DROP TABLE IF EXISTS `npc`;
CREATE TABLE `npc`(
  `id` decimal(11,0) NOT NULL default '0',
  `idTemplate` int(11) NOT NULL default '0',
  `name` varchar(200) default NULL,
  `serverSideName` int(1) default '0',
  `title` varchar(45) default '',
  `serverSideTitle` int(1) default '0',
  `class` varchar(200) default NULL,
  `collision_radius` decimal(5,2) default NULL,
  `collision_height` decimal(5,2) default NULL,
  `level` decimal(2,0) default NULL,
  `sex` varchar(6) default NULL,
  `type` varchar(22) default NULL,
  `attackrange` int(11) default NULL,
  `hp` decimal(8,0) default NULL,
  `mp` decimal(8,0) default NULL,
  `hpreg` decimal(8,2) default NULL,
  `mpreg` decimal(5,2) default NULL,
  `str` decimal(7,0) default NULL,
  `con` decimal(7,0) default NULL,
  `dex` decimal(7,0) default NULL,
  `int` decimal(7,0) default NULL,
  `wit` decimal(7,0) default NULL,
  `men` decimal(7,0) default NULL,
  `exp` decimal(9,0) default NULL,
  `sp` decimal(8,0) default NULL,
  `patk` decimal(5,0) default NULL,
  `pdef` decimal(5,0) default NULL,
  `matk` decimal(5,0) default NULL,
  `mdef` decimal(5,0) default NULL,
  `atkspd` decimal(3,0) default NULL,
  `aggro` decimal(6,0) default NULL,
  `matkspd` decimal(4,0) default NULL,
  `rhand` decimal(5,0) default NULL,
  `lhand` decimal(5,0) default NULL,
  `armor` decimal(1,0) default NULL,
  `enchant` int(11) NOT NULL default '0',
  `walkspd` decimal(3,0) default NULL,
  `runspd` decimal(3,0) default NULL,
  `isUndead` int(11) default 0,
  `absorb_level` decimal(2,0) default 0,
  `absorb_type` enum('FULL_PARTY','LAST_HIT','PARTY_ONE_RANDOM') DEFAULT 'LAST_HIT' NOT NULL,
  `drop_herbs` enum('true','false') DEFAULT 'false' NOT NULL,
  PRIMARY KEY (`id`)
) DEFAULT CHARSET=utf8;

INSERT INTO `npc` VALUES
(1,1,'Thomas D. Turkey',0,'Misguided Holiday Scrooge',0,'LineageMonster4.br_crazy_turkey',22.00,32.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,30,132,0,0,'LAST_HIT','false'),
(2,2,'',0,'',0,'LineageNPC.clear_npc',22.00,32.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,30,132,0,0,'LAST_HIT','false'),
(3,3,'Santa\'s Helper',0,'',0,'LineageNPC.e_smith_master_MDwarf',13.00,17.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,30,132,0,0,'LAST_HIT','false'),
(4,4,'Holiday Santa',0,'Happy Holidays!',0,'LineageNPC2.br_xmas08_santa',13.00,21.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,30,132,0,0,'LAST_HIT','false'),
(5,5,'Holiday Santa',0,'Happy Holidays!',0,'LineageNPC2.br_xmas08_santa',13.00,21.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,30,132,0,0,'LAST_HIT','false'),
(6,6,'Holiday Sled',0,'Happy Holidays!',0,'LineageNPC2.br_xmas08_sled',13.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,30,132,0,0,'LAST_HIT','false'),
(7,7,'Birthday Cake',0,'',0,'LineageNPC2.br_birthday_cake',0.01,5.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,30,132,0,0,'LAST_HIT','false'),
(8,8,'Spirit of Fire',0,'',0,'LineageMonster4.br_fire_elemental',16.00,22.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,30,132,0,0,'LAST_HIT','false'),
(9,9,'Explosive Spirit of Fire',0,'',0,'LineageMonster4.br_fire_elemental_of_fierce',26.00,35.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,30,132,0,0,'LAST_HIT','false'),
(10,10,'Jack Sage',0,'Eva\'s High Priest',0,'LineageNPC2.br_archbishop_of_eva',8.00,26.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,30,132,0,0,'LAST_HIT','false'),
(11,11,'Eva\'s Obelisk',0,'',0,'LineageNPC2.br_obelisk_of_eva',40.00,120.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,30,132,0,0,'LAST_HIT','false'),
(12,12,'',0,'',0,'LineageNPC.clear_npc',0.00,0.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,30,132,0,0,'LAST_HIT','false'),
(13,13,'Warm Hearted Sno',0,'Beginner Supporter',0,'LineageNPC2.br_tp_actor',9.00,29.29,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,30,132,0,0,'LAST_HIT','false'),
(14,14,'Warm Hearted Sno',0,'Beginner Supporter',0,'LineageNPC2.br_tp_actor',9.00,29.29,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,30,132,0,0,'LAST_HIT','false'),
(15,15,'Warm Hearted Sno',0,'Beginner Supporter',0,'LineageNPC2.br_tp_actor',9.00,29.29,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,30,132,0,0,'LAST_HIT','false'),
(16,16,'Warm Hearted Sno',0,'Beginner Supporter',0,'LineageNPC2.br_tp_actor',9.00,29.29,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,30,132,0,0,'LAST_HIT','false'),
(17,17,'Warm Hearted Sno',0,'Beginner Supporter',0,'LineageNPC2.br_tp_actor',9.00,29.29,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,30,132,0,0,'LAST_HIT','false'),
(18,18,'Warm Hearted Sno',0,'Beginner Supporter',0,'LineageNPC2.br_tp_actor',9.00,29.29,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,30,132,0,0,'LAST_HIT','false'),
(19,19,'Wooldy',0,'Halloween Children',0,'LineageMonster5.br_wooldie',15.00,25.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(20,20,'Verdandi',0,'Halloween Children',0,'LineageMonster5.br_berdandi',15.00,25.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(21,21,'Skooldy',0,'Jack Game Trainer',0,'LineageMonster5.br_scooldie',15.00,25.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22,22,'Lucky Sky Lantern',0,'',0,'LineageNPC2.br_lamp',15.00,25.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(23,23,'Ambience Sky Lantern',0,'',0,'LineageNPC2.br_lamp_a',15.00,25.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(24,24,'Sway Sky Lantern',0,'',0,'LineageNPC2.br_lamp_b',15.00,25.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(25,25,'Comfort Sky Lantern',0,'',0,'LineageNPC2.br_lamp_c',15.00,25.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(26,26,'Halloween Event Manager',0,'',0,'LineageNPC.clear_npc',15.00,25.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(27,27,'Kadomas',0,'',0,'LineageNPC2.br_kadomatsu',24.50,14.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(28,28,'Kotatz',0,'',0,'LineageNPC2.br_kotatsu',25.50,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(29,29,'Flame Box',0,'',0,'LineageNPC2.br_fire_box',11.00,12.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(30,30,'Santa',0,'',0,'LineageNPC2.br_xmas08_santa',9.00,16.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(31,31,'',0,'',0,'LineageNPC.clear_npc',15.00,25.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(1501,1501,'Majo Agathion',0,'',0,'LineageNPC2.br_agathion_mazu',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,24,125,0,0,'LAST_HIT','false'),
(1502,1502,'Gold Agathion',0,'',0,'LineageNPC2.br_agathion_mazu',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,24,125,0,0,'LAST_HIT','false'),
(1503,1503,'Black Agathion',0,'',0,'LineageNPC2.br_agathion_mazu',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,24,125,0,0,'LAST_HIT','false'),
(1504,1504,'Plaipitak Agathion',0,'',0,'LineageNPC2.br_agathion_elephant',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,24,125,0,0,'LAST_HIT','false'),
(1505,1505,'Baby Panda Agathion',0,'',0,'LineageNPC2.br_agathion_bpanda',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,24,125,0,0,'LAST_HIT','false'),
(1506,1506,'Bamboo Panda Agathion',0,'',0,'LineageNPC2.br_agathion_mpanda',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,24,125,0,0,'LAST_HIT','false'),
(1507,1507,'Sexy Panda Agathion',0,'',0,'LineageNPC2.br_agathion_wpanda',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,24,125,0,0,'LAST_HIT','false'),
(1508,1508,'White Cupid Agathion',0,'',0,'LineageNPC2.br_agathion_wcupid',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,24,125,0,0,'LAST_HIT','false'),
(1509,1509,'Dark Cupid Agathion',0,'',0,'LineageNPC2.br_agathion_dcupid',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,24,125,0,0,'LAST_HIT','false'),
(1510,1510,'White Maneki Neko Agathion',0,'',0,'LineageNPC2.br_agathion_maneki',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,24,125,0,0,'LAST_HIT','false'),
(1511,1511,'Black Maneki Neko Agathion',0,'',0,'LineageNPC2.br_agathion_maneki',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,24,125,0,0,'LAST_HIT','false'),
(1512,1512,'Brown Maneki Neko Agathion',0,'',0,'LineageNPC2.br_agathion_maneki',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,24,125,0,0,'LAST_HIT','false'),
(1513,1513,'One-Eyed Bat Drove Agathion',0,'',0,'LineageNPC2.br_agathion_bat',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,24,125,0,0,'LAST_HIT','false'),
(1514,1514,'Pegasus Agathion',0,'',0,'LineageNPC2.br_agathion_pegasus',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,24,125,0,0,'LAST_HIT','false'),
(1515,1515,'Yellow-Robed Tojigong Agathion',0,'',0,'LineageNPC2.br_agathion_tozi',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,24,125,0,0,'LAST_HIT','false'),
(1516,1516,'Blue-Robed Tojigong Agathion',0,'',0,'LineageNPC2.br_agathion_tozi',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,24,125,0,0,'LAST_HIT','false'),
(1517,1517,'Green-Robed Tojigong Agathion',0,'',0,'LineageNPC2.br_agathion_tozi',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,24,125,0,0,'LAST_HIT','false'),
(1518,1518,'Bugbear Agathion',0,'',0,'LineageNPC2.br_agathion_bugbear',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,24,125,0,0,'LAST_HIT','false'),
(1519,1519,'Red Sumo Wrestler Agathion',0,'',0,'LineageNPC2.br_agathion_redsumo',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,24,125,0,0,'LAST_HIT','false'),
(1520,1520,'Blue Sumo Wrestler Agathion',0,'',0,'LineageNPC2.br_agathion_bluesumo',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,24,125,0,0,'LAST_HIT','false'),
(1521,1521,'Great Sumo Match Agathion',0,'',0,'LineageNPC2.br_agathion_match',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,24,125,0,0,'LAST_HIT','false'),
(1522,1522,'Button-Eyed Bear Doll',0,'',0,'LineageNPC2.br_agathion_bear',13.00,11.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,3907,0,0,0,24,125,0,0,'LAST_HIT','false'),
(1523,1523,'God of Fortune',0,'',0,'LineageNPC2.br_agathion_wealthgod',13.00,11.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,3907,0,0,0,24,125,0,0,'LAST_HIT','false'),
(1524,1524,'Dryad Agathion',0,'',0,'LineageNPC2.br_agathion_dryad',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,24,125,0,0,'LAST_HIT','false'),
(1525,1525,'Wonboso Agathion',0,'',0,'LineageNPC2.br_agathion_cashcow',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,24,125,0,0,'LAST_HIT','false'),
(1526,1526,'Daewoonso Agathion',0,'',0,'LineageNPC2.br_agathion_luckycow',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,24,125,0,0,'LAST_HIT','false'),
(1527,1527,'Pomona Agathion',0,'',0,'LineageNPC2.br_agathion_pomona',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,30,132,0,0,'LAST_HIT','false'),
(1528,1528,'Weaver Agathion',0,'',0,'LineageNPC2.br_agathion_womanweaver',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,30,132,0,0,'LAST_HIT','false'),
(1529,1529,'Chon-chon Agathion',0,'',0,'LineageNPC2.br_agathion_luckygirl',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(1530,1530,'Tang-tang Agathion',0,'',0,'LineageNPC2.br_agathion_luckyboy',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(1531,1531,'Dancing Lucky Kid Agathion',0,'',0,'LineageNPC2.br_agathion_dancingchild',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(1532,1532,'Monkey King Agathion',0,'',0,'LineageNPC2.br_agathion_sunwukong',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(1533,1533,'Utanka Agathion',0,'',0,'LineageNPC2.br_agathion_uthanka',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(1534,1534,'Bonus B Agathion',0,'',0,'LineageNPC2.br_agathion_bonus',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(1535,1535,'Zombie Agathion',0,'',0,'LineageNPC2.br_agathion_gangsi',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(1536,1536,'Baekyi Hwamae Agathion',0,'',0,'LineageNPC2.br_agathion_bluebird',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(1537,1537,'Gwanwoo Hwamae Agathion',0,'',0,'LineageNPC2.br_agathion_hatbird',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(1538,1538,'Baby Rudolph',0,'',0,'LineageNPC2.br_pet_rudolf',21.50,37.00,70,'male','L2Pet',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(1539,1539,'Iken Agathion',0,'',0,'LineageNPC2.br_local_JP_Mfighter',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(1540,1540,'Lana Agathion',0,'',0,'LineageNPC2.br_local_JP_FFighter',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(1541,1541,'Gnocian Agathion',0,'',0,'LineageNPC2.br_local_JP_MElf',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(1542,1542,'Orodriel Agathion',0,'',0,'LineageNPC2.br_local_JP_Felf',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(1543,1543,'Lakinos Agathion',0,'',0,'LineageNPC2.br_local_JP_MDarkelf',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(1544,1544,'Mortia Agathion',0,'',0,'LineageNPC2.br_local_JP_Fdarkelf',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(1545,1545,'Hayance Agathion',0,'',0,'LineageNPC2.br_local_JP_MDwarf',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(1546,1546,'Meruril Agathion',0,'',0,'LineageNPC2.br_local_JP_FDwarf',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(1547,1547,'Taman ze Lapatui Agathion',0,'',0,'LineageNPC2.br_local_JP_MOrc',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(1548,1548,'Kaurin Agathion',0,'',0,'LineageNPC2.br_local_JP_FOrc',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(1549,1549,'Ahertbein Agathion',0,'',0,'LineageNPC2.br_local_JP_MKamael',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(1550,1550,'Naonin Agathion',0,'',0,'LineageNPC2.br_local_JP_FKamael',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(1551,1551,'Guangong Agathion',0,'',0,'LineageNPC2.br_aga_warriorgod',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(1552,1552,'Gwanseum Nyang Nyang Agathion',0,'',0,'LineageNPC2.br_aga_mercygod',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(1553,1553,'Blue Opera Agathion',0,'',0,'LineageNPC2.br_aga_blue_pekingopera',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(1554,1554,'Red Opera Agathion',0,'',0,'LineageNPC2.br_aga_red_pekingopera',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(1555,1555,'Opera Agathion',0,'',0,'LineageNPC2.br_aga_redblue_pekingopera',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(1556,1556,'Mandarin Dress Agathion',0,'',0,'LineageNPC2.br_aga_chinesedress',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(1557,1557,'Nepal Snow Agathion',0,'',0,'LineageNPC2.br_aga_suno_trumpet',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(1558,1558,'Round Ball Snow Agathion',0,'',0,'LineageNPC2.br_aga_suno_ball',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(1559,1559,'Ladder Snow Agathion',0,'',0,'LineageNPC2.br_aga_suno_tall',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(1560,1560,'Blue Opera Agathion',0,'',0,'LineageNPC2.br_aga_blue_pekingopera',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(1561,1561,'Baby Rudolph',0,'',0,'LineageNPC2.br_pet_rudolf',21.50,27.00,70,'male','L2Pet',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(4301,4301,'Queen of Hearts',0,'Valentine Messenger',0,'LineageMonster2.queen_of_cat',8.00,15.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,24,125,0,0,'LAST_HIT','false'),
(4302,4302,'Master Dugi',0,'Soul Healer',0,'LineageNPC2.event_comic_masteryogy',9.00,16.70,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,30,132,0,0,'LAST_HIT','false'),
(4303,4303,'Skooldy',0,'Halloween Children',0,'LineageMonster5.br_scooldie',15.00,25.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(4304,4304,'Santa',0,'Merry Christmas',0,'LineageNPC2.br_xmas08_santa',9.00,16.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false');

INSERT INTO `npc` VALUES
(12077,12077,'Wolf',0,'',0,'LineageMonster.pet_wolf',13.00,11.50,15,'male','L2Pet',40,195,164,3.95,1.21,40,43,30,21,20,25,0,0,9,19,3,17,304,0,333,3907,0,0,0,24,125,0,0,'LAST_HIT','false'),
(12311,12311,'Hatchling of the Wind',0,'',0,'LineageMonster.hatchling',9.00,10.00,35,'male','L2Pet',40,610,433,7.11,1.84,40,43,30,21,20,25,0,0,48,42,22,39,278,0,333,0,0,0,0,80,140,0,0,'LAST_HIT','false'),
(12312,12312,'Hatchling of the Stars',0,'',0,'LineageMonster.hatchling',9.00,10.00,35,'male','L2Pet',40,610,433,7.11,1.84,40,43,30,21,20,25,0,0,48,42,22,39,278,0,333,0,0,0,0,80,140,0,0,'LAST_HIT','false'),
(12313,12313,'Hatchling of Twilight',0,'',0,'LineageMonster.hatchling',9.00,10.00,35,'male','L2Pet',40,610,433,7.11,1.84,40,43,30,21,20,25,0,0,48,42,22,39,282,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(12526,12526,'Wind Strider',0,'',0,'LineageMonster.strider',23.00,31.00,55,'male','L2Pet',40,2728,1138,10.27,2.45,40,43,30,21,20,25,0,0,703,332,360,301,304,0,333,5178,0,0,0,80,170,0,0,'LAST_HIT','false'),
(12527,12527,'Star Strider',0,'',0,'LineageMonster.strider',23.00,31.00,55,'male','L2Pet',40,2728,1138,10.27,2.45,40,43,30,21,20,25,0,0,703,332,360,301,282,0,333,0,0,0,0,88,187,0,0,'LAST_HIT','false'),
(12528,12528,'Twilight Strider',0,'',0,'LineageMonster.strider',23.00,31.00,55,'male','L2Pet',40,2728,1138,10.27,2.45,40,43,30,21,20,25,0,0,703,332,360,301,278,0,333,0,0,0,0,80,170,0,0,'LAST_HIT','false'),
(12564,12564,'Sin Eater',0,'',0,'LineageMonster.imp',10.00,24.00,15,'male','L2Pet',40,195,164,1.15,1.21,40,1,30,21,20,25,0,0,9,19,3,17,278,0,333,0,0,0,0,60,125,0,0,'LAST_HIT','false'),
(12621,12621,'Wyvern',0,'',0,'LineageMonster.wyvern',60.00,80.00,70,'male','L2Pet',40,3862,1722,11.85,2.78,40,43,30,21,20,25,0,0,1335,470,780,440,282,0,333,0,0,0,0,88,187,0,0,'LAST_HIT','false'),
(12774,12774,'Young Squash',0,'',0,'LineageNPC.drop_gourd_50_sm',10.00,10.50,70,'etc','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,0,0,1,0,'LAST_HIT','false'),
(12775,12775,'High Quality Squash',0,'',0,'LineageNPC.drop_gourd',23.00,25.00,70,'etc','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,0,0,1,0,'LAST_HIT','false'),
(12776,12776,'Low Quality Squash',0,'',0,'LineageNPC.drop_gourd_25_sm',15.00,16.00,70,'etc','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,0,0,1,0,'LAST_HIT','false'),
(12777,12777,'Large Young Squash',0,'',0,'LineageNPC.drop_gourd',23.00,25.00,70,'etc','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,0,0,1,0,'LAST_HIT','false'),
(12778,12778,'High Quality Large Squash',0,'',0,'LineageNPC.drop_gourd_50_bi',34.00,40.00,70,'etc','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,0,0,1,0,'LAST_HIT','false'),
(12779,12779,'Low Quality Large Squash',0,'',0,'LineageNPC.drop_gourd_25_bi',28.00,31.00,70,'etc','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,0,0,1,0,'LAST_HIT','false'),
(12780,12780,'Baby Buffalo',0,'',0,'LineageMonster2.baby_buffalo',12.00,15.00,25,'male','L2BabyPet',40,751,331,2.37,1.53,40,43,30,21,20,25,0,0,88,119,37,112,282,0,333,0,0,0,0,33,132,0,0,'LAST_HIT','false'),
(12781,12781,'Baby Kookaburra',0,'',0,'LineageMonster2.baby_ostrich',7.00,15.00,25,'male','L2BabyPet',40,751,331,2.37,1.53,40,43,30,21,20,25,0,0,88,119,37,112,282,0,333,0,0,0,0,14,132,0,0,'LAST_HIT','false'),
(12782,12782,'Baby Cougar',0,'',0,'LineageMonster2.baby_tiger',11.00,15.70,25,'male','L2BabyPet',40,751,331,2.37,1.53,40,43,30,21,20,25,0,0,88,119,37,112,278,0,333,0,0,0,0,28,120,0,0,'LAST_HIT','false'),
(13001,13001,'Heart of Warding',0,'',0,'LineageNPC.heart_of_warding',17.00,75.00,70,'etc','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,55,132,1,0,'LAST_HIT','false'),
(13002,13002,'Life Control Tower',0,'',0,'LineageNPC.broadcasting_tower',13.00,54.00,20,'etc','L2ControlTower',40,10000,213,3.95,1.21,40,43,30,21,20,10,40,10,57,94,23,76,282,0,333,0,0,0,0,55,0,1,0,'LAST_HIT','false'),
(13003,13003,'Life Control Tower',0,'',0,'LineageNPC.dead_castle_aden_controltower_jewel',7.00,35.00,20,'etc','L2ControlTower',40,10000,213,3.95,1.21,40,43,30,21,20,10,40,10,57,94,23,76,282,0,333,0,0,0,0,55,0,1,0,'LAST_HIT','false'),
(13004,13004,'Flame Control Tower',0,'',0,'LineageNPC.broadcasting_tower',13.00,54.00,20,'etc','L2FlameTower',40,10000,213,3.95,1.21,40,43,30,21,20,10,40,10,57,94,23,76,282,0,333,0,0,0,0,55,0,1,0,'LAST_HIT','false'),
(13005,13005,'Flame Control Tower',0,'',0,'LineageNPC.dead_castle_aden_controltower_jewel',7.00,35.00,20,'etc','L2FlameTower',40,10000,213,3.95,1.21,40,43,30,21,20,10,40,10,57,94,23,76,282,0,333,0,0,0,0,55,0,1,0,'LAST_HIT','false'),
(13006,13006,'Christmas Tree',0,'',0,'LineageDeco.x_mas_tree',0.01,0.01,70,'etc','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,30,120,0,0,'LAST_HIT','false'),
(13007,13007,'Special Christmas Tree',0,'',0,'LineageDeco.x_mas_tree_50_bi',0.00,0.00,70,'etc','L2XmassTree',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,33,132,0,0,'LAST_HIT','false'),
(13014,13014,'',0,'',0,'LineageNPC.clear_npc',0.10,0.10,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(13015,13015,'',0,'',0,'LineageMonster3.Evilate_weather',0.10,0.10,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(13016,13016,'King Squash',0,'',0,'LineageNPC.drop_gourd',23.00,25.00,70,'etc','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,0,0,0,0,'LAST_HIT','false'),
(13017,13017,'Emperor Squash',0,'',0,'LineageNPC.drop_gourd_50_bi',34.00,40.00,70,'etc','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,0,0,0,0,'LAST_HIT','false'),
(13018,13018,'',0,'',0,'LineageNPC2.skill_dummy_00_a',5.00,10.00,70,'male','L2EffectPoint',40,3862,1493,11.85,2.78,40,43,30,21,20,10,0,0,1314,470,780,382,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(13019,13019,'',0,'',0,'LineageNPC2.skill_dummy_00_a',5.00,10.00,70,'male','L2EffectPoint',40,3862,1493,11.85,2.78,40,43,30,21,20,10,0,0,1314,470,780,382,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(13020,13020,'',0,'',0,'LineageNPC2.skill_dummy_00_a',5.00,10.00,70,'male','L2EffectPoint',40,3862,1493,11.85,2.78,40,43,30,21,20,10,0,0,1314,470,780,382,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(13021,13021,'',0,'',0,'LineageNPC2.skill_dummy_00_a',5.00,10.00,70,'male','L2EffectPoint',40,3862,1493,11.85,2.78,40,43,30,21,20,10,0,0,1314,470,780,382,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(13022,13022,'',0,'',0,'LineageNPC2.skill_dummy_00_a',5.00,10.00,70,'male','L2EffectPoint',40,3862,1493,11.85,2.78,40,43,30,21,20,10,0,0,1314,470,780,382,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(13023,13023,'',0,'',0,'LineageNPC2.skill_dummy_00_a',5.00,10.00,70,'male','L2EffectPoint',40,3862,1493,11.85,2.78,40,43,30,21,20,10,0,0,1314,470,780,382,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(13024,13024,'',0,'',0,'LineageNPC2.skill_dummy_00_a',5.00,10.00,70,'male','L2EffectPoint',40,3862,1493,11.85,2.78,40,43,30,21,20,10,0,0,1314,470,780,382,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(13025,13025,'',0,'',0,'LineageNPC2.skill_dummy_01_a',5.00,10.00,70,'male','L2EffectPoint',40,3862,1493,11.85,2.78,40,43,30,21,20,10,0,0,1314,470,780,382,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(13026,13026,'',0,'',0,'LineageNPC2.skill_dummy_01_a',5.00,10.00,70,'male','L2EffectPoint',40,3862,1493,11.85,2.78,40,43,30,21,20,10,0,0,1314,470,780,382,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(13027,13027,'',0,'',0,'LineageNPC2.skill_dummy_01_a',5.00,10.00,70,'male','L2EffectPoint',40,3862,1493,11.85,2.78,40,43,30,21,20,10,0,0,1314,470,780,382,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(13028,13028,'',0,'',0,'LineageNPC2.skill_dummy_01_a',5.00,10.00,70,'male','L2EffectPoint',40,3862,1493,11.85,2.78,40,43,30,21,20,10,0,0,1314,470,780,382,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(13029,13029,'',0,'',0,'LineageNPC2.skill_dummy_01_a',5.00,10.00,70,'male','L2EffectPoint',40,3862,1493,11.85,2.78,40,43,30,21,20,10,0,0,1314,470,780,382,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(13030,13030,'',0,'',0,'LineageNPC2.skill_dummy_01_a',5.00,10.00,70,'male','L2EffectPoint',40,3862,1493,11.85,2.78,40,43,30,21,20,10,0,0,1314,470,780,382,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(13031,13031,'Huge Pig',0,'',0,'LineageNPC2.E_pig_ball',15.00,18.30,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(13032,13032,'Huge Pig',0,'',0,'LineageNPC2.E_pig_ball',15.00,18.30,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(13033,13033,'Huge Pig',0,'',0,'LineageNPC2.E_pig_ball',15.00,18.30,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(13034,13034,'Super Huge Pig',0,'',0,'LineageNPC2.E_pig_ball_H',29.00,38.70,80,'male','L2Monster',40,5372,1493,11.85,2.78,40,43,30,21,20,10,0,0,1314,470,780,382,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(13035,13035,'Golden Pig',0,'',0,'LineageNPC2.E_pig_ball',15.00,18.30,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(13036,13036,'Alchemist\'s Chest',0,'',0,'LineageMonster.mimic_even',8.50,8.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(13037,13037,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,50,1,0,0,'LAST_HIT','false'),
(13038,13038,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,0,0,0,0,'LAST_HIT','false'),
(13039,13039,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,0,0,0,0,'LAST_HIT','false'),
(13040,13040,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,0,0,0,0,'LAST_HIT','false'),
(13041,13041,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,0,0,0,0,'LAST_HIT','false'),
(13042,13042,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,0,0,0,0,'LAST_HIT','false'),
(13043,13043,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,0,0,0,0,'LAST_HIT','false'),
(13044,13044,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,0,0,0,0,'LAST_HIT','false'),
(13045,13045,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,0,0,0,0,'LAST_HIT','false'),
(13046,13046,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,0,0,0,0,'LAST_HIT','false'),
(13047,13047,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,0,0,0,0,'LAST_HIT','false'),
(13048,13048,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,0,0,0,0,'LAST_HIT','false'),
(13049,13049,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,0,0,0,0,'LAST_HIT','false'),
(13050,13050,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,0,0,0,0,'LAST_HIT','false'),
(13051,13051,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,0,0,0,0,'LAST_HIT','false'),
(13052,13052,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,0,0,0,0,'LAST_HIT','false'),
(13053,13053,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,0,0,0,0,'LAST_HIT','false'),
(13054,13054,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,0,0,0,0,'LAST_HIT','false'),
(13055,13055,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,0,0,0,0,'LAST_HIT','false'),
(13056,13056,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,0,0,0,0,'LAST_HIT','false'),
(13057,13057,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,0,0,0,0,'LAST_HIT','false'),
(13058,13058,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,0,0,0,0,'LAST_HIT','false'),
(13059,13059,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,0,0,0,0,'LAST_HIT','false'),
(13060,13060,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,0,0,0,0,'LAST_HIT','false'),
(13061,13061,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,0,0,0,0,'LAST_HIT','false'),
(13062,13062,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,0,0,0,0,'LAST_HIT','false'),
(13063,13063,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,0,0,0,0,'LAST_HIT','false'),
(13064,13064,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,0,0,0,0,'LAST_HIT','false'),
(13065,13065,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,0,0,0,0,'LAST_HIT','false'),
(13066,13066,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,0,0,0,0,'LAST_HIT','false'),
(13067,13067,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,0,0,0,0,'LAST_HIT','false'),
(13068,13068,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,0,0,0,0,'LAST_HIT','false'),
(13069,13069,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,0,0,0,0,'LAST_HIT','false'),
(13070,13070,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,0,0,0,0,'LAST_HIT','false'),
(13071,13071,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium',8.50,25.00,43,'female','L2Decoy',40,1728,618,8.69,2.14,40,43,30,21,20,10,0,0,291,252,163,181,278,0,333,0,0,0,0,0,0,0,0,'LAST_HIT','false'),
(13072,13072,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium',8.50,25.00,52,'female','L2Decoy',40,2402,892,10.27,2.45,40,43,30,21,20,10,0,0,518,324,300,239,278,0,333,0,0,0,0,0,0,0,0,'LAST_HIT','false'),
(13073,13073,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium',8.50,25.00,60,'female','L2Decoy',40,3054,1150,10.27,2.45,40,43,30,21,20,10,0,0,860,368,478,299,278,0,333,0,0,0,0,0,0,0,0,'LAST_HIT','false'),
(13074,13074,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium',8.50,25.00,66,'female','L2Decoy',40,3546,1353,47.40,2.78,40,43,30,21,20,10,0,0,1020,427,649,348,278,0,333,0,0,0,0,0,0,0,0,'LAST_HIT','false'),
(13075,13075,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium',8.50,25.00,70,'female','L2Decoy',40,3862,1493,59.25,2.78,40,43,30,21,20,10,0,0,1445,466,780,382,278,0,333,0,0,0,0,0,0,0,0,'LAST_HIT','false'),
(13076,13076,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium',8.50,25.00,74,'female','L2Decoy',40,4158,1637,53.72,3.09,40,43,30,21,20,10,0,0,2312,481,921,416,278,0,333,0,0,0,0,50,1,0,0,'LAST_HIT','false'),
(13077,13077,'Onyx Beast',0,'',0,'LineageMonster.onyx_beast',14.00,14.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(13078,13078,'Doom Wraith',0,'',0,'LineageMonster.death_blader_tr',13.00,25.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,1472,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(13079,13079,'Grail Apostle',0,'',0,'LineageMonster3.apostle_grail_tr',10.00,35.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,8221,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(13080,13080,'Grail Apostle',0,'',0,'LineageMonster2.apostle_warrior',8.00,30.00,70,'female','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,8221,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(13081,13081,'Unicorn',0,'',0,'LineageMonster.Unicorn_tr',15.00,28.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(13082,13082,'Lilim Knight',0,'',0,'LineageMonster4.lilim_knight_tr',12.00,25.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(13083,13083,'Golem Guardian',0,'',0,'LineageMonster3.golem_guardian_tr',13.00,25.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(13084,13084,'Inferno Drake',0,'',0,'LineageMonster2.inferno_drake_tr',15.00,24.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(13085,13085,'Dragon Bomber',0,'',0,'LineageMonster3.antaras_ex_b_tr',16.00,24.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(13086,13086,'Zariche',0,'',0,'LineageMonster4.Avatar_Z',12.00,31.58,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,8190,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(13087,13087,'Akamanah',0,'',0,'LineageMonster4.Avatar_A',10.00,33.73,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,8689,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(13088,13088,'Final Form',0,'',0,'LineageMonster4.Specular_Form',9.00,38.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(13089,13089,'Final Form',0,'',0,'LineageMonster4.Specular_Form_F',10.00,32.76,70,'female','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(13090,13090,'Native',0,'',0,'LineageNPC.a_common_peopleC_Mhuman',8.00,23.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(13091,13091,'Yeti',0,'',0,'LineageMonster.yeti',15.00,27.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(13092,13092,'Buffalo',0,'',0,'LineageMonster2.buffalo',22.00,31.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(13093,13093,'Pig',0,'',0,'LineageNPC2.E_pig_ball',15.00,18.30,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(13094,13094,'Zombie',0,'',0,'LineageMonster3.zombie_laborer',11.00,24.60,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(13095,13095,'Pixy',0,'',0,'LineageMonster.pixy',5.00,25.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13096,13096,'Rabbit',0,'',0,'LineageMonster.rabbit',5.00,4.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13097,13097,'',0,'',0,'LineageNPC.clear_npc',0.00,0.00,80,'male','L2Monster',40,4550,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13098,13098,'Event Treasure Chest',0,'',0,'LineageMonster.mimic_even',8.50,8.50,80,'male','L2Monster',40,4550,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,0,0,0,0,'LAST_HIT','false'),
(13099,13099,'Zaken',0,'',0,'LineageMonster.zaken_tr',16.00,32.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13100,13100,'Anakim',0,'',0,'LineageMonster2.anakim_tr',15.50,29.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13101,13101,'Benom',0,'',0,'LineageMonster3.benom_tr',20.00,56.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,8203,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13102,13102,'Gordon',0,'',0,'LineageMonster3.Cruel_Rider_tr',43.00,46.60,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13103,13103,'Ranku',0,'',0,'LineageMonster4.LaneCoo_tr',13.00,29.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13104,13104,'Kiyachi',0,'',0,'LineageMonster4.Keyache_tr',12.00,29.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13105,13105,'Demon Prince',0,'',0,'LineageMonster4.rahuu_tr',33.00,49.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13106,13106,'Heretic Male',0,'',0,'LineageMonster3.heretic_privates_tr',7.70,28.40,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,8205,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13107,13107,'Heretic Female',0,'',0,'LineageMonster3.heretic_priest_tr',8.00,19.60,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,8208,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13108,13108,'Vale master',0,'',0,'LineageMonster.vale_master_tr',12.00,40.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13109,13109,'Saber Tooth Tiger',0,'',0,'LineageMonster.saber_toothed_tiger_tr',34.00,28.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13110,13110,'Ol Mahum',0,'',0,'LineageMonster.oel_mahum_champion_tr',23.00,61.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13111,13111,'Doll Blader',0,'',0,'LineageMonster.doll_blader_tr',6.00,12.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,5129,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13112,13112,'Divine Knight',0,'',0,'LineageMonster4.Divine_tanker',16.00,30.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13113,13113,'Divine Warrior',0,'',0,'LineageMonster4.Divine_Warrior',14.50,29.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13114,13114,'Divine Rogue',0,'',0,'LineageMonster4.Divine_Rogue',10.00,28.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13115,13115,'Divine Healer',0,'',0,'LineageMonster4.Divine_healer',10.00,25.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13116,13116,'Divine Wizard',0,'',0,'LineageMonster4.Divine_Wizard',10.00,26.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13117,13117,'Divine Enchanter',0,'',0,'LineageMonster4.Divine_enchanter',8.00,18.25,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13118,13118,'Divine Summoner',0,'',0,'LineageMonster4.Divine_healer',10.00,25.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13119,13119,'Dwarf Golem',0,'',0,'LineageMonster3.chaos_golem_tr',31.00,51.80,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13120,13120,'Giant rat',0,'',0,'LineageMonster4.little_mouse_120p',15.00,20.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13121,13121,'Giant rat',0,'',0,'LineageMonster4.little_mouse_120p',15.00,20.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13122,13122,'Giant rat',0,'',0,'LineageMonster4.little_mouse_120p',15.00,20.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13123,13123,'Super giant rat',0,'',0,'LineageMonster4.little_mouse_180p',19.00,33.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13124,13124,'Giant rat',0,'Mr. Bashful',0,'LineageMonster4.little_mouse_120p',15.00,20.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13125,13125,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13126,13126,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13127,13127,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13128,13128,'Golem Trader',0,'',0,'LineageNPC.e_teleporter_FDwarf',8.00,21.30,70,'male','L2MerchantSummon',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13129,13129,'Teleporter',0,'',0,'LineageNPC.a_teleporter_FHuman',8.00,25.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13130,13130,'Light Purple Maned Horse',0,'',0,'LineageMonster4.gray_horse',31.00,32.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13131,13131,'Grizzly Bear',0,'',0,'LineageMonster.grizzly',21.00,40.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13132,13132,'Timitran',0,'',0,'LineageMonster.ti_mi_tran',23.00,90.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13133,13133,'Lava Golem',0,'',0,'LineageMonster2.lava_golem',22.00,45.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13134,13134,'Yeti',0,'',0,'LineageMonster.yeti_20_bi',18.00,32.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13135,13135,'Pumpkin Ghost',0,'',0,'LineageNpc2.Pumpkin_Head_man',12.00,18.00,70,'etc','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,50,120,1,0,'LAST_HIT','false'),
(13136,13136,'',0,'',0,'LineageNpcEV.battle_banner',12.00,32.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13137,13137,'',0,'',0,'LineageNpcEV.battle_banner',12.00,32.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13138,13138,'',0,'',0,'LineageNpcEV.battle_banner',12.00,32.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13139,13139,'',0,'',0,'LineageNpcEV.battle_banner',12.00,32.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13140,13140,'',0,'',0,'LineageNpcEV.battle_banner',12.00,32.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13141,13141,'',0,'',0,'LineageNpcEV.battle_banner',12.00,32.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13142,13142,'Final Form',0,'',0,'LineageMonster4.Specular_Form_air',9.00,38.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13143,13143,'Final Form',0,'',0,'LineageMonster4.Specular_Form_F_air',10.00,32.76,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13144,13144,'Aurabird-Falcon',0,'',0,'LineageMonster4.closed_attacker',38.00,14.25,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13145,13145,'Aurabird-Owl',0,'',0,'LineageMonster4.heavy_shooter',40.00,18.57,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13146,13146,'Tawny-Maned Lion',0,'',0,'LineageMonster4.tawny_maned_lion',25.00,22.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13147,13147,'Steam Sledge',0,'',0,'LineageMonster4.steam_sledge',40.00,27.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13148,13148,'Lindvior',0,'',0,'LineageMonster4.lindvior_air',190.00,390.60,55,'female','L2FlyMonster',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13149,13149,'For Presentation 1',0,'',0,'LineageNPC.clear_npc',12.00,32.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13150,13150,'For Presentation 2',0,'',0,'LineageNPC.clear_npc',12.00,32.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13151,13151,'For Presentation 3',0,'',0,'LineageNPC.clear_npc',12.00,32.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13152,13152,'For Presentation 4',0,'',0,'LineageNPC.clear_npc',12.00,32.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13153,13153,'For Presentation 5',0,'',0,'LineageNPC.clear_npc',12.00,32.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13154,13154,'Demon Race',0,'',0,'LineageMonster4.summoner_demon_tr',11.00,27.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13155,13155,'Unicorniun',0,'',0,'LineageMonster4.summoner_unicorn_tr',8.00,30.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13156,13156,'Myo Race',0,'',0,'LineageMonster4.summoner_cat_tr',10.00,23.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13157,13157,'Frog',0,'',0,'LineageMonster.poison_toad',20.00,9.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13158,13158,'Young Child',0,'',0,'LineageNPC2.a_child_people_Mhuman',5.00,12.30,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13159,13159,'Mercenary',0,'',0,'LineageNPC.a_fighterguild_master_Mhuman',8.00,23.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13160,13160,'Snowman',0,'',0,'LineageNpc2.snow_man',28.00,30.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13161,13161,'Scarecrow',0,'',0,'LineageNpc2.scarecrow',13.00,30.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13162,13162,'Tin Plate Golem',0,'',0,'LineageNpc2.tin_golem',13.00,18.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13163,13163,'Tow',0,'',0,'LineageNPC2.tow',4.40,8.25,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13164,13164,'Lure Tow',0,'',0,'LineageNPC2.tow_lure',4.40,8.25,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13165,13165,'Heavy Tow',0,'',0,'LineageNPC2.tow_heavy',4.40,8.25,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13166,13166,'Wing Tow',0,'',0,'LineageNPC2.tow_whim',4.40,8.25,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13167,13167,'Main Role A',0,'',0,'LineageNPC2.tp_actor',9.00,28.30,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13168,13168,'Main Role B',0,'',0,'LineageNPC2.tp_actor',9.00,28.30,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13169,13169,'Human Male Mercenary',0,'',0,'LineageNPC.a_guard_MHuman',8.00,24.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13170,13170,'Male Elf Mercenary',0,'',0,'LineageNPC.a_guard_MElf',8.00,23.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13171,13171,'Dark Elf Female Mercenary',0,'',0,'LineageNPC.a_guard_FDarkelf',8.00,25.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13172,13172,'Orc Male Mercenary',0,'',0,'LineageNPC.e_guard_MOrc',8.00,27.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13173,13173,'Dwarf Male Mercenary',0,'',0,'LineageNPC.e_guard_MDwarf',8.00,19.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13174,13174,'Kamael Male Mercenary',0,'',0,'LineageNPC2.K_M1_guard',13.00,25.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13175,13175,'Knight Level Mercenary',0,'',0,'LineageNPC.a_royal_guardA_MHuman',8.00,24.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13176,13176,'Archer Level Mercenary',0,'',0,'LineageNPC2.archer_of_insurgents',10.00,23.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13177,13177,'Wizard Level Mercenary',0,'',0,'LineageNPC2.mage_of_insurgents',9.00,23.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13178,13178,'Trooper Level Mercenary',0,'',0,'LineageNPC2.K_F1_guard_Master',13.00,22.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13179,13179,'Knight Leader Elite Mercenary',0,'',0,'LineageMonster3.Kight_of_Dawn',12.00,24.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13180,13180,'Commander Elite Mercenary',0,'',0,'LineageNPC2.chief_of_insurgents',10.00,26.99,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13181,13181,'Treasure Box',0,'Gracia',0,'LineageMonster.mimic_even',8.50,8.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13182,13182,'Free Gift Merchant',0,'Gracia',0,'LineageMonster.silver_cat',7.00,15.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13183,13183,'Thomas D. Turkey',0,'',0,'LineageNpc2.crazy_turkey',12.00,32.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13184,13184,'Santa Claus',0,'',0,'LineageNPC2.santa_claus',10.00,21.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13185,13185,'Santa Claus',0,'',0,'LineageNPC2.santa_claus_120p',10.00,21.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13186,13186,'Santa Claus',0,'',0,'LineageNPC2.santa_sled',0.01,50.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13187,13187,'Milk Cow',0,'',0,'LineageMonster4.milk_cow',16.00,12.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13188,13188,'Head Milk Cow',0,'',0,'LineageMonster4.milk_cow_200p',26.00,28.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13189,13189,'Bull',0,'',0,'LineageMonster4.yellow_cow',16.00,12.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13190,13190,'Head Bull',0,'',0,'LineageMonster4.yellow_cow_200p',26.00,28.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13191,13191,'Gloomy Milk Cow',0,'',0,'LineageMonster4.milk_cow_e',16.00,12.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13192,13192,'Gloomy Head Milk Cow',0,'',0,'LineageMonster4.milk_cow_200p_e',26.00,28.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13193,13193,'',0,'',0,'LineageNpcEV.obelisk_of_middle_square',229.00,177.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,1,180,0,0,'LAST_HIT','false'),
(13194,13194,'',0,'',0,'LineageNPC.clear_npc',12.00,32.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13195,13195,'',0,'',0,'LineageNPC.clear_npc',12.00,32.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13196,13196,'Great Pig',0,'Mis-summoned',0,'LineageNPC2.E_pig_ball',15.00,18.30,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(13197,13197,'Guardian\'s Strider',0,'',0,'LineageNPC.training_doll_150p',13.00,40.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13198,13198,'Native',0,'',0,'LineageNPC.a_common_peopleC_Mhuman',8.00,23.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13199,13199,'Native',0,'',0,'LineageNPC.a_common_peopleB_FHuman',8.00,20.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13200,13200,'Young Child',0,'',0,'LineageNPC2.a_child_people_Fhuman',5.00,12.30,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13201,13201,'Guards of the Dawn',0,'',0,'LineageNPC.a_fighterguild_master_FHuman',8.00,21.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13202,13202,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13203,13203,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13204,13204,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13205,13205,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13206,13206,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13207,13207,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13208,13208,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13209,13209,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13210,13210,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13211,13211,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13212,13212,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13213,13213,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13214,13214,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13215,13215,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13216,13216,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13217,13217,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13218,13218,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13219,13229,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13220,13220,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13221,13221,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13222,13222,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13223,13223,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13224,13224,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13225,13225,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13226,13226,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13227,13227,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13228,13228,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13229,13229,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13230,13230,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13231,13231,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13232,13232,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13233,13233,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13234,13234,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13235,13235,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13236,13236,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13237,13237,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13238,13238,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13239,13239,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13240,13240,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13241,13241,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13242,13242,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13243,13243,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13244,13244,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13245,13245,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13246,13246,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13247,13247,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13248,13248,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13249,13249,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13250,13250,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13251,13251,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13252,13252,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13253,13253,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13254,13254,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13255,13255,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13256,13256,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13257,13257,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium',8.50,25.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13258,13258,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium',8.50,25.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13259,13259,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium',8.50,25.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13260,13260,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium',8.50,25.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13261,13261,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium',8.50,25.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13262,13262,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium',8.50,25.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13263,13263,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium',8.50,25.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13264,13264,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium',8.50,25.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13265,13265,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium',8.50,25.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13266,13266,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium',8.50,25.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13267,13267,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium',8.50,25.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13268,13268,'Aqua Elf',0,'',0,'LineageNPC2.bikini_elf',12.00,27.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13269,13269,'Hot Weather',0,'',0,'LineageMonster5.event_the_heat',9.00,14.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13270,13270,'Sultriness',0,'',0,'LineageMonster5.event_terrible_heat',30.00,53.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(13271,13271,'Young Watermelon',0,'',0,'LineageNPC2.event_unripe_watermelon',11.00,22.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(13272,13272,'Defective Watermelon',0,'',0,'LineageNPC2.event_bad_watermelon',14.00,30.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(13273,13273,'Rain Watermelon',0,'',0,'LineageNPC2.event_good_watermelon',17.00,35.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(13274,13274,'Large Rain Watermelon',0,'',0,'LineageNPC2.event_king_watermelon',30.00,65.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(13275,13275,'Young Honey Watermelon',0,'',0,'LineageNPC2.event_big_watermelon',10.00,20.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(13276,13276,'Defective Honey Watermelon',0,'',0,'LineageNPC2.event_bad_big_watermelon',20.00,40.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(13277,13277,'Rain Honey Watermelon',0,'',0,'LineageNPC2.event_good_big_watermelon',26.00,52.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(13278,13278,'Large Rain Honey Watermelon',0,'',0,'LineageNPC2.event_king_big_watermelon',30.00,60.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14001,14001,'Reanimated Man',0,'',0,'LineageMonster.skeleton',11.00,25.00,46,'male','L2Pet',40,2914,816,8.69,2.14,40,43,30,21,20,25,0,0,482,245,202,230,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14002,14002,'Reanimated Man',0,'',0,'LineageMonster.skeleton',11.00,25.00,54,'male','L2Pet',40,3843,1102,10.27,2.45,40,43,30,21,20,25,0,0,763,313,339,293,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14003,14003,'Reanimated Man',0,'',0,'LineageMonster.skeleton',11.00,25.00,62,'male','L2Pet',40,4829,1404,11.85,2.78,40,43,30,21,20,25,0,0,1133,388,532,363,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14004,14004,'Reanimated Man',0,'',0,'LineageMonster.skeleton',11.00,25.00,66,'male','L2Pet',40,5319,1561,11.85,2.78,40,43,30,21,20,25,0,0,1347,428,649,401,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14005,14005,'Reanimated Man',0,'',0,'LineageMonster.skeleton',11.00,25.00,70,'male','L2Pet',40,5793,1722,11.85,2.78,40,43,30,21,20,25,0,0,1577,470,780,440,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14006,14006,'Reanimated Man',0,'',0,'LineageMonster.skeleton',11.00,25.00,74,'male','L2Pet',40,6238,1888,13.43,3.09,40,43,30,21,20,25,0,0,1816,512,921,480,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14007,14007,'Reanimated Man',0,'',0,'LineageMonster.skeleton',11.00,25.00,76,'male','L2Pet',40,6446,1972,13.43,3.09,40,43,30,21,20,25,0,0,1937,534,994,500,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14008,14008,'Reanimated Man',0,'',0,'LineageMonster.skeleton',11.00,25.00,78,'male','L2Pet',40,7085,2057,13.43,3.09,40,43,30,21,20,25,0,0,2068,555,1069,520,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14009,14009,'Reanimated Man',0,'',0,'LineageMonster.skeleton',11.00,25.00,78,'male','L2Pet',40,7085,2057,13.43,3.09,40,43,30,21,20,25,0,0,2078,555,1069,520,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14010,14010,'Reanimated Man',0,'',0,'LineageMonster.skeleton',11.00,25.00,78,'male','L2Pet',40,7085,2057,13.43,3.09,40,43,30,21,20,25,0,0,2088,555,1069,520,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14011,14011,'Reanimated Man',0,'',0,'LineageMonster.skeleton',11.00,25.00,78,'male','L2Pet',40,7085,2057,13.43,3.09,40,43,30,21,20,25,0,0,2099,555,1069,520,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14012,14012,'Reanimated Man',0,'',0,'LineageMonster.skeleton',11.00,25.00,79,'male','L2Pet',40,7085,2057,13.43,3.09,40,43,30,21,20,25,0,0,2109,555,1069,520,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14013,14013,'Reanimated Man',0,'',0,'LineageMonster.skeleton',11.00,25.00,79,'male','L2Pet',40,7085,2057,13.43,3.09,40,43,30,21,20,25,0,0,2119,555,1069,520,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14014,14014,'Reanimated Man',0,'',0,'LineageMonster.skeleton',11.00,25.00,79,'male','L2Pet',40,7085,2057,13.43,3.09,40,43,30,21,20,25,0,0,2130,555,1069,520,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14015,14015,'Reanimated Man',0,'',0,'LineageMonster.skeleton',11.00,25.00,79,'male','L2Pet',40,7085,2057,13.43,3.09,40,43,30,21,20,25,0,0,2140,555,1069,520,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14016,14016,'Reanimated Man',0,'',0,'LineageMonster.skeleton',11.00,25.00,80,'male','L2Pet',40,7085,2057,13.43,3.09,40,43,30,21,20,25,0,0,2150,555,1069,520,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14017,14017,'Reanimated Man',0,'',0,'LineageMonster.skeleton',11.00,25.00,80,'male','L2Pet',40,7085,2057,13.43,3.09,40,43,30,21,20,25,0,0,2173,558,1082,523,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14018,14018,'Reanimated Man',0,'',0,'LineageMonster.skeleton',11.00,25.00,80,'male','L2Pet',40,7085,2057,13.43,3.09,40,43,30,21,20,25,0,0,2184,558,1082,523,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14019,14019,'Reanimated Man',0,'',0,'LineageMonster.skeleton',11.00,25.00,80,'male','L2Pet',40,7085,2057,13.43,3.09,40,43,30,21,20,25,0,0,2194,558,1082,523,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14020,14020,'Reanimated Man',0,'',0,'LineageMonster.skeleton',11.00,25.00,81,'male','L2Pet',40,7085,2057,13.43,3.09,40,43,30,21,20,25,0,0,2204,558,1082,523,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14021,14021,'Reanimated Man',0,'',0,'LineageMonster.skeleton',11.00,25.00,81,'male','L2Pet',40,7085,2057,13.43,3.09,40,43,30,21,20,25,0,0,2215,558,1082,523,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14022,14022,'Reanimated Man',0,'',0,'LineageMonster.skeleton',11.00,25.00,81,'male','L2Pet',40,7085,2057,13.43,3.09,40,43,30,21,20,25,0,0,2225,558,1082,523,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14023,14023,'Reanimated Man',0,'',0,'LineageMonster.skeleton',11.00,25.00,81,'male','L2Pet',40,7085,2057,13.43,3.09,40,43,30,21,20,25,0,0,2236,558,1082,523,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14024,14024,'Reanimated Man',0,'',0,'LineageMonster.skeleton',11.00,25.00,82,'male','L2Pet',40,7085,2057,13.43,3.09,40,43,30,21,20,25,0,0,2246,558,1082,523,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14025,14025,'Reanimated Man',0,'',0,'LineageMonster.skeleton',11.00,25.00,82,'male','L2Pet',40,7085,2057,13.43,3.09,40,43,30,21,20,25,0,0,2256,558,1082,523,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14026,14026,'Reanimated Man',0,'',0,'LineageMonster.skeleton',11.00,25.00,82,'male','L2Pet',40,7085,2057,13.43,3.09,40,43,30,21,20,25,0,0,2280,562,1095,526,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14027,14027,'Reanimated Man',0,'',0,'LineageMonster.skeleton',11.00,25.00,82,'male','L2Pet',40,7085,2057,13.43,3.09,40,43,30,21,20,25,0,0,2290,562,1095,526,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14028,14028,'Reanimated Man',0,'',0,'LineageMonster.skeleton',11.00,25.00,83,'male','L2Pet',40,7085,2057,13.43,3.09,40,43,30,21,20,25,0,0,2301,562,1095,526,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14029,14029,'Reanimated Man',0,'',0,'LineageMonster.skeleton',11.00,25.00,83,'male','L2Pet',40,7085,2057,13.43,3.09,40,43,30,21,20,25,0,0,2311,562,1095,526,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14030,14030,'Reanimated Man',0,'',0,'LineageMonster.skeleton',11.00,25.00,83,'male','L2Pet',40,7085,2057,13.43,3.09,40,43,30,21,20,25,0,0,2322,562,1095,526,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14031,14031,'Reanimated Man',0,'',0,'LineageMonster.skeleton',11.00,25.00,83,'male','L2Pet',40,7085,2057,13.43,3.09,40,43,30,21,20,25,0,0,2332,562,1095,526,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14032,14032,'Reanimated Man',0,'',0,'LineageMonster.skeleton',11.00,25.00,84,'male','L2Pet',40,7085,2057,13.43,3.09,40,43,30,21,20,25,0,0,2343,562,1095,526,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14033,14033,'Reanimated Man',0,'',0,'LineageMonster.skeleton',11.00,25.00,84,'male','L2Pet',40,7085,2057,13.43,3.09,40,43,30,21,20,25,0,0,2353,562,1095,526,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14034,14034,'Reanimated Man',0,'',0,'LineageMonster.skeleton',11.00,25.00,84,'male','L2Pet',40,7085,2057,13.43,3.09,40,43,30,21,20,25,0,0,2363,562,1095,526,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14035,14035,'Reanimated Man',0,'',0,'LineageMonster.skeleton',11.00,25.00,84,'male','L2Pet',40,7085,2057,13.43,3.09,40,43,30,21,20,25,0,0,2374,562,1095,526,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14036,14036,'Reanimated Man',0,'',0,'LineageMonster.skeleton',11.00,25.00,85,'male','L2Pet',40,7085,2057,13.43,3.09,40,43,30,21,20,25,0,0,2384,562,1095,526,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14037,14037,'Reanimated Man',0,'',0,'LineageMonster.skeleton',11.00,25.00,85,'male','L2Pet',40,7085,2057,13.43,3.09,40,43,30,21,20,25,0,0,2395,562,1095,526,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14038,14038,'Corrupted Man',0,'',0,'LineageMonster.zombie',13.00,21.00,42,'male','L2Pet',40,2490,1019,8.69,2.14,40,43,30,21,20,25,0,0,374,215,152,202,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14039,14039,'Corrupted Man',0,'',0,'LineageMonster.zombie',13.00,21.00,50,'male','L2Pet',40,3367,1435,8.69,2.14,40,43,30,21,20,25,0,0,611,278,264,260,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14040,14040,'Corrupted Man',0,'',0,'LineageMonster.zombie',13.00,21.00,58,'male','L2Pet',40,4333,1876,10.27,2.45,40,43,30,21,20,25,0,0,937,349,428,327,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14041,14041,'Corrupted Man',0,'',0,'LineageMonster.zombie',13.00,21.00,64,'male','L2Pet',40,5076,2223,11.85,2.78,40,43,30,21,20,25,0,0,1238,408,589,382,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14042,14042,'Corrupted Man',0,'',0,'LineageMonster.zombie',13.00,21.00,68,'male','L2Pet',40,5559,2462,11.85,2.78,40,43,30,21,20,25,0,0,1460,449,713,421,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14043,14043,'Corrupted Man',0,'',0,'LineageMonster.zombie',13.00,21.00,72,'male','L2Pet',40,6020,2707,13.43,3.09,40,43,30,21,20,25,0,0,1695,491,849,460,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14044,14044,'Corrupted Man',0,'',0,'LineageMonster.zombie',13.00,21.00,78,'male','L2Pet',40,6642,3086,13.43,3.09,40,43,30,21,20,25,0,0,2068,555,1069,520,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14045,14045,'Corrupted Man',0,'',0,'LineageMonster.zombie',13.00,21.00,78,'male','L2Pet',40,6642,3086,13.43,3.09,40,43,30,21,20,25,0,0,2078,555,1069,520,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14046,14046,'Corrupted Man',0,'',0,'LineageMonster.zombie',13.00,21.00,78,'male','L2Pet',40,6642,3086,13.43,3.09,40,43,30,21,20,25,0,0,2088,555,1069,520,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14047,14047,'Corrupted Man',0,'',0,'LineageMonster.zombie',13.00,21.00,78,'male','L2Pet',40,6642,3086,13.43,3.09,40,43,30,21,20,25,0,0,2099,555,1069,520,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14048,14048,'Corrupted Man',0,'',0,'LineageMonster.zombie',13.00,21.00,79,'male','L2Pet',40,6642,3086,13.43,3.09,40,43,30,21,20,25,0,0,2109,555,1069,520,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14049,14049,'Corrupted Man',0,'',0,'LineageMonster.zombie',13.00,21.00,79,'male','L2Pet',40,6642,3086,13.43,3.09,40,43,30,21,20,25,0,0,2119,555,1069,520,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14050,14050,'Corrupted Man',0,'',0,'LineageMonster.zombie',13.00,21.00,79,'male','L2Pet',40,6642,3086,13.43,3.09,40,43,30,21,20,25,0,0,2130,555,1069,520,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14051,14051,'Corrupted Man',0,'',0,'LineageMonster.zombie',13.00,21.00,79,'male','L2Pet',40,6642,3086,13.43,3.09,40,43,30,21,20,25,0,0,2140,555,1069,520,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14052,14052,'Corrupted Man',0,'',0,'LineageMonster.zombie',13.00,21.00,80,'male','L2Pet',40,6642,3086,13.43,3.09,40,43,30,21,20,25,0,0,2150,555,1069,520,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14053,14053,'Corrupted Man',0,'',0,'LineageMonster.zombie',13.00,21.00,80,'male','L2Pet',40,6642,3086,13.43,3.09,40,43,30,21,20,25,0,0,2173,558,1082,523,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14054,14054,'Corrupted Man',0,'',0,'LineageMonster.zombie',13.00,21.00,80,'male','L2Pet',40,6642,3086,13.43,3.09,40,43,30,21,20,25,0,0,2184,558,1082,523,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14055,14055,'Corrupted Man',0,'',0,'LineageMonster.zombie',13.00,21.00,80,'male','L2Pet',40,6642,3086,13.43,3.09,40,43,30,21,20,25,0,0,2194,558,1082,523,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14056,14056,'Corrupted Man',0,'',0,'LineageMonster.zombie',13.00,21.00,81,'male','L2Pet',40,6642,3086,13.43,3.09,40,43,30,21,20,25,0,0,2204,558,1082,523,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14057,14057,'Corrupted Man',0,'',0,'LineageMonster.zombie',13.00,21.00,81,'male','L2Pet',40,6642,3086,13.43,3.09,40,43,30,21,20,25,0,0,2215,558,1082,523,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14058,14058,'Corrupted Man',0,'',0,'LineageMonster.zombie',13.00,21.00,81,'male','L2Pet',40,6642,3086,13.43,3.09,40,43,30,21,20,25,0,0,2225,558,1082,523,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14059,14059,'Corrupted Man',0,'',0,'LineageMonster.zombie',13.00,21.00,81,'male','L2Pet',40,6642,3086,13.43,3.09,40,43,30,21,20,25,0,0,2236,558,1082,523,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14060,14060,'Corrupted Man',0,'',0,'LineageMonster.zombie',13.00,21.00,82,'male','L2Pet',40,6642,3086,13.43,3.09,40,43,30,21,20,25,0,0,2246,558,1082,523,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14061,14061,'Corrupted Man',0,'',0,'LineageMonster.zombie',13.00,21.00,82,'male','L2Pet',40,6642,3086,13.43,3.09,40,43,30,21,20,25,0,0,2256,558,1082,523,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14062,14062,'Corrupted Man',0,'',0,'LineageMonster.zombie',13.00,21.00,82,'male','L2Pet',40,6642,3086,13.43,3.09,40,43,30,21,20,25,0,0,2280,562,1095,526,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14063,14063,'Corrupted Man',0,'',0,'LineageMonster.zombie',13.00,21.00,82,'male','L2Pet',40,6642,3086,13.43,3.09,40,43,30,21,20,25,0,0,2290,562,1095,526,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14064,14064,'Corrupted Man',0,'',0,'LineageMonster.zombie',13.00,21.00,83,'male','L2Pet',40,6642,3086,13.43,3.09,40,43,30,21,20,25,0,0,2301,562,1095,526,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14065,14065,'Corrupted Man',0,'',0,'LineageMonster.zombie',13.00,21.00,83,'male','L2Pet',40,6642,3086,13.43,3.09,40,43,30,21,20,25,0,0,2311,562,1095,526,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14066,14066,'Corrupted Man',0,'',0,'LineageMonster.zombie',13.00,21.00,83,'male','L2Pet',40,6642,3086,13.43,3.09,40,43,30,21,20,25,0,0,2322,562,1095,526,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14067,14067,'Corrupted Man',0,'',0,'LineageMonster.zombie',13.00,21.00,83,'male','L2Pet',40,6642,3086,13.43,3.09,40,43,30,21,20,25,0,0,2332,562,1095,526,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14068,14068,'Corrupted Man',0,'',0,'LineageMonster.zombie',13.00,21.00,84,'male','L2Pet',40,6642,3086,13.43,3.09,40,43,30,21,20,25,0,0,2343,562,1095,526,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14069,14069,'Corrupted Man',0,'',0,'LineageMonster.zombie',13.00,21.00,84,'male','L2Pet',40,6642,3086,13.43,3.09,40,43,30,21,20,25,0,0,2353,562,1095,526,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14070,14070,'Corrupted Man',0,'',0,'LineageMonster.zombie',13.00,21.00,84,'male','L2Pet',40,6642,3086,13.43,3.09,40,43,30,21,20,25,0,0,2363,562,1095,526,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14071,14071,'Corrupted Man',0,'',0,'LineageMonster.zombie',13.00,21.00,84,'male','L2Pet',40,6642,3086,13.43,3.09,40,43,30,21,20,25,0,0,2374,562,1095,526,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14072,14072,'Corrupted Man',0,'',0,'LineageMonster.zombie',13.00,21.00,85,'male','L2Pet',40,6642,3086,13.43,3.09,40,43,30,21,20,25,0,0,2384,562,1095,526,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14073,14073,'Corrupted Man',0,'',0,'LineageMonster.zombie',13.00,21.00,85,'male','L2Pet',40,6642,3086,13.43,3.09,40,43,30,21,20,25,0,0,2395,562,1095,526,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14074,14074,'Cursed Man',0,'',0,'LineageMonster.doll_master',20.00,42.00,58,'male','L2Pet',80,3467,1251,12.32,2.45,40,43,30,21,20,25,0,0,1015,349,428,327,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14075,14075,'Cursed Man',0,'',0,'LineageMonster.doll_master',20.00,42.00,62,'male','L2Pet',80,3863,1404,14.22,2.78,40,43,30,21,20,25,0,0,1227,388,532,363,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14076,14076,'Cursed Man',0,'',0,'LineageMonster.doll_master',20.00,42.00,66,'male','L2Pet',80,4255,1561,14.22,2.78,40,43,30,21,20,25,0,0,1459,428,649,401,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14077,14077,'Cursed Man',0,'',0,'LineageMonster.doll_master',20.00,42.00,70,'male','L2Pet',80,4634,1722,14.22,2.78,40,43,30,21,20,25,0,0,1708,470,780,440,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14078,14078,'Cursed Man',0,'',0,'LineageMonster.doll_master',20.00,42.00,72,'male','L2Pet',80,4816,1804,16.12,3.09,40,43,30,21,20,25,0,0,1837,491,849,460,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14079,14079,'Cursed Man',0,'',0,'LineageMonster.doll_master',20.00,42.00,74,'male','L2Pet',80,4990,1888,16.12,3.09,40,43,30,21,20,25,0,0,1967,512,921,480,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14080,14080,'Cursed Man',0,'',0,'LineageMonster.doll_master',20.00,42.00,76,'male','L2Pet',80,5157,1972,16.12,3.09,40,43,30,21,20,25,0,0,2098,534,994,500,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14081,14081,'Cursed Man',0,'',0,'LineageMonster.doll_master',20.00,42.00,78,'male','L2Pet',80,5314,2057,16.12,3.09,40,43,30,21,20,25,0,0,2229,555,1069,520,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14082,14082,'Cursed Man',0,'',0,'LineageMonster.doll_master',20.00,42.00,78,'male','L2Pet',80,5314,2057,16.12,3.09,40,43,30,21,20,25,0,0,2245,555,1069,520,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14083,14083,'Cursed Man',0,'',0,'LineageMonster.doll_master',20.00,42.00,78,'male','L2Pet',80,5314,2057,16.12,3.09,40,43,30,21,20,25,0,0,2261,555,1069,520,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14084,14084,'Cursed Man',0,'',0,'LineageMonster.doll_master',20.00,42.00,78,'male','L2Pet',80,5314,2057,16.12,3.09,40,43,30,21,20,25,0,0,2277,555,1069,520,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14085,14085,'Cursed Man',0,'',0,'LineageMonster.doll_master',20.00,42.00,79,'male','L2Pet',80,5314,2057,16.12,3.09,40,43,30,21,20,25,0,0,2293,555,1069,520,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14086,14086,'Cursed Man',0,'',0,'LineageMonster.doll_master',20.00,42.00,79,'male','L2Pet',80,5314,2057,16.12,3.09,40,43,30,21,20,25,0,0,2309,555,1069,520,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14087,14087,'Cursed Man',0,'',0,'LineageMonster.doll_master',20.00,42.00,79,'male','L2Pet',80,5314,2057,16.12,3.09,40,43,30,21,20,25,0,0,2325,555,1069,520,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14088,14088,'Cursed Man',0,'',0,'LineageMonster.doll_master',20.00,42.00,79,'male','L2Pet',80,5314,2057,16.12,3.09,40,43,30,21,20,25,0,0,2341,555,1069,520,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14089,14089,'Cursed Man',0,'',0,'LineageMonster.doll_master',20.00,42.00,80,'male','L2Pet',80,5314,2057,16.12,3.09,40,43,30,21,20,25,0,0,2357,555,1069,520,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14090,14090,'Cursed Man',0,'',0,'LineageMonster.doll_master',20.00,42.00,80,'male','L2Pet',80,5314,2057,16.12,3.09,40,43,30,21,20,25,0,0,2388,558,1082,523,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14091,14091,'Cursed Man',0,'',0,'LineageMonster.doll_master',20.00,42.00,80,'male','L2Pet',80,5314,2057,16.12,3.09,40,43,30,21,20,25,0,0,2404,558,1082,523,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14092,14092,'Cursed Man',0,'',0,'LineageMonster.doll_master',20.00,42.00,80,'male','L2Pet',80,5314,2057,16.12,3.09,40,43,30,21,20,25,0,0,2420,558,1082,523,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14093,14093,'Cursed Man',0,'',0,'LineageMonster.doll_master',20.00,42.00,81,'male','L2Pet',80,5314,2057,16.12,3.09,40,43,30,21,20,25,0,0,2436,558,1082,523,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14094,14094,'Cursed Man',0,'',0,'LineageMonster.doll_master',20.00,42.00,81,'male','L2Pet',80,5314,2057,16.12,3.09,40,43,30,21,20,25,0,0,2452,558,1082,523,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14095,14095,'Cursed Man',0,'',0,'LineageMonster.doll_master',20.00,42.00,81,'male','L2Pet',80,5314,2057,16.12,3.09,40,43,30,21,20,25,0,0,2468,558,1082,523,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14096,14096,'Cursed Man',0,'',0,'LineageMonster.doll_master',20.00,42.00,81,'male','L2Pet',80,5314,2057,16.12,3.09,40,43,30,21,20,25,0,0,2484,558,1082,523,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14097,14097,'Cursed Man',0,'',0,'LineageMonster.doll_master',20.00,42.00,82,'male','L2Pet',80,5314,2057,16.12,3.09,40,43,30,21,20,25,0,0,2500,558,1082,523,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14098,14098,'Cursed Man',0,'',0,'LineageMonster.doll_master',20.00,42.00,82,'male','L2Pet',80,5314,2057,16.12,3.09,40,43,30,21,20,25,0,0,2517,558,1082,523,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14099,14099,'Cursed Man',0,'',0,'LineageMonster.doll_master',20.00,42.00,82,'male','L2Pet',80,5314,2057,16.12,3.09,40,43,30,21,20,25,0,0,2548,562,1095,526,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14100,14100,'Cursed Man',0,'',0,'LineageMonster.doll_master',20.00,42.00,82,'male','L2Pet',80,5314,2057,16.12,3.09,40,43,30,21,20,25,0,0,2564,562,1095,526,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14101,14101,'Cursed Man',0,'',0,'LineageMonster.doll_master',20.00,42.00,83,'male','L2Pet',80,5314,2057,16.12,3.09,40,43,30,21,20,25,0,0,2580,562,1095,526,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14102,14102,'Cursed Man',0,'',0,'LineageMonster.doll_master',20.00,42.00,83,'male','L2Pet',80,5314,2057,16.12,3.09,40,43,30,21,20,25,0,0,2596,562,1095,526,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14103,14103,'Cursed Man',0,'',0,'LineageMonster.doll_master',20.00,42.00,83,'male','L2Pet',80,5314,2057,16.12,3.09,40,43,30,21,20,25,0,0,2613,562,1095,526,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14104,14104,'Cursed Man',0,'',0,'LineageMonster.doll_master',20.00,42.00,83,'male','L2Pet',80,5314,2057,16.12,3.09,40,43,30,21,20,25,0,0,2629,562,1095,526,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14105,14105,'Cursed Man',0,'',0,'LineageMonster.doll_master',20.00,42.00,84,'male','L2Pet',80,5314,2057,16.12,3.09,40,43,30,21,20,25,0,0,2645,562,1095,526,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14106,14106,'Cursed Man',0,'',0,'LineageMonster.doll_master',20.00,42.00,84,'male','L2Pet',80,5314,2057,16.12,3.09,40,43,30,21,20,25,0,0,2661,562,1095,526,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14107,14107,'Cursed Man',0,'',0,'LineageMonster.doll_master',20.00,42.00,84,'male','L2Pet',80,5314,2057,16.12,3.09,40,43,30,21,20,25,0,0,2678,562,1095,526,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14108,14108,'Cursed Man',0,'',0,'LineageMonster.doll_master',20.00,42.00,84,'male','L2Pet',80,5314,2057,16.12,3.09,40,43,30,21,20,25,0,0,2694,562,1095,526,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14109,14109,'Cursed Man',0,'',0,'LineageMonster.doll_master',20.00,42.00,85,'male','L2Pet',80,5314,2057,16.12,3.09,40,43,30,21,20,25,0,0,2710,562,1095,526,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14110,14110,'Cursed Man',0,'',0,'LineageMonster.doll_master',20.00,42.00,85,'male','L2Pet',80,5314,2057,16.12,3.09,40,43,30,21,20,25,0,0,2726,562,1095,526,278,0,333,0,0,0,0,66,154,1,0,'LAST_HIT','false'),
(14111,14111,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,22,'male','L2Pet',40,984,279,5.53,1.53,40,43,30,21,20,25,0,0,82,102,28,95,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14112,14112,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,32,'male','L2Pet',40,1700,458,7.11,2.24,40,43,30,21,20,25,0,0,186,151,69,140,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14113,14113,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,42,'male','L2Pet',40,2673,679,9.09,2.14,40,43,30,21,20,25,0,0,376,236,152,221,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14114,14114,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,50,'male','L2Pet',40,3614,957,9.09,2.14,40,43,30,21,20,25,0,0,615,305,263,285,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14115,14115,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,58,'male','L2Pet',40,4651,1251,10.27,2.45,40,43,30,21,20,25,0,0,943,383,428,360,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14116,14116,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,27,'male','L2Pet',40,1310,367,5.53,1.53,40,43,30,21,20,25,0,0,124,125,45,117,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14117,14117,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,37,'male','L2Pet',40,2155,533,7.11,2.24,40,43,30,21,20,25,0,0,267,181,104,169,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14118,14118,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,46,'male','L2Pet',40,3128,816,9.09,2.14,40,43,30,21,20,25,0,0,486,270,202,252,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14119,14119,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,54,'male','L2Pet',40,4125,1102,10.27,2.45,40,43,30,21,20,25,0,0,768,342,339,322,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14120,14120,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,60,'male','L2Pet',40,4917,1327,10.27,2.45,40,43,30,21,20,25,0,0,1040,404,477,379,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14121,14121,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,62,'male','L2Pet',40,5183,1404,12.25,3.18,40,43,30,21,20,25,0,0,1142,426,531,399,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14122,14122,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,64,'male','L2Pet',40,5448,1482,12.25,3.18,40,43,30,21,20,25,0,0,1248,449,588,420,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14123,14123,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,66,'male','L2Pet',40,5710,1561,12.25,3.18,40,43,30,21,20,25,0,0,1357,470,649,440,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14124,14124,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,68,'male','L2Pet',40,5967,1641,12.25,3.18,40,43,30,21,20,25,0,0,1472,493,713,462,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14125,14125,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,70,'male','L2Pet',40,6218,1722,12.25,3.18,40,43,30,21,20,25,0,0,1588,515,779,483,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14126,14126,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,72,'male','L2Pet',40,6461,1803,13.43,3.09,40,43,30,21,20,25,0,0,1708,540,848,505,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14127,14127,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,74,'male','L2Pet',40,6695,1888,13.43,3.09,40,43,30,21,20,25,0,0,1829,563,920,527,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14128,14128,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,76,'male','L2Pet',40,6919,1972,13.43,3.09,40,43,30,21,20,25,0,0,1952,586,993,548,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14129,14129,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,78,'male','L2Pet',40,7150,2059,13.43,3.09,40,43,30,21,20,25,0,0,2083,609,1071,569,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14130,14130,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,78,'male','L2Pet',40,7209,2081,13.43,3.09,40,43,30,21,20,25,0,0,2117,614,1092,574,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14131,14131,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,78,'male','L2Pet',40,7269,2103,13.43,3.09,40,43,30,21,20,25,0,0,2152,620,1113,579,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14132,14132,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,78,'male','L2Pet',40,7329,2126,13.43,3.09,40,43,30,21,20,25,0,0,2188,626,1134,584,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14133,14133,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,79,'male','L2Pet',40,7390,2149,13.43,3.09,40,43,30,21,20,25,0,0,2224,632,1156,589,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14134,14134,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,79,'male','L2Pet',40,7451,2172,13.43,3.09,40,43,30,21,20,25,0,0,2261,638,1178,594,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14135,14135,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,79,'male','L2Pet',40,7513,2195,13.43,3.09,40,43,30,21,20,25,0,0,2298,644,1201,599,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14136,14136,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,79,'male','L2Pet',40,7575,2219,13.43,3.09,40,43,30,21,20,25,0,0,2336,650,1224,604,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14137,14137,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,80,'male','L2Pet',40,7638,2243,13.43,3.09,40,43,30,21,20,25,0,0,2375,656,1248,609,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14138,14138,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,80,'male','L2Pet',40,7701,2267,13.43,3.09,40,43,30,21,20,25,0,0,2414,662,1272,614,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14139,14139,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,80,'male','L2Pet',40,7765,2292,13.43,3.09,40,43,30,21,20,25,0,0,2454,668,1296,619,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14140,14140,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,80,'male','L2Pet',40,7829,2317,13.43,3.09,40,43,30,21,20,25,0,0,2495,674,1321,624,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14141,14141,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,81,'male','L2Pet',40,7894,2342,13.43,3.09,40,43,30,21,20,25,0,0,2536,680,1346,629,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14142,14142,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,81,'male','L2Pet',40,7959,2367,13.43,3.09,40,43,30,21,20,25,0,0,2578,686,1372,635,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14143,14143,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,81,'male','L2Pet',40,8025,2393,13.43,3.09,40,43,30,21,20,25,0,0,2621,692,1398,641,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14144,14144,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,81,'male','L2Pet',40,8091,2419,13.43,3.09,40,43,30,21,20,25,0,0,2664,698,1425,647,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14145,14145,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,82,'male','L2Pet',40,8158,2445,13.43,3.09,40,43,30,21,20,25,0,0,2708,704,1452,653,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14146,14146,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,82,'male','L2Pet',40,8226,2471,13.43,3.09,40,43,30,21,20,25,0,0,2753,710,1480,659,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14147,14147,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,82,'male','L2Pet',40,8294,2498,13.43,3.09,40,43,30,21,20,25,0,0,2799,716,1509,665,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14148,14148,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,82,'male','L2Pet',40,8363,2525,13.43,3.09,40,43,30,21,20,25,0,0,2845,723,1538,671,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14149,14149,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,83,'male','L2Pet',40,8432,2552,13.43,3.09,40,43,30,21,20,25,0,0,2892,730,1568,677,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14150,14150,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,83,'male','L2Pet',40,8502,2580,13.43,3.09,40,43,30,21,20,25,0,0,2940,737,1598,683,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14151,14151,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,83,'male','L2Pet',40,8572,2608,13.43,3.09,40,43,30,21,20,25,0,0,2989,744,1629,689,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14152,14152,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,83,'male','L2Pet',40,8643,2636,13.43,3.09,40,43,30,21,20,25,0,0,3039,751,1660,695,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14153,14153,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,84,'male','L2Pet',40,8715,2665,13.43,3.09,40,43,30,21,20,25,0,0,3089,758,1692,701,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14154,14154,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,84,'male','L2Pet',40,8787,2694,13.43,3.09,40,43,30,21,20,25,0,0,3140,765,1725,707,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14155,14155,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,84,'male','L2Pet',40,8860,2723,13.43,3.09,40,43,30,21,20,25,0,0,3192,772,1758,713,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14156,14156,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,84,'male','L2Pet',40,8933,2753,13.43,3.09,40,43,30,21,20,25,0,0,3245,779,1792,719,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14157,14157,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,85,'male','L2Pet',40,9007,2783,13.43,3.09,40,43,30,21,20,25,0,0,3299,786,1827,725,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14158,14158,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat',9.00,16.00,85,'male','L2Pet',40,9082,2813,13.43,3.09,40,43,30,21,20,25,0,0,3354,793,1862,731,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(14159,14159,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,27,'female','L2Pet',40,1310,367,5.53,1.53,40,43,30,21,20,25,0,0,113,125,54,117,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14160,14160,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,37,'female','L2Pet',40,2155,553,7.11,2.24,40,43,30,21,20,25,0,0,242,181,126,169,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14161,14161,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,47,'female','L2Pet',40,3128,816,9.09,2.14,40,43,30,21,20,25,0,0,441,270,244,252,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14162,14162,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,54,'female','L2Pet',40,4125,1102,10.27,2.45,40,43,30,21,20,25,0,0,698,342,410,322,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14163,14163,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,22,'female','L2Pet',40,984,279,5.53,1.53,40,43,30,21,20,25,0,0,74,102,34,95,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14164,14164,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,32,'female','L2Pet',40,1700,458,7.11,2.24,40,43,30,21,20,25,0,0,169,151,83,140,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14165,14165,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,42,'female','L2Pet',40,2673,679,9.09,2.14,40,43,30,21,20,25,0,0,342,236,183,221,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14166,14166,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,50,'female','L2Pet',40,3614,957,9.09,2.14,40,43,30,21,20,25,0,0,559,305,319,285,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14167,14167,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,58,'female','L2Pet',40,4651,1251,10.27,2.45,40,43,30,21,20,25,0,0,857,383,518,360,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14168,14168,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,60,'female','L2Pet',40,4917,1327,10.27,2.45,40,43,30,21,20,25,0,0,946,404,578,379,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14169,14169,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,62,'female','L2Pet',40,5183,1404,12.25,3.18,40,43,30,21,20,25,0,0,1038,426,642,399,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14170,14170,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,64,'female','L2Pet',40,5448,1482,12.25,3.18,40,43,30,21,20,25,0,0,1135,449,711,420,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14171,14171,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,66,'female','L2Pet',40,5710,1561,12.25,3.18,40,43,30,21,20,25,0,0,1233,470,785,440,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14172,14172,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,68,'female','L2Pet',40,5967,1641,12.25,3.18,40,43,30,21,20,25,0,0,1338,493,862,462,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14173,14173,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,70,'female','L2Pet',40,6218,1722,12.25,3.18,40,43,30,21,20,25,0,0,1443,515,943,483,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14174,14174,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,72,'female','L2Pet',40,6461,1804,13.43,3.09,40,43,30,21,20,25,0,0,1553,540,1026,505,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14175,14175,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,74,'female','L2Pet',40,6695,1888,13.43,3.09,40,43,30,21,20,25,0,0,1663,563,1113,527,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14176,14176,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,76,'female','L2Pet',40,6919,1972,13.43,3.09,40,43,30,21,20,25,0,0,1775,586,1201,548,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14177,14177,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,78,'female','L2Pet',40,7150,2059,13.43,3.09,40,43,30,21,20,25,0,0,1894,609,1295,569,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14178,14178,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,78,'female','L2Pet',40,7209,2081,13.43,3.09,40,43,30,21,20,25,0,0,1925,614,1320,574,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14179,14179,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,78,'female','L2Pet',40,7269,2103,13.43,3.09,40,43,30,21,20,25,0,0,1957,620,1345,579,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14180,14180,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,78,'female','L2Pet',40,7329,2126,13.43,3.09,40,43,30,21,20,25,0,0,1989,626,1371,584,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14181,14181,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,79,'female','L2Pet',40,7390,2149,13.43,3.09,40,43,30,21,20,25,0,0,2022,632,1397,589,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14182,14182,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,79,'female','L2Pet',40,7451,2172,13.43,3.09,40,43,30,21,20,25,0,0,2055,638,1424,594,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14183,14183,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,79,'female','L2Pet',40,7513,2195,13.43,3.09,40,43,30,21,20,25,0,0,2089,644,1451,599,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14184,14184,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,79,'female','L2Pet',40,7575,2219,13.43,3.09,40,43,30,21,20,25,0,0,2124,650,1479,604,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14185,14185,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,80,'female','L2Pet',40,7638,2243,13.43,3.09,40,43,30,21,20,25,0,0,2159,656,1507,609,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14186,14186,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,80,'female','L2Pet',40,7701,2267,13.43,3.09,40,43,30,21,20,25,0,0,2195,662,1536,614,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14187,14187,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,80,'female','L2Pet',40,7765,2292,13.43,3.09,40,43,30,21,20,25,0,0,2231,668,1566,619,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14188,14188,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,80,'female','L2Pet',40,7829,2317,13.43,3.09,40,43,30,21,20,25,0,0,2268,674,1596,624,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14189,14189,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,81,'female','L2Pet',40,7894,2342,13.43,3.09,40,43,30,21,20,25,0,0,2306,680,1627,629,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14190,14190,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,81,'female','L2Pet',40,7959,2367,13.43,3.09,40,43,30,21,20,25,0,0,2344,686,1658,635,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14191,14191,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,81,'female','L2Pet',40,8025,2393,13.43,3.09,40,43,30,21,20,25,0,0,2383,692,1690,641,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14192,14192,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,81,'female','L2Pet',40,8091,2419,13.43,3.09,40,43,30,21,20,25,0,0,2422,698,1723,647,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14193,14193,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,82,'female','L2Pet',40,8158,2445,13.43,3.09,40,43,30,21,20,25,0,0,2462,704,1756,653,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14194,14194,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,82,'female','L2Pet',40,8226,2471,13.43,3.09,40,43,30,21,20,25,0,0,2503,710,1790,659,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14195,14195,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,82,'female','L2Pet',40,8294,2498,13.43,3.09,40,43,30,21,20,25,0,0,2544,716,1825,665,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14196,14196,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,82,'female','L2Pet',40,8363,2525,13.43,3.09,40,43,30,21,20,25,0,0,2586,723,1860,671,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14197,14197,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,83,'female','L2Pet',40,8432,2552,13.43,3.09,40,43,30,21,20,25,0,0,2629,730,1896,677,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14198,14198,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,83,'female','L2Pet',40,8502,2580,13.43,3.09,40,43,30,21,20,25,0,0,2673,737,1933,683,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14199,14199,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,83,'female','L2Pet',40,8572,2608,13.43,3.09,40,43,30,21,20,25,0,0,2717,744,1970,689,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14200,14200,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,83,'female','L2Pet',40,8643,2636,13.43,3.09,40,43,30,21,20,25,0,0,2762,751,2008,695,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14201,14201,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,84,'female','L2Pet',40,8715,2665,13.43,3.09,40,43,30,21,20,25,0,0,2808,758,2047,701,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14202,14202,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,84,'female','L2Pet',40,8787,2694,13.43,3.09,40,43,30,21,20,25,0,0,2855,765,2087,707,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14203,14203,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,84,'female','L2Pet',40,8860,2723,13.43,3.09,40,43,30,21,20,25,0,0,2902,772,2127,713,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14204,14204,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,84,'female','L2Pet',40,8933,2753,13.43,3.09,40,43,30,21,20,25,0,0,2950,779,2168,719,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14205,14205,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,85,'female','L2Pet',40,9007,2783,13.43,3.09,40,43,30,21,20,25,0,0,2999,786,2210,725,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14206,14206,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat',8.00,15.00,85,'female','L2Pet',40,9082,2813,13.43,3.09,40,43,30,21,20,25,0,0,3049,793,2253,731,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14207,14207,'Kai the Cat',0,'',0,'LineageMonster.silver_cat',7.00,15.00,42,'male','L2Pet',40,2008,679,9.09,2.14,40,43,30,21,20,25,0,0,413,236,152,221,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14208,14208,'Kai the Cat',0,'',0,'LineageMonster.silver_cat',7.00,15.00,46,'male','L2Pet',40,2351,816,9.09,2.14,40,43,30,21,20,25,0,0,534,270,202,252,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14209,14209,'Kai the Cat',0,'',0,'LineageMonster.silver_cat',7.00,15.00,50,'male','L2Pet',40,2716,957,9.09,2.14,40,43,30,21,20,25,0,0,676,305,263,285,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14210,14210,'Kai the Cat',0,'',0,'LineageMonster.silver_cat',7.00,15.00,54,'male','L2Pet',40,3100,1102,10.27,2.45,40,43,30,21,20,25,0,0,844,342,339,322,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14211,14211,'Kai the Cat',0,'',0,'LineageMonster.silver_cat',7.00,15.00,58,'male','L2Pet',40,3496,1251,10.27,2.45,40,43,30,21,20,25,0,0,1036,393,428,360,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14212,14212,'Kai the Cat',0,'',0,'LineageMonster.silver_cat',7.00,15.00,60,'male','L2Pet',40,3695,1327,10.27,2.45,40,43,30,21,20,25,0,0,1142,404,477,379,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14213,14213,'Kai the Cat',0,'',0,'LineageMonster.silver_cat',7.00,15.00,62,'male','L2Pet',40,3895,1404,12.25,3.18,40,43,30,21,20,25,0,0,1255,426,531,399,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14214,14214,'Kai the Cat',0,'',0,'LineageMonster.silver_cat',7.00,15.00,64,'male','L2Pet',40,4094,1482,12.25,3.18,40,43,30,21,20,25,0,0,1372,449,588,420,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14215,14215,'Kai the Cat',0,'',0,'LineageMonster.silver_cat',7.00,15.00,66,'male','L2Pet',40,4291,1561,12.25,3.18,40,43,30,21,20,25,0,0,1491,470,649,440,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14216,14216,'Kai the Cat',0,'',0,'LineageMonster.silver_cat',7.00,15.00,68,'male','L2Pet',40,4484,1641,12.25,3.18,40,43,30,21,20,25,0,0,1618,493,713,462,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14217,14217,'Kai the Cat',0,'',0,'LineageMonster.silver_cat',7.00,15.00,70,'male','L2Pet',40,4673,1722,12.25,3.18,40,43,30,21,20,25,0,0,1745,515,779,483,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14218,14218,'Kai the Cat',0,'',0,'LineageMonster.silver_cat',7.00,15.00,72,'male','L2Pet',40,4856,1804,13.43,3.09,40,43,30,21,20,25,0,0,1878,540,848,505,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14219,14219,'Kai the Cat',0,'',0,'LineageMonster.silver_cat',7.00,15.00,74,'male','L2Pet',40,5032,1888,13.43,3.09,40,43,30,21,20,25,0,0,2010,563,920,527,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14220,14220,'Kai the Cat',0,'',0,'LineageMonster.silver_cat',7.00,15.00,76,'male','L2Pet',40,5200,1972,13.43,3.09,40,43,30,21,20,25,0,0,2146,586,993,548,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14221,14221,'Kai the Cat',0,'',0,'LineageMonster.silver_cat',7.00,15.00,78,'male','L2Pet',40,5373,2059,13.43,3.09,40,43,30,21,20,25,0,0,2291,609,1071,569,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14222,14222,'Kai the Cat',0,'',0,'LineageMonster.silver_cat',7.00,15.00,78,'male','L2Pet',40,5417,2081,13.43,3.09,40,43,30,21,20,25,0,0,2329,614,1092,574,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14223,14223,'Kai the Cat',0,'',0,'LineageMonster.silver_cat',7.00,15.00,78,'male','L2Pet',40,5462,2103,13.43,3.09,40,43,30,21,20,25,0,0,2368,620,1113,579,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14224,14224,'Kai the Cat',0,'',0,'LineageMonster.silver_cat',7.00,15.00,78,'male','L2Pet',40,5507,2126,13.43,3.09,40,43,30,21,20,25,0,0,2408,626,1134,584,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14225,14225,'Kai the Cat',0,'',0,'LineageMonster.silver_cat',7.00,15.00,79,'male','L2Pet',40,5552,2149,13.43,3.09,40,43,30,21,20,25,0,0,2448,632,1156,589,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14226,14226,'Kai the Cat',0,'',0,'LineageMonster.silver_cat',7.00,15.00,79,'male','L2Pet',40,5598,2172,13.43,3.09,40,43,30,21,20,25,0,0,2489,638,1178,594,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14227,14227,'Kai the Cat',0,'',0,'LineageMonster.silver_cat',7.00,15.00,79,'male','L2Pet',40,5644,2195,13.43,3.09,40,43,30,21,20,25,0,0,2531,644,1201,599,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14228,14228,'Kai the Cat',0,'',0,'LineageMonster.silver_cat',7.00,15.00,79,'male','L2Pet',40,5690,2219,13.43,3.09,40,43,30,21,20,25,0,0,2573,650,1224,604,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14229,14229,'Kai the Cat',0,'',0,'LineageMonster.silver_cat',7.00,15.00,80,'male','L2Pet',40,5737,2243,13.43,3.09,40,43,30,21,20,25,0,0,2616,656,1248,609,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14230,14230,'Kai the Cat',0,'',0,'LineageMonster.silver_cat',7.00,15.00,80,'male','L2Pet',40,5784,2267,13.43,3.09,40,43,30,21,20,25,0,0,2660,662,1272,614,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14231,14231,'Kai the Cat',0,'',0,'LineageMonster.silver_cat',7.00,15.00,80,'male','L2Pet',40,5832,2292,13.43,3.09,40,43,30,21,20,25,0,0,2704,668,1296,619,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14232,14232,'Kai the Cat',0,'',0,'LineageMonster.silver_cat',7.00,15.00,80,'male','L2Pet',40,5880,2317,13.43,3.09,40,43,30,21,20,25,0,0,2749,674,1321,624,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14233,14233,'Kai the Cat',0,'',0,'LineageMonster.silver_cat',7.00,15.00,81,'male','L2Pet',40,5928,2342,13.43,3.09,40,43,30,21,20,25,0,0,2795,680,1346,629,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14234,14234,'Kai the Cat',0,'',0,'LineageMonster.silver_cat',7.00,15.00,81,'male','L2Pet',40,5977,2367,13.43,3.09,40,43,30,21,20,25,0,0,2842,686,1372,635,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14235,14235,'Kai the Cat',0,'',0,'LineageMonster.silver_cat',7.00,15.00,81,'male','L2Pet',40,6026,2393,13.43,3.09,40,43,30,21,20,25,0,0,2890,692,1398,641,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14236,14236,'Kai the Cat',0,'',0,'LineageMonster.silver_cat',7.00,15.00,81,'male','L2Pet',40,6076,2419,13.43,3.09,40,43,30,21,20,25,0,0,2938,698,1425,647,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14237,14237,'Kai the Cat',0,'',0,'LineageMonster.silver_cat',7.00,15.00,82,'male','L2Pet',40,6126,2445,13.43,3.09,40,43,30,21,20,25,0,0,2987,704,1452,653,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14238,14238,'Kai the Cat',0,'',0,'LineageMonster.silver_cat',7.00,15.00,82,'male','L2Pet',40,6176,2471,13.43,3.09,40,43,30,21,20,25,0,0,3037,710,1480,659,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14239,14239,'Kai the Cat',0,'',0,'LineageMonster.silver_cat',7.00,15.00,82,'male','L2Pet',40,6227,2498,13.43,3.09,40,43,30,21,20,25,0,0,3088,716,1509,665,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14240,14240,'Kai the Cat',0,'',0,'LineageMonster.silver_cat',7.00,15.00,82,'male','L2Pet',40,6278,2525,13.43,3.09,40,43,30,21,20,25,0,0,3140,723,1538,671,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14241,14241,'Kai the Cat',0,'',0,'LineageMonster.silver_cat',7.00,15.00,83,'male','L2Pet',40,6330,2552,13.43,3.09,40,43,30,21,20,25,0,0,3193,730,1568,677,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14242,14242,'Kai the Cat',0,'',0,'LineageMonster.silver_cat',7.00,15.00,83,'male','L2Pet',40,6382,2580,13.43,3.09,40,43,30,21,20,25,0,0,3246,737,1598,683,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14243,14243,'Kai the Cat',0,'',0,'LineageMonster.silver_cat',7.00,15.00,83,'male','L2Pet',40,6435,2608,13.43,3.09,40,43,30,21,20,25,0,0,3300,744,1629,689,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14244,14244,'Kai the Cat',0,'',0,'LineageMonster.silver_cat',7.00,15.00,83,'male','L2Pet',40,6488,2636,13.43,3.09,40,43,30,21,20,25,0,0,3355,751,1660,695,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14245,14245,'Kai the Cat',0,'',0,'LineageMonster.silver_cat',7.00,15.00,84,'male','L2Pet',40,6541,2665,13.43,3.09,40,43,30,21,20,25,0,0,3411,758,1692,701,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14246,14246,'Kai the Cat',0,'',0,'LineageMonster.silver_cat',7.00,15.00,84,'male','L2Pet',40,6595,2694,13.43,3.09,40,43,30,21,20,25,0,0,3468,765,1725,707,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14247,14247,'Kai the Cat',0,'',0,'LineageMonster.silver_cat',7.00,15.00,84,'male','L2Pet',40,6649,2723,13.43,3.09,40,43,30,21,20,25,0,0,3526,772,1758,713,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14248,14248,'Kai the Cat',0,'',0,'LineageMonster.silver_cat',7.00,15.00,84,'male','L2Pet',40,6704,2753,13.43,3.09,40,43,30,21,20,25,0,0,3585,779,1792,719,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14249,14249,'Kai the Cat',0,'',0,'LineageMonster.silver_cat',7.00,15.00,85,'male','L2Pet',40,6759,2783,13.43,3.09,40,43,30,21,20,25,0,0,3645,786,1827,725,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14250,14250,'Kai the Cat',0,'',0,'LineageMonster.silver_cat',7.00,15.00,85,'male','L2Pet',40,6815,2813,13.43,3.09,40,43,30,21,20,25,0,0,3706,793,1862,731,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14251,14251,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat',8.00,15.00,58,'female','L2Pet',40,2889,1251,10.27,2.45,40,43,30,21,20,25,0,0,779,348,428,327,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14252,14252,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat',8.00,15.00,60,'female','L2Pet',40,3054,1327,10.27,2.45,40,43,30,21,20,25,0,0,860,368,477,345,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14253,14253,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat',8.00,15.00,62,'female','L2Pet',40,3219,1404,12.25,3.18,40,43,30,21,20,25,0,0,944,388,531,363,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14254,14254,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat',8.00,15.00,64,'female','L2Pet',40,3384,1482,12.25,3.18,40,43,30,21,20,25,0,0,1031,408,588,381,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14255,14255,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat',8.00,15.00,66,'female','L2Pet',40,3546,1561,12.25,3.18,40,43,30,21,20,25,0,0,1121,427,649,400,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14256,14256,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat',8.00,15.00,68,'female','L2Pet',40,3706,1641,12.25,3.18,40,43,30,21,20,25,0,0,1217,449,713,420,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14257,14257,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat',8.00,15.00,70,'female','L2Pet',40,3862,1722,12.25,3.18,40,43,30,21,20,25,0,0,1312,469,779,439,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14258,14258,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat',8.00,15.00,72,'female','L2Pet',40,4013,1804,13.43,3.09,40,43,30,21,20,25,0,0,1412,491,848,459,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14259,14259,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat',8.00,15.00,74,'female','L2Pet',40,4158,1888,13.43,3.09,40,43,30,21,20,25,0,0,1511,511,920,479,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14260,14260,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat',8.00,15.00,76,'female','L2Pet',40,4297,1972,13.43,3.09,40,43,30,21,20,25,0,0,1613,532,993,498,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14265,14265,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat',8.00,15.00,78,'female','L2Pet',40,4440,2059,13.43,3.09,40,43,30,21,20,25,0,0,1721,553,1071,517,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14266,14266,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat',8.00,15.00,78,'female','L2Pet',40,4476,2081,13.43,3.09,40,43,30,21,20,25,0,0,1749,558,1092,521,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14267,14267,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat',8.00,15.00,78,'female','L2Pet',40,4513,2103,13.43,3.09,40,43,30,21,20,25,0,0,1778,563,1113,525,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14268,14268,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat',8.00,15.00,78,'female','L2Pet',40,4550,2126,13.43,3.09,40,43,30,21,20,25,0,0,1807,568,1134,530,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14269,14269,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat',8.00,15.00,79,'female','L2Pet',40,4587,2149,13.43,3.09,40,43,30,21,20,25,0,0,1837,573,1156,535,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14270,14270,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat',8.00,15.00,79,'female','L2Pet',40,4625,2172,13.43,3.09,40,43,30,21,20,25,0,0,1867,578,1178,540,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14271,14271,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat',8.00,15.00,79,'female','L2Pet',40,4663,2195,13.43,3.09,40,43,30,21,20,25,0,0,1898,583,1201,545,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14272,14272,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat',8.00,15.00,79,'female','L2Pet',40,4701,2219,13.43,3.09,40,43,30,21,20,25,0,0,1929,588,1224,550,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14273,14273,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat',8.00,15.00,80,'female','L2Pet',40,4740,2243,13.43,3.09,40,43,30,21,20,25,0,0,1961,593,1248,555,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14274,14274,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat',8.00,15.00,80,'female','L2Pet',40,4779,2267,13.43,3.09,40,43,30,21,20,25,0,0,1993,598,1272,560,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14275,14275,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat',8.00,15.00,80,'female','L2Pet',40,4818,2292,13.43,3.09,40,43,30,21,20,25,0,0,2026,603,1296,565,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14276,14276,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat',8.00,15.00,80,'female','L2Pet',40,4858,2317,13.43,3.09,40,43,30,21,20,25,0,0,2059,608,1321,570,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14277,14277,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat',8.00,15.00,81,'female','L2Pet',40,4898,2342,13.43,3.09,40,43,30,21,20,25,0,0,2093,614,1346,575,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14278,14278,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat',8.00,15.00,81,'female','L2Pet',40,4938,2367,13.43,3.09,40,43,30,21,20,25,0,0,2128,620,1372,580,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14279,14279,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat',8.00,15.00,81,'female','L2Pet',40,4979,2393,13.43,3.09,40,43,30,21,20,25,0,0,2163,626,1398,585,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14280,14280,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat',8.00,15.00,81,'female','L2Pet',40,5020,2419,13.43,3.09,40,43,30,21,20,25,0,0,2199,632,1425,590,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14281,14281,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat',8.00,15.00,82,'female','L2Pet',40,5061,2445,13.43,3.09,40,43,30,21,20,25,0,0,2235,638,1452,595,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14282,14282,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat',8.00,15.00,82,'female','L2Pet',40,5103,2471,13.43,3.09,40,43,30,21,20,25,0,0,2272,644,1480,600,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14283,14283,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat',8.00,15.00,82,'female','L2Pet',40,5145,2498,13.43,3.09,40,43,30,21,20,25,0,0,2310,650,1509,605,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14284,14284,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat',8.00,15.00,82,'female','L2Pet',40,5187,2525,13.43,3.09,40,43,30,21,20,25,0,0,2348,656,1538,610,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14285,14285,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat',8.00,15.00,83,'female','L2Pet',40,5230,2552,13.43,3.09,40,43,30,21,20,25,0,0,2387,662,1568,615,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14286,14286,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat',8.00,15.00,83,'female','L2Pet',40,5273,2580,13.43,3.09,40,43,30,21,20,25,0,0,2426,668,1598,620,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14287,14287,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat',8.00,15.00,83,'female','L2Pet',40,5316,2608,13.43,3.09,40,43,30,21,20,25,0,0,2466,674,1629,625,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14288,14288,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat',8.00,15.00,83,'female','L2Pet',40,5360,2636,13.43,3.09,40,43,30,21,20,25,0,0,2507,680,1660,630,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14289,14289,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat',8.00,15.00,84,'female','L2Pet',40,5404,2665,13.43,3.09,40,43,30,21,20,25,0,0,2548,686,1692,636,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14290,14290,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat',8.00,15.00,84,'female','L2Pet',40,5448,2694,13.43,3.09,40,43,30,21,20,25,0,0,2590,692,1725,642,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14291,14291,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat',8.00,15.00,84,'female','L2Pet',40,5493,2723,13.43,3.09,40,43,30,21,20,25,0,0,2633,698,1758,648,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14292,14292,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat',8.00,15.00,84,'female','L2Pet',40,5538,2753,13.43,3.09,40,43,30,21,20,25,0,0,2677,704,1792,654,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14293,14293,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat',8.00,15.00,85,'female','L2Pet',40,5584,2783,13.43,3.09,40,43,30,21,20,25,0,0,2721,710,1827,660,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14294,14294,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat',8.00,15.00,85,'female','L2Pet',40,5630,2813,13.43,3.09,40,43,30,21,20,25,0,0,2766,717,1862,666,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14295,14295,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,22,'male','L2Pet',40,984,279,5.53,1.53,40,43,30,21,20,25,0,0,82,102,28,95,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14296,14296,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,32,'male','L2Pet',40,1700,458,7.11,2.24,40,43,30,21,20,25,0,0,186,151,69,140,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14297,14297,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,42,'male','L2Pet',40,2673,679,9.09,2.14,40,43,30,21,20,25,0,0,376,236,152,221,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14298,14298,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,50,'male','L2Pet',40,3614,957,9.09,2.14,40,43,30,21,20,25,0,0,615,305,263,285,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14299,14299,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,58,'male','L2Pet',40,4651,1251,10.27,2.45,40,43,30,21,20,25,0,0,943,383,428,360,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14300,14300,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,27,'male','L2Pet',40,1310,367,5.53,1.53,40,43,30,21,20,25,0,0,124,125,45,117,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14301,14301,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,37,'male','L2Pet',40,2155,553,7.11,2.24,40,43,30,21,20,25,0,0,267,181,104,169,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14302,14302,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,46,'male','L2Pet',40,3128,757,9.09,2.14,40,43,30,21,20,25,0,0,486,270,202,252,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14303,14303,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,54,'male','L2Pet',40,4125,1102,10.27,2.45,40,43,30,21,20,25,0,0,768,342,339,322,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14304,14304,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,60,'male','L2Pet',40,4917,1327,10.27,2.45,40,43,30,21,20,25,0,0,1040,404,477,379,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14305,14305,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,62,'male','L2Pet',40,5183,1404,12.25,3.18,40,43,30,21,20,25,0,0,1142,426,531,399,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14306,14306,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,64,'male','L2Pet',40,5448,1482,12.25,3.18,40,43,30,21,20,25,0,0,1248,449,588,420,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14307,14307,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,66,'male','L2Pet',40,5710,1561,12.25,3.18,40,43,30,21,20,25,0,0,1357,470,649,440,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14308,14308,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,68,'male','L2Pet',40,5967,1641,12.25,3.18,40,43,30,21,20,25,0,0,1472,493,713,462,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14309,14309,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,70,'male','L2Pet',40,6218,1722,12.25,3.18,40,43,30,21,20,25,0,0,1588,515,779,483,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14310,14310,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,72,'male','L2Pet',40,6461,1804,13.43,3.09,40,43,30,21,20,25,0,0,1708,540,848,505,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14311,14311,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,74,'male','L2Pet',40,6695,1888,13.43,3.09,40,43,30,21,20,25,0,0,1829,563,920,527,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14312,14312,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,76,'male','L2Pet',40,6919,1972,13.43,3.09,40,43,30,21,20,25,0,0,1952,586,993,548,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14313,14313,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,78,'male','L2Pet',40,7150,2059,13.43,3.09,40,43,30,21,20,25,0,0,2083,609,1071,569,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14314,14314,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,78,'male','L2Pet',40,7209,2081,13.43,3.09,40,43,30,21,20,25,0,0,2117,614,1092,574,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14315,14315,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,78,'male','L2Pet',40,7269,2103,13.43,3.09,40,43,30,21,20,25,0,0,2152,620,1113,579,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14316,14316,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,78,'male','L2Pet',40,7329,2126,13.43,3.09,40,43,30,21,20,25,0,0,2188,626,1134,584,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14317,14317,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,79,'male','L2Pet',40,7390,2149,13.43,3.09,40,43,30,21,20,25,0,0,2224,632,1156,589,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14318,14318,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,79,'male','L2Pet',40,7451,2172,13.43,3.09,40,43,30,21,20,25,0,0,2261,638,1178,594,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14319,14319,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,79,'male','L2Pet',40,7513,2195,13.43,3.09,40,43,30,21,20,25,0,0,2298,644,1201,599,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14320,14320,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,79,'male','L2Pet',40,7575,2219,13.43,3.09,40,43,30,21,20,25,0,0,2336,650,1224,604,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14321,14321,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,80,'male','L2Pet',40,7638,2243,13.43,3.09,40,43,30,21,20,25,0,0,2375,656,1248,609,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14322,14322,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,80,'male','L2Pet',40,7701,2267,13.43,3.09,40,43,30,21,20,25,0,0,2414,662,1272,614,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14323,14323,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,80,'male','L2Pet',40,7765,2292,13.43,3.09,40,43,30,21,20,25,0,0,2454,668,1296,619,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14324,14324,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,80,'male','L2Pet',40,7829,2317,13.43,3.09,40,43,30,21,20,25,0,0,2495,674,1321,624,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14325,14325,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,81,'male','L2Pet',40,7894,2342,13.43,3.09,40,43,30,21,20,25,0,0,2536,680,1346,629,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14326,14326,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,81,'male','L2Pet',40,7959,2367,13.43,3.09,40,43,30,21,20,25,0,0,2578,686,1372,635,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14327,14327,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,81,'male','L2Pet',40,8025,2393,13.43,3.09,40,43,30,21,20,25,0,0,2621,692,1398,641,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14328,14328,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,81,'male','L2Pet',40,8091,2419,13.43,3.09,40,43,30,21,20,25,0,0,2664,698,1425,647,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14329,14329,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,82,'male','L2Pet',40,8158,2445,13.43,3.09,40,43,30,21,20,25,0,0,2708,704,1452,653,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14330,14330,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,82,'male','L2Pet',40,8226,2471,13.43,3.09,40,43,30,21,20,25,0,0,2753,710,1480,659,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14331,14331,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,82,'male','L2Pet',40,8294,2498,13.43,3.09,40,43,30,21,20,25,0,0,2799,716,1509,665,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14332,14332,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,82,'male','L2Pet',40,8363,2525,13.43,3.09,40,43,30,21,20,25,0,0,2845,723,1538,671,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14333,14333,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,83,'male','L2Pet',40,8432,2552,13.43,3.09,40,43,30,21,20,25,0,0,2892,730,1568,677,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14334,14334,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,83,'male','L2Pet',40,8502,2580,13.43,3.09,40,43,30,21,20,25,0,0,2940,737,1598,683,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14335,14335,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,83,'male','L2Pet',40,8572,2608,13.43,3.09,40,43,30,21,20,25,0,0,2989,744,1629,689,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14336,14336,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,83,'male','L2Pet',40,8643,2636,13.43,3.09,40,43,30,21,20,25,0,0,3039,751,1660,695,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14337,14337,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,84,'male','L2Pet',40,8715,2665,13.43,3.09,40,43,30,21,20,25,0,0,3089,758,1692,701,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14338,14338,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,84,'male','L2Pet',40,8787,2694,13.43,3.09,40,43,30,21,20,25,0,0,3140,765,1725,707,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14339,14339,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,84,'male','L2Pet',40,8860,2723,13.43,3.09,40,43,30,21,20,25,0,0,3192,772,1758,713,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14340,14340,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,84,'male','L2Pet',40,8933,2753,13.43,3.09,40,43,30,21,20,25,0,0,3245,779,1792,719,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14341,14341,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,85,'male','L2Pet',40,9007,2783,13.43,3.09,40,43,30,21,20,25,0,0,3299,786,1827,725,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14342,14342,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer',11.00,18.00,85,'male','L2Pet',40,9082,2813,13.43,3.09,40,43,30,21,20,25,0,0,3354,793,1862,731,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14343,14343,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,27,'male','L2Pet',40,1310,367,5.53,1.53,40,43,30,21,20,25,0,0,113,125,54,117,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14344,14344,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,37,'male','L2Pet',40,2155,553,7.11,2.24,40,43,30,21,20,25,0,0,242,181,126,169,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14345,14345,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,47,'male','L2Pet',40,3128,816,9.09,2.14,40,43,30,21,20,25,0,0,441,270,244,252,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14346,14346,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,54,'male','L2Pet',40,4125,1102,10.27,2.45,40,43,30,21,20,25,0,0,698,342,410,322,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14347,14347,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,22,'male','L2Pet',40,984,279,5.53,1.53,40,43,30,21,20,25,0,0,74,102,34,95,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14348,14348,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,32,'male','L2Pet',40,1700,458,7.11,2.24,40,43,30,21,20,25,0,0,169,151,83,140,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14349,14349,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,42,'male','L2Pet',40,2673,679,9.09,2.14,40,43,30,21,20,25,0,0,342,236,183,221,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14350,14350,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,50,'male','L2Pet',40,3614,957,9.09,2.14,40,43,30,21,20,25,0,0,559,305,319,285,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14351,14351,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,58,'male','L2Pet',40,4651,1251,10.27,2.45,40,43,30,21,20,25,0,0,857,383,518,360,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14352,14352,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,60,'male','L2Pet',40,4917,1327,10.27,2.45,40,43,30,21,20,25,0,0,946,404,578,379,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14353,14353,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,62,'male','L2Pet',40,5813,1404,12.25,3.18,40,43,30,21,20,25,0,0,1038,426,642,399,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14354,14354,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,64,'male','L2Pet',40,5448,1482,12.25,3.18,40,43,30,21,20,25,0,0,1134,449,711,420,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14355,14355,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,66,'male','L2Pet',40,5710,1561,12.25,3.18,40,43,30,21,20,25,0,0,1231,470,785,440,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14356,14356,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,68,'male','L2Pet',40,5967,1641,12.25,3.18,40,43,30,21,20,25,0,0,1338,493,862,462,278,0,333,0,0,0,0,66,140,0,0,'LAST_HIT','false'),
(14357,14357,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,70,'male','L2Pet',40,6218,1722,12.25,3.18,40,43,30,21,20,25,0,0,1443,515,943,483,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14358,14358,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,72,'male','L2Pet',40,6461,1804,13.43,3.09,40,43,30,21,20,25,0,0,1553,540,1026,505,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14359,14359,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,74,'male','L2Pet',40,6695,1888,13.43,3.09,40,43,30,21,20,25,0,0,1663,563,1113,527,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14360,14360,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,76,'male','L2Pet',40,6919,1972,13.43,3.09,40,43,30,21,20,25,0,0,1775,586,1201,548,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14361,14361,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,78,'male','L2Pet',40,7150,2059,13.43,3.09,40,43,30,21,20,25,0,0,1894,609,1295,569,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14362,14362,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,78,'male','L2Pet',40,7209,2081,13.43,3.09,40,43,30,21,20,25,0,0,1925,614,1320,574,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14363,14363,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,78,'male','L2Pet',40,7269,2103,13.43,3.09,40,43,30,21,20,25,0,0,1957,620,1345,579,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14364,14364,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,78,'male','L2Pet',40,7329,2126,13.43,3.09,40,43,30,21,20,25,0,0,1989,626,1371,584,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14365,14365,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,79,'male','L2Pet',40,7390,2149,13.43,3.09,40,43,30,21,20,25,0,0,2022,632,1397,589,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14366,14366,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,79,'male','L2Pet',40,7451,2172,13.43,3.09,40,43,30,21,20,25,0,0,2055,638,1424,594,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14367,14367,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,79,'male','L2Pet',40,7513,2195,13.43,3.09,40,43,30,21,20,25,0,0,2089,644,1451,599,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14368,14368,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,79,'male','L2Pet',40,7575,2219,13.43,3.09,40,43,30,21,20,25,0,0,2124,650,1479,604,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14369,14369,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,80,'male','L2Pet',40,7638,2243,13.43,3.09,40,43,30,21,20,25,0,0,2159,656,1507,609,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14370,14370,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,80,'male','L2Pet',40,7701,2267,13.43,3.09,40,43,30,21,20,25,0,0,2195,662,1536,614,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14371,14371,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,80,'male','L2Pet',40,7765,2292,13.43,3.09,40,43,30,21,20,25,0,0,2231,668,1566,619,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14372,14372,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,80,'male','L2Pet',40,7829,2317,13.43,3.09,40,43,30,21,20,25,0,0,2268,674,1596,624,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14373,14373,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,81,'male','L2Pet',40,7894,2342,13.43,3.09,40,43,30,21,20,25,0,0,2306,680,1627,629,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14374,14374,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,81,'male','L2Pet',40,7959,2367,13.43,3.09,40,43,30,21,20,25,0,0,2344,686,1658,635,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14375,14375,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,81,'male','L2Pet',40,8025,2393,13.43,3.09,40,43,30,21,20,25,0,0,2383,692,1690,641,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14376,14376,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,81,'male','L2Pet',40,8091,2419,13.43,3.09,40,43,30,21,20,25,0,0,2422,698,1723,647,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14377,14377,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,82,'male','L2Pet',40,8158,2445,13.43,3.09,40,43,30,21,20,25,0,0,2462,704,1756,653,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14378,14378,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,82,'male','L2Pet',40,8226,2471,13.43,3.09,40,43,30,21,20,25,0,0,2503,710,1790,659,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14379,14379,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,82,'male','L2Pet',40,8294,2498,13.43,3.09,40,43,30,21,20,25,0,0,2544,716,1825,665,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14380,14380,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,82,'male','L2Pet',40,8363,2525,13.43,3.09,40,43,30,21,20,25,0,0,2586,723,1860,671,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14381,14381,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,83,'male','L2Pet',40,8432,2552,13.43,3.09,40,43,30,21,20,25,0,0,2629,730,1896,677,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14382,14382,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,83,'male','L2Pet',40,8502,2580,13.43,3.09,40,43,30,21,20,25,0,0,2673,737,1933,683,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14383,14383,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,83,'male','L2Pet',40,8572,2608,13.43,3.09,40,43,30,21,20,25,0,0,2717,744,1970,689,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14384,14384,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,83,'male','L2Pet',40,8643,2636,13.43,3.09,40,43,30,21,20,25,0,0,2762,751,2008,695,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14385,14385,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,84,'male','L2Pet',40,8715,2665,13.43,3.09,40,43,30,21,20,25,0,0,2808,758,2047,701,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14386,14386,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,84,'male','L2Pet',40,8787,2694,13.43,3.09,40,43,30,21,20,25,0,0,2855,765,2087,707,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14387,14387,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,84,'male','L2Pet',40,8860,2723,13.43,3.09,40,43,30,21,20,25,0,0,2902,772,2127,713,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14388,14388,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,84,'male','L2Pet',40,8933,2753,13.43,3.09,40,43,30,21,20,25,0,0,2950,779,2168,719,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14389,14389,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,85,'male','L2Pet',40,9007,2783,13.43,3.09,40,43,30,21,20,25,0,0,2999,786,2210,725,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14390,14390,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage',13.00,17.00,85,'male','L2Pet',40,9082,2813,13.43,3.09,40,43,30,21,20,25,0,0,3049,793,2253,731,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14391,14391,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye',11.00,16.00,42,'male','L2Pet',40,2008,637,9.09,2.14,40,43,30,21,20,25,0,0,376,236,221,221,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14392,14392,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye',11.00,16.00,46,'male','L2Pet',40,2351,816,9.09,2.14,40,43,30,21,20,25,0,0,486,270,295,252,278,0,467,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14393,14393,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye',11.00,16.00,50,'male','L2Pet',40,2716,957,9.09,2.14,40,43,30,21,20,25,0,0,615,305,384,285,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14394,14394,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye',11.00,16.00,54,'male','L2Pet',40,3100,1102,10.27,2.45,40,43,30,21,20,25,0,0,768,342,495,322,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14395,14395,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye',11.00,16.00,58,'male','L2Pet',40,3496,1251,10.27,2.45,40,43,30,21,20,25,0,0,943,383,625,360,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14396,14396,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye',11.00,16.00,60,'male','L2Pet',40,3695,1327,10.27,2.45,40,43,30,21,20,25,0,0,1040,404,697,379,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14397,14397,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye',11.00,16.00,62,'male','L2Pet',40,3895,1404,12.25,3.18,40,43,30,21,20,25,0,0,1142,426,775,399,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14398,14398,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye',11.00,16.00,64,'male','L2Pet',40,4094,1482,12.25,3.18,40,43,30,21,20,25,0,0,1248,449,858,420,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14399,14399,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye',11.00,16.00,66,'male','L2Pet',40,4291,1561,12.25,3.18,40,43,30,21,20,25,0,0,1356,470,947,440,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14400,14400,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye',11.00,16.00,68,'male','L2Pet',40,4484,1641,12.25,3.18,40,43,30,21,20,25,0,0,1472,493,1041,462,278,0,432,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14401,14401,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye',11.00,16.00,70,'male','L2Pet',40,4673,1722,12.25,3.18,40,43,30,21,20,25,0,0,1587,515,1137,483,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14402,14402,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye',11.00,16.00,72,'male','L2Pet',40,4856,1804,13.43,3.09,40,43,30,21,20,25,0,0,1708,540,1238,505,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14403,14403,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye',11.00,16.00,74,'male','L2Pet',40,5032,1888,13.43,3.09,40,43,30,21,20,25,0,0,1828,563,1343,527,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14404,14404,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye',11.00,16.00,76,'male','L2Pet',40,5200,1972,13.43,3.09,40,43,30,21,20,25,0,0,1952,586,1449,548,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14405,14405,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye',11.00,16.00,78,'male','L2Pet',40,5373,2059,13.43,3.09,40,43,30,21,20,25,0,0,2084,609,1564,569,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14406,14406,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye',11.00,16.00,78,'male','L2Pet',40,5417,2081,13.43,3.09,40,43,30,21,20,25,0,0,2119,614,1594,574,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14407,14407,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye',11.00,16.00,78,'male','L2Pet',40,5462,2103,13.43,3.09,40,43,30,21,20,25,0,0,2154,620,1625,579,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14408,14408,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye',11.00,16.00,78,'male','L2Pet',40,5507,2126,13.43,3.09,40,43,30,21,20,25,0,0,2190,626,1656,584,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14409,14409,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye',11.00,16.00,79,'male','L2Pet',40,5552,2149,13.43,3.09,40,43,30,21,20,25,0,0,2226,632,1688,589,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14410,14410,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye',11.00,16.00,79,'male','L2Pet',40,5598,2172,13.43,3.09,40,43,30,21,20,25,0,0,2263,638,1721,594,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14411,14411,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye',11.00,16.00,79,'male','L2Pet',40,5644,2195,13.43,3.09,40,43,30,21,20,25,0,0,2301,644,1754,599,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14412,14412,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye',11.00,16.00,79,'male','L2Pet',40,5690,2219,13.43,3.09,40,43,30,21,20,25,0,0,2339,650,1788,604,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14413,14413,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye',11.00,16.00,80,'male','L2Pet',40,5737,2243,13.43,3.09,40,43,30,21,20,25,0,0,2378,656,1823,609,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14414,14414,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye',11.00,16.00,80,'male','L2Pet',40,5784,2267,13.43,3.09,40,43,30,21,20,25,0,0,2418,662,1858,614,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14415,14415,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye',11.00,16.00,80,'male','L2Pet',40,5832,2292,13.43,3.09,40,43,30,21,20,25,0,0,2458,668,1894,619,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14416,14416,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye',11.00,16.00,80,'male','L2Pet',40,5880,2317,13.43,3.09,40,43,30,21,20,25,0,0,2499,674,1931,624,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14417,14417,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye',11.00,16.00,81,'male','L2Pet',40,5928,2342,13.43,3.09,40,43,30,21,20,25,0,0,2541,680,1969,629,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14418,14418,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye',11.00,16.00,81,'male','L2Pet',40,5977,2367,13.43,3.09,40,43,30,21,20,25,0,0,2583,686,2007,635,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14419,14419,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye',11.00,16.00,81,'male','L2Pet',40,6026,2393,13.43,3.09,40,43,30,21,20,25,0,0,2626,692,2046,641,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14420,14420,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye',11.00,16.00,81,'male','L2Pet',40,6076,2419,13.43,3.09,40,43,30,21,20,25,0,0,2670,698,2086,647,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14421,14421,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye',11.00,16.00,82,'male','L2Pet',40,6126,2445,13.43,3.09,40,43,30,21,20,25,0,0,2715,704,2127,653,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14422,14422,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye',11.00,16.00,82,'male','L2Pet',40,6176,2471,13.43,3.09,40,43,30,21,20,25,0,0,2760,710,2168,659,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14423,14423,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye',11.00,16.00,82,'male','L2Pet',40,6227,2498,13.43,3.09,40,43,30,21,20,25,0,0,2806,716,2210,665,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14424,14424,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye',11.00,16.00,82,'male','L2Pet',40,6278,2525,13.43,3.09,40,43,30,21,20,25,0,0,2853,723,2253,671,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14425,14425,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye',11.00,16.00,83,'male','L2Pet',40,6330,2552,13.43,3.09,40,43,30,21,20,25,0,0,2901,730,2297,677,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14426,14426,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye',11.00,16.00,83,'male','L2Pet',40,6382,2580,13.43,3.09,40,43,30,21,20,25,0,0,2949,737,2342,683,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14427,14427,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye',11.00,16.00,83,'male','L2Pet',40,6435,2608,13.43,3.09,40,43,30,21,20,25,0,0,2998,744,2388,689,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14428,14428,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye',11.00,16.00,83,'male','L2Pet',40,6488,2636,13.43,3.09,40,43,30,21,20,25,0,0,3048,751,2435,695,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14429,14429,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye',11.00,16.00,84,'male','L2Pet',40,6541,2665,13.43,3.09,40,43,30,21,20,25,0,0,3099,758,2482,701,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14430,14430,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye',11.00,16.00,84,'male','L2Pet',40,6595,2694,13.43,3.09,40,43,30,21,20,25,0,0,3151,765,2530,707,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14431,14431,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye',11.00,16.00,84,'male','L2Pet',40,6649,2723,13.43,3.09,40,43,30,21,20,25,0,0,3204,772,2579,713,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14432,14432,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye',11.00,16.00,84,'male','L2Pet',40,6704,2753,13.43,3.09,40,43,30,21,20,25,0,0,3258,779,2629,719,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14433,14433,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye',11.00,16.00,85,'male','L2Pet',40,6759,2783,13.43,3.09,40,43,30,21,20,25,0,0,3312,786,2680,725,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14434,14434,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye',11.00,16.00,85,'male','L2Pet',40,6815,2813,13.43,3.09,40,43,30,21,20,25,0,0,3367,793,2732,731,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14435,14435,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn',9.00,25.05,58,'male','L2Pet',40,2889,1251,10.27,2.45,40,43,30,21,20,25,0,0,779,348,428,327,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14436,14436,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn',9.00,25.05,60,'male','L2Pet',40,3054,1327,10.27,2.45,40,43,30,21,20,25,0,0,860,368,477,345,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14437,14437,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn',9.00,25.05,62,'male','L2Pet',40,3219,1404,12.25,3.18,40,43,30,21,20,25,0,0,944,388,531,363,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14438,14438,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn',9.00,25.05,64,'male','L2Pet',40,3384,1482,12.25,3.18,40,43,30,21,20,25,0,0,1031,408,588,381,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14439,14439,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn',9.00,25.05,66,'male','L2Pet',40,3546,1561,12.25,3.18,40,43,30,21,20,25,0,0,1121,427,649,400,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14440,14440,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn',9.00,25.05,68,'male','L2Pet',40,3706,1641,12.25,3.18,40,43,30,21,20,25,0,0,1217,449,713,420,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14441,14441,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn',9.00,25.05,70,'male','L2Pet',40,3862,1722,12.25,3.18,40,43,30,21,20,25,0,0,1312,469,779,439,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14442,14442,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn',9.00,25.05,72,'male','L2Pet',40,4013,1804,13.43,3.09,40,43,30,21,20,25,0,0,1412,491,848,459,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14443,14443,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn',9.00,25.05,74,'male','L2Pet',40,4158,1888,13.43,3.09,40,43,30,21,20,25,0,0,1511,511,920,479,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14444,14444,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn',9.00,25.05,76,'male','L2Pet',40,4297,1972,13.43,3.09,40,43,30,21,20,25,0,0,1613,532,993,498,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14449,14449,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn',9.00,25.05,78,'male','L2Pet',40,4440,2059,13.43,3.09,40,43,30,21,20,25,0,0,1721,553,1071,517,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14450,14450,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn',9.00,25.05,78,'male','L2Pet',40,4476,2081,13.43,3.09,40,43,30,21,20,25,0,0,1749,558,1092,521,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14451,14451,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn',9.00,25.05,78,'male','L2Pet',40,4513,2103,13.43,3.09,40,43,30,21,20,25,0,0,1778,563,1113,525,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14452,14452,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn',9.00,25.05,78,'male','L2Pet',40,4550,2126,13.43,3.09,40,43,30,21,20,25,0,0,1807,568,1134,530,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14453,14453,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn',9.00,25.05,79,'male','L2Pet',40,4587,2149,13.43,3.09,40,43,30,21,20,25,0,0,1837,573,1156,535,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14454,14454,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn',9.00,25.05,79,'male','L2Pet',40,4625,2172,13.43,3.09,40,43,30,21,20,25,0,0,1867,578,1178,540,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14455,14455,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn',9.00,25.05,79,'male','L2Pet',40,4663,2195,13.43,3.09,40,43,30,21,20,25,0,0,1898,583,1201,545,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14456,14456,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn',9.00,25.05,79,'male','L2Pet',40,4701,2219,13.43,3.09,40,43,30,21,20,25,0,0,1929,588,1224,550,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14457,14457,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn',9.00,25.05,80,'male','L2Pet',40,4740,2243,13.43,3.09,40,43,30,21,20,25,0,0,1961,593,1248,555,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14458,14458,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn',9.00,25.05,80,'male','L2Pet',40,4779,2267,13.43,3.09,40,43,30,21,20,25,0,0,1993,598,1272,560,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14459,14459,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn',9.00,25.05,80,'male','L2Pet',40,4818,2292,13.43,3.09,40,43,30,21,20,25,0,0,2026,603,1296,565,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14460,14460,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn',9.00,25.05,80,'male','L2Pet',40,4858,2317,13.43,3.09,40,43,30,21,20,25,0,0,2059,608,1321,570,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14461,14461,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn',9.00,25.05,81,'male','L2Pet',40,4898,2342,13.43,3.09,40,43,30,21,20,25,0,0,2093,614,1346,575,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14462,14462,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn',9.00,25.05,81,'male','L2Pet',40,4938,2367,13.43,3.09,40,43,30,21,20,25,0,0,2128,620,1372,580,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14463,14463,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn',9.00,25.05,81,'male','L2Pet',40,4979,2393,13.43,3.09,40,43,30,21,20,25,0,0,2163,626,1398,585,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14464,14464,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn',9.00,25.05,81,'male','L2Pet',40,5020,2419,13.43,3.09,40,43,30,21,20,25,0,0,2199,632,1425,590,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14465,14465,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn',9.00,25.05,82,'male','L2Pet',40,5061,2445,13.43,3.09,40,43,30,21,20,25,0,0,2235,638,1452,595,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14466,14466,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn',9.00,25.05,82,'male','L2Pet',40,5103,2471,13.43,3.09,40,43,30,21,20,25,0,0,2272,644,1480,600,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14467,14467,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn',9.00,25.05,82,'male','L2Pet',40,5145,2498,13.43,3.09,40,43,30,21,20,25,0,0,2310,650,1509,605,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14468,14468,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn',9.00,25.05,82,'male','L2Pet',40,5187,2525,13.43,3.09,40,43,30,21,20,25,0,0,2348,656,1538,610,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14469,14469,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn',9.00,25.05,83,'male','L2Pet',40,5230,2552,13.43,3.09,40,43,30,21,20,25,0,0,2387,662,1568,615,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14470,14470,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn',9.00,25.05,83,'male','L2Pet',40,5273,2580,13.43,3.09,40,43,30,21,20,25,0,0,2426,668,1598,620,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14471,14471,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn',9.00,25.05,83,'male','L2Pet',40,5316,2608,13.43,3.09,40,43,30,21,20,25,0,0,2466,674,1629,625,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14472,14472,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn',9.00,25.05,83,'male','L2Pet',40,5360,2636,13.43,3.09,40,43,30,21,20,25,0,0,2507,680,1660,630,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14473,14473,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn',9.00,25.05,84,'male','L2Pet',40,5404,2665,13.43,3.09,40,43,30,21,20,25,0,0,2548,686,1692,636,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14474,14474,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn',9.00,25.05,84,'male','L2Pet',40,5448,2694,13.43,3.09,40,43,30,21,20,25,0,0,2590,692,1725,642,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14475,14475,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn',9.00,25.05,84,'male','L2Pet',40,5493,2723,13.43,3.09,40,43,30,21,20,25,0,0,2633,698,1758,648,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14476,14476,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn',9.00,25.05,84,'male','L2Pet',40,5538,2753,13.43,3.09,40,43,30,21,20,25,0,0,2677,704,1792,654,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14477,14477,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn',9.00,25.05,85,'male','L2Pet',40,5584,2783,13.43,3.09,40,43,30,21,20,25,0,0,2721,710,1827,660,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14478,14478,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn',9.00,25.05,85,'male','L2Pet',40,5630,2813,13.43,3.09,40,43,30,21,20,25,0,0,2766,717,1862,666,278,0,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(14479,14479,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,22,'male','L2Pet',40,984,279,5.53,1.53,40,43,30,21,20,25,0,0,82,102,28,95,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14480,14480,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,32,'male','L2Pet',40,1700,458,7.11,2.24,40,43,30,21,20,25,0,0,186,151,69,140,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14481,14481,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,42,'male','L2Pet',40,2673,679,9.09,2.14,40,43,30,21,20,25,0,0,376,236,152,221,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14482,14482,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,50,'male','L2Pet',40,3614,957,9.09,2.14,40,43,30,21,20,25,0,0,615,305,263,285,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14483,14483,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,58,'male','L2Pet',40,4651,1251,10.27,2.45,40,43,30,21,20,25,0,0,943,383,428,360,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14484,14484,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,27,'male','L2Pet',40,1310,367,5.53,1.53,40,43,30,21,20,25,0,0,124,125,45,117,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14485,14485,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,37,'male','L2Pet',40,2155,533,7.11,2.24,40,43,30,21,20,25,0,0,267,181,104,169,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14486,14486,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,46,'male','L2Pet',40,3128,816,9.09,2.14,40,43,30,21,20,25,0,0,486,270,202,252,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14487,14487,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,54,'male','L2Pet',40,4125,1102,10.27,2.45,40,43,30,21,20,25,0,0,768,342,339,322,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14488,14488,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,60,'male','L2Pet',40,4917,1327,10.27,2.45,40,43,30,21,20,25,0,0,1040,404,477,379,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14489,14489,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,62,'male','L2Pet',40,5183,1404,12.25,3.18,40,43,30,21,20,25,0,0,1142,426,531,399,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14490,14490,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,64,'male','L2Pet',40,5448,1482,12.25,3.18,40,43,30,21,20,25,0,0,1248,449,588,420,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14491,14491,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,66,'male','L2Pet',40,5710,1561,12.25,3.18,40,43,30,21,20,25,0,0,1357,470,649,440,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14492,14492,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,68,'male','L2Pet',40,5967,1641,12.25,3.18,40,43,30,21,20,25,0,0,1472,493,713,462,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14493,14493,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,70,'male','L2Pet',40,6218,1722,12.25,3.18,40,43,30,21,20,25,0,0,1588,515,779,483,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14494,14494,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,72,'male','L2Pet',40,6461,1804,13.43,3.09,40,43,30,21,20,25,0,0,1708,540,848,505,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14495,14495,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,74,'male','L2Pet',40,6695,1888,13.43,3.09,40,43,30,21,20,25,0,0,1829,563,920,527,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14496,14496,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,76,'male','L2Pet',40,6919,1972,13.43,3.09,40,43,30,21,20,25,0,0,1952,586,993,548,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14497,14497,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,78,'male','L2Pet',40,7150,2059,13.43,3.09,40,43,30,21,20,25,0,0,2083,609,1071,569,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14498,14498,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,78,'male','L2Pet',40,7209,2081,13.43,3.09,40,43,30,21,20,25,0,0,2117,614,1092,574,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14499,14499,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,78,'male','L2Pet',40,7269,2103,13.43,3.09,40,43,30,21,20,25,0,0,2152,620,1113,579,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14500,14500,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,78,'male','L2Pet',40,7329,2126,13.43,3.09,40,43,30,21,20,25,0,0,2188,626,1134,584,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14501,14501,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,79,'male','L2Pet',40,7390,2149,13.43,3.09,40,43,30,21,20,25,0,0,2224,632,1156,589,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14502,14502,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,79,'male','L2Pet',40,7451,2172,13.43,3.09,40,43,30,21,20,25,0,0,2261,638,1178,594,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14503,14503,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,79,'male','L2Pet',40,7513,2195,13.43,3.09,40,43,30,21,20,25,0,0,2298,644,1201,599,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14504,14504,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,79,'male','L2Pet',40,7575,2219,13.43,3.09,40,43,30,21,20,25,0,0,2336,650,1224,604,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14505,14505,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,80,'male','L2Pet',40,7638,2243,13.43,3.09,40,43,30,21,20,25,0,0,2375,656,1248,609,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14506,14506,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,80,'male','L2Pet',40,7701,2267,13.43,3.09,40,43,30,21,20,25,0,0,2414,662,1272,614,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14507,14507,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,80,'male','L2Pet',40,7765,2292,13.43,3.09,40,43,30,21,20,25,0,0,2454,668,1296,619,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14508,14508,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,80,'male','L2Pet',40,7829,2317,13.43,3.09,40,43,30,21,20,25,0,0,2495,674,1321,624,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14509,14509,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,81,'male','L2Pet',40,7894,2342,13.43,3.09,40,43,30,21,20,25,0,0,2536,680,1346,629,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14510,14510,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,81,'male','L2Pet',40,7959,2367,13.43,3.09,40,43,30,21,20,25,0,0,2578,686,1372,635,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14511,14511,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,81,'male','L2Pet',40,8025,2393,13.43,3.09,40,43,30,21,20,25,0,0,2621,692,1398,641,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14512,14512,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,81,'male','L2Pet',40,8091,2419,13.43,3.09,40,43,30,21,20,25,0,0,2664,698,1425,647,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14513,14513,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,82,'male','L2Pet',40,8158,2445,13.43,3.09,40,43,30,21,20,25,0,0,2708,704,1452,653,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14514,14514,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,82,'male','L2Pet',40,8226,2471,13.43,3.09,40,43,30,21,20,25,0,0,2753,710,1480,659,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14515,14515,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,82,'male','L2Pet',40,8294,2498,13.43,3.09,40,43,30,21,20,25,0,0,2799,716,1509,665,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14516,14516,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,82,'male','L2Pet',40,8363,2525,13.43,3.09,40,43,30,21,20,25,0,0,2845,723,1538,671,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14517,14517,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,83,'male','L2Pet',40,8432,2552,13.43,3.09,40,43,30,21,20,25,0,0,2892,730,1568,677,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14518,14518,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,83,'male','L2Pet',40,8502,2580,13.43,3.09,40,43,30,21,20,25,0,0,2940,737,1598,683,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14519,14519,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,83,'male','L2Pet',40,8572,2608,13.43,3.09,40,43,30,21,20,25,0,0,2989,744,1629,689,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14520,14520,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,83,'male','L2Pet',40,8643,2636,13.43,3.09,40,43,30,21,20,25,0,0,3039,751,1660,695,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14521,14521,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,84,'male','L2Pet',40,8715,2665,13.43,3.09,40,43,30,21,20,25,0,0,3089,758,1692,701,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14522,14522,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,84,'male','L2Pet',40,8787,2694,13.43,3.09,40,43,30,21,20,25,0,0,3140,765,1725,707,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14523,14523,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,84,'male','L2Pet',40,8860,2723,13.43,3.09,40,43,30,21,20,25,0,0,3192,772,1758,713,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14524,14524,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,84,'male','L2Pet',40,8933,2753,13.43,3.09,40,43,30,21,20,25,0,0,3245,779,1792,719,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14525,14525,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,85,'male','L2Pet',40,9007,2783,13.43,3.09,40,43,30,21,20,25,0,0,3299,786,1827,725,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14526,14526,'Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,85,'male','L2Pet',40,9082,2813,13.43,3.09,40,43,30,21,20,25,0,0,3354,793,1862,731,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14527,14527,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,27,'female','L2Pet',40,1310,367,5.53,1.53,40,43,30,21,20,25,0,0,113,125,54,117,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14528,14528,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,37,'female','L2Pet',40,2155,553,7.11,2.24,40,43,30,21,20,25,0,0,242,181,126,169,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14529,14529,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,47,'female','L2Pet',40,3128,816,9.09,2.14,40,43,30,21,20,25,0,0,441,270,244,252,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14530,14530,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,54,'female','L2Pet',40,4125,1102,10.27,2.45,40,43,30,21,20,25,0,0,698,342,410,322,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14531,14531,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,22,'female','L2Pet',40,984,279,5.53,1.53,40,43,30,21,20,25,0,0,74,102,34,95,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14532,14532,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,32,'female','L2Pet',40,1700,458,7.11,2.24,40,43,30,21,20,25,0,0,169,151,83,140,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14533,14533,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,42,'female','L2Pet',40,2673,679,9.09,2.14,40,43,30,21,20,25,0,0,342,236,183,221,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14534,14534,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,50,'female','L2Pet',40,3614,957,9.09,2.14,40,43,30,21,20,25,0,0,559,305,319,285,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14535,14535,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,58,'female','L2Pet',40,4651,1251,10.27,2.45,40,43,30,21,20,25,0,0,857,383,518,360,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14536,14536,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,60,'female','L2Pet',40,4917,1327,10.27,2.45,40,43,30,21,20,25,0,0,946,404,578,379,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14537,14537,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,62,'female','L2Pet',40,5183,1404,12.25,3.18,40,43,30,21,20,25,0,0,1038,426,642,399,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14538,14538,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,64,'female','L2Pet',40,5448,1482,12.25,3.18,40,43,30,21,20,25,0,0,1135,449,711,420,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14539,14539,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,66,'female','L2Pet',40,5710,1561,12.25,3.18,40,43,30,21,20,25,0,0,1233,470,785,440,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14540,14540,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,68,'female','L2Pet',40,5967,1641,12.25,3.18,40,43,30,21,20,25,0,0,1338,493,862,462,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14541,14541,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,70,'female','L2Pet',40,6218,1722,12.25,3.18,40,43,30,21,20,25,0,0,1443,515,943,483,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14542,14542,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,72,'female','L2Pet',40,6461,1804,13.43,3.09,40,43,30,21,20,25,0,0,1553,540,1026,505,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14543,14543,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,74,'female','L2Pet',40,6695,1888,13.43,3.09,40,43,30,21,20,25,0,0,1663,563,1113,527,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14544,14544,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,76,'female','L2Pet',40,6919,1972,13.43,3.09,40,43,30,21,20,25,0,0,1775,586,1201,548,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14545,14545,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,78,'female','L2Pet',40,7150,2059,13.43,3.09,40,43,30,21,20,25,0,0,1894,609,1295,569,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14546,14546,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,78,'female','L2Pet',40,7209,2081,13.43,3.09,40,43,30,21,20,25,0,0,1925,614,1320,574,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14547,14547,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,78,'female','L2Pet',40,7269,2103,13.43,3.09,40,43,30,21,20,25,0,0,1957,620,1345,579,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14548,14548,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,78,'female','L2Pet',40,7329,2126,13.43,3.09,40,43,30,21,20,25,0,0,1989,626,1371,584,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14549,14549,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,79,'female','L2Pet',40,7390,2149,13.43,3.09,40,43,30,21,20,25,0,0,2022,632,1397,589,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14550,14550,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,79,'female','L2Pet',40,7451,2172,13.43,3.09,40,43,30,21,20,25,0,0,2055,638,1424,594,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14551,14551,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,79,'female','L2Pet',40,7513,2195,13.43,3.09,40,43,30,21,20,25,0,0,2089,644,1451,599,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14552,14552,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,79,'female','L2Pet',40,7575,2219,13.43,3.09,40,43,30,21,20,25,0,0,2124,650,1479,604,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14553,14553,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,80,'female','L2Pet',40,7638,2243,13.43,3.09,40,43,30,21,20,25,0,0,2159,656,1507,609,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14554,14554,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,80,'female','L2Pet',40,7701,2267,13.43,3.09,40,43,30,21,20,25,0,0,2195,662,1536,614,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14555,14555,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,80,'female','L2Pet',40,7765,2292,13.43,3.09,40,43,30,21,20,25,0,0,2231,668,1566,619,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14556,14556,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,80,'female','L2Pet',40,7829,2317,13.43,3.09,40,43,30,21,20,25,0,0,2268,674,1596,624,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14557,14557,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,81,'female','L2Pet',40,7894,2342,13.43,3.09,40,43,30,21,20,25,0,0,2306,680,1627,629,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14558,14558,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,81,'female','L2Pet',40,7959,2367,13.43,3.09,40,43,30,21,20,25,0,0,2344,686,1658,635,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14559,14559,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,81,'female','L2Pet',40,8025,2393,13.43,3.09,40,43,30,21,20,25,0,0,2383,692,1690,641,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14560,14560,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,81,'female','L2Pet',40,8091,2419,13.43,3.09,40,43,30,21,20,25,0,0,2422,698,1723,647,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14561,14561,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,82,'female','L2Pet',40,8158,2445,13.43,3.09,40,43,30,21,20,25,0,0,2462,704,1756,653,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14562,14562,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,82,'female','L2Pet',40,8226,2471,13.43,3.09,40,43,30,21,20,25,0,0,2503,710,1790,659,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14563,14563,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,82,'female','L2Pet',40,8294,2498,13.43,3.09,40,43,30,21,20,25,0,0,2544,716,1825,665,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14564,14564,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,82,'female','L2Pet',40,8363,2525,13.43,3.09,40,43,30,21,20,25,0,0,2586,723,1860,671,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14565,14565,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,83,'female','L2Pet',40,8432,2552,13.43,3.09,40,43,30,21,20,25,0,0,2629,730,1896,677,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14566,14566,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,83,'female','L2Pet',40,8502,2580,13.43,3.09,40,43,30,21,20,25,0,0,2673,737,1933,683,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14567,14567,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,83,'female','L2Pet',40,8572,2608,13.43,3.09,40,43,30,21,20,25,0,0,2717,744,1970,689,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14568,14568,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,83,'female','L2Pet',40,8643,2636,13.43,3.09,40,43,30,21,20,25,0,0,2762,751,2008,695,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14569,14569,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,84,'female','L2Pet',40,8715,2665,13.43,3.09,40,43,30,21,20,25,0,0,2808,758,2047,701,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14570,14570,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,84,'female','L2Pet',40,8787,2694,13.43,3.09,40,43,30,21,20,25,0,0,2855,765,2087,707,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14571,14571,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,84,'female','L2Pet',40,8860,2723,13.43,3.09,40,43,30,21,20,25,0,0,2902,772,2127,713,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14572,14572,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,84,'female','L2Pet',40,8933,2753,13.43,3.09,40,43,30,21,20,25,0,0,2950,779,2168,719,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14573,14573,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,85,'female','L2Pet',40,9007,2783,13.43,3.09,40,43,30,21,20,25,0,0,2999,786,2210,725,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14574,14574,'Silhouette',0,'',0,'LineageMonster.silhouette',8.00,23.00,85,'female','L2Pet',40,9082,2813,13.43,3.09,40,43,30,21,20,25,0,0,3049,793,2253,731,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(14575,14575,'Soulless',0,'',0,'LineageMonster.shadeless',7.00,28.00,42,'male','L2Pet',40,2008,679,9.09,2.14,40,43,30,21,20,25,0,0,376,236,221,221,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14576,14576,'Soulless',0,'',0,'LineageMonster.shadeless',7.00,28.00,46,'male','L2Pet',40,2351,816,9.09,2.14,40,43,30,21,20,25,0,0,486,270,295,252,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14577,14577,'Soulless',0,'',0,'LineageMonster.shadeless',7.00,28.00,50,'male','L2Pet',40,2716,957,9.09,2.14,40,43,30,21,20,25,0,0,615,305,384,285,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14578,14578,'Soulless',0,'',0,'LineageMonster.shadeless',7.00,28.00,54,'male','L2Pet',40,3100,1102,10.27,2.45,40,43,30,21,20,25,0,0,768,342,495,322,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14579,14579,'Soulless',0,'',0,'LineageMonster.shadeless',7.00,28.00,58,'male','L2Pet',40,3496,1251,10.27,2.45,40,43,30,21,20,25,0,0,943,383,625,360,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14580,14580,'Soulless',0,'',0,'LineageMonster.shadeless',7.00,28.00,60,'male','L2Pet',40,3695,1327,10.27,2.45,40,43,30,21,20,25,0,0,1040,404,697,379,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14581,14581,'Soulless',0,'',0,'LineageMonster.shadeless',7.00,28.00,62,'male','L2Pet',40,3895,1404,12.25,3.18,40,43,30,21,20,25,0,0,1142,426,775,399,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14582,14582,'Soulless',0,'',0,'LineageMonster.shadeless',7.00,28.00,64,'male','L2Pet',40,4094,1482,12.25,3.18,40,43,30,21,20,25,0,0,1248,449,858,420,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14583,14583,'Soulless',0,'',0,'LineageMonster.shadeless',7.00,28.00,66,'male','L2Pet',40,4291,1561,12.25,3.18,40,43,30,21,20,25,0,0,1357,470,948,440,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14584,14584,'Soulless',0,'',0,'LineageMonster.shadeless',7.00,28.00,68,'male','L2Pet',40,4484,1641,12.25,3.18,40,43,30,21,20,25,0,0,1472,493,1041,462,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14585,14585,'Soulless',0,'',0,'LineageMonster.shadeless',7.00,28.00,70,'male','L2Pet',40,4673,1722,12.25,3.18,40,43,30,21,20,25,0,0,1588,515,1138,483,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14586,14586,'Soulless',0,'',0,'LineageMonster.shadeless',7.00,28.00,72,'male','L2Pet',40,4856,1804,13.43,3.09,40,43,30,21,20,25,0,0,1709,540,1238,505,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14587,14587,'Soulless',0,'',0,'LineageMonster.shadeless',7.00,28.00,74,'male','L2Pet',40,5032,1888,13.43,3.09,40,43,30,21,20,25,0,0,1829,563,1343,527,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14588,14588,'Soulless',0,'',0,'LineageMonster.shadeless',7.00,28.00,76,'male','L2Pet',40,5200,1972,13.43,3.09,40,43,30,21,20,25,0,0,1952,586,1450,548,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14589,14589,'Soulless',0,'',0,'LineageMonster.shadeless',7.00,28.00,78,'male','L2Pet',40,5373,2059,13.43,3.09,40,43,30,21,20,25,0,0,2085,609,1565,569,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14590,14590,'Soulless',0,'',0,'LineageMonster.shadeless',7.00,28.00,78,'male','L2Pet',40,5417,2081,13.43,3.09,40,43,30,21,20,25,0,0,2120,614,1595,574,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14591,14591,'Soulless',0,'',0,'LineageMonster.shadeless',7.00,28.00,78,'male','L2Pet',40,5462,2103,13.43,3.09,40,43,30,21,20,25,0,0,2155,620,1626,579,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14592,14592,'Soulless',0,'',0,'LineageMonster.shadeless',7.00,28.00,78,'male','L2Pet',40,5507,2126,13.43,3.09,40,43,30,21,20,25,0,0,2191,626,1658,584,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14593,14593,'Soulless',0,'',0,'LineageMonster.shadeless',7.00,28.00,79,'male','L2Pet',40,5552,2149,13.43,3.09,40,43,30,21,20,25,0,0,2228,632,1690,589,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14594,14594,'Soulless',0,'',0,'LineageMonster.shadeless',7.00,28.00,79,'male','L2Pet',40,5598,2172,13.43,3.09,40,43,30,21,20,25,0,0,2265,638,1723,594,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14595,14595,'Soulless',0,'',0,'LineageMonster.shadeless',7.00,28.00,79,'male','L2Pet',40,5644,2195,13.43,3.09,40,43,30,21,20,25,0,0,2303,644,1756,599,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14596,14596,'Soulless',0,'',0,'LineageMonster.shadeless',7.00,28.00,79,'male','L2Pet',40,5690,2219,13.43,3.09,40,43,30,21,20,25,0,0,2341,650,1790,604,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14597,14597,'Soulless',0,'',0,'LineageMonster.shadeless',7.00,28.00,80,'male','L2Pet',40,5737,2243,13.43,3.09,40,43,30,21,20,25,0,0,2380,656,1825,609,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14598,14598,'Soulless',0,'',0,'LineageMonster.shadeless',7.00,28.00,80,'male','L2Pet',40,5784,2267,13.43,3.09,40,43,30,21,20,25,0,0,2420,662,1860,614,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14599,14599,'Soulless',0,'',0,'LineageMonster.shadeless',7.00,28.00,80,'male','L2Pet',40,5832,2292,13.43,3.09,40,43,30,21,20,25,0,0,2460,668,1896,619,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14600,14600,'Soulless',0,'',0,'LineageMonster.shadeless',7.00,28.00,80,'male','L2Pet',40,5880,2317,13.43,3.09,40,43,30,21,20,25,0,0,2501,674,1933,624,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14601,14601,'Soulless',0,'',0,'LineageMonster.shadeless',7.00,28.00,81,'male','L2Pet',40,5928,2342,13.43,3.09,40,43,30,21,20,25,0,0,2543,680,1971,629,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14602,14602,'Soulless',0,'',0,'LineageMonster.shadeless',7.00,28.00,81,'male','L2Pet',40,5977,2367,13.43,3.09,40,43,30,21,20,25,0,0,2585,686,2009,635,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14603,14603,'Soulless',0,'',0,'LineageMonster.shadeless',7.00,28.00,81,'male','L2Pet',40,6026,2393,13.43,3.09,40,43,30,21,20,25,0,0,2628,692,2048,641,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14604,14604,'Soulless',0,'',0,'LineageMonster.shadeless',7.00,28.00,81,'male','L2Pet',40,6076,2419,13.43,3.09,40,43,30,21,20,25,0,0,2672,698,2088,647,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14605,14605,'Soulless',0,'',0,'LineageMonster.shadeless',7.00,28.00,82,'male','L2Pet',40,6126,2445,13.43,3.09,40,43,30,21,20,25,0,0,2717,704,2129,653,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14606,14606,'Soulless',0,'',0,'LineageMonster.shadeless',7.00,28.00,82,'male','L2Pet',40,6176,2471,13.43,3.09,40,43,30,21,20,25,0,0,2762,710,2170,659,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14607,14607,'Soulless',0,'',0,'LineageMonster.shadeless',7.00,28.00,82,'male','L2Pet',40,6227,2498,13.43,3.09,40,43,30,21,20,25,0,0,2808,716,2212,665,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14608,14608,'Soulless',0,'',0,'LineageMonster.shadeless',7.00,28.00,82,'male','L2Pet',40,6278,2525,13.43,3.09,40,43,30,21,20,25,0,0,2855,723,2255,671,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14609,14609,'Soulless',0,'',0,'LineageMonster.shadeless',7.00,28.00,83,'male','L2Pet',40,6330,2552,13.43,3.09,40,43,30,21,20,25,0,0,2903,730,2299,677,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14610,14610,'Soulless',0,'',0,'LineageMonster.shadeless',7.00,28.00,83,'male','L2Pet',40,6382,2580,13.43,3.09,40,43,30,21,20,25,0,0,2952,737,2344,683,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14611,14611,'Soulless',0,'',0,'LineageMonster.shadeless',7.00,28.00,83,'male','L2Pet',40,6435,2608,13.43,3.09,40,43,30,21,20,25,0,0,3001,744,2390,689,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14612,14612,'Soulless',0,'',0,'LineageMonster.shadeless',7.00,28.00,83,'male','L2Pet',40,6488,2636,13.43,3.09,40,43,30,21,20,25,0,0,3051,751,2437,695,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14613,14613,'Soulless',0,'',0,'LineageMonster.shadeless',7.00,28.00,84,'male','L2Pet',40,6541,2665,13.43,3.09,40,43,30,21,20,25,0,0,3102,758,2485,701,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14614,14614,'Soulless',0,'',0,'LineageMonster.shadeless',7.00,28.00,84,'male','L2Pet',40,6595,2694,13.43,3.09,40,43,30,21,20,25,0,0,3154,765,2533,707,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14615,14615,'Soulless',0,'',0,'LineageMonster.shadeless',7.00,28.00,84,'male','L2Pet',40,6649,2723,13.43,3.09,40,43,30,21,20,25,0,0,3207,772,2582,713,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14616,14616,'Soulless',0,'',0,'LineageMonster.shadeless',7.00,28.00,84,'male','L2Pet',40,6704,2753,13.43,3.09,40,43,30,21,20,25,0,0,3261,779,2632,719,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14617,14617,'Soulless',0,'',0,'LineageMonster.shadeless',7.00,28.00,85,'male','L2Pet',40,6759,2783,13.43,3.09,40,43,30,21,20,25,0,0,3316,786,2683,725,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14618,14618,'Soulless',0,'',0,'LineageMonster.shadeless',7.00,28.00,85,'male','L2Pet',40,6815,2813,13.43,3.09,40,43,30,21,20,25,0,0,3372,793,2735,731,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14619,14619,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow',10.00,35.05,58,'male','L2Pet',40,5778,1251,9.09,2.45,40,43,30,21,20,25,0,0,779,560,428,527,278,0,333,0,0,0,0,33,187,0,0,'LAST_HIT','false'),
(14620,14620,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow',10.00,35.05,60,'male','L2Pet',40,6109,1327,9.09,2.45,40,43,30,21,20,25,0,0,860,592,477,555,278,0,333,0,0,0,0,33,187,0,0,'LAST_HIT','false'),
(14621,14621,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow',10.00,35.05,62,'male','L2Pet',40,6439,1404,9.09,3.18,40,43,30,21,20,25,0,0,944,624,531,585,278,0,333,0,0,0,0,33,187,0,0,'LAST_HIT','false'),
(14622,14622,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow',10.00,35.05,64,'male','L2Pet',40,6768,1482,10.27,3.18,40,43,30,21,20,25,0,0,1031,657,588,614,278,0,333,0,0,0,0,33,187,0,0,'LAST_HIT','false'),
(14623,14623,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow',10.00,35.05,66,'male','L2Pet',40,7093,1561,10.27,3.18,40,43,30,21,20,25,0,0,1121,688,649,645,278,0,333,0,0,0,0,33,187,0,0,'LAST_HIT','false'),
(14624,14624,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow',10.00,35.05,68,'male','L2Pet',40,7412,1641,10.27,3.18,40,43,30,21,20,25,0,0,1217,722,713,676,278,0,333,0,0,0,0,33,187,0,0,'LAST_HIT','false'),
(14625,14625,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow',10.00,35.05,70,'male','L2Pet',40,7724,1722,12.25,3.18,40,43,30,21,20,25,0,0,1312,755,779,707,278,0,333,0,0,0,0,33,187,0,0,'LAST_HIT','false'),
(14626,14626,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow',10.00,35.05,72,'male','L2Pet',40,8026,1804,12.25,3.09,40,43,30,21,20,25,0,0,1412,790,848,739,278,0,333,0,0,0,0,33,187,0,0,'LAST_HIT','false'),
(14627,14627,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow',10.00,35.05,74,'male','L2Pet',40,8317,1888,12.25,3.09,40,43,30,21,20,25,0,0,1511,822,920,771,278,0,333,0,0,0,0,33,187,0,0,'LAST_HIT','false'),
(14628,14628,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow',10.00,35.05,76,'male','L2Pet',40,8595,1972,12.25,3.09,40,43,30,21,20,25,0,0,1613,856,993,802,278,0,333,0,0,0,0,33,187,0,0,'LAST_HIT','false'),
(14633,14633,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow',10.00,35.05,78,'male','L2Pet',40,8882,2059,13.43,3.09,40,43,30,21,20,25,0,0,1721,891,1071,833,278,0,333,0,0,0,0,33,187,0,0,'LAST_HIT','false'),
(14634,14634,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow',10.00,35.05,78,'male','L2Pet',40,8956,2081,13.43,3.09,40,43,30,21,20,25,0,0,1749,899,1092,841,278,0,333,0,0,0,0,33,187,0,0,'LAST_HIT','false'),
(14635,14635,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow',10.00,35.05,78,'male','L2Pet',40,9030,2103,13.43,3.09,40,43,30,21,20,25,0,0,1778,908,1113,849,278,0,333,0,0,0,0,33,187,0,0,'LAST_HIT','false'),
(14636,14636,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow',10.00,35.05,78,'male','L2Pet',40,9105,2126,13.43,3.09,40,43,30,21,20,25,0,0,1807,917,1134,857,278,0,333,0,0,0,0,33,187,0,0,'LAST_HIT','false'),
(14637,14637,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow',10.00,35.05,79,'male','L2Pet',40,9181,2149,13.43,3.09,40,43,30,21,20,25,0,0,1837,926,1156,865,278,0,333,0,0,0,0,33,187,0,0,'LAST_HIT','false'),
(14638,14638,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow',10.00,35.05,79,'male','L2Pet',40,9257,2172,13.43,3.09,40,43,30,21,20,25,0,0,1867,935,1178,873,278,0,333,0,0,0,0,33,187,0,0,'LAST_HIT','false'),
(14639,14639,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow',10.00,35.05,79,'male','L2Pet',40,9334,2195,13.43,3.09,40,43,30,21,20,25,0,0,1898,944,1201,881,278,0,333,0,0,0,0,33,187,0,0,'LAST_HIT','false'),
(14640,14640,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow',10.00,35.05,79,'male','L2Pet',40,9411,2219,13.43,3.09,40,43,30,21,20,25,0,0,1929,953,1224,889,278,0,333,0,0,0,0,33,187,0,0,'LAST_HIT','false'),
(14641,14641,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow',10.00,35.05,80,'male','L2Pet',40,9489,2243,13.43,3.09,40,43,30,21,20,25,0,0,1961,962,1248,897,278,0,333,0,0,0,0,33,187,0,0,'LAST_HIT','false'),
(14642,14642,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow',10.00,35.05,80,'male','L2Pet',40,9568,2267,13.43,3.09,40,43,30,21,20,25,0,0,1993,971,1272,905,278,0,333,0,0,0,0,33,187,0,0,'LAST_HIT','false'),
(14643,14643,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow',10.00,35.05,80,'male','L2Pet',40,9647,2292,13.43,3.09,40,43,30,21,20,25,0,0,2026,980,1296,913,278,0,333,0,0,0,0,33,187,0,0,'LAST_HIT','false'),
(14644,14644,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow',10.00,35.05,80,'male','L2Pet',40,9727,2317,13.43,3.09,40,43,30,21,20,25,0,0,2059,989,1321,921,278,0,333,0,0,0,0,33,187,0,0,'LAST_HIT','false'),
(14645,14645,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow',10.00,35.05,81,'male','L2Pet',40,9808,2342,13.43,3.09,40,43,30,21,20,25,0,0,2093,998,1346,929,278,0,333,0,0,0,0,33,187,0,0,'LAST_HIT','false'),
(14646,14646,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow',10.00,35.05,81,'male','L2Pet',40,9889,2367,13.43,3.09,40,43,30,21,20,25,0,0,2128,1008,1372,937,278,0,333,0,0,0,0,33,187,0,0,'LAST_HIT','false'),
(14647,14647,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow',10.00,35.05,81,'male','L2Pet',40,9971,2393,13.43,3.09,40,43,30,21,20,25,0,0,2163,1018,1398,946,278,0,333,0,0,0,0,33,187,0,0,'LAST_HIT','false'),
(14648,14648,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow',10.00,35.05,81,'male','L2Pet',40,10054,2419,13.43,3.09,40,43,30,21,20,25,0,0,2199,1028,1425,955,278,0,333,0,0,0,0,33,187,0,0,'LAST_HIT','false'),
(14649,14649,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow',10.00,35.05,82,'male','L2Pet',40,10137,2445,13.43,3.09,40,43,30,21,20,25,0,0,2235,1038,1452,964,278,0,333,0,0,0,0,33,187,0,0,'LAST_HIT','false'),
(14650,14650,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow',10.00,35.05,82,'male','L2Pet',40,10221,2471,13.43,3.09,40,43,30,21,20,25,0,0,2272,1048,1480,973,278,0,333,0,0,0,0,33,187,0,0,'LAST_HIT','false'),
(14651,14651,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow',10.00,35.05,82,'male','L2Pet',40,10306,2498,13.43,3.09,40,43,30,21,20,25,0,0,2310,1058,1509,982,278,0,333,0,0,0,0,33,187,0,0,'LAST_HIT','false'),
(14652,14652,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow',10.00,35.05,82,'male','L2Pet',40,10392,2525,13.43,3.09,40,43,30,21,20,25,0,0,2348,1068,1538,991,278,0,333,0,0,0,0,33,187,0,0,'LAST_HIT','false'),
(14653,14653,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow',10.00,35.05,83,'male','L2Pet',40,10478,2552,13.43,3.09,40,43,30,21,20,25,0,0,2387,1078,1568,1000,278,0,333,0,0,0,0,33,187,0,0,'LAST_HIT','false'),
(14654,14654,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow',10.00,35.05,83,'male','L2Pet',40,10565,2580,13.43,3.09,40,43,30,21,20,25,0,0,2426,1088,1598,1009,278,0,333,0,0,0,0,33,187,0,0,'LAST_HIT','false'),
(14655,14655,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow',10.00,35.05,83,'male','L2Pet',40,10653,2608,13.43,3.09,40,43,30,21,20,25,0,0,2466,1098,1629,1018,278,0,333,0,0,0,0,33,187,0,0,'LAST_HIT','false'),
(14656,14656,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow',10.00,35.05,83,'male','L2Pet',40,10741,2636,13.43,3.09,40,43,30,21,20,25,0,0,2507,1109,1660,1027,278,0,333,0,0,0,0,33,187,0,0,'LAST_HIT','false'),
(14657,14657,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow',10.00,35.05,84,'male','L2Pet',40,10830,2665,13.43,3.09,40,43,30,21,20,25,0,0,2548,1120,1692,1036,278,0,333,0,0,0,0,33,187,0,0,'LAST_HIT','false'),
(14658,14658,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow',10.00,35.05,84,'male','L2Pet',40,10920,2694,13.43,3.09,40,43,30,21,20,25,0,0,2590,1131,1725,1046,278,0,333,0,0,0,0,33,187,0,0,'LAST_HIT','false'),
(14659,14659,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow',10.00,35.05,84,'male','L2Pet',40,11011,2723,13.43,3.09,40,43,30,21,20,25,0,0,2633,1142,1758,1056,278,0,333,0,0,0,0,33,187,0,0,'LAST_HIT','false'),
(14660,14660,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow',10.00,35.05,84,'male','L2Pet',40,11102,2753,13.43,3.09,40,43,30,21,20,25,0,0,2677,1153,1792,1066,278,0,333,0,0,0,0,33,187,0,0,'LAST_HIT','false'),
(14661,14661,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow',10.00,35.05,85,'male','L2Pet',40,11194,2783,13.43,3.09,40,43,30,21,20,25,0,0,2721,1164,1827,1076,278,0,333,0,0,0,0,33,187,0,0,'LAST_HIT','false'),
(14662,14662,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow',10.00,35.05,85,'male','L2Pet',40,11287,2813,13.43,3.09,40,43,30,21,20,25,0,0,2766,1175,1862,1086,278,0,333,0,0,0,0,33,187,0,0,'LAST_HIT','false'),
(14663,14663,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem',5.00,19.00,30,'male','L2Pet',40,1049,421,5.53,1.53,40,43,30,21,20,25,0,0,132,140,58,132,278,0,333,0,0,0,0,33,165,0,0,'LAST_HIT','false'),
(14664,14664,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem',5.00,19.00,38,'male','L2Pet',40,1540,573,7.11,1.84,40,43,30,21,20,25,0,0,238,188,112,176,278,0,333,0,0,0,0,33,165,0,0,'LAST_HIT','false'),
(14665,14665,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem',5.00,19.00,45,'male','L2Pet',40,2057,781,8.69,2.14,40,43,30,21,20,25,0,0,377,238,188,223,278,0,333,0,0,0,0,33,165,0,0,'LAST_HIT','false'),
(14666,14666,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem',5.00,19.00,51,'male','L2Pet',40,2555,993,10.27,2.45,40,43,30,21,20,25,0,0,539,286,281,268,278,0,333,0,0,0,0,33,165,0,0,'LAST_HIT','false'),
(14667,14667,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem',5.00,19.00,57,'male','L2Pet',40,3087,1213,10.27,2.45,40,43,30,21,20,25,0,0,743,340,405,318,320,0,333,0,0,0,0,33,165,0,0,'LAST_HIT','false'),
(14668,14668,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem',5.00,19.00,62,'male','L2Pet',40,3541,1404,11.85,2.78,40,43,30,21,20,25,0,0,944,388,532,363,278,0,333,0,0,0,0,33,165,0,0,'LAST_HIT','false'),
(14669,14669,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem',5.00,19.00,66,'male','L2Pet',40,3901,1561,11.85,2.78,40,43,30,21,20,25,0,0,1123,428,649,401,278,0,333,0,0,0,0,33,165,0,0,'LAST_HIT','false'),
(14670,14670,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem',5.00,19.00,70,'male','L2Pet',40,4248,1722,11.85,2.78,40,43,30,21,20,25,0,0,1314,470,780,440,278,0,333,0,0,0,0,33,165,0,0,'LAST_HIT','false'),
(14671,14671,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem',5.00,19.00,74,'male','L2Pet',40,4574,1888,13.43,3.09,40,43,30,21,20,25,0,0,1513,512,921,480,278,0,333,0,0,0,0,33,165,0,0,'LAST_HIT','false'),
(14672,14672,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem',5.00,19.00,78,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1723,555,1069,520,278,0,333,0,0,0,0,33,165,0,0,'LAST_HIT','false'),
(14673,14673,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem',5.00,19.00,78,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1732,555,1069,520,278,0,333,0,0,0,0,33,165,0,0,'LAST_HIT','false'),
(14674,14674,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem',5.00,19.00,78,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1740,555,1069,520,278,0,333,0,0,0,0,33,165,0,0,'LAST_HIT','false'),
(14675,14675,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem',5.00,19.00,78,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1749,555,1069,520,278,0,333,0,0,0,0,33,165,0,0,'LAST_HIT','false'),
(14676,14676,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem',5.00,19.00,79,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1757,555,1069,520,278,0,333,0,0,0,0,33,165,0,0,'LAST_HIT','false'),
(14677,14677,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem',5.00,19.00,79,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1766,555,1069,520,278,0,333,0,0,0,0,33,165,0,0,'LAST_HIT','false'),
(14678,14678,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem',5.00,19.00,79,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1775,555,1069,520,278,0,333,0,0,0,0,33,165,0,0,'LAST_HIT','false'),
(14679,14679,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem',5.00,19.00,79,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1783,555,1069,520,278,0,333,0,0,0,0,33,165,0,0,'LAST_HIT','false'),
(14680,14680,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem',5.00,19.00,80,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1792,555,1069,520,278,0,333,0,0,0,0,33,165,0,0,'LAST_HIT','false'),
(14681,14681,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem',5.00,19.00,80,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1811,558,1082,523,278,0,333,0,0,0,0,33,165,0,0,'LAST_HIT','false'),
(14682,14682,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem',5.00,19.00,80,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1820,558,1082,523,278,0,333,0,0,0,0,33,165,0,0,'LAST_HIT','false'),
(14683,14683,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem',5.00,19.00,80,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1828,558,1082,523,278,0,333,0,0,0,0,33,165,0,0,'LAST_HIT','false'),
(14684,14684,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem',5.00,19.00,81,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1837,558,1082,523,278,0,333,0,0,0,0,33,165,0,0,'LAST_HIT','false'),
(14685,14685,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem',5.00,19.00,81,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1846,558,1082,523,278,0,333,0,0,0,0,33,165,0,0,'LAST_HIT','false'),
(14686,14686,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem',5.00,19.00,81,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1854,558,1082,523,278,0,333,0,0,0,0,33,165,0,0,'LAST_HIT','false'),
(14687,14687,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem',5.00,19.00,81,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1863,558,1082,523,278,0,333,0,0,0,0,33,165,0,0,'LAST_HIT','false'),
(14688,14688,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem',5.00,19.00,82,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1871,558,1082,523,278,0,333,0,0,0,0,33,165,0,0,'LAST_HIT','false'),
(14689,14689,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem',5.00,19.00,82,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1880,558,1082,523,278,0,333,0,0,0,0,33,165,0,0,'LAST_HIT','false'),
(14690,14690,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem',5.00,19.00,82,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1900,562,1095,526,278,0,333,0,0,0,0,33,165,0,0,'LAST_HIT','false'),
(14691,14691,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem',5.00,19.00,82,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1909,562,1095,526,278,0,333,0,0,0,0,33,165,0,0,'LAST_HIT','false'),
(14692,14692,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem',5.00,19.00,83,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1917,562,1095,526,278,0,333,0,0,0,0,33,165,0,0,'LAST_HIT','false'),
(14693,14693,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem',5.00,19.00,83,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1926,562,1095,526,278,0,333,0,0,0,0,33,165,0,0,'LAST_HIT','false'),
(14694,14694,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem',5.00,19.00,83,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1935,562,1095,526,278,0,333,0,0,0,0,33,165,0,0,'LAST_HIT','false'),
(14695,14695,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem',5.00,19.00,83,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1943,562,1095,526,278,0,333,0,0,0,0,33,165,0,0,'LAST_HIT','false'),
(14696,14696,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem',5.00,19.00,84,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1952,562,1095,526,278,0,333,0,0,0,0,33,165,0,0,'LAST_HIT','false'),
(14697,14697,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem',5.00,19.00,84,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1961,562,1095,526,278,0,333,0,0,0,0,33,165,0,0,'LAST_HIT','false'),
(14698,14698,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem',5.00,19.00,84,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1969,562,1095,526,278,0,333,0,0,0,0,33,165,0,0,'LAST_HIT','false'),
(14699,14699,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem',5.00,19.00,84,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1978,562,1095,526,278,0,333,0,0,0,0,33,165,0,0,'LAST_HIT','false'),
(14700,14700,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem',5.00,19.00,85,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1987,562,1095,526,278,0,333,0,0,0,0,33,165,0,0,'LAST_HIT','false'),
(14701,14701,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem',5.00,19.00,85,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1995,562,1095,526,278,0,333,0,0,0,0,33,165,0,0,'LAST_HIT','false'),
(14702,14702,'Big Boom',0,'',0,'LineageMonster.big_boom',6.00,13.00,60,'male','L2Pet',40,3054,1327,10.27,2.45,40,43,30,21,20,25,0,0,860,368,478,345,278,0,333,0,0,0,0,52,154,0,0,'LAST_HIT','false'),
(14703,14703,'Big Boom',0,'',0,'LineageMonster.big_boom',6.00,13.00,64,'male','L2Pet',40,3054,1327,10.27,2.45,40,43,30,21,20,25,0,0,860,368,478,345,278,0,333,0,0,0,0,52,154,0,0,'LAST_HIT','false'),
(14704,14704,'Big Boom',0,'',0,'LineageMonster.big_boom',6.00,13.00,68,'male','L2Pet',40,3384,1482,11.85,2.78,40,43,30,21,20,25,0,0,1031,408,589,382,278,0,333,0,0,0,0,52,154,0,0,'LAST_HIT','false'),
(14705,14705,'Big Boom',0,'',0,'LineageMonster.big_boom',6.00,13.00,72,'male','L2Pet',40,3706,1641,11.85,2.78,40,43,30,21,20,25,0,0,1217,449,713,421,278,0,333,0,0,0,0,52,154,0,0,'LAST_HIT','false'),
(14706,14706,'Big Boom',0,'',0,'LineageMonster.big_boom',6.00,13.00,76,'male','L2Pet',40,4013,1804,13.43,3.09,40,43,30,21,20,25,0,0,1413,491,849,460,278,0,333,0,0,0,0,52,154,0,0,'LAST_HIT','false'),
(14707,14707,'Big Boom',0,'',0,'LineageMonster.big_boom',6.00,13.00,78,'male','L2Pet',40,4550,2143,13.43,3.09,40,43,30,21,20,25,0,0,1793,553,1118,533,278,0,333,0,0,0,0,52,154,0,0,'LAST_HIT','false'),
(14708,14708,'Big Boom',0,'',0,'LineageMonster.big_boom',6.00,13.00,78,'male','L2Pet',40,4550,2143,13.43,3.09,40,43,30,21,20,25,0,0,1793,553,1118,533,278,0,333,0,0,0,0,52,154,0,0,'LAST_HIT','false'),
(14709,14709,'Big Boom',0,'',0,'LineageMonster.big_boom',6.00,13.00,78,'male','L2Pet',40,4550,2143,13.43,3.09,40,43,30,21,20,25,0,0,1793,553,1118,533,278,0,333,0,0,0,0,52,154,0,0,'LAST_HIT','false'),
(14710,14710,'Big Boom',0,'',0,'LineageMonster.big_boom',6.00,13.00,78,'male','L2Pet',40,4550,2143,13.43,3.09,40,43,30,21,20,25,0,0,1793,553,1118,533,278,0,333,0,0,0,0,52,154,0,0,'LAST_HIT','false'),
(14711,14711,'Big Boom',0,'',0,'LineageMonster.big_boom',6.00,13.00,79,'male','L2Pet',40,4550,2143,13.43,3.09,40,43,30,21,20,25,0,0,1793,553,1118,533,278,0,333,0,0,0,0,52,154,0,0,'LAST_HIT','false'),
(14712,14712,'Big Boom',0,'',0,'LineageMonster.big_boom',6.00,13.00,79,'male','L2Pet',40,4550,2143,13.43,3.09,40,43,30,21,20,25,0,0,1793,553,1118,533,278,0,333,0,0,0,0,52,154,0,0,'LAST_HIT','false'),
(14713,14713,'Big Boom',0,'',0,'LineageMonster.big_boom',6.00,13.00,79,'male','L2Pet',40,4550,2143,13.43,3.09,40,43,30,21,20,25,0,0,1793,553,1118,533,278,0,333,0,0,0,0,52,154,0,0,'LAST_HIT','false'),
(14714,14714,'Big Boom',0,'',0,'LineageMonster.big_boom',6.00,13.00,79,'male','L2Pet',40,4550,2143,13.43,3.09,40,43,30,21,20,25,0,0,1793,553,1118,533,278,0,333,0,0,0,0,52,154,0,0,'LAST_HIT','false'),
(14715,14715,'Big Boom',0,'',0,'LineageMonster.big_boom',6.00,13.00,80,'male','L2Pet',40,4550,2143,13.43,3.09,40,43,30,21,20,25,0,0,1793,553,1118,533,278,0,333,0,0,0,0,52,154,0,0,'LAST_HIT','false'),
(14716,14716,'Big Boom',0,'',0,'LineageMonster.big_boom',6.00,13.00,80,'male','L2Pet',40,4550,2143,13.43,3.09,40,43,30,21,20,25,0,0,1803,556,1131,537,278,0,333,0,0,0,0,52,154,0,0,'LAST_HIT','false'),
(14717,14717,'Big Boom',0,'',0,'LineageMonster.big_boom',6.00,13.00,80,'male','L2Pet',40,4550,2143,13.43,3.09,40,43,30,21,20,25,0,0,1803,556,1131,537,278,0,333,0,0,0,0,52,154,0,0,'LAST_HIT','false'),
(14718,14718,'Big Boom',0,'',0,'LineageMonster.big_boom',6.00,13.00,80,'male','L2Pet',40,4550,2143,13.43,3.09,40,43,30,21,20,25,0,0,1803,556,1131,537,278,0,333,0,0,0,0,52,154,0,0,'LAST_HIT','false'),
(14719,14719,'Big Boom',0,'',0,'LineageMonster.big_boom',6.00,13.00,81,'male','L2Pet',40,4550,2143,13.43,3.09,40,43,30,21,20,25,0,0,1803,556,1131,537,278,0,333,0,0,0,0,52,154,0,0,'LAST_HIT','false'),
(14720,14720,'Big Boom',0,'',0,'LineageMonster.big_boom',6.00,13.00,81,'male','L2Pet',40,4550,2143,13.43,3.09,40,43,30,21,20,25,0,0,1803,556,1131,537,278,0,333,0,0,0,0,52,154,0,0,'LAST_HIT','false'),
(14721,14721,'Big Boom',0,'',0,'LineageMonster.big_boom',6.00,13.00,81,'male','L2Pet',40,4550,2143,13.43,3.09,40,43,30,21,20,25,0,0,1803,556,1131,537,278,0,333,0,0,0,0,52,154,0,0,'LAST_HIT','false'),
(14722,14722,'Big Boom',0,'',0,'LineageMonster.big_boom',6.00,13.00,81,'male','L2Pet',40,4550,2143,13.43,3.09,40,43,30,21,20,25,0,0,1803,556,1131,537,278,0,333,0,0,0,0,52,154,0,0,'LAST_HIT','false'),
(14723,14723,'Big Boom',0,'',0,'LineageMonster.big_boom',6.00,13.00,82,'male','L2Pet',40,4550,2143,13.43,3.09,40,43,30,21,20,25,0,0,1803,556,1131,537,278,0,333,0,0,0,0,52,154,0,0,'LAST_HIT','false'),
(14724,14724,'Big Boom',0,'',0,'LineageMonster.big_boom',6.00,13.00,82,'male','L2Pet',40,4550,2143,13.43,3.09,40,43,30,21,20,25,0,0,1803,556,1131,537,278,0,333,0,0,0,0,52,154,0,0,'LAST_HIT','false'),
(14725,14725,'Big Boom',0,'',0,'LineageMonster.big_boom',6.00,13.00,82,'male','L2Pet',40,4550,2143,13.43,3.09,40,43,30,21,20,25,0,0,1814,559,1144,540,278,0,333,0,0,0,0,52,154,0,0,'LAST_HIT','false'),
(14726,14726,'Big Boom',0,'',0,'LineageMonster.big_boom',6.00,13.00,82,'male','L2Pet',40,4550,2143,13.43,3.09,40,43,30,21,20,25,0,0,1814,559,1144,540,278,0,333,0,0,0,0,52,154,0,0,'LAST_HIT','false'),
(14727,14727,'Big Boom',0,'',0,'LineageMonster.big_boom',6.00,13.00,83,'male','L2Pet',40,4550,2143,13.43,3.09,40,43,30,21,20,25,0,0,1814,559,1144,540,278,0,333,0,0,0,0,52,154,0,0,'LAST_HIT','false'),
(14728,14728,'Big Boom',0,'',0,'LineageMonster.big_boom',6.00,13.00,83,'male','L2Pet',40,4550,2143,13.43,3.09,40,43,30,21,20,25,0,0,1814,559,1144,540,278,0,333,0,0,0,0,52,154,0,0,'LAST_HIT','false'),
(14729,14729,'Big Boom',0,'',0,'LineageMonster.big_boom',6.00,13.00,83,'male','L2Pet',40,4550,2143,13.43,3.09,40,43,30,21,20,25,0,0,1814,559,1144,540,278,0,333,0,0,0,0,52,154,0,0,'LAST_HIT','false'),
(14730,14730,'Big Boom',0,'',0,'LineageMonster.big_boom',6.00,13.00,83,'male','L2Pet',40,4550,2143,13.43,3.09,40,43,30,21,20,25,0,0,1814,559,1144,540,278,0,333,0,0,0,0,52,154,0,0,'LAST_HIT','false'),
(14731,14731,'Big Boom',0,'',0,'LineageMonster.big_boom',6.00,13.00,84,'male','L2Pet',40,4550,2143,13.43,3.09,40,43,30,21,20,25,0,0,1814,559,1144,540,278,0,333,0,0,0,0,52,154,0,0,'LAST_HIT','false'),
(14732,14732,'Big Boom',0,'',0,'LineageMonster.big_boom',6.00,13.00,84,'male','L2Pet',40,4550,2143,13.43,3.09,40,43,30,21,20,25,0,0,1814,559,1144,540,278,0,333,0,0,0,0,52,154,0,0,'LAST_HIT','false'),
(14733,14733,'Big Boom',0,'',0,'LineageMonster.big_boom',6.00,13.00,84,'male','L2Pet',40,4550,2143,13.43,3.09,40,43,30,21,20,25,0,0,1814,559,1144,540,278,0,333,0,0,0,0,52,154,0,0,'LAST_HIT','false'),
(14734,14734,'Big Boom',0,'',0,'LineageMonster.big_boom',6.00,13.00,84,'male','L2Pet',40,4550,2143,13.43,3.09,40,43,30,21,20,25,0,0,1814,559,1144,540,278,0,333,0,0,0,0,52,154,0,0,'LAST_HIT','false'),
(14735,14735,'Big Boom',0,'',0,'LineageMonster.big_boom',6.00,13.00,85,'male','L2Pet',40,4550,2143,13.43,3.09,40,43,30,21,20,25,0,0,1814,559,1144,540,278,0,333,0,0,0,0,52,154,0,0,'LAST_HIT','false'),
(14736,14736,'Big Boom',0,'',0,'LineageMonster.big_boom',6.00,13.00,85,'male','L2Pet',40,4550,2143,13.43,3.09,40,43,30,21,20,25,0,0,1814,559,1144,540,278,0,333,0,0,0,0,52,154,0,0,'LAST_HIT','false'),
(14737,14737,'Siege Golem',0,'',0,'LineageMonster.siege_golem',60.00,140.00,55,'male','L2SiegeSummon',80,790000,1138,10.27,2.45,40,43,30,21,20,25,0,0,2592,1205,360,1242,165,0,333,0,0,0,0,44,44,1,0,'LAST_HIT','false'),
(14738,14738,'Siege Golem',0,'',0,'LineageMonster.siege_golem',60.00,140.00,78,'male','L2SiegeSummon',80,790000,1138,10.27,2.45,40,43,30,21,20,25,0,0,3036,1397,484,1440,165,0,333,0,0,0,0,44,44,1,0,'LAST_HIT','false'),
(14739,14739,'Siege Golem',0,'',0,'LineageMonster.siege_golem',60.00,140.00,78,'male','L2SiegeSummon',80,790000,1138,10.27,2.45,40,43,30,21,20,25,0,0,3066,1397,484,1440,165,0,333,0,0,0,0,44,44,1,0,'LAST_HIT','false'),
(14740,14740,'Siege Golem',0,'',0,'LineageMonster.siege_golem',60.00,140.00,78,'male','L2SiegeSummon',80,790000,1138,10.27,2.45,40,43,30,21,20,25,0,0,3096,1397,484,1440,165,0,333,0,0,0,0,44,44,1,0,'LAST_HIT','false'),
(14741,14741,'Siege Golem',0,'',0,'LineageMonster.siege_golem',60.00,140.00,78,'male','L2SiegeSummon',80,790000,1138,10.27,2.45,40,43,30,21,20,25,0,0,3126,1397,484,1440,165,0,333,0,0,0,0,44,44,1,0,'LAST_HIT','false'),
(14742,14742,'Siege Golem',0,'',0,'LineageMonster.siege_golem',60.00,140.00,79,'male','L2SiegeSummon',80,790000,1138,10.27,2.45,40,43,30,21,20,25,0,0,3156,1397,484,1440,165,0,333,0,0,0,0,44,44,1,0,'LAST_HIT','false'),
(14743,14743,'Siege Golem',0,'',0,'LineageMonster.siege_golem',60.00,140.00,79,'male','L2SiegeSummon',80,790000,1138,10.27,2.45,40,43,30,21,20,25,0,0,3186,1397,484,1440,165,0,333,0,0,0,0,44,44,1,0,'LAST_HIT','false'),
(14744,14744,'Siege Golem',0,'',0,'LineageMonster.siege_golem',60.00,140.00,79,'male','L2SiegeSummon',80,790000,1138,10.27,2.45,40,43,30,21,20,25,0,0,3216,1397,484,1440,165,0,333,0,0,0,0,44,44,1,0,'LAST_HIT','false'),
(14745,14745,'Siege Golem',0,'',0,'LineageMonster.siege_golem',60.00,140.00,79,'male','L2SiegeSummon',80,790000,1138,10.27,2.45,40,43,30,21,20,25,0,0,3246,1397,484,1440,165,0,333,0,0,0,0,44,44,1,0,'LAST_HIT','false'),
(14746,14746,'Siege Golem',0,'',0,'LineageMonster.siege_golem',60.00,140.00,80,'male','L2SiegeSummon',80,790000,1138,10.27,2.45,40,43,30,21,20,25,0,0,3276,1397,484,1440,165,0,333,0,0,0,0,44,44,1,0,'LAST_HIT','false'),
(14747,14747,'Siege Golem',0,'',0,'LineageMonster.siege_golem',60.00,140.00,80,'male','L2SiegeSummon',80,790000,1138,10.27,2.45,40,43,30,21,20,25,0,0,3326,1406,490,1449,165,0,333,0,0,0,0,44,44,1,0,'LAST_HIT','false'),
(14748,14748,'Siege Golem',0,'',0,'LineageMonster.siege_golem',60.00,140.00,80,'male','L2SiegeSummon',80,790000,1138,10.27,2.45,40,43,30,21,20,25,0,0,3356,1406,490,1449,165,0,333,0,0,0,0,44,44,1,0,'LAST_HIT','false'),
(14749,14749,'Siege Golem',0,'',0,'LineageMonster.siege_golem',60.00,140.00,80,'male','L2SiegeSummon',80,790000,1138,10.27,2.45,40,43,30,21,20,25,0,0,3386,1406,490,1449,165,0,333,0,0,0,0,44,44,1,0,'LAST_HIT','false'),
(14750,14750,'Siege Golem',0,'',0,'LineageMonster.siege_golem',60.00,140.00,81,'male','L2SiegeSummon',80,790000,1138,10.27,2.45,40,43,30,21,20,25,0,0,3417,1406,490,1449,165,0,333,0,0,0,0,44,44,1,0,'LAST_HIT','false'),
(14751,14751,'Siege Golem',0,'',0,'LineageMonster.siege_golem',60.00,140.00,81,'male','L2SiegeSummon',80,790000,1138,10.27,2.45,40,43,30,21,20,25,0,0,3447,1406,490,1449,165,0,333,0,0,0,0,44,44,1,0,'LAST_HIT','false'),
(14752,14752,'Siege Golem',0,'',0,'LineageMonster.siege_golem',60.00,140.00,81,'male','L2SiegeSummon',80,790000,1138,10.27,2.45,40,43,30,21,20,25,0,0,3477,1406,490,1449,165,0,333,0,0,0,0,44,44,1,0,'LAST_HIT','false'),
(14753,14753,'Siege Golem',0,'',0,'LineageMonster.siege_golem',60.00,140.00,81,'male','L2SiegeSummon',80,790000,1138,10.27,2.45,40,43,30,21,20,25,0,0,3507,1406,490,1449,165,0,333,0,0,0,0,44,44,1,0,'LAST_HIT','false'),
(14754,14754,'Siege Golem',0,'',0,'LineageMonster.siege_golem',60.00,140.00,82,'male','L2SiegeSummon',80,790000,1138,10.27,2.45,40,43,30,21,20,25,0,0,3538,1406,490,1449,165,0,333,0,0,0,0,44,44,1,0,'LAST_HIT','false'),
(14755,14755,'Siege Golem',0,'',0,'LineageMonster.siege_golem',60.00,140.00,82,'male','L2SiegeSummon',80,790000,1138,10.27,2.45,40,43,30,21,20,25,0,0,3568,1406,490,1449,165,0,333,0,0,0,0,44,44,1,0,'LAST_HIT','false'),
(14756,14756,'Siege Golem',0,'',0,'LineageMonster.siege_golem',60.00,140.00,82,'male','L2SiegeSummon',80,790000,1138,10.27,2.45,40,43,30,21,20,25,0,0,3619,1414,496,1457,165,0,333,0,0,0,0,44,44,1,0,'LAST_HIT','false'),
(14757,14757,'Siege Golem',0,'',0,'LineageMonster.siege_golem',60.00,140.00,82,'male','L2SiegeSummon',80,790000,1138,10.27,2.45,40,43,30,21,20,25,0,0,3650,1414,496,1457,165,0,333,0,0,0,0,44,44,1,0,'LAST_HIT','false'),
(14758,14758,'Siege Golem',0,'',0,'LineageMonster.siege_golem',60.00,140.00,83,'male','L2SiegeSummon',80,790000,1138,10.27,2.45,40,43,30,21,20,25,0,0,3680,1414,496,1457,165,0,333,0,0,0,0,44,44,1,0,'LAST_HIT','false'),
(14759,14759,'Siege Golem',0,'',0,'LineageMonster.siege_golem',60.00,140.00,83,'male','L2SiegeSummon',80,790000,1138,10.27,2.45,40,43,30,21,20,25,0,0,3711,1414,496,1457,165,0,333,0,0,0,0,44,44,1,0,'LAST_HIT','false'),
(14760,14760,'Siege Golem',0,'',0,'LineageMonster.siege_golem',60.00,140.00,83,'male','L2SiegeSummon',80,790000,1138,10.27,2.45,40,43,30,21,20,25,0,0,3741,1414,496,1457,165,0,333,0,0,0,0,44,44,1,0,'LAST_HIT','false'),
(14761,14761,'Siege Golem',0,'',0,'LineageMonster.siege_golem',60.00,140.00,83,'male','L2SiegeSummon',80,790000,1138,10.27,2.45,40,43,30,21,20,25,0,0,3772,1414,496,1457,165,0,333,0,0,0,0,44,44,1,0,'LAST_HIT','false'),
(14762,14762,'Siege Golem',0,'',0,'LineageMonster.siege_golem',60.00,140.00,84,'male','L2SiegeSummon',80,790000,1138,10.27,2.45,40,43,30,21,20,25,0,0,3802,1414,496,1457,165,0,333,0,0,0,0,44,44,1,0,'LAST_HIT','false'),
(14763,14763,'Siege Golem',0,'',0,'LineageMonster.siege_golem',60.00,140.00,84,'male','L2SiegeSummon',80,790000,1138,10.27,2.45,40,43,30,21,20,25,0,0,3832,1414,496,1457,165,0,333,0,0,0,0,44,44,1,0,'LAST_HIT','false'),
(14764,14764,'Siege Golem',0,'',0,'LineageMonster.siege_golem',60.00,140.00,84,'male','L2SiegeSummon',80,790000,1138,10.27,2.45,40,43,30,21,20,25,0,0,3863,1414,496,1457,165,0,333,0,0,0,0,44,44,1,0,'LAST_HIT','false'),
(14765,14765,'Siege Golem',0,'',0,'LineageMonster.siege_golem',60.00,140.00,84,'male','L2SiegeSummon',80,790000,1138,10.27,2.45,40,43,30,21,20,25,0,0,3893,1414,496,1457,165,0,333,0,0,0,0,44,44,1,0,'LAST_HIT','false'),
(14766,14766,'Siege Golem',0,'',0,'LineageMonster.siege_golem',60.00,140.00,85,'male','L2SiegeSummon',80,790000,1138,10.27,2.45,40,43,30,21,20,25,0,0,3924,1414,496,1457,165,0,333,0,0,0,0,44,44,1,0,'LAST_HIT','false'),
(14767,14767,'Siege Golem',0,'',0,'LineageMonster.siege_golem',60.00,140.00,85,'male','L2SiegeSummon',80,790000,1138,10.27,2.45,40,43,30,21,20,25,0,0,3954,1414,496,1457,165,0,333,0,0,0,0,44,44,1,0,'LAST_HIT','false'),
(14768,14768,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem',93.00,90.00,60,'male','L2SiegeSummon',40,3153,1327,10.27,2.45,40,43,30,21,20,25,0,0,888,709,478,730,278,0,333,0,0,0,0,11,11,1,0,'LAST_HIT','false'),
(14769,14769,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem',93.00,90.00,78,'male','L2SiegeSummon',40,3153,1327,10.27,2.45,40,43,30,21,20,25,0,0,1012,794,601,818,278,0,333,0,0,0,0,11,11,1,0,'LAST_HIT','false'),
(14770,14770,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem',93.00,90.00,78,'male','L2SiegeSummon',40,3153,1327,10.27,2.45,40,43,30,21,20,25,0,0,1022,794,601,818,278,0,333,0,0,0,0,11,11,1,0,'LAST_HIT','false'),
(14771,14771,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem',93.00,90.00,78,'male','L2SiegeSummon',40,3153,1327,10.27,2.45,40,43,30,21,20,25,0,0,1032,794,601,818,278,0,333,0,0,0,0,11,11,1,0,'LAST_HIT','false'),
(14772,14772,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem',93.00,90.00,78,'male','L2SiegeSummon',40,3153,1327,10.27,2.45,40,43,30,21,20,25,0,0,1042,794,601,818,278,0,333,0,0,0,0,11,11,1,0,'LAST_HIT','false'),
(14773,14773,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem',93.00,90.00,79,'male','L2SiegeSummon',40,3153,1327,10.27,2.45,40,43,30,21,20,25,0,0,1052,794,601,818,278,0,333,0,0,0,0,11,11,1,0,'LAST_HIT','false'),
(14774,14774,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem',93.00,90.00,79,'male','L2SiegeSummon',40,3153,1327,10.27,2.45,40,43,30,21,20,25,0,0,1062,794,601,818,278,0,333,0,0,0,0,11,11,1,0,'LAST_HIT','false'),
(14775,14775,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem',93.00,90.00,79,'male','L2SiegeSummon',40,3153,1327,10.27,2.45,40,43,30,21,20,25,0,0,1072,794,601,818,278,0,333,0,0,0,0,11,11,1,0,'LAST_HIT','false'),
(14776,14776,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem',93.00,90.00,79,'male','L2SiegeSummon',40,3153,1327,10.27,2.45,40,43,30,21,20,25,0,0,1082,794,601,818,278,0,333,0,0,0,0,11,11,1,0,'LAST_HIT','false'),
(14777,14777,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem',93.00,90.00,80,'male','L2SiegeSummon',40,3153,1327,10.27,2.45,40,43,30,21,20,25,0,0,1092,794,601,818,278,0,333,0,0,0,0,11,11,1,0,'LAST_HIT','false'),
(14778,14778,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem',93.00,90.00,80,'male','L2SiegeSummon',40,3153,1327,10.27,2.45,40,43,30,21,20,25,0,0,1108,799,608,823,278,0,333,0,0,0,0,11,11,1,0,'LAST_HIT','false'),
(14779,14779,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem',93.00,90.00,80,'male','L2SiegeSummon',40,3153,1327,10.27,2.45,40,43,30,21,20,25,0,0,1118,799,608,823,278,0,333,0,0,0,0,11,11,1,0,'LAST_HIT','false'),
(14780,14780,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem',93.00,90.00,80,'male','L2SiegeSummon',40,3153,1327,10.27,2.45,40,43,30,21,20,25,0,0,1128,799,608,823,278,0,333,0,0,0,0,11,11,1,0,'LAST_HIT','false'),
(14781,14781,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem',93.00,90.00,81,'male','L2SiegeSummon',40,3153,1327,10.27,2.45,40,43,30,21,20,25,0,0,1139,799,608,823,278,0,333,0,0,0,0,11,11,1,0,'LAST_HIT','false'),
(14782,14782,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem',93.00,90.00,81,'male','L2SiegeSummon',40,3153,1327,10.27,2.45,40,43,30,21,20,25,0,0,1149,799,608,823,278,0,333,0,0,0,0,11,11,1,0,'LAST_HIT','false'),
(14783,14783,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem',93.00,90.00,81,'male','L2SiegeSummon',40,3153,1327,10.27,2.45,40,43,30,21,20,25,0,0,1159,799,608,823,278,0,333,0,0,0,0,11,11,1,0,'LAST_HIT','false'),
(14784,14784,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem',93.00,90.00,81,'male','L2SiegeSummon',40,3153,1327,10.27,2.45,40,43,30,21,20,25,0,0,1169,799,608,823,278,0,333,0,0,0,0,11,11,1,0,'LAST_HIT','false'),
(14785,14785,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem',93.00,90.00,82,'male','L2SiegeSummon',40,3153,1327,10.27,2.45,40,43,30,21,20,25,0,0,1179,799,608,823,278,0,333,0,0,0,0,11,11,1,0,'LAST_HIT','false'),
(14786,14786,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem',93.00,90.00,82,'male','L2SiegeSummon',40,3153,1327,10.27,2.45,40,43,30,21,20,25,0,0,1189,799,608,823,278,0,333,0,0,0,0,11,11,1,0,'LAST_HIT','false'),
(14787,14787,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem',93.00,90.00,82,'male','L2SiegeSummon',40,3153,1327,10.27,2.45,40,43,30,21,20,25,0,0,1206,804,615,828,278,0,333,0,0,0,0,11,11,1,0,'LAST_HIT','false'),
(14788,14788,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem',93.00,90.00,82,'male','L2SiegeSummon',40,3153,1327,10.27,2.45,40,43,30,21,20,25,0,0,1216,804,615,828,278,0,333,0,0,0,0,11,11,1,0,'LAST_HIT','false'),
(14789,14789,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem',93.00,90.00,83,'male','L2SiegeSummon',40,3153,1327,10.27,2.45,40,43,30,21,20,25,0,0,1226,804,615,828,278,0,333,0,0,0,0,11,11,1,0,'LAST_HIT','false'),
(14790,14790,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem',93.00,90.00,83,'male','L2SiegeSummon',40,3153,1327,10.27,2.45,40,43,30,21,20,25,0,0,1237,804,615,828,278,0,333,0,0,0,0,11,11,1,0,'LAST_HIT','false'),
(14791,14791,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem',93.00,90.00,83,'male','L2SiegeSummon',40,3153,1327,10.27,2.45,40,43,30,21,20,25,0,0,1247,804,615,828,278,0,333,0,0,0,0,11,11,1,0,'LAST_HIT','false'),
(14792,14792,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem',93.00,90.00,83,'male','L2SiegeSummon',40,3153,1327,10.27,2.45,40,43,30,21,20,25,0,0,1257,804,615,828,278,0,333,0,0,0,0,11,11,1,0,'LAST_HIT','false'),
(14793,14793,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem',93.00,90.00,84,'male','L2SiegeSummon',40,3153,1327,10.27,2.45,40,43,30,21,20,25,0,0,1267,804,615,828,278,0,333,0,0,0,0,11,11,1,0,'LAST_HIT','false'),
(14794,14794,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem',93.00,90.00,84,'male','L2SiegeSummon',40,3153,1327,10.27,2.45,40,43,30,21,20,25,0,0,1277,804,615,828,278,0,333,0,0,0,0,11,11,1,0,'LAST_HIT','false'),
(14795,14795,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem',93.00,90.00,84,'male','L2SiegeSummon',40,3153,1327,10.27,2.45,40,43,30,21,20,25,0,0,1287,804,615,828,278,0,333,0,0,0,0,11,11,1,0,'LAST_HIT','false'),
(14796,14796,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem',93.00,90.00,84,'male','L2SiegeSummon',40,3153,1327,10.27,2.45,40,43,30,21,20,25,0,0,1297,804,615,828,278,0,333,0,0,0,0,11,11,1,0,'LAST_HIT','false'),
(14797,14797,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem',93.00,90.00,85,'male','L2SiegeSummon',40,3153,1327,10.27,2.45,40,43,30,21,20,25,0,0,1308,804,615,828,278,0,333,0,0,0,0,11,11,1,0,'LAST_HIT','false'),
(14798,14798,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem',93.00,90.00,85,'male','L2SiegeSummon',40,3153,1327,10.27,2.45,40,43,30,21,20,25,0,0,1318,804,615,828,278,0,333,0,0,0,0,11,11,1,0,'LAST_HIT','false'),
(14799,14799,'Dark Panther',0,'',0,'LineageMonster.dark_fencer',7.00,13.00,42,'male','L2Pet',40,1826,679,8.69,2.14,40,43,30,21,20,25,0,0,311,215,152,202,278,0,333,0,0,0,0,27,165,0,0,'LAST_HIT','false'),
(14800,14800,'Dark Panther',0,'',0,'LineageMonster.dark_fencer',7.00,13.00,51,'male','L2Pet',40,2555,993,10.27,2.45,40,43,30,21,20,25,0,0,539,286,281,268,278,0,333,0,0,0,0,27,165,0,0,'LAST_HIT','false'),
(14801,14801,'Dark Panther',0,'',0,'LineageMonster.dark_fencer',7.00,13.00,60,'male','L2Pet',40,3359,1327,10.27,2.45,40,43,30,21,20,25,0,0,860,368,478,345,278,0,333,0,0,0,0,27,165,0,0,'LAST_HIT','false'),
(14802,14802,'Dark Panther',0,'',0,'LineageMonster.dark_fencer',7.00,13.00,64,'male','L2Pet',40,3722,1482,11.85,2.78,40,43,30,21,20,25,0,0,1031,408,589,382,278,0,333,0,0,0,0,27,165,0,0,'LAST_HIT','false'),
(14803,14803,'Dark Panther',0,'',0,'LineageMonster.dark_fencer',7.00,13.00,68,'male','L2Pet',40,4076,1641,11.85,2.78,40,43,30,21,20,25,0,0,1217,449,713,421,278,0,333,0,0,0,0,27,165,0,0,'LAST_HIT','false'),
(14804,14804,'Dark Panther',0,'',0,'LineageMonster.dark_fencer',7.00,13.00,72,'male','L2Pet',40,4414,1804,13.43,3.09,40,43,30,21,20,25,0,0,1413,491,849,460,278,0,333,0,0,0,0,27,165,0,0,'LAST_HIT','false'),
(14805,14805,'Dark Panther',0,'',0,'LineageMonster.dark_fencer',7.00,13.00,76,'male','L2Pet',40,4727,1972,13.43,3.09,40,43,30,21,20,25,0,0,1614,534,994,500,278,0,333,0,0,0,0,27,165,0,0,'LAST_HIT','false'),
(14806,14806,'Dark Panther',0,'',0,'LineageMonster.dark_fencer',7.00,13.00,78,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1723,555,1069,520,278,0,333,0,0,0,0,27,165,0,0,'LAST_HIT','false'),
(14807,14807,'Dark Panther',0,'',0,'LineageMonster.dark_fencer',7.00,13.00,78,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1732,555,1069,520,278,0,333,0,0,0,0,27,165,0,0,'LAST_HIT','false'),
(14808,14808,'Dark Panther',0,'',0,'LineageMonster.dark_fencer',7.00,13.00,78,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1740,555,1069,520,278,0,333,0,0,0,0,27,165,0,0,'LAST_HIT','false'),
(14809,14809,'Dark Panther',0,'',0,'LineageMonster.dark_fencer',7.00,13.00,78,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1749,555,1069,520,278,0,333,0,0,0,0,27,165,0,0,'LAST_HIT','false'),
(14810,14810,'Dark Panther',0,'',0,'LineageMonster.dark_fencer',7.00,13.00,79,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1757,555,1069,520,278,0,333,0,0,0,0,27,165,0,0,'LAST_HIT','false'),
(14811,14811,'Dark Panther',0,'',0,'LineageMonster.dark_fencer',7.00,13.00,79,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1766,555,1069,520,370,0,333,0,0,0,0,27,165,0,0,'LAST_HIT','false'),
(14812,14812,'Dark Panther',0,'',0,'LineageMonster.dark_fencer',7.00,13.00,79,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1775,555,1069,520,278,0,333,0,0,0,0,27,165,0,0,'LAST_HIT','false'),
(14813,14813,'Dark Panther',0,'',0,'LineageMonster.dark_fencer',7.00,13.00,79,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1783,555,1069,520,278,0,333,0,0,0,0,27,165,0,0,'LAST_HIT','false'),
(14814,14814,'Dark Panther',0,'',0,'LineageMonster.dark_fencer',7.00,13.00,80,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1792,555,1069,520,278,0,333,0,0,0,0,27,165,0,0,'LAST_HIT','false'),
(14815,14815,'Dark Panther',0,'',0,'LineageMonster.dark_fencer',7.00,13.00,80,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1811,558,1082,523,278,0,333,0,0,0,0,27,165,0,0,'LAST_HIT','false'),
(14816,14816,'Dark Panther',0,'',0,'LineageMonster.dark_fencer',7.00,13.00,80,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1820,558,1082,523,278,0,333,0,0,0,0,27,165,0,0,'LAST_HIT','false'),
(14817,14817,'Dark Panther',0,'',0,'LineageMonster.dark_fencer',7.00,13.00,80,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1828,558,1082,523,278,0,333,0,0,0,0,27,165,0,0,'LAST_HIT','false'),
(14818,14818,'Dark Panther',0,'',0,'LineageMonster.dark_fencer',7.00,13.00,81,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1837,558,1082,523,278,0,333,0,0,0,0,27,165,0,0,'LAST_HIT','false'),
(14819,14819,'Dark Panther',0,'',0,'LineageMonster.dark_fencer',7.00,13.00,81,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1846,558,1082,523,278,0,333,0,0,0,0,27,165,0,0,'LAST_HIT','false'),
(14820,14820,'Dark Panther',0,'',0,'LineageMonster.dark_fencer',7.00,13.00,81,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1854,558,1082,523,278,0,333,0,0,0,0,27,165,0,0,'LAST_HIT','false'),
(14821,14821,'Dark Panther',0,'',0,'LineageMonster.dark_fencer',7.00,13.00,81,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1863,558,1082,523,278,0,333,0,0,0,0,27,165,0,0,'LAST_HIT','false'),
(14822,14822,'Dark Panther',0,'',0,'LineageMonster.dark_fencer',7.00,13.00,82,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1871,558,1082,523,278,0,333,0,0,0,0,27,165,0,0,'LAST_HIT','false'),
(14823,14823,'Dark Panther',0,'',0,'LineageMonster.dark_fencer',7.00,13.00,82,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1880,558,1082,523,278,0,333,0,0,0,0,27,165,0,0,'LAST_HIT','false'),
(14824,14824,'Dark Panther',0,'',0,'LineageMonster.dark_fencer',7.00,13.00,82,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1900,562,1095,526,278,0,333,0,0,0,0,27,165,0,0,'LAST_HIT','false'),
(14825,14825,'Dark Panther',0,'',0,'LineageMonster.dark_fencer',7.00,13.00,82,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1909,562,1095,526,278,0,333,0,0,0,0,27,165,0,0,'LAST_HIT','false'),
(14826,14826,'Dark Panther',0,'',0,'LineageMonster.dark_fencer',7.00,13.00,83,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1917,562,1095,526,278,0,333,0,0,0,0,27,165,0,0,'LAST_HIT','false'),
(14827,14827,'Dark Panther',0,'',0,'LineageMonster.dark_fencer',7.00,13.00,83,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1926,562,1095,526,278,0,333,0,0,0,0,27,165,0,0,'LAST_HIT','false'),
(14828,14828,'Dark Panther',0,'',0,'LineageMonster.dark_fencer',7.00,13.00,83,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1935,562,1095,526,278,0,333,0,0,0,0,27,165,0,0,'LAST_HIT','false'),
(14829,14829,'Dark Panther',0,'',0,'LineageMonster.dark_fencer',7.00,13.00,83,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1943,562,1095,526,278,0,333,0,0,0,0,27,165,0,0,'LAST_HIT','false'),
(14830,14830,'Dark Panther',0,'',0,'LineageMonster.dark_fencer',7.00,13.00,84,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1952,562,1095,526,278,0,333,0,0,0,0,27,165,0,0,'LAST_HIT','false'),
(14831,14831,'Dark Panther',0,'',0,'LineageMonster.dark_fencer',7.00,13.00,84,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1961,562,1095,526,278,0,333,0,0,0,0,27,165,0,0,'LAST_HIT','false'),
(14832,14832,'Dark Panther',0,'',0,'LineageMonster.dark_fencer',7.00,13.00,84,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1969,562,1095,526,278,0,333,0,0,0,0,27,165,0,0,'LAST_HIT','false'),
(14833,14833,'Dark Panther',0,'',0,'LineageMonster.dark_fencer',7.00,13.00,84,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1978,562,1095,526,278,0,333,0,0,0,0,27,165,0,0,'LAST_HIT','false'),
(14834,14834,'Dark Panther',0,'',0,'LineageMonster.dark_fencer',7.00,13.00,85,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1987,562,1095,526,278,0,333,0,0,0,0,27,165,0,0,'LAST_HIT','false'),
(14835,14835,'Dark Panther',0,'',0,'LineageMonster.dark_fencer',7.00,13.00,85,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1995,562,1095,526,278,0,333,0,0,0,0,27,165,0,0,'LAST_HIT','false'),
(14836,14836,'Feline King',0,'',0,'LineageMonster3.king_of_cat',6.00,16.01,80,'male','L2Pet',40,6053,2143,13.43,3.09,40,43,30,21,20,25,0,0,2646,633,2006,593,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14837,14837,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus',13.50,17.00,80,'male','L2Pet',40,6053,2143,13.43,3.09,40,43,30,21,20,25,0,0,2646,633,2006,593,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14838,14838,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight',12.50,33.50,80,'male','L2Pet',40,6053,2143,13.43,3.09,40,43,30,21,20,25,0,0,2646,633,2006,593,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14839,14839,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon',45.00,47.50,68,'male','L2SiegeSummon',40,79000,1138,12.25,3.18,40,43,30,21,20,25,0,0,22,1314,428,1354,165,0,333,0,0,0,0,44,44,0,0,'LAST_HIT','false'),
(14840,14840,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon',45.00,47.50,78,'male','L2SiegeSummon',40,79000,1138,12.25,3.18,40,43,30,21,20,25,0,0,22,1314,428,1354,165,0,333,0,0,0,0,44,44,0,0,'LAST_HIT','false'),
(14841,14841,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon',45.00,47.50,78,'male','L2SiegeSummon',40,79000,1138,12.25,3.18,40,43,30,21,20,25,0,0,22,1314,428,1354,165,0,333,0,0,0,0,44,44,0,0,'LAST_HIT','false'),
(14842,14842,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon',45.00,47.50,78,'male','L2SiegeSummon',40,79000,1138,12.25,3.18,40,43,30,21,20,25,0,0,22,1314,428,1354,165,0,333,0,0,0,0,44,44,0,0,'LAST_HIT','false'),
(14843,14843,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon',45.00,47.50,78,'male','L2SiegeSummon',40,79000,1138,12.25,3.18,40,43,30,21,20,25,0,0,22,1314,428,1354,165,0,333,0,0,0,0,44,44,0,0,'LAST_HIT','false'),
(14844,14844,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon',45.00,47.50,79,'male','L2SiegeSummon',40,79000,1138,12.25,3.18,40,43,30,21,20,25,0,0,22,1314,428,1354,165,0,333,0,0,0,0,44,44,0,0,'LAST_HIT','false'),
(14845,14845,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon',45.00,47.50,79,'male','L2SiegeSummon',40,79000,1138,12.25,3.18,40,43,30,21,20,25,0,0,22,1314,428,1354,165,0,333,0,0,0,0,44,44,0,0,'LAST_HIT','false'),
(14846,14846,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon',45.00,47.50,79,'male','L2SiegeSummon',40,79000,1138,12.25,3.18,40,43,30,21,20,25,0,0,22,1314,428,1354,165,0,333,0,0,0,0,44,44,0,0,'LAST_HIT','false'),
(14847,14847,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon',45.00,47.50,79,'male','L2SiegeSummon',40,79000,1138,12.25,3.18,40,43,30,21,20,25,0,0,22,1314,428,1354,165,0,333,0,0,0,0,44,44,0,0,'LAST_HIT','false'),
(14848,14848,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon',45.00,47.50,80,'male','L2SiegeSummon',40,79000,1138,12.25,3.18,40,43,30,21,20,25,0,0,22,1314,428,1354,165,0,333,0,0,0,0,44,44,0,0,'LAST_HIT','false'),
(14849,14849,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon',45.00,47.50,80,'male','L2SiegeSummon',40,79000,1138,12.25,3.18,40,43,30,21,20,25,0,0,22,1314,428,1354,165,0,333,0,0,0,0,44,44,0,0,'LAST_HIT','false'),
(14850,14850,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon',45.00,47.50,80,'male','L2SiegeSummon',40,79000,1138,12.25,3.18,40,43,30,21,20,25,0,0,22,1314,428,1354,165,0,333,0,0,0,0,44,44,0,0,'LAST_HIT','false'),
(14851,14851,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon',45.00,47.50,80,'male','L2SiegeSummon',40,79000,1138,12.25,3.18,40,43,30,21,20,25,0,0,22,1314,428,1354,165,0,333,0,0,0,0,44,44,0,0,'LAST_HIT','false'),
(14852,14852,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon',45.00,47.50,81,'male','L2SiegeSummon',40,79000,1138,12.25,3.18,40,43,30,21,20,25,0,0,22,1314,428,1354,165,0,333,0,0,0,0,44,44,0,0,'LAST_HIT','false'),
(14853,14853,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon',45.00,47.50,81,'male','L2SiegeSummon',40,79000,1138,12.25,3.18,40,43,30,21,20,25,0,0,22,1314,428,1354,165,0,333,0,0,0,0,44,44,0,0,'LAST_HIT','false'),
(14854,14854,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon',45.00,47.50,81,'male','L2SiegeSummon',40,79000,1138,12.25,3.18,40,43,30,21,20,25,0,0,22,1314,428,1354,165,0,333,0,0,0,0,44,44,0,0,'LAST_HIT','false'),
(14855,14855,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon',45.00,47.50,81,'male','L2SiegeSummon',40,79000,1138,12.25,3.18,40,43,30,21,20,25,0,0,22,1314,428,1354,165,0,333,0,0,0,0,44,44,0,0,'LAST_HIT','false'),
(14856,14856,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon',45.00,47.50,82,'male','L2SiegeSummon',40,79000,1138,12.25,3.18,40,43,30,21,20,25,0,0,22,1314,428,1354,165,0,333,0,0,0,0,44,44,0,0,'LAST_HIT','false'),
(14857,14857,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon',45.00,47.50,82,'male','L2SiegeSummon',40,79000,1138,12.25,3.18,40,43,30,21,20,25,0,0,22,1314,428,1354,165,0,333,0,0,0,0,44,44,0,0,'LAST_HIT','false'),
(14858,14858,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon',45.00,47.50,82,'male','L2SiegeSummon',40,79000,1138,12.25,3.18,40,43,30,21,20,25,0,0,22,1314,428,1354,165,0,333,0,0,0,0,44,44,0,0,'LAST_HIT','false'),
(14859,14859,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon',45.00,47.50,82,'male','L2SiegeSummon',40,79000,1138,12.25,3.18,40,43,30,21,20,25,0,0,22,1314,428,1354,165,0,333,0,0,0,0,44,44,0,0,'LAST_HIT','false'),
(14860,14860,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon',45.00,47.50,83,'male','L2SiegeSummon',40,79000,1138,12.25,3.18,40,43,30,21,20,25,0,0,22,1314,428,1354,165,0,333,0,0,0,0,44,44,0,0,'LAST_HIT','false'),
(14861,14861,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon',45.00,47.50,83,'male','L2SiegeSummon',40,79000,1138,12.25,3.18,40,43,30,21,20,25,0,0,22,1314,428,1354,165,0,333,0,0,0,0,44,44,0,0,'LAST_HIT','false'),
(14862,14862,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon',45.00,47.50,83,'male','L2SiegeSummon',40,79000,1138,12.25,3.18,40,43,30,21,20,25,0,0,22,1314,428,1354,165,0,333,0,0,0,0,44,44,0,0,'LAST_HIT','false'),
(14863,14863,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon',45.00,47.50,83,'male','L2SiegeSummon',40,79000,1138,12.25,3.18,40,43,30,21,20,25,0,0,22,1314,428,1354,165,0,333,0,0,0,0,44,44,0,0,'LAST_HIT','false'),
(14864,14864,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon',45.00,47.50,84,'male','L2SiegeSummon',40,79000,1138,12.25,3.18,40,43,30,21,20,25,0,0,22,1314,428,1354,165,0,333,0,0,0,0,44,44,0,0,'LAST_HIT','false'),
(14865,14865,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon',45.00,47.50,84,'male','L2SiegeSummon',40,79000,1138,12.25,3.18,40,43,30,21,20,25,0,0,22,1314,428,1354,165,0,333,0,0,0,0,44,44,0,0,'LAST_HIT','false'),
(14866,14866,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon',45.00,47.50,84,'male','L2SiegeSummon',40,79000,1138,12.25,3.18,40,43,30,21,20,25,0,0,22,1314,428,1354,165,0,333,0,0,0,0,44,44,0,0,'LAST_HIT','false'),
(14867,14867,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon',45.00,47.50,84,'male','L2SiegeSummon',40,79000,1138,12.25,3.18,40,43,30,21,20,25,0,0,22,1314,428,1354,165,0,333,0,0,0,0,44,44,0,0,'LAST_HIT','false'),
(14868,14868,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon',45.00,47.50,85,'male','L2SiegeSummon',40,79000,1138,12.25,3.18,40,43,30,21,20,25,0,0,22,1314,428,1354,165,0,333,0,0,0,0,44,44,0,0,'LAST_HIT','false'),
(14869,14869,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon',45.00,47.50,85,'male','L2SiegeSummon',40,79000,1138,12.25,3.18,40,43,30,21,20,25,0,0,22,1314,428,1354,165,0,333,0,0,0,0,44,44,0,0,'LAST_HIT','false'),
(14870,14870,'Divine Beast',0,'',0,'LineageMonster4.Divine_beast',31.00,15.50,80,'male','L2Pet',40,5025,2143,13.43,3.09,40,43,30,21,20,25,0,0,1900,562,1095,526,278,0,333,0,0,0,0,27,165,0,0,'LAST_HIT','false'),
(14871,14871,'Feline King',0,'',0,'LineageMonster3.king_of_cat',6.00,16.01,80,'male','L2Pet',40,6120,2174,13.43,3.09,40,43,30,21,20,25,0,0,2705,641,2059,600,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14872,14872,'Feline King',0,'',0,'LineageMonster3.king_of_cat',6.00,16.01,80,'male','L2Pet',40,6187,2205,13.43,3.09,40,43,30,21,20,25,0,0,2765,649,2113,607,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14873,14873,'Feline King',0,'',0,'LineageMonster3.king_of_cat',6.00,16.01,81,'male','L2Pet',40,6255,2237,13.43,3.09,40,43,30,21,20,25,0,0,2827,657,2168,614,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14874,14874,'Feline King',0,'',0,'LineageMonster3.king_of_cat',6.00,16.01,81,'male','L2Pet',40,6324,2269,13.43,3.09,40,43,30,21,20,25,0,0,2890,665,2225,621,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14875,14875,'Feline King',0,'',0,'LineageMonster3.king_of_cat',6.00,16.01,81,'male','L2Pet',40,6394,2302,13.43,3.09,40,43,30,21,20,25,0,0,2955,673,2283,628,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14876,14876,'Feline King',0,'',0,'LineageMonster3.king_of_cat',6.00,16.01,82,'male','L2Pet',40,6464,2335,13.43,3.09,40,43,30,21,20,25,0,0,3021,681,2343,636,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14877,14877,'Feline King',0,'',0,'LineageMonster3.king_of_cat',6.00,16.01,82,'male','L2Pet',40,6535,2369,13.43,3.09,40,43,30,21,20,25,0,0,3089,689,2404,644,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14878,14878,'Feline King',0,'',0,'LineageMonster3.king_of_cat',6.00,16.01,82,'male','L2Pet',40,6607,2403,13.43,3.09,40,43,30,21,20,25,0,0,3158,698,2467,652,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14879,14879,'Feline King',0,'',0,'LineageMonster3.king_of_cat',6.00,16.01,83,'male','L2Pet',40,6680,2438,13.43,3.09,40,43,30,21,20,25,0,0,3229,707,2532,660,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14880,14880,'Feline King',0,'',0,'LineageMonster3.king_of_cat',6.00,16.01,83,'male','L2Pet',40,6754,2473,13.43,3.09,40,43,30,21,20,25,0,0,3301,716,2598,668,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14881,14881,'Feline King',0,'',0,'LineageMonster3.king_of_cat',6.00,16.01,83,'male','L2Pet',40,6828,2509,13.43,3.09,40,43,30,21,20,25,0,0,3375,725,2666,676,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14882,14882,'Feline King',0,'',0,'LineageMonster3.king_of_cat',6.00,16.01,84,'male','L2Pet',40,6903,2545,13.43,3.09,40,43,30,21,20,25,0,0,3451,734,2736,684,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14883,14883,'Feline King',0,'',0,'LineageMonster3.king_of_cat',6.00,16.01,84,'male','L2Pet',40,6979,2582,13.43,3.09,40,43,30,21,20,25,0,0,3528,743,2808,692,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14884,14884,'Feline King',0,'',0,'LineageMonster3.king_of_cat',6.00,16.01,84,'male','L2Pet',40,7056,2619,13.43,3.09,40,43,30,21,20,25,0,0,3607,752,2882,700,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14885,14885,'Feline King',0,'',0,'LineageMonster3.king_of_cat',6.00,16.01,85,'male','L2Pet',40,7134,2657,13.43,3.09,40,43,30,21,20,25,0,0,3688,761,2958,708,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14886,14886,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus',13.50,17.00,80,'male','L2Pet',40,6120,2174,13.43,3.09,40,43,30,21,20,25,0,0,2705,641,2059,600,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14887,14887,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus',13.50,17.00,80,'male','L2Pet',40,6187,2205,13.43,3.09,40,43,30,21,20,25,0,0,2765,649,2113,607,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14888,14888,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus',13.50,17.00,81,'male','L2Pet',40,6255,2237,13.43,3.09,40,43,30,21,20,25,0,0,2827,657,2168,614,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14889,14889,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus',13.50,17.00,81,'male','L2Pet',40,6324,2269,13.43,3.09,40,43,30,21,20,25,0,0,2890,665,2225,621,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14890,14890,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus',13.50,17.00,81,'male','L2Pet',40,6394,2302,13.43,3.09,40,43,30,21,20,25,0,0,2955,673,2283,628,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14891,14891,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus',13.50,17.00,82,'male','L2Pet',40,6464,2335,13.43,3.09,40,43,30,21,20,25,0,0,3021,681,2343,636,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14892,14892,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus',13.50,17.00,82,'male','L2Pet',40,6535,2369,13.43,3.09,40,43,30,21,20,25,0,0,3089,689,2404,644,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14893,14893,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus',13.50,17.00,82,'male','L2Pet',40,6607,2403,13.43,3.09,40,43,30,21,20,25,0,0,3158,698,2467,652,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14894,14894,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus',13.50,17.00,83,'male','L2Pet',40,6680,2438,13.43,3.09,40,43,30,21,20,25,0,0,3229,707,2532,660,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14895,14895,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus',13.50,17.00,83,'male','L2Pet',40,6754,2473,13.43,3.09,40,43,30,21,20,25,0,0,3301,716,2598,668,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14896,14896,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus',13.50,17.00,83,'male','L2Pet',40,6828,2509,13.43,3.09,40,43,30,21,20,25,0,0,3375,725,2666,676,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14897,14897,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus',13.50,17.00,84,'male','L2Pet',40,6903,2545,13.43,3.09,40,43,30,21,20,25,0,0,3451,734,2736,684,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14898,14898,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus',13.50,17.00,84,'male','L2Pet',40,6979,2582,13.43,3.09,40,43,30,21,20,25,0,0,3528,743,2808,692,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14899,14899,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus',13.50,17.00,84,'male','L2Pet',40,7056,2619,13.43,3.09,40,43,30,21,20,25,0,0,3607,752,2882,700,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14900,14900,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus',13.50,17.00,85,'male','L2Pet',40,7134,2657,13.43,3.09,40,43,30,21,20,25,0,0,3688,761,2958,708,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14901,14901,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight',12.50,33.50,80,'male','L2Pet',40,6120,2174,13.43,3.09,40,43,30,21,20,25,0,0,2705,641,2059,600,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14902,14902,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight',12.50,33.50,80,'male','L2Pet',40,6187,2205,13.43,3.09,40,43,30,21,20,25,0,0,2765,649,2113,607,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14903,14903,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight',12.50,33.50,81,'male','L2Pet',40,6255,2237,13.43,3.09,40,43,30,21,20,25,0,0,2827,657,2168,614,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14904,14904,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight',12.50,33.50,81,'male','L2Pet',40,6324,2269,13.43,3.09,40,43,30,21,20,25,0,0,2890,665,2225,621,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14905,14905,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight',12.50,33.50,81,'male','L2Pet',40,6394,2302,13.43,3.09,40,43,30,21,20,25,0,0,2955,673,2283,628,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14906,14906,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight',12.50,33.50,82,'male','L2Pet',40,6464,2335,13.43,3.09,40,43,30,21,20,25,0,0,3021,681,2343,636,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14907,14907,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight',12.50,33.50,82,'male','L2Pet',40,6535,2369,13.43,3.09,40,43,30,21,20,25,0,0,3089,689,2404,644,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14908,14908,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight',12.50,33.50,82,'male','L2Pet',40,6607,2403,13.43,3.09,40,43,30,21,20,25,0,0,3158,698,2467,652,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14909,14909,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight',12.50,33.50,83,'male','L2Pet',40,6680,2438,13.43,3.09,40,43,30,21,20,25,0,0,3229,707,2532,660,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14910,14910,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight',12.50,33.50,83,'male','L2Pet',40,6754,2473,13.43,3.09,40,43,30,21,20,25,0,0,3301,716,2598,668,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14911,14911,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight',12.50,33.50,83,'male','L2Pet',40,6828,2509,13.43,3.09,40,43,30,21,20,25,0,0,3375,725,2666,676,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14912,14912,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight',12.50,33.50,84,'male','L2Pet',40,6903,2545,13.43,3.09,40,43,30,21,20,25,0,0,3451,734,2736,684,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14913,14913,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight',12.50,33.50,84,'male','L2Pet',40,6979,2582,13.43,3.09,40,43,30,21,20,25,0,0,3528,743,2808,692,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14914,14914,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight',12.50,33.50,84,'male','L2Pet',40,7056,2619,13.43,3.09,40,43,30,21,20,25,0,0,3607,752,2882,700,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14915,14915,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight',12.50,33.50,85,'male','L2Pet',40,7134,2657,13.43,3.09,40,43,30,21,20,25,0,0,3688,761,2958,708,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14916,14916,'Tigress',0,'',0,'LineageMonster.saber_toothed_tiger_070p',22.00,18.40,85,'male','L2Pet',40,7134,2657,13.43,3.09,40,43,30,21,20,25,0,0,3688,761,2958,708,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14917,14917,'Tigress',0,'',0,'LineageMonster.saber_toothed_tiger_070p',22.00,18.40,85,'male','L2Pet',40,7134,2657,13.43,3.09,40,43,30,21,20,25,0,0,3688,761,2958,708,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(14918,14918,'Imperial Phoenix',0,'',0,'LineageMonster4.phoenix',7.00,34.00,85,'male','L2Pet',40,7134,2657,13.43,3.09,40,43,30,21,20,25,0,0,3688,761,2958,708,278,0,333,0,0,0,0,52,198,0,0,'LAST_HIT','false'),
(16013,16013,'Trained Buffalo',0,'',0,'LineageMonster2.buffalo',22.00,31.00,67,'male','L2TamedBeast',40,3626,1388,23.70,2.78,40,43,30,21,20,10,0,0,1169,439,681,356,278,0,333,0,0,0,0,22,187,0,0,'LAST_HIT','false'),
(16014,16014,'Trained Buffalo',0,'',0,'LineageMonster2.buffalo',22.00,31.00,67,'male','L2TamedBeast',40,3626,1388,23.70,2.78,40,43,30,21,20,10,0,0,1169,439,681,356,278,0,333,0,0,0,0,22,187,0,0,'LAST_HIT','false'),
(16015,16015,'Trained Cougar',0,'',0,'LineageMonster.saber_toothed_tiger',34.00,28.00,69,'male','L2TamedBeast',40,3784,1458,23.70,2.78,40,43,30,21,20,10,0,0,1265,460,746,373,278,0,333,0,0,0,0,66,192,0,0,'LAST_HIT','false'),
(16016,16016,'Trained Cougar',0,'',0,'LineageMonster.saber_toothed_tiger',34.00,28.00,69,'male','L2TamedBeast',40,3784,1458,23.70,2.78,40,43,30,21,20,10,0,0,1265,460,746,373,278,0,333,0,0,0,0,66,192,0,0,'LAST_HIT','false'),
(16017,16017,'Trained Kookaburra',0,'',0,'LineageMonster2.pet_ostrich',10.00,33.00,65,'male','L2TamedBeast',40,3465,1319,23.70,2.78,40,43,30,21,20,10,0,0,1077,418,619,340,278,0,333,0,0,0,0,25,209,0,0,'LAST_HIT','false'),
(16018,16018,'Trained Kookaburra',0,'',0,'LineageMonster2.pet_ostrich',10.00,33.00,65,'male','L2TamedBeast',40,3465,1319,23.70,2.78,40,43,30,21,20,10,0,0,1077,418,619,340,278,0,333,0,0,0,0,25,209,0,0,'LAST_HIT','false'),
(16019,16019,'Tiny Baby Buffalo',0,'',0,'LineageMonster2.baby_buffalo',20.00,31.00,99,'male','L2Monster',40,400000,9999,13.43,3.09,40,43,30,21,20,10,0,0,9000,5000,6000,6000,300,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(16020,16020,'Tame Tiny Baby Buffalo',0,'',0,'LineageMonster2.baby_buffalo',20.00,31.00,99,'male','L2Monster',40,400000,9999,13.43,3.09,40,43,30,21,20,10,0,0,9000,5000,6000,6000,300,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(16021,16021,'Tiny Baby Cougar',0,'',0,'LineageMonster2.baby_tiger',20.00,31.00,99,'male','L2Monster',40,400000,9999,13.43,3.09,40,43,30,21,20,10,0,0,9000,5000,6000,6000,300,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(16022,16022,'Tame Tiny Baby Cougar',0,'',0,'LineageMonster2.baby_tiger',20.00,31.00,99,'male','L2Monster',40,400000,9999,13.43,3.09,40,43,30,21,20,10,0,0,9000,5000,6000,6000,300,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(16023,16023,'Tiny Baby Kookaburra',0,'',0,'LineageMonster2.baby_ostrich',20.00,31.00,99,'male','L2Monster',40,400000,9999,13.43,3.09,40,43,30,21,20,10,0,0,9000,5000,6000,6000,300,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(16024,16024,'Tame Tiny Baby Kookaburra',0,'',0,'LineageMonster2.baby_ostrich',20.00,31.00,99,'male','L2Monster',40,400000,9999,13.43,3.09,40,43,30,21,20,10,0,0,9000,5000,6000,6000,300,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(16025,16025,'Great Wolf',0,'',0,'LineageMonster4.Pet_Wolf_B',32.00,21.41,55,'male','L2Pet',40,2444,2444,0.00,0.00,40,43,30,21,20,25,0,0,500,500,500,500,304,0,333,9661,0,NULL,0,45,170,0,0,'LAST_HIT','false'),
(16026,16026,'Beastly Agathion',0,'',0,'LineageNPC2.Agathion_BF',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(16027,16027,'Rainbow Agathion',0,'',0,'LineageNPC2.Agathion_RA',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(16028,16028,'Lord Agathion',0,'',0,'LineageNPC2.Agathion_CL',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(16029,16029,'Fortress Agathion',0,'',0,'LineageNPC2.Agathion_FT',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(16030,16030,'Great Wolf',0,'',0,'LineageMonster4.Pet_Wolf_Ba',32.00,23.56,55,'male','L2Pet',40,2444,2444,0.00,0.00,40,43,30,21,20,25,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(16031,16031,'Little Angel Agathion',0,'',0,'LineageNpc2.Agathion_ag',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(16032,16032,'Little Devil Agathion',0,'',0,'LineageNpc2.Agathion_st',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(16033,16033,'Rudolph Agathion',0,'',0,'LineageNpc2.Agathion_rd',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(16034,16034,'Improved Baby Buffalo',0,'',0,'LineageMonster2.baby_buffalo',12.00,15.00,55,'male','L2BabyPet',40,751,331,2.37,1.53,40,43,30,21,20,25,0,0,88,119,37,112,282,0,333,0,0,0,0,33,132,0,0,'LAST_HIT','false'),
(16035,16035,'Improved Baby Kookaburra',0,'',0,'LineageMonster2.baby_ostrich',7.00,15.00,55,'male','L2BabyPet',40,751,331,2.37,1.53,40,43,30,21,20,25,0,0,88,119,37,112,282,0,333,0,0,0,0,14,132,0,0,'LAST_HIT','false'),
(16036,16036,'Improved Baby Cougar',0,'',0,'LineageMonster2.baby_tiger',11.00,15.70,55,'male','L2BabyPet',40,751,331,2.37,1.53,40,43,30,21,20,25,0,0,88,119,37,112,278,0,333,0,0,0,0,28,120,0,0,'LAST_HIT','false'),
(16037,16037,'Great Snow Wolf',0,'',0,'LineageMonster4.Pet_Wolf_Ba',32.00,23.56,55,'male','L2Pet',40,2444,2444,0.00,0.00,40,43,30,21,20,25,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(16038,16038,'Red Wind Strider',0,'',0,'LineageMonster.strider',23.00,31.00,55,'male','L2Pet',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(16039,16039,'Red Star Strider',0,'',0,'LineageMonster.strider',23.00,31.00,55,'male','L2Pet',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(16040,16040,'Red Twilight Strider',0,'',0,'LineageMonster.strider',23.00,31.00,55,'male','L2Pet',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(16041,16041,'Fenrir',0,'',0,'LineageMonster4.Pet_Wolf_Ba',32.00,23.56,70,'male','L2Pet',40,2444,2444,0.00,0.00,40,43,30,21,20,25,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(16042,16042,'Snow Fenrir',0,'',0,'LineageMonster4.Pet_Wolf_Ba',32.00,23.56,70,'male','L2Pet',40,2444,2444,0.00,0.00,40,43,30,21,20,25,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(16043,16043,'Fox Shaman',0,'',0,'LineageMonster4.foxian_wizard_pet',10.00,18.50,55,'male','L2Pet',40,2643,988,2.37,1.53,35,37,30,32,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,28,120,0,0,'LAST_HIT','false'),
(16044,16044,'Wild Beast Fighter',0,'',0,'LineageMonster4.beast_fighter_pet',32.00,15.70,55,'male','L2Pet',40,2643,988,2.37,1.53,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(16045,16045,'White Weasel',0,'',0,'LineageMonster4.ferret_pet',6.50,12.50,55,'male','L2Pet',40,2643,988,2.37,1.53,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,28,120,0,0,'LAST_HIT','false'),
(16046,16046,'Fairy Princess',0,'',0,'LineageMonster4.fairy_princess_pet',10.00,15.00,55,'female','L2Pet',40,2643,988,2.37,1.53,35,37,30,32,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,28,120,0,0,'LAST_HIT','false'),
(16049,16049,'Love Agathion',0,'',0,'LineageNpc2.agathion_love',13.00,11.50,55,'male','L2Npc',40,2643,988,0.00,0.00,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(16050,16050,'Owl Monk',0,'',0,'LineageMonster4.owl_wizard_the_pet',40.00,27.50,55,'male','L2Pet',40,2643,988,2.37,1.53,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,80,120,0,0,'LAST_HIT','false'),
(16051,16051,'Spirit Shaman',0,'',0,'LineageMonster4.sprit_magician_the_pet',12.80,15.60,55,'male','L2Pet',40,2643,988,2.37,1.53,35,37,30,32,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,80,120,0,0,'LAST_HIT','false'),
(16052,16052,'Toy Knight',0,'',0,'LineageMonster4.toy_knight_the_pet',10.00,15.00,55,'male','L2Pet',40,2643,988,2.37,1.53,40,43,30,21,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,80,120,0,0,'LAST_HIT','false'),
(16053,16053,'Turtle Ascetic',0,'',0,'LineageMonster4.turtle_buffer_the_pet',11.00,10.00,55,'male','L2Pet',40,2643,988,2.37,1.53,38,40,30,26,20,25,0,0,665,322,311,262,253,0,333,0,0,0,0,80,120,0,0,'LAST_HIT','false'),
(16054,16054,'Monkey',0,'',0,'LineageNpc2.agathion_mk',32.00,23.56,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(16055,16055,'Griffon',0,'',0,'LineageNpc2.agathion_gr',32.00,23.56,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(16056,16056,'Joy',0,'',0,'LineageNpc2.agathion_happy',32.00,23.56,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(16057,16057,'Sorrow',0,'',0,'LineageNpc2.agathion_sorrow',32.00,23.56,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(16058,16058,'Anger',0,'',0,'LineageNpc2.agathion_anger',32.00,23.56,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(16059,16059,'Boy Bear',0,'',0,'LineageNPC2.teddy_bear_boy',32.00,23.56,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(16060,16060,'Girl Bear',0,'',0,'LineageNPC2.teddy_bear_girl',32.00,23.56,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(16061,16061,'Collection Device',0,'',0,'LineageNPC2.collecting_golem',32.00,23.56,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(16062,16062,'Knight',0,'',0,'LineageNPC2.agathion_pvp',32.00,23.56,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(16063,16063,'Saerom',0,'',0,'LineageNPC2.agathion_gift',32.00,23.56,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(16064,16064,'Juju',0,'',0,'LineageNPC2.agathion_cupi',13.00,11.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,30,132,0,0,'LAST_HIT','false'),
(16065,16065,'Oink Oink',0,'',0,'LineageNPC2.agathion_pig',0.01,5.75,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(16066,16066,'Light of Dawn',0,'',0,'LineageNPC2.agathion_pig',0.01,5.75,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(16067,16067,'Deinonychus',0,'',0,'LineageMonster3.deinonychus',14.00,14.30,55,'male','L2Pet',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(16068,16068,'Guardian\'s Strider',0,'',0,'LineageMonster4.dragon_descendant_2a',27.00,33.50,55,'male','L2Pet',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(16069,16069,'Pona',0,'',0,'LineageNPC2.agathion_pona',15.00,25.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(16070,16070,'Towbat',0,'',0,'LineageNPC2.agathion_tow',0.01,5.75,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18001,18001,'Blood Queen',0,'',0,'LineageMonster.bloody_queen',14.00,40.00,60,'female','L2Monster',40,3054,1150,10.27,2.45,40,43,30,21,20,10,4536,394,860,368,478,299,278,300,333,0,0,0,0,80,160,0,0,'LAST_HIT','false'),
(18002,18002,'Blood Queen',0,'',0,'LineageMonster.bloody_queen',14.00,40.00,60,'female','L2Monster',40,3054,1150,10.27,2.45,40,43,30,21,20,10,4320,375,946,368,478,299,282,300,333,0,0,0,0,88,176,0,0,'LAST_HIT','false'),
(18003,18003,'Bearded Keltir',0,'',0,'LineageMonster.keltir',9.50,10.00,1,'male','L2Monster',40,62,44,3.16,0.91,40,43,30,21,20,10,29,2,4,39,3,32,278,0,333,0,0,0,0,25,60,0,0,'LAST_HIT','false'),
(18004,18004,'Susceptor Prime',0,'',0,'LineageMonster.susceptor_prime',45.00,72.00,49,'male','L2Monster',50,2168,799,8.69,2.14,40,43,30,21,20,10,0,1,480,270,247,219,282,0,333,0,0,0,0,85,187,0,0,'LAST_HIT','false'),
(18005,18005,'Mimic',0,'',0,'LineageMonster.mimic',8.50,8.50,52,'male','L2Monster',40,2479,892,10.27,2.45,40,43,30,21,20,10,3244,251,588,304,300,239,278,0,333,0,0,0,0,88,171,0,0,'LAST_HIT','false'),
(18006,18006,'Maruk Lord',0,'',0,'LineageMonster.death_blader',15.00,45.00,68,'male','L2Monster',40,3825,1423,11.85,2.78,40,43,30,21,20,10,6057,586,1256,464,713,365,278,500,333,1472,0,0,0,110,187,1,0,'LAST_HIT','false'),
(18007,18007,'Limal Karinness',0,'',0,'LineageMonster.bloody_queen',14.00,40.00,69,'female','L2Monster',40,3784,1458,11.85,2.78,40,43,30,21,20,10,5951,582,1392,460,821,373,278,500,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(18008,18008,'Karik',0,'',0,'LineageMonster.karik',25.00,90.00,70,'male','L2Monster',40,3862,1493,11.85,2.78,40,43,30,21,20,10,6370,632,1445,470,858,382,278,500,333,0,0,0,0,40,220,0,0,'LAST_HIT','false'),
(18009,18009,'Offering of Branded Elder',0,'',0,'LineageMonster.orc_fighter_bi',12.00,26.40,34,'male','L2FestivalMonster',40,1164,430,7.11,1.84,40,43,30,21,20,10,1754,102,178,163,82,132,278,0,333,127,0,0,0,49,33,0,0,'LAST_HIT','false'),
(18010,18010,'Offering of the Branded',0,'',0,'LineageMonster.orc',10.00,21.00,32,'male','L2FestivalMonster',40,1056,397,7.11,1.84,40,43,30,21,20,10,1523,86,134,129,69,123,237,0,333,218,0,0,0,49,33,0,0,'LAST_HIT','false'),
(18011,18011,'Offering of Branded Archer',0,'',0,'LineageMonster.orc_archer',14.00,25.00,28,'male','L2FestivalMonster',500,859,334,5.53,1.53,40,43,30,21,20,10,1001,53,251,110,49,106,249,0,333,14,0,0,0,49,66,0,0,'LAST_HIT','false'),
(18012,18012,'Offering of Branded Warrior',0,'',0,'LineageMonster.orc_champion',10.00,23.00,29,'male','L2FestivalMonster',40,906,349,5.53,1.53,40,43,30,21,20,10,1026,55,122,135,53,110,278,0,333,125,0,0,0,49,121,0,0,'LAST_HIT','false'),
(18013,18013,'Offering of Branded Follower',0,'',0,'LineageMonster.orc_shaman',9.00,22.00,29,'male','L2FestivalMonster',40,906,349,5.53,1.53,40,43,30,21,20,10,1227,66,107,115,53,110,237,0,333,316,0,0,0,49,165,0,0,'LAST_HIT','false'),
(18014,18014,'Offering of Branded Berserker',0,'',0,'LineageMonster.virud_lizardman',10.00,23.00,37,'male','L2FestivalMonster',40,1338,480,7.11,1.84,40,43,30,21,20,10,2276,140,222,182,104,147,278,0,333,292,0,0,0,47,126,0,0,'LAST_HIT','false'),
(18015,18015,'Offering of Branded Zealot',0,'',0,'LineageMonster.orc_fighter_bi',12.00,26.40,34,'male','L2FestivalMonster',40,1164,430,7.11,1.84,40,43,30,21,20,10,1650,96,156,138,82,132,237,0,333,158,0,0,0,49,170,0,0,'LAST_HIT','false'),
(18016,18016,'Offering of Branded Marksman',0,'',0,'LineageMonster.orc_archer_20_bi',16.00,30.00,32,'male','L2FestivalMonster',500,1056,397,7.11,1.84,40,43,30,21,20,10,1265,71,342,129,69,123,249,0,333,273,0,0,0,49,143,0,0,'LAST_HIT','false'),
(18017,18017,'Offering of Branded Disciple',0,'',0,'LineageMonster.batur_orc',9.00,21.50,34,'male','L2FestivalMonster',40,1164,430,7.11,1.84,40,43,30,21,20,10,1650,96,178,163,82,132,278,0,333,129,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18018,18018,'Offering of Branded Saint',0,'',0,'LineageMonster.batur_orc_20_bi',10.00,25.30,39,'male','L2FestivalMonster',40,1462,514,7.11,1.84,40,43,30,21,20,10,2171,138,255,195,121,158,278,0,333,72,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18019,18019,'Apostate\'s Offering Elder',0,'',0,'LineageMonster.orc_champion_20_bi',12.00,27.60,45,'male','L2FestivalMonster',40,1870,677,8.69,2.14,40,43,30,21,20,10,3013,210,377,238,188,193,278,0,333,72,0,0,0,49,33,0,0,'LAST_HIT','false'),
(18020,18020,'Apostate\'s Offering',0,'',0,'LineageMonster.orc_fighter',12.00,22.00,43,'male','L2FestivalMonster',40,1728,618,8.69,2.14,40,43,30,21,20,10,2751,186,291,189,163,181,237,0,333,223,0,0,0,49,33,0,0,'LAST_HIT','false'),
(18021,18021,'Apostate\'s Offering Archer',0,'',0,'LineageMonster.batur_orc_archer',11.00,21.50,39,'male','L2FestivalMonster',500,1462,514,7.11,1.84,40,43,30,21,20,10,1879,119,566,165,121,158,249,0,333,275,0,0,0,49,66,0,0,'LAST_HIT','false'),
(18022,18022,'Apostate\'s Offering Warrior',0,'',0,'LineageMonster.batur_orc_warrior',10.00,20.00,40,'male','L2FestivalMonster',40,1527,531,7.11,1.84,40,43,30,21,20,10,1920,124,273,201,131,164,278,0,333,127,0,0,0,88,126,0,0,'LAST_HIT','false'),
(18023,18023,'Apostate\'s Offering Follower',0,'',0,'LineageMonster.batur_orc_shaman',11.00,16.00,40,'male','L2FestivalMonster',40,1527,531,7.11,1.84,40,43,30,21,20,10,2296,148,238,171,131,164,237,0,333,316,0,0,0,55,170,0,0,'LAST_HIT','false'),
(18024,18024,'Apostate\'s Offering Berserker',0,'',0,'LineageMonster.zenta_lizardman',11.00,32.00,48,'male','L2FestivalMonster',40,2091,768,8.69,2.14,40,43,30,21,20,10,3832,280,453,261,231,212,278,0,333,297,0,0,0,40,132,0,0,'LAST_HIT','false'),
(18025,18025,'Apostate\'s Offering Zealot',0,'',0,'LineageMonster.batur_orc_20_bi',10.00,25.30,45,'male','L2FestivalMonster',40,1870,677,8.69,2.14,40,43,30,21,20,10,2891,201,330,202,188,193,237,0,333,172,0,0,0,88,176,0,0,'LAST_HIT','false'),
(18026,18026,'Apostate\'s Offering Marksman',0,'',0,'LineageMonster.batur_orc_archer_20_bi',13.00,25.30,43,'male','L2FestivalMonster',500,1728,618,8.69,2.14,40,43,30,21,20,10,2285,154,739,189,163,181,249,0,333,277,0,0,0,49,148,0,0,'LAST_HIT','false'),
(18027,18027,'Apostate\'s Offering Disciple',0,'',0,'LineageMonster.batur_orc_overlord',12.00,24.00,45,'male','L2FestivalMonster',40,1870,677,8.69,2.14,40,43,30,21,20,10,2891,201,377,238,188,193,278,0,333,74,0,0,0,88,187,0,0,'LAST_HIT','false'),
(18028,18028,'Apostate\'s Offering Saint',0,'',0,'LineageMonster.batur_orc_overlord_20_bi',14.00,28.80,50,'male','L2FestivalMonster',40,2245,830,8.69,2.14,40,43,30,21,20,10,3570,269,509,278,264,226,278,0,333,133,0,0,0,88,187,0,0,'LAST_HIT','false'),
(18029,18029,'Witch\'s Offering Elder',0,'',0,'LineageMonster.batur_orc_warrior_20_bi',12.00,24.00,56,'male','L2FestivalMonster',40,2724,1019,10.27,2.45,40,43,30,21,20,10,4666,383,706,331,382,269,278,0,333,133,0,0,0,88,33,0,0,'LAST_HIT','false'),
(18030,18030,'Witch\'s Offering',0,'',0,'LineageMonster.batur_orc',9.00,21.50,54,'male','L2FestivalMonster',40,2562,955,10.27,2.45,40,43,30,21,20,10,4339,346,556,266,339,254,237,0,333,226,0,0,0,88,33,0,0,'LAST_HIT','false'),
(18031,18031,'Witch\'s Offering Archer',0,'',0,'LineageMonster.batur_orc_archer',11.00,21.50,50,'male','L2FestivalMonster',500,2245,830,8.69,2.14,40,43,30,21,20,10,3090,233,1132,236,264,226,249,0,333,278,0,0,0,49,77,0,0,'LAST_HIT','false'),
(18032,18032,'Witch\'s Offering Warrior',0,'',0,'LineageMonster.batur_orc_warrior',10.00,20.00,51,'male','L2FestivalMonster',40,2323,861,10.27,2.45,40,43,30,21,20,10,3121,238,539,286,281,232,278,0,333,72,0,0,0,88,132,0,0,'LAST_HIT','false'),
(18033,18033,'Witch\'s Offering Follower',0,'',0,'LineageMonster.batur_orc_shaman',11.00,16.00,51,'male','L2FestivalMonster',40,2323,861,10.27,2.45,40,43,30,21,20,10,3732,285,472,243,281,232,237,0,333,316,0,0,0,55,176,0,0,'LAST_HIT','false'),
(18034,18034,'Witch\'s Offering Berserker',0,'',0,'LineageMonster.virud_lizardman_warrior',12.00,30.00,59,'male','L2FestivalMonster',40,2971,1117,10.27,2.45,40,43,30,21,20,10,5789,495,820,359,453,291,278,0,333,301,0,0,0,57,137,0,0,'LAST_HIT','false'),
(18035,18035,'Witch\'s Offering Zealot',0,'',0,'LineageMonster.batur_orc_20_bi',10.00,25.30,56,'male','L2FestivalMonster',40,2724,1019,10.27,2.45,40,43,30,21,20,10,4478,368,618,281,382,269,237,0,333,91,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18036,18036,'Witch\'s Offering Marksman',0,'',0,'LineageMonster.batur_orc_archer_20_bi',13.00,25.30,54,'male','L2FestivalMonster',500,2562,955,10.27,2.45,40,43,30,21,20,10,3604,287,1413,266,339,254,249,0,333,282,0,0,0,49,154,0,0,'LAST_HIT','false'),
(18037,18037,'Witch\'s Offering Disciple',0,'',0,'LineageMonster.batur_orc_overlord',12.00,24.00,56,'male','L2FestivalMonster',40,2724,1019,10.27,2.45,40,43,30,21,20,10,4478,368,706,331,382,269,278,0,333,135,0,0,0,88,192,0,0,'LAST_HIT','false'),
(18038,18038,'Witch\'s Offering Saint',0,'',0,'LineageMonster.batur_orc_overlord_20_bi',14.00,28.80,61,'male','L2FestivalMonster',40,3137,1184,11.85,2.78,40,43,30,21,20,10,5313,468,901,378,505,307,278,0,333,79,0,0,0,88,192,0,0,'LAST_HIT','false'),
(18039,18039,'Dark Omen Offering Elder',0,'',0,'LineageMonster.batur_orc_warrior_20_bi',12.00,24.00,67,'male','L2FestivalMonster',40,3626,1388,11.85,2.78,40,43,30,21,20,10,6679,636,1169,439,681,356,278,0,333,79,0,0,0,88,33,0,0,'LAST_HIT','false'),
(18040,18040,'Dark Omen Offering',0,'',0,'LineageMonster.batur_orc',9.00,21.50,65,'male','L2FestivalMonster',40,3465,1319,11.85,2.78,40,43,30,21,20,10,6286,584,942,355,619,340,237,0,333,234,0,0,0,88,33,0,0,'LAST_HIT','false'),
(18041,18041,'Dark Omen Offering Archer',0,'',0,'LineageMonster.batur_orc_archer',11.00,21.50,61,'male','L2FestivalMonster',500,3137,1184,11.85,2.78,40,43,30,21,20,10,4599,405,2004,321,505,307,249,0,333,283,0,0,0,49,77,0,0,'LAST_HIT','false'),
(18042,18042,'Dark Omen Offering Warrior',0,'',0,'LineageMonster.batur_orc_warrior',10.00,20.00,62,'male','L2FestivalMonster',40,3219,1217,11.85,2.78,40,43,30,21,20,10,4612,411,944,388,532,315,278,0,333,133,0,0,0,88,137,0,0,'LAST_HIT','false'),
(18043,18043,'Dark Omen Offering Follower',0,'',0,'LineageMonster.batur_orc_shaman',11.00,16.00,62,'male','L2FestivalMonster',40,3219,1217,11.85,2.78,40,43,30,21,20,10,5516,492,826,330,532,315,237,0,333,316,0,0,0,55,181,0,0,'LAST_HIT','false'),
(18044,18044,'Dark Omen Offering Berserker',0,'',0,'LineageMonster.virud_lizardman_warrior',12.00,30.00,70,'male','L2FestivalMonster',40,3862,1493,11.85,2.78,40,43,30,21,20,10,8149,808,1314,470,780,382,278,0,333,97,0,0,0,57,143,0,0,'LAST_HIT','false'),
(18045,18045,'Dark Omen Offering Zealot',0,'',0,'LineageMonster.batur_orc_20_bi',10.00,25.30,67,'male','L2FestivalMonster',40,3626,1388,11.85,2.78,40,43,30,21,20,10,6410,610,1023,373,681,356,237,0,333,2503,0,0,0,88,187,0,0,'LAST_HIT','false'),
(18046,18046,'Dark Omen Offering Marksman',0,'',0,'LineageMonster.batur_orc_archer_20_bi',13.00,25.30,65,'male','L2FestivalMonster',500,3465,1319,11.85,2.78,40,43,30,21,20,10,5222,485,2393,355,619,340,249,0,333,286,0,0,0,49,159,0,0,'LAST_HIT','false'),
(18047,18047,'Dark Omen Offering Disciple',0,'',0,'LineageMonster.batur_orc_overlord',12.00,24.00,67,'male','L2FestivalMonster',40,3626,1388,11.85,2.78,40,43,30,21,20,10,6410,610,1169,439,681,356,278,0,333,142,0,0,0,88,198,0,0,'LAST_HIT','false'),
(18048,18048,'Dark Omen Offering Saint',0,'',0,'LineageMonster.batur_orc_overlord_20_bi',14.00,28.80,72,'male','L2FestivalMonster',40,4013,1565,13.43,3.09,40,43,30,21,20,10,7402,752,1413,491,849,399,278,0,333,2500,0,0,0,88,198,0,0,'LAST_HIT','false'),
(18049,18049,'Offering of Forbidden Path Elder',0,'',0,'LineageMonster.batur_orc_overlord_20_bi',14.00,28.80,78,'male','L2FestivalMonster',40,4428,1784,13.43,3.09,40,43,30,21,20,10,9052,991,1715,555,1069,451,278,0,333,2500,0,0,0,88,33,0,0,'LAST_HIT','false'),
(18050,18050,'Offering of Forbidden Path',0,'',0,'LineageMonster.batur_orc_warrior',10.00,20.00,76,'male','L2FestivalMonster',40,4297,1710,13.43,3.09,40,43,30,21,20,10,8594,919,1412,454,994,433,237,0,333,236,0,0,0,88,33,0,0,'LAST_HIT','false'),
(18051,18051,'Offering of Forbidden Path Archer',0,'',0,'LineageMonster.ketra_orc_archer',12.00,27.00,80,'male','L2FestivalMonster',500,4663,1934,13.43,3.09,40,43,30,21,20,10,8310,955,4248,508,1220,485,249,0,333,287,0,0,0,49,77,0,0,'LAST_HIT','false'),
(18052,18052,'Offering of Forbidden Path Warrior',0,'',0,'LineageMonster.ketra_orc_warrior',12.00,24.00,80,'male','L2FestivalMonster',40,4550,1859,13.43,3.09,40,43,30,21,20,10,7680,862,1814,576,1144,468,278,0,333,79,0,0,0,39,143,0,0,'LAST_HIT','false'),
(18053,18053,'Offering of Forbidden Path Follower',0,'',0,'LineageMonster.ketra_orc_shaman',10.00,23.00,80,'male','L2FestivalMonster',40,4550,1859,13.43,3.09,40,43,30,21,20,10,9185,1031,1587,490,1144,468,237,0,333,316,0,0,0,11,198,0,0,'LAST_HIT','false'),
(18054,18054,'Offering of Forbidden Path Berserker',0,'',0,'LineageMonster.zenta_lizardman_warrior',13.00,35.00,81,'male','L2FestivalMonster',40,4608,1896,13.43,3.09,40,43,30,21,20,10,10912,1239,1863,587,1182,477,278,0,333,305,0,0,0,44,148,0,0,'LAST_HIT','false'),
(18055,18055,'Offering of Forbidden Path Zealot',0,'',0,'LineageMonster.ketra_orc_20_bi',14.00,34.80,78,'male','L2FestivalMonster',40,4428,1784,13.43,3.09,40,43,30,21,20,10,8687,951,1500,472,1069,451,237,0,333,175,0,0,0,49,214,0,0,'LAST_HIT','false'),
(18056,18056,'Offering of Forbidden Path Marksman',0,'',0,'LineageMonster.ketra_orc_archer_20_bi',14.00,32.40,76,'male','L2FestivalMonster',500,4297,1710,13.43,3.09,40,43,30,21,20,10,7139,763,3587,454,994,433,249,0,333,289,0,0,0,49,165,0,0,'LAST_HIT','false'),
(18057,18057,'Offering of Forbidden Path Disciple',0,'',0,'LineageMonster.ketra_orc_overload',12.00,24.00,78,'male','L2FestivalMonster',40,4428,1784,13.43,3.09,40,43,30,21,20,10,8687,951,1715,555,1069,451,278,0,333,151,0,0,0,36,214,0,0,'LAST_HIT','false'),
(18058,18058,'Offering of Forbidden Path Saint',0,'',0,'LineageMonster.ketra_orc_overload_20_bi',14.00,28.80,80,'male','L2FestivalMonster',40,4716,1972,13.43,3.09,40,43,30,21,20,10,9837,1144,1959,608,1258,494,278,0,333,2500,0,0,0,36,214,0,0,'LAST_HIT','false'),
(18059,18059,'Offering of Branded Elder',0,'',0,'LineageMonster.orc_fighter_bi',12.00,26.40,34,'male','L2FestivalMonster',40,1164,430,7.11,1.84,40,43,30,21,20,10,1720,100,178,163,82,132,278,0,333,127,0,0,0,49,33,0,0,'LAST_HIT','false'),
(18060,18060,'Offering of the Branded',0,'',0,'LineageMonster.orc',10.00,21.00,32,'male','L2FestivalMonster',40,1056,397,7.11,1.84,40,43,30,21,20,10,1523,86,134,129,69,123,237,0,333,218,0,0,0,49,33,0,0,'LAST_HIT','false'),
(18061,18061,'Offering of Branded Archer',0,'',0,'LineageMonster.orc_archer',14.00,25.00,28,'male','L2FestivalMonster',500,859,334,5.53,1.53,40,43,30,21,20,10,1001,53,251,110,49,106,249,0,333,14,0,0,0,49,66,0,0,'LAST_HIT','false'),
(18062,18062,'Offering of Branded Warrior',0,'',0,'LineageMonster.orc_champion',10.00,23.00,29,'male','L2FestivalMonster',40,906,349,5.53,1.53,40,43,30,21,20,10,1026,55,122,135,53,110,278,0,333,125,0,0,0,49,121,0,0,'LAST_HIT','false'),
(18063,18063,'Offering of Branded Follower',0,'',0,'LineageMonster.orc_shaman',9.00,22.00,29,'male','L2FestivalMonster',40,906,349,5.53,1.53,40,43,30,21,20,10,1227,66,107,115,53,110,237,0,333,316,0,0,0,49,165,0,0,'LAST_HIT','false'),
(18064,18064,'Offering of Branded Berserker',0,'',0,'LineageMonster.virud_lizardman',10.00,23.00,37,'male','L2FestivalMonster',40,1338,480,7.11,1.84,40,43,30,21,20,10,2276,140,222,182,104,147,278,0,333,292,0,0,0,47,126,0,0,'LAST_HIT','false'),
(18065,18065,'Offering of Branded Zealot',0,'',0,'LineageMonster.orc_fighter_bi',12.00,26.40,34,'male','L2FestivalMonster',40,1164,430,7.11,1.84,40,43,30,21,20,10,1650,96,156,138,82,132,237,0,333,158,0,0,0,49,170,0,0,'LAST_HIT','false'),
(18066,18066,'Offering of Branded Marksman',0,'',0,'LineageMonster.orc_archer_20_bi',16.00,30.00,32,'male','L2FestivalMonster',500,1056,397,7.11,1.84,40,43,30,21,20,10,1265,71,342,129,69,123,249,0,333,273,0,0,0,49,143,0,0,'LAST_HIT','false'),
(18067,18067,'Offering of Branded Disciple',0,'',0,'LineageMonster.batur_orc',9.00,21.50,34,'male','L2FestivalMonster',40,1164,430,7.11,1.84,40,43,30,21,20,10,1650,96,178,163,82,132,278,0,333,129,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18068,18068,'Offering of Branded Saint',0,'',0,'LineageMonster.batur_orc_20_bi',10.00,25.30,39,'male','L2FestivalMonster',40,1462,514,7.11,1.84,40,43,30,21,20,10,2171,138,255,195,121,158,278,0,333,72,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18069,18069,'Apostate\'s Offering Elder',0,'',0,'LineageMonster.orc_champion_20_bi',12.00,27.60,45,'male','L2FestivalMonster',40,1870,677,8.69,2.14,40,43,30,21,20,10,3013,210,377,238,188,193,278,0,333,72,0,0,0,49,33,0,0,'LAST_HIT','false'),
(18070,18070,'Apostate\'s Offering',0,'',0,'LineageMonster.orc_fighter',12.00,22.00,43,'male','L2FestivalMonster',40,1728,618,8.69,2.14,40,43,30,21,20,10,2751,186,291,189,163,181,237,0,333,223,0,0,0,49,33,0,0,'LAST_HIT','false'),
(18071,18071,'Apostate\'s Offering Archer',0,'',0,'LineageMonster.batur_orc_archer',11.00,21.50,39,'male','L2FestivalMonster',500,1462,514,7.11,1.84,40,43,30,21,20,10,1879,119,566,165,121,158,249,0,333,275,0,0,0,49,66,0,0,'LAST_HIT','false'),
(18072,18072,'Apostate\'s Offering Warrior',0,'',0,'LineageMonster.batur_orc_warrior',10.00,20.00,40,'male','L2FestivalMonster',40,1527,531,7.11,1.84,40,43,30,21,20,10,1920,124,273,201,131,164,278,0,333,127,0,0,0,88,126,0,0,'LAST_HIT','false'),
(18073,18073,'Apostate\'s Offering Follower',0,'',0,'LineageMonster.batur_orc_shaman',11.00,16.00,40,'male','L2FestivalMonster',40,1527,531,7.11,1.84,40,43,30,21,20,10,2296,148,238,171,131,164,237,0,333,316,0,0,0,55,170,0,0,'LAST_HIT','false'),
(18074,18074,'Apostate\'s Offering Berserker',0,'',0,'LineageMonster.zenta_lizardman',11.00,32.00,48,'male','L2FestivalMonster',40,2091,768,8.69,2.14,40,43,30,21,20,10,3832,280,453,261,231,212,278,0,333,297,0,0,0,40,132,0,0,'LAST_HIT','false'),
(18075,18075,'Apostate\'s Offering Zealot',0,'',0,'LineageMonster.batur_orc_20_bi',10.00,25.30,45,'male','L2FestivalMonster',40,1870,677,8.69,2.14,40,43,30,21,20,10,2891,201,330,202,188,193,237,0,333,172,0,0,0,88,176,0,0,'LAST_HIT','false'),
(18076,18076,'Apostate\'s Offering Marksman',0,'',0,'LineageMonster.batur_orc_archer_20_bi',13.00,25.30,43,'male','L2FestivalMonster',500,1728,618,8.69,2.14,40,43,30,21,20,10,2285,154,739,189,163,181,249,0,333,277,0,0,0,49,148,0,0,'LAST_HIT','false'),
(18077,18077,'Apostate\'s Offering Disciple',0,'',0,'LineageMonster.batur_orc_overlord',12.00,24.00,45,'male','L2FestivalMonster',40,1870,677,8.69,2.14,40,43,30,21,20,10,2891,201,377,238,188,193,278,0,333,74,0,0,0,88,187,0,0,'LAST_HIT','false'),
(18078,18078,'Apostate\'s Offering Saint',0,'',0,'LineageMonster.batur_orc_overlord_20_bi',14.00,28.80,50,'male','L2FestivalMonster',40,2245,830,8.69,2.14,40,43,30,21,20,10,3570,269,509,278,264,226,278,0,333,133,0,0,0,88,187,0,0,'LAST_HIT','false'),
(18079,18079,'Witch\'s Offering Elder',0,'',0,'LineageMonster.batur_orc_warrior_20_bi',12.00,24.00,56,'male','L2FestivalMonster',40,2724,1019,10.27,2.45,40,43,30,21,20,10,4666,383,706,331,382,269,278,0,333,133,0,0,0,88,33,0,0,'LAST_HIT','false'),
(18080,18080,'Witch\'s Offering',0,'',0,'LineageMonster.batur_orc',9.00,21.50,54,'male','L2FestivalMonster',40,2562,955,10.27,2.45,40,43,30,21,20,10,4339,346,556,266,339,254,237,0,333,226,0,0,0,88,33,0,0,'LAST_HIT','false'),
(18081,18081,'Witch\'s Offering Archer',0,'',0,'LineageMonster.batur_orc_archer',11.00,21.50,50,'male','L2FestivalMonster',500,2245,830,8.69,2.14,40,43,30,21,20,10,3090,233,1132,236,264,226,249,0,333,278,0,0,0,49,77,0,0,'LAST_HIT','false'),
(18082,18082,'Witch\'s Offering Warrior',0,'',0,'LineageMonster.batur_orc_warrior',10.00,20.00,51,'male','L2FestivalMonster',40,2323,861,10.27,2.45,40,43,30,21,20,10,3121,238,539,286,281,232,278,0,333,72,0,0,0,88,132,0,0,'LAST_HIT','false'),
(18083,18083,'Witch\'s Offering Follower',0,'',0,'LineageMonster.batur_orc_shaman',11.00,16.00,51,'male','L2FestivalMonster',40,2323,861,10.27,2.45,40,43,30,21,20,10,3732,285,472,243,281,232,237,0,333,316,0,0,0,55,176,0,0,'LAST_HIT','false'),
(18084,18084,'Witch\'s Offering Berserker',0,'',0,'LineageMonster.virud_lizardman_warrior',12.00,30.00,59,'male','L2FestivalMonster',40,2971,1117,10.27,2.45,40,43,30,21,20,10,5789,495,820,359,453,291,278,0,333,301,0,0,0,57,137,0,0,'LAST_HIT','false'),
(18085,18085,'Witch\'s Offering Zealot',0,'',0,'LineageMonster.batur_orc_20_bi',10.00,25.30,56,'male','L2FestivalMonster',40,2724,1019,10.27,2.45,40,43,30,21,20,10,4478,368,618,281,382,269,237,0,333,91,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18086,18086,'Witch\'s Offering Marksman',0,'',0,'LineageMonster.batur_orc_archer_20_bi',13.00,25.30,54,'male','L2FestivalMonster',500,2562,955,10.27,2.45,40,43,30,21,20,10,3604,287,1413,266,339,254,249,0,333,282,0,0,0,49,154,0,0,'LAST_HIT','false'),
(18087,18087,'Witch\'s Offering Disciple',0,'',0,'LineageMonster.batur_orc_overlord',12.00,24.00,56,'male','L2FestivalMonster',40,2724,1019,10.27,2.45,40,43,30,21,20,10,4478,368,706,331,382,269,278,0,333,135,0,0,0,88,192,0,0,'LAST_HIT','false'),
(18088,18088,'Witch\'s Offering Saint',0,'',0,'LineageMonster.batur_orc_overlord_20_bi',14.00,28.80,61,'male','L2FestivalMonster',40,3137,1184,11.85,2.78,40,43,30,21,20,10,5313,468,901,378,505,307,278,0,333,79,0,0,0,88,192,0,0,'LAST_HIT','false'),
(18089,18089,'Dark Omen Offering Elder',0,'',0,'LineageMonster.batur_orc_warrior_20_bi',12.00,24.00,67,'male','L2FestivalMonster',40,3626,1388,11.85,2.78,40,43,30,21,20,10,6679,636,1169,439,681,356,278,0,333,79,0,0,0,88,33,0,0,'LAST_HIT','false'),
(18090,18090,'Dark Omen Offering',0,'',0,'LineageMonster.batur_orc',9.00,21.50,65,'male','L2FestivalMonster',40,3465,1319,11.85,2.78,40,43,30,21,20,10,6286,584,942,355,619,340,237,0,333,234,0,0,0,88,33,0,0,'LAST_HIT','false'),
(18091,18091,'Dark Omen Offering Archer',0,'',0,'LineageMonster.batur_orc_archer',11.00,21.50,61,'male','L2FestivalMonster',500,3137,1184,11.85,2.78,40,43,30,21,20,10,4599,405,2004,321,505,307,249,0,333,283,0,0,0,49,77,0,0,'LAST_HIT','false'),
(18092,18092,'Dark Omen Offering Warrior',0,'',0,'LineageMonster.batur_orc_warrior',10.00,20.00,62,'male','L2FestivalMonster',40,3219,1217,11.85,2.78,40,43,30,21,20,10,4612,411,944,388,532,315,278,0,333,133,0,0,0,88,137,0,0,'LAST_HIT','false'),
(18093,18093,'Dark Omen Offering Follower',0,'',0,'LineageMonster.batur_orc_shaman',11.00,16.00,62,'male','L2FestivalMonster',40,3219,1217,11.85,2.78,40,43,30,21,20,10,5516,492,826,330,532,315,237,0,333,316,0,0,0,55,181,0,0,'LAST_HIT','false'),
(18094,18094,'Dark Omen Offering Berserker',0,'',0,'LineageMonster.virud_lizardman_warrior',12.00,30.00,70,'male','L2FestivalMonster',40,3862,1493,11.85,2.78,40,43,30,21,20,10,8149,808,1314,470,780,382,278,0,333,97,0,0,0,57,143,0,0,'LAST_HIT','false'),
(18095,18095,'Dark Omen Offering Zealot',0,'',0,'LineageMonster.batur_orc_20_bi',10.00,25.30,67,'male','L2FestivalMonster',40,3626,1388,11.85,2.78,40,43,30,21,20,10,6410,610,1023,373,681,356,237,0,333,2503,0,0,0,88,187,0,0,'LAST_HIT','false'),
(18096,18096,'Dark Omen Offering Marksman',0,'',0,'LineageMonster.batur_orc_archer_20_bi',13.00,25.30,65,'male','L2FestivalMonster',500,3465,1319,11.85,2.78,40,43,30,21,20,10,5222,485,2393,355,619,340,249,0,333,286,0,0,0,49,159,0,0,'LAST_HIT','false'),
(18097,18097,'Dark Omen Offering Disciple',0,'',0,'LineageMonster.batur_orc_overlord',12.00,24.00,67,'male','L2FestivalMonster',40,3626,1388,11.85,2.78,40,43,30,21,20,10,6410,610,1169,439,681,356,278,0,333,142,0,0,0,88,198,0,0,'LAST_HIT','false'),
(18098,18098,'Dark Omen Offering Saint',0,'',0,'LineageMonster.batur_orc_overlord_20_bi',14.00,28.80,72,'male','L2FestivalMonster',40,4013,1565,13.43,3.09,40,43,30,21,20,10,7402,752,1413,491,849,399,278,0,333,2500,0,0,0,88,198,0,0,'LAST_HIT','false'),
(18099,18099,'Offering of Forbidden Path Elder',0,'',0,'LineageMonster.batur_orc_overlord_20_bi',14.00,28.80,78,'male','L2FestivalMonster',40,4428,1784,13.43,3.09,40,43,30,21,20,10,9052,991,1715,555,1069,451,278,0,333,2500,0,0,0,88,33,0,0,'LAST_HIT','false'),
(18100,18100,'Offering of Forbidden Path',0,'',0,'LineageMonster.batur_orc_warrior',10.00,20.00,76,'male','L2FestivalMonster',40,4297,1710,13.43,3.09,40,43,30,21,20,10,8594,919,1412,454,994,433,237,0,333,236,0,0,0,88,33,0,0,'LAST_HIT','false'),
(18101,18101,'Offering of Forbidden Path Archer',0,'',0,'LineageMonster.ketra_orc_archer',12.00,27.00,80,'male','L2FestivalMonster',500,4663,1934,13.43,3.09,40,43,30,21,20,10,8310,955,4248,508,1220,485,249,0,333,287,0,0,0,49,77,0,0,'LAST_HIT','false'),
(18102,18102,'Offering of Forbidden Path Warrior',0,'',0,'LineageMonster.ketra_orc_warrior',12.00,24.00,80,'male','L2FestivalMonster',40,4550,1859,13.43,3.09,40,43,30,21,20,10,7680,862,1814,576,1144,468,278,0,333,79,0,0,0,39,143,0,0,'LAST_HIT','false'),
(18103,18103,'Offering of Forbidden Path Follower',0,'',0,'LineageMonster.ketra_orc_shaman',10.00,23.00,80,'male','L2FestivalMonster',40,4550,1859,13.43,3.09,40,43,30,21,20,10,9185,1031,1587,490,1144,468,237,0,333,316,0,0,0,11,198,0,0,'LAST_HIT','false'),
(18104,18104,'Offering of Forbidden Path Berserker',0,'',0,'LineageMonster.zenta_lizardman_warrior',13.00,35.00,80,'male','L2FestivalMonster',40,4608,1896,13.43,3.09,40,43,30,21,20,10,10912,1239,1863,587,1182,477,278,0,333,305,0,0,0,44,148,0,0,'LAST_HIT','false'),
(18105,18105,'Offering of Forbidden Path Zealot',0,'',0,'LineageMonster.ketra_orc_20_bi',14.00,34.80,78,'male','L2FestivalMonster',40,4428,1784,13.43,3.09,40,43,30,21,20,10,8687,951,1500,472,1069,451,237,0,333,175,0,0,0,49,214,0,0,'LAST_HIT','false'),
(18106,18106,'Offering of Forbidden Path Marksman',0,'',0,'LineageMonster.ketra_orc_archer_20_bi',14.00,32.40,76,'male','L2FestivalMonster',500,4297,1710,13.43,3.09,40,43,30,21,20,10,7139,763,3587,454,994,433,249,0,333,289,0,0,0,49,165,0,0,'LAST_HIT','false'),
(18107,18107,'Offering of Forbidden Path Disciple',0,'',0,'LineageMonster.ketra_orc_overload',12.00,24.00,78,'male','L2FestivalMonster',40,4428,1784,13.43,3.09,40,43,30,21,20,10,8687,951,1715,555,1069,451,278,0,333,151,0,0,0,36,214,0,0,'LAST_HIT','false'),
(18108,18108,'Offering of Forbidden Path Saint',0,'',0,'LineageMonster.ketra_orc_overload_20_bi',14.00,28.80,83,'male','L2FestivalMonster',40,4716,1972,13.43,3.09,40,43,30,21,20,10,9837,1144,1959,608,1258,494,278,0,333,2500,0,0,0,36,214,0,0,'LAST_HIT','false'),
(18109,18109,'Treasures of the Festival',0,'',0,'LineageMonster.mimic',8.50,8.50,30,'male','L2FestivalMonster',0,999,365,5.53,1.53,40,43,30,21,20,10,90,0,0,140,0,114,0,0,0,0,0,0,0,88,214,0,0,'LAST_HIT','false'),
(18110,18110,'Treasures of the Festival',0,'',0,'LineageMonster.mimic',8.50,8.50,41,'male','L2FestivalMonster',0,1488,560,8.69,2.14,40,43,30,21,20,10,168,0,0,208,0,169,0,0,0,0,0,0,0,88,214,0,0,'LAST_HIT','false'),
(18111,18111,'Treasures of the Festival',0,'',0,'LineageMonster.mimic',8.50,8.50,52,'male','L2FestivalMonster',0,2058,892,10.27,2.45,40,43,30,21,20,10,270,0,0,295,0,239,0,0,0,0,0,0,0,88,214,0,0,'LAST_HIT','false'),
(18112,18112,'Treasures of the Festival',0,'',0,'LineageMonster.mimic',8.50,8.50,63,'male','L2FestivalMonster',0,2640,1251,11.85,2.78,40,43,30,21,20,10,396,0,0,398,0,323,0,0,0,0,0,0,0,88,214,0,0,'LAST_HIT','false'),
(18113,18113,'Treasures of the Festival',0,'',0,'LineageMonster.mimic',8.50,8.50,72,'male','L2FestivalMonster',0,3063,1565,13.43,3.09,40,43,30,21,20,10,518,0,0,491,0,399,0,0,0,0,0,0,0,88,214,0,0,'LAST_HIT','false'),
(18114,18114,'Treasures of the Festival',0,'',0,'LineageMonster.mimic',8.50,8.50,30,'male','L2FestivalMonster',0,999,365,5.53,1.53,40,43,30,21,20,10,90,0,0,140,0,114,0,0,0,0,0,0,0,88,214,0,0,'LAST_HIT','false'),
(18115,18115,'Treasures of the Festival',0,'',0,'LineageMonster.mimic',8.50,8.50,41,'male','L2FestivalMonster',0,1488,560,8.69,2.14,40,43,30,21,20,10,168,0,0,208,0,169,0,0,0,0,0,0,0,88,214,0,0,'LAST_HIT','false'),
(18116,18116,'Treasures of the Festival',0,'',0,'LineageMonster.mimic',8.50,8.50,52,'male','L2FestivalMonster',0,2058,892,10.27,2.45,40,43,30,21,20,10,270,0,0,295,0,239,0,0,0,0,0,0,0,88,214,0,0,'LAST_HIT','false'),
(18117,18117,'Treasures of the Festival',0,'',0,'LineageMonster.mimic',8.50,8.50,63,'male','L2FestivalMonster',0,2640,1251,11.85,2.78,40,43,30,21,20,10,396,0,0,398,0,323,0,0,0,0,0,0,0,88,214,0,0,'LAST_HIT','false'),
(18118,18118,'Treasures of the Festival',0,'',0,'LineageMonster.mimic',8.50,8.50,72,'male','L2FestivalMonster',0,3063,1565,13.43,3.09,40,43,30,21,20,10,518,0,0,491,0,399,0,0,0,0,0,0,0,88,214,0,0,'LAST_HIT','false'),
(18119,18119,'Corpse of Deadman',0,'',0,'LineageMonster.zombie_corpse',13.00,21.00,63,'male','L2Monster',40,3302,1251,11.85,2.78,40,43,30,21,20,10,0,0,987,398,560,323,278,0,333,0,0,0,0,15,1,1,0,'LAST_HIT','false'),
(18120,18120,'Halisha\'s Officer',0,'',0,'LineageMonster2.imperial_warlord_zombie_20_bi',9.00,36.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,9764,1108,2255,534,1731,433,278,0,333,134,6721,0,0,42,165,1,0,'LAST_HIT','false'),
(18121,18121,'Halisha\'s Officer',0,'',0,'LineageMonster2.imperial_warlord_zombie_20_bi',9.00,36.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,9260,1051,1694,710,977,577,278,0,333,134,6721,0,0,42,165,1,0,'LAST_HIT','false'),
(18122,18122,'Halisha\'s Officer',0,'',0,'LineageMonster2.imperial_warlord_zombie_20_bi',9.00,36.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,7072,803,1863,587,1182,477,278,0,333,134,6721,0,0,42,165,1,0,'LAST_HIT','false'),
(18123,18123,'Halisha\'s Officer',0,'',0,'LineageMonster2.imperial_warlord_zombie_20_bi',9.00,36.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,9764,1108,2255,534,1731,433,278,0,333,134,6721,0,0,42,165,1,0,'LAST_HIT','false'),
(18124,18124,'Halisha\'s Officer',0,'',0,'LineageMonster2.imperial_warlord_zombie_20_bi',9.00,36.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,9260,1051,1694,710,977,577,278,0,333,134,6721,0,0,42,165,1,0,'LAST_HIT','false'),
(18125,18125,'Halisha\'s Officer',0,'',0,'LineageMonster2.imperial_warlord_zombie_20_bi',9.00,36.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,7072,803,1863,587,1182,477,278,0,333,134,6721,0,0,42,165,1,0,'LAST_HIT','false'),
(18126,18126,'Halisha\'s Officer',0,'',0,'LineageMonster2.imperial_warlord_zombie_20_bi',9.00,36.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,9764,1108,2255,534,1731,433,278,0,333,134,6721,0,0,42,165,1,0,'LAST_HIT','false'),
(18127,18127,'Halisha\'s Officer',0,'',0,'LineageMonster2.imperial_warlord_zombie_20_bi',9.00,36.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,9260,1051,1694,710,977,577,278,0,333,134,6721,0,0,42,165,1,0,'LAST_HIT','false'),
(18128,18128,'Halisha\'s Officer',0,'',0,'LineageMonster2.imperial_warlord_zombie_20_bi',9.00,36.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,7072,803,1863,587,1182,477,278,0,333,134,6721,0,0,42,165,1,0,'LAST_HIT','false'),
(18129,18129,'Halisha\'s Officer',0,'',0,'LineageMonster2.imperial_warlord_zombie_20_bi',9.00,36.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,9764,1108,2255,534,1731,433,278,0,333,134,6721,0,0,42,165,1,0,'LAST_HIT','false'),
(18130,18130,'Halisha\'s Officer',0,'',0,'LineageMonster2.imperial_warlord_zombie_20_bi',9.00,36.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,9260,1051,1694,710,977,577,278,0,333,134,6721,0,0,42,165,1,0,'LAST_HIT','false'),
(18131,18131,'Halisha\'s Officer',0,'',0,'LineageMonster2.imperial_warlord_zombie_20_bi',9.00,36.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,7072,803,1863,587,1182,477,278,0,333,134,6721,0,0,42,165,1,0,'LAST_HIT','false'),
(18132,18132,'Imperial Healer',0,'',0,'LineageMonster2.tera_beetle',19.00,54.50,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,9949,1129,1540,782,807,635,278,0,333,0,0,0,0,49,187,0,0,'LAST_HIT','false'),
(18133,18133,'Imperial Mosaic',0,'',0,'LineageMonster2.scorpion',28.00,66.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,9190,1043,1630,587,1182,477,237,0,333,0,0,0,0,40,187,0,0,'LAST_HIT','false'),
(18134,18134,'Imperial Mosaic',0,'',0,'LineageMonster2.scorpion',28.00,66.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,6906,784,1630,587,1182,477,237,0,333,0,0,0,0,40,187,0,0,'LAST_HIT','false'),
(18135,18135,'Imperial Mosaic',0,'',0,'LineageMonster2.scorpion',28.00,66.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,9149,1039,1630,587,1182,477,237,0,333,0,0,0,0,40,187,0,0,'LAST_HIT','false'),
(18136,18136,'Imperial Mosaic',0,'',0,'LineageMonster2.scorpion',28.00,66.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,9190,1043,1482,710,977,577,237,0,333,0,0,0,0,40,187,0,0,'LAST_HIT','false'),
(18137,18137,'Imperial Mosaic',0,'',0,'LineageMonster2.scarab',14.00,22.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,6812,773,1863,587,1182,477,278,0,333,0,0,0,0,49,198,0,0,'LAST_HIT','false'),
(18138,18138,'Imperial Mosaic',0,'',0,'LineageMonster2.scarab',14.00,22.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,9069,1029,1863,587,1182,477,278,0,333,0,0,0,0,49,198,0,0,'LAST_HIT','false'),
(18139,18139,'Imperial Mosaic',0,'',0,'LineageMonster2.scarab',14.00,22.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,8935,1014,1863,587,1182,477,278,0,333,0,0,0,0,49,198,0,0,'LAST_HIT','false'),
(18140,18140,'Imperial Mosaic',0,'',0,'LineageMonster2.scarab',14.00,22.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,9065,1029,1694,710,977,577,278,0,333,0,0,0,0,49,198,0,0,'LAST_HIT','false'),
(18141,18141,'Beetle of Grave',0,'',0,'LineageMonster2.scarab',14.00,22.00,81,'male','L2SepulcherMonster',40,4608,1896,53.72,3.09,40,43,30,21,20,10,8745,993,3001,401,3068,325,278,0,333,0,0,0,0,49,198,0,0,'LAST_HIT','false'),
(18142,18142,'Beetle of Grave',0,'',0,'LineageMonster2.scarab',14.00,22.00,81,'male','L2SepulcherMonster',40,4608,1896,53.72,3.09,40,43,30,21,20,10,8745,993,3001,401,3068,325,278,0,333,0,0,0,0,49,198,0,0,'LAST_HIT','false'),
(18143,18143,'Beetle of Grave',0,'',0,'LineageMonster2.scarab',14.00,22.00,81,'male','L2SepulcherMonster',40,4608,1896,53.72,3.09,40,43,30,21,20,10,8745,993,3001,401,3068,325,278,0,333,0,0,0,0,49,198,0,0,'LAST_HIT','false'),
(18144,18144,'Beetle of Grave',0,'',0,'LineageMonster2.scarab',14.00,22.00,81,'male','L2SepulcherMonster',40,4608,1896,53.72,3.09,40,43,30,21,20,10,8745,993,3001,401,3068,325,278,0,333,0,0,0,0,49,198,0,0,'LAST_HIT','false'),
(18145,18145,'Beetle of Grave',0,'',0,'LineageMonster2.scarab',14.00,22.00,81,'male','L2SepulcherMonster',40,4608,1896,53.72,3.09,40,43,30,21,20,10,7399,840,2480,485,2095,394,278,0,333,0,0,0,0,49,198,0,0,'LAST_HIT','false'),
(18146,18146,'Beetle of Grave',0,'',0,'LineageMonster2.scarab',14.00,22.00,81,'male','L2SepulcherMonster',40,4608,1896,53.72,3.09,40,43,30,21,20,10,7568,859,2480,485,2095,394,278,0,333,0,0,0,0,49,198,0,0,'LAST_HIT','false'),
(18147,18147,'Beetle of Grave',0,'',0,'LineageMonster2.scarab',14.00,22.00,81,'male','L2SepulcherMonster',40,4608,1896,53.72,3.09,40,43,30,21,20,10,7046,800,2480,485,2095,394,278,0,333,0,0,0,0,49,198,0,0,'LAST_HIT','false'),
(18148,18148,'Beetle of Grave',0,'',0,'LineageMonster2.scarab',14.00,22.00,81,'male','L2SepulcherMonster',40,4608,1896,53.72,3.09,40,43,30,21,20,10,8203,931,2480,485,2095,394,278,0,333,0,0,0,0,49,198,0,0,'LAST_HIT','false'),
(18149,18149,'Beetle of Grave',0,'',0,'LineageMonster2.scarab',14.00,22.00,81,'male','L2SepulcherMonster',40,4608,1896,53.72,3.09,40,43,30,21,20,10,7247,823,2480,485,2095,394,278,0,333,0,0,0,0,49,198,0,0,'LAST_HIT','false'),
(18150,18150,'Victim',0,'',0,'LineageNPC.a_tombkeeperA',8.00,23.00,81,'female','L2SepulcherMonster',40,4608,1896,13.43,3.09,40,43,30,21,20,10,0,0,1863,587,1182,477,278,0,333,0,0,0,0,55,110,1,0,'LAST_HIT','false'),
(18151,18151,'Victim',0,'',0,'LineageNPC.a_tombkeeperA',8.00,23.00,81,'female','L2SepulcherMonster',40,4608,1896,13.43,3.09,40,43,30,21,20,10,0,0,1863,587,1182,477,278,0,333,0,0,0,0,55,110,1,0,'LAST_HIT','false'),
(18152,18152,'Victim',0,'',0,'LineageNPC.a_tombkeeperA',8.00,23.00,81,'female','L2SepulcherMonster',40,4608,1896,13.43,3.09,40,43,30,21,20,10,0,0,1863,587,1182,477,278,0,333,0,0,0,0,55,110,1,0,'LAST_HIT','false'),
(18153,18153,'Victim',0,'',0,'LineageNPC.a_tombkeeperA',8.00,23.00,81,'female','L2SepulcherMonster',40,4608,1896,13.43,3.09,40,43,30,21,20,10,0,0,1863,587,1182,477,278,0,333,0,0,0,0,55,110,1,0,'LAST_HIT','false'),
(18154,18154,'Victim',0,'',0,'LineageNPC.a_tombkeeperA',8.00,23.00,81,'female','L2SepulcherMonster',40,4608,1896,13.43,3.09,40,43,30,21,20,10,0,0,1863,587,1182,477,278,0,333,0,0,0,0,55,110,1,0,'LAST_HIT','false'),
(18155,18155,'Victim',0,'',0,'LineageNPC.a_tombkeeperA',8.00,23.00,81,'female','L2SepulcherMonster',40,4608,1896,13.43,3.09,40,43,30,21,20,10,0,0,1863,587,1182,477,278,0,333,0,0,0,0,55,110,1,0,'LAST_HIT','false'),
(18156,18156,'Victim',0,'',0,'LineageNPC.a_tombkeeperA',8.00,23.00,81,'female','L2SepulcherMonster',40,4608,1896,13.43,3.09,40,43,30,21,20,10,0,0,1863,587,1182,477,278,0,333,0,0,0,0,55,110,1,0,'LAST_HIT','false'),
(18157,18157,'Victim',0,'',0,'LineageNPC.a_tombkeeperA',8.00,23.00,81,'female','L2SepulcherMonster',40,4608,1896,13.43,3.09,40,43,30,21,20,10,0,0,1863,587,1182,477,278,0,333,0,0,0,0,55,110,1,0,'LAST_HIT','false'),
(18158,18158,'Executioner of Halisha',0,'',0,'LineageMonster2.erinyes',21.00,50.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,0,0,2255,534,1731,433,278,0,333,0,0,0,0,34,165,0,0,'LAST_HIT','false'),
(18159,18159,'Executioner of Halisha',0,'',0,'LineageMonster2.erinyes',21.00,50.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,0,0,2255,534,1731,433,278,0,333,0,0,0,0,34,165,0,0,'LAST_HIT','false'),
(18160,18160,'Executioner of Halisha',0,'',0,'LineageMonster2.erinyes',21.00,50.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,0,0,2255,534,1731,433,278,0,333,0,0,0,0,34,165,0,0,'LAST_HIT','false'),
(18161,18161,'Executioner of Halisha',0,'',0,'LineageMonster2.erinyes',21.00,50.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,0,0,2255,534,1731,433,278,0,333,0,0,0,0,34,165,0,0,'LAST_HIT','false'),
(18162,18162,'Executioner of Halisha',0,'',0,'LineageMonster2.erinyes',21.00,50.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,0,0,2255,534,1731,433,278,0,333,0,0,0,0,34,165,0,0,'LAST_HIT','false'),
(18163,18163,'Executioner of Halisha',0,'',0,'LineageMonster2.erinyes',21.00,50.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,0,0,2255,534,1731,433,278,0,333,0,0,0,0,34,165,0,0,'LAST_HIT','false'),
(18164,18164,'Executioner of Halisha',0,'',0,'LineageMonster2.erinyes',21.00,50.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,0,0,2255,534,1731,433,278,0,333,0,0,0,0,34,165,0,0,'LAST_HIT','false'),
(18165,18165,'Executioner of Halisha',0,'',0,'LineageMonster2.erinyes',21.00,50.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,0,0,2255,534,1731,433,278,0,333,0,0,0,0,34,165,0,0,'LAST_HIT','false'),
(18166,18166,'Imperial Guard',0,'',0,'LineageMonster.death_knight',12.00,31.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,7005,795,2255,534,1731,433,278,0,333,142,0,0,0,29,121,1,0,'LAST_HIT','false'),
(18167,18167,'Imperial Guard',0,'',0,'LineageMonster.death_knight',12.00,31.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,6906,784,1694,710,977,577,278,0,333,142,0,0,0,29,121,1,0,'LAST_HIT','false'),
(18168,18168,'Imperial Guard',0,'',0,'LineageMonster.death_knight',12.00,31.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,7099,806,1863,587,1182,477,278,0,333,142,0,0,0,29,121,1,0,'LAST_HIT','false'),
(18169,18169,'Imperial Guard',0,'',0,'LineageMonster.death_knight',12.00,31.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,6872,780,1694,710,977,577,278,0,333,142,0,0,0,29,121,1,0,'LAST_HIT','false'),
(18170,18170,'Imperial Guard',0,'',0,'LineageMonster.doll_master',20.00,42.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,6879,781,2170,485,2095,394,237,0,333,0,0,0,0,88,176,1,0,'LAST_HIT','false'),
(18171,18171,'Imperial Guard',0,'',0,'LineageMonster.doll_master',20.00,42.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,7147,811,1347,782,807,635,237,0,333,0,0,0,0,88,176,1,0,'LAST_HIT','false'),
(18172,18172,'Imperial Guard',0,'',0,'LineageMonster.doll_master',20.00,42.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,6812,773,1630,587,1182,477,237,0,333,0,0,0,0,88,176,1,0,'LAST_HIT','false'),
(18173,18173,'Halisha\'s Foreman',0,'',0,'LineageMonster.kaim_vanul',24.00,40.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,9321,1058,2255,534,1731,433,278,0,333,0,0,0,0,40,176,0,0,'LAST_HIT','false'),
(18174,18174,'Halisha\'s Foreman',0,'',0,'LineageMonster.kaim_vanul',24.00,40.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,9321,1058,2255,534,1731,433,278,0,333,0,0,0,0,40,176,0,0,'LAST_HIT','false'),
(18175,18175,'Halisha\'s Foreman',0,'',0,'LineageMonster.kaim_vanul',24.00,40.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,9321,1058,2255,534,1731,433,278,0,333,0,0,0,0,40,176,0,0,'LAST_HIT','false'),
(18176,18176,'Halisha\'s Foreman',0,'',0,'LineageMonster.kaim_vanul',24.00,40.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,9321,1058,2255,534,1731,433,278,0,333,0,0,0,0,40,176,0,0,'LAST_HIT','false'),
(18177,18177,'Halisha\'s Foreman',0,'',0,'LineageMonster.kaim_vanul',24.00,40.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,9321,1058,2255,534,1731,433,278,0,333,0,0,0,0,40,176,0,0,'LAST_HIT','false'),
(18178,18178,'Halisha\'s Foreman',0,'',0,'LineageMonster.kaim_vanul',24.00,40.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,9321,1058,2255,534,1731,433,278,0,333,0,0,0,0,40,176,0,0,'LAST_HIT','false'),
(18179,18179,'Halisha\'s Foreman',0,'',0,'LineageMonster.kaim_vanul',24.00,40.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,9321,1058,2255,534,1731,433,278,0,333,0,0,0,0,40,176,0,0,'LAST_HIT','false'),
(18180,18180,'Halisha\'s Foreman',0,'',0,'LineageMonster.kaim_vanul',24.00,40.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,9321,1058,2255,534,1731,433,278,0,333,0,0,0,0,40,176,0,0,'LAST_HIT','false'),
(18181,18181,'Halisha\'s Foreman',0,'',0,'LineageMonster.kaim_vanul',24.00,40.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,9321,1058,2255,534,1731,433,278,0,333,0,0,0,0,40,176,0,0,'LAST_HIT','false'),
(18182,18182,'Halisha\'s Foreman',0,'',0,'LineageMonster.kaim_vanul',24.00,40.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,9321,1058,2255,534,1731,433,278,0,333,0,0,0,0,40,176,0,0,'LAST_HIT','false'),
(18183,18183,'Halisha\'s Foreman',0,'',0,'LineageMonster.kaim_vanul',24.00,40.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,9321,1058,2255,534,1731,433,278,0,333,0,0,0,0,40,176,0,0,'LAST_HIT','false'),
(18184,18184,'Halisha\'s Foreman',0,'',0,'LineageMonster.kaim_vanul',24.00,40.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,7133,810,2255,534,1731,433,278,0,333,0,0,0,0,40,176,0,0,'LAST_HIT','false'),
(18185,18185,'Evil Astrologer',0,'',0,'LineageMonster.doll_blader',6.00,12.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,9413,1069,1694,710,977,577,278,0,333,5129,5129,0,0,24,165,0,0,'LAST_HIT','false'),
(18186,18186,'Evil Astrologer',0,'',0,'LineageMonster.doll_blader',6.00,12.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,9467,1075,1694,710,977,577,278,0,333,5129,5129,0,0,24,165,0,0,'LAST_HIT','false'),
(18187,18187,'Knight of Darkness',0,'',0,'LineageMonster.death_lord',21.00,40.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,9190,1043,2255,534,1731,433,278,0,333,78,0,0,0,44,176,1,0,'LAST_HIT','false'),
(18188,18188,'Knight of Darkness',0,'',0,'LineageMonster.death_lord',21.00,40.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,6906,784,2255,534,1731,433,278,0,333,78,0,0,0,44,176,1,0,'LAST_HIT','false'),
(18189,18189,'Knight of Darkness',0,'',0,'LineageMonster.death_lord',21.00,40.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,9149,1039,2255,534,1731,433,278,0,333,78,0,0,0,44,176,1,0,'LAST_HIT','false'),
(18190,18190,'Knight of Darkness',0,'',0,'LineageMonster.death_lord',21.00,40.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,9190,1043,2255,534,1731,433,278,0,333,78,0,0,0,44,176,1,0,'LAST_HIT','false'),
(18191,18191,'Witch of dust',0,'',0,'LineageMonster.banshee',9.00,23.00,81,'female','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,6812,773,2255,534,1731,433,278,0,333,3939,0,0,0,88,176,0,0,'LAST_HIT','false'),
(18192,18192,'Witch of dust',0,'',0,'LineageMonster.banshee',9.00,23.00,81,'female','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,9069,1029,2255,534,1731,433,278,0,333,3939,0,0,0,88,176,0,0,'LAST_HIT','false'),
(18193,18193,'Witch of dust',0,'',0,'LineageMonster.banshee',9.00,23.00,81,'female','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,8935,1014,2255,534,1731,433,278,0,333,3939,0,0,0,88,176,0,0,'LAST_HIT','false'),
(18194,18194,'Witch of dust',0,'',0,'LineageMonster.banshee',9.00,23.00,81,'female','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,9065,1029,2255,534,1731,433,278,0,333,3939,0,0,0,88,176,0,0,'LAST_HIT','false'),
(18195,18195,'Signet of Emperor',0,'',0,'LineageMonster.ant_larva',12.00,8.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,6946,788,3001,401,3068,325,278,0,333,0,0,0,0,44,66,0,0,'LAST_HIT','false'),
(18196,18196,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad',15.00,75.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,22690,2576,1272,946,551,768,278,0,333,0,0,0,0,0,0,0,0,'LAST_HIT','false'),
(18197,18197,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad',15.00,75.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,22690,2576,1272,946,551,768,278,0,333,0,0,0,0,0,0,0,0,'LAST_HIT','false'),
(18198,18198,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad',15.00,75.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,22690,2576,1272,946,551,768,278,0,333,0,0,0,0,0,0,0,0,'LAST_HIT','false'),
(18199,18199,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad',15.00,75.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,22690,2576,1272,946,551,768,278,0,333,0,0,0,0,0,0,0,0,'LAST_HIT','false'),
(18200,18200,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad',15.00,75.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,22690,2576,1272,946,551,768,278,0,333,0,0,0,0,0,0,0,0,'LAST_HIT','false'),
(18201,18201,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad',15.00,75.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,22690,2576,1272,946,551,768,278,0,333,0,0,0,0,0,0,0,0,'LAST_HIT','false'),
(18202,18202,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad',15.00,75.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,22690,2576,1272,946,551,768,278,0,333,0,0,0,0,0,0,0,0,'LAST_HIT','false'),
(18203,18203,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad',15.00,75.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,22690,2576,1272,946,551,768,278,0,333,0,0,0,0,0,0,0,0,'LAST_HIT','false'),
(18204,18204,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad',15.00,75.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,22690,2576,1272,946,551,768,278,0,333,0,0,0,0,0,0,0,0,'LAST_HIT','false'),
(18205,18205,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad',15.00,75.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,22690,2576,1272,946,551,768,278,0,333,0,0,0,0,0,0,0,0,'LAST_HIT','false'),
(18206,18206,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad',15.00,75.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,22690,2576,1272,946,551,768,278,0,333,0,0,0,0,0,0,0,0,'LAST_HIT','false'),
(18207,18207,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad',15.00,75.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,22690,2576,1272,946,551,768,278,0,333,0,0,0,0,0,0,0,0,'LAST_HIT','false'),
(18208,18208,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad',15.00,75.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,22690,2576,1272,946,551,768,278,0,333,0,0,0,0,0,0,0,0,'LAST_HIT','false'),
(18209,18209,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad',15.00,75.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,22690,2576,1272,946,551,768,278,0,333,0,0,0,0,0,0,0,0,'LAST_HIT','false'),
(18210,18210,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad',15.00,75.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,22690,2576,1272,946,551,768,278,0,333,0,0,0,0,0,0,0,0,'LAST_HIT','false'),
(18211,18211,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad',15.00,75.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,22690,2576,1272,946,551,768,278,0,333,0,0,0,0,0,0,0,0,'LAST_HIT','false'),
(18212,18212,'Archon of Halisha',0,'',0,'LineageMonster2.ahrimanes',14.00,57.75,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,28935,3285,1540,782,807,635,278,0,333,6722,0,0,0,38,203,0,0,'LAST_HIT','false'),
(18213,18213,'Archon of Halisha',0,'',0,'LineageMonster2.ahrimanes',14.00,57.75,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,28935,3285,1540,782,807,635,278,0,333,6722,0,0,0,38,203,0,0,'LAST_HIT','false'),
(18214,18214,'Archon of Halisha',0,'',0,'LineageMonster2.ahrimanes',14.00,57.75,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,28935,3285,1540,782,807,635,278,0,333,6722,0,0,0,38,203,0,0,'LAST_HIT','false'),
(18215,18215,'Archon of Halisha',0,'',0,'LineageMonster2.ahrimanes',14.00,57.75,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,28935,3285,1540,782,807,635,278,0,333,6722,0,0,0,38,203,0,0,'LAST_HIT','false'),
(18216,18216,'Archon of Halisha',0,'',0,'LineageMonster2.ahrimanes',14.00,57.75,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,28935,3285,1540,782,807,635,278,0,333,6722,0,0,0,38,203,0,0,'LAST_HIT','false'),
(18217,18217,'Archon of Halisha',0,'',0,'LineageMonster2.ahrimanes',14.00,57.75,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,28935,3285,1540,782,807,635,278,0,333,6722,0,0,0,38,203,0,0,'LAST_HIT','false'),
(18218,18218,'Archon of Halisha',0,'',0,'LineageMonster2.ahrimanes',14.00,57.75,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,28935,3285,1540,782,807,635,278,0,333,6722,0,0,0,38,203,0,0,'LAST_HIT','false'),
(18219,18219,'Archon of Halisha',0,'',0,'LineageMonster2.ahrimanes',14.00,57.75,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,28935,3285,1540,782,807,635,278,0,333,6722,0,0,0,38,203,0,0,'LAST_HIT','false'),
(18220,18220,'Shaman of Darkness',0,'',0,'LineageMonster.banshee',9.00,23.00,81,'female','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,9467,1075,2050,587,1431,477,278,0,333,3939,0,0,0,88,176,0,0,'LAST_HIT','false'),
(18221,18221,'Shaman of Darkness',0,'',0,'LineageMonster.banshee',9.00,23.00,81,'female','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,9721,1103,2050,587,1431,477,278,0,333,3939,0,0,0,88,176,0,0,'LAST_HIT','false'),
(18222,18222,'Assassin of Darkness',0,'',0,'LineageMonster2.ashuras',13.00,37.50,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,9210,1045,2480,485,2095,394,278,0,333,0,0,0,0,45,209,0,0,'LAST_HIT','false'),
(18223,18223,'Assassin of Darkness',0,'',0,'LineageMonster2.ashuras',13.00,37.50,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,6906,784,1863,587,1182,477,278,0,333,0,0,0,0,45,209,0,0,'LAST_HIT','false'),
(18224,18224,'Assassin of Darkness',0,'',0,'LineageMonster2.ashuras',13.00,37.50,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,9303,1056,2480,485,2095,394,278,0,333,0,0,0,0,45,209,0,0,'LAST_HIT','false'),
(18225,18225,'Assassin of Darkness',0,'',0,'LineageMonster2.ashuras',13.00,37.50,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,9210,1045,1863,587,1182,477,278,0,333,0,0,0,0,45,209,0,0,'LAST_HIT','false'),
(18226,18226,'Caster of Darkness',0,'',0,'LineageMonster.vale_master',12.00,40.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,6812,773,2480,485,2095,394,278,0,333,0,0,0,0,77,170,0,0,'LAST_HIT','false'),
(18227,18227,'Caster of Darkness',0,'',0,'LineageMonster.vale_master',12.00,40.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,11706,1329,1863,587,1182,477,278,0,333,0,0,0,0,77,170,0,0,'LAST_HIT','false'),
(18228,18228,'Caster of Darkness',0,'',0,'LineageMonster.vale_master',12.00,40.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,8801,999,2480,485,2095,394,278,0,333,0,0,0,0,77,170,0,0,'LAST_HIT','false'),
(18229,18229,'Caster of Darkness',0,'',0,'LineageMonster.vale_master',12.00,40.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,9065,1029,1863,587,1182,477,278,0,333,0,0,0,0,77,170,0,0,'LAST_HIT','false'),
(18230,18230,'Signet of Emperor',0,'',0,'LineageMonster.ant_larva',12.00,8.00,81,'male','L2SepulcherMonster',40,4608,1896,40.29,3.09,40,43,30,21,20,10,7495,851,3001,401,3068,325,278,0,333,0,0,0,0,44,66,0,0,'LAST_HIT','false'),
(18231,18231,'Statue of Protection',0,'',0,'LineageMonster2.temple_guard_a',15.00,42.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,11149,1266,1694,710,977,577,278,0,333,5795,0,0,0,58,154,0,0,'LAST_HIT','false'),
(18232,18232,'Statue of Protection',0,'',0,'LineageMonster2.temple_guard_a',15.00,42.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,11149,1266,1694,710,977,577,278,0,333,5795,0,0,0,58,154,0,0,'LAST_HIT','false'),
(18233,18233,'Statue of Protection',0,'',0,'LineageMonster2.temple_guard_a',15.00,42.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,11149,1266,1694,710,977,577,278,0,333,5795,0,0,0,58,154,0,0,'LAST_HIT','false'),
(18234,18234,'Statue of Protection',0,'',0,'LineageMonster2.temple_guard_a',15.00,42.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,11149,1266,1694,710,977,577,278,0,333,5795,0,0,0,58,154,0,0,'LAST_HIT','false'),
(18235,18235,'Statue of Protection',0,'',0,'LineageMonster2.temple_guard_a',15.00,42.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,11149,1266,1694,710,977,577,278,0,333,5795,0,0,0,58,154,0,0,'LAST_HIT','false'),
(18236,18236,'Statue of Protection',0,'',0,'LineageMonster2.temple_guard_a',15.00,42.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,11149,1266,1694,710,977,577,278,0,333,5795,0,0,0,58,154,0,0,'LAST_HIT','false'),
(18237,18237,'Statue of Protection',0,'',0,'LineageMonster2.temple_guard_a',15.00,42.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,11149,1266,1694,710,977,577,278,0,333,5795,0,0,0,58,154,0,0,'LAST_HIT','false'),
(18238,18238,'Statue of Protection',0,'',0,'LineageMonster2.temple_guard_a',15.00,42.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,11149,1266,1694,710,977,577,278,0,333,5795,0,0,0,58,154,0,0,'LAST_HIT','false'),
(18239,18239,'Statue of Protection',0,'',0,'LineageMonster2.temple_guard_a',15.00,42.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,11149,1266,1694,710,977,577,278,0,333,5795,0,0,0,58,154,0,0,'LAST_HIT','false'),
(18240,18240,'Statue of Protection',0,'',0,'LineageMonster2.temple_guard_a',15.00,42.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,11149,1266,1694,710,977,577,278,0,333,5795,0,0,0,58,154,0,0,'LAST_HIT','false'),
(18241,18241,'Statue of Protection',0,'',0,'LineageMonster2.temple_guard_a',15.00,42.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,11149,1266,1694,710,977,577,278,0,333,5795,0,0,0,58,154,0,0,'LAST_HIT','false'),
(18242,18242,'Statue of Protection',0,'',0,'LineageMonster2.temple_guard_a',15.00,42.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,11149,1266,1694,710,977,577,278,0,333,5795,0,0,0,58,154,0,0,'LAST_HIT','false'),
(18243,18243,'Statue of Protection',0,'',0,'LineageMonster2.temple_guard_a',15.00,42.00,81,'male','L2SepulcherMonster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,11149,1266,1694,710,977,577,278,0,333,5795,0,0,0,58,154,0,0,'LAST_HIT','false'),
(18244,18244,'Watchman of Grave',0,'',0,'LineageMonster.mana_vampire',11.00,20.00,81,'male','L2SepulcherMonster',40,3456,1896,40.29,3.09,40,43,30,21,20,10,0,0,2480,485,2095,394,278,0,333,0,0,0,0,99,1,0,0,'LAST_HIT','false'),
(18245,18245,'Watchman of Grave',0,'',0,'LineageMonster.mana_vampire',11.00,20.00,81,'male','L2SepulcherMonster',40,3456,1896,40.29,3.09,40,43,30,21,20,10,0,0,1694,710,977,577,278,0,333,0,0,0,0,99,1,0,0,'LAST_HIT','false'),
(18246,18246,'Watchman of Grave',0,'',0,'LineageMonster.mana_vampire',11.00,20.00,81,'male','L2SepulcherMonster',40,3456,1896,40.29,3.09,40,43,30,21,20,10,0,0,1863,587,1182,477,278,0,333,0,0,0,0,99,1,0,0,'LAST_HIT','false'),
(18247,18247,'Watchman of Grave',0,'',0,'LineageMonster.mana_vampire',11.00,20.00,81,'male','L2SepulcherMonster',40,3456,1896,40.29,3.09,40,43,30,21,20,10,0,0,2480,485,2095,394,278,0,333,0,0,0,0,99,1,0,0,'LAST_HIT','false'),
(18248,18248,'Watchman of Grave',0,'',0,'LineageMonster.mana_vampire',11.00,20.00,81,'male','L2SepulcherMonster',40,3456,1896,40.29,3.09,40,43,30,21,20,10,0,0,1694,710,977,577,278,0,333,0,0,0,0,99,1,0,0,'LAST_HIT','false'),
(18249,18249,'Watchman of Grave',0,'',0,'LineageMonster.mana_vampire',11.00,20.00,81,'male','L2SepulcherMonster',40,3456,1896,40.29,3.09,40,43,30,21,20,10,0,0,1863,587,1182,477,278,0,333,0,0,0,0,99,1,0,0,'LAST_HIT','false'),
(18250,18250,'Watchman of Grave',0,'',0,'LineageMonster.mana_vampire',11.00,20.00,81,'male','L2SepulcherMonster',40,3456,1896,40.29,3.09,40,43,30,21,20,10,0,0,2480,485,2095,394,278,0,333,0,0,0,0,99,1,0,0,'LAST_HIT','false'),
(18251,18251,'Watchman of Grave',0,'',0,'LineageMonster.mana_vampire',11.00,20.00,81,'male','L2SepulcherMonster',40,3456,1896,40.29,3.09,40,43,30,21,20,10,0,0,1694,710,977,577,278,0,333,0,0,0,0,99,1,0,0,'LAST_HIT','false'),
(18252,18252,'Watchman of Grave',0,'',0,'LineageMonster.mana_vampire',11.00,20.00,81,'male','L2SepulcherMonster',40,3456,1896,40.29,3.09,40,43,30,21,20,10,0,0,1863,587,1182,477,278,0,333,0,0,0,0,99,1,0,0,'LAST_HIT','false'),
(18253,18253,'Watchman of Grave',0,'',0,'LineageMonster.mana_vampire',11.00,20.00,81,'male','L2SepulcherMonster',40,3456,1896,40.29,3.09,40,43,30,21,20,10,0,0,2480,485,2095,394,278,0,333,0,0,0,0,99,1,0,0,'LAST_HIT','false'),
(18254,18254,'Watchman of Grave',0,'',0,'LineageMonster.mana_vampire',11.00,20.00,81,'male','L2SepulcherMonster',40,3456,1896,40.29,3.09,40,43,30,21,20,10,0,0,1694,710,977,577,278,0,333,0,0,0,0,99,1,0,0,'LAST_HIT','false'),
(18255,18255,'Watchman of Grave',0,'',0,'LineageMonster.mana_vampire',11.00,20.00,81,'male','L2SepulcherMonster',40,3456,1896,40.29,3.09,40,43,30,21,20,10,0,0,1863,587,1182,477,278,0,333,0,0,0,0,99,1,0,0,'LAST_HIT','false'),
(18256,18256,'Halisha\'s Treasure Box',0,'',0,'LineageMonster.mimic',8.50,8.50,85,'male','L2SepulcherMonster',40,1,1,0.00,0.00,40,43,30,21,20,10,0,0,2,1,1,1,1,0,333,0,0,0,0,0,0,0,0,'LAST_HIT','false'),
(18257,18257,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,52,'male','L2Monster',40,2402,892,10.27,2.45,40,43,30,21,20,10,0,0,518,324,300,239,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18258,18258,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,52,'male','L2Monster',40,2402,892,10.27,2.45,40,43,30,21,20,10,0,0,518,324,300,239,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18259,18259,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,52,'male','L2Monster',40,2402,892,10.27,2.45,40,43,30,21,20,10,0,0,518,324,300,239,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18260,18260,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,52,'male','L2Monster',40,2402,892,10.27,2.45,40,43,30,21,20,10,0,0,518,324,300,239,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18261,18261,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,52,'male','L2Monster',40,2402,892,10.27,2.45,40,43,30,21,20,10,0,0,518,324,300,239,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18262,18262,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,52,'male','L2Monster',40,2402,892,10.27,2.45,40,43,30,21,20,10,0,0,518,324,300,239,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18263,18263,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,52,'male','L2Monster',40,2402,892,10.27,2.45,40,43,30,21,20,10,0,0,518,324,300,239,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18264,18264,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,52,'male','L2Monster',40,2402,892,10.27,2.45,40,43,30,21,20,10,0,0,518,324,300,239,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18265,18265,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,21,'male','L2Chest',40,575,227,5.53,1.53,40,43,30,21,20,10,630,29,63,98,25,80,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18266,18266,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,24,'male','L2Chest',40,687,272,5.53,1.53,40,43,30,21,20,10,771,38,81,111,34,90,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18267,18267,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,27,'male','L2Chest',40,813,318,5.53,1.53,40,43,30,21,20,10,918,47,104,125,45,102,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18268,18268,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,30,'male','L2Chest',40,954,365,5.53,1.53,40,43,30,21,20,10,1080,59,132,140,58,114,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18269,18269,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,33,'male','L2Chest',40,1109,413,7.11,1.84,40,43,30,21,20,10,1306,75,166,157,75,128,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18270,18270,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,36,'male','L2Chest',40,1279,463,7.11,1.84,40,43,30,21,20,10,1555,94,206,175,96,142,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18271,18271,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,39,'male','L2Chest',40,1462,514,7.11,1.84,40,43,30,21,20,10,1825,116,255,195,121,158,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18272,18272,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,42,'male','L2Chest',40,1660,589,8.69,2.14,40,43,30,21,20,10,2116,141,311,215,152,175,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18273,18273,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,45,'male','L2Chest',40,1870,677,8.69,2.14,40,43,30,21,20,10,2430,169,377,238,188,193,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18274,18274,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,48,'male','L2Chest',40,2091,768,8.69,2.14,40,43,30,21,20,10,2764,202,453,261,231,212,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18275,18275,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,51,'male','L2Chest',40,2323,861,10.27,2.45,40,43,30,21,20,10,3121,238,539,286,281,232,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18276,18276,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,54,'male','L2Chest',40,2562,955,10.27,2.45,40,43,30,21,20,10,3499,279,636,313,339,254,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18277,18277,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,57,'male','L2Chest',40,2806,1052,10.27,2.45,40,43,30,21,20,10,3898,324,743,340,405,276,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18278,18278,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,60,'male','L2Chest',40,3054,1150,10.27,2.45,40,43,30,21,20,10,4320,375,860,368,478,299,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18279,18279,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,63,'male','L2Chest',40,3302,1251,11.85,2.78,40,43,30,21,20,10,4762,430,987,398,560,323,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18280,18280,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,66,'male','L2Chest',40,3546,1353,11.85,2.78,40,43,30,21,20,10,5227,492,1123,428,649,348,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18281,18281,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,69,'male','L2Chest',40,3784,1458,11.85,2.78,40,43,30,21,20,10,5713,559,1265,460,746,373,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18282,18282,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,72,'male','L2Chest',40,4013,1565,13.43,3.09,40,43,30,21,20,10,6220,632,1413,491,849,399,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18283,18283,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,75,'male','L2Chest',40,4229,1673,13.43,3.09,40,43,30,21,20,10,6750,712,1563,523,957,425,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18284,18284,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,78,'male','L2Chest',40,4428,1784,13.43,3.09,40,43,30,21,20,10,7300,799,1715,555,1069,451,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18285,18285,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,81,'male','L2Chest',40,4608,1896,13.43,3.09,40,43,30,21,20,10,7873,894,1863,587,1182,477,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18286,18286,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,84,'male','L2Chest',40,4766,2011,13.43,3.09,40,43,30,21,20,10,8467,996,2006,619,1296,502,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18287,18287,'Otherworldly Invader Food',0,'',0,'LineageMonster.mimic',8.50,8.50,33,'male','L2Chest',40,1109,413,7.11,1.84,40,43,30,21,20,10,0,0,166,157,75,128,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18288,18288,'Otherworldly Invader Food',0,'',0,'LineageMonster.mimic',8.50,8.50,35,'male','L2Chest',40,1220,446,7.11,1.84,40,43,30,21,20,10,0,0,192,169,89,137,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18289,18289,'Dimension Invader Food',0,'',0,'LineageMonster.mimic',8.50,8.50,43,'male','L2Chest',40,1728,618,8.69,2.14,40,43,30,21,20,10,0,0,332,223,163,181,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18290,18290,'Dimension Invader Food',0,'',0,'LineageMonster.mimic',8.50,8.50,45,'male','L2Chest',40,1870,677,8.69,2.14,40,43,30,21,20,10,0,0,377,238,188,193,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18291,18291,'Purgatory Invader Food',0,'',0,'LineageMonster.mimic',8.50,8.50,53,'male','L2Chest',40,2481,923,10.27,2.45,40,43,30,21,20,10,0,0,602,304,319,247,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18292,18292,'Purgatory Invader Food',0,'',0,'LineageMonster.mimic',8.50,8.50,55,'male','L2Chest',40,2643,987,10.27,2.45,40,43,30,21,20,10,0,0,670,322,360,261,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18293,18293,'Forbidden Path Invader Food',0,'',0,'LineageMonster.mimic',8.50,8.50,63,'male','L2Chest',40,3302,1251,11.85,2.78,40,43,30,21,20,10,0,0,987,398,560,323,278,0,333,0,0,0,0,80,165,0,0,'LAST_HIT','false'),
(18294,18294,'Forbidden Path Invader Food',0,'',0,'LineageMonster.mimic',8.50,8.50,65,'male','L2Chest',40,3465,1319,11.85,2.78,40,43,30,21,20,10,0,0,1077,418,619,340,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18295,18295,'Dark Omen Invader Food',0,'',0,'LineageMonster.mimic',8.50,8.50,73,'male','L2Chest',40,4086,1601,13.43,3.09,40,43,30,21,20,10,0,0,1463,502,885,407,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18296,18296,'Dark Omen Invader Food',0,'',0,'LineageMonster.mimic',8.50,8.50,75,'male','L2Chest',40,4229,1673,13.43,3.09,40,43,30,21,20,10,0,0,1563,523,957,425,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18297,18297,'Messenger Invader Food',0,'',0,'LineageMonster.mimic',8.50,8.50,83,'male','L2Chest',40,4716,1972,13.43,3.09,40,43,30,21,20,10,0,0,1959,608,1258,494,278,0,333,0,0,0,0,80,165,0,0,'LAST_HIT','false'),
(18298,18298,'Messenger Invader Food',0,'',0,'LineageMonster.mimic',8.50,8.50,85,'male','L2Chest',40,4813,2049,13.43,3.09,40,43,30,21,20,10,0,0,2052,629,1333,511,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18299,18299,'Flame of the Branded',0,'',0,'LineageMonster.big_boom',6.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,52,33,0,0,'LAST_HIT','false'),
(18300,18300,'Offering of the Branded Evoked Spirit',0,'',0,'LineageMonster.orc',10.00,21.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,158,0,0,0,49,170,0,0,'LAST_HIT','false'),
(18301,18301,'Flame of Apostates',0,'',0,'LineageMonster.big_boom',6.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,52,33,0,0,'LAST_HIT','false'),
(18302,18302,'Offering of Apostates Evoked Spirit',0,'',0,'LineageMonster.orc_fighter',12.00,22.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,172,0,0,0,49,176,0,0,'LAST_HIT','false'),
(18303,18303,'Flame of the Witch',0,'',0,'LineageMonster.big_boom',6.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,52,33,0,0,'LAST_HIT','false'),
(18304,18304,'Offering of the Witch Evoked Spirit',0,'',0,'LineageMonster.batur_orc',9.00,21.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,91,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18305,18305,'Flame of Dark Omen',0,'',0,'LineageMonster.big_boom',6.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,52,33,0,0,'LAST_HIT','false'),
(18306,18306,'Offering of Dark Omen Evoked Spirit',0,'',0,'LineageMonster.batur_orc',9.00,21.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,2503,0,0,0,88,187,0,0,'LAST_HIT','false'),
(18307,18307,'Flame of Forbidden Path',0,'',0,'LineageMonster.big_boom',6.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,52,33,0,0,'LAST_HIT','false'),
(18308,18308,'Offering of /Forbidden Path Evoked Spirit',0,'',0,'LineageMonster.batur_orc_warrior',10.00,20.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,175,0,0,0,88,192,0,0,'LAST_HIT','false'),
(18309,18309,'Flame of the Branded',0,'',0,'LineageMonster.big_boom',6.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,52,33,0,0,'LAST_HIT','false'),
(18310,18310,'Offering of the Branded Evoked Spirit',0,'',0,'LineageMonster.orc',10.00,21.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,158,0,0,0,49,170,0,0,'LAST_HIT','false'),
(18311,18311,'Flame of Apostates',0,'',0,'LineageMonster.big_boom',6.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,52,33,0,0,'LAST_HIT','false'),
(18312,18312,'Offering of Apostates Evoked Spirit',0,'',0,'LineageMonster.orc_fighter',12.00,22.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,172,0,0,0,49,176,0,0,'LAST_HIT','false'),
(18313,18313,'Flame of the Witch',0,'',0,'LineageMonster.big_boom',6.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,52,33,0,0,'LAST_HIT','false'),
(18314,18314,'Offering of the Witch Evoked Spirit',0,'',0,'LineageMonster.batur_orc',9.00,21.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,91,0,0,0,88,181,0,0,'LAST_HIT','false'),
(18315,18315,'Flame of Dark Omen',0,'',0,'LineageMonster.big_boom',6.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,52,33,0,0,'LAST_HIT','false'),
(18316,18316,'Offering of Dark Omen Evoked Spirit',0,'',0,'LineageMonster.batur_orc',9.00,21.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,2503,0,0,0,88,187,0,0,'LAST_HIT','false'),
(18317,18317,'Flame of Forbidden Path',0,'',0,'LineageMonster.big_boom',6.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,52,33,0,0,'LAST_HIT','false'),
(18318,18318,'Offering of Forbidden Path Evoked Spirit',0,'',0,'LineageMonster.batur_orc_warrior',10.00,20.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,175,0,0,0,88,192,0,0,'LAST_HIT','false'),
(18319,18319,'Caught Frog',0,'',0,'LineageMonster.poison_toad',20.00,10.00,10,'male','L2PenaltyMonster',40,257,120,3.16,0.91,40,43,30,21,20,10,421,14,22,52,8,49,278,0,333,0,0,0,0,55,121,0,0,'LAST_HIT','false'),
(18320,18320,'Caught Undine',0,'',0,'LineageMonster.undine',12.00,27.00,20,'female','L2PenaltyMonster',40,541,213,3.95,1.21,40,43,30,21,20,10,843,37,57,80,23,76,278,0,333,0,0,0,0,66,132,0,0,'LAST_HIT','false'),
(18321,18321,'Caught Rakul',0,'',0,'LineageMonster.rakul',30.00,39.00,30,'male','L2PenaltyMonster',40,954,365,5.53,1.53,40,43,30,21,20,10,1550,85,132,119,58,114,278,0,333,156,0,0,0,66,143,1,0,'LAST_HIT','false'),
(18322,18322,'Caught Sea Giant',0,'',0,'LineageMonster.water_giant',13.00,44.00,40,'male','L2PenaltyMonster',40,1527,531,7.11,1.84,40,43,30,21,20,10,2755,178,273,171,131,164,278,0,333,131,0,0,0,38,154,0,0,'LAST_HIT','false'),
(18323,18323,'Caught Sea Horse Soldier',0,'',0,'LineageMonster.theeder',9.00,32.00,50,'male','L2PenaltyMonster',80,2245,830,8.69,2.14,40,43,30,21,20,10,4305,324,509,236,264,226,278,0,333,291,0,0,0,80,150,0,0,'LAST_HIT','false'),
(18324,18324,'Caught Homunculus',0,'',0,'LineageMonster2.homunculus',12.00,32.50,60,'male','L2PenaltyMonster',40,3054,1150,10.27,2.45,40,43,30,21,20,10,6200,538,860,313,478,299,278,0,333,0,0,0,0,30,160,0,0,'LAST_HIT','false'),
(18325,18325,'Caught Flava',0,'',0,'LineageMonster2.flava',18.00,34.00,70,'male','L2PenaltyMonster',40,3862,1493,11.85,2.78,40,43,30,21,20,10,8438,837,1314,399,780,382,278,0,333,0,0,0,0,30,170,0,0,'LAST_HIT','false'),
(18326,18326,'Caught Gigantic Eye',0,'',0,'LineageMonster2.hundred_eye',21.00,55.00,80,'male','L2PenaltyMonster',40,4550,1859,13.43,3.09,40,43,30,21,20,10,11022,1237,1814,490,1144,468,278,0,333,0,0,0,0,33,198,0,0,'LAST_HIT','false'),
(18327,18327,'Freya\'s Servant',0,'',0,'LineageMonster.gargoyle_02te',11.00,20.00,58,'male','L2Monster',80,400000,9999,13.43,3.09,40,43,30,21,20,10,440000,40000,9000,5000,6000,6000,300,500,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(18328,18328,'Hall Alarm Device',0,'',0,'LineageNPC.grave_keeper_key',11.00,20.00,80,'male','L2Monster',80,1264000,9999,13.43,3.09,40,43,30,21,20,10,440000,40000,9000,5000,6000,6000,300,500,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(18329,18329,'Hall Keeper Captain',0,'',0,'LineageMonster.death_lord',16.00,40.00,80,'male','L2Monster',40,12608,1896,80.58,3.09,40,43,30,21,20,10,0,0,2255,724,1731,433,278,500,333,78,0,0,0,34,165,0,0,'LAST_HIT','false'),
(18330,18330,'Hall Keeper Wizard',0,'',0,'LineageMonster.vale_master',11.00,40.00,80,'male','L2Monster',40,12608,1896,80.58,3.09,40,43,30,21,20,10,0,0,2055,704,1531,393,278,500,333,0,0,0,0,34,165,0,0,'LAST_HIT','false'),
(18331,18331,'Hall Keeper Guard',0,'',0,'LineageMonster.death_knight',13.00,29.00,80,'male','L2Monster',40,12608,1896,80.58,3.09,40,43,30,21,20,10,0,0,1555,704,1931,393,278,500,333,6717,0,0,0,34,165,0,0,'LAST_HIT','false'),
(18332,18332,'Hall Keeper Patrol',0,'',0,'LineageMonster.headless_knight',20.00,30.00,80,'male','L2Monster',40,12608,1896,80.58,3.09,40,43,30,21,20,10,0,0,2055,704,1531,393,278,500,333,6717,0,0,0,34,165,0,0,'LAST_HIT','false'),
(18333,18333,'Hall Keeper Suicidal Soldier',0,'',0,'LineageMonster3.self_blaster',11.00,20.00,80,'male','L2Monster',40,12608,1896,80.58,3.09,40,43,30,21,20,10,0,0,2055,704,1531,393,278,500,333,0,0,0,0,34,165,0,0,'LAST_HIT','false'),
(18334,18334,'Dark Choir Captain',0,'',0,'LineageMonster2.erinyes_cmd',20.00,46.00,85,'male','L2Monster',40,12608,1896,80.58,3.09,40,43,30,21,20,10,0,0,2455,734,1931,483,308,2000,333,0,0,0,0,34,165,0,0,'LAST_HIT','false'),
(18335,18335,'Dark Choir Prima Donna',0,'',0,'LineageMonster3.portrait_spirit',11.00,20.00,80,'male','L2Monster',80,400000,9999,13.43,3.09,40,43,30,21,20,10,440000,40000,9000,5000,6000,6000,300,500,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(18336,18336,'Dark Choir Lancer',0,'',0,'LineageMonster.death_blader',12.00,42.00,80,'male','L2Monster',40,12608,1896,80.58,3.09,40,43,30,21,20,10,0,0,2255,734,1731,433,278,400,333,1472,1472,0,0,34,165,0,0,'LAST_HIT','false'),
(18337,18337,'Dark Choir Archer',0,'',0,'LineageMonster.skeleton_archer_20_bi',10.00,33.00,80,'male','L2Monster',120,12608,1896,80.58,3.09,40,43,30,21,20,10,0,0,2255,734,1731,433,278,400,333,4819,4819,0,0,34,165,0,0,'LAST_HIT','false'),
(18338,18338,'Dark Choir Witch Doctor',0,'',0,'LineageMonster3.portrait_spirit_winged',11.00,20.00,80,'male','L2Monster',80,400000,9999,13.43,3.09,40,43,30,21,20,10,440000,40000,9000,5000,6000,6000,300,500,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(18339,18339,'Dark Choir Player',0,'',0,'LineageMonster.skeleton',11.00,20.00,80,'male','L2Monster',80,400000,9999,13.43,3.09,40,43,30,21,20,10,440000,40000,9000,5000,6000,6000,300,500,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(18340,18340,'Hall Keeper Suicidal Soldier',0,'',0,'LineageMonster3.self_blaster',11.00,20.00,80,'male','L2Monster',80,400000,9999,13.43,3.09,40,43,30,21,20,10,440000,40000,9000,5000,6000,6000,300,500,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(18341,18341,'Hall Keeper Suicidal Soldier',0,'',0,'LineageMonster3.self_blaster',11.00,20.00,80,'male','L2Monster',80,400000,9999,13.43,3.09,40,43,30,21,20,10,440000,40000,9000,5000,6000,6000,300,500,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(18342,18342,'Gremlin',0,'',0,'LineageMonster.gremlin',10.00,15.00,1,'male','L2Monster',40,62,44,3.16,0.91,40,43,30,21,20,10,29,2,9,39,3,32,278,0,333,0,0,0,0,20,90,0,0,'LAST_HIT','false'),
(18343,18343,'Gatekeeper Zombie',0,'',0,'LineageMonster3.zombie_gateguard',17.00,30.50,78,'male','L2Monster',80,400000,9999,13.43,3.09,40,43,30,21,20,10,440000,40000,9000,5000,6000,6000,278,500,333,8217,0,0,0,33,120,0,0,'LAST_HIT','false'),
(18344,18344,'Ancient Egg',0,'',0,'LineageNpcEV.dinosaur_nest',43.00,10.00,78,'male','L2Monster',0,3,3,4.74,3.09,40,43,30,21,20,10,0,0,1,606,1,1182,278,0,333,0,0,0,0,0,0,0,0,'LAST_HIT','false'),
(18345,18345,'Sprigant',0,'',0,'LineageMonster3.Arachnoid',45.00,67.00,78,'male','L2Monster',40,1179,2057,13.43,3.09,40,43,30,21,20,10,0,0,2129,615,2129,511,278,500,333,0,0,0,0,60,165,0,0,'LAST_HIT','false'),
(18346,18346,'Sprigant',0,'',0,'LineageMonster3.Arachnoid',45.00,67.00,78,'male','L2Monster',40,1179,2057,13.43,3.09,40,43,30,21,20,10,0,0,2129,615,2129,511,300,500,333,0,0,0,0,0,0,0,0,'LAST_HIT','false'),
(18347,18347,'Garden Guard',0,'',0,'LineageMonster4.Mostro_Fighter',15.50,22.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18348,18348,'Garden Guard',0,'',0,'LineageMonster4.Mostro_Fighter',15.50,22.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18349,18349,'Garden Guard',0,'',0,'LineageMonster4.Mostro_Gunner',15.00,24.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18350,18350,'Garden Guard',0,'',0,'LineageMonster4.Mostro_Fighter',15.50,22.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18351,18351,'Garden Guard',0,'',0,'LineageMonster4.Mostro_Fighter',15.50,22.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18352,18352,'Kamael Guard',0,'',0,'LineageMonster4.Mostro_Fighter',15.50,22.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18353,18353,'Guardian of Records',0,'',0,'LineageMonster4.Mostro_Fighter',15.50,22.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18354,18354,'Guardian of Observation',0,'',0,'LineageMonster4.Mostro_Fighter',15.50,22.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18355,18355,'Spicula\'s Guard',0,'',0,'LineageMonster4.Mostro_Fighter',15.50,22.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18356,18356,'Harkilgamed\'s Gatekeeper',0,'',0,'LineageMonster4.Mostro_Gunner',15.00,24.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18357,18357,'Rodenpicula\'s Gatekeeper',0,'',0,'LineageMonster4.Mostro_Fighter',15.50,22.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18358,18358,'Guardian of Secrets',0,'',0,'LineageMonster4.Mostro_Fighter',15.50,22.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18359,18359,'Arviterre\'s Guardian',0,'',0,'LineageMonster4.Mostro_Fighter',15.50,22.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18360,18360,'Katenar\'s Gatekeeper',0,'',0,'LineageMonster4.Mostro_Fighter',15.50,22.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18361,18361,'Guardian of Prediction',0,'',0,'LineageMonster4.Mostro_Fighter',15.50,22.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18362,18362,'Garden Guard',0,'',0,'LineageMonster4.Mostro_Fighter',15.50,22.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18363,18363,'Garden Guard',0,'',0,'LineageMonster4.Mostro_Gunner',15.00,24.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18364,18364,'Witch Warder',0,'',0,'LineageMonster.onyx_beast',14.00,18.70,79,'male','L2Monster',40,22454,1821,26.86,3.09,40,43,30,21,20,10,0,0,1765,481,1107,459,278,0,333,0,0,0,0,11,165,0,0,'LAST_HIT','false'),
(18365,18365,'Witch Warder',0,'',0,'LineageMonster.onyx_beast',14.00,18.70,80,'male','L2Monster',40,22754,1859,26.86,3.09,40,43,30,21,20,10,0,0,1996,524,1144,468,278,0,333,0,0,0,0,39,192,0,0,'LAST_HIT','false'),
(18366,18366,'Witch Warder',0,'',0,'LineageMonster.onyx_beast',14.00,18.70,82,'male','L2Monster',40,23319,1934,26.86,3.09,40,43,30,21,20,10,0,0,1912,598,1220,485,278,0,333,0,0,0,0,49,192,0,0,'LAST_HIT','false'),
(18367,18367,'Prison Guard',0,'',0,'LineageMonster3.zombie_gateguard',17.00,30.50,80,'male','L2Monster',40,4550,1859,26.86,3.09,40,43,30,21,20,10,9304,1044,1996,524,1144,468,278,0,333,8217,0,0,0,39,192,0,0,'LAST_HIT','false'),
(18368,18368,'Prison Guard',0,'',0,'LineageMonster3.zombie_gateguard',17.00,30.50,80,'male','L2Monster',40,4550,1859,26.86,3.09,40,43,30,21,20,10,9304,1044,1996,524,1144,468,278,500,333,8217,0,0,0,39,192,0,0,'LAST_HIT','false'),
(18369,18369,'Chromatic Crystalline Golem',0,'',0,'LineageMonster4.Crystal_Golem',40.00,47.00,82,'male','L2Monster',40,4664,1935,26.86,3.09,40,43,30,21,20,20,9308,1017,1896,598,883,486,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18370,18370,'Chromatic Crystalline Golem',0,'',0,'LineageMonster4.Crystal_Golem',40.00,47.00,82,'male','L2Monster',40,4664,1935,26.86,3.09,40,43,30,21,20,20,8545,934,1896,598,883,486,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18371,18371,'Beleth Sample',0,'',0,'LineageMonster3.zombie_gateguard',17.00,30.50,82,'male','L2Monster',40,4664,1935,26.86,3.09,40,43,30,21,20,20,7697,841,1896,598,883,486,253,0,333,8217,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18372,18372,'Beleth Sample',0,'',0,'LineageMonster3.zombie_laborer',11.00,24.60,82,'male','L2Monster',40,4664,1935,26.86,3.09,40,43,30,21,20,20,7697,841,1896,598,883,486,253,0,333,123,0,NULL,0,60,120,0,0,'LAST_HIT','false'),
(18373,18373,'Beleth Sample',0,'',0,'LineageMonster3.zombie_enlisted_man',17.00,22.30,82,'male','L2Monster',40,4664,1935,26.86,3.09,40,43,30,21,20,20,7697,841,1896,598,883,486,253,0,333,0,0,NULL,0,0,0,0,0,'LAST_HIT','false'),
(18374,18374,'Beleth Sample',0,'',0,'LineageMonster3.zombie_em_knight',17.00,22.30,82,'male','L2Monster',40,4664,1935,26.86,3.09,40,43,30,21,20,20,7697,841,1896,598,883,486,253,0,333,8215,0,NULL,0,60,120,0,0,'LAST_HIT','false'),
(18375,18375,'Beleth Sample',0,'',0,'LineageMonster.skeleton_royal_guard',11.00,28.50,82,'male','L2Monster',40,4664,1935,26.86,3.09,40,43,30,21,20,20,7697,841,1896,598,883,486,253,0,333,946,945,NULL,0,60,120,0,0,'LAST_HIT','false'),
(18376,18376,'Beleth Sample',0,'',0,'LineageMonster.vale_master',16.00,47.00,82,'male','L2Monster',40,4664,1935,26.86,3.09,40,43,30,21,20,20,7697,841,1896,598,883,486,253,0,333,205,0,NULL,0,60,120,0,0,'LAST_HIT','false'),
(18377,18377,'Beleth Sample',0,'',0,'LineageMonster.skeleton_knight',10.00,25.00,82,'male','L2Monster',40,4664,1935,26.86,3.09,40,43,30,21,20,20,7697,841,1896,598,883,486,253,0,333,150,103,NULL,0,60,120,0,0,'LAST_HIT','false'),
(18378,18378,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_switch',20.00,13.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18379,18379,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18380,18380,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18381,18381,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18382,18382,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18383,18383,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18384,18384,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18385,18385,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18386,18386,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18387,18387,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18388,18388,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18389,18389,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18390,18390,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18391,18391,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18392,18392,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18393,18393,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18394,18394,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18395,18395,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18396,18396,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18397,18397,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18398,18398,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18399,18399,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18400,18400,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18401,18401,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18402,18402,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18403,18403,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18404,18404,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18405,18405,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18406,18406,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18407,18407,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18408,18408,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18409,18409,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18410,18410,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18411,18411,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18412,18412,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18413,18413,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18414,18414,'Warrior\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar',9.00,33.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18415,18415,'Midway Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar',9.00,33.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18416,18416,'Doorman',0,'',0,'LineageNpcEV.trioll_altar',9.00,33.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18417,18417,'Bridge Keeper',0,'',0,'LineageNpcEV.trioll_altar',9.00,33.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18418,18418,'Bridge Keeper',0,'',0,'LineageNpcEV.trioll_altar',9.00,33.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18419,18419,'Bridge Keeper',0,'',0,'LineageNpcEV.trioll_altar',9.00,33.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18420,18420,'Trap',0,'',0,'LineageNpcEV.trioll_altar',9.00,33.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18427,18427,'',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18428,18428,'',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18429,18429,'',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18430,18430,'',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18431,18431,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18432,18432,'Trap',0,'',0,'LineageNpcEV.Trap_device_wall_switch',13.60,38.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18433,18433,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18434,18434,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18435,18435,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18436,18436,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18437,18437,'Trap',0,'',0,'LineageNPC.clear_npc',0.10,0.10,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18438,18438,'Trap',0,'',0,'LineageNpcEV.trioll_altar',9.00,33.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18441,18441,'Kamael Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar',9.00,33.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18442,18442,'Trap',0,'',0,'LineageNpcEV.trioll_altar',9.00,33.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18443,18443,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff',30.00,13.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18444,18444,'Garden Guard',0,'',0,'LineageMonster4.Mostro_Fighter',15.50,22.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18445,18445,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar',9.00,33.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18446,18446,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar',9.00,33.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18447,18447,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar',9.00,33.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18448,18448,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar',9.00,33.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18449,18449,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar',9.00,33.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18450,18450,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar',9.00,33.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18451,18451,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar',9.00,33.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18452,18452,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar',9.00,33.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18453,18453,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar',9.00,33.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18454,18454,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar',9.00,33.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18455,18455,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar',9.00,33.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18456,18456,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar',9.00,33.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18457,18457,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar',9.00,33.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18458,18458,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar',9.00,33.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18459,18459,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar',9.00,33.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18460,18460,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar',9.00,33.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18461,18461,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar',9.00,33.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18463,18463,'Remnant Diabolist',0,'',0,'LineageNPC.e_traderB_Fdwarf_mon_120p',7.70,28.40,83,'male','L2Monster',40,103599,2444,56.86,3.09,40,43,30,21,20,10,198007,21380,23356,1220,6250,1034,253,400,253,0,0,NULL,0,80,170,0,0,'LAST_HIT','false'),
(18464,18464,'Remnant Diviner',0,'',0,'LineageNPC.a_mageguild_teacher_Mhuman_mon',11.00,25.40,83,'male','L2Monster',40,2444,2444,56.86,3.09,40,43,30,21,20,10,103599,27522,23356,1220,6250,1034,253,400,253,0,0,NULL,0,80,170,0,0,'LAST_HIT','false'),
(18465,18465,'Derek',0,'First Generation Seer',0,'LineageNPC.a_mageguild_teacher_Mhuman_mon_120p',12.50,33.50,83,'male','L2Monster',40,1061952,2444,56.86,3.09,40,43,30,21,20,10,2837400,302710,20773,1620,10250,1434,253,0,253,0,0,NULL,0,80,170,0,0,'LAST_HIT','false'),
(18466,18466,'Outpost Captain',0,'',0,'LineageMonster3.benom',20.00,56.00,85,'male','L2Monster',40,176243,2444,56.86,3.09,40,43,30,21,20,10,283740,30271,20773,1620,10250,1434,253,300,253,8203,8203,NULL,0,80,170,0,0,'LAST_HIT','false'),
(18467,18467,'Wounded Land Guard',0,'',0,'LineageMonster4.eyeless',36.00,43.50,84,'male','L2Monster',40,530976,2444,56.86,3.09,40,43,30,21,20,10,1096172,116952,15773,1120,5250,934,278,0,333,0,0,NULL,0,60,210,0,0,'LAST_HIT','false'),
(18468,18468,'Doorman',0,'',0,'LineageNpcEV.trioll_altar',9.00,33.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18469,18469,'Hall Guard',0,'',0,'LineageMonster.blade_stakato_120p',20.00,41.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18470,18470,'Hall Guard',0,'',0,'LineageMonster.blade_stakato_soldier_120p',20.00,41.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18471,18471,'Hall Guard',0,'',0,'LineageMonster4.Anthias',20.00,41.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18472,18472,'Hall Guard',0,'',0,'LineageMonster4.Anthias',20.00,41.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18473,18473,'Hall Captain',0,'',0,'LineageMonster3.cannibal_stakato_leader_120p',20.00,27.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18474,18474,'Alarm',0,'',0,'LineageNpcEV.trioll_altar',9.00,33.50,83,'male','L2Monster',40,4717,1973,0.00,0.00,40,43,30,21,20,20,0,0,1943,609,901,494,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18475,18475,'Hall Guard',0,'',0,'LineageMonster.undine',20.00,41.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18476,18476,'Hall Guard',0,'',0,'LineageMonster.lienrik_210p',20.00,41.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18477,18477,'Coral Treasure Chest',0,'',0,'LineageMonster.mimic_even',8.50,8.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18478,18478,'Herb Jar',0,'',0,'LineageNpcEV.herb_pot',8.00,21.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18479,18479,'Inner Castle Sentry',0,'',0,'LineageMonster.kel_mahum',36.00,43.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18480,18480,'Inner Castle Guard',0,'',0,'LineageMonster4.eyeless',36.00,43.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18481,18481,'Inner Castle Seer',0,'',0,'LineageMonster4.eyeless',36.00,43.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18482,18482,'Fafurion Kindred',0,'',0,'LineageMonster3.Water_Drake',35.00,58.00,82,'male','L2Monster',40,9327,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,0,0,0,0,'LAST_HIT','false'),
(18483,18483,'Garden Guard',0,'',0,'LineageMonster4.Mostro_Fighter',15.50,22.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18484,18484,'Naia Failan',0,'',0,'LineageNPC.heart_of_warding',17.00,75.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18485,18485,'',0,'',0,'LineageNPC.clear_npc',0.10,0.10,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,1,1,0,0,'LAST_HIT','false'),
(18486,18486,'',0,'',0,'LineageNPC.clear_npc',0.10,0.10,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18487,18487,'',0,'',0,'LineageNPC.clear_npc',0.10,0.10,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,1,1,0,0,'LAST_HIT','false'),
(18488,18488,'',0,'',0,'LineageNPC.clear_npc',0.10,0.10,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18489,18489,'',0,'',0,'LineageNPC.clear_npc',0.10,0.10,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18490,18490,'Beleth\'s Slave',0,'',0,'LineageMonster4.devil_doll',8.00,17.50,86,'male','L2Monster',40,29293,2089,26.86,3.09,40,43,30,21,20,20,65975,6876,21589,1024,10032,1247,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18491,18491,'Lock',0,'Tower of Naia',0,'LineageNpcEV.soulprison',21.00,53.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18492,18492,'Controller',0,'Tower of Naia',0,'LineageNpcEV.elobrate_machine',13.00,20.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18493,18493,'Ward',0,'Tower of Naia',0,'LineageMonster2.hundred_eye',21.00,55.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(18494,18494,'Ingenious Contraption',0,'',0,'LineageNpcEV.elobrate_machine',13.00,20.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18495,18495,'Ingenious Contraption',0,'',0,'LineageNpcEV.elobrate_machine',13.00,20.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18496,18496,'Ingenious Contraption',0,'',0,'LineageNpcEV.elobrate_machine',13.00,20.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18497,18497,'Ingenious Contraption',0,'',0,'LineageNpcEV.elobrate_machine',13.00,20.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18498,18498,'Ingenious Contraption',0,'',0,'LineageNpcEV.elobrate_machine',13.00,20.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18499,18499,'Ingenious Contraption',0,'',0,'LineageNpcEV.elobrate_machine',13.00,20.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18500,18500,'Ingenious Contraption',0,'',0,'LineageNpcEV.elobrate_machine',13.00,20.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18501,18501,'Ingenious Contraption',0,'',0,'LineageNpcEV.elobrate_machine',13.00,20.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18502,18502,'Ingenious Contraption',0,'',0,'LineageNpcEV.elobrate_machine',13.00,20.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18503,18503,'Ingenious Contraption',0,'',0,'LineageNpcEV.elobrate_machine',13.00,20.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18504,18504,'Ingenious Contraption',0,'',0,'LineageNpcEV.elobrate_machine',13.00,20.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18505,18505,'Ingenious Contraption',0,'',0,'LineageNpcEV.elobrate_machine',13.00,20.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18506,18506,'Soul Crystal Pillar',0,'',0,'LineageNpcEV.soulprison',21.00,53.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18507,18507,'',0,'',0,'LineageNpcEV.trap_ironcastle',12.00,20.40,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18508,18508,'',0,'',0,'LineageNpcEV.trap_ironcastle',12.00,20.40,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18509,18509,'',0,'',0,'LineageNpcEV.trap_ironcastle',12.00,20.40,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18510,18510,'',0,'',0,'LineageNpcEV.trap_ironcastle',12.00,20.40,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18511,18511,'',0,'',0,'LineageNpcEV.trap_ironcastle',12.00,20.40,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18512,18512,'',0,'',0,'LineageNpcEV.trap_ironcastle',12.00,20.40,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18513,18513,'',0,'',0,'LineageNpcEV.trap_ironcastle',12.00,20.40,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18514,18514,'',0,'',0,'LineageNpcEV.trap_ironcastle',12.00,20.40,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18515,18515,'',0,'',0,'LineageNpcEV.trap_ironcastle',12.00,20.40,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18516,18516,'',0,'',0,'LineageNpcEV.trap_ironcastle',12.00,20.40,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18517,18517,'',0,'',0,'LineageNpcEV.trap_ironcastle',12.00,20.40,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18518,18518,'',0,'',0,'LineageNpcEV.trap_ironcastle',12.00,20.40,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18519,18519,'',0,'',0,'LineageNpcEV.trap_ironcastle',12.00,20.40,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18520,18520,'',0,'',0,'LineageNpcEV.trap_ironcastle',12.00,20.40,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18521,18521,'',0,'',0,'LineageNpcEV.trap_ironcastle',12.00,20.40,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18522,18522,'',0,'',0,'LineageNpcEV.trap_ironcastle',12.00,20.40,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18523,18523,'',0,'',0,'LineageNpcEV.trap_ironcastle',12.00,20.40,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18524,18524,'',0,'',0,'LineageNpcEV.trap_ironcastle',12.00,20.40,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18525,18525,'',0,'',0,'LineageNpcEV.trap_ironcastle',12.00,20.40,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18526,18526,'',0,'',0,'LineageNpcEV.trap_ironcastle',12.00,20.40,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18527,18527,'',0,'',0,'LineageNpcEV.trap_ironcastle',12.00,20.40,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18528,18528,'',0,'',0,'LineageNpcEV.trap_ironcastle',12.00,20.40,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18529,18529,'',0,'',0,'LineageNpcEV.trap_ironcastle',12.00,20.40,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18530,18530,'',0,'',0,'LineageNpcEV.trap_ironcastle',12.00,20.40,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18531,18531,'',0,'',0,'LineageNpcEV.trap_ironcastle',12.00,20.40,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18532,18532,'',0,'',0,'LineageNpcEV.trap_ironcastle',12.00,20.40,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18533,18533,'',0,'',0,'LineageNpcEV.trap_ironcastle',12.00,20.40,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18534,18534,'Kertang\'s Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18535,18535,'Kertang\'s Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18536,18536,'Kertang\'s Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18537,18537,'Kertang\'s Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18538,18538,'Kertang\'s Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18539,18539,'Resurrection Tower',0,'',0,'LineageNpcEV.resurrection_tower',28.00,50.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18540,18540,'Resurrection Tower',0,'',0,'LineageNpcEV.resurrection_tower',28.00,50.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18541,18541,'Resurrection Tower',0,'',0,'LineageNpcEV.resurrection_tower',28.00,50.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18542,18542,'Resurrection Tower',0,'',0,'LineageNpcEV.resurrection_tower',28.00,50.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18543,18543,'Resurrection Tower',0,'',0,'LineageNpcEV.resurrection_tower',28.00,50.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18544,18544,'Cruma Border',0,'Event Monster',0,'LineageNpcEV.trap_ironcastle',12.00,20.40,45,'male','L2Monster',40,1870,678,17.38,2.14,40,43,30,21,20,10,0,0,375,238,172,194,253,0,333,0,0,NULL,0,0,0,0,0,'LAST_HIT','true'),
(18545,18545,'Ancient Experiment',0,'Event Monster',0,'LineageMonster.marsh_stakato_soldier',10.00,25.00,45,'male','L2Monster',40,14963,2444,17.38,2.14,40,43,30,21,20,10,0,0,228,200,120,130,278,0,333,0,0,NULL,0,40,60,0,0,'LAST_HIT','false'),
(18546,18546,'Ancient Experiment',0,'Event Monster',0,'LineageMonster.stone_golem',20.00,31.00,45,'male','L2Monster',40,19909,2444,17.38,2.14,40,43,30,21,20,10,0,0,228,200,120,130,278,0,333,0,0,NULL,0,40,60,0,0,'LAST_HIT','false'),
(18547,18547,'Ancient Experiment',0,'Event Monster',0,'LineageMonster.onyx_beast',14.00,14.50,45,'male','L2Monster',40,59729,2444,17.38,2.14,40,43,30,21,20,10,0,0,200,100,120,100,278,0,333,0,0,NULL,0,60,120,0,0,'LAST_HIT','false'),
(18548,18548,'Ancient Experiment',0,'',0,'LineageMonster.onyx_beast',14.00,14.50,45,'male','L2Monster',40,9954,2444,17.38,2.14,40,43,30,21,20,10,0,0,110,80,90,80,278,0,333,0,0,NULL,0,60,120,0,0,'LAST_HIT','false'),
(18549,18549,'Ancient Experiment',0,'',0,'LineageMonster.onyx_beast',14.00,14.50,45,'male','L2Monster',40,9954,2444,17.38,2.14,40,43,30,21,20,10,0,0,110,80,90,80,278,0,333,0,0,NULL,0,60,120,0,0,'LAST_HIT','false'),
(18550,18550,'Cruma Phantom',0,'Event Monster',0,'LineageMonster.death_blader',15.00,45.00,50,'male','L2Monster',40,55990,707,17.38,2.14,40,43,30,21,20,10,0,0,165,170,120,130,278,0,333,0,0,NULL,0,40,60,0,0,'LAST_HIT','false'),
(18551,18551,'Cruma Phantom',0,'Event Monster',0,'LineageMonster.susceptor',20.00,35.00,50,'male','L2Monster',40,83985,707,17.38,2.14,40,43,30,21,20,10,0,0,165,130,120,120,278,0,333,0,0,NULL,0,40,60,0,0,'LAST_HIT','false'),
(18552,18552,'Cruma Phantom',0,'',0,'LineageMonster.gamlin',11.00,32.00,50,'male','L2Monster',40,27995,707,17.38,2.14,40,43,30,21,20,10,0,0,165,170,120,100,278,0,333,0,0,NULL,0,40,90,0,0,'LAST_HIT','false'),
(18553,18553,'Cruma Phantom',0,'',0,'LineageMonster.leogul',11.00,32.00,50,'male','L2Monster',40,27995,707,17.38,2.14,40,43,30,21,20,10,0,0,165,170,120,100,278,0,333,0,0,NULL,0,40,90,0,0,'LAST_HIT','false'),
(18554,18554,'Tomlan Kamos',0,'Kaneus',0,'LineageMonster.bugbear_bi',23.00,53.00,23,'male','L2Monster',40,81589,1287,13.43,3.09,40,43,30,21,20,20,355901,19458,91,171,40,209,253,0,333,4,0,NULL,0,60,140,0,0,'LAST_HIT','false'),
(18555,18555,'Ol Ariosh',0,'Kaneus',0,'LineageMonster.ol_mahum_champion_05te_120p',16.00,33.20,26,'male','L2Monster',40,95696,1515,13.43,3.09,40,43,30,21,20,20,397272,23285,136,193,61,235,253,0,333,67,633,NULL,0,60,140,0,0,'LAST_HIT','false'),
(18556,18556,'Follower of Ariosh',0,'',0,'LineageMonster.ol_mahum_champion',14.00,27.00,26,'male','L2Monster',40,770,1515,13.43,3.09,40,43,30,21,20,20,0,0,95,121,46,98,253,0,333,69,102,NULL,0,60,140,0,0,'LAST_HIT','false'),
(18557,18557,'Ranc Deumus',0,'Kaneus',0,'LineageMonster.virud_lizardman_warrior_bi',12.00,34.50,26,'male','L2Monster',40,95696,1515,13.43,3.09,40,43,30,21,20,20,397272,23285,136,193,61,235,253,0,333,93,0,NULL,0,60,140,0,0,'LAST_HIT','false'),
(18558,18558,'Crimson Hatu Otis',0,'Kaneus',0,'LineageMonster.crimson_bear',19.00,36.00,33,'male','L2Monster',40,121680,2070,13.43,3.09,40,43,30,21,20,20,549172,35415,278,252,131,307,253,0,333,0,0,NULL,0,60,140,0,0,'LAST_HIT','false'),
(18559,18559,'Seer Flouros',0,'Kaneus',0,'LineageMonster.monster_eye_05te_ef',21.00,43.00,36,'male','L2Monster',40,148876,2318,13.43,3.09,40,43,30,21,20,20,620253,41849,366,281,168,343,253,0,333,0,0,NULL,0,60,140,0,0,'LAST_HIT','false'),
(18560,18560,'Follower of Flouros',0,'',0,'LineageMonster.monster_eye',21.00,43.00,36,'male','L2Monster',40,1279,2318,13.43,3.09,40,43,30,21,20,20,0,0,205,176,93,143,253,0,333,0,0,NULL,0,60,140,0,0,'LAST_HIT','false'),
(18561,18561,'Granitick Duerga',0,'Kaneus',0,'LineageMonster.stone_golem',20.00,31.00,36,'male','L2Monster',40,148876,2318,13.43,3.09,40,43,30,21,20,20,620253,41849,366,281,168,343,253,0,333,0,0,NULL,0,60,140,0,0,'LAST_HIT','false'),
(18562,18562,'Blade Otis',0,'Kaneus',0,'LineageMonster.blade_stakato_drone_10_sm',14.00,39.09,43,'male','L2Monster',40,209563,3094,13.43,3.09,40,43,30,21,20,20,784383,58093,567,357,261,435,253,0,333,131,0,NULL,0,60,140,0,0,'LAST_HIT','false'),
(18563,18563,'Follower of Otis',0,'',0,'LineageMonster.marsh_stakato_drone',9.00,24.00,43,'male','L2Monster',40,1729,3094,13.43,3.09,40,43,30,21,20,20,0,0,330,223,155,181,253,0,333,223,0,NULL,0,60,140,0,0,'LAST_HIT','false'),
(18564,18564,'Weird Bunei',0,'Kaneus',0,'LineageMonster3.Water_Drake',55.00,80.00,46,'female','L2Monster',40,261052,3540,13.43,3.09,40,43,30,21,20,20,848114,69276,756,394,349,479,253,0,333,0,0,NULL,0,60,140,0,0,'LAST_HIT','false'),
(18565,18565,'Brave Martim',0,'Kaneus',0,'LineageMonster.ogre_50_bi',30.00,66.00,46,'male','L2Monster',40,261052,3540,13.43,3.09,40,43,30,21,20,20,848114,69276,756,394,349,479,253,0,333,298,0,NULL,0,60,140,0,0,'LAST_HIT','false'),
(18566,18566,'Kaim Abigore',0,'Kaneus',0,'LineageMonster.kaim_vanul_50_bi',36.00,60.00,53,'male','L2Monster',40,464796,4620,13.43,3.09,40,43,30,21,20,20,967925,88254,1361,487,634,593,253,0,333,0,0,NULL,0,60,140,0,0,'LAST_HIT','false'),
(18567,18567,'Follower of Abigore',0,'',0,'LineageMonster.liviona',15.00,28.00,53,'male','L2Monster',40,2482,4620,13.43,3.09,40,43,30,21,20,20,0,0,598,304,279,247,253,0,333,0,0,NULL,0,60,140,0,0,'LAST_HIT','false'),
(18568,18568,'Knight Montagnar',0,'Kaneus',0,'LineageMonster.skeleton_royal_guard',11.00,28.50,56,'male','L2Monster',40,502835,5099,13.43,3.09,40,43,30,21,20,20,1002611,124970,1923,530,892,646,253,0,333,946,945,NULL,0,60,140,0,0,'LAST_HIT','false'),
(18569,18569,'Follower of Montagnar',0,'',0,'LineageMonster.dark_fencer',7.00,13.00,56,'male','L2Monster',40,2725,5099,13.43,3.09,40,43,30,21,20,20,0,0,700,331,327,269,253,0,333,0,0,NULL,0,60,140,1,0,'LAST_HIT','false'),
(18570,18570,'Summer Yaganitan',0,'Kaneus',0,'LineageMonster2.flava_15_bi',23.00,39.00,56,'male','L2Monster',40,502835,5099,13.43,3.09,40,43,30,21,20,20,1002611,124970,1923,530,892,646,253,0,333,0,0,NULL,0,60,140,0,0,'LAST_HIT','false'),
(18571,18571,'Venomous Storace',0,'Kaneus',0,'LineageMonster.serpent_slave_50_bi',19.00,72.00,63,'male','L2Monster',40,664392,6257,13.43,3.09,40,43,30,21,20,20,1046467,179455,3388,638,1572,777,253,0,333,73,0,NULL,0,60,140,0,0,'LAST_HIT','false'),
(18572,18572,'Follower of Storace',0,'',0,'LineageMonster.cave_maiden_080p',21.00,54.00,63,'female','L2Monster',40,3302,6257,13.43,3.09,40,43,30,21,20,20,0,0,979,399,453,324,253,0,333,73,0,NULL,0,60,140,0,0,'LAST_HIT','false'),
(18573,18573,'Kel Bilette',0,'Kaneus',0,'LineageMonster.kel_mahum_champion_50_bi',19.00,48.00,66,'male','L2Monster',40,704666,6770,13.43,3.09,40,43,30,21,20,20,1052061,186892,3928,686,1827,836,253,0,333,75,0,NULL,0,60,140,0,0,'LAST_HIT','false'),
(18574,18574,'Follower of Bilette',0,'',0,'LineageMonster.kel_mahum_witch_doctor',13.00,25.00,66,'male','L2Monster',40,3547,6770,13.43,3.09,40,43,30,21,20,20,0,0,1114,429,519,348,253,0,333,193,0,NULL,0,60,140,0,0,'LAST_HIT','false'),
(18575,18575,'Warlord Tamuze',0,'Kaneus',0,'LineageMonster3.Vampire_Troop_Leader_120p',22.00,43.00,66,'male','L2Monster',40,704666,6770,13.43,3.09,40,43,30,21,20,20,1052061,186892,3928,686,1827,836,253,0,333,8686,0,NULL,0,60,140,0,0,'LAST_HIT','false'),
(18576,18576,'Follower of Tamuze',0,'',0,'LineageMonster3.self_blaster',9.00,25.80,66,'male','L2Monster',40,3547,6770,13.43,3.09,40,43,30,21,20,20,0,0,1114,429,519,348,253,0,333,0,0,NULL,0,60,140,0,0,'LAST_HIT','false'),
(18577,18577,'White Allosce',0,'Kaneus',0,'LineageMonster2.hundred_eye',21.00,55.00,73,'male','L2Monster',40,750958,8005,13.43,3.09,40,43,30,21,20,20,1169076,202886,5666,804,2635,979,253,0,333,0,0,NULL,0,60,140,0,0,'LAST_HIT','false'),
(18578,18578,'Follower of Allosce',0,'',0,'LineageMonster.monster_eye',21.00,43.00,73,'male','L2Monster',40,4087,8005,13.43,3.09,40,43,30,21,20,20,0,0,1451,502,672,408,253,0,333,0,0,NULL,0,60,140,1,0,'LAST_HIT','false'),
(18579,18579,'Hunting Ground Keeper',0,'',0,'LineageMonster4.employee_of_baroness',15.00,28.70,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18580,18580,'Cursed Girl',0,'',0,'LineageMonster4.cursed_housemaid',8.00,17.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18581,18581,'Gardener',0,'',0,'LineageMonster4.gardener',17.00,26.80,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18582,18582,'Turned Girl',0,'Kratei\'s Fortune',0,'LineageMonster4.cursed_housemaid',8.00,17.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18583,18583,'Housekeeper',0,'',0,'LineageMonster4.mad_laundry_maid',9.00,21.60,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18584,18584,'Turned Boy',0,'',0,'LineageMonster4.cursed_errand_boy',8.00,12.80,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18585,18585,'Cursed Girl',0,'',0,'LineageMonster4.cursed_housemaid',8.00,17.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18586,18586,'Gardener',0,'',0,'LineageMonster4.gardener',17.00,26.80,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18587,18587,'Begrudged Maid',0,'',0,'LineageMonster4.head_parlour_maid',25.00,32.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18588,18588,'Hunting Ground Keeper',0,'',0,'LineageMonster4.employee_of_baroness',15.00,28.70,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18589,18589,'Cursed Gardener',0,'',0,'LineageMonster4.gardener',17.00,26.80,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18590,18590,'Baroness\' Employee',0,'',0,'LineageMonster4.employee_of_baroness',15.00,28.70,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18591,18591,'Begrudged Boy',0,'',0,'LineageMonster4.cursed_errand_boy',8.00,12.80,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18592,18592,'Kratei\'s Steward',0,'',0,'LineageMonster4.chief_steward',18.00,31.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18593,18593,'Housekeeper',0,'',0,'LineageMonster4.mad_laundry_maid',9.00,21.60,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18594,18594,'Mansion Guide',0,'',0,'LineageMonster4.mad_laundry_maid',9.00,21.60,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18595,18595,'Baroness\' Employee',0,'',0,'LineageMonster4.employee_of_baroness',15.00,28.70,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18596,18596,'Cursed Gardener',0,'',0,'LineageMonster4.gardener',17.00,26.80,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18597,18597,'Begrudged Maid',0,'',0,'LineageMonster4.head_parlour_maid',25.00,32.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18598,18598,'Cursed Head Maid',0,'',0,'LineageMonster4.head_parlour_maid',25.00,32.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18599,18599,'Mansion Manager',0,'',0,'LineageMonster4.steward',21.00,25.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18600,18600,'Kratei\'s Steward',0,'',0,'LineageMonster4.chief_steward',18.00,31.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18601,18601,'Kratei\'s Watcher',0,'',0,'LineageNpcEV.trap_ironcastle_150p_a',18.00,32.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18602,18602,'Kratei\'s Watcher',0,'',0,'LineageNpcEV.trap_ironcastle_150p',18.00,32.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18603,18603,'',0,'',0,'LineageNPC.clear_npc',8.00,24.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18604,18604,'',0,'',0,'LineageNPC.clear_npc',8.00,24.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18605,18605,'',0,'',0,'LineageNPC.clear_npc',8.00,24.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18606,18606,'',0,'',0,'LineageNPC.clear_npc',8.00,24.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18607,18607,'Gargos',0,'Spirit of Fire',0,'LineageMonster.vale_master',12.00,40.00,39,'male','L2Monster',40,41343,430,0.00,0.00,40,43,30,21,20,20,11225,714,253,170,87,138,253,0,333,0,0,NULL,0,70,155,0,0,'LAST_HIT','false'),
(18608,18608,'Kinsus',0,'Spirit of Fire',0,'LineageMonster4.Anthias',20.00,41.00,39,'male','L2Monster',40,25740,430,0.00,0.00,40,43,30,21,20,20,11225,714,253,170,87,138,253,0,333,0,0,NULL,0,60,180,0,0,'LAST_HIT','false'),
(18609,18609,'Papion',0,'Spirit of Water',0,'LineageMonster4.Anthias',20.00,41.00,36,'male','L2Monster',40,16610,382,0.00,0.00,40,43,30,21,20,20,10783,652,205,152,70,124,253,0,333,0,0,NULL,0,60,180,0,0,'LAST_HIT','false'),
(18610,18610,'Hillas',0,'Spirit of Water',0,'LineageMonster.sylph_100_bi',20.00,70.00,36,'female','L2Monster',40,19187,382,0.00,0.00,40,43,30,21,20,20,10783,652,205,152,70,124,253,0,333,0,0,NULL,0,60,140,0,0,'LAST_HIT','false'),
(18611,18611,'Spirit of Water',0,'',0,'LineageMonster.undine',12.00,27.00,33,'female','L2Monster',40,1109,414,0.00,0.00,40,43,30,21,20,20,631,22,165,158,78,128,253,0,333,0,0,NULL,0,60,100,0,0,'LAST_HIT','false'),
(18612,18612,'Spirit of Water',0,'',0,'LineageMonster.sylph',11.00,35.00,36,'female','L2Monster',40,1109,414,0.00,0.00,40,43,30,21,20,20,631,22,165,158,78,128,253,0,333,0,0,NULL,0,60,100,0,0,'LAST_HIT','false'),
(18613,18613,'Spirit of Water',0,'',0,'LineageMonster.sylph_110p',12.00,39.70,39,'female','L2Monster',40,1463,514,0.00,0.00,40,43,30,21,20,20,852,35,253,195,119,159,253,0,333,0,0,NULL,0,60,100,0,0,'LAST_HIT','false'),
(18614,18614,'Spirit of Fire',0,'',0,'LineageMonster.skeleton_knight',10.00,25.00,36,'male','L2Monster',40,1279,464,0.00,0.00,40,43,30,21,20,20,726,28,205,176,93,143,253,0,333,150,103,NULL,0,40,160,0,0,'LAST_HIT','false'),
(18615,18615,'Spirit of Fire',0,'',0,'LineageMonster.dre_vanul',14.00,36.00,39,'male','L2Monster',40,1463,514,0.00,0.00,40,43,30,21,20,20,852,35,253,195,119,159,253,0,333,0,0,NULL,0,80,80,0,0,'LAST_HIT','false'),
(18616,18616,'Bloom',0,'',0,'LineageMonster.magical_weaver',11.00,20.00,36,'male','L2Monster',40,1279,464,0.00,0.00,40,43,30,21,20,20,726,28,205,176,93,143,253,0,333,0,0,NULL,0,90,90,0,0,'LAST_HIT','false'),
(18617,18617,'',0,'',0,'LineageNPC.clear_npc',8.00,24.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18618,18618,'',0,'',0,'LineageNPC.clear_npc',8.00,24.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18619,18619,'',0,'',0,'LineageNPC.clear_npc',8.00,24.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18620,18620,'Adiantum',0,'',0,'LineageMonster.onyx_beast',14.00,14.50,42,'male','L2Monster',40,43410,480,0.00,0.00,40,43,30,21,20,20,91640,4070,309,189,104,154,253,0,333,0,0,NULL,0,30,120,0,0,'LAST_HIT','false'),
(18621,18621,'',0,'',0,'LineageNPC.clear_npc',8.00,24.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18622,18622,'Powder Keg',0,'',0,'LineageNPCEV.gunpowder',80.00,60.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18623,18623,'Begrudged Archer',0,'',0,'LineageMonster.skeleton_archer_20_bi',13.00,32.50,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18624,18624,'Deadman\'s Grudge',0,'',0,'LineageMonster.unpleasant_humming',12.00,26.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18625,18625,'Deadman\'s Grudge',0,'',0,'LineageMonster.skeleton_knight',10.00,25.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18626,18626,'Deadman\'s Grudge',0,'',0,'LineageMonster.skeleton_royal_guard',11.00,28.50,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18627,18627,'Deadman\'s Grudge',0,'',0,'LineageMonster.skeleton_royal_guard',11.00,28.50,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18628,18628,'Atan',0,'Lookout',0,'LineageMonster.pirates_zombie',10.00,23.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18629,18629,'Kams',0,'Panuka',0,'LineageMonster.skeleton_knight_50_bi',15.00,39.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18630,18630,'Hikoro',0,'Panuka',0,'LineageMonster.rakul',30.00,39.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18631,18631,'Alkaso',0,'Panuka',0,'LineageMonster.pirates_zombie_captain_20_bi',20.00,35.59,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18632,18632,'Gerbera',0,'Panuka',0,'LineageMonster2.imperial_warlord_zombie_20_bi',9.00,36.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18633,18633,'Lematan',0,'',0,'LineageMonster4.cursed_pirate',24.00,37.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18634,18634,'Lematan\'s Follower',0,'',0,'LineageMonster.pirates_zombie',10.00,23.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18635,18635,'Varka Silenos Recruit',0,'',0,'LineageMonster2.barka_silenos_hunter',16.00,38.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18636,18636,'Varka Silenos Footman',0,'',0,'LineageMonster2.barka_silenos_warrior',16.00,41.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18637,18637,'Grazing Antelope',0,'',0,'LineageMonster2.antelope',17.00,34.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18638,18638,'Varka Silenos Scout',0,'',0,'LineageMonster2.barka_silenos_hunter',16.00,38.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18639,18639,'Varka Silenos Hunter',0,'',0,'LineageMonster2.barka_silenos_archer',8.00,37.50,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18640,18640,'Varka Silenos Shaman',0,'',0,'LineageMonster2.barka_silenos_shaman',14.00,39.50,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18641,18641,'Varka Silenos Priest',0,'',0,'LineageMonster2.barka_silenos_priest',9.00,41.50,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18642,18642,'Varka Silenos Warrior',0,'',0,'LineageMonster2.barka_silenos_warrior',16.00,41.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18643,18643,'Grazing Antelope',0,'',0,'LineageMonster2.antelope',17.00,34.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18644,18644,'Varka Silenos Medium',0,'',0,'LineageMonster2.barka_silenos_shaman',14.00,39.50,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18645,18645,'Varka Silenos Magus',0,'',0,'LineageMonster2.barka_silenos_mage_20_bi',11.00,55.20,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18646,18646,'Varka Silenos Officer',0,'',0,'LineageMonster2.barka_silenos_chieftain',18.00,42.50,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18647,18647,'Grazing Flava',0,'',0,'LineageMonster2.flava',18.00,34.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18648,18648,'Varka Silenos Seer',0,'',0,'LineageMonster2.barka_silenos_shaman',14.00,39.50,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18649,18649,'Varka Silenos Great Magus',0,'',0,'LineageMonster2.barka_silenos_warrior_20_bi',20.00,49.20,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18650,18650,'Varka Silenos General',0,'',0,'LineageMonster2.barka_silenos_chieftain',18.00,42.50,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18651,18651,'Grazing Elder Antelope',0,'',0,'LineageMonster2.antelope',17.00,34.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18652,18652,'Varka Silenos Great Seer',0,'',0,'LineageMonster2.barka_silenos_shaman',14.00,39.50,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18653,18653,'Varka\'s Elite Guard',0,'',0,'LineageMonster2.barka_silenos_warrior',16.00,41.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18654,18654,'Varka\'s Commander',0,'',0,'LineageMonster2.barka_silenos_chieftain_20_bi',22.00,51.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18655,18655,'Varka\'s Head Guard',0,'',0,'LineageMonster2.barka_silenos_warrior',16.00,41.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18656,18656,'Varka\'s Head Magus',0,'',0,'LineageMonster2.barka_silenos_shaman',14.00,39.50,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18657,18657,'Prophet Guard',0,'',0,'LineageMonster2.barka_silenos_warrior',16.00,41.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18658,18658,'Disciple of Prophet',0,'',0,'LineageMonster2.barka_silenos_priest',9.00,41.50,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18659,18659,'Varka\'s Prophet',0,'',0,'LineageMonster2.barka_silenos_shaman_20_bi',17.00,47.50,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18660,18660,'Latana',0,'',0,'LineageMonster4.wounded_dragon',60.00,60.00,85,'male','L2Monster',40,1785000,22197,285.00,26.32,60,57,73,76,70,80,2842864,27215,14375,2999,36620,1999,333,800,3819,0,0,0,0,0,0,0,14,'LAST_HIT','false'),
(18661,18661,'',0,'',0,'LineageNPC.clear_npc',8.00,24.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18662,18662,'',0,'',0,'LineageNPC.clear_npc',8.00,24.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18663,18663,'',0,'',0,'LineageNPC.clear_npc',8.00,24.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18664,18664,'Fortune Bug',0,'',0,'LineageMonster4.jackpot_bug',16.00,22.50,52,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18665,18665,'Fortune Bug',0,'',0,'LineageMonster4.jackpot_bug',16.00,22.50,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18666,18666,'Fortune Bug',0,'',0,'LineageMonster4.jackpot_bug',16.00,22.50,75,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18667,18667,'Ward of Death',0,'',0,'LineageNpcEV.trap_immortality',24.00,48.50,83,'male','L2Monster',40,6060,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18668,18668,'Ward of Death',0,'',0,'LineageNpcEV.trap_immortality',8.00,48.50,83,'male','L2Monster',40,6060,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18669,18669,'',0,'',0,'LineageNPC.clear_npc',0.10,0.10,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,1,1,0,0,'LAST_HIT','false'),
(18670,18670,'',0,'',0,'LineageNPC.clear_npc',8.00,24.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18671,18671,'Block',0,'',0,'LineageNPC2.block',16.00,17.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18672,18672,'Block',0,'',0,'LineageNPC2.block',16.00,17.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18673,18673,'Block',0,'',0,'LineageNPC2.block',16.00,17.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18674,18674,'Block',0,'',0,'LineageNPC2.block',16.00,17.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18675,18675,'Block',0,'',0,'LineageNPC2.block',16.00,17.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18676,18676,'Block-Carrying Girl',0,'',0,'LineageNPC2.block_mother',12.00,31.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18677,18677,'Dragon Steed Troop Messenger',0,'',0,'LineageMonster4.dragon_peltast',25.00,46.50,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18678,18678,'Energy Seed - Water',0,'',0,'LineageNPC.seed_click_dummy_water',10.00,10.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18679,18679,'Energy Seed - Fire',0,'',0,'LineageNPC.seed_click_dummy_fire',10.00,10.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18680,18680,'Energy Seed - Wind',0,'',0,'LineageNPC.seed_click_dummy_wind',10.00,10.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18681,18681,'Energy Seed - Earth',0,'',0,'LineageNPC.seed_click_dummy_earth',10.00,10.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18682,18682,'Energy Seed - Divinity',0,'',0,'LineageNPC.seed_click_dummy_holy',10.00,10.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18683,18683,'Energy Seed - Darkness',0,'',0,'LineageNPC.seed_click_dummy_dark',10.00,10.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18684,18684,'Red Star Stone',0,'',0,'LineageNpcEV.star_stone_a',54.00,61.00,70,'male','L2FlyNpc',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,1,1,0,0,'LAST_HIT','false'),
(18685,18685,'Red Star Stone',0,'',0,'LineageNpcEV.star_stone_b',38.00,43.50,70,'male','L2FlyNpc',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,1,1,0,0,'LAST_HIT','false'),
(18686,18686,'Red Star Stone',0,'',0,'LineageNpcEV.star_stone_c',38.00,30.50,70,'male','L2FlyNpc',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,1,1,0,0,'LAST_HIT','false'),
(18687,18687,'Blue Star Stone',0,'',0,'LineageNpcEV.star_stone_a',54.00,61.00,70,'male','L2FlyNpc',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,1,1,0,0,'LAST_HIT','false'),
(18688,18688,'Blue Star Stone',0,'',0,'LineageNpcEV.star_stone_b',38.00,43.50,70,'male','L2FlyNpc',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,1,1,0,0,'LAST_HIT','false'),
(18689,18689,'Blue Star Stone',0,'',0,'LineageNpcEV.star_stone_c',38.00,30.50,70,'male','L2FlyNpc',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,1,1,0,0,'LAST_HIT','false'),
(18690,18690,'Green Star Stone',0,'',0,'LineageNpcEV.star_stone_a',54.00,61.00,70,'male','L2FlyNpc',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,1,1,0,0,'LAST_HIT','false'),
(18691,18691,'Green Star Stone',0,'',0,'LineageNpcEV.star_stone_b',38.00,43.50,70,'male','L2FlyNpc',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,1,1,0,0,'LAST_HIT','false'),
(18692,18692,'Green Star Stone',0,'',0,'LineageNpcEV.star_stone_c',38.00,30.50,70,'male','L2FlyNpc',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,1,1,0,0,'LAST_HIT','false'),
(18693,18693,'Treasure Box of the Ancient Giants',0,'',0,'LineageMonster.mimic',8.50,8.50,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18694,18694,'Treasure Box Guard',0,'',0,'LineageMonster2.magmagoil_lad_20_sm',12.00,60.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18695,18695,'Treasure Box Guard',0,'',0,'LineageMonster2.magmagoil_20_sm',12.00,60.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18696,18696,'Dimension Moving Device',0,'',0,'LineageNpcEV.teleport_gate_of_legion',44.50,7.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18697,18697,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18698,18698,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18699,18699,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18700,18700,'',0,'',0,'LineageNpc2.trap_mark',8.00,24.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18701,18701,'',0,'',0,'LineageNpc2.trap_mark',8.00,24.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18702,18702,'Dimension Moving Device',0,'',0,'LineageNpcEV.teleport_gate_of_legion',44.50,7.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18703,18703,'Defeated Troops Controller',0,'',0,'LineageNpcEV.crystal_of_secret_door',57.00,74.00,85,'male','L2Monster',40,88121,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18704,18704,'Tumor of Death',0,'',0,'LineageNpcEV.tumor_immortality',42.00,55.00,80,'male','L2Monster',40,268352,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18705,18705,'Destroyed Tumor',0,'',0,'LineageNpcEV.tumor_immortality_a',42.00,55.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18706,18706,'Soul Coffin',0,'',0,'LineageNpcEV.vein_immortality',0.01,6.00,80,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18707,18707,'',0,'',0,'LineageNPC.clear_npc',8.00,24.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18708,18708,'Tumor of Death',0,'',0,'LineageNpcEV.tumor_immortality',42.00,55.00,85,'male','L2Monster',40,175243,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,0,0,333,0,0,NULL,0,0,0,0,0,'LAST_HIT','false'),
(18709,18709,'Soul Coffin',0,'',0,'LineageNpcEV.vein_immortality_080p',0.10,6.10,80,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18710,18710,'Soul Coffin',0,'',0,'LineageNpcEV.vein_immortality',0.10,6.00,80,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18711,18711,'Soul Coffin',0,'',0,'LineageNpcEV.vein_immortality_120p',0.10,8.50,80,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18712,18712,'Soul Coffin',0,'',0,'LineageNpcEV.vein_immortality_080p',0.10,6.10,80,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18713,18713,'Soul Coffin',0,'',0,'LineageNpcEV.vein_immortality',0.10,6.00,80,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18714,18714,'Soul Coffin',0,'',0,'LineageNpcEV.vein_immortality_120p',0.10,8.50,80,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18715,18715,'Conquered Soul',0,'',0,'LineageMonster4.death_knight_n_104p',22.88,41.60,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18716,18716,'Conquered Soul',0,'',0,'LineageMonster4.Death_slayer_080p',16.00,27.20,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18717,18717,'Conquered Soul',0,'',0,'LineageMonster4.lich_b_088p',21.12,40.48,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18718,18718,'Sacrificed Fanatic',0,'',0,'LineageMonster4.ravager_silen_dead',27.00,48.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18719,18719,'Sacrificed Fanatic',0,'',0,'LineageMonster4.disciple_silen_dead',19.00,44.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18720,18720,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18721,18721,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18722,18722,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18723,18723,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18724,18724,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18725,18725,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18726,18726,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18727,18727,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18728,18728,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18729,18729,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18730,18730,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18731,18731,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18732,18732,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18733,18733,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18734,18734,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18735,18735,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18736,18736,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18737,18737,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18738,18738,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18739,18739,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18740,18740,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18741,18741,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18742,18742,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18743,18743,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18744,18744,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18745,18745,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18746,18746,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18747,18747,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18748,18748,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18749,18749,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18750,18750,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18751,18751,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18752,18752,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18753,18753,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18754,18754,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18755,18755,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18756,18756,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18757,18757,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18758,18758,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18759,18759,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18760,18760,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18761,18761,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18762,18762,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18763,18763,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18764,18764,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18765,18765,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18766,18766,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18767,18767,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18768,18768,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18769,18769,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18770,18770,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18771,18771,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18772,18772,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18773,18773,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18774,18774,'Trap',0,'',0,'LineageNpc2.trap_mark',5.00,10.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18775,18775,'Seed of Destruction Control Device',0,'',0,'LineageNpcEV.crystal_of_secret_door',57.00,74.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18776,18776,'Obelisk',0,'',0,'LineageNpcEV.obelisk_of_middle_square',229.00,177.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18777,18777,'Great Powerful Device',0,'',0,'LineageNpcEV.crystal_of_secret_door',57.00,74.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18778,18778,'Throne of Destruction Powerful Device',0,'',0,'LineageNpcEV.protector_of_seed',57.00,74.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18779,18779,'',0,'',0,'LineageNPC.clear_npc',0.10,0.10,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,1,1,0,0,'LAST_HIT','false'),
(18780,18780,'Symbol of Cohemenes',0,'',0,'LineageNpcEV.trap_immortality',24.00,48.50,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18781,18781,'Young Drake Wing',0,'',0,'LineageMonster4.m_drake_wing_knave',153.00,63.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18782,18782,'Zealot of Shilen',0,'',0,'LineageMonster4.disciple_silen',19.00,44.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,73,170,0,0,'LAST_HIT','false'),
(18783,18783,'Defeated Troops Commander',0,'',0,'LineageMonster4.Dragon_centurion_135p',28.00,46.50,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18784,18784,'Defeated Troops No 1 Battalion Commander',0,'',0,'LineageMonster4.Dragon_centurion_135p',28.00,46.50,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18785,18785,'Defeated Troops White Dragon Leader',0,'',0,'LineageMonster4.Dragon_centurion_120p',22.00,42.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18786,18786,'Defeated Troops Infantry',0,'',0,'LineageMonster4.Dragon_centurion_120p',22.00,42.00,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18787,18787,'Defeated Troops Magic Leader',0,'',0,'LineageMonster4.dragon_mage_075p',28.00,39.50,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18788,18788,'Defeated Troops Magician',0,'',0,'LineageMonster4.dragon_mage_075p',28.00,39.50,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18789,18789,'Defeated Troops Magic Soldier',0,'',0,'LineageMonster4.dragon_mage_065p',25.00,34.50,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18790,18790,'Defeated Troops Healer',0,'',0,'LineageMonster4.dragon_mage_065p',25.00,34.50,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18791,18791,'Defeated Troops Javelin Thrower',0,'',0,'LineageMonster4.dragon_peltast',25.00,46.50,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18792,18792,'Defeated Troops Javelin Thrower',0,'',0,'LineageMonster4.dragon_peltast',25.00,46.50,70,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,278,0,333,0,0,NULL,0,60,60,0,0,'LAST_HIT','false'),
(18793,18793,'Bizarre Cocoon',0,'',0,'LineageNpcEV.n_event_stakato_egg_a',24.00,27.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18794,18794,'Bizarre Cocoon',0,'',0,'LineageNpcEV.n_event_stakato_egg_b',35.00,27.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18795,18795,'Bizarre Cocoon',0,'',0,'LineageNpcEV.n_event_stakato_egg_c',48.00,27.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18796,18796,'Bizarre Cocoon',0,'',0,'LineageNpcEV.n_event_stakato_egg_d',24.00,27.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18797,18797,'Bizarre Cocoon',0,'',0,'LineageNpcEV.n_event_stakato_egg_e',35.00,27.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18798,18798,'Bizarre Cocoon',0,'',0,'LineageNpcEV.n_event_stakato_egg_f',48.00,27.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18799,18799,'Newborn Lavasaurus',0,'',0,'LineageMonster2.magmagoil_20_sm',12.00,60.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18800,18800,'Fledgling Lavasaurus',0,'',0,'LineageMonster2.magmagoil',15.00,75.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18801,18801,'Adult Lavasaurus',0,'',0,'LineageMonster2.magmagoil_lad_20_sm',12.00,60.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18802,18802,'Elderly Lavasaurus',0,'',0,'LineageMonster2.magmagoil_lad',15.00,75.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18803,18803,'Ancient Lavasaurus',0,'',0,'LineageMonster2.magmagoil_lad',15.00,75.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18804,18804,'Tar Beetle',0,'',0,'LineageMonster2.scarab_20_sm_e',18.00,26.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18805,18805,'Waste Landfill Machine',0,'',0,'LineageNpcEV.riding_control_unit_c',19.00,28.00,83,'male','L2Monster',40,4639,1812,0.00,0.00,40,43,30,21,20,20,0,0,1303,671,607,482,253,0,333,0,0,0,0,1,1,0,0,'LAST_HIT','false'),
(18806,18806,'Brazier of Purity',0,'',0,'LineageNpcEV.warp_gate_a',16.00,31.00,83,'male','L2Monster',40,4639,1812,0.00,0.00,40,43,30,21,20,20,0,0,1303,671,607,482,253,0,333,0,0,0,0,1,1,0,0,'LAST_HIT','false'),
(18807,18807,'Frightened Ragna Orc',0,'',0,'LineageMonster.batur_orc_03te',9.00,21.50,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18808,18808,'Dark Shaman Varangka',0,'',0,'LineageMonster2.ketra_orc_chieftain_20_bi_e',17.00,46.20,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18809,18809,'Varangka\'s Retainer',0,'',0,'LineageMonster.batur_orc_overlord_03te_120p',12.00,28.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18810,18810,'Varangka\'s Page',0,'',0,'LineageMonster.batur_orc_shaman_a_01te_120p_e',11.00,21.50,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18811,18811,'Guardian of the Altar',0,'',0,'LineageMonster2.parasitic_eye_050p_e',17.00,29.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18812,18812,'Kasha\'s Eye',0,'',0,'LineageMonster2.parasitic_eye_050p_e_r',17.00,29.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18813,18813,'Kasha\'s Eye',0,'',0,'LineageMonster2.parasitic_eye_050p_e_g',17.00,29.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18814,18814,'Kasha\'s Eye',0,'',0,'LineageMonster2.parasitic_eye_050p_e_b',17.00,29.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18815,18815,'Guard of the Grave',0,'Death-calling',0,'LineageMonster2.magmagoil_20_sm',12.00,60.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18816,18816,'Chieftain\'s Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18817,18817,'Invader Martyr of Nightmare',0,'',0,'LineageMonster.doll_master',20.00,42.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18818,18818,'Nihil Invader Martyr',0,'',0,'LineageMonster5.scapegoat',20.00,32.50,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18819,18819,'Nihil Invader Treasure Chest',0,'',0,'LineageMonster5.bounded_mimic',11.00,8.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18820,18820,'Nihil Invader Treasure Chest',0,'',0,'LineageMonster5.bounded_mimic',11.00,8.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18821,18821,'Mutant Martyr',0,'',0,'LineageMonster5.doll_claw',28.00,50.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18822,18822,'Mutant Treasure Chest',0,'',0,'LineageMonster5.bounded_mimic',11.00,8.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18823,18823,'Mutant Treasure Chest',0,'',0,'LineageMonster5.bounded_mimic',11.00,8.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18824,18824,'Merchant of Mammon A',0,'',0,'LineageNPC.a_warehouse_keeper_MDwarf',8.00,17.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18825,18825,'Merchant of Mammon B',0,'',0,'LineageNPC.e_guard_MDwarf',8.00,19.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18826,18826,'Shilen\'s Evil Thoughts For Presentation',0,'',0,'LineageMonster5.vicious_mind_of_silen',14.00,27.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18827,18827,'Priest Cain for Presentation',0,'',0,'LineageNPC.a_sanctuary_teacher_MHuman',8.00,23.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18828,18828,'High Priest of Dawn',0,'',0,'LineageNPC2.high_priest_of_dawn',10.00,22.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18829,18829,'Shilen\'s Evil Thoughts Leader For Presentation',0,'',0,'LineageMonster5.leader_mind_of_silen',27.00,40.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18830,18830,'ssq For Presentation Camera Dummy 1',0,'',0,'LineageNPC.camera_target_dummy',11.00,25.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18831,18831,'ssq For Presentation Camera Dummy 2',0,'',0,'LineageNPC.camera_target_dummy',11.00,25.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18832,18832,'ssq For Presentation Camera Dummy 3',0,'',0,'LineageNPC.camera_target_dummy',11.00,25.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18833,18833,'Emperor\'s Seal Device',0,'',0,'LineageNPCEV.ssq_sealing_emperor',16.00,24.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18834,18834,'Guards of the Dawn',0,'',0,'LineageNPC.a_fighterguild_master_Mhuman',8.00,23.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18835,18835,'Guards of the Dawn',0,'',0,'LineageNPC.a_mageguild_master_MHuman',8.00,24.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18836,18836,'Varangka\'s Guardian',0,'',0,'LineageMonster2.ahrimanes_70p',14.00,39.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18837,18837,'',0,'',0,'LineageNPC.camera_target_dummy_a',15.00,25.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(18838,18838,'Treasure Chest of Invader Soldier of Nightmare',0,'',0,'LineageMonster5.bounded_mimic',11.00,8.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false');

INSERT INTO `npc` VALUES
(20001,20001,'Gremlin',0,'',0,'LineageMonster.gremlin',10.00,15.00,1,'male','L2Monster',40,62,44,3.16,0.91,40,43,30,21,20,10,29,2,9,39,3,32,278,0,333,0,0,0,0,22,90,0,0,'LAST_HIT','false'),
(20002,20002,'Rabbit',0,'',0,'LineageMonster.rabbit',5.00,4.50,1,'male','L2Monster',40,62,44,3.16,0.91,40,43,30,21,20,10,29,2,9,39,3,32,278,0,333,0,0,0,0,55,88,0,0,'LAST_HIT','false'),
(20003,20003,'Goblin',0,'',0,'LineageMonster.goblin',10.00,16.50,5,'male','L2Monster',40,126,77,3.16,0.91,40,43,30,21,20,10,178,5,13,48,4,39,278,0,333,4,0,0,0,40,110,0,0,'LAST_HIT','true'),
(20004,20004,'Imp',0,'',0,'LineageMonster.imp',10.00,24.00,6,'male','L2Monster',40,147,85,3.16,0.91,40,43,30,21,20,10,213,6,15,50,5,41,278,0,333,0,0,0,0,60,80,0,0,'LAST_HIT','true'),
(20005,20005,'Imp Elder',0,'',0,'LineageMonster.imp',10.00,24.00,7,'male','L2Monster',40,171,94,3.16,0.91,40,43,30,21,20,10,249,8,18,48,6,43,278,0,333,0,0,0,0,60,80,0,0,'LAST_HIT','true'),
(20006,20006,'Orc Archer',0,'',0,'LineageMonster.orc_archer',14.00,25.00,8,'male','L2Monster',500,197,102,3.16,0.91,40,43,30,21,20,10,293,10,41,55,6,45,249,0,333,14,0,0,0,49,121,0,0,'LAST_HIT','true'),
(20007,20007,'Green Fungus',0,'',0,'LineageMonster.walking_fungus',15.00,22.50,9,'male','L2Monster',40,226,111,3.16,0.91,40,43,30,21,20,10,321,11,22,53,7,47,278,0,333,0,0,0,0,70,110,0,0,'LAST_HIT','true'),
(20008,20008,'Felim Lizardman',0,'',0,'LineageMonster.virud_lizardman',10.00,23.00,14,'male','L2Monster',40,364,156,3.95,1.21,40,43,30,21,20,10,498,19,30,80,12,59,278,0,333,1,0,0,0,47,143,0,0,'LAST_HIT','true'),
(20009,20009,'Vuku Orc',0,'',0,'LineageMonster.orc',10.00,21.00,14,'male','L2Monster',40,364,156,3.95,1.21,40,43,30,21,20,10,498,19,33,73,12,59,278,0,333,156,0,0,0,49,121,0,0,'LAST_HIT','true'),
(20010,20010,'Felim Lizardman Scout',0,'',0,'LineageMonster.virud_lizardman',10.00,23.00,15,'male','L2Monster',40,390,165,3.95,1.21,40,43,30,21,20,10,534,22,40,69,14,62,278,0,333,16,0,0,0,47,143,0,0,'LAST_HIT','true'),
(20011,20011,'Vuku Orc Archer',0,'',0,'LineageMonster.orc_archer',14.00,25.00,15,'male','L2Monster',500,390,165,3.95,1.21,40,43,30,21,20,10,550,22,82,76,14,62,249,0,333,14,0,0,0,49,121,0,0,'LAST_HIT','true'),
(20012,20012,'Gora Werewolf',0,'',0,'LineageMonster.werewolf',10.00,26.00,16,'male','L2Monster',40,417,174,3.95,1.21,40,43,30,21,20,10,582,23,44,72,15,64,278,500,333,0,0,0,0,55,132,0,0,'LAST_HIT','true'),
(20013,20013,'Dryad',0,'',0,'LineageMonster.dryad',9.00,20.00,13,'female','L2Monster',40,339,147,3.95,1.21,40,43,30,21,20,10,462,18,27,77,11,56,278,0,333,0,0,0,0,44,121,0,0,'LAST_HIT','true'),
(20014,20014,'Felim Lizardman Warrior',0,'',0,'LineageMonster.virud_lizardman_warrior',12.00,30.00,17,'male','L2Monster',40,446,184,3.95,1.21,40,43,30,21,20,10,605,25,48,75,17,67,278,0,333,16,0,0,0,57,143,0,0,'LAST_HIT','true'),
(20015,20015,'Marsh Zombie',0,'',0,'LineageMonster.zombie',13.00,21.00,13,'male','L2Monster',40,339,147,3.95,1.21,40,43,30,21,20,10,654,26,33,63,11,56,278,0,333,0,0,0,0,15,15,1,0,'LAST_HIT','true'),
(20016,20016,'Stone Golem',0,'',0,'LineageMonster.stone_golem',20.00,31.00,13,'male','L2Monster',40,339,147,3.95,1.21,40,43,30,21,20,10,654,26,30,70,11,56,278,0,333,0,0,0,0,25,25,0,0,'LAST_HIT','true'),
(20017,20017,'Vuku Orc Fighter',0,'',0,'LineageMonster.orc_fighter',12.00,22.00,17,'male','L2Monster',40,446,184,3.95,1.21,40,43,30,21,20,10,618,26,48,75,17,67,278,500,333,2,0,0,0,45,110,0,0,'LAST_HIT','true'),
(20018,20018,'Carnivorous Fungus',0,'',0,'LineageMonster.walking_fungus',15.00,22.50,14,'male','L2Monster',40,364,156,3.95,1.21,40,43,30,21,20,10,424,16,37,66,12,59,278,500,333,0,0,0,0,77,121,0,0,'LAST_HIT','false'),
(20019,20019,'Dryad Elder',0,'',0,'LineageMonster.dryad',9.00,20.00,14,'female','L2Monster',40,364,156,3.95,1.21,40,43,30,21,20,10,498,19,30,80,12,59,278,0,333,0,0,0,0,44,121,0,0,'LAST_HIT','true'),
(20020,20020,'Marsh Zombie Lord',0,'',0,'LineageMonster.zombie',13.00,21.00,14,'male','L2Monster',40,364,156,3.95,1.21,40,43,30,21,20,10,705,27,30,80,12,59,278,0,333,0,0,0,0,15,15,1,0,'LAST_HIT','true'),
(20021,20021,'Red Bear',0,'',0,'LineageMonster.grizzly',21.00,40.00,14,'male','L2Monster',40,364,156,3.95,1.21,40,43,30,21,20,10,498,19,37,66,12,59,278,0,333,0,0,0,0,44,121,0,0,'LAST_HIT','true'),
(20022,20022,'Misery Skeleton',0,'',0,'LineageMonster.skeleton',11.00,25.00,14,'male','L2Monster',40,364,156,3.95,1.21,40,43,30,21,20,10,424,16,32,66,12,59,317,500,333,946,945,0,0,60,140,1,0,'LAST_HIT','false'),
(20023,20023,'Shadow Beast',0,'',0,'LineageMonster.onyx_beast',14.00,14.50,15,'male','L2Monster',40,390,165,3.95,1.21,40,43,30,21,20,10,534,22,40,69,14,62,278,0,333,0,0,0,0,33,132,0,0,'LAST_HIT','true'),
(20024,20024,'Langk Lizardman Warrior',0,'',0,'LineageMonster.virud_lizardman_warrior',12.00,30.00,17,'male','L2Monster',40,446,184,3.95,1.21,40,43,30,21,20,10,618,26,48,75,17,67,278,500,333,16,0,0,0,57,143,0,0,'LAST_HIT','true'),
(20025,20025,'Lesser Dark Horror',0,'',0,'LineageMonster.dark_horror',20.00,35.00,15,'male','L2Monster',40,390,165,3.95,1.21,40,43,30,21,20,10,545,22,36,76,14,62,278,500,333,0,0,0,0,100,100,1,0,'LAST_HIT','true'),
(20026,20026,'Ruin Zombie',0,'',0,'LineageMonster.zombie',13.00,21.00,15,'male','L2Monster',40,390,165,3.95,1.21,40,43,30,21,20,10,755,31,40,69,14,62,278,0,333,0,0,0,0,16,16,1,0,'LAST_HIT','true'),
(20027,20027,'Langk Lizardman Scout',0,'',0,'LineageMonster.virud_lizardman',10.00,23.00,16,'male','L2Monster',40,417,174,3.95,1.21,40,43,30,21,20,10,570,23,44,72,15,64,278,0,333,16,0,0,0,47,143,0,0,'LAST_HIT','true'),
(20028,20028,'Pincher',0,'',0,'LineageMonster.giant_spider',26.00,25.50,16,'male','L2Monster',40,417,174,3.95,1.21,40,43,30,21,20,10,570,23,44,72,15,64,278,0,333,0,0,0,0,79,143,0,0,'LAST_HIT','true'),
(20029,20029,'Ruin Zombie Leader',0,'',0,'LineageMonster.zombie',13.00,21.00,16,'male','L2Monster',40,417,174,3.95,1.21,40,43,30,21,20,10,807,33,36,87,15,64,278,0,333,0,0,0,0,15,15,1,0,'LAST_HIT','true'),
(20030,20030,'Langk Lizardman',0,'',0,'LineageMonster.virud_lizardman',10.00,23.00,15,'male','L2Monster',40,390,165,3.95,1.21,40,43,30,21,20,10,534,22,36,76,14,62,278,0,333,1,0,0,0,43,130,0,0,'LAST_HIT','true'),
(20031,20031,'Omen Beast',0,'',0,'LineageMonster.onyx_beast',14.00,14.50,17,'male','L2Monster',40,446,184,3.95,1.21,40,43,30,21,20,10,504,21,48,75,17,67,278,0,333,0,0,0,0,30,120,0,0,'LAST_HIT','false'),
(20032,20032,'Pinrul',0,'',0,'LineageMonster.giant_spider',26.00,25.50,17,'male','L2Monster',40,446,184,3.95,1.21,40,43,30,21,20,10,605,25,48,75,17,67,278,0,333,0,0,0,0,79,143,0,0,'LAST_HIT','true'),
(20033,20033,'Shade Horror',0,'',0,'LineageMonster.dark_horror',20.00,35.00,17,'male','L2Monster',40,446,184,3.95,1.21,40,43,30,21,20,10,504,21,48,75,17,67,278,0,333,0,0,0,0,110,110,1,0,'LAST_HIT','false'),
(20034,20034,'Prowler',0,'',0,'LineageMonster.giant_spider',26.00,25.50,17,'male','L2Monster',40,446,184,3.95,1.21,40,43,30,21,20,10,618,26,48,75,17,67,278,500,333,0,0,0,0,79,143,0,0,'LAST_HIT','true'),
(20035,20035,'Tracker Skeleton',0,'',0,'LineageMonster.skeleton',11.00,25.00,17,'male','L2Monster',40,446,184,3.95,1.21,40,43,30,21,20,10,605,25,42,75,17,67,317,0,333,946,945,0,0,60,140,1,0,'LAST_HIT','true'),
(20036,20036,'Lirein',0,'',0,'LineageMonster.sylph',11.00,35.00,18,'female','L2Monster',40,476,193,3.95,1.21,40,43,30,21,20,10,652,28,53,79,19,70,278,500,333,0,0,0,0,66,66,0,0,'LAST_HIT','true'),
(20037,20037,'Mana Seeker',0,'',0,'LineageMonster.mana_vampire',11.00,20.00,18,'male','L2Monster',40,476,193,7.90,1.21,40,43,30,21,20,10,496,21,44,95,19,70,278,0,333,0,0,0,0,99,99,0,0,'LAST_HIT','false'),
(20038,20038,'Venomous Spider',0,'',0,'LineageMonster.poison_spider',27.00,25.50,18,'male','L2Monster',40,476,193,3.95,1.21,40,43,30,21,20,10,704,31,53,79,19,70,278,0,333,0,0,0,0,60,140,0,0,'LAST_HIT','true'),
(20039,20039,'Scavenger Wererat',0,'',0,'LineageMonster.wererat',14.00,25.00,18,'male','L2Monster',40,476,193,3.95,1.21,40,43,30,21,20,10,640,28,46,79,19,70,317,0,333,12,0,0,0,88,132,0,0,'LAST_HIT','true'),
(20040,20040,'Sukar Wererat',0,'',0,'LineageMonster.wererat',14.00,25.00,18,'male','L2Monster',40,476,193,3.95,1.21,40,43,30,21,20,10,533,23,46,79,19,70,317,0,333,216,0,0,0,88,132,0,0,'LAST_HIT','false'),
(20041,20041,'Tainted Zombie',0,'',0,'LineageMonster.zombie',13.00,21.00,18,'male','L2Monster',40,476,193,3.95,1.21,40,43,30,21,20,10,754,33,44,95,19,70,278,0,333,0,0,0,0,15,15,1,0,'LAST_HIT','false'),
(20042,20042,'Tracker Skeleton Leader',0,'',0,'LineageMonster.skeleton',11.00,25.00,18,'male','L2Monster',40,476,193,3.95,1.21,40,43,30,21,20,10,652,28,46,79,19,70,317,500,333,946,945,0,0,60,140,1,0,'LAST_HIT','true'),
(20043,20043,'Arachnid Tracker',0,'',0,'LineageMonster.poison_spider',27.00,25.50,19,'male','L2Monster',40,508,203,3.95,1.21,40,43,30,21,20,10,760,34,48,99,21,73,278,500,333,0,0,0,0,60,140,0,0,'LAST_HIT','true'),
(20044,20044,'Lirein Elder',0,'',0,'LineageMonster.sylph',11.00,35.00,19,'female','L2Monster',40,508,203,3.95,1.21,40,43,30,21,20,10,691,31,58,82,21,73,278,500,333,0,0,0,0,66,66,0,0,'LAST_HIT','true'),
(20045,20045,'Skeleton Scout',0,'',0,'LineageMonster.skeleton_archer',11.00,27.00,19,'male','L2Monster',500,508,203,3.95,1.21,40,43,30,21,20,10,698,31,107,99,21,73,247,0,333,275,0,0,0,40,140,1,0,'LAST_HIT','true'),
(20046,20046,'Stink Zombie',0,'',0,'LineageMonster.zombie',13.00,21.00,19,'male','L2Monster',40,508,203,3.95,1.21,40,43,30,21,20,10,799,36,48,99,21,73,278,0,333,0,0,0,0,15,15,1,0,'LAST_HIT','false'),
(20047,20047,'Sukar Wererat Leader',0,'',0,'LineageMonster.wererat',14.00,25.00,19,'male','L2Monster',40,508,203,3.95,1.21,40,43,30,21,20,10,576,26,42,99,21,73,317,500,333,216,0,0,0,88,132,0,0,'LAST_HIT','false'),
(20048,20048,'Lesser Succubus',0,'',0,'LineageMonster.succubus',10.00,36.00,20,'female','L2Monster',40,541,213,3.95,1.21,40,43,30,21,20,10,605,27,57,94,23,76,278,500,333,0,0,0,0,60,100,0,0,'LAST_HIT','false'),
(20049,20049,'Lycanthrope',0,'',0,'LineageMonster.werewolf',10.00,26.00,20,'male','L2Monster',40,541,213,3.95,1.21,40,43,30,21,20,10,726,32,63,86,23,76,278,500,333,0,0,0,0,55,132,0,0,'LAST_HIT','true'),
(20050,20050,'Arachnid Predator',0,'',0,'LineageMonster.poison_spider',27.00,25.50,20,'male','L2Monster',40,541,213,3.95,1.21,40,43,30,21,20,10,799,35,63,86,23,76,278,500,333,0,0,0,0,66,154,0,0,'LAST_HIT','true'),
(20051,20051,'Skeleton Bowman',0,'',0,'LineageMonster.skeleton_archer',11.00,27.00,20,'male','L2Monster',500,541,213,3.95,1.21,40,43,30,21,20,10,734,32,117,104,23,76,247,0,333,275,0,0,0,40,140,1,0,'LAST_HIT','true'),
(20052,20052,'Lesser Succubus Turen',0,'',0,'LineageMonster.succubus',10.00,36.00,21,'female','L2Monster',40,575,227,5.53,1.53,40,43,30,21,20,10,649,30,69,89,25,80,278,500,333,0,0,0,0,60,100,0,0,'LAST_HIT','false'),
(20053,20053,'Ol Mahum Patrol',0,'',0,'LineageMonster.ol_mahum_archer',14.00,25.00,21,'male','L2Monster',500,575,227,5.53,1.53,40,43,30,21,20,10,787,36,140,98,25,80,247,0,333,14,0,0,0,50,110,0,0,'LAST_HIT','true'),
(20054,20054,'Ruin Spartoi',0,'',0,'LineageMonster.spartoi',11.00,27.00,21,'male','L2Monster',40,575,227,5.53,1.53,40,43,30,21,20,10,764,35,57,108,25,80,278,0,333,73,0,0,0,60,140,1,0,'LAST_HIT','true'),
(20055,20055,'Wandering Eye',0,'',0,'LineageMonster.monster_eye',21.00,43.00,21,'male','L2Monster',40,575,227,5.53,1.53,40,43,30,21,20,10,764,35,57,108,25,80,278,0,333,0,0,0,0,90,159,0,0,'LAST_HIT','true'),
(20056,20056,'Dre Vanul Disposer',0,'',0,'LineageMonster.dre_vanul',14.00,36.00,22,'male','L2Monster',40,611,242,5.53,1.53,40,43,30,21,20,10,767,36,75,93,28,83,278,500,333,0,0,0,0,88,88,0,0,'LAST_HIT','false'),
(20057,20057,'Lesser Succubus Tilfo',0,'',0,'LineageMonster.succubus',10.00,36.00,22,'female','L2Monster',40,611,242,5.53,1.53,40,43,30,21,20,10,698,33,75,93,28,83,278,500,333,0,0,0,0,66,110,0,0,'LAST_HIT','false'),
(20058,20058,'Ol Mahum Guard',0,'',0,'LineageMonster.ol_mahum',13.50,25.00,22,'male','L2Monster',40,611,242,5.53,1.53,40,43,30,21,20,10,821,39,75,93,28,83,278,0,333,2,0,0,0,50,110,0,0,'LAST_HIT','true'),
(20059,20059,'Hungry Eye',0,'',0,'LineageMonster.monster_eye',21.00,43.00,22,'male','L2Monster',40,611,242,5.53,1.53,40,43,30,21,20,10,821,39,75,93,28,83,278,0,333,0,0,0,0,90,159,0,0,'LAST_HIT','true'),
(20060,20060,'Raging Spartoi',0,'',0,'LineageMonster.spartoi',11.00,27.00,22,'male','L2Monster',40,611,242,5.53,1.53,40,43,30,21,20,10,837,40,54,113,28,83,317,500,333,946,945,0,0,66,154,1,0,'LAST_HIT','true'),
(20061,20061,'Ol Mahum Straggler',0,'',0,'LineageMonster.ol_mahum',13.50,25.00,23,'male','L2Monster',40,648,257,5.53,1.53,40,43,30,21,20,10,895,43,75,107,31,87,278,500,333,2,0,0,0,50,110,0,0,'LAST_HIT','true'),
(20062,20062,'Tumran Bugbear',0,'',0,'LineageMonster.bugbear',17.00,35.00,23,'male','L2Monster',40,648,257,5.53,1.53,40,43,30,21,20,10,878,42,68,117,31,87,278,0,333,156,0,0,0,55,130,0,0,'LAST_HIT','true'),
(20063,20063,'Ol Mahum Shooter',0,'',0,'LineageMonster.ol_mahum_archer',14.00,25.00,24,'male','L2Monster',500,687,272,5.53,1.53,40,43,30,21,20,10,963,47,181,111,34,90,247,0,333,14,0,0,0,50,110,0,0,'LAST_HIT','true'),
(20064,20064,'Tumran Bugbear Warrior',0,'',0,'LineageMonster.bugbear',17.00,35.00,24,'male','L2Monster',40,687,272,5.53,1.53,40,43,30,21,20,10,954,47,89,101,34,90,278,500,333,88,0,0,0,60,143,0,0,'LAST_HIT','true'),
(20065,20065,'Ol Mahum Patrolman',0,'',0,'LineageMonster.ol_mahum',13.50,25.00,25,'male','L2Monster',40,728,287,5.53,1.53,40,43,30,21,20,10,826,41,80,127,37,94,278,0,333,2,0,0,0,55,121,0,0,'LAST_HIT','false'),
(20066,20066,'Ol Mahum Captain',0,'',0,'LineageMonster.ol_mahum_champion',14.00,27.00,25,'male','L2Monster',40,728,287,5.53,1.53,40,43,30,21,20,10,1052,53,97,105,37,94,278,500,333,69,0,0,0,50,110,0,0,'LAST_HIT','true'),
(20067,20067,'Monster Eye Watcher',0,'',0,'LineageMonster.monster_eye',21.00,43.00,25,'male','L2Monster',40,728,287,5.53,1.53,40,43,30,21,20,10,992,50,80,127,37,94,278,0,333,0,0,0,0,90,159,0,0,'LAST_HIT','true'),
(20068,20068,'Monster Eye Destroyer',0,'',0,'LineageMonster.monster_eye',21.00,43.00,26,'male','L2Monster',40,770,303,5.53,1.53,40,43,30,21,20,10,1078,54,87,132,41,98,278,500,333,0,0,0,0,90,159,0,0,'LAST_HIT','true'),
(20069,20069,'Selu Lizardman Scout',0,'',0,'LineageMonster.virud_lizardman',10.00,23.00,26,'male','L2Monster',40,770,303,5.53,1.53,40,43,30,21,20,10,880,44,87,132,41,98,278,0,333,16,0,0,0,47,143,0,0,'LAST_HIT','false'),
(20070,20070,'Lesser Basilisk',0,'',0,'LineageMonster.lesser_basilisk',34.00,25.00,27,'male','L2Monster',40,813,318,5.53,1.53,40,43,30,21,20,10,1124,58,114,114,45,102,278,500,333,0,0,0,0,35,131,0,0,'LAST_HIT','true'),
(20071,20071,'Selu Lizardman Warrior',0,'',0,'LineageMonster.virud_lizardman_warrior',12.00,30.00,27,'male','L2Monster',40,813,318,5.53,1.53,40,43,30,21,20,10,946,48,114,114,45,102,278,500,333,16,0,0,0,57,143,0,0,'LAST_HIT','false'),
(20072,20072,'Basilisk',0,'',0,'LineageMonster.lesser_basilisk',34.00,25.00,28,'male','L2Monster',40,859,334,5.53,1.53,40,43,30,21,20,10,1189,62,102,143,49,106,278,500,333,0,0,0,0,35,131,0,0,'LAST_HIT','true'),
(20073,20073,'Ol Mahum Legionnaire',0,'',0,'LineageMonster.ol_mahum',13.50,25.00,28,'male','L2Monster',40,859,334,5.53,1.53,40,43,30,21,20,10,981,52,113,130,49,106,278,0,333,2,0,0,0,55,121,0,0,'LAST_HIT','false'),
(20074,20074,'Androscorpio',0,'',0,'LineageMonster.onyx_beast',14.00,14.50,29,'male','L2Monster',40,906,349,5.53,1.53,40,43,30,21,20,10,1243,67,122,135,53,110,278,0,333,0,0,0,0,33,132,0,0,'LAST_HIT','true'),
(20075,20075,'Ant Larva',0,'',0,'LineageMonster.ant_larva',12.00,8.00,29,'male','L2Monster',40,906,349,5.53,1.53,40,43,30,21,20,10,1139,61,111,149,53,110,278,0,333,0,0,0,0,40,60,0,0,'LAST_HIT','false'),
(20076,20076,'Ol Mahum Commander',0,'',0,'LineageMonster.ol_mahum_champion',14.00,27.00,29,'male','L2Monster',40,906,349,5.53,1.53,40,43,30,21,20,10,1319,71,134,123,53,110,278,500,333,69,0,0,0,50,110,0,0,'LAST_HIT','true'),
(20077,20077,'Androscorpio Hunter',0,'',0,'LineageMonster.onyx_beast',14.00,14.50,30,'male','L2Monster',40,954,365,5.53,1.53,40,43,30,21,20,10,1308,72,145,128,58,114,278,0,333,0,0,0,0,33,132,0,0,'LAST_HIT','true'),
(20078,20078,'Whispering Wind',0,'',0,'LineageMonster.sylph_100_bi',20.00,70.00,30,'female','L2Monster',40,954,365,5.53,1.53,40,43,30,21,20,10,1308,72,120,155,58,114,278,0,333,0,0,0,0,66,66,0,0,'LAST_HIT','true'),
(20079,20079,'Ant',0,'',0,'LineageMonster.ant',26.00,15.00,30,'male','L2Monster',40,954,365,5.53,1.53,40,43,30,21,20,10,1308,72,145,128,58,114,278,0,333,0,0,0,0,40,130,0,0,'LAST_HIT','false'),
(20080,20080,'Ant Captain',0,'',0,'LineageMonster.ant',26.00,15.00,31,'male','L2Monster',40,1004,381,7.11,1.84,40,43,30,21,20,10,1425,79,157,133,64,118,278,500,333,0,0,0,0,40,130,0,0,'LAST_HIT','false'),
(20081,20081,'Ant Overseer',0,'',0,'LineageMonster.ant',26.00,15.00,32,'male','L2Monster',40,1056,397,14.22,1.84,40,43,30,21,20,10,1200,67,169,138,69,123,278,0,333,0,0,0,0,40,130,0,0,'LAST_HIT','false'),
(20082,20082,'Ant Recruit',0,'',0,'LineageMonster.ant_soldier',35.00,17.00,33,'male','L2Monster',40,1109,413,7.11,1.84,40,43,30,21,20,10,1451,83,151,173,75,128,278,0,333,0,0,0,0,80,130,0,0,'LAST_HIT','false'),
(20083,20083,'Granite Golem',0,'',0,'LineageMonster.stone_golem',20.00,31.00,33,'male','L2Monster',40,1109,413,7.11,1.84,40,43,30,21,20,10,2239,129,151,173,75,128,278,0,333,0,0,0,0,23,23,0,0,'LAST_HIT','true'),
(20084,20084,'Ant Patrol',0,'',0,'LineageMonster.ant_soldier',35.00,17.00,34,'male','L2Monster',40,1164,430,7.11,1.84,40,43,30,21,20,10,1667,97,196,148,82,132,278,0,333,0,0,0,0,80,130,0,0,'LAST_HIT','false'),
(20085,20085,'Puncher',0,'',0,'LineageMonster.stone_golem',20.00,31.00,34,'male','L2Monster',40,1164,430,7.11,1.84,40,43,30,21,20,10,2424,142,196,148,82,132,278,500,333,0,0,0,0,23,23,0,0,'LAST_HIT','true'),
(20086,20086,'Ant Guard',0,'',0,'LineageMonster.ant_soldier',35.00,17.00,35,'male','L2Monster',40,1220,446,7.11,1.84,40,43,30,21,20,10,1484,88,192,169,89,137,278,0,333,0,0,0,0,80,174,0,0,'LAST_HIT','false'),
(20087,20087,'Ant Soldier',0,'',0,'LineageMonster.ant_soldier',35.00,17.00,35,'male','L2Monster',40,1220,446,14.22,1.84,40,43,30,21,20,10,1780,105,192,169,89,137,278,500,333,0,0,0,0,80,174,0,0,'LAST_HIT','false'),
(20088,20088,'Ant Warrior Captain',0,'',0,'LineageMonster.ant_soldier',35.00,17.00,36,'male','L2Monster',40,1279,463,14.22,1.84,40,43,30,21,20,10,1984,120,227,159,96,142,278,500,333,0,0,0,0,80,174,0,0,'LAST_HIT','false'),
(20089,20089,'Noble Ant',0,'',0,'LineageMonster.noble_ant',20.00,48.00,37,'male','L2Monster',40,1338,480,7.11,1.84,40,43,30,21,20,10,1659,102,222,182,104,147,278,0,333,0,0,0,0,88,191,0,0,'LAST_HIT','false'),
(20090,20090,'Noble Ant Leader',0,'',0,'LineageMonster.noble_ant',20.00,48.00,38,'male','L2Monster',40,1400,497,14.22,1.84,40,43,30,21,20,10,1829,114,261,171,112,153,278,500,333,0,0,0,0,88,191,0,0,'LAST_HIT','false'),
(20091,20091,'Young Fox',0,'',0,'LineageMonster.fox',9.50,10.00,1,'male','L2Monster',40,62,44,3.16,0.91,40,43,30,21,20,10,29,2,9,39,3,32,278,0,333,0,0,0,0,25,121,0,0,'LAST_HIT','false'),
(20092,20092,'Monster Eye',0,'',0,'LineageMonster.monster_eye',21.00,43.00,10,'male','L2Monster',40,257,120,3.16,0.91,40,43,30,21,20,10,294,10,22,61,8,49,278,0,333,0,0,0,0,99,147,0,0,'LAST_HIT','false'),
(20093,20093,'Orc Fighter',0,'',0,'LineageMonster.orc_fighter',12.00,22.00,10,'male','L2Monster',40,257,120,3.16,0.91,40,43,30,21,20,10,363,12,22,61,8,49,278,500,333,1,0,0,0,49,121,0,0,'LAST_HIT','true'),
(20094,20094,'Orc Marksman',0,'',0,'LineageMonster.orc_archer',14.00,25.00,10,'male','L2Monster',500,257,120,3.16,0.91,40,43,30,21,20,10,305,10,56,55,8,49,249,0,333,14,0,0,0,49,121,0,0,'LAST_HIT','false'),
(20095,20095,'Vampire Bat',0,'',0,'LineageMonster.vampire_bat',10.00,33.50,10,'male','L2Monster',40,257,120,3.16,0.91,40,43,30,21,20,10,296,10,22,61,8,49,278,0,333,0,0,0,0,66,88,0,0,'LAST_HIT','false'),
(20096,20096,'Orc Lieutenant',0,'',0,'LineageMonster.orc_fighter',12.00,22.00,11,'male','L2Monster',40,292,129,3.95,1.21,40,43,30,21,20,10,391,15,23,70,9,52,278,0,333,2,0,0,0,49,121,0,0,'LAST_HIT','true'),
(20097,20097,'Drill Bat',0,'',0,'LineageMonster.vampire_bat',10.00,33.50,11,'male','L2Monster',40,292,129,3.95,1.21,40,43,30,21,20,10,326,12,27,58,9,52,278,0,333,0,0,0,0,66,88,0,0,'LAST_HIT','false'),
(20098,20098,'Orc Fighter Leader',0,'',0,'LineageMonster.orc_fighter',12.00,22.00,12,'male','L2Monster',40,315,138,3.95,1.21,40,43,30,21,20,10,447,17,30,60,10,54,278,500,333,2,0,0,0,49,121,0,0,'LAST_HIT','true'),
(20099,20099,'Skeleton',0,'',0,'LineageMonster.skeleton',11.00,25.00,12,'male','L2Monster',40,315,138,3.95,1.21,40,43,30,21,20,10,363,13,26,60,10,54,317,500,333,946,945,0,0,66,154,1,0,'LAST_HIT','false'),
(20100,20100,'Skeleton Archer',0,'',0,'LineageMonster.skeleton_archer',11.00,27.00,13,'male','L2Monster',500,339,147,3.95,1.21,40,43,30,21,20,10,405,16,74,63,11,56,249,500,333,14,0,0,0,44,154,1,0,'LAST_HIT','false'),
(20101,20101,'Crasher',0,'',0,'LineageMonster.stone_golem',20.00,31.00,14,'male','L2Monster',40,364,156,3.95,1.21,40,43,30,21,20,10,705,27,30,80,12,59,278,0,333,0,0,0,0,25,25,0,0,'LAST_HIT','true'),
(20102,20102,'Skeleton Marksman',0,'',0,'LineageMonster.skeleton_archer',11.00,27.00,14,'male','L2Monster',500,364,156,3.95,1.21,40,43,30,21,20,10,428,17,82,66,12,59,249,0,333,14,0,0,0,44,154,1,0,'LAST_HIT','false'),
(20103,20103,'Giant Spider',0,'',0,'LineageMonster.giant_spider',26.00,25.50,15,'male','L2Monster',40,390,165,3.95,1.21,40,43,30,21,20,10,545,22,40,69,14,62,278,500,333,0,0,0,0,79,143,0,0,'LAST_HIT','true'),
(20104,20104,'Skeleton Lord',0,'',0,'LineageMonster.skeleton',11.00,25.00,15,'male','L2Monster',40,390,165,3.95,1.21,40,43,30,21,20,10,445,18,29,84,14,62,317,0,333,946,945,0,0,66,154,1,0,'LAST_HIT','false'),
(20105,20105,'Dark Horror',0,'',0,'LineageMonster.dark_horror',20.00,35.00,16,'male','L2Monster',40,417,174,3.95,1.21,40,43,30,21,20,10,576,23,44,72,15,64,278,500,333,0,0,0,0,100,100,1,0,'LAST_HIT','true'),
(20106,20106,'Talon Spider',0,'',0,'LineageMonster.giant_spider',26.00,25.50,16,'male','L2Monster',40,417,174,3.95,1.21,40,43,30,21,20,10,570,23,44,72,15,64,278,0,333,0,0,0,0,79,143,0,0,'LAST_HIT','true'),
(20107,20107,'Wererat',0,'',0,'LineageMonster.wererat',14.00,25.00,16,'male','L2Monster',40,417,174,3.95,1.21,40,43,30,21,20,10,475,19,40,79,15,64,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(20108,20108,'Blade Spider',0,'',0,'LineageMonster.giant_spider',26.00,25.50,17,'male','L2Monster',40,446,184,3.95,1.21,40,43,30,21,20,10,618,26,48,75,17,67,278,500,333,0,0,0,0,79,143,0,0,'LAST_HIT','true'),
(20109,20109,'Salamander',0,'',0,'LineageMonster.salamander',16.00,6.80,17,'male','L2Monster',40,446,184,7.90,1.21,40,43,30,21,20,10,494,21,44,83,17,67,278,0,333,0,0,0,0,70,105,0,0,'LAST_HIT','false'),
(20110,20110,'Undine',0,'',0,'LineageMonster.undine',12.00,27.00,17,'female','L2Monster',40,446,184,7.90,1.21,40,43,30,21,20,10,479,20,44,83,17,67,278,500,333,0,0,0,0,66,66,0,0,'LAST_HIT','false'),
(20111,20111,'Wererat Leader',0,'',0,'LineageMonster.wererat',14.00,25.00,17,'male','L2Monster',40,446,184,7.90,1.21,40,43,30,21,20,10,479,20,40,91,17,67,278,500,333,1,0,0,0,88,132,0,0,'LAST_HIT','false'),
(20112,20112,'Salamander Elder',0,'',0,'LineageMonster.salamander',16.00,6.80,18,'male','L2Monster',40,476,193,7.90,1.21,40,43,30,21,20,10,496,21,53,79,19,70,278,0,333,0,0,0,0,70,105,0,0,'LAST_HIT','false'),
(20113,20113,'Undine Elder',0,'',0,'LineageMonster.undine',12.00,27.00,18,'female','L2Monster',40,476,193,7.90,1.21,40,43,30,21,20,10,505,22,44,95,19,70,278,500,333,0,0,0,0,66,66,0,0,'LAST_HIT','false'),
(20114,20114,'Salamander Noble',0,'',0,'LineageMonster.salamander',16.00,6.80,19,'male','L2Monster',40,508,203,7.90,1.21,40,43,30,21,20,10,525,23,58,82,21,73,278,0,333,0,0,0,0,70,105,0,0,'LAST_HIT','false'),
(20115,20115,'Undine Noble',0,'',0,'LineageMonster.undine',12.00,27.00,19,'female','L2Monster',40,508,203,7.90,1.21,40,43,30,21,20,10,536,24,58,82,21,73,278,500,333,0,0,0,0,66,66,0,0,'LAST_HIT','false'),
(20116,20116,'Fox',0,'',0,'LineageMonster.fox',9.50,10.00,2,'male','L2Monster',40,75,52,3.16,0.91,40,43,30,21,20,10,58,2,10,42,3,34,278,0,333,0,0,0,0,25,121,0,0,'LAST_HIT','false'),
(20117,20117,'Dre Vanul',0,'',0,'LineageMonster.dre_vanul',14.00,36.00,20,'male','L2Monster',40,541,213,3.95,1.21,40,43,30,21,20,10,666,29,63,86,23,76,278,500,333,0,0,0,0,88,88,0,0,'LAST_HIT','false'),
(20118,20118,'Dre Vanul Scout',0,'',0,'LineageMonster.dre_vanul',14.00,36.00,21,'male','L2Minion',40,575,227,5.53,1.53,40,43,30,21,20,10,649,30,69,89,25,80,278,500,333,0,0,0,0,88,88,0,0,'LAST_HIT','false'),
(20119,20119,'Elder Fox',0,'',0,'LineageMonster.fox',9.50,10.00,3,'male','L2Monster',40,90,60,3.16,0.91,40,43,30,21,20,10,88,2,12,40,3,35,278,0,333,0,0,0,0,25,121,0,0,'LAST_HIT','false'),
(20120,20120,'Wolf',0,'',0,'LineageMonster.wolf',13.00,9.00,4,'male','L2Monster',40,107,68,3.16,0.91,40,43,30,21,20,10,141,4,12,46,4,37,278,0,333,0,0,0,0,24,110,0,0,'LAST_HIT','true'),
(20121,20121,'Giant Toad',0,'',0,'LineageMonster.poison_toad',20.00,10.00,5,'male','L2Monster',40,126,77,3.16,0.91,40,43,30,21,20,10,178,5,13,48,4,39,278,0,333,0,0,0,0,50,100,0,0,'LAST_HIT','true'),
(20130,20130,'Orc',0,'',0,'LineageMonster.orc',10.00,21.00,6,'male','L2Monster',40,147,85,3.16,0.91,40,43,30,21,20,10,213,6,15,50,5,41,278,0,333,156,0,0,0,49,121,0,0,'LAST_HIT','true'),
(20131,20131,'Orc Grunt',0,'',0,'LineageMonster.orc',10.00,21.00,7,'male','L2Monster',40,171,94,3.16,0.91,40,43,30,21,20,10,249,8,17,53,6,43,278,0,333,4,0,0,0,49,121,0,0,'LAST_HIT','true'),
(20132,20132,'Werewolf',0,'',0,'LineageMonster.werewolf',10.00,26.00,9,'male','L2Monster',40,226,111,3.16,0.91,40,43,30,21,20,10,321,11,20,58,7,47,278,0,333,0,0,0,0,55,132,0,0,'LAST_HIT','true'),
(20133,20133,'Bugbear',0,'',0,'LineageMonster.bugbear',17.00,35.00,21,'male','L2Monster',40,575,227,5.53,1.53,40,43,30,21,20,10,649,30,63,98,25,80,278,500,333,4,0,0,0,60,143,0,0,'LAST_HIT','false'),
(20134,20134,'Cave Maiden',0,'',0,'LineageMonster.cave_maiden',25.00,65.00,59,'female','L2Monster',40,2971,1117,10.27,2.45,40,43,30,21,20,10,5112,437,902,326,453,291,278,500,333,68,0,0,0,70,174,0,0,'LAST_HIT','false'),
(20135,20135,'Alligator',0,'',0,'LineageMonster.crocodile',28.00,11.50,40,'male','L2Monster',40,1527,531,7.11,1.84,40,43,30,21,20,10,2373,153,300,183,131,164,278,500,333,0,0,0,0,70,174,0,0,'LAST_HIT','true'),
(20136,20136,'Death Knight',0,'',0,'LineageMonster.death_knight',14.50,36.00,50,'male','L2Monster',40,2245,830,17.38,2.14,40,43,30,21,20,10,4651,350,616,230,264,226,278,500,333,75,0,0,0,27,174,1,0,'LAST_HIT','false'),
(20137,20137,'Drake',0,'',0,'LineageMonster.drake',30.00,100.00,57,'male','L2Monster',40,2806,1052,10.27,2.45,40,43,30,21,20,10,4819,401,817,309,405,276,278,500,333,0,0,0,0,77,191,0,0,'LAST_HIT','false'),
(20138,20138,'Gargoyle',0,'',0,'LineageMonster.gargoyle',16.00,50.00,27,'male','L2Monster',40,813,318,5.53,1.53,40,43,30,21,20,10,946,48,104,125,45,102,278,500,333,0,0,0,0,154,154,0,0,'LAST_HIT','false'),
(20139,20139,'Giant Bee',0,'',0,'LineageMonster.giant_bee',8.00,24.50,16,'male','L2Monster',40,417,174,3.95,1.21,40,43,30,21,20,10,471,19,40,79,15,64,278,0,333,0,0,0,0,99,99,0,0,'LAST_HIT','false'),
(20140,20140,'Giant Leech',0,'',0,'LineageMonster.giant_leech',70.00,29.00,24,'male','L2Monster',40,687,272,5.53,1.53,40,43,30,21,20,10,795,39,81,111,34,90,278,500,333,0,0,0,0,55,121,0,0,'LAST_HIT','false'),
(20141,20141,'Giant Wild Hog',0,'',0,'LineageMonster.giant_wild_hog',35.00,27.00,47,'male','L2Monster',40,2016,738,8.69,2.14,40,43,30,21,20,10,2730,196,427,253,216,206,278,500,333,0,0,0,0,38,132,0,0,'LAST_HIT','false'),
(20142,20142,'Griffon',0,'',0,'LineageMonster.griffin',20.00,44.00,20,'male','L2Monster',40,541,213,3.95,1.21,40,43,30,21,20,10,593,26,57,94,23,76,278,0,333,0,0,0,0,99,99,0,0,'LAST_HIT','false'),
(20143,20143,'Grizzly',0,'',0,'LineageMonster.grizzly',21.00,40.00,12,'male','L2Monster',40,315,138,3.95,1.21,40,43,30,21,20,10,436,16,27,66,10,54,278,500,333,0,0,0,0,40,110,0,0,'LAST_HIT','true'),
(20144,20144,'Hangman Tree',0,'',0,'LineageMonster.hanged_man_ripper',35.00,80.00,35,'male','L2Monster',40,1220,446,7.11,1.84,40,43,30,21,20,10,1817,108,192,169,89,137,278,500,333,0,0,0,0,55,174,0,0,'LAST_HIT','true'),
(20145,20145,'Harpy',0,'',0,'LineageMonster.harpy',10.00,42.00,32,'female','L2Monster',40,1056,397,7.11,1.84,40,43,30,21,20,10,1504,84,154,151,69,123,278,500,333,0,0,0,0,60,100,0,0,'LAST_HIT','true'),
(20146,20146,'Headless Knight',0,'',0,'LineageMonster.headless_knight',21.00,31.00,50,'male','L2Monster',40,2245,830,8.69,2.14,40,43,30,21,20,10,3708,279,463,306,264,226,278,500,333,124,0,0,0,77,191,1,0,'LAST_HIT','false'),
(20147,20147,'Hobgoblin',0,'',0,'LineageMonster.hobgoblin',12.00,24.00,21,'male','L2Monster',40,575,227,5.53,1.53,40,43,30,21,20,10,764,35,63,98,25,80,278,0,333,4,0,0,0,45,110,0,0,'LAST_HIT','true'),
(20148,20148,'Hungry Spirit',0,'',0,'LineageMonster.hungry_spirit',30.00,40.00,40,'male','L2Monster',40,1527,531,7.11,1.84,40,43,30,21,20,10,1958,126,300,183,131,164,278,500,333,0,0,0,0,16,132,1,0,'LAST_HIT','false'),
(20149,20149,'Iron Golem',0,'',0,'LineageMonster.iron_golem',18.00,34.00,38,'male','L2Monster',40,1400,497,7.11,1.84,40,43,30,21,20,10,2524,157,216,207,112,153,278,500,333,0,0,0,0,22,22,0,0,'LAST_HIT','false'),
(20150,20150,'King Bugbear',0,'',0,'LineageMonster.king_bugbear',15.00,40.00,32,'male','L2Monster',40,1056,397,7.11,1.84,40,43,30,21,20,10,1265,71,169,138,69,123,278,500,333,88,0,0,0,60,143,0,0,'LAST_HIT','false'),
(20151,20151,'Kobold',0,'',0,'LineageMonster.kobold',10.00,15.00,4,'male','L2Monster',40,107,68,3.16,0.91,40,43,30,21,20,10,118,3,12,46,4,37,278,0,333,4,0,0,0,51,121,0,0,'LAST_HIT','false'),
(20152,20152,'Lizardman',0,'',0,'LineageMonster.virud_lizardman',10.00,23.00,19,'male','L2Monster',40,508,203,3.95,1.21,40,43,30,21,20,10,565,25,53,90,21,73,278,0,333,291,0,0,0,47,143,0,0,'LAST_HIT','false'),
(20153,20153,'Magical Weaver',0,'',0,'LineageMonster.magical_weaver',11.00,20.00,11,'male','L2Monster',40,292,129,3.95,1.21,40,43,30,21,20,10,391,15,27,58,9,52,278,0,333,0,0,0,0,99,99,0,0,'LAST_HIT','true'),
(20154,20154,'Mandragora Sprout',0,'',0,'LineageMonster.manadragora',14.00,17.80,21,'female','L2Monster',40,575,227,5.53,1.53,40,43,30,21,20,10,764,35,63,98,25,80,278,0,333,0,0,0,0,80,80,0,0,'LAST_HIT','true'),
(20155,20155,'Mandragora Sapling',0,'',0,'LineageMonster.mandragora_a',15.00,26.00,23,'female','L2Monster',40,648,257,5.53,1.53,40,43,30,21,20,10,895,43,82,97,31,87,278,500,333,0,0,0,0,80,120,0,0,'LAST_HIT','true'),
(20156,20156,'Mandragora Blossom',0,'',0,'LineageMonster.mandragora_b',12.00,25.50,25,'female','L2Monster',40,728,287,5.53,1.53,40,43,30,21,20,10,1012,51,97,105,37,94,278,500,333,0,0,0,0,80,120,0,0,'LAST_HIT','true'),
(20157,20157,'Marsh Stakato',0,'',0,'LineageMonster.marsh_stakato',10.00,20.00,29,'male','L2Monster',40,906,349,5.53,1.53,40,43,30,21,20,10,1509,81,117,123,53,110,317,500,333,223,0,0,0,21,120,0,0,'LAST_HIT','true'),
(20158,20158,'Medusa',0,'',0,'LineageMonster.medusa',10.00,25.00,34,'female','L2Monster',40,1164,430,7.11,1.84,40,43,30,21,20,10,1714,100,178,163,82,132,278,500,333,0,0,0,0,50,110,0,0,'LAST_HIT','true'),
(20159,20159,'Minotaur',0,'',0,'LineageMonster.minotaur',21.00,45.50,43,'male','L2Monster',40,1728,618,8.69,2.14,40,43,30,21,20,10,2263,153,365,202,163,181,278,500,333,300,0,0,0,44,132,0,0,'LAST_HIT','false'),
(20160,20160,'Neer Crawler',0,'',0,'LineageMonster.neer_crawler',14.00,22.00,28,'male','L2Monster',40,859,334,5.53,1.53,40,43,30,21,20,10,1201,63,124,118,49,106,278,500,333,0,0,0,0,50,90,1,0,'LAST_HIT','true'),
(20161,20161,'Oel Mahum',0,'',0,'LineageMonster.oel_mahum',20.00,37.00,53,'male','L2Monster',40,2481,923,10.27,2.45,40,43,30,21,20,10,4167,328,602,304,319,247,278,500,333,0,0,0,0,70,174,0,0,'LAST_HIT','true'),
(20162,20162,'Ogre',0,'',0,'LineageMonster.ogre',21.00,44.00,41,'male','L2Monster',40,1593,560,8.69,2.14,40,43,30,21,20,10,2057,135,446,189,141,169,200,500,333,98,0,0,0,24,88,0,0,'LAST_HIT','false'),
(20163,20163,'Ol Mahum',0,'',0,'LineageMonster.ol_mahum',13.50,25.00,23,'male','L2Monster',40,648,257,5.53,1.53,40,43,30,21,20,10,731,35,82,97,31,87,278,0,333,2,0,0,0,55,121,0,0,'LAST_HIT','false'),
(20164,20164,'Ol Mahum Archer',0,'',0,'LineageMonster.ol_mahum_archer',14.00,25.00,25,'male','L2Monster',500,728,287,5.53,1.53,40,43,30,21,20,10,868,44,216,105,37,94,249,500,333,14,0,0,0,55,121,0,0,'LAST_HIT','false'),
(20165,20165,'Ol Mahum Champion',0,'',0,'LineageMonster.ol_mahum_champion',14.00,27.00,29,'male','L2Monster',40,906,349,5.53,1.53,40,43,30,21,20,10,1257,67,134,123,53,110,278,500,333,69,0,0,0,55,121,0,0,'LAST_HIT','false'),
(20166,20166,'Succubus',0,'',0,'LineageMonster.succubus',10.00,36.00,32,'female','L2Monster',40,1056,397,7.11,1.84,40,43,30,21,20,10,1265,71,154,151,69,123,278,500,333,0,0,0,0,66,110,0,0,'LAST_HIT','false'),
(20167,20167,'Serpent Slave',0,'',0,'LineageMonster.serpent_slave',17.00,46.00,40,'male','L2Monster',40,1527,531,7.11,1.84,40,43,30,21,20,10,1977,128,273,201,131,164,278,500,333,73,0,0,0,77,121,0,0,'LAST_HIT','false'),
(20168,20168,'Silenos',0,'',0,'LineageMonster.silenos',14.00,32.50,30,'male','L2Monster',40,954,365,5.53,1.53,40,43,30,21,20,10,1308,72,132,140,58,114,278,0,333,88,0,0,0,70,110,0,0,'LAST_HIT','true'),
(20169,20169,'Skeleton Royal Guard',0,'',0,'LineageMonster.skeleton_royal_guard',11.00,28.50,26,'male','L2Monster',40,770,303,5.53,1.53,40,43,30,21,20,10,898,45,92,109,41,98,317,500,333,946,945,0,0,88,132,1,0,'LAST_HIT','false'),
(20170,20170,'Spartoi',0,'',0,'LineageMonster.spartoi',11.00,27.00,15,'male','L2Monster',40,390,165,3.95,1.21,40,43,30,21,20,10,454,19,35,69,14,62,317,500,333,946,945,0,0,66,154,1,0,'LAST_HIT','false'),
(20171,20171,'Specter',0,'',0,'LineageMonster.dark_horror',20.00,35.00,26,'male','L2Monster',40,770,303,5.53,1.53,40,43,30,21,20,10,1078,54,96,120,41,98,278,500,333,0,0,0,0,110,110,1,0,'LAST_HIT','true'),
(20172,20172,'Sylph',0,'',0,'LineageMonster.sylph',11.00,35.00,10,'female','L2Monster',40,257,120,3.16,0.91,40,43,30,21,20,10,296,10,25,55,8,49,278,0,333,0,0,0,0,66,66,0,0,'LAST_HIT','false'),
(20173,20173,'Troll',0,'',0,'LineageMonster.troll',21.00,35.00,33,'male','L2Monster',40,1109,413,7.11,1.84,40,43,30,21,20,10,1332,76,182,143,75,128,278,500,333,0,0,0,0,60,121,0,0,'LAST_HIT','false'),
(20174,20174,'Two-Headed Giant',0,'',0,'LineageMonster.twin_headed_giant',17.00,39.00,35,'male','L2Monster',40,1220,446,7.11,1.84,40,43,30,21,20,10,1499,89,174,186,89,137,278,500,333,4,0,0,0,49,110,0,0,'LAST_HIT','false'),
(20175,20175,'Walking Fungus',0,'',0,'LineageMonster.walking_fungus',15.00,22.50,8,'male','L2Monster',40,197,102,3.16,0.91,40,43,30,21,20,10,237,8,18,55,6,45,278,0,333,0,0,0,0,77,121,0,0,'LAST_HIT','false'),
(20176,20176,'Wyrm',0,'',0,'LineageMonster.wyrm',29.00,72.00,35,'male','L2Monster',40,1220,446,7.11,1.84,40,43,30,21,20,10,1817,108,211,154,89,137,278,500,333,0,0,0,0,70,174,0,0,'LAST_HIT','true'),
(20177,20177,'Zombie',0,'',0,'LineageMonster.zombie',13.00,21.00,6,'male','L2Monster',40,147,85,3.16,0.91,40,43,30,21,20,10,178,5,15,50,5,41,278,0,333,0,0,0,0,16,16,1,0,'LAST_HIT','false'),
(20189,20189,'Puma',0,'',0,'LineageMonster.onyx_beast',14.00,14.50,15,'male','L2Monster',40,390,165,3.95,1.21,40,43,30,21,20,10,441,18,40,69,14,62,278,0,333,0,0,0,0,33,132,0,0,'LAST_HIT','false'),
(20190,20190,'Skeleton Marauder',0,'',0,'LineageMonster.skeleton_archer',11.00,27.00,29,'male','L2Monster',500,906,349,5.53,1.53,40,43,30,21,20,10,1306,70,299,123,53,110,247,500,333,14,0,0,0,40,140,1,0,'LAST_HIT','true'),
(20191,20191,'Skeleton Raider',0,'',0,'LineageMonster.skeleton',11.00,25.00,30,'male','L2Monster',40,954,365,5.53,1.53,40,43,30,21,20,10,1335,73,127,128,58,114,317,500,333,946,945,0,0,60,140,1,0,'LAST_HIT','true'),
(20192,20192,'Tyrant',0,'',0,'LineageMonster.grave',15.00,29.00,35,'male','L2Monster',40,1220,446,7.11,1.84,40,43,30,21,20,10,1781,105,211,154,89,137,278,0,333,0,0,0,0,70,174,0,0,'LAST_HIT','true'),
(20193,20193,'Tyrant Kingpin',0,'',0,'LineageMonster.grave',15.00,29.00,36,'male','L2Monster',40,1279,463,7.11,1.84,40,43,30,21,20,10,1922,116,227,159,96,142,278,500,333,0,0,0,0,77,191,0,0,'LAST_HIT','true'),
(20194,20194,'Queen Undine',0,'',0,'LineageMonster.undine',12.00,27.00,50,'female','L2Monster',40,2245,830,8.69,2.14,40,43,30,21,20,10,3090,233,560,253,264,226,278,500,333,0,0,0,0,66,66,0,0,'LAST_HIT','false'),
(20197,20197,'Sorrow Maiden',0,'',0,'LineageMonster.sylph',11.00,35.00,27,'female','L2Monster',40,813,318,5.53,1.53,40,43,30,21,20,10,1102,56,104,125,45,102,278,0,333,0,0,0,0,66,66,0,0,'LAST_HIT','true'),
(20198,20198,'Neer Ghoul Berserker',0,'',0,'LineageMonster.neer_crawler',14.00,22.00,29,'male','L2Monster',40,906,349,5.53,1.53,40,43,30,21,20,10,1268,68,134,123,53,110,278,500,333,0,0,0,0,50,90,1,0,'LAST_HIT','true'),
(20199,20199,'Amber Basilisk',0,'',0,'LineageMonster.lesser_basilisk',34.00,25.00,30,'male','L2Monster',40,954,365,5.53,1.53,40,43,30,21,20,10,1557,85,120,155,58,114,278,0,333,0,0,0,0,35,131,0,0,'LAST_HIT','true'),
(20200,20200,'Strain',0,'',0,'LineageMonster.hungry_spirit',30.00,40.00,31,'male','L2Monster',40,1004,381,7.11,1.84,40,43,30,21,20,10,1383,77,157,133,64,118,278,0,333,0,0,0,0,15,120,1,0,'LAST_HIT','true'),
(20201,20201,'Ghoul',0,'',0,'LineageMonster.zombie',13.00,21.00,32,'male','L2Monster',40,1056,397,7.11,1.84,40,43,30,21,20,10,2085,117,169,138,69,123,278,0,333,0,0,0,0,15,15,1,0,'LAST_HIT','true'),
(20202,20202,'Dead Seeker',0,'',0,'LineageMonster.vampire_bat',10.00,33.50,34,'male','L2Monster',40,1164,430,7.11,1.84,40,43,30,21,20,10,1664,97,178,163,82,132,278,0,333,0,0,0,0,60,80,0,0,'LAST_HIT','true'),
(20203,20203,'Dion Grizzly',0,'',0,'LineageMonster.grizzly',21.00,40.00,20,'male','L2Monster',40,541,213,3.95,1.21,40,43,30,21,20,10,705,31,52,104,23,76,278,0,333,0,0,0,0,40,110,0,0,'LAST_HIT','true'),
(20204,20204,'Bloody Bee',0,'',0,'LineageMonster.giant_bee',8.00,24.50,23,'male','L2Monster',40,648,257,5.53,1.53,40,43,30,21,20,10,956,46,82,97,31,87,278,0,333,0,0,0,0,90,90,0,0,'LAST_HIT','true'),
(20205,20205,'Dire Wolf',0,'',0,'LineageMonster.dire_wolf',13.00,11.00,24,'male','L2Monster',40,687,272,5.53,1.53,40,43,30,21,20,10,954,47,89,101,34,90,278,500,333,0,0,0,0,24,110,0,0,'LAST_HIT','true'),
(20206,20206,'Kadif Werewolf',0,'',0,'LineageMonster.werewolf',10.00,26.00,25,'male','L2Monster',40,728,287,5.53,1.53,40,43,30,21,20,10,982,49,97,105,37,94,278,0,333,0,0,0,0,50,120,0,0,'LAST_HIT','true'),
(20207,20207,'Ol Mahum Guerilla',0,'',0,'LineageMonster.ol_mahum',13.50,25.00,26,'male','L2Monster',40,770,303,11.06,1.53,40,43,30,21,20,10,982,49,87,132,41,98,278,0,333,2,19,0,0,50,110,0,0,'LAST_HIT','true'),
(20208,20208,'Ol Mahum Raider',0,'',0,'LineageMonster.ol_mahum',13.50,25.00,27,'male','L2Monster',40,813,318,11.06,1.53,40,43,30,21,20,10,1035,53,83,138,45,102,317,0,333,10,0,0,0,50,110,0,0,'LAST_HIT','true'),
(20209,20209,'Ol Mahum Marksman',0,'',0,'LineageMonster.ol_mahum_archer',14.00,25.00,28,'male','L2Monster',500,859,334,11.06,1.53,40,43,30,21,20,10,1128,59,276,118,49,106,247,0,333,275,0,0,0,50,110,0,0,'LAST_HIT','true'),
(20210,20210,'Ol Mahum Sergeant',0,'',0,'LineageMonster.ol_mahum',13.50,25.00,29,'male','L2Monster',40,906,349,11.06,1.53,40,43,30,21,20,10,1156,62,111,149,53,110,278,0,333,68,19,0,0,50,110,0,0,'LAST_HIT','true'),
(20211,20211,'Ol Mahum Captain',0,'',0,'LineageMonster.ol_mahum_champion',14.00,27.00,30,'male','L2Monster',40,954,365,11.06,1.53,40,43,30,21,20,10,1241,68,145,128,58,114,278,500,333,123,19,0,0,50,110,0,0,'LAST_HIT','true'),
(20212,20212,'Bloody Axe Turmak',0,'Ol Mahum Lord',0,'LineageMonster.ol_mahum_champion',14.00,27.00,34,'male','L2Monster',40,1164,430,14.22,1.84,40,43,30,21,20,10,1469,86,196,148,82,132,278,500,333,69,19,0,0,55,121,0,0,'LAST_HIT','false'),
(20213,20213,'Porta',0,'',0,'LineageMonster.stone_golem',20.00,31.00,40,'male','L2Monster',40,1527,531,14.22,1.84,40,43,30,21,20,10,1576,102,248,222,131,164,278,0,333,0,0,0,0,23,60,0,0,'LAST_HIT','false'),
(20214,20214,'Excuro',0,'',0,'LineageMonster.mana_vampire',11.00,20.00,41,'male','L2Monster',40,1593,560,17.38,2.14,40,43,30,21,20,10,2028,132,265,229,141,169,278,0,333,0,0,0,0,40,90,0,0,'LAST_HIT','false'),
(20215,20215,'Mordeo',0,'',0,'LineageMonster.onyx_beast',14.00,14.50,42,'male','L2Monster',40,1660,589,17.38,2.14,40,43,30,21,20,10,2625,175,342,196,152,175,278,500,333,0,0,0,0,30,120,0,0,'LAST_HIT','false'),
(20216,20216,'Ricenseo',0,'',0,'LineageMonster.monster_eye',21.00,43.00,43,'male','L2Monster',40,1728,618,17.38,2.14,40,43,30,21,20,10,2104,142,332,223,163,181,278,0,333,0,0,0,0,40,90,0,0,'LAST_HIT','false'),
(20217,20217,'Krator',0,'',0,'LineageMonster.stone_golem',20.00,31.00,44,'male','L2Monster',40,1799,648,17.38,2.14,40,43,30,21,20,10,2688,184,322,253,176,187,278,0,333,0,0,0,0,23,60,0,0,'LAST_HIT','false'),
(20218,20218,'Premo',0,'',0,'LineageMonster.troll',21.00,35.00,45,'male','L2Monster',40,1870,677,17.38,2.14,40,43,30,21,20,10,2812,195,415,216,188,193,278,0,333,0,0,0,0,55,90,0,0,'LAST_HIT','false'),
(20219,20219,'Validus',0,'',0,'LineageMonster.grave',15.00,29.00,46,'male','L2Monster',40,1943,707,17.38,2.14,40,43,30,21,20,10,2408,170,365,270,202,199,278,0,333,0,0,0,0,70,174,0,0,'LAST_HIT','false'),
(20220,20220,'Dicor',0,'',0,'LineageMonster.mandragora_b',12.00,25.50,47,'female','L2Monster',40,2016,738,17.38,2.14,40,43,30,21,20,10,2867,205,469,230,216,206,278,500,333,0,0,0,0,80,174,0,0,'LAST_HIT','false'),
(20221,20221,'Perum',0,'',0,'LineageMonster.iron_golem',18.00,34.00,48,'male','L2Monster',40,2091,768,17.38,2.14,40,43,30,21,20,10,3438,251,412,288,231,212,278,500,333,0,0,0,0,20,20,0,0,'LAST_HIT','false'),
(20222,20222,'Torfe',0,'',0,'LineageMonster.grave',15.00,29.00,49,'male','L2Monster',40,2168,799,17.38,2.14,40,43,30,21,20,10,3025,223,529,245,247,219,278,0,333,0,0,0,0,70,174,0,0,'LAST_HIT','false'),
(20223,20223,'Mandragora Sprout',0,'',0,'LineageMonster.manadragora',14.00,17.80,20,'female','L2Monster',40,541,213,3.95,1.21,40,43,30,21,20,10,783,35,63,86,23,76,278,0,333,0,0,0,0,80,80,0,0,'LAST_HIT','true'),
(20224,20224,'Ol Mahum Ranger',0,'',0,'LineageMonster.ol_mahum_archer',14.00,25.00,22,'male','L2Monster',500,611,242,5.53,1.53,40,43,30,21,20,10,1059,50,139,113,28,83,247,0,333,13,0,0,0,50,110,0,0,'LAST_HIT','true'),
(20225,20225,'Giant Mist Leech',0,'',0,'LineageMonster.giant_leech',70.00,29.00,25,'male','L2Monster',40,728,287,5.53,1.53,40,43,30,21,20,10,992,50,88,116,37,94,278,0,333,0,0,0,0,50,110,0,0,'LAST_HIT','true'),
(20226,20226,'Gray Ant',0,'',0,'LineageMonster.ant',26.00,15.00,26,'male','L2Monster',40,770,303,5.53,1.53,40,43,30,21,20,10,1056,53,87,132,41,98,278,0,333,0,0,0,0,40,130,0,0,'LAST_HIT','true'),
(20227,20227,'Horror Mist Ripper',0,'',0,'LineageMonster.dark_horror',20.00,35.00,27,'male','L2Monster',40,813,318,5.53,1.53,40,43,30,21,20,10,1124,58,114,114,45,102,278,500,333,0,0,0,0,100,100,1,0,'LAST_HIT','true'),
(20228,20228,'Giant Crimson Ant',0,'',0,'LineageMonster.ant_soldier',35.00,17.00,28,'male','L2Monster',40,859,334,5.53,1.53,40,43,30,21,20,10,1296,68,124,118,49,106,278,0,333,0,0,0,0,80,130,0,0,'LAST_HIT','true'),
(20229,20229,'Stinger Wasp',0,'',0,'LineageMonster.giant_bee',8.00,24.50,30,'male','L2Monster',40,954,365,5.53,1.53,40,43,30,21,20,10,1454,79,120,155,58,114,278,500,333,0,0,0,0,90,90,0,0,'LAST_HIT','true'),
(20230,20230,'Marsh Stakato Worker',0,'',0,'LineageMonster.marsh_stakato_worker',9.00,21.00,31,'male','L2Monster',40,1004,381,7.11,1.84,40,43,30,21,20,10,1663,92,142,146,64,118,278,0,333,153,0,0,0,20,140,0,0,'LAST_HIT','true'),
(20231,20231,'Toad Lord',0,'',0,'LineageMonster.poison_toad',20.00,10.00,32,'male','L2Monster',40,1056,397,7.11,1.84,40,43,30,21,20,10,1622,91,140,167,69,123,278,0,333,0,0,0,0,50,100,0,0,'LAST_HIT','true'),
(20232,20232,'Marsh Stakato Soldier',0,'',0,'LineageMonster.marsh_stakato_soldier',10.00,25.00,33,'male','L2Monster',40,1109,413,7.11,1.84,40,43,30,21,20,10,1583,91,132,173,75,128,317,0,333,217,0,0,0,30,155,0,0,'LAST_HIT','true'),
(20233,20233,'Marsh Spider',0,'',0,'LineageMonster.poison_spider',27.00,25.50,34,'male','L2Monster',40,1164,430,7.11,1.84,40,43,30,21,20,10,1867,109,178,163,82,132,278,500,333,0,0,0,0,60,140,0,0,'LAST_HIT','true'),
(20234,20234,'Marsh Stakato Drone',0,'',0,'LineageMonster.marsh_stakato_drone',9.00,24.00,35,'male','L2Monster',40,1220,446,7.11,1.84,40,43,30,21,20,10,1889,112,185,154,89,137,317,500,333,219,0,0,0,80,174,0,0,'LAST_HIT','true'),
(20235,20235,'Shackle',0,'',0,'LineageMonster.hungry_spirit',30.00,40.00,45,'male','L2Monster',40,1870,677,8.69,2.14,40,43,30,21,20,10,2974,207,343,262,188,193,278,500,333,0,0,0,0,15,174,1,0,'LAST_HIT','false'),
(20236,20236,'Cave Servant',0,'',0,'LineageMonster.skeleton',11.00,25.00,46,'male','L2Monster',40,1943,707,8.69,2.14,40,43,30,21,20,10,3077,218,365,270,202,199,278,0,333,79,945,0,0,66,191,1,0,'LAST_HIT','false'),
(20237,20237,'Cave Servant Archer',0,'',0,'LineageMonster.skeleton_archer',11.00,27.00,47,'male','L2Monster',500,2016,738,8.69,2.14,40,43,30,21,20,10,4143,297,1043,230,216,206,249,0,333,14,0,0,0,44,191,1,0,'LAST_HIT','false'),
(20238,20238,'Cave Servant Warrior',0,'',0,'LineageMonster.skeleton',11.00,25.00,48,'male','L2Monster',40,2091,768,8.69,2.14,40,43,30,21,20,10,3987,291,498,238,231,212,278,0,333,77,2495,0,0,66,191,1,0,'LAST_HIT','false'),
(20239,20239,'Cave Servant Captain',0,'',0,'LineageMonster.spartoi',11.00,27.00,49,'male','L2Monster',40,2168,799,8.69,2.14,40,43,30,21,20,10,4238,313,437,297,247,219,278,500,333,73,2495,0,0,66,191,1,0,'LAST_HIT','false'),
(20240,20240,'Royal Cave Servant',0,'',0,'LineageMonster.skeleton_royal_guard',11.00,28.50,51,'male','L2Monster',40,2323,861,10.27,2.45,40,43,30,21,20,10,4546,347,429,315,281,232,317,0,333,946,945,0,0,88,191,1,0,'LAST_HIT','false'),
(20241,20241,'Hunter Gargoyle',0,'',0,'LineageMonster.hunter_gargoyle',25.00,65.00,52,'male','L2Monster',40,2402,892,10.27,2.45,40,43,30,21,20,10,4633,358,627,268,300,239,278,0,333,0,0,0,0,100,174,0,0,'LAST_HIT','true'),
(20242,20242,'Dustwind Gargoyle',0,'',0,'LineageMonster.hunter_gargoyle',25.00,65.00,53,'male','L2Monster',40,2481,923,10.27,2.45,40,43,30,21,20,10,4813,378,547,334,319,247,278,0,333,0,0,0,0,100,174,0,0,'LAST_HIT','false'),
(20243,20243,'Thunder Wyrm',0,'',0,'LineageMonster.wyrm',29.00,72.00,54,'male','L2Monster',40,2562,955,10.27,2.45,40,43,30,21,20,10,4283,341,699,284,339,254,278,500,333,0,0,0,0,70,174,0,0,'LAST_HIT','false'),
(20244,20244,'Malruk Succubus',0,'',0,'LineageMonster.succubus',10.00,36.00,55,'female','L2Monster',40,2643,987,10.27,2.45,40,43,30,21,20,10,4399,355,737,292,360,261,278,0,333,0,0,0,0,60,174,0,0,'LAST_HIT','false'),
(20245,20245,'Malruk Succubus Turen',0,'',0,'LineageMonster.succubus',10.00,36.00,56,'female','L2Monster',40,2724,1019,10.27,2.45,40,43,30,21,20,10,4560,375,777,301,382,269,278,0,333,0,0,0,0,60,174,0,0,'LAST_HIT','false'),
(20246,20246,'Cave Keeper',0,'',0,'LineageMonster.serpent_slave',17.00,46.00,58,'male','L2Monster',40,2889,1084,10.27,2.45,40,43,30,21,20,10,5822,492,751,318,428,284,317,0,333,223,0,0,0,70,174,0,0,'LAST_HIT','false'),
(20248,20248,'Turak Bugbear',0,'',0,'LineageMonster.bugbear',17.00,35.00,31,'male','L2Monster',40,1004,381,7.11,1.84,40,43,30,21,20,10,1397,78,129,161,64,118,278,0,333,88,0,0,0,55,130,0,0,'LAST_HIT','true'),
(20249,20249,'Turak Bugbear Warrior',0,'',0,'LineageMonster.bugbear',17.00,35.00,33,'male','L2Monster',40,1109,413,14.22,1.84,40,43,30,21,20,10,1502,86,151,173,75,128,278,500,333,73,0,0,0,55,130,0,0,'LAST_HIT','true'),
(20250,20250,'Glass Jaguar',0,'',0,'LineageMonster.onyx_beast',14.00,14.50,27,'male','L2Monster',40,813,318,5.53,1.53,40,43,30,21,20,10,1102,56,114,114,45,102,278,0,333,0,0,0,0,30,120,0,0,'LAST_HIT','true'),
(20251,20251,'Delu Lizardman',0,'',0,'LineageMonster.virud_lizardman',10.00,23.00,28,'male','L2Monster',40,859,334,5.53,1.53,40,43,30,21,20,10,1166,61,102,143,49,106,278,0,333,1,19,0,0,43,130,0,0,'LAST_HIT','true'),
(20252,20252,'Delu Lizardman Scout',0,'',0,'LineageMonster.virud_lizardman',10.00,23.00,29,'male','L2Monster',40,906,349,5.53,1.53,40,43,30,21,20,10,1231,66,134,123,53,110,278,0,333,123,0,0,0,43,130,0,0,'LAST_HIT','true'),
(20253,20253,'Delu Lizardman Warrior',0,'',0,'LineageMonster.virud_lizardman_warrior',12.00,30.00,30,'male','L2Monster',40,954,365,5.53,1.53,40,43,30,21,20,10,1321,72,120,155,58,114,278,500,333,16,0,0,0,52,130,0,0,'LAST_HIT','true'),
(20254,20254,'Skeleton Axeman',0,'',0,'LineageMonster.skeleton',11.00,25.00,28,'male','L2Monster',40,859,334,5.53,1.53,40,43,30,21,20,10,1201,63,113,130,49,106,278,500,333,86,0,0,0,60,140,1,0,'LAST_HIT','true'),
(20255,20255,'Batur Orc',0,'',0,'LineageMonster.batur_orc',9.00,21.50,31,'male','L2Monster',40,1004,381,7.11,1.84,40,43,30,21,20,10,1164,65,129,161,64,118,278,0,333,123,0,0,0,88,143,0,0,'LAST_HIT','false'),
(20256,20256,'Batur Orc Archer',0,'',0,'LineageMonster.batur_orc_archer',11.00,21.50,32,'male','L2Monster',500,1056,397,7.11,1.84,40,43,30,21,20,10,1600,90,311,167,69,123,249,0,333,13,0,0,0,49,143,0,0,'LAST_HIT','false'),
(20257,20257,'Batur Orc Warrior',0,'',0,'LineageMonster.batur_orc_warrior',10.00,20.00,33,'male','L2Monster',40,1109,413,7.11,1.84,40,43,30,21,20,10,1602,92,182,143,75,128,278,500,333,123,19,0,0,88,132,0,0,'LAST_HIT','false'),
(20258,20258,'Batur Orc Shaman',0,'',0,'LineageMonster.batur_orc_shaman',11.00,16.00,34,'male','L2Monster',40,1164,430,7.11,1.84,40,43,30,21,20,10,1401,82,196,148,82,132,278,0,333,7,0,0,0,55,132,0,0,'LAST_HIT','false'),
(20259,20259,'Batur Orc Overlord',0,'',0,'LineageMonster.batur_orc_overlord',12.00,24.00,35,'male','L2Monster',40,1220,446,7.11,1.84,40,43,30,21,20,10,1802,107,211,154,89,137,278,500,333,79,0,0,0,88,154,0,0,'LAST_HIT','false'),
(20260,20260,'Orc Champion',0,'',0,'LineageMonster.orc_champion',10.00,23.00,14,'male','L2Monster',40,364,156,3.95,1.21,40,43,30,21,20,10,435,17,30,80,12,59,278,500,333,2,0,0,0,49,143,0,0,'LAST_HIT','false'),
(20261,20261,'Orc Shaman',0,'',0,'LineageMonster.orc_shaman',9.00,22.00,17,'male','L2Monster',40,446,184,3.95,1.21,40,43,30,21,20,10,504,21,40,91,17,67,278,0,333,7,0,0,0,49,132,0,0,'LAST_HIT','false'),
(20265,20265,'Monster Eye Searcher',0,'',0,'LineageMonster.monster_eye',21.00,43.00,22,'male','L2Monster',40,611,242,11.06,1.53,40,43,30,21,20,10,763,36,75,93,28,83,278,0,333,0,0,0,0,90,159,0,0,'LAST_HIT','true'),
(20266,20266,'Monster Eye Gazer',0,'',0,'LineageMonster.monster_eye',21.00,43.00,25,'male','L2Monster',40,728,287,5.53,1.53,40,43,30,21,20,10,992,50,80,127,37,94,278,0,333,0,0,0,0,90,159,0,0,'LAST_HIT','true'),
(20267,20267,'Breka Orc',0,'',0,'LineageMonster.batur_orc',9.00,21.50,31,'male','L2Monster',40,1004,381,7.11,1.84,40,43,30,21,20,10,1397,78,113,161,64,118,317,0,333,215,0,0,0,80,130,0,0,'LAST_HIT','true'),
(20268,20268,'Breka Orc Archer',0,'',0,'LineageMonster.batur_orc_archer',11.00,21.50,32,'male','L2Monster',500,1056,397,7.11,1.84,40,43,30,21,20,10,1920,108,311,167,69,123,247,0,333,275,0,0,0,45,130,0,0,'LAST_HIT','true'),
(20269,20269,'Breka Orc Shaman',0,'',0,'LineageMonster.batur_orc_shaman',11.00,16.00,34,'male','L2Monster',40,1164,430,7.11,1.84,40,43,30,21,20,10,1681,98,162,179,82,132,278,0,333,7,0,0,0,55,132,0,0,'LAST_HIT','true'),
(20270,20270,'Breka Orc Overlord',0,'',0,'LineageMonster.batur_orc_overlord',12.00,24.00,35,'male','L2Monster',40,1220,446,7.11,1.84,40,43,30,21,20,10,2380,141,211,154,89,137,278,500,333,79,0,0,0,88,191,0,0,'LAST_HIT','true'),
(20271,20271,'Breka Orc Warrior',0,'',0,'LineageMonster.batur_orc_warrior',10.00,20.00,33,'male','L2Monster',40,1109,413,7.11,1.84,40,43,30,21,20,10,1922,110,182,143,75,128,278,500,333,123,20,0,0,88,132,0,0,'LAST_HIT','true'),
(20272,20272,'Cave Servant',0,'',0,'LineageMonster.skeleton',11.00,25.00,46,'male','L2Monster',40,1943,707,8.69,2.14,40,43,30,21,20,10,2564,182,365,270,202,199,278,0,333,79,945,0,0,66,154,1,0,'LAST_HIT','false'),
(20273,20273,'Cave Servant Archer',0,'',0,'LineageMonster.skeleton_archer',11.00,27.00,47,'male','L2Monster',500,2016,738,8.69,2.14,40,43,30,21,20,10,2757,198,1043,230,216,206,249,0,333,275,0,0,0,44,154,1,0,'LAST_HIT','false'),
(20274,20274,'Cave Servant Warrior',0,'',0,'LineageMonster.skeleton',11.00,25.00,48,'male','L2Monster',40,2091,768,8.69,2.14,40,43,30,21,20,10,2792,204,498,238,231,212,278,0,333,77,0,0,0,66,154,1,0,'LAST_HIT','false'),
(20275,20275,'Cave Servant Captain',0,'',0,'LineageMonster.spartoi',11.00,27.00,49,'male','L2Monster',40,2168,799,8.69,2.14,40,43,30,21,20,10,2968,219,437,297,247,219,278,500,333,73,0,0,0,66,154,1,0,'LAST_HIT','false'),
(20276,20276,'Royal Cave Servant',0,'',0,'LineageMonster.skeleton_royal_guard',11.00,28.50,51,'male','L2Monster',40,2323,861,10.27,2.45,40,43,30,21,20,10,3152,240,429,315,281,232,317,0,333,946,945,0,0,88,132,1,0,'LAST_HIT','false'),
(20277,20277,'Cave Keeper',0,'',0,'LineageMonster.serpent_slave',17.00,46.00,58,'male','L2Monster',40,2889,1084,10.27,2.45,40,43,30,21,20,10,4077,344,751,318,428,284,317,0,333,223,0,0,0,77,121,0,0,'LAST_HIT','false'),
(20279,20279,'Shackle',0,'',0,'LineageMonster.hungry_spirit',30.00,40.00,45,'male','L2Monster',40,1870,677,8.69,2.14,40,43,30,21,20,10,2478,172,343,262,188,193,278,500,333,0,0,0,0,16,132,1,0,'LAST_HIT','false'),
(20280,20280,'Headless Knight',0,'',0,'LineageMonster.headless_knight',21.00,31.00,50,'male','L2Monster',40,2245,830,8.69,2.14,40,43,30,21,20,10,3090,233,463,306,264,226,278,500,333,124,0,0,0,77,121,1,0,'LAST_HIT','false'),
(20281,20281,'Dustwind Gargoyle',0,'',0,'LineageMonster.hunter_gargoyle',25.00,65.00,53,'male','L2Monster',40,2481,923,10.27,2.45,40,43,30,21,20,10,3370,265,547,334,319,247,278,0,333,0,0,0,0,110,110,0,0,'LAST_HIT','false'),
(20282,20282,'Thunder Wyrm',0,'',0,'LineageMonster.wyrm',29.00,72.00,54,'male','L2Monster',40,2562,955,10.27,2.45,40,43,30,21,20,10,3569,285,699,284,339,254,278,500,333,0,0,0,0,77,77,0,0,'LAST_HIT','false'),
(20283,20283,'Malruk Succubus',0,'',0,'LineageMonster.succubus',10.00,36.00,55,'female','L2Monster',40,2643,987,10.27,2.45,40,43,30,21,20,10,3666,296,737,292,360,261,278,0,333,0,0,0,0,66,110,0,0,'LAST_HIT','false'),
(20284,20284,'Malruk Succubus Turen',0,'',0,'LineageMonster.succubus',10.00,36.00,56,'female','L2Monster',40,2724,1019,10.27,2.45,40,43,30,21,20,10,3800,312,777,301,382,269,278,0,333,0,0,0,0,66,110,0,0,'LAST_HIT','false'),
(20285,20285,'Drake',0,'',0,'LineageMonster.drake',30.00,100.00,57,'male','L2Monster',40,2806,1052,10.27,2.45,40,43,30,21,20,10,4016,334,817,309,405,276,278,500,333,0,0,0,0,77,77,0,0,'LAST_HIT','false'),
(20286,20286,'Hunter Gargoyle',0,'',0,'LineageMonster.hunter_gargoyle',25.00,65.00,52,'male','L2Monster',40,2402,892,10.27,2.45,40,43,30,21,20,10,3244,251,627,268,300,239,278,0,333,0,0,0,0,110,110,0,0,'LAST_HIT','false'),
(20287,20287,'Cave Maiden',0,'',0,'LineageMonster.cave_maiden',25.00,65.00,59,'female','L2Monster',40,2971,1117,10.27,2.45,40,43,30,21,20,10,4260,364,902,326,453,291,278,500,333,68,0,0,0,77,132,0,0,'LAST_HIT','false'),
(20291,20291,'Enku Orc Champion',0,'',0,'LineageMonster.orc_champion',10.00,23.00,21,'male','L2Monster',40,575,227,5.53,1.53,40,43,30,21,20,10,927,43,57,108,25,80,278,500,333,2,0,0,0,45,130,0,0,'LAST_HIT','true'),
(20292,20292,'Enku Orc Shaman',0,'',0,'LineageMonster.orc_shaman',9.00,22.00,20,'male','L2Monster',40,541,213,3.95,1.21,40,43,30,21,20,10,813,36,52,104,23,76,278,0,333,7,0,0,0,45,120,0,0,'LAST_HIT','true'),
(20293,20293,'Virud Lizardman',0,'',0,'LineageMonster.virud_lizardman',10.00,23.00,20,'male','L2Monster',40,541,213,3.95,1.21,40,43,30,21,20,10,593,26,52,104,23,76,278,0,333,291,0,0,0,47,143,0,0,'LAST_HIT','false'),
(20294,20294,'Virud Lizardman Matriarch',0,'',0,'LineageMonster.virud_lizardman_matriarch',13.00,37.00,24,'male','L2Monster',40,687,272,5.53,1.53,40,43,30,21,20,10,951,47,89,101,34,90,278,500,333,2,19,0,0,61,143,0,0,'LAST_HIT','false'),
(20295,20295,'Virud Lizardman Warrior',0,'',0,'LineageMonster.virud_lizardman_warrior',12.00,30.00,22,'male','L2Monster',40,611,242,5.53,1.53,40,43,30,21,20,10,698,33,75,93,28,83,278,500,333,16,0,0,0,57,143,0,0,'LAST_HIT','false'),
(20296,20296,'Virud Lizardman Scout',0,'',0,'LineageMonster.virud_lizardman_scout',10.00,22.00,21,'male','L2Monster',500,575,227,5.53,1.53,40,43,30,21,20,10,656,30,127,108,25,80,249,0,333,2507,0,0,0,47,143,0,0,'LAST_HIT','false'),
(20297,20297,'Virud Lizardman Shaman',0,'',0,'LineageMonster.virud_lizardman_shaman',10.00,29.00,23,'male','L2Monster',40,648,257,5.53,1.53,40,43,30,21,20,10,731,35,68,117,31,87,278,0,333,7,0,0,0,47,132,0,0,'LAST_HIT','false'),
(20298,20298,'Virud Lizardman Shaman',0,'',0,'LineageMonster.virud_lizardman_shaman',10.00,29.00,23,'male','L2Monster',40,648,257,5.53,1.53,40,43,30,21,20,10,731,35,68,117,31,87,278,0,333,7,0,0,0,47,132,0,0,'LAST_HIT','false'),
(20299,20299,'Zenta Lizardman',0,'',0,'LineageMonster.zenta_lizardman',11.00,32.00,40,'male','L2Monster',40,1527,531,7.11,1.84,40,43,30,21,20,10,1939,125,248,222,131,164,278,0,333,68,0,0,0,40,154,0,0,'LAST_HIT','false'),
(20300,20300,'Zenta Lizardman Matriarch',0,'',0,'LineageMonster.zenta_lizardman_matriarch',20.00,40.00,44,'male','L2Monster',40,1799,648,8.69,2.14,40,43,30,21,20,10,2848,195,341,209,176,187,317,500,333,221,0,0,0,58,154,0,0,'LAST_HIT','false'),
(20301,20301,'Zenta Lizardman Scout',0,'',0,'LineageMonster.zenta_lizardman_scout',11.00,30.00,41,'male','L2Monster',500,1593,560,8.69,2.14,40,43,30,21,20,10,2098,137,589,229,141,169,249,0,333,14,0,0,0,40,165,0,0,'LAST_HIT','false'),
(20302,20302,'Zenta Lizardman Warrior',0,'',0,'LineageMonster.zenta_lizardman_warrior',13.00,35.00,42,'male','L2Monster',40,1660,589,8.69,2.14,40,43,30,21,20,10,2180,145,342,196,152,175,278,500,333,16,0,0,0,44,154,0,0,'LAST_HIT','false'),
(20303,20303,'Zenta Lizardman Shaman',0,'',0,'LineageMonster.zenta_lizardman_shaman',13.00,35.00,43,'male','L2Monster',40,1728,618,8.69,2.14,40,43,30,21,20,10,2240,152,302,245,163,181,278,0,333,7,0,0,0,47,143,0,0,'LAST_HIT','false'),
(20304,20304,'Marsh Stakato Queen',0,'',0,'LineageMonster.marsh_stakato_queen',15.00,37.00,36,'female','L2Monster',40,1279,463,7.11,1.84,40,43,30,21,20,10,1906,115,227,159,96,142,278,500,333,74,0,0,0,143,143,0,0,'LAST_HIT','false'),
(20305,20305,'Grave',0,'',0,'LineageMonster.grave',15.00,29.00,40,'male','L2Monster',40,1527,531,7.11,1.84,40,43,30,21,20,10,1958,126,300,183,131,164,278,500,333,0,0,0,0,77,121,0,0,'LAST_HIT','false'),
(20307,20307,'Garum Werewolf',0,'',0,'LineageMonster.werewolf',10.00,26.00,9,'male','L2Monster',40,226,111,3.16,0.91,40,43,30,21,20,10,321,11,22,53,7,47,278,0,333,5,0,0,0,55,132,0,0,'LAST_HIT','true'),
(20308,20308,'Hook Spider',0,'',0,'LineageMonster.giant_spider',26.00,25.50,16,'male','L2Monster',40,417,174,3.95,1.21,40,43,30,21,20,10,570,23,44,72,15,64,278,0,333,0,0,0,0,79,143,0,0,'LAST_HIT','true'),
(20309,20309,'Brown Fox',0,'',0,'LineageMonster.fox',9.50,10.00,2,'male','L2Monster',40,75,52,3.16,0.91,40,43,30,21,20,10,58,2,10,42,3,34,278,0,333,0,0,0,0,25,121,0,0,'LAST_HIT','false'),
(20310,20310,'Brown Bear',0,'',0,'LineageMonster.grizzly_bi',21.00,50.00,16,'male','L2Monster',40,417,174,3.95,1.21,40,43,30,21,20,10,576,23,36,87,15,64,278,500,333,0,0,0,0,40,110,0,0,'LAST_HIT','true'),
(20311,20311,'Rakeclaw Imp',0,'',0,'LineageMonster.imp',10.00,24.00,6,'male','L2Monster',40,147,85,3.16,0.91,40,43,30,21,20,10,213,6,16,46,5,41,278,0,333,0,0,0,0,60,80,0,0,'LAST_HIT','true'),
(20312,20312,'Rakeclaw Imp Hunter',0,'',0,'LineageMonster.imp',10.00,24.00,7,'male','L2Monster',40,171,94,3.16,0.91,40,43,30,21,20,10,249,8,18,48,6,43,278,0,333,0,0,0,0,60,80,0,0,'LAST_HIT','true'),
(20313,20313,'Rakeclaw Imp Chieftain',0,'',0,'LineageMonster.imp_bi',10.00,30.00,10,'male','L2Monster',40,257,120,3.16,0.91,40,43,30,21,20,10,363,12,25,55,8,49,278,500,333,0,0,0,0,66,88,0,0,'LAST_HIT','true'),
(20314,20314,'Great White Shark',0,'',0,'LineageMonster.great_white_shark',20.00,7.00,42,'male','L2Monster',40,1660,589,8.69,2.14,40,43,30,21,20,10,2180,145,342,196,152,175,278,500,333,0,0,0,0,88,191,0,0,'LAST_HIT','false'),
(20316,20316,'Darkwing Bat',0,'',0,'LineageMonster.vampire_bat',10.00,33.50,11,'male','L2Monster',40,292,129,3.95,1.21,40,43,30,21,20,10,391,15,27,58,9,52,278,0,333,0,0,0,0,60,80,0,0,'LAST_HIT','true'),
(20317,20317,'Black Wolf',0,'',0,'LineageMonster.wolf',13.00,9.00,4,'male','L2Monster',40,107,68,3.16,0.91,40,43,30,21,20,10,141,4,12,46,4,37,278,0,333,0,0,0,0,24,110,0,0,'LAST_HIT','true'),
(20318,20318,'Black Timber Wolf',0,'',0,'LineageMonster.wolf_bi',13.00,10.80,6,'male','L2Monster',40,147,85,3.16,0.91,40,43,30,21,20,10,211,6,15,50,5,41,278,0,333,0,0,0,0,26,121,0,0,'LAST_HIT','true'),
(20319,20319,'Goblin Grave Robber',0,'',0,'LineageMonster.goblin',10.00,16.50,5,'male','L2Monster',40,126,77,3.16,0.91,40,43,30,21,20,10,178,5,13,48,4,39,278,0,333,4,0,0,0,40,110,0,0,'LAST_HIT','true'),
(20320,20320,'Goblin Tomb Raider Leader',0,'',0,'LineageMonster.goblin_bi',10.00,21.40,12,'male','L2Monster',40,315,138,3.95,1.21,40,43,30,21,20,10,427,16,24,66,10,54,317,0,333,12,0,0,0,40,110,0,0,'LAST_HIT','true'),
(20321,20321,'Goblin Thief',0,'',0,'LineageMonster.goblin_bi',10.00,21.40,10,'male','L2Monster',40,257,120,3.16,0.91,40,43,30,21,20,10,356,12,20,61,8,49,317,0,333,217,0,0,0,40,110,0,0,'LAST_HIT','true'),
(20322,20322,'Goblin Brigand',0,'',0,'LineageMonster.goblin',10.00,16.50,8,'male','L2Monster',40,197,102,3.16,0.91,40,43,30,21,20,10,284,10,18,55,6,45,278,0,333,4,0,0,0,44,121,0,0,'LAST_HIT','true'),
(20323,20323,'Goblin Brigand Leader',0,'',0,'LineageMonster.goblin_bi',10.00,21.40,14,'male','L2Monster',40,364,156,3.95,1.21,40,43,30,21,20,10,508,20,29,73,12,59,317,500,333,217,0,0,0,44,121,0,0,'LAST_HIT','true'),
(20324,20324,'Goblin Brigand Lieutenant',0,'',0,'LineageMonster.goblin',10.00,16.50,10,'male','L2Monster',40,257,120,3.16,0.91,40,43,30,21,20,10,363,12,20,61,8,49,317,500,333,10,0,0,0,44,121,0,0,'LAST_HIT','true'),
(20325,20325,'Goblin Raider',0,'',0,'LineageMonster.goblin',10.00,16.50,5,'male','L2Monster',40,126,77,3.16,0.91,40,43,30,21,20,10,178,5,13,48,4,39,278,0,333,4,0,0,0,40,110,0,0,'LAST_HIT','true'),
(20326,20326,'Goblin Scout',0,'',0,'LineageMonster.goblin',10.00,16.50,8,'male','L2Monster',40,197,102,3.16,0.91,40,43,30,21,20,10,284,10,18,55,6,45,278,0,333,4,0,0,0,40,110,0,0,'LAST_HIT','true'),
(20327,20327,'Goblin Snooper',0,'',0,'LineageMonster.goblin',10.00,16.50,5,'male','L2Monster',40,126,77,3.16,0.91,40,43,30,21,20,10,178,5,13,48,4,39,278,0,333,4,0,0,0,44,121,0,0,'LAST_HIT','true'),
(20328,20328,'Goblin Lookout',0,'',0,'LineageMonster.goblin',10.00,16.50,8,'male','L2Monster',40,197,102,3.16,0.91,40,43,30,21,20,10,284,10,16,55,6,45,317,0,333,12,0,0,0,40,110,0,0,'LAST_HIT','true'),
(20329,20329,'Ghost Guardian',0,'',0,'LineageMonster.human_ghost',8.00,22.00,21,'male','L2Monster',40,575,227,5.53,1.53,40,43,30,21,20,10,643,30,63,98,25,80,278,500,333,0,0,0,0,88,154,1,0,'LAST_HIT','false'),
(20330,20330,'Mineshaft Bat',0,'',0,'LineageMonster.vampire_bat',10.00,33.50,11,'male','L2Monster',40,292,129,3.95,1.21,40,43,30,21,20,10,326,12,27,58,9,52,278,0,333,0,0,0,0,66,88,0,0,'LAST_HIT','false'),
(20331,20331,'Monster Eye Tracker',0,'',0,'LineageMonster.monster_eye',21.00,43.00,10,'male','L2Monster',40,257,120,3.16,0.91,40,43,30,21,20,10,296,10,20,67,8,49,278,0,333,0,0,0,0,99,147,0,0,'LAST_HIT','false'),
(20333,20333,'Greystone Golem',0,'',0,'LineageMonster.stone_golem',20.00,31.00,13,'male','L2Monster',40,339,147,3.95,1.21,40,43,30,21,20,10,654,26,27,77,11,56,278,0,333,0,0,0,0,25,25,0,0,'LAST_HIT','true'),
(20334,20334,'Gremlin Scavenger',0,'',0,'LineageMonster.gremlin',10.00,15.00,1,'male','L2Monster',40,62,44,3.16,0.91,40,43,30,21,20,10,29,2,9,39,3,32,278,0,333,0,0,0,0,22,55,0,0,'LAST_HIT','false'),
(20335,20335,'Grizzly Bear',0,'',0,'LineageMonster.grizzly_bi',21.00,50.00,17,'male','L2Monster',40,446,184,3.95,1.21,40,43,30,21,20,10,599,25,40,91,17,67,278,0,333,0,0,0,0,44,121,0,0,'LAST_HIT','true'),
(20336,20336,'Green Dryad',0,'',0,'LineageMonster.dryad_sm',6.00,15.00,8,'female','L2Monster',40,197,102,3.16,0.91,40,43,30,21,20,10,284,10,18,55,6,45,278,0,333,0,0,0,0,44,121,0,0,'LAST_HIT','true'),
(20337,20337,'Longtail Fox',0,'',0,'LineageMonster.fox',9.50,10.00,2,'male','L2Monster',40,75,52,3.16,0.91,40,43,30,21,20,10,58,2,10,42,3,34,278,0,333,0,0,0,0,25,121,0,0,'LAST_HIT','false'),
(20338,20338,'Nightmare Weaver',0,'',0,'LineageMonster.magical_weaver',11.00,20.00,21,'male','L2Monster',40,575,227,5.53,1.53,40,43,30,21,20,10,707,33,69,89,25,80,278,500,333,0,0,0,0,99,99,0,0,'LAST_HIT','false'),
(20340,20340,'Slave Skeleton',0,'',0,'LineageMonster.skeleton',11.00,25.00,12,'male','L2Monster',40,315,138,3.95,1.21,40,43,30,21,20,10,363,13,26,60,10,54,317,500,333,946,0,0,0,66,154,1,0,'LAST_HIT','false'),
(20341,20341,'Undead Slave',0,'',0,'LineageMonster.zombie',13.00,21.00,19,'male','L2Monster',40,508,203,3.95,1.21,40,43,30,21,20,10,799,36,58,82,21,73,278,0,333,0,0,0,0,16,16,1,0,'LAST_HIT','false'),
(20342,20342,'Werewolf Chieftain',0,'',0,'LineageMonster.werewolf_bi',11.00,29.70,12,'male','L2Monster',40,315,138,3.95,1.21,40,43,30,21,20,10,436,16,30,60,10,54,278,500,333,5,0,0,0,55,132,0,0,'LAST_HIT','true'),
(20343,20343,'Werewolf Hunter',0,'',0,'LineageMonster.werewolf',10.00,26.00,10,'male','L2Monster',40,257,120,3.16,0.91,40,43,30,21,20,10,363,12,25,55,8,49,278,500,333,5,0,0,0,55,132,0,0,'LAST_HIT','true'),
(20345,20345,'Dark Terror',0,'',0,'LineageMonster.dark_horror',20.00,35.00,16,'male','L2Monster',40,417,174,3.95,1.21,40,43,30,21,20,10,533,22,44,72,15,64,278,500,333,0,0,0,0,110,110,1,0,'LAST_HIT','false'),
(20346,20346,'Darkstone Golem',0,'',0,'LineageMonster.stone_golem',20.00,31.00,13,'male','L2Monster',40,339,147,3.95,1.21,40,43,30,21,20,10,545,21,27,77,11,56,278,0,333,0,0,0,0,25,25,0,0,'LAST_HIT','false'),
(20347,20347,'Doom Wraith',0,'',0,'LineageMonster.death_blader',15.00,45.00,55,'male','L2Monster',40,2643,987,10.27,2.45,40,43,30,21,20,10,3739,302,737,292,360,261,278,500,333,1472,0,0,0,110,191,1,0,'LAST_HIT','false'),
(20348,20348,'Cave Spider',0,'',0,'LineageMonster.giant_spider',26.00,25.50,15,'male','L2Monster',40,390,165,3.95,1.21,40,43,30,21,20,10,445,18,40,69,14,62,278,0,333,0,0,0,0,72,130,0,0,'LAST_HIT','false'),
(20349,20349,'Cave Bat',0,'',0,'LineageMonster.vampire_bat',10.00,33.50,13,'male','L2Monster',40,339,147,3.95,1.21,40,43,30,21,20,10,385,15,33,63,11,56,278,0,333,0,0,0,0,66,88,0,0,'LAST_HIT','false'),
(20350,20350,'Cave Fang Spider',0,'',0,'LineageMonster.giant_spider',26.00,25.50,16,'male','L2Monster',40,417,174,3.95,1.21,40,43,30,21,20,10,485,20,44,72,15,64,278,500,333,0,0,0,0,72,130,0,0,'LAST_HIT','false'),
(20351,20351,'Dre Vanul Tracker',0,'',0,'LineageMonster.dre_vanul',14.00,36.00,20,'male','L2Monster',40,541,213,3.95,1.21,40,43,30,21,20,10,605,27,63,86,23,76,278,500,333,0,0,0,0,88,88,0,0,'LAST_HIT','false'),
(20352,20352,'Dre Vanul Slayer',0,'',0,'LineageMonster.dre_vanul',14.00,36.00,22,'male','L2Monster',40,611,242,5.53,1.53,40,43,30,21,20,10,767,36,75,93,28,83,278,500,333,0,0,0,0,88,88,0,0,'LAST_HIT','false'),
(20353,20353,'Dre Vanul Beholder',0,'',0,'LineageMonster.dre_vanul',14.00,36.00,21,'male','L2Monster',40,575,227,5.53,1.53,40,43,30,21,20,10,649,30,69,89,25,80,278,500,333,0,0,0,0,88,88,0,0,'LAST_HIT','false'),
(20354,20354,'Dwarf Ghost',0,'',0,'LineageMonster.dwarf_ghost',9.00,16.50,20,'male','L2Monster',40,541,213,3.95,1.21,40,43,30,21,20,10,605,27,63,86,23,76,278,500,333,0,0,0,0,88,154,1,0,'LAST_HIT','false'),
(20356,20356,'Langk Lizardman Leader',0,'',0,'LineageMonster.virud_lizardman_warrior_bi',12.00,34.50,25,'male','L2Monster',40,728,287,5.53,1.53,40,43,30,21,20,10,1012,51,80,127,37,94,278,500,333,16,0,0,0,57,143,0,0,'LAST_HIT','true'),
(20357,20357,'Langk Lizardman Lieutenant',0,'',0,'LineageMonster.virud_lizardman_warrior',12.00,30.00,22,'male','L2Monster',40,611,242,5.53,1.53,40,43,30,21,20,10,821,39,62,113,28,83,278,0,333,16,0,0,0,57,143,0,0,'LAST_HIT','true'),
(20358,20358,'Ratman Hunter',0,'',0,'LineageMonster.wererat',14.00,25.00,18,'male','L2Monster',40,476,193,3.95,1.21,40,43,30,21,20,10,640,28,38,95,19,70,317,0,333,11,0,0,0,88,132,0,0,'LAST_HIT','true'),
(20359,20359,'Ratman Warrior',0,'',0,'LineageMonster.wererat',14.00,25.00,19,'male','L2Monster',40,508,203,3.95,1.21,40,43,30,21,20,10,678,30,58,82,21,73,278,0,333,2,0,0,0,88,132,0,0,'LAST_HIT','true'),
(20360,20360,'Ratman Spy',0,'',0,'LineageMonster.wererat_sm',12.00,18.70,16,'male','L2Monster',40,417,174,3.95,1.21,40,43,30,21,20,10,570,23,39,72,15,64,317,0,333,12,0,0,0,88,132,0,0,'LAST_HIT','true'),
(20361,20361,'Tunath Orc Marksman',0,'',0,'LineageMonster.orc_archer',14.00,25.00,10,'male','L2Monster',500,257,120,3.16,0.91,40,43,30,21,20,10,305,10,51,61,8,49,249,0,333,14,0,0,0,49,121,0,0,'LAST_HIT','false'),
(20362,20362,'Tunath Orc Warrior',0,'',0,'LineageMonster.orc_fighter',12.00,22.00,12,'male','L2Monster',40,315,138,3.95,1.21,40,43,30,21,20,10,363,13,25,73,10,54,278,500,333,2,0,0,0,49,121,0,0,'LAST_HIT','false'),
(20363,20363,'Maraku Werewolf',0,'',0,'LineageMonster.werewolf',10.00,26.00,9,'male','L2Monster',40,226,111,3.16,0.91,40,43,30,21,20,10,321,11,22,53,7,47,278,0,333,0,0,0,0,50,120,0,0,'LAST_HIT','true'),
(20364,20364,'Maraku Werewolf Chieftain',0,'',0,'LineageMonster.werewolf_bi',11.00,29.70,14,'male','L2Monster',40,364,156,3.95,1.21,40,43,30,21,20,10,508,20,32,66,12,59,317,500,333,217,0,0,0,55,132,0,0,'LAST_HIT','true'),
(20365,20365,'Mountain Fungus',0,'',0,'LineageMonster.walking_fungus',15.00,22.50,8,'male','L2Monster',40,197,102,3.16,0.91,40,43,30,21,20,10,284,10,20,50,6,45,278,0,333,0,0,0,0,70,110,0,0,'LAST_HIT','true'),
(20367,20367,'Merkenis Escort',0,'',0,'LineageMonster.spartoi',11.00,27.00,20,'male','L2Minion',40,541,213,3.95,1.21,40,43,30,21,20,10,605,27,52,104,23,76,278,500,333,68,0,0,0,60,140,1,0,'LAST_HIT','false'),
(20368,20368,'Grave Keeper',0,'',0,'LineageMonster.stone_golem',20.00,31.00,13,'male','L2Monster',40,339,147,3.95,1.21,40,43,30,21,20,10,545,21,27,77,11,56,278,0,333,0,0,0,0,25,25,0,0,'LAST_HIT','false'),
(20369,20369,'Moonstone Beast',0,'',0,'LineageMonster.onyx_beast',14.00,14.50,17,'male','L2Monster',40,446,184,3.95,1.21,40,43,30,21,20,10,599,25,48,75,17,67,278,0,333,0,0,0,0,33,132,0,0,'LAST_HIT','true'),
(20370,20370,'Barbed Bat',0,'',0,'LineageMonster.vampire_bat',10.00,33.50,12,'male','L2Monster',40,315,138,3.95,1.21,40,43,30,21,20,10,427,16,30,60,10,54,278,0,333,0,0,0,0,66,88,0,0,'LAST_HIT','true'),
(20371,20371,'Mist Terror',0,'',0,'LineageMonster.dark_horror',20.00,35.00,15,'male','L2Monster',40,390,165,3.95,1.21,40,43,30,21,20,10,454,19,40,69,14,62,278,500,333,0,0,0,0,110,110,1,0,'LAST_HIT','false'),
(20372,20372,'Baraq Orc Fighter',0,'',0,'LineageMonster.orc_fighter',12.00,22.00,10,'male','L2Monster',40,257,120,3.16,0.91,40,43,30,21,20,10,302,10,25,55,8,49,278,500,333,2,0,0,0,49,121,0,0,'LAST_HIT','false'),
(20373,20373,'Baraq Orc Warrior Leader',0,'',0,'LineageMonster.orc_fighter',12.00,22.00,11,'male','L2Monster',40,292,129,3.95,1.21,40,43,30,21,20,10,326,12,27,58,9,52,278,0,333,2,0,0,0,49,121,0,0,'LAST_HIT','false'),
(20374,20374,'Baranka\'s Guard',0,'',0,'LineageMonster.spartoi',11.00,27.00,22,'male','L2Monster',40,611,242,5.53,1.53,40,43,30,21,20,10,910,43,62,113,28,83,278,500,333,68,0,0,0,66,154,1,0,'LAST_HIT','false'),
(20375,20375,'Baranka\'s Escort',0,'',0,'LineageMonster.spartoi',11.00,27.00,21,'male','L2Monster',40,575,227,5.53,1.53,40,43,30,21,20,10,649,30,50,108,25,80,317,500,333,946,0,0,0,66,154,1,0,'LAST_HIT','false'),
(20376,20376,'Varikan Brigand Leader',0,'',0,'LineageMonster.goblin_bi',10.00,21.40,10,'male','L2Monster',40,257,120,6.32,0.91,40,43,30,21,20,10,503,17,22,61,8,49,278,500,333,12,0,0,0,44,121,0,0,'LAST_HIT','false'),
(20377,20377,'Varika\'s Bandit',0,'',0,'LineageMonster.goblin',10.00,16.50,7,'male','L2Minion',40,171,94,1.58,0.91,40,43,30,21,20,10,334,12,20,44,6,43,278,0,333,0,0,0,0,44,121,0,0,'LAST_HIT','false'),
(20378,20378,'Stone Giant',0,'',0,'LineageMonster.stone_golem',20.00,31.00,13,'male','L2Monster',40,339,147,3.95,1.21,40,43,30,21,20,10,545,21,27,77,11,56,278,0,333,0,0,0,0,25,25,0,0,'LAST_HIT','false'),
(20379,20379,'Stone Soldier',0,'',0,'LineageMonster.stone_golem',20.00,31.00,14,'male','L2Monster',40,364,156,3.95,1.21,40,43,30,21,20,10,705,27,30,80,12,59,278,0,333,0,0,0,0,23,23,0,0,'LAST_HIT','true'),
(20380,20380,'Stone Guardian',0,'',0,'LineageMonster.stone_golem',20.00,31.00,16,'male','L2Monster',40,417,174,3.95,1.21,40,43,30,21,20,10,807,33,36,87,15,64,278,0,333,0,0,0,0,25,25,0,0,'LAST_HIT','true'),
(20381,20381,'Vaiss Orc',0,'',0,'LineageMonster.orc',10.00,21.00,10,'male','L2Monster',40,257,120,3.16,0.91,40,43,30,21,20,10,296,10,22,61,8,49,278,0,333,156,0,0,0,49,121,0,0,'LAST_HIT','false'),
(20382,20382,'Vaiss Orc Warrior Leader',0,'',0,'LineageMonster.orc_fighter',12.00,22.00,11,'male','L2Monster',40,292,129,3.95,1.21,40,43,30,21,20,10,326,12,27,58,9,52,278,0,333,2,0,0,0,49,121,0,0,'LAST_HIT','false'),
(20383,20383,'Arachnid Hunter',0,'',0,'LineageMonster.binding',12.00,21.00,30,'male','L2Monster',40,954,365,5.53,1.53,40,43,30,21,20,10,1223,67,120,155,58,114,278,500,333,0,0,0,0,11,154,1,0,'LAST_HIT','false'),
(20385,20385,'Balor Orc Archer',0,'',0,'LineageMonster.orc_archer',14.00,25.00,8,'male','L2Monster',500,197,102,3.16,0.91,40,43,30,21,20,10,293,10,41,55,6,45,247,0,333,14,0,0,0,45,110,0,0,'LAST_HIT','true'),
(20386,20386,'Balor Orc Fighter',0,'',0,'LineageMonster.orc_fighter',12.00,22.00,10,'male','L2Monster',40,257,120,3.16,0.91,40,43,30,21,20,10,363,12,25,55,8,49,278,500,333,2,0,0,0,45,110,0,0,'LAST_HIT','true'),
(20387,20387,'Balor Orc Fighter Leader',0,'',0,'LineageMonster.orc_fighter',12.00,22.00,12,'male','L2Monster',40,315,138,3.95,1.21,40,43,30,21,20,10,436,16,30,60,10,54,278,500,333,2,0,0,0,45,110,0,0,'LAST_HIT','true'),
(20388,20388,'Balor Orc Lieutenant',0,'',0,'LineageMonster.orc_fighter',12.00,22.00,11,'male','L2Monster',40,292,129,3.95,1.21,40,43,30,21,20,10,391,15,27,58,9,52,278,0,333,2,0,0,0,45,110,0,0,'LAST_HIT','true'),
(20389,20389,'Boogle Ratman',0,'',0,'LineageMonster.wererat',14.00,25.00,16,'male','L2Monster',40,417,174,3.95,1.21,40,43,30,21,20,10,475,19,39,72,15,64,317,0,333,12,0,0,0,88,132,0,0,'LAST_HIT','false'),
(20390,20390,'Boogle Ratman Leader',0,'',0,'LineageMonster.wererat',14.00,25.00,18,'male','L2Monster',40,476,193,3.95,1.21,40,43,30,21,20,10,533,23,46,79,19,70,317,0,333,12,0,0,0,88,132,0,0,'LAST_HIT','false'),
(20391,20391,'Red Fox',0,'',0,'LineageMonster.fox',9.50,10.00,2,'male','L2Monster',40,75,52,3.16,0.91,40,43,30,21,20,10,58,2,10,42,3,34,278,0,333,0,0,0,0,25,121,0,0,'LAST_HIT','false'),
(20392,20392,'Redeye Bat',0,'',0,'LineageMonster.vampire_bat_bi',10.00,42.00,15,'male','L2Monster',40,390,165,3.95,1.21,40,43,30,21,20,10,534,22,40,69,14,62,278,0,333,0,0,0,0,66,88,0,0,'LAST_HIT','true'),
(20393,20393,'Red Scavenger Spider',0,'',0,'LineageMonster.giant_spider',26.00,25.50,16,'male','L2Monster',40,417,174,3.95,1.21,40,43,30,21,20,10,570,23,44,72,15,64,278,0,333,0,0,0,0,79,143,0,0,'LAST_HIT','true'),
(20394,20394,'Crimson Tarantula',0,'',0,'LineageMonster.giant_spider',26.00,25.50,15,'male','L2Monster',40,390,165,3.95,1.21,40,43,30,21,20,10,449,18,40,69,14,62,278,500,333,0,0,0,0,79,143,0,0,'LAST_HIT','false'),
(20398,20398,'Vrykolakas',0,'',0,'LineageMonster.werewolf_bi',11.00,29.70,15,'male','L2Monster',40,390,165,7.90,1.21,40,43,30,21,20,10,692,28,40,69,14,62,278,500,333,0,0,0,0,55,132,0,0,'LAST_HIT','false'),
(20399,20399,'Vrykolakas Wolfkin',0,'',0,'LineageMonster.wolf_bi',13.00,10.80,9,'male','L2Minion',40,226,111,1.58,0.91,40,43,30,21,20,10,354,12,25,48,7,47,278,0,333,0,0,0,0,26,121,0,0,'LAST_HIT','false'),
(20400,20400,'Blood Fungus',0,'',0,'LineageMonster.walking_fungus',15.00,22.50,12,'male','L2Monster',40,315,138,3.95,1.21,40,43,30,21,20,10,427,16,30,60,10,54,278,0,333,0,0,0,0,70,110,0,0,'LAST_HIT','true'),
(20401,20401,'Veelan Bugbear',0,'',0,'LineageMonster.bugbear',17.00,35.00,23,'male','L2Monster',40,648,257,5.53,1.53,40,43,30,21,20,10,878,42,68,117,31,87,278,0,333,156,0,0,0,60,143,0,0,'LAST_HIT','true'),
(20402,20402,'Veelan Bugbear Warrior',0,'',0,'LineageMonster.bugbear',17.00,35.00,24,'male','L2Monster',40,687,272,5.53,1.53,40,43,30,21,20,10,954,47,89,101,34,90,278,500,333,88,0,0,0,60,143,0,0,'LAST_HIT','true'),
(20403,20403,'Hunter Tarantula',0,'',0,'LineageMonster.giant_spider',26.00,25.50,16,'male','L2Monster',40,417,174,3.95,1.21,40,43,30,21,20,10,570,23,44,72,15,64,278,0,333,0,0,0,0,79,143,0,0,'LAST_HIT','true'),
(20404,20404,'Silent Horror',0,'',0,'LineageMonster.dark_horror',20.00,35.00,16,'male','L2Monster',40,417,174,3.95,1.21,40,43,30,21,20,10,485,20,44,72,15,64,278,500,333,0,0,0,0,110,110,1,0,'LAST_HIT','false'),
(20405,20405,'Young Brown Fox',0,'',0,'LineageMonster.fox',9.50,10.00,1,'male','L2Monster',40,62,44,3.16,0.91,40,43,30,21,20,10,29,2,10,36,3,32,278,0,333,0,0,0,0,25,121,0,0,'LAST_HIT','false'),
(20406,20406,'Young Red Fox',0,'',0,'LineageMonster.fox',9.50,10.00,1,'male','L2Monster',40,62,44,3.16,0.91,40,43,30,21,20,10,29,2,10,36,3,32,278,0,333,0,0,0,0,25,121,0,0,'LAST_HIT','false'),
(20407,20407,'Young Crimson Fox',0,'',0,'LineageMonster.fox',9.50,10.00,1,'male','L2Monster',40,62,44,3.16,0.91,40,43,30,21,20,10,29,2,10,36,3,32,278,0,333,0,0,0,0,25,121,0,0,'LAST_HIT','false'),
(20410,20410,'Scavenger Spider',0,'',0,'LineageMonster.giant_spider',26.00,25.50,15,'male','L2Monster',40,390,165,3.95,1.21,40,43,30,21,20,10,545,22,40,69,14,62,278,500,333,0,0,0,0,79,143,0,0,'LAST_HIT','true'),
(20411,20411,'Scavenger Bat',0,'',0,'LineageMonster.vampire_bat',10.00,33.50,18,'male','L2Monster',40,476,193,3.95,1.21,40,43,30,21,20,10,640,28,53,79,19,70,278,0,333,0,0,0,0,66,88,0,0,'LAST_HIT','true'),
(20412,20412,'Susceptor',0,'',0,'LineageMonster.susceptor',20.00,35.00,49,'male','L2Monster',40,2168,799,8.69,2.14,40,43,30,21,20,10,2910,215,437,297,247,219,278,500,333,0,0,0,0,29,191,0,0,'LAST_HIT','false'),
(20415,20415,'Scarlet Salamander',0,'',0,'LineageMonster.salamander',16.00,6.80,17,'male','L2Monster',40,446,184,3.95,1.21,40,43,30,21,20,10,555,23,48,75,17,67,278,0,333,0,0,0,0,70,105,0,0,'LAST_HIT','false'),
(20416,20416,'Scarlet Salamander Elder',0,'',0,'LineageMonster.salamander',16.00,6.80,18,'male','L2Monster',40,476,193,3.95,1.21,40,43,30,21,20,10,586,26,53,79,19,70,278,0,333,0,0,0,0,70,105,0,0,'LAST_HIT','false'),
(20418,20418,'Crystalline Beast',0,'',0,'LineageMonster.onyx_beast',14.00,14.50,18,'male','L2Monster',40,476,193,3.95,1.21,40,43,30,21,20,10,633,28,53,79,19,70,278,0,333,0,0,0,0,33,132,0,0,'LAST_HIT','true'),
(20419,20419,'Akaste Succubus',0,'',0,'LineageMonster.succubus',10.00,36.00,20,'female','L2Monster',40,541,213,3.95,1.21,40,43,30,21,20,10,605,27,63,86,23,76,278,500,333,0,0,0,0,66,110,0,0,'LAST_HIT','false'),
(20420,20420,'Akaste Succubus Turen',0,'',0,'LineageMonster.succubus',10.00,36.00,21,'female','L2Monster',40,575,227,5.53,1.53,40,43,30,21,20,10,649,30,69,89,25,80,278,500,333,0,0,0,0,66,110,0,0,'LAST_HIT','false'),
(20421,20421,'Akaste Succubus Tilfo',0,'',0,'LineageMonster.succubus_bi',10.00,43.20,22,'female','L2Monster',40,611,242,5.53,1.53,40,43,30,21,20,10,698,33,75,93,28,83,278,500,333,0,0,0,0,66,110,0,0,'LAST_HIT','false'),
(20422,20422,'Akaste Bone Warlord',0,'',0,'LineageMonster.skeleton',11.00,25.00,17,'male','L2Monster',40,446,184,3.95,1.21,40,43,30,21,20,10,612,26,48,75,17,67,278,500,333,2,18,0,0,66,154,1,0,'LAST_HIT','false'),
(20423,20423,'Akaste Bone Archer',0,'',0,'LineageMonster.skeleton_archer',11.00,27.00,14,'male','L2Monster',500,364,156,3.95,1.21,40,43,30,21,20,10,428,17,68,80,12,59,249,0,333,275,0,0,0,44,154,1,0,'LAST_HIT','false'),
(20424,20424,'Akaste Bone Lord',0,'',0,'LineageMonster.skeleton',11.00,25.00,19,'male','L2Monster',40,508,203,3.95,1.21,40,43,30,21,20,10,592,26,58,82,21,73,278,500,333,68,19,0,0,66,154,1,0,'LAST_HIT','false'),
(20425,20425,'Akaste Bone Soldier',0,'',0,'LineageMonster.skeleton',11.00,25.00,12,'male','L2Monster',40,315,138,3.95,1.21,40,43,30,21,20,10,363,13,26,60,10,54,317,500,333,946,0,0,0,66,154,1,0,'LAST_HIT','false'),
(20426,20426,'Evil Eye',0,'',0,'LineageMonster.monster_eye',21.00,43.00,10,'male','L2Monster',40,257,120,3.16,0.91,40,43,30,21,20,10,356,12,20,67,8,49,278,0,333,0,0,0,0,90,134,0,0,'LAST_HIT','true'),
(20427,20427,'Evil Eye Watcher',0,'',0,'LineageMonster.monster_eye',21.00,43.00,10,'male','L2Monster',40,257,120,3.16,0.91,40,43,30,21,20,10,296,10,20,67,8,49,278,0,333,0,0,0,0,99,147,0,0,'LAST_HIT','false'),
(20428,20428,'Evil Eye Patroller',0,'',0,'LineageMonster.monster_eye',21.00,43.00,14,'male','L2Monster',40,364,156,3.95,1.21,40,43,30,21,20,10,498,19,30,80,12,59,278,0,333,0,0,0,0,99,147,0,0,'LAST_HIT','true'),
(20429,20429,'Evil Eye Lookout',0,'',0,'LineageMonster.monster_eye',21.00,43.00,14,'male','L2Monster',40,364,156,3.95,1.21,40,43,30,21,20,10,415,16,30,80,12,59,278,0,333,0,0,0,0,99,147,0,0,'LAST_HIT','false'),
(20431,20431,'Elf Ghost',0,'',0,'LineageMonster.elf_ghost',7.00,21.00,20,'male','L2Monster',40,541,213,3.95,1.21,40,43,30,21,20,10,605,27,52,104,23,76,278,500,333,0,0,0,0,88,154,1,0,'LAST_HIT','false'),
(20432,20432,'Elpy',0,'',0,'LineageMonster.elpy',5.00,4.00,1,'male','L2Monster',40,62,44,3.16,0.91,40,43,30,21,20,10,35,2,9,39,3,32,278,0,333,0,0,0,0,55,88,0,0,'LAST_HIT','true'),
(20433,20433,'Festering Bat',0,'',0,'LineageMonster.vampire_bat',10.00,33.50,13,'male','L2Monster',40,339,147,3.95,1.21,40,43,30,21,20,10,462,18,33,63,11,56,278,0,333,0,0,0,0,60,80,0,0,'LAST_HIT','true'),
(20435,20435,'Opal Beast',0,'',0,'LineageMonster.onyx_beast',14.00,14.50,15,'male','L2Monster',40,390,165,3.95,1.21,40,43,30,21,20,10,449,18,40,69,14,62,278,500,333,0,0,0,0,33,132,0,0,'LAST_HIT','false'),
(20436,20436,'Ol Mahum Supplier',0,'',0,'LineageMonster.ol_mahum_bi',14.00,29.20,23,'male','L2Monster',40,648,257,5.53,1.53,40,43,30,21,20,10,878,42,68,117,31,87,278,0,333,2,19,0,0,50,110,0,0,'LAST_HIT','true'),
(20437,20437,'Ol Mahum Recruit',0,'',0,'LineageMonster.ol_mahum',13.50,25.00,21,'male','L2Monster',40,575,227,5.53,1.53,40,43,30,21,20,10,764,35,57,108,25,80,278,0,333,68,19,0,0,50,110,0,0,'LAST_HIT','true'),
(20438,20438,'Ol Mahum General',0,'',0,'LineageMonster.ol_mahum_champion',14.00,27.00,26,'male','L2Monster',40,770,303,5.53,1.53,40,43,30,21,20,10,1078,54,105,109,41,98,278,500,333,67,102,0,0,50,110,0,0,'LAST_HIT','true'),
(20439,20439,'Ol Mahum Officer',0,'',0,'LineageMonster.ol_mahum',13.50,25.00,24,'male','L2Monster',40,687,272,5.53,1.53,40,43,30,21,20,10,935,46,74,122,34,90,278,0,333,66,0,0,0,50,110,0,0,'LAST_HIT','true'),
(20440,20440,'Elder Brown Fox',0,'',0,'LineageMonster.fox',9.50,10.00,3,'male','L2Monster',40,90,60,3.16,0.91,40,43,30,21,20,10,88,2,12,40,3,35,278,0,333,0,0,0,0,25,121,0,0,'LAST_HIT','false'),
(20441,20441,'Elder Longtail Fox',0,'',0,'LineageMonster.fox',9.50,10.00,3,'male','L2Monster',40,90,60,3.16,0.91,40,43,30,21,20,10,88,2,12,40,3,35,278,0,333,0,0,0,0,25,121,0,0,'LAST_HIT','false'),
(20442,20442,'Elder Wolf',0,'',0,'LineageMonster.wolf',13.00,9.00,5,'male','L2Monster',40,126,77,3.16,0.91,40,43,30,21,20,10,176,5,13,48,4,39,278,0,333,0,0,0,0,24,110,0,0,'LAST_HIT','true'),
(20443,20443,'Elder Red Fox',0,'',0,'LineageMonster.fox',9.50,10.00,3,'male','L2Monster',40,90,60,3.16,0.91,40,43,30,21,20,10,88,2,12,40,3,35,278,0,333,0,0,0,0,25,121,0,0,'LAST_HIT','false'),
(20444,20444,'Elder Prairie Fox',0,'',0,'LineageMonster.fox',9.50,10.00,3,'male','L2Monster',40,90,60,3.16,0.91,40,43,30,21,20,10,88,2,12,40,3,35,278,0,333,0,0,0,0,25,121,0,0,'LAST_HIT','false'),
(20445,20445,'Uthanka Pirate',0,'',0,'LineageMonster.orc',10.00,21.00,7,'male','L2Minion',40,171,94,1.58,0.91,40,43,30,21,20,10,307,10,20,44,6,43,278,0,333,3,0,0,0,49,121,0,0,'LAST_HIT','false'),
(20446,20446,'Utuku Orc',0,'',0,'LineageMonster.orc',10.00,21.00,6,'male','L2Monster',40,147,85,3.16,0.91,40,43,30,21,20,10,213,6,15,50,5,41,278,0,333,156,0,0,0,49,121,0,0,'LAST_HIT','true'),
(20447,20447,'Utuku Orc Archer',0,'',0,'LineageMonster.orc_archer',14.00,25.00,8,'male','L2Monster',500,197,102,3.16,0.91,40,43,30,21,20,10,293,10,41,55,6,45,249,0,333,14,0,0,0,49,121,0,0,'LAST_HIT','true'),
(20448,20448,'Utuku Orc Grunt',0,'',0,'LineageMonster.orc',10.00,21.00,7,'male','L2Monster',40,171,94,3.16,0.91,40,43,30,21,20,10,249,8,17,53,6,43,278,0,333,3,0,0,0,49,121,0,0,'LAST_HIT','true'),
(20449,20449,'Will-O-Wisp',0,'',0,'LineageMonster.will_o_wisp',13.00,22.00,15,'male','L2Monster',40,390,165,3.95,1.21,40,43,30,21,20,10,533,22,40,69,14,62,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(20450,20450,'Relic Werewolf',0,'',0,'LineageMonster.werewolf',10.00,26.00,9,'male','L2Monster',40,226,111,3.16,0.91,40,43,30,21,20,10,267,9,22,53,7,47,278,0,333,0,0,0,0,55,132,0,0,'LAST_HIT','false'),
(20451,20451,'Relic Spartoi',0,'',0,'LineageMonster.spartoi',11.00,27.00,21,'male','L2Monster',40,575,227,11.06,1.53,40,43,30,21,20,10,592,27,57,108,25,80,278,0,333,68,0,0,0,66,154,1,0,'LAST_HIT','false'),
(20453,20453,'Human Ghost',0,'',0,'LineageMonster.human_ghost',8.00,22.00,20,'male','L2Monster',40,541,213,3.95,1.21,40,43,30,21,20,10,605,27,52,104,23,76,278,500,333,0,0,0,0,88,154,1,0,'LAST_HIT','false'),
(20454,20454,'Oblivion Watcher',0,'',0,'LineageMonster.monster_eye',21.00,43.00,17,'male','L2Minion',40,446,184,1.98,1.21,40,43,30,21,20,10,454,20,53,68,17,67,278,0,333,0,0,0,0,99,99,0,0,'LAST_HIT','false'),
(20455,20455,'Doom Soldier',0,'',0,'LineageMonster.skeleton',11.00,25.00,14,'male','L2Monster',40,364,156,3.95,1.21,40,43,30,21,20,10,424,16,32,66,12,59,317,500,333,946,0,0,0,60,140,1,0,'LAST_HIT','false'),
(20456,20456,'Ashen Wolf',0,'',0,'LineageMonster.wolf',13.00,9.00,4,'male','L2Monster',40,107,68,3.16,0.91,40,43,30,21,20,10,141,4,12,46,4,37,278,0,333,0,0,0,0,24,110,0,0,'LAST_HIT','true'),
(20457,20457,'Zombie Soldier',0,'',0,'LineageMonster.zombie',13.00,21.00,19,'male','L2Monster',40,508,203,3.95,1.21,40,43,30,21,20,10,958,43,58,82,21,73,278,0,333,0,0,0,0,16,16,1,0,'LAST_HIT','true'),
(20458,20458,'Zombie Warrior',0,'',0,'LineageMonster.zombie_bi',12.00,27.50,22,'male','L2Monster',40,611,242,5.53,1.53,40,43,30,21,20,10,1184,56,75,93,28,83,278,500,333,0,0,0,0,16,16,1,0,'LAST_HIT','true'),
(20460,20460,'Crimson Spider',0,'',0,'LineageMonster.giant_spider',26.00,25.50,15,'male','L2Monster',40,390,165,3.95,1.21,40,43,30,21,20,10,545,22,40,69,14,62,278,500,333,0,0,0,0,79,143,0,0,'LAST_HIT','true'),
(20461,20461,'Dungeon Spider',0,'',0,'LineageMonster.giant_spider',26.00,25.50,15,'male','L2Monster',40,390,165,3.95,1.21,40,43,30,21,20,10,454,19,40,69,14,62,278,500,333,0,0,0,0,79,143,0,0,'LAST_HIT','false'),
(20462,20462,'Cave Blade Spider',0,'',0,'LineageMonster.giant_spider',26.00,25.50,17,'male','L2Monster',40,446,184,3.95,1.21,40,43,30,21,20,10,515,22,48,75,17,67,278,500,333,0,0,0,0,79,143,0,0,'LAST_HIT','false'),
(20463,20463,'Dungeon Skeleton Archer',0,'',0,'LineageMonster.skeleton_archer',11.00,27.00,13,'male','L2Monster',500,339,147,3.95,1.21,40,43,30,21,20,10,397,16,61,77,11,56,249,0,333,275,0,0,0,44,154,1,0,'LAST_HIT','false'),
(20464,20464,'Dungeon Skeleton',0,'',0,'LineageMonster.skeleton',11.00,25.00,12,'male','L2Monster',40,315,138,3.95,1.21,40,43,30,21,20,10,363,13,26,60,10,54,317,500,333,946,0,0,0,66,154,1,0,'LAST_HIT','false'),
(20465,20465,'Prairie Fox',0,'',0,'LineageMonster.fox',9.50,10.00,2,'male','L2Monster',40,75,52,3.16,0.91,40,43,30,21,20,10,58,2,11,38,3,34,278,0,333,0,0,0,0,25,121,0,0,'LAST_HIT','false'),
(20466,20466,'Pincer Spider',0,'',0,'LineageMonster.giant_spider',26.00,25.50,17,'male','L2Monster',40,446,184,3.95,1.21,40,43,30,21,20,10,618,26,48,75,17,67,278,500,333,0,0,0,0,79,143,0,0,'LAST_HIT','true'),
(20468,20468,'Kaboo Orc',0,'',0,'LineageMonster.orc',10.00,21.00,6,'male','L2Monster',40,147,85,3.16,0.91,40,43,30,21,20,10,213,6,15,50,5,41,278,0,333,156,0,0,0,49,121,0,0,'LAST_HIT','true'),
(20469,20469,'Kaboo Orc Archer',0,'',0,'LineageMonster.orc_archer',14.00,25.00,8,'male','L2Monster',500,197,102,3.16,0.91,40,43,30,21,20,10,293,10,41,55,6,45,247,0,333,14,0,0,0,45,110,0,0,'LAST_HIT','true'),
(20470,20470,'Kaboo Orc Grunt',0,'',0,'LineageMonster.orc',10.00,21.00,7,'male','L2Monster',40,171,94,3.16,0.91,40,43,30,21,20,10,249,8,17,53,6,43,278,0,333,3,0,0,0,45,110,0,0,'LAST_HIT','true'),
(20471,20471,'Kaboo Orc Fighter',0,'',0,'LineageMonster.orc_fighter',12.00,22.00,10,'male','L2Monster',40,257,120,3.16,0.91,40,43,30,21,20,10,363,12,20,67,8,49,278,500,333,2,0,0,0,49,121,0,0,'LAST_HIT','true'),
(20472,20472,'Kaboo Orc Fighter Leader',0,'',0,'LineageMonster.orc_fighter',12.00,22.00,12,'male','L2Monster',40,315,138,3.95,1.21,40,43,30,21,20,10,436,16,25,73,10,54,278,500,333,2,0,0,0,49,121,0,0,'LAST_HIT','true'),
(20473,20473,'Kaboo Orc Fighter Lieutenant',0,'',0,'LineageMonster.orc_fighter',12.00,22.00,11,'male','L2Monster',40,292,129,3.95,1.21,40,43,30,21,20,10,391,15,23,70,9,52,278,0,333,2,0,0,0,49,121,0,0,'LAST_HIT','true'),
(20474,20474,'Kasha Spider',0,'',0,'LineageMonster.giant_spider',26.00,25.50,15,'male','L2Monster',40,390,165,3.95,1.21,40,43,30,21,20,10,534,22,40,69,14,62,278,0,333,0,0,0,0,79,143,0,0,'LAST_HIT','true'),
(20475,20475,'Kasha Wolf',0,'',0,'LineageMonster.wolf',13.00,9.00,4,'male','L2Monster',40,107,68,3.16,0.91,40,43,30,21,20,10,141,4,12,46,4,37,278,0,333,0,0,0,0,24,110,0,0,'LAST_HIT','true'),
(20476,20476,'Kasha Fang Spider',0,'',0,'LineageMonster.giant_spider',26.00,25.50,16,'male','L2Monster',40,417,174,3.95,1.21,40,43,30,21,20,10,570,23,44,72,15,64,278,0,333,0,0,0,0,79,143,0,0,'LAST_HIT','true'),
(20477,20477,'Kasha Timber Wolf',0,'',0,'LineageMonster.wolf_bi',13.00,10.80,6,'male','L2Monster',40,147,85,3.16,0.91,40,43,30,21,20,10,211,6,15,50,5,41,278,0,333,0,0,0,0,24,110,0,0,'LAST_HIT','true'),
(20478,20478,'Kasha Blade Spider',0,'',0,'LineageMonster.giant_spider',26.00,25.50,17,'male','L2Monster',40,446,184,3.95,1.21,40,43,30,21,20,10,666,28,48,75,17,67,278,0,333,0,0,0,0,79,143,0,0,'LAST_HIT','true'),
(20479,20479,'Kasha Bear',0,'',0,'LineageMonster.grizzly_bi',21.00,50.00,15,'male','L2Monster',40,390,165,3.95,1.21,40,43,30,21,20,10,539,22,33,84,14,62,278,500,333,0,0,0,0,44,121,0,0,'LAST_HIT','true'),
(20480,20480,'Blade Bat',0,'',0,'LineageMonster.vampire_bat',10.00,33.50,10,'male','L2Monster',40,257,120,3.16,0.91,40,43,30,21,20,10,356,12,25,55,8,49,278,0,333,0,0,0,0,66,88,0,0,'LAST_HIT','true'),
(20481,20481,'Bearded Keltir',0,'',0,'LineageMonster.keltir',9.50,10.00,1,'male','L2Monster',40,62,44,3.16,0.91,40,43,30,21,20,10,35,2,9,39,3,32,278,0,333,0,0,0,0,23,60,0,0,'LAST_HIT','true'),
(20483,20483,'Corpse Candle',0,'',0,'LineageMonster.will_o_wisp',13.00,22.00,17,'male','L2Monster',40,446,184,3.95,1.21,40,43,30,21,20,10,604,25,40,91,17,67,278,0,333,0,0,0,0,88,154,0,0,'LAST_HIT','false'),
(20487,20487,'Kuruka Ratman',0,'',0,'LineageMonster.wererat',14.00,25.00,16,'male','L2Monster',40,417,174,3.95,1.21,40,43,30,21,20,10,475,19,32,87,15,64,317,0,333,216,0,0,0,88,132,0,0,'LAST_HIT','false'),
(20488,20488,'Kuruka Ratman Hunter',0,'',0,'LineageMonster.wererat',14.00,25.00,17,'male','L2Monster',40,446,184,3.95,1.21,40,43,30,21,20,10,504,21,40,91,17,67,278,0,333,3,0,0,0,88,132,0,0,'LAST_HIT','false'),
(20489,20489,'Quicksilver Beast',0,'',0,'LineageMonster.onyx_beast',14.00,14.50,15,'male','L2Monster',40,390,165,3.95,1.21,40,43,30,21,20,10,449,18,40,69,14,62,278,500,333,0,0,0,0,33,132,0,0,'LAST_HIT','false'),
(20490,20490,'Death Doll',0,'',0,'LineageMonster.crimson_doll',15.00,38.00,40,'male','L2Monster',40,1527,531,7.11,1.84,40,43,30,21,20,10,2175,141,300,183,131,164,278,500,333,0,0,0,0,66,165,1,0,'LAST_HIT','false'),
(20491,20491,'Crypt Horror',0,'',0,'LineageMonster.dark_horror',20.00,35.00,15,'male','L2Monster',40,390,165,3.95,1.21,40,43,30,21,20,10,454,19,40,69,14,62,278,500,333,0,0,0,0,110,110,1,0,'LAST_HIT','false'),
(20492,20492,'Kirunak\'s Guards',0,'',0,'LineageMonster.spartoi',11.00,27.00,21,'male','L2Minion',40,575,227,5.53,1.53,40,43,30,21,20,10,636,29,57,108,25,80,278,0,333,68,0,0,0,66,154,1,0,'LAST_HIT','false'),
(20494,20494,'Turek War Hound',0,'',0,'LineageMonster.dire_wolf',13.00,11.00,24,'male','L2Monster',40,687,272,11.06,1.53,40,43,30,21,20,10,869,43,89,101,34,90,278,0,333,0,0,0,0,26,121,0,0,'LAST_HIT','false'),
(20495,20495,'Turek Orc Warlord',0,'',0,'LineageMonster.orc_champion',10.00,23.00,30,'male','L2Monster',40,954,365,11.06,1.53,40,43,30,21,20,10,1390,76,120,155,58,114,278,500,333,127,0,0,0,49,143,0,0,'LAST_HIT','false'),
(20496,20496,'Turek Orc Archer',0,'',0,'LineageMonster.orc_archer',14.00,25.00,27,'male','L2Monster',500,813,318,11.06,1.53,40,43,30,21,20,10,1076,55,231,125,45,102,249,0,333,14,0,0,0,49,121,0,0,'LAST_HIT','false'),
(20497,20497,'Turek Orc Skirmisher',0,'',0,'LineageMonster.orc_fighter',12.00,22.00,28,'male','L2Monster',40,859,334,11.06,1.53,40,43,30,21,20,10,1117,58,102,143,49,106,278,500,333,121,0,0,0,49,121,0,0,'LAST_HIT','false'),
(20498,20498,'Turek Orc Supplier',0,'',0,'LineageMonster.orc_fighter',12.00,22.00,27,'male','L2Monster',40,813,318,11.06,1.53,40,43,30,21,20,10,1035,53,83,138,45,102,317,0,333,11,0,0,0,49,121,0,0,'LAST_HIT','false'),
(20499,20499,'Turek Orc Footman',0,'',0,'LineageMonster.orc',10.00,21.00,26,'male','L2Monster',40,770,303,11.06,1.53,40,43,30,21,20,10,982,49,96,120,41,98,278,0,333,2,0,0,0,49,121,0,0,'LAST_HIT','false'),
(20500,20500,'Turek Orc Sentinel',0,'',0,'LineageMonster.orc',10.00,21.00,25,'male','L2Monster',40,728,287,11.06,1.53,40,43,30,21,20,10,922,46,88,116,37,94,278,0,333,3,0,0,0,49,121,0,0,'LAST_HIT','false'),
(20501,20501,'Turek Orc Shaman',0,'',0,'LineageMonster.orc_shaman',9.00,22.00,29,'male','L2Monster',40,906,349,11.06,1.53,40,43,30,21,20,10,1156,62,111,149,53,110,278,0,333,7,0,0,0,49,132,0,0,'LAST_HIT','false'),
(20502,20502,'Twink Puma',0,'',0,'LineageMonster.onyx_beast',14.00,14.50,15,'male','L2Monster',40,390,165,3.95,1.21,40,43,30,21,20,10,539,22,40,69,14,62,278,500,333,0,0,0,0,33,132,0,0,'LAST_HIT','true'),
(20504,20504,'Dread Soldier',0,'',0,'LineageMonster.skeleton',11.00,25.00,14,'male','L2Monster',40,364,156,3.95,1.21,40,43,30,21,20,10,424,16,32,66,12,59,317,500,333,946,0,0,0,66,154,1,0,'LAST_HIT','false'),
(20505,20505,'Ruin Bat',0,'',0,'LineageMonster.vampire_bat_bi',10.00,42.00,20,'male','L2Monster',40,541,213,3.95,1.21,40,43,30,21,20,10,712,32,63,86,23,76,278,0,333,0,0,0,0,66,88,0,0,'LAST_HIT','true'),
(20506,20506,'Ruin Imp',0,'',0,'LineageMonster.imp_bi',10.00,30.00,17,'male','L2Monster',40,446,184,3.95,1.21,40,43,30,21,20,10,605,25,48,75,17,67,278,0,333,0,0,0,0,66,88,0,0,'LAST_HIT','true'),
(20507,20507,'Ruin Imp Elder',0,'',0,'LineageMonster.imp_bi',10.00,30.00,21,'male','L2Monster',40,575,227,5.53,1.53,40,43,30,21,20,10,779,36,69,89,25,80,278,500,333,0,0,0,0,66,88,0,0,'LAST_HIT','true'),
(20508,20508,'Plunder Tarantula',0,'',0,'LineageMonster.giant_spider',26.00,25.50,17,'male','L2Monster',40,446,184,3.95,1.21,40,43,30,21,20,10,618,26,48,75,17,67,278,500,333,0,0,0,0,79,143,0,0,'LAST_HIT','true'),
(20509,20509,'Spore Fungus',0,'',0,'LineageMonster.walking_fungus',15.00,22.50,9,'male','L2Monster',40,226,111,3.16,0.91,40,43,30,21,20,10,321,11,22,53,7,47,278,0,333,0,0,0,0,77,121,0,0,'LAST_HIT','true'),
(20510,20510,'Puma',0,'',0,'LineageMonster.onyx_beast',14.00,14.50,12,'male','L2Monster',40,315,138,3.95,1.21,40,43,30,21,20,10,423,16,30,60,10,54,278,0,333,0,0,0,0,33,132,0,0,'LAST_HIT','true'),
(20511,20511,'Pitchstone Golem',0,'',0,'LineageMonster.stone_golem',20.00,31.00,19,'male','L2Monster',40,508,203,3.95,1.21,40,43,30,21,20,10,799,36,48,99,21,73,278,0,333,0,0,0,0,25,25,0,0,'LAST_HIT','false'),
(20512,20512,'Field Stalker',0,'',0,'LineageMonster.field_stalker',15.00,30.00,35,'male','L2Monster',40,1220,446,7.11,1.84,40,43,30,21,20,10,1812,107,211,154,89,137,278,500,333,0,0,0,0,77,121,0,0,'LAST_HIT','false'),
(20513,20513,'Skeleton Knight',0,'',0,'LineageMonster.skeleton_knight',10.00,25.00,32,'male','L2Monster',40,1056,397,7.11,1.84,40,43,30,21,20,10,1265,71,140,167,69,123,278,500,333,150,0,0,0,44,176,1,0,'LAST_HIT','false'),
(20514,20514,'Shield Skeleton',0,'',0,'LineageMonster.skeleton',11.00,25.00,15,'male','L2Monster',40,390,165,3.95,1.21,40,43,30,21,20,10,534,22,40,69,14,62,278,0,333,157,103,0,0,66,154,1,0,'LAST_HIT','true'),
(20515,20515,'Skeleton Infantryman',0,'',0,'LineageMonster.skeleton',11.00,25.00,16,'male','L2Monster',40,417,174,3.95,1.21,40,43,30,21,20,10,570,23,44,72,15,64,278,0,333,157,18,0,0,66,154,1,0,'LAST_HIT','true'),
(20516,20516,'Skeleton Sentinel',0,'',0,'LineageMonster.skeleton_bi',11.00,31.00,14,'male','L2Monster',40,364,156,3.95,1.21,40,43,30,21,20,10,424,16,32,66,12,59,317,500,333,946,0,0,0,66,154,1,0,'LAST_HIT','false'),
(20517,20517,'Skeleton Hunter',0,'',0,'LineageMonster.skeleton',11.00,25.00,12,'male','L2Monster',40,315,138,3.95,1.21,40,43,30,21,20,10,363,13,26,60,10,54,317,500,333,946,0,0,0,66,154,1,0,'LAST_HIT','false'),
(20518,20518,'Skeleton Hunter Archer',0,'',0,'LineageMonster.skeleton_archer',11.00,27.00,13,'male','L2Monster',500,339,147,3.95,1.21,40,43,30,21,20,10,397,16,61,77,11,56,249,0,333,275,0,0,0,44,154,1,0,'LAST_HIT','false'),
(20519,20519,'Skeleton Pikeman',0,'',0,'LineageMonster.skeleton_pikeman',10.00,28.00,27,'male','L2Monster',40,813,318,5.53,1.53,40,43,30,21,20,10,946,48,114,114,45,102,278,500,333,299,0,0,0,55,170,1,0,'LAST_HIT','false'),
(20520,20520,'Pirate Captain Uthanka',0,'',0,'LineageMonster.orc_fighter_bi',12.00,26.40,10,'male','L2Monster',40,257,120,6.32,0.91,40,43,30,21,20,10,463,16,20,67,8,49,278,500,333,2,0,0,0,49,121,0,0,'LAST_HIT','false'),
(20521,20521,'Whinstone Golem',0,'',0,'LineageMonster.stone_golem',20.00,31.00,14,'male','L2Monster',40,364,156,3.95,1.21,40,43,30,21,20,10,705,27,30,80,12,59,278,0,333,0,0,0,0,25,25,0,0,'LAST_HIT','true'),
(20522,20522,'White Fang',0,'',0,'LineageMonster.wolf_bi',13.00,10.80,10,'male','L2Monster',40,257,120,6.32,0.91,40,43,30,21,20,10,458,15,22,61,8,49,278,500,333,0,0,0,0,26,121,0,0,'LAST_HIT','false'),
(20524,20524,'Grey Wolf Elder',0,'',0,'LineageMonster.wolf',13.00,9.00,7,'male','L2Minion',40,171,94,1.58,0.91,40,43,30,21,20,10,304,10,20,44,6,43,278,0,333,0,0,0,0,26,121,0,0,'LAST_HIT','false'),
(20525,20525,'Gray Wolf',0,'',0,'LineageMonster.wolf',13.00,9.00,4,'male','L2Monster',40,107,68,3.16,0.91,40,43,30,21,20,10,141,4,12,46,4,37,278,0,333,0,0,0,0,26,121,0,0,'LAST_HIT','true'),
(20526,20526,'Obsidian Golem',0,'',0,'LineageMonster.stone_golem',20.00,31.00,15,'male','L2Monster',40,390,165,3.95,1.21,40,43,30,21,20,10,755,31,33,84,14,62,278,0,333,0,0,0,0,25,25,0,0,'LAST_HIT','true'),
(20527,20527,'Great Snow Wolf',0,'',0,'LineageMonster.dire_wolf',13.00,11.00,4,'male','L2Monster',40,107,68,3.16,0.91,40,43,30,21,20,10,121,3,13,42,4,37,278,500,333,0,0,0,0,26,121,0,0,'LAST_HIT','false'),
(20528,20528,'Goblin Lord',0,'',0,'LineageMonster.goblin',10.00,16.50,13,'male','L2Monster',40,339,147,3.95,1.21,40,43,30,21,20,10,458,18,29,63,11,56,317,0,333,217,0,0,0,44,121,0,0,'LAST_HIT','true'),
(20529,20529,'Young Brown Keltir',0,'',0,'LineageMonster.keltir',9.50,10.00,1,'male','L2Monster',40,62,44,3.16,0.91,40,43,30,21,20,10,35,2,9,39,3,32,278,0,333,0,0,0,0,23,110,0,0,'LAST_HIT','true'),
(20530,20530,'Young Red Keltir',0,'',0,'LineageMonster.keltir',9.50,10.00,1,'male','L2Monster',40,62,44,3.16,0.91,40,43,30,21,20,10,35,2,9,39,3,32,278,0,333,0,0,0,0,23,110,0,0,'LAST_HIT','true'),
(20531,20531,'Young Prairie Keltir',0,'',0,'LineageMonster.keltir',9.50,10.00,1,'male','L2Monster',40,62,44,3.16,0.91,40,43,30,21,20,10,35,2,9,39,3,32,278,0,333,0,0,0,0,23,110,0,0,'LAST_HIT','true'),
(20532,20532,'Brown Keltir',0,'',0,'LineageMonster.keltir',9.50,10.00,2,'male','L2Monster',40,75,52,3.16,0.91,40,43,30,21,20,10,70,2,10,42,3,34,278,0,333,0,0,0,0,23,110,0,0,'LAST_HIT','true'),
(20533,20533,'Longtail Keltir',0,'',0,'LineageMonster.keltir',9.50,10.00,2,'male','L2Monster',40,75,52,3.16,0.91,40,43,30,21,20,10,70,2,10,42,3,34,278,0,333,0,0,0,0,23,110,0,0,'LAST_HIT','true'),
(20534,20534,'Red Keltir',0,'',0,'LineageMonster.keltir',9.50,10.00,2,'male','L2Monster',40,75,52,3.16,0.91,40,43,30,21,20,10,70,2,10,42,3,34,278,0,333,0,0,0,0,23,110,0,0,'LAST_HIT','true'),
(20535,20535,'Prairie Keltir',0,'',0,'LineageMonster.keltir',9.50,10.00,2,'male','L2Monster',40,75,52,3.16,0.91,40,43,30,21,20,10,70,2,10,42,3,34,278,0,333,0,0,0,0,23,110,0,0,'LAST_HIT','true'),
(20536,20536,'Elder Brown Keltir',0,'',0,'LineageMonster.keltir',9.50,10.00,3,'male','L2Monster',40,90,60,3.16,0.91,40,43,30,21,20,10,105,2,11,44,3,35,278,0,333,0,0,0,0,23,110,0,0,'LAST_HIT','true'),
(20537,20537,'Elder Red Keltir',0,'',0,'LineageMonster.keltir',9.50,10.00,3,'male','L2Monster',40,90,60,3.16,0.91,40,43,30,21,20,10,105,2,11,44,3,35,278,0,333,0,0,0,0,23,110,0,0,'LAST_HIT','true'),
(20538,20538,'Elder Prairie Keltir',0,'',0,'LineageMonster.keltir',9.50,10.00,3,'male','L2Monster',40,90,60,3.16,0.91,40,43,30,21,20,10,105,2,11,44,3,35,278,0,333,0,0,0,0,23,110,0,0,'LAST_HIT','true'),
(20539,20539,'Elder Longtail Keltir',0,'',0,'LineageMonster.keltir',9.50,10.00,3,'male','L2Monster',40,90,60,3.16,0.91,40,43,30,21,20,10,105,2,11,44,3,35,278,0,333,0,0,0,0,23,110,0,0,'LAST_HIT','true'),
(20540,20540,'Gemstone Beast',0,'',0,'LineageMonster.onyx_beast',14.00,14.50,12,'male','L2Monster',40,315,138,3.95,1.21,40,43,30,21,20,10,352,13,25,73,10,54,278,0,333,0,0,0,0,33,132,0,0,'LAST_HIT','false'),
(20541,20541,'Ore Bat',0,'',0,'LineageMonster.vampire_bat',10.00,33.50,17,'male','L2Monster',40,446,184,3.95,1.21,40,43,30,21,20,10,499,21,48,75,17,67,278,0,333,0,0,0,0,66,88,0,0,'LAST_HIT','false'),
(20542,20542,'Skeleton Longbowman',0,'',0,'LineageMonster.skeleton_archer',11.00,27.00,19,'male','L2Monster',500,508,203,3.95,1.21,40,43,30,21,20,10,587,26,129,82,21,73,249,500,333,275,0,0,0,44,154,1,0,'LAST_HIT','false'),
(20543,20543,'Ghost',0,'',0,'LineageMonster.human_ghost',8.00,22.00,20,'male','L2Monster',40,541,213,3.95,1.21,40,43,30,21,20,10,599,27,63,86,23,76,278,500,333,0,0,0,0,88,154,1,0,'LAST_HIT','false'),
(20544,20544,'Elder Keltir',0,'',0,'LineageMonster.keltir',9.50,10.00,3,'male','L2Monster',40,90,60,3.16,0.91,40,43,30,21,20,10,105,2,12,40,3,35,278,0,333,0,0,0,0,23,60,0,0,'LAST_HIT','true'),
(20545,20545,'Young Keltir',0,'',0,'LineageMonster.keltir',9.50,10.00,1,'male','L2Monster',40,62,44,3.16,0.91,40,43,30,21,20,10,35,2,9,39,3,32,278,0,333,0,0,0,0,23,60,0,0,'LAST_HIT','true'),
(20546,20546,'Turek Orc Elder',0,'',0,'LineageMonster.orc_shaman',9.00,22.00,34,'male','L2Monster',40,1164,430,7.11,1.84,40,43,30,21,20,10,1714,100,162,179,82,132,278,500,333,7,0,0,0,49,132,0,0,'LAST_HIT','false'),
(20547,20547,'Ol Mahum Reserve',0,'',0,'LineageMonster.ol_mahum_bi',14.00,29.20,23,'male','L2Monster',40,648,257,5.53,1.53,40,43,30,21,20,10,878,42,68,117,31,87,278,0,333,2,19,0,0,55,121,0,0,'LAST_HIT','true'),
(20548,20548,'Ol Mahum Deserter',0,'',0,'LineageMonster.ol_mahum',13.50,25.00,23,'male','L2Monster',40,648,257,5.53,1.53,40,43,30,21,20,10,895,43,75,107,31,87,278,500,333,2,0,0,0,55,121,0,0,'LAST_HIT','true'),
(20549,20549,'Ol Mahum Lord',0,'',0,'LineageMonster.ol_mahum_champion',14.00,27.00,34,'male','L2Monster',40,1164,430,14.22,1.84,40,43,30,21,20,10,1763,103,196,148,82,132,278,500,333,69,19,0,0,55,121,0,0,'LAST_HIT','true'),
(20550,20550,'Guardian Basilisk',0,'',0,'LineageMonster.lesser_basilisk',34.00,25.00,36,'male','L2Monster',40,1279,463,7.11,1.84,40,43,30,21,20,10,1960,118,206,175,96,142,278,0,333,0,0,0,0,35,174,0,0,'LAST_HIT','true'),
(20551,20551,'Road Scavenger',0,'',0,'LineageMonster.wererat',14.00,25.00,37,'male','L2Monster',40,1338,480,7.11,1.84,40,43,30,21,20,10,1991,122,194,154,104,147,317,0,333,221,0,0,0,80,174,0,0,'LAST_HIT','true'),
(20552,20552,'Fettered Soul',0,'',0,'LineageMonster.binding',12.00,21.00,38,'male','L2Monster',40,1400,497,14.22,1.84,40,43,30,21,20,10,2146,134,238,188,112,153,278,0,333,0,0,0,0,11,191,1,0,'LAST_HIT','true'),
(20553,20553,'Windsus',0,'',0,'LineageMonster.giant_wild_hog',35.00,27.00,39,'male','L2Monster',40,1462,514,7.11,1.84,40,43,30,21,20,10,2212,141,255,195,121,158,278,0,333,0,0,0,0,38,191,0,0,'LAST_HIT','true'),
(20554,20554,'Grandis',0,'',0,'LineageMonster.twin_headed_giant',17.00,39.00,40,'male','L2Monster',40,1527,531,7.11,1.84,40,43,30,21,20,10,2585,167,273,201,131,164,278,500,333,0,0,0,0,49,191,0,0,'LAST_HIT','true'),
(20555,20555,'Giant Fungus',0,'',0,'LineageMonster.walking_fungus_bi',15.00,31.30,40,'male','L2Monster',40,1527,531,7.11,1.84,40,43,30,21,20,10,2327,150,273,201,131,164,278,0,333,0,0,0,0,70,174,0,0,'LAST_HIT','true'),
(20556,20556,'Giant Monstereye',0,'',0,'LineageMonster.monster_eye_bi',29.00,60.00,41,'male','L2Monster',40,1593,560,8.69,2.14,40,43,30,21,20,10,2444,160,321,189,141,169,278,0,333,0,0,0,0,90,174,0,0,'LAST_HIT','true'),
(20557,20557,'Dire Wyrm',0,'',0,'LineageMonster.wyrm',29.00,72.00,42,'male','L2Monster',40,1660,589,8.69,2.14,40,43,30,21,20,10,2590,173,283,237,152,175,278,500,333,0,0,0,0,70,174,0,0,'LAST_HIT','true'),
(20558,20558,'Rotting tree',0,'',0,'LineageMonster.hanged_man_ripper',35.00,80.00,43,'male','L2Monster',40,1728,618,8.69,2.14,40,43,30,21,20,10,2662,180,302,245,163,181,278,0,333,0,0,0,0,60,191,0,0,'LAST_HIT','true'),
(20559,20559,'Rotting Golem',0,'',0,'LineageMonster.stone_golem_bi_one',22.00,43.40,44,'male','L2Monster',40,1799,648,8.69,2.14,40,43,30,21,20,10,3942,270,322,253,176,187,278,0,333,0,0,0,0,25,25,0,0,'LAST_HIT','true'),
(20560,20560,'Trisalim Spider',0,'',0,'LineageMonster.giant_spider',26.00,25.50,45,'male','L2Monster',40,1870,677,8.69,2.14,40,43,30,21,20,10,2916,203,415,216,188,193,278,0,333,0,0,0,0,79,191,0,0,'LAST_HIT','true'),
(20561,20561,'Trisalim Tarantula',0,'',0,'LineageMonster.poison_spider',27.00,25.50,46,'male','L2Monster',40,1943,707,8.69,2.14,40,43,30,21,20,10,3452,245,365,270,202,199,278,500,333,0,0,0,0,66,191,0,0,'LAST_HIT','true'),
(20562,20562,'Spore Zombie',0,'',0,'LineageMonster.zombie_bi',12.00,27.50,47,'male','L2Monster',40,2016,738,8.69,2.14,40,43,30,21,20,10,3591,257,469,230,216,206,278,0,333,0,0,0,0,16,16,1,0,'LAST_HIT','true'),
(20563,20563,'Manashen Gargoyle',0,'',0,'LineageMonster.gargoyle',16.00,50.00,40,'male','L2Monster',40,1527,531,7.11,1.84,40,43,30,21,20,10,2769,179,300,183,131,164,278,0,333,0,0,0,0,140,174,0,0,'LAST_HIT','true'),
(20564,20564,'Enchanted Monstereye',0,'',0,'LineageMonster.monster_eye',21.00,43.00,41,'male','L2Monster',40,1593,560,8.69,2.14,40,43,30,21,20,10,2493,163,321,189,141,169,278,500,333,0,0,0,0,90,174,0,0,'LAST_HIT','true'),
(20565,20565,'Enchanted Stone Golem',0,'',0,'LineageMonster.stone_golem_bi',20.00,40.30,42,'male','L2Monster',40,1660,589,8.69,2.14,40,43,30,21,20,10,3627,242,342,196,152,175,278,0,333,0,0,0,0,23,23,0,0,'LAST_HIT','true'),
(20566,20566,'Enchanted Iron Golem',0,'',0,'LineageMonster.iron_golem',18.00,34.00,43,'male','L2Monster',40,1728,618,8.69,2.14,40,43,30,21,20,10,3802,257,302,245,163,181,278,0,333,0,0,0,0,20,20,0,0,'LAST_HIT','true'),
(20567,20567,'Enchanted Gargoyle',0,'',0,'LineageMonster.gargoyle',16.00,50.00,44,'male','L2Monster',40,1799,648,8.69,2.14,40,43,30,21,20,10,3350,229,390,209,176,187,278,0,333,0,0,0,0,140,174,0,0,'LAST_HIT','true'),
(20568,20568,'Formor',0,'',0,'LineageMonster.troll',21.00,35.00,45,'male','L2Monster',40,1870,677,8.69,2.14,40,43,30,21,20,10,2945,205,377,238,188,193,278,0,333,0,0,0,0,60,191,0,0,'LAST_HIT','true'),
(20569,20569,'Formor Elder',0,'',0,'LineageMonster.troll',21.00,35.00,46,'male','L2Monster',40,1943,707,8.69,2.14,40,43,30,21,20,10,3200,227,401,245,202,199,278,0,333,0,0,0,0,55,174,0,0,'LAST_HIT','true'),
(20570,20570,'Tarlk Bugbear',0,'',0,'LineageMonster.bugbear',17.00,35.00,47,'male','L2Monster',40,2016,738,8.69,2.14,40,43,30,21,20,10,3212,230,427,253,216,206,278,0,333,88,0,0,0,55,174,0,0,'LAST_HIT','true'),
(20571,20571,'Tarlk Bugbear Warrior',0,'',0,'LineageMonster.bugbear',17.00,35.00,48,'male','L2Monster',40,2091,768,8.69,2.14,40,43,30,21,20,10,3793,277,453,261,231,212,278,500,333,169,0,0,0,60,191,0,0,'LAST_HIT','true'),
(20572,20572,'Tarlk Bugbear High Warrior',0,'',0,'LineageMonster.king_bugbear',15.00,40.00,49,'male','L2Monster',40,2168,799,8.69,2.14,40,43,30,21,20,10,4155,307,529,245,247,219,278,0,333,160,0,0,0,55,174,0,0,'LAST_HIT','true'),
(20573,20573,'Tarlk Basilisk',0,'',0,'LineageMonster.lesser_basilisk',34.00,25.00,50,'male','L2Monster',40,2245,830,8.69,2.14,40,43,30,21,20,10,3600,271,463,306,264,226,278,0,333,0,0,0,0,35,174,0,0,'LAST_HIT','true'),
(20574,20574,'Elder Tarlk Basilisk',0,'',0,'LineageMonster.lesser_basilisk',34.00,25.00,51,'male','L2Monster',40,2323,861,10.27,2.45,40,43,30,21,20,10,3820,291,593,260,281,232,278,500,333,0,0,0,0,35,174,0,0,'LAST_HIT','true'),
(20575,20575,'Oel Mahum Warrior',0,'',0,'LineageMonster.oel_mahum_warrior',20.00,38.00,54,'male','L2Monster',40,2562,955,10.27,2.45,40,43,30,21,20,10,4241,338,699,284,339,254,278,0,333,72,0,0,0,70,174,0,0,'LAST_HIT','true'),
(20576,20576,'Oel Mahum Witch Doctor',0,'',0,'LineageMonster.oel_mahum_witch_doctor',15.00,34.00,55,'male','L2Monster',40,2643,987,20.54,2.45,40,43,30,21,20,10,4401,355,609,354,360,261,278,0,333,201,0,0,0,77,191,0,0,'LAST_HIT','true'),
(20577,20577,'Leto Lizardman',0,'',0,'LineageMonster.zenta_lizardman',11.00,32.00,35,'male','L2Monster',40,1220,446,7.11,1.84,40,43,30,21,20,10,1781,105,192,169,89,137,278,0,333,66,0,0,0,37,174,0,0,'LAST_HIT','true'),
(20578,20578,'Leto Lizardman Archer',0,'',0,'LineageMonster.zenta_lizardman_scout',11.00,30.00,36,'male','L2Monster',500,1279,463,7.11,1.84,40,43,30,21,20,10,1941,117,417,193,96,142,247,0,333,14,0,0,0,37,174,0,0,'LAST_HIT','true'),
(20579,20579,'Leto Lizardman Soldier',0,'',0,'LineageMonster.zenta_lizardman',11.00,32.00,37,'male','L2Monster',40,1338,480,7.11,1.84,40,43,30,21,20,10,2030,125,222,182,104,147,278,500,333,68,0,0,0,37,174,0,0,'LAST_HIT','true'),
(20580,20580,'Leto Lizardman Warrior',0,'',0,'LineageMonster.zenta_lizardman_warrior',13.00,35.00,38,'male','L2Monster',40,1400,497,14.22,1.84,40,43,30,21,20,10,1953,121,261,171,112,153,278,0,333,93,0,0,0,40,174,0,0,'LAST_HIT','true'),
(20581,20581,'Leto Lizardman Shaman',0,'',0,'LineageMonster.zenta_lizardman_shaman',13.00,35.00,39,'male','L2Monster',40,1462,514,7.11,1.84,40,43,30,21,20,10,2212,141,280,177,121,158,278,0,333,159,0,0,0,43,174,0,0,'LAST_HIT','true'),
(20582,20582,'Leto Lizardman Overlord',0,'',0,'LineageMonster.zenta_lizardman_matriarch',20.00,40.00,40,'male','L2Monster',40,1527,531,14.22,1.84,40,43,30,21,20,10,2207,142,217,222,131,164,317,500,333,221,0,0,0,53,174,0,0,'LAST_HIT','true'),
(20583,20583,'Timak Orc',0,'',0,'LineageMonster.batur_orc',9.00,21.50,40,'male','L2Monster',40,1527,531,7.11,1.84,40,43,30,21,20,10,2327,150,300,183,131,164,278,0,333,2,0,0,0,88,191,0,2,'LAST_HIT','true'),
(20584,20584,'Timak Orc Archer',0,'',0,'LineageMonster.batur_orc_archer',11.00,21.50,41,'male','L2Monster',500,1593,560,8.69,2.14,40,43,30,21,20,10,3152,206,589,229,141,169,249,0,333,14,0,0,0,49,191,0,2,'LAST_HIT','true'),
(20585,20585,'Timak Orc Soldier',0,'',0,'LineageMonster.batur_orc',9.00,21.50,42,'male','L2Monster',40,1660,589,8.69,2.14,40,43,30,21,20,10,3114,207,311,215,152,175,278,500,333,66,0,0,0,88,191,0,2,'LAST_HIT','true'),
(20586,20586,'Timak Orc Warrior',0,'',0,'LineageMonster.batur_orc_warrior',10.00,20.00,43,'male','L2Monster',40,1728,618,8.69,2.14,40,43,30,21,20,10,2984,202,332,223,163,181,278,0,333,68,0,0,0,80,174,0,2,'LAST_HIT','true'),
(20587,20587,'Timak Orc Shaman',0,'',0,'LineageMonster.batur_orc_shaman',11.00,16.00,44,'male','L2Monster',40,1799,648,8.69,2.14,40,43,30,21,20,10,2815,193,390,209,176,187,278,0,333,179,0,0,0,50,174,0,3,'LAST_HIT','true'),
(20588,20588,'Timak Orc Overlord',0,'',0,'LineageMonster.batur_orc_overlord',14.50,28.80,45,'male','L2Monster',40,1870,677,8.69,2.14,40,43,30,21,20,10,3701,257,415,216,188,193,278,500,333,127,0,0,0,80,174,0,3,'LAST_HIT','true'),
(20589,20589,'Fline',0,'',0,'LineageMonster.sylph',11.00,35.00,45,'female','L2Monster',40,1870,677,17.38,2.14,40,43,30,21,20,10,2766,192,343,262,188,193,278,0,333,0,0,0,0,60,174,0,0,'LAST_HIT','false'),
(20590,20590,'Liele',0,'',0,'LineageMonster.undine',12.00,27.00,46,'female','L2Monster',40,1943,707,17.38,2.14,40,43,30,21,20,10,2862,203,365,270,202,199,278,0,333,0,0,0,0,60,174,0,0,'LAST_HIT','false'),
(20591,20591,'Valley Treant',0,'',0,'LineageMonster.ti_mi_tran',23.00,90.00,47,'male','L2Monster',40,2016,738,17.38,2.14,40,43,30,21,20,10,4224,303,388,279,216,206,278,0,333,0,0,0,0,13,13,0,0,'LAST_HIT','false'),
(20592,20592,'Satyr',0,'',0,'LineageMonster.pan',14.00,35.00,48,'male','L2Monster',40,2091,768,26.07,2.14,40,43,30,21,20,10,3076,224,412,288,231,212,278,500,333,291,0,0,0,45,174,0,0,'LAST_HIT','false'),
(20593,20593,'Unicorn',0,'',0,'LineageMonster.unicorn',14.00,30.00,49,'male','L2Monster',40,2168,799,26.07,2.14,40,43,30,21,20,10,3299,244,437,297,247,219,278,0,333,0,0,0,0,46,174,0,0,'LAST_HIT','false'),
(20594,20594,'Forest Runner',0,'',0,'LineageMonster.mandragora_b',12.00,25.50,50,'female','L2Monster',40,2245,830,17.38,2.14,40,43,30,21,20,10,3381,254,463,306,264,226,278,0,333,0,0,0,0,80,174,0,0,'LAST_HIT','false'),
(20595,20595,'Fline Elder',0,'',0,'LineageMonster.sylph',11.00,35.00,51,'female','L2Monster',40,2323,861,20.54,2.45,40,43,30,21,20,10,3518,268,593,260,281,232,278,0,333,0,0,0,0,60,174,0,0,'LAST_HIT','false'),
(20596,20596,'Liele Elder',0,'',0,'LineageMonster.undine',12.00,27.00,52,'female','L2Monster',40,2402,892,20.54,2.45,40,43,30,21,20,10,3730,288,627,268,300,239,278,500,333,0,0,0,0,60,174,0,0,'LAST_HIT','false'),
(20597,20597,'Valley Treant Elder',0,'',0,'LineageMonster.ti_mi_tran',23.00,90.00,53,'male','L2Monster',40,2481,923,30.81,2.45,40,43,30,21,20,10,5199,408,662,276,319,247,278,0,333,0,0,0,0,12,12,0,0,'LAST_HIT','false'),
(20598,20598,'Satyr Elder',0,'',0,'LineageMonster.pan',14.00,35.00,54,'male','L2Monster',40,2562,955,30.81,2.45,40,43,30,21,20,10,3816,304,699,284,339,254,278,0,333,297,0,0,0,45,174,0,0,'LAST_HIT','false'),
(20599,20599,'Unicorn Elder',0,'',0,'LineageMonster.unicorn',14.00,30.00,55,'male','L2Monster',40,2643,987,30.81,2.45,40,43,30,21,20,10,3959,319,737,292,360,261,278,0,333,0,0,0,0,46,174,0,0,'LAST_HIT','false'),
(20600,20600,'Karul Bugbear',0,'',0,'LineageMonster.bugbear',17.00,35.00,40,'male','L2Monster',40,1527,531,7.11,1.84,40,43,30,21,20,10,2741,177,300,183,131,164,278,0,333,88,0,0,0,55,174,0,0,'LAST_HIT','true'),
(20601,20601,'Tamlin Orc',0,'',0,'LineageMonster.batur_orc',9.00,21.50,41,'male','L2Monster',40,1593,560,8.69,2.14,40,43,30,21,20,10,2444,160,291,208,141,169,278,0,333,2,0,0,0,80,174,0,0,'LAST_HIT','true'),
(20602,20602,'Tamlin Orc Archer',0,'',0,'LineageMonster.batur_orc_archer',11.00,21.50,42,'male','L2Monster',500,1660,589,8.69,2.14,40,43,30,21,20,10,3308,220,692,215,152,175,247,0,333,14,0,0,0,45,174,0,0,'LAST_HIT','true'),
(20603,20603,'Kronbe Spider',0,'',0,'LineageMonster.giant_spider',26.00,25.50,43,'male','L2Monster',40,1728,618,8.69,2.14,40,43,30,21,20,10,2715,184,302,245,163,181,278,500,333,0,0,0,0,72,174,0,0,'LAST_HIT','true'),
(20604,20604,'Lakin',0,'',0,'LineageMonster.twin_headed_giant',17.00,39.00,44,'male','L2Monster',40,1799,648,8.69,2.14,40,43,30,21,20,10,3317,227,390,209,176,187,278,0,333,89,0,0,0,45,174,0,0,'LAST_HIT','true'),
(20605,20605,'Weird Drake',0,'',0,'LineageMonster.drake',30.00,100.00,45,'male','L2Monster',40,1870,677,8.69,2.14,40,43,30,21,20,10,3004,209,377,238,188,193,278,500,333,0,0,0,0,70,174,0,0,'LAST_HIT','true'),
(20606,20606,'Kuran Kobold',0,'',0,'LineageMonster.kobold',10.00,15.00,27,'male','L2Monster',40,813,318,11.06,1.53,40,43,30,21,20,10,950,48,94,138,45,102,278,0,333,0,0,0,0,51,121,0,0,'LAST_HIT','false'),
(20607,20607,'Kuran Kobold Warrior',0,'',0,'LineageMonster.kobold',10.00,15.00,28,'male','L2Monster',40,859,334,11.06,1.53,40,43,30,21,20,10,1006,53,124,118,49,106,278,0,333,0,0,0,0,51,121,0,0,'LAST_HIT','false'),
(20608,20608,'Patin Archer',0,'',0,'LineageMonster.skeleton_archer',11.00,27.00,29,'male','L2Monster',500,906,349,11.06,1.53,40,43,30,21,20,10,1022,55,271,135,53,110,249,500,333,14,0,0,0,44,154,1,0,'LAST_HIT','false'),
(20609,20609,'Lakin Salamander',0,'',0,'LineageMonster.salamander',16.00,6.80,30,'male','L2Monster',40,954,365,11.06,1.53,40,43,30,21,20,10,1068,58,120,155,58,114,278,0,333,0,0,0,0,70,105,0,0,'LAST_HIT','false'),
(20610,20610,'Sentinel Of Water',0,'',0,'LineageMonster.monster_eye',21.00,43.00,31,'male','L2Monster',40,1004,381,14.22,1.84,40,43,30,21,20,10,1083,60,157,133,64,118,278,0,333,0,0,0,0,99,99,0,0,'LAST_HIT','false'),
(20611,20611,'Dre Vanul Warrior',0,'',0,'LineageMonster.dre_vanul',14.00,36.00,32,'male','L2Monster',40,1056,397,14.22,1.84,40,43,30,21,20,10,1154,65,169,138,69,123,278,0,333,0,0,0,0,88,88,0,0,'LAST_HIT','false'),
(20612,20612,'Salamander Rowin',0,'',0,'LineageMonster.salamander',16.00,6.80,33,'male','L2Monster',40,1109,413,14.22,1.84,40,43,30,21,20,10,1319,75,151,173,75,128,278,500,333,0,0,0,0,70,105,0,0,'LAST_HIT','false'),
(20613,20613,'Lafi Lizardman',0,'',0,'LineageMonster.virud_lizardman',10.00,23.00,27,'male','L2Monster',40,813,318,11.06,1.53,40,43,30,21,20,10,950,48,104,125,45,102,278,0,333,291,0,0,0,47,143,0,0,'LAST_HIT','false'),
(20614,20614,'Lafi Lizardman Scout',0,'',0,'LineageMonster.virud_lizardman_scout',10.00,22.00,28,'male','L2Monster',500,859,334,11.06,1.53,40,43,30,21,20,10,940,49,228,143,49,106,249,0,333,2507,0,0,0,47,143,0,0,'LAST_HIT','false'),
(20615,20615,'Ritmal Swordsman',0,'',0,'LineageMonster.spartoi',11.00,27.00,29,'male','L2Monster',40,906,349,11.06,1.53,40,43,30,21,20,10,1094,58,122,135,53,110,278,500,333,73,0,0,0,66,154,1,0,'LAST_HIT','false'),
(20616,20616,'Lakin Undine',0,'',0,'LineageMonster.undine',12.00,27.00,30,'female','L2Monster',40,954,365,11.06,1.53,40,43,30,21,20,10,1434,78,145,128,58,114,278,0,333,0,0,0,0,66,66,0,0,'LAST_HIT','false'),
(20617,20617,'Sentinel Of Water',0,'',0,'LineageMonster.magical_weaver',11.00,20.00,31,'male','L2Monster',40,1004,381,14.22,1.84,40,43,30,21,20,10,1093,60,129,161,64,118,278,0,333,0,0,0,0,99,99,0,0,'LAST_HIT','false'),
(20618,20618,'Kanil Succubus',0,'',0,'LineageMonster.succubus',10.00,36.00,32,'female','L2Monster',40,1056,397,14.22,1.84,40,43,30,21,20,10,1216,68,169,138,69,123,278,0,333,0,0,0,0,66,110,0,0,'LAST_HIT','false'),
(20619,20619,'Rowin Undine',0,'',0,'LineageMonster.undine',12.00,27.00,33,'female','L2Monster',40,1109,413,14.22,1.84,40,43,30,21,20,10,1252,72,151,173,75,128,278,500,333,0,0,0,0,66,66,0,0,'LAST_HIT','false'),
(20620,20620,'Cave Beast',0,'',0,'LineageMonster.troll',21.00,35.00,61,'male','L2Monster',40,3137,1184,35.55,2.78,40,43,30,21,20,10,4304,378,992,344,505,307,278,500,333,0,0,0,0,55,174,0,0,'LAST_HIT','false'),
(20621,20621,'Death Wave',0,'',0,'LineageMonster.will_o_wisp',13.00,22.00,62,'male','L2Monster',40,3219,1217,35.55,2.78,40,43,30,21,20,10,4639,413,1038,353,532,315,278,500,333,0,0,0,0,80,174,0,0,'LAST_HIT','false'),
(20622,20622,'Malruk Soldier',0,'',0,'LineageMonster.skeleton_royal_guard',11.00,28.50,63,'male','L2Monster',40,3302,1251,35.55,2.78,40,43,30,21,20,10,4953,447,950,362,560,323,317,500,333,221,0,0,0,88,191,1,0,'LAST_HIT','false'),
(20623,20623,'Plando',0,'',0,'LineageMonster.virud_lizardman_scout',10.00,22.00,64,'male','L2Monster',500,3384,1285,47.40,2.78,40,43,30,21,20,10,4953,453,2084,449,589,331,249,500,333,2507,0,0,0,47,191,0,0,'LAST_HIT','false'),
(20624,20624,'Cave Howler',0,'',0,'LineageMonster.twin_headed_giant',17.00,39.00,65,'male','L2Monster',40,3465,1319,47.40,2.78,40,43,30,21,20,10,5037,468,979,460,619,340,278,500,333,0,0,0,0,49,191,0,0,'LAST_HIT','false'),
(20625,20625,'Malruk Knight',0,'',0,'LineageMonster.skeleton_knight',10.00,25.00,66,'male','L2Monster',40,3546,1353,47.40,2.78,40,43,30,21,20,10,5030,473,1020,471,649,348,278,500,333,78,0,0,0,44,191,1,10,'LAST_HIT','false'),
(20626,20626,'Malruk Berserker',0,'',0,'LineageMonster.death_knight',12.00,31.00,67,'male','L2Monster',40,3626,1388,47.40,2.78,40,43,30,21,20,10,7220,687,1415,362,681,356,278,500,333,77,0,0,0,29,191,1,10,'LAST_HIT','false'),
(20627,20627,'Malruk Lord',0,'',0,'LineageMonster.death_blader',15.00,45.00,68,'male','L2Monster',40,3706,1423,59.25,2.78,40,43,30,21,20,10,4964,479,1217,449,713,365,278,500,333,1472,0,0,0,110,191,1,10,'LAST_HIT','false'),
(20628,20628,'Limal Karinness',0,'',0,'LineageMonster.bloody_queen',14.00,40.00,69,'female','L2Monster',40,3784,1458,59.25,2.78,40,43,30,21,20,10,5349,523,1392,418,746,373,278,500,333,0,0,0,0,88,191,0,10,'LAST_HIT','false'),
(20629,20629,'Karik',0,'',0,'LineageMonster.karik',25.00,90.00,70,'male','L2Monster',40,3862,1493,59.25,2.78,40,43,30,21,20,10,6584,652,1445,427,780,382,278,500,333,0,0,0,0,40,191,0,10,'LAST_HIT','false'),
(20630,20630,'Taik Orc',0,'',0,'LineageMonster.ketra_orc',12.00,29.00,40,'male','L2Monster',40,1527,531,7.11,1.84,40,43,30,21,20,10,2327,150,273,201,131,164,278,0,333,127,0,0,0,49,191,0,0,'LAST_HIT','true'),
(20631,20631,'Taik Orc Archer',0,'',0,'LineageMonster.ketra_orc_archer',12.00,27.00,41,'male','L2Monster',500,1593,560,8.69,2.14,40,43,30,21,20,10,3152,206,589,195,141,169,247,0,333,14,0,0,0,45,174,0,0,'LAST_HIT','true'),
(20632,20632,'Taik Orc Warrior',0,'',0,'LineageMonster.ketra_orc_warrior',12.00,24.00,42,'male','L2Monster',40,1660,589,8.69,2.14,40,43,30,21,20,10,3144,209,342,196,152,175,278,500,333,75,0,0,0,39,191,0,0,'LAST_HIT','true'),
(20633,20633,'Taik Orc Shaman',0,'',0,'LineageMonster.ketra_orc_shaman',10.00,23.00,43,'male','L2Monster',40,1728,618,8.69,2.14,40,43,30,21,20,10,3068,207,302,245,163,181,278,0,333,9,0,0,0,10,174,0,0,'LAST_HIT','true'),
(20634,20634,'Taik Orc Captain',0,'',0,'LineageMonster.ketra_orc_warrior',12.00,24.00,44,'male','L2Monster',40,1799,648,17.38,2.14,40,43,30,21,20,10,2943,201,322,253,176,187,278,500,333,75,104,0,0,36,174,0,0,'LAST_HIT','true'),
(20635,20635,'Carinkain',0,'',0,'LineageMonster.mana_vampire',11.00,20.00,45,'male','L2Monster',40,1870,677,8.69,2.14,40,43,30,21,20,10,2974,207,415,216,188,193,278,500,333,0,0,0,0,90,174,0,0,'LAST_HIT','true'),
(20636,20636,'Forest of Mirrors Ghost',0,'',0,'LineageMonster.dwarf_ghost',9.00,16.50,46,'male','L2Monster',40,1943,707,8.69,2.14,40,43,30,21,20,10,3310,235,442,223,202,199,278,500,333,0,0,0,0,80,174,1,3,'LAST_HIT','true'),
(20637,20637,'Forest of Mirrors Ghost',0,'',0,'LineageMonster.elf_ghost',7.00,21.00,47,'male','L2Monster',40,2016,738,8.69,2.14,40,43,30,21,20,10,3456,248,469,230,216,206,278,500,333,0,0,0,0,80,174,1,4,'LAST_HIT','true'),
(20638,20638,'Forest of Mirrors Ghost',0,'',0,'LineageMonster.human_ghost',8.00,22.00,48,'male','L2Monster',40,2091,768,8.69,2.14,40,43,30,21,20,10,3605,263,498,238,231,212,278,500,333,0,0,0,0,80,174,1,4,'LAST_HIT','true'),
(20639,20639,'Mirror',0,'',0,'LineageMonster.mirror',26.00,52.00,49,'male','L2Monster',40,2168,799,17.38,2.14,40,43,30,21,20,10,4254,314,437,297,247,219,278,0,333,0,0,0,0,80,174,0,4,'LAST_HIT','true'),
(20640,20640,'Harit Lizardman',0,'',0,'LineageMonster.zenta_lizardman',11.00,32.00,50,'male','L2Monster',40,2245,830,8.69,2.14,40,43,30,21,20,10,3636,274,509,278,264,226,278,0,333,88,945,0,0,37,174,0,5,'LAST_HIT','true'),
(20641,20641,'Harit Lizardman Grunt',0,'',0,'LineageMonster.zenta_lizardman',11.00,32.00,51,'male','L2Monster',40,2323,861,10.27,2.45,40,43,30,21,20,10,4501,343,539,286,281,232,278,0,333,70,0,0,0,37,174,0,5,'LAST_HIT','true'),
(20642,20642,'Harit Lizardman Archer',0,'',0,'LineageMonster.zenta_lizardman_scout',11.00,30.00,52,'male','L2Monster',500,2402,892,10.27,2.45,40,43,30,21,20,10,4214,326,1152,324,300,239,247,500,333,14,0,0,0,37,174,0,5,'LAST_HIT','true'),
(20643,20643,'Harit Lizardman Warrior',0,'',0,'LineageMonster.zenta_lizardman_warrior',13.00,35.00,53,'male','L2Monster',40,2481,923,10.27,2.45,40,43,30,21,20,10,4332,341,662,276,319,247,278,0,333,291,0,0,0,40,174,0,0,'LAST_HIT','true'),
(20644,20644,'Harit Lizardman Shaman',0,'',0,'LineageMonster.zenta_lizardman_shaman',13.00,35.00,54,'male','L2Monster',40,2562,955,10.27,2.45,40,43,30,21,20,10,4241,338,699,284,339,254,278,0,333,9,0,0,0,43,174,0,0,'LAST_HIT','true'),
(20645,20645,'Harit Lizardman Matriarch',0,'',0,'LineageMonster.zenta_lizardman_matriarch',20.00,40.00,55,'male','L2Monster',40,2643,987,20.54,2.45,40,43,30,21,20,10,4768,385,609,354,360,261,278,500,333,221,0,0,0,53,174,0,0,'LAST_HIT','true'),
(20646,20646,'Halingka',0,'',0,'LineageMonster.saber_toothed_tiger',34.00,28.00,55,'male','L2Monster',40,2643,987,20.54,2.45,40,43,30,21,20,10,3592,290,737,292,360,261,278,0,333,0,0,0,0,66,187,0,6,'LAST_HIT','false'),
(20647,20647,'Yintzu',0,'',0,'LineageMonster.field_stalker',15.00,30.00,56,'male','L2Monster',40,2724,1019,20.54,2.45,40,43,30,21,20,10,3605,296,777,301,382,269,278,500,333,0,0,0,0,77,121,0,6,'LAST_HIT','false'),
(20648,20648,'Paliote',0,'',0,'LineageMonster.will_o_wisp',13.00,22.00,57,'male','L2Monster',40,2806,1052,20.54,2.45,40,43,30,21,20,10,4094,340,817,309,405,276,278,0,333,0,0,0,0,88,154,0,7,'LAST_HIT','false'),
(20649,20649,'Hamrut',0,'',0,'LineageMonster.poison_spider',27.00,25.50,58,'male','L2Monster',40,2889,1084,20.54,2.45,40,43,30,21,20,10,4075,344,859,318,428,284,278,500,333,0,0,0,0,66,154,0,7,'LAST_HIT','false'),
(20650,20650,'Kranrot',0,'',0,'LineageMonster.crimson_bear',19.00,36.00,59,'male','L2Monster',40,2971,1117,20.54,2.45,40,43,30,21,20,10,4410,377,902,326,453,291,278,500,333,0,0,0,0,40,187,0,8,'LAST_HIT','false'),
(20651,20651,'Gamlin',0,'',0,'LineageMonster.gamlin',11.00,32.00,60,'male','L2Monster',40,3054,1150,20.54,2.45,40,43,30,21,20,10,4097,355,782,405,478,299,278,0,333,0,0,0,0,88,187,0,0,'LAST_HIT','false'),
(20652,20652,'Leogul',0,'',0,'LineageMonster.leogul',15.00,35.00,61,'male','L2Monster',40,3137,1184,23.70,2.78,40,43,30,21,20,10,4320,380,819,416,505,307,278,500,333,0,0,0,0,88,187,0,0,'LAST_HIT','false'),
(20653,20653,'Lesser Giant',0,'',0,'LineageMonster.lesser_giant',21.00,44.00,61,'male','L2Monster',40,3137,1184,35.55,2.78,40,43,30,21,20,10,4058,357,901,378,505,307,278,0,333,3937,0,0,0,16,198,0,0,'LAST_HIT','false'),
(20654,20654,'Lesser Giant Soldier',0,'',0,'LineageMonster.lesser_giant',21.00,44.00,62,'male','L2Monster',40,3219,1217,35.55,2.78,40,43,30,21,20,10,6224,554,1142,321,532,315,278,0,333,3937,0,0,0,16,198,0,0,'LAST_HIT','false'),
(20655,20655,'Lesser Giant Shooter',0,'',0,'LineageMonster.lesser_giant_shooter',21.00,44.00,63,'male','L2Monster',500,3302,1251,35.55,2.78,40,43,30,21,20,10,5085,459,2194,398,560,323,249,500,333,4028,0,0,0,88,198,0,0,'LAST_HIT','false'),
(20656,20656,'Lesser Giant Scout',0,'',0,'LineageMonster.lesser_giant_shooter',21.00,44.00,63,'male','L2Monster',500,3302,1251,35.55,2.78,40,43,30,21,20,10,4639,419,2194,338,560,323,249,500,333,4028,0,0,0,88,198,0,0,'LAST_HIT','false'),
(20657,20657,'Lesser Giant Mage',0,'',0,'LineageMonster.lesser_giant_mage',21.00,44.00,64,'male','L2Monster',40,3384,1285,23.70,2.78,40,43,30,21,20,10,5511,504,1135,371,589,331,278,0,333,3938,0,0,0,16,198,0,0,'LAST_HIT','false'),
(20658,20658,'Lesser Giant Elder',0,'',0,'LineageMonster.lesser_giant_mage',21.00,44.00,65,'male','L2Monster',40,3465,1319,23.70,2.78,40,43,30,21,20,10,5324,494,1184,380,619,340,278,0,333,3938,0,0,0,16,198,0,0,'LAST_HIT','false'),
(20659,20659,'Grave Wanderer',0,'',0,'LineageMonster.zombie',13.00,21.00,45,'male','L2Monster',40,1870,677,8.69,2.14,40,43,30,21,20,10,4123,287,377,238,188,193,278,0,333,0,0,0,0,16,16,1,0,'LAST_HIT','true'),
(20660,20660,'Archer of Greed',0,'',0,'LineageMonster.skeleton_archer',11.00,27.00,46,'male','L2Monster',500,1943,707,8.69,2.14,40,43,30,21,20,10,4048,287,982,190,202,199,249,500,333,14,0,0,0,44,191,1,0,'LAST_HIT','true'),
(20661,20661,'Hatar Ratman Thief',0,'',0,'LineageMonster.wererat',14.00,25.00,47,'male','L2Monster',40,2016,738,8.69,2.14,40,43,30,21,20,10,3823,274,373,253,216,206,317,0,333,946,0,0,0,88,191,0,0,'LAST_HIT','true'),
(20662,20662,'Hatar Ratman Boss',0,'',0,'LineageMonster.wererat',14.00,25.00,48,'male','L2Monster',40,2091,768,8.69,2.14,40,43,30,21,20,10,3987,291,396,261,231,212,317,0,333,221,0,0,0,88,191,0,0,'LAST_HIT','true'),
(20663,20663,'Hatar Hanishee',0,'',0,'LineageMonster.medusa',10.00,25.00,49,'female','L2Monster',40,2168,799,8.69,2.14,40,43,30,21,20,10,3492,258,529,245,247,219,278,0,333,0,0,0,0,55,191,0,0,'LAST_HIT','true'),
(20664,20664,'Deprive',0,'',0,'LineageMonster.field_stalker',15.00,30.00,50,'male','L2Monster',40,2245,830,8.69,2.14,40,43,30,21,20,10,3672,277,560,253,264,226,278,500,333,0,0,0,0,77,191,0,0,'LAST_HIT','true'),
(20665,20665,'Taik Orc Supply',0,'',0,'LineageMonster.ketra_orc',12.00,29.00,51,'male','L2Monster',40,2323,861,10.27,2.45,40,43,30,21,20,10,4501,343,490,315,281,232,278,0,333,69,0,0,0,49,191,0,0,'LAST_HIT','true'),
(20666,20666,'Taik Orc Seeker',0,'',0,'LineageMonster.ketra_orc',12.00,29.00,52,'male','L2Monster',40,2402,892,10.27,2.45,40,43,30,21,20,10,4679,362,627,268,300,239,278,0,333,72,0,0,0,49,191,0,0,'LAST_HIT','false'),
(20667,20667,'Farcran',0,'',0,'LineageMonster.crimson_bear',19.00,36.00,53,'male','L2Monster',40,2481,923,10.27,2.45,40,43,30,21,20,10,4813,378,602,304,319,247,278,0,333,0,0,0,0,40,191,0,0,'LAST_HIT','true'),
(20668,20668,'Grave Guard',0,'',0,'LineageMonster.gargoyle',16.00,50.00,54,'male','L2Monster',40,2562,955,10.27,2.45,40,43,30,21,20,10,4283,341,578,344,339,254,278,500,333,0,0,0,0,140,174,0,0,'LAST_HIT','false'),
(20669,20669,'Taik Orc Supply Leader',0,'',0,'LineageMonster.ketra_orc_warrior',12.00,24.00,55,'male','L2Monster',40,2643,987,10.27,2.45,40,43,30,21,20,10,5340,431,737,292,360,261,278,500,333,75,0,0,0,36,174,0,0,'LAST_HIT','false'),
(20670,20670,'Crimson Drake',0,'',0,'LineageMonster.drake',30.00,100.00,61,'male','L2Monster',40,3137,1184,11.85,2.78,40,43,30,21,20,10,5465,481,992,344,505,307,278,200,333,0,0,0,0,70,174,0,0,'LAST_HIT','false'),
(20671,20671,'Kadios',0,'',0,'LineageMonster.devastator',35.00,35.00,62,'male','L2Monster',40,3219,1217,11.85,2.78,40,43,30,21,20,10,5702,508,1038,353,532,315,278,200,333,0,0,0,0,25,174,0,0,'LAST_HIT','false'),
(20672,20672,'Trives',0,'',0,'LineageMonster.serpent_slave',17.00,46.00,63,'male','L2Monster',40,3302,1251,11.85,2.78,40,43,30,21,20,10,5772,521,897,438,560,323,278,0,333,127,0,0,0,70,174,0,0,'LAST_HIT','false'),
(20673,20673,'Falibati',0,'',0,'LineageMonster.cave_maiden',25.00,65.00,64,'female','L2Monster',40,3384,1285,11.85,2.78,40,43,30,21,20,10,6016,551,938,449,589,331,278,300,333,73,0,0,0,70,174,0,0,'LAST_HIT','false'),
(20674,20674,'Doom Knight',0,'',0,'LineageMonster.death_blader',15.00,45.00,65,'male','L2Monster',40,3465,1319,11.85,2.78,40,43,30,21,20,10,8649,804,1184,380,619,340,278,300,333,1472,0,0,0,100,174,1,10,'LAST_HIT','false'),
(20675,20675,'Tairim',0,'',0,'LineageMonster.will_o_wisp',13.00,22.00,50,'male','L2Monster',40,2245,830,8.69,2.14,40,43,30,21,20,10,3817,288,463,306,264,226,278,0,333,0,0,0,0,88,191,0,0,'LAST_HIT','false'),
(20676,20676,'Judge of Marsh',0,'',0,'LineageMonster.hanged_man_ripper',35.00,80.00,65,'male','L2Monster',40,3465,1319,11.85,2.78,40,43,30,21,20,10,6205,577,1184,380,619,340,278,500,333,0,0,0,0,60,191,0,0,'LAST_HIT','true'),
(20677,20677,'Tulben',0,'',0,'LineageMonster.vampire_bat',10.00,33.50,66,'male','L2Monster',40,3546,1353,11.85,2.78,40,43,30,21,20,10,6968,656,1123,428,649,348,278,0,333,0,0,0,0,66,191,0,0,'LAST_HIT','true'),
(20678,20678,'Tortured Undead',0,'',0,'LineageMonster.hungry_spirit',30.00,40.00,53,'male','L2Monster',40,2481,923,10.27,2.45,40,43,30,21,20,10,4085,321,662,276,319,247,278,0,333,0,0,0,0,15,174,1,0,'LAST_HIT','false'),
(20679,20679,'Marsh Stalker',0,'',0,'LineageMonster.gargoyle',16.00,50.00,54,'male','L2Monster',40,2562,955,10.27,2.45,40,43,30,21,20,10,4199,335,636,313,339,254,278,0,333,0,0,0,0,140,174,0,0,'LAST_HIT','true'),
(20680,20680,'Marsh Drake',0,'',0,'LineageMonster.drake',30.00,100.00,55,'male','L2Monster',40,2643,987,10.27,2.45,40,43,30,21,20,10,4443,359,737,292,360,261,278,500,333,0,0,0,0,70,174,0,0,'LAST_HIT','true'),
(20681,20681,'Vanor Silenos',0,'',0,'LineageMonster.heltor_silenos',13.00,29.00,45,'male','L2Monster',40,1870,677,8.69,2.14,40,43,30,21,20,10,3092,215,377,238,188,193,278,0,333,88,0,0,0,37,191,0,0,'LAST_HIT','true'),
(20682,20682,'Vanor Silenos Grunt',0,'',0,'LineageMonster.heltor_silenos',13.00,29.00,46,'male','L2Monster',40,1943,707,8.69,2.14,40,43,30,21,20,10,3077,218,401,245,202,199,278,0,333,158,18,0,0,37,191,0,0,'LAST_HIT','true'),
(20683,20683,'Vanor Silenos Scout',0,'',0,'LineageMonster.heltor_silenos',13.00,29.00,47,'male','L2Monster',40,2016,738,8.69,2.14,40,43,30,21,20,10,4004,287,388,279,216,206,278,500,333,5,0,0,0,37,191,0,0,'LAST_HIT','true'),
(20684,20684,'Vanor Silenos Warrior',0,'',0,'LineageMonster.heltor_silenos_warrior',13.00,31.00,48,'male','L2Monster',40,2091,768,8.69,2.14,40,43,30,21,20,10,4188,306,498,238,231,212,278,0,333,160,0,0,0,39,191,0,0,'LAST_HIT','true'),
(20685,20685,'Vanor Silenos Shaman',0,'',0,'LineageMonster.heltor_silenos_shaman',13.00,32.00,49,'male','L2Monster',40,2168,799,8.69,2.14,40,43,30,21,20,10,3492,258,529,245,247,219,278,0,333,9,0,0,0,31,191,0,0,'LAST_HIT','true'),
(20686,20686,'Vanor Silenos Chieftain',0,'',0,'LineageMonster.heltor_silenos_chieftain',13.00,31.50,50,'male','L2Monster',40,2245,830,17.38,2.14,40,43,30,21,20,10,3637,274,463,306,264,226,278,0,333,75,0,0,0,29,191,0,0,'LAST_HIT','true'),
(20738,20738,'Kobold Looter Bepook',0,'',0,'LineageMonster.kobold_bi',15.00,24.00,13,'male','L2Monster',40,339,147,7.90,1.21,40,43,30,21,20,10,663,26,33,63,11,56,278,500,333,4,0,0,0,51,121,0,0,'LAST_HIT','false'),
(20739,20739,'Bepook\'s Pet',0,'',0,'LineageMonster.wolf',13.00,9.00,10,'male','L2Minion',40,257,120,1.58,0.91,40,43,30,21,20,10,439,14,27,50,8,49,278,0,333,0,0,0,0,26,121,0,0,'LAST_HIT','false'),
(20742,20742,'Mystical Weaver',0,'',0,'LineageMonster.magical_weaver',11.00,20.00,22,'male','L2Monster',40,611,242,5.53,1.53,40,43,30,21,20,10,684,32,62,113,28,83,278,0,333,0,0,0,0,99,99,0,0,'LAST_HIT','false'),
(20743,20743,'Howler',0,'',0,'LineageMonster.werewolf',10.00,26.00,25,'male','L2Monster',40,728,287,5.53,1.53,40,43,30,21,20,10,843,42,80,127,37,94,278,500,333,0,0,0,0,55,132,0,0,'LAST_HIT','false'),
(20744,20744,'Red Eye Vampire Bat',0,'',0,'LineageMonster.vampire_bat',10.00,33.50,22,'male','L2Monster',40,611,242,5.53,1.53,40,43,30,21,20,10,684,32,75,93,28,83,278,0,333,0,0,0,0,66,88,0,0,'LAST_HIT','false'),
(20745,20745,'Gigantiops',0,'',0,'LineageMonster.ant_soldier',35.00,17.00,35,'male','L2Monster',40,1220,446,7.11,1.84,40,43,30,21,20,10,2681,159,174,186,89,137,278,500,333,0,0,0,0,80,174,0,0,'LAST_HIT','false'),
(20746,20746,'Young Gigantiops',0,'',0,'LineageMonster.ant',26.00,15.00,31,'male','L2Minion',40,1004,381,7.11,1.84,40,43,30,21,20,10,2062,114,157,133,64,118,278,0,333,0,0,0,0,40,139,0,0,'LAST_HIT','false'),
(20747,20747,'Roxide',0,'',0,'LineageMonster.succubus',10.00,36.00,32,'female','L2Monster',40,1056,397,14.22,1.84,40,43,30,21,20,10,1459,82,169,138,69,123,278,500,333,0,0,0,0,66,174,0,0,'LAST_HIT','false'),
(20748,20748,'Roxide Cohort',0,'',0,'LineageMonster.spartoi',11.00,27.00,29,'male','L2Minion',40,906,349,11.06,1.53,40,43,30,21,20,10,1349,72,111,149,53,110,278,0,333,73,0,0,0,66,174,1,0,'LAST_HIT','false'),
(20749,20749,'Death Fire',0,'',0,'LineageMonster.dre_vanul',14.00,36.00,32,'male','L2Monster',40,1056,397,14.22,1.84,40,43,30,21,20,10,1459,82,169,138,69,123,278,500,333,0,0,0,0,88,174,0,0,'LAST_HIT','false'),
(20750,20750,'Fire Archer',0,'',0,'LineageMonster.skeleton_archer',11.00,27.00,29,'male','L2Minion',500,906,349,11.06,1.53,40,43,30,21,20,10,1397,75,247,149,53,110,249,0,333,14,0,0,0,44,174,1,0,'LAST_HIT','false'),
(20751,20751,'Snipe',0,'',0,'LineageMonster.onyx_beast',14.00,14.50,44,'male','L2Monster',40,1799,648,17.38,2.14,40,43,30,21,20,10,2259,155,390,209,176,187,278,0,333,0,0,0,0,30,120,0,0,'LAST_HIT','false'),
(20752,20752,'Snipe Cohort',0,'',0,'LineageMonster.onyx_beast',14.00,14.50,42,'male','L2Minion',40,1660,589,17.38,2.14,40,43,30,21,20,10,3290,219,283,237,152,175,278,0,333,0,0,0,0,30,120,0,0,'LAST_HIT','false'),
(20753,20753,'Dark Lord',0,'',0,'LineageMonster.death_blader',15.00,45.00,50,'male','L2Monster',40,2245,830,17.38,2.14,40,43,30,21,20,10,4282,322,463,306,264,226,278,500,333,1472,0,0,0,100,174,1,0,'LAST_HIT','false'),
(20754,20754,'Dark Knight',0,'',0,'LineageMonster.death_knight',12.00,31.00,48,'male','L2Monster',40,2091,768,17.38,2.14,40,43,30,21,20,10,4960,362,498,238,231,212,278,0,333,127,0,0,0,27,174,1,0,'LAST_HIT','false'),
(20755,20755,'Talakin',0,'',0,'LineageMonster.ol_mahum_champion',14.00,27.00,30,'male','L2Monster',40,954,365,5.53,1.53,40,43,30,21,20,10,1970,108,120,155,58,114,278,500,333,2,0,0,0,50,133,0,0,'LAST_HIT','false'),
(20756,20756,'Talakin Archer',0,'',0,'LineageMonster.ol_mahum_archer',14.00,25.00,28,'male','L2Minion',500,859,334,5.53,1.53,40,43,30,21,20,10,1884,99,228,143,49,106,247,0,333,14,0,0,0,50,133,0,0,'LAST_HIT','false'),
(20757,20757,'Talakin Raider',0,'',0,'LineageMonster.ol_mahum',13.50,25.00,27,'male','L2Minion',40,813,318,5.53,1.53,40,43,30,21,20,10,1380,71,114,114,45,102,278,0,333,3,0,0,0,50,133,0,0,'LAST_HIT','false'),
(20758,20758,'Dragon Bearer Chief',0,'',0,'LineageMonster.spartoi',11.00,27.00,49,'male','L2Monster',40,2168,799,8.69,2.14,40,43,30,21,20,10,5255,389,437,297,247,219,278,500,333,123,945,0,0,60,174,1,0,'LAST_HIT','false'),
(20759,20759,'Dragon Bearer Warrior',0,'',0,'LineageMonster.skeleton',11.00,25.00,48,'male','L2Minion',40,2091,768,8.69,2.14,40,43,30,21,20,10,4944,361,498,238,231,212,278,0,333,2,945,0,0,60,174,1,0,'LAST_HIT','false'),
(20760,20760,'Dragon Bearer Archer',0,'',0,'LineageMonster.skeleton_archer',11.00,27.00,47,'male','L2Minion',500,2016,738,8.69,2.14,40,43,30,21,20,10,5137,368,862,279,216,206,247,0,333,14,0,0,0,40,174,1,0,'LAST_HIT','false'),
(20761,20761,'Pytan',0,'',0,'LineageMonster.bloody_queen',14.00,40.00,69,'female','L2Monster',40,3784,1458,35.55,2.78,40,43,30,21,20,10,6633,649,1392,418,746,373,278,500,333,0,0,0,0,88,191,0,10,'LAST_HIT','false'),
(20762,20762,'Pytan Knight',0,'',0,'LineageMonster.death_blader',15.00,45.00,68,'male','L2Minion',40,3706,1423,23.70,2.78,40,43,30,21,20,10,7021,678,1106,494,713,365,278,0,333,1472,0,0,0,110,191,1,10,'LAST_HIT','false'),
(20763,20763,'Lord of the Plains',0,'',0,'LineageMonster.zenta_lizardman_matriarch',20.00,40.00,40,'male','L2Monster',40,1527,531,7.11,1.84,40,43,30,21,20,10,3869,250,217,222,131,164,317,500,333,221,0,0,0,53,174,0,0,'LAST_HIT','false'),
(20764,20764,'Shaman of the Plains',0,'',0,'LineageMonster.zenta_lizardman_shaman',13.00,35.00,39,'male','L2Minion',40,1462,514,7.11,1.84,40,43,30,21,20,10,3457,220,231,214,121,158,278,0,333,179,0,0,0,43,174,0,0,'LAST_HIT','false'),
(20765,20765,'Warrior of the Plains',0,'',0,'LineageMonster.zenta_lizardman_warrior',13.00,35.00,38,'male','L2Minion',40,1400,497,7.11,1.84,40,43,30,21,20,10,2992,187,261,171,112,153,278,0,333,16,0,0,0,40,174,0,0,'LAST_HIT','false'),
(20766,20766,'Scout of the Plains',0,'',0,'LineageMonster.zenta_lizardman_scout',11.00,30.00,36,'male','L2Minion',500,1279,463,7.11,1.84,40,43,30,21,20,10,2659,161,417,193,96,142,247,0,333,14,0,0,0,37,174,0,0,'LAST_HIT','false'),
(20767,20767,'Timak Orc Troop Leader',0,'',0,'LineageMonster.batur_orc_overlord',12.00,24.00,45,'male','L2Monster',40,1870,677,8.69,2.14,40,43,30,21,20,10,4801,334,415,216,188,193,278,0,333,79,0,0,0,80,174,0,3,'LAST_HIT','false'),
(20768,20768,'Timak Orc Troop Shaman',0,'',0,'LineageMonster.batur_orc_shaman',11.00,16.00,44,'male','L2Monster',40,1799,648,8.69,2.14,40,43,30,21,20,10,4632,317,390,209,176,187,278,0,333,7,0,0,0,50,174,0,3,'LAST_HIT','false'),
(20769,20769,'Timak Orc Troop Warrior',0,'',0,'LineageMonster.batur_orc_warrior',10.00,20.00,43,'male','L2Monster',40,1728,618,8.69,2.14,40,43,30,21,20,10,3684,249,365,202,163,181,278,0,333,123,19,0,0,80,174,0,2,'LAST_HIT','false'),
(20770,20770,'Timak Orc Troop Archer',0,'',0,'LineageMonster.batur_orc_archer',11.00,21.50,41,'male','L2Monster',500,1593,560,8.69,2.14,40,43,30,21,20,10,4319,283,713,189,141,169,247,0,333,13,0,0,0,45,174,0,2,'LAST_HIT','false'),
(20771,20771,'Barif',0,'',0,'LineageMonster.lesser_giant_mage',21.00,44.00,64,'male','L2Monster',40,3384,1285,23.70,2.78,40,43,30,21,20,10,6515,596,938,449,589,331,278,500,333,3938,0,0,0,16,198,0,0,'LAST_HIT','false'),
(20772,20772,'Barif\'s Pet',0,'',0,'LineageMonster.leogul',15.00,35.00,61,'male','L2Minion',40,3137,1184,23.70,2.78,40,43,30,21,20,10,6332,557,992,344,505,307,278,0,333,0,0,0,0,88,187,0,0,'LAST_HIT','false'),
(20773,20773,'Conjurer Bat Lord',0,'',0,'LineageMonster.vampire_bat',10.00,33.50,72,'male','L2Monster',40,4013,1565,13.43,3.09,40,43,30,21,20,10,10535,1070,1284,540,849,399,278,500,333,0,0,0,0,60,174,0,0,'LAST_HIT','false'),
(20774,20774,'Conjurer Bat',0,'',0,'LineageMonster.vampire_bat',10.00,33.50,70,'male','L2Minion',40,3862,1493,11.85,2.78,40,43,30,21,20,10,11140,1105,1194,517,780,382,278,0,333,0,0,0,0,60,174,0,0,'LAST_HIT','false'),
(20775,20775,'Bugbear Raider',0,'',0,'LineageMonster.bugbear',17.00,35.00,17,'male','L2Monster',40,446,184,3.95,1.21,40,43,30,21,20,10,599,25,48,75,17,67,278,0,333,0,0,0,0,60,143,0,0,'LAST_HIT','true'),
(20776,20776,'Dark Succubus',0,'',0,'LineageMonster.succubus',10.00,36.00,20,'female','L2Monster',40,541,213,3.95,1.21,40,43,30,21,20,10,783,35,57,94,23,76,278,0,333,0,0,0,0,66,110,0,0,'LAST_HIT','true'),
(20777,20777,'Hunter Bear',0,'',0,'LineageMonster.grizzly',21.00,40.00,14,'male','L2Monster',40,364,156,3.95,1.21,40,43,30,21,20,10,498,19,37,66,12,59,278,0,333,0,0,0,0,44,121,0,0,'LAST_HIT','true'),
(20778,20778,'Ragna Orc Overlord',0,'',0,'LineageMonster.orc_champion',10.00,23.00,39,'male','L2Monster',40,1462,514,7.11,1.84,40,43,30,21,20,10,2477,157,231,214,121,158,278,0,333,2,0,0,0,49,191,0,0,'LAST_HIT','false'),
(20779,20779,'Ragna Orc Seer',0,'',0,'LineageMonster.orc_shaman',9.00,22.00,39,'male','L2Monster',40,1462,514,7.11,1.84,40,43,30,21,20,10,2212,141,231,214,121,158,278,0,333,7,0,0,0,49,191,0,0,'LAST_HIT','false'),
(20780,20780,'Bloody Axe Elite',0,'',0,'LineageMonster.ol_mahum_champion',14.00,27.00,35,'male','L2Monster',40,1220,446,7.11,1.84,40,43,30,21,20,10,1799,106,174,186,89,137,278,500,333,2,0,0,0,50,174,0,0,'LAST_HIT','true'),
(20781,20781,'Delu Lizardman Shaman',0,'',0,'LineageMonster.virud_lizardman_shaman',10.00,29.00,35,'male','L2Monster',40,1220,446,7.11,1.84,40,43,30,21,20,10,1781,105,211,154,89,137,278,0,333,7,0,0,0,43,174,0,0,'LAST_HIT','true'),
(20782,20782,'Ol Mahum Novice',0,'',0,'LineageMonster.ol_mahum',13.50,25.00,17,'male','L2Monster',40,446,184,3.95,1.21,40,43,30,21,20,10,618,26,44,83,17,67,278,500,333,1,0,0,0,50,110,0,0,'LAST_HIT','true'),
(20783,20783,'Dread Wolf',0,'',0,'LineageMonster.dire_wolf',13.00,11.00,35,'male','L2Monster',40,1220,446,3.56,1.84,40,43,30,21,20,10,1635,96,256,127,89,137,278,500,333,0,0,0,0,24,140,0,0,'LAST_HIT','true'),
(20784,20784,'Tasaba Lizardman',0,'',0,'LineageMonster.virud_lizardman_scout',10.00,22.00,36,'male','L2Monster',500,1279,463,3.56,1.84,40,43,30,21,20,10,1852,112,505,159,96,142,247,0,333,2507,0,0,0,43,140,0,0,'LAST_HIT','true'),
(20785,20785,'Tasaba Lizardman Shaman',0,'',0,'LineageMonster.virud_lizardman_shaman',10.00,29.00,37,'male','L2Monster',40,1338,480,3.56,1.84,40,43,30,21,20,10,1791,110,244,140,104,147,278,0,333,7,0,0,0,43,140,0,0,'LAST_HIT','true'),
(20786,20786,'Lienrik',0,'',0,'LineageMonster.lienrik',12.00,50.00,39,'male','L2Monster',40,1462,514,3.56,1.84,40,43,30,21,20,10,1990,126,297,146,121,158,317,0,333,0,0,0,0,100,150,0,0,'LAST_HIT','true'),
(20787,20787,'Lienrik Lad',0,'',0,'LineageMonster.lienrik',12.00,50.00,40,'male','L2Monster',40,1527,531,3.56,1.84,40,43,30,21,20,10,2421,156,317,151,131,164,317,500,333,0,0,0,0,110,191,0,0,'LAST_HIT','true'),
(20788,20788,'Rakul',0,'',0,'LineageMonster.rakul',30.00,39.00,35,'male','L2Monster',40,1220,446,7.11,1.84,40,43,30,21,20,10,2120,125,192,169,89,137,278,0,333,3,0,0,0,60,174,1,0,'LAST_HIT','true'),
(20789,20789,'Crokian',0,'',0,'LineageMonster.crokian',18.00,29.00,36,'male','L2Monster',40,1279,463,7.11,1.84,40,43,30,21,20,10,1999,121,187,193,96,142,278,500,333,5128,0,0,0,18,174,0,0,'LAST_HIT','true'),
(20790,20790,'Dailaon',0,'',0,'LineageMonster.dailaon',20.00,28.00,37,'male','L2Monster',500,1338,480,7.11,1.84,40,43,30,21,20,10,2567,158,448,200,104,147,247,0,333,5127,0,0,0,18,174,0,0,'LAST_HIT','true'),
(20791,20791,'Crokian Warrior',0,'',0,'LineageMonster.crokian',18.00,29.00,38,'male','L2Monster',40,1400,497,14.22,1.84,40,43,30,21,20,10,2211,138,261,171,112,153,278,500,333,5128,0,0,0,18,174,0,0,'LAST_HIT','true'),
(20792,20792,'Farhite',0,'',0,'LineageMonster.farhite',16.00,31.00,39,'male','L2Monster',40,1462,514,14.22,1.84,40,43,30,21,20,10,2057,131,280,150,121,158,278,0,333,5131,0,0,0,15,174,0,0,'LAST_HIT','true'),
(20793,20793,'Nos',0,'',0,'LineageMonster.nos',26.00,42.00,40,'male','L2Monster',40,1527,531,14.22,1.84,40,43,30,21,20,10,2251,145,300,183,131,164,278,500,333,5130,0,0,0,18,174,0,2,'LAST_HIT','true'),
(20794,20794,'Blade Stakato',0,'',0,'LineageMonster.blade_stakato',15.00,36.00,41,'male','L2Monster',40,1593,560,17.38,2.14,40,43,30,21,20,10,2103,137,265,229,141,169,278,0,333,223,0,0,0,27,191,0,2,'LAST_HIT','false'),
(20795,20795,'Blade Stakato Worker',0,'',0,'LineageMonster.blade_stakato_worker',13.00,40.00,42,'male','L2Monster',40,1660,589,17.38,2.14,40,43,30,21,20,10,1988,132,272,215,152,175,317,0,333,226,0,0,0,27,191,0,2,'LAST_HIT','false'),
(20796,20796,'Blade Stakato Warrior',0,'',0,'LineageMonster.blade_stakato_soldier',15.00,38.00,43,'male','L2Monster',40,1728,618,17.38,2.14,40,43,30,21,20,10,2125,143,365,202,163,181,278,500,333,232,0,0,0,27,191,0,2,'LAST_HIT','false'),
(20797,20797,'Blade Stakato Drone',0,'',0,'LineageMonster.blade_stakato_drone',15.00,39.00,44,'male','L2Monster',40,1799,648,26.07,2.14,40,43,30,21,20,10,2154,147,390,178,176,187,278,0,333,74,0,0,0,27,191,0,3,'LAST_HIT','false'),
(20798,20798,'Water Giant',0,'',0,'LineageMonster.water_giant',13.00,44.00,45,'male','L2Monster',40,1870,677,17.38,2.14,40,43,30,21,20,10,2612,181,343,262,188,193,278,500,333,5132,0,0,0,38,191,0,3,'LAST_HIT','false'),
(20799,20799,'Queen Undine Lad',0,'',0,'LineageMonster.undine',12.00,27.00,46,'female','L2Monster',40,1943,707,17.38,2.14,40,43,30,21,20,10,2630,186,442,190,202,199,278,0,333,0,0,0,0,66,191,0,3,'LAST_HIT','false'),
(20800,20800,'Eva\'s Seeker',0,'',0,'LineageMonster.field_stalker',15.00,30.00,47,'male','L2Monster',40,2016,738,17.38,2.14,40,43,30,21,20,10,2465,176,388,279,216,206,278,0,333,0,0,0,0,77,191,0,4,'LAST_HIT','false'),
(20801,20801,'Theeder Piker',0,'',0,'LineageMonster.theeder',9.00,32.00,48,'male','L2Monster',80,2091,768,17.38,2.14,40,43,30,21,20,10,2972,217,481,288,231,212,237,500,333,302,0,0,0,88,191,0,4,'LAST_HIT','false'),
(20802,20802,'Theeder Mage',0,'',0,'LineageMonster.theeder',9.00,32.00,49,'male','L2Monster',40,2168,799,17.38,2.14,40,43,30,21,20,10,3025,223,529,208,247,219,278,0,333,192,0,0,0,88,191,0,4,'LAST_HIT','false'),
(20803,20803,'Doll Master',0,'',0,'LineageMonster.doll_master',20.00,42.00,50,'male','L2Monster',40,2245,830,26.07,2.14,40,43,30,21,20,10,3949,297,616,230,264,226,278,500,333,0,0,0,0,88,191,1,5,'LAST_HIT','false'),
(20804,20804,'Crokian Lad',0,'',0,'LineageMonster.crokian_100_bi',36.00,61.00,41,'male','L2Monster',40,1593,560,17.38,2.14,40,43,30,21,20,10,2574,168,291,208,141,169,278,500,333,5128,0,0,0,18,174,0,0,'LAST_HIT','false'),
(20805,20805,'Dailaon Lad',0,'',0,'LineageMonster.dailaon_100_bi',40.00,58.00,42,'male','L2Monster',500,1660,589,17.38,2.14,40,43,30,21,20,10,2790,186,762,196,152,175,247,0,333,5127,0,0,0,18,174,0,0,'LAST_HIT','false'),
(20806,20806,'Crokian Lad Warrior',0,'',0,'LineageMonster.crokian_100_bi',36.00,61.00,43,'male','L2Monster',40,1728,618,17.38,2.14,40,43,30,21,20,10,2678,181,365,202,163,181,278,500,333,5128,0,0,0,18,174,0,0,'LAST_HIT','false'),
(20807,20807,'Farhite Lad',0,'',0,'LineageMonster.farhite_50_bi',24.00,48.00,44,'male','L2Monster',40,1799,648,17.38,2.14,40,43,30,21,20,10,2817,193,390,178,176,187,278,0,333,5131,0,0,0,15,174,0,0,'LAST_HIT','false'),
(20808,20808,'Nos Lad',0,'',0,'LineageMonster.nos_100_bi',52.00,86.00,45,'male','L2Monster',40,1870,677,17.38,2.14,40,43,30,21,20,10,3487,242,343,262,188,193,278,500,333,128,0,0,0,18,174,0,0,'LAST_HIT','false'),
(20809,20809,'Ghost of the Tower',0,'',0,'LineageMonster.human_ghost',8.00,22.00,60,'male','L2Monster',40,3054,1150,30.81,2.45,40,43,30,21,20,10,4045,351,860,368,478,299,278,500,333,0,0,0,0,80,143,1,0,'LAST_HIT','false'),
(20810,20810,'Seer of Hallate',0,'',0,'LineageMonster.field_stalker',15.00,30.00,60,'male','L2Monster',40,3054,1150,30.81,2.45,40,43,30,21,20,10,4045,351,946,335,478,299,278,500,333,0,0,0,0,70,170,0,0,'LAST_HIT','false'),
(20811,20811,'Ghastly Warrior',0,'',0,'LineageMonster.unpleasant_humming',12.00,26.00,61,'male','L2Monster',40,3137,1184,35.55,2.78,40,43,30,21,20,10,4769,419,717,416,505,307,412,500,333,0,0,0,0,21,150,1,0,'LAST_HIT','false'),
(20812,20812,'Archer of Despair',0,'',0,'LineageMonster.skeleton_archer',11.00,27.00,61,'male','L2Monster',500,3137,1184,35.55,2.78,40,43,30,21,20,10,4708,414,2204,292,505,307,247,500,333,284,0,0,0,40,160,1,0,'LAST_HIT','false'),
(20813,20813,'Crendion',0,'',0,'LineageMonster.liviona',15.00,28.00,62,'male','L2Monster',40,3219,1217,35.55,2.78,40,43,30,21,20,10,4276,381,944,388,532,315,278,500,333,0,0,0,0,80,160,0,0,'LAST_HIT','false'),
(20814,20814,'Blader of Despair',0,'',0,'LineageMonster.spartoi',11.00,27.00,62,'male','L2Monster',80,3219,1217,35.55,2.78,40,43,30,21,20,10,4938,440,1212,353,532,315,236,500,333,79,0,0,0,60,143,1,0,'LAST_HIT','false'),
(20815,20815,'Hound Dog of Hallate',0,'',0,'LineageMonster.dire_wolf',13.00,11.00,63,'male','L2Monster',40,3302,1251,47.40,2.78,40,43,30,21,20,10,4583,413,897,438,560,323,278,500,333,0,0,0,0,24,165,0,0,'LAST_HIT','false'),
(20816,20816,'Hallate\'s Royal Guard',0,'',0,'LineageMonster.skeleton_royal_guard',11.00,28.50,63,'male','L2Monster',40,3302,1251,35.55,2.78,40,43,30,21,20,10,5098,460,785,438,560,323,317,500,333,946,945,0,0,80,164,1,0,'LAST_HIT','false'),
(20817,20817,'Corrupt Sage',0,'',0,'LineageMonster.vale_master',12.00,40.00,64,'male','L2Monster',40,3384,1285,35.55,2.78,40,43,30,21,20,10,5315,486,1135,315,589,331,278,500,333,210,0,0,0,77,176,0,0,'LAST_HIT','false'),
(20818,20818,'Hallate\'s Warrior',0,'',0,'LineageMonster.skeleton_knight',10.00,25.00,64,'male','L2Monster',40,3384,1285,35.55,2.78,40,43,30,21,20,10,4926,451,1135,371,589,331,278,500,333,78,0,0,0,44,176,1,0,'LAST_HIT','false'),
(20819,20819,'Archer of Abyss',0,'',0,'LineageMonster.fiend_archer',17.00,55.00,65,'male','L2Monster',500,3465,1319,35.55,2.78,40,43,30,21,20,10,4889,454,2632,380,619,340,249,500,333,0,0,0,0,77,181,0,0,'LAST_HIT','false'),
(20820,20820,'Hallate\'s Knight',0,'',0,'LineageMonster.death_knight',12.00,31.00,65,'male','L2Monster',40,3465,1319,47.40,2.78,40,43,30,21,20,10,7310,679,979,460,619,340,278,500,333,80,0,0,0,29,176,1,0,'LAST_HIT','false'),
(20821,20821,'Erin Ediunce',0,'',0,'LineageMonster.banshee',9.00,23.00,66,'female','L2Monster',40,3546,1353,47.40,2.78,40,43,30,21,20,10,5335,502,1020,401,649,348,278,500,333,3939,0,0,0,88,181,0,10,'LAST_HIT','false'),
(20822,20822,'Hallate\'s Maid',0,'',0,'LineageMonster.bloody_queen',14.00,40.00,66,'female','L2Monster',40,3546,1353,47.40,2.78,40,43,30,21,20,10,4964,467,893,471,649,348,317,500,333,0,0,0,0,88,176,0,0,'LAST_HIT','false'),
(20823,20823,'Platinum Tribe Soldier',0,'',0,'LineageMonster.kel_mahum',13.00,26.00,67,'male','L2Monster',40,3626,1388,47.40,2.78,40,43,30,21,20,10,5764,549,1126,399,681,356,317,500,333,242,0,0,0,55,176,0,10,'LAST_HIT','false'),
(20824,20824,'Hallate\'s Commander',0,'',0,'LineageMonster.death_blader',15.00,45.00,67,'male','L2Monster',40,3626,1388,47.40,2.78,40,43,30,21,20,10,5184,493,1286,399,681,356,278,500,333,1472,0,0,0,110,187,1,0,'LAST_HIT','false'),
(20825,20825,'Hallate\'s Inspector',0,'',0,'LineageMonster.karik_25_bi',31.00,110.00,68,'male','L2Monster',40,3706,1423,47.40,2.78,40,43,30,21,20,10,5414,523,1339,408,713,365,278,500,333,0,0,0,0,40,187,0,0,'LAST_HIT','false'),
(20826,20826,'Platinum Tribe Archer',0,'',0,'LineageMonster.kel_mahum_archer',13.00,27.00,68,'male','L2Monster',500,3706,1423,35.55,2.78,40,43,30,21,20,10,7650,739,2975,347,713,365,249,500,333,288,0,0,0,55,176,0,10,'LAST_HIT','false'),
(20827,20827,'Platinum Tribe Warrior',0,'',0,'LineageMonster.kel_mahum_warrior',13.00,28.00,69,'male','L2Monster',40,3784,1458,47.40,2.78,40,43,30,21,20,10,5991,586,1150,506,746,373,278,500,333,148,0,0,0,55,176,0,10,'LAST_HIT','false'),
(20828,20828,'Platinum Tribe Shaman',0,'',0,'LineageMonster.kel_mahum_witch_doctor',13.00,25.00,70,'male','L2Monster',40,3862,1493,59.25,2.78,40,43,30,21,20,10,5881,583,1445,427,780,382,278,500,333,202,0,0,0,55,176,0,10,'LAST_HIT','false'),
(20829,20829,'Platinum Tribe Overlord',0,'',0,'LineageMonster.kel_mahum_champion',13.00,32.00,71,'male','L2Monster',40,3938,1529,67.15,3.09,40,43,30,21,20,10,8449,847,1239,529,814,390,278,500,333,147,0,0,0,55,187,0,10,'LAST_HIT','false'),
(20830,20830,'Guardian Angel',0,'',0,'LineageMonster.angel',13.50,36.50,72,'male','L2Monster',40,4013,1565,53.72,3.09,40,43,30,21,20,10,0,0,1710,406,849,399,278,500,333,148,0,0,0,33,187,0,10,'LAST_HIT','false'),
(20831,20831,'Seal Angel',0,'',0,'LineageMonster.angel',13.50,36.50,73,'male','L2Monster',40,4086,1601,67.15,3.09,40,43,30,21,20,10,0,0,1770,415,885,407,278,500,333,148,0,0,0,30,170,0,10,'LAST_HIT','false'),
(20832,20832,'Zaken\'s Pikeman',0,'',0,'LineageMonster.skeleton_pikeman',10.00,28.00,43,'male','L2Monster',40,1728,618,8.69,2.14,40,43,30,21,20,10,2720,184,249,252,163,181,278,500,333,292,0,0,0,50,174,1,0,'LAST_HIT','false'),
(20833,20833,'Zaken\'s Archer',0,'',0,'LineageMonster.skeleton_archer',11.00,27.00,44,'male','L2Monster',500,1799,648,8.69,2.14,40,43,30,21,20,10,3025,207,592,260,176,187,247,0,333,279,0,0,0,40,174,1,0,'LAST_HIT','false'),
(20834,20834,'Mardian',0,'',0,'LineageMonster.giant_spider',26.00,25.50,42,'male','L2Monster',40,1660,589,17.38,2.14,40,43,30,21,20,10,2251,150,342,196,152,175,278,500,333,0,0,0,0,79,191,0,0,'LAST_HIT','false'),
(20835,20835,'Zaken\'s Seer',0,'',0,'LineageMonster.liviona',15.00,28.00,45,'male','L2Monster',40,1870,677,8.69,2.14,40,43,30,21,20,10,2478,172,283,269,188,193,278,500,333,0,0,0,0,80,174,0,0,'LAST_HIT','false'),
(20836,20836,'Pirate Zombie',0,'',0,'LineageMonster.pirates_zombie',10.00,23.00,44,'male','L2Monster',40,1799,648,17.38,2.14,40,43,30,21,20,10,2832,194,341,209,176,187,317,0,333,225,0,0,0,11,174,1,0,'LAST_HIT','false'),
(20837,20837,'Tainted Ogre',0,'',0,'LineageMonster.ogre',21.00,44.00,45,'male','L2Monster',40,1870,677,17.38,2.14,40,43,30,21,20,10,2565,178,577,216,188,193,200,500,333,194,0,0,0,24,191,0,0,'LAST_HIT','false'),
(20838,20838,'Bloody Bat',0,'',0,'LineageMonster.vampire_bat',10.00,33.50,45,'male','L2Monster',40,1870,677,17.38,2.14,40,43,30,21,20,10,2405,167,300,262,188,193,317,0,333,0,0,0,0,66,191,0,0,'LAST_HIT','false'),
(20839,20839,'Unpleasant Humming',0,'',0,'LineageMonster.unpleasant_humming',12.00,26.00,46,'male','L2Monster',40,1943,707,8.69,2.14,40,43,30,21,20,10,2877,204,301,327,202,199,278,500,333,0,0,0,0,21,174,1,3,'LAST_HIT','false'),
(20840,20840,'Death Flyer',0,'',0,'LineageMonster.dark_horror',20.00,35.00,47,'male','L2Monster',40,2016,738,8.69,2.14,40,43,30,21,20,10,2971,213,320,287,216,206,278,0,333,0,0,0,0,100,174,1,4,'LAST_HIT','false'),
(20841,20841,'Fiend Archer',0,'',0,'LineageMonster.fiend_archer',17.00,55.00,48,'male','L2Monster',500,2091,768,8.69,2.14,40,43,30,21,20,10,3052,223,757,296,231,212,247,500,333,0,0,0,0,70,174,0,4,'LAST_HIT','false'),
(20842,20842,'Musveren',0,'',0,'LineageMonster.field_stalker',15.00,30.00,49,'male','L2Monster',40,2168,799,8.69,2.14,40,43,30,21,20,10,2910,215,361,359,247,219,278,0,333,0,0,0,0,70,174,0,4,'LAST_HIT','false'),
(20843,20843,'Zaken\'s Royal Guard',0,'',0,'LineageMonster.skeleton_royal_guard',11.00,28.50,50,'male','L2Monster',40,2245,830,8.69,2.14,40,43,30,21,20,10,3677,277,335,370,264,226,317,500,333,225,945,0,0,80,174,1,5,'LAST_HIT','false'),
(20844,20844,'Kaim Vanul',0,'',0,'LineageMonster.kaim_vanul',24.00,40.00,51,'male','L2Monster',40,2323,861,10.27,2.45,40,43,30,21,20,10,3279,250,405,381,281,232,278,0,333,0,0,0,0,37,174,0,5,'LAST_HIT','false'),
(20845,20845,'Pirate\'s Zombie Captain',0,'',0,'LineageMonster.pirates_zombie_captain',17.00,28.00,52,'male','L2Monster',40,2402,892,10.27,2.45,40,43,30,21,20,10,4954,383,375,393,300,239,317,500,333,232,0,0,0,14,174,1,5,'LAST_HIT','false'),
(20846,20846,'Doll Blader',0,'',0,'LineageMonster.doll_blader',6.00,12.00,53,'male','L2Monster',40,2481,923,10.27,2.45,40,43,30,21,20,10,3931,309,396,344,319,247,317,0,333,5129,5129,0,0,22,174,0,6,'LAST_HIT','false'),
(20847,20847,'Vale Master',0,'',0,'LineageMonster.vale_master',12.00,40.00,54,'male','L2Monster',40,2562,955,10.27,2.45,40,43,30,21,20,10,3750,299,477,354,339,254,278,500,333,0,0,0,0,70,174,0,6,'LAST_HIT','false'),
(20848,20848,'Light Bringer',0,'',0,'LineageMonster.light_bringer',10.00,23.00,46,'male','L2Monster',40,1943,707,17.38,2.14,40,43,30,21,20,10,2432,172,401,245,202,199,278,500,333,0,0,0,0,60,174,0,3,'LAST_HIT','false'),
(20849,20849,'Light Worm',0,'',0,'LineageMonster.light_worm',5.00,16.00,41,'male','L2Monster',40,1593,560,17.38,2.14,40,43,30,21,20,10,1932,126,265,229,141,169,278,500,333,0,0,0,0,66,191,0,2,'LAST_HIT','false'),
(20850,20850,'Golden Stag Lord',0,'',0,'LineageMonster.golden_stag_lord',25.00,30.00,50,'male','L2Monster',40,2245,830,8.69,2.14,40,43,30,21,20,10,3152,237,509,278,264,226,278,0,333,0,0,0,0,38,191,0,0,'LAST_HIT','false'),
(20851,20851,'Theeder',0,'',0,'LineageMonster.theeder',9.00,32.00,47,'male','L2Monster',40,2016,738,8.69,2.14,40,43,30,21,20,10,2841,204,498,253,216,206,237,500,333,0,0,0,0,88,191,0,0,'LAST_HIT','false'),
(20852,20852,'Banshee',0,'',0,'LineageMonster.banshee',9.00,23.00,60,'female','L2Monster',40,3054,1150,10.27,2.45,40,43,30,21,20,10,4450,386,828,335,478,299,317,500,333,3939,0,0,0,88,191,0,0,'LAST_HIT','false'),
(20853,20853,'Kel Mahum',0,'',0,'LineageMonster.kel_mahum',13.00,26.00,65,'male','L2Monster',40,3465,1319,11.85,2.78,40,43,30,21,20,10,7824,727,942,418,619,340,317,500,333,242,0,0,0,55,191,0,0,'LAST_HIT','false'),
(20854,20854,'Kel Mahum Warrior',0,'',0,'LineageMonster.kel_mahum_warrior',13.00,28.00,66,'male','L2Monster',40,3546,1353,11.85,2.78,40,43,30,21,20,10,7686,723,1235,389,649,348,278,500,333,148,0,0,0,55,191,0,0,'LAST_HIT','false'),
(20855,20855,'Kel Mahum Archer',0,'',0,'LineageMonster.kel_mahum_archer',13.00,27.00,67,'male','L2Monster',500,3626,1388,11.85,2.78,40,43,30,21,20,10,8900,848,2859,339,681,356,249,0,333,288,0,0,0,55,191,0,0,'LAST_HIT','false'),
(20856,20856,'Kel Mahum Shaman',0,'',0,'LineageMonster.kel_mahum_witch_doctor',13.00,25.00,68,'male','L2Monster',40,3706,1423,11.85,2.78,40,43,30,21,20,10,6390,617,1339,347,713,365,278,500,333,202,0,0,0,55,191,0,0,'LAST_HIT','false'),
(20857,20857,'Kel Mahum Champion',0,'',0,'LineageMonster.kel_mahum_champion',13.00,32.00,70,'male','L2Monster',40,3862,1493,11.85,2.78,40,43,30,21,20,10,8149,808,1445,427,780,382,278,500,333,147,0,0,0,55,191,0,0,'LAST_HIT','false'),
(20858,20858,'Angel',0,'',0,'LineageMonster.angel',13.50,36.50,72,'male','L2Monster',40,4013,1565,13.43,3.09,40,43,30,21,20,10,9102,925,1554,446,849,399,278,500,333,148,0,0,0,33,191,0,0,'LAST_HIT','false'),
(20859,20859,'Guardian Angel',0,'',0,'LineageMonster.angel',13.50,36.50,72,'male','L2Monster',40,4013,1565,53.72,3.09,40,43,30,21,20,10,12443,1264,1554,446,849,399,278,500,333,148,0,0,0,33,187,0,0,'LAST_HIT','false'),
(20860,20860,'Seal Angel',0,'',0,'LineageMonster.angel',13.50,36.50,73,'male','L2Monster',40,4086,1601,67.15,3.09,40,43,30,21,20,10,13949,1435,1330,552,885,407,278,500,333,148,0,0,0,33,187,0,10,'LAST_HIT','false'),
(20861,20861,'Oel Mahum Champion',0,'',0,'LineageMonster.oel_mahum_champion',23.00,61.00,56,'male','L2Monster',40,2724,1019,10.27,2.45,40,43,30,21,20,10,5533,454,777,301,382,269,278,500,333,127,0,0,0,73,191,0,0,'LAST_HIT','false'),
(20862,20862,'Death Lord',0,'',0,'LineageMonster.death_lord',21.00,40.00,75,'male','L2Monster',40,4229,1673,13.43,3.09,40,43,30,21,20,10,7774,820,1720,475,957,425,278,0,333,78,0,0,0,44,191,1,0,'LAST_HIT','false'),
(20919,20919,'Maille Lizardman',0,'',0,'LineageMonster.virud_lizardman',10.00,23.00,20,'male','L2Monster',40,541,213,1.98,1.21,40,43,30,21,20,10,641,28,57,94,23,76,278,0,333,291,0,0,0,43,130,0,0,'LAST_HIT','true'),
(20920,20920,'Maille Lizardman Scout',0,'',0,'LineageMonster.virud_lizardman_scout',10.00,22.00,22,'male','L2Monster',500,611,242,2.77,1.53,40,43,30,21,20,10,1187,56,153,102,28,83,247,0,333,2507,0,0,0,43,130,0,0,'LAST_HIT','true'),
(20921,20921,'Maille Lizardman Guard',0,'',0,'LineageMonster.virud_lizardman',10.00,23.00,24,'male','L2Monster',40,687,272,2.77,1.53,40,43,30,21,20,10,858,42,81,111,34,90,278,500,333,291,0,0,0,43,130,0,0,'LAST_HIT','true'),
(20922,20922,'Maille Lizardman Warrior',0,'',0,'LineageMonster.virud_lizardman_warrior',12.00,30.00,26,'male','L2Monster',40,770,303,2.77,1.53,40,43,30,21,20,10,951,48,96,120,41,98,278,0,333,16,0,0,0,52,130,0,0,'LAST_HIT','true'),
(20923,20923,'Maille Lizardman Shaman',0,'',0,'LineageMonster.virud_lizardman_shaman',10.00,29.00,28,'male','L2Monster',40,859,334,2.77,1.53,40,43,30,21,20,10,1392,74,113,130,49,106,278,0,333,7,0,0,0,47,132,0,0,'LAST_HIT','true'),
(20924,20924,'Maille Lizardman Matriarch',0,'',0,'LineageMonster.virud_lizardman_matriarch',13.00,37.00,30,'male','L2Monster',40,954,365,2.77,1.53,40,43,30,21,20,10,1708,94,132,140,58,114,278,500,333,69,627,0,0,61,143,0,0,'LAST_HIT','true'),
(20925,20925,'Giant Araneid',0,'',0,'LineageMonster.giant_spider',26.00,25.50,24,'male','L2Monster',40,687,272,2.77,1.53,40,43,30,21,20,10,875,44,81,94,34,90,278,0,333,0,0,0,0,72,130,0,0,'LAST_HIT','true'),
(20926,20926,'Poison Araneid',0,'',0,'LineageMonster.poison_spider',27.00,25.50,25,'male','L2Monster',40,728,287,2.77,1.53,40,43,30,21,20,10,1012,50,88,98,37,94,278,0,333,0,0,0,0,60,140,0,0,'LAST_HIT','true'),
(20927,20927,'King of the Araneid',0,'',0,'LineageMonster.giant_spider_50_bi',39.00,38.00,27,'male','L2Monster',40,813,318,2.77,1.53,40,43,30,21,20,10,1453,74,104,106,45,102,278,500,333,0,0,0,0,72,130,0,0,'LAST_HIT','true'),
(20928,20928,'Hatu Weird Bee',0,'',0,'LineageMonster.giant_bee',8.00,24.50,30,'male','L2Monster',40,954,365,2.77,1.53,40,43,30,21,20,10,1468,80,132,140,58,114,278,500,333,0,0,0,0,99,132,0,0,'LAST_HIT','true'),
(20929,20929,'Hatu Dire Wolf',0,'',0,'LineageMonster.dire_wolf',13.00,11.00,32,'male','L2Monster',40,1056,397,3.56,1.84,40,43,30,21,20,10,1393,78,154,151,69,123,278,0,333,0,0,0,0,26,121,0,0,'LAST_HIT','true'),
(20930,20930,'Hatu Brown Bear',0,'',0,'LineageMonster.grizzly',21.00,40.00,34,'male','L2Monster',40,1164,430,3.56,1.84,40,43,30,21,20,10,2195,128,178,163,82,132,278,300,333,0,0,0,0,44,157,0,0,'LAST_HIT','true'),
(20931,20931,'Hatu Onyx Beast',0,'',0,'LineageMonster.onyx_beast',14.00,14.50,36,'male','L2Monster',40,1279,463,3.56,1.84,40,43,30,21,20,10,2035,124,206,175,96,142,278,0,333,0,0,0,0,30,174,0,0,'LAST_HIT','true'),
(20932,20932,'Hatu Crimson Bear',0,'',0,'LineageMonster.crimson_bear',19.00,36.00,38,'male','L2Monster',40,1400,497,3.56,1.84,40,43,30,21,20,10,2688,168,238,188,112,153,278,0,333,0,0,0,0,37,174,0,0,'LAST_HIT','true'),
(20933,20933,'Hatu Windsus',0,'',0,'LineageMonster.giant_wild_hog',35.00,27.00,40,'male','L2Monster',40,1527,531,3.56,1.84,40,43,30,21,20,10,3080,198,273,201,131,164,278,500,333,0,0,0,0,35,174,0,0,'LAST_HIT','true'),
(20934,20934,'Wasp Worker',0,'',0,'LineageMonster.giant_bee_bi',8.00,32.00,35,'male','L2Monster',40,1220,446,3.56,1.84,40,43,30,21,20,10,1651,98,192,144,89,137,278,0,333,0,0,0,0,99,191,0,0,'LAST_HIT','true'),
(20935,20935,'Wasp Leader',0,'',0,'LineageMonster.giant_bee_100_bi',16.00,49.00,37,'male','L2Monster',40,1338,480,3.56,1.84,40,43,30,21,20,10,1809,112,222,154,104,147,278,300,333,0,0,0,0,90,174,0,0,'LAST_HIT','true'),
(20936,20936,'Tanor Silenos',0,'',0,'LineageMonster.heltor_silenos',13.00,29.00,40,'male','L2Monster',40,1527,531,3.56,1.84,40,43,30,21,20,10,3443,222,273,201,131,164,278,0,333,88,0,0,0,34,174,0,0,'LAST_HIT','false'),
(20937,20937,'Tanor Silenos Grunt',0,'',0,'LineageMonster.heltor_silenos',13.00,29.00,42,'male','L2Minion',40,1660,589,4.35,2.14,40,43,30,21,20,10,4498,300,311,215,152,175,278,0,333,158,18,0,0,34,174,0,0,'LAST_HIT','false'),
(20938,20938,'Tanor Silenos Scout',0,'',0,'LineageMonster.heltor_silenos',13.00,29.00,44,'male','L2Minion',40,1799,648,4.35,2.14,40,43,30,21,20,10,4937,338,354,230,176,187,278,0,333,5,0,0,0,34,174,0,0,'LAST_HIT','false'),
(20939,20939,'Tanor Silenos Warrior',0,'',0,'LineageMonster.heltor_silenos_warrior',13.00,31.00,46,'male','L2Minion',40,1943,707,4.35,2.14,40,43,30,21,20,10,5504,390,401,245,202,199,278,500,333,160,0,0,0,36,174,0,0,'LAST_HIT','false'),
(20940,20940,'Tanor Silenos Shaman',0,'',0,'LineageMonster.heltor_silenos_shaman',13.00,32.00,48,'male','L2Minion',40,2091,768,4.35,2.14,40,43,30,21,20,10,6707,490,453,261,231,212,278,0,333,9,0,0,0,29,174,0,0,'LAST_HIT','false'),
(20941,20941,'Tanor Silenos Chieftain',0,'',0,'LineageMonster.heltor_silenos_chieftain',13.00,31.50,50,'male','L2Monster',40,2245,830,4.35,2.14,40,43,30,21,20,10,6503,490,509,278,264,226,278,500,333,75,0,0,0,27,174,0,0,'LAST_HIT','false'),
(20942,20942,'Nightmare Guide',0,'',0,'LineageMonster.harpy',10.00,42.00,43,'female','L2Minion',40,1728,618,4.35,2.14,40,43,30,21,20,10,3282,222,332,189,163,181,278,0,333,0,0,0,0,60,174,0,0,'LAST_HIT','false'),
(20943,20943,'Nightmare Keeper',0,'',0,'LineageMonster.harpy',10.00,42.00,45,'female','L2Minion',40,1870,677,4.35,2.14,40,43,30,21,20,10,4721,328,377,202,188,193,278,0,333,0,0,0,0,60,174,0,0,'LAST_HIT','false'),
(20944,20944,'Nightmare Lord',0,'',0,'LineageMonster.succubus_100_bi',20.00,75.00,47,'female','L2Monster',40,2016,738,4.35,2.14,40,43,30,21,20,10,4000,286,427,215,216,206,300,500,359,0,0,0,0,60,174,0,0,'LAST_HIT','false'),
(20945,20945,'Cadeine',0,'',0,'LineageMonster.hobgoblin',12.00,24.00,50,'male','L2Minion',40,2245,830,4.35,2.14,40,43,30,21,20,10,4483,338,509,278,264,226,278,0,333,127,625,0,0,45,174,0,0,'LAST_HIT','false'),
(20946,20946,'Sanhidro',0,'',0,'LineageMonster.troll',21.00,35.00,52,'male','L2Minion',40,2402,892,5.14,2.45,40,43,30,21,20,10,6896,534,570,295,300,239,278,0,333,0,0,0,0,55,174,0,0,'LAST_HIT','false'),
(20947,20947,'Connabi',0,'',0,'LineageMonster.bugbear',17.00,35.00,54,'male','L2Monster',40,2562,955,5.14,2.45,40,43,30,21,20,10,7437,592,636,313,339,254,300,0,359,88,0,0,0,55,174,0,0,'LAST_HIT','false'),
(20948,20948,'Bartal',0,'',0,'LineageMonster.liviona',15.00,28.00,56,'male','L2Minion',40,2724,1019,5.14,2.45,40,43,30,21,20,10,7385,606,706,331,382,269,278,0,333,0,0,0,0,88,191,0,0,'LAST_HIT','false'),
(20949,20949,'Luminun',0,'',0,'LineageMonster.twin_headed_giant',17.00,39.00,58,'male','L2Minion',40,2889,1084,5.14,2.45,40,43,30,21,20,10,8700,734,781,349,428,284,278,0,333,157,0,0,0,49,191,0,0,'LAST_HIT','false'),
(20950,20950,'Innersen',0,'',0,'LineageMonster.king_bugbear',15.00,40.00,60,'male','L2Monster',40,3054,1150,5.14,2.45,40,43,30,21,20,10,9365,812,860,368,478,299,278,500,333,160,0,0,0,60,191,0,0,'LAST_HIT','false'),
(20951,20951,'Pobby\'s Maid',0,'',0,'LineageMonster.manadragora',14.00,17.80,53,'female','L2Minion',40,2481,923,5.14,2.45,40,43,30,21,20,10,5037,396,602,258,319,247,278,0,333,0,0,0,0,80,174,0,0,'LAST_HIT','false'),
(20952,20952,'Pobby Escort',0,'',0,'LineageMonster.mandragora_b',12.00,25.50,55,'female','L2Minion',40,2643,987,5.14,2.45,40,43,30,21,20,10,9101,734,670,273,360,261,278,0,333,0,0,0,0,80,174,0,0,'LAST_HIT','false'),
(20953,20953,'Pobby',0,'',0,'LineageMonster.mandragora_a',15.00,26.00,57,'female','L2Monster',40,2806,1052,5.14,2.45,40,43,30,21,20,10,8452,702,743,289,405,276,278,500,333,0,0,0,0,80,174,0,0,'LAST_HIT','false'),
(20954,20954,'Hungered Corpse',0,'',0,'LineageMonster.skeleton',11.00,25.00,60,'male','L2Minion',40,3054,1150,5.14,2.45,40,43,30,21,20,10,9985,866,860,368,478,299,278,0,333,123,945,0,0,60,180,1,0,'LAST_HIT','false'),
(20955,20955,'Ghostly Warrior',0,'',0,'LineageMonster.skeleton_pikeman',10.00,28.00,62,'male','L2Minion',40,3219,1217,5.93,2.78,40,43,30,21,20,10,10662,950,944,388,532,315,278,0,333,299,0,0,0,50,180,1,0,'LAST_HIT','false'),
(20956,20956,'Past Knight',0,'',0,'LineageMonster.skeleton_knight',10.00,25.00,64,'male','L2Monster',40,3384,1285,5.93,2.78,40,43,30,21,20,10,11588,1060,1031,408,589,331,278,500,333,150,103,0,0,40,174,1,0,'LAST_HIT','false'),
(20957,20957,'Nihil Invader',0,'',0,'LineageMonster.skeleton_royal_guard',11.00,28.50,66,'male','L2Minion',40,3546,1353,5.93,2.78,40,43,30,21,20,10,12082,1138,1123,428,649,348,278,0,333,946,945,0,0,88,203,1,0,'LAST_HIT','false'),
(20958,20958,'Death Agent',0,'',0,'LineageMonster.death_blader',15.00,45.00,68,'male','L2Minion',40,3706,1423,5.93,2.78,40,43,30,21,20,10,9018,872,1217,449,713,365,278,0,333,1472,0,0,0,110,214,1,0,'LAST_HIT','false'),
(20959,20959,'Dark Guard',0,'',0,'LineageMonster.headless_knight',21.00,31.00,70,'male','L2Monster',40,3862,1493,5.93,2.78,40,43,30,21,20,10,13863,1374,1314,470,780,382,278,500,333,124,0,0,0,77,187,1,0,'LAST_HIT','false'),
(20960,20960,'Bloody Ghost',0,'',0,'LineageMonster.succubus',10.00,36.00,64,'female','L2Minion',40,3384,1285,5.93,2.78,40,43,30,21,20,10,7988,732,1031,347,589,331,278,0,333,0,0,0,0,66,192,0,0,'LAST_HIT','false'),
(20961,20961,'Bloody Knight',0,'',0,'LineageMonster.doll_blader',6.00,12.00,65,'male','L2Minion',40,3465,1319,5.93,2.78,40,43,30,21,20,10,11719,1088,1077,355,619,340,278,0,333,5129,5129,0,0,24,192,0,0,'LAST_HIT','false'),
(20962,20962,'Bloody Priest',0,'',0,'LineageMonster.bloody_queen',14.00,40.00,66,'female','L2Minion',40,3546,1353,5.93,2.78,40,43,30,21,20,10,13045,1228,1123,364,649,348,278,0,333,0,0,0,0,88,203,0,0,'LAST_HIT','false'),
(20963,20963,'Bloody Lord',0,'',0,'LineageMonster.banshee',9.00,23.00,68,'female','L2Monster',40,3706,1423,5.93,2.78,40,43,30,21,20,10,9382,906,1217,382,713,365,278,500,333,3939,0,0,0,88,198,0,0,'LAST_HIT','false'),
(20964,20964,'Huge Footmark',0,'',0,'LineageMonster.stone_golem',20.00,31.00,70,'male','L2Monster',40,3862,1493,5.93,2.78,40,43,30,21,20,10,13513,1340,1314,470,780,382,278,0,333,0,0,0,0,25,25,0,0,'LAST_HIT','false'),
(20965,20965,'Chimera Piece',0,'',0,'LineageMonster.will_o_wisp',34.00,28.00,72,'male','L2Monster',40,4013,1565,6.72,3.09,40,43,30,21,20,10,14379,1460,1413,491,849,399,278,0,333,0,0,0,0,66,191,0,0,'LAST_HIT','false'),
(20966,20966,'Changed Creation',0,'',0,'LineageMonster.leogul',15.00,35.00,74,'male','L2Monster',40,4158,1637,6.72,3.09,40,43,30,21,20,10,15493,1616,1513,512,921,416,278,0,333,0,0,0,0,80,170,0,0,'LAST_HIT','false'),
(20967,20967,'Past Creature',0,'',0,'LineageMonster.gamlin',11.00,32.00,76,'male','L2Monster',40,4297,1710,6.72,3.09,40,43,30,21,20,10,16021,1712,1614,534,994,433,278,0,333,0,0,0,0,88,187,0,0,'LAST_HIT','false'),
(20968,20968,'Nonexistent Man',0,'',0,'LineageMonster.susceptor',20.00,35.00,78,'male','L2Monster',40,4428,1784,6.72,3.09,40,43,30,21,20,10,15583,1706,1715,555,1069,451,278,0,333,0,0,0,0,29,165,0,0,'LAST_HIT','false'),
(20969,20969,'Giant\'s Shadow',0,'',0,'LineageMonster.lesser_giant_shooter',21.00,44.00,79,'male','L2Monster',500,4490,1821,6.72,3.09,40,43,30,21,20,10,13043,1446,3921,566,1107,459,249,0,333,4028,0,0,0,88,209,0,0,'LAST_HIT','false'),
(20970,20970,'Soldier of Ancient Times',0,'',0,'LineageMonster.lesser_giant',21.00,44.00,73,'male','L2Monster',40,4086,1601,6.72,3.09,40,43,30,21,20,10,10913,1122,1463,426,885,407,278,0,333,3937,0,0,0,16,209,0,0,'LAST_HIT','false'),
(20971,20971,'Warrior of Ancient Times',0,'',0,'LineageMonster.lesser_giant',21.00,44.00,75,'male','L2Monster',40,4229,1673,6.72,3.09,40,43,30,21,20,10,15602,1646,1563,445,957,425,278,0,333,3937,0,0,0,16,203,0,0,'LAST_HIT','false'),
(20972,20972,'Shaman of Ancient Times',0,'',0,'LineageMonster.lesser_giant_mage',21.00,44.00,75,'male','L2Monster',40,4229,1673,6.72,3.09,40,43,30,21,20,10,10970,1158,1563,445,957,425,278,0,333,3938,0,0,0,16,214,0,0,'LAST_HIT','false'),
(20973,20973,'Forgotten Ancient People',0,'',0,'LineageMonster.lesser_giant_mage',21.00,44.00,77,'male','L2Monster',40,4364,1747,6.72,3.09,40,43,30,21,20,10,16958,1836,1664,463,1031,442,278,0,333,3938,0,0,0,16,203,0,0,'LAST_HIT','false'),
(20974,20974,'Spiteful Soul Leader',0,'',0,'LineageMonster.skeleton_royal_guard_bi',16.00,44.00,65,'male','L2Monster',40,3465,1319,11.85,2.78,40,43,30,21,20,10,11772,1094,1077,418,619,340,278,0,333,946,945,0,0,88,191,1,0,'LAST_HIT','false'),
(20975,20975,'Spiteful Soul Wizard',0,'',0,'LineageMonster.elf_ghost_50_bi',10.00,32.00,63,'male','L2Minion',40,3302,1251,11.85,2.78,40,43,30,21,20,10,10499,948,987,398,560,323,278,0,333,0,0,0,0,88,191,1,0,'LAST_HIT','false'),
(20976,20976,'Spiteful Soul Fighter',0,'',0,'LineageMonster.human_ghost_50_bi',12.00,33.00,62,'male','L2Minion',40,3219,1217,11.85,2.78,40,43,30,21,20,10,8911,794,944,388,532,315,278,0,333,0,0,0,0,88,191,1,0,'LAST_HIT','false'),
(20977,20977,'Elmoradan\'s Lady',0,'',0,'LineageMonster.banshee_50_bi',13.50,38.00,65,'female','L2Monster',40,3465,1319,23.70,2.78,40,43,30,21,20,10,7513,698,979,460,619,340,278,500,333,3939,0,0,0,88,176,0,0,'LAST_HIT','false'),
(20978,20978,'Elmoradan\'s Archer Escort',0,'',0,'LineageMonster.skeleton_archer',11.00,27.00,64,'male','L2Minion',500,3384,1285,23.70,2.78,40,43,30,21,20,10,7470,684,2522,315,589,331,249,0,333,284,0,0,0,44,154,1,0,'LAST_HIT','false'),
(20979,20979,'Elmoradan\'s Maid',0,'',0,'LineageMonster.doll_blader',6.00,12.00,64,'male','L2Minion',40,3384,1285,23.70,2.78,40,43,30,21,20,10,7141,654,1135,371,589,331,278,0,333,5129,5129,0,0,24,187,0,0,'LAST_HIT','false'),
(20980,20980,'Hallate\'s Follower Mul',0,'',0,'LineageMonster.vale_master',12.00,40.00,68,'male','L2Monster',40,3706,1423,23.70,2.78,40,43,30,21,20,10,7606,735,1339,408,713,365,278,500,333,210,0,0,0,77,187,0,0,'LAST_HIT','false'),
(20981,20981,'Mul\'s Wizard',0,'',0,'LineageMonster.kaim_vanul_50_bi',36.00,60.00,67,'male','L2Minion',40,3626,1388,23.70,2.78,40,43,30,21,20,10,7564,720,1063,483,681,356,278,0,333,0,0,0,0,40,176,0,0,'LAST_HIT','false'),
(20982,20982,'Mul\'s Knight',0,'',0,'LineageMonster.dre_vanul_100_bi',28.00,75.00,67,'male','L2Minion',40,3626,1388,23.70,2.78,40,43,30,21,20,10,6676,636,1126,399,681,356,317,0,333,0,0,0,0,88,157,0,0,'LAST_HIT','false'),
(20983,20983,'Binder',0,'',0,'LineageMonster.kel_mahum_champion_50_bi',19.00,48.00,73,'male','L2Monster',40,4086,1601,26.86,3.09,40,43,30,21,20,10,10342,1064,1609,456,885,407,278,500,333,147,0,0,0,55,187,0,0,'LAST_HIT','false'),
(20984,20984,'Bound Warrior',0,'',0,'LineageMonster.kel_mahum_warrior',13.00,28.00,72,'male','L2Monster',40,4013,1565,26.86,3.09,40,43,30,21,20,10,9719,987,1554,446,849,399,278,0,333,148,0,0,0,55,176,0,0,'LAST_HIT','false'),
(20985,20985,'Bound Archer',0,'',0,'LineageMonster.kel_mahum_archer',13.00,27.00,72,'male','L2Monster',500,4013,1565,26.86,3.09,40,43,30,21,20,10,9647,980,3454,379,849,399,249,0,333,288,0,0,0,55,187,0,0,'LAST_HIT','false'),
(20986,20986,'Sairon',0,'',0,'LineageMonster.doll_blader_50_bi',9.00,20.50,54,'male','L2Monster',40,2562,955,20.54,2.45,40,43,30,21,20,10,5524,440,636,313,339,254,278,500,333,5129,5129,0,0,22,174,0,6,'LAST_HIT','false'),
(20987,20987,'Sairon\'s Doll',0,'',0,'LineageMonster.doll_blader',6.00,12.00,53,'male','L2Minion',40,2481,923,20.54,2.45,40,43,30,21,20,10,5025,395,602,304,319,247,278,0,333,5129,5129,0,0,22,174,0,6,'LAST_HIT','false'),
(20988,20988,'Sairon\'s Puppet',0,'',0,'LineageMonster.doll_blader',6.00,12.00,53,'male','L2Minion',40,2481,923,20.54,2.45,40,43,30,21,20,10,5527,434,602,304,319,247,278,0,333,5129,5129,0,0,22,174,0,6,'LAST_HIT','false'),
(20989,20989,'Lageos',0,'',0,'LineageMonster.marsh_stakato_drone_50_bi',13.00,37.00,38,'male','L2Monster',40,1400,497,7.11,1.84,40,43,30,21,20,10,2749,171,238,188,112,153,278,0,333,182,0,0,0,80,174,0,0,'LAST_HIT','false'),
(20990,20990,'Pageos',0,'',0,'LineageMonster.marsh_stakato_soldier',10.00,25.00,38,'male','L2Minion',40,1400,497,7.11,1.84,40,43,30,21,20,10,2609,163,238,188,112,153,278,0,333,128,0,0,0,30,174,0,0,'LAST_HIT','false'),
(20991,20991,'Swamp Tribe',0,'',0,'LineageMonster.farhite_50_bi',24.00,48.00,45,'male','L2Monster',40,1870,677,17.38,2.14,40,43,30,21,20,10,5139,357,377,238,188,193,278,500,333,5131,0,0,0,15,174,0,0,'LAST_HIT','false'),
(20992,20992,'Swamp Alligator',0,'',0,'LineageMonster.crokian',18.00,29.00,44,'male','L2Minion',40,1799,648,17.38,2.14,40,43,30,21,20,10,4600,315,354,230,176,187,278,0,333,5128,0,0,0,18,174,0,0,'LAST_HIT','false'),
(20993,20993,'Swamp Warrior',0,'',0,'LineageMonster.dailaon',20.00,28.00,44,'male','L2Minion',500,1799,648,17.38,2.14,40,43,30,21,20,10,4881,334,788,230,176,187,247,0,333,5127,0,0,0,18,174,0,0,'LAST_HIT','false'),
(20994,20994,'Garden Guard Leader',0,'',0,'LineageMonster.doll_master_50_bi',30.00,63.00,50,'male','L2Monster',40,2245,830,17.38,2.14,40,43,30,21,20,10,6194,466,560,253,264,226,278,500,333,0,0,0,0,88,191,1,5,'LAST_HIT','false'),
(20995,20995,'Garden Guard',0,'',0,'LineageMonster.theeder',9.00,32.00,48,'male','L2Minion',40,2091,768,17.38,2.14,40,43,30,21,20,10,4222,308,453,261,231,212,278,0,333,94,0,0,0,88,191,0,4,'LAST_HIT','false'),
(20996,20996,'Spiteful Ghost of Ruins',0,'',0,'LineageMonster.zombie',13.00,21.00,50,'male','L2Monster',40,2245,830,8.69,2.14,40,43,30,21,20,10,5349,403,560,253,264,226,278,500,333,0,0,0,0,16,16,1,0,'LAST_HIT','false'),
(20997,20997,'Soldier of Grief',0,'',0,'LineageMonster.unpleasant_humming',12.00,26.00,51,'male','L2Monster',40,2323,861,10.27,2.45,40,43,30,21,20,10,3782,288,593,260,281,232,278,0,333,0,0,0,0,23,165,1,0,'LAST_HIT','false'),
(20998,20998,'Cruel Punisher',0,'',0,'LineageMonster.hungry_spirit',30.00,40.00,52,'male','L2Monster',40,2402,892,10.27,2.45,40,43,30,21,20,10,4168,322,518,324,300,239,278,0,333,0,0,0,0,16,132,1,0,'LAST_HIT','false'),
(20999,20999,'Roving Soul',0,'',0,'LineageMonster.skeleton',11.00,25.00,53,'male','L2Monster',40,2481,923,10.27,2.45,40,43,30,21,20,10,4943,389,527,304,319,247,317,0,333,75,0,0,0,66,176,1,0,'LAST_HIT','false'),
(21000,21000,'Soul of Ruins',0,'',0,'LineageMonster.human_ghost',8.00,22.00,54,'male','L2Monster',40,2562,955,10.27,2.45,40,43,30,21,20,10,4325,345,578,344,339,254,278,500,333,0,0,0,0,80,174,1,0,'LAST_HIT','false'),
(21001,21001,'Wretched Archer',0,'',0,'LineageMonster.skeleton_archer',11.00,27.00,55,'male','L2Monster',500,2643,987,10.27,2.45,40,43,30,21,20,10,5856,473,1639,292,360,261,247,0,333,282,0,0,0,40,174,1,0,'LAST_HIT','true'),
(21002,21002,'Doom Scout',0,'',0,'LineageMonster.skeleton_royal_guard',11.00,28.50,56,'male','L2Monster',40,2724,1019,10.27,2.45,40,43,30,21,20,10,5163,424,679,301,382,269,317,500,333,242,2496,0,0,80,174,1,0,'LAST_HIT','true'),
(21003,21003,'Grave Lich',0,'',0,'LineageMonster.liviona',15.00,28.00,57,'male','L2Monster',40,2806,1052,10.27,2.45,40,43,30,21,20,10,4725,393,675,374,405,276,278,0,333,0,0,0,0,80,174,0,0,'LAST_HIT','true'),
(21004,21004,'Dismal Pole',0,'',0,'LineageMonster.hanged_man_ripper',35.00,80.00,58,'male','L2Monster',80,2889,1084,10.27,2.45,40,43,30,21,20,10,5239,443,828,384,428,284,236,500,333,0,0,0,0,55,174,0,0,'LAST_HIT','true'),
(21005,21005,'Grave Predator',0,'',0,'LineageMonster.devastator',35.00,35.00,59,'male','L2Monster',40,2971,1117,10.27,2.45,40,43,30,21,20,10,5732,490,902,326,453,291,278,500,333,0,0,0,0,25,174,0,0,'LAST_HIT','true'),
(21006,21006,'Doom Servant',0,'',0,'LineageMonster.hungry_spirit',30.00,40.00,60,'male','L2Monster',40,3054,1150,10.27,2.45,40,43,30,21,20,10,5447,473,946,335,478,299,278,500,333,0,0,0,0,16,191,1,8,'LAST_HIT','false'),
(21007,21007,'Doom Guard',0,'',0,'LineageMonster.hungry_spirit',30.00,40.00,61,'male','L2Monster',40,3137,1184,11.85,2.78,40,43,30,21,20,10,5844,514,992,344,505,307,278,0,333,0,0,0,0,16,191,1,9,'LAST_HIT','false'),
(21008,21008,'Doom Archer',0,'',0,'LineageMonster.skeleton_archer',11.00,27.00,62,'male','L2Monster',500,3219,1217,11.85,2.78,40,43,30,21,20,10,7471,666,2308,353,532,315,249,500,333,286,0,0,0,44,191,1,9,'LAST_HIT','false'),
(21009,21009,'Doom Trooper',0,'',0,'LineageMonster.skeleton_pikeman',12.00,33.00,63,'male','L2Monster',80,3302,1251,11.85,2.78,40,43,30,21,20,10,7966,719,1267,362,560,323,236,0,333,301,0,0,0,50,174,1,10,'LAST_HIT','false'),
(21010,21010,'Doom Warrior',0,'',0,'LineageMonster.skeleton_knight',10.00,25.00,64,'male','L2Monster',40,3384,1285,11.85,2.78,40,43,30,21,20,10,6380,584,993,371,589,331,317,0,333,71,0,0,0,40,174,1,10,'LAST_HIT','false'),
(21011,21011,'Ol Mahum Van Grunt',0,'',0,'LineageMonster.ol_mahum',13.50,25.00,30,'male','L2Monster',40,954,365,5.53,1.53,40,43,30,21,20,10,1308,72,132,140,58,114,278,0,333,5,0,0,0,55,165,0,0,'LAST_HIT','true'),
(21012,21012,'Magical Eye',0,'',0,'LineageMonster.magical_weaver',11.00,20.00,31,'male','L2Monster',40,1004,381,7.11,1.84,40,43,30,21,20,10,1736,96,129,161,64,118,278,500,333,0,0,0,0,99,165,0,0,'LAST_HIT','true'),
(21013,21013,'Ol Mahum Van Archer',0,'',0,'LineageMonster.ol_mahum_archer',14.00,25.00,32,'male','L2Monster',500,1056,397,7.11,1.84,40,43,30,21,20,10,1920,108,376,138,69,123,249,0,333,273,0,0,0,55,165,0,0,'LAST_HIT','true'),
(21014,21014,'Lesser Warlike Tyrant',0,'',0,'LineageMonster.grave',15.00,29.00,33,'male','L2Monster',40,1109,413,7.11,1.84,40,43,30,21,20,10,1987,114,151,173,75,128,278,500,333,0,0,0,0,77,165,0,0,'LAST_HIT','true'),
(21015,21015,'Ol Mahum Van Leader',0,'',0,'LineageMonster.ol_mahum_champion',14.00,27.00,34,'male','L2Monster',40,1164,430,7.11,1.84,40,43,30,21,20,10,2040,119,196,148,82,132,278,500,333,67,0,0,0,55,165,0,0,'LAST_HIT','true'),
(21016,21016,'Warlike Tyrant',0,'',0,'LineageMonster.grave',15.00,29.00,35,'male','L2Monster',40,1220,446,7.11,1.84,40,43,30,21,20,10,2192,130,211,154,89,137,278,0,333,0,0,0,0,77,191,0,0,'LAST_HIT','true'),
(21017,21017,'Fallen Orc',0,'',0,'LineageMonster.ketra_orc',12.00,29.00,55,'male','L2Monster',40,2643,987,10.27,2.45,40,43,30,21,20,10,4399,355,737,292,360,261,278,0,333,127,0,0,0,45,174,0,0,'LAST_HIT','true'),
(21018,21018,'Ancient Gargoyle',0,'',0,'LineageMonster.hunter_gargoyle',25.00,65.00,56,'male','L2Monster',40,2724,1019,10.27,2.45,40,43,30,21,20,10,5536,455,642,364,382,269,278,500,333,0,0,0,0,100,174,0,0,'LAST_HIT','true'),
(21019,21019,'Fallen Orc Archer',0,'',0,'LineageMonster.ketra_orc_archer',12.00,27.00,57,'male','L2Monster',500,2806,1052,10.27,2.45,40,43,30,21,20,10,6093,506,1501,374,405,276,247,0,333,279,0,0,0,45,174,0,0,'LAST_HIT','true'),
(21020,21020,'Fallen Orc Shaman',0,'',0,'LineageMonster.ketra_orc_shaman',10.00,23.00,58,'male','L2Monster',40,2889,1084,10.27,2.45,40,43,30,21,20,10,6898,583,710,384,428,284,278,0,333,9,0,0,0,10,174,0,0,'LAST_HIT','true'),
(21021,21021,'Sharp Talon Tiger',0,'',0,'LineageMonster.saber_toothed_tiger',34.00,28.00,59,'male','L2Monster',40,2971,1117,10.27,2.45,40,43,30,21,20,10,6353,543,902,277,453,291,278,500,333,0,0,0,0,60,174,0,0,'LAST_HIT','true'),
(21022,21022,'Fallen Orc Captain',0,'',0,'LineageMonster.ketra_orc_warrior',12.00,24.00,60,'male','L2Monster',40,3054,1150,10.27,2.45,40,43,30,21,20,10,6462,561,946,285,478,299,278,500,333,160,0,0,0,36,174,0,0,'LAST_HIT','true'),
(21023,21023,'Sobbing Wind',0,'',0,'LineageMonster.sylph',11.00,35.00,26,'female','L2Monster',40,770,303,5.53,1.53,40,43,30,21,20,10,1056,53,87,132,41,98,278,0,333,0,0,0,0,66,165,0,0,'LAST_HIT','true'),
(21024,21024,'Babbling Wind',0,'',0,'LineageMonster.sylph',11.00,35.00,27,'female','L2Monster',40,813,318,5.53,1.53,40,43,30,21,20,10,1113,57,94,138,45,102,278,0,333,0,0,0,0,66,165,0,0,'LAST_HIT','true'),
(21025,21025,'Giggling Wind',0,'',0,'LineageMonster.sylph',11.00,35.00,28,'female','L2Monster',40,859,334,5.53,1.53,40,43,30,21,20,10,1178,62,102,143,49,106,278,0,333,0,0,0,0,66,165,0,0,'LAST_HIT','true'),
(21026,21026,'Singing Wind',0,'',0,'LineageMonster.sylph',11.00,35.00,29,'female','L2Monster',40,906,349,5.53,1.53,40,43,30,21,20,10,1268,68,111,149,53,110,278,500,333,0,0,0,0,66,165,0,0,'LAST_HIT','true'),
(21034,21034,'Ogre',0,'',0,'LineageMonster.ogre',25.00,52.50,38,'male','L2Monster',40,1400,497,3.56,1.84,40,43,30,21,20,10,3594,224,440,141,112,153,197,500,333,98,0,0,0,22,174,0,0,'LAST_HIT','true'),
(21035,21035,'Catherok',0,'',0,'LineageMonster.marsh_stakato_soldier',10.00,25.00,42,'male','L2Monster',40,1660,589,17.38,2.14,40,43,30,21,20,10,2275,151,342,196,152,175,278,500,333,127,0,0,0,30,60,0,0,'LAST_HIT','false'),
(21036,21036,'Shindebarn',0,'',0,'LineageMonster.magical_weaver',11.00,20.00,44,'male','L2Monster',40,1799,648,17.38,2.14,40,43,30,21,20,10,2869,196,390,209,176,187,278,0,333,0,0,0,0,40,90,0,0,'LAST_HIT','false'),
(21037,21037,'Ossiud',0,'',0,'LineageMonster.field_stalker',15.00,30.00,47,'male','L2Monster',40,2016,738,17.38,2.14,40,43,30,21,20,10,3326,238,469,230,216,206,278,500,333,0,0,0,0,70,174,0,0,'LAST_HIT','false'),
(21038,21038,'Liangma',0,'',0,'LineageMonster.will_o_wisp',13.00,22.00,49,'male','L2Monster',40,2168,799,17.38,2.14,40,43,30,21,20,10,2926,216,529,245,247,219,278,500,333,0,0,0,0,80,174,0,0,'LAST_HIT','false'),
(21039,21039,'Snipe Cohort',0,'',0,'LineageMonster.onyx_beast',14.00,14.50,43,'male','L2Monster',40,1728,618,17.38,2.14,40,43,30,21,20,10,3041,205,302,245,163,181,278,0,333,0,0,0,0,30,174,0,0,'LAST_HIT','false'),
(21040,21040,'Soldier of Darkness',0,'',0,'LineageMonster.death_knight',12.00,31.00,49,'male','L2Minion',40,2168,799,17.38,2.14,40,43,30,21,20,10,5077,375,581,223,247,219,278,0,333,127,0,0,0,27,174,1,0,'LAST_HIT','false'),
(21058,21058,'Beast Lord',0,'',0,'LineageMonster.saber_toothed_tiger',34.00,28.00,60,'male','L2Monster',40,3054,1150,20.54,2.45,40,43,30,21,20,10,7880,684,946,335,478,299,278,500,333,0,0,0,0,66,191,0,0,'LAST_HIT','false'),
(21059,21059,'Beast Guardian',0,'',0,'LineageMonster.onyx_beast',14.00,14.50,59,'male','L2Minion',40,2971,1117,20.54,2.45,40,43,30,21,20,10,6289,537,902,326,453,291,278,0,333,0,0,0,0,33,191,0,0,'LAST_HIT','false'),
(21060,21060,'Beast Seer',0,'',0,'LineageMonster.field_stalker',15.00,30.00,59,'male','L2Minion',40,2971,1117,20.54,2.45,40,43,30,21,20,10,6289,537,745,395,453,291,278,0,333,0,0,0,0,77,191,0,0,'LAST_HIT','false'),
(21061,21061,'Hallate\'s Guardian',0,'',0,'LineageMonster.kaim_vanul',24.00,40.00,69,'male','L2Monster',40,3784,1458,47.40,2.78,40,43,30,21,20,10,6396,625,1392,418,746,373,278,500,333,0,0,0,0,37,174,0,0,'LAST_HIT','false'),
(21062,21062,'Messenger Angel',0,'',0,'LineageMonster.angel',13.50,36.50,70,'male','L2Monster',40,3862,1493,47.40,2.78,40,43,30,21,20,10,0,0,1590,388,780,382,278,500,333,148,0,0,0,33,191,0,10,'LAST_HIT','false'),
(21063,21063,'Messenger Angel',0,'',0,'LineageMonster.angel',13.50,36.50,70,'male','L2Monster',40,3862,1493,47.40,2.78,40,43,30,21,20,10,13079,1297,1194,517,780,382,278,500,333,148,0,0,0,33,191,0,10,'LAST_HIT','false'),
(21064,21064,'Platinum Guardian Archer',0,'',0,'LineageMonster.kel_mahum_archer',13.00,27.00,71,'male','L2Monster',500,3938,1529,53.72,3.09,40,43,30,21,20,10,8009,803,3332,371,814,390,249,500,333,288,0,0,0,55,191,0,10,'LAST_HIT','false'),
(21065,21065,'Platinum Guardian Warrior',0,'',0,'LineageMonster.kel_mahum_warrior',13.00,28.00,72,'male','L2Monster',40,4013,1565,67.15,3.09,40,43,30,21,20,10,6036,613,1284,540,849,399,278,500,333,148,0,0,0,55,191,0,10,'LAST_HIT','false'),
(21066,21066,'Platinum Guardian Shaman',0,'',0,'LineageMonster.kel_mahum_witch_doctor',13.00,25.00,73,'male','L2Monster',40,4086,1601,67.15,3.09,40,43,30,21,20,10,6529,672,1609,456,885,407,278,500,333,202,0,0,0,55,191,0,10,'LAST_HIT','false'),
(21067,21067,'Guardian Archangel',0,'',0,'LineageMonster.angel',13.50,36.50,74,'male','L2Monster',40,4158,1637,67.15,3.09,40,43,30,21,20,10,0,0,1831,423,921,416,278,500,333,148,0,0,0,30,174,0,10,'LAST_HIT','false'),
(21068,21068,'Guardian Archangel',0,'',0,'LineageMonster.angel',13.50,36.50,74,'male','L2Monster',40,4158,1637,67.15,3.09,40,43,30,21,20,10,14206,1481,1664,466,921,416,278,500,333,148,0,0,0,33,191,0,10,'LAST_HIT','false'),
(21069,21069,'Platinum Guardian Prefect',0,'',0,'LineageMonster.kel_mahum_champion',13.00,32.00,74,'male','L2Monster',40,4158,1637,67.15,3.09,40,43,30,21,20,10,8909,928,1831,423,921,416,278,500,333,147,0,0,0,50,174,0,10,'LAST_HIT','false'),
(21070,21070,'Seal Archangel',0,'',0,'LineageMonster.angel',13.50,36.50,75,'male','L2Monster',40,4229,1673,67.15,3.09,40,43,30,21,20,10,0,0,1892,432,957,425,278,500,333,148,0,0,0,33,191,0,10,'LAST_HIT','false'),
(21071,21071,'Seal Archangel',0,'',0,'LineageMonster.angel',13.50,36.50,75,'male','L2Monster',40,4229,1673,67.15,3.09,40,43,30,21,20,10,14733,1554,1421,575,957,425,278,500,333,148,0,0,0,33,191,0,10,'LAST_HIT','false'),
(21072,21072,'Platinum Guardian Chief',0,'',0,'LineageMonster.kel_mahum_witch_doctor',13.00,25.00,75,'male','L2Monster',40,4229,1673,67.15,3.09,40,43,30,21,20,10,6752,712,1720,475,957,425,278,500,333,202,0,0,0,55,191,0,10,'LAST_HIT','false'),
(21073,21073,'Guardian Warrior of Elmoreden',0,'',0,'LineageMonster.skeleton_knight',10.00,25.00,64,'male','L2Monster',40,3384,1285,23.70,2.78,40,43,30,21,20,10,7040,644,1135,371,589,331,278,0,333,84,0,0,0,44,191,1,0,'LAST_HIT','false'),
(21074,21074,'Bound Shaman',0,'',0,'LineageMonster.kel_mahum_witch_doctor',13.00,25.00,72,'male','L2Monster',40,4013,1565,26.86,3.09,40,43,30,21,20,10,9651,980,1284,540,849,399,278,0,333,202,0,0,0,55,191,0,0,'LAST_HIT','false'),
(21075,21075,'Slaughter Bathin',0,'',0,'LineageMonster.death_knight',12.00,31.00,63,'male','L2Monster',40,3302,1251,23.70,2.78,40,43,30,21,20,10,6995,631,1086,362,560,323,278,500,333,84,0,0,0,29,191,1,0,'LAST_HIT','false'),
(21076,21076,'Bathin\'s Knight',0,'',0,'LineageMonster.skeleton_knight',10.00,25.00,62,'male','L2Minion',40,3219,1217,23.70,2.78,40,43,30,21,20,10,6881,613,1038,353,532,315,278,0,333,78,0,0,0,44,191,1,0,'LAST_HIT','false'),
(21077,21077,'Bathin\'s Wizard',0,'',0,'LineageMonster.banshee',9.00,23.00,62,'female','L2Minion',40,3219,1217,23.70,2.78,40,43,30,21,20,10,6669,594,1038,353,532,315,278,0,333,3939,0,0,0,88,191,0,0,'LAST_HIT','false'),
(21078,21078,'Magus Valac',0,'',0,'LineageMonster.vale_master',12.00,40.00,70,'male','L2Monster',40,3862,1493,23.70,2.78,40,43,30,21,20,10,8481,841,1445,427,780,382,278,500,333,198,0,0,0,77,191,0,0,'LAST_HIT','false'),
(21079,21079,'Valac\'s Creature',0,'',0,'LineageMonster.serpent_slave',17.00,46.00,69,'male','L2Minion',40,3784,1458,23.70,2.78,40,43,30,21,20,10,7707,754,1392,418,746,373,278,0,333,150,0,0,0,77,191,0,0,'LAST_HIT','false'),
(21080,21080,'Valac\'s Guardian Spirit',0,'',0,'LineageMonster.shadow',10.00,30.00,69,'male','L2Minion',40,3784,1458,23.70,2.78,40,43,30,21,20,10,7123,697,1006,506,746,373,317,0,333,0,0,0,0,88,191,0,0,'LAST_HIT','false'),
(21081,21081,'Power Angel Amon',0,'',0,'LineageMonster.angel',13.50,36.50,75,'male','L2Monster',40,4229,1673,26.86,3.09,40,43,30,21,20,10,8887,937,1720,475,957,425,278,500,333,4700,0,0,0,33,191,0,0,'LAST_HIT','false'),
(21082,21082,'Amon\'s Captain of the Guards',0,'',0,'LineageMonster.kel_mahum_champion',13.00,32.00,74,'male','L2Minion',40,4158,1637,26.86,3.09,40,43,30,21,20,10,8546,891,1664,466,921,416,278,0,333,150,0,0,0,55,191,0,0,'LAST_HIT','false'),
(21083,21083,'Amon\'s Spirits',0,'',0,'LineageMonster.pixy',5.00,25.00,74,'female','L2Minion',40,4158,1637,26.86,3.09,40,43,30,21,20,10,10096,1052,1664,466,921,416,278,0,333,0,0,0,0,88,191,0,0,'LAST_HIT','false'),
(21084,21084,'Bloody Lady',0,'',0,'LineageMonster.bloody_queen',14.00,40.00,60,'female','L2Monster',40,3054,1150,30.81,2.45,40,43,30,21,20,10,4536,394,860,368,478,299,278,500,333,0,0,0,0,80,174,0,0,'LAST_HIT','false'),
(21085,21085,'Bloody Sniper',0,'',0,'LineageMonster.fiend_archer',17.00,55.00,71,'male','L2Monster',500,3938,1529,67.15,3.09,40,43,30,21,20,10,5574,559,3332,437,814,390,249,500,333,0,0,0,0,77,191,0,0,'LAST_HIT','false'),
(21086,21086,'Bloody Liviona',0,'',0,'LineageMonster.liviona',15.00,28.00,72,'male','L2Monster',40,4013,1565,67.15,3.09,40,43,30,21,20,10,5566,565,1413,491,849,399,278,500,333,0,0,0,0,88,191,0,0,'LAST_HIT','false'),
(21087,21087,'Bloody Knight',0,'',0,'LineageMonster.death_knight',12.00,31.00,73,'male','L2Monster',40,4086,1601,67.15,3.09,40,43,30,21,20,10,8932,919,1770,415,885,407,278,500,333,137,0,0,0,29,191,1,0,'LAST_HIT','false'),
(21088,21088,'Bloody Banshee',0,'',0,'LineageMonster.banshee',9.00,23.00,74,'female','L2Monster',40,4158,1637,67.15,3.09,40,43,30,21,20,10,5879,612,1513,512,921,416,278,500,333,3939,0,0,0,88,191,0,0,'LAST_HIT','false'),
(21089,21089,'Bloody Lord',0,'',0,'LineageMonster.karik',25.00,90.00,75,'male','L2Monster',40,4229,1673,67.15,3.09,40,43,30,21,20,10,6817,719,1720,475,957,425,278,500,333,0,0,0,0,40,191,0,0,'LAST_HIT','false'),
(21090,21090,'Bloody Guardian',0,'',0,'LineageMonster.death_blader',15.00,45.00,75,'male','L2Monster',40,4229,1673,40.29,3.09,40,43,30,21,20,10,8734,921,1720,475,957,425,278,500,333,1472,0,0,0,110,191,1,0,'LAST_HIT','false'),
(21091,21091,'Bloody Keeper',0,'',0,'LineageMonster.kaim_vanul',24.00,40.00,74,'male','L2Monster',40,4158,1637,26.86,3.09,40,43,30,21,20,10,8831,920,1513,512,921,416,278,0,333,0,0,0,0,40,191,0,0,'LAST_HIT','false'),
(21092,21092,'Bloody Mystic',0,'',0,'LineageMonster.banshee',9.00,23.00,74,'female','L2Monster',40,4158,1637,26.86,3.09,40,43,30,21,20,10,8627,899,1513,512,921,416,278,0,333,3939,0,0,0,88,191,0,0,'LAST_HIT','false'),
(21093,21093,'Ratman Sub Chieftain',0,'',0,'LineageMonster.wererat',14.00,25.00,19,'male','L2Monster',40,508,203,3.95,1.21,40,43,30,21,20,10,691,31,58,70,21,73,278,400,333,216,0,0,0,88,165,0,0,'LAST_HIT','true'),
(21094,21094,'Ratman Chieftain',0,'',0,'LineageMonster.wererat',14.00,25.00,20,'male','L2Monster',40,541,213,3.95,1.21,40,43,30,21,20,10,712,32,52,104,23,76,278,0,333,3,0,0,0,88,170,0,0,'LAST_HIT','true'),
(21095,21095,'Giant Poison Bee',0,'',0,'LineageMonster.giant_bee',8.00,24.50,21,'male','L2Monster',40,575,227,5.53,1.53,40,43,30,21,20,10,840,39,55,83,25,80,317,0,333,0,0,0,0,99,99,0,0,'LAST_HIT','true'),
(21096,21096,'Cloudy Beast',0,'',0,'LineageMonster.onyx_beast',14.00,14.50,22,'male','L2Monster',40,611,242,5.53,1.53,40,43,30,21,20,10,837,40,68,87,28,83,278,400,333,0,0,0,0,33,154,0,0,'LAST_HIT','true'),
(21097,21097,'Young Araneid',0,'',0,'LineageMonster.poison_spider',27.00,25.50,23,'male','L2Monster',40,648,257,5.53,1.53,40,43,30,21,20,10,985,48,75,107,31,87,278,400,333,0,0,0,0,66,143,0,0,'LAST_HIT','true'),
(21098,21098,'Plain Grizzly',0,'',0,'LineageMonster.grizzly',21.00,40.00,24,'male','L2Monster',40,687,272,5.53,1.53,40,43,30,21,20,10,935,46,81,111,34,90,278,0,333,0,0,0,0,44,126,0,0,'LAST_HIT','true'),
(21099,21099,'Cloudy Beast Turen',0,'',0,'LineageMonster.onyx_beast',14.00,14.50,25,'male','L2Monster',40,728,287,5.53,1.53,40,43,30,21,20,10,1012,51,88,98,37,94,278,400,333,0,0,0,0,33,159,0,0,'LAST_HIT','true'),
(21100,21100,'Langk Lizardman Sentinel',0,'',0,'LineageMonster.virud_lizardman',10.00,23.00,19,'male','L2Monster',40,508,203,3.95,1.21,40,43,30,21,20,10,691,31,53,90,21,73,278,500,333,2,0,0,0,47,143,0,0,'LAST_HIT','true'),
(21101,21101,'Langk Lizardman Shaman',0,'',0,'LineageMonster.virud_lizardman_shaman',10.00,29.00,24,'male','L2Monster',40,687,272,5.53,1.53,40,43,30,21,20,10,935,46,81,94,34,90,278,0,333,6,0,0,0,47,143,0,0,'LAST_HIT','true'),
(21102,21102,'Watchman of the Plains',0,'',0,'LineageMonster.magical_weaver',11.00,20.00,30,'male','L2Monster',40,954,365,5.53,1.53,40,43,30,21,20,10,1335,73,132,119,58,114,278,500,333,0,0,0,0,90,160,0,0,'LAST_HIT','true'),
(21103,21103,'Roughly Hewn Rock Golem',0,'',0,'LineageMonster.stone_golem_bi',20.00,40.30,31,'male','L2Monster',40,1004,381,7.11,1.84,40,43,30,21,20,10,1397,78,142,146,64,118,278,0,333,0,0,0,0,23,23,0,0,'LAST_HIT','true'),
(21104,21104,'Delu Lizardman Supplier',0,'',0,'LineageMonster.virud_lizardman',10.00,23.00,32,'male','L2Monster',40,1056,397,7.11,1.84,40,43,30,21,20,10,1754,99,134,151,69,123,317,0,333,223,0,0,0,43,135,0,0,'LAST_HIT','true'),
(21105,21105,'Delu Lizardman Special Agent',0,'',0,'LineageMonster.virud_lizardman_scout',10.00,22.00,33,'male','L2Monster',500,1109,413,7.11,1.84,40,43,30,21,20,10,2022,116,406,143,75,128,247,0,333,2507,0,0,0,43,135,0,0,'LAST_HIT','true'),
(21106,21106,'Cursed Seer',0,'',0,'LineageMonster.magical_weaver',11.00,20.00,34,'male','L2Monster',40,1164,430,7.11,1.84,40,43,30,21,20,10,1714,100,178,138,82,132,278,500,333,0,0,0,0,90,160,0,0,'LAST_HIT','true'),
(21107,21107,'Delu Lizardman Commander',0,'',0,'LineageMonster.virud_lizardman_warrior',12.00,30.00,35,'male','L2Monster',40,1220,446,14.22,1.84,40,43,30,21,20,10,1814,107,192,169,89,137,278,0,333,93,0,0,0,52,135,0,0,'LAST_HIT','true'),
(21108,21108,'Glow Wisp',0,'',0,'LineageMonster.will_o_wisp',13.00,22.00,67,'male','L2Monster',40,3626,1388,11.85,2.78,40,43,30,21,20,10,6528,622,1169,439,681,356,278,0,333,0,0,0,0,88,176,0,0,'LAST_HIT','true'),
(21109,21109,'Hames Orc Scout',0,'',0,'LineageMonster.ketra_orc',12.00,29.00,68,'male','L2Monster',40,3706,1423,11.85,2.78,40,43,30,21,20,10,8082,781,1065,382,713,365,317,0,333,229,0,0,0,49,203,0,0,'LAST_HIT','true'),
(21110,21110,'Marsh Predator',0,'',0,'LineageMonster.devastator',35.00,35.00,69,'male','L2Monster',40,3784,1458,11.85,2.78,40,43,30,21,20,10,6890,674,1265,460,746,373,278,0,333,0,0,0,0,27,192,0,0,'LAST_HIT','true'),
(21111,21111,'Lava Wyrm',0,'',0,'LineageMonster.wyrm',29.00,72.00,70,'male','L2Monster',40,3862,1493,11.85,2.78,40,43,30,21,20,10,7197,714,1314,470,780,382,278,500,333,0,0,0,0,70,175,0,0,'LAST_HIT','true'),
(21112,21112,'Hames Orc Footman',0,'',0,'LineageMonster.ketra_orc',12.00,29.00,71,'male','L2Monster',40,3938,1529,13.43,3.09,40,43,30,21,20,10,8724,875,1363,481,814,390,278,0,333,233,110,0,0,45,180,0,0,'LAST_HIT','true'),
(21113,21113,'Hames Orc Sniper',0,'',0,'LineageMonster.ketra_orc_archer',12.00,27.00,72,'male','L2Monster',500,4013,1565,13.43,3.09,40,43,30,21,20,10,9722,988,3140,417,849,399,247,0,333,287,0,0,0,45,160,0,0,'LAST_HIT','true'),
(21114,21114,'Cursed Guardian',0,'',0,'LineageMonster.death_blader',15.00,45.00,73,'male','L2Monster',40,4086,1601,13.43,3.09,40,43,30,21,20,10,9231,950,1463,426,885,407,278,0,333,1472,0,0,0,110,192,1,0,'LAST_HIT','true'),
(21115,21115,'Hames Orc Shaman',0,'',0,'LineageMonster.ketra_orc_shaman',10.00,23.00,74,'male','L2Monster',40,4158,1637,13.43,3.09,40,43,30,21,20,10,8043,838,1513,435,921,416,278,0,333,186,0,0,0,10,145,0,0,'LAST_HIT','true'),
(21116,21116,'Hames Orc Overlord',0,'',0,'LineageMonster.ketra_orc_warrior',14.00,28.80,75,'male','L2Monster',40,4229,1673,13.43,3.09,40,43,30,21,20,10,12699,1340,1720,475,957,425,278,500,333,75,103,0,0,36,175,0,0,'LAST_HIT','true'),
(21117,21117,'Kasha Imp',0,'',0,'LineageMonster.imp_bi',10.00,30.00,19,'male','L2Monster',40,508,203,3.95,1.21,40,43,30,21,20,10,678,30,53,77,21,73,278,0,333,0,0,0,0,66,93,0,0,'LAST_HIT','true'),
(21118,21118,'Baar Dre Vanul',0,'',0,'LineageMonster.dre_vanul',14.00,36.00,20,'male','L2Monster',40,541,213,3.95,1.21,40,43,30,21,20,10,726,32,57,94,23,76,278,400,333,0,0,0,0,88,93,0,0,'LAST_HIT','true'),
(21119,21119,'Hobgoblin',0,'',0,'LineageMonster.hobgoblin',12.00,24.00,21,'male','L2Monster',40,575,227,5.53,1.53,40,43,30,21,20,10,764,35,63,98,25,80,278,0,333,4,0,0,0,49,121,0,0,'LAST_HIT','true'),
(21120,21120,'Kasha Imp Turen',0,'',0,'LineageMonster.imp_bi',10.00,30.00,22,'male','L2Monster',40,611,242,5.53,1.53,40,43,30,21,20,10,996,47,75,79,28,83,278,400,333,0,0,0,0,66,93,0,0,'LAST_HIT','true'),
(21121,21121,'Kasha Dire Wolf',0,'',0,'LineageMonster.dire_wolf',13.00,11.00,23,'male','L2Monster',40,648,257,5.53,1.53,40,43,30,21,20,10,895,43,75,91,31,87,278,400,333,0,0,0,0,26,148,0,0,'LAST_HIT','true'),
(21122,21122,'Kasha Bugbear',0,'',0,'LineageMonster.bugbear',17.00,35.00,24,'male','L2Monster',40,687,272,5.53,1.53,40,43,30,21,20,10,954,47,81,111,34,90,278,400,333,169,0,0,0,60,143,0,0,'LAST_HIT','true'),
(21123,21123,'Baar Dre Vanul Destroyer',0,'',0,'LineageMonster.dre_vanul',14.00,36.00,25,'male','L2Monster',40,728,287,5.53,1.53,40,43,30,21,20,10,1267,63,97,105,37,94,278,400,333,0,0,0,0,88,93,0,0,'LAST_HIT','true'),
(21124,21124,'Red Eye Barbed Bat',0,'',0,'LineageMonster.vampire_bat',10.00,33.50,18,'male','L2Monster',40,476,193,3.95,1.21,40,43,30,21,20,10,640,28,48,73,19,70,278,0,333,0,0,0,0,66,99,0,0,'LAST_HIT','true'),
(21125,21125,'Northern Trimden',0,'',0,'LineageMonster.poison_spider',27.00,25.50,19,'male','L2Monster',40,508,203,3.95,1.21,40,43,30,21,20,10,684,31,53,90,21,73,278,400,333,0,0,0,0,66,154,0,0,'LAST_HIT','true'),
(21126,21126,'Kerope Werewolf',0,'',0,'LineageMonster.werewolf_bi',11.00,29.70,20,'male','L2Monster',40,541,213,3.95,1.21,40,43,30,21,20,10,712,32,57,80,23,76,278,0,333,0,0,0,0,55,137,0,0,'LAST_HIT','true'),
(21127,21127,'Northern Goblin',0,'',0,'LineageMonster2.northern_goblin',4.00,15.00,21,'male','L2Monster',40,575,227,5.53,1.53,40,43,30,21,20,10,764,35,63,98,25,80,278,0,333,152,0,0,0,33,132,0,0,'LAST_HIT','true'),
(21128,21128,'Spine Golem',0,'',0,'LineageMonster.stone_golem_bi',20.00,40.30,22,'male','L2Monster',40,611,242,5.53,1.53,40,43,30,21,20,10,821,39,68,102,28,83,278,0,333,0,0,0,0,25,25,0,0,'LAST_HIT','true'),
(21129,21129,'Kerope Werewolf Chief',0,'',0,'LineageMonster.werewolf_bi',11.00,29.70,23,'male','L2Monster',40,648,257,5.53,1.53,40,43,30,21,20,10,895,43,82,82,31,87,278,400,333,0,0,0,0,55,154,0,0,'LAST_HIT','true'),
(21130,21130,'Northern Goblin Leader',0,'',0,'LineageMonster2.northern_goblin',4.00,15.00,24,'male','L2Monster',40,687,272,5.53,1.53,40,43,30,21,20,10,954,47,81,111,34,90,278,400,333,66,102,0,0,33,137,0,0,'LAST_HIT','true'),
(21131,21131,'Enchanted Spine Golem',0,'',0,'LineageMonster.stone_golem_bi',20.00,40.30,25,'male','L2Monster',40,728,287,5.53,1.53,40,43,30,21,20,10,992,50,97,105,37,94,278,0,333,0,0,0,0,25,31,0,0,'LAST_HIT','true'),
(21132,21132,'Underground Kobold',0,'',0,'LineageMonster.kobold',10.00,15.00,24,'male','L2Monster',40,687,272,5.53,1.53,40,43,30,21,20,10,779,38,81,94,34,90,278,0,333,0,0,0,0,51,121,0,0,'LAST_HIT','false'),
(21133,21133,'Dead Pit Skeleton Archer',0,'',0,'LineageMonster.skeleton_archer',11.00,27.00,25,'male','L2Monster',500,728,287,5.53,1.53,40,43,30,21,20,10,851,43,197,98,37,94,249,0,333,274,0,0,0,44,143,1,0,'LAST_HIT','false'),
(21134,21134,'Dead Pit Spartoi',0,'',0,'LineageMonster.spartoi',11.00,27.00,26,'male','L2Monster',40,770,303,5.53,1.53,40,43,30,21,20,10,898,45,96,102,41,98,278,400,333,219,0,0,0,66,159,1,0,'LAST_HIT','false'),
(21135,21135,'Underground Kobold Warrior',0,'',0,'LineageMonster.kobold',10.00,15.00,27,'male','L2Monster',40,813,318,5.53,1.53,40,43,30,21,20,10,1103,56,114,114,45,102,278,0,333,0,0,0,0,51,126,0,0,'LAST_HIT','false'),
(21136,21136,'Dead Pit Horror',0,'',0,'LineageMonster.dark_horror',20.00,35.00,28,'male','L2Monster',40,859,334,5.53,1.53,40,43,30,21,20,10,981,52,113,110,49,106,278,0,333,0,0,0,0,110,110,1,0,'LAST_HIT','false'),
(21137,21137,'Iron Ore Golem',0,'',0,'LineageMonster.iron_golem',18.00,34.00,29,'male','L2Monster',40,906,349,5.53,1.53,40,43,30,21,20,10,1057,57,111,149,53,110,278,400,333,0,0,0,0,22,23,0,0,'LAST_HIT','false'),
(21138,21138,'Greedy Geist',0,'',0,'LineageMonster.hungry_spirit',30.00,40.00,30,'male','L2Monster',40,954,365,5.53,1.53,40,43,30,21,20,10,1134,62,132,119,58,114,278,0,333,0,0,0,0,16,165,1,0,'LAST_HIT','false'),
(21139,21139,'Catacomb Barbed Bat',0,'',0,'LineageMonster.vampire_bat',10.00,33.50,23,'male','L2Monster',40,648,257,22.12,1.53,40,43,30,21,20,10,655,31,75,91,31,87,278,500,333,0,0,0,0,66,143,0,0,'LAST_HIT','false'),
(21140,21140,'Catacomb Wisp',0,'',0,'LineageMonster.will_o_wisp',13.00,22.00,26,'male','L2Monster',40,770,303,22.12,1.53,40,43,30,21,20,10,788,39,96,102,41,98,278,500,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(21141,21141,'Catacomb Serpent',0,'',0,'LineageMonster.serpent_slave',17.00,46.00,28,'male','L2Monster',40,859,334,22.12,1.53,40,43,30,21,20,10,926,48,113,110,49,106,278,500,333,73,0,0,0,77,143,0,0,'LAST_HIT','false'),
(21142,21142,'Grave Keeper Spartoi',0,'',0,'LineageMonster.spartoi',11.00,27.00,29,'male','L2Monster',40,906,349,22.12,1.53,40,43,30,21,20,10,927,49,111,149,53,110,278,500,333,221,0,0,0,66,154,1,0,'LAST_HIT','false'),
(21143,21143,'Catacomb Scavenger Bat',0,'',0,'LineageMonster.vampire_bat',10.00,33.50,31,'male','L2Monster',40,1004,381,28.44,1.84,40,43,30,21,20,10,1042,57,142,124,64,118,278,500,333,0,0,0,0,60,140,0,0,'LAST_HIT','false'),
(21144,21144,'Catacomb Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,34,'male','L2Monster',40,1164,430,28.44,1.84,40,43,30,21,20,10,1254,73,178,138,82,132,278,500,333,0,0,0,0,80,130,0,0,'LAST_HIT','false'),
(21145,21145,'Catacomb Stakato Soldier',0,'',0,'LineageMonster.blade_stakato_soldier',15.00,38.00,38,'male','L2Monster',40,1400,497,28.44,1.84,40,43,30,21,20,10,1611,100,238,160,112,153,278,500,333,232,0,0,0,25,150,0,0,'LAST_HIT','false'),
(21146,21146,'Grave Keeper Dark Horror',0,'',0,'LineageMonster.dark_horror',20.00,35.00,40,'male','L2Monster',40,1527,531,28.44,1.84,40,43,30,21,20,10,1735,112,248,222,131,164,278,500,333,0,0,0,0,100,160,1,0,'LAST_HIT','false'),
(21147,21147,'Catacomb Gargoyle',0,'',0,'LineageMonster.gargoyle',16.00,50.00,43,'male','L2Monster',40,1728,618,34.76,2.14,40,43,30,21,20,10,2114,143,332,223,163,181,278,500,333,0,0,0,0,140,170,0,0,'LAST_HIT','false'),
(21148,21148,'Catacomb Liviona',0,'',0,'LineageMonster.liviona',15.00,28.00,44,'male','L2Monster',40,1799,648,34.76,2.14,40,43,30,21,20,10,2100,143,354,196,176,187,278,500,333,0,0,0,0,80,140,0,0,'LAST_HIT','false'),
(21149,21149,'Decayed Ancient Pikeman',0,'',0,'LineageMonster.skeleton_pikeman',10.00,28.00,46,'male','L2Monster',40,1943,707,34.76,2.14,40,43,30,21,20,10,2419,171,401,245,202,199,278,500,333,96,0,0,0,50,170,1,0,'LAST_HIT','false'),
(21150,21150,'Decayed Ancient Soldier',0,'',0,'LineageMonster.skeleton_knight',10.00,25.00,49,'male','L2Monster',40,2168,799,34.76,2.14,40,43,30,21,20,10,2745,203,480,270,247,219,278,500,333,125,0,0,0,44,176,1,0,'LAST_HIT','false'),
(21151,21151,'Decayed Ancient Knight',0,'',0,'LineageMonster.skeleton_royal_guard',11.00,28.50,50,'male','L2Monster',40,2245,830,34.76,2.14,40,43,30,21,20,10,2858,215,509,278,264,226,278,500,333,227,0,0,0,88,187,1,0,'LAST_HIT','false'),
(21152,21152,'Purgatory Wisp',0,'',0,'LineageMonster.will_o_wisp',13.00,22.00,53,'male','L2Monster',40,2481,923,41.08,2.45,40,43,30,21,20,10,3047,239,602,258,319,247,278,500,333,0,0,0,0,88,165,0,0,'LAST_HIT','false'),
(21153,21153,'Purgatory Serpent',0,'',0,'LineageMonster.serpent_slave',17.00,46.00,56,'male','L2Monster',40,2724,1019,41.08,2.45,40,43,30,21,20,10,3586,294,706,281,382,269,278,500,333,73,0,0,0,77,192,0,0,'LAST_HIT','false'),
(21154,21154,'Hell Keeper Medusa',0,'',0,'LineageMonster.medusa',10.00,25.00,58,'female','L2Monster',40,2889,1084,41.08,2.45,40,43,30,21,20,10,3753,317,710,384,428,284,278,500,333,0,0,0,0,55,181,0,0,'LAST_HIT','false'),
(21155,21155,'Purgatory Conjurer',0,'',0,'LineageMonster.vampire_bat',10.00,33.50,59,'male','L2Monster',40,2971,1117,41.08,2.45,40,43,30,21,20,10,3776,322,820,305,453,291,278,500,333,0,0,0,0,66,192,0,0,'LAST_HIT','false'),
(21156,21156,'Purgatory Shadow',0,'',0,'LineageMonster.shadow',10.00,30.00,61,'male','L2Monster',40,3137,1184,47.40,2.78,40,43,30,21,20,10,4036,355,901,321,505,307,278,500,333,0,0,0,0,80,155,0,0,'LAST_HIT','false'),
(21157,21157,'Purgatory Tarantula',0,'',0,'LineageMonster.poison_spider',27.00,25.50,64,'male','L2Monster',40,3384,1285,47.40,2.78,40,43,30,21,20,10,4569,418,1031,347,589,331,278,500,333,0,0,0,0,60,175,0,0,'LAST_HIT','false'),
(21158,21158,'Hell Keeper Crimson Doll',0,'',0,'LineageMonster.crimson_doll',15.00,38.00,67,'male','L2Monster',40,3626,1388,47.40,2.78,40,43,30,21,20,10,5133,488,1063,483,681,356,278,500,333,0,0,0,0,60,180,1,0,'LAST_HIT','false'),
(21159,21159,'Purgatory Gargoyle',0,'',0,'LineageMonster.gargoyle',16.00,50.00,68,'male','L2Monster',40,3706,1423,47.40,2.78,40,43,30,21,20,10,5287,510,1217,449,713,365,278,500,333,0,0,0,0,140,175,0,0,'LAST_HIT','false'),
(21160,21160,'Purgatory Liviona',0,'',0,'LineageMonster.liviona',15.00,28.00,71,'male','L2Monster',40,3938,1529,53.72,3.09,40,43,30,21,20,10,5468,548,1363,408,814,390,278,500,333,0,0,0,0,88,176,0,0,'LAST_HIT','false'),
(21161,21161,'Lesser Ancient Soldier',0,'',0,'LineageMonster.medusa',10.00,25.00,73,'female','L2Monster',40,4086,1601,53.72,3.09,40,43,30,21,20,10,5945,611,1463,502,885,407,278,500,333,0,0,0,0,50,180,0,0,'LAST_HIT','false'),
(21162,21162,'Lesser Ancient Scout',0,'',0,'LineageMonster.blade_stakato_drone',15.00,39.00,74,'male','L2Monster',40,4158,1637,53.72,3.09,40,43,30,21,20,10,5940,619,1513,512,921,416,278,500,333,135,0,0,0,25,160,0,0,'LAST_HIT','false'),
(21163,21163,'Lesser Ancient Shaman',0,'',0,'LineageMonster.silhouette',8.00,23.00,76,'female','L2Monster',40,4297,1710,53.72,3.09,40,43,30,21,20,10,6265,669,1614,454,994,433,278,500,333,0,0,0,0,80,200,0,0,'LAST_HIT','false'),
(21164,21164,'Guardian Spirit of Ancient Holy Ground',0,'',0,'LineageMonster.death_lord',21.00,40.00,78,'male','L2Monster',40,4490,1821,53.72,3.09,40,43,30,21,20,10,7136,791,1765,566,1107,459,278,500,333,78,0,0,0,44,209,1,0,'LAST_HIT','false'),
(21165,21165,'Lesser Ancient Warrior',0,'',0,'LineageMonster.shadeless',7.00,28.00,78,'male','L2Monster',40,4550,1859,53.72,3.09,40,43,30,21,20,10,7761,871,2195,476,1144,468,278,500,333,0,0,0,0,48,200,0,0,'LAST_HIT','false'),
(21166,21166,'Lith Scout',0,'',0,'LineageMonster2.temple_guard_a_20_sm',12.00,33.60,21,'male','L2Monster',40,575,227,22.12,1.53,40,43,30,21,20,10,594,27,66,69,25,80,317,0,333,5795,0,0,0,58,143,0,0,'LAST_HIT','false'),
(21167,21167,'Lith Witch',0,'',0,'LineageMonster2.temple_savant_a_20_sm',8.00,32.00,24,'male','L2Monster',40,687,272,22.12,1.53,40,43,30,21,20,10,690,34,98,92,34,90,278,0,333,5797,0,0,0,27,121,0,0,'LAST_HIT','false'),
(21168,21168,'Lith Warrior',0,'',0,'LineageMonster2.temple_guard_b_20_sm',12.00,33.60,27,'male','L2Monster',40,813,318,22.12,1.53,40,43,30,21,20,10,855,43,126,103,45,102,278,0,333,5796,0,0,0,58,143,0,0,'LAST_HIT','false'),
(21169,21169,'Lith Guard',0,'',0,'LineageMonster2.temple_guard_a',15.00,42.00,30,'male','L2Monster',40,954,365,22.12,1.53,40,43,30,21,20,10,1133,62,140,99,58,114,317,0,333,5795,0,0,0,53,140,0,0,'LAST_HIT','false'),
(21170,21170,'Lith Medium',0,'',0,'LineageMonster2.temple_savant_a',10.00,40.00,33,'male','L2Monster',40,1109,413,28.44,1.84,40,43,30,21,20,10,1307,75,201,130,75,128,278,0,333,5797,0,0,0,25,120,0,0,'LAST_HIT','false'),
(21171,21171,'Lith Overlord',0,'',0,'LineageMonster2.temple_guard_b',15.00,42.00,36,'male','L2Monster',40,1279,463,28.44,1.84,40,43,30,21,20,10,1669,101,250,145,96,142,278,0,333,5796,0,0,0,53,140,0,0,'LAST_HIT','false'),
(21172,21172,'Lith Patrolman',0,'',0,'LineageMonster2.temple_guard_a',15.00,42.00,39,'male','L2Monster',40,1462,514,28.44,1.84,40,43,30,21,20,10,1972,125,270,137,121,158,317,0,333,5795,0,0,0,53,150,0,0,'LAST_HIT','false'),
(21173,21173,'Lith Shaman',0,'',0,'LineageMonster2.temple_savant_a',10.00,40.00,42,'male','L2Monster',40,1660,589,34.76,2.14,40,43,30,21,20,10,2118,141,377,178,152,175,278,0,333,5798,0,0,0,27,143,0,0,'LAST_HIT','false'),
(21174,21174,'Lith Commander',0,'',0,'LineageMonster2.temple_guard_b',15.00,42.00,45,'male','L2Monster',40,1870,677,34.76,2.14,40,43,30,21,20,10,2731,190,457,196,188,193,278,0,333,5796,0,0,0,53,150,0,0,'LAST_HIT','false'),
(21175,21175,'Lilim Butcher',0,'',0,'LineageMonster2.lilim_assassin_10_sm',11.00,36.00,48,'male','L2Monster',40,2091,768,34.76,2.14,40,43,30,21,20,10,3093,226,480,183,231,212,317,0,333,232,232,0,0,36,170,0,0,'LAST_HIT','false'),
(21176,21176,'Lilim Magus',0,'',0,'LineageMonster2.lilim_wizard_10_sm',8.00,30.60,51,'female','L2Monster',40,2323,861,41.08,2.45,40,43,30,21,20,10,3123,238,652,237,281,232,278,0,333,0,0,0,0,50,140,0,0,'LAST_HIT','false'),
(21177,21177,'Lilim Knight Errant',0,'',0,'LineageMonster2.lilim_knight_10_sm',11.00,45.00,54,'male','L2Monster',40,2562,955,41.08,2.45,40,43,30,21,20,10,4385,349,769,258,339,254,278,0,333,5800,5799,0,0,61,187,0,0,'LAST_HIT','false'),
(21178,21178,'Lilim Marauder',0,'',0,'LineageMonster2.lilim_assassin_10_sm',11.00,36.00,57,'male','L2Monster',40,2806,1052,41.08,2.45,40,43,30,21,20,10,4697,390,786,239,405,276,317,0,333,229,229,0,0,39,198,0,0,'LAST_HIT','false'),
(21179,21179,'Lilim Priest',0,'',0,'LineageMonster2.lilim_wizard_10_sm',8.00,30.60,60,'female','L2Monster',40,3054,1150,41.08,2.45,40,43,30,21,20,10,4322,375,1041,304,478,299,278,0,333,0,0,0,0,50,160,0,0,'LAST_HIT','false'),
(21180,21180,'Lilim Knight',0,'',0,'LineageMonster2.lilim_knight_10_sm',11.00,45.00,63,'male','L2Monster',40,3302,1251,47.40,2.78,40,43,30,21,20,10,6489,586,1194,329,560,323,361,0,333,5800,5799,0,0,56,180,0,0,'LAST_HIT','false'),
(21181,21181,'Lilim Assassin',0,'',0,'LineageMonster2.lilim_assassin_10_bi',13.00,44.00,66,'male','L2Monster',40,3546,1353,47.40,2.78,40,43,30,21,20,10,6868,646,1189,301,649,348,317,0,333,234,234,0,0,36,190,0,0,'LAST_HIT','false'),
(21182,21182,'Lilim Soldier',0,'',0,'LineageMonster2.lilim_wizard_10_bi',10.00,37.50,69,'female','L2Monster',40,3784,1458,47.40,2.78,40,43,30,21,20,10,5717,559,1531,380,746,373,278,0,333,0,0,0,0,50,170,0,0,'LAST_HIT','false'),
(21183,21183,'Lilim Knight Commander',0,'',0,'LineageMonster2.lilim_knight_10_bi',13.00,55.00,72,'male','L2Monster',40,4013,1565,53.72,3.09,40,43,30,21,20,10,8475,861,1710,406,849,399,361,0,333,5800,5799,0,0,56,190,0,0,'LAST_HIT','false'),
(21184,21184,'Lilim Slayer',0,'',0,'LineageMonster2.lilim_assassin_10_bi',13.00,44.00,75,'male','L2Monster',40,4229,1673,53.72,3.09,40,43,30,21,20,10,8869,935,1655,367,957,425,317,0,333,236,236,0,0,36,200,0,0,'LAST_HIT','false'),
(21185,21185,'Lilim Great Mystic',0,'',0,'LineageMonster2.lilim_wizard_10_bi',10.00,37.50,78,'female','L2Monster',40,4428,1784,53.72,3.09,40,43,30,21,20,10,7305,799,2075,459,1069,451,278,0,333,0,0,0,0,50,180,0,0,'LAST_HIT','false'),
(21186,21186,'Lilim Court Knight',0,'',0,'LineageMonster2.lilim_knight_10_bi',13.00,55.00,78,'male','L2Monster',40,4550,1859,53.72,3.09,40,43,30,21,20,10,10464,1174,2195,476,1144,468,361,0,333,5800,5799,0,0,56,200,0,0,'LAST_HIT','false'),
(21187,21187,'Gigant Slave',0,'',0,'LineageMonster2.tomb_guard_a_20_sm',8.00,32.00,21,'male','L2Monster',40,575,227,22.12,1.53,40,43,30,21,20,10,594,27,76,69,25,80,278,0,333,5791,0,0,0,53,143,0,0,'LAST_HIT','false'),
(21188,21188,'Gigant Acolyte',0,'',0,'LineageMonster2.tomb_savant_a_20_sm',8.00,32.00,24,'male','L2Monster',40,687,272,22.12,1.53,40,43,30,21,20,10,690,34,98,92,34,90,278,0,333,5793,0,0,0,53,121,0,0,'LAST_HIT','false'),
(21189,21189,'Gigant Overseer',0,'',0,'LineageMonster2.tomb_guard_b_20_sm',12.00,34.00,27,'male','L2Monster',40,813,318,22.12,1.53,40,43,30,21,20,10,855,43,126,103,45,102,278,0,333,5792,0,0,0,53,143,0,0,'LAST_HIT','false'),
(21190,21190,'Gigant Footman',0,'',0,'LineageMonster2.tomb_guard_a',10.00,40.00,30,'male','L2Monster',40,954,365,22.12,1.53,40,43,30,21,20,10,1133,62,160,99,58,114,278,0,333,5791,0,0,0,49,140,0,0,'LAST_HIT','false'),
(21191,21191,'Gigant Cleric',0,'',0,'LineageMonster2.tomb_savant_a',10.00,40.00,33,'male','L2Monster',40,1109,413,28.44,1.84,40,43,30,21,20,10,1307,75,201,130,75,128,278,0,333,5793,0,0,0,49,120,0,0,'LAST_HIT','false'),
(21192,21192,'Gigant Officer',0,'',0,'LineageMonster2.tomb_guard_b',15.00,42.50,36,'male','L2Monster',40,1279,463,28.44,1.84,40,43,30,21,20,10,1669,101,250,145,96,142,278,0,333,5792,0,0,0,49,140,0,0,'LAST_HIT','false'),
(21193,21193,'Gigant Raider',0,'',0,'LineageMonster2.tomb_guard_a',10.00,40.00,39,'male','L2Monster',40,1462,514,28.44,1.84,40,43,30,21,20,10,1972,125,308,137,121,158,278,0,333,5791,0,0,0,49,150,0,0,'LAST_HIT','false'),
(21194,21194,'Gigant Confessor',0,'',0,'LineageMonster2.tomb_savant_a',10.00,40.00,42,'male','L2Monster',40,1660,589,34.76,2.14,40,43,30,21,20,10,2118,141,377,178,152,175,278,0,333,5794,0,0,0,53,143,0,0,'LAST_HIT','false'),
(21195,21195,'Gigant Commander',0,'',0,'LineageMonster2.tomb_guard_b',15.00,42.50,45,'male','L2Monster',40,1870,677,34.76,2.14,40,43,30,21,20,10,2731,190,457,196,188,193,278,0,333,5792,0,0,0,49,150,0,0,'LAST_HIT','false'),
(21196,21196,'Nephilim Sentinel',0,'',0,'LineageMonster2.nephilim_slayer_10_sm',11.00,32.40,48,'male','L2Monster',40,2091,768,34.76,2.14,40,43,30,21,20,10,3093,226,548,183,231,212,278,0,333,0,0,0,0,65,170,0,0,'LAST_HIT','false'),
(21197,21197,'Nephilim Priest',0,'',0,'LineageMonster2.nephilim_priest_10_sm',21.00,36.50,51,'male','L2Monster',40,2323,861,41.08,2.45,40,43,30,21,20,10,3391,258,652,237,281,232,278,0,333,0,0,0,0,50,140,0,0,'LAST_HIT','false'),
(21198,21198,'Nephilim Swordsman',0,'',0,'LineageMonster2.nephilim_lord_10_sm',9.00,37.40,54,'male','L2Monster',40,2562,955,41.08,2.45,40,43,30,21,20,10,4385,349,769,258,339,254,278,0,333,0,0,0,0,71,187,0,0,'LAST_HIT','false'),
(21199,21199,'Nephilim Guard',0,'',0,'LineageMonster2.nephilim_slayer_10_sm',11.00,32.40,57,'male','L2Monster',40,2806,1052,41.08,2.45,40,43,30,21,20,10,4697,390,899,239,405,276,278,0,333,0,0,0,0,71,198,0,0,'LAST_HIT','false'),
(21200,21200,'Nephilim Bishop',0,'',0,'LineageMonster2.nephilim_priest_10_sm',21.00,36.50,60,'male','L2Monster',40,3054,1150,41.08,2.45,40,43,30,21,20,10,4694,407,1041,304,478,299,278,0,333,0,0,0,0,55,176,0,0,'LAST_HIT','false'),
(21201,21201,'Nephilim Centurion',0,'',0,'LineageMonster2.nephilim_lord_10_sm',9.00,37.40,63,'male','L2Monster',40,3302,1251,47.40,2.78,40,43,30,21,20,10,6489,586,1194,329,560,323,278,0,333,0,0,0,0,71,198,0,0,'LAST_HIT','false'),
(21202,21202,'Nephilim Scout',0,'',0,'LineageMonster2.nephilim_slayer_10_bi',13.00,39.60,66,'male','L2Monster',40,3546,1353,47.40,2.78,40,43,30,21,20,10,6868,646,1358,301,649,348,278,0,333,0,0,0,0,65,190,0,0,'LAST_HIT','false'),
(21203,21203,'Nephilim Archbishop',0,'',0,'LineageMonster2.nephilim_priest_10_bi',21.00,44.00,69,'male','L2Monster',40,3784,1458,47.40,2.78,40,43,30,21,20,10,6208,607,1531,380,746,373,278,0,333,0,0,0,0,55,187,0,0,'LAST_HIT','false'),
(21204,21204,'Nephilim Praetorian',0,'',0,'LineageMonster2.nephilim_lord_10_bi',13.00,48.00,72,'male','L2Monster',40,4013,1565,53.72,3.09,40,43,30,21,20,10,8475,861,1710,406,849,399,278,0,333,0,0,0,0,65,190,0,0,'LAST_HIT','false'),
(21205,21205,'Nephilim Royal Guard',0,'',0,'LineageMonster2.nephilim_slayer_10_bi',13.00,39.60,75,'male','L2Monster',40,4229,1673,53.72,3.09,40,43,30,21,20,10,8869,935,1892,367,957,425,278,0,333,0,0,0,0,65,200,0,0,'LAST_HIT','false'),
(21206,21206,'Nephilim Cardinal',0,'',0,'LineageMonster2.nephilim_priest_10_bi',21.00,44.00,78,'male','L2Monster',40,4428,1784,53.72,3.09,40,43,30,21,20,10,7933,868,2075,459,1069,451,278,0,333,0,0,0,0,50,180,0,0,'LAST_HIT','false'),
(21207,21207,'Nephilim Commander',0,'',0,'LineageMonster2.nephilim_lord_10_bi',11.00,45.30,78,'male','L2Monster',40,4550,1859,53.72,3.09,40,43,30,21,20,10,10464,1174,2195,476,1144,468,278,0,333,0,0,0,0,71,220,0,0,'LAST_HIT','false'),
(21208,21208,'Hallowed Watchman',0,'',0,'LineageMonster.skeleton',11.00,25.00,20,'male','L2Monster',40,541,213,15.80,1.21,40,43,30,21,20,10,521,23,57,94,23,76,278,0,333,216,111,0,0,66,143,1,0,'LAST_HIT','false'),
(21209,21209,'Hallowed Seer',0,'',0,'LineageMonster.binding',12.00,21.00,22,'male','L2Monster',40,611,242,22.12,1.53,40,43,30,21,20,10,612,29,68,87,28,83,278,500,333,0,0,0,0,11,121,1,0,'LAST_HIT','false'),
(21210,21210,'Vault Guardian',0,'',0,'LineageMonster.imp',10.00,24.00,25,'male','L2Monster',40,728,287,22.12,1.53,40,43,30,21,20,10,780,39,88,116,37,94,278,500,333,0,0,0,0,66,143,0,0,'LAST_HIT','false'),
(21211,21211,'Vault Seer',0,'',0,'LineageMonster.succubus',10.00,36.00,27,'female','L2Monster',40,813,318,22.12,1.53,40,43,30,21,20,10,830,42,104,106,45,102,278,500,333,0,0,0,0,66,121,0,0,'LAST_HIT','false'),
(21212,21212,'Hallowed Sentinel',0,'',0,'LineageMonster.skeleton_bi',11.00,31.00,30,'male','L2Monster',40,954,365,22.12,1.53,40,43,30,21,20,10,957,52,132,140,58,114,278,0,333,69,646,0,0,66,154,1,0,'LAST_HIT','false'),
(21213,21213,'Hallowed Monk',0,'',0,'LineageMonster.binding_20_bi',14.00,25.30,32,'male','L2Monster',40,1056,397,28.44,1.84,40,43,30,21,20,10,1110,62,154,129,69,123,278,500,333,0,0,0,0,11,121,1,0,'LAST_HIT','false'),
(21214,21214,'Vault Sentinel',0,'',0,'LineageMonster.imp_bi',10.00,30.00,35,'male','L2Monster',40,1220,446,28.44,1.84,40,43,30,21,20,10,1400,83,192,169,89,137,278,500,333,0,0,0,0,66,154,0,0,'LAST_HIT','false'),
(21215,21215,'Vault Monk',0,'',0,'LineageMonster.succubus_bi',10.00,43.20,37,'female','L2Monster',40,1338,480,28.44,1.84,40,43,30,21,20,10,1485,91,222,154,104,147,278,500,333,0,0,0,0,66,132,0,0,'LAST_HIT','false'),
(21216,21216,'Overlord of the Holy Lands',0,'',0,'LineageMonster.skeleton_knight_20_bi',12.00,30.50,40,'male','L2Monster',40,1527,531,28.44,1.84,40,43,30,21,20,10,1701,110,300,183,131,164,278,0,333,129,646,0,0,44,176,1,0,'LAST_HIT','false'),
(21217,21217,'Hallowed Priest',0,'',0,'LineageMonster.banshee_20_bi',10.00,27.50,42,'female','L2Monster',40,1660,589,34.76,2.14,40,43,30,21,20,10,1913,127,311,183,152,175,278,500,333,0,0,0,0,80,135,0,0,'LAST_HIT','false'),
(21218,21218,'Vault Overlord',0,'',0,'LineageMonster.death_blader_10_sm',14.00,40.50,45,'male','L2Monster',40,1870,677,34.76,2.14,40,43,30,21,20,10,2315,161,415,216,188,193,278,500,333,297,0,0,0,100,160,1,0,'LAST_HIT','false'),
(21219,21219,'Vault Priest',0,'',0,'LineageMonster.bloody_queen_10_sm',13.00,38.00,47,'female','L2Monster',40,2016,738,34.76,2.14,40,43,30,21,20,10,2396,171,427,215,216,206,278,500,333,0,0,0,0,80,135,0,0,'LAST_HIT','false'),
(21220,21220,'Sepulcher Archon',0,'',0,'LineageMonster.skeleton_knight_30_bi',13.00,33.00,50,'male','L2Monster',40,2245,830,34.76,2.14,40,43,30,21,20,10,2658,200,560,253,264,226,278,0,333,131,107,0,0,44,187,1,0,'LAST_HIT','false'),
(21221,21221,'Sepulcher Inquisitor',0,'',0,'LineageMonster.banshee_30_bi',11.00,30.00,52,'female','L2Monster',40,2402,892,41.08,2.45,40,43,30,21,20,10,2933,227,570,251,300,239,278,500,333,0,0,0,0,88,159,0,0,'LAST_HIT','false'),
(21222,21222,'Sepulcher Archon',0,'',0,'LineageMonster.death_blader_10_bi',16.00,49.50,55,'male','L2Monster',40,2643,987,41.08,2.45,40,43,30,21,20,10,3459,279,737,292,360,261,278,500,333,298,0,0,0,110,187,1,0,'LAST_HIT','false'),
(21223,21223,'Sepulcher Inquisitor',0,'',0,'LineageMonster.bloody_queen_10_bi',15.00,46.00,57,'female','L2Monster',40,2806,1052,41.08,2.45,40,43,30,21,20,10,3524,293,743,289,405,276,278,500,333,0,0,0,0,88,159,0,0,'LAST_HIT','false'),
(21224,21224,'Sepulcher Guardian',0,'',0,'LineageMonster.skeleton_royal_guard_20_bi',13.00,34.50,60,'male','L2Monster',40,3054,1150,41.08,2.45,40,43,30,21,20,10,3828,332,828,335,478,299,317,0,333,233,0,0,0,88,209,1,0,'LAST_HIT','false'),
(21225,21225,'Sepulcher Sage',0,'',0,'LineageMonster.vale_master_10_bi',13.00,44.00,62,'male','L2Monster',40,3219,1217,47.40,2.78,40,43,30,21,20,10,4169,371,944,330,532,315,278,500,333,311,0,0,0,77,176,0,0,'LAST_HIT','false'),
(21226,21226,'Sepulcher Guardian',0,'',0,'LineageMonster.death_knight',12.00,31.00,65,'male','L2Monster',40,3465,1319,47.40,2.78,40,43,30,21,20,10,4831,448,1184,380,619,340,278,500,333,0,0,0,0,27,190,1,0,'LAST_HIT','false'),
(21227,21227,'Sepulcher Sage',0,'',0,'LineageMonster.doll_master',20.00,42.00,67,'male','L2Monster',40,3626,1388,47.40,2.78,40,43,30,21,20,10,5444,518,1169,373,681,356,278,500,333,0,0,0,0,88,176,1,0,'LAST_HIT','false'),
(21228,21228,'Sepulcher Guard',0,'',0,'LineageMonster.skeleton_royal_guard_30_bi',14.00,37.50,70,'male','L2Monster',40,3862,1493,47.40,2.78,40,43,30,21,20,10,5211,516,1265,427,780,382,317,0,333,236,0,0,0,80,200,1,0,'LAST_HIT','false'),
(21229,21229,'Sepulcher Preacher',0,'',0,'LineageMonster.vale_master_30_bi',15.00,52.00,72,'male','L2Monster',40,4013,1565,53.72,3.09,40,43,30,21,20,10,5623,571,1413,417,849,399,278,500,333,326,0,0,0,70,165,0,0,'LAST_HIT','false'),
(21230,21230,'Sepulcher Guard',0,'',0,'LineageMonster.death_knight',12.00,31.00,75,'male','L2Monster',40,4229,1673,53.72,3.09,40,43,30,21,20,10,6432,678,1720,475,957,425,278,500,333,0,0,0,0,27,200,1,0,'LAST_HIT','false'),
(21231,21231,'Sepulcher Preacher',0,'',0,'LineageMonster.doll_master_20_bi',24.00,50.40,77,'male','L2Monster',40,4364,1747,53.72,3.09,40,43,30,21,20,10,6431,696,1664,463,1031,442,278,500,333,0,0,0,0,80,165,1,0,'LAST_HIT','false'),
(21232,21232,'Barrow Guardian',0,'',0,'LineageMonster.skeleton',11.00,25.00,20,'male','L2Monster',40,541,213,15.80,1.21,40,43,30,21,20,10,521,23,57,94,23,76,278,0,333,216,0,0,0,66,143,1,0,'LAST_HIT','false'),
(21233,21233,'Barrow Seer',0,'',0,'LineageMonster.binding',12.00,21.00,22,'male','L2Monster',40,611,242,22.12,1.53,40,43,30,21,20,10,612,29,68,87,28,83,278,500,333,0,0,0,0,11,121,1,0,'LAST_HIT','false'),
(21234,21234,'Grave Guardian',0,'',0,'LineageMonster.imp',10.00,24.00,25,'male','L2Monster',40,728,287,22.12,1.53,40,43,30,21,20,10,780,39,88,116,37,94,278,500,333,0,0,0,0,66,143,0,0,'LAST_HIT','false'),
(21235,21235,'Grave Seer',0,'',0,'LineageMonster.succubus',10.00,36.00,27,'female','L2Monster',40,813,318,22.12,1.53,40,43,30,21,20,10,830,42,104,106,45,102,278,500,333,0,0,0,0,66,121,0,0,'LAST_HIT','false'),
(21236,21236,'Barrow Sentinel',0,'',0,'LineageMonster.skeleton_bi',11.00,31.00,30,'male','L2Monster',40,954,365,22.12,1.53,40,43,30,21,20,10,957,52,132,140,58,114,278,0,333,69,0,0,0,60,140,1,0,'LAST_HIT','false'),
(21237,21237,'Barrow Monk',0,'',0,'LineageMonster.binding_20_bi',14.00,25.30,32,'male','L2Monster',40,1056,397,28.44,1.84,40,43,30,21,20,10,1110,62,154,129,69,123,278,500,333,0,0,0,0,10,110,1,0,'LAST_HIT','false'),
(21238,21238,'Grave Sentinel',0,'',0,'LineageMonster.imp_bi',10.00,30.00,35,'male','L2Monster',40,1220,446,28.44,1.84,40,43,30,21,20,10,1400,83,192,169,89,137,278,500,333,0,0,0,0,60,140,0,0,'LAST_HIT','false'),
(21239,21239,'Grave Monk',0,'',0,'LineageMonster.succubus_bi',10.00,43.20,37,'female','L2Monster',40,1338,480,28.44,1.84,40,43,30,21,20,10,1485,91,222,154,104,147,278,500,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(21240,21240,'Barrow Overlord',0,'',0,'LineageMonster.skeleton_knight_20_bi',12.00,30.50,40,'male','L2Monster',40,1527,531,28.44,1.84,40,43,30,21,20,10,1701,110,300,183,131,164,278,0,333,129,0,0,0,44,176,1,0,'LAST_HIT','false'),
(21241,21241,'Barrow Priest',0,'',0,'LineageMonster.banshee_20_bi',10.00,27.50,42,'female','L2Monster',40,1660,589,34.76,2.14,40,43,30,21,20,10,1913,127,311,183,152,175,278,500,333,0,0,0,0,88,148,0,0,'LAST_HIT','false'),
(21242,21242,'Grave Overlord',0,'',0,'LineageMonster.death_blader_10_sm',14.00,40.50,45,'male','L2Monster',40,1870,677,34.76,2.14,40,43,30,21,20,10,2315,161,415,216,188,193,278,500,333,297,0,0,0,100,160,1,0,'LAST_HIT','false'),
(21243,21243,'Grave Priest',0,'',0,'LineageMonster.bloody_queen_10_sm',13.00,38.00,47,'female','L2Monster',40,2016,738,34.76,2.14,40,43,30,21,20,10,2396,171,427,215,216,206,278,500,333,0,0,0,0,80,135,0,0,'LAST_HIT','false'),
(21244,21244,'Crypt Archon',0,'',0,'LineageMonster.skeleton_knight_30_bi',13.00,33.00,50,'male','L2Monster',40,2245,830,34.76,2.14,40,43,30,21,20,10,2658,200,560,253,264,226,278,0,333,131,0,0,0,44,187,1,0,'LAST_HIT','false'),
(21245,21245,'Crypt Inquisitor',0,'',0,'LineageMonster.banshee_30_bi',11.00,30.00,52,'female','L2Monster',40,2402,892,41.08,2.45,40,43,30,21,20,10,2933,227,570,251,300,239,278,500,333,0,0,0,0,88,159,0,0,'LAST_HIT','false'),
(21246,21246,'Tomb Archon',0,'',0,'LineageMonster.death_blader_10_bi',16.00,49.50,55,'male','L2Monster',40,2643,987,41.08,2.45,40,43,30,21,20,10,3459,279,737,292,360,261,278,500,333,298,0,0,0,110,187,1,0,'LAST_HIT','false'),
(21247,21247,'Tomb Inquisitor',0,'',0,'LineageMonster.bloody_queen_10_bi',15.00,46.00,57,'female','L2Monster',40,2806,1052,41.08,2.45,40,43,30,21,20,10,3524,293,743,289,405,276,278,500,333,0,0,0,0,88,159,0,0,'LAST_HIT','false'),
(21248,21248,'Crypt Guardian',0,'',0,'LineageMonster.skeleton_royal_guard_20_bi',13.00,34.50,60,'male','L2Monster',40,3054,1150,41.08,2.45,40,43,30,21,20,10,3828,332,828,335,478,299,317,0,333,233,0,0,0,80,190,1,0,'LAST_HIT','false'),
(21249,21249,'Crypt Sage',0,'',0,'LineageMonster.vale_master_10_bi',13.00,44.00,62,'male','L2Monster',40,3219,1217,47.40,2.78,40,43,30,21,20,10,4169,371,944,330,532,315,278,500,333,311,0,0,0,70,160,0,0,'LAST_HIT','false'),
(21250,21250,'Tomb Guardian',0,'',0,'LineageMonster.death_knight',12.00,31.00,65,'male','L2Monster',40,3465,1319,47.40,2.78,40,43,30,21,20,10,4831,448,1184,380,619,340,278,500,333,0,0,0,0,27,190,1,0,'LAST_HIT','false'),
(21251,21251,'Tomb Sage',0,'',0,'LineageMonster.doll_master',20.00,42.00,67,'male','L2Monster',40,3626,1388,47.40,2.78,40,43,30,21,20,10,5444,518,1169,373,681,356,278,500,333,0,0,0,0,80,160,1,0,'LAST_HIT','false'),
(21252,21252,'Crypt Guard',0,'',0,'LineageMonster.skeleton_royal_guard_30_bi',14.00,37.50,70,'male','L2Monster',40,3862,1493,47.40,2.78,40,43,30,21,20,10,5211,516,1265,427,780,382,317,0,333,236,0,0,0,88,220,1,0,'LAST_HIT','false'),
(21253,21253,'Crypt Preacher',0,'',0,'LineageMonster.vale_master_30_bi',15.00,52.00,72,'male','L2Monster',40,4013,1565,53.72,3.09,40,43,30,21,20,10,5623,571,1413,417,849,399,278,500,333,326,0,0,0,77,181,0,0,'LAST_HIT','false'),
(21254,21254,'Tomb Guard',0,'',0,'LineageMonster.death_knight',12.00,31.00,75,'male','L2Monster',40,4229,1673,53.72,3.09,40,43,30,21,20,10,6432,678,1720,475,957,425,278,500,333,78,0,0,0,29,220,1,0,'LAST_HIT','false'),
(21255,21255,'Tomb Preacher',0,'',0,'LineageMonster.doll_master_20_bi',24.00,50.40,77,'male','L2Monster',40,4364,1747,53.72,3.09,40,43,30,21,20,10,7190,778,1664,463,1031,442,278,500,333,0,0,0,0,80,165,1,0,'LAST_HIT','false'),
(21256,21256,'Underground Werewolf',0,'',0,'LineageMonster.werewolf_bi',11.00,29.70,23,'male','L2Monster',40,648,257,5.53,1.53,40,43,30,21,20,10,754,36,75,91,31,87,278,400,333,0,0,0,0,55,148,0,0,'LAST_HIT','false'),
(21257,21257,'Evil Eye Seer',0,'',0,'LineageMonster.monster_eye',21.00,43.00,18,'male','L2Monster',40,476,193,3.95,1.21,40,43,30,21,20,10,646,28,48,73,19,70,278,0,333,0,0,0,0,99,170,0,0,'LAST_HIT','true'),
(21258,21258,'Fallen Orc Shaman',0,'',0,'LineageMonster.ketra_orc_shaman',10.00,23.00,58,'male','L2Monster',40,2889,1084,10.27,2.45,40,43,30,21,20,10,0,0,781,297,428,284,278,0,333,9,0,0,0,10,130,0,0,'LAST_HIT','true'),
(21259,21259,'Fallen Orc Shaman',0,'',0,'LineageMonster.saber_toothed_tiger',34.00,28.00,59,'male','L2Monster',40,2971,1117,10.27,2.45,40,43,30,21,20,10,12983,1110,820,305,453,291,278,500,333,0,0,0,0,60,180,0,0,'LAST_HIT','true'),
(21260,21260,'Betrayer Orc Hero',0,'',0,'LineageMonster.ketra_orc_warrior',12.00,24.00,50,'male','L2Monster',40,2245,830,8.69,2.14,40,43,30,21,20,10,3691,278,509,278,264,226,278,0,333,74,0,0,0,39,187,0,0,'LAST_HIT','false'),
(21261,21261,'Ol Mahum Transcender',0,'',0,'LineageMonster.ol_mahum',13.50,25.00,50,'male','L2Monster',40,2245,830,8.69,2.14,40,43,30,21,20,10,4284,323,509,236,264,226,278,0,333,127,0,0,0,50,130,0,0,'LAST_HIT','true'),
(21262,21262,'Ol Mahum Transcender',0,'',0,'LineageMonster.ol_mahum_champion',14.00,27.00,53,'male','L2Monster',40,2481,923,10.27,2.45,40,43,30,21,20,10,7732,608,602,304,319,247,278,500,333,127,0,0,0,55,154,0,0,'LAST_HIT','true'),
(21263,21263,'Ol Mahum Transcender',0,'',0,'LineageMonster.oel_mahum',20.00,37.00,55,'male','L2Monster',40,2643,987,10.27,2.45,40,43,30,21,20,10,11790,952,670,322,360,261,278,500,333,127,0,0,0,77,165,0,0,'LAST_HIT','true'),
(21264,21264,'Ol Mahum Transcender',0,'',0,'LineageMonster.kel_mahum',13.00,26.00,58,'male','L2Monster',40,2889,1084,10.27,2.45,40,43,30,21,20,10,19082,1612,781,349,428,284,278,500,333,127,0,0,0,55,176,0,0,'LAST_HIT','true'),
(21265,21265,'Cave Ant Larva',0,'',0,'LineageMonster.ant_larva',12.00,8.00,36,'male','L2Monster',40,1279,463,7.11,1.84,40,43,30,21,20,10,1586,96,206,175,96,142,278,0,333,0,0,0,0,44,66,0,0,'LAST_HIT','true'),
(21266,21266,'Cave Ant Larva',0,'',0,'LineageMonster.ant_larva',12.00,8.00,36,'male','L2Monster',40,1279,463,7.11,1.84,40,43,30,21,20,10,0,0,206,175,96,142,278,0,333,0,0,0,0,44,66,0,0,'LAST_HIT','true'),
(21267,21267,'Cave Ant Larva',0,'',0,'LineageMonster.ant_larva',12.00,8.00,36,'male','L2Monster',40,1279,463,7.11,1.84,40,43,30,21,20,10,0,0,206,175,96,142,278,0,333,0,0,0,0,44,66,0,0,'LAST_HIT','true'),
(21268,21268,'Cave Ant Larva',0,'',0,'LineageMonster.ant_larva',12.00,8.00,36,'male','L2Monster',40,1279,463,14.22,1.84,40,43,30,21,20,10,1475,89,187,193,96,142,278,0,333,0,0,0,0,44,66,0,0,'LAST_HIT','true'),
(21269,21269,'Cave Ant',0,'',0,'LineageMonster.ant',26.00,15.00,37,'male','L2Monster',40,1338,480,7.11,1.84,40,43,30,21,20,10,3368,207,222,154,104,147,278,500,333,0,0,0,0,44,143,0,0,'LAST_HIT','true'),
(21270,21270,'Cave Ant Soldier',0,'',0,'LineageMonster.ant_soldier',35.00,17.00,38,'male','L2Monster',40,1400,497,7.11,1.84,40,43,30,21,20,10,3891,243,238,188,112,153,278,500,333,0,0,0,0,88,143,0,0,'LAST_HIT','true'),
(21271,21271,'Cave Ant',0,'',0,'LineageMonster.ant',26.00,15.00,37,'male','L2Monster',40,1338,480,7.11,1.84,40,43,30,21,20,10,2298,141,222,154,104,147,278,500,333,0,0,0,0,44,143,0,0,'LAST_HIT','true'),
(21272,21272,'Cave Ant Soldier',0,'',0,'LineageMonster.ant_soldier',35.00,17.00,38,'male','L2Monster',40,1400,497,7.11,1.84,40,43,30,21,20,10,4085,255,238,188,112,153,278,500,333,0,0,0,0,88,143,0,0,'LAST_HIT','true'),
(21273,21273,'Cave Noble Ant',0,'',0,'LineageMonster.noble_ant',20.00,48.00,39,'male','L2Monster',40,1462,514,14.22,1.84,40,43,30,21,20,10,5918,376,280,177,121,158,278,500,333,0,0,0,0,88,191,0,0,'LAST_HIT','true'),
(21274,21274,'Kookaburra',0,'',0,'LineageMonster2.youth_ostrich',8.00,26.40,67,'male','L2Monster',40,3626,1388,5.93,2.78,40,43,30,21,20,10,8356,796,1169,373,681,356,278,0,333,0,0,0,0,25,209,0,0,'LAST_HIT','true'),
(21275,21275,'Kookaburra',0,'',0,'LineageMonster2.youth_ostrich',8.00,26.40,67,'male','L2Monster',40,3626,1388,5.93,2.78,40,43,30,21,20,10,8356,796,1415,308,681,356,278,0,333,0,0,0,0,25,209,0,0,'LAST_HIT','true'),
(21276,21276,'Kookaburra',0,'',0,'LineageMonster2.youth_ostrich',8.00,26.40,67,'male','L2Monster',40,3626,1388,5.93,2.78,40,43,30,21,20,10,8356,796,1063,410,681,356,278,0,333,0,0,0,0,25,209,0,0,'LAST_HIT','true'),
(21278,21278,'Antelope',0,'',0,'LineageMonster2.antelope',17.00,34.00,68,'male','L2Monster',40,3706,1423,5.93,2.78,40,43,30,21,20,10,8608,832,1217,449,713,365,278,0,333,0,0,0,0,49,203,0,0,'LAST_HIT','true'),
(21279,21279,'Antelope',0,'',0,'LineageMonster2.antelope',17.00,34.00,68,'male','L2Monster',40,3706,1423,5.93,2.78,40,43,30,21,20,10,8608,832,1106,494,713,365,278,0,333,0,0,0,0,49,181,0,0,'LAST_HIT','true'),
(21280,21280,'Antelope',0,'',0,'LineageMonster2.antelope',17.00,34.00,68,'male','L2Monster',40,3706,1423,5.93,2.78,40,43,30,21,20,10,8608,832,1473,371,713,365,278,0,333,0,0,0,0,49,181,0,0,'LAST_HIT','true'),
(21282,21282,'Bandersnatch',0,'',0,'LineageMonster2.bandersnatch',18.00,25.00,69,'male','L2Monster',40,3784,1458,5.93,2.78,40,43,30,21,20,10,9040,884,1757,460,746,373,200,150,333,0,0,0,0,33,187,0,0,'LAST_HIT','true'),
(21283,21283,'Bandersnatch',0,'',0,'LineageMonster2.bandersnatch',18.00,25.00,69,'male','L2Monster',40,3784,1458,5.93,2.78,40,43,30,21,20,10,9040,884,2127,380,746,373,200,150,333,0,0,0,0,33,187,0,0,'LAST_HIT','true'),
(21284,21284,'Bandersnatch',0,'',0,'LineageMonster2.bandersnatch',18.00,25.00,69,'male','L2Monster',40,3784,1458,5.93,2.78,40,43,30,21,20,10,9040,884,1598,506,746,373,197,150,333,0,0,0,0,30,170,0,0,'LAST_HIT','true'),
(21286,21286,'Buffalo',0,'',0,'LineageMonster2.buffalo',22.00,31.00,70,'male','L2Monster',40,3862,1493,5.93,2.78,40,43,30,21,20,10,9121,904,1825,470,780,382,200,0,333,0,0,0,0,22,187,0,0,'LAST_HIT','true'),
(21287,21287,'Buffalo',0,'',0,'LineageMonster2.buffalo',22.00,31.00,70,'male','L2Monster',40,3862,1493,5.93,2.78,40,43,30,21,20,10,9121,904,1659,517,780,382,200,0,333,0,0,0,0,22,187,0,0,'LAST_HIT','true'),
(21288,21288,'Buffalo',0,'',0,'LineageMonster2.buffalo',22.00,31.00,70,'male','L2Monster',40,3862,1493,5.93,2.78,40,43,30,21,20,10,9121,904,2209,388,780,382,200,0,333,0,0,0,0,22,187,0,0,'LAST_HIT','true'),
(21290,21290,'Grendel',0,'',0,'LineageMonster2.bionic_bear',15.00,39.00,71,'male','L2Monster',40,3938,1529,6.72,3.09,40,43,30,21,20,10,9572,960,1894,481,814,390,200,150,333,0,0,0,0,39,176,0,0,'LAST_HIT','true'),
(21291,21291,'Grendel',0,'',0,'LineageMonster2.bionic_bear',15.00,39.00,71,'male','L2Monster',40,3938,1529,6.72,3.09,40,43,30,21,20,10,9572,960,1721,529,814,390,200,150,333,0,0,0,0,39,176,0,0,'LAST_HIT','true'),
(21292,21292,'Grendel',0,'',0,'LineageMonster2.bionic_bear',15.00,39.00,71,'male','L2Monster',40,3938,1529,6.72,3.09,40,43,30,21,20,10,9572,960,2291,397,814,390,200,150,333,0,0,0,0,39,176,0,0,'LAST_HIT','true'),
(21294,21294,'Canyon Antelope',0,'',0,'LineageMonster2.antelope',17.00,34.00,68,'male','L2Monster',40,3706,1423,23.70,2.78,40,43,30,21,20,10,6893,666,1217,449,713,365,278,0,333,0,0,0,0,45,200,0,0,'LAST_HIT','false'),
(21295,21295,'Canyon Antelope Slave',0,'',0,'LineageMonster2.antelope',17.00,34.00,69,'male','L2Monster',40,3784,1458,23.70,2.78,40,43,30,21,20,10,7311,715,1265,460,746,373,361,300,333,0,0,0,0,45,200,0,0,'LAST_HIT','false'),
(21296,21296,'Canyon Bandersnatch',0,'',0,'LineageMonster2.bandersnatch',18.00,25.00,70,'male','L2Monster',40,3862,1493,35.55,2.78,40,43,30,21,20,10,7244,718,2429,353,780,382,200,300,333,0,0,0,0,33,198,0,0,'LAST_HIT','false'),
(21297,21297,'Canyon Bandersnatch Slave',0,'',0,'LineageMonster2.bandersnatch',18.00,25.00,71,'male','L2Monster',40,3938,1529,40.29,3.09,40,43,30,21,20,10,7275,730,1721,529,814,390,200,200,333,0,0,0,0,99,180,0,0,'LAST_HIT','false'),
(21298,21298,'Eye of Restrainer',0,'',0,'LineageMonster.monster_eye',21.00,43.00,71,'male','L2Monster',40,3938,1529,26.86,3.09,40,43,30,21,20,10,7023,705,1239,449,814,390,278,150,333,0,0,0,0,99,154,0,0,'LAST_HIT','false'),
(21299,21299,'Buffalo Slave',0,'',0,'LineageMonster2.buffalo_ec',22.00,31.00,72,'male','L2Monster',40,4013,1565,40.29,3.09,40,43,30,21,20,10,7481,760,2159,446,849,399,200,300,333,0,0,0,0,22,176,0,0,'LAST_HIT','false'),
(21300,21300,'Eye of Guide',0,'',0,'LineageMonster2.parasitic_eye_20_sm',20.00,50.50,72,'male','L2Monster',40,4013,1565,40.29,3.09,40,43,30,21,20,10,7360,747,1168,505,849,399,278,0,333,0,0,0,0,33,170,0,0,'LAST_HIT','false'),
(21301,21301,'Gaze of Nightmare',0,'',0,'LineageMonster.field_stalker',15.00,30.00,72,'male','L2Monster',40,4013,1565,53.72,3.09,40,43,30,21,20,10,6624,673,1061,654,849,399,278,0,333,0,0,0,0,77,214,0,0,'LAST_HIT','false'),
(21302,21302,'Eye of Watchman',0,'',0,'LineageMonster2.parasitic_eye',25.00,63.00,73,'male','L2Monster',40,4086,1601,40.29,3.09,40,43,30,21,20,10,7105,731,1770,352,885,407,278,300,333,0,0,0,0,33,200,0,0,'LAST_HIT','false'),
(21303,21303,'Homunculus',0,'',0,'LineageMonster2.homunculus_20_sm',10.00,26.00,73,'male','L2Monster',40,4086,1601,40.29,3.09,40,43,30,21,20,10,7185,739,1947,320,885,407,278,150,333,0,0,0,0,33,203,0,0,'LAST_HIT','false'),
(21304,21304,'Grendel Slave',0,'',0,'LineageMonster2.bionic_bear',15.00,39.00,74,'male','L2Monster',40,4158,1637,53.72,3.09,40,43,30,21,20,10,7918,825,2312,466,921,416,200,200,333,0,0,0,0,39,180,0,0,'LAST_HIT','false'),
(21305,21305,'Eye of Pilgrim',0,'',0,'LineageMonster2.parasitic_eye_20_sm',20.00,50.50,74,'male','L2Monster',40,4158,1637,40.29,3.09,40,43,30,21,20,10,7775,810,1375,479,921,416,278,0,333,0,0,0,0,33,181,0,0,'LAST_HIT','false'),
(21306,21306,'Disciples of Protection',0,'',0,'LineageMonster2.apostle_warrior',8.00,30.00,74,'female','L2Monster',40,4158,1637,67.15,3.09,40,43,30,21,20,10,8441,880,1579,682,921,416,200,150,333,6717,0,0,0,55,176,0,0,'LAST_HIT','false'),
(21307,21307,'Elder Homunculus',0,'',0,'LineageMonster2.homunculus',12.00,32.50,75,'male','L2Monster',40,4229,1673,53.72,3.09,40,43,30,21,20,10,7394,780,1892,367,957,425,278,150,333,0,0,0,0,33,220,0,0,'LAST_HIT','false'),
(21308,21308,'Disciples of Punishment',0,'',0,'LineageMonster2.apostle_warrior',8.00,30.00,75,'female','L2Monster',40,4229,1673,67.15,3.09,40,43,30,21,20,10,7860,829,2389,475,957,425,200,150,333,6717,0,0,0,55,209,0,0,'LAST_HIT','false'),
(21309,21309,'Disciples of Punishment',0,'',0,'LineageMonster2.apostle_warrior',8.00,30.00,75,'female','L2Monster',40,4229,1673,67.15,3.09,40,43,30,21,20,10,8192,864,1795,633,957,425,200,150,333,6717,0,0,0,55,209,0,0,'LAST_HIT','false'),
(21310,21310,'Disciples of Authority',0,'',0,'LineageMonster2.apostle_mage',11.00,38.50,76,'male','L2Monster',40,4297,1710,67.15,3.09,40,43,30,21,20,10,8071,863,1775,412,994,433,278,150,333,6718,0,0,0,55,170,0,0,'LAST_HIT','false'),
(21311,21311,'Disciples of Authority',0,'',0,'LineageMonster2.apostle_mage',11.00,38.50,76,'male','L2Monster',40,4297,1710,67.15,3.09,40,43,30,21,20,10,7441,795,1334,549,994,433,278,150,333,6718,0,0,0,55,170,0,0,'LAST_HIT','false'),
(21312,21312,'Eye of Ruler',0,'',0,'LineageMonster2.parasitic_eye',25.00,63.00,74,'male','L2Monster',40,4158,1637,40.29,3.09,40,43,30,21,20,10,10752,1121,1375,479,921,416,278,300,333,0,0,0,0,33,200,0,0,'LAST_HIT','false'),
(21313,21313,'Sly Hound Dog',0,'',0,'LineageMonster2.bandersnatch',18.00,25.00,72,'male','L2Monster',40,4013,1565,40.29,3.09,40,43,30,21,20,10,10294,1046,2375,406,849,399,200,0,333,0,0,0,0,33,203,0,0,'LAST_HIT','false'),
(21314,21314,'Hot Springs Bandersnatchling',0,'',0,'LineageMonster2.bandersnatch',18.00,25.00,73,'male','L2Monster',40,4086,1601,26.86,3.09,40,43,30,21,20,10,8609,886,2032,502,885,407,197,400,333,0,0,0,0,30,195,0,0,'LAST_HIT','true'),
(21315,21315,'Hot Springs Buffalo',0,'',0,'LineageMonster2.buffalo',22.00,31.00,73,'male','L2Monster',40,4086,1601,26.86,3.09,40,43,30,21,20,10,8971,923,2032,502,885,407,200,0,333,0,0,0,0,22,187,0,0,'LAST_HIT','true'),
(21316,21316,'Hot Springs Flava',0,'',0,'LineageMonster2.flava',18.00,34.00,74,'male','L2Monster',40,4158,1637,26.86,3.09,40,43,30,21,20,10,10556,1100,1513,512,921,416,278,450,333,0,0,0,0,30,180,0,0,'LAST_HIT','true'),
(21317,21317,'Hot Springs Atroxspawn',0,'',0,'LineageMonster2.kailiharim',45.00,39.00,74,'male','L2Monster',40,4158,1637,26.86,3.09,40,43,30,21,20,10,8846,922,2102,512,921,416,197,500,333,0,0,0,0,105,190,0,0,'LAST_HIT','true'),
(21318,21318,'Hot Springs Antelope',0,'',0,'LineageMonster2.antelope',17.00,34.00,74,'male','L2Monster',40,4158,1637,26.86,3.09,40,43,30,21,20,10,9247,964,1513,512,921,416,278,0,333,0,0,0,0,49,203,0,0,'LAST_HIT','true'),
(21319,21319,'Hot Springs Nepenthes',0,'',0,'LineageMonster2.nephenthes',28.00,43.50,75,'male','L2Monster',40,4229,1673,26.86,3.09,40,43,30,21,20,10,11636,1227,2172,523,957,425,197,350,333,0,0,0,0,48,190,0,0,'LAST_HIT','true'),
(21320,21320,'Hot Springs Yeti',0,'',0,'LineageMonster.yeti_20_bi',18.00,32.00,75,'male','L2Monster',40,4229,1673,26.86,3.09,40,43,30,21,20,10,9470,999,1563,523,957,425,278,0,333,0,0,0,0,17,187,0,0,'LAST_HIT','true'),
(21321,21321,'Hot Springs Atrox',0,'',0,'LineageMonster2.kailiharim',45.00,39.00,76,'male','L2Monster',40,4297,1710,26.86,3.09,40,43,30,21,20,10,11135,1190,2242,534,994,433,200,500,333,0,0,0,0,115,190,0,0,'LAST_HIT','true'),
(21322,21322,'Hot Springs Bandersnatch',0,'',0,'LineageMonster2.bandersnatch',18.00,25.00,76,'male','L2Monster',40,4297,1710,26.86,3.09,40,43,30,21,20,10,11135,1190,2242,534,994,433,197,400,333,0,0,0,0,30,195,0,0,'LAST_HIT','true'),
(21323,21323,'Hot Springs Grendel',0,'',0,'LineageMonster2.bionic_bear',15.00,39.00,76,'male','L2Monster',40,4297,1710,26.86,3.09,40,43,30,21,20,10,9753,1042,2242,534,994,433,256,0,333,0,0,0,0,36,165,0,0,'LAST_HIT','true'),
(21324,21324,'Ketra Orc Footman',0,'',0,'LineageMonster.ketra_orc',12.00,29.00,77,'male','L2Monster',40,4364,1747,26.86,3.09,40,43,30,21,20,10,9323,1009,1664,544,1031,442,278,150,333,79,0,0,0,49,192,0,0,'LAST_HIT','true'),
(21325,21325,'Ketra\'s War Hound',0,'',0,'LineageMonster2.bandersnatch',18.00,25.00,77,'male','L2Monster',40,4364,1747,26.86,3.09,40,43,30,21,20,10,9015,975,2543,495,1031,442,200,150,333,0,0,0,0,33,203,0,0,'LAST_HIT','true'),
(21326,21326,'Grazing Kookaburra',0,'',0,'LineageMonster2.youth_ostrich',8.00,26.40,77,'male','L2Monster',40,4364,1747,26.86,3.09,40,43,30,21,20,10,9015,975,1375,560,1031,442,278,150,333,0,0,0,0,25,209,0,0,'LAST_HIT','true'),
(21327,21327,'Ketra Orc Raider',0,'',0,'LineageMonster.ketra_orc_warrior',12.00,24.00,78,'male','L2Monster',40,4428,1784,26.86,3.09,40,43,30,21,20,10,10240,1120,2075,459,1069,451,278,150,333,79,6919,0,0,39,192,0,0,'LAST_HIT','true'),
(21328,21328,'Ketra Orc Scout',0,'',0,'LineageMonster.ketra_orc_archer',12.00,27.00,78,'male','L2Monster',500,4428,1784,26.86,3.09,40,43,30,21,20,10,9816,1074,3464,611,1069,451,249,150,333,288,0,0,0,49,192,0,0,'LAST_HIT','true'),
(21329,21329,'Ketra Orc Shaman',0,'',0,'LineageMonster.ketra_orc_shaman',10.00,23.00,78,'male','L2Monster',40,4490,1821,26.86,3.09,40,43,30,21,20,10,9955,1103,1765,481,1107,459,278,150,333,92,0,0,0,11,165,0,0,'LAST_HIT','true'),
(21330,21330,'Grazing Buffalo',0,'',0,'LineageMonster2.buffalo',22.00,31.00,78,'male','L2Monster',40,4490,1821,26.86,3.09,40,43,30,21,20,10,9489,1051,2026,685,1107,459,200,150,333,0,0,0,0,22,181,0,0,'LAST_HIT','true'),
(21331,21331,'Ketra Orc Warrior',0,'',0,'LineageMonster.ketra_orc_warrior',12.00,24.00,78,'male','L2Monster',40,4550,1859,26.86,3.09,40,43,30,21,20,10,9304,1044,1996,524,1144,468,278,150,333,79,6919,0,0,39,192,0,0,'LAST_HIT','true'),
(21332,21332,'Ketra Orc Lieutenant',0,'',0,'LineageMonster2.ketra_orc_chieftain',11.00,38.50,78,'male','L2Monster',40,4550,1859,26.86,3.09,40,43,30,21,20,10,10420,1169,2291,634,1144,468,200,400,333,6719,0,0,0,26,192,0,0,'LAST_HIT','true'),
(21333,21333,'Grazing Windsus',0,'',0,'LineageMonster.giant_wild_hog',35.00,27.00,78,'male','L2Monster',40,4608,1896,26.86,3.09,40,43,30,21,20,10,9976,1133,1540,710,1182,477,278,150,333,0,0,0,0,38,187,0,0,'LAST_HIT','true'),
(21334,21334,'Ketra Orc Medium',0,'',0,'LineageMonster.ketra_orc_shaman',10.00,23.00,78,'male','L2Monster',40,4608,1896,26.86,3.09,40,43,30,21,20,10,14933,1695,1863,499,1182,477,278,400,333,92,0,0,0,11,165,0,0,'LAST_HIT','true'),
(21335,21335,'Ketra Orc Elite Soldier',0,'',0,'LineageMonster.ketra_orc',12.00,29.00,78,'male','L2Monster',40,4663,1934,26.86,3.09,40,43,30,21,20,10,9625,1106,1912,598,1220,485,278,300,333,79,0,0,0,49,192,0,0,'LAST_HIT','true'),
(21336,21336,'Ketra Orc White Captain',0,'',0,'LineageMonster.ketra_orc_overload_20_bi',14.00,28.80,78,'male','L2Monster',40,4663,1934,26.86,3.09,40,43,30,21,20,10,11317,1300,1738,657,1220,485,278,300,333,80,0,0,0,36,192,0,0,'LAST_HIT','true'),
(21337,21337,'Grazing Elder Buffalo',0,'',0,'LineageMonster2.buffalo',22.00,31.00,78,'male','L2Monster',40,4716,1972,26.86,3.09,40,43,30,21,20,10,10475,1217,2249,736,1258,494,200,150,333,0,0,0,0,22,181,0,0,'LAST_HIT','true'),
(21338,21338,'Ketra Orc Seer',0,'',0,'LineageMonster.ketra_orc_shaman',10.00,23.00,78,'male','L2Monster',40,4716,1972,26.86,3.09,40,43,30,21,20,10,13783,1602,2155,470,1258,494,278,350,333,213,0,0,0,11,176,0,0,'LAST_HIT','true'),
(21339,21339,'Ketra Orc General',0,'',0,'LineageMonster2.ketra_orc_chieftain_20_bi',17.00,46.20,78,'male','L2Monster',40,4766,2011,26.86,3.09,40,43,30,21,20,10,10494,1234,3372,511,1296,502,200,150,333,6719,0,0,0,26,192,0,0,'LAST_HIT','true'),
(21340,21340,'Ketra Orc Battalion Commander',0,'',0,'LineageMonster2.ketra_orc_warlord',12.00,30.00,78,'male','L2Monster',40,4766,2011,26.86,3.09,40,43,30,21,20,10,10494,1234,2006,619,1296,502,278,150,333,80,6919,0,0,29,192,0,0,'LAST_HIT','true'),
(21341,21341,'Grazing Elder Kookaburra',0,'',0,'LineageMonster2.youth_ostrich',8.00,26.40,78,'male','L2Monster',40,4813,2049,26.86,3.09,40,43,30,21,20,10,10986,1307,1696,647,1333,511,278,150,333,0,0,0,0,25,209,0,0,'LAST_HIT','true'),
(21342,21342,'Ketra Orc Grand Seer',0,'',0,'LineageMonster.ketra_orc_shaman',10.00,23.00,78,'male','L2Monster',40,4813,2049,26.86,3.09,40,43,30,21,20,10,14456,1720,2052,629,1333,511,278,150,333,213,0,0,0,11,176,0,0,'LAST_HIT','true'),
(21343,21343,'Ketra Commander',0,'',0,'LineageMonster2.ketra_orc_warlord_20_bi',15.00,36.00,78,'male','L2Monster',40,4608,1896,26.86,3.09,40,43,30,21,20,10,16400,1862,1630,587,1182,477,317,150,333,80,6919,0,0,29,192,0,0,'LAST_HIT','false'),
(21344,21344,'Ketra Elite Guard',0,'',0,'LineageMonster.ketra_orc_overload',12.00,24.00,78,'male','L2Minion',40,4550,1859,26.86,3.09,40,43,30,21,20,10,11138,1250,2195,476,1144,468,278,0,333,80,0,0,0,36,198,0,0,'LAST_HIT','false'),
(21345,21345,'Ketra\'s Head Shaman',0,'',0,'LineageMonster.ketra_orc_shaman',10.00,23.00,78,'male','L2Monster',40,4813,2049,26.86,3.09,40,43,30,21,20,10,12360,1471,2257,572,1333,511,278,150,333,210,0,0,0,11,192,0,0,'LAST_HIT','false'),
(21346,21346,'Ketra\'s Head Guard',0,'',0,'LineageMonster2.ketra_orc_chieftain',11.00,38.50,78,'male','L2Minion',40,4766,2011,26.86,3.09,40,43,30,21,20,10,12279,1444,2303,749,1296,502,200,0,333,6719,0,0,0,26,192,0,0,'LAST_HIT','false'),
(21347,21347,'Ketra Prophet',0,'',0,'LineageMonster.ketra_orc_shaman',10.00,23.00,78,'male','L2Monster',40,4899,2127,26.86,3.09,40,43,30,21,20,10,18779,2289,2141,650,1406,528,278,150,333,213,0,0,0,11,192,0,0,'LAST_HIT','false'),
(21348,21348,'Prophet\'s Guard',0,'',0,'LineageMonster2.ketra_orc_chieftain',11.00,38.50,78,'male','L2Minion',40,4858,2088,26.86,3.09,40,43,30,21,20,10,12871,1550,2913,639,1370,519,200,0,333,6719,0,0,0,26,198,0,0,'LAST_HIT','false'),
(21349,21349,'Prophet\'s Aide',0,'',0,'LineageMonster.ketra_orc_shaman',10.00,23.00,78,'male','L2Minion',40,4858,2088,26.86,3.09,40,43,30,21,20,10,13071,1574,2097,639,1370,519,278,0,333,210,0,0,0,11,198,0,0,'LAST_HIT','false'),
(21350,21350,'Varka Silenos Recruit',0,'',0,'LineageMonster2.barka_silenos_hunter',16.00,38.00,77,'male','L2Monster',40,4364,1747,26.86,3.09,40,43,30,21,20,10,9851,1066,1664,544,1031,442,361,150,333,2504,0,0,0,44,175,0,0,'LAST_HIT','true'),
(21351,21351,'Varka Silenos Footman',0,'',0,'LineageMonster2.barka_silenos_warrior',16.00,41.00,77,'male','L2Monster',40,4364,1747,26.86,3.09,40,43,30,21,20,10,8487,918,1831,495,1031,442,278,400,333,2504,0,0,0,34,185,0,0,'LAST_HIT','true'),
(21352,21352,'Grazing Antelope',0,'',0,'LineageMonster2.antelope',17.00,34.00,77,'male','L2Monster',40,4364,1747,26.86,3.09,40,43,30,21,20,10,9015,975,1375,560,1031,442,278,150,333,0,0,0,0,45,185,0,0,'LAST_HIT','true'),
(21353,21353,'Varka Silenos Scout',0,'',0,'LineageMonster2.barka_silenos_hunter',16.00,38.00,78,'male','L2Monster',40,4428,1784,26.86,3.09,40,43,30,21,20,10,9906,1084,2075,459,1069,451,278,350,333,142,6918,0,0,48,192,0,0,'LAST_HIT','true'),
(21354,21354,'Varka Silenos Hunter',0,'',0,'LineageMonster2.barka_silenos_archer',8.00,37.50,78,'male','L2Monster',500,4428,1784,26.86,3.09,40,43,30,21,20,10,9816,1074,3464,611,1069,451,247,300,333,6917,0,0,0,30,175,0,0,'LAST_HIT','true'),
(21355,21355,'Varka Silenos Shaman',0,'',0,'LineageMonster2.barka_silenos_shaman',14.00,39.50,78,'male','L2Monster',40,4490,1821,26.86,3.09,40,43,30,21,20,10,9492,1052,2451,481,1107,459,200,300,333,6716,0,0,0,39,165,0,0,'LAST_HIT','true'),
(21356,21356,'Grazing Nepenthes',0,'',0,'LineageMonster2.nephenthes',28.00,43.50,78,'male','L2Monster',40,4490,1821,26.86,3.09,40,43,30,21,20,10,9489,1051,2026,685,1107,459,200,150,333,0,0,0,0,52,187,0,0,'LAST_HIT','true'),
(21357,21357,'Varka Silenos Priest',0,'',0,'LineageMonster2.barka_silenos_priest',9.00,41.50,78,'male','L2Monster',40,4550,1859,26.86,3.09,40,43,30,21,20,10,10277,1153,1996,524,1144,468,278,450,333,6716,0,0,0,39,192,0,0,'LAST_HIT','true'),
(21358,21358,'Varka Silenos Warrior',0,'',0,'LineageMonster2.barka_silenos_warrior',16.00,41.00,78,'male','L2Monster',40,4550,1859,26.86,3.09,40,43,30,21,20,10,10771,1209,1649,634,1144,468,278,150,333,142,6918,0,0,37,192,0,0,'LAST_HIT','true'),
(21359,21359,'Grazing Bandersnatch',0,'',0,'LineageMonster2.bandersnatch',18.00,25.00,78,'male','L2Monster',40,4608,1896,26.86,3.09,40,43,30,21,20,10,9976,1133,2139,710,1182,477,200,150,333,0,0,0,0,33,192,0,0,'LAST_HIT','true'),
(21360,21360,'Varka Silenos Medium',0,'',0,'LineageMonster2.barka_silenos_shaman',14.00,39.50,78,'male','L2Monster',40,4608,1896,26.86,3.09,40,43,30,21,20,10,15892,1804,2588,499,1182,477,200,150,333,6716,0,0,0,39,165,0,0,'LAST_HIT','true'),
(21361,21361,'Varka Silenos Magus',0,'',0,'LineageMonster2.barka_silenos_mage_20_bi',11.00,55.20,78,'male','L2Monster',40,4663,1934,26.86,3.09,40,43,30,21,20,10,9625,1106,1912,598,1220,485,278,150,333,6716,0,0,0,39,192,0,0,'LAST_HIT','true'),
(21362,21362,'Varka Silenos Officer',0,'',0,'LineageMonster2.barka_silenos_chieftain',18.00,42.50,78,'male','L2Monster',40,4663,1934,26.86,3.09,40,43,30,21,20,10,11317,1300,2414,657,1220,485,200,150,333,2504,0,0,0,27,192,0,0,'LAST_HIT','true'),
(21363,21363,'Grazing Flava',0,'',0,'LineageMonster2.flava',18.00,34.00,78,'male','L2Monster',40,4716,1972,26.86,3.09,40,43,30,21,20,10,10475,1217,1619,736,1258,494,278,150,333,0,0,0,0,33,181,0,0,'LAST_HIT','true'),
(21364,21364,'Varka Silenos Seer',0,'',0,'LineageMonster2.barka_silenos_shaman',14.00,39.50,78,'male','L2Monster',40,4716,1972,26.86,3.09,40,43,30,21,20,10,13272,1543,2994,470,1258,494,200,150,333,6716,0,0,0,39,176,0,0,'LAST_HIT','true'),
(21365,21365,'Varka Silenos Great Magus',0,'',0,'LineageMonster2.barka_silenos_warrior_20_bi',20.00,49.20,78,'male','L2Monster',40,4766,2011,26.86,3.09,40,43,30,21,20,10,11525,1355,2428,511,1296,502,278,150,333,2500,0,0,0,37,192,0,0,'LAST_HIT','true'),
(21366,21366,'Varka Silenos General',0,'',0,'LineageMonster2.barka_silenos_chieftain',18.00,42.50,78,'male','L2Monster',40,4766,2011,26.86,3.09,40,43,30,21,20,10,12718,1496,2787,619,1296,502,200,150,333,2500,0,0,0,27,192,0,0,'LAST_HIT','true'),
(21367,21367,'Grazing Elder Antelope',0,'',0,'LineageMonster2.antelope',17.00,34.00,78,'male','L2Monster',40,4813,2049,26.86,3.09,40,43,30,21,20,10,10986,1307,1696,647,1333,511,278,150,333,0,0,0,0,49,203,0,0,'LAST_HIT','true'),
(21368,21368,'Varka Silenos Great Seer',0,'',0,'LineageMonster2.barka_silenos_shaman',14.00,39.50,78,'male','L2Monster',40,4813,2049,26.86,3.09,40,43,30,21,20,10,16964,2019,2851,629,1333,511,200,150,333,6716,0,0,0,39,176,0,0,'LAST_HIT','true'),
(21369,21369,'Varka\'s Commander',0,'',0,'LineageMonster2.barka_silenos_chieftain_20_bi',22.00,51.00,78,'male','L2Monster',40,4608,1896,26.86,3.09,40,43,30,21,20,10,15953,1811,2588,587,1182,477,197,150,333,2500,0,0,0,25,175,0,0,'LAST_HIT','false'),
(21370,21370,'Varka\'s Elite Guard',0,'',0,'LineageMonster2.barka_silenos_warrior',16.00,41.00,78,'male','L2Minion',40,4550,1859,26.86,3.09,40,43,30,21,20,10,11565,1298,2195,476,1144,468,278,0,333,2500,0,0,0,34,180,0,0,'LAST_HIT','false'),
(21371,21371,'Varka\'s Head Magus',0,'',0,'LineageMonster2.barka_silenos_shaman',14.00,39.50,78,'male','L2Monster',40,4813,2049,26.86,3.09,40,43,30,21,20,10,12360,1471,3136,572,1333,511,200,150,333,6716,0,0,0,39,192,0,0,'LAST_HIT','false'),
(21372,21372,'Varka\'s Head Guard',0,'',0,'LineageMonster2.barka_silenos_hunter',16.00,38.00,78,'male','L2Minion',40,4766,2011,26.86,3.09,40,43,30,21,20,10,12279,1444,1658,749,1296,502,278,0,333,2500,6918,0,0,48,192,0,0,'LAST_HIT','false'),
(21373,21373,'Varka\'s Prophet',0,'',0,'LineageMonster2.barka_silenos_shaman_20_bi',17.00,47.50,78,'male','L2Monster',40,4899,2127,26.86,3.09,40,43,30,21,20,10,18082,2204,2973,650,1406,528,200,150,333,6716,0,0,0,39,192,0,0,'LAST_HIT','false'),
(21374,21374,'Prophet Guard',0,'',0,'LineageMonster2.barka_silenos_warrior',16.00,41.00,78,'male','L2Minion',40,4858,2088,26.86,3.09,40,43,30,21,20,10,12871,1550,2097,639,1370,519,278,0,333,2500,6918,0,0,37,198,0,0,'LAST_HIT','false'),
(21375,21375,'Disciple of Prophet',0,'',0,'LineageMonster2.barka_silenos_priest',9.00,41.50,78,'male','L2Minion',40,4858,2088,26.86,3.09,40,43,30,21,20,10,12404,1494,2097,639,1370,519,278,0,333,6716,0,0,0,39,198,0,0,'LAST_HIT','false'),
(21376,21376,'Scarlet Stakato Worker',0,'',0,'LineageMonster.blade_stakato_worker',13.00,40.00,78,'male','L2Monster',40,4428,1784,67.15,3.09,40,43,30,21,20,10,7054,772,1886,505,1069,451,278,150,333,235,0,0,0,27,143,0,0,'LAST_HIT','false'),
(21377,21377,'Scarlet Stakato Soldier',0,'',0,'LineageMonster.blade_stakato_soldier',15.00,38.00,78,'male','L2Monster',40,4428,1784,67.15,3.09,40,43,30,21,20,10,6904,755,1886,429,1069,451,278,400,333,180,0,0,0,27,200,0,0,'LAST_HIT','false'),
(21378,21378,'Scarlet Stakato Noble',0,'',0,'LineageMonster.blade_stakato_drone',15.00,39.00,78,'male','L2Monster',40,4490,1821,67.15,3.09,40,43,30,21,20,10,9829,1089,1941,514,1107,459,278,450,333,235,0,0,0,27,200,0,0,'LAST_HIT','false'),
(21379,21379,'Tepra Scorpion',0,'',0,'LineageMonster2.scorpion_20_sm',24.00,52.80,78,'male','L2Monster',40,4490,1821,67.15,3.09,40,43,30,21,20,10,7098,786,1698,514,1107,459,317,150,333,0,0,0,0,40,137,0,0,'LAST_HIT','false'),
(21380,21380,'Tepra Scarab',0,'',0,'LineageMonster2.scarab',14.00,22.00,78,'male','L2Monster',40,4490,1821,67.15,3.09,40,43,30,21,20,10,7237,802,1941,514,1107,459,278,150,333,0,0,0,0,49,192,0,0,'LAST_HIT','false'),
(21381,21381,'Assassin Beetle',0,'',0,'LineageMonster2.tera_beetle',19.00,54.50,78,'male','L2Monster',40,4550,1859,67.15,3.09,40,43,30,21,20,10,8414,944,1996,524,1144,468,278,500,333,0,0,0,0,49,159,0,0,'LAST_HIT','false'),
(21382,21382,'Mercenary of Destruction',0,'',0,'LineageMonster.skeleton_knight',10.00,25.00,78,'male','L2Monster',40,4550,1859,67.15,3.09,40,43,30,21,20,10,10380,1165,1996,524,1144,468,278,150,333,150,103,0,0,44,181,1,0,'LAST_HIT','false'),
(21383,21383,'Knight of Destruction',0,'',0,'LineageMonster.skeleton_royal_guard',11.00,28.50,78,'male','L2Monster',40,4550,1859,67.15,3.09,40,43,30,21,20,10,10396,1167,1996,524,1144,468,278,150,333,946,945,0,0,88,203,1,0,'LAST_HIT','false'),
(21384,21384,'Necromancer of Destruction',0,'',0,'LineageMonster.vale_master_20_bi',14.50,48.00,78,'male','L2Monster',40,4608,1896,67.15,3.09,40,43,30,21,20,10,8915,1012,2050,454,1182,477,278,150,333,0,0,0,0,77,159,0,0,'LAST_HIT','false'),
(21385,21385,'Lavastone Golem',0,'',0,'LineageMonster.stone_golem',20.00,31.00,78,'male','L2Monster',40,4608,1896,67.15,3.09,40,43,30,21,20,10,8585,975,2050,534,1182,477,278,150,333,0,0,0,0,25,44,0,0,'LAST_HIT','false'),
(21386,21386,'Magma Golem',0,'',0,'LineageMonster2.lava_golem',22.00,45.00,78,'male','L2Monster',40,4608,1896,67.15,3.09,40,43,30,21,20,10,9174,1041,2847,534,1182,477,200,150,333,0,0,0,0,14,66,0,0,'LAST_HIT','false'),
(21387,21387,'Arimanes of Destruction',0,'',0,'LineageMonster2.ahrimanes',14.00,57.75,78,'male','L2Monster',40,4663,1934,67.15,3.09,40,43,30,21,20,10,7314,840,2921,543,1220,485,200,150,333,6722,0,0,0,38,203,0,0,'LAST_HIT','false'),
(21388,21388,'Iblis of Destruction',0,'',0,'LineageMonster.fiend_archer',17.00,55.00,78,'male','L2Monster',40,4663,1934,80.58,3.09,40,43,30,21,20,10,9221,1059,2103,543,1220,485,278,150,333,0,0,0,0,77,165,0,0,'LAST_HIT','false'),
(21389,21389,'Balrog of Destruction',0,'',0,'LineageMonster.kaim_vanul',24.00,40.00,78,'male','L2Monster',40,4716,1972,80.58,3.09,40,43,30,21,20,10,9888,1149,2155,553,1258,494,278,150,333,0,0,0,0,40,170,0,0,'LAST_HIT','false'),
(21390,21390,'Ashuras of Destruction',0,'',0,'LineageMonster2.ashuras_30_bi',17.00,49.00,78,'male','L2Monster',40,4766,2011,80.58,3.09,40,43,30,21,20,10,11408,1342,2207,562,1296,502,278,150,333,0,0,0,0,45,209,0,0,'LAST_HIT','false'),
(21391,21391,'Lavasillisk',0,'',0,'LineageMonster.lesser_basilisk',34.00,25.00,78,'male','L2Monster',40,4716,1972,80.58,3.09,40,43,30,21,20,10,7886,916,2155,553,1258,494,278,150,333,0,0,0,0,38,154,0,0,'LAST_HIT','false'),
(21392,21392,'Blazing Ifrit',0,'',0,'LineageMonster2.ifrit_30_bi',13.00,55.00,78,'male','L2Monster',40,4766,2011,80.58,3.09,40,43,30,21,20,10,11251,1323,2207,562,1296,502,278,150,333,0,0,0,0,41,165,0,0,'LAST_HIT','false'),
(21393,21393,'Magma Drake',0,'',0,'LineageMonster2.inferno_drake_20_bi',29.00,42.00,78,'male','L2Monster',40,4813,2049,80.58,3.09,40,43,30,21,20,10,9494,1130,2257,572,1333,511,278,150,333,0,0,0,0,62,214,0,0,'LAST_HIT','false'),
(21394,21394,'Lavasaurus',0,'',0,'LineageMonster2.magmagoil',15.00,75.00,78,'male','L2Monster',500,4490,1821,67.15,3.09,40,43,30,21,20,10,8988,996,5991,437,1107,459,179,400,333,0,0,0,0,1,1,0,0,'LAST_HIT','false'),
(21395,21395,'Elder Lavasaurus',0,'',0,'LineageMonster2.magmagoil_lad',15.00,75.00,78,'male','L2Monster',500,4716,1972,80.58,3.09,40,43,30,21,20,10,9760,1134,6652,470,1258,494,179,150,333,0,0,0,0,1,1,0,0,'LAST_HIT','false'),
(21396,21396,'Carrion Scarab',0,'',0,'LineageMonster2.scarab',14.00,22.00,78,'male','L2Monster',40,4428,1784,40.29,3.09,40,43,30,21,20,10,8182,895,1417,672,1069,451,278,0,333,0,0,0,0,49,143,0,0,'LAST_HIT','false'),
(21397,21397,'Carrion Scarab',0,'',0,'LineageMonster2.scarab',14.00,22.00,78,'male','L2Monster',40,4428,1784,40.29,3.09,40,43,30,21,20,10,7103,777,2282,417,1069,451,278,0,333,0,0,0,0,49,143,0,0,'LAST_HIT','false'),
(21398,21398,'Soldier Scarab',0,'',0,'LineageMonster2.scarab',14.00,22.00,78,'male','L2Monster',40,4428,1784,80.58,3.09,40,43,30,21,20,10,6744,738,1715,555,1069,451,278,350,333,0,0,0,0,49,198,0,0,'LAST_HIT','false'),
(21399,21399,'Soldier Scarab',0,'',0,'LineageMonster2.scarab',14.00,22.00,78,'male','L2Monster',40,4428,1784,67.15,3.09,40,43,30,21,20,10,7736,846,1715,555,1069,451,278,350,333,0,0,0,0,49,198,0,0,'LAST_HIT','false'),
(21400,21400,'Hexa Beetle',0,'',0,'LineageMonster2.tera_beetle',25.00,54.50,78,'male','L2Monster',40,4490,1821,67.15,3.09,40,43,30,21,20,10,6611,732,1765,566,1107,459,278,350,333,0,0,0,0,49,159,0,0,'LAST_HIT','false'),
(21401,21401,'Hexa Beetle',0,'',0,'LineageMonster2.tera_beetle',25.00,54.50,78,'male','L2Monster',40,4490,1821,53.72,3.09,40,43,30,21,20,10,7271,806,1941,514,1107,459,278,350,333,0,0,0,0,45,145,0,0,'LAST_HIT','false'),
(21402,21402,'Katraxis',0,'',0,'LineageMonster2.scorpion_20_sm',24.00,52.80,78,'male','L2Monster',40,4490,1821,53.72,3.09,40,43,30,21,20,10,7503,831,1544,566,1107,459,317,300,333,0,0,0,0,37,165,0,0,'LAST_HIT','false'),
(21403,21403,'Katraxis',0,'',0,'LineageMonster2.scorpion_20_sm',24.00,52.80,78,'male','L2Monster',40,4490,1821,67.15,3.09,40,43,30,21,20,10,6928,767,1544,566,1107,459,317,300,333,0,0,0,0,40,181,0,0,'LAST_HIT','false'),
(21404,21404,'Tera Beetle',0,'',0,'LineageMonster2.tera_beetle',25.00,54.50,78,'male','L2Monster',40,4550,1859,53.72,3.09,40,43,30,21,20,10,14906,1673,1649,634,1144,468,278,0,333,0,0,0,0,49,203,0,0,'LAST_HIT','false'),
(21405,21405,'Tera Beetle',0,'',0,'LineageMonster2.tera_beetle',25.00,54.50,78,'male','L2Monster',40,4550,1859,53.72,3.09,40,43,30,21,20,10,7146,802,1814,576,1144,468,278,0,333,0,0,0,0,45,185,0,0,'LAST_HIT','false'),
(21406,21406,'Knight of Empire',0,'',0,'LineageMonster.skeleton_knight',10.00,25.00,78,'male','L2Monster',40,4550,1859,67.15,3.09,40,43,30,21,20,10,8454,949,1814,576,1144,468,278,300,333,150,103,0,0,40,145,1,0,'LAST_HIT','false'),
(21407,21407,'Knight of Empire',0,'',0,'LineageMonster.skeleton_knight',10.00,25.00,78,'male','L2Monster',40,4550,1859,40.29,3.09,40,43,30,21,20,10,9017,1012,1814,576,1144,468,278,300,333,150,103,0,0,40,145,1,0,'LAST_HIT','false'),
(21408,21408,'Royal Guard of Empire',0,'',0,'LineageMonster.skeleton_pikeman',10.00,28.00,78,'male','L2Monster',40,4550,1859,67.15,3.09,40,43,30,21,20,10,7358,825,1996,524,1144,468,278,0,333,304,0,0,0,55,209,1,0,'LAST_HIT','false'),
(21409,21409,'Royal Guard of Empire',0,'',0,'LineageMonster.skeleton_pikeman',10.00,28.00,78,'male','L2Monster',40,4550,1859,80.58,3.09,40,43,30,21,20,10,6857,769,1499,698,1144,468,278,0,333,304,0,0,0,55,209,1,0,'LAST_HIT','false'),
(21410,21410,'Guardian Scarab',0,'',0,'LineageMonster2.scarab_20_bi',17.00,26.50,78,'male','L2Monster',40,4608,1896,67.15,3.09,40,43,30,21,20,10,7602,863,1863,587,1182,477,278,0,333,0,0,0,0,45,195,0,0,'LAST_HIT','false'),
(21411,21411,'Guardian Scarab',0,'',0,'LineageMonster2.scarab_20_bi',17.00,26.50,78,'male','L2Monster',40,4608,1896,53.72,3.09,40,43,30,21,20,10,7584,861,1863,587,1182,477,278,0,333,0,0,0,0,45,195,0,0,'LAST_HIT','false'),
(21412,21412,'Ustralith',0,'',0,'LineageMonster2.scorpion',28.00,66.00,78,'male','L2Monster',40,4608,1896,67.15,3.09,40,43,30,21,20,10,9682,1099,1347,710,1182,477,317,150,333,0,0,0,0,37,130,0,0,'LAST_HIT','false'),
(21413,21413,'Ustralith',0,'',0,'LineageMonster2.scorpion',28.00,66.00,78,'male','L2Monster',40,4608,1896,67.15,3.09,40,43,30,21,20,10,7445,845,1793,534,1182,477,317,150,333,0,0,0,0,40,143,0,0,'LAST_HIT','false'),
(21414,21414,'Assassin of Empire',0,'',0,'LineageMonster.skeleton_royal_guard',11.00,28.50,78,'male','L2Monster',40,4608,1896,67.15,3.09,40,43,30,21,20,10,7236,821,1973,485,1182,477,317,0,333,946,945,0,0,88,192,1,0,'LAST_HIT','false'),
(21415,21415,'Assassin of Empire',0,'',0,'LineageMonster.skeleton_royal_guard',11.00,28.50,78,'male','L2Monster',40,4608,1896,67.15,3.09,40,43,30,21,20,10,7299,828,1482,646,1182,477,317,0,333,946,945,0,0,88,192,1,0,'LAST_HIT','false'),
(21416,21416,'Imperial Commander',0,'',0,'LineageMonster2.imperial_warlord_zombie',7.00,30.00,78,'male','L2Monster',40,4608,1896,67.15,3.09,40,43,30,21,20,10,8637,980,1863,587,1182,477,278,350,333,134,6721,0,0,39,140,1,0,'LAST_HIT','false'),
(21417,21417,'Imperial Commander',0,'',0,'LineageMonster2.imperial_warlord_zombie',7.00,30.00,78,'male','L2Monster',40,4608,1896,80.58,3.09,40,43,30,21,20,10,12557,1425,2255,485,1182,477,278,350,333,134,6721,0,0,39,140,1,0,'LAST_HIT','false'),
(21418,21418,'Imperial Royal Guard',0,'',0,'LineageMonster.death_knight',12.00,31.00,78,'male','L2Monster',40,4663,1934,53.72,3.09,40,43,30,21,20,10,8030,922,1912,598,1220,485,278,0,333,142,0,0,0,29,176,1,0,'LAST_HIT','false'),
(21419,21419,'Imperial Royal Guard',0,'',0,'LineageMonster.death_knight',12.00,31.00,78,'male','L2Monster',40,4663,1934,53.72,3.09,40,43,30,21,20,10,8173,939,1912,598,1220,485,278,0,333,142,0,0,0,29,176,1,0,'LAST_HIT','false'),
(21420,21420,'Ashuras',0,'',0,'LineageMonster2.ashuras',13.00,37.50,78,'male','L2Monster',40,4663,1934,67.15,3.09,40,43,30,21,20,10,7704,885,1912,598,1220,485,278,150,333,0,0,0,0,45,220,0,0,'LAST_HIT','false'),
(21421,21421,'Ashuras',0,'',0,'LineageMonster2.ashuras',13.00,37.50,78,'male','L2Monster',40,4663,1934,67.15,3.09,40,43,30,21,20,10,7231,830,1912,598,1220,485,278,150,333,0,0,0,0,45,220,0,0,'LAST_HIT','false'),
(21422,21422,'Dancer of Empire',0,'',0,'LineageMonster.banshee',9.00,23.00,78,'female','L2Monster',40,4663,1934,80.58,3.09,40,43,30,21,20,10,6913,794,2103,543,1220,485,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(21423,21423,'Dancer of Empire',0,'',0,'LineageMonster.banshee',9.00,23.00,78,'female','L2Monster',40,4663,1934,80.58,3.09,40,43,30,21,20,10,7328,842,2103,543,1220,485,278,150,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(21424,21424,'Ashkenas',0,'',0,'LineageMonster2.ashuras',13.00,37.50,78,'male','L2Monster',40,4663,1934,80.58,3.09,40,43,30,21,20,10,9288,1067,2544,449,1220,485,278,350,333,0,0,0,0,45,209,0,0,'LAST_HIT','false'),
(21425,21425,'Ashkenas',0,'',0,'LineageMonster2.ashuras',13.00,37.50,78,'male','L2Monster',40,4663,1934,80.58,3.09,40,43,30,21,20,10,9444,1085,2544,449,1220,485,278,350,333,0,0,0,0,45,209,0,0,'LAST_HIT','false'),
(21426,21426,'Abraxion',0,'',0,'LineageMonster2.erinyes',21.00,50.00,78,'male','L2Monster',40,4716,1972,53.72,3.09,40,43,30,21,20,10,16312,1896,2722,608,1258,494,200,350,333,0,0,0,0,34,143,0,0,'LAST_HIT','false'),
(21427,21427,'Abraxion',0,'',0,'LineageMonster2.erinyes',21.00,50.00,78,'male','L2Monster',40,4716,1972,53.72,3.09,40,43,30,21,20,10,9587,1114,2722,608,1258,494,200,350,333,0,0,0,0,34,143,0,0,'LAST_HIT','false'),
(21428,21428,'Hasturan',0,'',0,'LineageMonster2.erinyes',21.00,50.00,78,'male','L2Monster',40,4716,1972,67.15,3.09,40,43,30,21,20,10,7324,851,2994,553,1258,494,200,150,333,0,0,0,0,34,165,0,0,'LAST_HIT','false'),
(21429,21429,'Hasturan',0,'',0,'LineageMonster2.erinyes',21.00,50.00,78,'male','L2Monster',40,4716,1972,67.15,3.09,40,43,30,21,20,10,7647,889,2474,669,1258,494,200,150,333,0,0,0,0,34,165,0,0,'LAST_HIT','false'),
(21430,21430,'Arimanes',0,'',0,'LineageMonster2.ahrimanes',14.00,57.75,78,'male','L2Monster',40,4716,1972,80.58,3.09,40,43,30,21,20,10,8801,1023,3293,503,1258,494,200,0,333,6722,0,0,0,38,231,0,0,'LAST_HIT','false'),
(21431,21431,'Arimanes',0,'',0,'LineageMonster2.ahrimanes',14.00,57.75,78,'male','L2Monster',40,4716,1972,80.58,3.09,40,43,30,21,20,10,7507,872,2249,736,1258,494,200,0,333,6722,0,0,0,38,231,0,0,'LAST_HIT','false'),
(21432,21432,'Chakram Beetle',0,'',0,'LineageMonster2.tera_beetle',19.00,54.50,78,'male','L2Monster',40,4550,1859,80.58,3.09,40,43,30,21,20,10,12155,1364,1814,576,1144,468,278,0,333,0,0,0,0,49,187,0,0,'LAST_HIT','false'),
(21433,21433,'Jamadar Beetle',0,'',0,'LineageMonster2.tera_beetle_20_sm',20.00,43.60,78,'male','L2Monster',40,4490,1821,80.58,3.09,40,43,30,21,20,10,11788,1306,1765,566,1107,459,278,0,333,0,0,0,0,49,192,0,0,'LAST_HIT','false'),
(21434,21434,'Seer of Blood',0,'',0,'LineageMonster2.erinyes',21.00,50.00,78,'male','L2Monster',40,4663,1934,80.58,3.09,40,43,30,21,20,10,23561,2707,2655,598,1220,485,200,0,333,0,0,0,0,34,165,0,0,'LAST_HIT','false'),
(21435,21435,'Guide of Offering',0,'',0,'LineageMonster2.imperial_warlord_zombie',7.00,30.00,78,'male','L2Minion',40,4550,1859,80.58,3.09,40,43,30,21,20,10,11922,1338,1814,576,1144,468,278,0,333,134,6721,0,0,42,165,1,0,'LAST_HIT','false'),
(21436,21436,'Leader of Offering',0,'',0,'LineageMonster2.imperial_warlord_zombie',7.00,30.00,78,'male','L2Minion',40,4550,1859,80.58,3.09,40,43,30,21,20,10,12367,1388,1814,576,1144,468,278,0,333,134,6721,0,0,42,165,1,0,'LAST_HIT','false'),
(21437,21437,'Offering Bug',0,'',0,'LineageMonster2.scarab',14.00,22.00,78,'male','L2Monster',40,4490,1821,53.72,3.09,40,43,30,21,20,10,7489,830,1765,566,1107,459,278,0,333,0,0,0,0,49,198,0,0,'LAST_HIT','false'),
(21438,21438,'Heathen Warrior',0,'',0,'LineageMonster.skeleton_royal_guard',11.00,28.50,65,'male','L2Monster',40,3465,1319,2.96,2.78,40,43,30,21,20,10,5966,556,1140,346,619,340,317,150,333,946,945,0,0,88,192,1,0,'LAST_HIT','false'),
(21439,21439,'Heathen Executed',0,'',0,'LineageMonster.hungry_spirit',30.00,40.00,66,'male','L2Monster',40,3546,1353,2.96,2.78,40,43,30,21,20,10,6151,580,1358,301,649,348,278,150,333,0,0,0,0,16,192,1,0,'LAST_HIT','false'),
(21440,21440,'Heathen Archer',0,'',0,'LineageMonster.skeleton_archer',11.00,27.00,67,'male','L2Monster',500,3626,1388,2.96,2.78,40,43,30,21,20,10,6735,640,3145,308,681,356,249,0,333,284,0,0,0,44,170,1,0,'LAST_HIT','false'),
(21441,21441,'Heathen Grunt',0,'',0,'LineageMonster.skeleton_pikeman',10.00,28.00,68,'male','L2Monster',40,3706,1423,2.96,2.78,40,43,30,21,20,10,6530,632,1473,371,713,365,278,150,333,96,0,0,0,55,187,1,0,'LAST_HIT','false'),
(21442,21442,'Heathen Knight',0,'',0,'LineageMonster.skeleton_knight',10.00,25.00,69,'male','L2Monster',40,3784,1458,2.96,2.78,40,43,30,21,20,10,6723,656,1531,380,746,373,278,150,333,150,103,0,0,44,181,1,0,'LAST_HIT','false'),
(21443,21443,'Raider of Pastureland',0,'',0,'LineageMonster.dark_mahum',13.00,26.00,63,'male','L2Monster',40,3302,1251,11.85,2.78,40,43,30,21,20,10,7006,633,649,530,560,323,317,150,333,153,0,0,0,55,181,0,0,'LAST_HIT','true'),
(21444,21444,'Raider of Pastureland',0,'',0,'LineageMonster.dark_mahum',13.00,26.00,63,'male','L2Monster',40,3302,1251,11.85,2.78,40,43,30,21,20,10,5887,532,741,530,560,323,278,150,333,153,0,0,0,55,181,0,0,'LAST_HIT','true'),
(21445,21445,'Alpen Bandersnatch',0,'',0,'LineageMonster2.bandersnatch',18.00,25.00,64,'male','L2Monster',40,3384,1285,11.85,2.78,40,43,30,21,20,10,6076,556,1302,449,589,331,200,150,333,0,0,0,0,33,187,0,0,'LAST_HIT','true'),
(21446,21446,'Raider of Pastureland',0,'',0,'LineageMonster.dark_mahum',13.00,26.00,64,'male','L2Monster',40,3384,1285,11.85,2.78,40,43,30,21,20,10,7476,684,678,543,589,331,317,150,333,160,0,0,0,55,181,0,0,'LAST_HIT','true'),
(21447,21447,'Raider of Pastureland',0,'',0,'LineageMonster.dark_mahum',13.00,26.00,66,'male','L2Monster',40,3546,1353,11.85,2.78,40,43,30,21,20,10,7689,724,738,570,649,348,317,150,333,229,0,0,0,55,181,0,0,'LAST_HIT','true'),
(21448,21448,'Raider of Pastureland',0,'',0,'LineageMonster.dark_mahum',13.00,26.00,66,'male','L2Monster',40,3546,1353,11.85,2.78,40,43,30,21,20,10,6462,608,843,570,649,348,278,150,333,229,0,0,0,55,181,0,0,'LAST_HIT','true'),
(21449,21449,'Raider of Pastureland',0,'',0,'LineageMonster.dark_mahum',13.00,26.00,68,'male','L2Monster',40,3706,1423,11.85,2.78,40,43,30,21,20,10,8440,815,800,598,713,365,317,150,333,234,0,0,0,55,181,0,0,'LAST_HIT','true'),
(21450,21450,'Alpen Grendel',0,'',0,'LineageMonster2.bionic_bear',15.00,39.00,68,'male','L2Monster',40,3706,1423,11.85,2.78,40,43,30,21,20,10,8162,789,1690,449,713,365,200,150,333,0,0,0,0,39,170,0,0,'LAST_HIT','true'),
(21451,21451,'Alpen Kookaburra',0,'',0,'LineageMonster2.baby_ostrich',7.00,15.00,65,'male','L2FeedableBeast',40,3465,1319,5.93,2.78,40,43,30,21,20,10,5530,514,1077,418,619,340,278,0,333,0,0,0,0,14,121,0,0,'LAST_HIT','true'),
(21452,21452,'Alpen Kookaburra',0,'',0,'LineageMonster2.baby_ostrich',7.00,15.00,65,'male','L2FeedableBeast',40,3465,1319,11.85,2.78,40,43,30,21,20,10,7312,679,890,506,619,340,278,0,333,0,0,0,0,14,154,0,0,'LAST_HIT','true'),
(21453,21453,'Alpen Kookaburra',0,'',0,'LineageMonster2.baby_ostrich',7.00,15.00,65,'male','L2FeedableBeast',40,3465,1319,11.85,2.78,40,43,30,21,20,10,6144,571,890,506,619,340,278,0,333,0,0,0,0,14,154,0,0,'LAST_HIT','true'),
(21454,21454,'Alpen Kookaburra',0,'',0,'LineageMonster2.baby_ostrich',7.00,15.00,65,'male','L2FeedableBeast',40,3465,1319,11.85,2.78,40,43,30,21,20,10,7312,679,890,506,619,340,278,0,333,0,0,0,0,14,154,0,0,'LAST_HIT','true'),
(21455,21455,'Alpen Kookaburra',0,'',0,'LineageMonster2.baby_ostrich',7.00,15.00,65,'male','L2FeedableBeast',40,3465,1319,11.85,2.78,40,43,30,21,20,10,6144,571,890,506,619,340,278,0,333,0,0,0,0,14,154,0,0,'LAST_HIT','true'),
(21456,21456,'Alpen Kookaburra',0,'',0,'LineageMonster2.baby_ostrich',7.00,15.00,65,'male','L2FeedableBeast',40,3465,1319,11.85,2.78,40,43,30,21,20,10,7312,679,890,506,619,340,278,0,333,0,0,0,0,14,154,0,0,'LAST_HIT','true'),
(21457,21457,'Alpen Kookaburra',0,'',0,'LineageMonster2.baby_ostrich',7.00,15.00,65,'male','L2FeedableBeast',40,3465,1319,11.85,2.78,40,43,30,21,20,10,6144,571,890,506,619,340,278,0,333,0,0,0,0,14,154,0,0,'LAST_HIT','true'),
(21458,21458,'Alpen Kookaburra',0,'',0,'LineageMonster2.baby_ostrich',7.00,15.00,65,'male','L2FeedableBeast',40,3465,1319,11.85,2.78,40,43,30,21,20,10,7312,679,890,506,619,340,278,0,333,0,0,0,0,14,154,0,0,'LAST_HIT','true'),
(21459,21459,'Alpen Kookaburra',0,'',0,'LineageMonster2.baby_ostrich',7.00,15.00,65,'male','L2FeedableBeast',40,3465,1319,11.85,2.78,40,43,30,21,20,10,6144,571,890,506,619,340,278,0,333,0,0,0,0,14,154,0,0,'LAST_HIT','true'),
(21460,21460,'Alpen Kookaburra',0,'',0,'LineageMonster2.youth_ostrich',8.00,26.40,65,'male','L2FeedableBeast',40,3465,1319,23.70,2.78,40,43,30,21,20,10,7661,711,1077,418,619,340,278,150,333,0,0,0,0,25,209,0,0,'LAST_HIT','false'),
(21461,21461,'Alpen Kookaburra',0,'',0,'LineageMonster2.youth_ostrich',8.00,26.40,65,'male','L2FeedableBeast',40,3465,1319,23.70,2.78,40,43,30,21,20,10,7963,740,1077,418,619,340,278,150,333,0,0,0,0,25,209,0,0,'LAST_HIT','false'),
(21462,21462,'Alpen Kookaburra',0,'',0,'LineageMonster2.youth_ostrich',8.00,26.40,65,'male','L2FeedableBeast',40,3465,1319,23.70,2.78,40,43,30,21,20,10,7661,711,1077,418,619,340,278,150,333,0,0,0,0,25,209,0,0,'LAST_HIT','false'),
(21463,21463,'Alpen Kookaburra',0,'',0,'LineageMonster2.youth_ostrich',8.00,26.40,65,'male','L2FeedableBeast',40,3465,1319,23.70,2.78,40,43,30,21,20,10,7367,684,1077,418,619,340,278,150,333,0,0,0,0,25,209,0,0,'LAST_HIT','false'),
(21464,21464,'Alpen Kookaburra',0,'',0,'LineageMonster2.youth_ostrich',8.00,26.40,65,'male','L2FeedableBeast',40,3465,1319,23.70,2.78,40,43,30,21,20,10,7661,711,1077,418,619,340,278,150,333,0,0,0,0,25,209,0,0,'LAST_HIT','false'),
(21465,21465,'Alpen Kookaburra',0,'',0,'LineageMonster2.youth_ostrich',8.00,26.40,65,'male','L2FeedableBeast',40,3465,1319,23.70,2.78,40,43,30,21,20,10,7963,740,1077,418,619,340,278,150,333,0,0,0,0,25,209,0,0,'LAST_HIT','false'),
(21466,21466,'Alpen Kookaburra',0,'',0,'LineageMonster2.youth_ostrich',8.00,26.40,65,'male','L2FeedableBeast',40,3465,1319,23.70,2.78,40,43,30,21,20,10,7661,711,1077,418,619,340,278,150,333,0,0,0,0,25,209,0,0,'LAST_HIT','false'),
(21467,21467,'Alpen Kookaburra',0,'',0,'LineageMonster2.youth_ostrich',8.00,26.40,65,'male','L2FeedableBeast',40,3465,1319,23.70,2.78,40,43,30,21,20,10,7367,684,1077,418,619,340,278,150,333,0,0,0,0,25,209,0,0,'LAST_HIT','false'),
(21468,21468,'Alpen Kookaburra',0,'',0,'LineageMonster2.rough_ostrich',10.00,33.00,65,'male','L2FeedableBeast',40,3465,1319,47.40,2.78,40,43,30,21,20,10,6457,600,1433,314,619,340,278,150,333,0,0,0,0,25,231,0,0,'LAST_HIT','false'),
(21469,21469,'Alpen Kookaburra',0,'',0,'LineageMonster2.rough_ostrich',10.00,33.00,65,'male','L2FeedableBeast',40,3465,1319,47.40,2.78,40,43,30,21,20,10,6159,572,1433,314,619,340,278,150,333,0,0,0,0,25,231,0,0,'LAST_HIT','false'),
(21470,21470,'Alpen Buffalo',0,'',0,'LineageMonster2.baby_buffalo',12.00,15.00,67,'male','L2FeedableBeast',40,3626,1388,5.93,2.78,40,43,30,21,20,10,5875,560,1169,439,681,356,278,0,333,0,0,0,0,33,121,0,0,'LAST_HIT','true'),
(21471,21471,'Alpen Buffalo',0,'',0,'LineageMonster2.baby_buffalo',12.00,15.00,67,'male','L2FeedableBeast',40,3626,1388,11.85,2.78,40,43,30,21,20,10,7769,740,966,531,681,356,278,0,333,0,0,0,0,33,143,0,0,'LAST_HIT','true'),
(21472,21472,'Alpen Buffalo',0,'',0,'LineageMonster2.baby_buffalo',12.00,15.00,67,'male','L2FeedableBeast',40,3626,1388,11.85,2.78,40,43,30,21,20,10,6528,622,966,531,681,356,278,0,333,0,0,0,0,33,143,0,0,'LAST_HIT','true'),
(21473,21473,'Alpen Buffalo',0,'',0,'LineageMonster2.baby_buffalo',12.00,15.00,67,'male','L2FeedableBeast',40,3626,1388,11.85,2.78,40,43,30,21,20,10,7769,740,966,531,681,356,278,0,333,0,0,0,0,33,143,0,0,'LAST_HIT','true'),
(21474,21474,'Alpen Buffalo',0,'',0,'LineageMonster2.baby_buffalo',12.00,15.00,67,'male','L2FeedableBeast',40,3626,1388,11.85,2.78,40,43,30,21,20,10,6528,622,966,531,681,356,278,0,333,0,0,0,0,33,143,0,0,'LAST_HIT','true'),
(21475,21475,'Alpen Buffalo',0,'',0,'LineageMonster2.baby_buffalo',12.00,15.00,67,'male','L2FeedableBeast',40,3626,1388,11.85,2.78,40,43,30,21,20,10,7769,740,966,531,681,356,278,0,333,0,0,0,0,33,143,0,0,'LAST_HIT','true'),
(21476,21476,'Alpen Buffalo',0,'',0,'LineageMonster2.baby_buffalo',12.00,15.00,67,'male','L2FeedableBeast',40,3626,1388,11.85,2.78,40,43,30,21,20,10,6528,622,966,531,681,356,278,0,333,0,0,0,0,33,143,0,0,'LAST_HIT','true'),
(21477,21477,'Alpen Buffalo',0,'',0,'LineageMonster2.baby_buffalo',12.00,15.00,67,'male','L2FeedableBeast',40,3626,1388,11.85,2.78,40,43,30,21,20,10,7769,740,966,531,681,356,278,0,333,0,0,0,0,33,143,0,0,'LAST_HIT','true'),
(21478,21478,'Alpen Buffalo',0,'',0,'LineageMonster2.baby_buffalo',12.00,15.00,67,'male','L2FeedableBeast',40,3626,1388,11.85,2.78,40,43,30,21,20,10,6528,622,966,531,681,356,278,0,333,0,0,0,0,33,143,0,0,'LAST_HIT','true'),
(21479,21479,'Alpen Buffalo',0,'',0,'LineageMonster2.youth_buffalo',16.00,25.20,67,'male','L2FeedableBeast',40,3626,1388,23.70,2.78,40,43,30,21,20,10,8139,775,1624,439,681,356,200,150,333,0,0,0,0,22,187,0,0,'LAST_HIT','false'),
(21480,21480,'Alpen Buffalo',0,'',0,'LineageMonster2.youth_buffalo',16.00,25.20,67,'male','L2FeedableBeast',40,3626,1388,23.70,2.78,40,43,30,21,20,10,8460,806,1624,439,681,356,200,150,333,0,0,0,0,22,187,0,0,'LAST_HIT','false'),
(21481,21481,'Alpen Buffalo',0,'',0,'LineageMonster2.youth_buffalo',16.00,25.20,67,'male','L2FeedableBeast',40,3626,1388,23.70,2.78,40,43,30,21,20,10,8139,775,1624,439,681,356,200,150,333,0,0,0,0,22,187,0,0,'LAST_HIT','false'),
(21482,21482,'Alpen Buffalo',0,'',0,'LineageMonster2.youth_buffalo',16.00,25.20,67,'male','L2FeedableBeast',40,3626,1388,23.70,2.78,40,43,30,21,20,10,7828,745,1624,439,681,356,200,150,333,0,0,0,0,22,187,0,0,'LAST_HIT','false'),
(21483,21483,'Alpen Buffalo',0,'',0,'LineageMonster2.youth_buffalo',16.00,25.20,67,'male','L2FeedableBeast',40,3626,1388,23.70,2.78,40,43,30,21,20,10,8139,775,1624,439,681,356,200,150,333,0,0,0,0,22,187,0,0,'LAST_HIT','false'),
(21484,21484,'Alpen Buffalo',0,'',0,'LineageMonster2.youth_buffalo',16.00,25.20,67,'male','L2FeedableBeast',40,3626,1388,23.70,2.78,40,43,30,21,20,10,8460,806,1624,439,681,356,200,150,333,0,0,0,0,22,187,0,0,'LAST_HIT','false'),
(21485,21485,'Alpen Buffalo',0,'',0,'LineageMonster2.youth_buffalo',16.00,25.20,67,'male','L2FeedableBeast',40,3626,1388,23.70,2.78,40,43,30,21,20,10,8139,775,1624,439,681,356,200,150,333,0,0,0,0,22,187,0,0,'LAST_HIT','false'),
(21486,21486,'Alpen Buffalo',0,'',0,'LineageMonster2.youth_buffalo',16.00,25.20,67,'male','L2FeedableBeast',40,3626,1388,23.70,2.78,40,43,30,21,20,10,7828,745,1624,439,681,356,200,150,333,0,0,0,0,22,187,0,0,'LAST_HIT','false'),
(21487,21487,'Alpen Buffalo',0,'',0,'LineageMonster2.buffalo',22.00,31.00,67,'male','L2FeedableBeast',40,3626,1388,47.40,2.78,40,43,30,21,20,10,6861,653,2162,329,681,356,200,150,333,0,0,0,0,22,187,0,0,'LAST_HIT','false'),
(21488,21488,'Alpen Buffalo',0,'',0,'LineageMonster2.buffalo',22.00,31.00,67,'male','L2FeedableBeast',40,3626,1388,47.40,2.78,40,43,30,21,20,10,6544,623,2162,329,681,356,200,150,333,0,0,0,0,22,187,0,0,'LAST_HIT','false'),
(21489,21489,'Alpen Cougar',0,'',0,'LineageMonster2.baby_tiger',11.00,15.70,69,'male','L2FeedableBeast',40,3784,1458,5.93,2.78,40,43,30,21,20,10,6231,610,1265,460,746,373,278,0,333,0,0,0,0,30,121,0,0,'LAST_HIT','true'),
(21490,21490,'Alpen Cougar',0,'',0,'LineageMonster2.baby_tiger',11.00,15.70,69,'male','L2FeedableBeast',40,3784,1458,11.85,2.78,40,43,30,21,20,10,8240,806,1045,556,746,373,278,0,333,0,0,0,0,30,143,0,0,'LAST_HIT','true'),
(21491,21491,'Alpen Cougar',0,'',0,'LineageMonster2.baby_tiger',11.00,15.70,69,'male','L2FeedableBeast',40,3784,1458,11.85,2.78,40,43,30,21,20,10,6924,678,1045,556,746,373,278,0,333,0,0,0,0,30,143,0,0,'LAST_HIT','true'),
(21492,21492,'Alpen Cougar',0,'',0,'LineageMonster2.baby_tiger',11.00,15.70,69,'male','L2FeedableBeast',40,3784,1458,11.85,2.78,40,43,30,21,20,10,8240,806,1045,556,746,373,278,0,333,0,0,0,0,30,143,0,0,'LAST_HIT','true'),
(21493,21493,'Alpen Cougar',0,'',0,'LineageMonster2.baby_tiger',11.00,15.70,69,'male','L2FeedableBeast',40,3784,1458,11.85,2.78,40,43,30,21,20,10,6924,678,1045,556,746,373,278,0,333,0,0,0,0,30,143,0,0,'LAST_HIT','true'),
(21494,21494,'Alpen Cougar',0,'',0,'LineageMonster2.baby_tiger',11.00,15.70,69,'male','L2FeedableBeast',40,3784,1458,11.85,2.78,40,43,30,21,20,10,8240,806,1045,556,746,373,278,0,333,0,0,0,0,30,143,0,0,'LAST_HIT','true'),
(21495,21495,'Alpen Cougar',0,'',0,'LineageMonster2.baby_tiger',11.00,15.70,69,'male','L2FeedableBeast',40,3784,1458,11.85,2.78,40,43,30,21,20,10,6924,678,1045,556,746,373,278,0,333,0,0,0,0,30,143,0,0,'LAST_HIT','true'),
(21496,21496,'Alpen Cougar',0,'',0,'LineageMonster2.baby_tiger',11.00,15.70,69,'male','L2FeedableBeast',40,3784,1458,11.85,2.78,40,43,30,21,20,10,8240,806,1045,556,746,373,278,0,333,0,0,0,0,30,143,0,0,'LAST_HIT','true'),
(21497,21497,'Alpen Cougar',0,'',0,'LineageMonster2.baby_tiger',11.00,15.70,69,'male','L2FeedableBeast',40,3784,1458,11.85,2.78,40,43,30,21,20,10,6924,678,1045,556,746,373,278,0,333,0,0,0,0,30,143,0,0,'LAST_HIT','true'),
(21498,21498,'Alpen Cougar',0,'',0,'LineageMonster2.youth_tiger',16.00,17.20,69,'male','L2FeedableBeast',40,3784,1458,23.70,2.78,40,43,30,21,20,10,8632,844,1265,460,746,373,278,150,333,0,0,0,0,66,192,0,0,'LAST_HIT','false'),
(21499,21499,'Alpen Cougar',0,'',0,'LineageMonster2.youth_tiger',16.00,17.20,69,'male','L2FeedableBeast',40,3784,1458,23.70,2.78,40,43,30,21,20,10,8973,878,1265,460,746,373,278,150,333,0,0,0,0,66,192,0,0,'LAST_HIT','false'),
(21500,21500,'Alpen Cougar',0,'',0,'LineageMonster2.youth_tiger',16.00,17.20,69,'male','L2FeedableBeast',40,3784,1458,23.70,2.78,40,43,30,21,20,10,8632,844,1265,460,746,373,278,150,333,0,0,0,0,66,192,0,0,'LAST_HIT','false'),
(21501,21501,'Alpen Cougar',0,'',0,'LineageMonster2.youth_tiger',16.00,17.20,69,'male','L2FeedableBeast',40,3784,1458,23.70,2.78,40,43,30,21,20,10,8302,812,1265,460,746,373,278,150,333,0,0,0,0,66,192,0,0,'LAST_HIT','false'),
(21502,21502,'Alpen Cougar',0,'',0,'LineageMonster2.youth_tiger',16.00,17.20,69,'male','L2FeedableBeast',40,3784,1458,23.70,2.78,40,43,30,21,20,10,8632,844,1265,460,746,373,278,150,333,0,0,0,0,66,192,0,0,'LAST_HIT','false'),
(21503,21503,'Alpen Cougar',0,'',0,'LineageMonster2.youth_tiger',16.00,17.20,69,'male','L2FeedableBeast',40,3784,1458,23.70,2.78,40,43,30,21,20,10,8973,878,1265,460,746,373,278,150,333,0,0,0,0,66,192,0,0,'LAST_HIT','false'),
(21504,21504,'Alpen Cougar',0,'',0,'LineageMonster2.youth_tiger',16.00,17.20,69,'male','L2FeedableBeast',40,3784,1458,23.70,2.78,40,43,30,21,20,10,8632,844,1265,460,746,373,278,150,333,0,0,0,0,66,192,0,0,'LAST_HIT','false'),
(21505,21505,'Alpen Cougar',0,'',0,'LineageMonster2.youth_tiger',16.00,17.20,69,'male','L2FeedableBeast',40,3784,1458,23.70,2.78,40,43,30,21,20,10,8302,812,1265,460,746,373,278,150,333,0,0,0,0,66,192,0,0,'LAST_HIT','false'),
(21506,21506,'Alpen Cougar',0,'',0,'LineageMonster.saber_toothed_tiger',34.00,28.00,69,'male','L2FeedableBeast',40,3784,1458,47.40,2.78,40,43,30,21,20,10,7276,712,1684,345,746,373,278,150,333,0,0,0,0,66,220,0,0,'LAST_HIT','false'),
(21507,21507,'Alpen Cougar',0,'',0,'LineageMonster.saber_toothed_tiger',34.00,28.00,69,'male','L2FeedableBeast',40,3784,1458,47.40,2.78,40,43,30,21,20,10,6941,679,1684,345,746,373,278,150,333,0,0,0,0,66,220,0,0,'LAST_HIT','false'),
(21508,21508,'Splinter Stakato',0,'',0,'LineageMonster.blade_stakato',15.00,36.00,66,'male','L2Monster',40,3546,1353,11.85,2.78,40,43,30,21,20,10,8452,796,1123,364,649,348,278,150,333,235,0,0,0,27,192,0,0,'LAST_HIT','false'),
(21509,21509,'Splinter Stakato Worker',0,'',0,'LineageMonster.blade_stakato_worker',13.00,40.00,67,'male','L2Monster',40,3626,1388,11.85,2.78,40,43,30,21,20,10,7445,709,1286,339,681,356,278,150,333,0,0,0,0,27,198,0,0,'LAST_HIT','false'),
(21510,21510,'Splinter Stakato Soldier',0,'',0,'LineageMonster.blade_stakato_soldier',15.00,38.00,68,'male','L2Monster',40,3706,1423,11.85,2.78,40,43,30,21,20,10,8972,867,1473,371,713,365,278,150,333,148,0,0,0,27,198,0,0,'LAST_HIT','false'),
(21511,21511,'Splinter Stakato Drone',0,'',0,'LineageMonster.blade_stakato_drone',15.00,39.00,69,'male','L2Monster',40,3784,1458,11.85,2.78,40,43,30,21,20,10,9944,973,1265,460,746,373,278,150,333,132,0,0,0,27,203,0,0,'LAST_HIT','false'),
(21512,21512,'Splinter Stakato Drone',0,'',0,'LineageMonster.blade_stakato_drone',15.00,39.00,70,'male','L2Monster',40,3862,1493,11.85,2.78,40,43,30,21,20,10,12636,1253,1086,569,780,382,278,0,333,132,0,0,0,27,203,0,0,'LAST_HIT','false'),
(21513,21513,'Needle Stakato',0,'',0,'LineageMonster.blade_stakato',15.00,36.00,70,'male','L2Monster',40,3862,1493,11.85,2.78,40,43,30,21,20,10,9507,943,1314,399,780,382,278,150,333,235,0,0,0,27,203,0,0,'LAST_HIT','false'),
(21514,21514,'Needle Stakato Worker',0,'',0,'LineageMonster.blade_stakato_worker',13.00,40.00,71,'male','L2Monster',40,3938,1529,13.43,3.09,40,43,30,21,20,10,8360,839,1499,371,814,390,278,150,333,0,0,0,0,27,209,0,0,'LAST_HIT','false'),
(21515,21515,'Needle Stakato Soldier',0,'',0,'LineageMonster.blade_stakato_soldier',15.00,38.00,72,'male','L2Monster',40,4013,1565,13.43,3.09,40,43,30,21,20,10,10059,1022,1710,406,849,399,278,150,333,148,0,0,0,27,209,0,0,'LAST_HIT','false'),
(21516,21516,'Needle Stakato Drone',0,'',0,'LineageMonster.blade_stakato_drone',15.00,39.00,73,'male','L2Monster',40,4086,1601,13.43,3.09,40,43,30,21,20,10,10340,1064,1463,502,885,407,278,150,333,132,0,0,0,27,214,0,0,'LAST_HIT','false'),
(21517,21517,'Needle Stakato Drone',0,'',0,'LineageMonster.blade_stakato_drone',15.00,39.00,74,'male','L2Monster',40,4158,1637,13.43,3.09,40,43,30,21,20,10,14121,1472,1250,620,921,416,278,0,333,132,0,0,0,27,214,0,0,'LAST_HIT','false'),
(21518,21518,'Frenzy Stakato Soldier',0,'',0,'LineageMonster.blade_stakato_soldier',15.00,38.00,68,'male','L2Monster',40,3706,1423,11.85,2.78,40,43,30,21,20,10,8002,773,1417,337,713,365,317,0,333,235,0,0,0,27,203,0,0,'LAST_HIT','false'),
(21519,21519,'Frenzy Stakato Drone',0,'',0,'LineageMonster.blade_stakato_drone',15.00,39.00,72,'male','L2Monster',40,4013,1565,13.43,3.09,40,43,30,21,20,10,8972,912,1645,369,849,399,317,0,333,235,0,0,0,27,214,0,0,'LAST_HIT','false'),
(21520,21520,'Eye of Splendor',0,'',0,'LineageMonster.kel_mahum',13.00,26.00,60,'male','L2Monster',40,3054,1150,10.27,2.45,40,43,30,21,20,10,7466,648,860,368,478,299,278,0,366,326,0,0,0,50,160,0,0,'LAST_HIT','true'),
(21521,21521,'Claws of Splendor',0,'',0,'LineageMonster.kel_mahum_warrior',13.00,28.00,60,'male','L2Monster',40,3054,1150,10.27,2.45,40,43,30,21,20,10,7340,637,711,446,478,299,278,0,366,326,0,0,0,50,160,0,0,'LAST_HIT','true'),
(21522,21522,'Claws of Splendor',0,'',0,'LineageMonster.dark_fencer',7.00,13.00,60,'male','L2Monster',40,3054,1150,10.27,2.45,40,43,30,21,20,10,8748,759,1041,259,478,299,278,0,333,0,0,0,0,27,170,0,0,'LAST_HIT','true'),
(21523,21523,'Flash of Splendor',0,'',0,'LineageMonster.kel_mahum_witch_doctor',13.00,25.00,61,'male','L2Monster',40,3137,1184,11.85,2.78,40,43,30,21,20,10,7529,663,901,378,505,307,278,150,366,326,0,0,0,50,150,0,0,'LAST_HIT','true'),
(21524,21524,'Blade of Splendor',0,'',0,'LineageMonster.kel_mahum',13.00,26.00,61,'male','L2Monster',40,3137,1184,11.85,2.78,40,43,30,21,20,10,8028,707,1200,284,505,307,278,0,333,242,0,0,0,50,165,0,0,'LAST_HIT','true'),
(21525,21525,'Blade of Splendor',0,'',0,'LineageMonster.kel_mahum',13.00,26.00,61,'male','L2Monster',40,3137,1184,11.85,2.78,40,43,30,21,20,10,8028,707,901,378,505,307,278,0,333,242,0,0,0,50,165,0,0,'LAST_HIT','true'),
(21526,21526,'Wisdom of Splendor',0,'',0,'LineageMonster.kel_mahum_warrior',13.00,28.00,62,'male','L2Monster',40,3219,1217,11.85,2.78,40,43,30,21,20,10,9220,822,944,388,532,315,278,150,366,193,0,0,0,50,160,0,0,'LAST_HIT','true'),
(21527,21527,'Anger of Splendor',0,'',0,'LineageMonster.kel_mahum_champion',13.00,32.00,63,'male','L2Monster',40,3302,1251,11.85,2.78,40,43,30,21,20,10,8132,734,987,398,560,323,278,0,476,193,0,0,0,50,150,0,0,'LAST_HIT','true'),
(21528,21528,'Anger of Splendor',0,'',0,'LineageMonster.dark_fencer',7.00,13.00,63,'male','L2Monster',40,3302,1251,11.85,2.78,40,43,30,21,20,10,9645,871,987,398,560,323,278,0,333,0,0,0,0,27,170,0,0,'LAST_HIT','true'),
(21529,21529,'Soul of Splendor',0,'',0,'LineageMonster.kel_mahum_witch_doctor',13.00,25.00,63,'male','L2Monster',40,3302,1251,11.85,2.78,40,43,30,21,20,10,7377,666,987,398,560,323,278,150,366,193,0,0,0,50,160,0,0,'LAST_HIT','true'),
(21530,21530,'Victory of Splendor',0,'',0,'LineageMonster.kel_mahum',13.00,26.00,64,'male','L2Monster',40,3384,1285,11.85,2.78,40,43,30,21,20,10,8006,733,1031,408,589,331,278,0,366,196,0,0,0,50,160,0,0,'LAST_HIT','true'),
(21531,21531,'Punishment of Splendor',0,'',0,'LineageMonster.kel_mahum_warrior',13.00,28.00,64,'male','L2Monster',40,3384,1285,11.85,2.78,40,43,30,21,20,10,8837,809,1373,306,589,331,278,0,333,242,0,0,0,50,165,0,0,'LAST_HIT','true'),
(21532,21532,'Shout of Splendor',0,'',0,'LineageMonster.kel_mahum_champion',13.00,32.00,65,'male','L2Monster',40,3465,1319,11.85,2.78,40,43,30,21,20,10,9456,879,1077,418,619,340,278,150,476,196,0,0,0,50,150,0,0,'LAST_HIT','true'),
(21533,21533,'Alliance of Splendor',0,'',0,'LineageMonster.kel_mahum_witch_doctor',13.00,25.00,65,'male','L2Monster',40,3465,1319,11.85,2.78,40,43,30,21,20,10,7767,722,890,430,619,340,278,0,366,196,0,0,0,50,160,0,0,'LAST_HIT','true'),
(21534,21534,'Alliance of Splendor',0,'',0,'LineageMonster.dark_fencer',7.00,13.00,65,'male','L2Monster',40,3465,1319,11.85,2.78,40,43,30,21,20,10,10267,954,1303,346,619,340,278,0,333,0,0,0,0,25,155,0,0,'LAST_HIT','true'),
(21535,21535,'Signet of Splendor',0,'',0,'LineageMonster.kel_mahum_warrior',13.00,28.00,66,'male','L2Monster',40,3546,1353,11.85,2.78,40,43,30,21,20,10,9331,878,1123,428,649,348,278,150,333,189,0,0,0,55,176,0,0,'LAST_HIT','true'),
(21536,21536,'Crown of Splendor',0,'',0,'LineageMonster.kel_mahum_champion',13.00,32.00,66,'male','L2Monster',40,3546,1353,11.85,2.78,40,43,30,21,20,10,9487,893,1123,428,649,348,278,0,333,189,0,0,0,55,181,0,0,'LAST_HIT','true'),
(21537,21537,'Fang of Splendor',0,'',0,'LineageMonster.kel_mahum_witch_doctor',13.00,25.00,67,'male','L2Monster',40,3626,1388,11.85,2.78,40,43,30,21,20,10,8905,848,966,451,681,356,278,0,333,189,0,0,0,55,170,0,0,'LAST_HIT','true'),
(21538,21538,'Fang of Splendor',0,'',0,'LineageMonster.dark_fencer',7.00,13.00,67,'male','L2Monster',40,3626,1388,11.85,2.78,40,43,30,21,20,10,10908,1039,1415,362,681,356,278,0,333,0,0,0,0,27,170,0,0,'LAST_HIT','true'),
(21539,21539,'Wailing of Splendor',0,'',0,'LineageMonster.kel_mahum',13.00,26.00,67,'male','L2Monster',40,3626,1388,11.85,2.78,40,43,30,21,20,10,9685,922,1557,329,681,356,278,0,333,242,0,0,0,55,187,0,0,'LAST_HIT','true'),
(21540,21540,'Wailing of Splendor',0,'',0,'LineageMonster.kel_mahum',13.00,26.00,67,'male','L2Monster',40,3626,1388,11.85,2.78,40,43,30,21,20,10,9685,922,1169,439,681,356,278,0,333,242,0,0,0,55,187,0,0,'LAST_HIT','true'),
(21541,21541,'Pilgrim of Splendor',0,'',0,'LineageMonster.kel_mahum_witch_doctor',13.00,25.00,63,'male','L2Monster',40,3302,1251,11.85,2.78,40,43,30,21,20,10,9944,898,987,338,560,323,278,150,476,315,0,0,0,50,165,0,0,'LAST_HIT','false'),
(21542,21542,'Disciple of Pilgrim',0,'',0,'LineageMonster.kel_mahum_warrior',13.00,28.00,62,'male','L2Monster',40,3219,1217,11.85,2.78,40,43,30,21,20,10,6932,618,1038,353,532,315,278,0,476,193,0,0,0,50,165,0,0,'LAST_HIT','false'),
(21543,21543,'Page of Pilgrim',0,'',0,'LineageMonster.kel_mahum',13.00,26.00,62,'male','L2Monster',40,3219,1217,11.85,2.78,40,43,30,21,20,10,7909,705,858,427,532,315,278,0,476,326,0,0,0,50,165,0,0,'LAST_HIT','false'),
(21544,21544,'Judge of Splendor',0,'',0,'LineageMonster.kel_mahum_champion',13.00,32.00,67,'male','L2Monster',40,3626,1388,11.85,2.78,40,43,30,21,20,10,11331,1079,1169,439,681,356,300,150,512,150,0,0,0,50,160,0,0,'LAST_HIT','false'),
(21545,21545,'Judge of Fire',0,'',0,'LineageMonster.kel_mahum_witch_doctor',13.00,25.00,66,'male','L2Monster',40,3546,1353,11.85,2.78,40,43,30,21,20,10,7855,739,1235,331,649,348,278,0,476,189,0,0,0,50,165,0,0,'LAST_HIT','false'),
(21546,21546,'Judge of Light',0,'',0,'LineageMonster.kel_mahum',13.00,26.00,66,'male','L2Monster',40,3546,1353,11.85,2.78,40,43,30,21,20,10,8963,844,1020,471,649,348,278,0,476,196,0,0,0,50,165,0,0,'LAST_HIT','false'),
(21547,21547,'Corrupted Knight',0,'',0,'LineageMonster.skeleton_knight',10.00,25.00,63,'male','L2Monster',40,3302,1251,11.85,2.78,40,43,30,21,20,10,8116,733,987,398,560,323,278,0,333,150,103,0,0,40,165,1,0,'LAST_HIT','true'),
(21548,21548,'Resurrected Knight',0,'',0,'LineageMonster.skeleton_knight',10.00,25.00,63,'male','L2Monster',40,3302,1251,11.85,2.78,40,43,30,21,20,10,7019,634,987,398,560,323,278,0,333,150,103,0,0,40,165,1,0,'LAST_HIT','true'),
(21549,21549,'Corrupted Guard',0,'',0,'LineageMonster.skeleton_royal_guard',11.00,28.50,64,'male','L2Monster',40,3384,1285,11.85,2.78,40,43,30,21,20,10,8375,767,902,408,589,331,317,0,333,946,0,0,0,80,175,1,0,'LAST_HIT','true'),
(21550,21550,'Corrupted Guard',0,'',0,'LineageMonster.skeleton_royal_guard',11.00,28.50,64,'male','L2Monster',40,3384,1285,11.85,2.78,40,43,30,21,20,10,8543,782,1201,306,589,331,317,150,333,946,945,0,0,80,175,1,0,'LAST_HIT','true'),
(21551,21551,'Resurrected Guard',0,'',0,'LineageMonster.skeleton_royal_guard',11.00,28.50,66,'male','L2Monster',40,3546,1353,11.85,2.78,40,43,30,21,20,10,9541,898,982,428,649,348,317,0,333,221,0,0,0,80,175,1,0,'LAST_HIT','true'),
(21552,21552,'Resurrected Guard',0,'',0,'LineageMonster.skeleton_royal_guard',11.00,28.50,66,'male','L2Monster',40,3546,1353,11.85,2.78,40,43,30,21,20,10,9085,855,1307,322,649,348,317,150,333,221,945,0,0,80,175,1,0,'LAST_HIT','true'),
(21553,21553,'Trampled Man',0,'',0,'LineageMonster.zombie',13.00,21.00,65,'male','L2Monster',40,3465,1319,11.85,2.78,40,43,30,21,20,10,6267,582,1077,355,619,340,278,0,333,0,0,0,0,15,40,1,0,'LAST_HIT','true'),
(21554,21554,'Trampled Man',0,'',0,'LineageMonster.zombie',13.00,21.00,65,'male','L2Monster',40,3465,1319,11.85,2.78,40,43,30,21,20,10,6267,582,1303,294,619,340,278,0,333,0,0,0,0,15,40,1,0,'LAST_HIT','true'),
(21555,21555,'Slaughter Executioner',0,'',0,'LineageMonster.dark_horror',20.00,42.00,65,'male','L2Monster',40,3465,1319,11.85,2.78,40,43,30,21,20,10,7619,708,979,391,619,340,278,0,333,0,0,0,0,100,160,1,0,'LAST_HIT','true'),
(21556,21556,'Slaughter Executioner',0,'',0,'LineageMonster.dark_horror',20.00,35.00,65,'male','L2Monster',40,3465,1319,11.85,2.78,40,43,30,21,20,10,7435,691,1077,355,619,340,278,0,333,0,0,0,0,110,176,1,0,'LAST_HIT','true'),
(21557,21557,'Bone Snatcher',0,'',0,'LineageMonster2.black_magician',8.00,30.00,66,'male','L2Monster',40,3546,1353,11.85,2.78,40,43,30,21,20,10,8774,826,1123,428,649,348,278,0,333,178,0,0,0,19,180,0,0,'LAST_HIT','true'),
(21558,21558,'Bone Snatcher',0,'',0,'LineageMonster2.black_magician',8.00,30.00,66,'male','L2Monster',40,3546,1353,11.85,2.78,40,43,30,21,20,10,8774,826,1123,428,649,348,278,0,333,178,0,0,0,19,180,0,0,'LAST_HIT','true'),
(21559,21559,'Bone Maker',0,'',0,'LineageMonster2.black_magician',8.00,30.00,66,'male','L2Monster',40,3546,1353,11.85,2.78,40,43,30,21,20,10,9596,903,1020,471,649,348,278,150,333,178,0,0,0,19,180,0,0,'LAST_HIT','true'),
(21560,21560,'Bone Shaper',0,'',0,'LineageMonster2.black_magician',8.00,30.00,66,'male','L2Monster',40,3546,1353,11.85,2.78,40,43,30,21,20,10,9596,903,1020,471,649,348,278,150,333,178,0,0,0,19,180,0,0,'LAST_HIT','true'),
(21561,21561,'Sacrificed Man',0,'',0,'LineageMonster.zombie',13.00,21.00,67,'male','L2Monster',40,3626,1388,11.85,2.78,40,43,30,21,20,10,8057,767,1063,410,681,356,278,150,333,0,0,0,0,15,40,1,0,'LAST_HIT','true'),
(21562,21562,'Guillotine\'s Ghost',0,'',0,'LineageMonster.liviona',15.00,28.00,67,'male','L2Monster',40,3626,1388,11.85,2.78,40,43,30,21,20,10,8344,795,1169,373,681,356,278,150,333,0,0,0,0,88,165,0,0,'LAST_HIT','true'),
(21563,21563,'Bone Collector',0,'',0,'LineageMonster2.black_magician',8.00,30.00,67,'male','L2Monster',40,3626,1388,11.85,2.78,40,43,30,21,20,10,9695,923,1286,399,681,356,278,0,333,178,0,0,0,19,180,0,0,'LAST_HIT','true'),
(21564,21564,'Skull Collector',0,'',0,'LineageMonster2.black_magician',8.00,30.00,67,'male','L2Monster',40,3626,1388,11.85,2.78,40,43,30,21,20,10,9223,878,1286,399,681,356,278,150,333,178,0,0,0,19,180,0,0,'LAST_HIT','true'),
(21565,21565,'Bone Animator',0,'',0,'LineageMonster2.black_magician',8.00,30.00,68,'male','L2Monster',40,3706,1423,11.85,2.78,40,43,30,21,20,10,9314,900,1339,408,713,365,278,0,333,178,0,0,0,19,180,0,0,'LAST_HIT','true'),
(21566,21566,'Skull Animator',0,'',0,'LineageMonster2.black_magician',8.00,30.00,68,'male','L2Monster',40,3706,1423,11.85,2.78,40,43,30,21,20,10,10186,984,1339,408,713,365,278,150,333,178,0,0,0,19,180,0,0,'LAST_HIT','true'),
(21567,21567,'Bone Slayer',0,'',0,'LineageMonster2.black_magician',8.00,30.00,68,'male','L2Monster',40,3706,1423,11.85,2.78,40,43,30,21,20,10,12175,1176,1106,494,713,365,278,150,333,178,0,0,0,19,180,0,0,'LAST_HIT','true'),
(21568,21568,'Devil Bat',0,'',0,'LineageMonster.vampire_bat',10.00,33.50,68,'male','L2Monster',40,3706,1423,11.85,2.78,40,43,30,21,20,10,10440,1009,1473,315,713,365,278,150,333,0,0,0,0,60,170,0,0,'LAST_HIT','true'),
(21569,21569,'Devil Bat',0,'',0,'LineageMonster.vampire_bat',10.00,33.50,68,'male','L2Monster',40,3706,1423,11.85,2.78,40,43,30,21,20,10,8108,783,1217,382,713,365,278,150,333,0,0,0,0,60,170,0,0,'LAST_HIT','true'),
(21570,21570,'Ghost of Betrayer',0,'',0,'LineageMonster.binding',12.00,21.00,69,'male','L2Monster',40,3784,1458,11.85,2.78,40,43,30,21,20,10,7557,739,1150,506,746,373,278,150,333,0,0,0,0,10,174,1,0,'LAST_HIT','true'),
(21571,21571,'Ghost of Rebellion Soldier',0,'',0,'LineageMonster.skeleton_knight',10.00,25.00,69,'male','L2Monster',40,3784,1458,11.85,2.78,40,43,30,21,20,10,10718,1049,1265,460,746,373,278,150,333,150,103,0,0,40,165,1,0,'LAST_HIT','true'),
(21572,21572,'Bone Sweeper',0,'',0,'LineageMonster2.black_magician',8.00,30.00,69,'male','L2Monster',40,3784,1458,11.85,2.78,40,43,30,21,20,10,10282,1006,1392,418,746,373,278,0,333,178,0,0,0,19,185,0,0,'LAST_HIT','true'),
(21573,21573,'Atrox',0,'',0,'LineageMonster2.kailiharim',45.00,39.00,69,'male','L2Monster',40,3784,1458,11.85,2.78,40,43,30,21,20,10,11456,1121,2127,380,746,373,197,150,333,0,0,0,0,105,185,0,0,'LAST_HIT','true'),
(21574,21574,'Bone Grinder',0,'',0,'LineageMonster2.black_magician',8.00,30.00,70,'male','L2Monster',40,3862,1493,11.85,2.78,40,43,30,21,20,10,12902,1279,1194,517,780,382,278,150,333,178,0,0,0,19,185,0,0,'LAST_HIT','true'),
(21575,21575,'Bone Grinder',0,'',0,'LineageMonster2.black_magician',8.00,30.00,70,'male','L2Monster',40,3862,1493,11.85,2.78,40,43,30,21,20,10,7269,721,1314,470,780,382,278,150,333,178,0,0,0,19,185,0,0,'LAST_HIT','true'),
(21576,21576,'Ghost of Guillotine',0,'',0,'LineageMonster.liviona',15.00,28.00,70,'male','L2Monster',40,3862,1493,11.85,2.78,40,43,30,21,20,10,9350,927,1590,330,780,382,278,0,333,0,0,0,0,80,150,0,0,'LAST_HIT','true'),
(21577,21577,'Ghost of Guillotine',0,'',0,'LineageMonster.liviona',15.00,28.00,70,'male','L2Monster',40,3862,1493,11.85,2.78,40,43,30,21,20,10,8195,813,1314,399,780,382,278,0,333,0,0,0,0,80,150,0,0,'LAST_HIT','true'),
(21578,21578,'Behemoth Zombie',0,'',0,'LineageMonster2.giant_zombie',13.00,40.00,71,'male','L2Monster',40,3938,1529,13.43,3.09,40,43,30,21,20,10,10308,1034,1239,529,814,390,278,0,333,0,0,0,0,20,90,1,0,'LAST_HIT','true'),
(21579,21579,'Ghost of Rebellion Leader',0,'',0,'LineageMonster.skeleton_royal_guard',11.00,28.50,71,'male','L2Monster',40,3938,1529,13.43,3.09,40,43,30,21,20,10,10843,1088,1193,481,814,390,317,0,333,221,945,0,0,80,175,1,0,'LAST_HIT','true'),
(21580,21580,'Bone Caster',0,'',0,'LineageMonster2.black_magician',8.00,30.00,71,'male','L2Monster',40,3938,1529,13.43,3.09,40,43,30,21,20,10,10154,1019,1499,437,814,390,278,0,333,178,0,0,0,19,185,0,0,'LAST_HIT','true'),
(21581,21581,'Bone Puppeteer',0,'',0,'LineageMonster2.black_magician',8.00,30.00,71,'male','L2Monster',40,3938,1529,13.43,3.09,40,43,30,21,20,10,11105,1114,1499,437,814,390,278,150,333,178,0,0,0,19,185,0,0,'LAST_HIT','true'),
(21582,21582,'Vampire Soldier',0,'',0,'LineageMonster2.vampire_soldier',8.00,23.50,71,'male','L2Monster',40,3938,1529,13.43,3.09,40,43,30,21,20,10,11891,1193,1649,397,814,390,278,0,333,234,0,0,0,60,190,0,0,'LAST_HIT','true'),
(21583,21583,'Bone Scavenger',0,'',0,'LineageMonster2.black_magician',8.00,30.00,72,'male','L2Monster',40,4013,1565,13.43,3.09,40,43,30,21,20,10,11196,1137,1554,446,849,399,278,0,333,178,0,0,0,19,185,0,0,'LAST_HIT','true'),
(21584,21584,'Bone Scavenger',0,'',0,'LineageMonster2.black_magician',8.00,30.00,72,'male','L2Monster',40,4013,1565,13.43,3.09,40,43,30,21,20,10,10442,1061,1284,540,849,399,278,0,333,178,0,0,0,19,185,0,0,'LAST_HIT','true'),
(21585,21585,'Vampire Magician',0,'',0,'LineageMonster2.vampire_witch',6.00,21.50,72,'female','L2Monster',40,4013,1565,13.43,3.09,40,43,30,21,20,10,9628,978,1710,406,849,399,278,150,333,946,0,0,0,64,180,0,0,'LAST_HIT','true'),
(21586,21586,'Vampire Adept',0,'',0,'LineageMonster2.vampire_wizard',5.50,28.00,72,'female','L2Monster',40,4013,1565,13.43,3.09,40,43,30,21,20,10,11374,1156,1710,406,849,399,278,150,333,99,0,0,0,46,180,0,0,'LAST_HIT','true'),
(21587,21587,'Vampire Warrior',0,'',0,'LineageMonster2.vampire_soldier_20_bi',10.00,29.00,72,'male','L2Monster',40,4013,1565,13.43,3.09,40,43,30,21,20,10,11852,1204,1710,406,849,399,278,0,333,234,0,0,0,60,190,0,0,'LAST_HIT','true'),
(21588,21588,'Vampire Wizard',0,'',0,'LineageMonster2.vampire_witch',6.00,21.50,73,'female','L2Monster',40,4086,1601,13.43,3.09,40,43,30,21,20,10,9936,1022,1947,377,885,407,278,0,333,946,0,0,0,64,180,0,0,'LAST_HIT','true'),
(21589,21589,'Vampire Wizard',0,'',0,'LineageMonster2.vampire_witch',6.00,21.50,73,'female','L2Monster',40,4086,1601,13.43,3.09,40,43,30,21,20,10,10168,1046,1099,668,885,407,278,0,333,946,0,0,0,64,180,0,0,'LAST_HIT','true'),
(21590,21590,'Vampire Magister',0,'',0,'LineageMonster2.vampire_wizard',5.50,28.00,73,'female','L2Monster',40,4086,1601,13.43,3.09,40,43,30,21,20,10,9936,1022,1770,415,885,407,278,0,333,99,0,0,0,46,180,0,0,'LAST_HIT','true'),
(21591,21591,'Vampire Magister',0,'',0,'LineageMonster2.vampire_wizard',5.50,28.00,73,'female','L2Monster',40,4086,1601,13.43,3.09,40,43,30,21,20,10,11462,1179,1770,415,885,407,278,0,333,99,0,0,0,46,180,0,0,'LAST_HIT','true'),
(21592,21592,'Vampire Magister',0,'',0,'LineageMonster2.vampire_wizard',5.50,28.00,73,'female','L2Monster',40,4086,1601,13.43,3.09,40,43,30,21,20,10,7750,797,1330,552,885,407,278,0,333,99,0,0,0,46,180,0,0,'LAST_HIT','true'),
(21593,21593,'Vampire Warlord',0,'',0,'LineageMonster2.vampire_warrior',9.00,31.50,73,'male','L2Monster',40,4086,1601,13.43,3.09,40,43,30,21,20,10,13346,1373,2459,415,885,407,197,0,333,6723,0,0,0,43,190,0,0,'LAST_HIT','true'),
(21594,21594,'Vampire Warlord',0,'',0,'LineageMonster2.vampire_warrior',9.00,31.50,73,'male','L2Monster',40,4086,1601,13.43,3.09,40,43,30,21,20,10,12571,1294,2459,415,885,407,197,0,333,6723,0,0,0,43,190,0,0,'LAST_HIT','true'),
(21595,21595,'Vampire Warlord',0,'',0,'LineageMonster2.vampire_warrior',9.00,31.50,73,'male','L2Monster',40,4086,1601,13.43,3.09,40,43,30,21,20,10,9161,943,1847,552,885,407,197,0,333,6723,0,0,0,43,190,0,0,'LAST_HIT','true'),
(21596,21596,'Requiem Lord',0,'',0,'LineageMonster2.black_magician',8.00,30.00,68,'male','L2Monster',40,3706,1423,11.85,2.78,40,43,30,21,20,10,12038,1163,1106,494,713,365,278,150,333,178,0,0,0,19,185,0,0,'LAST_HIT','false'),
(21597,21597,'Requiem Behemoth',0,'',0,'LineageMonster2.giant_zombie',13.00,40.00,67,'male','L2Monster',40,3626,1388,11.85,2.78,40,43,30,21,20,10,8265,787,1286,399,681,356,278,0,333,0,0,0,0,20,100,1,0,'LAST_HIT','false'),
(21598,21598,'Requiem Behemoth',0,'',0,'LineageMonster2.giant_zombie',13.00,40.00,67,'male','L2Monster',40,3626,1388,11.85,2.78,40,43,30,21,20,10,9179,874,1286,399,681,356,278,0,333,0,0,0,0,20,100,1,0,'LAST_HIT','false'),
(21599,21599,'Requiem Priest',0,'',0,'LineageMonster2.black_magician',8.00,30.00,71,'male','L2Monster',40,3938,1529,13.43,3.09,40,43,30,21,20,10,12750,1279,1239,529,814,390,278,150,333,178,0,0,0,19,185,0,0,'LAST_HIT','false'),
(21600,21600,'Requiem Behemoth',0,'',0,'LineageMonster2.giant_zombie',13.00,40.00,70,'male','L2Monster',40,3862,1493,11.85,2.78,40,43,30,21,20,10,9022,895,1445,427,780,382,278,0,333,0,0,0,0,20,100,1,0,'LAST_HIT','false'),
(21601,21601,'Requiem Behemoth',0,'',0,'LineageMonster2.giant_zombie',13.00,40.00,70,'male','L2Monster',40,3862,1493,11.85,2.78,40,43,30,21,20,10,10732,1064,1445,427,780,382,278,0,333,0,0,0,0,20,100,1,0,'LAST_HIT','false'),
(21602,21602,'Zaken\'s Pikeman',0,'',0,'LineageMonster.skeleton_pikeman',10.00,28.00,43,'male','L2Monster',40,1728,618,8.69,2.14,40,43,30,21,20,10,3693,250,332,223,163,181,278,150,333,292,0,0,0,50,174,1,0,'LAST_HIT','false'),
(21603,21603,'Zaken\'s Pikeman',0,'',0,'LineageMonster.skeleton_pikeman',10.00,28.00,43,'male','L2Monster',40,1728,618,8.69,2.14,40,43,30,21,20,10,5230,354,442,167,163,181,278,150,333,292,0,0,0,50,174,1,0,'LAST_HIT','false'),
(21604,21604,'Zaken\'s Elite Pikeman',0,'',0,'LineageMonster.skeleton_pikeman_20_bi',12.00,33.60,43,'male','L2Monster',40,1728,618,34.76,2.14,40,43,30,21,20,10,2114,143,332,223,163,181,278,150,333,292,0,0,0,50,174,1,0,'LAST_HIT','false'),
(21605,21605,'Zaken\'s Archer',0,'',0,'LineageMonster.skeleton_archer',11.00,27.00,44,'male','L2Monster',500,1799,648,8.69,2.14,40,43,30,21,20,10,4109,281,788,230,176,187,249,0,333,279,0,0,0,44,191,1,0,'LAST_HIT','false'),
(21606,21606,'Zaken\'s Archer',0,'',0,'LineageMonster.skeleton_archer',11.00,27.00,44,'male','L2Monster',500,1799,648,8.69,2.14,40,43,30,21,20,10,5818,398,1048,173,176,187,249,0,333,279,0,0,0,44,191,1,0,'LAST_HIT','false'),
(21607,21607,'Zaken\'s Elite Archer',0,'',0,'LineageMonster.skeleton_archer_20_bi',13.00,32.50,44,'male','L2Monster',500,1799,648,34.76,2.14,40,43,30,21,20,10,2273,155,788,230,176,187,247,0,333,279,0,0,0,40,174,1,0,'LAST_HIT','false'),
(21608,21608,'Zaken\'s Watchman',0,'',0,'LineageMonster.liviona',15.00,28.00,45,'male','L2Monster',40,1870,677,8.69,2.14,40,43,30,21,20,10,3365,234,377,202,188,193,278,150,333,0,0,0,0,88,191,0,0,'LAST_HIT','false'),
(21609,21609,'Zaken\'s Watchman',0,'',0,'LineageMonster.liviona',15.00,28.00,45,'male','L2Monster',40,1870,677,8.69,2.14,40,43,30,21,20,10,4766,331,502,152,188,193,278,150,333,0,0,0,0,88,191,0,0,'LAST_HIT','false'),
(21610,21610,'Zaken\'s High Grade Watchman',0,'',0,'LineageMonster.liviona_20_bi',18.00,33.60,45,'male','L2Monster',40,1870,677,34.76,2.14,40,43,30,21,20,10,2174,151,377,202,188,193,278,150,333,0,0,0,0,80,174,0,0,'LAST_HIT','false'),
(21611,21611,'Unpleasant Humming',0,'',0,'LineageMonster.unpleasant_humming',12.00,26.00,46,'male','L2Monster',40,1943,707,8.69,2.14,40,43,30,21,20,10,3907,277,401,245,202,199,278,150,333,0,0,0,0,23,191,1,3,'LAST_HIT','false'),
(21612,21612,'Unpleasant Humming',0,'',0,'LineageMonster.unpleasant_humming',12.00,26.00,46,'male','L2Monster',40,1943,707,8.69,2.14,40,43,30,21,20,10,5533,392,534,184,202,199,278,150,333,0,0,0,0,23,191,1,3,'LAST_HIT','false'),
(21613,21613,'Unpleasant Shout',0,'',0,'LineageMonster.unpleasant_humming_20_bi',13.50,31.20,46,'male','L2Monster',40,1943,707,34.76,2.14,40,43,30,21,20,10,2360,167,401,245,202,199,278,150,333,0,0,0,0,21,174,1,0,'LAST_HIT','false'),
(21614,21614,'Death Flyer',0,'',0,'LineageMonster.dark_horror',20.00,35.00,47,'male','L2Monster',40,2016,738,8.69,2.14,40,43,30,21,20,10,4035,289,427,253,216,206,278,0,333,0,0,0,0,110,191,1,4,'LAST_HIT','false'),
(21615,21615,'Death Flyer',0,'',0,'LineageMonster.dark_horror',20.00,35.00,47,'male','L2Monster',40,2016,738,8.69,2.14,40,43,30,21,20,10,5714,410,568,190,216,206,278,0,333,0,0,0,0,110,191,1,4,'LAST_HIT','false'),
(21616,21616,'Gigantic Flyer',0,'',0,'LineageMonster.dark_horror_bi',20.00,42.00,47,'male','L2Monster',40,2016,738,34.76,2.14,40,43,30,21,20,10,2607,187,427,253,216,206,278,0,333,0,0,0,0,100,174,1,0,'LAST_HIT','false'),
(21617,21617,'Fiend Archer',0,'',0,'LineageMonster.fiend_archer',17.00,55.00,48,'male','L2Monster',500,2091,768,8.69,2.14,40,43,30,21,20,10,4103,300,1007,222,231,212,247,150,333,0,0,0,0,70,174,0,4,'LAST_HIT','false'),
(21618,21618,'Fiend Archer',0,'',0,'LineageMonster.fiend_archer',17.00,55.00,48,'male','L2Monster',500,2091,768,8.69,2.14,40,43,30,21,20,10,5811,425,1341,167,231,212,247,150,333,0,0,0,0,70,174,0,0,'LAST_HIT','false'),
(21619,21619,'Pit Archer',0,'',0,'LineageMonster.fiend_archer_20_bi',20.00,66.00,48,'male','L2Monster',500,2091,768,34.76,2.14,40,43,30,21,20,10,2651,193,1007,222,231,212,247,150,333,0,0,0,0,70,174,0,0,'LAST_HIT','false'),
(21620,21620,'Musveren',0,'',0,'LineageMonster.field_stalker',15.00,30.00,49,'male','L2Monster',40,2168,799,8.69,2.14,40,43,30,21,20,10,3951,292,480,270,247,219,278,0,333,0,0,0,0,77,191,0,4,'LAST_HIT','false'),
(21621,21621,'Musveren',0,'',0,'LineageMonster.field_stalker',15.00,30.00,49,'male','L2Monster',40,2168,799,8.69,2.14,40,43,30,21,20,10,5595,414,640,202,247,219,278,0,333,0,0,0,0,77,191,0,4,'LAST_HIT','false'),
(21622,21622,'Greater Musveren',0,'',0,'LineageMonster.field_stalker_20_bi',18.00,36.00,49,'male','L2Monster',40,2168,799,34.76,2.14,40,43,30,21,20,10,2553,188,480,270,247,219,278,0,333,0,0,0,0,70,174,0,0,'LAST_HIT','false'),
(21623,21623,'Zaken\'s Guard',0,'',0,'LineageMonster.skeleton_royal_guard',11.00,28.50,50,'male','L2Monster',40,2245,830,8.69,2.14,40,43,30,21,20,10,4994,376,445,278,264,226,317,150,333,225,945,0,0,80,174,1,5,'LAST_HIT','false'),
(21624,21624,'Zaken\'s Guard',0,'',0,'LineageMonster.skeleton_royal_guard',11.00,28.50,50,'male','L2Monster',40,2245,830,8.69,2.14,40,43,30,21,20,10,7072,533,593,209,264,226,317,150,333,225,945,0,0,88,191,1,5,'LAST_HIT','false'),
(21625,21625,'Zaken\'s Elite Guard',0,'',0,'LineageMonster.skeleton_royal_guard_20_bi',13.00,34.50,50,'male','L2Monster',40,2245,830,34.76,2.14,40,43,30,21,20,10,2858,215,445,278,264,226,317,150,333,225,945,0,0,80,174,1,0,'LAST_HIT','false'),
(21626,21626,'Kaim Vanul',0,'',0,'LineageMonster.kaim_vanul',24.00,40.00,51,'male','L2Monster',40,2323,861,10.27,2.45,40,43,30,21,20,10,4453,340,539,286,281,232,278,0,333,0,0,0,0,37,174,0,5,'LAST_HIT','false'),
(21627,21627,'Kaim Vanul',0,'',0,'LineageMonster.kaim_vanul',24.00,40.00,51,'male','L2Monster',40,2323,861,10.27,2.45,40,43,30,21,20,10,6306,481,718,215,281,232,278,0,333,0,0,0,0,40,191,0,5,'LAST_HIT','false'),
(21628,21628,'Kaim Vanul Lad',0,'',0,'LineageMonster.kaim_vanul_20_bi',28.00,48.00,51,'male','L2Monster',40,2323,861,41.08,2.45,40,43,30,21,20,10,2877,219,539,286,281,232,278,0,333,0,0,0,0,37,174,0,0,'LAST_HIT','false'),
(21629,21629,'Pirate Zombie Captain',0,'',0,'LineageMonster.pirates_zombie_captain',17.00,28.00,52,'male','L2Monster',40,2402,892,10.27,2.45,40,43,30,21,20,10,6727,520,499,295,300,239,317,150,333,232,0,0,0,14,174,1,5,'LAST_HIT','false'),
(21630,21630,'Pirate Zombie Captain',0,'',0,'LineageMonster.pirates_zombie_captain',17.00,28.00,52,'male','L2Monster',40,2402,892,10.27,2.45,40,43,30,21,20,10,9526,737,664,221,300,239,317,150,333,232,0,0,0,14,174,1,5,'LAST_HIT','false'),
(21631,21631,'Zombie Captain\'s Spiritual Body',0,'',0,'LineageMonster.pirates_zombie_captain_20_bi',20.00,33.60,52,'male','L2Monster',40,2402,892,41.08,2.45,40,43,30,21,20,10,3948,305,499,295,300,239,317,150,333,232,0,0,0,14,174,1,0,'LAST_HIT','false'),
(21632,21632,'Doll Blader',0,'',0,'LineageMonster.doll_blader',6.00,12.00,53,'male','L2Monster',40,2481,923,10.27,2.45,40,43,30,21,20,10,5339,420,527,258,319,247,317,0,333,5129,5129,0,0,24,191,0,6,'LAST_HIT','false'),
(21633,21633,'Doll Blader',0,'',0,'LineageMonster.doll_blader',6.00,12.00,53,'male','L2Monster',40,2481,923,10.27,2.45,40,43,30,21,20,10,7560,594,701,194,319,247,317,0,333,5129,5129,0,0,24,191,0,6,'LAST_HIT','false'),
(21634,21634,'Crimson Doll Blader',0,'',0,'LineageMonster.doll_blader_20_bi',7.00,15.00,53,'male','L2Monster',40,2481,923,41.08,2.45,40,43,30,21,20,10,3450,271,527,258,319,247,317,0,333,5129,5129,0,0,22,174,0,0,'LAST_HIT','false'),
(21635,21635,'Vale Master',0,'',0,'LineageMonster.vale_master',12.00,40.00,54,'male','L2Monster',40,2562,955,10.27,2.45,40,43,30,21,20,10,5093,406,636,266,339,254,278,150,333,0,0,0,0,70,174,0,6,'LAST_HIT','false'),
(21636,21636,'Vale Master',0,'',0,'LineageMonster.vale_master',12.00,40.00,54,'male','L2Monster',40,2562,955,10.27,2.45,40,43,30,21,20,10,7212,575,846,199,339,254,278,150,333,0,0,0,0,77,191,0,6,'LAST_HIT','false'),
(21637,21637,'Crimson Vale Master',0,'',0,'LineageMonster.vale_master_20_bi',14.50,48.00,54,'male','L2Monster',40,2562,955,41.08,2.45,40,43,30,21,20,10,3291,262,636,266,339,254,278,150,333,0,0,0,0,70,174,0,0,'LAST_HIT','false'),
(21638,21638,'Dread Wolf',0,'',0,'LineageMonster.dire_wolf',13.00,11.00,35,'male','L2Monster',40,1220,446,3.56,1.84,40,43,30,21,20,10,2303,136,211,154,89,137,278,150,333,0,0,0,0,24,140,0,0,'LAST_HIT','true'),
(21639,21639,'Tasaba Lizardman',0,'',0,'LineageMonster.virud_lizardman_scout',10.00,22.00,36,'male','L2Monster',500,1279,463,3.56,1.84,40,43,30,21,20,10,2725,164,417,193,96,142,247,0,333,2507,0,0,0,43,140,0,0,'LAST_HIT','true'),
(21640,21640,'Tasaba Lizardman Shaman',0,'',0,'LineageMonster.virud_lizardman_shaman',10.00,29.00,37,'male','L2Monster',40,1338,480,3.56,1.84,40,43,30,21,20,10,2003,124,295,116,104,147,278,0,333,7,0,0,0,43,140,0,0,'LAST_HIT','true'),
(21641,21641,'Ogre',0,'',0,'LineageMonster.ogre',21.00,44.00,38,'male','L2Monster',40,1400,497,3.56,1.84,40,43,30,21,20,10,3555,222,300,207,112,153,256,150,333,98,0,0,0,22,174,0,0,'LAST_HIT','true'),
(21642,21642,'Tasaba Lizardman Sniper',0,'',0,'LineageMonster.virud_lizardman_scout',10.00,22.00,39,'male','L2Monster',500,1462,514,3.56,1.84,40,43,30,21,20,10,3263,208,566,165,121,158,247,150,333,2507,0,0,0,43,140,0,0,'LAST_HIT','true'),
(21643,21643,'Tasaba Lizardman Sniper',0,'',0,'LineageMonster.virud_lizardman_scout',10.00,22.00,39,'male','L2Monster',500,1462,514,3.56,1.84,40,43,30,21,20,10,4146,264,685,137,121,158,247,150,333,2507,0,0,0,43,140,0,0,'LAST_HIT','true'),
(21644,21644,'Lienrik',0,'',0,'LineageMonster.lienrik',12.00,50.00,39,'male','L2Monster',40,1462,514,3.56,1.84,40,43,30,21,20,10,1990,126,297,146,121,158,317,0,333,0,0,0,0,100,150,0,0,'LAST_HIT','true'),
(21645,21645,'Lienrik Lad',0,'',0,'LineageMonster.lienrik',12.00,50.00,40,'male','L2Monster',40,1527,531,3.56,1.84,40,43,30,21,20,10,3836,248,317,151,131,164,317,150,333,0,0,0,0,110,191,0,0,'LAST_HIT','true'),
(21646,21646,'Grave Scarab',0,'',0,'LineageMonster2.scarab',14.00,22.00,73,'male','L2Monster',40,4086,1601,13.43,3.09,40,43,30,21,20,10,10206,1050,1463,502,885,407,278,0,333,0,0,0,0,49,198,0,0,'LAST_HIT','true'),
(21647,21647,'Scavenger Scarab',0,'',0,'LineageMonster2.scarab',14.00,22.00,73,'male','L2Monster',40,4086,1601,13.43,3.09,40,43,30,21,20,10,8609,886,1463,502,885,407,278,150,333,0,0,0,0,49,198,0,0,'LAST_HIT','true'),
(21648,21648,'Grave Ant',0,'',0,'LineageMonster.ant_soldier',35.00,17.00,74,'male','L2Monster',40,4158,1637,13.43,3.09,40,43,30,21,20,10,9383,978,1513,512,921,416,278,0,333,0,0,0,0,88,165,0,0,'LAST_HIT','true'),
(21649,21649,'Scavenger Ant',0,'',0,'LineageMonster.ant_soldier',35.00,17.00,74,'male','L2Monster',40,4158,1637,13.43,3.09,40,43,30,21,20,10,11099,1157,1513,512,921,416,278,150,333,0,0,0,0,88,165,0,0,'LAST_HIT','true'),
(21650,21650,'Shrine Knight',0,'',0,'LineageMonster.skeleton_knight',10.00,25.00,75,'male','L2Monster',40,4229,1673,13.43,3.09,40,43,30,21,20,10,10149,1071,1563,523,957,425,278,0,333,150,103,0,0,44,181,1,0,'LAST_HIT','true'),
(21651,21651,'Shrine Guard',0,'',0,'LineageMonster.skeleton_pikeman',10.00,28.00,75,'male','L2Monster',40,4229,1673,13.43,3.09,40,43,30,21,20,10,9695,1023,1563,523,957,425,278,0,333,98,0,0,0,55,187,1,0,'LAST_HIT','true'),
(21652,21652,'Scarlet Stakato Noble',0,'',0,'LineageMonster.blade_stakato_drone',15.00,39.00,78,'male','L2Monster',40,4490,1821,67.15,3.09,40,43,30,21,20,10,9382,1039,1544,566,1107,459,317,450,333,235,0,0,0,27,181,0,0,'LAST_HIT','false'),
(21653,21653,'Assassin Beetle',0,'',0,'LineageMonster2.tera_beetle',19.00,54.50,78,'male','L2Monster',40,4550,1859,67.15,3.09,40,43,30,21,20,10,6804,763,1814,576,1144,468,278,150,333,0,0,0,0,49,181,0,0,'LAST_HIT','false'),
(21654,21654,'Necromancer of Destruction',0,'',0,'LineageMonster.vale_master_20_bi',14.50,48.00,78,'male','L2Monster',40,4608,1896,67.15,3.09,40,43,30,21,20,10,8042,913,1863,587,1182,477,278,150,333,0,0,0,0,77,154,0,0,'LAST_HIT','false'),
(21655,21655,'Arimanes of Destruction',0,'',0,'LineageMonster2.ahrimanes',14.00,57.75,78,'male','L2Monster',40,4663,1934,67.15,3.09,40,43,30,21,20,10,7148,821,2655,598,1220,485,200,150,333,6722,0,0,0,38,203,0,0,'LAST_HIT','false'),
(21656,21656,'Ashuras of Destruction',0,'',0,'LineageMonster2.ashuras_30_bi',17.00,49.00,78,'male','L2Monster',40,4766,2011,80.58,3.09,40,43,30,21,20,10,10463,1230,2006,619,1296,502,278,150,333,0,0,0,0,45,209,0,0,'LAST_HIT','false'),
(21657,21657,'Magma Drake',0,'',0,'LineageMonster2.inferno_drake_20_bi',29.00,42.00,78,'male','L2Monster',40,4813,2049,80.58,3.09,40,43,30,21,20,10,9062,1078,2052,629,1333,511,278,150,333,0,0,0,0,62,203,0,0,'LAST_HIT','false'),
(21658,21658,'Punishment of Splendor',0,'',0,'LineageMonster.kel_mahum_warrior',13.00,28.00,64,'male','L2Monster',40,3384,1285,11.85,2.78,40,43,30,21,20,10,8837,809,1031,408,589,331,278,0,333,242,0,0,0,50,165,0,0,'LAST_HIT','true'),
(21659,21659,'Otherworldly Invader Soldier',0,'',0,'LineageMonster.neer_crawler',14.00,22.00,30,'male','L2RiftInvader',40,954,365,16.59,1.53,40,43,30,21,20,10,1457,79,115,119,58,114,317,0,333,0,0,0,0,55,181,1,0,'LAST_HIT','false'),
(21660,21660,'Otherworldly Invader Soldier',0,'',0,'LineageMonster.neer_crawler',14.00,22.00,35,'male','L2RiftInvader',40,1220,446,21.33,1.84,40,43,30,21,20,10,2073,122,126,191,89,137,317,150,333,0,0,0,0,55,181,1,0,'LAST_HIT','false'),
(21661,21661,'Otherworldly Invader Archer',0,'',0,'LineageMonster.skeleton_archer',11.00,27.00,33,'male','L2RiftInvader',500,1109,413,21.33,1.84,40,43,30,21,20,10,1492,85,491,100,75,128,249,150,333,275,0,0,0,44,181,1,0,'LAST_HIT','false'),
(21662,21662,'Otherworldly Invader Elite Soldier',0,'',0,'LineageMonster.dark_horror',20.00,35.00,35,'male','L2RiftInvader',40,1220,446,21.33,1.84,40,43,30,21,20,10,1726,102,192,144,89,137,278,150,333,0,0,0,0,110,181,1,0,'LAST_HIT','false'),
(21663,21663,'Otherworldly Invader Shaman',0,'',0,'LineageMonster.dark_horror',20.00,35.00,33,'male','L2RiftInvader',40,1109,413,21.33,1.84,40,43,30,21,20,10,1884,108,166,134,75,128,278,150,333,0,0,0,0,110,181,1,0,'LAST_HIT','false'),
(21664,21664,'Otherworldly Invader Priest',0,'',0,'LineageMonster.dark_horror',20.00,35.00,30,'male','L2RiftInvader',40,954,365,11.06,1.53,40,43,30,21,20,10,1511,82,132,119,58,114,278,0,333,0,0,0,0,110,181,1,0,'LAST_HIT','false'),
(21665,21665,'Otherworldly Invader Magus',0,'',0,'LineageMonster.dark_horror',20.00,35.00,35,'male','L2RiftInvader',40,1220,446,21.33,1.84,40,43,30,21,20,10,1362,80,256,108,89,137,278,150,333,0,0,0,0,110,181,1,0,'LAST_HIT','false'),
(21666,21666,'Otherworldly Invader Martyrs',0,'',0,'LineageMonster.dark_horror',20.00,35.00,30,'male','L2RiftInvader',40,954,365,16.59,1.53,40,43,30,21,20,10,1018,55,132,119,58,114,278,0,333,0,0,0,0,110,181,1,0,'LAST_HIT','false'),
(21667,21667,'Otherworldly Invader Warrior',0,'',0,'LineageMonster.skeleton',11.00,25.00,33,'male','L2RiftInvader',40,1109,413,21.33,1.84,40,43,30,21,20,10,1211,69,145,157,75,128,317,150,333,220,0,0,0,66,181,1,0,'LAST_HIT','false'),
(21668,21668,'Otherworldly Invader Soldier',0,'',0,'LineageMonster.neer_crawler',14.00,22.00,30,'male','L2RiftInvader',40,954,365,16.59,1.53,40,43,30,21,20,10,1071,58,115,119,58,114,317,150,333,0,0,0,0,55,181,1,0,'LAST_HIT','false'),
(21669,21669,'Otherworldly Invader Discipline',0,'',0,'LineageMonster.skeleton',11.00,25.00,33,'male','L2RiftInvader',40,1109,413,21.33,1.84,40,43,30,21,20,10,1275,73,145,157,75,128,317,0,333,220,0,0,0,66,181,1,0,'LAST_HIT','false'),
(21670,21670,'Otherworldly Invader Berserker',0,'',0,'LineageMonster.skeleton',11.00,25.00,35,'male','L2RiftInvader',40,1220,446,21.33,1.84,40,43,30,21,20,10,1785,105,139,205,89,137,317,150,333,220,0,0,0,66,181,1,0,'LAST_HIT','false'),
(21671,21671,'Otherworldly Invader Food',0,'',0,'LineageMonster.mimic',8.50,8.50,30,'male','L2Chest',40,954,365,5.53,1.53,40,43,30,21,20,10,1308,72,132,140,58,114,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(21672,21672,'Otherworldly Invader Elite Soldier',0,'',0,'LineageMonster.skeleton_pikeman',10.00,28.00,35,'male','L2RiftInvader',40,1220,446,42.66,1.84,40,43,30,21,20,10,1599,94,192,169,89,137,278,150,333,96,0,0,0,55,181,1,0,'LAST_HIT','false'),
(21673,21673,'Otherworldly Invader Elite Soldier',0,'',0,'LineageMonster.skeleton_pikeman',10.00,28.00,35,'male','L2RiftInvader',40,1220,446,42.66,1.84,40,43,30,21,20,10,1629,96,192,169,89,137,278,150,333,96,0,0,0,55,181,1,0,'LAST_HIT','false'),
(21674,21674,'Otherworldly Invader Elite Soldier',0,'',0,'LineageMonster.skeleton_pikeman',10.00,28.00,35,'male','L2RiftInvader',40,1220,446,1.78,1.84,40,43,30,21,20,10,1525,92,192,169,89,137,278,0,333,96,0,0,0,55,181,1,0,'LAST_HIT','false'),
(21675,21675,'Otherworldly Invader Elite Soldier',0,'',0,'LineageMonster.skeleton_pikeman',10.00,28.00,30,'male','L2RiftInvader',40,954,365,2.77,1.53,40,43,30,21,20,10,1555,84,132,140,58,114,278,0,333,96,0,0,0,55,181,1,0,'LAST_HIT','false'),
(21676,21676,'Otherworldly Invader Warrior',0,'',0,'LineageMonster.skeleton',11.00,25.00,33,'male','L2RiftInvader',40,1109,413,42.66,1.84,40,43,30,21,20,10,1452,83,145,157,75,128,317,150,333,220,0,0,0,66,181,1,0,'LAST_HIT','false'),
(21677,21677,'Otherworldly Invader Elite Soldier',0,'',0,'LineageMonster.skeleton_pikeman',10.00,28.00,30,'male','L2RiftInvader',40,954,365,33.18,1.53,40,43,30,21,20,10,1164,63,109,170,58,114,278,150,333,96,0,0,0,55,181,1,0,'LAST_HIT','false'),
(21678,21678,'Otherworldly Invader Elite Soldier',0,'',0,'LineageMonster.skeleton_pikeman',10.00,28.00,33,'male','L2RiftInvader',40,1109,413,42.66,1.84,40,43,30,21,20,10,1409,80,201,130,75,128,278,150,333,96,0,0,0,55,181,1,0,'LAST_HIT','false'),
(21679,21679,'Otherworldly Invader Elite Soldier',0,'',0,'LineageMonster.skeleton_pikeman',10.00,28.00,30,'male','L2RiftInvader',40,954,365,33.18,1.53,40,43,30,21,20,10,1148,62,109,170,58,114,278,150,333,96,0,0,0,55,181,1,0,'LAST_HIT','false'),
(21680,21680,'Otherworldly Invader Elite Soldier',0,'',0,'LineageMonster.skeleton_pikeman',10.00,28.00,35,'male','L2RiftInvader',40,1220,446,42.66,1.84,40,43,30,21,20,10,1562,92,232,140,89,137,278,150,333,96,0,0,0,55,181,1,0,'LAST_HIT','false'),
(21681,21681,'Otherworldly Invader Magus',0,'',0,'LineageMonster.dark_horror',20.00,35.00,33,'male','L2RiftInvader',40,1109,413,42.66,1.84,40,43,30,21,20,10,1343,77,166,157,75,128,278,0,333,0,0,0,0,110,181,1,0,'LAST_HIT','false'),
(21682,21682,'Dimension Invader Soldier',0,'',0,'LineageMonster.neer_crawler',14.00,22.00,40,'male','L2RiftInvader',40,1527,531,21.33,1.84,40,43,30,21,20,10,2590,167,238,171,131,164,317,0,333,0,0,0,0,55,181,1,0,'LAST_HIT','false'),
(21683,21683,'Dimension Invader Soldier',0,'',0,'LineageMonster.neer_crawler',14.00,22.00,45,'male','L2RiftInvader',40,1870,677,26.07,2.14,40,43,30,21,20,10,3427,238,248,269,188,193,317,150,333,0,0,0,0,55,181,1,0,'LAST_HIT','false'),
(21684,21684,'Dimension Invader Archer',0,'',0,'LineageMonster.skeleton_archer',11.00,27.00,43,'male','L2RiftInvader',500,1728,618,26.07,2.14,40,43,30,21,20,10,2534,171,984,142,163,181,249,150,333,279,0,0,0,44,181,1,0,'LAST_HIT','false'),
(21685,21685,'Dimension Invader Elite Soldier',0,'',0,'LineageMonster.crimson_doll',15.00,38.00,45,'male','L2RiftInvader',40,1870,677,26.07,2.14,40,43,30,21,20,10,2853,198,377,202,188,193,278,150,333,0,0,0,0,66,181,1,0,'LAST_HIT','false'),
(21686,21686,'Dimension Invader Shaman',0,'',0,'LineageMonster.crimson_doll',15.00,38.00,43,'male','L2RiftInvader',40,1728,618,26.07,2.14,40,43,30,21,20,10,3199,216,332,189,163,181,278,150,333,0,0,0,0,66,181,1,0,'LAST_HIT','false'),
(21687,21687,'Dimension Invader Priest',0,'',0,'LineageMonster.crimson_doll',15.00,38.00,40,'male','L2RiftInvader',40,1527,531,14.22,1.84,40,43,30,21,20,10,2686,173,273,171,131,164,278,0,333,0,0,0,0,66,181,1,0,'LAST_HIT','false'),
(21688,21688,'Dimension Invader Magus',0,'',0,'LineageMonster.crimson_doll',15.00,38.00,45,'male','L2RiftInvader',40,1870,677,26.07,2.14,40,43,30,21,20,10,2253,156,502,152,188,193,278,150,333,0,0,0,0,66,181,1,0,'LAST_HIT','false'),
(21689,21689,'Dimension Invader Martyrs',0,'',0,'LineageMonster.crimson_doll',15.00,38.00,40,'male','L2RiftInvader',40,1527,531,21.33,1.84,40,43,30,21,20,10,1809,117,273,171,131,164,278,0,333,0,0,0,0,66,181,1,0,'LAST_HIT','false'),
(21690,21690,'Dimension Invader Warrior',0,'',0,'LineageMonster.skeleton_knight',10.00,25.00,43,'male','L2RiftInvader',40,1728,618,26.07,2.14,40,43,30,21,20,10,2057,139,332,223,163,181,278,150,333,70,0,0,0,44,181,1,0,'LAST_HIT','false'),
(21691,21691,'Dimension Invader Soldier',0,'',0,'LineageMonster.neer_crawler',14.00,22.00,40,'male','L2RiftInvader',40,1527,531,21.33,1.84,40,43,30,21,20,10,1905,123,238,171,131,164,317,150,333,0,0,0,0,55,181,1,0,'LAST_HIT','false'),
(21692,21692,'Dimension Invader Discipline',0,'',0,'LineageMonster.skeleton_knight',10.00,25.00,43,'male','L2RiftInvader',40,1728,618,26.07,2.14,40,43,30,21,20,10,2166,146,332,223,163,181,278,0,333,70,0,0,0,44,181,1,0,'LAST_HIT','false'),
(21693,21693,'Dimension Invader Berserker',0,'',0,'LineageMonster.skeleton_knight',10.00,25.00,45,'male','L2RiftInvader',40,1870,677,26.07,2.14,40,43,30,21,20,10,2951,205,312,288,188,193,278,150,333,70,0,0,0,44,181,1,0,'LAST_HIT','false'),
(21694,21694,'Dimension Invader Food',0,'',0,'LineageMonster.mimic',8.50,8.50,40,'male','L2Chest',40,1527,531,7.11,1.84,40,43,30,21,20,10,2327,150,273,201,131,164,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(21695,21695,'Dimension Invader Elite Soldier',0,'',0,'LineageMonster.headless_knight',21.00,31.00,45,'male','L2RiftInvader',40,1870,677,52.14,2.14,40,43,30,21,20,10,2643,183,377,238,188,193,278,150,333,135,0,0,0,77,181,1,0,'LAST_HIT','false'),
(21696,21696,'Dimension Invader Elite Soldier',0,'',0,'LineageMonster.headless_knight',21.00,31.00,45,'male','L2RiftInvader',40,1870,677,52.14,2.14,40,43,30,21,20,10,2693,187,377,238,188,193,278,150,333,135,0,0,0,77,181,1,0,'LAST_HIT','false'),
(21697,21697,'Dimension Invader Elite Soldier',0,'',0,'LineageMonster.headless_knight',21.00,31.00,45,'male','L2RiftInvader',40,1870,677,2.17,2.14,40,43,30,21,20,10,2521,176,377,238,188,193,278,0,333,135,0,0,0,77,181,1,0,'LAST_HIT','false'),
(21698,21698,'Dimension Invader Elite Soldier',0,'',0,'LineageMonster.headless_knight',21.00,31.00,40,'male','L2RiftInvader',40,1527,531,3.56,1.84,40,43,30,21,20,10,2764,178,273,201,131,164,278,0,333,135,0,0,0,77,181,1,0,'LAST_HIT','false'),
(21699,21699,'Dimension Invader Warrior',0,'',0,'LineageMonster.skeleton_knight',10.00,25.00,43,'male','L2RiftInvader',40,1728,618,52.14,2.14,40,43,30,21,20,10,2466,166,332,223,163,181,278,150,333,70,0,0,0,44,181,1,0,'LAST_HIT','false'),
(21700,21700,'Dimension Invader Elite Soldier',0,'',0,'LineageMonster.headless_knight',21.00,31.00,40,'male','L2RiftInvader',40,1527,531,42.66,1.84,40,43,30,21,20,10,2070,133,225,244,131,164,278,150,333,135,0,0,0,77,181,1,0,'LAST_HIT','false'),
(21701,21701,'Dimension Invader Elite Soldier',0,'',0,'LineageMonster.headless_knight',21.00,31.00,43,'male','L2RiftInvader',40,1728,618,52.14,2.14,40,43,30,21,20,10,2392,161,402,184,163,181,278,150,333,135,0,0,0,77,181,1,0,'LAST_HIT','false'),
(21702,21702,'Dimension Invader Elite Soldier',0,'',0,'LineageMonster.headless_knight',21.00,31.00,40,'male','L2RiftInvader',40,1527,531,42.66,1.84,40,43,30,21,20,10,2041,131,225,244,131,164,278,150,333,135,0,0,0,77,181,1,0,'LAST_HIT','false'),
(21703,21703,'Dimension Invader Elite Soldier',0,'',0,'LineageMonster.headless_knight',21.00,31.00,45,'male','L2RiftInvader',40,1870,677,52.14,2.14,40,43,30,21,20,10,2583,179,457,196,188,193,278,150,333,135,0,0,0,77,181,1,0,'LAST_HIT','false'),
(21704,21704,'Dimension Invader Magus',0,'',0,'LineageMonster.crimson_doll',15.00,38.00,43,'male','L2RiftInvader',40,1728,618,52.14,2.14,40,43,30,21,20,10,2281,154,332,223,163,181,278,0,333,0,0,0,0,66,181,1,0,'LAST_HIT','false'),
(21705,21705,'Purgatory Invader Soldier',0,'',0,'LineageMonster.doll_blader',6.00,12.00,50,'male','L2RiftInvader',40,2245,830,26.07,2.14,40,43,30,21,20,10,4047,305,445,236,264,226,317,0,333,5129,5129,0,0,24,181,0,0,'LAST_HIT','false'),
(21706,21706,'Purgatory Invader Soldier',0,'',0,'LineageMonster.doll_blader',6.00,12.00,55,'male','L2RiftInvader',40,2643,987,30.81,2.45,40,43,30,21,20,10,5120,413,440,364,360,261,317,150,333,5129,5129,0,0,24,181,0,0,'LAST_HIT','false'),
(21707,21707,'Purgatory Invader Archer',0,'',0,'LineageMonster.skeleton_archer',11.00,27.00,53,'male','L2RiftInvader',500,2481,923,30.81,2.45,40,43,30,21,20,10,3850,302,1782,194,319,247,249,150,333,282,0,0,0,44,181,1,0,'LAST_HIT','false'),
(21708,21708,'Purgatory Invader Elite Soldier',0,'',0,'LineageMonster.banshee',9.00,23.00,55,'female','L2RiftInvader',40,2643,987,30.81,2.45,40,43,30,21,20,10,4262,344,670,273,360,261,278,150,333,3939,0,0,0,88,181,0,0,'LAST_HIT','false'),
(21709,21709,'Purgatory Invader Shaman',0,'',0,'LineageMonster.banshee',9.00,23.00,53,'female','L2RiftInvader',40,2481,923,30.81,2.45,40,43,30,21,20,10,4861,382,602,258,319,247,278,150,333,3939,0,0,0,88,181,0,0,'LAST_HIT','false'),
(21710,21710,'Purgatory Invader Priest',0,'',0,'LineageMonster.banshee',9.00,23.00,50,'female','L2RiftInvader',40,2245,830,17.38,2.14,40,43,30,21,20,10,4198,316,509,236,264,226,278,0,333,3939,0,0,0,88,181,0,0,'LAST_HIT','false'),
(21711,21711,'Purgatory Invader Magus',0,'',0,'LineageMonster.banshee',9.00,23.00,55,'female','L2RiftInvader',40,2643,987,30.81,2.45,40,43,30,21,20,10,3365,271,892,205,360,261,278,150,333,3939,0,0,0,88,181,0,0,'LAST_HIT','false'),
(21712,21712,'Purgatory Invader Martyrs',0,'',0,'LineageMonster.banshee',9.00,23.00,50,'female','L2RiftInvader',40,2245,830,26.07,2.14,40,43,30,21,20,10,2828,213,509,236,264,226,278,0,333,3939,0,0,0,88,181,0,0,'LAST_HIT','false'),
(21713,21713,'Purgatory Invader Warrior',0,'',0,'LineageMonster.skeleton_royal_guard',11.00,28.50,53,'male','L2RiftInvader',40,2481,923,30.81,2.45,40,43,30,21,20,10,3125,245,527,304,319,247,317,150,333,946,946,0,0,88,181,1,0,'LAST_HIT','false'),
(21714,21714,'Purgatory Invader Soldier',0,'',0,'LineageMonster.doll_blader',6.00,12.00,50,'male','L2RiftInvader',40,2245,830,26.07,2.14,40,43,30,21,20,10,2977,224,445,236,264,226,317,150,333,5129,5129,0,0,24,181,0,0,'LAST_HIT','false'),
(21715,21715,'Purgatory Invader Disciples',0,'',0,'LineageMonster.skeleton_royal_guard',11.00,28.50,53,'male','L2RiftInvader',40,2481,923,30.81,2.45,40,43,30,21,20,10,3291,258,527,304,319,247,317,0,333,946,946,0,0,88,181,1,0,'LAST_HIT','false'),
(21716,21716,'Purgatory Invader Berserker',0,'',0,'LineageMonster.skeleton_royal_guard',11.00,28.50,55,'male','L2RiftInvader',40,2643,987,30.81,2.45,40,43,30,21,20,10,4409,356,484,389,360,261,317,150,333,946,946,0,0,88,181,1,0,'LAST_HIT','false'),
(21717,21717,'Purgatory Invader Food',0,'',0,'LineageMonster.mimic',8.50,8.50,50,'male','L2Chest',40,2245,830,8.69,2.14,40,43,30,21,20,10,3636,274,509,278,264,226,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(21718,21718,'Purgatory Invader Elite Soldier',0,'',0,'LineageMonster.bloody_queen',14.00,40.00,55,'female','L2RiftInvader',40,2643,987,61.62,2.45,40,43,30,21,20,10,3949,318,670,322,360,261,278,150,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(21719,21719,'Purgatory Invader Elite Soldier',0,'',0,'LineageMonster.bloody_queen',14.00,40.00,55,'female','L2RiftInvader',40,2643,987,61.62,2.45,40,43,30,21,20,10,4023,324,670,322,360,261,278,150,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(21720,21720,'Purgatory Invader Elite Soldier',0,'',0,'LineageMonster.bloody_queen',14.00,40.00,55,'female','L2RiftInvader',40,2643,987,2.57,2.45,40,43,30,21,20,10,3766,304,670,322,360,261,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(21721,21721,'Purgatory Invader Elite Soldier',0,'',0,'LineageMonster.bloody_queen',14.00,40.00,50,'female','L2RiftInvader',40,2245,830,4.35,2.14,40,43,30,21,20,10,4319,326,509,278,264,226,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(21722,21722,'Purgatory Invader Warrior',0,'',0,'LineageMonster.skeleton_royal_guard',11.00,28.50,53,'male','L2RiftInvader',40,2481,923,61.62,2.45,40,43,30,21,20,10,3746,294,527,304,319,247,317,150,333,946,946,0,0,88,181,1,0,'LAST_HIT','false'),
(21723,21723,'Purgatory Invader Elite Soldier',0,'',0,'LineageMonster.bloody_queen',14.00,40.00,50,'female','L2RiftInvader',40,2245,830,52.14,2.14,40,43,30,21,20,10,3235,243,421,336,264,226,278,150,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(21724,21724,'Purgatory Invader Elite Soldier',0,'',0,'LineageMonster.bloody_queen',14.00,40.00,53,'female','L2RiftInvader',40,2481,923,61.62,2.45,40,43,30,21,20,10,3635,285,729,251,319,247,278,150,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(21725,21725,'Purgatory Invader Elite Soldier',0,'',0,'LineageMonster.bloody_queen',14.00,40.00,50,'female','L2RiftInvader',40,2245,830,52.14,2.14,40,43,30,21,20,10,3189,240,421,336,264,226,278,150,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(21726,21726,'Purgatory Invader Elite Soldier',0,'',0,'LineageMonster.bloody_queen',14.00,40.00,55,'female','L2RiftInvader',40,2643,987,61.62,2.45,40,43,30,21,20,10,3859,311,811,266,360,261,278,150,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(21727,21727,'Purgatory Invader Magus',0,'',0,'LineageMonster.banshee',9.00,23.00,53,'female','L2RiftInvader',40,2481,923,61.62,2.45,40,43,30,21,20,10,3465,272,602,258,319,247,278,0,333,3939,0,0,0,88,181,0,0,'LAST_HIT','false'),
(21728,21728,'Forbidden Path Invader Elite Soldier',0,'',0,'LineageMonster.doll_blader',6.00,12.00,60,'male','L2RiftInvader',40,3054,1150,30.81,2.45,40,43,30,21,20,10,5828,506,753,313,478,299,317,0,333,5129,5129,0,0,24,181,0,0,'LAST_HIT','false'),
(21729,21729,'Forbidden Path Invader Elite Soldier',0,'',0,'LineageMonster.doll_blader',6.00,12.00,65,'male','L2RiftInvader',40,3465,1319,35.55,2.78,40,43,30,21,20,10,7151,664,708,473,619,340,317,150,333,5129,5129,0,0,24,181,0,0,'LAST_HIT','false'),
(21730,21730,'Forbidden Path Invader Archer',0,'',0,'LineageMonster.skeleton_archer',11.00,27.00,63,'male','L2RiftInvader',500,3302,1251,35.55,2.78,40,43,30,21,20,10,5439,491,2920,254,560,323,249,150,333,284,0,0,0,44,181,1,0,'LAST_HIT','false'),
(21731,21731,'Forbidden Path Invader Elite Soldier',0,'',0,'LineageMonster.banshee',9.00,23.00,65,'female','L2RiftInvader',40,3465,1319,35.55,2.78,40,43,30,21,20,10,5952,553,1077,355,619,340,278,150,333,3939,0,0,0,88,181,0,0,'LAST_HIT','false'),
(21732,21732,'Forbidden Path Invader Shaman',0,'',0,'LineageMonster.banshee',9.00,23.00,63,'female','L2RiftInvader',40,3302,1251,35.55,2.78,40,43,30,21,20,10,6868,620,987,338,560,323,278,150,333,3939,0,0,0,88,181,0,0,'LAST_HIT','false'),
(21733,21733,'Forbidden Path Invader Priest',0,'',0,'LineageMonster.banshee',9.00,23.00,60,'female','L2RiftInvader',40,3054,1150,20.54,2.45,40,43,30,21,20,10,6045,525,860,313,478,299,278,0,333,3939,0,0,0,88,181,0,0,'LAST_HIT','false'),
(21734,21734,'Forbidden Path Invader Magus',0,'',0,'LineageMonster.banshee',9.00,23.00,65,'female','L2RiftInvader',40,3465,1319,35.55,2.78,40,43,30,21,20,10,4700,436,1433,267,619,340,278,150,333,3939,0,0,0,88,181,0,0,'LAST_HIT','false'),
(21735,21735,'Forbidden Path Invader Martyrs',0,'',0,'LineageMonster.banshee',9.00,23.00,60,'female','L2RiftInvader',40,3054,1150,30.81,2.45,40,43,30,21,20,10,4072,353,860,313,478,299,278,0,333,3939,0,0,0,88,181,0,0,'LAST_HIT','false'),
(21736,21736,'Forbidden Path Invader Warrior',0,'',0,'LineageMonster.skeleton_royal_guard',11.00,28.50,63,'male','L2RiftInvader',40,3302,1251,35.55,2.78,40,43,30,21,20,10,4415,398,864,398,560,323,317,150,333,946,946,0,0,88,181,1,0,'LAST_HIT','false'),
(21737,21737,'Forbidden Path Invader Soldier',0,'',0,'LineageMonster.doll_blader',6.00,12.00,60,'male','L2RiftInvader',40,3054,1150,30.81,2.45,40,43,30,21,20,10,4287,372,753,313,478,299,317,150,333,5129,5129,0,0,24,181,0,0,'LAST_HIT','false'),
(21738,21738,'Forbidden Path Invader Disciple',0,'',0,'LineageMonster.skeleton_royal_guard',11.00,28.50,63,'male','L2RiftInvader',40,3302,1251,35.55,2.78,40,43,30,21,20,10,4650,419,864,398,560,323,317,0,333,946,946,0,0,88,181,1,0,'LAST_HIT','false'),
(21739,21739,'Forbidden Path Invader Berserker',0,'',0,'LineageMonster.skeleton_royal_guard',11.00,28.50,65,'male','L2RiftInvader',40,3465,1319,35.55,2.78,40,43,30,21,20,10,6158,572,778,506,619,340,317,150,333,946,946,0,0,88,181,1,0,'LAST_HIT','false'),
(21740,21740,'Forbidden Path Invader Food',0,'',0,'LineageMonster.mimic',8.50,8.50,60,'male','L2Chest',40,3054,1150,10.27,2.45,40,43,30,21,20,10,5235,454,860,368,478,299,278,0,333,0,0,0,0,80,165,0,0,'LAST_HIT','false'),
(21741,21741,'Forbidden Path Invader Elite Soldier',0,'',0,'LineageMonster.bloody_queen',14.00,40.00,65,'female','L2RiftInvader',40,3465,1319,71.10,2.78,40,43,30,21,20,10,5515,512,1077,418,619,340,278,150,333,0,0,0,0,80,165,0,0,'LAST_HIT','false'),
(21742,21742,'Forbidden Path Invader Elite Soldier',0,'',0,'LineageMonster.bloody_queen',14.00,40.00,65,'female','L2RiftInvader',40,3465,1319,71.10,2.78,40,43,30,21,20,10,5620,522,1077,418,619,340,278,150,333,0,0,0,0,80,165,0,0,'LAST_HIT','false'),
(21743,21743,'Forbidden Path Invader Elite Soldier',0,'',0,'LineageMonster.bloody_queen',14.00,40.00,65,'female','L2RiftInvader',40,3465,1319,2.96,2.78,40,43,30,21,20,10,5259,488,1077,418,619,340,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(21744,21744,'Forbidden Path Invader Elite Soldier',0,'',0,'LineageMonster.bloody_queen',14.00,40.00,60,'female','L2RiftInvader',40,3054,1150,5.14,2.45,40,43,30,21,20,10,6220,540,860,368,478,299,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(21745,21745,'Forbidden Path Invader Warrior',0,'',0,'LineageMonster.skeleton_royal_guard',11.00,28.50,63,'male','L2RiftInvader',40,3302,1251,71.10,2.78,40,43,30,21,20,10,5294,478,864,398,560,323,317,150,333,946,946,0,0,88,181,1,0,'LAST_HIT','false'),
(21746,21746,'Forbidden Path Invader Elite Soldier',0,'',0,'LineageMonster.bloody_queen',14.00,40.00,60,'female','L2RiftInvader',40,3054,1150,61.62,2.45,40,43,30,21,20,10,4658,404,711,446,478,299,278,150,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(21747,21747,'Forbidden Path Invader Elite Soldier',0,'',0,'LineageMonster.bloody_queen',14.00,40.00,63,'female','L2RiftInvader',40,3302,1251,71.10,2.78,40,43,30,21,20,10,5136,463,1194,329,560,323,278,150,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(21748,21748,'Forbidden Path Invader Elite Soldier',0,'',0,'LineageMonster.bloody_queen',14.00,40.00,60,'female','L2RiftInvader',40,3054,1150,61.62,2.45,40,43,30,21,20,10,4592,398,711,446,478,299,278,150,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(21749,21749,'Forbidden Path Invader Elite Soldier',0,'',0,'LineageMonster.bloody_queen',14.00,40.00,65,'female','L2RiftInvader',40,3465,1319,71.10,2.78,40,43,30,21,20,10,5390,500,1303,346,619,340,278,150,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(21750,21750,'Forbidden Path Invader Magus',0,'',0,'LineageMonster.banshee',9.00,23.00,63,'female','L2RiftInvader',40,3302,1251,71.10,2.78,40,43,30,21,20,10,4897,442,987,338,560,323,278,0,333,3939,0,0,0,88,181,0,0,'LAST_HIT','false'),
(21751,21751,'Dark Omen Invader Soldier',0,'',0,'LineageMonster2.giant_zombie',13.00,40.00,70,'male','L2RiftInvader',40,3862,1493,35.55,2.78,40,43,30,21,20,10,7933,786,1314,470,780,382,278,0,333,0,0,0,0,22,181,1,0,'LAST_HIT','false'),
(21752,21752,'Dark Omen Invader Soldier',0,'',0,'LineageMonster2.giant_zombie',13.00,40.00,75,'male','L2RiftInvader',40,4229,1673,40.29,3.09,40,43,30,21,20,10,9521,1004,1175,696,957,425,278,150,333,0,0,0,0,22,181,1,0,'LAST_HIT','false'),
(21753,21753,'Dark Omen Invader Archer',0,'',0,'LineageMonster.skeleton_archer',11.00,27.00,73,'male','L2RiftInvader',500,4086,1601,40.29,3.09,40,43,30,21,20,10,7303,751,4327,320,885,407,249,150,333,288,0,0,0,44,181,1,0,'LAST_HIT','false'),
(21754,21754,'Dark Omen Invader Elite Soldier',0,'',0,'LineageMonster.doll_master',20.00,42.00,75,'male','L2RiftInvader',40,4229,1673,40.29,3.09,40,43,30,21,20,10,7925,836,1368,445,957,425,317,150,333,0,0,0,0,88,181,1,0,'LAST_HIT','false'),
(21755,21755,'Dark Omen Invader Shaman',0,'',0,'LineageMonster.doll_master',20.00,42.00,73,'male','L2RiftInvader',40,4086,1601,40.29,3.09,40,43,30,21,20,10,9222,949,1280,426,885,407,317,150,333,0,0,0,0,88,181,1,0,'LAST_HIT','false'),
(21756,21756,'Dark Omen Invader Priest',0,'',0,'LineageMonster.doll_master',20.00,42.00,70,'male','L2RiftInvader',40,3862,1493,23.70,2.78,40,43,30,21,20,10,8228,816,1150,399,780,382,317,0,333,0,0,0,0,88,181,1,0,'LAST_HIT','false'),
(21757,21757,'Dark Omen Invader Magus',0,'',0,'LineageMonster.doll_master',20.00,42.00,75,'male','L2RiftInvader',40,4229,1673,40.29,3.09,40,43,30,21,20,10,6258,660,1821,334,957,425,317,150,333,0,0,0,0,88,181,1,0,'LAST_HIT','false'),
(21758,21758,'Dark Omen Invader Martyrs',0,'',0,'LineageMonster.doll_master',20.00,42.00,70,'male','L2RiftInvader',40,3862,1493,35.55,2.78,40,43,30,21,20,10,5542,549,1150,399,780,382,317,0,333,0,0,0,0,88,181,1,0,'LAST_HIT','false'),
(21759,21759,'Dark Omen Invader Warrior',0,'',0,'LineageMonster2.imperial_warlord_zombie',7.00,30.00,73,'male','L2RiftInvader',40,4086,1601,40.29,3.09,40,43,30,21,20,10,5929,610,1463,502,885,407,278,150,333,134,6721,0,0,42,181,1,0,'LAST_HIT','false'),
(21760,21760,'Dark Omen Invader Soldier',0,'',0,'LineageMonster2.giant_zombie',13.00,40.00,70,'male','L2RiftInvader',40,3862,1493,35.55,2.78,40,43,30,21,20,10,5835,578,1314,470,780,382,278,150,333,0,0,0,0,22,181,1,0,'LAST_HIT','false'),
(21761,21761,'Dark Omen Invader Disciple',0,'',0,'LineageMonster2.imperial_warlord_zombie',7.00,30.00,73,'male','L2RiftInvader',40,4086,1601,40.29,3.09,40,43,30,21,20,10,6243,642,1463,502,885,407,278,0,333,134,6721,0,0,42,181,1,0,'LAST_HIT','false'),
(21762,21762,'Dark Omen Invader Berserker',0,'',0,'LineageMonster2.imperial_warlord_zombie',7.00,30.00,75,'male','L2RiftInvader',40,4229,1673,40.29,3.09,40,43,30,21,20,10,8198,864,1292,633,957,425,278,150,333,134,6721,0,0,42,181,1,0,'LAST_HIT','false'),
(21763,21763,'Dark Omen Invader Food',0,'',0,'LineageMonster.mimic',8.50,8.50,70,'male','L2Chest',40,3862,1493,11.85,2.78,40,43,30,21,20,10,7126,707,1314,470,780,382,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(21764,21764,'Dark Omen Invader Elite Soldier',0,'',0,'LineageMonster.death_blader',15.00,45.00,75,'male','L2RiftInvader',40,4229,1673,80.58,3.09,40,43,30,21,20,10,7343,774,1563,523,957,425,278,150,333,1472,0,0,0,110,181,1,0,'LAST_HIT','false'),
(21765,21765,'Dark Omen Invader Elite Soldier',0,'',0,'LineageMonster.death_blader',15.00,45.00,75,'male','L2RiftInvader',40,4229,1673,80.58,3.09,40,43,30,21,20,10,7482,789,1563,523,957,425,278,150,333,1472,0,0,0,110,181,1,0,'LAST_HIT','false'),
(21766,21766,'Dark Omen Invader Elite Soldier',0,'',0,'LineageMonster.death_blader',15.00,45.00,75,'male','L2RiftInvader',40,4229,1673,3.36,3.09,40,43,30,21,20,10,7002,740,1563,523,957,425,278,0,333,1472,0,0,0,110,181,1,0,'LAST_HIT','false'),
(21767,21767,'Dark Omen Invader Elite Soldier',0,'',0,'LineageMonster.death_blader',15.00,45.00,70,'male','L2RiftInvader',40,3862,1493,5.93,2.78,40,43,30,21,20,10,8466,840,1314,470,780,382,278,0,333,1472,0,0,0,110,181,1,0,'LAST_HIT','false'),
(21768,21768,'Dark Omen Invader Warrior',0,'',0,'LineageMonster2.imperial_warlord_zombie',7.00,30.00,73,'male','L2RiftInvader',40,4086,1601,80.58,3.09,40,43,30,21,20,10,7108,731,1463,502,885,407,278,150,333,134,6721,0,0,42,181,1,0,'LAST_HIT','false'),
(21769,21769,'Dark Omen Invader Elite Soldier',0,'',0,'LineageMonster.death_blader',15.00,45.00,70,'male','L2RiftInvader',40,3862,1493,71.10,2.78,40,43,30,21,20,10,6341,628,1086,569,780,382,278,150,333,1472,0,0,0,110,181,1,0,'LAST_HIT','false'),
(21770,21770,'Dark Omen Invader Elite Soldier',0,'',0,'LineageMonster.death_blader',15.00,45.00,73,'male','L2RiftInvader',40,4086,1601,80.58,3.09,40,43,30,21,20,10,6896,709,1770,415,885,407,278,150,333,1472,0,0,0,110,181,1,0,'LAST_HIT','false'),
(21771,21771,'Dark Omen Invader Elite Soldier',0,'',0,'LineageMonster.death_blader',15.00,45.00,70,'male','L2RiftInvader',40,3862,1493,71.10,2.78,40,43,30,21,20,10,6251,619,1086,569,780,382,278,150,333,1472,0,0,0,110,181,1,0,'LAST_HIT','false'),
(21772,21772,'Dark Omen Invader Elite Soldier',0,'',0,'LineageMonster.death_blader',15.00,45.00,75,'male','L2RiftInvader',40,4229,1673,80.58,3.09,40,43,30,21,20,10,7176,757,1892,432,957,425,278,150,333,1472,0,0,0,110,181,1,0,'LAST_HIT','false'),
(21773,21773,'Dark Omen Invader Magus',0,'',0,'LineageMonster.doll_master',20.00,42.00,73,'male','L2RiftInvader',40,4086,1601,80.58,3.09,40,43,30,21,20,10,6575,676,1280,426,885,407,317,0,333,0,0,0,0,88,181,1,0,'LAST_HIT','false'),
(21774,21774,'Messenger Invader Soldier',0,'',0,'LineageMonster2.giant_zombie',13.00,40.00,78,'male','L2RiftInvader',40,4550,1859,40.29,3.09,40,43,30,21,20,10,10362,1163,1814,576,1144,468,278,0,333,0,0,0,0,22,181,1,0,'LAST_HIT','false'),
(21775,21775,'Messenger Invader Soldier',0,'',0,'LineageMonster2.giant_zombie',13.00,40.00,78,'male','L2RiftInvader',40,4813,2049,40.29,3.09,40,43,30,21,20,10,12230,1455,1542,837,1333,511,278,150,333,0,0,0,0,22,181,1,0,'LAST_HIT','false'),
(21776,21776,'Messenger Invader Archer',0,'',0,'LineageMonster.skeleton_archer',11.00,27.00,78,'male','L2RiftInvader',500,4716,1972,40.29,3.09,40,43,30,21,20,10,9442,1097,5796,388,1258,494,249,150,333,289,0,0,0,44,181,1,0,'LAST_HIT','false'),
(21777,21777,'Messenger Invader Elite Soldier',0,'',0,'LineageMonster.doll_master',20.00,42.00,78,'male','L2RiftInvader',40,4813,2049,40.29,3.09,40,43,30,21,20,10,10179,1211,1796,535,1333,511,317,150,333,0,0,0,0,88,181,1,0,'LAST_HIT','false'),
(21778,21778,'Messenger Invader Shaman',0,'',0,'LineageMonster.doll_master',20.00,42.00,78,'male','L2RiftInvader',40,4716,1972,40.29,3.09,40,43,30,21,20,10,11921,1386,1714,517,1258,494,317,150,333,0,0,0,0,88,181,1,0,'LAST_HIT','false'),
(21779,21779,'Messenger Invader Priest',0,'',0,'LineageMonster.doll_master',20.00,42.00,78,'male','L2RiftInvader',40,4550,1859,26.86,3.09,40,43,30,21,20,10,10747,1206,1587,490,1144,468,317,0,333,0,0,0,0,88,181,1,0,'LAST_HIT','false'),
(21780,21780,'Messenger Invader Magus',0,'',0,'LineageMonster.doll_master',20.00,42.00,78,'male','L2RiftInvader',40,4813,2049,40.29,3.09,40,43,30,21,20,10,8038,957,2390,402,1333,511,317,150,333,0,0,0,0,88,181,1,0,'LAST_HIT','false'),
(21781,21781,'Messenger Invader Martyrs',0,'',0,'LineageMonster.doll_master',20.00,42.00,78,'male','L2RiftInvader',40,4550,1859,40.29,3.09,40,43,30,21,20,10,7239,812,1587,490,1144,468,317,0,333,0,0,0,0,88,181,1,0,'LAST_HIT','false'),
(21782,21782,'Messenger Invader Warrior',0,'',0,'LineageMonster2.imperial_warlord_zombie',7.00,30.00,78,'male','L2RiftInvader',40,4716,1972,40.29,3.09,40,43,30,21,20,10,7664,891,1959,608,1258,494,278,150,333,134,6721,0,0,42,181,1,0,'LAST_HIT','false'),
(21783,21783,'Messenger Invader Soldier',0,'',0,'LineageMonster2.giant_zombie',13.00,40.00,78,'male','L2RiftInvader',40,4550,1859,40.29,3.09,40,43,30,21,20,10,7621,855,1814,576,1144,468,278,150,333,0,0,0,0,22,181,1,0,'LAST_HIT','false'),
(21784,21784,'Messenger Invader Disciple',0,'',0,'LineageMonster2.imperial_warlord_zombie',7.00,30.00,78,'male','L2RiftInvader',40,4716,1972,40.29,3.09,40,43,30,21,20,10,8071,938,1959,608,1258,494,278,0,333,134,6721,0,0,42,181,1,0,'LAST_HIT','false'),
(21785,21785,'Messenger Invader Berserker',0,'',0,'LineageMonster2.imperial_warlord_zombie',7.00,30.00,78,'male','L2RiftInvader',40,4813,2049,40.29,3.09,40,43,30,21,20,10,10530,1253,1696,761,1333,511,278,150,333,134,6721,0,0,42,181,1,0,'LAST_HIT','false'),
(21786,21786,'Messenger Invader Food',0,'',0,'LineageMonster.mimic',8.50,8.50,78,'male','L2Chest',40,4550,1859,13.43,3.09,40,43,30,21,20,10,9308,1045,1814,576,1144,468,278,0,333,0,0,0,0,80,165,0,0,'LAST_HIT','false'),
(21787,21787,'Messenger Invader Elite Soldier',0,'',0,'LineageMonster.death_lord',21.00,40.00,78,'male','L2RiftInvader',40,4813,2049,80.58,3.09,40,43,30,21,20,10,9432,1122,2052,629,1333,511,278,150,333,78,0,0,0,40,165,1,0,'LAST_HIT','false'),
(21788,21788,'Messenger Invader Elite Soldier',0,'',0,'LineageMonster.death_lord',21.00,40.00,78,'male','L2RiftInvader',40,4813,2049,80.58,3.09,40,43,30,21,20,10,9610,1144,2052,629,1333,511,278,150,333,78,0,0,0,40,165,1,0,'LAST_HIT','false'),
(21789,21789,'Messenger Invader Elite Soldier',0,'',0,'LineageMonster.death_lord',21.00,40.00,78,'male','L2RiftInvader',40,4813,2049,3.36,3.09,40,43,30,21,20,10,8994,1072,2052,629,1333,511,278,0,333,78,0,0,0,44,181,1,0,'LAST_HIT','false'),
(21790,21790,'Messenger Invader Elite Soldier',0,'',0,'LineageMonster.death_lord',21.00,40.00,78,'male','L2RiftInvader',40,4550,1859,6.72,3.09,40,43,30,21,20,10,11058,1242,1814,576,1144,468,278,0,333,78,0,0,0,44,181,1,0,'LAST_HIT','false'),
(21791,21791,'Messenger Invader Warrior',0,'',0,'LineageMonster2.imperial_warlord_zombie',7.00,30.00,78,'male','L2RiftInvader',40,4716,1972,80.58,3.09,40,43,30,21,20,10,9189,1068,1959,608,1258,494,278,150,333,134,6721,0,0,42,181,1,0,'LAST_HIT','false'),
(21792,21792,'Messenger Invader Elite Soldier',0,'',0,'LineageMonster.death_lord',21.00,40.00,78,'male','L2RiftInvader',40,4550,1859,80.58,3.09,40,43,30,21,20,10,8282,929,1499,698,1144,468,278,150,333,78,0,0,0,44,181,1,0,'LAST_HIT','false'),
(21793,21793,'Messenger Invader Elite Soldier',0,'',0,'LineageMonster.death_lord',21.00,40.00,78,'male','L2RiftInvader',40,4716,1972,80.58,3.09,40,43,30,21,20,10,8915,1036,2371,503,1258,494,278,150,333,78,0,0,0,44,181,1,0,'LAST_HIT','false'),
(21794,21794,'Messenger Invader Elite Soldier',0,'',0,'LineageMonster.death_lord',21.00,40.00,78,'male','L2RiftInvader',40,4550,1859,80.58,3.09,40,43,30,21,20,10,8165,916,1499,698,1144,468,278,150,333,78,0,0,0,44,181,1,0,'LAST_HIT','false'),
(21795,21795,'Messenger Invader Elite Soldier',0,'',0,'LineageMonster.death_lord',21.00,40.00,78,'male','L2RiftInvader',40,4813,2049,80.58,3.09,40,43,30,21,20,10,9217,1097,2483,520,1333,511,278,150,333,78,0,0,0,44,181,1,0,'LAST_HIT','false'),
(21796,21796,'Messenger Invader Magus',0,'',0,'LineageMonster.doll_master',20.00,42.00,78,'male','L2RiftInvader',40,4716,1972,80.58,3.09,40,43,30,21,20,10,8499,988,1714,517,1258,494,317,0,333,0,0,0,0,88,181,1,0,'LAST_HIT','false'),
(21797,21797,'Spirit of Timiniel',0,'',0,'LineageMonster.pixy',5.00,25.00,55,'female','L2Monster',40,2643,987,5.14,2.45,40,43,30,21,20,10,3959,320,554,331,360,261,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(21798,21798,'Ghost of a Gatekeeper',0,'',0,'LineageMonster.skeleton_knight',10.00,25.00,76,'male','L2Monster',40,4297,1710,26.86,3.09,40,43,30,21,20,10,7104,759,1614,534,994,433,278,0,333,150,103,0,0,40,165,1,0,'LAST_HIT','false'),
(21799,21799,'Ghost of a Gatekeeper',0,'',0,'LineageMonster.skeleton_knight',10.00,25.00,76,'male','L2Monster',40,4297,1710,40.29,3.09,40,43,30,21,20,10,8710,931,1614,534,994,433,278,0,432,150,103,0,0,40,165,1,0,'LAST_HIT','false'),
(21800,21800,'Vassal Ghost',0,'',0,'LineageMonster.zombie',13.00,21.00,77,'male','L2Monster',40,4364,1747,26.86,3.09,40,43,30,21,20,10,6616,716,1664,544,1031,442,278,0,333,0,0,0,0,15,15,1,0,'LAST_HIT','false'),
(21801,21801,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,21,'male','L2Chest',40,575,227,5.53,1.53,40,43,30,21,20,10,630,29,63,98,25,80,278,0,333,0,0,0,0,80,165,0,0,'LAST_HIT','false'),
(21802,21802,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,24,'male','L2Chest',40,687,272,5.53,1.53,40,43,30,21,20,10,771,38,81,111,34,90,278,0,333,0,0,0,0,80,165,0,0,'LAST_HIT','false'),
(21803,21803,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,27,'male','L2Chest',40,813,318,5.53,1.53,40,43,30,21,20,10,918,47,104,125,45,102,278,0,333,0,0,0,0,80,165,0,0,'LAST_HIT','false'),
(21804,21804,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,30,'male','L2Chest',40,954,365,5.53,1.53,40,43,30,21,20,10,1080,59,132,140,58,114,278,0,333,0,0,0,0,80,165,0,0,'LAST_HIT','false'),
(21805,21805,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,33,'male','L2Chest',40,1109,413,7.11,1.84,40,43,30,21,20,10,1306,75,166,157,75,128,278,0,333,0,0,0,0,80,165,0,0,'LAST_HIT','false'),
(21806,21806,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,36,'male','L2Chest',40,1279,463,7.11,1.84,40,43,30,21,20,10,1555,94,206,175,96,142,278,0,333,0,0,0,0,80,165,0,0,'LAST_HIT','false'),
(21807,21807,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,39,'male','L2Chest',40,1462,514,7.11,1.84,40,43,30,21,20,10,1825,116,255,195,121,158,278,0,333,0,0,0,0,80,165,0,0,'LAST_HIT','false'),
(21808,21808,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,42,'male','L2Chest',40,1660,589,8.69,2.14,40,43,30,21,20,10,2116,141,311,215,152,175,278,0,333,0,0,0,0,80,165,0,0,'LAST_HIT','false'),
(21809,21809,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,45,'male','L2Chest',40,1870,677,8.69,2.14,40,43,30,21,20,10,2430,169,377,238,188,193,278,0,333,0,0,0,0,80,165,0,0,'LAST_HIT','false'),
(21810,21810,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,48,'male','L2Chest',40,2091,768,8.69,2.14,40,43,30,21,20,10,2764,202,453,261,231,212,278,0,333,0,0,0,0,80,165,0,0,'LAST_HIT','false'),
(21811,21811,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,51,'male','L2Chest',40,2323,861,10.27,2.45,40,43,30,21,20,10,3121,238,539,286,281,232,278,0,333,0,0,0,0,80,165,0,0,'LAST_HIT','false'),
(21812,21812,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,54,'male','L2Chest',40,2562,955,10.27,2.45,40,43,30,21,20,10,3499,279,636,313,339,254,278,0,333,0,0,0,0,80,165,0,0,'LAST_HIT','false'),
(21813,21813,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,57,'male','L2Chest',40,2806,1052,10.27,2.45,40,43,30,21,20,10,3898,324,743,340,405,276,278,0,333,0,0,0,0,80,165,0,0,'LAST_HIT','false'),
(21814,21814,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,60,'male','L2Chest',40,3054,1150,10.27,2.45,40,43,30,21,20,10,4320,375,860,368,478,299,278,0,333,0,0,0,0,80,165,0,0,'LAST_HIT','false'),
(21815,21815,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,63,'male','L2Chest',40,3302,1251,11.85,2.78,40,43,30,21,20,10,4762,430,987,398,560,323,278,0,333,0,0,0,0,80,165,0,0,'LAST_HIT','false'),
(21816,21816,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,66,'male','L2Chest',40,3546,1353,11.85,2.78,40,43,30,21,20,10,5227,492,1123,428,649,348,278,0,333,0,0,0,0,80,165,0,0,'LAST_HIT','false'),
(21817,21817,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,69,'male','L2Chest',40,3784,1458,11.85,2.78,40,43,30,21,20,10,5713,559,1265,460,746,373,278,0,333,0,0,0,0,80,165,0,0,'LAST_HIT','false'),
(21818,21818,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,72,'male','L2Chest',40,4013,1565,13.43,3.09,40,43,30,21,20,10,6220,632,1413,491,849,399,278,0,333,0,0,0,0,80,165,0,0,'LAST_HIT','false'),
(21819,21819,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,75,'male','L2Chest',40,4229,1673,13.43,3.09,40,43,30,21,20,10,6750,712,1563,523,957,425,278,0,333,0,0,0,0,88,181,0,0,'LAST_HIT','false'),
(21820,21820,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,78,'male','L2Chest',40,4428,1784,13.43,3.09,40,43,30,21,20,10,7300,799,1715,555,1069,451,278,0,333,0,0,0,0,80,165,0,0,'LAST_HIT','false'),
(21821,21821,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,81,'male','L2Chest',40,4608,1896,13.43,3.09,40,43,30,21,20,10,7873,894,1863,587,1182,477,278,0,333,0,0,0,0,80,165,0,0,'LAST_HIT','false'),
(21822,21822,'Treasure Chest',0,'',0,'LineageMonster.mimic',8.50,8.50,84,'male','L2Chest',40,4766,2011,13.43,3.09,40,43,30,21,20,10,8467,996,2006,619,1296,502,278,0,333,0,0,0,0,80,165,0,0,'LAST_HIT','false'),
(21823,21823,'Executor of Sacrificial Offerings',0,'',0,'LineageMonster2.imperial_warlord_zombie',7.00,30.00,78,'male','L2Minion',40,4550,1859,80.58,3.09,40,43,30,21,20,10,12042,1351,1814,576,1144,468,278,0,333,134,6721,0,0,42,209,1,0,'LAST_HIT','false'),
(21824,21824,'Alpen Kookaburra',0,'',0,'LineageMonster2.rough_ostrich',20.00,31.00,65,'male','L2FeedableBeast',80,13862,9999,13.43,3.09,40,43,30,21,20,10,0,0,1392,5000,746,6000,300,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(21825,21825,'Alpen Kookaburra',0,'',0,'LineageMonster2.rough_ostrich',20.00,31.00,65,'male','L2FeedableBeast',80,13862,9999,13.43,3.09,40,43,30,21,20,10,0,0,1392,5000,746,6000,300,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(21826,21826,'Alpen Buffalo',0,'',0,'LineageMonster2.buffalo',20.00,31.00,67,'male','L2FeedableBeast',80,14507,9999,13.43,3.09,40,43,30,21,20,10,0,0,1392,5000,746,6000,300,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(21827,21827,'Alpen Buffalo',0,'',0,'LineageMonster2.buffalo',20.00,31.00,67,'male','L2FeedableBeast',80,14507,9999,13.43,3.09,40,43,30,21,20,10,0,0,1392,5000,746,6000,300,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(21828,21828,'Alpen Cougar',0,'',0,'LineageMonster.saber_toothed_tiger',20.00,31.00,69,'male','L2FeedableBeast',80,15139,9999,13.43,3.09,40,43,30,21,20,10,0,0,1392,5000,746,6000,300,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(21829,21829,'Alpen Cougar',0,'',0,'LineageMonster.saber_toothed_tiger',20.00,31.00,69,'male','L2FeedableBeast',80,15139,9999,13.43,3.09,40,43,30,21,20,10,0,0,1392,5000,746,6000,300,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(22001,22001,'Grim Wolf',0,'',0,'LineageMonster.dire_wolf',13.00,11.00,25,'male','L2Monster',80,728,316,5.53,1.53,40,43,30,21,20,10,876,43,99,112,37,94,278,0,333,0,0,0,0,24,130,0,0,'LAST_HIT','true'),
(22002,22002,'Grim Grizzly',0,'',0,'LineageMonster.grizzly',21.00,40.00,26,'male','L2Monster',80,770,333,5.53,1.53,40,43,30,21,20,10,933,47,115,114,41,98,278,0,333,0,0,0,0,40,110,0,0,'LAST_HIT','true'),
(22003,22003,'Grave Robber Scout',0,'',0,'LineageNPC.e_traderB_Fdwarf_mon',7.00,18.00,27,'female','L2Monster',80,813,350,5.53,1.53,40,43,30,21,20,10,1162,59,113,119,45,102,247,0,333,8527,0,0,0,49,110,1,0,'LAST_HIT','true'),
(22004,22004,'Grave Robber Lookout',0,'',0,'LineageMonster.dwarf_ghost',9.00,16.50,27,'male','L2Monster',80,813,350,5.53,1.53,40,43,30,21,20,10,1382,69,113,119,45,102,278,0,333,0,0,0,0,80,120,1,0,'LAST_HIT','true'),
(22005,22005,'Grave Robber Ranger',0,'',0,'LineageNPC.e_collector_teacher_Fdwarf_mon',8.00,17.50,28,'male','L2Monster',80,859,367,5.53,1.53,40,43,30,21,20,10,1230,63,133,130,49,106,317,0,333,8529,0,0,0,45,110,1,0,'LAST_HIT','true'),
(22006,22006,'Grave Robber Guard',0,'',0,'LineageNPC.e_collector_teacher_Mdwarf_mon',8.00,17.50,29,'male','L2Monster',80,906,384,5.53,1.53,40,43,30,21,20,10,1298,68,146,137,53,110,278,0,333,8528,0,0,0,36,110,1,0,'LAST_HIT','true'),
(22007,22007,'Ghost of a Soldier',0,'',0,'LineageMonster.orc',10.00,21.00,29,'male','L2Monster',80,906,384,5.53,1.53,40,43,30,21,20,10,1415,75,146,137,53,110,278,0,333,8530,0,0,0,45,120,1,0,'LAST_HIT','false'),
(22008,22008,'Grave Robber Fighter',0,'',0,'LineageNPC.e_collector_teacher_Mdwarf_mon',8.00,17.50,30,'male','L2Monster',80,954,402,5.53,1.53,40,43,30,21,20,10,1367,74,130,137,58,114,278,0,333,8528,0,0,0,36,110,1,0,'LAST_HIT','true'),
(22009,22009,'Ghost of a Loyal Vassal',0,'',0,'LineageMonster.orc_shaman',9.00,22.00,31,'male','L2Monster',80,1004,419,7.11,1.84,40,43,30,21,20,10,1591,88,140,146,64,118,278,0,333,8532,0,0,0,45,120,1,0,'LAST_HIT','false'),
(22010,22010,'Ghost of a General',0,'',0,'LineageMonster.orc_fighter',12.00,22.00,32,'male','L2Monster',80,1056,437,7.11,1.84,40,43,30,21,20,10,1695,95,185,147,69,123,278,500,333,8532,0,0,0,45,120,1,0,'LAST_HIT','false'),
(22011,22011,'Ghost of a Batur Chief',0,'',0,'LineageMonster.orc_champion',10.00,23.00,33,'male','L2Monster',80,1109,455,7.11,1.84,40,43,30,21,20,10,1947,111,191,149,75,128,278,500,333,8533,0,0,0,45,130,1,0,'LAST_HIT','false'),
(22012,22012,'Ghost of a Batur Chief',0,'',0,'LineageMonster.orc_champion',10.00,23.00,33,'male','L2Monster',80,1109,455,7.11,1.84,40,43,30,21,20,10,1515,87,191,149,75,128,278,500,333,8533,0,0,0,45,130,1,0,'LAST_HIT','false'),
(22013,22013,'Ghost of a Morek Chief',0,'',0,'LineageMonster.orc_champion',10.00,23.00,33,'male','L2Monster',80,1109,455,7.11,1.84,40,43,30,21,20,10,1515,87,191,149,75,128,278,500,333,8533,0,0,0,45,130,1,0,'LAST_HIT','false'),
(22014,22014,'Ghost of a Morek Chief',0,'',0,'LineageMonster.orc_champion',10.00,23.00,33,'male','L2Monster',80,1109,455,7.11,1.84,40,43,30,21,20,10,1515,87,191,149,75,128,278,500,333,8533,0,0,0,45,130,1,0,'LAST_HIT','false'),
(22015,22015,'Ghost of a Turka Chief',0,'',0,'LineageMonster.orc_champion',10.00,23.00,33,'male','L2Monster',80,1109,455,7.11,1.84,40,43,30,21,20,10,1515,87,191,149,75,128,278,500,333,8533,0,0,0,45,130,1,0,'LAST_HIT','false'),
(22016,22016,'Ghost of a Turka Chief',0,'',0,'LineageMonster.orc_champion',10.00,23.00,33,'male','L2Monster',80,1109,455,7.11,1.84,40,43,30,21,20,10,1515,87,191,149,75,128,278,500,333,8533,0,0,0,45,130,1,0,'LAST_HIT','false'),
(22017,22017,'Bandit Sweeper',0,'',0,'LineageMonster2.northern_goblin',4.00,15.00,30,'male','L2Monster',80,954,402,5.53,1.53,40,43,30,21,20,10,1281,70,130,137,58,114,278,500,333,0,0,0,0,88,132,0,0,'LAST_HIT','true'),
(22018,22018,'Bandit Hound',0,'',0,'LineageMonster.dire_wolf',13.00,11.00,31,'male','L2Monster',80,1005,419,7.11,1.84,40,43,30,21,20,10,1404,78,140,146,64,118,278,500,333,0,0,0,0,88,132,0,0,'LAST_HIT','true'),
(22019,22019,'Bandit Watchman',0,'',0,'LineageMonster.ol_mahum_archer_04te',20.00,23.00,32,'male','L2Monster',80,1056,437,7.11,1.84,40,43,30,21,20,10,1449,81,185,147,69,123,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','true'),
(22020,22020,'Snow Lynx',0,'',0,'LineageMonster.onyx_beast',14.00,14.50,33,'male','L2Monster',80,1109,455,7.11,1.84,40,43,30,21,20,10,1515,87,191,149,75,128,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','true'),
(22021,22021,'Bandit Undertaker',0,'',0,'LineageMonster2.northern_goblin_110p',20.00,23.00,34,'male','L2Monster',80,1164,473,7.11,1.84,40,43,30,21,20,10,1593,93,203,150,82,132,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','true'),
(22022,22022,'Bandit Assassin',0,'',0,'LineageMonster.wererat_01te',20.00,23.00,35,'male','L2Monster',80,1221,491,7.11,1.84,40,43,30,21,20,10,1735,103,199,161,89,137,278,500,333,0,0,0,0,88,132,0,0,'LAST_HIT','true'),
(22023,22023,'Bandit Warrior',0,'',0,'LineageMonster.ol_mahum_04te',20.00,23.00,36,'male','L2Monster',80,1279,509,7.11,1.84,40,43,30,21,20,10,1899,115,262,172,96,142,278,500,333,0,0,0,0,88,132,0,0,'LAST_HIT','true'),
(22024,22024,'Bandit Inspector',0,'',0,'LineageMonster2.northern_goblin_120p',4.00,15.00,37,'male','L2Monster',80,1339,528,7.11,1.84,40,43,30,21,20,10,1855,114,251,158,104,147,278,500,333,0,0,0,0,88,132,0,0,'LAST_HIT','true'),
(22025,22025,'Frozen Wasteland Werewolf',0,'',0,'LineageMonster.werewolf',10.00,26.00,38,'male','L2Monster',80,1400,547,7.11,1.84,40,43,30,21,20,10,3048,190,258,177,112,153,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','true'),
(22026,22026,'Bandit Captain',0,'',0,'LineageMonster.ol_mahum_champion_04te',20.00,23.00,40,'male','L2Monster',80,1527,584,7.11,1.84,40,43,30,21,20,10,2537,164,273,195,131,164,278,500,333,69,19,0,0,88,132,0,0,'LAST_HIT','true'),
(22027,22027,'Forgotten Crewman',0,'',0,'LineageMonster.dwarf_ghost',9.00,16.50,39,'male','L2Minion',80,1463,565,7.11,1.84,40,43,30,21,20,10,2639,168,313,175,121,158,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(22028,22028,'Vagabond of the Ruins',0,'',0,'LineageNPC.a_mageguild_teacher_Mhuman_mon',20.00,23.00,40,'male','L2Monster',80,1527,584,7.11,1.84,40,43,30,21,20,10,2537,164,273,195,131,164,278,500,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(22029,22029,'Ragna Orc',0,'',0,'LineageMonster.batur_orc_03te',9.00,21.50,40,'male','L2Monster',80,1527,584,7.11,1.84,40,43,30,21,20,10,2537,164,273,195,131,164,278,0,333,2,0,0,0,80,140,0,0,'LAST_HIT','false'),
(22030,22030,'Ragna Orc Shaman',0,'',0,'LineageMonster.batur_orc_shaman_a_03te',11.00,16.00,42,'male','L2Monster',80,1660,648,8.69,2.14,40,43,30,21,20,10,3151,209,367,202,152,175,278,0,333,159,0,0,0,50,140,0,0,'LAST_HIT','false'),
(22031,22031,'Ragna Orc Archer',0,'',0,'LineageMonster.batur_orc_archer_03te',11.00,21.50,43,'male','L2Monster',80,1728,680,8.69,2.14,40,43,30,21,20,10,2915,197,363,214,163,181,247,0,333,13,0,0,0,45,130,0,0,'LAST_HIT','true'),
(22032,22032,'Ragna Orc Warrior',0,'',0,'LineageMonster.batur_orc_warrior_03te',10.00,20.00,44,'male','L2Monster',40,1799,712,8.69,2.14,40,43,30,21,20,10,3649,249,465,217,176,187,278,500,333,68,0,0,0,80,140,0,0,'LAST_HIT','false'),
(22033,22033,'Ragna Orc Mage',0,'',0,'LineageMonster.batur_orc_shaman_a_01te',11.00,16.00,45,'male','L2Monster',80,1870,745,8.69,2.14,40,43,30,21,20,10,4687,325,391,227,188,193,278,0,333,179,0,0,0,50,140,0,0,'LAST_HIT','true'),
(22034,22034,'Ragna Orc Mage',0,'',0,'LineageMonster.batur_orc_shaman_a_01te',17.00,17.00,45,'male','L2Monster',80,1870,745,8.69,2.14,40,43,30,21,20,10,4687,325,391,227,188,193,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','true'),
(22035,22035,'Ragna Orc Mage',0,'',0,'LineageMonster.batur_orc_shaman_a_01te',17.00,17.00,45,'male','L2Monster',80,1870,745,8.69,2.14,40,43,30,21,20,10,4687,325,391,227,188,193,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','true'),
(22036,22036,'Ragna Orc Mage',0,'',0,'LineageMonster.batur_orc_shaman_a_01te',17.00,17.00,45,'male','L2Monster',80,1870,745,8.69,2.14,40,43,30,21,20,10,4687,325,391,227,188,193,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','true'),
(22037,22037,'Ragna Orc Healer',0,'',0,'LineageMonster.batur_orc_shaman_a_03te',20.00,23.00,45,'male','L2Monster',80,1870,745,8.69,2.14,40,43,30,21,20,10,2943,205,391,227,188,193,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(22038,22038,'Ragna Orc Hero',0,'',0,'LineageMonster.batur_orc_overlord_03te',12.00,24.00,48,'male','L2Monster',80,2091,845,8.69,2.14,40,43,30,21,20,10,4343,317,575,238,231,212,278,500,333,74,0,0,0,80,140,0,0,'LAST_HIT','false'),
(22039,22039,'Ragna Orc Commander',0,'',0,'LineageMonster.batur_orc_overlord_01te',12.00,24.00,49,'male','L2Monster',80,2168,878,8.69,2.14,40,43,30,21,20,10,3659,270,490,267,247,219,278,500,333,135,0,0,0,80,140,0,0,'LAST_HIT','false'),
(22040,22040,'Ragna Orc Sniper',0,'',0,'LineageMonster.batur_orc_archer_01te',11.00,21.50,47,'male','L2Monster',500,2016,811,8.69,2.14,40,43,30,21,20,10,3311,237,512,241,216,206,247,0,333,275,0,0,0,45,140,0,0,'LAST_HIT','true'),
(22041,22041,'Ragna Orc Sorcerer',0,'',0,'LineageMonster.batur_orc_shaman_a_01te',11.00,16.00,50,'male','L2Monster',80,2245,912,8.69,2.14,40,43,30,21,20,10,3629,273,509,273,264,226,278,0,333,7,0,0,0,50,140,0,0,'LAST_HIT','true'),
(22042,22042,'Ragna Orc Sorcerer',0,'',0,'LineageMonster.batur_orc_shaman_a_01te',11.00,16.00,50,'male','L2Monster',80,2245,912,8.69,2.14,40,43,30,21,20,10,3629,273,509,273,264,226,278,0,333,7,0,0,0,50,140,0,0,'LAST_HIT','true'),
(22043,22043,'Ragna Orc Sorcerer',0,'',0,'LineageMonster.batur_orc_shaman_a_01te',11.00,16.00,50,'male','L2Monster',80,2245,912,8.69,2.14,40,43,30,21,20,10,3629,273,509,273,264,226,278,0,333,7,0,0,0,50,140,0,0,'LAST_HIT','true'),
(22044,22044,'Ragna Orc Sorcerer',0,'',0,'LineageMonster.batur_orc_shaman_a_01te',11.00,16.00,50,'male','L2Monster',80,2245,912,8.69,2.14,40,43,30,21,20,10,3629,273,509,273,264,226,278,0,333,7,0,0,0,50,140,0,0,'LAST_HIT','true'),
(22045,22045,'Dark Corpse',0,'',0,'LineageMonster.zombie_02te',20.00,22.00,40,'male','L2Monster',80,1526,584,7.11,1.84,40,43,30,21,20,10,2592,160,273,195,131,164,278,0,333,0,0,0,0,40,40,1,0,'LAST_HIT','true'),
(22046,22046,'Varangka\'s Dre Vanul',0,'',0,'LineageMonster.dre_vanul',14.00,36.00,46,'male','L2Monster',80,1942,778,8.69,2.14,40,43,30,21,20,10,2864,194,431,246,202,199,317,0,333,0,0,0,0,80,100,0,0,'LAST_HIT','true'),
(22047,22047,'Guardian of the Ghost Town',0,'',0,'LineageMonster.monster_eye_05te',21.00,43.00,44,'male','L2Monster',80,1798,712,8.69,2.14,40,43,30,21,20,10,2496,164,465,217,176,187,278,0,333,0,0,0,0,90,100,0,0,'LAST_HIT','true'),
(22048,22048,'Dark Spider',0,'',0,'LineageMonster.giant_spider_04te',26.00,25.50,42,'male','L2Monster',80,1660,648,8.69,2.14,40,43,30,21,20,10,2388,152,367,202,152,175,317,0,333,0,0,0,0,72,150,0,0,'LAST_HIT','true'),
(22049,22049,'Varangka\'s Succubus',0,'',0,'LineageMonster.succubus_05te',10.00,36.00,49,'male','L2Monster',80,2168,878,8.69,2.14,40,43,30,21,20,10,3250,330,490,267,247,219,317,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','true'),
(22050,22050,'Probe Golem Prodigy IV',0,'',0,'LineageMonster3.golem_microscout',12.00,43.50,46,'male','L2Monster',80,1943,778,8.69,2.14,40,43,30,21,20,10,3274,232,431,246,202,199,197,500,333,0,0,0,0,30,190,0,0,'LAST_HIT','true'),
(22051,22051,'Spelunking Spider',0,'',0,'LineageMonster.giant_spider_05te',26.00,25.50,47,'male','L2Monster',80,2017,811,8.69,2.14,40,43,30,21,20,10,3311,237,512,241,216,206,278,0,333,0,0,0,0,72,150,0,0,'LAST_HIT','true'),
(22052,22052,'Menacing Jackhammer Golem',0,'',0,'LineageMonster3.golem_prop',23.00,32.80,47,'male','L2Monster',80,2017,811,8.69,2.14,40,43,30,21,20,10,3311,237,512,241,216,206,197,500,333,0,0,0,0,72,180,0,0,'LAST_HIT','true'),
(22053,22053,'Horrifying Cannon Golem I',0,'',0,'LineageMonster3.golem_cannon_catapult',23.50,34.70,48,'male','L2Monster',80,2092,845,8.69,2.14,40,43,30,21,20,10,3423,250,575,238,231,212,197,500,333,0,0,0,0,130,180,0,0,'LAST_HIT','true'),
(22054,22054,'Horrifying Cannon Golem IV',0,'',0,'LineageMonster3.golem_cannon_catapult',23.50,34.70,48,'male','L2Monster',80,2092,845,8.69,2.14,40,43,30,21,20,10,3423,250,575,238,231,212,197,500,333,0,0,0,0,130,180,0,0,'LAST_HIT','true'),
(22055,22055,'Cruel Vice Golem',0,'',0,'LineageMonster3.golem_repair',23.00,32.80,49,'male','L2Monster',80,2168,878,8.69,2.14,40,43,30,21,20,10,3659,270,490,267,247,219,197,500,333,0,0,0,0,72,140,0,0,'LAST_HIT','true'),
(22056,22056,'Probe Golem Champion I',0,'',0,'LineageMonster3.golem_microscout',12.00,43.50,49,'male','L2Monster',80,2168,878,8.69,2.14,40,43,30,21,20,10,3659,270,490,267,247,219,197,500,333,0,0,0,0,30,140,0,0,'LAST_HIT','true'),
(22057,22057,'Spelunking Ant',0,'',0,'LineageMonster.ant_soldier',35.00,17.00,50,'male','L2Monster',80,2245,912,8.69,2.14,40,43,30,21,20,10,3629,273,509,273,264,226,278,500,333,0,0,0,0,80,150,0,0,'LAST_HIT','true'),
(22058,22058,'Horrifying Excavator Golem III',0,'',0,'LineageMonster3.golem_carrier',23.00,32.80,51,'male','L2Monster',80,2323,946,10.27,2.45,40,43,30,21,20,10,3841,293,602,280,281,232,197,500,333,0,0,0,0,72,150,0,0,'LAST_HIT','true'),
(22059,22059,'Bloodthirsty Ginzu Golem VII',0,'',0,'LineageMonster3.golem_guardian_090p',16.00,37.20,51,'male','L2Monster',80,2323,946,10.27,2.45,40,43,30,21,20,10,3841,293,602,280,281,232,197,500,333,0,0,0,0,50,150,0,0,'LAST_HIT','false'),
(22060,22060,'Horrifying Cannon Golem',0,'',0,'LineageMonster3.golem_cannon_catapult_a',23.50,34.70,52,'male','L2Monster',80,2402,981,10.27,2.45,40,43,30,21,20,10,2198,170,561,306,300,239,197,500,333,0,0,0,0,130,180,0,0,'LAST_HIT','false'),
(22061,22061,'Horrifying Cannon Golem III',0,'',0,'LineageMonster3.golem_microscout_a',20.00,40.00,51,'male','L2Monster',80,2323,946,10.27,2.45,40,43,30,21,20,10,3841,293,602,280,281,232,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(22062,22062,'Horrifying Jackhammer Golem',0,'',0,'LineageMonster3.golem_prop',23.00,32.80,52,'male','L2Monster',80,2402,981,10.27,2.45,40,43,30,21,20,10,2198,170,561,306,300,239,197,500,333,0,0,0,0,72,140,0,0,'LAST_HIT','false'),
(22063,22063,'Ginzu Golem Prodigy X',0,'',0,'LineageMonster3.golem_guardian_090p',16.00,37.20,52,'male','L2Monster',80,2402,981,10.27,2.45,40,43,30,21,20,10,2198,170,561,306,300,239,197,500,333,0,0,0,0,50,150,0,0,'LAST_HIT','false'),
(22064,22064,'Bloodthirsty Ginzu Golem II',0,'',0,'LineageMonster3.golem_guardian_a_090p',16.00,37.20,52,'male','L2Monster',80,2402,981,10.27,2.45,40,43,30,21,20,10,2198,170,561,306,300,239,197,500,333,0,0,0,0,50,150,0,0,'LAST_HIT','false'),
(22065,22065,'Horrifying Ginzu Golem V',0,'',0,'LineageMonster3.golem_guardian',18.00,41.50,53,'male','L2Monster',80,2482,1016,10.27,2.45,40,43,30,21,20,10,4398,346,636,283,319,247,197,500,333,0,0,0,0,53,150,0,0,'LAST_HIT','false'),
(22066,22066,'Horrifying Cannon Golem VI',0,'',0,'LineageMonster3.golem_cannon_catapult_a_090p',21.00,30.00,53,'male','L2Monster',80,2482,1016,10.27,2.45,40,43,30,21,20,10,4398,346,636,283,319,247,197,0,333,0,0,0,0,130,180,0,0,'LAST_HIT','false'),
(22067,22067,'Horrifying Cannon Golem VI',0,'',0,'LineageMonster3.golem_cannon_catapult_a_090p',21.00,30.00,53,'male','L2Monster',80,2482,1016,10.27,2.45,40,43,30,21,20,10,4398,346,636,283,319,247,197,0,333,0,0,0,0,130,180,0,0,'LAST_HIT','false'),
(22068,22068,'Horrifying Cannon Golem VI',0,'',0,'LineageMonster3.golem_cannon_catapult_a_090p',21.00,30.00,53,'male','L2Monster',80,2482,1016,10.27,2.45,40,43,30,21,20,10,4398,346,636,283,319,247,197,0,333,0,0,0,0,130,180,0,0,'LAST_HIT','false'),
(22069,22069,'Horrifying Cannon Golem VI',0,'',0,'LineageMonster3.golem_cannon_catapult_a_090p',21.00,30.00,53,'male','L2Monster',80,2482,1016,10.27,2.45,40,43,30,21,20,10,4398,346,636,283,319,247,197,0,333,0,0,0,0,130,180,0,0,'LAST_HIT','false'),
(22070,22070,'Horrifying Cannon Golem VI',0,'',0,'LineageMonster3.golem_cannon_catapult_a_090p',21.00,30.00,53,'male','L2Monster',80,2482,1016,10.27,2.45,40,43,30,21,20,10,4398,346,636,283,319,247,197,0,333,0,0,0,0,130,180,0,0,'LAST_HIT','false'),
(22071,22071,'Horrifying Cannon Golem VI',0,'',0,'LineageMonster3.golem_cannon_catapult_a_090p',21.00,30.00,53,'male','L2Monster',80,2482,1016,10.27,2.45,40,43,30,21,20,10,4398,346,636,283,319,247,197,0,333,0,0,0,0,130,180,0,0,'LAST_HIT','false'),
(22072,22072,'Horrifying Cannon Golem VI',0,'',0,'LineageMonster3.golem_cannon_catapult_a_090p',21.00,30.00,53,'male','L2Monster',80,2482,1016,10.27,2.45,40,43,30,21,20,10,4398,346,636,283,319,247,197,0,333,0,0,0,0,130,180,0,0,'LAST_HIT','false'),
(22073,22073,'Horrifying Cannon Golem VI',0,'',0,'LineageMonster3.golem_cannon_catapult_a_090p',20.00,40.00,53,'male','L2Monster',80,2482,1016,10.27,2.45,40,43,30,21,20,10,4398,346,636,283,319,247,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(22074,22074,'Epic Cannon Golem',0,'',0,'LineageMonster3.golem_cannon_catapult_a_090p',21.00,30.00,53,'male','L2Monster',80,2482,1016,10.27,2.45,40,43,30,21,20,10,4398,346,636,283,319,247,197,500,333,0,0,0,0,130,180,0,0,'LAST_HIT','false'),
(22075,22075,'Epic Cannon Golem Adjunct',0,'',0,'LineageMonster3.golem_microscout_a',12.00,43.50,52,'male','L2Monster',80,2402,981,10.27,2.45,40,43,30,21,20,10,2198,170,561,306,300,239,197,0,333,0,0,0,0,30,200,0,0,'LAST_HIT','false'),
(22076,22076,'Deadly Ginzu Golem V',0,'',0,'LineageMonster3.golem_guardian',18.00,41.50,53,'male','L2Monster',80,2482,1016,10.27,2.45,40,43,30,21,20,10,4398,346,636,283,319,247,197,500,333,0,0,0,0,53,150,0,0,'LAST_HIT','false'),
(22077,22077,'Horrifying Ginzu Golem VIII',0,'',0,'LineageMonster3.golem_guardian_a',18.00,41.50,54,'male','L2Monster',80,2562,1050,10.27,2.45,40,43,30,21,20,10,4370,348,667,293,339,254,197,500,333,0,0,0,0,53,150,0,0,'LAST_HIT','false'),
(22078,22078,'Deadly Ginzu Golem VIII',0,'',0,'LineageMonster3.golem_guardian_a',18.00,41.50,54,'male','L2Monster',80,2562,1050,10.27,2.45,40,43,30,21,20,10,4370,348,667,293,339,254,197,500,333,0,0,0,0,53,150,0,0,'LAST_HIT','false'),
(22079,22079,'Lost Bandersnatch',0,'',0,'LineageMonster2.bandersnatch_c',18.00,25.00,53,'male','L2Minion',40,2482,1016,10.27,2.45,40,43,30,21,20,10,4398,346,636,283,319,247,278,0,333,0,0,0,0,30,170,0,0,'LAST_HIT','false'),
(22080,22080,'Massive Maze Bandersnatch',0,'',0,'LineageMonster2.bandersnatch',18.00,25.00,54,'male','L2Monster',40,2562,1050,10.27,2.45,40,43,30,21,20,10,4370,348,667,293,339,254,278,0,333,0,0,0,0,30,170,0,0,'LAST_HIT','false'),
(22081,22081,'Lost Watcher',0,'',0,'LineageMonster.field_stalker',15.00,30.00,53,'male','L2Monster',40,2482,1016,10.27,2.45,40,43,30,21,20,10,4398,346,636,283,319,247,278,0,333,0,0,0,0,70,130,0,0,'LAST_HIT','true'),
(22082,22082,'Elder Lost Watcher',0,'',0,'LineageMonster.field_stalker_110p',16.00,36.00,54,'male','L2Monster',40,2562,1050,10.27,2.45,40,43,30,21,20,10,4370,348,667,293,339,254,278,0,333,0,0,0,0,70,170,0,0,'LAST_HIT','true'),
(22083,22083,'Baby Panthera',0,'',0,'LineageMonster.saber_toothed_tiger_080p',29.00,22.70,55,'male','L2Minion',40,2644,1086,10.27,2.45,40,43,30,21,20,10,4519,365,733,302,360,261,278,0,333,0,0,0,0,60,170,0,0,'LAST_HIT','false'),
(22084,22084,'Panthera',0,'',0,'LineageMonster.saber_toothed_tiger',34.00,28.00,56,'male','L2Monster',40,2724,1121,10.27,2.45,40,43,30,21,20,10,4896,402,730,310,382,269,278,300,333,0,0,0,0,60,170,0,0,'LAST_HIT','false'),
(22085,22085,'Lost Gargoyle',0,'',0,'LineageMonster.gargoyle_02te',16.00,50.00,55,'male','L2Monster',40,2643,1086,10.27,2.45,40,43,30,21,20,10,4519,365,733,302,360,261,278,0,333,0,0,0,0,140,140,0,0,'LAST_HIT','true'),
(22086,22086,'Lost Gargoyle Youngling',0,'',0,'LineageMonster.gargoyle_02te_110p',17.50,56.00,56,'male','L2Monster',40,2725,1121,10.27,2.45,40,43,30,21,20,10,4896,402,730,310,382,269,278,500,333,0,0,0,0,140,140,0,0,'LAST_HIT','true'),
(22087,22087,'Pronghorn Spirit',0,'',0,'LineageMonster2.antelope',17.00,34.00,56,'male','L2Monster',40,2725,1121,10.27,2.45,40,43,30,21,20,10,4896,402,730,310,382,269,278,0,333,0,0,0,0,45,185,0,0,'LAST_HIT','false'),
(22088,22088,'Pronghorn',0,'',0,'LineageMonster2.antelope_110p',19.00,37.80,57,'male','L2Monster',40,2807,1157,10.27,2.45,40,43,30,21,20,10,4087,340,861,298,405,276,278,0,333,0,0,0,0,45,185,0,0,'LAST_HIT','true'),
(22089,22089,'Ice Tarantula',0,'',0,'LineageMonster.giant_spider',26.00,25.50,57,'male','L2Monster',40,2807,1157,10.27,2.45,40,43,30,21,20,10,4087,340,861,298,405,276,278,0,333,0,0,0,0,72,120,0,0,'LAST_HIT','true'),
(22090,22090,'Frost Tarantula',0,'',0,'LineageMonster.giant_spider_110p',32.00,28.00,58,'male','L2Monster',40,2889,1192,10.27,2.45,40,43,30,21,20,10,5053,427,834,325,428,284,278,0,333,0,0,0,0,72,120,0,0,'LAST_HIT','true'),
(22091,22091,'Lost Iron Golem',0,'',0,'LineageMonster.iron_golem_120p',22.00,42.50,58,'male','L2Minion',40,2890,1192,10.27,2.45,40,43,30,21,20,10,5053,427,834,325,428,284,278,0,333,0,0,0,0,20,20,0,0,'LAST_HIT','false'),
(22092,22092,'Frost Iron Golem',0,'',0,'LineageMonster.iron_golem_130p',24.00,46.40,59,'male','L2Monster',40,2972,1229,10.27,2.45,40,43,30,21,20,10,6134,524,866,324,453,291,278,300,333,0,0,0,0,20,20,0,0,'LAST_HIT','false'),
(22093,22093,'Lost Buffalo',0,'',0,'LineageMonster2.buffalo',22.00,31.00,60,'male','L2Monster',40,3055,1265,10.27,2.45,40,43,30,21,20,10,5522,479,868,349,478,299,278,0,333,0,0,0,0,20,170,0,0,'LAST_HIT','false'),
(22094,22094,'Frost Buffalo',0,'',0,'LineageMonster2.buffalo_a_110p',24.00,34.70,61,'male','L2Monster',40,3137,1301,11.85,2.78,40,43,30,21,20,10,5254,462,1050,348,505,307,278,300,333,0,0,0,0,20,170,0,0,'LAST_HIT','true'),
(22095,22095,'Ursus Cub',0,'',0,'LineageMonster.grizzly',21.00,40.00,61,'male','L2Minion',40,3138,1301,11.85,2.78,40,43,30,21,20,10,5254,462,1050,348,505,307,278,0,333,0,0,0,0,40,120,0,0,'LAST_HIT','false'),
(22096,22096,'Ursus',0,'',0,'LineageMonster.grizzly_120p',21.00,40.00,62,'male','L2Monster',40,3220,1338,11.85,2.78,40,43,30,21,20,10,6303,562,1095,360,532,315,278,0,333,0,0,0,0,40,120,0,0,'LAST_HIT','false'),
(22097,22097,'Lost Yeti',0,'',0,'LineageMonster.yeti',15.00,27.50,62,'male','L2Monster',40,3220,1338,11.85,2.78,40,43,30,21,20,10,6303,562,1095,360,532,315,278,0,333,0,0,0,0,16,170,0,0,'LAST_HIT','true'),
(22098,22098,'Frost Yeti',0,'',0,'LineageMonster.yeti_110p',20.00,29.80,63,'male','L2Monster',40,3302,1375,11.85,2.78,40,43,30,21,20,10,6277,567,1136,384,560,323,278,0,333,0,0,0,0,16,170,0,0,'LAST_HIT','true'),
(22099,22099,'Freya\'s Buffalo',0,'',0,'LineageMonster2.buffalo',22.00,31.00,57,'male','L2Minion',80,2807,1157,10.27,2.45,40,43,30,21,20,10,4087,340,861,298,405,276,278,500,333,0,0,0,0,20,170,0,0,'LAST_HIT','false'),
(22100,22100,'Freya\'s Gardener',0,'',0,'LineageMonster.field_stalker',15.00,30.00,58,'male','L2Monster',80,2889,1192,10.27,2.45,40,43,30,21,20,10,5053,427,834,325,428,284,278,500,333,0,0,0,0,70,130,0,0,'LAST_HIT','false'),
(22101,22101,'Freya\'s Servant',0,'',0,'LineageMonster.gargoyle_02te',16.00,50.00,58,'male','L2Minion',80,2889,1192,10.27,2.45,40,43,30,21,20,10,5053,427,834,325,428,284,317,500,333,0,0,0,0,140,168,0,0,'LAST_HIT','false'),
(22102,22102,'Freya\'s Servant',0,'',0,'LineageMonster.gargoyle_02te',16.00,50.00,58,'male','L2Monster',80,2889,1192,10.27,2.45,40,43,30,21,20,10,5053,427,834,325,428,284,197,500,333,0,0,0,0,140,140,0,0,'LAST_HIT','false'),
(22103,22103,'Freya\'s White Bear',0,'',0,'LineageMonster.grizzly',21.00,40.00,57,'male','L2Minion',80,2807,1157,10.27,2.45,40,43,30,21,20,10,4087,340,861,298,405,276,278,500,333,0,0,0,0,40,165,0,0,'LAST_HIT','false'),
(22104,22104,'Freya\'s Dog',0,'',0,'LineageMonster2.bandersnatch',18.00,25.00,58,'male','L2Monster',80,2889,1192,10.27,2.45,40,43,30,21,20,10,5053,427,834,325,428,284,278,500,333,0,0,0,0,30,170,0,0,'LAST_HIT','false'),
(22105,22105,'Spiked Stakato',0,'',0,'LineageMonster.blade_stakato_120p',20.00,44.00,72,'male','L2Monster',80,4014,1720,13.43,3.09,40,43,30,21,20,10,7758,751,1681,454,849,399,278,500,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(22106,22106,'Spiked Stakato Worker',0,'',0,'LineageMonster.blade_stakato_worker_120p',20.00,48.00,73,'male','L2Monster',80,4087,1760,13.43,3.09,40,43,30,21,20,10,7975,782,1747,456,885,407,278,500,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(22107,22107,'Spiked Stakato Guard',0,'',0,'LineageMonster.spike_stakato',20.00,26.00,74,'male','L2Monster',80,4159,1800,13.43,3.09,40,43,30,21,20,10,8196,814,1608,501,921,416,278,500,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(22108,22108,'Female Spiked Stakato',0,'',0,'LineageMonster.spike_stakato_soldier',20.00,29.00,74,'male','L2Monster',80,4159,1800,13.43,3.09,40,43,30,21,20,10,11367,1140,1608,501,921,416,278,500,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(22109,22109,'Male Spiked Stakato',0,'',0,'LineageMonster.marsh_stakato_soldier_120p',20.00,31.00,74,'male','L2Monster',80,4159,1800,13.43,3.09,40,43,30,21,20,10,11215,1124,1608,501,921,416,278,500,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(22110,22110,'Male Spiked Stakato',0,'',0,'LineageMonster3.marsh_stakato_soldier_tran',20.00,28.00,74,'male','L2Monster',80,4159,1800,13.43,3.09,40,43,30,21,20,10,8533,849,1608,501,921,416,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(22111,22111,'Spiked Stakato Sorcerer',0,'',0,'LineageMonster.blade_stakato_queen_120p',20.00,44.00,75,'male','L2Monster',80,4229,1840,13.43,3.09,40,43,30,21,20,10,6804,683,1683,488,957,425,278,500,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(22112,22112,'Cannibalistic Stakato Follower',0,'',0,'LineageMonster.spike_stakato_worker',20.00,24.00,74,'male','L2Monster',80,4159,1800,13.43,3.09,40,43,30,21,20,10,9177,956,1608,501,921,416,278,500,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(22113,22113,'Cannibalistic Stakato Leader',0,'',0,'LineageMonster3.cannibal_stakato_leader_120p',20.00,48.00,75,'male','L2Monster',80,4229,1840,13.43,3.09,40,43,30,21,20,10,10777,1092,1683,488,957,425,278,500,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(22114,22114,'Cannibalistic Stakato Leader',0,'',0,'LineageMonster3.cannibal_stakato_leader_tran',20.00,48.00,75,'male','L2Monster',80,4229,1840,13.43,3.09,40,43,30,21,20,10,8765,883,1683,488,957,425,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(22115,22115,'Spiked Stakato Soldier',0,'',0,'LineageMonster.blade_stakato_120p',20.00,44.00,76,'male','L2Monster',80,4298,1880,13.43,3.09,40,43,30,21,20,10,7162,730,1824,506,994,433,278,500,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(22116,22116,'Spiked Stakato Drone',0,'',0,'LineageMonster.blade_stakato_drone_120p',20.00,47.00,77,'male','L2Monster',80,4364,1920,13.43,3.09,40,43,30,21,20,10,7352,758,1711,513,1031,442,278,500,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(22117,22117,'Spiked Stakato Captain',0,'',0,'LineageMonster.marsh_stakato_drone_120p',20.00,29.00,78,'male','L2Monster',80,4429,1961,13.43,3.09,40,43,30,21,20,10,7544,787,2111,522,1069,451,278,500,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(22118,22118,'Spiked Stakato Nurse',0,'',0,'LineageMonster.marsh_stakato_queen_120p',20.00,44.00,79,'male','L2Monster',80,4491,2002,13.43,3.09,40,43,30,21,20,10,10473,1116,2200,550,1107,459,278,500,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(22119,22119,'Spiked Stakato Nurse',0,'',0,'LineageMonster3.marsh_stakato_queen_tran',20.00,36.00,79,'male','L2Monster',80,4491,2002,13.43,3.09,40,43,30,21,20,10,7789,823,2200,550,1107,459,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(22120,22120,'Spiked Stakato Baby',0,'',0,'LineageMonster.spike_stakato_drone',20.00,29.00,79,'male','L2Monster',80,4491,2002,13.43,3.09,40,43,30,21,20,10,9929,1060,2200,550,1107,459,278,500,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(22121,22121,'Spiked Stakato Shaman',0,'',0,'LineageMonster.blade_stakato_queen_120p',20.00,44.00,80,'male','L2Monster',80,4551,2043,13.43,3.09,40,43,30,21,20,10,7742,827,1890,556,1144,468,278,500,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(22122,22122,'Monastic Pilgrim',0,'',0,'LineageMonster.angel_080p',13.00,28.00,78,'male','L2Minion',80,4551,2043,13.43,3.09,40,43,30,21,20,10,10320,1116,1890,556,1144,468,278,0,333,148,0,0,0,40,120,0,0,'LAST_HIT','false'),
(22123,22123,'Monastic Crusader',0,'',0,'LineageMonster.archangel_050p',20.00,40.00,78,'male','L2Monster',80,4609,2085,13.43,3.09,40,43,30,21,20,10,10422,1139,1972,574,1182,477,278,200,333,1303,0,0,0,40,120,0,0,'LAST_HIT','false'),
(22124,22124,'Solina Brother',0,'',0,'LineageMonster3.solina_brother',20.00,25.00,78,'male','L2Monster',80,4609,2085,13.43,3.09,40,43,30,21,20,10,8316,900,1972,574,1182,477,278,500,333,8212,0,0,0,88,180,0,0,'LAST_HIT','false'),
(22125,22125,'Solina Lay Brother',0,'',0,'LineageMonster3.solina_brother',20.00,25.00,78,'male','L2Monster',80,4664,2126,13.43,3.09,40,43,30,21,20,10,8326,911,2203,573,1220,485,278,500,333,8212,0,0,0,88,180,0,0,'LAST_HIT','false'),
(22126,22126,'Silent Seeker',0,'',0,'LineageMonster3.solina_father',20.00,25.00,78,'male','L2Monster',80,4664,2126,13.43,3.09,40,43,30,21,20,10,8523,933,2203,573,1220,485,278,500,333,8213,0,0,0,88,180,0,0,'LAST_HIT','false'),
(22127,22127,'Silent Brother',0,'',0,'LineageMonster3.solina_father',20.00,25.00,78,'male','L2Monster',80,4717,2168,13.43,3.09,40,43,30,21,20,10,8530,944,2695,571,1258,494,278,500,333,8212,0,0,0,88,180,0,0,'LAST_HIT','false'),
(22128,22128,'Monastery Guardian',0,'',0,'LineageMonster3.grail_protection',20.00,15.00,78,'male','L2Monster',80,4717,2168,13.43,3.09,40,43,30,21,20,10,9740,1131,2695,571,1258,494,278,500,333,0,0,0,0,80,160,0,0,'LAST_HIT','false'),
(22129,22129,'Warrior Monk',0,'',0,'LineageMonster3.monk_warrior',20.00,28.00,78,'male','L2Monster',80,4767,2211,13.43,3.09,40,43,30,21,20,10,8944,1003,2298,612,1296,502,278,500,333,8211,8210,0,0,40,132,0,0,'LAST_HIT','false'),
(22130,22130,'Divine Advocate',0,'',0,'LineageMonster2.apostle_warrior',8.00,30.00,78,'male','L2Minion',80,4814,2253,13.43,3.09,40,43,30,21,20,10,13056,1497,2129,615,1333,511,278,0,333,6717,0,0,0,40,80,0,0,'LAST_HIT','false'),
(22131,22131,'Pilgrim of Light',0,'',0,'LineageMonster2.apostle_mage',11.00,38.50,78,'male','L2Minion',80,4814,2253,13.43,3.09,40,43,30,21,20,10,11319,1297,2129,615,1333,511,278,0,333,6718,0,0,0,50,165,0,0,'LAST_HIT','false'),
(22132,22132,'Judge of Light',0,'',0,'LineageMonster3.apostle_grail_a',20.00,43.00,78,'male','L2Monster',80,4858,2296,13.43,3.09,40,43,30,21,20,10,7432,851,2199,625,1373,521,278,200,333,8220,0,0,0,40,80,0,0,'LAST_HIT','false'),
(22133,22133,'Guardian of the Grail',0,'',0,'LineageMonster.will_o_wisp',13.00,22.00,78,'male','L2Monster',80,4858,2296,13.43,3.09,40,43,30,21,20,10,13888,1670,2199,625,1373,521,278,500,333,0,0,0,0,40,120,0,0,'LAST_HIT','false'),
(22134,22134,'Guardian of the Holy Land',0,'',0,'LineageMonster3.solina_priest',20.00,35.00,78,'male','L2Monster',80,4900,2339,13.43,3.09,40,43,30,21,20,10,9372,1088,2269,635,1413,531,278,0,333,8214,0,0,0,40,120,0,0,'LAST_HIT','false'),
(22135,22135,'Beholder of Light',0,'',0,'LineageMonster3.apostle_grail',20.00,43.00,78,'male','L2Monster',80,4900,2339,13.43,3.09,40,43,30,21,20,10,10160,1192,2269,635,1413,531,278,500,333,8221,0,0,0,40,120,0,0,'LAST_HIT','false'),
(22136,22136,'Gatekeeper Zombie',0,'',0,'LineageMonster3.zombie_gateguard',17.00,30.50,78,'male','L2Monster',80,4717,2168,13.43,3.09,40,43,30,21,20,10,250,25,1719,4500,2288,780,300,300,555,8217,0,0,0,60,120,1,0,'LAST_HIT','false'),
(22137,22137,'Penance Guard',0,'',0,'LineageMonster3.zombie_gateguard_brd',17.00,30.50,78,'male','L2Monster',80,4608,1567,13.43,3.09,40,43,30,21,20,10,7360,792,2475,1127,1544,780,278,300,333,8217,0,0,0,60,120,1,0,'LAST_HIT','false'),
(22138,22138,'Chapel Guard',0,'',0,'LineageMonster3.zombie_gateguard_brd',17.00,30.50,78,'male','L2Monster',80,4812,2439,13.43,3.09,40,43,30,21,20,10,8104,912,2475,793,1144,780,278,300,333,8217,0,0,0,60,120,1,0,'LAST_HIT','false'),
(22139,22139,'Old Aristocrat\'s Soldier',0,'',0,'LineageMonster3.zombie_enlisted_man',17.00,22.30,78,'male','L2Monster',80,4609,2439,13.43,3.09,40,43,26,21,20,10,8283,893,1719,1108,1144,780,278,300,333,0,0,0,0,38,200,1,0,'LAST_HIT','false'),
(22140,22140,'Zombie Worker',0,'',0,'LineageMonster3.zombie_laborer',11.00,24.60,78,'male','L2Monster',80,4551,2439,13.43,3.09,40,43,25,21,20,10,8080,861,1886,1108,1144,780,278,300,333,123,0,0,0,36,120,1,0,'LAST_HIT','false'),
(22141,22141,'Forgotten Victim',0,'',0,'LineageMonster3.zombie_laborer',11.00,24.60,78,'male','L2Monster',80,4551,2439,13.43,3.09,40,43,25,21,20,10,8348,891,1886,1108,1144,780,278,300,333,123,0,0,0,36,120,1,0,'LAST_HIT','false'),
(22142,22142,'Triol\'s Layperson',0,'',0,'LineageMonster3.heretic_privates_a',7.70,28.40,78,'male','L2Monster',80,4609,3566,13.43,3.09,40,43,30,21,20,10,6771,730,1652,793,1144,780,278,300,333,8207,8207,0,0,58,200,0,0,'LAST_HIT','false'),
(22143,22143,'Triol\'s Believer',0,'',0,'LineageMonster3.heretic_privates',20.00,28.00,78,'male','L2Monster',80,3731,2439,13.43,3.09,40,43,30,21,20,10,7827,859,1652,793,1211,780,300,300,555,8205,0,0,0,61,180,0,0,'LAST_HIT','false'),
(22144,22144,'Resurrected Temple Knight',0,'',0,'LineageMonster3.zombie_enlisted_man',20.00,23.00,78,'male','L2Monster',80,4664,4599,13.43,3.09,40,43,26,21,20,10,8489,926,1698,1108,1144,780,550,300,555,0,0,0,0,61,180,1,0,'LAST_HIT','false'),
(22145,22145,'Ritual Sacrifice',0,'',0,'LineageMonster3.self_blaster',20.00,23.00,78,'male','L2Monster',80,4609,2499,13.43,3.09,40,43,30,21,20,10,8159,880,1719,793,1144,780,300,300,555,0,0,0,0,61,180,1,0,'LAST_HIT','false'),
(22146,22146,'Triol\'s Priest',0,'',0,'LineageMonster3.heretic_privates',7.70,28.40,78,'male','L2Monster',80,4766,4599,13.43,3.09,40,43,30,21,20,10,7282,813,1719,793,1211,780,278,300,333,8205,0,0,0,60,200,0,0,'LAST_HIT','false'),
(22147,22147,'Ritual Offering',0,'',0,'LineageMonster3.zombie_enlisted_man',17.00,22.30,78,'male','L2Monster',80,4717,4599,13.43,3.09,40,43,30,21,20,10,8986,994,1517,793,1144,780,278,300,333,0,0,0,0,38,180,1,0,'LAST_HIT','false'),
(22148,22148,'Triol\'s Believer',0,'',0,'LineageMonster3.heretic_privates',7.70,28.40,78,'male','L2Monster',80,5830,4599,13.43,3.09,40,43,30,21,20,10,7080,773,1719,793,1144,780,278,300,333,8205,0,0,0,60,180,0,0,'LAST_HIT','false'),
(22149,22149,'Ritual Offering',0,'',0,'LineageMonster3.zombie_enlisted_man',17.00,22.30,78,'male','L2Monster',80,4664,4599,13.43,3.09,40,43,30,21,20,10,8489,926,1517,793,1144,780,278,300,333,0,0,0,0,38,180,1,0,'LAST_HIT','false'),
(22150,22150,'Triol\'s Believer',0,'',0,'LineageMonster3.heretic_privates',7.70,28.40,78,'male','L2Monster',80,4717,4599,13.43,3.09,40,43,30,21,20,10,7440,822,1719,793,1144,780,278,300,333,8205,0,0,0,60,180,0,0,'LAST_HIT','false'),
(22151,22151,'Triol\'s Priest',0,'',0,'LineageMonster3.heretic_privates',7.70,28.40,78,'male','L2Monster',80,4814,4599,13.43,3.09,40,43,30,21,20,10,8410,956,1719,793,1144,780,278,300,333,8205,0,0,0,60,180,0,0,'LAST_HIT','false'),
(22152,22152,'Temple Guard',0,'',0,'LineageMonster3.zombie_em_knight',17.00,22.30,78,'male','L2Monster',80,4767,2699,13.43,3.09,40,43,30,21,20,10,9204,1030,1869,793,1144,780,236,300,333,8215,0,0,0,38,180,1,0,'LAST_HIT','false'),
(22153,22153,'Temple Guard Captain',0,'',0,'LineageMonster3.zombie_em_knight',17.00,22.30,78,'male','L2Monster',80,4767,3201,13.43,3.09,40,43,30,21,20,10,8908,995,1899,793,1144,780,236,300,333,8215,0,0,0,38,180,1,0,'LAST_HIT','false'),
(22154,22154,'Ritual Sacrifice',0,'',0,'LineageMonster3.self_blaster',9.00,25.80,78,'male','L2Monster',80,4814,3201,13.43,3.09,40,43,31,21,20,10,8984,1016,1719,677,1144,780,278,300,333,0,0,0,0,30,200,1,0,'LAST_HIT','false'),
(22155,22155,'Triol\'s High Priest',0,'',0,'LineageMonster3.heretic_priest_a',8.00,19.10,78,'male','L2Monster',80,4814,5505,13.43,3.09,40,43,30,21,20,10,10248,1175,1883,793,1244,780,278,300,333,8206,8206,0,0,30,180,0,0,'LAST_HIT','false'),
(22156,22156,'Triol\'s Priest',0,'',0,'LineageMonster3.heretic_privates',7.70,28.40,78,'male','L2Monster',80,4858,4599,13.43,3.09,40,43,30,21,20,10,11582,1348,1719,793,1144,780,278,300,333,8205,0,0,0,60,180,0,0,'LAST_HIT','false'),
(22157,22157,'Triol\'s Priest',0,'',0,'LineageMonster3.heretic_privates',7.70,28.40,78,'male','L2Monster',80,4814,4599,13.43,3.09,40,43,30,21,20,10,11097,1275,1719,793,1144,780,278,300,333,8205,0,0,0,60,180,0,0,'LAST_HIT','false'),
(22158,22158,'Triol\'s Believer',0,'',0,'LineageMonster3.heretic_privates_a',7.70,28.40,78,'male','L2Monster',80,4814,4599,13.43,3.09,40,43,30,21,20,10,11314,1301,1650,793,1214,780,278,300,333,8207,8207,0,0,58,180,0,0,'LAST_HIT','false'),
(22159,22159,'Triol\'s High Priest',0,'',0,'LineageMonster3.heretic_priest_a',8.00,19.10,78,'male','L2Monster',80,4858,5505,13.43,3.09,40,43,30,21,20,10,10490,1217,1883,793,1144,780,278,300,333,8206,8206,0,0,30,180,0,0,'LAST_HIT','false'),
(22160,22160,'Triol\'s Priest',0,'',0,'LineageMonster3.heretic_privates',7.70,28.40,78,'male','L2Monster',80,4858,4599,13.43,3.09,40,43,30,21,20,10,11582,1347,1719,793,1144,780,278,300,333,8205,0,0,0,60,180,0,0,'LAST_HIT','false'),
(22161,22161,'Ritual Sacrifice',0,'',0,'LineageMonster3.self_blaster',9.00,25.80,78,'male','L2Monster',80,4814,2439,13.43,3.09,40,43,30,21,20,10,13124,1508,1719,793,1144,780,278,300,333,0,0,0,0,30,200,1,0,'LAST_HIT','false'),
(22162,22162,'Triol\'s Believer',0,'',0,'LineageMonster3.heretic_privates_a',7.70,28.40,78,'male','L2Monster',80,4814,4599,13.43,3.09,40,43,30,21,20,10,11380,1301,1883,793,1214,780,278,300,333,8207,8207,0,0,58,180,0,0,'LAST_HIT','false'),
(22163,22163,'Triol\'s High Priest',0,'',0,'LineageMonster3.heretic_priest',8.00,19.10,78,'male','L2Monster',80,4858,5605,13.43,3.09,40,43,30,21,20,10,12170,1417,1719,793,1144,780,278,300,333,8208,0,0,0,30,180,0,0,'LAST_HIT','false'),
(22164,22164,'Triol\'s Believer',0,'',0,'LineageMonster3.heretic_privates_a',7.70,28.40,78,'male','L2Monster',80,4858,4599,13.43,3.09,40,43,30,21,20,10,11582,1347,1916,793,1301,780,278,300,333,8207,8207,0,0,58,180,0,0,'LAST_HIT','false'),
(22165,22165,'Triol\'s Priest',0,'',0,'LineageMonster3.heretic_privates',7.70,28.40,78,'male','L2Monster',80,4814,4599,13.43,3.09,40,43,30,21,20,10,11097,1275,1719,793,1144,780,278,300,333,8205,0,0,0,60,180,0,0,'LAST_HIT','false'),
(22166,22166,'Triol\'s Believer',0,'',0,'LineageMonster3.heretic_privates',7.70,28.40,78,'male','L2Monster',80,4814,4599,13.43,3.09,40,43,30,21,20,10,11098,1275,1916,793,1301,780,278,300,333,8205,0,0,0,60,180,0,0,'LAST_HIT','false'),
(22167,22167,'Triol\'s High Priest',0,'',0,'LineageMonster3.heretic_priest_a',8.00,19.10,78,'male','L2Monster',80,4900,6505,13.43,3.09,40,43,30,21,20,10,10735,1260,1883,793,1144,780,278,300,333,8206,8206,0,0,30,180,0,0,'LAST_HIT','false'),
(22168,22168,'Triol\'s Priest',0,'',0,'LineageMonster3.heretic_privates',7.70,28.40,78,'male','L2Monster',80,4900,4599,13.43,3.09,40,43,30,21,20,10,11626,1368,1719,793,1144,780,278,300,333,8205,0,0,0,60,180,0,0,'LAST_HIT','false'),
(22169,22169,'Ritual Sacrifice',0,'',0,'LineageMonster3.self_blaster',9.00,25.80,78,'male','L2Monster',80,4858,2439,13.43,3.09,40,43,30,21,20,10,13434,1562,1719,793,1144,780,278,300,333,0,0,0,0,30,200,1,0,'LAST_HIT','false'),
(22170,22170,'Triol\'s Believer',0,'',0,'LineageMonster3.heretic_privates_a',7.70,28.40,78,'male','L2Monster',80,4858,4599,13.43,3.09,40,43,30,21,20,10,11582,1347,2033,793,1301,780,278,300,333,8207,8207,0,0,58,180,0,0,'LAST_HIT','false'),
(22171,22171,'Triol\'s High Priest',0,'',0,'LineageMonster3.heretic_priest',8.00,19.10,78,'male','L2Monster',80,4900,5605,13.43,3.09,40,43,30,21,20,10,12454,1460,1719,793,1144,780,278,300,333,8208,0,0,0,30,180,0,0,'LAST_HIT','false'),
(22172,22172,'Ritual Sacrifice',0,'',0,'LineageMonster3.self_blaster',9.00,25.80,78,'male','L2Monster',80,4858,2439,13.43,3.09,40,43,30,21,20,10,13435,1563,1719,793,1144,780,278,300,333,0,0,0,0,30,200,1,0,'LAST_HIT','false'),
(22173,22173,'Triol\'s Priest',0,'',0,'LineageMonster3.heretic_privates',7.70,28.40,78,'male','L2Monster',80,4858,4599,13.43,3.09,40,43,30,21,20,10,11360,1321,1719,793,1144,780,278,300,333,8205,0,0,0,60,180,0,0,'LAST_HIT','false'),
(22174,22174,'Triol\'s Priest',0,'',0,'LineageMonster3.heretic_privates',7.70,28.40,78,'male','L2Monster',80,4814,4325,13.43,3.09,40,43,30,21,20,10,11314,1301,1719,793,1144,780,278,300,333,8205,0,0,0,60,180,0,0,'LAST_HIT','false'),
(22175,22175,'Andreas\' Captain of the Royal Guard',0,'',0,'LineageMonster3.zombie_em_knight',20.00,22.00,78,'male','L2Monster',80,4812,430,13.43,3.09,40,43,30,21,20,10,14436,688,1719,793,1144,780,500,500,555,8215,0,0,0,61,180,1,0,'LAST_HIT','false'),
(22176,22176,'Andreas\' Royal Guards',0,'',0,'LineageMonster3.zombie_em_knight',20.00,23.00,78,'male','L2Monster',80,4812,430,13.43,3.09,40,43,25,21,20,10,14436,688,2475,1108,1144,780,300,500,555,8215,0,0,0,61,180,1,0,'LAST_HIT','false'),
(22188,22188,'Andreas\' Captain of the Royal Guard',0,'',0,'LineageMonster3.heretic_priest_120p',20.00,23.00,78,'male','L2Monster',80,4899,4599,13.43,3.09,40,43,31,21,20,10,14698,700,2682,960,1566,780,300,500,555,8208,0,0,0,61,180,0,0,'LAST_HIT','false'),
(22189,22189,'Andreas\' Royal Guards',0,'',0,'LineageMonster3.heretic_privates_120p',22.00,34.00,78,'male','L2Monster',80,4858,2439,13.43,3.09,40,43,32,21,20,10,14574,694,2682,960,1566,780,460,500,555,8205,0,0,0,61,180,0,0,'LAST_HIT','false'),
(22190,22190,'Ritual Sacrifice',0,'',0,'LineageMonster3.self_blaster',20.00,23.00,78,'male','L2Monster',80,4858,2439,13.43,3.09,40,43,30,21,20,10,14574,694,1883,793,1144,780,300,0,555,0,0,0,0,61,180,1,0,'LAST_HIT','false'),
(22191,22191,'Andreas\' Captain of the Royal Guard',0,'',0,'LineageMonster3.heretic_priest_120p',20.00,23.00,78,'male','L2Monster',80,7350,4560,13.43,3.09,40,43,30,21,20,10,22049,1050,1719,793,1144,780,300,300,555,8208,0,0,0,61,180,0,0,'LAST_HIT','false'),
(22192,22192,'Andreas\' Royal Guards',0,'',0,'LineageMonster3.heretic_privates_120p',20.00,23.00,78,'male','L2Monster',80,9716,2439,13.43,3.09,40,43,30,21,20,10,29148,1388,1719,793,1144,780,300,500,555,8205,0,0,0,61,180,0,0,'LAST_HIT','false'),
(22193,22193,'Andreas\' Royal Guards',0,'',0,'LineageMonster3.heretic_privates_120p',20.00,23.00,78,'male','L2Monster',80,9716,2439,13.43,3.09,40,43,30,21,20,10,29148,1388,1719,793,1144,780,600,500,555,8205,0,0,0,61,180,0,0,'LAST_HIT','false'),
(22194,22194,'Penance Guard',0,'',0,'LineageMonster3.zombie_gateguard_slp',17.00,30.50,78,'male','L2Monster',80,4608,1566,13.43,3.09,40,43,30,21,20,10,13824,658,2475,1108,1544,780,278,300,333,8217,0,0,0,60,120,1,0,'LAST_HIT','false'),
(22195,22195,'Ritual Sacrifice',0,'',0,'LineageMonster3.self_blaster',20.00,31.00,78,'male','L2Monster',80,100000,9999,13.43,3.09,40,43,30,21,20,10,3083,500,3109,755,1893,651,278,0,333,0,0,0,0,88,132,0,0,'LAST_HIT','false'),
(22196,22196,'Velociraptor',0,'',0,'LineageMonster3.velociraptor',20.00,47.20,80,'male','L2Monster',80,26612,2296,13.43,3.09,40,43,30,21,20,10,11031,1351,2199,625,1373,521,278,1000,333,0,0,0,0,33,180,0,0,'LAST_HIT','false'),
(22197,22197,'Velociraptor',0,'',0,'LineageMonster3.velociraptor',20.00,47.20,80,'male','L2Monster',80,14019,2296,13.43,3.09,40,43,30,21,20,10,35331,3824,2199,625,1373,521,278,1000,333,0,0,0,0,33,210,0,0,'LAST_HIT','false'),
(22198,22198,'Velociraptor',0,'',0,'LineageMonster3.velociraptor',20.00,47.20,80,'male','L2Monster',80,28039,2296,13.43,3.09,40,43,30,21,20,10,77389,8410,2199,625,1373,521,278,1000,333,0,0,0,0,33,170,0,0,'LAST_HIT','false'),
(22199,22199,'Pterosaur',0,'',0,'LineageMonster3.rhamphorhynchus',36.00,43.70,80,'male','L2Monster',80,112798,2339,13.43,3.09,40,43,30,21,20,10,11131,1401,2269,635,1413,531,278,1000,333,0,0,0,0,88,188,0,0,'LAST_HIT','false'),
(22200,22200,'Ornithomimus',0,'',0,'LineageMonster3.ornithomimus',15.00,37.20,80,'male','L2Monster',80,13858,2211,13.43,3.09,40,43,30,21,20,10,35183,3716,2298,612,1296,502,278,1000,333,0,0,0,0,36,170,0,0,'LAST_HIT','false'),
(22201,22201,'Ornithomimus',0,'',0,'LineageMonster3.ornithomimus',15.00,37.20,80,'male','L2Monster',80,13858,2211,13.43,3.09,40,43,30,21,20,10,35183,3698,2298,612,1296,502,278,1000,333,0,0,0,0,36,200,0,0,'LAST_HIT','false'),
(22202,22202,'Ornithomimus',0,'',0,'LineageMonster3.ornithomimus',15.00,37.20,80,'male','L2Monster',80,13858,2211,13.43,3.09,40,43,30,21,20,10,35183,3716,2298,612,1296,502,278,1000,333,0,0,0,0,36,160,0,0,'LAST_HIT','false'),
(22203,22203,'Deinonychus',0,'',0,'LineageMonster3.deinonychus',14.00,14.30,80,'male','L2Monster',80,13763,2168,13.43,3.09,40,43,30,21,20,10,33592,3508,2695,571,1258,494,278,1000,333,0,0,0,0,24,160,0,0,'LAST_HIT','false'),
(22204,22204,'Deinonychus',0,'',0,'LineageMonster3.deinonychus',14.00,14.30,80,'male','L2Monster',80,13763,2168,13.43,3.09,40,43,30,21,20,10,32759,3422,2695,571,1258,494,278,1000,333,0,0,0,0,24,190,0,0,'LAST_HIT','false'),
(22205,22205,'Deinonychus',0,'',0,'LineageMonster3.deinonychus',14.00,14.30,80,'male','L2Monster',80,13763,2168,13.43,3.09,40,43,30,21,20,10,33591,3508,2695,571,1258,494,278,1000,333,0,0,0,0,24,160,0,0,'LAST_HIT','false'),
(22208,22208,'Pachycephalosaurus',0,'',0,'LineageMonster3.pachycephalosaurus',22.00,40.00,80,'male','L2Monster',80,13953,2253,13.43,3.09,40,43,30,21,20,10,39261,4198,2129,615,1333,511,278,1000,333,0,0,0,0,33,150,0,0,'LAST_HIT','false'),
(22209,22209,'Pachycephalosaurus',0,'',0,'LineageMonster3.pachycephalosaurus',22.00,40.00,80,'male','L2Monster',80,13953,2253,13.43,3.09,40,43,30,21,20,10,35898,3839,2129,615,1333,511,278,1000,333,0,0,0,0,33,170,0,0,'LAST_HIT','false'),
(22210,22210,'Pachycephalosaurus',0,'',0,'LineageMonster3.pachycephalosaurus',22.00,40.00,80,'male','L2Monster',80,13953,2253,13.43,3.09,40,43,30,21,20,10,39031,4176,2129,615,1333,511,278,1000,333,0,0,0,0,33,150,0,0,'LAST_HIT','false'),
(22211,22211,'Wild Strider',0,'',0,'LineageMonster3.wild_giant_strider',32.00,44.20,80,'male','L2Monster',80,13953,2253,13.43,3.09,40,43,30,21,20,10,36753,3952,2129,615,1333,511,278,1000,333,0,0,0,0,50,150,0,0,'LAST_HIT','false'),
(22212,22212,'Wild Strider',0,'',0,'LineageMonster3.wild_giant_strider',32.00,44.20,80,'male','L2Monster',80,13953,2253,13.43,3.09,40,43,30,21,20,10,35263,3771,2129,615,1333,511,278,1000,333,0,0,0,0,50,170,0,0,'LAST_HIT','false'),
(22213,22213,'Wild Strider',0,'',0,'LineageMonster3.wild_giant_strider',32.00,44.20,80,'male','L2Monster',80,13953,2253,13.43,3.09,40,43,30,21,20,10,36753,3952,2129,615,1333,511,278,1000,333,0,0,0,0,50,150,0,0,'LAST_HIT','false'),
(22214,22214,'Elroki',0,'',0,'LineageMonster3.Crokian_Officer',25.00,33.00,80,'male','L2Monster',80,27907,2253,13.43,3.09,40,43,30,21,20,10,34669,3723,2129,615,1333,511,278,1000,333,0,0,0,0,60,180,0,0,'LAST_HIT','false'),
(22215,22215,'Tyrannosaurus',0,'',0,'LineageMonster3.tyranosaurus',60.00,89.70,80,'male','L2Monster',40,340753,2277,97.43,23.09,40,43,30,21,20,20,634684,69817,17528,1336,7406,543,253,1000,333,0,0,0,0,88,188,0,12,'LAST_HIT','false'),
(22216,22216,'Tyrannosaurus',0,'',0,'LineageMonster3.tyranosaurus',60.00,89.70,80,'male','L2Monster',40,340753,2277,97.43,23.09,40,43,30,21,20,20,634684,69817,17528,1336,7406,543,253,1000,333,0,0,0,0,88,188,0,12,'LAST_HIT','false'),
(22217,22217,'Tyrannosaurus',0,'',0,'LineageMonster3.tyranosaurus',60.00,89.70,80,'male','L2Monster',40,340753,2277,97.43,23.09,40,43,30,21,20,20,634684,69817,17528,1336,7406,543,253,1000,333,0,0,0,0,88,188,0,12,'LAST_HIT','false'),
(22218,22218,'Velociraptor',0,'',0,'LineageMonster3.velociraptor',20.00,47.20,80,'male','L2Monster',80,14019,2296,13.43,3.09,40,43,30,21,20,10,33439,3595,2199,625,1373,521,278,1000,333,0,0,0,0,33,200,0,0,'LAST_HIT','false'),
(22219,22219,'Ornithomimus',0,'',0,'LineageMonster3.ornithomimus',15.00,37.20,80,'male','L2Monster',80,13858,2211,13.43,3.09,40,43,30,21,20,10,31854,3365,2298,612,1296,502,278,1000,333,0,0,0,0,36,190,0,0,'LAST_HIT','false'),
(22220,22220,'Deinonychus',0,'',0,'LineageMonster3.deinonychus',14.00,14.30,80,'male','L2Monster',80,13763,2168,13.43,3.09,40,43,30,21,20,10,27724,2891,2695,571,1258,494,278,1000,333,0,0,0,0,24,180,0,0,'LAST_HIT','false'),
(22221,22221,'Pachycephalosaurus',0,'',0,'LineageMonster3.pachycephalosaurus',22.00,40.00,80,'male','L2Monster',80,13953,2211,13.43,3.09,40,43,30,21,20,10,30806,3254,2298,612,1296,502,278,1000,333,0,0,0,0,33,150,0,0,'LAST_HIT','false'),
(22222,22222,'Wild Strider',0,'',0,'LineageMonster3.wild_giant_strider',32.00,44.20,80,'male','L2Monster',80,13953,2253,13.43,3.09,40,43,30,21,20,10,30637,3274,2129,615,1333,511,278,1000,333,0,0,0,0,50,150,0,0,'LAST_HIT','false'),
(22223,22223,'Velociraptor',0,'',0,'LineageMonster3.velociraptor',19.00,47.20,80,'male','L2Monster',80,14019,2296,13.43,3.09,40,43,30,21,20,10,34684,3755,2199,625,1373,521,278,1000,333,0,0,0,0,88,188,0,0,'LAST_HIT','false'),
(22224,22224,'Ornithomimus',0,'',0,'LineageMonster3.ornithomimus',15.00,37.20,80,'male','L2Monster',80,13858,2211,13.43,3.09,40,43,30,21,20,10,32698,3456,2298,612,1296,502,278,1000,333,0,0,0,0,36,170,0,0,'LAST_HIT','false'),
(22225,22225,'Deinonychus',0,'',0,'LineageMonster3.deinonychus',14.00,14.30,80,'male','L2Monster',80,13763,2168,13.43,3.09,40,43,30,21,20,10,30343,3187,2695,571,1258,494,278,1000,333,0,0,0,0,24,160,0,0,'LAST_HIT','false'),
(22226,22226,'Pachycephalosaurus',0,'',0,'LineageMonster3.pachycephalosaurus',22.00,40.00,80,'male','L2Monster',80,13953,2253,13.43,3.09,40,43,30,21,20,10,35125,3733,2129,615,1333,511,278,1000,333,0,0,0,0,33,140,0,0,'LAST_HIT','false'),
(22227,22227,'Wild Strider',0,'',0,'LineageMonster3.wild_giant_strider',32.00,44.20,80,'male','L2Monster',80,13953,2253,13.43,3.09,40,43,30,21,20,10,34440,3682,2129,615,1333,511,278,1000,333,0,0,0,0,50,140,0,0,'LAST_HIT','false'),
(22228,22228,'Grey Elpy',0,'',0,'LineageMonster.elpy',5.00,4.50,1,'male','L2Monster',40,62,44,3.16,0.91,40,43,30,21,20,10,35,2,9,39,3,32,278,0,333,0,0,0,0,50,80,0,0,'LAST_HIT','true'),
(22229,22229,'Young Grey Keltir',0,'',0,'LineageMonster.keltir',9.50,10.00,1,'male','L2Monster',40,62,44,3.16,0.91,40,43,30,21,20,10,29,2,4,39,3,32,278,0,333,0,0,0,0,23,110,0,0,'LAST_HIT','true'),
(22230,22230,'Grey Keltir',0,'',0,'LineageMonster.keltir',9.50,10.00,2,'male','L2Monster',40,75,52,3.16,0.91,40,43,30,21,20,10,70,2,10,42,3,34,278,0,333,0,0,0,0,23,110,0,0,'LAST_HIT','true'),
(22231,22231,'Dominant Grey Keltir',0,'',0,'LineageMonster.keltir',9.50,10.00,3,'male','L2Monster',40,90,60,3.16,0.91,40,43,30,21,20,10,105,2,11,44,3,35,278,0,333,0,0,0,0,23,110,0,0,'LAST_HIT','true'),
(22232,22232,'Black Wolf',0,'',0,'LineageMonster.wolf',13.00,9.00,4,'male','L2Monster',40,107,68,3.16,0.91,40,43,30,21,20,10,121,3,13,42,4,37,278,0,333,0,0,0,0,24,110,0,0,'LAST_HIT','true'),
(22233,22233,'Dominant Black Wolf',0,'',0,'LineageMonster.wolf_bi',13.00,10.80,5,'male','L2Monster',40,126,77,3.16,0.91,40,43,30,21,20,10,178,5,13,48,4,39,278,0,333,0,0,0,0,24,110,0,0,'LAST_HIT','true'),
(22234,22234,'Green Goblin',0,'',0,'LineageMonster.goblin',10.00,16.50,6,'male','L2Monster',40,147,85,3.16,0.91,40,43,30,21,20,10,211,6,15,50,5,41,278,0,333,4,0,0,0,40,110,0,0,'LAST_HIT','true'),
(22235,22235,'Mountain Werewolf',0,'',0,'LineageMonster.werewolf',10.00,26.00,7,'male','L2Monster',40,171,94,1.58,0.91,40,43,30,21,20,10,334,12,20,44,6,43,278,0,333,5,0,0,0,50,120,0,0,'LAST_HIT','true'),
(22236,22236,'Muertos Archer',0,'',0,'LineageMonster4.Mostro_Gunner',15.00,24.50,8,'male','L2Monster',40,197,102,3.16,0.91,40,43,30,21,20,10,293,10,41,55,6,45,278,0,333,10128,0,0,0,36,110,0,0,'LAST_HIT','true'),
(22237,22237,'Mountain Fungus',0,'',0,'LineageMonster.walking_fungus',15.00,22.50,9,'male','L2Monster',40,226,111,3.16,0.91,40,43,30,21,20,10,321,11,22,53,7,47,278,0,333,0,0,0,0,70,110,0,0,'LAST_HIT','true'),
(22238,22238,'Mountain Werewolf Chief',0,'',0,'LineageMonster.werewolf_bi',11.00,29.70,10,'male','L2Monster',40,257,120,3.16,0.91,40,43,30,21,20,10,356,12,20,67,8,49,278,0,333,5,0,0,0,50,120,0,0,'LAST_HIT','true'),
(22239,22239,'Muertos Guard',0,'',0,'LineageMonster4.Mostro_Fighter',15.50,22.50,11,'male','L2Monster',40,292,129,3.95,1.21,40,43,30,21,20,10,391,15,27,58,9,52,278,0,333,0,0,0,0,36,120,0,0,'LAST_HIT','true'),
(22240,22240,'Muertos Scout',0,'',0,'LineageMonster4.Mostro_Fighter',15.50,22.50,12,'male','L2Monster',40,315,138,3.95,1.21,40,43,30,21,20,10,436,16,27,66,10,54,278,0,333,0,0,0,0,36,120,0,0,'LAST_HIT','true'),
(22241,22241,'Colossus',0,'',0,'LineageMonster.stone_golem',20.00,31.00,13,'male','L2Monster',40,339,147,3.95,1.21,40,43,30,21,20,10,458,18,29,63,11,56,278,0,333,0,0,0,0,23,23,0,0,'LAST_HIT','true'),
(22242,22242,'Muertos Warrior',0,'',0,'LineageMonster4.Mostro_Fighter',15.50,22.50,14,'male','L2Monster',40,364,156,3.95,1.21,40,43,30,21,20,10,424,16,32,66,12,59,278,500,333,0,0,0,0,36,110,0,0,'LAST_HIT','true'),
(22243,22243,'Muertos Captain',0,'',0,'LineageMonster4.Mostro_Fighter',15.50,22.50,15,'male','L2Monster',40,390,165,3.95,1.21,40,43,30,21,20,10,449,18,40,69,14,62,278,0,333,0,0,0,0,36,110,0,0,'LAST_HIT','true'),
(22244,22244,'Crimson Spider',0,'',0,'LineageMonster.giant_spider_05te',26.00,25.50,16,'male','L2Monster',40,417,174,3.95,1.21,40,43,30,21,20,10,570,23,44,72,15,64,278,0,333,0,0,0,0,72,130,0,0,'LAST_HIT','true'),
(22245,22245,'Muertos Lieutenant',0,'',0,'LineageMonster4.Mostro_Fighter',15.50,22.50,17,'male','L2Monster',40,446,184,3.95,1.21,40,43,30,21,20,10,612,26,48,75,17,67,278,0,333,0,0,0,0,36,120,0,0,'LAST_HIT','true'),
(22246,22246,'Muertos Commander',0,'',0,'LineageMonster4.Mostro_Fighter',15.50,22.50,18,'male','L2Monster',40,476,193,3.95,1.21,40,43,30,21,20,10,633,28,53,79,19,70,278,500,333,0,0,0,0,33,132,0,0,'LAST_HIT','true'),
(22247,22247,'Grotto Golem',0,'',0,'LineageMonster.stone_golem',20.00,31.00,15,'male','L2Monster',40,390,165,3.95,1.21,40,43,30,21,20,10,449,18,40,69,14,62,278,500,333,0,0,0,0,23,23,0,0,'LAST_HIT','true'),
(22248,22248,'Shady Muertos',0,'',0,'LineageMonster4.Mostro_Fighter',15.50,22.50,17,'male','L2Monster',40,446,184,3.95,1.21,40,43,30,21,20,10,555,23,48,75,17,67,278,0,333,0,0,0,0,70,105,0,0,'LAST_HIT','false'),
(22249,22249,'Shady Muertos Guard',0,'',0,'LineageMonster4.Mostro_Gunner',15.00,24.50,16,'male','L2Monster',40,417,174,3.95,1.21,40,43,30,21,20,10,570,23,44,72,15,64,278,0,333,10128,0,0,0,36,110,0,0,'LAST_HIT','true'),
(22250,22250,'Grotto Leopard',0,'',0,'LineageMonster.onyx_beast',14.00,14.50,16,'male','L2Monster',40,417,174,3.95,1.21,40,43,30,21,20,10,570,23,44,72,15,64,278,0,333,0,0,0,0,30,120,0,0,'LAST_HIT','true'),
(22251,22251,'Shady Muertos Captain',0,'',0,'LineageMonster4.Mostro_Fighter',15.50,22.50,17,'male','L2Monster',40,446,184,3.95,1.21,40,43,30,21,20,10,555,23,48,75,17,67,278,0,333,0,0,0,0,36,110,0,0,'LAST_HIT','true'),
(22252,22252,'Grotto Grizzly',0,'',0,'LineageMonster.grizzly',21.00,40.00,17,'male','L2Monster',40,446,184,3.95,1.21,40,43,30,21,20,10,555,23,48,75,17,67,278,0,333,0,0,0,0,40,110,0,0,'LAST_HIT','true'),
(22253,22253,'Shady Muertos Warrior',0,'',0,'LineageMonster4.Mostro_Fighter',15.50,22.50,18,'male','L2Monster',40,476,193,3.95,1.21,40,43,30,21,20,10,633,28,53,79,19,70,278,0,333,0,0,0,0,36,110,0,0,'LAST_HIT','true'),
(22254,22254,'Shady Muertos Archer',0,'',0,'LineageMonster4.Mostro_Gunner',15.00,24.50,18,'male','L2Monster',500,476,193,3.95,1.21,40,43,30,21,20,10,633,28,53,79,19,70,278,0,333,10128,0,0,0,36,110,0,0,'LAST_HIT','true'),
(22255,22255,'Shady Muertos Commander',0,'',0,'LineageMonster4.Mostro_Fighter',15.50,22.50,19,'male','L2Monster',40,508,203,3.95,1.21,40,43,30,21,20,10,592,26,58,82,21,73,278,0,333,0,0,0,0,36,110,0,0,'LAST_HIT','true'),
(22256,22256,'Shady Muertos Wizard',0,'',0,'LineageMonster4.Mostro_Fighter',15.50,22.50,19,'male','L2Monster',40,508,203,3.95,1.21,40,43,30,21,20,10,592,26,58,82,21,73,278,0,333,0,0,0,0,36,110,0,0,'LAST_HIT','true'),
(22257,22257,'Island Guardian',0,'',0,'LineageMonster.light_worm_250p',40.00,47.00,78,'male','L2Monster',40,4428,1784,26.86,3.09,40,43,30,21,20,10,12615,1380,2205,525,1069,451,278,0,333,0,0,0,0,39,192,0,0,'LAST_HIT','true'),
(22258,22258,'White Sand Mirage',0,'',0,'LineageMonster.undine',40.00,28.00,79,'male','L2Monster',40,4490,1821,26.86,3.09,40,43,30,21,20,10,9829,612,1941,525,1107,459,278,300,333,0,0,0,0,50,165,0,0,'LAST_HIT','true'),
(22259,22259,'Muddy Coral',0,'',0,'LineageMonster.theeder_120p',40.00,39.00,80,'female','L2Monster',40,4550,1859,26.86,3.09,40,43,30,21,20,10,14100,1581,1894,834,1144,468,278,0,333,192,0,0,0,39,192,0,0,'LAST_HIT','true'),
(22260,22260,'Kleopora',0,'',0,'LineageMonster.gargoyle_02te',35.00,50.00,80,'female','L2Monster',40,4550,1859,26.86,3.09,40,43,30,21,20,10,11681,1311,1185,413,1144,468,278,0,333,0,0,0,0,39,192,0,0,'LAST_HIT','true'),
(22261,22261,'Seychelles',0,'',0,'LineageMonster.water_giant_120p',40.00,52.00,81,'male','L2Monster',40,4608,1896,26.86,3.09,40,43,30,21,20,10,12332,1365,1863,499,1182,477,278,0,333,5132,0,0,0,50,165,0,0,'LAST_HIT','true'),
(22262,22262,'Naiad',0,'',0,'LineageMonster4.tears',20.00,28.00,81,'female','L2Monster',40,4608,1896,26.86,3.09,40,43,30,21,20,10,12486,1382,1863,499,1182,477,278,300,333,9638,0,0,0,50,165,0,0,'LAST_HIT','true'),
(22263,22263,'Sonneratia',0,'',0,'LineageMonster.onyx_beast_bi',14.00,18.70,82,'female','L2Monster',40,4663,1934,26.86,3.09,40,43,30,21,20,10,14724,1609,1912,598,1220,485,278,0,333,0,0,0,0,30,180,0,0,'LAST_HIT','true'),
(22264,22264,'Castalia',0,'',0,'LineageMonster4.tears_d',20.00,27.50,82,'female','L2Monster',40,4663,1934,26.86,3.09,40,43,30,21,20,10,13088,1430,1912,598,1220,485,278,300,333,9638,9638,0,0,60,180,0,0,'LAST_HIT','true'),
(22265,22265,'Chrysocolla',0,'',0,'LineageMonster4.Crystal_Golem',34.00,47.00,83,'male','L2Monster',40,4716,1972,26.86,3.09,40,43,30,21,20,10,15491,1672,2249,736,1258,494,278,250,333,0,0,0,0,54,170,0,0,'LAST_HIT','true'),
(22266,22266,'Pythia',0,'',0,'LineageMonster4.tears',20.00,27.50,83,'female','L2Monster',40,4716,1972,26.86,3.09,40,43,30,21,20,10,13801,1489,1155,460,1258,494,278,0,333,9638,9638,0,0,60,180,0,0,'LAST_HIT','true'),
(22267,22267,'Dark Water Dragon',0,'',0,'LineageMonster3.antaras_ex_b',42.00,34.50,83,'male','L2Monster',40,103599,1972,26.86,3.09,40,43,30,21,20,10,158534,17119,3690,703,1258,494,278,300,333,0,0,0,0,200,200,0,0,'LAST_HIT','false'),
(22268,22268,'Shade',0,'',0,'LineageMonster4.eyeless',36.00,43.50,82,'male','L2Monster',40,4663,1934,26.86,3.09,40,43,30,21,20,10,0,0,1912,598,1220,485,278,420,333,0,0,0,0,49,192,0,0,'LAST_HIT','false'),
(22269,22269,'Shade',0,'',0,'LineageMonster4.eyeless',36.00,43.50,82,'male','L2Monster',40,4663,1934,26.86,3.09,40,43,30,21,20,10,10350,1130,1912,598,1220,485,278,420,333,0,0,0,0,49,192,0,0,'LAST_HIT','false'),
(22270,22270,'Water Dragon Detractor',0,'',0,'LineageMonster4.eyeless',36.00,43.50,82,'male','L2Monster',40,4663,1934,26.86,3.09,40,43,30,21,20,10,9625,1106,1912,598,1220,485,278,300,333,0,0,0,0,49,192,0,0,'LAST_HIT','false'),
(22271,22271,'Water Dragon Detractor',0,'',0,'LineageMonster4.eyeless',36.00,43.50,82,'male','L2Monster',40,4663,1934,26.86,3.09,40,43,30,21,20,10,9625,1106,1912,598,1220,485,278,300,333,0,0,0,0,49,192,0,0,'LAST_HIT','false'),
(22272,22272,'Beleth\'s Minion',0,'',0,'LineageMonster.vale_master',32.00,35.00,82,'male','L2Monster',40,4664,1935,26.86,3.09,40,43,30,21,20,20,16531,1728,1896,598,883,486,253,400,333,210,0,0,0,49,192,1,0,'LAST_HIT','false'),
(22273,22273,'Beleth\'s Minion',0,'',0,'LineageMonster.silhouette',28.00,23.00,82,'female','L2Monster',40,4664,1935,26.86,3.09,40,43,30,21,20,20,15997,1670,1896,598,883,486,253,400,333,0,0,0,0,49,192,1,0,'LAST_HIT','false'),
(22274,22274,'Beleth\'s Minion',0,'',0,'LineageMonster.shadeless',25.00,28.00,82,'male','L2Monster',40,4664,1935,26.86,3.09,40,43,30,21,20,20,16319,1705,1896,598,883,486,253,400,325,0,0,0,0,49,192,1,0,'LAST_HIT','false'),
(22275,22275,'Gatekeeper Lohan',0,'',0,'LineageMonster3.Jungle_Bleeze',40.00,47.00,81,'female','L2Monster',40,52146,1897,26.86,3.09,40,43,30,21,20,20,96272,10663,11673,940,5427,1145,253,400,333,0,0,0,0,50,170,0,0,'LAST_HIT','false'),
(22276,22276,'Gatekeeper of the Square',0,'',0,'LineageMonster4.Crystal_Golem',40.00,47.00,81,'male','L2Monster',40,4609,1897,26.86,3.09,40,43,30,21,20,20,28314,2999,1848,588,857,477,253,400,333,0,0,0,0,50,170,0,0,'LAST_HIT','false'),
(22277,22277,'Gatekeeper Provo',0,'',0,'LineageMonster2.lava_golem',40.00,47.00,81,'male','L2Monster',40,52146,1897,26.86,3.09,40,43,30,21,20,20,96272,10663,11673,940,5427,1145,253,400,333,0,0,0,0,50,170,0,0,'LAST_HIT','false'),
(22278,22278,'Gatekeeper of Fire',0,'',0,'LineageMonster4.Crystal_Golem',40.00,47.00,81,'male','L2Monster',40,4609,1897,26.86,3.09,40,43,30,21,20,20,28314,2999,1848,588,857,477,253,0,333,0,0,0,0,50,165,0,0,'LAST_HIT','false'),
(22279,22279,'Chromatic Detainee',0,'',0,'LineageMonster3.Crokian_Officer',32.00,35.00,81,'male','L2Monster',40,4609,1897,26.86,3.09,40,43,30,21,20,20,27781,2932,1848,588,857,477,253,0,333,0,0,0,0,50,165,0,0,'LAST_HIT','false'),
(22280,22280,'Rodo Knight',0,'',0,'LineageMonster4.Crystal_Golem',40.00,47.00,82,'male','L2Monster',40,4664,1935,26.86,3.09,40,43,30,21,20,20,15937,1663,1896,598,883,486,253,0,333,0,0,0,0,49,192,0,0,'LAST_HIT','false'),
(22281,22281,'Plaza Caiman',0,'',0,'LineageMonster3.Crokian_Officer',40.00,37.00,82,'male','L2Monster',40,17352,1935,26.86,3.09,40,43,30,21,20,20,13121,1370,13704,957,6371,1166,253,400,333,0,0,0,0,50,170,0,0,'LAST_HIT','false'),
(22282,22282,'Chromatic Detainee',0,'',0,'LineageMonster3.Crokian_Officer',32.00,35.00,81,'male','L2Monster',40,4609,1897,26.86,3.09,40,43,30,21,20,20,27781,2932,1848,588,857,477,253,0,333,0,0,0,0,50,165,0,0,'LAST_HIT','false'),
(22283,22283,'Emerald Alligar',0,'',0,'LineageMonster3.Crokian_Officer',40.00,35.00,82,'male','L2Monster',40,17352,1935,26.86,3.09,40,43,30,21,20,20,13121,1370,13704,957,6371,1166,253,400,333,0,0,0,0,50,170,0,0,'LAST_HIT','false'),
(22284,22284,'Chromatic Detainee',0,'',0,'LineageMonster.blade_stakato',32.00,35.00,81,'male','L2Monster',40,4609,1897,26.86,3.09,40,43,30,21,20,20,26651,2807,1848,588,857,477,253,0,333,0,0,0,0,50,165,0,0,'LAST_HIT','false'),
(22285,22285,'Chromatic Detainee',0,'',0,'LineageMonster.blade_stakato',32.00,35.00,81,'male','L2Monster',40,4609,1897,26.86,3.09,40,43,30,21,20,20,28709,3035,1848,588,857,477,253,400,333,0,0,0,0,50,170,0,0,'LAST_HIT','false'),
(22286,22286,'Plaza Gaviel',0,'',0,'LineageMonster3.Crokian_Officer',40.00,35.00,82,'male','L2Monster',40,17352,1935,26.86,3.09,40,43,30,21,20,20,13121,1370,13704,957,6371,1166,253,400,333,0,0,0,0,50,170,0,0,'LAST_HIT','false'),
(22287,22287,'Crystalline Unicorn',0,'',0,'LineageMonster.unicorn',40.00,43.00,82,'male','L2Monster',40,4664,1935,26.86,3.09,40,43,30,21,20,20,34503,3583,1896,598,883,486,253,400,333,0,0,0,0,50,170,0,0,'LAST_HIT','false'),
(22288,22288,'Emerald Boar',0,'',0,'LineageMonster.giant_wild_hog',40.00,23.82,82,'male','L2Monster',40,4664,1935,26.86,3.09,40,43,30,21,20,20,37724,3936,1896,598,883,486,253,400,333,0,0,0,0,50,170,0,0,'LAST_HIT','false'),
(22289,22289,'Plaza Helm',0,'',0,'LineageMonster2.ketra_warbeast',40.00,41.00,82,'male','L2Monster',40,4664,1935,26.86,3.09,40,43,30,21,20,20,36334,3792,1896,598,883,486,253,400,333,0,0,0,0,50,170,0,0,'LAST_HIT','false'),
(22290,22290,'Terod\'s Minion',0,'',0,'LineageMonster4.eyeless_080p',20.00,27.50,82,'male','L2Minion',40,17352,1935,26.86,3.09,40,43,30,21,20,20,101261,11072,13704,957,6371,1166,253,0,333,0,0,0,0,49,192,0,0,'LAST_HIT','false'),
(22291,22291,'Weylin\'s Minion',0,'',0,'LineageMonster4.eyeless_080p',20.00,32.50,82,'male','L2Monster',40,17352,1935,26.86,3.09,40,43,30,21,20,20,95185,10408,13704,957,6371,1166,253,400,333,0,0,0,0,50,170,0,0,'LAST_HIT','false'),
(22292,22292,'Tourmaline',0,'',0,'LineageMonster4.Crystal_Golem',40.00,47.00,82,'male','L2Monster',40,4664,1935,26.86,3.09,40,43,30,21,20,20,34122,3731,1896,598,883,486,253,0,333,0,0,0,0,49,192,0,0,'LAST_HIT','false'),
(22293,22293,'Spinel',0,'',0,'LineageMonster.stone_golem',18.00,34.00,82,'male','L2Monster',40,4664,1935,26.86,3.09,40,43,30,21,20,20,30840,3224,1896,598,883,486,253,400,333,0,0,0,0,50,170,0,0,'LAST_HIT','false'),
(22294,22294,'Fire Opal',0,'',0,'LineageMonster4.Crystal_Golem',40.00,47.00,82,'male','L2Monster',40,4664,1935,26.86,3.09,40,43,30,21,20,20,34122,3731,1896,598,883,486,253,400,333,0,0,0,0,50,170,0,0,'LAST_HIT','false'),
(22295,22295,'Reef Golem',0,'',0,'LineageMonster4.Crystal_Golem',40.00,47.00,82,'male','L2Monster',40,17352,1935,26.86,3.09,40,43,30,21,20,20,99513,10881,13704,957,6371,1166,253,400,333,0,0,0,0,50,170,0,0,'LAST_HIT','false'),
(22296,22296,'Reef Golem',0,'',0,'LineageMonster4.Crystal_Golem',40.00,47.00,82,'male','L2Monster',40,17352,1935,26.86,3.09,40,43,30,21,20,20,104675,11446,13704,957,6371,1166,253,400,333,0,0,0,0,50,170,0,0,'LAST_HIT','false'),
(22297,22297,'Reef Golem',0,'',0,'LineageMonster4.Crystal_Golem',40.00,47.00,82,'male','L2Monster',40,17352,1935,26.86,3.09,40,43,30,21,20,20,103023,11265,13704,957,6371,1166,253,400,333,0,0,0,0,50,170,0,0,'LAST_HIT','false'),
(22298,22298,'Weylin',0,'',0,'LineageMonster.banshee_30_bi',20.00,27.50,82,'female','L2Monster',40,52055,1935,26.86,3.09,40,43,30,21,20,20,164166,17951,11789,957,5477,1166,253,400,333,3939,0,0,0,50,170,0,0,'LAST_HIT','false'),
(22299,22299,'Dolph',0,'',0,'LineageMonster.pan_100_bi',20.00,70.00,82,'male','L2Monster',80,103968,1935,26.86,3.09,40,43,30,21,20,20,189054,20673,11338,957,5268,1166,253,400,333,213,0,0,0,70,170,0,0,'LAST_HIT','false'),
(22300,22300,'Dolph\'s Minion',0,'',0,'LineageMonster4.eyeless_080p',20.00,27.50,82,'male','L2Minion',40,4664,1935,26.86,3.09,40,43,30,21,20,20,34451,3767,1896,598,883,486,253,400,333,0,0,0,0,50,170,0,0,'LAST_HIT','false'),
(22301,22301,'Terod',0,'',0,'LineageMonster.doll_master_20_bi',20.00,27.50,82,'male','L2Monster',40,52055,1935,26.86,3.09,40,43,30,21,20,20,190311,20810,11789,957,5477,1166,253,400,333,0,0,0,0,50,170,0,0,'LAST_HIT','false'),
(22302,22302,'Darnel\'s Guardian',0,'',0,'LineageMonster.pixy_bi',20.00,27.00,82,'female','L2Monster',40,52055,1935,26.86,3.09,40,43,30,21,20,20,182298,19934,11789,957,5477,1166,253,400,333,0,0,0,0,50,170,0,0,'LAST_HIT','false'),
(22303,22303,'Guardian of the Square',0,'',0,'LineageMonster3.ice_fairy',20.00,27.00,82,'female','L2Monster',40,52055,1935,26.86,3.09,40,43,30,21,20,20,190116,20789,11789,957,5477,1166,253,400,333,0,0,0,0,50,170,0,0,'LAST_HIT','false'),
(22304,22304,'Guardian of the Emerald',0,'',0,'LineageMonster.blue_eye_150p',20.00,27.00,82,'male','L2Monster',40,52055,1935,26.86,3.09,40,43,30,21,20,20,190922,20877,11789,957,5477,1166,253,400,333,0,0,0,0,50,170,0,0,'LAST_HIT','false'),
(22305,22305,'Kechi\'s Captain',0,'',0,'LineageMonster.field_stalker_110p',36.00,43.50,82,'male','L2Monster',40,17352,1935,26.86,3.09,40,43,30,21,20,20,34650,3789,13704,957,6371,1166,253,400,333,0,0,0,0,50,170,0,0,'LAST_HIT','false'),
(22306,22306,'Kechi\'s Captain',0,'',0,'LineageMonster2.lava_golem',36.00,43.50,82,'male','L2Monster',40,17352,1935,26.86,3.09,40,43,30,21,20,20,88071,9156,13704,957,6371,1166,253,400,333,0,0,0,0,50,170,0,0,'LAST_HIT','false'),
(22307,22307,'Kechi\'s Captain',0,'',0,'LineageMonster3.Steel_Trapper',36.00,43.50,82,'male','L2Monster',40,52055,1935,26.86,3.09,40,43,30,21,20,20,190926,19906,11789,957,5477,1166,253,400,333,0,0,0,0,50,170,0,0,'LAST_HIT','false'),
(22308,22308,'Kechi\'s Guard',0,'',0,'LineageMonster.mana_vampire_120p',32.00,35.00,82,'male','L2Minion',40,4664,1935,26.86,3.09,40,43,30,21,20,20,30391,3173,1896,598,883,486,253,400,333,0,0,0,0,50,170,0,0,'LAST_HIT','false'),
(22309,22309,'Kechi\'s Guard',0,'',0,'LineageMonster.blade_stakato_soldier',32.00,35.00,82,'male','L2Minion',40,4664,1935,26.86,3.09,40,43,30,21,20,20,42319,4434,1896,598,883,486,253,400,333,148,0,0,0,50,170,0,0,'LAST_HIT','false'),
(22310,22310,'Kechi\'s Guard',0,'',0,'LineageMonster3.portrait_spirit_150p',32.00,35.00,82,'male','L2Minion',40,4664,1935,26.86,3.09,40,43,30,21,20,20,39903,4170,1896,598,883,486,253,400,333,0,0,0,0,50,170,0,0,'LAST_HIT','false'),
(22311,22311,'Parme\'s Guardian',0,'',0,'LineageMonster.riba',37.00,64.00,83,'female','L2Monster',40,51870,1973,26.86,3.09,40,43,30,21,20,20,180237,18511,11903,974,5534,1186,253,400,333,0,0,0,0,50,170,0,0,'LAST_HIT','false'),
(22312,22312,'Fafurion\'s Henchman',0,'',0,'LineageMonster.raikel',25.00,72.00,83,'male','L2Monster',40,51870,1973,26.86,3.09,40,43,30,21,20,20,190928,20619,11903,974,5534,1186,253,400,333,0,0,0,0,50,170,0,0,'LAST_HIT','false'),
(22313,22313,'Garden Stakato',0,'',0,'LineageMonster.blade_stakato_drone',32.00,35.00,83,'male','L2Monster',40,17290,1973,26.86,3.09,40,43,30,21,20,20,60929,6262,13866,974,6447,1186,253,400,333,134,0,0,0,50,170,0,0,'LAST_HIT','false'),
(22314,22314,'Garden Poison Moth',0,'',0,'LineageMonster4.Anthias',30.00,47.00,83,'male','L2Monster',40,17290,1973,26.86,3.09,40,43,30,21,20,20,59615,6120,13866,974,6447,1186,253,400,333,0,0,0,0,50,170,0,0,'LAST_HIT','false'),
(22315,22315,'Garden Guard',0,'',0,'LineageMonster.water_giant',40.00,42.00,83,'male','L2Monster',80,17290,1973,26.86,3.09,40,43,30,21,20,20,34896,3768,13866,974,6447,1186,253,400,333,5132,0,0,0,50,170,0,0,'LAST_HIT','false'),
(22316,22316,'Garden Guardian Tree',0,'',0,'LineageMonster3.Jungle_Bleeze',40.00,47.00,83,'female','L2Monster',40,17290,1973,26.86,3.09,40,43,30,21,20,20,100984,10905,13866,974,6447,1186,253,400,333,0,0,0,0,50,170,0,0,'LAST_HIT','false'),
(22317,22317,'Garden Castalia',0,'',0,'LineageMonster4.tears_d',20.00,27.00,83,'female','L2Monster',40,17290,1973,26.86,3.09,40,43,30,21,20,20,14993,1556,13866,974,6447,1186,253,400,333,9639,9639,0,0,50,170,0,0,'LAST_HIT','false'),
(22320,22320,'Junior Watchman',0,'',0,'LineageMonster4.eyeless',36.00,43.50,81,'male','L2Monster',40,51870,2444,56.86,3.09,40,43,30,21,20,10,163195,17623,12532,1055,4855,954,278,300,333,0,0,NULL,0,60,180,0,0,'LAST_HIT','false'),
(22321,22321,'Junior Summoner',0,'',0,'LineageMonster2.vampire_witch',6.00,21.50,81,'female','L2Monster',40,51870,2444,56.86,3.09,40,43,30,21,20,10,155629,16805,12532,1055,4855,954,278,300,333,946,0,NULL,0,64,180,0,0,'LAST_HIT','false'),
(22322,22322,'Subjugated Native',0,'',0,'LineageNPC.a_common_peopleC_Mhuman',10.00,24.00,83,'male','L2Monster',40,6060,1973,56.86,3.09,40,43,30,21,20,10,11381,1207,2250,609,1047,494,278,0,333,8219,0,0,0,64,180,0,0,'LAST_HIT','false'),
(22323,22323,'Charmed Native',0,'',0,'LineageNPC.a_common_peopleC_Mhuman',10.00,24.00,83,'male','L2Monster',40,6060,1973,56.86,3.09,40,43,30,21,20,10,11746,1247,2250,609,1047,494,278,0,333,8528,0,0,0,64,180,0,0,'LAST_HIT','false'),
(22324,22324,'Blind Huntsman',0,'',0,'LineageMonster4.eyeless_080p',34.00,35.00,81,'male','L2Monster',40,12120,2011,56.86,3.09,40,43,30,21,20,10,28643,2982,9532,1455,3955,1154,278,300,333,0,0,0,0,60,200,0,0,'LAST_HIT','false'),
(22325,22325,'Blind Watchman',0,'',0,'LineageMonster4.eyeless_080p',34.00,35.00,81,'male','L2Monster',40,12120,2011,56.86,3.09,40,43,30,21,20,10,25715,2666,9532,1455,3955,1154,278,300,333,0,0,0,0,60,200,0,0,'LAST_HIT','false'),
(22326,22326,'Hellinark',0,'Naia\'s Guardian',0,'LineageMonster.karik',19.00,35.00,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22327,22327,'Arcane Scout',0,'',0,'LineageMonster.dark_mahum',13.00,26.00,81,'male','L2Monster',40,103599,2444,56.86,3.09,40,43,30,21,20,10,320391,34598,23356,1220,6250,1034,278,300,333,234,0,NULL,0,50,160,0,0,'LAST_HIT','false'),
(22328,22328,'Arcane Guardian',0,'',0,'LineageMonster3.Succubus_Raid',12.00,30.70,81,'male','L2Monster',40,51799,2444,56.86,3.09,40,43,30,21,20,10,135761,14070,12532,1055,4855,954,278,420,333,0,0,NULL,0,60,170,0,0,'LAST_HIT','false'),
(22329,22329,'Arcane Watchman',0,'',0,'LineageMonster3.Death_Blader_Raid',15.00,32.50,81,'male','L2Monster',40,103599,2444,56.86,3.09,40,43,30,21,20,10,330999,35954,23356,1220,6250,1034,278,500,333,0,0,NULL,0,60,170,0,0,'LAST_HIT','false'),
(22330,22330,'Remnant Wraith',0,'',0,'LineageMonster3.zombie_laborer',11.00,28.50,81,'male','L2Monster',40,6060,2444,56.86,3.09,40,43,30,21,20,10,17814,1922,2933,717,1755,654,253,420,253,123,0,NULL,0,80,120,1,0,'LAST_HIT','false'),
(22334,22334,'Sand Scorpion',0,'',0,'LineageMonster2.sandScorpion',28.00,66.00,84,'male','L2Monster',40,51736,2444,56.86,3.09,40,43,30,21,20,10,147900,15779,12532,1855,4855,1154,278,300,333,0,0,NULL,0,37,170,0,0,'LAST_HIT','false'),
(22335,22335,'Desert Scorpion',0,'',0,'LineageMonster2.sandScorpion',28.00,66.00,81,'male','L2Monster',40,51736,2444,56.86,3.09,40,43,30,21,20,10,151636,16036,12532,1855,4855,1154,278,300,333,0,0,NULL,0,37,170,0,0,'LAST_HIT','false'),
(22336,22336,'Sand Devil',0,'',0,'LineageMonster2.imperial_warlord_zombie_sand',7.00,30.00,84,'male','L2Monster',40,17245,2444,56.86,3.09,40,43,30,21,20,10,49859,5317,4532,1055,1955,854,278,300,333,0,0,NULL,0,39,150,0,0,'LAST_HIT','false'),
(22337,22337,'Desiccator',0,'',0,'LineageMonster.skeleton_knight_sand',10.00,25.00,84,'male','L2Monster',40,17245,2444,56.86,3.09,40,43,30,21,20,10,47145,5029,4533,1055,1955,854,278,300,333,0,0,NULL,0,40,160,0,0,'LAST_HIT','false'),
(22339,22339,'Wandering Caravan',0,'',0,'LineageMonster4.Caravan',33.00,58.50,81,'male','L2Monster',40,6381,2444,56.86,3.09,40,43,30,21,20,10,18810,2005,2933,717,1755,654,278,300,333,0,0,NULL,0,56,160,0,0,'LAST_HIT','false'),
(22340,22340,'Sandstorm',0,'',0,'LineageMonster4.SandTourbillon',10.00,28.00,81,'male','L2Monster',40,51736,2444,56.86,3.09,40,43,30,21,20,10,146852,15665,12532,1055,4855,954,278,420,333,0,0,NULL,0,180,250,0,0,'LAST_HIT','false'),
(22341,22341,'Keltas',0,'',0,'LineageMonster3.Vampire_Troop_Leader',19.00,35.00,84,'male','L2Monster',40,309998,2011,56.86,3.09,40,43,30,21,20,10,449479,47956,9286,991,4318,1207,278,0,333,8686,0,0,0,120,200,0,0,'LAST_HIT','false'),
(22342,22342,'Darion\'s Enforcer',0,'',0,'LineageMonster.silhouette',32.00,35.00,84,'female','L2Monster',40,6381,2444,56.86,3.09,40,43,30,21,20,10,12424,1325,2943,717,1500,634,253,420,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22343,22343,'Darion\'s Executioner',0,'',0,'LineageMonster.shadeless',32.00,35.00,84,'male','L2Monster',40,6381,2444,56.86,3.09,40,43,30,21,20,10,9996,1065,2943,717,1500,634,253,420,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22344,22344,'Quarry Supervisor',0,'',0,'LineageMonster2.vampire_warrior',9.00,31.50,84,'male','L2Monster',40,25868,2444,56.86,3.09,40,43,30,21,20,10,70967,7313,2455,608,1382,514,253,420,333,6723,0,NULL,0,43,165,0,0,'LAST_HIT','false'),
(22345,22345,'Quarry Bowman',0,'',0,'LineageMonster2.vampire_wizard',5.50,28.00,84,'female','L2Monster',40,8622,2444,56.86,3.09,40,43,30,21,20,10,22388,2302,500,500,500,500,278,0,333,99,0,NULL,0,46,165,0,0,'LAST_HIT','false'),
(22346,22346,'Quarry Foreman',0,'',0,'LineageMonster3.Vampire_Troop_Leader_120p',22.00,43.00,84,'male','L2Monster',40,103332,2444,56.86,3.09,40,43,30,21,20,10,274809,29317,4255,900,1834,720,278,420,333,8686,0,NULL,0,60,165,0,0,'LAST_HIT','false'),
(22347,22347,'Quarry Patrolman',0,'',0,'LineageMonster4.eyeless_080p',34.00,35.00,84,'male','L2Monster',40,51736,2444,56.86,3.09,40,43,30,21,20,10,150396,16043,2455,900,1382,514,278,420,333,0,0,NULL,0,60,210,0,0,'LAST_HIT','false'),
(22349,22349,'Chimera of Earth',0,'',0,'LineageMonster4.Chimera',35.00,36.00,81,'female','L2Monster',40,103332,2444,56.86,3.09,40,43,30,21,20,10,283740,30271,15773,1120,5250,934,253,300,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22350,22350,'Chimera of Darkness',0,'',0,'LineageMonster4.Chimera',35.00,36.00,81,'female','L2Monster',40,103332,2444,56.86,3.09,40,43,30,21,20,10,294726,31444,15773,1120,5250,934,253,300,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22351,22351,'Chimera of Wind',0,'',0,'LineageMonster4.Chimera',35.00,36.00,81,'female','L2Monster',40,103332,2444,56.86,3.09,40,43,30,21,20,10,294726,31444,15773,1120,5250,934,253,300,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22352,22352,'Chimera of Fire',0,'',0,'LineageMonster4.Chimera',35.00,36.00,81,'female','L2Monster',40,103332,2444,56.86,3.09,40,43,30,21,20,10,284782,30380,15773,1120,5250,934,253,300,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22353,22353,'Celtus',0,'Chimera',0,'LineageMonster4.Chimera',35.00,36.00,81,'male','L2Monster',40,530976,2444,56.86,3.09,40,43,30,21,20,10,1096172,116952,15773,1120,5250,934,253,0,253,0,0,NULL,0,80,180,0,0,'LAST_HIT','false'),
(22355,22355,'Enceinte Defender',0,'',0,'LineageMonster4.eyeless',36.00,43.50,85,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,210,0,0,'LAST_HIT','false'),
(22356,22356,'Enceinte Defender',0,'',0,'LineageMonster4.eyeless',36.00,43.50,85,'male','L2Monster',40,176243,2444,56.86,3.09,40,43,30,21,20,10,0,0,15773,1120,5250,934,253,300,253,0,0,NULL,0,80,210,0,0,'LAST_HIT','false'),
(22357,22357,'Enceinte Defender',0,'',0,'LineageMonster4.eyeless',36.00,43.50,85,'male','L2Monster',40,102863,2444,56.86,3.09,40,43,30,21,20,10,0,0,15773,1120,5250,934,253,300,253,0,0,NULL,0,80,210,0,0,'LAST_HIT','false'),
(22358,22358,'Enceinte Defender',0,'',0,'LineageMonster4.eyeless',36.00,43.50,85,'male','L2Monster',40,88192,2444,56.86,3.09,40,43,30,21,20,10,247472,26088,12773,1020,4950,834,253,300,253,0,0,NULL,0,80,210,0,0,'LAST_HIT','false'),
(22359,22359,'Town Guard',0,'',0,'LineageMonster4.eyeless',36.00,43.50,85,'male','L2Monster',40,17167,2444,80.58,3.09,40,43,30,21,20,10,49496,5218,3890,803,1458,594,253,400,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22360,22360,'Town Patrolman',0,'',0,'LineageMonster.kel_mahum',13.00,26.00,85,'male','L2Monster',40,51502,2444,56.86,3.09,40,43,30,21,20,10,144799,15264,10773,1020,4950,834,253,420,253,0,0,NULL,0,40,60,0,0,'LAST_HIT','false'),
(22361,22361,'Steel Citadel Keymaster',0,'',0,'LineageMonster4.eyeless',36.00,43.50,85,'male','L2Monster',40,176243,2444,56.86,3.09,40,43,30,21,20,10,555758,58596,15773,1520,5250,934,253,420,253,0,0,NULL,0,80,210,0,0,'LAST_HIT','false'),
(22362,22362,'Guzen',0,'',0,'LineageMonster4.rahuu',33.00,49.00,85,'male','L2Monster',40,528731,2444,56.86,3.09,40,43,30,21,20,10,1092430,115182,15773,1120,5250,934,253,420,253,0,0,NULL,0,105,210,0,0,'LAST_HIT','false'),
(22363,22363,'Body Destroyer',0,'',0,'LineageMonster4.finished_malignant',14.00,31.50,85,'male','L2Monster',40,88192,2444,56.86,3.09,40,43,30,21,20,10,27729,2919,10773,920,4250,834,253,420,253,0,0,NULL,0,40,160,0,0,'LAST_HIT','false'),
(22364,22364,'Soul Dominator',0,'',0,'LineageMonster.death_blader',15.00,45.00,85,'male','L2Monster',40,29397,2444,56.86,3.09,40,43,30,21,20,10,90391,9528,10773,920,4250,1234,253,420,253,0,0,NULL,0,40,60,0,0,'LAST_HIT','false'),
(22365,22365,'Labyrinth Watchman',0,'',0,'LineageMonster4.eyeless_080p',34.00,35.00,85,'male','L2Monster',40,88192,2444,56.86,3.09,40,43,30,21,20,10,258121,27372,10773,920,4250,1234,253,300,253,0,0,NULL,0,80,210,0,0,'LAST_HIT','false'),
(22366,22366,'Labyrinth Watchman',0,'',0,'LineageMonster4.eyeless_080p',34.00,35.00,85,'male','L2Monster',40,88192,2444,56.86,3.09,40,43,30,21,20,10,0,0,10773,920,4250,1234,253,300,253,0,0,NULL,0,80,210,0,0,'LAST_HIT','false'),
(22367,22367,'Labyrinth Mystic',0,'',0,'LineageMonster.vale_master',12.00,40.00,85,'male','L2Monster',40,29397,2444,56.86,3.09,40,43,30,21,20,10,88204,9295,10773,920,4250,2334,253,300,253,0,0,NULL,0,40,60,0,0,'LAST_HIT','false'),
(22368,22368,'Labyrinth Captain',0,'',0,'LineageMonster.death_lord',21.00,40.00,85,'male','L2Monster',40,176244,2444,56.86,3.09,40,43,30,21,20,10,984405,98718,14773,2320,6250,1834,253,420,253,0,0,NULL,0,40,60,0,0,'LAST_HIT','false'),
(22369,22369,'Labyrinth Seer',0,'',0,'LineageMonster2.vampire_wizard',5.50,28.00,85,'male','L2Monster',40,88192,2444,56.86,3.09,40,43,30,21,20,10,102724,10315,10773,920,6250,1234,253,300,253,0,0,NULL,0,40,60,0,0,'LAST_HIT','false'),
(22370,22370,'Passageway Captain',0,'',0,'LineageMonster.shadow_50_bi',15.00,45.00,85,'male','L2Monster',40,88192,2444,56.86,3.09,40,43,30,21,20,10,272725,28753,10773,920,4250,1234,253,420,253,0,0,NULL,0,40,60,0,0,'LAST_HIT','false'),
(22371,22371,'Passageway Guards',0,'',0,'LineageMonster2.vampire_soldier_20_bi',10.00,29.00,85,'male','L2Monster',40,29397,2444,56.86,3.09,40,43,30,21,20,10,88733,9353,6773,1120,3250,934,253,300,253,0,0,NULL,0,40,60,0,0,'LAST_HIT','false'),
(22372,22372,'Passageway Mystic',0,'',0,'LineageMonster2.vampire_wizard',5.50,28.00,85,'male','L2Monster',40,88192,2444,56.86,3.09,40,43,30,21,20,10,259294,27337,10773,920,4250,1234,253,420,253,0,0,NULL,0,40,60,0,0,'LAST_HIT','false'),
(22373,22373,'Cosmic Scout',0,'',0,'LineageMonster.crimson_doll',15.00,38.00,85,'male','L2Monster',40,29397,2444,56.86,3.09,40,43,30,21,20,10,92475,9746,6773,720,2250,934,253,300,253,0,0,NULL,0,40,60,0,0,'LAST_HIT','false'),
(22374,22374,'Cosmic Watcher',0,'',0,'LineageMonster3.zombie_enlisted_man',17.00,22.29,85,'male','L2Monster',40,88192,2444,56.86,3.09,40,43,30,21,20,10,256947,27090,10773,920,4250,1234,253,300,253,0,0,NULL,0,40,60,0,0,'LAST_HIT','false'),
(22375,22375,'Cosmic Priest',0,'',0,'LineageMonster2.vampire_wizard',5.50,28.00,85,'male','L2Monster',40,176243,2444,56.86,3.09,40,43,30,21,20,10,537069,56626,10773,920,4250,1234,253,420,253,0,0,NULL,0,40,60,0,0,'LAST_HIT','false'),
(22376,22376,'Cosmic Lord',0,'',0,'LineageMonster4.rahuu',33.00,49.00,85,'male','L2Monster',40,528731,2444,56.86,3.09,40,43,30,21,20,10,1092428,115184,10773,920,4250,1234,253,420,253,0,0,NULL,0,80,210,0,0,'LAST_HIT','false'),
(22377,22377,'Master Zelos',0,'',0,'LineageMonster4.rahuu',33.00,49.00,85,'male','L2Monster',40,526860,2444,56.86,3.09,40,43,30,21,20,10,2838302,147052,15773,1620,5250,1634,253,600,253,0,0,NULL,0,80,210,0,0,'LAST_HIT','false'),
(22378,22378,'Master\'s Minion',0,'',0,'LineageMonster3.Vampire_Troop_Leader',19.00,35.00,86,'male','L2Monster',40,102527,2444,56.86,3.09,40,43,30,21,20,10,629209,32597,7773,1820,4250,1234,253,420,253,0,0,NULL,0,40,60,0,0,'LAST_HIT','false'),
(22379,22379,'Master\'s Minion',0,'',0,'LineageMonster2.vampire_witch',6.00,21.50,86,'male','L2Monster',40,51333,2444,56.86,3.09,40,43,30,21,20,10,329531,34340,10773,620,4250,1234,253,300,253,0,0,NULL,0,40,60,0,0,'LAST_HIT','false'),
(22380,22380,'Master Festina',0,'',0,'LineageMonster4.rah',20.00,40.59,86,'male','L2Monster',40,526860,2444,56.86,3.09,40,43,30,21,20,10,1325183,138115,15773,1120,6250,1234,253,420,253,0,0,NULL,0,80,210,0,0,'LAST_HIT','false'),
(22381,22381,'Master\'s Guard',0,'',0,'LineageMonster3.portrait_spirit',23.00,40.00,1,'male','L2Monster',40,87880,2444,56.86,3.09,40,43,30,21,20,10,299123,31174,10773,920,4250,1234,253,300,253,0,0,NULL,0,40,60,0,0,'LAST_HIT','false'),
(22382,22382,'Master\'s Guard',0,'',0,'LineageMonster3.portrait_spirit_winged',23.00,40.00,86,'male','L2Monster',40,87880,2444,56.86,3.09,40,43,30,21,20,10,294231,30666,10773,620,4250,1234,253,420,253,0,0,NULL,0,40,60,0,0,'LAST_HIT','false'),
(22383,22383,'Tully\'s Toy',0,'',0,'LineageMonster3.golem_repair',23.00,32.79,86,'male','L2Monster',40,87880,2444,56.86,3.09,40,43,30,21,20,10,0,0,5773,720,3250,1834,253,300,253,0,0,NULL,0,40,60,0,0,'LAST_HIT','false'),
(22384,22384,'Mystic\'s Toy',0,'',0,'LineageMonster3.golem_microscout',12.00,43.50,1,'male','L2Monster',40,2444,2444,56.86,3.09,40,43,30,21,20,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,40,60,0,0,'LAST_HIT','false'),
(22385,22385,'Tully\'s Golem Guard',0,'',0,'LineageMonster3.golem_guardian_a',18.00,41.50,86,'male','L2Monster',40,175620,2444,56.86,3.09,40,43,30,21,20,10,476707,49976,10773,1720,4250,1234,253,300,253,0,0,NULL,0,40,60,0,0,'LAST_HIT','false'),
(22386,22386,'Foundry Mystic',0,'',0,'LineageMonster.doll_master',20.00,42.00,86,'male','L2Monster',40,87880,2444,56.86,3.09,40,43,30,21,20,10,286890,30351,10773,920,4250,1234,253,300,253,0,0,NULL,0,40,60,0,0,'LAST_HIT','false'),
(22387,22387,'Foundry Mystic',0,'',0,'LineageMonster.doll_master',20.00,42.00,86,'male','L2Monster',40,87880,2444,56.86,3.09,40,43,30,21,20,10,292925,30349,10773,620,4250,1234,253,300,253,0,0,NULL,0,40,60,0,0,'LAST_HIT','false'),
(22388,22388,'Foundry Spirit Guard',0,'',0,'LineageMonster4.finished_malignant',14.00,31.50,86,'male','L2Monster',40,175620,2444,56.86,3.09,40,43,30,21,20,10,643753,67092,10773,920,4250,1234,253,300,253,0,0,NULL,0,80,160,0,0,'LAST_HIT','false'),
(22389,22389,'Foundry Spirit Guard',0,'',0,'LineageMonster4.finished_malignant',33.00,49.00,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22390,22390,'Foundry Foreman',0,'',0,'LineageMonster2.ahrimanes_20_sm',13.00,47.20,86,'male','L2Monster',40,526860,2444,56.86,3.09,40,43,30,21,20,10,1306411,136159,10773,920,4250,1234,253,300,253,0,0,NULL,0,40,60,0,0,'LAST_HIT','false'),
(22391,22391,'Foundry Assistant Overseer',0,'',0,'LineageMonster2.ashuras',13.00,37.50,86,'male','L2Monster',40,17111,2444,56.86,3.09,40,43,30,21,20,10,101028,10005,4773,820,4250,1234,253,300,253,0,0,NULL,0,40,60,0,0,'LAST_HIT','false'),
(22392,22392,'Failed Experimental Timetwister Golem',0,'',0,'LineageMonster3.golem_microscout_a',12.00,43.50,86,'male','L2Monster',40,7015,2444,56.86,3.09,40,43,30,21,20,10,91897,4553,40773,820,4250,1134,253,0,253,0,0,NULL,0,40,60,0,0,'LAST_HIT','false'),
(22393,22393,'Beleth\'s Follower',0,'',0,'LineageMonster3.zombie_gateguard',17.00,30.50,86,'male','L2Monster',40,102527,2444,56.86,3.09,40,43,30,21,20,10,716188,74637,10773,920,4250,1234,253,300,253,8217,0,0,0,80,155,0,0,'LAST_HIT','false'),
(22394,22394,'Beleth\'s Devotee',0,'',0,'LineageMonster3.portrait_spirit_winged',23.00,40.00,86,'male','L2Monster',40,307582,2444,56.86,3.09,40,43,30,21,20,10,306230,60918,10773,620,6250,1234,253,300,253,0,0,NULL,0,40,60,0,0,'LAST_HIT','false'),
(22395,22395,'Beleth\'s Projection',0,'',0,'LineageMonster4.behamah',25.00,37.50,86,'male','L2Monster',40,87880,2444,56.86,3.09,40,43,30,21,20,10,0,0,10773,1120,4250,1234,253,420,253,0,0,NULL,0,80,160,0,0,'LAST_HIT','false'),
(22396,22396,'Foundry Laborer',0,'',0,'LineageMonster4.Caravan_Slave',35.00,47.50,86,'male','L2Monster',40,7014,2444,56.86,3.09,40,43,30,21,20,10,0,0,1773,620,1250,534,253,0,253,0,0,NULL,0,90,180,0,0,'LAST_HIT','false'),
(22397,22397,'Foundry Foreman',0,'',0,'LineageMonster4.rahuu',33.00,51.50,86,'male','L2Monster',40,51333,2444,56.86,3.09,40,43,30,21,20,10,146516,15177,8773,920,4250,1234,253,300,253,0,0,NULL,0,80,210,0,0,'LAST_HIT','false'),
(22398,22398,'Lesser Evil',0,'',0,'LineageMonster3.zombie_gateguard',17.00,30.50,86,'male','L2Monster',40,102667,2444,54.00,0.00,40,43,30,30,20,20,0,0,14577,1923,4334,1955,253,0,253,8217,0,0,0,80,120,0,0,'LAST_HIT','false'),
(22399,22399,'Greater Evil',0,'',0,'LineageMonster3.zombie_gateguard_120p',17.00,30.50,86,'male','L2Monster',40,154001,2444,59.00,0.00,43,40,30,32,30,30,0,0,18655,3143,6559,2655,253,0,253,8217,0,0,0,80,120,0,0,'LAST_HIT','false'),
(22400,22400,'Parme\'s Healer',0,'',0,'LineageMonster4.tears_d',20.00,27.00,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22401,22401,'Parme\'s Healer',0,'',0,'LineageMonster4.tears_d',20.00,27.00,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22402,22402,'Shadow Column',0,'',0,'LineageNpcEV.dark_clouds_chessman',60.00,79.00,82,'male','L2Monster',40,2332,1884,67.15,3.09,65,65,65,45,45,45,4232,465,0,735,1220,765,355,0,355,0,0,0,0,0,0,0,0,'LAST_HIT','false'),
(22403,22403,'Foundry Foreman',0,'',0,'LineageMonster4.rah',33.00,40.00,86,'female','L2Monster',40,51333,2444,0.00,0.00,10,10,10,10,10,10,146516,15177,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22404,22404,'Arcane Captain',0,'',0,'LineageMonster.kaim_vanul',24.00,41.00,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22405,22405,'Darion\'s Faithful Servant',0,'',0,'LineageMonster4.demon_darion_fgt',36.00,53.00,86,'male','L2Monster',40,34222,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22406,22406,'Darion\'s Faithful Servant',0,'',0,'LineageMonster4.demon_darion_fgt',36.00,53.00,86,'male','L2Monster',40,51333,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22407,22407,'Darion\'s Faithful Servant',0,'',0,'LineageMonster4.demon_darion_fgt',36.00,53.00,86,'male','L2Monster',40,102667,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22408,22408,'Darion\'s Faithful Servant',0,'',0,'LineageMonster4.demon_darion_fgt',36.00,53.00,86,'male','L2Monster',40,87437,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22409,22409,'Darion\'s Faithful Servant',0,'',0,'LineageMonster4.demon_darion_fgt',36.00,53.00,86,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22410,22410,'Darion\'s Faithful Servant',0,'',0,'LineageMonster4.demon_darion_fgt',36.00,53.00,86,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22411,22411,'Beleth\'s Retainer',0,'',0,'LineageMonster4.demon_darion_fgt',36.00,53.00,86,'male','L2Monster',40,146466,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22412,22412,'Beleth\'s Fighter',0,'',0,'LineageMonster4.behamah_120p',36.00,47.00,86,'male','L2Monster',40,351240,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,10278,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22413,22413,'Beleth\'s Low Servant',0,'',0,'LineageMonster3.spectral_knight',36.00,43.50,86,'male','L2Monster',40,154001,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22414,22414,'Beleth\'s Follower',0,'',0,'LineageMonster3.zombie_gateguard',17.00,30.50,86,'male','L2Monster',40,2444,2444,56.86,3.09,40,43,30,21,20,10,0,0,10773,1120,3250,1234,253,0,253,8217,0,0,0,80,120,0,0,'LAST_HIT','false'),
(22415,22415,'Beleth\'s Devotee',0,'',0,'LineageMonster3.portrait_spirit_winged',23.00,40.00,86,'male','L2Monster',40,153791,2444,0.00,0.00,10,10,10,10,10,10,306230,60918,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22416,22416,'Kechi\'s Captain',0,'',0,'LineageMonster2.ifrit_30_bi',13.00,55.00,82,'male','L2Monster',40,52054,2444,0.00,0.00,10,10,10,10,10,10,200880,21963,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22417,22417,'Kechi\'s Guard',0,'',0,'LineageMonster3.portrait_spirit_winged_150p',23.00,52.00,82,'male','L2Minion',40,27983,2444,0.00,0.00,10,10,10,10,10,10,41503,4368,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22418,22418,'Burning Iris',0,'',0,'LineageMonster4.eyeless_080p',34.00,35.00,82,'male','L2Monster',40,18655,2444,0.00,0.00,10,10,10,10,10,10,28161,2936,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22419,22419,'Flame Iris',0,'',0,'LineageMonster4.eyeless_080p',34.00,35.00,82,'male','L2Monster',40,18655,2444,0.00,0.00,10,10,10,10,10,10,26474,2753,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22420,22420,'Brimstone Iris',0,'',0,'LineageMonster4.eyeless_080p',34.00,35.00,82,'male','L2Monster',40,18655,2444,0.00,0.00,10,10,10,10,10,10,28869,3011,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22422,22422,'Failan\'s Guard',0,'',0,'LineageMonster3.Death_Blader_Raid',15.00,32.50,83,'male','L2Monster',40,17290,2444,0.00,0.00,10,10,10,10,10,10,63855,6895,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22423,22423,'Original Sin Warden',0,'',0,'LineageMonster4.behamah',25.00,37.50,86,'male','L2Monster',40,25631,2444,13.55,3.09,40,43,30,21,20,20,69803,6996,11746,1024,5457,1247,253,0,253,10278,0,0,0,80,132,0,0,'LAST_HIT','false'),
(22424,22424,'Slave of Greed',0,'',0,'LineageMonster2.ashuras',13.00,37.50,86,'male','L2Monster',40,21044,2089,13.55,3.09,40,43,30,21,20,20,60503,6075,2570,640,1192,520,253,0,253,0,0,0,0,80,132,0,0,'LAST_HIT','false'),
(22425,22425,'Slave of Lust',0,'',0,'LineageMonster3.Succubus_Raid',12.00,30.70,86,'male','L2Monster',40,21044,2089,13.55,3.09,40,43,30,21,20,20,60503,6075,2570,640,1192,520,253,0,253,0,0,0,0,80,132,0,0,'LAST_HIT','false'),
(22426,22426,'Slave of Wrath',0,'',0,'LineageMonster.vale_master_10_bi',13.00,44.00,86,'male','L2Monster',40,21044,2089,13.55,3.09,40,43,30,21,20,20,60503,6075,2570,640,1192,520,253,0,253,0,0,0,0,80,132,0,0,'LAST_HIT','false'),
(22427,22427,'Slave of Sloth',0,'',0,'LineageMonster2.giant_zombie',13.00,40.00,86,'male','L2Monster',40,21044,2089,13.55,3.09,40,43,30,21,20,20,60503,6075,2570,640,1192,520,253,0,253,0,0,0,0,80,132,0,0,'LAST_HIT','false'),
(22428,22428,'Slave of Envy',0,'',0,'LineageMonster3.Bloody_Queen_Raid',11.00,34.00,86,'male','L2Monster',40,21044,2089,13.55,3.09,40,43,30,21,20,20,60503,6075,2570,640,1192,520,253,0,253,0,0,0,0,80,132,0,0,'LAST_HIT','false'),
(22429,22429,'Slave of Pride',0,'',0,'LineageMonster2.knight_of_shadow',10.00,35.50,86,'male','L2Monster',40,21044,2089,13.55,3.09,40,43,30,21,20,20,60503,6075,2570,640,1192,520,253,0,253,0,0,0,0,80,132,0,0,'LAST_HIT','false'),
(22430,22430,'Slave of Gluttony',0,'',0,'LineageMonster3.Death_Blader_Raid',15.00,32.50,86,'male','L2Monster',40,21044,2089,13.55,3.09,40,43,30,21,20,20,60503,6075,2570,640,1192,520,253,0,253,0,0,0,0,80,132,0,0,'LAST_HIT','false'),
(22431,22431,'Original Sin Warden',0,'',0,'LineageMonster4.behamah',25.00,37.50,86,'male','L2Monster',40,43905,2444,13.55,3.09,40,43,30,21,20,20,139297,13961,18981,1024,8820,1247,253,0,253,10278,0,0,0,80,132,0,0,'LAST_HIT','false'),
(22432,22432,'Slave of Greed',0,'',0,'LineageMonster2.ashuras',13.00,37.50,86,'male','L2Monster',40,17111,2089,13.55,3.09,40,43,30,21,20,20,35640,3714,14355,1024,6674,1247,253,0,253,0,0,0,0,80,132,0,0,'LAST_HIT','false'),
(22433,22433,'Slave of Lust',0,'',0,'LineageMonster3.Succubus_Raid',12.00,30.70,86,'male','L2Monster',40,17111,2089,13.55,3.09,40,43,30,21,20,20,35640,3714,14355,1024,6674,1247,253,0,253,0,0,0,0,80,132,0,0,'LAST_HIT','false'),
(22434,22434,'Slave of Wrath',0,'',0,'LineageMonster.vale_master_10_bi',13.00,44.00,86,'male','L2Monster',40,17111,2089,13.55,3.09,40,43,30,21,20,20,35640,3714,14355,1024,6674,1247,253,0,253,0,0,0,0,80,132,0,0,'LAST_HIT','false'),
(22435,22435,'Slave of Sloth',0,'',0,'LineageMonster2.giant_zombie',13.00,40.00,86,'male','L2Monster',40,17111,2089,13.55,3.09,40,43,30,21,20,20,35640,3714,14355,1024,6674,1247,253,0,253,0,0,0,0,80,132,0,0,'LAST_HIT','false'),
(22436,22436,'Slave of Envy',0,'',0,'LineageMonster3.Bloody_Queen_Raid',11.00,34.00,86,'male','L2Monster',40,17111,2089,13.55,3.09,40,43,30,21,20,20,35640,3714,14355,1024,6674,1247,253,0,253,0,0,0,0,80,132,0,0,'LAST_HIT','false'),
(22437,22437,'Slave of Pride',0,'',0,'LineageMonster2.knight_of_shadow',10.00,35.50,86,'male','L2Monster',40,17111,2089,13.55,3.09,40,43,30,21,20,20,35640,3714,14355,1024,6674,1247,253,0,253,0,0,0,0,80,132,0,0,'LAST_HIT','false'),
(22438,22438,'Slave of Gluttony',0,'',0,'LineageMonster3.Death_Blader_Raid',15.00,32.50,86,'male','L2Monster',40,17111,2089,13.55,3.09,40,43,30,21,20,20,35640,3714,14355,1024,6674,1247,253,0,253,0,0,0,0,80,132,0,0,'LAST_HIT','false'),
(22439,22439,'Beleth\'s Assassin',0,'',0,'LineageMonster.dark_mahum',8.00,25.00,86,'male','L2Monster',40,175620,2444,13.55,3.09,40,40,40,40,40,40,733677,76468,500,500,500,500,500,0,500,0,0,0,0,80,132,0,0,'LAST_HIT','false'),
(22440,22440,'Beleth\'s Assassin',0,'',0,'LineageMonster.dark_mahum',8.00,25.00,86,'male','L2Monster',40,175620,2444,13.55,3.09,40,40,40,40,40,40,0,0,500,500,500,500,500,0,500,0,0,0,0,80,132,0,0,'LAST_HIT','false'),
(22441,22441,'Beleth\'s Minion',0,'',0,'LineageMonster3.Vampire_Troop_Leader_120p',16.00,43.00,86,'male','L2Monster',40,175760,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,8686,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22442,22442,'Beleth\'s Minion',0,'',0,'LineageMonster3.Vampire_Troop_Leader_120p',16.00,43.00,86,'male','L2Monster',40,102667,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,8686,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22443,22443,'Kertang\'s Messenger',0,'',0,'LineageMonster4.snake_head_man',10.00,37.00,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22444,22444,'Kertang\'s Messenger',0,'',0,'LineageMonster4.snake_head_man',10.00,37.00,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22445,22445,'Kertang\'s Messenger',0,'',0,'LineageMonster4.snake_head_man',10.00,37.00,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22446,22446,'Kertang\'s Messenger',0,'',0,'LineageMonster4.snake_head_man_a',10.00,37.00,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22447,22447,'Kertang\'s Messenger',0,'',0,'LineageMonster4.snake_head_man_a',10.00,37.00,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22448,22448,'Leodas',0,'Resistance Commander',0,'LineageNPC.a_fighterguild_master_Mhuman_old',8.00,23.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22449,22449,'Amaskari',0,'Torture Expert',0,'LineageMonster2.ahrimanes',12.00,55.00,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22450,22450,'Tortured Native',0,'',0,'LineageNPC.a_common_peopleC_Mhuman',8.00,23.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22451,22451,'Native Elite Soldier',0,'',0,'LineageNPC.a_common_peopleC_Mhuman',8.00,23.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22452,22452,'White Skull Kanabion',0,'',0,'LineageMonster.skeleton_pikeman',8.00,23.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22453,22453,'White Skull Kanabion',0,'Doppler',0,'LineageMonster.skeleton_knight_20_bi',8.00,23.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22454,22454,'White Skull Kanabion',0,'Void',0,'LineageMonster.skeleton_royal_guard_30_bi',8.00,23.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22455,22455,'Begrudged Kanabion',0,'',0,'LineageMonster.orc',8.00,23.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22456,22456,'Begrudged Kanabion',0,'Doppler',0,'LineageMonster.orc_fighter',8.00,23.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22457,22457,'Begrudged Kanabion',0,'Void',0,'LineageMonster.orc_champion',8.00,23.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22458,22458,'Rotten Kanabion',0,'',0,'LineageMonster.zombie_bi_one',8.00,23.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22459,22459,'Rotten Kanabion',0,'Doppler',0,'LineageMonster.neer_crawler',8.00,23.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22460,22460,'Rotten Kanabion',0,'Void',0,'LineageMonster3.Zombie_Raid',8.00,23.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22461,22461,'Gluttonous Kanabion',0,'',0,'LineageMonster.crokian',8.00,23.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22462,22462,'Gluttonous Kanabion',0,'Doppler',0,'LineageMonster3.Crokian_Officer',8.00,23.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22463,22463,'Gluttonous Kanabion',0,'Void',0,'LineageMonster.nos',8.00,23.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22464,22464,'Callous Kanabion',0,'',0,'LineageMonster.zenta_lizardman',8.00,23.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22465,22465,'Callous Kanabion',0,'Doppler',0,'LineageMonster.zenta_lizardman_warrior',8.00,23.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22466,22466,'Callous Kanabion',0,'Void',0,'LineageMonster.zenta_lizardman_matriarch',8.00,23.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22467,22467,'Savage Kanabion',0,'',0,'LineageMonster.heltor_silenos',8.00,23.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22468,22468,'Savage Kanabion',0,'Doppler',0,'LineageMonster.heltor_silenos_warrior',8.00,23.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22469,22469,'Savage Kanabion',0,'Void',0,'LineageMonster.heltor_silenos_chieftain',8.00,23.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22470,22470,'Peerless Kanabion',0,'',0,'LineageMonster.batur_orc_20_bi',8.00,23.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22471,22471,'Peerless Kanabion',0,'Doppler',0,'LineageMonster.batur_orc_warrior_20_bi',8.00,23.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22472,22472,'Peerless Kanabion',0,'Void',0,'LineageMonster.batur_orc_overlord_20_bi',8.00,23.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22473,22473,'Massive Kanabion',0,'',0,'LineageMonster.kel_mahum',8.00,23.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22474,22474,'Massive Kanabion',0,'Doppler',0,'LineageMonster.kel_mahum_warrior',8.00,23.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22475,22475,'Massive Kanabion',0,'Void',0,'LineageMonster.kel_mahum_champion',8.00,23.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22476,22476,'Fervent Kanabion',0,'',0,'LineageMonster2.vampire_soldier',8.00,23.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22477,22477,'Fervent Kanabion',0,'Doppler',0,'LineageMonster2.vampire_warrior',8.00,23.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22478,22478,'Fervent Kanabion',0,'Void',0,'LineageMonster3.Vampire_Troop_Leader',8.00,23.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22479,22479,'Ruptured Kanabion',0,'',0,'LineageMonster4.eyeless_080p',8.00,23.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22480,22480,'Ruptured Kanabion',0,'Doppler',0,'LineageMonster4.eyeless',8.00,23.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22481,22481,'Ruptured Kanabion',0,'Void',0,'LineageMonster4.eyeless_120p',8.00,23.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22482,22482,'Sword Kanabion',0,'',0,'LineageMonster4.rah',8.00,23.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22483,22483,'Sword Kanabion',0,'Doppler',0,'LineageMonster4.rahuu',8.00,23.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22484,22484,'Sword Kanabion',0,'Void',0,'LineageMonster4.rahuu',8.00,23.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22485,22485,'Lost Watcher',0,'',0,'LineageMonster.oel_mahum',20.00,37.00,29,'male','L2Monster',40,7852,350,0.00,0.00,40,43,30,21,20,20,0,0,463,217,213,265,253,0,333,127,0,NULL,0,80,140,0,0,'LAST_HIT','false'),
(22486,22486,'Lost Watcher',0,'',0,'LineageMonster.oel_mahum',20.00,37.00,29,'male','L2Monster',40,7852,350,0.00,0.00,40,43,30,21,20,20,0,0,463,217,213,265,253,0,333,127,0,NULL,0,80,140,0,0,'LAST_HIT','false'),
(22487,22487,'Lost Beholder',0,'',0,'LineageMonster.oel_mahum_warrior',20.00,38.00,29,'male','L2Monster',40,15704,350,0.00,0.00,40,43,30,21,20,20,0,0,381,218,179,265,253,0,333,72,0,NULL,0,80,140,0,0,'LAST_HIT','false'),
(22488,22488,'Lost Watcher',0,'',0,'LineageMonster.zenta_lizardman',11.00,32.00,39,'male','L2Monster',40,11561,514,0.00,0.00,40,43,30,21,20,20,0,0,1452,312,673,380,253,0,333,68,0,NULL,0,80,140,0,0,'LAST_HIT','false'),
(22489,22489,'Lost Watcher',0,'',0,'LineageMonster.zenta_lizardman',11.00,32.00,39,'male','L2Monster',40,11561,514,0.00,0.00,40,43,30,21,20,20,0,0,1452,312,673,380,253,0,333,68,0,NULL,0,80,140,0,0,'LAST_HIT','false'),
(22490,22490,'Lost Beholder',0,'',0,'LineageMonster.zenta_lizardman_warrior',13.00,35.00,39,'male','L2Monster',40,23080,514,0.00,0.00,40,43,30,21,20,20,0,0,1202,312,556,380,253,0,333,16,0,NULL,0,80,140,0,0,'LAST_HIT','false'),
(22491,22491,'Lost Watcher',0,'',0,'LineageMonster.stone_golem',20.00,31.00,49,'male','L2Monster',40,26237,799,0.00,0.00,40,43,30,21,20,20,0,0,2570,432,1192,526,253,0,333,0,0,NULL,0,80,140,0,0,'LAST_HIT','false'),
(22492,22492,'Lost Watcher',0,'',0,'LineageMonster.stone_golem',20.00,31.00,49,'male','L2Monster',40,26237,799,0.00,0.00,40,43,30,21,20,20,0,0,2570,432,1192,526,253,0,333,0,0,NULL,0,80,140,0,0,'LAST_HIT','false'),
(22493,22493,'Lost Beholder',0,'',0,'LineageMonster.iron_golem_bi',27.00,52.00,49,'male','L2Monster',40,52474,799,0.00,0.00,40,43,30,21,20,20,0,0,2160,432,1006,526,253,0,333,0,0,NULL,0,80,140,0,0,'LAST_HIT','false'),
(22494,22494,'Lost Watcher',0,'',0,'LineageMonster.skeleton_royal_guard',11.00,28.50,59,'male','L2Monster',40,47350,1118,0.00,0.00,40,43,30,21,20,20,0,0,6236,575,2896,701,253,0,333,946,945,NULL,0,80,140,0,0,'LAST_HIT','false'),
(22495,22495,'Lost Watcher',0,'',0,'LineageMonster.skeleton_royal_guard',11.00,28.50,59,'male','L2Monster',40,47350,1118,0.00,0.00,40,43,30,21,20,20,0,0,6236,575,2896,701,253,0,333,946,945,NULL,0,80,140,0,0,'LAST_HIT','false'),
(22496,22496,'Lost Beholder',0,'',0,'LineageMonster.doll_master',20.00,42.00,59,'male','L2Monster',40,94601,1118,0.00,0.00,40,43,30,21,20,20,0,0,5654,575,2630,701,253,0,333,0,0,NULL,0,80,140,0,0,'LAST_HIT','false'),
(22497,22497,'Lost Watcher',0,'',0,'LineageMonster2.bandersnatch',18.00,25.00,69,'male','L2Monster',40,54800,1459,0.00,0.00,40,43,30,21,20,20,0,0,10100,736,4692,897,253,0,333,0,0,NULL,0,80,140,0,0,'LAST_HIT','false'),
(22498,22498,'Lost Watcher',0,'',0,'LineageMonster2.bandersnatch',18.00,25.00,69,'male','L2Monster',40,54800,1459,0.00,0.00,40,43,30,21,20,20,0,0,10100,736,4692,897,253,0,333,0,0,NULL,0,80,140,0,0,'LAST_HIT','false'),
(22499,22499,'Lost Beholder',0,'',0,'LineageMonster.onyx_beast_150p',20.00,23.50,69,'male','L2Monster',40,109485,1459,0.00,0.00,40,43,30,21,20,20,0,0,9901,736,4603,897,253,0,333,0,0,NULL,0,80,140,0,0,'LAST_HIT','false'),
(22500,22500,'Lost Watcher',0,'',0,'LineageMonster.angel',13.50,36.50,78,'male','L2Monster',40,89836,1784,0.00,0.00,40,43,30,21,20,20,0,0,17924,889,8329,1083,253,0,333,148,0,NULL,0,80,140,0,0,'LAST_HIT','false'),
(22501,22501,'Lost Watcher',0,'',0,'LineageMonster.angel',13.50,36.50,78,'male','L2Monster',40,89836,1784,0.00,0.00,40,43,30,21,20,20,0,0,17924,889,8329,1083,253,0,333,148,0,NULL,0,80,140,0,0,'LAST_HIT','false'),
(22502,22502,'Lost Beholder',0,'',0,'LineageMonster2.apostle_warrior',8.00,30.00,78,'male','L2Monster',40,179531,1784,0.00,0.00,40,43,30,21,20,20,0,0,17525,889,8147,1083,253,0,333,6717,0,NULL,0,80,140,0,0,'LAST_HIT','false'),
(22503,22503,'Lost Watcher',0,'',0,'LineageMonster4.behamah',25.00,37.50,81,'male','L2Monster',40,89279,1897,0.00,0.00,40,43,30,21,20,20,0,0,18698,940,8688,1145,253,0,333,10278,10278,NULL,0,80,140,0,0,'LAST_HIT','false'),
(22504,22504,'Lost Watcher',0,'',0,'LineageMonster4.behamah',25.00,37.50,81,'male','L2Monster',40,89279,1897,0.00,0.00,40,43,30,21,20,20,0,0,18698,940,8688,1145,253,0,333,10278,10278,NULL,0,80,140,0,0,'LAST_HIT','false'),
(22505,22505,'Lost Beholder',0,'',0,'LineageMonster2.hundred_eye',54.00,55.00,81,'male','L2Monster',40,178417,1897,0.00,0.00,40,43,30,21,20,20,0,0,18258,940,8484,1145,253,0,333,0,0,NULL,0,80,140,0,0,'LAST_HIT','false'),
(22506,22506,'Boom - Child',0,'',0,'LineageMonster4.boom_eye',33.00,13.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,250,300,0,0,'LAST_HIT','false'),
(22507,22507,'Boom - Child',0,'',0,'LineageMonster4.boom_eye',36.00,43.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22508,22508,'Boom - Child',0,'',0,'LineageMonster4.boom_eye',36.00,43.50,70,'male','L2Npc',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22509,22509,'Fanatic of Infinity',0,'',0,'LineageMonster4.ravager_silen',36.00,48.50,76,'male','L2Monster',40,34861,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22510,22510,'Rotten Messenger',0,'',0,'LineageMonster4.death_scout_088p',36.00,21.00,77,'male','L2Monster',40,36109,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22511,22511,'Zealot of Infinity',0,'',0,'LineageMonster4.disciple_silen',36.00,43.50,77,'male','L2Monster',40,36109,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22512,22512,'Body Severer',0,'',0,'LineageMonster4.bonecreeper',36.00,47.00,78,'male','L2Monster',40,37595,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22513,22513,'Body Harvester',0,'',0,'LineageMonster4.corpseshambler',36.00,34.50,79,'male','L2Monster',40,29651,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22514,22514,'Soul Exploiter',0,'',0,'LineageMonster4.soul_harvester',17.00,30.50,80,'male','L2Monster',40,41587,2444,56.86,3.09,40,43,30,21,20,10,0,0,10773,1120,3250,1234,253,0,253,0,0,0,0,80,120,0,0,'LAST_HIT','false'),
(22515,22515,'Soul Devourer',0,'',0,'LineageMonster4.soul_wagon_104p',36.00,35.50,81,'male','L2Monster',40,43756,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22516,22516,'Butcher of Infinity',0,'',0,'LineageMonster4.ravager_silen',36.00,48.00,81,'male','L2Monster',40,21878,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22517,22517,'Disciple of Infinity',0,'',0,'LineageMonster4.disciple_silen',36.00,43.50,81,'male','L2Monster',40,21878,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22518,22518,'Rotten Messenger',0,'',0,'LineageMonster4.death_scout_088p',32.00,21.00,83,'male','L2Monster',40,23026,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22519,22519,'Body Harvester',0,'',0,'LineageMonster4.corpseshambler',32.00,34.00,84,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22520,22520,'Body Severer',0,'',0,'LineageMonster4.bonecreeper',32.00,47.00,83,'male','L2Monster',40,24240,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22521,22521,'Soul Exploiter',0,'',0,'LineageMonster4.soul_harvester',32.00,30.50,83,'male','L2Monster',40,24240,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22522,22522,'Soul Devourer',0,'',0,'LineageMonster4.soul_wagon_104p',8.00,35.00,82,'male','L2Monster',40,23026,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22523,22523,'Soul Devourer',0,'Food of Ekimus',0,'LineageMonster4.soul_wagon_130p',8.00,45.00,83,'male','L2Monster',40,2444,2444,13.55,3.09,40,40,40,40,40,40,0,0,500,500,500,500,500,0,500,0,0,0,0,80,132,0,0,'LAST_HIT','false'),
(22524,22524,'Emissary of Death',0,'',0,'LineageMonster4.Death_slayer_080p',8.00,27.00,83,'male','L2Monster',40,24240,2444,13.55,3.09,40,40,40,40,40,40,0,0,500,500,500,500,500,0,500,0,0,0,0,80,132,0,0,'LAST_HIT','false'),
(22525,22525,'Emissary of Death',0,'',0,'LineageMonster4.Death_slayer',8.00,35.00,84,'male','L2Monster',40,25526,2444,13.55,3.09,40,40,40,40,40,40,0,0,500,500,500,500,500,0,500,0,0,0,0,80,132,0,0,'LAST_HIT','false'),
(22526,22526,'Emissary of Death',0,'',0,'LineageMonster4.Death_slayer_080p',8.00,27.00,83,'male','L2Monster',40,24240,2444,13.55,3.09,40,40,40,40,40,40,0,0,500,500,500,500,500,0,500,0,0,0,0,80,132,0,0,'LAST_HIT','false'),
(22527,22527,'Emissary of Death',0,'',0,'LineageMonster4.Death_slayer',8.00,34.00,84,'male','L2Monster',40,25526,2444,13.55,3.09,40,40,40,40,40,40,0,0,500,500,500,500,500,0,500,0,0,0,0,80,132,0,0,'LAST_HIT','false'),
(22528,22528,'Cursed Prefect',0,'',0,'LineageMonster4.death_knight_n_104p',8.00,42.00,83,'male','L2Monster',40,24240,2444,13.55,3.09,40,40,40,40,40,40,0,0,500,500,500,500,500,0,500,13982,0,0,0,80,132,0,0,'LAST_HIT','false'),
(22529,22529,'Cursed Prefect',0,'',0,'LineageMonster4.death_knight_n_130p',8.00,53.00,84,'male','L2Monster',40,25526,2444,13.55,3.09,40,40,40,40,40,40,0,0,500,500,500,500,500,0,500,13982,0,0,0,80,132,0,0,'LAST_HIT','false'),
(22530,22530,'Cursed Prefect',0,'',0,'LineageMonster4.death_knight_n_104p',8.00,42.00,83,'male','L2Monster',40,24240,2444,13.55,3.09,40,40,40,40,40,40,0,0,500,500,500,500,500,0,500,13983,0,0,0,80,132,0,0,'LAST_HIT','false'),
(22531,22531,'Cursed Prefect',0,'',0,'LineageMonster4.death_knight_n_130p',8.00,53.00,84,'male','L2Monster',40,25526,2444,13.55,3.09,40,40,40,40,40,40,0,0,500,500,500,500,500,0,500,13983,0,0,0,80,132,0,0,'LAST_HIT','false'),
(22532,22532,'Law Scholar of Conclusions',0,'',0,'LineageMonster4.lich_A_088p',8.00,40.00,83,'male','L2Monster',40,24240,2444,13.55,3.09,40,40,40,40,40,40,0,0,500,500,500,500,500,0,500,0,0,0,0,80,132,0,0,'LAST_HIT','false'),
(22533,22533,'Law Scholar of Conclusions',0,'',0,'LineageMonster4.lich_A_110p',8.00,51.00,84,'male','L2Monster',40,25526,2444,13.55,3.09,40,40,40,40,40,40,0,0,500,500,500,500,500,0,500,0,0,0,0,80,132,0,0,'LAST_HIT','false'),
(22534,22534,'Law Scholar of Conclusions',0,'',0,'LineageMonster4.lich_b_088p',8.00,40.00,83,'male','L2Monster',40,24240,2444,13.55,3.09,40,40,40,40,40,40,0,0,500,500,500,500,500,0,500,0,0,0,0,80,132,0,0,'LAST_HIT','false'),
(22535,22535,'Law Scholar of Conclusions',0,'',0,'LineageMonster4.lich_b_110p',8.00,51.00,84,'male','L2Monster',40,25526,2444,13.55,3.09,40,40,40,40,40,40,0,0,500,500,500,500,500,0,500,0,0,0,0,80,132,0,0,'LAST_HIT','false'),
(22536,22536,'Royal Guard Captain',0,'',0,'LineageMonster4.Dragon_eliteguard_075p',40.00,55.00,84,'male','L2Monster',40,51737,2011,13.55,3.09,40,43,30,21,20,20,333644,33883,12017,991,5587,1207,278,0,333,0,0,NULL,0,80,180,0,0,'LAST_HIT','false'),
(22537,22537,'Dragon Steed Troop Grand Magician',0,'',0,'LineageMonster4.Dragon_archmage_135p',25.00,49.90,84,'male','L2Monster',40,51737,2011,13.55,3.09,40,43,30,21,20,20,73171,7447,12017,991,5587,1207,278,0,333,0,0,NULL,0,80,180,0,0,'LAST_HIT','false'),
(22538,22538,'Dragon Steed Troop Commander',0,'',0,'LineageMonster4.Dragon_centurion_135p',28.00,46.50,83,'male','L2Monster',40,51870,1973,13.55,3.09,40,43,30,21,20,20,96783,10083,11903,974,5534,1186,278,0,333,13978,0,0,0,80,180,0,0,'LAST_HIT','false'),
(22539,22539,'Dragon Steed Troops No 1 Battalion Commander',0,'',0,'LineageMonster4.Dragon_centurion_135p',28.00,46.50,82,'male','L2Monster',40,52055,1935,13.55,3.09,40,43,30,21,20,20,98080,10347,11789,957,5477,1166,278,0,333,13978,0,0,0,80,180,0,0,'LAST_HIT','false'),
(22540,22540,'White Dragon Leader',0,'',0,'LineageMonster4.Dragon_centurion_120p',22.00,42.00,81,'male','L2Monster',40,52146,1897,13.55,3.09,40,43,30,21,20,20,82134,8708,11673,940,5427,1145,278,0,333,13979,13980,0,0,80,180,0,0,'LAST_HIT','false'),
(22541,22541,'Dragon Steed Troop Infantry',0,'',0,'LineageMonster4.Dragon_centurion_120p',22.00,42.00,80,'male','L2Monster',40,52288,1859,13.55,3.09,40,43,30,21,20,20,83347,8955,11557,923,5374,1125,278,0,333,13979,13980,NULL,0,80,180,0,0,'LAST_HIT','false'),
(22542,22542,'Dragon Steed Troop Magic Leader',0,'',0,'LineageMonster4.dragon_mage_075p',28.00,39.50,82,'male','L2Monster',40,52055,1935,13.55,3.09,40,43,30,21,20,20,193521,21161,11789,957,5477,1166,278,0,333,0,0,NULL,0,80,180,0,0,'LAST_HIT','false'),
(22543,22543,'Dragon Steed Troop Magician',0,'',0,'LineageMonster4.dragon_mage_075p',28.00,39.50,81,'male','L2Monster',40,52146,1897,13.55,3.09,40,43,30,21,20,20,79493,8397,11673,940,5427,1145,278,0,333,0,0,NULL,0,80,180,0,0,'LAST_HIT','false'),
(22544,22544,'Dragon Steed Troop Magic Soldier',0,'',0,'LineageMonster4.dragon_mage_065p',25.00,34.50,80,'male','L2Monster',40,52288,1859,13.55,3.09,40,43,30,21,20,20,84936,9090,11557,923,5374,1125,278,0,333,13981,0,NULL,0,80,180,0,0,'LAST_HIT','false'),
(22545,22545,'Wife of the Dragon of Darkness',0,'',0,'LineageMonster4.dragon_shadow_110p',60.00,66.00,83,'male','L2Monster',40,51870,1973,13.55,3.09,40,43,30,21,20,20,203716,22000,11903,974,5534,1186,278,0,333,0,0,NULL,0,80,180,0,0,'LAST_HIT','false'),
(22546,22546,'Warrior of Light',0,'',0,'LineageMonster4.dragon_berserker_090p',50.00,55.00,79,'male','L2Monster',40,52385,1822,13.55,3.09,40,43,30,21,20,20,82511,8653,11354,906,5279,1104,278,0,333,0,0,NULL,0,80,180,0,0,'LAST_HIT','false'),
(22547,22547,'Dragon Steed Troop Healer',0,'',0,'LineageMonster4.dragon_mage_065p',25.00,34.50,79,'male','L2Monster',40,52385,1822,13.55,3.09,40,43,30,21,20,20,59035,6215,11354,906,5279,1104,278,0,333,13981,0,NULL,0,80,180,0,0,'LAST_HIT','false'),
(22548,22548,'Dragon Steed Troop Javelin Thrower',0,'',0,'LineageMonster4.dragon_peltast',25.00,46.50,80,'male','L2Monster',40,52288,1859,13.55,3.09,40,43,30,21,20,20,94968,10260,11557,923,5374,1125,278,0,333,13843,0,NULL,0,80,180,0,0,'LAST_HIT','false'),
(22549,22549,'Dragon Steed Troop Javelin Thrower',0,'',0,'LineageMonster4.dragon_peltast',25.00,46.50,80,'male','L2Monster',40,52288,1859,13.55,3.09,40,43,30,21,20,20,94968,10260,11557,923,5374,1125,278,0,333,13843,0,NULL,0,80,180,0,0,'LAST_HIT','false'),
(22550,22550,'Savage Warrior',0,'',0,'LineageMonster4.ravager_silen',27.00,48.50,77,'male','L2Monster',40,31011,1747,13.55,3.09,40,43,30,21,20,20,103619,10725,8198,872,3808,1062,278,0,333,13987,0,NULL,0,80,180,0,0,'LAST_HIT','false'),
(22551,22551,'Priest of Darkness',0,'',0,'LineageMonster4.disciple_silen',19.00,44.00,76,'male','L2Monster',40,31021,1710,13.55,3.09,40,43,30,21,20,20,95778,9756,8031,855,3734,1041,278,0,333,0,0,NULL,0,80,180,0,0,'LAST_HIT','false'),
(22552,22552,'Mutation Drake',0,'',0,'LineageMonster4.Mutant_drake',48.00,53.50,78,'male','L2Monster',40,52476,1784,0.00,0.00,40,43,30,21,20,20,92347,9614,11141,889,5176,1083,278,0,333,0,0,NULL,0,80,180,0,0,'LAST_HIT','false'),
(22553,22553,'Large Crystal Core',0,'',0,'LineageNpcEV.source_facility',62.00,140.00,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22554,22554,'Small Crystal Core',0,'',0,'LineageNpcEV.source_facility',62.00,140.00,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22555,22555,'Small Crystal Core',0,'',0,'LineageNpcEV.source_facility',62.00,140.00,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22556,22556,'Small Crystal Core',0,'',0,'LineageNpcEV.source_facility',62.00,140.00,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22557,22557,'Defense Mechanism',0,'',0,'LineageMonster4.defence_mech',86.00,133.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22558,22558,'Defense Battery',0,'',0,'LineageMonster4.defence_mech',86.00,133.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22559,22559,'Defeated Troops Commander',0,'',0,'LineageMonster4.Dragon_centurion_135p',28.00,46.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22560,22560,'Defeated Troops No 1 Battalion Commander',0,'',0,'LineageMonster4.Dragon_centurion_135p',28.00,46.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22561,22561,'Defeated Troops White Dragon Leader',0,'',0,'LineageMonster4.Dragon_centurion_120p',22.00,42.00,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22562,22562,'Defeated Troops Infantry',0,'',0,'LineageMonster4.Dragon_centurion_120p',22.00,42.00,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22563,22563,'Defeated Troops Magic Leader',0,'',0,'LineageMonster4.dragon_mage_075p',28.00,39.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22564,22564,'Defeated Troops Magician',0,'',0,'LineageMonster4.dragon_mage_075p',28.00,39.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22565,22565,'Defeated Troops Magic Soldier',0,'',0,'LineageMonster4.dragon_mage_065p',25.00,34.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22566,22566,'Defeated Troops Healer',0,'',0,'LineageMonster4.dragon_mage_065p',25.00,34.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22567,22567,'Defeated Troops Javelin Thrower',0,'',0,'LineageMonster4.dragon_peltast',25.00,46.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22568,22568,'Defeated Troops Javelin Thrower',0,'',0,'LineageMonster4.dragon_peltast',25.00,46.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22569,22569,'Soldiers of Bravery',0,'Tiat\'s Bodyguard',0,'LineageMonster4.dragon_rider',36.00,51.00,85,'male','L2Monster',40,528731,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22570,22570,'Royal Guard Captain',0,'',0,'LineageMonster4.Dragon_eliteguard_075p',40.00,55.00,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22571,22571,'Dragon Steed Troop Grand Magician',0,'',0,'LineageMonster4.Dragon_archmage_135p',25.00,49.90,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22572,22572,'Dragon Steed Troop Commander',0,'',0,'LineageMonster4.Dragon_centurion_135p',28.00,46.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22573,22573,'Dragon Steed Troops No 1 Battalion Commander',0,'',0,'LineageMonster4.Dragon_centurion_135p',28.00,46.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22574,22574,'White Dragon Leader',0,'',0,'LineageMonster4.Dragon_centurion_120p',22.00,42.00,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,13979,13980,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22575,22575,'Dragon Steed Troop Infantry',0,'',0,'LineageMonster4.Dragon_centurion_120p',22.00,42.00,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22576,22576,'Dragon Steed Troop Magic Leader',0,'',0,'LineageMonster4.dragon_mage_075p',28.00,39.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22577,22577,'Dragon Steed Troop Magician',0,'',0,'LineageMonster4.dragon_mage_075p',28.00,39.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22578,22578,'Dragon Steed Troop Magic Soldier',0,'',0,'LineageMonster4.dragon_mage_065p',25.00,34.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22579,22579,'Warrior of Light',0,'',0,'LineageMonster4.dragon_berserker_090p',50.00,55.00,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22580,22580,'Dragon Steed Troop Healer',0,'',0,'LineageMonster4.dragon_mage_065p',25.00,34.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22581,22581,'Dragon Steed Troop Javelin Thrower',0,'',0,'LineageMonster4.dragon_peltast',25.00,46.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22582,22582,'Dragon Steed Troop Javelin Thrower',0,'',0,'LineageMonster4.dragon_peltast',25.00,46.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22583,22583,'Dragon Steed Troop Magic Leader',0,'',0,'LineageMonster4.dragon_mage_075p',28.00,39.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22584,22584,'Dragon Steed Troop Magician',0,'',0,'LineageMonster4.dragon_mage_075p',28.00,39.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22585,22585,'Dragon Steed Troop Magic Soldier',0,'',0,'LineageMonster4.dragon_mage_065p',25.00,34.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22586,22586,'Dragon Steed Troop Commander',0,'',0,'LineageMonster4.Dragon_centurion_135p',28.00,46.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22587,22587,'Dragon Steed Troop Captain #1',0,'',0,'LineageMonster4.Dragon_centurion_135p',28.00,46.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22588,22588,'White Dragon Leader',0,'',0,'LineageMonster4.Dragon_centurion_120p',22.00,42.00,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22589,22589,'Dragon Steed Troop Infantry',0,'',0,'LineageMonster4.Dragon_centurion_120p',22.00,42.00,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22590,22590,'',0,'',0,'LineageNPC.clear_npc',8.00,23.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22591,22591,'Dragon Steed Troop Magic Leader',0,'',0,'LineageMonster4.dragon_mage_075p',28.00,39.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22592,22592,'Dragon Steed Troop Magician',0,'',0,'LineageMonster4.dragon_mage_075p',28.00,39.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22593,22593,'Dragon Steed Troop Magic Soldier',0,'',0,'LineageMonster4.dragon_mage_065p',25.00,34.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,13981,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22594,22594,'Dragon Steed Troop Commander',0,'',0,'LineageMonster4.Dragon_centurion_135p',28.00,46.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22595,22595,'Dragon Steed Troops No 1 Battalion Commander',0,'',0,'LineageMonster4.Dragon_centurion_135p',28.00,46.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22596,22596,'White Dragon Leader',0,'',0,'LineageMonster4.Dragon_centurion_120p',22.00,42.00,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,13979,13980,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22597,22597,'Dragon Steed Troop Infantry',0,'',0,'LineageMonster4.Dragon_centurion_120p',22.00,42.00,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,13979,13980,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22598,22598,'Obelisk',0,'',0,'LineageNpcEV.obelisk_of_middle_square',229.00,177.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22599,22599,'Great Powerful Device',0,'',0,'LineageNpcEV.crystal_of_secret_door',57.00,74.00,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22600,22600,'Throne of Destruction Powerful Device',0,'',0,'LineageNpcEV.protector_of_seed',57.00,74.00,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22601,22601,'Heart Protection Device',0,'',0,'LineageNpcEV.crystal_of_secret_door',57.00,74.00,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22602,22602,'Mutant - Bird',0,'',0,'LineageMonster4.mutant_hawk',100.00,85.00,73,'male','L2FlyMonster',40,4087,1601,56.86,3.09,40,43,30,21,20,10,14171,1458,871,452,406,367,278,0,333,0,0,0,0,64,180,0,0,'LAST_HIT','false'),
(22603,22603,'Mutant - Bird',0,'',0,'LineageMonster4.mutant_hawk',100.00,85.00,74,'male','L2FlyMonster',40,4159,1637,56.86,3.09,40,43,30,21,20,10,14562,1517,901,462,416,375,278,0,333,0,0,0,0,64,180,0,0,'LAST_HIT','false'),
(22604,22604,'Dra Hawk',0,'',0,'LineageMonster4.drahawk',110.00,35.00,74,'male','L2FlyMonster',40,4159,1637,56.86,3.09,40,43,30,21,20,10,9167,955,901,462,416,375,278,0,333,0,0,0,0,64,180,0,0,'LAST_HIT','false'),
(22605,22605,'Dra Hawk',0,'',0,'LineageMonster4.drahawk',110.00,35.00,75,'male','L2FlyMonster',40,4229,1674,56.86,3.09,40,43,30,21,20,10,9416,993,931,471,434,383,278,0,333,0,0,0,0,64,180,0,0,'LAST_HIT','false'),
(22606,22606,'Floating Skull',0,'',0,'LineageMonster4.floating_skeleton',28.00,39.00,76,'male','L2FlyMonster',40,4358,1710,56.86,3.09,40,43,30,21,20,10,10528,1125,971,481,449,391,278,0,333,0,0,0,0,64,180,0,0,'LAST_HIT','false'),
(22607,22607,'Floating Skull',0,'',0,'LineageMonster4.floating_skeleton',28.00,39.00,77,'male','L2FlyMonster',40,4514,1747,56.86,3.09,40,43,30,21,20,10,17574,1901,1015,490,469,398,278,0,333,0,0,0,0,64,180,0,0,'LAST_HIT','false'),
(22608,22608,'Floating Zombie',0,'',0,'LineageMonster4.floating_zombie',70.00,50.00,75,'male','L2FlyMonster',40,4229,1674,56.86,3.09,40,43,30,21,20,10,9720,1025,931,471,434,383,278,0,333,0,0,0,0,64,180,0,0,'LAST_HIT','false'),
(22609,22609,'Floating Zombie',0,'',0,'LineageMonster4.floating_zombie',70.00,50.00,76,'male','L2FlyMonster',40,4358,1710,56.86,3.09,40,43,30,21,20,10,9475,1012,971,481,449,391,278,0,333,0,0,0,0,64,180,0,0,'LAST_HIT','false'),
(22610,22610,'Mutated Drake Wing',0,'',0,'LineageMonster4.m_drake_wing_knave',153.00,63.00,75,'male','L2FlyMonster',40,4229,1674,56.86,3.09,40,43,30,21,20,10,11981,1263,931,471,434,383,278,0,333,0,0,0,0,64,180,0,0,'LAST_HIT','false'),
(22611,22611,'Mutated Drake Wing',0,'',0,'LineageMonster4.m_drake_wing_knave',153.00,63.00,76,'male','L2FlyMonster',40,4358,1710,56.86,3.09,40,43,30,21,20,10,11797,1261,971,481,449,391,278,0,333,0,0,0,0,64,180,0,0,'LAST_HIT','false'),
(22612,22612,'Drak',0,'',0,'LineageMonster4.drac',100.00,40.00,76,'male','L2FlyMonster',40,4358,1710,56.86,3.09,40,43,30,21,20,10,11485,1227,971,481,449,391,278,0,333,0,0,0,0,64,180,0,0,'LAST_HIT','false'),
(22613,22613,'Drak',0,'',0,'LineageMonster4.drac',100.00,40.00,77,'male','L2FlyMonster',40,4514,1747,56.86,3.09,40,43,30,21,20,10,11789,1275,1015,490,469,398,278,0,333,0,0,0,0,64,180,0,0,'LAST_HIT','false'),
(22614,22614,'Vulture Rider',0,'',0,'LineageMonster4.master_rider',123.00,90.00,74,'male','L2FlyMonster',40,4159,1637,56.86,3.09,40,43,30,21,20,10,10093,1052,901,462,416,375,278,0,333,0,0,0,0,64,180,0,0,'LAST_HIT','false'),
(22615,22615,'Vulture Rider',0,'',0,'LineageMonster4.master_rider',123.00,90.00,75,'male','L2FlyMonster',40,4229,1674,56.86,3.09,40,43,30,21,20,10,10368,1093,931,471,434,383,278,0,333,0,0,0,0,64,180,0,0,'LAST_HIT','false'),
(22616,22616,'Seed of Pain',0,'',0,'LineageMonster4.death_claw_054p',8.00,23.50,1,'male','L2Monster',40,2444,2444,0.00,0.00,10,10,10,10,10,10,0,0,500,500,500,500,253,0,253,0,0,NULL,0,80,120,0,0,'LAST_HIT','false'),
(22617,22617,'Spiked Stakato',0,'',0,'LineageMonster.blade_stakato_120p',18.00,43.20,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22618,22618,'Spiked Stakato Worker',0,'',0,'LineageMonster.blade_stakato_worker_120p',22.00,48.30,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22619,22619,'Spiked Stakato Guard',0,'',0,'LineageMonster.spike_stakato',16.00,22.80,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22620,22620,'Female Spiked Stakato',0,'',0,'LineageMonster.spike_stakato_soldier',17.00,30.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22621,22621,'Male Spiked Stakato',0,'',0,'LineageMonster.marsh_stakato_soldier_120p',18.00,31.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22622,22622,'Male Spiked Stakato',0,'',0,'LineageMonster3.marsh_stakato_soldier_tran',16.00,28.40,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22623,22623,'Spiked Stakato Sorcerer',0,'',0,'LineageMonster.blade_stakato_queen_120p',24.00,43.60,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22624,22624,'Cannibalistic Stakato Follower',0,'',0,'LineageMonster.spike_stakato_worker',17.00,29.80,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22625,22625,'Cannibalistic Stakato Leader',0,'',0,'LineageMonster3.cannibal_stakato_leader_120p',34.00,48.80,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22626,22626,'Cannibalistic Stakato Leader',0,'',0,'LineageMonster3.cannibal_stakato_leader_tran',40.00,42.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22627,22627,'Spiked Stakato Soldier',0,'',0,'LineageMonster.blade_stakato_120p',18.00,43.20,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22628,22628,'Spiked Stakato Drone',0,'',0,'LineageMonster.blade_stakato_drone_120p',28.00,47.30,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22629,22629,'Spiked Stakato Captain',0,'',0,'LineageMonster.marsh_stakato_drone_120p',14.00,29.10,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22630,22630,'Spike Stakato Nurse',0,'',0,'LineageMonster.marsh_stakato_queen_120p',26.00,43.80,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22631,22631,'Spike Stakato Nurse',0,'',0,'LineageMonster3.marsh_stakato_queen_tran',18.00,36.40,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22632,22632,'Spiked Stakato Baby',0,'',0,'LineageMonster.spike_stakato_drone',16.00,29.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22633,22633,'Spiked Stakato Shaman',0,'',0,'LineageMonster.blade_stakato_queen_120p',24.00,45.60,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22634,22634,'Scarlet Stakato Worker',0,'',0,'LineageMonster.blade_stakato_worker',13.00,40.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22635,22635,'Scarlet Stakato Soldier',0,'',0,'LineageMonster.blade_stakato_soldier',15.00,38.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22636,22636,'Scarlet Stakato Noble',0,'',0,'LineageMonster.blade_stakato_drone',15.00,39.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22637,22637,'Tepra Scorpion',0,'',0,'LineageMonster2.scorpion_20_sm',24.00,52.80,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22638,22638,'Tepra Scarab',0,'',0,'LineageMonster2.scarab',14.00,22.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22639,22639,'Assassin Beetle',0,'',0,'LineageMonster2.tera_beetle',19.00,54.50,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22640,22640,'Mercenary of Destruction',0,'',0,'LineageMonster.skeleton_knight',10.00,25.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22641,22641,'Knight of Destruction',0,'',0,'LineageMonster.skeleton_royal_guard',11.00,28.50,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22642,22642,'Lavastone Golem',0,'',0,'LineageMonster.stone_golem',20.00,31.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22643,22643,'Magma Golem',0,'',0,'LineageMonster2.lava_golem',22.00,45.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22644,22644,'Arimanes of Destruction',0,'',0,'LineageMonster2.ahrimanes',14.00,57.75,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22645,22645,'Balrog of Destruction',0,'',0,'LineageMonster.fiend_archer',17.00,55.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22646,22646,'Ashuras of Destruction',0,'',0,'LineageMonster2.ashuras_30_bi',17.00,49.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22647,22647,'Lavasillisk',0,'',0,'LineageMonster.lesser_basilisk',34.00,25.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22648,22648,'Blazing Ifrit',0,'',0,'LineageMonster2.ifrit_30_bi',13.00,55.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22649,22649,'Magma Drake',0,'',0,'LineageMonster2.inferno_drake_20_bi',29.00,42.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22650,22650,'Mucrokian Fanatic',0,'',0,'LineageMonster3.Crokian_Officer_blue_b_120p',25.00,41.00,83,'male','L2Monster',40,6060,1777,56.86,3.09,40,43,30,21,20,20,15611,1607,2835,2865,820,1075,278,0,333,0,0,0,0,60,170,0,0,'LAST_HIT','true'),
(22651,22651,'Mucrokian Ascetic',0,'',0,'LineageMonster3.Crokian_Officer_red_a_120p',25.00,41.00,83,'male','L2Monster',40,6060,1777,56.86,3.09,40,43,30,21,20,20,16145,1665,2835,2865,820,1075,278,0,333,0,0,0,0,60,170,0,0,'LAST_HIT','true'),
(22652,22652,'Mucrokian Savior',0,'',0,'LineageMonster3.Crokian_Officer_blue_a_120p',5.00,41.00,84,'male','L2Monster',40,6382,1812,56.86,3.09,40,43,30,21,20,20,16377,1658,2835,2865,820,1075,278,0,333,0,0,0,0,60,170,0,0,'LAST_HIT','true'),
(22653,22653,'Mucrokian Preacher',0,'',0,'LineageMonster3.Crokian_Officer_red_b_120p',25.00,41.00,84,'male','L2Monster',40,6382,1812,56.86,3.09,40,43,30,21,20,20,16938,1725,2835,2865,820,1075,278,0,333,0,0,0,0,60,170,0,0,'LAST_HIT','true'),
(22654,22654,'Contaminated Mucrokian',0,'',0,'LineageMonster.crokian_e',18.00,29.00,83,'male','L2Monster',40,6060,1777,56.86,3.09,40,43,30,21,20,20,5574,1204,2065,1228,820,855,278,500,333,5128,0,0,0,80,180,0,0,'LAST_HIT','true'),
(22655,22655,'Awakened Mucrokian',0,'',0,'LineageMonster3.Crokian_Elder_raid_120p',30.00,52.00,84,'male','L2Monster',40,6382,1812,56.86,3.09,40,43,30,21,20,20,14980,3042,3115,2865,820,1355,278,0,333,0,0,0,0,60,170,0,0,'LAST_HIT','true'),
(22656,22656,'Suppressor',0,'',0,'LineageMonster3.golem_cannon_catapult_a_120p',23.50,41.50,83,'male','L2Monster',40,6060,1777,56.86,3.09,40,43,30,21,20,20,15611,1607,2835,730,820,1075,278,0,333,0,0,0,0,60,170,0,0,'LAST_HIT','true'),
(22657,22657,'Exterminator',0,'',0,'LineageMonster3.golem_carrier_120p',23.00,41.50,84,'male','L2Monster',40,6382,1812,56.86,3.09,40,43,30,21,20,20,16377,1665,2835,730,820,1075,278,0,333,0,0,0,0,60,170,0,0,'LAST_HIT','true'),
(22658,22658,'Evil Spirits in Magic Force',0,'',0,'LineageMonster4.Anthias',20.00,41.00,83,'male','L2Monster',40,6060,1777,56.86,3.09,40,43,30,21,20,20,16145,1665,2835,730,820,1075,278,0,333,0,0,0,0,60,170,0,0,'LAST_HIT','true'),
(22659,22659,'Guardian Waterspirit',0,'',0,'LineageMonster4.tears_d',20.00,25.70,84,'male','L2Monster',40,6382,1812,56.86,3.09,40,43,30,21,20,20,16938,1725,2835,730,820,1075,278,0,333,9638,9638,0,0,60,170,0,0,'LAST_HIT','true'),
(22660,22660,'Lesser Giant',0,'',0,'LineageMonster.lesser_giant_50_bi',31.50,69.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22661,22661,'Lesser Giant Soldier',0,'',0,'LineageMonster.lesser_giant_50_bi',31.50,69.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22662,22662,'Lesser Giant Shooter',0,'',0,'LineageMonster.lesser_giant_shooter_50_bi',30.00,66.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22663,22663,'Lesser Giant Scout',0,'',0,'LineageMonster.lesser_giant_shooter_50_bi',30.00,66.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22664,22664,'Lesser Giant Mage',0,'',0,'LineageMonster.lesser_giant_mage_50_bi',30.00,66.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22665,22665,'Lesser Giant Elder',0,'',0,'LineageMonster.lesser_giant_mage_50_bi',30.00,66.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22666,22666,'Barif',0,'',0,'LineageMonster.lesser_giant_mage_50_bi',30.00,66.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22667,22667,'Barif\'s Pet',0,'',0,'LineageMonster.leogul',15.00,35.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22668,22668,'Gamlin',0,'Scout',0,'LineageMonster.gamlin',11.00,32.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22669,22669,'Leogul',0,'Scout',0,'LineageMonster.leogul',15.00,35.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22670,22670,'Cursed Lord',0,'',0,'LineageMonster.vampire_bat_bi_120p',10.00,56.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22671,22671,'Cursed Guardian!',0,'',0,'LineageMonster.onyx_beast',14.00,14.50,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22672,22672,'Cursed Seer',0,'',0,'LineageMonster.gargoyle_bi',16.00,65.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22673,22673,'Hirokai',0,'',0,'LineageMonster.vampire_bat_bi',10.00,42.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22674,22674,'Imagro',0,'',0,'LineageMonster.gargoyle_bi',16.00,65.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22675,22675,'Palit',0,'',0,'LineageMonster2.brain_buster',20.00,29.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22676,22676,'Hamlet',0,'',0,'LineageMonster.hunter_gargoyle',25.00,65.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22677,22677,'Klennot',0,'',0,'LineageMonster.ogre',21.00,44.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22678,22678,'Grave Robber Summoner',0,'Lunatic',0,'LineageMonster.wererat_e',14.00,25.00,81,'male','L2Monster',40,5468,1708,13.43,3.09,40,43,30,21,20,20,18634,2063,2203,2471,1607,2682,253,0,333,0,0,0,0,60,140,0,0,'LAST_HIT','false'),
(22679,22679,'Grave Robber Magician',0,'Lunatic',0,'LineageMonster.wererat_e',14.00,25.00,82,'male','L2Monster',40,5756,1743,13.43,3.09,40,43,30,21,20,20,19572,2140,2203,2471,1607,2882,253,0,333,0,0,0,0,60,140,0,0,'LAST_HIT','false'),
(22680,22680,'Grave Robber Worker',0,'Lunatic',0,'LineageMonster.wererat_110p',14.00,27.50,81,'male','L2Monster',40,5468,1708,13.43,3.09,40,43,30,21,20,20,16063,1778,2503,2471,1407,2582,253,0,333,0,0,0,0,60,140,0,0,'LAST_HIT','false'),
(22681,22681,'Grave Robber Warrior',0,'Lunatic',0,'LineageMonster.wererat_110p',14.00,27.50,82,'male','L2Monster',40,5756,1743,13.43,3.09,40,43,30,21,20,20,16871,1845,2503,2471,1407,2582,253,0,333,0,0,0,0,60,140,0,0,'LAST_HIT','false'),
(22682,22682,'Grave Robber Warrior of Light',0,'Lunatic',0,'LineageMonster.wererat_110p',14.00,27.50,82,'male','L2Monster',40,5756,1743,13.43,3.09,40,43,30,21,20,20,18659,2040,2303,2471,1607,2682,253,350,333,0,0,0,0,60,140,0,0,'LAST_HIT','false'),
(22683,22683,'Servitor of Darkness',0,'',0,'LineageMonster.shadeless',7.00,33.00,81,'male','L2Monster',40,5468,1708,13.43,3.09,40,43,30,21,20,20,20453,2266,2303,2471,1607,2582,253,0,333,0,0,0,0,60,140,0,0,'LAST_HIT','false'),
(22684,22684,'Servitor of Darkness',0,'',0,'LineageMonster.shadow_a_110p',10.00,25.00,81,'male','L2Monster',40,5468,1708,13.43,3.09,40,43,30,21,20,20,20453,2266,2303,2471,1607,2882,253,0,333,0,0,0,0,60,140,0,0,'LAST_HIT','false'),
(22685,22685,'Servitor of Darkness',0,'',0,'LineageMonster2.knight_of_shadow',10.00,35.50,81,'male','L2Monster',40,5468,1708,13.43,3.09,40,43,30,21,20,20,20453,2266,2303,2471,1607,2582,253,0,333,0,0,0,0,60,140,0,0,'LAST_HIT','false'),
(22686,22686,'Servitor of Darkness',0,'',0,'LineageMonster3.spectral_knight',12.50,33.50,81,'male','L2Monster',40,5468,1708,13.43,3.09,40,43,30,21,20,20,20453,2266,2303,2471,1607,2882,253,0,333,0,0,0,0,60,140,0,0,'LAST_HIT','false'),
(22687,22687,'Phantoms of the Mine',0,'',0,'LineageMonster.banshee_20_bi',10.00,27.50,81,'male','L2Monster',40,5468,1708,13.43,3.09,40,43,30,21,20,20,18303,2027,2303,2471,1607,2582,253,0,333,0,0,0,0,60,140,0,0,'LAST_HIT','false'),
(22688,22688,'Evil Spirits of the Mine',0,'',0,'LineageMonster.vale_master',12.00,40.00,82,'male','L2Monster',40,5756,1743,13.43,3.09,40,43,30,21,20,20,19224,2101,2303,2471,1607,2582,253,400,333,0,0,0,0,60,140,0,0,'LAST_HIT','false'),
(22689,22689,'Mine Bug',0,'',0,'LineageMonster.ant_larva_e',12.00,9.00,82,'male','L2Monster',40,5756,1743,13.43,3.09,40,43,30,21,20,20,42004,4528,2303,2471,1607,2882,253,400,333,0,0,0,0,60,140,0,0,'LAST_HIT','false'),
(22690,22690,'Earthworm\'s Descendant',0,'',0,'LineageMonster.devastator_e',35.00,35.00,82,'male','L2Monster',40,5756,1743,13.43,3.09,40,43,30,21,20,20,20165,2204,2303,2471,1607,2882,253,0,333,0,0,0,0,60,140,0,0,'LAST_HIT','false'),
(22691,22691,'Ragna Orc',0,'Spirit Infested',0,'LineageMonster.batur_orc_03te_120p',9.00,25.25,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22692,22692,'Ragna Orc Warrior',0,'Spirit Infested',0,'LineageMonster.batur_orc_warrior_03te_120p',10.00,24.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22693,22693,'Ragna Orc Hero',0,'Spirit Infested',0,'LineageMonster.batur_orc_overlord_03te_120p',12.00,28.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22694,22694,'Ragna Orc Commander',0,'Spirit Infested',0,'LineageMonster.orc_champion_20_bi_e',12.00,27.60,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22695,22695,'Ragna Orc Healer',0,'Spirit Infested',0,'LineageMonster.batur_orc_shaman_a_03te_120p_e',11.00,20.80,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22696,22696,'Ragna Orc Shaman',0,'Spirit Infested',0,'LineageMonster.batur_orc_shaman_a_01te_120p_e',11.00,21.50,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22697,22697,'Ragna Orc Seer',0,'Spirit Infested',0,'LineageMonster.orc_shaman_120p',9.00,27.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22698,22698,'Ragna Orc Archer',0,'Spirit Infested',0,'LineageMonster.batur_orc_archer_03te_120p',11.00,26.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22699,22699,'Ragna Orc Sniper',0,'Spirit Infested',0,'LineageMonster.batur_orc_archer_01te_120p',11.00,26.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22700,22700,'Varangka\'s Guardian',0,'',0,'LineageMonster2.ahrimanes_70p',14.00,39.50,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22701,22701,'Varangka\'s Dre Vanul',0,'',0,'LineageMonster.fiend_archer_20_sm',14.00,44.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22702,22702,'Varangka\'s Destroyer',0,'',0,'LineageMonster.kaim_vanul_20_sm',19.00,32.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22703,22703,'Contaminated Morek Warrior',0,'',0,'LineageMonster.batur_orc_overlord_20_bi',14.00,28.80,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22704,22704,'Contaminated Batur Warrior',0,'',0,'LineageMonster.ketra_orc_20_bi',14.00,34.80,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22705,22705,'Contaminated Batur Commander',0,'',0,'LineageMonster.ketra_orc_warrior_20_bi',14.00,28.80,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22706,22706,'Turka Follower\'s Ghost',0,'',0,'LineageMonster.ketra_orc_overload_20_bi_op',14.00,28.80,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22707,22707,'Turka Commander\'s Ghost',0,'Grave Guardian Spirit',0,'LineageMonster2.ketra_orc_chieftain_20_bi_op',17.00,46.20,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22708,22708,'Invader Warrior of Nightmare',0,'',0,'LineageMonster2.imperial_warlord_zombie',7.00,30.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22709,22709,'Invader Healer of Nightmare',0,'',0,'LineageMonster.doll_master',20.00,42.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22710,22710,'Invader Guide of Nightmare',0,'',0,'LineageMonster.doll_master',20.00,42.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22711,22711,'Invader Destroyer of Nightmare',0,'',0,'LineageMonster.death_blader',15.00,45.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22712,22712,'Invader Assassin of Nightmare',0,'',0,'LineageMonster5.doll_degenerated',15.00,20.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22713,22713,'Invader Shaman of Nightmare',0,'',0,'LineageMonster5.twisted_banshee',15.00,26.50,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22714,22714,'Invader Archer of Nightmare',0,'',0,'LineageMonster5.skeleton_hunter',13.00,26.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22715,22715,'Invader Soldier of Nightmare',0,'',0,'LineageMonster2.giant_zombie',13.00,40.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22716,22716,'Invader Soldier of Nightmare',0,'',0,'LineageMonster2.giant_zombie',13.00,40.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22717,22717,'Invader Disciple of Nightmare',0,'',0,'LineageMonster.neer_crawler',14.00,22.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22718,22718,'Invader Elite Soldier of Nightmare',0,'',0,'LineageMonster.death_lord',21.00,40.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22719,22719,'Nihil Invader Warrior',0,'',0,'LineageMonster5.dimension_caller',25.00,40.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22720,22720,'Nihil Invader Healer',0,'',0,'LineageMonster5.scapegoat',20.00,32.50,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22721,22721,'Nihil Invader Guide',0,'',0,'LineageMonster5.scapegoat',20.00,32.50,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22722,22722,'Nihil Invader Destroyer',0,'',0,'LineageMonster5.mixed_skeleton_guard',29.00,40.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22723,22723,'Nihil Invader Assassin',0,'',0,'LineageMonster5.zombie_guadian',14.00,32.50,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22724,22724,'Nihil Invader Shaman',0,'',0,'LineageMonster5.scapegoat',20.00,32.50,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22725,22725,'Nihil Invader Archer',0,'',0,'LineageMonster5.skeleton_boneshooter',18.00,27.50,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22726,22726,'Nihil Invader Soldier',0,'',0,'LineageMonster5.chaos_zombie',28.00,41.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22727,22727,'Nihil Invader Soldier',0,'',0,'LineageMonster5.chaos_zombie',28.00,41.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22728,22728,'Nihil Invader Disciple',0,'',0,'LineageMonster5.bloody_princess',18.00,33.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22729,22729,'Nihil Invader Elite Soldier',0,'',0,'LineageMonster5.dimension_caller',25.00,40.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22730,22730,'Mutant Warrior',0,'',0,'LineageMonster5.dimension_caller',25.00,40.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22731,22731,'Mutant Healer',0,'',0,'LineageMonster5.doll_claw',28.00,50.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22732,22732,'Mutant Guide',0,'',0,'LineageMonster5.doll_claw',28.00,50.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22733,22733,'Mutant Destroyer',0,'',0,'LineageMonster5.mixed_skeleton_guard',29.00,40.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22734,22734,'Mutant Assassin',0,'',0,'LineageMonster5.zombie_guadian',14.00,32.50,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22735,22735,'Mutant Shaman',0,'',0,'LineageMonster5.doll_claw',28.00,50.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22736,22736,'Mutant Overlord',0,'',0,'LineageMonster5.skeleton_sniper',20.00,34.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22737,22737,'Mutant Soldier',0,'',0,'LineageMonster5.chaos_zombie',28.00,41.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22738,22738,'Mutant Soldier',0,'',0,'LineageMonster5.chaos_zombie',28.00,41.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22739,22739,'Mutant Disciple',0,'',0,'LineageMonster5.bloody_king',30.00,45.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22740,22740,'Mutant Elite Soldier',0,'',0,'LineageMonster5.mistress_of_dimension',15.00,35.00,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22741,22741,'Grave Robber Warrior',0,'',0,'LineageMonster.wererat_110p',14.00,27.50,82,'male','L2Monster',40,3643,1743,13.43,3.09,40,43,30,21,20,20,16871,1845,2303,2471,1607,1382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22742,22742,'Ornithomimus',0,'',0,'LineageMonster3.ornithomimus',15.00,37.20,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22743,22743,'Deinonychus',0,'',0,'LineageMonster3.deinonychus',14.00,14.30,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22744,22744,'Ornithomimus',0,'',0,'LineageMonster3.ornithomimus',15.00,37.20,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false'),
(22745,22745,'Deinonychus',0,'',0,'LineageMonster3.deinonychus',14.00,14.30,80,'male','L2Monster',40,3862,1494,0.00,0.00,40,43,30,21,20,20,0,0,1303,471,607,382,253,0,333,0,0,0,0,60,120,0,0,'LAST_HIT','false');

INSERT INTO `npc` VALUES
(25001,25001,'Greyclaw Kutus',0,'Raid Boss',0,'LineageMonster.ol_mahum_champion_50_bi',21.00,43.50,23,'male','L2RaidBoss',40,95986,545,117.62,4.73,60,57,73,76,70,80,714843,67170,84,321,1,174,409,0,3819,67,633,0,0,50,170,0,0,'LAST_HIT','false'),
(25002,25002,'Guard of Kutus',0,'Raid Fighter',0,'LineageMonster.ol_mahum',13.50,25.00,22,'male','L2Minion',40,6613,257,29.94,4.73,40,43,30,41,20,10,0,0,204,154,21,167,278,0,333,7,0,0,0,50,170,0,0,'LAST_HIT','false'),
(25003,25003,'Pawn of Kutus',0,'Raid Fighter',0,'LineageMonster.ol_mahum',13.50,25.00,22,'male','L2Minion',40,9870,257,29.94,4.73,40,43,30,41,20,10,0,0,305,154,164,167,278,0,333,123,0,0,0,50,170,0,0,'LAST_HIT','false'),
(25004,25004,'Turek Mercenary Captain',0,'Raid Boss',0,'LineageMonster.orc_champion_50_bi',15.00,35.00,30,'male','L2RaidBoss',40,168366,763,310.14,5.72,60,57,73,76,70,80,1424160,129276,295,423,26,229,278,0,3819,124,0,0,0,72,275,0,0,'LAST_HIT','false'),
(25005,25005,'Turek Mercenary Archer',0,'Raid Fighter',0,'LineageMonster.orc_archer',14.00,25.00,29,'male','L2Minion',500,11414,365,79.32,4.73,40,43,30,41,20,10,0,0,539,204,84,220,249,0,333,271,0,0,0,49,187,0,0,'LAST_HIT','false'),
(25006,25006,'Turek Mercenary Warrior',0,'Raid Fighter',0,'LineageMonster.orc_fighter',12.00,22.00,29,'male','L2Minion',40,8518,365,79.32,4.73,40,43,30,41,20,10,0,0,539,204,84,220,278,0,333,2,0,0,0,49,187,0,0,'LAST_HIT','false'),
(25007,25007,'Retreat Spider Cletu',0,'Raid Boss',0,'LineageMonster.poison_spider',27.00,25.50,42,'male','L2RaidBoss',40,331522,1062,428.19,5.72,60,57,73,76,70,80,2299956,251972,793,648,97,351,409,0,3819,0,0,0,0,60,170,0,0,'LAST_HIT','false'),
(25008,25008,'Cletu\'s Retainer',0,'Raid Fighter',0,'LineageMonster.giant_spider',26.00,25.50,41,'male','L2Minion',40,33216,514,110.41,5.72,40,43,30,41,20,10,0,0,1467,313,353,339,278,0,333,0,0,0,0,72,170,0,0,'LAST_HIT','false'),
(25009,25009,'Cletu\'s Pawn',0,'Raid Fighter',0,'LineageMonster.giant_spider',26.00,25.50,41,'male','L2Minion',40,16608,514,110.41,5.72,40,43,30,41,20,10,0,0,1467,313,353,339,278,0,333,0,0,0,0,72,170,0,0,'LAST_HIT','false'),
(25010,25010,'Furious Thieles',0,'Raid Boss',0,'LineageMonster.ti_mi_tran',23.00,90.00,55,'male','L2RaidBoss',40,624464,2039,592.29,7.70,60,57,73,76,70,80,2988757,448385,1958,966,376,523,278,0,3819,0,0,0,0,19,81,0,0,'LAST_HIT','false'),
(25011,25011,'Guard of Thieles',0,'Raid Fighter',0,'LineageMonster.zenta_lizardman_scout',11.00,30.00,54,'male','L2Minion',500,42806,987,153.99,7.70,40,43,30,41,20,10,0,0,3683,470,1402,508,249,0,333,279,0,0,0,40,187,0,0,'LAST_HIT','false'),
(25012,25012,'Follower of Thieles',0,'Raid Fighter',0,'LineageMonster.dryad',9.00,20.00,54,'female','L2Minion',40,31945,987,153.99,7.70,40,43,30,41,20,10,0,0,3683,470,1402,508,278,0,333,0,0,0,0,44,187,0,0,'LAST_HIT','false'),
(25013,25013,'Ghost of Peasant Leader',0,'Raid Boss',0,'LineageMonster.skeleton_knight_50_bi',15.00,39.00,50,'male','L2RaidBoss',40,507285,1722,529.53,7.70,60,57,73,76,70,80,2494222,346727,1419,835,222,452,278,0,3819,145,0,0,0,64,275,1,0,'LAST_HIT','false'),
(25014,25014,'Ghost of Peasant',0,'Raid Fighter',0,'LineageMonster.skeleton',11.00,25.00,49,'male','L2Minion',40,51380,830,137.24,6.74,40,43,30,41,20,10,0,0,5299,405,3222,438,278,0,333,68,0,0,0,66,187,1,0,'LAST_HIT','false'),
(25015,25015,'Ghost of Peasant',0,'Raid Fighter',0,'LineageMonster.skeleton_archer',11.00,27.00,49,'male','L2Minion',500,25690,830,137.24,6.74,40,43,30,41,20,10,0,0,2650,405,807,438,278,0,333,14,0,0,0,44,187,1,0,'LAST_HIT','false'),
(25016,25016,'The 3rd Underwater Guardian',0,'Raid Boss',0,'LineageMonster.susceptor_100_bi',40.00,73.00,60,'male','L2RaidBoss',40,188376,2368,702.39,8.75,60,57,73,76,70,80,3346092,522780,2604,1107,556,599,278,0,3819,0,0,0,0,43,243,0,0,'LAST_HIT','false'),
(25017,25017,'Escort of the 3rd Guardian',0,'Raid Fighter',0,'LineageMonster.will_o_wisp',13.00,22.00,59,'male','L2Minion',40,24399,1150,183.19,7.70,40,43,30,41,20,10,0,0,4935,539,2037,583,278,0,333,0,0,0,0,88,187,0,0,'LAST_HIT','false'),
(25018,25018,'Support of the 3rd Guardian',0,'Raid Fighter',0,'LineageMonster.will_o_wisp',13.00,22.00,59,'male','L2Minion',40,12199,1150,183.19,7.70,40,43,30,41,20,10,0,0,4935,539,2037,583,278,0,333,0,0,0,0,88,187,0,0,'LAST_HIT','false'),
(25019,25019,'Pan Dryad',0,'Raid Boss',0,'LineageMonster.pan_100_bi',42.00,73.00,25,'male','L2RaidBoss',40,206185,606,127.71,4.73,60,57,73,76,70,80,730469,69595,201,348,19,189,614,0,3819,291,0,0,0,45,170,0,0,'LAST_HIT','false'),
(25020,25020,'Breka Warlock Pastu',0,'Raid Boss',0,'LineageMonster.batur_orc_shaman_100_bi',22.00,35.00,34,'male','L2RaidBoss',40,156584,893,178.88,5.72,60,57,73,76,70,80,1174184,135023,222,491,9,266,278,0,3819,8,0,0,0,81,275,0,0,'LAST_HIT','false'),
(25021,25021,'Pastu\'s Silhouette',0,'Raid Fighter',0,'LineageMonster.silhouette',8.00,23.00,33,'female','L2Minion',40,15774,430,45.88,5.72,40,43,30,41,20,10,0,0,408,236,46,256,278,0,333,0,0,0,0,88,187,0,0,'LAST_HIT','false'),
(25022,25022,'Pastu\'s Shadow',0,'Raid Fighter',0,'LineageMonster.shadow',10.00,30.00,33,'male','L2Minion',40,7887,430,45.88,5.72,40,43,30,41,20,10,0,0,408,236,46,256,278,0,333,0,0,0,0,88,187,0,0,'LAST_HIT','false'),
(25023,25023,'Stakato Queen Zyrnna',0,'Raid Boss',0,'LineageMonster.marsh_stakato_queen_100_bi',30.00,76.00,34,'female','L2RaidBoss',40,208019,1415,332.20,6.74,60,57,73,76,70,80,1753455,156895,416,491,43,266,278,0,3819,150,0,0,0,81,275,0,0,'LAST_HIT','false'),
(25024,25024,'Jeruna\'s Guard Captain',0,'Raid Fighter',0,'LineageMonster.marsh_stakato_drone',9.00,24.00,33,'male','L2Minion',40,20909,677,85.21,6.74,40,43,30,41,20,10,0,0,1528,236,612,256,278,0,333,238,0,0,0,88,187,0,0,'LAST_HIT','false'),
(25025,25025,'Jeruna\'s Guard',0,'Raid Fighter',0,'LineageMonster.marsh_stakato_soldier',10.00,25.00,33,'male','L2Minion',40,10454,677,85.21,6.74,40,43,30,41,20,10,0,0,764,236,155,256,278,0,333,257,0,0,0,33,187,0,0,'LAST_HIT','false'),
(25026,25026,'Katu Van Leader Atui',0,'Raid Boss',0,'LineageMonster.ketra_orc_overload',12.00,24.00,49,'male','L2RaidBoss',40,352421,1660,278.27,6.74,60,57,73,76,70,80,1655129,248433,708,810,56,439,278,0,3819,84,0,0,0,53,275,0,0,'LAST_HIT','false'),
(25027,25027,'Katu Van Marksman',0,'Raid Fighter',0,'LineageMonster.ketra_orc_archer',12.00,27.00,48,'male','L2Minion',500,23911,799,72.08,6.74,40,43,30,41,20,10,0,0,1321,393,214,425,249,0,333,279,0,0,0,49,187,0,0,'LAST_HIT','false'),
(25028,25028,'Katu Van Raider',0,'Raid Fighter',0,'LineageMonster.ketra_orc_warrior',12.00,24.00,48,'male','L2Minion',40,17844,799,72.08,6.74,40,43,30,41,20,10,0,0,1321,393,214,425,278,0,333,128,0,0,0,39,187,0,0,'LAST_HIT','false'),
(25029,25029,'Atraiban',0,'Raid Boss',0,'LineageMonster.field_stalker_200_bi',45.00,96.00,53,'male','L2RaidBoss',40,156190,1911,611.07,7.70,60,57,73,76,70,80,3145490,461913,1729,912,323,494,278,0,3819,0,0,0,0,113,275,0,0,'LAST_HIT','false'),
(25030,25030,'Atraiban\'s Top Disciple',0,'Raid Fighter',0,'LineageMonster.will_o_wisp',13.00,22.00,52,'male','L2Minion',40,20135,923,158.68,7.70,40,43,30,41,20,10,0,0,32424,443,1163,479,278,0,333,0,0,0,0,88,187,0,0,'LAST_HIT','false'),
(25031,25031,'Atraiban\'s Disciple',0,'Raid Fighter',0,'LineageMonster.liviona',15.00,28.00,52,'male','L2Minion',40,10067,923,158.68,7.70,40,43,30,41,20,10,0,0,3242,443,1163,479,278,0,333,0,0,0,0,88,187,0,0,'LAST_HIT','false'),
(25032,25032,'Eva\'s Guardian Millenu',0,'Raid Boss',0,'LineageMonster.banshee_50_bi',13.50,38.00,58,'female','L2RaidBoss',40,229722,2707,828.24,8.75,60,57,73,76,70,80,1820975,806823,2334,1050,473,568,278,0,3819,3939,0,0,0,129,275,0,0,'LAST_HIT','false'),
(25033,25033,'Millenu Guard Shaman',0,'Raid Fighter',0,'LineageMonster.heltor_silenos_shaman',13.00,32.00,57,'male','L2Minion',40,20074,1319,218.67,8.75,40,43,30,41,20,10,0,0,5879,511,3126,553,278,0,333,5131,0,0,0,31,187,0,0,'LAST_HIT','false'),
(25034,25034,'Mellenu Guard Warrior',0,'Raid Fighter',0,'LineageMonster.skeleton_royal_guard',11.00,28.50,57,'male','L2Minion',40,30142,1319,218.67,8.75,40,43,30,41,20,10,0,0,8819,511,7028,553,278,0,333,946,945,0,0,88,187,1,0,'LAST_HIT','false'),
(25035,25035,'Shilen\'s Messenger Cabrio',0,'Raid Boss',0,'LineageMonster.vale_master_50_bi',18.00,63.00,70,'male','L2RaidBoss',40,888658,3058,844.90,9.81,60,57,73,76,70,80,1915900,918808,4077,1412,921,764,278,0,3819,189,0,0,0,113,275,0,0,'LAST_HIT','false'),
(25036,25036,'Cabrio Captor',0,'Raid Fighter',0,'LineageMonster.skeleton_archer',11.00,27.00,69,'male','L2Minion',500,62338,1493,223.73,8.75,40,43,30,41,20,10,0,0,7856,690,3551,747,249,0,333,279,0,0,0,44,187,1,0,'LAST_HIT','false'),
(25037,25037,'Cabrio Blader',0,'Raid Fighter',0,'LineageMonster.doll_blader',6.00,12.00,69,'male','L2Minion',40,46520,1493,223.73,8.75,40,43,30,41,20,10,0,0,7856,690,3551,747,278,0,333,5129,5129,0,0,24,187,0,0,'LAST_HIT','false'),
(25038,25038,'Tirak',0,'Raid Boss',0,'LineageMonster.dre_vanul_100_bi',28.00,75.00,28,'male','L2RaidBoss',40,116581,699,143.80,4.73,60,57,73,76,70,80,750326,74683,132,392,7,212,278,0,3819,0,0,0,0,129,275,0,0,'LAST_HIT','false'),
(25039,25039,'Tirak\'s Guard',0,'Raid Fighter',0,'LineageMonster.spartoi',11.00,27.00,27,'male','L2Minion',40,11861,334,36.74,4.73,40,43,30,41,20,10,0,0,483,188,86,204,278,0,333,68,0,0,0,66,187,1,0,'LAST_HIT','false'),
(25040,25040,'Tirak\'s Knight',0,'Raid Fighter',0,'LineageMonster.skeleton',11.00,25.00,27,'male','L2Minion',40,5930,334,36.74,4.73,40,43,30,41,20,10,0,0,241,188,23,204,278,0,333,2,945,0,0,66,187,1,0,'LAST_HIT','false'),
(25041,25041,'Remmel',0,'Raid Boss',0,'LineageMonster.marsh_stakato_queen_100_bi',30.00,76.00,35,'female','L2RaidBoss',40,165289,927,185.07,5.72,60,57,73,76,70,80,1018607,103175,242,509,14,275,467,0,3819,221,109,0,0,50,170,0,0,'LAST_HIT','false'),
(25042,25042,'Remmel\'s Archer',0,'Raid Fighter',0,'LineageMonster.batur_orc_archer',11.00,21.50,34,'male','L2Minion',500,11143,446,47.49,5.72,40,43,30,41,20,10,0,0,444,245,45,266,247,0,333,275,0,0,0,45,170,0,0,'LAST_HIT','false'),
(25043,25043,'Remmel\'s Guard',0,'Raid Fighter',0,'LineageMonster.marsh_stakato',10.00,20.00,34,'male','L2Minion',40,8316,446,47.49,5.72,40,43,30,41,20,10,0,0,444,245,45,266,278,0,333,127,0,0,0,21,170,0,0,'LAST_HIT','false'),
(25044,25044,'Barion',0,'Raid Boss',0,'LineageMonster.skeleton_knight_50_bi',15.00,39.00,47,'male','L2RaidBoss',40,319791,1296,264.56,6.74,60,57,73,76,70,80,1624139,238098,615,761,45,412,278,0,3819,70,0,0,0,64,275,1,0,'LAST_HIT','false'),
(25045,25045,'Dark Mage\'s of Barion',0,'Raid Fighter',0,'LineageMonster.batur_orc_shaman',11.00,16.00,46,'male','L2Minion',40,32280,618,68.43,6.74,40,43,30,41,20,10,0,0,1145,369,168,399,278,0,333,159,0,0,0,55,132,0,0,'LAST_HIT','false'),
(25046,25046,'Barion\'s Grunt',0,'Raid Fighter',0,'LineageMonster.spartoi',11.00,27.00,46,'male','L2Minion',40,16140,618,68.43,6.74,40,43,30,41,20,10,0,0,1145,369,168,399,278,0,333,129,0,0,0,66,187,1,0,'LAST_HIT','false'),
(25047,25047,'Karte',0,'Raid Boss',0,'LineageMonster.death_knight_50_bi',18.00,47.50,49,'male','L2RaidBoss',40,352421,1660,278.27,6.74,60,57,73,76,70,80,1412364,185123,708,810,56,439,278,0,3819,131,0,0,0,43,275,1,0,'LAST_HIT','false'),
(25048,25048,'Karte\'s Chief Knight',0,'Raid Fighter',0,'LineageMonster.skeleton_knight',10.00,25.00,48,'male','L2Minion',40,35688,799,72.08,6.74,40,43,30,41,20,10,0,0,2642,393,851,425,278,0,333,71,0,0,0,44,187,1,0,'LAST_HIT','false'),
(25049,25049,'Karte\'s Royal Guard',0,'Raid Fighter',0,'LineageMonster.spartoi',11.00,27.00,48,'male','L2Minion',40,17844,799,72.08,6.74,40,43,30,41,20,10,0,0,1321,393,214,425,278,0,333,74,0,0,0,66,187,1,0,'LAST_HIT','false'),
(25050,25050,'Verfa',0,'Raid Boss',0,'LineageMonster.death_blader_200_bi',45.00,141.00,51,'male','L2RaidBoss',40,771340,2039,250.26,7.70,60,57,73,76,70,80,1381165,185853,1622,860,310,466,278,0,3819,1472,0,0,0,162,275,1,0,'LAST_HIT','false'),
(25051,25051,'Rahha',0,'Raid Boss',0,'LineageM