/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GeoEngine;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.pathfinding.Node;
import com.l2jserver.util.Point3D;
import java.util.logging.Logger;

public class GeoData {
    private static Logger _log = Logger.getLogger(GeoData.class.getName());

    protected GeoData() {
    }

    private GeoData(boolean disabled) {
        if (disabled) {
            _log.info("Geodata Engine: Disabled.");
        }
    }

    public static GeoData getInstance() {
        return SingletonHolder._instance;
    }

    public short getType(int x, int y) {
        return 0;
    }

    public short getHeight(int x, int y, int z) {
        return (short)z;
    }

    public short getSpawnHeight(int x, int y, int zmin, int zmax, int spawnid) {
        return (short)zmin;
    }

    public String geoPosition(int x, int y) {
        return "";
    }

    public boolean canSeeTarget(L2Object cha, L2Object target) {
        return Math.abs(target.getZ() - cha.getZ()) < 1000;
    }

    public boolean canSeeTarget(L2Object cha, Point3D worldPosition) {
        return Math.abs(worldPosition.getZ() - cha.getZ()) < 1000;
    }

    public boolean canSeeTarget(int x, int y, int z, int tx, int ty, int tz) {
        return Math.abs(z - tz) < 1000;
    }

    public boolean canSeeTargetDebug(L2PcInstance gm, L2Object target) {
        return true;
    }

    public short getNSWE(int x, int y, int z) {
        return 15;
    }

    public Location moveCheck(int x, int y, int z, int tx, int ty, int tz, int instanceId) {
        return new Location(tx, ty, tz);
    }

    public boolean canMoveFromToTarget(int x, int y, int z, int tx, int ty, int tz, int instanceId) {
        return true;
    }

    public void addGeoDataBug(L2PcInstance gm, String comment) {
    }

    public static void unloadGeodata(byte rx, byte ry) {
    }

    public static boolean loadGeodataFile(byte rx, byte ry) {
        return false;
    }

    public boolean hasGeo(int x, int y) {
        return false;
    }

    public Node[] getNeighbors(Node n) {
        return null;
    }

    private static class SingletonHolder {
        protected static final GeoData _instance = Config.GEODATA > 0 ? GeoEngine.getInstance() : new GeoData(true);

        private SingletonHolder() {
        }
    }
}

