/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.instancemanager.AuctionManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.entity.Auction;
import com.l2jserver.gameserver.model.entity.ClanHall;
import com.l2jserver.gameserver.model.zone.type.L2ClanHallZone;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import java.util.logging.Logger;
import javolution.util.FastMap;

public class ClanHallManager {
    protected static final Logger _log = Logger.getLogger(ClanHallManager.class.getName());
    private Map<Integer, ClanHall> _clanHall;
    private Map<Integer, ClanHall> _freeClanHall;
    private Map<Integer, ClanHall> _allClanHalls;
    private boolean _loaded = false;

    public static ClanHallManager getInstance() {
        return SingletonHolder._instance;
    }

    public boolean loaded() {
        return this._loaded;
    }

    private ClanHallManager() {
        _log.info("Initializing ClanHallManager");
        this._clanHall = new FastMap();
        this._freeClanHall = new FastMap();
        this._allClanHalls = new FastMap();
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void load() {
        Connection con = null;
        try {
            int grade = 0;
            long paidUntil = 0L;
            boolean paid = false;
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT clanhall.*,castlename_ja.locName FROM clanhall LEFT JOIN castlename_ja ON clanhall.id = castlename_ja.id ORDER BY clanhall.id");
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                int id = rs.getInt("id");
                String Name2 = rs.getString("name");
                int ownerId = rs.getInt("ownerId");
                int lease = rs.getInt("lease");
                String Desc = rs.getString("desc");
                String Location2 = rs.getString("location");
                String locName = rs.getString("locName");
                paidUntil = rs.getLong("paidUntil");
                grade = rs.getInt("Grade");
                paid = rs.getBoolean("paid");
                ClanHall ch = new ClanHall(id, Name2, ownerId, lease, Desc, Location2, locName, paidUntil, grade, paid);
                this._allClanHalls.put(id, ch);
                if (ownerId > 0) {
                    L2Clan owner = ClanTable.getInstance().getClan(ownerId);
                    if (owner != null) {
                        this._clanHall.put(id, ch);
                        owner.setHasHideout(id);
                        continue;
                    }
                    ch.free();
                }
                this._freeClanHall.put(id, ch);
                Auction auc = AuctionManager.getInstance().getAuction(id);
                if (auc != null || lease <= 0) continue;
                AuctionManager.getInstance().initNPC(id);
            }
            statement.close();
            _log.info("Loaded: " + this.getClanHalls().size() + " clan halls");
            _log.info("Loaded: " + this.getFreeClanHalls().size() + " free clan halls");
            this._loaded = true;
        }
        catch (Exception e) {
            _log.warning("Exception: ClanHallManager.load(): " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    public final Map<Integer, ClanHall> getFreeClanHalls() {
        return this._freeClanHall;
    }

    public final Map<Integer, ClanHall> getClanHalls() {
        return this._clanHall;
    }

    public final Map<Integer, ClanHall> getAllClanHalls() {
        return this._allClanHalls;
    }

    public final boolean isFree(int chId) {
        return this._freeClanHall.containsKey(chId);
    }

    public final synchronized void setFree(int chId) {
        this._freeClanHall.put(chId, this._clanHall.get(chId));
        ClanTable.getInstance().getClan(this._freeClanHall.get(chId).getOwnerId()).setHasHideout(0);
        this._freeClanHall.get(chId).free();
        this._clanHall.remove(chId);
    }

    public final synchronized void setOwner(int chId, L2Clan clan) {
        if (!this._clanHall.containsKey(chId)) {
            this._clanHall.put(chId, this._freeClanHall.get(chId));
            this._freeClanHall.remove(chId);
        } else {
            this._clanHall.get(chId).free();
        }
        ClanTable.getInstance().getClan(clan.getClanId()).setHasHideout(chId);
        this._clanHall.get(chId).setOwner(clan);
    }

    public final ClanHall getClanHallById(int clanHallId) {
        if (this._clanHall.containsKey(clanHallId)) {
            return this._clanHall.get(clanHallId);
        }
        if (this._freeClanHall.containsKey(clanHallId)) {
            return this._freeClanHall.get(clanHallId);
        }
        return null;
    }

    public final ClanHall getNearbyClanHall(int x, int y, int maxDist) {
        L2ClanHallZone zone = null;
        for (Map.Entry<Integer, ClanHall> ch : this._clanHall.entrySet()) {
            zone = ch.getValue().getZone();
            if (zone == null || !(zone.getDistanceToZone(x, y) < (double)maxDist)) continue;
            return ch.getValue();
        }
        for (Map.Entry<Integer, ClanHall> ch : this._freeClanHall.entrySet()) {
            zone = ch.getValue().getZone();
            if (zone == null || !(zone.getDistanceToZone(x, y) < (double)maxDist)) continue;
            return ch.getValue();
        }
        return null;
    }

    public final ClanHall getClanHallByOwner(L2Clan clan) {
        for (Map.Entry<Integer, ClanHall> ch : this._clanHall.entrySet()) {
            if (clan.getClanId() != ch.getValue().getOwnerId()) continue;
            return ch.getValue();
        }
        return null;
    }

    private static class SingletonHolder {
        protected static final ClanHallManager _instance = new ClanHallManager();

        private SingletonHolder() {
        }
    }
}

