/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.Config;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.instancemanager.InstanceManager;
import com.l2jserver.gameserver.instancemanager.ItemsOnGroundManager;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.L2WorldRegion;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.knownlist.ObjectKnownList;
import com.l2jserver.gameserver.model.actor.poly.ObjectPoly;
import com.l2jserver.gameserver.model.actor.position.ObjectPosition;
import com.l2jserver.gameserver.model.entity.Instance;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;

public abstract class L2Object {
    private boolean _isVisible;
    private ObjectKnownList _knownList;
    private String _name;
    private int _objectId;
    private ObjectPoly _poly;
    private ObjectPosition _position;
    private int _instanceId = 0;
    private InstanceType _instanceType = null;

    public L2Object(int objectId) {
        this.setInstanceType(InstanceType.L2Object);
        this._objectId = objectId;
        this.initKnownList();
        this.initPosition();
    }

    protected final void setInstanceType(InstanceType i) {
        this._instanceType = i;
    }

    public final InstanceType getInstanceType() {
        return this._instanceType;
    }

    public final boolean isInstanceType(InstanceType i) {
        return this._instanceType.isType(i);
    }

    public final boolean isInstanceTypes(InstanceType ... i) {
        return this._instanceType.isTypes(i);
    }

    public final void onAction(L2PcInstance player) {
        this.onAction(player, true);
    }

    public void onAction(L2PcInstance player, boolean interact) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    public void onActionShift(L2PcInstance player) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    public void onForcedAttack(L2PcInstance player) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    public void onSpawn() {
    }

    public final void setXYZ(int x, int y, int z) {
        this.getPosition().setXYZ(x, y, z);
    }

    public final void setXYZInvisible(int x, int y, int z) {
        this.getPosition().setXYZInvisible(x, y, z);
    }

    public final int getX() {
        assert (this.getPosition().getWorldRegion() != null || this._isVisible);
        return this.getPosition().getX();
    }

    public int getInstanceId() {
        return this._instanceId;
    }

    public void setInstanceId(int instanceId) {
        if (this._instanceId == instanceId) {
            return;
        }
        Instance oldI = InstanceManager.getInstance().getInstance(this._instanceId);
        Instance newI = InstanceManager.getInstance().getInstance(instanceId);
        if (newI == null) {
            return;
        }
        if (this instanceof L2PcInstance) {
            if (this._instanceId > 0 && oldI != null) {
                oldI.removePlayer(this.getObjectId());
            }
            if (instanceId > 0) {
                newI.addPlayer(this.getObjectId());
            }
            if (((L2PcInstance)this).getPet() != null) {
                ((L2PcInstance)this).getPet().setInstanceId(instanceId);
            }
        } else if (this instanceof L2Npc) {
            if (this._instanceId > 0 && oldI != null) {
                oldI.removeNpc((L2Npc)this);
            }
            if (instanceId > 0) {
                newI.addNpc((L2Npc)this);
            }
        }
        this._instanceId = instanceId;
        if (this._isVisible && this._knownList != null && !(this instanceof L2PcInstance)) {
            this.decayMe();
            this.spawnMe();
        }
    }

    public final int getY() {
        assert (this.getPosition().getWorldRegion() != null || this._isVisible);
        return this.getPosition().getY();
    }

    public final int getZ() {
        assert (this.getPosition().getWorldRegion() != null || this._isVisible);
        return this.getPosition().getZ();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void decayMe() {
        assert (this.getPosition().getWorldRegion() != null);
        L2WorldRegion reg = this.getPosition().getWorldRegion();
        L2Object l2Object = this;
        synchronized (l2Object) {
            this._isVisible = false;
            this.getPosition().setWorldRegion(null);
        }
        L2World.getInstance().removeVisibleObject(this, reg);
        L2World.getInstance().removeObject(this);
        if (Config.SAVE_DROPPED_ITEM) {
            ItemsOnGroundManager.getInstance().removeObject(this);
        }
    }

    public void refreshID() {
        L2World.getInstance().removeObject(this);
        IdFactory.getInstance().releaseId(this.getObjectId());
        this._objectId = IdFactory.getInstance().getNextId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void spawnMe() {
        assert (this.getPosition().getWorldRegion() == null && this.getPosition().getWorldPosition().getX() != 0 && this.getPosition().getWorldPosition().getY() != 0 && this.getPosition().getWorldPosition().getZ() != 0);
        L2Object l2Object = this;
        synchronized (l2Object) {
            this._isVisible = true;
            this.getPosition().setWorldRegion(L2World.getInstance().getRegion(this.getPosition().getWorldPosition()));
            L2World.getInstance().storeObject(this);
            this.getPosition().getWorldRegion().addVisibleObject(this);
        }
        L2World.getInstance().addVisibleObject(this, this.getPosition().getWorldRegion());
        this.onSpawn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void spawnMe(int x, int y, int z) {
        assert (this.getPosition().getWorldRegion() == null);
        L2Object l2Object = this;
        synchronized (l2Object) {
            this._isVisible = true;
            if (x > L2World.MAP_MAX_X) {
                x = L2World.MAP_MAX_X - 5000;
            }
            if (x < L2World.MAP_MIN_X) {
                x = L2World.MAP_MIN_X + 5000;
            }
            if (y > L2World.MAP_MAX_Y) {
                y = L2World.MAP_MAX_Y - 5000;
            }
            if (y < L2World.MAP_MIN_Y) {
                y = L2World.MAP_MIN_Y + 5000;
            }
            this.getPosition().setWorldPosition(x, y, z);
            this.getPosition().setWorldRegion(L2World.getInstance().getRegion(this.getPosition().getWorldPosition()));
        }
        L2World.getInstance().storeObject(this);
        this.getPosition().getWorldRegion().addVisibleObject(this);
        L2World.getInstance().addVisibleObject(this, this.getPosition().getWorldRegion());
        this.onSpawn();
    }

    public void toggleVisible() {
        if (this.isVisible()) {
            this.decayMe();
        } else {
            this.spawnMe();
        }
    }

    public boolean isAttackable() {
        return false;
    }

    public abstract boolean isAutoAttackable(L2Character var1);

    public boolean isMarker() {
        return false;
    }

    public final boolean isVisible() {
        return this.getPosition().getWorldRegion() != null;
    }

    public final void setIsVisible(boolean value) {
        this._isVisible = value;
        if (!this._isVisible) {
            this.getPosition().setWorldRegion(null);
        }
    }

    public ObjectKnownList getKnownList() {
        return this._knownList;
    }

    public void initKnownList() {
        this._knownList = new ObjectKnownList(this);
    }

    public final void setKnownList(ObjectKnownList value) {
        this._knownList = value;
    }

    public final String getName() {
        return this._name;
    }

    public final void setName(String value) {
        this._name = value;
    }

    public final int getObjectId() {
        return this._objectId;
    }

    public final ObjectPoly getPoly() {
        if (this._poly == null) {
            this._poly = new ObjectPoly(this);
        }
        return this._poly;
    }

    public ObjectPosition getPosition() {
        return this._position;
    }

    public void initPosition() {
        this._position = new ObjectPosition(this);
    }

    public final void setObjectPosition(ObjectPosition value) {
        this._position = value;
    }

    public L2WorldRegion getWorldRegion() {
        return this.getPosition().getWorldRegion();
    }

    public L2PcInstance getActingPlayer() {
        return null;
    }

    public void sendInfo(L2PcInstance activeChar) {
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.getName() + "[" + this.getObjectId() + "]";
    }

    public void sendPacket(L2GameServerPacket mov) {
    }

    public static enum InstanceType {
        L2Object(null),
        L2Character(L2Object),
        L2Npc(L2Character),
        L2Playable(L2Npc),
        L2Summon(L2Playable),
        L2Decoy(L2Character),
        L2Trap(L2Character),
        L2PcInstance(L2Playable),
        L2NpcInstance(L2Npc),
        L2MerchantInstance(L2NpcInstance),
        L2WarehouseInstance(L2NpcInstance),
        L2StaticObjectInstance(L2Character),
        L2DoorInstance(L2Character),
        L2NpcWalkerInstance(L2Npc),
        L2EffectPointInstance(L2Npc),
        L2SummonInstance(L2Summon),
        L2SiegeSummonInstance(L2SummonInstance),
        L2MerchantSummonInstance(L2SummonInstance),
        L2PetInstance(L2Summon),
        L2BabyPetInstance(L2PetInstance),
        L2DecoyInstance(L2Decoy),
        L2TrapInstance(L2Trap),
        L2Attackable(L2Npc),
        L2GuardInstance(L2Attackable),
        L2MonsterInstance(L2Attackable),
        L2ChestInstance(L2MonsterInstance),
        L2ControllableMobInstance(L2MonsterInstance),
        L2FeedableBeastInstance(L2MonsterInstance),
        L2TamedBeastInstance(L2FeedableBeastInstance),
        L2FriendlyMobInstance(L2Attackable),
        L2PenaltyMonsterInstance(L2MonsterInstance),
        L2RiftInvaderInstance(L2MonsterInstance),
        L2MinionInstance(L2MonsterInstance),
        L2RaidBossInstance(L2MonsterInstance),
        L2GrandBossInstance(L2RaidBossInstance),
        L2FlyNpcInstance(L2NpcInstance),
        L2FlyMonsterInstance(L2MonsterInstance),
        L2FlyMinionInstance(L2MinionInstance),
        L2FlyRaidBossInstance(L2RaidBossInstance),
        L2SepulcherNpcInstance(L2NpcInstance),
        L2SepulcherMonsterInstance(L2MonsterInstance),
        L2FestivalGiudeInstance(L2Npc),
        L2FestivalMonsterInstance(L2MonsterInstance),
        L2BoatInstance(L2Character),
        L2AirShipInstance(L2Character),
        L2AirShipControllerInstance(L2NpcInstance),
        L2DefenderInstance(L2Attackable),
        L2ArtefactInstance(L2NpcInstance),
        L2ControlTowerInstance(L2Npc),
        L2FlameTowerInstance(L2Npc),
        L2SiegeFlagInstance(L2Npc),
        L2SiegeNpcInstance(L2Npc),
        L2FortBallistaInstance(L2Npc),
        L2FortCommanderInstance(L2DefenderInstance),
        L2CastleBlacksmithInstance(L2NpcInstance),
        L2CastleChamberlainInstance(L2MerchantInstance),
        L2CastleMagicianInstance(L2NpcInstance),
        L2CastleTeleporterInstance(L2Npc),
        L2CastleWarehouseInstance(L2WarehouseInstance),
        L2MercManagerInstance(L2MerchantInstance),
        L2FortEnvoyInstance(L2Npc),
        L2FortLogisticsInstance(L2MerchantInstance),
        L2FortManagerInstance(L2MerchantInstance),
        L2FortSiegeNpcInstance(L2NpcWalkerInstance),
        L2FortSupportCaptainInstance(L2MerchantInstance),
        L2CabaleBufferInstance(L2Npc),
        L2SignsPriestInstance(L2Npc),
        L2DawnPriestInstance(L2SignsPriestInstance),
        L2DuskPriestInstance(L2SignsPriestInstance),
        L2DungeonGatekeeperInstance(L2Npc),
        L2AdventurerInstance(L2NpcInstance),
        L2AuctioneerInstance(L2Npc),
        L2ClanHallManagerInstance(L2MerchantInstance),
        L2ClanTraderInstance(L2Npc),
        L2FameManagerInstance(L2Npc),
        L2FishermanInstance(L2MerchantInstance),
        L2ManorManagerInstance(L2MerchantInstance),
        L2MercenaryManagerInstance(L2Npc),
        L2ObservationInstance(L2Npc),
        L2OlympiadManagerInstance(L2Npc),
        L2PetManagerInstance(L2MerchantInstance),
        L2RaceManagerInstance(L2Npc),
        L2SymbolMakerInstance(L2Npc),
        L2TeleporterInstance(L2Npc),
        L2TownPetInstance(L2Npc),
        L2TrainerInstance(L2NpcInstance),
        L2TransformManagerInstance(L2MerchantInstance),
        L2VillageMasterInstance(L2NpcInstance),
        L2WyvernManagerInstance(L2NpcInstance),
        L2XmassTreeInstance(L2NpcInstance),
        L2DoormenInstance(L2NpcInstance),
        L2CastleDoormenInstance(L2DoormenInstance),
        L2FortDoormenInstance(L2DoormenInstance),
        L2ClanHallDoormenInstance(L2DoormenInstance),
        L2ClassMasterInstance(L2NpcInstance),
        L2NpcBufferInstance(L2Npc),
        L2TvTEventNpcInstance(L2Npc),
        L2WeddingManagerInstance(L2Npc);

        private final InstanceType _parent;
        private final long _typeL;
        private final long _typeH;
        private final long _maskL;
        private final long _maskH;

        private InstanceType(InstanceType parent) {
            this._parent = parent;
            int high = this.ordinal() - 63;
            if (high < 0) {
                this._typeL = 1L << this.ordinal();
                this._typeH = 0L;
            } else {
                this._typeL = 0L;
                this._typeH = 1L << high;
            }
            if (this._typeL < 0L || this._typeH < 0L) {
                throw new Error("Too many instance types, failed to load " + this.name());
            }
            if (parent != null) {
                this._maskL = this._typeL | parent._maskL;
                this._maskH = this._typeH | parent._maskH;
            } else {
                this._maskL = this._typeL;
                this._maskH = this._typeH;
            }
        }

        public final InstanceType getParent() {
            return this._parent;
        }

        public final boolean isType(InstanceType it) {
            return (this._maskL & it._typeL) > 0L || (this._maskH & it._typeH) > 0L;
        }

        public final boolean isTypes(InstanceType ... it) {
            for (InstanceType i : it) {
                if (!this.isType(i)) continue;
                return true;
            }
            return false;
        }
    }
}

