/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.UITable;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.ActionKey;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public class L2UIKeysSettings {
    protected static final Logger _log = Logger.getLogger(L2UIKeysSettings.class.getName());
    private final L2PcInstance _player;
    Map<Integer, List<ActionKey>> _storedKeys;
    Map<Integer, List<Integer>> _storedCategories;
    boolean _saved = true;

    public L2UIKeysSettings(L2PcInstance player) {
        this._player = player;
        this.loadFromDB();
    }

    public void storeAll(Map<Integer, List<Integer>> catMap, Map<Integer, List<ActionKey>> keyMap) {
        this._saved = false;
        this._storedCategories = catMap;
        this._storedKeys = keyMap;
    }

    public void storeCategories(Map<Integer, List<Integer>> catMap) {
        this._saved = false;
        this._storedCategories = catMap;
    }

    public Map<Integer, List<Integer>> getCategories() {
        return this._storedCategories;
    }

    public void storeKeys(Map<Integer, List<ActionKey>> keyMap) {
        this._saved = false;
        this._storedKeys = keyMap;
    }

    public Map<Integer, List<ActionKey>> getKeys() {
        return this._storedKeys;
    }

    public void loadFromDB() {
        this.getCatsFromDB();
        this.getKeysFromDB();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveInDB() {
        int playerId = this._player.getObjectId();
        if (this._saved) {
            return;
        }
        String query = "REPLACE INTO character_ui_categories (`charId`, `catId`, `order`, `cmdId`) VALUES ";
        for (int category : this._storedCategories.keySet()) {
            int order = 0;
            for (int key : this._storedCategories.get(category)) {
                query = query + "(" + playerId + ", " + category + ", " + order++ + ", " + key + "),";
            }
        }
        query = query.substring(0, query.length() - 1) + "; ";
        Connection con = null;
        try {
            if (con == null) {
                con = L2DatabaseFactory.getInstance().getConnection();
            }
            PreparedStatement statement = con.prepareStatement(query);
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.warning("Exception: saveInDB(): " + e.getMessage());
            e.printStackTrace();
        }
        query = "REPLACE INTO character_ui_actions (`charId`, `cat`, `order`, `cmd`, `key`, `tgKey1`, `tgKey2`, `show`) VALUES";
        for (List<ActionKey> keyLst : this._storedKeys.values()) {
            int order = 0;
            for (ActionKey key : keyLst) {
                query = query + key.getSqlSaveString(playerId, order++) + ",";
            }
        }
        query = query.substring(0, query.length() - 1) + ";";
        try {
            if (con == null) {
                con = L2DatabaseFactory.getInstance().getConnection();
            }
            PreparedStatement statement = con.prepareStatement(query);
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.warning("Exception: saveInDB(): " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {
                _log.warning("Exception while closing connection: saveInDB(): " + e.getMessage());
                e.printStackTrace();
            }
        }
        this._saved = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getCatsFromDB() {
        if (this._storedCategories != null) {
            return;
        }
        this._storedCategories = new FastMap();
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement stmt = con.prepareStatement("SELECT * FROM character_ui_categories WHERE `charId` = ? ORDER BY `catId`, `order`");
            stmt.setInt(1, this._player.getObjectId());
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                int cat = rs.getInt("catId");
                int cmd = rs.getInt("cmdId");
                this.insertCategory(cat, cmd);
            }
            stmt.close();
            rs.close();
        }
        catch (Exception e) {
            _log.warning("Exception: getCatsFromDB(): " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (this._storedCategories.size() < 1) {
            this._storedCategories = UITable.getInstance().getCategories();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getKeysFromDB() {
        if (this._storedKeys != null) {
            return;
        }
        this._storedKeys = new FastMap();
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement stmt = con.prepareStatement("SELECT * FROM character_ui_actions WHERE `charId` = ? ORDER BY `cat`, `order`");
            stmt.setInt(1, this._player.getObjectId());
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                int cat = rs.getInt("cat");
                int cmd = rs.getInt("cmd");
                int key = rs.getInt("key");
                int tgKey1 = rs.getInt("tgKey1");
                int tgKey2 = rs.getInt("tgKey2");
                int show = rs.getInt("show");
                this.insertKey(cat, cmd, key, tgKey1, tgKey2, show);
            }
            stmt.close();
            rs.close();
        }
        catch (Exception e) {
            _log.warning("Exception: getKeysFromDB(): " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (this._storedKeys.size() < 1) {
            this._storedKeys = UITable.getInstance().getKeys();
        }
    }

    public void insertCategory(int cat, int cmd) {
        if (this._storedCategories.containsKey(cat)) {
            this._storedCategories.get(cat).add(cmd);
        } else {
            FastList tmp = new FastList();
            tmp.add(cmd);
            this._storedCategories.put(cat, (List<Integer>)tmp);
        }
    }

    public void insertKey(int cat, int cmdId, int key, int tgKey1, int tgKey2, int show) {
        ActionKey tmk = new ActionKey(cat, cmdId, key, tgKey1, tgKey2, show);
        if (this._storedKeys.containsKey(cat)) {
            this._storedKeys.get(cat).add(tmk);
        } else {
            FastList tmp = new FastList();
            tmp.add(tmk);
            this._storedKeys.put(cat, (List<ActionKey>)tmp);
        }
    }

    public boolean isSaved() {
        return this._saved;
    }
}

