/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.olympiad;

import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.olympiad.Olympiad;
import com.l2jserver.gameserver.model.olympiad.OlympiadGame;
import com.l2jserver.gameserver.model.olympiad.OlympiadGameTask;
import com.l2jserver.gameserver.model.olympiad.OlympiadStadium;
import com.l2jserver.util.L2FastList;
import com.l2jserver.util.Rnd;
import java.util.Map;
import java.util.logging.Logger;
import javolution.util.FastMap;

class OlympiadManager
implements Runnable {
    protected static final Logger _log = Logger.getLogger(OlympiadManager.class.getName());
    private Map<Integer, OlympiadGame> _olympiadInstances = new FastMap();
    protected static final OlympiadStadium[] STADIUMS = new OlympiadStadium[]{new OlympiadStadium(-88000, -252637, -3331, 17100001, 17100002), new OlympiadStadium(-83760, -252637, -3331, 17100003, 17100004), new OlympiadStadium(-79600, -252637, -3331, 17100005, 17100006), new OlympiadStadium(-75648, -252637, -3331, 17100007, 17100008), new OlympiadStadium(-88000, -249762, -3331, 17100009, 17100010), new OlympiadStadium(-83760, -249762, -3331, 17100011, 17100012), new OlympiadStadium(-79600, -249762, -3331, 17100013, 17100014), new OlympiadStadium(-75648, -249762, -3331, 17100015, 17100016), new OlympiadStadium(-88000, -246951, -3331, 17100017, 17100018), new OlympiadStadium(-83760, -246951, -3331, 17100019, 17100020), new OlympiadStadium(-79600, -246951, -3331, 17100021, 17100022), new OlympiadStadium(-75648, -246951, -3331, 17100023, 17100024), new OlympiadStadium(-88000, -244290, -3331, 17100025, 17100026), new OlympiadStadium(-83760, -244290, -3331, 17100027, 17100028), new OlympiadStadium(-79600, -244290, -3331, 17100029, 17100030), new OlympiadStadium(-75648, -244290, -3331, 17100031, 17100032), new OlympiadStadium(-88000, -241490, -3331, 17100033, 17100034), new OlympiadStadium(-83760, -241490, -3331, 17100035, 17100036), new OlympiadStadium(-79600, -241490, -3331, 17100037, 17100038), new OlympiadStadium(-75648, -241490, -3331, 17100039, 17100040), new OlympiadStadium(-88000, -238825, -3331, 17100041, 17100042), new OlympiadStadium(-83760, -238825, -3331, 17100043, 17100044)};

    private OlympiadManager() {
    }

    public static OlympiadManager getInstance() {
        return SingletonHolder._instance;
    }

    @Override
    public synchronized void run() {
        if (Olympiad.getInstance().isOlympiadEnd()) {
            return;
        }
        FastMap _gamesQueue = new FastMap();
        while (Olympiad.getInstance().inCompPeriod()) {
            if (Olympiad.getNobleCount() == 0) {
                try {
                    this.wait(60000L);
                }
                catch (InterruptedException ex) {}
                continue;
            }
            int _gamesQueueSize = 0;
            L2FastList<Integer> readyClasses = Olympiad.hasEnoughRegisteredClassed();
            boolean readyNonClassed = Olympiad.hasEnoughRegisteredNonClassed();
            if (readyClasses != null || readyNonClassed) {
                int i;
                for (i = 0; i < STADIUMS.length && (this.existNextOpponents(Olympiad.getRegisteredNonClassBased()) || this.existNextOpponents(this.getRandomClassList(Olympiad.getRegisteredClassBased(), readyClasses))); ++i) {
                    if (STADIUMS[i].isFreeToUse()) {
                        if (i < STADIUMS.length / 2) {
                            if (readyNonClassed && this.existNextOpponents(Olympiad.getRegisteredNonClassBased())) {
                                try {
                                    this._olympiadInstances.put(i, new OlympiadGame(i, Olympiad.COMP_TYPE.NON_CLASSED, this.nextOpponents(Olympiad.getRegisteredNonClassBased())));
                                    _gamesQueue.put(i, new OlympiadGameTask(this._olympiadInstances.get(i)));
                                    STADIUMS[i].setStadiaBusy();
                                }
                                catch (Exception ex) {
                                    if (this._olympiadInstances.get(i) != null) {
                                        for (L2PcInstance player : this._olympiadInstances.get(i).getPlayers()) {
                                            player.sendMessage("Your olympiad registration was canceled due to an error");
                                            player.setIsInOlympiadMode(false);
                                            player.setIsOlympiadStart(false);
                                            player.setOlympiadSide(-1);
                                            player.setOlympiadGameId(-1);
                                        }
                                        this._olympiadInstances.remove(i);
                                    }
                                    if (_gamesQueue.get(i) != null) {
                                        _gamesQueue.remove(i);
                                    }
                                    STADIUMS[i].setStadiaFree();
                                    --i;
                                }
                                continue;
                            }
                            if (readyClasses == null || !this.existNextOpponents(this.getRandomClassList(Olympiad.getRegisteredClassBased(), readyClasses))) continue;
                            try {
                                this._olympiadInstances.put(i, new OlympiadGame(i, Olympiad.COMP_TYPE.CLASSED, this.nextOpponents(this.getRandomClassList(Olympiad.getRegisteredClassBased(), readyClasses))));
                                _gamesQueue.put(i, new OlympiadGameTask(this._olympiadInstances.get(i)));
                                STADIUMS[i].setStadiaBusy();
                            }
                            catch (Exception ex) {
                                if (this._olympiadInstances.get(i) != null) {
                                    for (L2PcInstance player : this._olympiadInstances.get(i).getPlayers()) {
                                        player.sendMessage("Your olympiad registration was canceled due to an error");
                                        player.setIsInOlympiadMode(false);
                                        player.setIsOlympiadStart(false);
                                        player.setOlympiadSide(-1);
                                        player.setOlympiadGameId(-1);
                                    }
                                    this._olympiadInstances.remove(i);
                                }
                                if (_gamesQueue.get(i) != null) {
                                    _gamesQueue.remove(i);
                                }
                                STADIUMS[i].setStadiaFree();
                                --i;
                            }
                            continue;
                        }
                        if (readyClasses != null && this.existNextOpponents(this.getRandomClassList(Olympiad.getRegisteredClassBased(), readyClasses))) {
                            try {
                                this._olympiadInstances.put(i, new OlympiadGame(i, Olympiad.COMP_TYPE.CLASSED, this.nextOpponents(this.getRandomClassList(Olympiad.getRegisteredClassBased(), readyClasses))));
                                _gamesQueue.put(i, new OlympiadGameTask(this._olympiadInstances.get(i)));
                                STADIUMS[i].setStadiaBusy();
                            }
                            catch (Exception ex) {
                                if (this._olympiadInstances.get(i) != null) {
                                    for (L2PcInstance player : this._olympiadInstances.get(i).getPlayers()) {
                                        player.sendMessage("Your olympiad registration was canceled due to an error");
                                        player.setIsInOlympiadMode(false);
                                        player.setIsOlympiadStart(false);
                                        player.setOlympiadSide(-1);
                                        player.setOlympiadGameId(-1);
                                    }
                                    this._olympiadInstances.remove(i);
                                }
                                if (_gamesQueue.get(i) != null) {
                                    _gamesQueue.remove(i);
                                }
                                STADIUMS[i].setStadiaFree();
                                --i;
                            }
                            continue;
                        }
                        if (!readyNonClassed || !this.existNextOpponents(Olympiad.getRegisteredNonClassBased())) continue;
                        try {
                            this._olympiadInstances.put(i, new OlympiadGame(i, Olympiad.COMP_TYPE.NON_CLASSED, this.nextOpponents(Olympiad.getRegisteredNonClassBased())));
                            _gamesQueue.put(i, new OlympiadGameTask(this._olympiadInstances.get(i)));
                            STADIUMS[i].setStadiaBusy();
                        }
                        catch (Exception ex) {
                            if (this._olympiadInstances.get(i) != null) {
                                for (L2PcInstance player : this._olympiadInstances.get(i).getPlayers()) {
                                    player.sendMessage("Your olympiad registration was canceled due to an error");
                                    player.setIsInOlympiadMode(false);
                                    player.setIsOlympiadStart(false);
                                    player.setOlympiadSide(-1);
                                    player.setOlympiadGameId(-1);
                                }
                                this._olympiadInstances.remove(i);
                            }
                            if (_gamesQueue.get(i) != null) {
                                _gamesQueue.remove(i);
                            }
                            STADIUMS[i].setStadiaFree();
                            --i;
                        }
                        continue;
                    }
                    if (_gamesQueue.get(i) != null && !((OlympiadGameTask)_gamesQueue.get(i)).isTerminated() && ((OlympiadGameTask)_gamesQueue.get((Object)Integer.valueOf((int)i)))._game != null) continue;
                    try {
                        this._olympiadInstances.remove(i);
                        _gamesQueue.remove(i);
                        STADIUMS[i].setStadiaFree();
                        --i;
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                _gamesQueueSize = _gamesQueue.size();
                for (i = 0; i < _gamesQueueSize; ++i) {
                    if (_gamesQueue.get(i) != null && !((OlympiadGameTask)_gamesQueue.get(i)).isTerminated() && !((OlympiadGameTask)_gamesQueue.get(i)).isStarted()) {
                        Thread T = new Thread((Runnable)_gamesQueue.get(i));
                        T.start();
                    }
                    try {
                        this.wait(1000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            try {
                this.wait(30000L);
            }
            catch (InterruptedException e) {}
        }
        boolean allGamesTerminated = false;
        while (!allGamesTerminated) {
            try {
                this.wait(30000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (_gamesQueue.isEmpty()) {
                allGamesTerminated = true;
                continue;
            }
            for (OlympiadGameTask game : _gamesQueue.values()) {
                allGamesTerminated = allGamesTerminated || game.isTerminated();
            }
        }
        _gamesQueue.clear();
        this._olympiadInstances.clear();
        Olympiad.clearRegistered();
        OlympiadGame._battleStarted = false;
    }

    protected OlympiadGame getOlympiadGame(int index) {
        if (this._olympiadInstances != null && !this._olympiadInstances.isEmpty()) {
            return this._olympiadInstances.get(index);
        }
        return null;
    }

    protected void removeGame(OlympiadGame game) {
        if (this._olympiadInstances != null && !this._olympiadInstances.isEmpty()) {
            for (int i = 0; i < this._olympiadInstances.size(); ++i) {
                if (this._olympiadInstances.get(i) != game) continue;
                this._olympiadInstances.remove(i);
            }
        }
    }

    protected Map<Integer, OlympiadGame> getOlympiadGames() {
        return this._olympiadInstances == null ? null : this._olympiadInstances;
    }

    protected L2FastList<L2PcInstance> getRandomClassList(Map<Integer, L2FastList<L2PcInstance>> list, L2FastList<Integer> classList) {
        if (list == null || classList == null || list.isEmpty() || classList.isEmpty()) {
            return null;
        }
        return list.get(classList.get(Rnd.nextInt(classList.size())));
    }

    protected L2FastList<L2PcInstance> nextOpponents(L2FastList<L2PcInstance> list) {
        L2FastList<L2PcInstance> opponents = new L2FastList<L2PcInstance>();
        if (list.isEmpty()) {
            return opponents;
        }
        int loopCount = list.size() / 2;
        if (loopCount < 1) {
            return opponents;
        }
        int first = Rnd.nextInt(list.size());
        opponents.add(list.get(first));
        list.remove(first);
        int second = Rnd.nextInt(list.size());
        opponents.add(list.get(second));
        list.remove(second);
        return opponents;
    }

    protected boolean existNextOpponents(L2FastList<L2PcInstance> list) {
        if (list == null) {
            return false;
        }
        if (list.isEmpty()) {
            return false;
        }
        int loopCount = list.size() >> 1;
        return loopCount >= 1;
    }

    protected FastMap<Integer, String> getAllTitles() {
        FastMap titles = new FastMap();
        for (OlympiadGame instance : this._olympiadInstances.values()) {
            if (!instance._gamestarted) continue;
            titles.put((Object)instance._stadiumID, (Object)instance.getTitle());
        }
        return titles;
    }

    private static class SingletonHolder {
        protected static final OlympiadManager _instance = new OlympiadManager();

        private SingletonHolder() {
        }
    }
}

