/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.TaskPriority;
import com.l2jserver.gameserver.Universe;
import com.l2jserver.gameserver.datatables.MapRegionTable;
import com.l2jserver.gameserver.geoeditorcon.GeoEditorListener;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ExValidateLocationInAirShip;
import com.l2jserver.gameserver.network.serverpackets.PartyMemberPosition;
import com.l2jserver.gameserver.network.serverpackets.ValidateLocation;
import com.l2jserver.gameserver.network.serverpackets.ValidateLocationInVehicle;
import java.util.logging.Logger;

public class ValidatePosition
extends L2GameClientPacket {
    private static Logger _log = Logger.getLogger(ValidatePosition.class.getName());
    private static final String _C__48_VALIDATEPOSITION = "[C] 48 ValidatePosition";
    private int _x;
    private int _y;
    private int _z;
    private int _heading;
    private int _data;

    public TaskPriority getPriority() {
        return TaskPriority.PR_HIGH;
    }

    @Override
    protected void readImpl() {
        this._x = this.readD();
        this._y = this.readD();
        this._z = this.readD();
        this._heading = this.readD();
        this._data = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null || activeChar.isTeleporting()) {
            return;
        }
        int realX = activeChar.getX();
        int realY = activeChar.getY();
        int realZ = activeChar.getZ();
        if (this._x == 0 && this._y == 0 && realX != 0) {
            return;
        }
        if (activeChar.getParty() != null && activeChar.getLastPartyPositionDistance(this._x, this._y, this._z) > 150) {
            activeChar.setLastPartyPosition(this._x, this._y, this._z);
            activeChar.getParty().broadcastToPartyMembers(activeChar, new PartyMemberPosition(activeChar));
        }
        double dx = this._x - realX;
        double dy = this._y - realY;
        double dz = this._z - realZ;
        double diffSq = dx * dx + dy * dy;
        if (Config.DEVELOPER) {
            _log.fine("client pos: " + this._x + " " + this._y + " " + this._z + " head " + this._heading);
            _log.fine("server pos: " + realX + " " + realY + " " + realZ + " head " + activeChar.getHeading());
        }
        if (Config.ACCEPT_GEOEDITOR_CONN && GeoEditorListener.getInstance().getThread() != null && GeoEditorListener.getInstance().getThread().isWorking() && GeoEditorListener.getInstance().getThread().isSend(activeChar)) {
            GeoEditorListener.getInstance().getThread().sendGmPosition(this._x, this._y, (short)this._z);
        }
        if (Config.ACTIVATE_POSITION_RECORDER && !activeChar.isFlying() && Universe.getInstance().shouldLog(activeChar.getObjectId())) {
            Universe.getInstance().registerHeight(realX, realY, this._z);
        }
        if (activeChar.isFlying() || activeChar.isInsideZone((byte)7)) {
            activeChar.setXYZ(realX, realY, this._z);
            if (diffSq > 90000.0) {
                if (activeChar.isInBoat()) {
                    this.sendPacket(new ValidateLocationInVehicle(activeChar));
                } else if (activeChar.isInAirShip()) {
                    this.sendPacket(new ExValidateLocationInAirShip(activeChar));
                } else {
                    activeChar.sendPacket(new ValidateLocation(activeChar));
                }
            }
        } else if (diffSq < 250000.0) {
            if (Config.COORD_SYNCHRONIZE == -1) {
                activeChar.setXYZ(realX, realY, this._z);
                return;
            }
            if (Config.COORD_SYNCHRONIZE == 1) {
                if (!activeChar.isMoving() || !activeChar.validateMovementHeading(this._heading)) {
                    if (diffSq < 2500.0) {
                        activeChar.setXYZ(realX, realY, this._z);
                    } else {
                        activeChar.setXYZ(this._x, this._y, this._z);
                    }
                } else {
                    activeChar.setXYZ(realX, realY, this._z);
                }
                activeChar.setHeading(this._heading);
                return;
            }
            if (Config.GEODATA > 0 && (diffSq > 10000.0 || Math.abs(dz) > 200.0)) {
                if (Math.abs(dz) > 200.0 && Math.abs(dz) < 1500.0 && Math.abs(this._z - activeChar.getClientZ()) < 800) {
                    activeChar.setXYZ(realX, realY, this._z);
                    realZ = this._z;
                } else {
                    if (Config.DEVELOPER) {
                        _log.info(activeChar.getName() + ": Synchronizing position Server --> Client");
                    }
                    if (activeChar.isInBoat()) {
                        this.sendPacket(new ValidateLocationInVehicle(activeChar));
                    } else if (activeChar.isInAirShip()) {
                        this.sendPacket(new ExValidateLocationInAirShip(activeChar));
                    } else {
                        activeChar.sendPacket(new ValidateLocation(activeChar));
                    }
                }
            }
        }
        activeChar.setClientX(this._x);
        activeChar.setClientY(this._y);
        activeChar.setClientZ(this._z);
        activeChar.setClientHeading(this._heading);
        activeChar.setLastServerPosition(realX, realY, realZ);
        if (!Config.ALT_FLYING_WYVERN_IN_SIEGE && activeChar.getMountType() == 2 && activeChar.isInsideZone((byte)2) && (activeChar.getClan() == null || CastleManager.getInstance().getCastle(activeChar) != CastleManager.getInstance().getCastleByOwner(activeChar.getClan()) || activeChar != activeChar.getClan().getLeader().getPlayerInstance())) {
            activeChar.sendMessage("You entered into a no-fly zone.");
            activeChar.teleToLocation(MapRegionTable.TeleportWhereType.Town);
        }
    }

    @Override
    public String getType() {
        return _C__48_VALIDATEPOSITION;
    }
}

