/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills.funcs;

import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.skills.funcs.Lambda;

public final class LambdaStats
extends Lambda {
    private final StatsType _stat;

    public LambdaStats(StatsType stat) {
        this._stat = stat;
    }

    @Override
    public double calc(Env env) {
        switch (this._stat) {
            case PLAYER_LEVEL: {
                if (env.player == null) {
                    return 1.0;
                }
                return env.player.getLevel();
            }
            case CUBIC_LEVEL: {
                if (env.cubic == null) {
                    return 1.0;
                }
                return env.cubic.getOwner().getLevel();
            }
            case TARGET_LEVEL: {
                if (env.target == null) {
                    return 1.0;
                }
                return env.target.getLevel();
            }
            case PLAYER_MAX_HP: {
                if (env.player == null) {
                    return 1.0;
                }
                return env.player.getMaxHp();
            }
            case PLAYER_MAX_MP: {
                if (env.player == null) {
                    return 1.0;
                }
                return env.player.getMaxMp();
            }
        }
        return 0.0;
    }

    public static enum StatsType {
        PLAYER_LEVEL,
        CUBIC_LEVEL,
        TARGET_LEVEL,
        PLAYER_MAX_HP,
        PLAYER_MAX_MP;

    }
}

