/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.loginserver;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.loginserver.GameServerThread;
import com.l2jserver.util.Rnd;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.spec.RSAKeyGenParameterSpec;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.io.UTF8StreamReader;
import javolution.util.FastMap;
import javolution.xml.stream.XMLStreamException;
import javolution.xml.stream.XMLStreamReaderImpl;

public class GameServerTable {
    private static Logger _log = Logger.getLogger(GameServerTable.class.getName());
    private static GameServerTable _instance;
    private static Map<Integer, String> _serverNames;
    private Map<Integer, GameServerInfo> _gameServerTable = new FastMap().setShared(true);
    private static final int KEYS_SIZE = 10;
    private KeyPair[] _keyPairs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load() throws SQLException, GeneralSecurityException {
        Class<GameServerTable> clazz = GameServerTable.class;
        synchronized (GameServerTable.class) {
            if (_instance != null) {
                throw new IllegalStateException("Load can only be invoked a single time.");
            }
            _instance = new GameServerTable();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static GameServerTable getInstance() {
        return _instance;
    }

    public GameServerTable() throws SQLException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        this.loadServerNames();
        _log.info("Loaded " + _serverNames.size() + " server names");
        this.loadRegisteredGameServers();
        _log.info("Loaded " + this._gameServerTable.size() + " registered Game Servers");
        this.loadRSAKeys();
        _log.info("Cached " + this._keyPairs.length + " RSA keys for Game Server communication.");
    }

    private void loadRSAKeys() throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        RSAKeyGenParameterSpec spec = new RSAKeyGenParameterSpec(512, RSAKeyGenParameterSpec.F4);
        keyGen.initialize(spec);
        this._keyPairs = new KeyPair[10];
        for (int i = 0; i < 10; ++i) {
            this._keyPairs[i] = keyGen.genKeyPair();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadServerNames() {
        FileInputStream in = null;
        try {
            in = new FileInputStream("servername.xml");
            XMLStreamReaderImpl xpp = new XMLStreamReaderImpl();
            xpp.setInput((Reader)new UTF8StreamReader().setInput((InputStream)in));
            int e = xpp.getEventType();
            while (e != 8) {
                if (e == 1 && xpp.getLocalName().toString().equals("server")) {
                    Integer id = Integer.valueOf(xpp.getAttributeValue(null, (CharSequence)"id").toString());
                    String name = xpp.getAttributeValue(null, (CharSequence)"name").toString();
                    _serverNames.put(id, name);
                }
                e = xpp.next();
            }
        }
        catch (FileNotFoundException e) {
            _log.warning("servername.xml could not be loaded: file not found");
        }
        catch (XMLStreamException xppe) {
            xppe.printStackTrace();
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (Exception e) {}
        }
    }

    private void loadRegisteredGameServers() throws SQLException {
        Connection con = null;
        PreparedStatement statement = null;
        con = L2DatabaseFactory.getInstance().getConnection();
        statement = con.prepareStatement("SELECT * FROM gameservers");
        ResultSet rset = statement.executeQuery();
        while (rset.next()) {
            int id = rset.getInt("server_id");
            GameServerInfo gsi = new GameServerInfo(id, this.stringToHex(rset.getString("hexid")));
            this._gameServerTable.put(id, gsi);
        }
        rset.close();
        statement.close();
        con.close();
    }

    public Map<Integer, GameServerInfo> getRegisteredGameServers() {
        return this._gameServerTable;
    }

    public GameServerInfo getRegisteredGameServerById(int id) {
        return this._gameServerTable.get(id);
    }

    public boolean hasRegisteredGameServerOnId(int id) {
        return this._gameServerTable.containsKey(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerWithFirstAvaliableId(GameServerInfo gsi) {
        Map<Integer, GameServerInfo> map = this._gameServerTable;
        synchronized (map) {
            for (Map.Entry<Integer, String> entry : _serverNames.entrySet()) {
                if (this._gameServerTable.containsKey(entry.getKey())) continue;
                this._gameServerTable.put(entry.getKey(), gsi);
                gsi.setId(entry.getKey());
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean register(int id, GameServerInfo gsi) {
        Map<Integer, GameServerInfo> map = this._gameServerTable;
        synchronized (map) {
            if (!this._gameServerTable.containsKey(id)) {
                this._gameServerTable.put(id, gsi);
                gsi.setId(id);
                return true;
            }
        }
        return false;
    }

    public void registerServerOnDB(GameServerInfo gsi) {
        this.registerServerOnDB(gsi.getHexId(), gsi.getId(), gsi.getExternalHost());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerServerOnDB(byte[] hexId, int id, String externalHost) {
        Connection con = null;
        PreparedStatement statement = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            statement = con.prepareStatement("INSERT INTO gameservers (hexid,server_id,host) values (?,?,?)");
            statement.setString(1, this.hexToString(hexId));
            statement.setInt(2, id);
            statement.setString(3, externalHost);
            statement.executeUpdate();
            statement.close();
        }
        catch (SQLException e) {
            _log.log(Level.SEVERE, "SQL error while saving gameserver.", e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
    }

    public String getServerNameById(int id) {
        return this.getServerNames().get(id);
    }

    public Map<Integer, String> getServerNames() {
        return _serverNames;
    }

    public KeyPair getKeyPair() {
        return this._keyPairs[Rnd.nextInt(10)];
    }

    private byte[] stringToHex(String string) {
        return new BigInteger(string, 16).toByteArray();
    }

    private String hexToString(byte[] hex) {
        if (hex == null) {
            return "null";
        }
        return new BigInteger(hex).toString(16);
    }

    static {
        _serverNames = new FastMap();
    }

    public static class GameServerInfo {
        private int _id;
        private byte[] _hexId;
        private boolean _isAuthed;
        private GameServerThread _gst;
        private int _status;
        private String _internalIp;
        private String _externalIp;
        private String _externalHost;
        private int _port;
        private boolean _isPvp = true;
        private boolean _isTestServer;
        private boolean _isShowingClock;
        private boolean _isShowingBrackets;
        private int _maxPlayers;

        public GameServerInfo(int id, byte[] hexId, GameServerThread gst) {
            this._id = id;
            this._hexId = hexId;
            this._gst = gst;
            this._status = 4;
        }

        public GameServerInfo(int id, byte[] hexId) {
            this(id, hexId, null);
        }

        public void setId(int id) {
            this._id = id;
        }

        public int getId() {
            return this._id;
        }

        public byte[] getHexId() {
            return this._hexId;
        }

        public void setAuthed(boolean isAuthed) {
            this._isAuthed = isAuthed;
        }

        public boolean isAuthed() {
            return this._isAuthed;
        }

        public void setGameServerThread(GameServerThread gst) {
            this._gst = gst;
        }

        public GameServerThread getGameServerThread() {
            return this._gst;
        }

        public void setStatus(int status) {
            this._status = status;
        }

        public int getStatus() {
            return this._status;
        }

        public int getCurrentPlayerCount() {
            if (this._gst == null) {
                return 0;
            }
            return this._gst.getPlayerCount();
        }

        public void setInternalIp(String internalIp) {
            this._internalIp = internalIp;
        }

        public String getInternalHost() {
            return this._internalIp;
        }

        public void setExternalIp(String externalIp) {
            this._externalIp = externalIp;
        }

        public String getExternalIp() {
            return this._externalIp;
        }

        public void setExternalHost(String externalHost) {
            this._externalHost = externalHost;
        }

        public String getExternalHost() {
            return this._externalHost;
        }

        public int getPort() {
            return this._port;
        }

        public void setPort(int port) {
            this._port = port;
        }

        public void setMaxPlayers(int maxPlayers) {
            this._maxPlayers = maxPlayers;
        }

        public int getMaxPlayers() {
            return this._maxPlayers;
        }

        public boolean isPvp() {
            return this._isPvp;
        }

        public void setTestServer(boolean val) {
            this._isTestServer = val;
        }

        public boolean isTestServer() {
            return this._isTestServer;
        }

        public void setShowingClock(boolean clock) {
            this._isShowingClock = clock;
        }

        public boolean isShowingClock() {
            return this._isShowingClock;
        }

        public void setShowingBrackets(boolean val) {
            this._isShowingBrackets = val;
        }

        public boolean isShowingBrackets() {
            return this._isShowingBrackets;
        }

        public void setDown() {
            this.setAuthed(false);
            this.setPort(0);
            this.setGameServerThread(null);
            this.setStatus(4);
        }
    }
}

