/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javolution.io.UTF8StreamReader;
import javolution.io.UTF8StreamWriter;

public class Util {
    private static final String DATE_FORMAT = "yyyy/MM/dd HH:mm (E)";

    public static boolean isInternalIP(String ipAddress) {
        InetAddress addr = null;
        try {
            addr = InetAddress.getByName(ipAddress);
            return addr.isSiteLocalAddress() || addr.isLoopbackAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String printData(byte[] data, int len) {
        int t1;
        int a;
        int charpoint;
        StringBuilder result = new StringBuilder(len * 4);
        int counter = 0;
        for (int i = 0; i < len; ++i) {
            if (counter % 16 == 0) {
                result.append(Util.fillHex(i, 4)).append(": ");
            }
            result.append(Util.fillHex(data[i] & 0xFF, 2)).append(' ');
            if (++counter != 16) continue;
            result.append("   ");
            charpoint = i - 15;
            for (a = 0; a < 16; ++a) {
                if ((t1 = 0xFF & data[charpoint++]) > 31 && t1 < 128) {
                    result.append((char)t1);
                    continue;
                }
                result.append('.');
            }
            result.append('\n');
            counter = 0;
        }
        int rest = data.length % 16;
        if (rest > 0) {
            for (int i = 0; i < 17 - rest; ++i) {
                result.append("   ");
            }
            charpoint = data.length - rest;
            for (a = 0; a < rest; ++a) {
                if ((t1 = 0xFF & data[charpoint++]) > 31 && t1 < 128) {
                    result.append((char)t1);
                    continue;
                }
                result.append('.');
            }
            result.append('\n');
        }
        return result.toString();
    }

    public static String fillHex(int data, int digits) {
        String number = Integer.toHexString(data);
        for (int i = number.length(); i < digits; ++i) {
            number = "0" + number;
        }
        return number;
    }

    public static String printData(byte[] raw) {
        return Util.printData(raw, raw.length);
    }

    public static String printData(ByteBuffer buf) {
        byte[] data = new byte[buf.remaining()];
        buf.get(data);
        String hex = Util.printData(data, data.length);
        buf.position(buf.position() - data.length);
        return hex;
    }

    public static String dateFormat() {
        return new SimpleDateFormat(DATE_FORMAT).format(new Date());
    }

    public static String dateFormat(long d) {
        return new SimpleDateFormat(DATE_FORMAT).format(new Date(d));
    }

    public static String dateFormat(Date d) {
        return new SimpleDateFormat(DATE_FORMAT).format(d);
    }

    public static String dateFormat(Calendar d) {
        return new SimpleDateFormat(DATE_FORMAT).format(d.getTime());
    }

    public static String strTime(int time) {
        if (time == 0) {
            return "0\u79d2";
        }
        StringBuilder sb = new StringBuilder();
        long n = time / 86400;
        if (n > 0L) {
            sb.append(n).append('\u65e5');
            time %= 86400;
        }
        if ((n = (long)(time / 3600)) > 0L) {
            sb.append(n).append("\u6642\u9593");
            time %= 3600;
        }
        if ((n = (long)(time / 60)) > 0L) {
            sb.append(n).append('\u5206');
            time %= 60;
        }
        if ((n = (long)time) > 0L) {
            sb.append(n).append('\u79d2');
        }
        return sb.toString();
    }

    public static String strMillTime(long milliTime) {
        if (milliTime == 0L) {
            return milliTime + "0\u79d2";
        }
        if (milliTime <= 999L) {
            return milliTime + "\u3349\u79d2";
        }
        return Util.strTime((int)((milliTime + 999L) / 1000L));
    }

    public static BufferedReader utf8BufferedReader(String name) throws FileNotFoundException {
        return Util.skipBOM(new BufferedReader((Reader)new UTF8StreamReader().setInput((InputStream)new FileInputStream(name))));
    }

    public static BufferedReader utf8BufferedReader(File file) throws FileNotFoundException {
        return Util.skipBOM(new BufferedReader((Reader)new UTF8StreamReader().setInput((InputStream)new FileInputStream(file))));
    }

    public static UTF8StreamWriter utf8StreamWriter(String name) throws FileNotFoundException {
        return new UTF8StreamWriter().setOutput((OutputStream)new FileOutputStream(name));
    }

    public static UTF8StreamWriter utf8StreamWriter(File file) throws FileNotFoundException {
        return new UTF8StreamWriter().setOutput((OutputStream)new FileOutputStream(file));
    }

    private static BufferedReader skipBOM(BufferedReader reader) {
        return reader;
    }
}

