/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.ai;

import com.l2jserver.gameserver.ai.CtrlEvent;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.ai.L2AttackableAI;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.MobGroup;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.instance.L2ControllableMobInstance;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2NpcInstance;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.Rnd;
import java.util.Collection;
import javolution.util.FastList;

public class L2ControllableMobAI
extends L2AttackableAI {
    public static final int AI_IDLE = 1;
    public static final int AI_NORMAL = 2;
    public static final int AI_FORCEATTACK = 3;
    public static final int AI_FOLLOW = 4;
    public static final int AI_CAST = 5;
    public static final int AI_ATTACK_GROUP = 6;
    private int _alternateAI;
    private boolean _isThinking;
    private boolean _isNotMoving;
    private L2Character _forcedTarget;
    private MobGroup _targetGroup;

    protected void thinkFollow() {
        L2Attackable me = (L2Attackable)this._actor;
        if (!Util.checkIfInRange(300, me, this.getForcedTarget(), true)) {
            int signX = Rnd.nextInt(2) == 0 ? -1 : 1;
            int signY = Rnd.nextInt(2) == 0 ? -1 : 1;
            int randX = Rnd.nextInt(300);
            int randY = Rnd.nextInt(300);
            this.moveTo(this.getForcedTarget().getX() + signX * randX, this.getForcedTarget().getY() + signY * randY, this.getForcedTarget().getZ());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void onEvtThink() {
        if (this.isThinking()) {
            return;
        }
        this.setThinking(true);
        try {
            switch (this.getAlternateAI()) {
                case 1: {
                    if (this.getIntention() == CtrlIntention.AI_INTENTION_ACTIVE) return;
                    this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
                    return;
                }
                case 4: {
                    this.thinkFollow();
                    return;
                }
                case 5: {
                    this.thinkCast();
                    return;
                }
                case 3: {
                    this.thinkForceAttack();
                    return;
                }
                case 6: {
                    this.thinkAttackGroup();
                    return;
                }
                default: {
                    if (this.getIntention() == CtrlIntention.AI_INTENTION_ACTIVE) {
                        this.thinkActive();
                        return;
                    } else {
                        if (this.getIntention() != CtrlIntention.AI_INTENTION_ATTACK) return;
                        this.thinkAttack();
                    }
                    return;
                }
            }
        }
        finally {
            this.setThinking(false);
        }
    }

    protected void thinkCast() {
        L2Attackable npc = (L2Attackable)this._actor;
        if (this.getAttackTarget() == null || this.getAttackTarget().isAlikeDead()) {
            this.setAttackTarget(this.findNextRndTarget());
            this.clientStopMoving(null);
        }
        if (this.getAttackTarget() == null) {
            return;
        }
        npc.setTarget(this.getAttackTarget());
        L2Skill[] skills = null;
        try {
            skills = this._actor.getAllSkills();
        }
        catch (NullPointerException e) {
            _log.warning("Encountered Null Value.");
            e.printStackTrace();
        }
        if (!this._actor.isMuted()) {
            int max_range = 0;
            for (L2Skill sk : skills) {
                if (Util.checkIfInRange(sk.getCastRange(), this._actor, this.getAttackTarget(), true) && !this._actor.isSkillDisabled(sk) && this._actor.getCurrentMp() > (double)this._actor.getStat().getMpConsume(sk)) {
                    this._accessor.doCast(sk);
                    return;
                }
                max_range = Math.max(max_range, sk.getCastRange());
            }
            if (!this.isNotMoving()) {
                this.moveToPawn(this.getAttackTarget(), max_range);
            }
            return;
        }
    }

    protected void thinkAttackGroup() {
        L2Character target = this.getForcedTarget();
        if (target == null || target.isAlikeDead()) {
            this.setForcedTarget(this.findNextGroupTarget());
            this.clientStopMoving(null);
        }
        if (target == null) {
            return;
        }
        L2Skill[] skills = null;
        double dist2 = 0.0;
        int range = 0;
        int max_range = 0;
        this._actor.setTarget(target);
        L2ControllableMobInstance theTarget = (L2ControllableMobInstance)target;
        L2ControllableMobAI ctrlAi = (L2ControllableMobAI)theTarget.getAI();
        ctrlAi.forceAttack(this._actor);
        try {
            skills = this._actor.getAllSkills();
            dist2 = this._actor.getPlanDistanceSq(target.getX(), target.getY());
            max_range = range = this._actor.getPhysicalAttackRange() + this._actor.getTemplate().collisionRadius + target.getTemplate().collisionRadius;
        }
        catch (NullPointerException e) {
            _log.warning("Encountered Null Value.");
            e.printStackTrace();
        }
        if (!this._actor.isMuted() && dist2 > (double)((range + 20) * (range + 20))) {
            for (L2Skill sk : skills) {
                int castRange = sk.getCastRange();
                if ((double)(castRange * castRange) >= dist2 && !this._actor.isSkillDisabled(sk) && this._actor.getCurrentMp() > (double)this._actor.getStat().getMpConsume(sk)) {
                    this._accessor.doCast(sk);
                    return;
                }
                max_range = Math.max(max_range, castRange);
            }
            if (!this.isNotMoving()) {
                this.moveToPawn(target, range);
            }
            return;
        }
        this._accessor.doAttack(target);
    }

    protected void thinkForceAttack() {
        if (this.getForcedTarget() == null || this.getForcedTarget().isAlikeDead()) {
            this.clientStopMoving(null);
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            this.setAlternateAI(1);
        }
        L2Skill[] skills = null;
        double dist2 = 0.0;
        int range = 0;
        int max_range = 0;
        try {
            this._actor.setTarget(this.getForcedTarget());
            skills = this._actor.getAllSkills();
            dist2 = this._actor.getPlanDistanceSq(this.getForcedTarget().getX(), this.getForcedTarget().getY());
            max_range = range = this._actor.getPhysicalAttackRange() + this._actor.getTemplate().collisionRadius + this.getForcedTarget().getTemplate().collisionRadius;
        }
        catch (NullPointerException e) {
            _log.warning("Encountered Null Value.");
            e.printStackTrace();
        }
        if (!this._actor.isMuted() && dist2 > (double)((range + 20) * (range + 20))) {
            for (L2Skill sk : skills) {
                int castRange = sk.getCastRange();
                if ((double)(castRange * castRange) >= dist2 && !this._actor.isSkillDisabled(sk) && this._actor.getCurrentMp() > (double)this._actor.getStat().getMpConsume(sk)) {
                    this._accessor.doCast(sk);
                    return;
                }
                max_range = Math.max(max_range, castRange);
            }
            if (!this.isNotMoving()) {
                this.moveToPawn(this.getForcedTarget(), this._actor.getPhysicalAttackRange());
            }
            return;
        }
        this._accessor.doAttack(this.getForcedTarget());
    }

    protected void thinkAttack() {
        if (this.getAttackTarget() == null || this.getAttackTarget().isAlikeDead()) {
            if (this.getAttackTarget() != null) {
                L2Attackable npc = (L2Attackable)this._actor;
                npc.stopHating(this.getAttackTarget());
            }
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        } else {
            if (((L2Npc)this._actor).getFactionId() != null) {
                String faction_id = ((L2Npc)this._actor).getFactionId();
                Collection<L2Object> objs = this._actor.getKnownList().getKnownObjects().values();
                for (L2Object obj : objs) {
                    L2Npc npc;
                    if (!(obj instanceof L2Npc) || !faction_id.equals((npc = (L2Npc)obj).getFactionId()) || !this._actor.isInsideRadius(npc, npc.getFactionRange(), false, true) || Math.abs(this.getAttackTarget().getZ() - npc.getZ()) >= 200) continue;
                    npc.getAI().notifyEvent(CtrlEvent.EVT_AGGRESSION, this.getAttackTarget(), 1);
                }
            }
            L2Skill[] skills = null;
            double dist2 = 0.0;
            int range = 0;
            int max_range = 0;
            try {
                this._actor.setTarget(this.getAttackTarget());
                skills = this._actor.getAllSkills();
                dist2 = this._actor.getPlanDistanceSq(this.getAttackTarget().getX(), this.getAttackTarget().getY());
                max_range = range = this._actor.getPhysicalAttackRange() + this._actor.getTemplate().collisionRadius + this.getAttackTarget().getTemplate().collisionRadius;
            }
            catch (NullPointerException e) {
                _log.warning("Encountered Null Value.");
                e.printStackTrace();
            }
            if (!this._actor.isMuted() && dist2 > (double)((range + 20) * (range + 20))) {
                for (L2Skill sk : skills) {
                    int castRange = sk.getCastRange();
                    if ((double)(castRange * castRange) >= dist2 && !this._actor.isSkillDisabled(sk) && this._actor.getCurrentMp() > (double)this._actor.getStat().getMpConsume(sk)) {
                        this._accessor.doCast(sk);
                        return;
                    }
                    max_range = Math.max(max_range, castRange);
                }
                this.moveToPawn(this.getAttackTarget(), range);
                return;
            }
            L2Character hated = this._actor.isConfused() ? this.findNextRndTarget() : this.getAttackTarget();
            if (hated == null) {
                this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
                return;
            }
            if (hated != this.getAttackTarget()) {
                this.setAttackTarget(hated);
            }
            if (!this._actor.isMuted() && skills.length > 0 && Rnd.nextInt(5) == 3) {
                for (L2Skill sk : skills) {
                    int castRange = sk.getCastRange();
                    if (!((double)(castRange * castRange) >= dist2) || this._actor.isSkillDisabled(sk) || !(this._actor.getCurrentMp() < (double)this._actor.getStat().getMpConsume(sk))) continue;
                    this._accessor.doCast(sk);
                    return;
                }
            }
            this._accessor.doAttack(this.getAttackTarget());
        }
    }

    private void thinkActive() {
        this.setAttackTarget(this.findNextRndTarget());
        L2Character hated = this._actor.isConfused() ? this.findNextRndTarget() : this.getAttackTarget();
        if (hated != null) {
            this._actor.setRunning();
            this.setIntention(CtrlIntention.AI_INTENTION_ATTACK, hated);
        }
    }

    private boolean autoAttackCondition(L2Character target) {
        if (target == null || !(this._actor instanceof L2Attackable)) {
            return false;
        }
        L2Attackable me = (L2Attackable)this._actor;
        if (target instanceof L2NpcInstance || target instanceof L2DoorInstance) {
            return false;
        }
        if (target.isAlikeDead() || !me.isInsideRadius(target, me.getAggroRange(), false, false) || Math.abs(this._actor.getZ() - target.getZ()) > 100) {
            return false;
        }
        if (target.isInvul()) {
            return false;
        }
        if (target instanceof L2Playable && ((L2Playable)target).isSilentMoving()) {
            return false;
        }
        if (target instanceof L2Npc) {
            return false;
        }
        return me.isAggressive();
    }

    private L2Character findNextRndTarget() {
        int aggroRange = ((L2Attackable)this._actor).getAggroRange();
        L2Attackable npc = (L2Attackable)this._actor;
        double dblAggroRange = aggroRange * aggroRange;
        FastList potentialTarget = new FastList();
        Collection<L2Object> objs = npc.getKnownList().getKnownObjects().values();
        for (L2Object obj : objs) {
            L2Character target;
            int targetY;
            double dy;
            if (!(obj instanceof L2Character)) continue;
            int npcX = npc.getX();
            int npcY = npc.getY();
            int targetX = obj.getX();
            double dx = npcX - targetX;
            if (dx * dx + (dy = (double)(npcY - (targetY = obj.getY()))) * dy > dblAggroRange || !this.autoAttackCondition(target = (L2Character)obj)) continue;
            potentialTarget.add(target);
        }
        if (potentialTarget.isEmpty()) {
            return null;
        }
        int choice = Rnd.nextInt(potentialTarget.size());
        L2Character target = (L2Character)potentialTarget.get(choice);
        return target;
    }

    private L2ControllableMobInstance findNextGroupTarget() {
        return this.getGroupTarget().getRandomMob();
    }

    public L2ControllableMobAI(L2Character.AIAccessor accessor) {
        super(accessor);
        this.setAlternateAI(1);
    }

    public int getAlternateAI() {
        return this._alternateAI;
    }

    public void setAlternateAI(int _alternateai) {
        this._alternateAI = _alternateai;
    }

    public void forceAttack(L2Character target) {
        this.setAlternateAI(3);
        this.setForcedTarget(target);
    }

    public void forceAttackGroup(MobGroup group) {
        this.setForcedTarget(null);
        this.setGroupTarget(group);
        this.setAlternateAI(6);
    }

    public void stop() {
        this.setAlternateAI(1);
        this.clientStopMoving(null);
    }

    public void move(int x, int y, int z) {
        this.moveTo(x, y, z);
    }

    public void follow(L2Character target) {
        this.setAlternateAI(4);
        this.setForcedTarget(target);
    }

    public boolean isThinking() {
        return this._isThinking;
    }

    public boolean isNotMoving() {
        return this._isNotMoving;
    }

    public void setNotMoving(boolean isNotMoving) {
        this._isNotMoving = isNotMoving;
    }

    public void setThinking(boolean isThinking) {
        this._isThinking = isThinking;
    }

    private L2Character getForcedTarget() {
        return this._forcedTarget;
    }

    private MobGroup getGroupTarget() {
        return this._targetGroup;
    }

    private void setForcedTarget(L2Character forcedTarget) {
        this._forcedTarget = forcedTarget;
    }

    private void setGroupTarget(MobGroup targetGroup) {
        this._targetGroup = targetGroup;
    }
}

