/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.communitybbs.BB;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.communitybbs.BB.Topic;
import com.l2jserver.gameserver.communitybbs.Manager.ForumsBBSManager;
import com.l2jserver.gameserver.communitybbs.Manager.TopicBBSManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public class Forum {
    public static final int ROOT = 0;
    public static final int NORMAL = 1;
    public static final int CLAN = 2;
    public static final int MEMO = 3;
    public static final int MAIL = 4;
    public static final int INVISIBLE = 0;
    public static final int ALL = 1;
    public static final int CLANMEMBERONLY = 2;
    public static final int OWNERONLY = 3;
    private static Logger _log = Logger.getLogger(Forum.class.getName());
    private List<Forum> _children;
    private Map<Integer, Topic> _topic;
    private int _forumId;
    private String _forumName;
    private int _forumType;
    private int _forumPost;
    private int _forumPerm;
    private Forum _fParent;
    private int _ownerID;
    private boolean _loaded = false;

    public Forum(int Forumid, Forum FParent) {
        this._forumId = Forumid;
        this._fParent = FParent;
        this._children = new FastList();
        this._topic = new FastMap();
    }

    public Forum(String name, Forum parent, int type, int perm, int OwnerID) {
        this._forumName = name;
        this._forumId = ForumsBBSManager.getInstance().getANewID();
        this._forumType = type;
        this._forumPost = 0;
        this._forumPerm = perm;
        this._fParent = parent;
        this._ownerID = OwnerID;
        this._children = new FastList();
        this._topic = new FastMap();
        parent._children.add(this);
        ForumsBBSManager.getInstance().addForum(this);
        this._loaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        ResultSet result;
        PreparedStatement statement;
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            statement = con.prepareStatement("SELECT * FROM forums WHERE forum_id=?");
            statement.setInt(1, this._forumId);
            result = statement.executeQuery();
            if (result.next()) {
                this._forumName = result.getString("forum_name");
                this._forumPost = result.getInt("forum_post");
                this._forumType = result.getInt("forum_type");
                this._forumPerm = result.getInt("forum_perm");
                this._ownerID = result.getInt("forum_owner_id");
            }
            result.close();
            statement.close();
        }
        catch (Exception e) {
            _log.warning("data error on Forum " + this._forumId + " : " + e);
            e.printStackTrace();
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            statement = con.prepareStatement("SELECT * FROM topic WHERE topic_forum_id=? ORDER BY topic_id DESC");
            statement.setInt(1, this._forumId);
            result = statement.executeQuery();
            while (result.next()) {
                Topic t = new Topic(Topic.ConstructorType.RESTORE, result.getInt("topic_id"), result.getInt("topic_forum_id"), result.getString("topic_name"), result.getLong("topic_date"), result.getString("topic_ownername"), result.getInt("topic_ownerid"), result.getInt("topic_type"), result.getInt("topic_reply"));
                this._topic.put(t.getID(), t);
                if (t.getID() <= TopicBBSManager.getInstance().getMaxID(this)) continue;
                TopicBBSManager.getInstance().setMaxID(t.getID(), this);
            }
            result.close();
            statement.close();
        }
        catch (Exception e) {
            _log.warning("data error on Forum " + this._forumId + " : " + e);
            e.printStackTrace();
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getChildren() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT forum_id FROM forums WHERE forum_parent=?");
            statement.setInt(1, this._forumId);
            ResultSet result = statement.executeQuery();
            while (result.next()) {
                Forum f = new Forum(result.getInt("forum_id"), this);
                this._children.add(f);
                ForumsBBSManager.getInstance().addForum(f);
            }
            result.close();
            statement.close();
        }
        catch (Exception e) {
            _log.warning("data error on Forum (children): " + e);
            e.printStackTrace();
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    public int getTopicSize() {
        this.vload();
        return this._topic.size();
    }

    public Topic getTopic(int j) {
        this.vload();
        return this._topic.get(j);
    }

    public void addTopic(Topic t) {
        this.vload();
        this._topic.put(t.getID(), t);
    }

    public int getID() {
        return this._forumId;
    }

    public String getName() {
        this.vload();
        return this._forumName;
    }

    public int getType() {
        this.vload();
        return this._forumType;
    }

    public Forum getChildByName(String name) {
        this.vload();
        for (Forum f : this._children) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    public void rmTopicByID(int id) {
        this._topic.remove(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertIntoDb() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("INSERT INTO forums (forum_id,forum_name,forum_parent,forum_post,forum_type,forum_perm,forum_owner_id) VALUES (?,?,?,?,?,?,?)");
            statement.setInt(1, this._forumId);
            statement.setString(2, this._forumName);
            statement.setInt(3, this._fParent.getID());
            statement.setInt(4, this._forumPost);
            statement.setInt(5, this._forumType);
            statement.setInt(6, this._forumPerm);
            statement.setInt(7, this._ownerID);
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.warning("error while saving new Forum to db " + e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    public void vload() {
        if (!this._loaded) {
            this.load();
            this.getChildren();
            this._loaded = true;
        }
    }
}

