/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.communitybbs.Manager;

import com.l2jserver.gameserver.communitybbs.BB.CustomComment;
import com.l2jserver.gameserver.communitybbs.BB.CustomMsg;
import com.l2jserver.gameserver.communitybbs.Manager.BaseBBSManager;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.ShowBoard;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.List;
import java.util.StringTokenizer;
import javolution.util.FastList;

public class CustomBBSManager
extends BaseBBSManager {
    private static CustomBBSManager _instance = new CustomBBSManager();
    private static final int MESSAGE_LIST_LIMIT = 12;
    private static final int COMMENT_LIST_LIMIT = 10;
    private static final int MEDIUM_LENGTH = 1000;
    private static final int MINI_LENGTH = 170;
    private static final int MINI_VIEW = 1;
    private static final int MEDIUM_VIEW = 2;
    private static final int FULL_VIEW = 3;
    private static final int HIDE_EDIT = 0;
    private static final int SINGLE_EDIT = 1;
    private static final int MULTI_EDIT = 2;

    public static CustomBBSManager getInstance() {
        return _instance;
    }

    @Override
    public void parsecmd(String command, L2PcInstance activeChar) {
        if (activeChar == null) {
            return;
        }
        if (command.startsWith("_bbsmemo")) {
            command = "_bbscustom;msglist;memo";
        } else if (command.startsWith("_maillist")) {
            command = "_bbscustom;msglist;private";
        }
        if (command.startsWith("_bbscustom;")) {
            StringTokenizer st = new StringTokenizer(command, ";");
            st.nextToken();
            String subcmd = st.nextToken();
            CustomMsg.MsgType msgType = CustomMsg.MsgType.enumOf(st.nextToken());
            if (msgType.isClanmemberOnly && activeChar.getClan() == null) {
                this.authError(activeChar);
                return;
            }
            if (subcmd.equals("msglist")) {
                int msgPage = 1;
                if (st.hasMoreTokens()) {
                    msgPage = Integer.parseInt(st.nextToken());
                }
                this.showMessageList(activeChar, msgType, msgPage);
            } else if (subcmd.equals("msgnew")) {
                if (msgType.isMail) {
                    String toName = "";
                    if (st.hasMoreTokens()) {
                        toName = st.nextToken();
                    }
                    String title = "";
                    if (st.hasMoreTokens()) {
                        title = st.nextToken();
                    }
                    this.showMailNew(activeChar, msgType, toName, title, "");
                } else {
                    this.showMessageNew(activeChar, msgType);
                }
            } else if (subcmd.equals("msgreply")) {
                int msgId = Integer.parseInt(st.nextToken());
                this.showMailReply(activeChar, msgType, msgId);
            } else if (subcmd.equals("msgedit")) {
                int msgId = Integer.parseInt(st.nextToken());
                this.showMessageEdit(activeChar, msgType, msgId);
            } else if (subcmd.equals("msgview")) {
                int msgId = Integer.parseInt(st.nextToken());
                int comId = 0;
                st.nextToken();
                int msgPage = Integer.parseInt(st.nextToken());
                int comPage = Integer.parseInt(st.nextToken());
                char zoom = '-';
                if (st.hasMoreTokens()) {
                    zoom = st.nextToken().charAt(0);
                }
                char multi = '-';
                if (st.hasMoreTokens()) {
                    multi = st.nextToken().charAt(0);
                }
                this.showMessageView(activeChar, msgType, msgId, comId, msgPage, comPage, zoom, multi);
            } else if (subcmd.equals("comview")) {
                int msgId = Integer.parseInt(st.nextToken());
                int comId = Integer.parseInt(st.nextToken());
                int msgPage = Integer.parseInt(st.nextToken());
                int comPage = Integer.parseInt(st.nextToken());
                this.showCommentView(activeChar, msgType, msgId, comId, msgPage, comPage);
            } else if (subcmd.equals("msgdel")) {
                int msgId = Integer.parseInt(st.nextToken());
                st.nextToken();
                int msgPage = Integer.parseInt(st.nextToken());
                st.nextToken();
                if (this.doMessageDelete(activeChar, msgType, msgId)) {
                    this.showMessageList(activeChar, msgType, msgPage);
                }
            } else if (subcmd.equals("comdel")) {
                int msgId = Integer.parseInt(st.nextToken());
                int comId = Integer.parseInt(st.nextToken());
                int msgPage = Integer.parseInt(st.nextToken());
                int comPage = Integer.parseInt(st.nextToken());
                if (this.doCommentDelete(activeChar, msgType, msgId, comId)) {
                    this.showMessageView(activeChar, msgType, msgId, 0, msgPage, comPage);
                }
            } else {
                this.separateAndSend("<html><body><br><br><center> the command: " + command + " is not implemented yet</center><br><br></body></html>", activeChar);
            }
        } else {
            this.separateAndSend("<html><body><br><br><center> the command: " + command + " is not implemented yet</center><br><br></body></html>", activeChar);
        }
    }

    @Override
    public void parsewrite(String ar1, String ar2, String ar3, String ar4, String ar5, L2PcInstance activeChar) {
        if (activeChar == null) {
            return;
        }
        ar3 = this.quoteString(ar3);
        ar4 = this.quoteString(ar4);
        ar5 = this.quoteString(ar5);
        StringTokenizer st = new StringTokenizer(ar2, ";");
        CustomMsg.MsgType msgType = CustomMsg.MsgType.enumOf(st.nextToken());
        if (ar1.equals("create")) {
            if (!this.checkTitleAndContent(activeChar, ar4, ar3)) {
                return;
            }
            if (!CustomMsg.insert(msgType, "", ar4, ar3, activeChar)) {
                this.errorDialog(activeChar, "CREATE ERROR!");
                return;
            }
            this.showMessageList(activeChar, msgType);
        } else if (ar1.equals("mail")) {
            if (ar5.charAt(0) == ':') {
                ar5 = ar5.substring(1);
            }
            if (!this.checkTitleAndContent(activeChar, ar4, ar3)) {
                return;
            }
            if (!CustomMsg.insert(CustomMsg.MsgType.PRIVATE, ar5, ar4, ar3, activeChar)) {
                this.errorDialog(activeChar, "MAIL ERROR!");
                activeChar.sendPacket(new SystemMessage(SystemMessageId.MESSAGE_NOT_SENT));
                return;
            }
            activeChar.sendPacket(new SystemMessage(SystemMessageId.SENT_MAIL));
            L2PcInstance receiver = L2World.getInstance().getPlayer(ar5);
            if (receiver != null) {
                receiver.sendPacket(new SystemMessage(SystemMessageId.NEW_MAIL));
            }
            this.showMessageList(activeChar, msgType);
        } else if (ar1.equals("edit")) {
            if (!this.checkTitleAndContent(activeChar, ar4, ar3)) {
                return;
            }
            int msgId = Integer.parseInt(st.nextToken());
            if (!CustomMsg.update(msgId, ar4, ar3, activeChar)) {
                this.errorDialog(activeChar, "UPDATE ERROR!");
                return;
            }
            this.showMessageList(activeChar, msgType);
        } else if (ar1.equals("comment")) {
            if (ar3.length() > 256) {
                activeChar.sendPacket(new SystemMessage(SystemMessageId.ONE_LINE_RESPONSE_NOT_EXCEED_128_CHARACTERS));
                return;
            }
            int msgId = Integer.parseInt(st.nextToken());
            if (!CustomComment.insert(msgId, ar3, activeChar)) {
                this.errorDialog(activeChar, "COMMENT ERROR!");
                return;
            }
            this.showMessageView(activeChar, msgType, msgId);
        } else {
            this.separateAndSend("<html><body><br><br><center>the command: " + ar1 + " is not implemented yet</center><br><br></body></html>", activeChar);
        }
    }

    private boolean checkTitleAndContent(L2PcInstance activeChar, String title, String content) {
        if (title.length() > 128) {
            activeChar.sendPacket(new SystemMessage(SystemMessageId.PLEASE_INPUT_TITLE_LESS_128_CHARACTERS));
            return false;
        }
        if (content.length() > 3000) {
            activeChar.sendPacket(new SystemMessage(SystemMessageId.PLEASE_INPUT_CONTENT_LESS_3000_CHARACTERS));
            return false;
        }
        return true;
    }

    public int getPrivateMsgCnt(L2PcInstance activeChar) {
        return CustomMsg.getPrivateMsgCnt(activeChar);
    }

    private void showMessageList(L2PcInstance activeChar, CustomMsg.MsgType msgType) {
        this.showMessageList(activeChar, msgType, 1);
    }

    private void showMessageList(L2PcInstance activeChar, CustomMsg.MsgType msgType, int msgPage) {
        FastList msgTable;
        int msgTotal;
        if (msgPage < 1) {
            msgPage = 1;
        }
        if ((msgTotal = CustomMsg.list((List<CustomMsg>)(msgTable = new FastList()), msgType, activeChar, (msgPage - 1) * 12, 12)) < 0) {
            this.separateAndSend("<html><body><br><br><center><font color=FF0000>BBS ERROR!</font></center></body></html>", activeChar);
            return;
        }
        int nbp = 1 + (msgTotal - 1) / 12;
        if (msgPage > nbp) {
            msgPage = nbp;
        }
        StringBuilder html = new StringBuilder(8192);
        html.append("<html><body>");
        this.appendTopTag(html, msgType);
        html.append("<center><table border=0 cellspacing=0 cellpadding=4 bgcolor=888888><tr>");
        html.append("<td WIDTH=60 align=right>&$416;</td><td WIDTH=435 align=center>&$413;</td><td WIDTH=110 align=center>&$417;</td><td WIDTH=72 align=center>&$418;</td>");
        if (msgType.canComment) {
            html.append("<td WIDTH=60 align=right>&$423;</td>");
        } else if (msgType.isMail) {
            html.append("<td WIDTH=60 align=right></td>");
        } else {
            html.append("<td WIDTH=28 align=right></td>");
        }
        html.append("</tr></table>");
        int cnt = 0;
        for (CustomMsg tmpMsg : msgTable) {
            if (cnt % 2 == 0) {
                html.append("<table border=0 cellspacing=0 cellpadding=4 bgcolor=333333>");
            } else {
                html.append("<table border=0 cellspacing=0 cellpadding=4 bgcolor=444444>");
            }
            html.append("<tr><td FIXWIDTH=60 align=right>").append(tmpMsg.getMsgId()).append("</td><td FIXWIDTH=435 align=left><a action=\"bypass _bbscustom;msgview;").append(msgType.toString()).append(';').append(tmpMsg.getMsgId()).append(";0;").append(msgPage).append(";0\">").append(this.htmlescape(this.cut(tmpMsg.getTitle(), 70))).append("</a></td>");
            html.append("<td FIXWIDTH=110 align=right>").append(tmpMsg.getFromName()).append("</td>");
            html.append("<td FIXWIDTH=100 align=left>").append(tmpMsg.getDate()).append("</td>");
            if (msgType.canComment) {
                html.append("<td FIXWIDTH=32 align=right>").append(tmpMsg.getComCount()).append("</td>");
            } else if (msgType.isMail) {
                html.append("<td FIXWIDTH=32 align=center>").append(tmpMsg.getReadFlg() ? "\u2713" : "<font color=FF0000>new!</font>").append("</td>");
            }
            html.append("</tr></table>");
            ++cnt;
        }
        while (cnt < 12) {
            if (cnt % 2 == 0) {
                html.append("<table border=0 cellspacing=0 cellpadding=4 bgcolor=333333>");
            } else {
                html.append("<table border=0 cellspacing=0 cellpadding=4 bgcolor=444444>");
            }
            if (msgType.canComment || msgType.isMail) {
                html.append("<tr><td WIDTH=737>\u3000</td></tr></table>");
            } else {
                html.append("<tr><td WIDTH=705>\u3000</td></tr></table>");
            }
            ++cnt;
        }
        html.append("<br><table border=0 cellspaceing=0 cellpadding=0 width=730><tr>");
        html.append("<td><button value=\"&$422;\" action=\"bypass _bbscustom;msglist;").append(msgType.toString()).append("\" width=65 height=20 back=L2UI_ct1.button_df fore=L2UI_ct1.button_df>");
        html.append("</td><td width=600 align=center><table border=0 cellspaceing=0><tr>");
        int startIdx = 1 + (msgPage - 1) / 10 * 10;
        int nextIdx = startIdx + 10;
        html.append("<td><button");
        if (startIdx - 1 >= 1) {
            html.append(" action=\"bypass _bbscustom;msglist;" + msgType.toString() + ";" + (startIdx - 1) + "\"");
        }
        html.append(" back=l2ui_ch3.prev1_down fore=l2ui_ch3.prev1 width=16 height=16></td><td><button");
        if (msgPage - 1 >= 1) {
            html.append(" action=\"bypass _bbscustom;msglist;" + msgType.toString() + ";" + (msgPage - 1) + "\"");
        }
        html.append(" width=16 height=16 back=l2ui_ch3.prev1_down fore=l2ui_ch3.prev1></td>");
        for (int i = startIdx; i <= nbp && i < nextIdx; ++i) {
            html.append("<td WIDTH=16>");
            if (i == msgPage) {
                html.append(i);
            } else {
                html.append("<a action=\"bypass _bbscustom;msglist;").append(msgType.toString()).append(';').append(i).append("\">").append(i).append("</a>");
            }
            html.append("</td>");
        }
        html.append("<td><button");
        if (msgPage + 1 <= nbp) {
            html.append(" action=\"bypass _bbscustom;msglist;" + msgType.toString() + ";" + (msgPage + 1) + "\"");
        }
        html.append(" width=16 height=16 back=l2ui_ch3.next1_down fore=l2ui_ch3.next1></td><td><button");
        if (nextIdx <= nbp) {
            html.append(" action=\"bypass _bbscustom;msglist;" + msgType.toString() + ";" + nextIdx + "\"");
        }
        html.append(" width=16 height=16 back=l2ui_ch3.next1_down fore=l2ui_ch3.next1></td>");
        html.append("</tr></table></td><td width=65 align=right>");
        if (this.authNew(activeChar, msgType)) {
            html.append("<button value=\"&$421;\" action=\"bypass _bbscustom;msgnew;").append(msgType.toString()).append("\" width=65 height=20 back=L2UI_ct1.button_df fore=L2UI_ct1.button_df>");
        }
        html.append("</td>");
        html.append("</tr></table></center>");
        this.appendBottomTag(html);
        html.append("</body></html>");
        this.separateAndSend(html.toString(), activeChar);
    }

    private void showMessageNew(L2PcInstance activeChar, CustomMsg.MsgType msgType) {
        if (!this.authNew(activeChar, msgType)) {
            this.authError(activeChar);
            return;
        }
        if (msgType.isMail) {
            throw new IllegalArgumentException("showMessageNew(" + activeChar.getName() + "," + msgType.toString() + ")");
        }
        StringBuilder html = new StringBuilder(8192);
        html.append("<html><body>");
        this.appendTopTag(html, msgType);
        html.append("<center><table border=0 cellspacing=0 cellpadding=5><tr>");
        html.append("<td WIDTH=60 align=center>&$909;</td>");
        switch (msgType) {
            case CLAN: {
                html.append("<td FIXWIDTH=540>").append(activeChar.getClan().getName()).append("</td>");
                break;
            }
            default: {
                html.append("<td FIXWIDTH=540>").append(msgType.getCaption()).append("</td>");
            }
        }
        html.append("</tr><tr>");
        html.append("<td WIDTH=60 align=center>&$413;</td><td><edit var=\"Title\" width=540></td>");
        html.append("</tr><tr>");
        html.append("<td WIDTH=60 align=center valign=top>&$427;</td><td><MultiEdit var=\"Content\" width=540 height=300></td>");
        html.append("</tr></table><img src=L2UI.squareblank width=1 height=5><img src=L2UI.squaregray width=610 height=1><img src=L2UI.squareblank width=1 height=5>");
        html.append("<table border=0 cellspacing=0 cellpadding=5><tr>");
        html.append("<td><button value=\"&$140;\"");
        html.append(" action=\"Write Custom create ").append(msgType.toString()).append(" Content Title\"");
        html.append(" width=65 height=20 back=L2UI_ct1.button_df fore=L2UI_ct1.button_df></td><td><button value=\"&$141;\" action=\"bypass _bbscustom;msglist;").append(msgType.toString()).append("\" width=75 height=20 back=L2UI_ct1.button_df fore=L2UI_ct1.button_df></td>");
        html.append("<td WIDTH=350></td>");
        html.append("</tr></table></center>");
        this.appendBottomTag(html);
        html.append("</body></html>");
        this.separateAndSend(html.toString(), activeChar);
    }

    private void showMailReply(L2PcInstance activeChar, CustomMsg.MsgType msgType, int msgId) {
        CustomMsg curMsg = new CustomMsg().load(msgId);
        if (!curMsg.isSuccess()) {
            return;
        }
        if (msgType == CustomMsg.MsgType.MEMO) {
            String title = curMsg.getTitle();
            String message = curMsg.getMessage();
            curMsg = null;
            this.showMailNew(activeChar, msgType, ":", title, message);
        } else {
            String toName = curMsg.getFromName();
            String title = curMsg.getTitle();
            curMsg = null;
            if (!title.toLowerCase().startsWith("re:")) {
                title = "Re:" + title;
            }
            this.showMailNew(activeChar, msgType, toName, title, "");
        }
    }

    private void showMailNew(L2PcInstance activeChar, CustomMsg.MsgType msgType, String address, String title, String content) {
        if (!this.authReply(activeChar, msgType)) {
            this.authError(activeChar);
            return;
        }
        StringBuilder html = new StringBuilder(8192);
        html.append("<html><body>");
        this.appendTopTag(html, msgType);
        html.append("<center><table border=0 cellspacing=0 cellpadding=5><tr>");
        html.append("<td WIDTH=60 align=center>&$909;</td><td><edit var=\"Address\" width=540></td>");
        html.append("</tr><tr>");
        html.append("<td WIDTH=60 align=center>&$413;</td><td><edit var=\"Title\" width=540></td>");
        html.append("</tr><tr>");
        html.append("<td WIDTH=60 align=center valign=top>&$427;</td><td><MultiEdit var=\"Content\" width=540 height=300></td>");
        html.append("</tr></table><img src=L2UI.squareblank width=1 height=5><img src=L2UI.squaregray width=610 height=1><img src=L2UI.squareblank width=1 height=5>");
        html.append("<table border=0 cellspacing=0 cellpadding=5><tr>");
        html.append("<td><button value=\"&$140;\"");
        html.append(" action=\"Write Custom mail ").append(msgType.toString()).append(" Content Title Address\"");
        html.append(" width=65 height=20 back=L2UI_ct1.button_df fore=L2UI_ct1.button_df></td><td><button value=\"&$141;\" action=\"bypass _bbscustom;msglist;").append(msgType.toString()).append("\" width=75 height=20 back=L2UI_ct1.button_df fore=L2UI_ct1.button_df></td>");
        html.append("<td WIDTH=350></td>");
        html.append("</tr></table></center>");
        this.appendBottomTag(html);
        html.append("</body></html>");
        if (html.length() >= 8180) {
            this.separateAndSend("<html><body><br><br><center><font color=FF0000>PACKET TOO LARGE!</font></center></body></html>", activeChar);
            return;
        }
        this.send1001(html.toString(), activeChar);
        this.send1002(activeChar, content, title, address);
    }

    private void showMessageEdit(L2PcInstance activeChar, CustomMsg.MsgType msgType, int msgId) {
        CustomMsg curMsg = new CustomMsg().load(msgId);
        if (!this.authEdit(activeChar, msgType, curMsg)) {
            this.authError(activeChar);
            return;
        }
        StringBuilder html = new StringBuilder(8192);
        html.append("<html><body>");
        this.appendTopTag(html, msgType);
        html.append("<center><table border=0 cellspacing=0 cellpadding=5><tr>");
        html.append("<td WIDTH=60 align=center>&$909;</td>");
        switch (msgType) {
            case PRIVATE: {
                html.append("<td FIXWIDTH=540>").append(curMsg.getToName()).append("</td>");
                break;
            }
            case CLAN: {
                html.append("<td FIXWIDTH=540>").append(activeChar.getClan().getName()).append("</td>");
                break;
            }
            default: {
                html.append("<td FIXWIDTH=540>").append(msgType.getCaption()).append("</td>");
            }
        }
        html.append("</tr><tr>");
        html.append("<td WIDTH=60 align=center>&$413;</td><td><edit var=\"Title\" width=540></td>");
        html.append("</tr><tr>");
        html.append("<td WIDTH=60 align=center valign=top>&$427;</td><td><MultiEdit var=\"Content\" width=540 height=300></td>");
        html.append("</tr></table><img src=L2UI.squareblank width=1 height=5><img src=L2UI.squaregray width=610 height=1><img src=L2UI.squareblank width=1 height=5>");
        html.append("<table border=0 cellspacing=0 cellpadding=5><tr>");
        html.append("<td><button value=\"&$140;\" action=\"Write Custom edit ").append(msgType.toString()).append(';').append(curMsg.getMsgId()).append(" Content Title\" width=65 height=20 back=\"L2UI_ct1.button_df\" fore=\"L2UI_ct1.button_df\"></td>");
        html.append("<td><button value=\"&$141;\" action=\"bypass _bbscustom;msglist;").append(msgType.toString()).append("\" width=75 height=20 back=\"L2UI_ct1.button_df\" fore=\"L2UI_ct1.button_df\"></td>");
        html.append("<td WIDTH=350></td>");
        html.append("</tr></table></center>");
        this.appendBottomTag(html);
        html.append("</body></html>");
        if (html.length() >= 8180) {
            this.separateAndSend("<html><body><br><br><center><font color=FF0000>PACKET TOO LARGE!</font></center></body></html>", activeChar);
            return;
        }
        this.send1001(html.toString(), activeChar);
        this.send1002(activeChar, curMsg.getMessage(), "", curMsg.getTitle());
    }

    private void showMessageView(L2PcInstance activeChar, CustomMsg.MsgType msgType, int msgId) {
        this.showMessageView(activeChar, msgType, msgId, 0, 1, 1, '-', '-');
    }

    private void showMessageView(L2PcInstance activeChar, CustomMsg.MsgType msgType, int msgId, int dummy1, int msgPage, int comPage) {
        this.showMessageView(activeChar, msgType, msgId, dummy1, msgPage, comPage, '-', '-');
    }

    private void showMessageView(L2PcInstance activeChar, CustomMsg.MsgType msgType, int msgId, int dummy1, int msgPage, int comPage, char fullMsg, char multiCom) {
        String mes;
        if (msgPage < 1) {
            msgPage = 1;
        }
        if (comPage < 1) {
            comPage = 1;
        }
        int msgViewStyle = fullMsg == 'F' ? 3 : (comPage == 1 ? 2 : 1);
        boolean showComList = msgType.canComment;
        if (msgViewStyle == 3) {
            showComList = false;
        }
        int comInputStyle = !msgType.canComment ? 0 : (!this.authNew(activeChar, msgType) ? 0 : (multiCom == 'M' ? 2 : 1));
        CustomMsg curMsg = new CustomMsg().load(msgId);
        FastList comTable = null;
        int comTotal = -1;
        int nbp = 0;
        if (showComList) {
            comTable = new FastList();
            comTotal = CustomComment.list((List<CustomComment>)comTable, msgId, (comPage - 1) * 10, 10);
            if (comTotal < 0) {
                this.separateAndSend("<html><body><br><br><center><font color=FF0000>COMMENT ERROR!</font></center></body></html>", activeChar);
                return;
            }
            nbp = 1 + (comTotal - 1) / 10;
            if (comPage > nbp) {
                comPage = nbp;
            }
            if (comTotal == 0) {
                msgViewStyle = 3;
            }
        }
        StringBuilder html = new StringBuilder(8192);
        html.append("<html><body>");
        this.appendTopTag(html, msgType);
        html.append("<center><table border=0 cellspacing=0 cellpadding=5 width=570 bgcolor=444444>");
        html.append("<tr>");
        html.append("<td WIDTH=60 align=right>&$413; : </td><td FIXWIDTH=510>").append(this.htmlescape(curMsg.getTitle())).append("</td>");
        html.append("</tr>");
        html.append("</table><table border=0 cellspacing=0 cellpadding=5 width=570 bgcolor=444444>");
        html.append("<tr>");
        html.append("<td WIDTH=60 align=right>&$417; : </td><td FIXWIDTH=350>").append(curMsg.getFromName()).append("</td><td WIDTH=60 align=right>&$418; : </td><td WIDTH=100>").append(curMsg.getDate()).append("</td>");
        html.append("</tr>");
        html.append("</table><table border=0 cellspacing=0 cellpadding=5 width=570 bgcolor=333333>");
        html.append("<tr>");
        html.append("<td FIXWIDTH=600 height=66>");
        if (msgViewStyle == 1 && curMsg.getMessage().length() > 170) {
            mes = curMsg.getMessage().substring(0, 170).replace("\r", "").replaceAll("\n+", " ");
            html.append(this.htmlescape(mes));
            html.append("<a action=\"bypass _bbscustom;msgview;").append(msgType.toString()).append(';').append(msgId).append(";0;").append(msgPage).append(';').append(comPage).append(";F\">\u2026</a>");
        } else if (msgViewStyle == 2 && curMsg.getMessage().length() > 1060) {
            mes = curMsg.getMessage().substring(0, 1000);
            html.append(this.htmlescape(mes));
            html.append("<a action=\"bypass _bbscustom;msgview;").append(msgType.toString()).append(';').append(msgId).append(";0;").append(msgPage).append(';').append(comPage).append(";F\">\u2026</a>");
        } else {
            html.append(this.htmlescape(curMsg.getMessage()));
        }
        html.append("</td>");
        html.append("</tr>");
        html.append("</table><table border=0 cellspaceing=0 cellpadding=0 width=730><tr>");
        html.append("<td>");
        if (fullMsg == 'F') {
            html.append("<button value=\"&$161;\" action=\"bypass _bbscustom;msgview;").append(msgType.toString()).append(';').append(msgId).append(";0;").append(msgPage).append(';').append(comPage).append("\" width=65 height=20 back=L2UI_ct1.button_df fore=L2UI_ct1.button_df>");
        } else {
            html.append("<button value=\"&$422;\" action=\"bypass _bbscustom;msglist;").append(msgType.toString()).append(';').append(msgPage).append("\" width=65 height=20 back=L2UI_ct1.button_df fore=L2UI_ct1.button_df>");
        }
        html.append("</td><td width=665 align=right><table border=0 cellspacing=0 cellpadding=0><tr>");
        if (this.authReply(activeChar, msgType)) {
            html.append("<td> <button value=\"").append(msgType.isMail ? "&$426;" : "&$905;").append("\" action=\"bypass _bbscustom;msgreply;").append(msgType.toString()).append(';').append(msgId).append("\" width=65 height=20 back=L2UI_ct1.button_df fore=L2UI_ct1.button_df></td>");
        }
        if (this.authEdit(activeChar, msgType, curMsg)) {
            html.append("<td> <button value=\"&$424;\" action=\"bypass _bbscustom;msgedit;").append(msgType.toString()).append(';').append(msgId).append("\" width=65 height=20 back=L2UI_ct1.button_df fore=L2UI_ct1.button_df></td>");
        }
        if (this.authDelete(activeChar, msgType, curMsg)) {
            html.append("<td> <button value=\"&$425;\" action=\"bypass _bbscustom;msgdel;").append(msgType.toString()).append(';').append(msgId).append(";0;").append(msgPage).append(";0\" width=65 height=20 back=L2UI_ct1.button_df fore=L2UI_ct1.button_df></td>");
        }
        if (this.authNew(activeChar, msgType)) {
            html.append("<td> <button value=\"&$421;\" action=\"bypass _bbscustom;msgnew;").append(msgType.toString()).append("\" width=65 height=20 back=L2UI_ct1.button_df fore=L2UI_ct1.button_df></td>");
        }
        html.append("</tr></table></td>");
        html.append("</tr></table>");
        if (comInputStyle != 0) {
            html.append("<img src=L2UI.squareblank width=1 height=5><img src=L2UI.squaregray width=750 height=1><img src=L2UI.squareblank width=1 height=5>");
            html.append("<table border=0 cellspacing=0 cellpadding=4><tr>");
            if (comInputStyle == 1) {
                html.append("<td WIDTH=70 align=right valign=top><a action=\"bypass _bbscustom;msgview;").append(msgType.toString()).append(';').append(msgId).append(";0;").append(msgPage).append(';').append(comPage).append(';').append(fullMsg).append(";M\">\u25bd</a>&$423;</td>");
                html.append("<td><edit var=\"Content\" width=540></td>");
            } else {
                html.append("<td WIDTH=70 align=right valign=top><a action=\"bypass _bbscustom;msgview;").append(msgType.toString()).append(';').append(msgId).append(";0;").append(msgPage).append(';').append(comPage).append(';').append(fullMsg).append(";-\">\u25b3</a>&$423;</td>");
                html.append("<td><MultiEdit var=\"Content\" width=540 height=80></td>");
            }
            html.append("<td valign=top><button value=\"&$913;\" action=\"Write Custom comment ").append(msgType.toString()).append(';').append(msgId).append(" Content Content\" width=65 height=20 back=L2UI_ct1.button_df fore=L2UI_ct1.button_df></td>");
            html.append("</tr></table>");
        }
        if (showComList) {
            if (comTotal == 0) {
                html.append("<img src=L2UI.squareblank width=1 height=20>");
            } else {
                html.append("<table border=0 cellspacing=0 cellpadding=4><tr>");
                if (nbp >= 3) {
                    html.append("<td WIDTH=16><button");
                    if (comPage > 1) {
                        html.append(" action=\"bypass _bbscustom;msgview;" + msgType.toString() + ";" + msgId + ";0;" + msgPage + ";" + 1 + "\"");
                    }
                    html.append(" width=16 height=16 back=l2ui_ch3.prev1_down fore=l2ui_ch3.prev1></td>");
                }
                if (nbp >= 2) {
                    html.append("<td WIDTH=16><button");
                    if (comPage > 1) {
                        html.append(" action=\"bypass _bbscustom;msgview;" + msgType.toString() + ";" + msgId + ";0;" + msgPage + ";" + (comPage - 1) + "\"");
                    }
                    html.append(" width=16 height=16 back=l2ui_ch3.prev1_down fore=l2ui_ch3.prev1></td>");
                }
                html.append("<td WIDTH=70 align=center>&$423;</td>");
                if (nbp >= 2) {
                    html.append("<td WIDTH=16><button");
                    if (comPage < nbp) {
                        html.append(" action=\"bypass _bbscustom;msgview;" + msgType.toString() + ";" + msgId + ";0;" + msgPage + ";" + (comPage + 1) + "\"");
                    }
                    html.append(" width=16 height=16 back=l2ui_ch3.next1_down fore=l2ui_ch3.next1></td>");
                }
                if (nbp >= 3) {
                    html.append("<td WIDTH=16><button");
                    if (comPage < nbp) {
                        html.append(" action=\"bypass _bbscustom;msgview;" + msgType.toString() + ";" + msgId + ";0;" + msgPage + ";" + nbp + "\"");
                    }
                    html.append(" width=16 height=16 back=l2ui_ch3.next1_down fore=l2ui_ch3.next1></td>");
                }
                html.append("</tr></table>");
                int cnt = 0;
                for (CustomComment tmpCom : comTable) {
                    if (cnt % 2 == 0) {
                        html.append("<table border=0 cellspacing=0 cellpadding=4 bgcolor=444444>");
                    } else {
                        html.append("<table border=0 cellspacing=0 cellpadding=4 bgcolor=333333>");
                    }
                    html.append("<tr><td FIXWIDTH=40 align=right valign=top>").append(tmpCom.getComId()).append("</td><td FIXWIDTH=435 align=left valign=top>");
                    String m = tmpCom.getMessage();
                    if (m.length() > 230) {
                        html.append(this.htmlescape(m.substring(0, 170)));
                        html.append("<a action=\"bypass _bbscustom;comview;").append(msgType.toString()).append(';').append(msgId).append(';').append(tmpCom.getComId()).append(';').append(msgPage).append(';').append(comPage).append("\">\u2026</a>");
                    } else {
                        html.append(this.htmlescape(m));
                    }
                    m = null;
                    html.append("</td><td FIXWIDTH=110 align=right valign=bottom>");
                    if (tmpCom.isOwn(activeChar)) {
                        html.append("<font color=00FF00>").append(tmpCom.getFromName()).append("</font>");
                    } else if (tmpCom.getFromName().equals(curMsg.getFromName())) {
                        html.append("<font color=00FFFF>").append(tmpCom.getFromName()).append("</font>");
                    } else {
                        html.append(tmpCom.getFromName());
                    }
                    html.append("</td><td FIXWIDTH=92 align=left valign=bottom>").append(tmpCom.getDate()).append("</td><td FIXWIDTH=24 align=center valign=bottom>");
                    String caption = tmpCom.isOwn(activeChar) ? "<font color=FF0000>\u2715</font>" : (activeChar.isGM() ? "<font color=FFFF00>\u2717</font>" : null);
                    if (caption != null) {
                        html.append("<a action=\"bypass _bbscustom;comdel;").append(msgType.toString()).append(';').append(msgId).append(';').append(tmpCom.getComId()).append(';').append(msgPage).append(';').append(comPage).append("\">").append(caption).append("</a>");
                    }
                    html.append("</td></tr></table>");
                    ++cnt;
                }
            }
        }
        html.append("</center>");
        this.appendBottomTag(html);
        html.append("</body></html>");
        this.separateAndSend(html.toString(), activeChar);
        if (msgType.isMail) {
            curMsg.setReadFlg(true);
        }
    }

    private void showCommentView(L2PcInstance activeChar, CustomMsg.MsgType msgType, int msgId, int comId, int msgPage, int comPage) {
        CustomComment curCom = new CustomComment().load(msgId, comId);
        if (curCom == null) {
            this.separateAndSend("<html><body><br><br><center><font color=FF0000>COMMENT ERROR!</font></center></body></html>", activeChar);
            return;
        }
        StringBuilder html = new StringBuilder(8192);
        html.append("<html><body>");
        this.appendTopTag(html, msgType);
        html.append("<center><table border=0 cellspacing=0 cellpadding=5 width=570 bgcolor=444444>");
        html.append("<tr>");
        html.append("<td FIXWIDTH=60 align=right>&$413; : </td><td FIXWIDTH=510>Re:").append(this.htmlescape(curCom.getTitle())).append("  #").append(comId).append("</td>");
        html.append("</tr>");
        html.append("</table><table border=0 cellspacing=0 cellpadding=5 width=570 bgcolor=444444>");
        html.append("<tr>");
        html.append("<td FIXWIDTH=60 align=right>&$417; : </td><td FIXWIDTH=350>").append(curCom.getFromName()).append("</td><td FIXWIDTH=60 align=right>&$418; : </td><td FIXWIDTH=100>").append(curCom.getDate()).append("</td>");
        html.append("</tr>");
        html.append("</table><table border=0 cellspacing=0 cellpadding=5 width=570 bgcolor=333333>");
        html.append("<tr>");
        html.append("<td FIXWIDTH=600 height=66>");
        html.append(curCom.getMessage());
        html.append("</td>");
        html.append("</tr>");
        html.append("</table><img src=L2UI.squareblank width=1 height=5><img src=L2UI.squaregray width=750 height=1><img src=L2UI.squareblank width=1 height=5>");
        html.append("<table border=0 cellspaceing=0 cellpadding=0 width=730><tr>");
        html.append("<td><button value=\"&$161;\" action=\"bypass _bbscustom;msgview;").append(msgType.toString()).append(';').append(msgId).append(";0;").append(msgPage).append(';').append(comPage).append("\" width=65 height=20 back=L2UI_ct1.button_df fore=L2UI_ct1.button_df>");
        html.append("</td><td width=665 align=right><table border=0 cellspacing=0 cellpadding=0><tr></tr></table></td>");
        html.append("</tr></table></center>");
        this.appendBottomTag(html);
        html.append("</body></html>");
        this.separateAndSend(html.toString(), activeChar);
    }

    private boolean doMessageDelete(L2PcInstance activeChar, CustomMsg.MsgType msgType, int msgId) {
        CustomMsg delMsg = new CustomMsg().load(msgId);
        int delflag = 0;
        if (delMsg.isOwn(activeChar)) {
            delflag = 1;
        } else if (activeChar.isGM()) {
            delflag = 2;
        } else {
            this.authError(activeChar);
            return false;
        }
        delMsg = null;
        if (!CustomMsg.delete(msgId, delflag)) {
            this.errorDialog(activeChar, "DELETE ERROR!");
            return false;
        }
        return true;
    }

    private boolean doCommentDelete(L2PcInstance activeChar, CustomMsg.MsgType msgType, int msgId, int comId) {
        CustomComment delCom = new CustomComment().load(msgId, comId);
        int delflag = 0;
        if (delCom.isOwn(activeChar)) {
            delflag = 1;
        } else if (activeChar.isGM()) {
            delflag = 2;
        } else {
            this.authError(activeChar);
            return false;
        }
        delCom = null;
        if (!CustomComment.delete(msgId, comId, delflag)) {
            this.errorDialog(activeChar, "DELETE ERROR!");
            return false;
        }
        return true;
    }

    private void appendTopTag(StringBuilder html, CustomMsg.MsgType msgType) {
        html.append("<table border=0 cellspacing=10 cellpadding=0><tr><td fixwidth=400>").append(this.getHeaderTree(msgType)).append("</td><td fixwidth=400 align=right>").append(this.getSubMenu(msgType)).append("</td></tr></table>");
    }

    private void appendBottomTag(StringBuilder html) {
        html.append("<img src=L2UI.squareblank width=1 height=20>");
    }

    private String getHeaderTree(CustomMsg.MsgType msgType) {
        String html = null;
        switch (msgType) {
            case CLAN: {
                html = "<a action=\"\"> &$377; </a>&nbsp;>&nbsp;<a action=\"bypass _bbsclan_clanlist\"> &$809; </a>&nbsp;>&nbsp;<a action=\"bypass _bbsclan_clanhome\"> &$802; </a>&nbsp;>&nbsp;<a action=\"bypass _bbscustom;msglist;" + msgType.toString() + "\"> " + msgType.getCaption() + " </a>";
                break;
            }
            default: {
                html = "<a action=\"\"> &$377; </a>&nbsp;>&nbsp;<a action=\"bypass _bbscustom;msglist;" + msgType.toString() + "\"> " + msgType.getCaption() + " </a>";
            }
        }
        return html;
    }

    private String getSubMenu(CustomMsg.MsgType msgType) {
        if (msgType.canComment) {
            return "|<a action=\"bypass _bbscustom;msglist;announce\">\u304a\u77e5\u3089\u305b</a>|<a action=\"bypass _bbscustom;msglist;recruit\">\u8840\u76df\u52df\u96c6</a>|<a action=\"bypass _bbscustom;msglist;trade\">\u30c8\u30ec\u30fc\u30c9</a>|<a action=\"bypass _bbscustom;msglist;event\">\u30a4\u30d9\u30f3\u30c8</a>|<a action=\"bypass _bbscustom;msglist;qa\">Q&A</a>|<a action=\"bypass _bbscustom;msglist;hello\">\u3042\u3044\u3055\u3064</a>|<a action=\"bypass _bbscustom;msglist;default\">\u96d1\u8ac7</a>|";
        }
        return "";
    }

    private void errorDialog(L2PcInstance activeChar, String msg) {
        activeChar.sendPacket(new NpcHtmlMessage(0, "<html><title>ERROR</title><body><br><br><center><font color=FF0000>" + msg + "</font></center></body></html>"));
    }

    private void authError(L2PcInstance activeChar) {
        activeChar.sendPacket(new SystemMessage(SystemMessageId.YOU_ARE_NOT_AUTHORIZED_TO_DO_THAT));
    }

    private boolean isShutout(L2PcInstance activeChar) {
        return false;
    }

    private boolean isTuEEE(L2PcInstance activeChar) {
        return false;
    }

    private boolean authReply(L2PcInstance activeChar, CustomMsg.MsgType msgType) {
        return msgType.canReply;
    }

    private boolean authEdit(L2PcInstance activeChar, CustomMsg.MsgType msgType, CustomMsg curMsg) {
        if (this.isShutout(activeChar)) {
            return false;
        }
        return msgType.canEdit && curMsg.isOwn(activeChar) || this.isTuEEE(activeChar);
    }

    private boolean authDelete(L2PcInstance activeChar, CustomMsg.MsgType msgType, CustomMsg curMsg) {
        if (this.isShutout(activeChar)) {
            return false;
        }
        return curMsg.isOwn(activeChar) || activeChar.isGM() || this.isTuEEE(activeChar);
    }

    private boolean authNew(L2PcInstance activeChar, CustomMsg.MsgType msgType) {
        if (this.isShutout(activeChar)) {
            return false;
        }
        return !msgType.canPostAdminOnly || msgType.isMail || activeChar.isGM() || this.isTuEEE(activeChar);
    }

    private CharSequence cut(CharSequence s, int max) {
        int w;
        char c;
        int index;
        int length = s.length();
        if (length * 2 <= max) {
            return s;
        }
        int pos = 0;
        for (index = 0; index < length; ++index) {
            c = s.charAt(index);
            int n = w = c < '\u007f' || c > '\uff60' ? 1 : 2;
            if (pos + w > max) break;
            pos += w;
        }
        if (index >= length) {
            return s;
        }
        max -= 2;
        pos = 0;
        for (index = 0; index < length; ++index) {
            c = s.charAt(index);
            int n = w = c < '\u007f' || c > '\uff60' ? 1 : 2;
            if (pos + w > max) break;
            pos += w;
        }
        return s.subSequence(0, index) + "\u2026";
    }

    @Override
    protected void separateAndSend(String html, L2PcInstance acha) {
        if (html.length() < 12270) {
            super.separateAndSend(html, acha);
        } else {
            super.separateAndSend("<html><body><br><br><center><font color=FF0000>PACKET TOO LARGE!</font></center></body></html>", acha);
        }
    }

    @Override
    protected void send1002(L2PcInstance activeChar, String string1, String string2, String string3) {
        FastList _arg = new FastList();
        _arg.add("0");
        _arg.add("0");
        _arg.add("0");
        _arg.add("0");
        _arg.add("0");
        _arg.add("0");
        _arg.add(activeChar.getName());
        _arg.add(Integer.toString(activeChar.getObjectId()));
        _arg.add(activeChar.getAccountName());
        _arg.add("9");
        _arg.add(string3);
        _arg.add(string2);
        _arg.add(string1);
        _arg.add("0");
        _arg.add("0");
        _arg.add("0");
        _arg.add("0");
        activeChar.sendPacket(new ShowBoard((List<String>)_arg));
    }

    protected String quoteString(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        CharSequence result = input;
        StringBuilder buf = new StringBuilder(input.length());
        int index = 0;
        block5: while (index < input.length()) {
            int ch = input.charAt(index);
            block0 : switch (ch) {
                case 13: {
                    result = buf;
                    ++index;
                    break;
                }
                case 10: 
                case 32: {
                    char cl;
                    result = buf.append((char)ch);
                    while (++index < input.length()) {
                        cl = input.charAt(index);
                        if (cl == ch || cl == '\r') continue;
                        break block0;
                    }
                    continue block5;
                }
                case 38: {
                    char cl;
                    if (index + 1 < input.length() && ((cl = input.charAt(index + 1)) == '$' || cl == '#')) {
                        result = buf;
                        ch = 63;
                    }
                }
                default: {
                    buf.append((char)ch);
                    ++index;
                }
            }
        }
        return result.toString();
    }
}

