/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.L2Augmentation;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.skills.Stats;
import com.l2jserver.util.Rnd;
import gnu.trove.TIntObjectHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javolution.util.FastList;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AugmentationData {
    private static final Logger _log = Logger.getLogger(AugmentationData.class.getName());
    private static final int STAT_START = 1;
    private static final int STAT_END = 14560;
    private static final int STAT_BLOCKSIZE = 3640;
    private static final int STAT_SUBBLOCKSIZE = 91;
    private static final int STAT_NUM = 13;
    private static final byte[] STATS1_MAP = new byte[91];
    private static final byte[] STATS2_MAP = new byte[91];
    private static final int BLUE_START = 14561;
    private static final int SKILLS_BLOCKSIZE = 178;
    private static final int BASESTAT_STR = 16341;
    private static final int BASESTAT_CON = 16342;
    private static final int BASESTAT_INT = 16343;
    private static final int BASESTAT_MEN = 16344;
    private static final int ACC_START = 16669;
    private static final int ACC_BLOCKS_NUM = 10;
    private static final int ACC_STAT_SUBBLOCKSIZE = 21;
    private static final int ACC_STAT_NUM = 6;
    private static final int ACC_RING_START = 16669;
    private static final int ACC_RING_SKILLS = 18;
    private static final int ACC_RING_BLOCKSIZE = 102;
    private static final int ACC_RING_END = 17688;
    private static final int ACC_EAR_START = 17689;
    private static final int ACC_EAR_SKILLS = 18;
    private static final int ACC_EAR_BLOCKSIZE = 102;
    private static final int ACC_EAR_END = 18708;
    private static final int ACC_NECK_START = 18709;
    private static final int ACC_NECK_SKILLS = 24;
    private static final int ACC_NECK_BLOCKSIZE = 108;
    private static final int ACC_END = 19789;
    private static final byte[] ACC_STATS1_MAP = new byte[21];
    private static final byte[] ACC_STATS2_MAP = new byte[21];
    private ArrayList<?>[] _augStats = new ArrayList[4];
    private ArrayList<?>[] _augAccStats = new ArrayList[4];
    private ArrayList<?>[] _blueSkills = new ArrayList[10];
    private ArrayList<?>[] _purpleSkills = new ArrayList[10];
    private ArrayList<?>[] _redSkills = new ArrayList[10];
    private ArrayList<?>[] _yellowSkills = new ArrayList[10];
    private TIntObjectHashMap<augmentationSkill> _allSkills = new TIntObjectHashMap();

    public static final AugmentationData getInstance() {
        return SingletonHolder._instance;
    }

    private AugmentationData() {
        int j;
        int i;
        int idx;
        _log.info("Initializing AugmentationData.");
        this._augStats[0] = new ArrayList();
        this._augStats[1] = new ArrayList();
        this._augStats[2] = new ArrayList();
        this._augStats[3] = new ArrayList();
        this._augAccStats[0] = new ArrayList();
        this._augAccStats[1] = new ArrayList();
        this._augAccStats[2] = new ArrayList();
        this._augAccStats[3] = new ArrayList();
        for (idx = 0; idx < 13; idx = (int)((byte)(idx + 1))) {
            AugmentationData.STATS1_MAP[idx] = idx;
            AugmentationData.STATS2_MAP[idx] = idx;
        }
        for (i = 0; i < 13; ++i) {
            for (j = i + 1; j < 13; ++j) {
                AugmentationData.STATS1_MAP[idx] = (byte)i;
                AugmentationData.STATS2_MAP[idx] = (byte)j;
                idx = (byte)(idx + 1);
            }
        }
        idx = 0;
        for (i = 0; i < 4; ++i) {
            for (j = i; j < 6; ++j) {
                AugmentationData.ACC_STATS1_MAP[idx] = (byte)i;
                AugmentationData.ACC_STATS2_MAP[idx] = (byte)j;
                idx = (byte)(idx + 1);
            }
        }
        AugmentationData.ACC_STATS1_MAP[idx] = 4;
        int n = idx;
        idx = (byte)(idx + 1);
        AugmentationData.ACC_STATS2_MAP[n] = 4;
        AugmentationData.ACC_STATS1_MAP[idx] = 5;
        int n2 = idx;
        idx = (byte)(idx + 1);
        AugmentationData.ACC_STATS2_MAP[n2] = 5;
        AugmentationData.ACC_STATS1_MAP[idx] = 4;
        AugmentationData.ACC_STATS2_MAP[idx] = 5;
        for (i = 0; i < 10; ++i) {
            this._blueSkills[i] = new ArrayList();
            this._purpleSkills[i] = new ArrayList();
            this._redSkills[i] = new ArrayList();
            this._yellowSkills[i] = new ArrayList();
        }
        this.load();
        _log.info("AugmentationData: Loaded: " + this._augStats[0].size() * 4 + " augmentation stats.");
        _log.info("AugmentationData: Loaded: " + this._augAccStats[0].size() * 4 + " accessory augmentation stats.");
        for (i = 0; i < 10; ++i) {
            _log.info("AugmentationData: Loaded: " + this._blueSkills[i].size() + " blue, " + this._purpleSkills[i].size() + " purple and " + this._redSkills[i].size() + " red skills for lifeStoneLevel " + i);
        }
    }

    private final void load() {
        NamedNodeMap attrs;
        Node d;
        Node n;
        Document doc;
        File file;
        DocumentBuilderFactory factory;
        try {
            int badAugmantData = 0;
            factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setIgnoringComments(true);
            file = new File(Config.DATAPACK_ROOT + "/data/stats/augmentation/augmentation_skillmap.xml");
            if (!file.exists()) {
                if (Config.DEBUG) {
                    _log.info("The augmentation skillmap file is missing.");
                }
                return;
            }
            doc = factory.newDocumentBuilder().parse(file);
            for (n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
                if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
                for (d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                    if (!"augmentation".equalsIgnoreCase(d.getNodeName())) continue;
                    attrs = d.getAttributes();
                    int skillId = 0;
                    int augmentationId = Integer.parseInt(attrs.getNamedItem("id").getNodeValue());
                    int skillLvL = 0;
                    String type = "blue";
                    for (Node cd = d.getFirstChild(); cd != null; cd = cd.getNextSibling()) {
                        if ("skillId".equalsIgnoreCase(cd.getNodeName())) {
                            attrs = cd.getAttributes();
                            skillId = Integer.parseInt(attrs.getNamedItem("val").getNodeValue());
                            continue;
                        }
                        if ("skillLevel".equalsIgnoreCase(cd.getNodeName())) {
                            attrs = cd.getAttributes();
                            skillLvL = Integer.parseInt(attrs.getNamedItem("val").getNodeValue());
                            continue;
                        }
                        if (!"type".equalsIgnoreCase(cd.getNodeName())) continue;
                        attrs = cd.getAttributes();
                        type = attrs.getNamedItem("val").getNodeValue();
                    }
                    if (skillId == 0) {
                        if (Config.DEBUG) {
                            _log.log(Level.SEVERE, "Bad skillId in augmentation_skillmap.xml in the augmentationId:" + augmentationId);
                        }
                        ++badAugmantData;
                        continue;
                    }
                    if (skillLvL == 0) {
                        if (Config.DEBUG) {
                            _log.log(Level.SEVERE, "Bad skillLevel in augmentation_skillmap.xml in the augmentationId:" + augmentationId);
                        }
                        ++badAugmantData;
                        continue;
                    }
                    int k = (augmentationId - 14561) / 178;
                    if (type.equalsIgnoreCase("blue")) {
                        this._blueSkills[k].add(augmentationId);
                    } else if (type.equalsIgnoreCase("purple")) {
                        this._purpleSkills[k].add(augmentationId);
                    } else {
                        this._redSkills[k].add(augmentationId);
                    }
                    this._allSkills.put(augmentationId, (Object)new augmentationSkill(skillId, skillLvL));
                }
            }
            if (badAugmantData != 0) {
                _log.info("AugmentationData: " + badAugmantData + " bad skill(s) were skipped.");
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error parsing augmentation_skillmap.xml.", e);
            return;
        }
        for (int i = 1; i < 5; ++i) {
            float value;
            Iterator i$;
            int x;
            FastList array;
            StringTokenizer data;
            String tableName;
            Node cd;
            String statName;
            try {
                factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(false);
                factory.setIgnoringComments(true);
                file = new File(Config.DATAPACK_ROOT + "/data/stats/augmentation/augmentation_stats" + i + ".xml");
                if (!file.exists()) {
                    if (Config.DEBUG) {
                        _log.info("The augmentation stat data file " + i + " is missing.");
                    }
                    return;
                }
                doc = factory.newDocumentBuilder().parse(file);
                for (n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
                    if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
                    for (d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                        if (!"stat".equalsIgnoreCase(d.getNodeName())) continue;
                        attrs = d.getAttributes();
                        statName = attrs.getNamedItem("name").getNodeValue();
                        float[] soloValues = null;
                        float[] combinedValues = null;
                        for (cd = d.getFirstChild(); cd != null; cd = cd.getNextSibling()) {
                            if (!"table".equalsIgnoreCase(cd.getNodeName())) continue;
                            attrs = cd.getAttributes();
                            tableName = attrs.getNamedItem("name").getNodeValue();
                            data = new StringTokenizer(cd.getFirstChild().getNodeValue());
                            array = new FastList();
                            while (data.hasMoreTokens()) {
                                array.add((Object)Float.valueOf(Float.parseFloat(data.nextToken())));
                            }
                            if (tableName.equalsIgnoreCase("#soloValues")) {
                                soloValues = new float[array.size()];
                                x = 0;
                                i$ = array.iterator();
                                while (i$.hasNext()) {
                                    value = ((Float)i$.next()).floatValue();
                                    soloValues[x++] = value;
                                }
                                continue;
                            }
                            combinedValues = new float[array.size()];
                            x = 0;
                            i$ = array.iterator();
                            while (i$.hasNext()) {
                                value = ((Float)i$.next()).floatValue();
                                combinedValues[x++] = value;
                            }
                        }
                        this._augStats[i - 1].add(new augmentationStat(Stats.valueOfXml(statName), soloValues, combinedValues));
                    }
                }
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Error parsing augmentation_stats" + i + ".xml.", e);
                return;
            }
            try {
                factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(false);
                factory.setIgnoringComments(true);
                file = new File(Config.DATAPACK_ROOT + "/data/stats/augmentation/augmentation_jewel_stats" + i + ".xml");
                if (!file.exists()) {
                    if (Config.DEBUG) {
                        _log.info("The jewel augmentation stat data file " + i + " is missing.");
                    }
                    return;
                }
                doc = factory.newDocumentBuilder().parse(file);
                for (n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
                    if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
                    for (d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                        if (!"stat".equalsIgnoreCase(d.getNodeName())) continue;
                        attrs = d.getAttributes();
                        statName = attrs.getNamedItem("name").getNodeValue();
                        float[] soloValues = null;
                        float[] combinedValues = null;
                        for (cd = d.getFirstChild(); cd != null; cd = cd.getNextSibling()) {
                            if (!"table".equalsIgnoreCase(cd.getNodeName())) continue;
                            attrs = cd.getAttributes();
                            tableName = attrs.getNamedItem("name").getNodeValue();
                            data = new StringTokenizer(cd.getFirstChild().getNodeValue());
                            array = new FastList();
                            while (data.hasMoreTokens()) {
                                array.add((Object)Float.valueOf(Float.parseFloat(data.nextToken())));
                            }
                            if (tableName.equalsIgnoreCase("#soloValues")) {
                                soloValues = new float[array.size()];
                                x = 0;
                                i$ = array.iterator();
                                while (i$.hasNext()) {
                                    value = ((Float)i$.next()).floatValue();
                                    soloValues[x++] = value;
                                }
                                continue;
                            }
                            combinedValues = new float[array.size()];
                            x = 0;
                            i$ = array.iterator();
                            while (i$.hasNext()) {
                                value = ((Float)i$.next()).floatValue();
                                combinedValues[x++] = value;
                            }
                        }
                        this._augAccStats[i - 1].add(new augmentationStat(Stats.valueOfXml(statName), soloValues, combinedValues));
                    }
                }
                continue;
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Error parsing jewel augmentation_stats" + i + ".xml.", e);
                return;
            }
        }
    }

    public L2Augmentation generateRandomAugmentation(int lifeStoneLevel, int lifeStoneGrade, int bodyPart) {
        switch (bodyPart) {
            case 6: 
            case 8: 
            case 48: {
                return this.generateRandomAccessoryAugmentation(lifeStoneLevel, bodyPart);
            }
        }
        return this.generateRandomWeaponAugmentation(lifeStoneLevel, lifeStoneGrade);
    }

    private L2Augmentation generateRandomWeaponAugmentation(int lifeStoneLevel, int lifeStoneGrade) {
        int offset;
        int stat12 = 0;
        int stat34 = 0;
        boolean generateSkill = false;
        boolean generateGlow = false;
        lifeStoneLevel = Math.min(lifeStoneLevel, 9);
        switch (lifeStoneGrade) {
            case 0: {
                if (Rnd.get(1, 100) <= Config.AUGMENTATION_NG_SKILL_CHANCE) {
                    generateSkill = true;
                }
                if (Rnd.get(1, 100) > Config.AUGMENTATION_NG_GLOW_CHANCE) break;
                generateGlow = true;
                break;
            }
            case 1: {
                if (Rnd.get(1, 100) <= Config.AUGMENTATION_MID_SKILL_CHANCE) {
                    generateSkill = true;
                }
                if (Rnd.get(1, 100) > Config.AUGMENTATION_MID_GLOW_CHANCE) break;
                generateGlow = true;
                break;
            }
            case 2: {
                if (Rnd.get(1, 100) <= Config.AUGMENTATION_HIGH_SKILL_CHANCE) {
                    generateSkill = true;
                }
                if (Rnd.get(1, 100) > Config.AUGMENTATION_HIGH_GLOW_CHANCE) break;
                generateGlow = true;
                break;
            }
            case 3: {
                if (Rnd.get(1, 100) <= Config.AUGMENTATION_TOP_SKILL_CHANCE) {
                    generateSkill = true;
                }
                if (Rnd.get(1, 100) > Config.AUGMENTATION_TOP_GLOW_CHANCE) break;
                generateGlow = true;
                break;
            }
            case 4: {
                if (Rnd.get(1, 100) > Config.AUGMENTATION_ACC_SKILL_CHANCE) break;
                generateSkill = true;
            }
        }
        if (!generateSkill && Rnd.get(1, 100) <= Config.AUGMENTATION_BASESTAT_CHANCE) {
            stat34 = Rnd.get(16341, 16344);
        }
        int resultColor = Rnd.get(0, 100);
        resultColor = stat34 == 0 && !generateSkill ? (resultColor <= 15 * lifeStoneGrade + 40 ? 1 : 0) : (resultColor <= 10 * lifeStoneGrade + 5 || stat34 != 0 ? 3 : (resultColor <= 10 * lifeStoneGrade + 10 ? 1 : 2));
        L2Skill skill = null;
        if (generateSkill) {
            switch (resultColor) {
                case 1: {
                    stat34 = (Integer)this._blueSkills[lifeStoneLevel].get(Rnd.get(0, this._blueSkills[lifeStoneLevel].size() - 1));
                    break;
                }
                case 2: {
                    stat34 = (Integer)this._purpleSkills[lifeStoneLevel].get(Rnd.get(0, this._purpleSkills[lifeStoneLevel].size() - 1));
                    break;
                }
                case 3: {
                    stat34 = (Integer)this._redSkills[lifeStoneLevel].get(Rnd.get(0, this._redSkills[lifeStoneLevel].size() - 1));
                }
            }
            skill = ((augmentationSkill)this._allSkills.get(stat34)).getSkill();
        }
        if (stat34 == 0) {
            int temp = Rnd.get(2, 3);
            int colorOffset = resultColor * 910 + temp * 3640 + 1;
            offset = lifeStoneLevel * 91 + colorOffset;
            stat34 = Rnd.get(offset, offset + 91 - 1);
            offset = generateGlow && lifeStoneGrade >= 2 ? lifeStoneLevel * 91 + (temp - 2) * 3640 + lifeStoneGrade * 910 + 1 : lifeStoneLevel * 91 + (temp - 2) * 3640 + Rnd.get(0, 1) * 910 + 1;
        } else {
            offset = !generateGlow ? lifeStoneLevel * 91 + Rnd.get(0, 1) * 3640 + 1 : lifeStoneLevel * 91 + Rnd.get(0, 1) * 3640 + (lifeStoneGrade + resultColor) / 2 * 910 + 1;
        }
        stat12 = Rnd.get(offset, offset + 91 - 1);
        if (Config.DEBUG) {
            _log.info("Augmentation success: stat12=" + stat12 + "; stat34=" + stat34 + "; resultColor=" + resultColor + "; level=" + lifeStoneLevel + "; grade=" + lifeStoneGrade);
        }
        return new L2Augmentation((stat34 << 16) + stat12, skill);
    }

    private L2Augmentation generateRandomAccessoryAugmentation(int lifeStoneLevel, int bodyPart) {
        int stat12 = 0;
        int stat34 = 0;
        int base = 0;
        int skillsLength = 0;
        lifeStoneLevel = Math.min(lifeStoneLevel, 9);
        switch (bodyPart) {
            case 48: {
                base = 16669 + 102 * lifeStoneLevel;
                skillsLength = 18;
                break;
            }
            case 6: {
                base = 17689 + 102 * lifeStoneLevel;
                skillsLength = 18;
                break;
            }
            case 8: {
                base = 18709 + 108 * lifeStoneLevel;
                skillsLength = 24;
                break;
            }
            default: {
                return null;
            }
        }
        int resultColor = Rnd.get(0, 3);
        L2Skill skill = null;
        stat12 = Rnd.get(21);
        if (Rnd.get(1, 100) <= Config.AUGMENTATION_ACC_SKILL_CHANCE && this._allSkills.contains(stat34 = base + Rnd.get(skillsLength))) {
            skill = ((augmentationSkill)this._allSkills.get(stat34)).getSkill();
        }
        if (skill == null) {
            stat34 = (stat12 + 1 + Rnd.get(20)) % 21;
            stat34 = base + skillsLength + 21 * resultColor + stat34;
        }
        stat12 = base + skillsLength + 21 * resultColor + stat12;
        if (Config.DEBUG) {
            _log.info("Accessory augmentation success: stat12=" + stat12 + "; stat34=" + stat34 + "; level=" + lifeStoneLevel);
        }
        return new L2Augmentation((stat34 << 16) + stat12, skill);
    }

    public FastList<AugStat> getAugStatsById(int augmentationId) {
        FastList temp = new FastList();
        int[] stats = new int[]{0xFFFF & augmentationId, augmentationId >> 16};
        for (int i = 0; i < 2; ++i) {
            int level;
            augmentationStat as;
            byte stat2;
            byte stat1;
            int stat;
            int subblock;
            int base;
            if (stats[i] >= 1 && stats[i] <= 14560) {
                base = stats[i] - 1;
                int color = base / 3640;
                subblock = base % 3640;
                int level2 = subblock / 91;
                stat = subblock % 91;
                stat1 = STATS1_MAP[stat];
                stat2 = STATS2_MAP[stat];
                if (stat1 == stat2) {
                    as = (augmentationStat)this._augStats[color].get(stat1);
                    temp.add((Object)new AugStat(as.getStat(), as.getSingleStatValue(level2)));
                    continue;
                }
                as = (augmentationStat)this._augStats[color].get(stat1);
                temp.add((Object)new AugStat(as.getStat(), as.getCombinedStatValue(level2)));
                as = (augmentationStat)this._augStats[color].get(stat2);
                temp.add((Object)new AugStat(as.getStat(), as.getCombinedStatValue(level2)));
                continue;
            }
            if (stats[i] >= 16341 && stats[i] <= 16344) {
                switch (stats[i]) {
                    case 16341: {
                        temp.add((Object)new AugStat(Stats.STAT_STR, 1.0f));
                        break;
                    }
                    case 16342: {
                        temp.add((Object)new AugStat(Stats.STAT_CON, 1.0f));
                        break;
                    }
                    case 16343: {
                        temp.add((Object)new AugStat(Stats.STAT_INT, 1.0f));
                        break;
                    }
                    case 16344: {
                        temp.add((Object)new AugStat(Stats.STAT_MEN, 1.0f));
                    }
                }
                continue;
            }
            if (stats[i] < 16669 || stats[i] > 19789) continue;
            if (stats[i] <= 17688) {
                base = stats[i] - 16669;
                level = base / 102;
                subblock = base % 102 - 18;
            } else if (stats[i] <= 18708) {
                base = stats[i] - 17689;
                level = base / 102;
                subblock = base % 102 - 18;
            } else {
                base = stats[i] - 18709;
                level = base / 108;
                subblock = base % 108 - 24;
            }
            if (subblock < 0) continue;
            int color = subblock / 21;
            stat = subblock % 21;
            stat1 = ACC_STATS1_MAP[stat];
            stat2 = ACC_STATS2_MAP[stat];
            if (stat1 == stat2) {
                as = (augmentationStat)this._augAccStats[color].get(stat1);
                temp.add((Object)new AugStat(as.getStat(), as.getSingleStatValue(level)));
                continue;
            }
            as = (augmentationStat)this._augAccStats[color].get(stat1);
            temp.add((Object)new AugStat(as.getStat(), as.getCombinedStatValue(level)));
            as = (augmentationStat)this._augAccStats[color].get(stat2);
            temp.add((Object)new AugStat(as.getStat(), as.getCombinedStatValue(level)));
        }
        return temp;
    }

    public L2Skill getAugSkillById(int augmentationId) {
        augmentationSkill temp = (augmentationSkill)this._allSkills.get(augmentationId);
        if (temp == null) {
            return null;
        }
        return temp.getSkill();
    }

    private static class SingletonHolder {
        protected static final AugmentationData _instance = new AugmentationData();

        private SingletonHolder() {
        }
    }

    public class AugStat {
        private final Stats _stat;
        private final float _value;

        public AugStat(Stats stat, float value) {
            this._stat = stat;
            this._value = value;
        }

        public Stats getStat() {
            return this._stat;
        }

        public float getValue() {
            return this._value;
        }
    }

    public class augmentationStat {
        private final Stats _stat;
        private final int _singleSize;
        private final int _combinedSize;
        private final float[] _singleValues;
        private final float[] _combinedValues;

        public augmentationStat(Stats stat, float[] sValues, float[] cValues) {
            this._stat = stat;
            this._singleSize = sValues.length;
            this._singleValues = sValues;
            this._combinedSize = cValues.length;
            this._combinedValues = cValues;
        }

        public int getSingleStatSize() {
            return this._singleSize;
        }

        public int getCombinedStatSize() {
            return this._combinedSize;
        }

        public float getSingleStatValue(int i) {
            if (i >= this._singleSize || i < 0) {
                return this._singleValues[this._singleSize - 1];
            }
            return this._singleValues[i];
        }

        public float getCombinedStatValue(int i) {
            if (i >= this._combinedSize || i < 0) {
                return this._combinedValues[this._combinedSize - 1];
            }
            return this._combinedValues[i];
        }

        public Stats getStat() {
            return this._stat;
        }
    }

    public class augmentationSkill {
        private int _skillId;
        private int _skillLevel;

        public augmentationSkill(int skillId, int skillLevel) {
            this._skillId = skillId;
            this._skillLevel = skillLevel;
        }

        public L2Skill getSkill() {
            return SkillTable.getInstance().getInfo(this._skillId, this._skillLevel);
        }
    }
}

