/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.HennaTable;
import com.l2jserver.gameserver.templates.L2HelperBuff;
import com.l2jserver.gameserver.templates.StatsSet;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.logging.Logger;
import javolution.util.FastList;

public class HelperBuffTable {
    private static Logger _log = Logger.getLogger(HennaTable.class.getName());
    private List<L2HelperBuff> _helperBuff = new FastList();
    private int _magicClassLowestLevel = 100;
    private int _physicClassLowestLevel = 100;
    private int _magicClassHighestLevel = 1;
    private int _physicClassHighestLevel = 1;
    private int _servitorLowestLevel = 100;
    private int _servitorHighestLevel = 1;

    public static HelperBuffTable getInstance() {
        return SingletonHolder._instance;
    }

    private HelperBuffTable() {
        this.restoreHelperBuffData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreHelperBuffData() {
        Connection con = null;
        try {
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                PreparedStatement statement = con.prepareStatement("SELECT * FROM helper_buff_list");
                ResultSet helperbuffdata = statement.executeQuery();
                this.fillHelperBuffTable(helperbuffdata);
                helperbuffdata.close();
                statement.close();
            }
            catch (Exception e) {
                _log.severe("Table helper_buff_list not found : Update your DataPack" + e);
                e.printStackTrace();
            }
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    private void fillHelperBuffTable(ResultSet HelperBuffData) throws Exception {
        while (HelperBuffData.next()) {
            StatsSet helperBuffDat = new StatsSet();
            int id = HelperBuffData.getInt("id");
            helperBuffDat.set("id", id);
            helperBuffDat.set("skillID", HelperBuffData.getInt("skill_id"));
            helperBuffDat.set("skillLevel", HelperBuffData.getInt("skill_level"));
            helperBuffDat.set("lowerLevel", HelperBuffData.getInt("lower_level"));
            helperBuffDat.set("upperLevel", HelperBuffData.getInt("upper_level"));
            helperBuffDat.set("isMagicClass", HelperBuffData.getString("is_magic_class"));
            helperBuffDat.set("forSummon", HelperBuffData.getString("forSummon"));
            if ("false".equals(HelperBuffData.getString("is_magic_class"))) {
                if (HelperBuffData.getInt("lower_level") < this._physicClassLowestLevel) {
                    this._physicClassLowestLevel = HelperBuffData.getInt("lower_level");
                }
                if (HelperBuffData.getInt("upper_level") > this._physicClassHighestLevel) {
                    this._physicClassHighestLevel = HelperBuffData.getInt("upper_level");
                }
            } else {
                if (HelperBuffData.getInt("lower_level") < this._magicClassLowestLevel) {
                    this._magicClassLowestLevel = HelperBuffData.getInt("lower_level");
                }
                if (HelperBuffData.getInt("upper_level") > this._magicClassHighestLevel) {
                    this._magicClassHighestLevel = HelperBuffData.getInt("upper_level");
                }
            }
            if ("true".equals(HelperBuffData.getString("forSummon"))) {
                if (HelperBuffData.getInt("lower_level") < this._servitorLowestLevel) {
                    this._servitorLowestLevel = HelperBuffData.getInt("lower_level");
                }
                if (HelperBuffData.getInt("upper_level") > this._servitorHighestLevel) {
                    this._servitorHighestLevel = HelperBuffData.getInt("upper_level");
                }
            }
            L2HelperBuff template = new L2HelperBuff(helperBuffDat);
            this._helperBuff.add(template);
        }
        _log.config("Helper Buff Table: Loaded " + this._helperBuff.size() + " Templates.");
    }

    public List<L2HelperBuff> getHelperBuffTable() {
        return this._helperBuff;
    }

    public int getMagicClassHighestLevel() {
        return this._magicClassHighestLevel;
    }

    public int getMagicClassLowestLevel() {
        return this._magicClassLowestLevel;
    }

    public int getPhysicClassHighestLevel() {
        return this._physicClassHighestLevel;
    }

    public int getPhysicClassLowestLevel() {
        return this._physicClassLowestLevel;
    }

    public int getServitorLowestLevel() {
        return this._servitorLowestLevel;
    }

    public int getServitorHighestLevel() {
        return this._servitorHighestLevel;
    }

    private static class SingletonHolder {
        protected static final HelperBuffTable _instance = new HelperBuffTable();

        private SingletonHolder() {
        }
    }
}

