/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Couple;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.logging.Logger;
import javolution.util.FastList;

public class CoupleManager {
    private static final Logger _log = Logger.getLogger(CoupleManager.class.getName());
    private FastList<Couple> _couples;

    private CoupleManager() {
        _log.info("L2JMOD: Initializing CoupleManager");
        this.load();
    }

    public static final CoupleManager getInstance() {
        return SingletonHolder._instance;
    }

    public void reload() {
        this.getCouples().clear();
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void load() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("Select id from mods_wedding order by id");
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                this.getCouples().add((Object)new Couple(rs.getInt("id")));
            }
            statement.close();
            _log.info("Loaded: " + this.getCouples().size() + " couples(s)");
        }
        catch (Exception e) {
            _log.severe("Exception: CoupleManager.load(): " + e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    public final Couple getCouple(int coupleId) {
        int index = this.getCoupleIndex(coupleId);
        if (index >= 0) {
            return (Couple)this.getCouples().get(index);
        }
        return null;
    }

    public void createCouple(L2PcInstance player1, L2PcInstance player2) {
        if (player1 != null && player2 != null && player1.getPartnerId() == 0 && player2.getPartnerId() == 0) {
            int _player1id = player1.getObjectId();
            int _player2id = player2.getObjectId();
            Couple _new = new Couple(player1, player2);
            this.getCouples().add((Object)_new);
            player1.setPartnerId(_player2id);
            player2.setPartnerId(_player1id);
            player1.setCoupleId(_new.getId());
            player2.setCoupleId(_new.getId());
        }
    }

    public void deleteCouple(int coupleId) {
        int index = this.getCoupleIndex(coupleId);
        Couple couple = (Couple)this.getCouples().get(index);
        if (couple != null) {
            L2PcInstance player1 = (L2PcInstance)L2World.getInstance().findObject(couple.getPlayer1Id());
            L2PcInstance player2 = (L2PcInstance)L2World.getInstance().findObject(couple.getPlayer2Id());
            if (player1 != null) {
                player1.setPartnerId(0);
                player1.setMarried(false);
                player1.setCoupleId(0);
            }
            if (player2 != null) {
                player2.setPartnerId(0);
                player2.setMarried(false);
                player2.setCoupleId(0);
            }
            couple.divorce();
            this.getCouples().remove(index);
        }
    }

    public final int getCoupleIndex(int coupleId) {
        int i = 0;
        for (Couple temp : this.getCouples()) {
            if (temp != null && temp.getId() == coupleId) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public final FastList<Couple> getCouples() {
        if (this._couples == null) {
            this._couples = new FastList();
        }
        return this._couples;
    }

    private static class SingletonHolder {
        protected static final CoupleManager _instance = new CoupleManager();

        private SingletonHolder() {
        }
    }
}

