/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2GrandBossInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.zone.type.L2BossZone;
import com.l2jserver.gameserver.templates.StatsSet;
import com.l2jserver.util.L2FastList;
import com.l2jserver.util.Util;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntObjectHashMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import java.util.logging.Logger;
import javolution.util.FastMap;
import javolution.util.FastSet;

public class GrandBossManager {
    private static final String DELETE_GRAND_BOSS_LIST = "DELETE FROM grandboss_list";
    private static final String INSERT_GRAND_BOSS_LIST = "INSERT INTO grandboss_list (player_id,zone) VALUES (?,?)";
    private static final String UPDATE_GRAND_BOSS_DATA = "UPDATE grandboss_data set loc_x = ?, loc_y = ?, loc_z = ?, heading = ?, respawn_time = ?, currentHP = ?, currentMP = ?, status = ? where boss_id = ?";
    private static final String UPDATE_GRAND_BOSS_DATA2 = "UPDATE grandboss_data set status = ? where boss_id = ?";
    private static final String UPDATE_GRAND_BOSS_DATA3 = "UPDATE grandboss_data set respawn_time = ?, status = ? where boss_id = ?";
    protected static Logger _log = Logger.getLogger(GrandBossManager.class.getName());
    protected static Map<Integer, L2GrandBossInstance> _bosses;
    protected static TIntObjectHashMap<StatsSet> _storedInfo;
    private TIntIntHashMap _bossStatus;
    private L2FastList<L2BossZone> _zones;

    public static GrandBossManager getInstance() {
        return SingletonHolder._instance;
    }

    private GrandBossManager() {
        _log.info("Initializing GrandBossManager");
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        this._zones = new L2FastList();
        _bosses = new FastMap();
        _storedInfo = new TIntObjectHashMap();
        this._bossStatus = new TIntIntHashMap();
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT * from grandboss_data ORDER BY boss_id");
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                StatsSet info = new StatsSet();
                int bossId = rset.getInt("boss_id");
                info.set("loc_x", rset.getInt("loc_x"));
                info.set("loc_y", rset.getInt("loc_y"));
                info.set("loc_z", rset.getInt("loc_z"));
                info.set("heading", rset.getInt("heading"));
                info.set("respawn_time", rset.getLong("respawn_time"));
                double HP = rset.getDouble("currentHP");
                int true_HP = (int)HP;
                info.set("currentHP", true_HP);
                double MP = rset.getDouble("currentMP");
                int true_MP = (int)MP;
                info.set("currentMP", true_MP);
                int status = rset.getInt("status");
                this._bossStatus.put(bossId, status);
                _storedInfo.put(bossId, (Object)info);
                _log.info("GrandBossManager: " + NpcTable.getInstance().getTemplate(bossId).getName() + "(" + bossId + ") status is " + status + ".");
                if (status > 0) {
                    _log.info("GrandBossManager: Next spawn date of " + NpcTable.getInstance().getTemplate(bossId).getName() + " is " + new Date(info.getLong("respawn_time")) + ".");
                }
                info = null;
            }
            _log.info("GrandBossManager: Loaded " + _storedInfo.size() + " Instances");
            rset.close();
            statement.close();
        }
        catch (SQLException e) {
            _log.warning("GrandBossManager: Could not load grandboss_data table");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initZones() {
        Connection con = null;
        FastMap zones = new FastMap();
        if (this._zones == null) {
            _log.warning("GrandBossManager: Could not read Grand Boss zone data");
            return;
        }
        for (L2BossZone zone : this._zones) {
            if (zone == null) continue;
            zones.put((Object)zone.getId(), (Object)new FastSet());
        }
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT * from grandboss_list ORDER BY player_id");
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                int id = rset.getInt("player_id");
                int zone_id = rset.getInt("zone");
                ((FastSet)zones.get((Object)zone_id)).add((Object)id);
            }
            rset.close();
            statement.close();
            _log.info("GrandBossManager: Initialized " + this._zones.size() + " Grand Boss Zones");
        }
        catch (SQLException e) {
            _log.warning("GrandBossManager: Could not load grandboss_list table");
            e.getMessage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
        for (L2BossZone zone : this._zones) {
            if (zone == null) continue;
            zone.setAllowedPlayers((FastSet<Integer>)((FastSet)zones.get((Object)zone.getId())));
        }
        zones.clear();
    }

    public void addZone(L2BossZone zone) {
        if (this._zones != null) {
            this._zones.add(zone);
        }
    }

    public final L2BossZone getZone(L2Character character) {
        if (this._zones != null) {
            for (L2BossZone temp : this._zones) {
                if (!temp.isCharacterInZone(character)) continue;
                return temp;
            }
        }
        return null;
    }

    public final L2BossZone getZone(int x, int y, int z) {
        if (this._zones != null) {
            for (L2BossZone temp : this._zones) {
                if (!temp.isInsideZone(x, y, z)) continue;
                return temp;
            }
        }
        return null;
    }

    public final L2BossZone getZoneByBossId(int bossId) {
        if (this._zones != null) {
            for (L2BossZone temp : this._zones) {
                if (temp.getBossId() != bossId) continue;
                return temp;
            }
        }
        return null;
    }

    @Deprecated
    public boolean checkIfInZone(String zoneType, L2Object obj) {
        L2BossZone temp = this.getZone(obj.getX(), obj.getY(), obj.getZ());
        if (temp == null) {
            return false;
        }
        return temp.getZoneName().equalsIgnoreCase(zoneType);
    }

    public boolean checkIfInZone(L2PcInstance player) {
        if (player == null) {
            return false;
        }
        L2BossZone temp = this.getZone(player.getX(), player.getY(), player.getZ());
        return temp != null;
    }

    public int getBossStatus(int bossId) {
        return this._bossStatus.get(bossId);
    }

    public void setBossStatus(int bossId, int status) {
        this._bossStatus.put(bossId, status);
        _log.info(this.getClass().getSimpleName() + ": Updated " + NpcTable.getInstance().getTemplate(bossId).getName() + "(" + bossId + ") status to " + status);
        this.updateDb(bossId, true);
    }

    public void addBoss(L2GrandBossInstance boss) {
        if (boss != null) {
            _bosses.put(boss.getNpcId(), boss);
        }
    }

    public L2GrandBossInstance getBoss(int bossId) {
        return _bosses.get(bossId);
    }

    public StatsSet getStatsSet(int bossId) {
        return (StatsSet)_storedInfo.get(bossId);
    }

    public void setStatsSet(int bossId, StatsSet info) {
        _storedInfo.put(bossId, (Object)info);
        this.updateDb(bossId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeToDb() {
        Connection con = null;
        PreparedStatement statement = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            statement = con.prepareStatement(DELETE_GRAND_BOSS_LIST);
            statement.executeUpdate();
            statement.close();
            for (L2BossZone zone : this._zones) {
                if (zone == null || !zone.isStoreToDb()) continue;
                int id = zone.getId();
                FastSet<Integer> list = zone.getAllowedPlayers();
                if (list == null || list.isEmpty()) continue;
                for (Integer player : list) {
                    statement = con.prepareStatement(INSERT_GRAND_BOSS_LIST);
                    statement.setInt(1, player);
                    statement.setInt(2, id);
                    statement.executeUpdate();
                    statement.close();
                }
            }
            int[] arr$ = _storedInfo.keys();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Integer bossId = arr$[i$];
                L2GrandBossInstance boss = _bosses.get(bossId);
                StatsSet info = (StatsSet)_storedInfo.get(bossId.intValue());
                if (boss == null && info == null) {
                    statement = con.prepareStatement(UPDATE_GRAND_BOSS_DATA2);
                    statement.setInt(1, this._bossStatus.get(bossId.intValue()));
                    statement.setInt(2, bossId);
                } else if (boss == null && info != null) {
                    statement = con.prepareStatement(UPDATE_GRAND_BOSS_DATA3);
                    statement.setLong(1, info.getLong("respawn_time"));
                    statement.setInt(2, this._bossStatus.get(bossId.intValue()));
                    statement.setInt(3, bossId);
                } else {
                    statement = con.prepareStatement(UPDATE_GRAND_BOSS_DATA);
                    statement.setInt(1, boss.getX());
                    statement.setInt(2, boss.getY());
                    statement.setInt(3, boss.getZ());
                    statement.setInt(4, boss.getHeading());
                    statement.setLong(5, info.getLong("respawn_time"));
                    double hp = boss.getCurrentHp();
                    double mp = boss.getCurrentMp();
                    if (boss.isDead()) {
                        hp = boss.getMaxHp();
                        mp = boss.getMaxMp();
                    }
                    statement.setDouble(6, hp);
                    statement.setDouble(7, mp);
                    statement.setInt(8, this._bossStatus.get(bossId.intValue()));
                    statement.setInt(9, bossId);
                }
                statement.executeUpdate();
                statement.close();
            }
        }
        catch (SQLException e) {
            _log.warning("GrandBossManager: Couldn't store grandbosses to database:" + e);
            e.printStackTrace();
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDb(int bossId, boolean statusOnly) {
        Connection con = null;
        PreparedStatement statement = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            L2GrandBossInstance boss = _bosses.get(bossId);
            StatsSet info = (StatsSet)_storedInfo.get(bossId);
            if (statusOnly || boss == null && info == null) {
                statement = con.prepareStatement(UPDATE_GRAND_BOSS_DATA2);
                statement.setInt(1, this._bossStatus.get(bossId));
                statement.setInt(2, bossId);
            } else if (boss == null && info != null) {
                statement = con.prepareStatement(UPDATE_GRAND_BOSS_DATA3);
                statement.setLong(1, info.getLong("respawn_time"));
                statement.setInt(2, this._bossStatus.get(bossId));
                statement.setInt(3, bossId);
            } else {
                statement = con.prepareStatement(UPDATE_GRAND_BOSS_DATA);
                statement.setInt(1, boss.getX());
                statement.setInt(2, boss.getY());
                statement.setInt(3, boss.getZ());
                statement.setInt(4, boss.getHeading());
                statement.setLong(5, info.getLong("respawn_time"));
                double hp = boss.getCurrentHp();
                double mp = boss.getCurrentMp();
                if (boss.isDead()) {
                    hp = boss.getMaxHp();
                    mp = boss.getMaxMp();
                }
                statement.setDouble(6, hp);
                statement.setDouble(7, mp);
                statement.setInt(8, this._bossStatus.get(bossId));
                statement.setInt(9, bossId);
            }
            statement.executeUpdate();
            statement.close();
        }
        catch (SQLException e) {
            _log.warning("GrandBossManager: Couldn't store grandbosses to database:" + e);
            e.printStackTrace();
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void cleanUp() {
        this.storeToDb();
        _bosses.clear();
        _storedInfo.clear();
        this._bossStatus.clear();
        this._zones.clear();
    }

    public L2FastList<L2BossZone> getZones() {
        return this._zones;
    }

    public static String respawnTimeFormat(StatsSet info) {
        return Util.dateFormat(info.getLong("respawn_time"));
    }

    private static class SingletonHolder {
        protected static final GrandBossManager _instance = new GrandBossManager();

        private SingletonHolder() {
        }
    }
}

