/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.lib;

import com.l2jserver.L2DatabaseFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.logging.Logger;

public class SqlUtils {
    private static Logger _log = Logger.getLogger(SqlUtils.class.getName());

    private SqlUtils() {
    }

    public static SqlUtils getInstance() {
        return SingletonHolder._instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer getIntValue(String resultField, String tableName, String whereClause) {
        String query = "";
        Integer res = null;
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            query = L2DatabaseFactory.getInstance().prepQuerySelect(new String[]{resultField}, tableName, whereClause, true);
            PreparedStatement statement = con.prepareStatement(query);
            ResultSet rset = statement.executeQuery();
            if (rset.next()) {
                res = rset.getInt(1);
            }
            rset.close();
            statement.close();
        }
        catch (Exception e) {
            _log.warning("Error in query '" + query + "':" + e);
            e.printStackTrace();
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer[] getIntArray(String resultField, String tableName, String whereClause) {
        String query = "";
        Integer[] res = null;
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            query = L2DatabaseFactory.getInstance().prepQuerySelect(new String[]{resultField}, tableName, whereClause, false);
            PreparedStatement statement = con.prepareStatement(query);
            ResultSet rset = statement.executeQuery();
            int rows = 0;
            while (rset.next()) {
                ++rows;
            }
            if (rows == 0) {
                Integer[] integerArray = new Integer[]{};
                return integerArray;
            }
            res = new Integer[rows - 1];
            rset.first();
            int row = 0;
            while (rset.next()) {
                res[row] = rset.getInt(1);
            }
            rset.close();
            statement.close();
        }
        catch (Exception e) {
            _log.warning("mSGI: Error in query '" + query + "':" + e);
            e.printStackTrace();
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer[][] get2DIntArray(String[] resultFields, String usedTables, String whereClause) {
        long start = System.currentTimeMillis();
        String query = "";
        Connection con = null;
        Integer[][] res = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            query = L2DatabaseFactory.getInstance().prepQuerySelect(resultFields, usedTables, whereClause, false);
            PreparedStatement statement = con.prepareStatement(query);
            ResultSet rset = statement.executeQuery();
            int rows = 0;
            while (rset.next()) {
                ++rows;
            }
            res = new Integer[rows - 1][resultFields.length];
            rset.first();
            int row = 0;
            while (rset.next()) {
                for (int i = 0; i < resultFields.length; ++i) {
                    res[row][i] = rset.getInt(i + 1);
                }
                ++row;
            }
            rset.close();
            statement.close();
        }
        catch (Exception e) {
            _log.warning("Error in query '" + query + "':" + e);
            e.printStackTrace();
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
        _log.fine("Get all rows in query '" + query + "' in " + (System.currentTimeMillis() - start) + "ms");
        return res;
    }

    private static class SingletonHolder {
        protected static final SqlUtils _instance = new SqlUtils();

        private SingletonHolder() {
        }
    }
}

