/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.SevenSigns;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.network.serverpackets.MyTargetSelected;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.ValidateLocation;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import java.util.Collection;
import java.util.concurrent.ScheduledFuture;

public class L2CabaleBufferInstance
extends L2Npc {
    private ScheduledFuture<?> _aiTask;

    @Override
    public void onAction(L2PcInstance player, boolean interact) {
        if (!this.canTarget(player)) {
            return;
        }
        if (this != player.getTarget()) {
            player.setTarget(this);
            MyTargetSelected my = new MyTargetSelected(this.getObjectId(), 0);
            player.sendPacket(my);
            player.sendPacket(new ValidateLocation(this));
        } else if (interact && !this.canInteract(player)) {
            player.getAI().setIntention(CtrlIntention.AI_INTENTION_INTERACT, this);
        }
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    public L2CabaleBufferInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2CabaleBufferInstance);
        if (this._aiTask != null) {
            this._aiTask.cancel(true);
        }
        this._aiTask = ThreadPoolManager.getInstance().scheduleAiAtFixedRate(new CabalaAI(this), 3000L, 3000L);
    }

    @Override
    public void deleteMe() {
        if (this._aiTask != null) {
            this._aiTask.cancel(true);
            this._aiTask = null;
        }
        super.deleteMe();
    }

    @Override
    public int getDistanceToWatchObject(L2Object object) {
        return 900;
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return false;
    }

    private class CabalaAI
    implements Runnable {
        private L2CabaleBufferInstance _caster;

        protected CabalaAI(L2CabaleBufferInstance caster) {
            this._caster = caster;
        }

        @Override
        public void run() {
            boolean isBuffAWinner = false;
            boolean isBuffALoser = false;
            int winningCabal = SevenSigns.getInstance().getCabalHighestScore();
            int losingCabal = 0;
            if (winningCabal == 2) {
                losingCabal = 1;
            } else if (winningCabal == 1) {
                losingCabal = 2;
            }
            Collection<L2PcInstance> plrs = L2CabaleBufferInstance.this.getKnownList().getKnownPlayers().values();
            for (L2PcInstance player : plrs) {
                if (player == null || player.isInvul()) continue;
                int playerCabal = SevenSigns.getInstance().getPlayerCabal(player);
                if (playerCabal == winningCabal && playerCabal != 0 && this._caster.getNpcId() == 31094) {
                    if (!player.isMageClass()) {
                        if (this.handleCast(player, 4364)) {
                            isBuffAWinner = true;
                            continue;
                        }
                    } else if (this.handleCast(player, 4365)) {
                        isBuffAWinner = true;
                        continue;
                    }
                } else if (playerCabal == losingCabal && playerCabal != 0 && this._caster.getNpcId() == 31093) {
                    if (!player.isMageClass()) {
                        if (this.handleCast(player, 4361)) {
                            isBuffALoser = true;
                            continue;
                        }
                    } else if (this.handleCast(player, 4362)) {
                        isBuffALoser = true;
                        continue;
                    }
                }
                if (!isBuffAWinner || !isBuffALoser) continue;
                break;
            }
        }

        private boolean handleCast(L2PcInstance player, int skillId) {
            int skillLevel;
            int n = skillLevel = player.getLevel() > 40 ? 1 : 2;
            if (player.isDead() || !player.isVisible() || !L2CabaleBufferInstance.this.isInsideRadius(player, L2CabaleBufferInstance.this.getDistanceToWatchObject(player), false, false)) {
                return false;
            }
            L2Skill skill = SkillTable.getInstance().getInfo(skillId, skillLevel);
            if (player.getFirstEffect(skill) == null) {
                skill.getEffects(this._caster, player);
                L2CabaleBufferInstance.this.broadcastPacket(new MagicSkillUse(this._caster, player, skill.getId(), skillLevel, skill.getHitTime(), 0));
                SystemMessage sm = new SystemMessage(SystemMessageId.YOU_FEEL_S1_EFFECT);
                sm.addSkillName(skill);
                player.sendPacket(sm);
                return true;
            }
            return false;
        }
    }
}

