/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.MyTargetSelected;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.ValidateLocation;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;

public final class L2TerritoryWardInstance
extends L2Attackable {
    private Castle _castle = null;

    public L2TerritoryWardInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.disableCoreAI(true);
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        L2PcInstance actingPlayer;
        if (this.isInvul()) {
            return false;
        }
        return this._castle != null && this._castle.getZone().isActive() && (actingPlayer = attacker.getActingPlayer()) != null && actingPlayer.getSiegeSide() != 0 && !TerritoryWarManager.getInstance().isAllyField(actingPlayer, this._castle.getCastleId());
    }

    @Override
    public boolean hasRandomAnimation() {
        return false;
    }

    @Override
    public void onSpawn() {
        super.onSpawn();
        this._castle = CastleManager.getInstance().getCastle(this.getX(), this.getY(), this.getZ());
        if (this._castle == null) {
            _log.warning("L2TerritoryWardInstance(" + this.getName() + ") spawned outside Castle Zone!");
        }
    }

    @Override
    public boolean doDie(L2Character killer) {
        if (!super.doDie(killer) || this._castle == null || !TerritoryWarManager.getInstance().isTWInProgress()) {
            return false;
        }
        if (killer instanceof L2PcInstance) {
            if (((L2PcInstance)killer).getSiegeSide() > 0 && !((L2PcInstance)killer).isCombatFlagEquipped()) {
                ((L2PcInstance)killer).addItem("Pickup", this.getNpcId() - 23012, 1L, null, false);
            } else {
                TerritoryWarManager.getInstance().getTerritoryWard(this.getNpcId() - 36491).spawnMe();
            }
            SystemMessage sm = new SystemMessage(SystemMessageId.THE_S1_WARD_HAS_BEEN_DESTROYED);
            sm.addString(this.getName().replaceAll(" Ward", ""));
            sm.addPcName((L2PcInstance)killer);
            TerritoryWarManager.getInstance().announceToParticipants(sm, 0, 0);
        } else {
            TerritoryWarManager.getInstance().getTerritoryWard(this.getNpcId() - 36491).spawnMe();
        }
        this.decayMe();
        return true;
    }

    @Override
    public void onForcedAttack(L2PcInstance player) {
        this.onAction(player);
    }

    @Override
    public void onAction(L2PcInstance player, boolean interact) {
        if (player == null || !this.canTarget(player)) {
            return;
        }
        if (this != player.getTarget()) {
            player.setTarget(this);
            MyTargetSelected my = new MyTargetSelected(this.getObjectId(), player.getLevel() - this.getLevel());
            player.sendPacket(my);
            StatusUpdate su = new StatusUpdate(this.getObjectId());
            su.addAttribute(9, (int)this.getStatus().getCurrentHp());
            su.addAttribute(10, this.getMaxHp());
            player.sendPacket(su);
            player.sendPacket(new ValidateLocation(this));
        } else if (interact) {
            if (this.isAutoAttackable(player) && Math.abs(player.getZ() - this.getZ()) < 100) {
                player.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, this);
            } else {
                player.sendPacket(ActionFailed.STATIC_PACKET);
            }
        }
    }
}

