/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.itemcontainer;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.templates.item.L2Item;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;

public abstract class ItemContainer {
    protected static final Logger _log = Logger.getLogger(ItemContainer.class.getName());
    protected final List<L2ItemInstance> _items = new FastList();

    protected ItemContainer() {
    }

    protected abstract L2Character getOwner();

    protected abstract L2ItemInstance.ItemLocation getBaseLocation();

    public String getName() {
        return "ItemContainer";
    }

    public int getOwnerId() {
        return this.getOwner() == null ? 0 : this.getOwner().getObjectId();
    }

    public int getSize() {
        return this._items.size();
    }

    public L2ItemInstance[] getItems() {
        return this._items.toArray(new L2ItemInstance[this._items.size()]);
    }

    public L2ItemInstance getItemByItemId(int itemId) {
        for (L2ItemInstance item : this._items) {
            if (item == null || item.getItemId() != itemId) continue;
            return item;
        }
        return null;
    }

    public List<L2ItemInstance> getItemsByItemId(int itemId) {
        FastList returnList = new FastList();
        for (L2ItemInstance item : this._items) {
            if (item == null || item.getItemId() != itemId) continue;
            returnList.add(item);
        }
        return returnList;
    }

    public L2ItemInstance getItemByItemId(int itemId, L2ItemInstance itemToIgnore) {
        for (L2ItemInstance item : this._items) {
            if (item == null || item.getItemId() != itemId || item.equals(itemToIgnore)) continue;
            return item;
        }
        return null;
    }

    public L2ItemInstance getItemByObjectId(int objectId) {
        for (L2ItemInstance item : this._items) {
            if (item == null || item.getObjectId() != objectId) continue;
            return item;
        }
        return null;
    }

    public long getInventoryItemCount(int itemId, int enchantLevel) {
        return this.getInventoryItemCount(itemId, enchantLevel, true);
    }

    public long getInventoryItemCount(int itemId, int enchantLevel, boolean includeEquipped) {
        long count = 0L;
        for (L2ItemInstance item : this._items) {
            if (item.getItemId() != itemId || item.getEnchantLevel() != enchantLevel && enchantLevel >= 0 || !includeEquipped && item.isEquipped()) continue;
            if (item.isStackable()) {
                count = item.getCount();
                continue;
            }
            ++count;
        }
        return count;
    }

    public L2ItemInstance addItem(String process, L2ItemInstance item, L2PcInstance actor, L2Object reference) {
        L2ItemInstance olditem = this.getItemByItemId(item.getItemId());
        if (olditem != null && olditem.isStackable()) {
            long count = item.getCount();
            olditem.changeCount(process, count, actor, reference);
            olditem.setLastChange(2);
            ItemTable.getInstance().destroyItem(process, item, actor, reference);
            item.updateDatabase();
            item = olditem;
            if (item.getItemId() == 57 && (float)count < 10000.0f * Config.RATE_DROP_ITEMS_ID.get(57)) {
                if (GameTimeController.getGameTicks() % 5 == 0) {
                    item.updateDatabase();
                }
            } else {
                item.updateDatabase();
            }
        } else {
            item.setOwnerId(process, this.getOwnerId(), actor, reference);
            item.setLocation(this.getBaseLocation());
            item.setLastChange(1);
            this.addItem(item);
            item.updateDatabase();
        }
        this.refreshWeight();
        return item;
    }

    public L2ItemInstance addItem(String process, int itemId, long count, L2PcInstance actor, L2Object reference) {
        L2ItemInstance item = this.getItemByItemId(itemId);
        if (item != null && item.isStackable()) {
            item.changeCount(process, count, actor, reference);
            item.setLastChange(2);
            if (itemId == 57 && (float)count < 10000.0f * Config.RATE_DROP_ITEMS_ID.get(57)) {
                if (GameTimeController.getGameTicks() % 5 == 0) {
                    item.updateDatabase();
                }
            } else {
                item.updateDatabase();
            }
        } else {
            int i = 0;
            while ((long)i < count) {
                L2Item template = ItemTable.getInstance().getTemplate(itemId);
                if (template == null) {
                    _log.log(Level.WARNING, (actor != null ? "[" + actor.getName() + "] " : "") + "Invalid ItemId requested: ", itemId);
                    return null;
                }
                item = ItemTable.getInstance().createItem(process, itemId, template.isStackable() ? count : 1L, actor, reference);
                item.setOwnerId(this.getOwnerId());
                item.setLocation(this.getBaseLocation());
                item.setLastChange(1);
                this.addItem(item);
                item.updateDatabase();
                if (template.isStackable() || !Config.MULTIPLE_ITEM_DROP) break;
                ++i;
            }
        }
        this.refreshWeight();
        return item;
    }

    public L2ItemInstance addWearItem(String process, int itemId, L2PcInstance actor, L2Object reference) {
        L2ItemInstance item = this.getItemByItemId(itemId);
        if (item != null) {
            return item;
        }
        item = ItemTable.getInstance().createItem(process, itemId, 1L, actor, reference);
        item.setWear(true);
        item.setOwnerId(this.getOwnerId());
        item.setLocation(this.getBaseLocation());
        item.setLastChange(1);
        this.addItem(item);
        this.refreshWeight();
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public L2ItemInstance transferItem(String process, int objectId, long count, ItemContainer target, L2PcInstance actor, L2Object reference) {
        if (target == null) {
            return null;
        }
        L2ItemInstance sourceitem = this.getItemByObjectId(objectId);
        if (sourceitem == null) {
            return null;
        }
        L2ItemInstance targetitem = sourceitem.isStackable() ? target.getItemByItemId(sourceitem.getItemId()) : null;
        L2ItemInstance l2ItemInstance = sourceitem;
        synchronized (l2ItemInstance) {
            if (this.getItemByObjectId(objectId) != sourceitem) {
                return null;
            }
            if (count > sourceitem.getCount()) {
                count = sourceitem.getCount();
            }
            if (sourceitem.getCount() == count && targetitem == null) {
                this.removeItem(sourceitem);
                target.addItem(process, sourceitem, actor, reference);
                targetitem = sourceitem;
            } else {
                if (sourceitem.getCount() > count) {
                    sourceitem.changeCount(process, -count, actor, reference);
                } else {
                    this.removeItem(sourceitem);
                    ItemTable.getInstance().destroyItem(process, sourceitem, actor, reference);
                }
                if (targetitem != null) {
                    targetitem.changeCount(process, count, actor, reference);
                } else {
                    targetitem = target.addItem(process, sourceitem.getItemId(), count, actor, reference);
                }
            }
            sourceitem.updateDatabase(true);
            if (targetitem != sourceitem && targetitem != null) {
                targetitem.updateDatabase();
            }
            if (sourceitem.isAugmented()) {
                sourceitem.getAugmentation().removeBonus(actor);
            }
            this.refreshWeight();
            target.refreshWeight();
        }
        return targetitem;
    }

    public L2ItemInstance destroyItem(String process, L2ItemInstance item, L2PcInstance actor, L2Object reference) {
        return this.destroyItem(process, item, item.getCount(), actor, reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public L2ItemInstance destroyItem(String process, L2ItemInstance item, long count, L2PcInstance actor, L2Object reference) {
        L2ItemInstance l2ItemInstance = item;
        synchronized (l2ItemInstance) {
            if (item.getCount() > count) {
                item.changeCount(process, -count, actor, reference);
                item.setLastChange(2);
                if (process != null || GameTimeController.getGameTicks() % 10 == 0) {
                    item.updateDatabase();
                }
                this.refreshWeight();
                return item;
            }
            if (item.getCount() < count) {
                return null;
            }
            boolean removed = this.removeItem(item);
            if (!removed) {
                return null;
            }
            ItemTable.getInstance().destroyItem(process, item, actor, reference);
            item.updateDatabase();
            this.refreshWeight();
        }
        return item;
    }

    public L2ItemInstance destroyItem(String process, int objectId, long count, L2PcInstance actor, L2Object reference) {
        L2ItemInstance item = this.getItemByObjectId(objectId);
        if (item == null) {
            return null;
        }
        return this.destroyItem(process, item, count, actor, reference);
    }

    public L2ItemInstance destroyItemByItemId(String process, int itemId, long count, L2PcInstance actor, L2Object reference) {
        L2ItemInstance item = this.getItemByItemId(itemId);
        if (item == null) {
            return null;
        }
        return this.destroyItem(process, item, count, actor, reference);
    }

    public synchronized void destroyAllItems(String process, L2PcInstance actor, L2Object reference) {
        for (L2ItemInstance item : this._items) {
            if (item == null) continue;
            this.destroyItem(process, item, actor, reference);
        }
    }

    public long getAdena() {
        long count = 0L;
        for (L2ItemInstance item : this._items) {
            if (item == null || item.getItemId() != 57) continue;
            count = item.getCount();
            return count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addItem(L2ItemInstance item) {
        List<L2ItemInstance> list = this._items;
        synchronized (list) {
            this._items.add(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeItem(L2ItemInstance item) {
        List<L2ItemInstance> list = this._items;
        synchronized (list) {
            return this._items.remove(item);
        }
    }

    protected void refreshWeight() {
    }

    public void deleteMe() {
        try {
            this.updateDatabase();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deletedMe()", e);
        }
        FastList items = new FastList(this._items);
        this._items.clear();
        L2World.getInstance().removeObjects((List<L2Object>)items);
    }

    public void updateDatabase() {
        if (this.getOwner() != null) {
            for (L2ItemInstance item : this._items) {
                if (item == null) continue;
                item.updateDatabase(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT object_id, item_id, count, enchant_level, loc, loc_data, custom_type1, custom_type2, mana_left, time FROM items WHERE owner_id=? AND (loc=?)");
            statement.setInt(1, this.getOwnerId());
            statement.setString(2, this.getBaseLocation().name());
            ResultSet inv = statement.executeQuery();
            while (inv.next()) {
                L2PcInstance owner;
                L2ItemInstance item = L2ItemInstance.restoreFromDb(this.getOwnerId(), inv);
                if (item == null) continue;
                L2World.getInstance().storeObject(item);
                L2PcInstance l2PcInstance = owner = this.getOwner() == null ? null : this.getOwner().getActingPlayer();
                if (item.isStackable() && this.getItemByItemId(item.getItemId()) != null) {
                    this.addItem("Restore", item, owner, null);
                    continue;
                }
                this.addItem(item);
            }
            inv.close();
            statement.close();
            this.refreshWeight();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not restore container:", e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    public boolean validateCapacity(int slots) {
        return true;
    }

    public boolean validateWeight(int weight) {
        return true;
    }
}

