/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.quest;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestTimer;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ExShowQuestMark;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.PlaySound;
import com.l2jserver.gameserver.network.serverpackets.QuestList;
import com.l2jserver.gameserver.network.serverpackets.RadarControl;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.TutorialCloseHtml;
import com.l2jserver.gameserver.network.serverpackets.TutorialEnableClientEvent;
import com.l2jserver.gameserver.network.serverpackets.TutorialShowHtml;
import com.l2jserver.gameserver.network.serverpackets.TutorialShowQuestionMark;
import com.l2jserver.gameserver.skills.Stats;
import com.l2jserver.gameserver.templates.item.L2EtcItemType;
import com.l2jserver.util.Rnd;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastMap;

public final class QuestState {
    protected static final Logger _log = Logger.getLogger(Quest.class.getName());
    private final String _questName;
    private final L2PcInstance _player;
    private byte _state;
    private Map<String, String> _vars;
    private boolean _isExitQuestOnCleanUp = false;

    QuestState(Quest quest, L2PcInstance player, byte state) {
        this._questName = quest.getName();
        this._player = player;
        this.getPlayer().setQuestState(this);
        this._state = state;
    }

    public String getQuestName() {
        return this._questName;
    }

    public Quest getQuest() {
        return QuestManager.getInstance().getQuest(this._questName);
    }

    public L2PcInstance getPlayer() {
        return this._player;
    }

    public byte getState() {
        return this._state;
    }

    public boolean isCreated() {
        return this.getState() == 0;
    }

    public boolean isCompleted() {
        return this.getState() == 2;
    }

    public boolean isStarted() {
        return this.getState() == 1;
    }

    public Object setState(byte state) {
        if (this._state != state) {
            boolean newQuest = this.isCreated();
            this._state = state;
            if (newQuest) {
                Quest.createQuestInDb(this);
            } else {
                Quest.updateQuestInDb(this);
            }
            this.getPlayer().sendPacket(new QuestList());
        }
        return state;
    }

    public Object setStateAndNotSave(byte state) {
        if (this._state != state) {
            this._state = state;
            this.getPlayer().sendPacket(new QuestList());
        }
        return state;
    }

    public String setInternal(String var, String val) {
        if (this._vars == null) {
            this._vars = new FastMap();
        }
        if (val == null) {
            val = "";
        }
        this._vars.put(var, val);
        return val;
    }

    public String set(String var, String val) {
        String old;
        if (this._vars == null) {
            this._vars = new FastMap();
        }
        if (val == null) {
            val = "";
        }
        if ((old = this._vars.put(var, val)) != null) {
            Quest.updateQuestVarInDb(this, var, val);
        } else {
            Quest.createQuestVarInDb(this, var, val);
        }
        if ("cond".equals(var)) {
            try {
                int previousVal = 0;
                try {
                    previousVal = Integer.parseInt(old);
                }
                catch (Exception ex) {
                    previousVal = 0;
                }
                this.setCond(Integer.parseInt(val), previousVal);
            }
            catch (Exception e) {
                _log.finer(this.getPlayer().getName() + ", " + this.getQuestName() + " cond [" + val + "] is not an integer.  Value stored, but no packet was sent: " + e);
            }
        }
        return val;
    }

    private void setCond(int cond, int old) {
        int completedStateFlags = 0;
        if (cond == old) {
            return;
        }
        if (cond < 3 || cond > 31) {
            this.unset("__compltdStateFlags");
        } else {
            completedStateFlags = this.getInt("__compltdStateFlags");
        }
        if (completedStateFlags == 0) {
            if (cond > old + 1) {
                completedStateFlags = -2147483647;
                completedStateFlags |= (1 << old) - 1;
                this.set("__compltdStateFlags", String.valueOf(completedStateFlags |= 1 << cond - 1));
            }
        } else if (cond < old) {
            if ((completedStateFlags &= (1 << cond) - 1) == (1 << cond) - 1) {
                this.unset("__compltdStateFlags");
            } else {
                this.set("__compltdStateFlags", String.valueOf(completedStateFlags |= 0x80000001));
            }
        } else {
            this.set("__compltdStateFlags", String.valueOf(completedStateFlags |= 1 << cond - 1));
        }
        QuestList ql = new QuestList();
        this.getPlayer().sendPacket(ql);
        int questId = this.getQuest().getQuestIntId();
        if (questId > 0 && questId < 19999 && cond > 0) {
            this.getPlayer().sendPacket(new ExShowQuestMark(questId));
        }
    }

    public String unset(String var) {
        if (this._vars == null) {
            return null;
        }
        String old = this._vars.remove(var);
        if (old != null) {
            Quest.deleteQuestVarInDb(this, var);
        }
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveGlobalQuestVar(String var, String value) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("REPLACE INTO character_quest_global_data (charId,var,value) VALUES (?,?,?)");
            statement.setInt(1, this._player.getObjectId());
            statement.setString(2, var);
            statement.setString(3, value);
            statement.executeUpdate();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not insert player's global quest variable:", e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getGlobalQuestVar(String var) {
        String result = "";
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT value FROM character_quest_global_data WHERE charId = ? AND var = ?");
            statement.setInt(1, this._player.getObjectId());
            statement.setString(2, var);
            ResultSet rs = statement.executeQuery();
            if (rs.first()) {
                result = rs.getString(1);
            }
            rs.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not load player's global quest variable:", e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deleteGlobalQuestVar(String var) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("DELETE FROM character_quest_global_data WHERE charId = ? AND var = ?");
            statement.setInt(1, this._player.getObjectId());
            statement.setString(2, var);
            statement.executeUpdate();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not delete player's global quest variable:", e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Object get(String var) {
        if (this._vars == null) {
            return null;
        }
        return this._vars.get(var);
    }

    public int getInt(String var) {
        int varint = 0;
        try {
            varint = Integer.parseInt(this._vars.get(var));
        }
        catch (Exception e) {
            _log.finer(this.getPlayer().getName() + ": variable " + var + " isn't an integer: " + varint + e);
        }
        return varint;
    }

    public void addNotifyOfDeath(L2Character character) {
        if (character == null || !(character instanceof L2PcInstance)) {
            return;
        }
        ((L2PcInstance)character).addNotifyQuestOfDeath(this);
    }

    public long getQuestItemsCount(int itemId) {
        long count = 0L;
        for (L2ItemInstance item : this.getPlayer().getInventory().getItems()) {
            if (item == null || item.getItemId() != itemId) continue;
            count += item.getCount();
        }
        return count;
    }

    public int getEnchantLevel(int itemId) {
        L2ItemInstance enchanteditem = this.getPlayer().getInventory().getItemByItemId(itemId);
        if (enchanteditem == null) {
            return 0;
        }
        return enchanteditem.getEnchantLevel();
    }

    public void giveAdena(long count, boolean applyRates) {
        this.giveItems(57, count, applyRates ? 0 : 1);
    }

    public void rewardItems(int itemId, long count) {
        SystemMessage smsg;
        if (count <= 0L) {
            return;
        }
        L2ItemInstance _tmpItem = ItemTable.getInstance().createDummyItem(itemId);
        if (_tmpItem == null) {
            return;
        }
        if (itemId == 57) {
            count = (long)((float)count * Config.RATE_QUEST_REWARD_ADENA);
        } else if (Config.RATE_QUEST_REWARD_USE_MULTIPLIERS) {
            if (_tmpItem.isEtcItem()) {
                L2EtcItemType _type = _tmpItem.getEtcItem().getItemType();
                count = _type == L2EtcItemType.POTION ? (long)((float)count * Config.RATE_QUEST_REWARD_POTION) : (_type == L2EtcItemType.SCROLL ? (long)((float)count * Config.RATE_QUEST_REWARD_SCROLL) : (_type == L2EtcItemType.RECEIPE ? (long)((float)count * Config.RATE_QUEST_REWARD_RECIPE) : (_type == L2EtcItemType.MATERIAL ? (long)((float)count * Config.RATE_QUEST_REWARD_MATERIAL) : (long)((float)count * Config.RATE_QUEST_REWARD))));
            }
        } else {
            count = (long)((float)count * Config.RATE_QUEST_REWARD);
        }
        L2ItemInstance item = this.getPlayer().getInventory().addItem("Quest", itemId, count, this.getPlayer(), this.getPlayer().getTarget());
        if (item == null) {
            return;
        }
        if (itemId == 57) {
            smsg = new SystemMessage(SystemMessageId.EARNED_ADENA);
            smsg.addItemNumber(count);
            this.getPlayer().sendPacket(smsg);
        } else if (count > 1L) {
            smsg = new SystemMessage(SystemMessageId.EARNED_S2_S1_S);
            smsg.addItemName(item);
            smsg.addItemNumber(count);
            this.getPlayer().sendPacket(smsg);
        } else {
            smsg = new SystemMessage(SystemMessageId.EARNED_ITEM);
            smsg.addItemName(item);
            this.getPlayer().sendPacket(smsg);
        }
        StatusUpdate su = new StatusUpdate(this.getPlayer().getObjectId());
        su.addAttribute(14, this.getPlayer().getCurrentLoad());
        this.getPlayer().sendPacket(su);
    }

    public void giveItems(int itemId, long count) {
        this.giveItems(itemId, count, 0);
    }

    public void giveItems(int itemId, long count, int enchantlevel) {
        SystemMessage smsg;
        L2ItemInstance item;
        if (count <= 0L) {
            return;
        }
        if (itemId == 57 && enchantlevel <= 0) {
            count = (long)((float)count * Config.RATE_QUEST_REWARD_ADENA);
        }
        if ((item = this.getPlayer().getInventory().addItem("Quest", itemId, count, this.getPlayer(), this.getPlayer().getTarget())) == null) {
            return;
        }
        if (enchantlevel > 0 && itemId != 57) {
            item.setEnchantLevel(enchantlevel);
        }
        if (itemId == 57) {
            smsg = new SystemMessage(SystemMessageId.EARNED_ADENA);
            smsg.addItemNumber(count);
            this.getPlayer().sendPacket(smsg);
        } else if (count > 1L) {
            smsg = new SystemMessage(SystemMessageId.EARNED_S2_S1_S);
            smsg.addItemName(item);
            smsg.addItemNumber(count);
            this.getPlayer().sendPacket(smsg);
        } else {
            smsg = new SystemMessage(SystemMessageId.EARNED_ITEM);
            smsg.addItemName(item);
            this.getPlayer().sendPacket(smsg);
        }
        StatusUpdate su = new StatusUpdate(this.getPlayer().getObjectId());
        su.addAttribute(14, this.getPlayer().getCurrentLoad());
        this.getPlayer().sendPacket(su);
    }

    public void giveItems(int itemId, long count, byte attributeId, int attributeLevel) {
        SystemMessage smsg;
        if (count <= 0L) {
            return;
        }
        L2ItemInstance item = this.getPlayer().getInventory().addItem("Quest", itemId, count, this.getPlayer(), this.getPlayer().getTarget());
        if (item == null) {
            return;
        }
        if (attributeId >= 0 && attributeLevel > 0) {
            item.setElementAttr(attributeId, attributeLevel);
            if (item.isEquipped()) {
                item.updateElementAttrBonus(this.getPlayer());
            }
            InventoryUpdate iu = new InventoryUpdate();
            iu.addModifiedItem(item);
            this.getPlayer().sendPacket(iu);
        }
        if (itemId == 57) {
            smsg = new SystemMessage(SystemMessageId.EARNED_ADENA);
            smsg.addItemNumber(count);
            this.getPlayer().sendPacket(smsg);
        } else if (count > 1L) {
            smsg = new SystemMessage(SystemMessageId.EARNED_S2_S1_S);
            smsg.addItemName(item);
            smsg.addItemNumber(count);
            this.getPlayer().sendPacket(smsg);
        } else {
            smsg = new SystemMessage(SystemMessageId.EARNED_ITEM);
            smsg.addItemName(item);
            this.getPlayer().sendPacket(smsg);
        }
        StatusUpdate su = new StatusUpdate(this.getPlayer().getObjectId());
        su.addAttribute(14, this.getPlayer().getCurrentLoad());
        this.getPlayer().sendPacket(su);
    }

    public boolean dropQuestItems(int itemId, int count, long neededCount, int dropChance, boolean sound) {
        return this.dropQuestItems(itemId, count, count, neededCount, dropChance, sound);
    }

    public boolean dropQuestItems(int itemId, int minCount, int maxCount, long neededCount, int dropChance, boolean sound) {
        long currentCount = this.getQuestItemsCount(itemId);
        if (neededCount > 0L && currentCount >= neededCount) {
            return true;
        }
        if (currentCount >= neededCount) {
            return true;
        }
        long itemCount = 0L;
        int random = Rnd.get(1000000);
        for (dropChance = (int)((float)dropChance * (Config.RATE_QUEST_DROP / (float)(this.getPlayer().getParty() != null ? this.getPlayer().getParty().getMemberCount() : 1))); random < dropChance; dropChance -= 1000000) {
            if (minCount < maxCount) {
                itemCount += (long)Rnd.get(minCount, maxCount);
                continue;
            }
            if (minCount == maxCount) {
                itemCount += (long)minCount;
                continue;
            }
            ++itemCount;
        }
        if (itemCount > 0L) {
            if (neededCount > 0L && currentCount + itemCount > neededCount) {
                itemCount = neededCount - currentCount;
            }
            if (!this.getPlayer().getInventory().validateCapacityByItemId(itemId)) {
                return false;
            }
            this.getPlayer().addItem("Quest", itemId, itemCount, this.getPlayer().getTarget(), true);
            if (sound) {
                this.playSound(currentCount + itemCount < neededCount ? "Itemsound.quest_itemget" : "Itemsound.quest_middle");
            }
        }
        return neededCount > 0L && currentCount + itemCount >= neededCount;
    }

    public void addRadar(int x, int y, int z) {
        class Run
        implements Runnable {
            private final L2PcInstance player;
            private final int x;
            private final int y;
            private final int z;

            Run(L2PcInstance player, int x, int y, int z) {
                this.player = player;
                this.x = x;
                this.y = y;
                this.z = z;
            }

            @Override
            public void run() {
                this.player.sendPacket(new RadarControl(0, 1, this.x, this.y, this.z));
            }
        }
        ThreadPoolManager.getInstance().scheduleEffect(new Run(this.getPlayer(), x, y, z), 777L);
    }

    public void takeItems(int itemId, long count) {
        L2ItemInstance item = this.getPlayer().getInventory().getItemByItemId(itemId);
        if (item == null) {
            return;
        }
        if (count < 0L || count > item.getCount()) {
            count = item.getCount();
        }
        if (itemId == 57) {
            this.getPlayer().reduceAdena("Quest", count, this.getPlayer(), true);
        } else {
            if (item.isEquipped()) {
                L2ItemInstance[] unequiped = this.getPlayer().getInventory().unEquipItemInBodySlotAndRecord(item.getItem().getBodyPart());
                InventoryUpdate iu = new InventoryUpdate();
                for (L2ItemInstance itm : unequiped) {
                    iu.addModifiedItem(itm);
                }
                this.getPlayer().sendPacket(iu);
                this.getPlayer().broadcastUserInfo();
            }
            this.getPlayer().destroyItemByItemId("Quest", itemId, count, this.getPlayer(), true);
        }
    }

    public void playSound(String sound) {
        this.getPlayer().sendPacket(new PlaySound(sound));
    }

    public void ItemMissing(int Itemid, int count) {
        SystemMessage smsg = new SystemMessage(SystemMessageId.MISSING_S2_S1_TO_CREATE);
        smsg.addItemName(Itemid);
        smsg.addNumber(count);
        this.getPlayer().sendPacket(smsg);
    }

    public void addExpAndSp(int exp, int sp) {
        this.getPlayer().addExpAndSp((int)this.getPlayer().calcStat(Stats.EXPSP_RATE, (float)exp * Config.RATE_QUEST_REWARD_XP, null, null), (int)this.getPlayer().calcStat(Stats.EXPSP_RATE, (float)sp * Config.RATE_QUEST_REWARD_SP, null, null));
    }

    public int getRandom(int max) {
        return Rnd.get(max);
    }

    public int getItemEquipped(int loc) {
        return this.getPlayer().getInventory().getPaperdollItemId(loc);
    }

    public int getGameTicks() {
        return GameTimeController.getGameTicks();
    }

    public final boolean isExitQuestOnCleanUp() {
        return this._isExitQuestOnCleanUp;
    }

    public void setIsExitQuestOnCleanUp(boolean isExitQuestOnCleanUp) {
        this._isExitQuestOnCleanUp = isExitQuestOnCleanUp;
    }

    public void startQuestTimer(String name, long time) {
        this.getQuest().startQuestTimer(name, time, null, this.getPlayer(), false);
    }

    public void startQuestTimer(String name, long time, L2Npc npc) {
        this.getQuest().startQuestTimer(name, time, npc, this.getPlayer(), false);
    }

    public void startRepeatingQuestTimer(String name, long time) {
        this.getQuest().startQuestTimer(name, time, null, this.getPlayer(), true);
    }

    public void startRepeatingQuestTimer(String name, long time, L2Npc npc) {
        this.getQuest().startQuestTimer(name, time, npc, this.getPlayer(), true);
    }

    public final QuestTimer getQuestTimer(String name) {
        return this.getQuest().getQuestTimer(name, null, this.getPlayer());
    }

    public L2Npc addSpawn(int npcId) {
        return this.addSpawn(npcId, this.getPlayer().getX(), this.getPlayer().getY(), this.getPlayer().getZ(), 0, false, 0);
    }

    public L2Npc addSpawn(int npcId, int despawnDelay) {
        return this.addSpawn(npcId, this.getPlayer().getX(), this.getPlayer().getY(), this.getPlayer().getZ(), 0, false, despawnDelay);
    }

    public L2Npc addSpawn(int npcId, int x, int y, int z) {
        return this.addSpawn(npcId, x, y, z, 0, false, 0);
    }

    public L2Npc addSpawn(int npcId, L2Character cha) {
        return this.addSpawn(npcId, cha, true, 0);
    }

    public L2Npc addSpawn(int npcId, L2Character cha, int despawnDelay) {
        return this.addSpawn(npcId, cha.getX(), cha.getY(), cha.getZ(), cha.getHeading(), true, despawnDelay);
    }

    public L2Npc addSpawn(int npcId, int x, int y, int z, int despawnDelay) {
        return this.addSpawn(npcId, x, y, z, 0, false, despawnDelay);
    }

    public L2Npc addSpawn(int npcId, L2Character cha, boolean randomOffset, int despawnDelay) {
        return this.addSpawn(npcId, cha.getX(), cha.getY(), cha.getZ(), cha.getHeading(), randomOffset, despawnDelay);
    }

    public L2Npc addSpawn(int npcId, int x, int y, int z, int heading, boolean randomOffset, int despawnDelay) {
        return this.getQuest().addSpawn(npcId, x, y, z, heading, randomOffset, despawnDelay, false);
    }

    public L2Npc addSpawn(int npcId, int x, int y, int z, int heading, boolean randomOffset, int despawnDelay, boolean isSummonSpawn) {
        return this.getQuest().addSpawn(npcId, x, y, z, heading, randomOffset, despawnDelay, isSummonSpawn);
    }

    public String showHtmlFile(String fileName) {
        return this.getQuest().showHtmlFile(this.getPlayer(), fileName);
    }

    public QuestState exitQuest(boolean repeatable) {
        this._player.removeNotifyQuestOfDeath(this);
        if (this.isCompleted() || this.isCreated()) {
            return this;
        }
        this.setState((byte)2);
        int[] itemIdList = this.getQuest().getRegisteredItemIds();
        if (itemIdList != null) {
            for (int i = 0; i < itemIdList.length; ++i) {
                this.takeItems(itemIdList[i], -1L);
            }
        }
        if (repeatable) {
            this.getPlayer().delQuestState(this.getQuestName());
            Quest.deleteQuestInDb(this);
            this._vars = null;
        } else {
            if (this._vars != null) {
                for (String var : this._vars.keySet()) {
                    this.unset(var);
                }
            }
            Quest.updateQuestInDb(this);
        }
        return this;
    }

    public void showQuestionMark(int number) {
        this.getPlayer().sendPacket(new TutorialShowQuestionMark(number));
    }

    public void playTutorialVoice(String voice) {
        this.getPlayer().sendPacket(new PlaySound(2, voice, 0, 0, this.getPlayer().getX(), this.getPlayer().getY(), this.getPlayer().getZ()));
    }

    public void showTutorialHTML(String html) {
        String text = HtmCache.getInstance().getHtm(this.getPlayer().getHtmlPrefix(), "data/scripts/quests/255_Tutorial/" + html);
        if (text == null) {
            _log.warning("missing html page data/scripts/quests/255_Tutorial/" + html);
            text = "<html><body>File data/scripts/quests/255_Tutorial/" + html + " not found or file is empty.</body></html>";
        }
        this.getPlayer().sendPacket(new TutorialShowHtml(text));
    }

    public void closeTutorialHtml() {
        this.getPlayer().sendPacket(new TutorialCloseHtml());
    }

    public void onTutorialClientEvent(int number) {
        this.getPlayer().sendPacket(new TutorialEnableClientEvent(number));
    }

    public void dropItem(L2MonsterInstance npc, L2PcInstance player, int itemId, int count) {
        npc.dropItem(player, itemId, count);
    }
}

