/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.TaskPriority;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.instancemanager.BoatManager;
import com.l2jserver.gameserver.model.L2CharPosition;
import com.l2jserver.gameserver.model.actor.instance.L2BoatInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.templates.item.L2WeaponType;
import com.l2jserver.util.Point3D;

public final class RequestMoveToLocationInVehicle
extends L2GameClientPacket {
    private static final String _C__75_MOVETOLOCATIONINVEHICLE = "[C] 75 RequestMoveToLocationInVehicle";
    private final Point3D _pos = new Point3D(0, 0, 0);
    private final Point3D _origin_pos = new Point3D(0, 0, 0);
    private int _boatId;

    public TaskPriority getPriority() {
        return TaskPriority.PR_HIGH;
    }

    @Override
    protected void readImpl() {
        this._boatId = this.readD();
        int _x = this.readD();
        int _y = this.readD();
        int _z = this.readD();
        this._pos.setXYZ(_x, _y, _z);
        _x = this.readD();
        _y = this.readD();
        _z = this.readD();
        this._origin_pos.setXYZ(_x, _y, _z);
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (activeChar.isAttackingNow() && activeChar.getActiveWeaponItem() != null && activeChar.getActiveWeaponItem().getItemType() == L2WeaponType.BOW) {
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
        } else {
            L2BoatInstance boat = BoatManager.getInstance().getBoat(this._boatId);
            if (boat == null) {
                return;
            }
            activeChar.setBoat(boat);
            activeChar.setInBoat(true);
            activeChar.setInBoatPosition(this._pos);
            activeChar.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO_IN_A_BOAT, new L2CharPosition(this._pos.getX(), this._pos.getY(), this._pos.getZ(), 0), new L2CharPosition(this._origin_pos.getX(), this._origin_pos.getY(), this._origin_pos.getZ(), 0));
        }
    }

    @Override
    public String getType() {
        return _C__75_MOVETOLOCATIONINVEHICLE;
    }
}

