/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.templates.item;

import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.skills.SkillHolder;
import com.l2jserver.gameserver.skills.funcs.Func;
import com.l2jserver.gameserver.skills.funcs.FuncTemplate;
import com.l2jserver.gameserver.templates.StatsSet;
import com.l2jserver.gameserver.templates.item.L2ArmorType;
import com.l2jserver.gameserver.templates.item.L2Item;
import com.l2jserver.gameserver.util.StringUtil;
import java.util.ArrayList;

public final class L2Armor
extends L2Item {
    private final int _avoidModifier;
    private final int _pDef;
    private final int _mDef;
    private final int _mpBonus;
    private final int _hpBonus;
    private L2Skill _enchant4Skill = null;
    private SkillHolder[] _skillHolder;

    public L2Armor(L2ArmorType type, StatsSet set) {
        super(type, set);
        this._avoidModifier = set.getInteger("avoid_modify");
        this._pDef = set.getInteger("p_def");
        this._mDef = set.getInteger("m_def");
        this._mpBonus = set.getInteger("mp_bonus", 0);
        this._hpBonus = set.getInteger("hp_bonus", 0);
        String[] skill = set.getString("enchant4_skill").split("-");
        if (skill != null && skill.length == 2) {
            int skill_Id = Integer.parseInt(skill[0]);
            int skillLvl = Integer.parseInt(skill[1]);
            if (skill_Id > 0 && skillLvl > 0) {
                this._enchant4Skill = SkillTable.getInstance().getInfo(skill_Id, skillLvl);
            }
        }
        String[] skills = set.getString("skill").split(";");
        this._skillHolder = new SkillHolder[skills.length];
        int iterator = 0;
        for (String st : skills) {
            String[] info = st.split("-");
            if (info == null || info.length != 2) continue;
            int id = 0;
            int level = 0;
            try {
                id = Integer.parseInt(info[0]);
                level = Integer.parseInt(info[1]);
            }
            catch (Exception nfe) {
                _log.info(StringUtil.concat("> Couldnt parse ", st, " in armor skills!"));
                continue;
            }
            if (id <= 0 || level <= 0) continue;
            this._skillHolder[iterator] = new SkillHolder(id, level);
            iterator = (byte)(iterator + 1);
        }
    }

    @Override
    public L2ArmorType getItemType() {
        return (L2ArmorType)this._type;
    }

    @Override
    public final int getItemMask() {
        return this.getItemType().mask();
    }

    public final int getMDef() {
        return this._mDef;
    }

    public final int getPDef() {
        return this._pDef;
    }

    public final int getAvoidModifier() {
        return this._avoidModifier;
    }

    public final int getMpBonus() {
        return this._mpBonus;
    }

    public final int getHpBonus() {
        return this._hpBonus;
    }

    public L2Skill getEnchant4Skill() {
        return this._enchant4Skill;
    }

    public SkillHolder[] getSkills() {
        return this._skillHolder;
    }

    @Override
    public Func[] getStatFuncs(L2ItemInstance instance, L2Character player) {
        if (this._funcTemplates == null || this._funcTemplates.length == 0) {
            return _emptyFunctionSet;
        }
        ArrayList<Func> funcs = new ArrayList<Func>(this._funcTemplates.length);
        Env env = new Env();
        env.player = player;
        env.item = instance;
        for (FuncTemplate t : this._funcTemplates) {
            Func f = t.getFunc(env, instance);
            if (f == null) continue;
            funcs.add(f);
        }
        return funcs.toArray(new Func[funcs.size()]);
    }
}

