/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import org.python.compiler.ClassConstants;
import org.python.compiler.ClassFile;
import org.python.compiler.Code;
import org.python.compiler.CodeCompiler;
import org.python.compiler.Label;
import org.python.core.ClassDictInit;
import org.python.core.Py;

public class ProxyMaker
implements ClassConstants {
    public static final int tBoolean = 0;
    public static final int tByte = 1;
    public static final int tShort = 2;
    public static final int tInteger = 3;
    public static final int tLong = 4;
    public static final int tFloat = 5;
    public static final int tDouble = 6;
    public static final int tCharacter = 7;
    public static final int tVoid = 8;
    public static final int tOther = 9;
    public static final int tNone = 10;
    public static Hashtable types = ProxyMaker.fillTypes();
    Class superclass;
    Class[] interfaces;
    Hashtable names;
    Hashtable supernames = new Hashtable();
    public ClassFile classfile;
    public String myClass;
    public boolean isAdapter = false;
    static /* synthetic */ Class class$java$lang$Throwable;

    public static Hashtable fillTypes() {
        Hashtable<Class<Object>, Integer> hashtable = new Hashtable<Class<Object>, Integer>();
        hashtable.put(Boolean.TYPE, new Integer(0));
        hashtable.put(Byte.TYPE, new Integer(1));
        hashtable.put(Short.TYPE, new Integer(2));
        hashtable.put(Integer.TYPE, new Integer(3));
        hashtable.put(Long.TYPE, new Integer(4));
        hashtable.put(Float.TYPE, new Integer(5));
        hashtable.put(Double.TYPE, new Integer(6));
        hashtable.put(Character.TYPE, new Integer(7));
        hashtable.put(Void.TYPE, new Integer(8));
        return hashtable;
    }

    public static int getType(Class clazz) {
        if (clazz == null) {
            return 10;
        }
        Object v = types.get(clazz);
        if (v == null) {
            return 9;
        }
        return (Integer)v;
    }

    public ProxyMaker(String string, Class clazz) {
        this.myClass = "org.python.proxies." + string;
        if (clazz.isInterface()) {
            this.superclass = Object.class;
            this.interfaces = new Class[]{clazz};
        } else {
            this.superclass = clazz;
            this.interfaces = new Class[0];
        }
    }

    public ProxyMaker(String string, Class clazz, Class[] classArray) {
        this.myClass = string;
        if (clazz == null) {
            clazz = Object.class;
        }
        this.superclass = clazz;
        if (classArray == null) {
            classArray = new Class[]{};
        }
        this.interfaces = classArray;
    }

    public static String mapClass(Class clazz) {
        String string = clazz.getName();
        int n = string.indexOf(".");
        if (n == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n2 = 0;
        while (n != -1) {
            stringBuffer.append(string.substring(n2, n));
            stringBuffer.append("/");
            n2 = n + 1;
            n = string.indexOf(".", n2);
        }
        stringBuffer.append(string.substring(n2, string.length()));
        return stringBuffer.toString();
    }

    public static String mapType(Class clazz) {
        if (clazz.isArray()) {
            return "[" + ProxyMaker.mapType(clazz.getComponentType());
        }
        switch (ProxyMaker.getType(clazz)) {
            case 1: {
                return "B";
            }
            case 7: {
                return "C";
            }
            case 6: {
                return "D";
            }
            case 5: {
                return "F";
            }
            case 3: {
                return "I";
            }
            case 4: {
                return "J";
            }
            case 2: {
                return "S";
            }
            case 0: {
                return "Z";
            }
            case 8: {
                return "V";
            }
        }
        return "L" + ProxyMaker.mapClass(clazz) + ";";
    }

    public static String makeSignature(Class[] classArray, Class clazz) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(ProxyMaker.mapType(classArray[i]));
        }
        stringBuffer.append(")");
        stringBuffer.append(ProxyMaker.mapType(clazz));
        return stringBuffer.toString();
    }

    public void doConstants() throws Exception {
        Code code = this.classfile.addMethod("<clinit>", "()V", 8);
        code.return_();
    }

    public static void doReturn(Code code, Class clazz) throws Exception {
        switch (ProxyMaker.getType(clazz)) {
            case 10: {
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                code.ireturn();
                break;
            }
            case 4: {
                code.lreturn();
                break;
            }
            case 5: {
                code.freturn();
                break;
            }
            case 6: {
                code.dreturn();
                break;
            }
            case 8: {
                code.return_();
                break;
            }
            default: {
                code.areturn();
            }
        }
    }

    public static void doNullReturn(Code code, Class clazz) throws Exception {
        switch (ProxyMaker.getType(clazz)) {
            case 10: {
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                code.iconst(0);
                code.ireturn();
                break;
            }
            case 4: {
                code.ldc(code.pool.Long(0L));
                code.lreturn();
                break;
            }
            case 5: {
                code.ldc(code.pool.Float(0.0f));
                code.freturn();
                break;
            }
            case 6: {
                code.ldc(code.pool.Double(0.0));
                code.dreturn();
                break;
            }
            case 8: {
                code.return_();
                break;
            }
            default: {
                code.aconst_null();
                code.areturn();
            }
        }
    }

    public void callSuper(Code code, String string, String string2, Class[] classArray, Class clazz, String string3) throws Exception {
        code.aload(0);
        int n = 1;
        block6: for (int i = 0; i < classArray.length; ++i) {
            switch (ProxyMaker.getType(classArray[i])) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    code.iload(n);
                    ++n;
                    continue block6;
                }
                case 4: {
                    code.lload(n);
                    n += 2;
                    continue block6;
                }
                case 5: {
                    code.fload(n);
                    ++n;
                    continue block6;
                }
                case 6: {
                    code.dload(n);
                    n += 2;
                    continue block6;
                }
                default: {
                    code.aload(n);
                    ++n;
                }
            }
        }
        int n2 = code.pool.Methodref(string2, string, string3);
        code.invokespecial(n2);
        ProxyMaker.doReturn(code, clazz);
    }

    public void doJavaCall(Code code, String string, String string2, String string3) throws Exception {
        int n = code.pool.Methodref("org/python/core/PyObject", string3, "([Ljava/lang/Object;)Lorg/python/core/PyObject;");
        int n2 = code.pool.Methodref("org/python/core/Py", "py2" + string, "(Lorg/python/core/PyObject;)" + string2);
        code.invokevirtual(n);
        code.invokestatic(n2);
    }

    public void getArgs(Code code, Class[] classArray) throws Exception {
        if (classArray.length == 0) {
            int n = code.pool.Fieldref("org/python/core/Py", "EmptyObjects", "[Lorg/python/core/PyObject;");
            code.getstatic(n);
        } else {
            code.iconst(classArray.length);
            code.anewarray(code.pool.Class("java/lang/Object"));
            int n = code.getLocal("[org/python/core/PyObject");
            code.astore(n);
            int n2 = 1;
            for (int i = 0; i < classArray.length; ++i) {
                code.aload(n);
                code.iconst(i);
                switch (ProxyMaker.getType(classArray[i])) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        code.iload(n2);
                        ++n2;
                        int n3 = code.pool.Methodref("org/python/core/Py", "newInteger", "(I)Lorg/python/core/PyInteger;");
                        code.invokestatic(n3);
                        break;
                    }
                    case 4: {
                        code.lload(n2);
                        n2 += 2;
                        int n4 = code.pool.Methodref("org/python/core/Py", "newInteger", "(J)Lorg/python/core/PyObject;");
                        code.invokestatic(n4);
                        break;
                    }
                    case 5: {
                        code.fload(n2);
                        ++n2;
                        int n5 = code.pool.Methodref("org/python/core/Py", "newFloat", "(F)Lorg/python/core/PyFloat;");
                        code.invokestatic(n5);
                        break;
                    }
                    case 6: {
                        code.dload(n2);
                        n2 += 2;
                        int n6 = code.pool.Methodref("org/python/core/Py", "newFloat", "(D)Lorg/python/core/PyFloat;");
                        code.invokestatic(n6);
                        break;
                    }
                    case 7: {
                        code.iload(n2);
                        ++n2;
                        int n7 = code.pool.Methodref("org/python/core/Py", "newString", "(C)Lorg/python/core/PyString;");
                        code.invokestatic(n7);
                        break;
                    }
                    default: {
                        code.aload(n2);
                        ++n2;
                    }
                }
                code.aastore();
            }
            code.aload(n);
        }
    }

    public void callMethod(Code code, String string, Class[] classArray, Class clazz, Class[] classArray2) throws Exception {
        int n;
        int n2;
        Label label = null;
        Label label2 = null;
        String string2 = "_jcall";
        int n3 = 0;
        if (classArray2.length > 0) {
            label = code.getLabel();
            label2 = code.getLabel();
            string2 = "_jcallexc";
            n3 = code.getLocal("org/python/core/PyObject");
            code.astore(n3);
            label.setPosition();
            code.aload(n3);
        }
        this.getArgs(code, classArray);
        switch (ProxyMaker.getType(clazz)) {
            case 7: {
                this.doJavaCall(code, "char", "C", string2);
                break;
            }
            case 0: {
                this.doJavaCall(code, "boolean", "Z", string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                this.doJavaCall(code, "int", "I", string2);
                break;
            }
            case 4: {
                this.doJavaCall(code, "long", "J", string2);
                break;
            }
            case 5: {
                this.doJavaCall(code, "float", "F", string2);
                break;
            }
            case 6: {
                this.doJavaCall(code, "double", "D", string2);
                break;
            }
            case 8: {
                this.doJavaCall(code, "void", "V", string2);
                break;
            }
            default: {
                n2 = code.pool.Methodref("org/python/core/PyObject", string2, "([Ljava/lang/Object;)Lorg/python/core/PyObject;");
                code.invokevirtual(n2);
                int n4 = code.pool.Methodref("java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
                code.ldc(clazz.getName());
                code.invokestatic(n4);
                n = code.pool.Methodref("org/python/core/Py", "tojava", "(Lorg/python/core/PyObject;Ljava/lang/Class;)Ljava/lang/Object;");
                code.invokestatic(n);
                code.checkcast(code.pool.Class(ProxyMaker.mapClass(clazz)));
            }
        }
        if (classArray2.length > 0) {
            label2.setPosition();
        }
        ProxyMaker.doReturn(code, clazz);
        if (classArray2.length > 0) {
            int n5;
            n2 = 0;
            Label label3 = null;
            for (n = 0; n < classArray2.length; ++n) {
                label3 = code.getLabel();
                label3.setPosition();
                code.stack = 1;
                n5 = code.getLocal("java/lang/Throwable");
                code.astore(n5);
                code.aload(n5);
                code.athrow();
                code.addExceptionHandler(label, label2, label3, code.pool.Class(ProxyMaker.mapClass(classArray2[n])));
                ProxyMaker.doNullReturn(code, clazz);
                code.freeLocal(n5);
                if (classArray2[n] != (class$java$lang$Throwable == null ? ProxyMaker.class$("java.lang.Throwable") : class$java$lang$Throwable)) continue;
                n2 = 1;
            }
            if (n2 == 0) {
                label3 = code.getLabel();
                label3.setPosition();
                code.stack = 1;
                n = code.getLocal("java/lang/Throwable");
                code.astore(n);
                code.aload(n3);
                code.aload(n);
                n5 = code.pool.Methodref("org/python/core/PyObject", "_jthrow", "(Ljava/lang/Throwable;)V");
                code.invokevirtual(n5);
                code.addExceptionHandler(label, label2, label3, code.pool.Class("java/lang/Throwable"));
                code.freeLocal(n);
                ProxyMaker.doNullReturn(code, clazz);
            }
            code.freeLocal(n3);
        }
    }

    public void addMethod(Method method, int n) throws Exception {
        boolean bl = false;
        if (Modifier.isAbstract(n)) {
            n &= 0xFFFFFBFF;
            bl = true;
        }
        Class[] classArray = method.getParameterTypes();
        Class<?> clazz = method.getReturnType();
        String string = ProxyMaker.makeSignature(classArray, clazz);
        String string2 = method.getName();
        this.names.put(string2, string2);
        Code code = this.classfile.addMethod(string2, string, n);
        code.aload(0);
        code.ldc(string2);
        if (!bl) {
            int n2 = code.getLocal("org/python/core/PyObject");
            int n3 = code.pool.Methodref("org/python/core/Py", "jfindattr", "(Lorg/python/core/PyProxy;Ljava/lang/String;)Lorg/python/core/PyObject;");
            code.invokestatic(n3);
            code.astore(n2);
            code.aload(n2);
            Label label = code.getLabel();
            code.ifnonnull(label);
            String string3 = ProxyMaker.mapClass(method.getDeclaringClass());
            this.callSuper(code, string2, string3, classArray, clazz, string);
            label.setPosition();
            code.aload(n2);
            this.callMethod(code, string2, classArray, clazz, method.getExceptionTypes());
            this.addSuperMethod("super__" + string2, string2, string3, classArray, clazz, string, n);
        } else if (!this.isAdapter) {
            int n4 = code.pool.Methodref("org/python/core/Py", "jgetattr", "(Lorg/python/core/PyProxy;Ljava/lang/String;)Lorg/python/core/PyObject;");
            code.invokestatic(n4);
            this.callMethod(code, string2, classArray, clazz, method.getExceptionTypes());
        } else {
            int n5 = code.pool.Methodref("org/python/core/Py", "jfindattr", "(Lorg/python/core/PyProxy;Ljava/lang/String;)Lorg/python/core/PyObject;");
            code.invokestatic(n5);
            code.dup();
            Label label = code.getLabel();
            code.ifnull(label);
            this.callMethod(code, string2, classArray, clazz, method.getExceptionTypes());
            label.setPosition();
            code.pop();
            ProxyMaker.doNullReturn(code, clazz);
        }
    }

    private String methodString(Method method) {
        StringBuffer stringBuffer = new StringBuffer(method.getName());
        stringBuffer.append(":");
        Class<?>[] classArray = method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(classArray[i].getName());
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    protected void addMethods(Class clazz, Hashtable hashtable) throws Exception {
        Class<?>[] classArray;
        Method[] methodArray = clazz.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            classArray = methodArray[i];
            String string = this.methodString((Method)classArray);
            if (hashtable.containsKey(string)) continue;
            hashtable.put(string, string);
            int n = classArray.getModifiers();
            if (Modifier.isStatic(n) || Modifier.isPrivate(n)) continue;
            if (Modifier.isNative(n)) {
                n &= 0xFFFFFEFF;
            }
            if (Modifier.isProtected(n)) {
                if (Modifier.isFinal(n = n & 0xFFFFFFFB | 1)) {
                    this.addSuperMethod(methodArray[i], n);
                    continue;
                }
            } else if (Modifier.isFinal(n)) continue;
            this.addMethod(methodArray[i], n);
        }
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            this.addMethods(clazz2, hashtable);
        }
        classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            this.addMethods(classArray[i], hashtable);
        }
    }

    public void addConstructor(String string, Class[] classArray, Class clazz, String string2, int n) throws Exception {
        Code code = this.classfile.addMethod("<init>", string2, n);
        this.callSuper(code, "<init>", string, classArray, Void.TYPE, string2);
    }

    public void addConstructors(Class clazz) throws Exception {
        Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
        String string = ProxyMaker.mapClass(clazz);
        for (int i = 0; i < constructorArray.length; ++i) {
            int n = constructorArray[i].getModifiers();
            if (Modifier.isPrivate(n)) continue;
            if (Modifier.isNative(n)) {
                n &= 0xFFFFFEFF;
            }
            if (Modifier.isProtected(n)) {
                n = n & 0xFFFFFFFB | 1;
            }
            Class[] classArray = constructorArray[i].getParameterTypes();
            String string2 = ProxyMaker.makeSignature(classArray, Void.TYPE);
            this.addConstructor(string, classArray, Void.TYPE, string2, n);
        }
    }

    public void addSuperMethod(Method method, int n) throws Exception {
        String string;
        Class[] classArray = method.getParameterTypes();
        Class<?> clazz = method.getReturnType();
        String string2 = ProxyMaker.makeSignature(classArray, clazz);
        String string3 = ProxyMaker.mapClass(method.getDeclaringClass());
        String string4 = string = method.getName();
        if (Modifier.isFinal(n)) {
            string4 = "super__" + string;
            n &= 0xFFFFFFEF;
        }
        this.addSuperMethod(string4, string, string3, classArray, clazz, string2, n);
    }

    public void addSuperMethod(String string, String string2, String string3, Class[] classArray, Class clazz, String string4, int n) throws Exception {
        if (string.startsWith("super__")) {
            try {
                this.superclass.getMethod(string, classArray);
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
                return;
            }
        }
        this.supernames.put(string, string);
        Code code = this.classfile.addMethod(string, string4, n);
        this.callSuper(code, string2, string3, classArray, clazz, string4);
    }

    public void addProxy() throws Exception {
        this.classfile.addField("__proxy", "Lorg/python/core/PyInstance;", 4);
        Code code = this.classfile.addMethod("_setPyInstance", "(Lorg/python/core/PyInstance;)V", 1);
        int n = code.pool.Fieldref(this.classfile.name, "__proxy", "Lorg/python/core/PyInstance;");
        code.aload(0);
        code.aload(1);
        code.putfield(n);
        code.return_();
        code = this.classfile.addMethod("_getPyInstance", "()Lorg/python/core/PyInstance;", 1);
        code.aload(0);
        code.getfield(n);
        code.areturn();
        this.classfile.addField("__systemState", "Lorg/python/core/PySystemState;", 132);
        code = this.classfile.addMethod("_setPySystemState", "(Lorg/python/core/PySystemState;)V", 1);
        n = code.pool.Fieldref(this.classfile.name, "__systemState", "Lorg/python/core/PySystemState;");
        code.aload(0);
        code.aload(1);
        code.putfield(n);
        code.return_();
        code = this.classfile.addMethod("_getPySystemState", "()Lorg/python/core/PySystemState;", 1);
        code.aload(0);
        code.getfield(n);
        code.areturn();
    }

    public void addClassDictInit() throws Exception {
        int n = this.supernames.size();
        this.classfile.addInterface(ProxyMaker.mapClass(ClassDictInit.class));
        Code code = this.classfile.addMethod("classDictInit", "(Lorg/python/core/PyObject;)V", 9);
        code.aload(0);
        code.ldc("__supernames__");
        String[] stringArray = new String[n];
        Enumeration enumeration = this.supernames.keys();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n2++] = (String)enumeration.nextElement();
        }
        CodeCompiler.makeStrings(code, stringArray, n);
        n2 = code.pool.Methodref("org/python/core/Py", "java2py", "(Ljava/lang/Object;)Lorg/python/core/PyObject;");
        code.invokestatic(n2);
        int n3 = code.pool.Methodref("org/python/core/PyObject", "__setitem__", "(Ljava/lang/String;Lorg/python/core/PyObject;)V");
        code.invokevirtual(n3);
        code.return_();
    }

    public void build() throws Exception {
        this.names = new Hashtable();
        int n = this.superclass.getModifiers();
        if ((n & 0x10) != 0) {
            throw new InstantiationException("can't subclass final class");
        }
        n = 33;
        this.classfile = new ClassFile(this.myClass, ProxyMaker.mapClass(this.superclass), n);
        this.addProxy();
        this.addConstructors(this.superclass);
        this.classfile.addInterface("org/python/core/PyProxy");
        Hashtable hashtable = new Hashtable();
        this.addMethods(this.superclass, hashtable);
        for (int i = 0; i < this.interfaces.length; ++i) {
            if (this.interfaces[i].isAssignableFrom(this.superclass)) {
                Py.writeWarning("compiler", "discarding redundant interface: " + this.interfaces[i].getName());
                continue;
            }
            this.classfile.addInterface(ProxyMaker.mapClass(this.interfaces[i]));
            this.addMethods(this.interfaces[i], hashtable);
        }
        this.doConstants();
        this.addClassDictInit();
    }

    public static String makeProxy(Class clazz, OutputStream outputStream) throws Exception {
        ProxyMaker proxyMaker = new ProxyMaker(clazz.getName(), clazz);
        proxyMaker.build();
        proxyMaker.classfile.write(outputStream);
        return proxyMaker.myClass;
    }

    public static File makeFilename(String string, File file) {
        int n = string.indexOf(".");
        if (n == -1) {
            return new File(file, string + ".class");
        }
        return ProxyMaker.makeFilename(string.substring(n + 1, string.length()), new File(file, string.substring(0, n)));
    }

    public static OutputStream getFile(String string, String string2) throws IOException {
        File file = new File(string);
        File file2 = ProxyMaker.makeFilename(string2, file);
        new File(file2.getParent()).mkdirs();
        return new FileOutputStream(file2);
    }
}

