/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.HennaTable;
import com.l2jserver.gameserver.model.L2HennaInstance;
import com.l2jserver.gameserver.model.base.ClassId;
import com.l2jserver.gameserver.templates.item.L2Henna;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public class HennaTreeTable {
    private static Logger _log = Logger.getLogger(HennaTreeTable.class.getName());
    private Map<ClassId, List<L2HennaInstance>> _hennaTrees = new FastMap();
    private boolean _initialized = true;

    public static HennaTreeTable getInstance() {
        return SingletonHolder._instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HennaTreeTable() {
        int classId = 0;
        int count = 0;
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT class_name, id, parent_id FROM class_list ORDER BY id");
            ResultSet classlist = statement.executeQuery();
            while (classlist.next()) {
                FastList list = new FastList();
                classId = classlist.getInt("id");
                PreparedStatement statement2 = con.prepareStatement("SELECT class_id, symbol_id FROM henna_trees where class_id=? ORDER BY symbol_id");
                statement2.setInt(1, classId);
                ResultSet hennatree = statement2.executeQuery();
                while (hennatree.next()) {
                    int id = hennatree.getInt("symbol_id");
                    L2Henna template = HennaTable.getInstance().getTemplate(id);
                    if (template == null) {
                        hennatree.close();
                        statement2.close();
                        classlist.close();
                        statement.close();
                        return;
                    }
                    L2HennaInstance temp = new L2HennaInstance(template);
                    temp.setSymbolId(id);
                    temp.setItemIdDye(template.getDyeId());
                    temp.setAmountDyeRequire(template.getAmountDyeRequire());
                    temp.setPrice(template.getPrice());
                    temp.setStatINT(template.getStatINT());
                    temp.setStatSTR(template.getStatSTR());
                    temp.setStatCON(template.getStatCON());
                    temp.setStatMEM(template.getStatMEM());
                    temp.setStatDEX(template.getStatDEX());
                    temp.setStatWIT(template.getStatWIT());
                    list.add(temp);
                }
                this._hennaTrees.put(ClassId.values()[classId], (List<L2HennaInstance>)list);
                hennatree.close();
                statement2.close();
                count += list.size();
                _log.fine("Henna Tree for Class: " + classId + " has " + list.size() + " Henna Templates.");
            }
            classlist.close();
            statement.close();
            _log.config("HennaTreeTable: Loaded " + count + " Henna Tree Templates.");
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error loading Henna Tree Table.", e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
    }

    public L2HennaInstance[] getAvailableHenna(ClassId classId) {
        FastList result = new FastList();
        List<L2HennaInstance> henna = this._hennaTrees.get((Object)classId);
        if (henna == null) {
            _log.warning("Hennatree for class " + (Object)((Object)classId) + " is not defined !");
            return new L2HennaInstance[0];
        }
        for (L2HennaInstance temp : henna) {
            result.add(temp);
        }
        return result.toArray(new L2HennaInstance[result.size()]);
    }

    public boolean isInitialized() {
        return this._initialized;
    }

    private static class SingletonHolder {
        protected static final HennaTreeTable _instance = new HennaTreeTable();

        private SingletonHolder() {
        }
    }
}

