/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.datatables.SpawnTable;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.DimensionalRift;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.Rnd;
import gnu.trove.TByteObjectHashMap;
import java.awt.Polygon;
import java.awt.Shape;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javolution.util.FastList;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DimensionalRiftManager {
    private static Logger _log = Logger.getLogger(DimensionalRiftManager.class.getName());
    private TByteObjectHashMap<TByteObjectHashMap<DimensionalRiftRoom>> _rooms = new TByteObjectHashMap(7);
    private final int DIMENSIONAL_FRAGMENT_ITEM_ID = 7079;

    public static DimensionalRiftManager getInstance() {
        return SingletonHolder._instance;
    }

    private DimensionalRiftManager() {
        this.loadRooms();
        this.loadSpawns();
        new Quest(635, "RiftQuest", "Dummy Quest shown in players' questlist when inside the rift");
    }

    public DimensionalRiftRoom getRoom(byte type, byte room) {
        return this._rooms.get(type) == null ? null : (DimensionalRiftRoom)((TByteObjectHashMap)this._rooms.get(type)).get(room);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRooms() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement s = con.prepareStatement("SELECT * FROM dimensional_rift");
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                boolean isBossRoom;
                byte type = rs.getByte("type");
                byte room_id = rs.getByte("room_id");
                int xMin = rs.getInt("xMin");
                int xMax = rs.getInt("xMax");
                int yMin = rs.getInt("yMin");
                int yMax = rs.getInt("yMax");
                int z1 = rs.getInt("zMin");
                int z2 = rs.getInt("zMax");
                int xT = rs.getInt("xT");
                int yT = rs.getInt("yT");
                int zT = rs.getInt("zT");
                boolean bl = isBossRoom = rs.getByte("boss") > 0;
                if (!this._rooms.containsKey(type)) {
                    this._rooms.put(type, (Object)new TByteObjectHashMap(9));
                }
                ((TByteObjectHashMap)this._rooms.get(type)).put(room_id, (Object)new DimensionalRiftRoom(type, room_id, xMin, xMax, yMin, yMax, z1, z2, xT, yT, zT, isBossRoom));
            }
            s.close();
            con.close();
        }
        catch (Exception e) {
            _log.warning("Can't load Dimension Rift zones. " + e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
        int typeSize = this._rooms.keys().length;
        int roomSize = 0;
        for (byte b : this._rooms.keys()) {
            roomSize += ((TByteObjectHashMap)this._rooms.get(b)).keys().length;
        }
        _log.info("DimensionalRiftManager: Loaded " + typeSize + " room types with " + roomSize + " rooms.");
    }

    public void loadSpawns() {
        int countGood = 0;
        int countBad = 0;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setIgnoringComments(true);
            File file = new File(Config.DATAPACK_ROOT + "/data/dimensionalRift.xml");
            if (!file.exists()) {
                throw new IOException();
            }
            Document doc = factory.newDocumentBuilder().parse(file);
            for (Node rift = doc.getFirstChild(); rift != null; rift = rift.getNextSibling()) {
                if (!"rift".equalsIgnoreCase(rift.getNodeName())) continue;
                for (Node area = rift.getFirstChild(); area != null; area = area.getNextSibling()) {
                    if (!"area".equalsIgnoreCase(area.getNodeName())) continue;
                    NamedNodeMap attrs = area.getAttributes();
                    byte type = Byte.parseByte(attrs.getNamedItem("type").getNodeValue());
                    for (Node room = area.getFirstChild(); room != null; room = room.getNextSibling()) {
                        if (!"room".equalsIgnoreCase(room.getNodeName())) continue;
                        attrs = room.getAttributes();
                        byte roomId = Byte.parseByte(attrs.getNamedItem("id").getNodeValue());
                        for (Node spawn = room.getFirstChild(); spawn != null; spawn = spawn.getNextSibling()) {
                            if (!"spawn".equalsIgnoreCase(spawn.getNodeName())) continue;
                            attrs = spawn.getAttributes();
                            int mobId = Integer.parseInt(attrs.getNamedItem("mobId").getNodeValue());
                            int delay = Integer.parseInt(attrs.getNamedItem("delay").getNodeValue());
                            int count = Integer.parseInt(attrs.getNamedItem("count").getNodeValue());
                            L2NpcTemplate template = NpcTable.getInstance().getTemplate(mobId);
                            if (template == null) {
                                _log.warning("Template " + mobId + " not found!");
                            }
                            if (!this._rooms.containsKey(type)) {
                                _log.warning("Type " + type + " not found!");
                            } else if (!((TByteObjectHashMap)this._rooms.get(type)).containsKey(roomId)) {
                                _log.warning("Room " + roomId + " in Type " + type + " not found!");
                            }
                            for (int i = 0; i < count; ++i) {
                                DimensionalRiftRoom riftRoom = (DimensionalRiftRoom)((TByteObjectHashMap)this._rooms.get(type)).get(roomId);
                                int x = riftRoom.getRandomX();
                                int y = riftRoom.getRandomY();
                                int z = riftRoom.getTeleportCoords()[2];
                                if (template != null && this._rooms.containsKey(type) && ((TByteObjectHashMap)this._rooms.get(type)).containsKey(roomId)) {
                                    L2Spawn spawnDat = new L2Spawn(template);
                                    spawnDat.setAmount(1);
                                    spawnDat.setLocx(x);
                                    spawnDat.setLocy(y);
                                    spawnDat.setLocz(z);
                                    spawnDat.setHeading(-1);
                                    spawnDat.setRespawnDelay(delay);
                                    SpawnTable.getInstance().addNewSpawn(spawnDat, false);
                                    ((DimensionalRiftRoom)((TByteObjectHashMap)this._rooms.get(type)).get(roomId)).getSpawns().add((Object)spawnDat);
                                    ++countGood;
                                    continue;
                                }
                                ++countBad;
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            _log.warning("Error on loading dimensional rift spawns: " + e);
            e.printStackTrace();
        }
        _log.info("DimensionalRiftManager: Loaded " + countGood + " dimensional rift spawns" + (countBad > 0 ? ", " + countBad + " errors." : "."));
    }

    public void reload() {
        for (byte b : this._rooms.keys()) {
            for (byte i : ((TByteObjectHashMap)this._rooms.get(b)).keys()) {
                ((DimensionalRiftRoom)((TByteObjectHashMap)this._rooms.get(b)).get(i)).getSpawns().clear();
            }
            ((TByteObjectHashMap)this._rooms.get(b)).clear();
        }
        this._rooms.clear();
        this.loadRooms();
        this.loadSpawns();
    }

    public boolean checkIfInRiftZone(int x, int y, int z, boolean ignorePeaceZone) {
        if (ignorePeaceZone) {
            return ((DimensionalRiftRoom)((TByteObjectHashMap)this._rooms.get((byte)0)).get((byte)1)).checkIfInZone(x, y, z);
        }
        return ((DimensionalRiftRoom)((TByteObjectHashMap)this._rooms.get((byte)0)).get((byte)1)).checkIfInZone(x, y, z) && !((DimensionalRiftRoom)((TByteObjectHashMap)this._rooms.get((byte)0)).get((byte)0)).checkIfInZone(x, y, z);
    }

    public boolean checkIfInPeaceZone(int x, int y, int z) {
        return ((DimensionalRiftRoom)((TByteObjectHashMap)this._rooms.get((byte)0)).get((byte)0)).checkIfInZone(x, y, z);
    }

    public void teleportToWaitingRoom(L2PcInstance player) {
        int[] coords = this.getRoom((byte)0, (byte)0).getTeleportCoords();
        player.teleToLocation(coords[0], coords[1], coords[2]);
    }

    public synchronized void start(L2PcInstance player, byte type, L2Npc npc) {
        byte room;
        L2ItemInstance i;
        boolean canPass = true;
        if (!player.isInParty()) {
            this.showHtmlFile(player, "data/html/seven_signs/rift/NoParty.htm", npc);
            return;
        }
        if (player.getParty().getPartyLeaderOID() != player.getObjectId()) {
            this.showHtmlFile(player, "data/html/seven_signs/rift/NotPartyLeader.htm", npc);
            return;
        }
        if (player.getParty().isInDimensionalRift()) {
            this.handleCheat(player, npc);
            return;
        }
        if (player.getParty().getMemberCount() < Config.RIFT_MIN_PARTY_SIZE) {
            NpcHtmlMessage html = new NpcHtmlMessage(npc.getObjectId());
            html.setFile(player.getHtmlPrefix(), "data/html/seven_signs/rift/SmallParty.htm");
            html.replace((CharSequence)"%npc_name%", npc.getName());
            html.replace((CharSequence)"%count%", Config.RIFT_MIN_PARTY_SIZE);
            player.sendPacket(html);
            return;
        }
        if (!this.isAllowedEnter(type)) {
            player.sendMessage("Rift is full. Try later.");
            return;
        }
        for (L2PcInstance p : player.getParty().getPartyMembers()) {
            if (this.checkIfInPeaceZone(p.getX(), p.getY(), p.getZ())) continue;
            canPass = false;
            break;
        }
        if (!canPass) {
            this.showHtmlFile(player, "data/html/seven_signs/rift/NotInWaitingRoom.htm", npc);
            return;
        }
        int count = this.getNeededItems(type);
        for (L2PcInstance p : player.getParty().getPartyMembers()) {
            i = p.getInventory().getItemByItemId(7079);
            if (i == null) {
                canPass = false;
                break;
            }
            if (i.getCount() > 0L) {
                if (i.getCount() >= (long)this.getNeededItems(type)) continue;
                canPass = false;
                break;
            }
            canPass = false;
            break;
        }
        if (!canPass) {
            NpcHtmlMessage html = new NpcHtmlMessage(npc.getObjectId());
            html.setFile(player.getHtmlPrefix(), "data/html/seven_signs/rift/NoFragments.htm");
            html.replace((CharSequence)"%npc_name%", npc.getName());
            html.replace((CharSequence)"%count%", count);
            player.sendPacket(html);
            return;
        }
        for (L2PcInstance p : player.getParty().getPartyMembers()) {
            if (p.destroyItem("RiftEntrance", i = p.getInventory().getItemByItemId(7079), (long)count, null, false)) continue;
            NpcHtmlMessage html = new NpcHtmlMessage(npc.getObjectId());
            html.setFile(player.getHtmlPrefix(), "data/html/seven_signs/rift/NoFragments.htm");
            html.replace((CharSequence)"%npc_name%", npc.getName());
            html.replace((CharSequence)"%count%", count);
            player.sendPacket(html);
            return;
        }
        do {
            FastList<Byte> emptyRooms = this.getFreeRooms(type);
            room = (Byte)emptyRooms.get(Rnd.get(1, emptyRooms.size()) - 1);
        } while (((DimensionalRiftRoom)((TByteObjectHashMap)this._rooms.get(type)).get(room)).ispartyInside());
        new DimensionalRift(player.getParty(), type, room);
    }

    public void killRift(DimensionalRift d) {
        if (d.getTeleportTimerTask() != null) {
            d.getTeleportTimerTask().cancel();
        }
        d.setTeleportTimerTask(null);
        if (d.getTeleportTimer() != null) {
            d.getTeleportTimer().cancel();
        }
        d.setTeleportTimer(null);
        if (d.getSpawnTimerTask() != null) {
            d.getSpawnTimerTask().cancel();
        }
        d.setSpawnTimerTask(null);
        if (d.getSpawnTimer() != null) {
            d.getSpawnTimer().cancel();
        }
        d.setSpawnTimer(null);
    }

    private int getNeededItems(byte type) {
        switch (type) {
            case 1: {
                return Config.RIFT_ENTER_COST_RECRUIT;
            }
            case 2: {
                return Config.RIFT_ENTER_COST_SOLDIER;
            }
            case 3: {
                return Config.RIFT_ENTER_COST_OFFICER;
            }
            case 4: {
                return Config.RIFT_ENTER_COST_CAPTAIN;
            }
            case 5: {
                return Config.RIFT_ENTER_COST_COMMANDER;
            }
            case 6: {
                return Config.RIFT_ENTER_COST_HERO;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public void showHtmlFile(L2PcInstance player, String file, L2Npc npc) {
        NpcHtmlMessage html = new NpcHtmlMessage(npc.getObjectId());
        html.setFile(player.getHtmlPrefix(), file);
        html.replace((CharSequence)"%npc_name%", npc.getName());
        player.sendPacket(html);
    }

    public void handleCheat(L2PcInstance player, L2Npc npc) {
        this.showHtmlFile(player, "data/html/seven_signs/rift/Cheater.htm", npc);
        if (!player.isGM()) {
            _log.warning("Player " + player.getName() + "(" + player.getObjectId() + ") was cheating in dimension rift area!");
            Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " tried to cheat in dimensional rift.", Config.DEFAULT_PUNISH);
        }
    }

    public boolean isAllowedEnter(byte type) {
        int count = 0;
        for (Object room : ((TByteObjectHashMap)this._rooms.get(type)).getValues()) {
            if (!((DimensionalRiftRoom)room).ispartyInside()) continue;
            ++count;
        }
        return count < ((TByteObjectHashMap)this._rooms.get(type)).size() - 1;
    }

    public FastList<Byte> getFreeRooms(byte type) {
        FastList list = new FastList();
        for (Object room : ((TByteObjectHashMap)this._rooms.get(type)).getValues()) {
            if (((DimensionalRiftRoom)room).ispartyInside()) continue;
            list.add((Object)((DimensionalRiftRoom)room)._room);
        }
        return list;
    }

    private static class SingletonHolder {
        protected static final DimensionalRiftManager _instance = new DimensionalRiftManager();

        private SingletonHolder() {
        }
    }

    public class DimensionalRiftRoom {
        protected final byte _type;
        protected final byte _room;
        private final int _xMin;
        private final int _xMax;
        private final int _yMin;
        private final int _yMax;
        private final int _zMin;
        private final int _zMax;
        private final int[] _teleportCoords;
        private final Shape _s;
        private final boolean _isBossRoom;
        private final FastList<L2Spawn> _roomSpawns;
        protected final FastList<L2Npc> _roomMobs;
        private boolean _partyInside = false;

        public DimensionalRiftRoom(byte type, byte room, int xMin, int xMax, int yMin, int yMax, int zMin, int zMax, int xT, int yT, int zT, boolean isBossRoom) {
            this._type = type;
            this._room = room;
            this._xMin = xMin + 128;
            this._xMax = xMax - 128;
            this._yMin = yMin + 128;
            this._yMax = yMax - 128;
            this._zMin = zMin;
            this._zMax = zMax;
            this._teleportCoords = new int[]{xT, yT, zT};
            this._isBossRoom = isBossRoom;
            this._roomSpawns = new FastList();
            this._roomMobs = new FastList();
            this._s = new Polygon(new int[]{xMin, xMax, xMax, xMin}, new int[]{yMin, yMin, yMax, yMax}, 4);
        }

        public int getRandomX() {
            return Rnd.get(this._xMin, this._xMax);
        }

        public int getRandomY() {
            return Rnd.get(this._yMin, this._yMax);
        }

        public int[] getTeleportCoords() {
            return this._teleportCoords;
        }

        public boolean checkIfInZone(int x, int y, int z) {
            return this._s.contains(x, y) && z >= this._zMin && z <= this._zMax;
        }

        public boolean isBossRoom() {
            return this._isBossRoom;
        }

        public FastList<L2Spawn> getSpawns() {
            return this._roomSpawns;
        }

        public void spawn() {
            for (L2Spawn spawn : this._roomSpawns) {
                spawn.doSpawn();
                spawn.startRespawn();
            }
        }

        public DimensionalRiftRoom unspawn() {
            for (L2Spawn spawn : this._roomSpawns) {
                spawn.stopRespawn();
                if (spawn.getLastSpawn() != null) {
                    spawn.getLastSpawn().deleteMe();
                }
                spawn.decreaseCount(null);
            }
            return this;
        }

        public boolean ispartyInside() {
            return this._partyInside;
        }

        public void setPartyInside(boolean partyInside) {
            this._partyInside = partyInside;
        }
    }
}

