/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.L2CharacterAI;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.knownlist.BoatKnownList;
import com.l2jserver.gameserver.network.serverpackets.CreatureSay;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.PlaySound;
import com.l2jserver.gameserver.network.serverpackets.VehicleCheckLocation;
import com.l2jserver.gameserver.network.serverpackets.VehicleDeparture;
import com.l2jserver.gameserver.network.serverpackets.VehicleInfo;
import com.l2jserver.gameserver.network.serverpackets.VehicleStarted;
import com.l2jserver.gameserver.templates.chars.L2CharTemplate;
import com.l2jserver.gameserver.templates.item.L2Weapon;
import com.l2jserver.gameserver.util.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.util.Collection;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javolution.util.FastMap;

public class L2BoatInstance
extends L2Character {
    protected static final Logger _logBoat = Logger.getLogger(L2BoatInstance.class.getName());
    public float boatSpeed;
    private String _name;
    protected L2BoatTrajet _t1;
    protected L2BoatTrajet _t2;
    protected int _cycle = 0;
    protected VehicleDeparture _vd = null;
    private Map<Integer, L2PcInstance> _inboat;
    public int _runstate = 0;
    private int lastx = -1;
    private int lasty = -1;
    protected boolean needOnVehicleCheckLocation = false;
    private int _id;

    public L2BoatInstance(int objectId, L2CharTemplate template, String name) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2BoatInstance);
        this.setAI(new L2CharacterAI(new AIAccessor()));
        this._name = name;
    }

    @Override
    public void initKnownList() {
        this.setKnownList(new BoatKnownList(this));
    }

    public void moveToLocation(int x, int y, int z, float speed) {
        int curX = this.getX();
        int curY = this.getY();
        int dx = x - curX;
        int dy = y - curY;
        double distance = Math.sqrt(dx * dx + dy * dy);
        if (Config.DEBUG) {
            _logBoat.fine("distance to target:" + distance);
        }
        double sin = (double)dy / distance;
        double cos = (double)dx / distance;
        L2Character.MoveData m = new L2Character.MoveData();
        int ticksToMove = (int)(10.0 * distance / (double)speed);
        int heading = (int)(Math.atan2(-sin, -cos) * 10430.378350470453);
        this.getPosition().setHeading(heading += 32768);
        if (Config.DEBUG) {
            _logBoat.fine("dist:" + distance + "speed:" + speed + " ttt:" + ticksToMove + " heading:" + heading);
        }
        m._xDestination = x;
        m._yDestination = y;
        m._zDestination = z;
        m._heading = 0;
        m.onGeodataPathIndex = -1;
        m._moveStartTime = GameTimeController.getGameTicks();
        if (Config.DEBUG) {
            _logBoat.fine("time to target:" + ticksToMove);
        }
        this._move = m;
        GameTimeController.getInstance().registerMovingObject(this);
    }

    public void evtArrived() {
        if (this._runstate != 0) {
            Boatrun bc = new Boatrun(this._runstate, this);
            ThreadPoolManager.getInstance().scheduleGeneral(bc, 10L);
            this._runstate = 0;
        }
    }

    public int getId() {
        return this._id;
    }

    public void sendVehicleDeparture(L2PcInstance activeChar) {
        if (this._vd != null) {
            activeChar.sendPacket(this._vd);
        }
    }

    public VehicleDeparture getVehicleDeparture() {
        return this._vd;
    }

    public void beginCycle() {
        this.say(10);
        BoatCaptain bc = new BoatCaptain(1, this);
        if (this.getId() == 5) {
            ThreadPoolManager.getInstance().scheduleGeneral(bc, 180000L);
        } else {
            ThreadPoolManager.getInstance().scheduleGeneral(bc, 300000L);
        }
    }

    public void updatePeopleInTheBoat(int x, int y, int z) {
        if (this._inboat != null) {
            boolean check = false;
            if (this.lastx == -1 || this.lasty == -1) {
                check = true;
                this.lastx = x;
                this.lasty = y;
            } else if ((x - this.lastx) * (x - this.lastx) + (y - this.lasty) * (y - this.lasty) > 2250000) {
                check = true;
                this.lastx = x;
                this.lasty = y;
            }
            for (int i = 0; i < this._inboat.size(); ++i) {
                L2PcInstance player = this._inboat.get(i);
                if (player != null && player.isInBoat() && player.getBoat() == this) {
                    player.getPosition().setXYZ(x, y, z);
                    player.revalidateZone(false);
                }
                if (!check || !this.needOnVehicleCheckLocation) continue;
                VehicleCheckLocation vcl = new VehicleCheckLocation(this, x, y, z);
                player.sendPacket(vcl);
            }
        }
    }

    public void begin() {
        if (this._cycle == 1) {
            Collection<L2PcInstance> knownPlayers = this.getKnownList().getKnownPlayers().values();
            if (knownPlayers != null && !knownPlayers.isEmpty()) {
                this._inboat = new FastMap();
                int i = 0;
                for (L2PcInstance player : knownPlayers) {
                    if (!player.isInBoat() || player.getBoat() != this) continue;
                    L2ItemInstance it = player.getInventory().getItemByItemId(this._t1.idWTicket1);
                    if (it != null && it.getCount() >= 1L) {
                        player.getInventory().destroyItem("Boat", it.getObjectId(), 1L, player, (L2Object)this);
                        InventoryUpdate iu = new InventoryUpdate();
                        iu.addModifiedItem(it);
                        player.sendPacket(iu);
                        player.sendPacket(new VehicleStarted(this, 1));
                        this._inboat.put(i, player);
                        ++i;
                        continue;
                    }
                    if (it == null && this._t1.idWTicket1 == 0) {
                        this._inboat.put(i, player);
                        player.sendPacket(new VehicleStarted(this, 1));
                        ++i;
                        continue;
                    }
                    player.teleToLocation(this._t1.ntx1, this._t1.nty1, this._t1.ntz1, false);
                }
            }
            Boatrun bc = new Boatrun(0, this);
            ThreadPoolManager.getInstance().scheduleGeneral(bc, 0L);
        } else if (this._cycle == 2) {
            Collection<L2PcInstance> knownPlayers = this.getKnownList().getKnownPlayers().values();
            if (knownPlayers != null && !knownPlayers.isEmpty()) {
                this._inboat = new FastMap();
                int i = 0;
                for (L2PcInstance player : knownPlayers) {
                    if (!player.isInBoat() || player.getBoat() != this) continue;
                    L2ItemInstance it = player.getInventory().getItemByItemId(this._t2.idWTicket1);
                    if (it != null && it.getCount() >= 1L) {
                        player.getInventory().destroyItem("Boat", it.getObjectId(), 1L, player, (L2Object)this);
                        InventoryUpdate iu = new InventoryUpdate();
                        iu.addModifiedItem(it);
                        player.sendPacket(iu);
                        player.sendPacket(new VehicleStarted(this, 1));
                        this._inboat.put(i, player);
                        ++i;
                        continue;
                    }
                    if (it == null && this._t2.idWTicket1 == 0) {
                        this._inboat.put(i, player);
                        player.sendPacket(new VehicleStarted(this, 1));
                        ++i;
                        continue;
                    }
                    player.teleToLocation(this._t2.ntx1, this._t2.nty1, this._t2.ntz1, false);
                }
            }
            Boatrun bc = new Boatrun(0, this);
            ThreadPoolManager.getInstance().scheduleGeneral(bc, 0L);
        }
    }

    public void say(int i) {
        Collection<L2PcInstance> knownPlayers = this.getKnownList().getKnownPlayers().values();
        CreatureSay sm2 = null;
        switch (i) {
            case 10: {
                CreatureSay sm;
                if (this._cycle == 1) {
                    sm = new CreatureSay(0, 1, this._t1.npc1, this._t1.sysmess10_1);
                    if (this.getId() == 5) {
                        sm2 = new CreatureSay(0, 1, this._t1.npc1, this._t1.sysmess5_1);
                    }
                } else {
                    sm = new CreatureSay(0, 1, this._t2.npc1, this._t2.sysmess10_1);
                    if (this.getId() == 5) {
                        sm2 = new CreatureSay(0, 1, this._t2.npc1, this._t2.sysmess5_1);
                    }
                }
                PlaySound ps = new PlaySound(0, "itemsound.ship_arrival_departure", 1, this.getObjectId(), this.getX(), this.getY(), this.getZ());
                if (knownPlayers == null || knownPlayers.isEmpty()) {
                    return;
                }
                for (L2PcInstance player : knownPlayers) {
                    player.sendPacket(sm);
                    player.sendPacket(ps);
                    player.sendPacket(new VehicleStarted(this, 0));
                    if (sm2 == null) continue;
                    player.sendPacket(sm2);
                }
                break;
            }
            case 5: {
                CreatureSay sm = this._cycle == 1 ? new CreatureSay(0, 1, this._t1.npc1, this._t1.sysmess5_1) : new CreatureSay(0, 1, this._t2.npc1, this._t2.sysmess5_1);
                PlaySound ps = new PlaySound(0, "itemsound.ship_5min", 1, this.getObjectId(), this.getX(), this.getY(), this.getZ());
                if (knownPlayers == null || knownPlayers.isEmpty()) {
                    return;
                }
                for (L2PcInstance player : knownPlayers) {
                    player.sendPacket(sm);
                    player.sendPacket(ps);
                }
                break;
            }
            case 1: {
                CreatureSay sm = this._cycle == 1 ? new CreatureSay(0, 1, this._t1.npc1, this._t1.sysmess1_1) : new CreatureSay(0, 1, this._t2.npc1, this._t2.sysmess1_1);
                PlaySound ps = new PlaySound(0, "itemsound.ship_1min", 1, this.getObjectId(), this.getX(), this.getY(), this.getZ());
                if (knownPlayers == null || knownPlayers.isEmpty()) {
                    return;
                }
                for (L2PcInstance player : knownPlayers) {
                    player.sendPacket(sm);
                    player.sendPacket(ps);
                }
                break;
            }
            case 0: {
                CreatureSay sm = this._cycle == 1 ? new CreatureSay(0, 1, this._t1.npc1, this._t1.sysmess0_1) : new CreatureSay(0, 1, this._t2.npc1, this._t2.sysmess0_1);
                if (knownPlayers == null || knownPlayers.isEmpty()) {
                    return;
                }
                for (L2PcInstance player : knownPlayers) {
                    player.sendPacket(sm);
                }
                break;
            }
            case -1: {
                CreatureSay sm = this._cycle == 1 ? new CreatureSay(0, 1, this._t1.npc1, this._t1.sysmessb_1) : new CreatureSay(0, 1, this._t2.npc1, this._t2.sysmessb_1);
                PlaySound ps = new PlaySound(0, "itemsound.ship_arrival_departure", 1, this.getObjectId(), this.getX(), this.getY(), this.getZ());
                for (L2PcInstance player : knownPlayers) {
                    player.sendPacket(sm);
                    player.sendPacket(ps);
                }
                break;
            }
        }
    }

    public void spawn() {
        Collection<L2PcInstance> knownPlayers = this.getKnownList().getKnownPlayers().values();
        this._cycle = 1;
        this.beginCycle();
        if (knownPlayers == null || knownPlayers.isEmpty()) {
            return;
        }
        VehicleInfo vi = new VehicleInfo(this);
        for (L2PcInstance player : knownPlayers) {
            player.sendPacket(vi);
        }
    }

    public void setTrajet1(int idWaypoint1, int idWTicket1, int ntx1, int nty1, int ntz1, String idnpc1, String sysmess10_1, String sysmess5_1, String sysmess1_1, String sysmess0_1, String sysmessb_1) {
        this._t1 = new L2BoatTrajet(idWaypoint1, idWTicket1, ntx1, nty1, ntz1, idnpc1, sysmess10_1, sysmess5_1, sysmess1_1, sysmess0_1, sysmessb_1, this._name);
    }

    public void setTrajet2(int idWaypoint1, int idWTicket1, int ntx1, int nty1, int ntz1, String idnpc1, String sysmess10_1, String sysmess5_1, String sysmess1_1, String sysmess0_1, String sysmessb_1) {
        this._t2 = new L2BoatTrajet(idWaypoint1, idWTicket1, ntx1, nty1, ntz1, idnpc1, sysmess10_1, sysmess5_1, sysmess1_1, sysmess0_1, sysmessb_1, this._name);
    }

    @Override
    public void updateAbnormalEffect() {
    }

    @Override
    public L2ItemInstance getActiveWeaponInstance() {
        return null;
    }

    @Override
    public L2Weapon getActiveWeaponItem() {
        return null;
    }

    @Override
    public L2ItemInstance getSecondaryWeaponInstance() {
        return null;
    }

    @Override
    public L2Weapon getSecondaryWeaponItem() {
        return null;
    }

    @Override
    public int getLevel() {
        return 0;
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return false;
    }

    @Override
    public void setAI(L2CharacterAI newAI) {
        if (this._ai == null) {
            this._ai = newAI;
        }
    }

    public void setId(int id) {
        this._id = id;
    }

    @Override
    public void sendInfo(L2PcInstance activeChar) {
        if (!activeChar.isInBoat() && this != activeChar.getBoat()) {
            activeChar.sendPacket(new VehicleInfo(this));
            this.sendVehicleDeparture(activeChar);
        }
    }

    public class AIAccessor
    extends L2Character.AIAccessor {
        @Override
        public void detachAI() {
        }
    }

    class Boatrun
    implements Runnable {
        private int _state;
        private L2BoatInstance _boat;

        public Boatrun(int i, L2BoatInstance instance) {
            this._state = i;
            this._boat = instance;
        }

        @Override
        public void run() {
            this._boat._vd = null;
            this._boat.needOnVehicleCheckLocation = false;
            if (this._boat._cycle == 1) {
                int time = this._boat._t1.state(this._state, this._boat);
                if (time > 0) {
                    ++this._state;
                    Boatrun bc = new Boatrun(this._state, this._boat);
                    ThreadPoolManager.getInstance().scheduleGeneral(bc, time);
                } else if (time == 0) {
                    this._boat._cycle = 2;
                    this._boat.say(10);
                    BoatCaptain bc = new BoatCaptain(1, this._boat);
                    ThreadPoolManager.getInstance().scheduleGeneral(bc, 300000L);
                } else {
                    this._boat.needOnVehicleCheckLocation = true;
                    ++this._state;
                    this._boat._runstate = this._state;
                }
            } else if (this._boat._cycle == 2) {
                int time = this._boat._t2.state(this._state, this._boat);
                if (time > 0) {
                    ++this._state;
                    Boatrun bc = new Boatrun(this._state, this._boat);
                    ThreadPoolManager.getInstance().scheduleGeneral(bc, time);
                } else if (time == 0) {
                    this._boat._cycle = 1;
                    this._boat.say(10);
                    BoatCaptain bc = new BoatCaptain(1, this._boat);
                    ThreadPoolManager.getInstance().scheduleGeneral(bc, 300000L);
                } else {
                    this._boat.needOnVehicleCheckLocation = true;
                    ++this._state;
                    this._boat._runstate = this._state;
                }
            }
        }
    }

    class BoatCaptain
    implements Runnable {
        private int _state;
        private L2BoatInstance _boat;

        public BoatCaptain(int i, L2BoatInstance instance) {
            this._state = i;
            this._boat = instance;
        }

        @Override
        public void run() {
            if (this._boat.getId() == 5) {
                switch (this._state) {
                    case 1: {
                        this._boat.say(-1);
                        this._boat.begin();
                    }
                }
            } else {
                switch (this._state) {
                    case 1: {
                        this._boat.say(5);
                        BoatCaptain bc = new BoatCaptain(2, this._boat);
                        ThreadPoolManager.getInstance().scheduleGeneral(bc, 240000L);
                        break;
                    }
                    case 2: {
                        this._boat.say(1);
                        BoatCaptain bc = new BoatCaptain(3, this._boat);
                        ThreadPoolManager.getInstance().scheduleGeneral(bc, 40000L);
                        break;
                    }
                    case 3: {
                        this._boat.say(0);
                        BoatCaptain bc = new BoatCaptain(4, this._boat);
                        ThreadPoolManager.getInstance().scheduleGeneral(bc, 20000L);
                        break;
                    }
                    case 4: {
                        this._boat.say(-1);
                        this._boat.begin();
                    }
                }
            }
        }
    }

    private class L2BoatTrajet {
        private Map<Integer, L2BoatPoint> _path;
        public int idWaypoint1;
        public int idWTicket1;
        public int ntx1;
        public int nty1;
        public int ntz1;
        public int max;
        public String boatName;
        public String npc1;
        public String sysmess10_1;
        public String sysmess5_1;
        public String sysmess1_1;
        public String sysmessb_1;
        public String sysmess0_1;

        public L2BoatTrajet(int pIdWaypoint1, int pIdWTicket1, int pNtx1, int pNty1, int pNtz1, String pNpc1, String pSysmess10_1, String pSysmess5_1, String pSysmess1_1, String pSysmess0_1, String pSysmessb_1, String pBoatname) {
            this.idWaypoint1 = pIdWaypoint1;
            this.idWTicket1 = pIdWTicket1;
            this.ntx1 = pNtx1;
            this.nty1 = pNty1;
            this.ntz1 = pNtz1;
            this.npc1 = pNpc1;
            this.sysmess10_1 = pSysmess10_1;
            this.sysmess5_1 = pSysmess5_1;
            this.sysmess1_1 = pSysmess1_1;
            this.sysmessb_1 = pSysmessb_1;
            this.sysmess0_1 = pSysmess0_1;
            this.boatName = pBoatname;
            this.loadBoatPath();
        }

        public void parseLine(String line) {
            this._path = new FastMap();
            StringTokenizer st = new StringTokenizer(line, ";");
            Integer.parseInt(st.nextToken());
            this.max = Integer.parseInt(st.nextToken());
            for (int i = 0; i < this.max; ++i) {
                L2BoatPoint bp = new L2BoatPoint();
                bp.speed1 = Integer.parseInt(st.nextToken());
                bp.speed2 = Integer.parseInt(st.nextToken());
                bp.x = Integer.parseInt(st.nextToken());
                bp.y = Integer.parseInt(st.nextToken());
                bp.z = Integer.parseInt(st.nextToken());
                bp.time = Integer.parseInt(st.nextToken());
                this._path.put(i, bp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadBoatPath() {
            BufferedReader lnr = null;
            try {
                File doorData = new File(Config.DATAPACK_ROOT, "data/boatpath.csv");
                lnr = new LineNumberReader(new BufferedReader(new FileReader(doorData)));
                String line = null;
                while ((line = ((LineNumberReader)lnr).readLine()) != null) {
                    if (line.trim().length() == 0 || !line.startsWith(this.idWaypoint1 + ";")) continue;
                    this.parseLine(line);
                    return;
                }
                _logBoat.warning("No path for boat " + this.boatName + " !!!");
            }
            catch (FileNotFoundException e) {
                _logBoat.warning("boatpath.csv is missing in data folder");
            }
            catch (Exception e) {
                _logBoat.warning("error while creating boat table " + e);
            }
            finally {
                try {
                    lnr.close();
                }
                catch (Exception e1) {}
            }
        }

        public int state(int state, L2BoatInstance _boat) {
            if (state < this.max) {
                L2BoatPoint bp = this._path.get(state);
                double dx = _boat.getX() - bp.x;
                double dy = _boat.getY() - bp.y;
                double distance = Math.sqrt(dx * dx + dy * dy);
                double sin = dy / distance;
                double cos = dx / distance;
                _boat.getPosition().setHeading(Util.calculateHeadingFrom(cos, sin));
                _boat._vd = new VehicleDeparture(_boat, bp.speed1, bp.speed2, bp.x, bp.y, bp.z);
                L2BoatInstance.this.boatSpeed = bp.speed1;
                _boat.moveToLocation(bp.x, bp.y, bp.z, (float)bp.speed1);
                Collection<L2PcInstance> knownPlayers = _boat.getKnownList().getKnownPlayers().values();
                if (bp.time == 0) {
                    bp.time = 1;
                }
                if (knownPlayers == null || knownPlayers.isEmpty()) {
                    return bp.time;
                }
                for (L2PcInstance player : knownPlayers) {
                    player.sendPacket(_boat._vd);
                }
                return bp.time;
            }
            return 0;
        }

        protected class L2BoatPoint {
            public int speed1;
            public int speed2;
            public int x;
            public int y;
            public int z;
            public int time;

            protected L2BoatPoint() {
            }
        }
    }
}

