/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.instancemanager.GrandBossManager;
import com.l2jserver.gameserver.instancemanager.RaidBossPointsManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.util.Rnd;

public final class L2GrandBossInstance
extends L2MonsterInstance {
    private static final int BOSS_MAINTENANCE_INTERVAL = 10000;
    private boolean _isInSocialAction = false;
    private IEvtArrived _evtArrivedAction;

    public L2GrandBossInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2GrandBossInstance);
        this.setIsRaid(true);
    }

    @Override
    protected int getMaintenanceInterval() {
        return 10000;
    }

    @Override
    public void onSpawn() {
        this.setIsNoRndWalk(true);
        if (this.getNpcId() == 29020 || this.getNpcId() == 29028) {
            super.disableCoreAI(true);
        }
        super.onSpawn();
    }

    public boolean isInSocialAction() {
        return this._isInSocialAction;
    }

    public void setIsInSocialAction(boolean value) {
        this._isInSocialAction = value;
        this.setIsInvul(value);
        if (value) {
            this.aggroDisable();
        } else {
            this.setAggroEnable(Rnd.get(30000, 60000));
        }
    }

    @Override
    public boolean doDie(L2Character killer) {
        if (!super.doDie(killer)) {
            return false;
        }
        if (GrandBossManager.getInstance().getStatsSet(this.getNpcId()) == null) {
            return true;
        }
        L2PcInstance player = null;
        if (killer instanceof L2PcInstance) {
            player = (L2PcInstance)killer;
        } else if (killer instanceof L2Summon) {
            player = ((L2Summon)killer).getOwner();
        }
        if (player != null) {
            this.broadcastPacket(new SystemMessage(SystemMessageId.RAID_WAS_SUCCESSFUL));
            if (player.getParty() != null) {
                for (L2PcInstance member : player.getParty().getPartyMembers()) {
                    RaidBossPointsManager.addPoints(member, this.getNpcId(), this.getLevel() / 2 + Rnd.get(-5, 5));
                }
            } else {
                RaidBossPointsManager.addPoints(player, this.getNpcId(), this.getLevel() / 2 + Rnd.get(-5, 5));
            }
        }
        return true;
    }

    @Override
    public float getVitalityPoints(int damage) {
        return -super.getVitalityPoints(damage) / 100.0f;
    }

    @Override
    public boolean useVitalityRate() {
        return false;
    }

    @Override
    public boolean giveRaidCurse() {
        return this.getLevel() < 74;
    }

    public void setEvtArrived(IEvtArrived run) {
        this._evtArrivedAction = run;
    }

    public void evtArrived() {
        if (this._evtArrivedAction != null) {
            this._evtArrivedAction.evtArrived(this);
        }
    }

    public static interface IEvtArrived {
        public void evtArrived(L2Npc var1);
    }
}

