/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ai.L2CharacterAI;
import com.l2jserver.gameserver.ai.L2NpcWalkerAI;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.CreatureSay;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.util.Broadcast;
import java.util.Map;

public class L2NpcWalkerInstance
extends L2Npc {
    public L2NpcWalkerInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2NpcWalkerInstance);
        this.setAI(new L2NpcWalkerAI(new L2NpcWalkerAIAccessor()));
    }

    @Override
    public void setAI(L2CharacterAI newAI) {
        if (!(this._ai instanceof L2NpcWalkerAI)) {
            this._ai = newAI;
        }
    }

    @Override
    public void onSpawn() {
        this.getAI().setHomeX(this.getX());
        this.getAI().setHomeY(this.getY());
        this.getAI().setHomeZ(this.getZ());
    }

    public void broadcastChat(String chat) {
        Map<Integer, L2PcInstance> _knownPlayers = this.getKnownList().getKnownPlayers();
        if (_knownPlayers == null) {
            if (Config.DEVELOPER) {
                _log.info("broadcastChat _players == null");
            }
            return;
        }
        if (!_knownPlayers.isEmpty()) {
            CreatureSay cs = new CreatureSay(this.getObjectId(), 0, this.getName(), chat);
            Broadcast.toKnownPlayers(this, cs);
        }
    }

    @Override
    public void reduceCurrentHp(double i, L2Character attacker, boolean awake, boolean isDOT, L2Skill skill) {
    }

    @Override
    public boolean doDie(L2Character killer) {
        return false;
    }

    @Override
    public L2NpcWalkerAI getAI() {
        return (L2NpcWalkerAI)this._ai;
    }

    protected class L2NpcWalkerAIAccessor
    extends L2Character.AIAccessor {
        protected L2NpcWalkerAIAccessor() {
        }

        @Override
        public void detachAI() {
        }
    }
}

