/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.gameserver.SevenSigns;
import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2DawnPriestInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import java.util.StringTokenizer;
import javolution.text.TextBuilder;

public class L2SignsPriestInstance
extends L2Npc {
    public L2SignsPriestInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2SignsPriestInstance);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        if (player.getLastFolkNPC() == null || player.getLastFolkNPC().getObjectId() != this.getObjectId()) {
            return;
        }
        if (command.startsWith("SevenSignsDesc")) {
            int val = Integer.parseInt(command.substring(15));
            this.showChatWindow(player, val, null, true);
            return;
        }
        if (command.startsWith("SevenSigns")) {
            int cabal = 0;
            int stoneType = 0;
            L2ItemInstance ancientAdena = player.getInventory().getItemByItemId(5575);
            long ancientAdenaAmount = ancientAdena == null ? 0L : ancientAdena.getCount();
            int val = Integer.parseInt(command.substring(11, 12).trim());
            if (command.length() > 12) {
                val = Integer.parseInt(command.substring(11, 13).trim());
            }
            if (command.length() > 13) {
                try {
                    cabal = Integer.parseInt(command.substring(14, 15).trim());
                }
                catch (Exception e) {
                    try {
                        cabal = Integer.parseInt(command.substring(13, 14).trim());
                    }
                    catch (Exception e2) {
                        try {
                            StringTokenizer st = new StringTokenizer(command.trim());
                            st.nextToken();
                            cabal = Integer.parseInt(st.nextToken());
                        }
                        catch (Exception e3) {
                            _log.warning("Failed to retrieve cabal from bypass command. NpcId: " + this.getNpcId() + "; Command: " + command);
                        }
                    }
                }
            }
            switch (val) {
                case 2: {
                    if (!player.getInventory().validateCapacity(1)) {
                        player.sendPacket(new SystemMessage(SystemMessageId.SLOTS_FULL));
                        return;
                    }
                    if (!player.reduceAdena("SevenSigns", 500L, this, true)) {
                        player.sendPacket(new SystemMessage(SystemMessageId.YOU_NOT_ENOUGH_ADENA));
                        return;
                    }
                    player.getInventory().addItem("SevenSigns", 5707, 1L, player, this);
                    SystemMessage sm = new SystemMessage(SystemMessageId.EARNED_ITEM);
                    sm.addItemName(5707);
                    player.sendPacket(sm);
                    if (this instanceof L2DawnPriestInstance) {
                        this.showChatWindow(player, val, "dawn", false);
                        return;
                    }
                    this.showChatWindow(player, val, "dusk", false);
                    return;
                }
                case 33: {
                    int oldCabal = SevenSigns.getInstance().getPlayerCabal(player.getObjectId());
                    if (oldCabal != 0) {
                        if (this instanceof L2DawnPriestInstance) {
                            this.showChatWindow(player, val, "dawn_member", false);
                            return;
                        } else {
                            this.showChatWindow(player, val, "dusk_member", false);
                        }
                        return;
                    }
                    if (player.getClassId().level() == 0) {
                        if (this instanceof L2DawnPriestInstance) {
                            this.showChatWindow(player, val, "dawn_firstclass", false);
                            return;
                        } else {
                            this.showChatWindow(player, val, "dusk_firstclass", false);
                        }
                        return;
                    }
                    if (cabal == 1 && Config.ALT_GAME_CASTLE_DUSK) {
                        if (player.getClan() != null && player.getClan().getHasCastle() > 0) {
                            this.showChatWindow(player, "data/html/seven_signs/signs_33_dusk_no.htm");
                            return;
                        }
                    } else if (cabal == 2 && Config.ALT_GAME_CASTLE_DAWN && (player.getClan() == null || player.getClan().getHasCastle() == 0)) {
                        this.showChatWindow(player, "data/html/seven_signs/signs_33_dawn_fee.htm");
                        return;
                    }
                    if (this instanceof L2DawnPriestInstance) {
                        this.showChatWindow(player, val, "dawn", false);
                        return;
                    }
                    this.showChatWindow(player, val, "dusk", false);
                    return;
                }
                case 34: {
                    L2ItemInstance adena = player.getInventory().getItemByItemId(57);
                    L2ItemInstance certif = player.getInventory().getItemByItemId(6388);
                    boolean fee = true;
                    if (player.getClassId().level() < 2 || adena != null && adena.getCount() >= 50000L || certif != null && certif.getCount() >= 1L) {
                        fee = false;
                    }
                    if (fee) {
                        this.showChatWindow(player, "data/html/seven_signs/signs_33_dawn_no.htm");
                        return;
                    }
                    this.showChatWindow(player, "data/html/seven_signs/signs_33_dawn.htm");
                    return;
                }
                case 3: 
                case 8: {
                    this.showChatWindow(player, val, SevenSigns.getCabalShortName(cabal), false);
                    return;
                }
                case 4: {
                    int newSeal = Integer.parseInt(command.substring(15));
                    if (player.getClassId().level() >= 2) {
                        if (cabal == 1 && Config.ALT_GAME_CASTLE_DUSK && player.getClan() != null && player.getClan().getHasCastle() > 0) {
                            this.showChatWindow(player, "data/html/seven_signs/signs_33_dusk_no.htm");
                            return;
                        }
                        if (Config.ALT_GAME_CASTLE_DAWN && cabal == 2) {
                            boolean allowJoinDawn = false;
                            if (player.getClan() != null && player.getClan().getHasCastle() > 0) {
                                allowJoinDawn = true;
                            } else if (player.destroyItemByItemId("SevenSigns", 6388, 1L, this, true)) {
                                allowJoinDawn = true;
                            } else if (player.reduceAdena("SevenSigns", 50000L, this, true)) {
                                allowJoinDawn = true;
                            }
                            if (!allowJoinDawn) {
                                this.showChatWindow(player, "data/html/seven_signs/signs_33_dawn_fee.htm");
                                return;
                            }
                        }
                    }
                    SevenSigns.getInstance().setPlayerInfo(player.getObjectId(), cabal, newSeal);
                    if (cabal == 2) {
                        player.sendPacket(new SystemMessage(SystemMessageId.SEVENSIGNS_PARTECIPATION_DAWN));
                    } else {
                        player.sendPacket(new SystemMessage(SystemMessageId.SEVENSIGNS_PARTECIPATION_DUSK));
                    }
                    switch (newSeal) {
                        case 1: {
                            player.sendPacket(new SystemMessage(SystemMessageId.FIGHT_FOR_AVARICE));
                            break;
                        }
                        case 2: {
                            player.sendPacket(new SystemMessage(SystemMessageId.FIGHT_FOR_GNOSIS));
                            break;
                        }
                        case 3: {
                            player.sendPacket(new SystemMessage(SystemMessageId.FIGHT_FOR_STRIFE));
                        }
                    }
                    this.showChatWindow(player, 4, SevenSigns.getCabalShortName(cabal), false);
                    return;
                }
                case 5: {
                    if (this instanceof L2DawnPriestInstance) {
                        if (SevenSigns.getInstance().getPlayerCabal(player.getObjectId()) == 0) {
                            this.showChatWindow(player, val, "dawn_no", false);
                            return;
                        }
                        this.showChatWindow(player, val, "dawn", false);
                        return;
                    }
                    if (SevenSigns.getInstance().getPlayerCabal(player.getObjectId()) == 0) {
                        this.showChatWindow(player, val, "dusk_no", false);
                        return;
                    }
                    this.showChatWindow(player, val, "dusk", false);
                    return;
                }
                case 21: {
                    SystemMessage msg;
                    int contribStoneId = Integer.parseInt(command.substring(14, 18));
                    L2ItemInstance contribBlueStones = player.getInventory().getItemByItemId(6360);
                    L2ItemInstance contribGreenStones = player.getInventory().getItemByItemId(6361);
                    L2ItemInstance contribRedStones = player.getInventory().getItemByItemId(6362);
                    long contribBlueStoneCount = contribBlueStones == null ? 0L : contribBlueStones.getCount();
                    long contribGreenStoneCount = contribGreenStones == null ? 0L : contribGreenStones.getCount();
                    long contribRedStoneCount = contribRedStones == null ? 0L : contribRedStones.getCount();
                    long score = SevenSigns.getInstance().getPlayerContribScore(player.getObjectId());
                    long contributionCount = 0L;
                    boolean contribStonesFound = false;
                    long redContrib = 0L;
                    long greenContrib = 0L;
                    long blueContrib = 0L;
                    try {
                        contributionCount = Long.parseLong(command.substring(19).trim());
                    }
                    catch (Exception NumberFormatException2) {
                        if (this instanceof L2DawnPriestInstance) {
                            this.showChatWindow(player, 6, "dawn_failure", false);
                            return;
                        }
                        this.showChatWindow(player, 6, "dusk_failure", false);
                        return;
                    }
                    switch (contribStoneId) {
                        case 6360: {
                            blueContrib = ((long)Config.ALT_MAXIMUM_PLAYER_CONTRIB - score) / 3L;
                            if (blueContrib <= contribBlueStoneCount) break;
                            blueContrib = contributionCount;
                            break;
                        }
                        case 6361: {
                            greenContrib = ((long)Config.ALT_MAXIMUM_PLAYER_CONTRIB - score) / 5L;
                            if (greenContrib <= contribGreenStoneCount) break;
                            greenContrib = contributionCount;
                            break;
                        }
                        case 6362: {
                            redContrib = ((long)Config.ALT_MAXIMUM_PLAYER_CONTRIB - score) / 10L;
                            if (redContrib <= contribRedStoneCount) break;
                            redContrib = contributionCount;
                        }
                    }
                    if (redContrib > 0L && player.destroyItemByItemId("SevenSigns", 6362, redContrib, this, false)) {
                        contribStonesFound = true;
                        msg = new SystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
                        msg.addItemName(6362);
                        msg.addItemNumber(redContrib);
                        player.sendPacket(msg);
                    }
                    if (greenContrib > 0L && player.destroyItemByItemId("SevenSigns", 6361, greenContrib, this, false)) {
                        contribStonesFound = true;
                        msg = new SystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
                        msg.addItemName(6361);
                        msg.addItemNumber(greenContrib);
                        player.sendPacket(msg);
                    }
                    if (blueContrib > 0L && player.destroyItemByItemId("SevenSigns", 6360, blueContrib, this, false)) {
                        contribStonesFound = true;
                        msg = new SystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
                        msg.addItemName(6360);
                        msg.addItemNumber(blueContrib);
                        player.sendPacket(msg);
                    }
                    if (!contribStonesFound) {
                        if (this instanceof L2DawnPriestInstance) {
                            this.showChatWindow(player, 6, "dawn_low_stones", false);
                            return;
                        }
                        this.showChatWindow(player, 6, "dusk_low_stones", false);
                        return;
                    }
                    score = SevenSigns.getInstance().addPlayerStoneContrib(player.getObjectId(), blueContrib, greenContrib, redContrib);
                    SystemMessage sm = new SystemMessage(SystemMessageId.CONTRIB_SCORE_INCREASED);
                    sm.addItemNumber(score);
                    player.sendPacket(sm);
                    if (this instanceof L2DawnPriestInstance) {
                        this.showChatWindow(player, 6, "dawn", false);
                        return;
                    }
                    this.showChatWindow(player, 6, "dusk", false);
                    return;
                }
                case 6: {
                    stoneType = Integer.parseInt(command.substring(13));
                    L2ItemInstance blueStones = player.getInventory().getItemByItemId(6360);
                    L2ItemInstance greenStones = player.getInventory().getItemByItemId(6361);
                    L2ItemInstance redStones = player.getInventory().getItemByItemId(6362);
                    long blueStoneCount = blueStones == null ? 0L : blueStones.getCount();
                    long greenStoneCount = greenStones == null ? 0L : greenStones.getCount();
                    long redStoneCount = redStones == null ? 0L : redStones.getCount();
                    long contribScore = SevenSigns.getInstance().getPlayerContribScore(player.getObjectId());
                    boolean stonesFound = false;
                    if (contribScore == (long)Config.ALT_MAXIMUM_PLAYER_CONTRIB) {
                        player.sendPacket(new SystemMessage(SystemMessageId.CONTRIB_SCORE_EXCEEDED));
                        return;
                    }
                    long redContribCount = 0L;
                    long greenContribCount = 0L;
                    long blueContribCount = 0L;
                    String contribStoneColor = null;
                    String stoneColorContr = null;
                    long stoneCountContr = 0L;
                    int stoneIdContr = 0;
                    switch (stoneType) {
                        case 1: {
                            contribStoneColor = "\u9752\u3044";
                            stoneColorContr = "\u9752\u3044";
                            stoneIdContr = 6360;
                            stoneCountContr = blueStoneCount;
                            break;
                        }
                        case 2: {
                            contribStoneColor = "\u7dd1\u306e";
                            stoneColorContr = "\u7dd1\u306e";
                            stoneIdContr = 6361;
                            stoneCountContr = greenStoneCount;
                            break;
                        }
                        case 3: {
                            contribStoneColor = "\u8d64\u3044";
                            stoneColorContr = "\u8d64\u3044";
                            stoneIdContr = 6362;
                            stoneCountContr = redStoneCount;
                            break;
                        }
                        case 4: {
                            SystemMessage msg;
                            long tempContribScore = contribScore;
                            redContribCount = ((long)Config.ALT_MAXIMUM_PLAYER_CONTRIB - tempContribScore) / 10L;
                            if (redContribCount > redStoneCount) {
                                redContribCount = redStoneCount;
                            }
                            if ((greenContribCount = ((long)Config.ALT_MAXIMUM_PLAYER_CONTRIB - (tempContribScore += redContribCount * 10L)) / 5L) > greenStoneCount) {
                                greenContribCount = greenStoneCount;
                            }
                            if ((blueContribCount = ((long)Config.ALT_MAXIMUM_PLAYER_CONTRIB - (tempContribScore += greenContribCount * 5L)) / 3L) > blueStoneCount) {
                                blueContribCount = blueStoneCount;
                            }
                            if (redContribCount > 0L && player.destroyItemByItemId("SevenSigns", 6362, redContribCount, this, false)) {
                                stonesFound = true;
                                msg = new SystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
                                msg.addItemName(6362);
                                msg.addItemNumber(redContribCount);
                                player.sendPacket(msg);
                            }
                            if (greenContribCount > 0L && player.destroyItemByItemId("SevenSigns", 6361, greenContribCount, this, false)) {
                                stonesFound = true;
                                msg = new SystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
                                msg.addItemName(6361);
                                msg.addItemNumber(greenContribCount);
                                player.sendPacket(msg);
                            }
                            if (blueContribCount > 0L && player.destroyItemByItemId("SevenSigns", 6360, blueContribCount, this, false)) {
                                stonesFound = true;
                                msg = new SystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
                                msg.addItemName(6360);
                                msg.addItemNumber(blueContribCount);
                                player.sendPacket(msg);
                            }
                            if (!stonesFound) {
                                if (this instanceof L2DawnPriestInstance) {
                                    this.showChatWindow(player, val, "dawn_no_stones", false);
                                    return;
                                } else {
                                    this.showChatWindow(player, val, "dusk_no_stones", false);
                                }
                                return;
                            } else {
                                contribScore = SevenSigns.getInstance().addPlayerStoneContrib(player.getObjectId(), blueContribCount, greenContribCount, redContribCount);
                                SystemMessage sm = new SystemMessage(SystemMessageId.CONTRIB_SCORE_INCREASED);
                                sm.addItemNumber(contribScore);
                                player.sendPacket(sm);
                                if (this instanceof L2DawnPriestInstance) {
                                    this.showChatWindow(player, 6, "dawn", false);
                                    return;
                                } else {
                                    this.showChatWindow(player, 6, "dusk", false);
                                }
                            }
                            return;
                        }
                    }
                    String path = this instanceof L2DawnPriestInstance ? "data/html/seven_signs/signs_6_dawn_contribute.htm" : "data/html/seven_signs/signs_6_dusk_contribute.htm";
                    String contentContr = HtmCache.getInstance().getHtm(player.getHtmlPrefix(), path);
                    if (contentContr != null) {
                        contentContr = contentContr.replaceAll("%contribStoneColor%", contribStoneColor);
                        contentContr = contentContr.replaceAll("%stoneColor%", stoneColorContr);
                        contentContr = contentContr.replaceAll("%stoneCount%", String.valueOf(stoneCountContr));
                        contentContr = contentContr.replaceAll("%stoneItemId%", String.valueOf(stoneIdContr));
                        contentContr = contentContr.replaceAll("%objectId%", String.valueOf(this.getObjectId()));
                        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                        html.setHtml(contentContr);
                        player.sendPacket(html);
                        return;
                    }
                    _log.warning("Problem with HTML text " + path);
                    return;
                }
                case 7: {
                    long ancientAdenaConvert = 0L;
                    try {
                        ancientAdenaConvert = Long.parseLong(command.substring(13).trim());
                    }
                    catch (NumberFormatException e) {
                        this.showChatWindow(player, "data/html/seven_signs/blkmrkt_3.htm");
                        return;
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        this.showChatWindow(player, "data/html/seven_signs/blkmrkt_3.htm");
                        return;
                    }
                    if (ancientAdenaConvert < 1L) {
                        this.showChatWindow(player, "data/html/seven_signs/blkmrkt_3.htm");
                        return;
                    }
                    if (ancientAdenaAmount < ancientAdenaConvert) {
                        this.showChatWindow(player, "data/html/seven_signs/blkmrkt_4.htm");
                        return;
                    }
                    player.reduceAncientAdena("SevenSigns", ancientAdenaConvert, this, true);
                    player.addAdena("SevenSigns", ancientAdenaConvert, this, true);
                    this.showChatWindow(player, "data/html/seven_signs/blkmrkt_5.htm");
                    return;
                }
                case 9: {
                    int playerCabal = SevenSigns.getInstance().getPlayerCabal(player.getObjectId());
                    int winningCabal = SevenSigns.getInstance().getCabalHighestScore();
                    if (!SevenSigns.getInstance().isSealValidationPeriod() || playerCabal != winningCabal) return;
                    int ancientAdenaReward = SevenSigns.getInstance().getAncientAdenaReward(player.getObjectId(), true);
                    if (ancientAdenaReward < 3) {
                        if (this instanceof L2DawnPriestInstance) {
                            this.showChatWindow(player, 9, "dawn_b", false);
                            return;
                        }
                        this.showChatWindow(player, 9, "dusk_b", false);
                        return;
                    }
                    player.addAncientAdena("SevenSigns", ancientAdenaReward, this, true);
                    if (this instanceof L2DawnPriestInstance) {
                        this.showChatWindow(player, 9, "dawn_a", false);
                        return;
                    }
                    this.showChatWindow(player, 9, "dusk_a", false);
                    return;
                }
                case 11: {
                    try {
                        String portInfo = command.substring(14).trim();
                        StringTokenizer st = new StringTokenizer(portInfo);
                        int x = Integer.parseInt(st.nextToken());
                        int y = Integer.parseInt(st.nextToken());
                        int z = Integer.parseInt(st.nextToken());
                        long ancientAdenaCost = Long.parseLong(st.nextToken());
                        if (ancientAdenaCost > 0L && !player.reduceAncientAdena("SevenSigns", ancientAdenaCost, this, true)) return;
                        player.teleToLocation(x, y, z);
                        return;
                    }
                    catch (Exception e) {
                        _log.warning("SevenSigns: Error occurred while teleporting player: " + e);
                    }
                    return;
                }
                case 16: {
                    if (this instanceof L2DawnPriestInstance) {
                        this.showChatWindow(player, val, "dawn", false);
                        return;
                    }
                    this.showChatWindow(player, val, "dusk", false);
                    return;
                }
                case 17: {
                    stoneType = Integer.parseInt(command.substring(14));
                    int stoneId = 0;
                    long stoneCount = 0L;
                    int stoneValue = 0;
                    String stoneColor = null;
                    switch (stoneType) {
                        case 1: {
                            stoneColor = "blue";
                            stoneId = 6360;
                            stoneValue = 3;
                            break;
                        }
                        case 2: {
                            stoneColor = "green";
                            stoneId = 6361;
                            stoneValue = 5;
                            break;
                        }
                        case 3: {
                            stoneColor = "red";
                            stoneId = 6362;
                            stoneValue = 10;
                            break;
                        }
                        case 4: {
                            L2ItemInstance blueStonesAll = player.getInventory().getItemByItemId(6360);
                            L2ItemInstance greenStonesAll = player.getInventory().getItemByItemId(6361);
                            L2ItemInstance redStonesAll = player.getInventory().getItemByItemId(6362);
                            long blueStoneCountAll = blueStonesAll == null ? 0L : blueStonesAll.getCount();
                            long greenStoneCountAll = greenStonesAll == null ? 0L : greenStonesAll.getCount();
                            long redStoneCountAll = redStonesAll == null ? 0L : redStonesAll.getCount();
                            long ancientAdenaRewardAll = 0L;
                            ancientAdenaRewardAll = SevenSigns.calcAncientAdenaReward(blueStoneCountAll, greenStoneCountAll, redStoneCountAll);
                            if (ancientAdenaRewardAll == 0L) {
                                if (this instanceof L2DawnPriestInstance) {
                                    this.showChatWindow(player, 18, "dawn_no_stones", false);
                                    return;
                                } else {
                                    this.showChatWindow(player, 18, "dusk_no_stones", false);
                                }
                                return;
                            }
                            if (blueStoneCountAll > 0L) {
                                player.destroyItemByItemId("SevenSigns", 6360, blueStoneCountAll, this, true);
                            }
                            if (greenStoneCountAll > 0L) {
                                player.destroyItemByItemId("SevenSigns", 6361, greenStoneCountAll, this, true);
                            }
                            if (redStoneCountAll > 0L) {
                                player.destroyItemByItemId("SevenSigns", 6362, redStoneCountAll, this, true);
                            }
                            player.addAncientAdena("SevenSigns", ancientAdenaRewardAll, this, true);
                            if (this instanceof L2DawnPriestInstance) {
                                this.showChatWindow(player, 18, "dawn", false);
                                return;
                            } else {
                                this.showChatWindow(player, 18, "dusk", false);
                            }
                            return;
                        }
                    }
                    L2ItemInstance stoneInstance = player.getInventory().getItemByItemId(stoneId);
                    if (stoneInstance != null) {
                        stoneCount = stoneInstance.getCount();
                    }
                    String path = this instanceof L2DawnPriestInstance ? "data/html/seven_signs/signs_17_dawn.htm" : "data/html/seven_signs/signs_17_dusk.htm";
                    String content = HtmCache.getInstance().getHtm(player.getHtmlPrefix(), path);
                    if (content != null) {
                        content = content.replaceAll("%stoneColor%", stoneColor);
                        content = content.replaceAll("%stoneValue%", String.valueOf(stoneValue));
                        content = content.replaceAll("%stoneCount%", String.valueOf(stoneCount));
                        content = content.replaceAll("%stoneItemId%", String.valueOf(stoneId));
                        content = content.replaceAll("%objectId%", String.valueOf(this.getObjectId()));
                        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                        html.setHtml(content);
                        player.sendPacket(html);
                        return;
                    }
                    _log.warning("Problem with HTML text data/html/seven_signs/signs_17.htm: " + path);
                    return;
                }
                case 18: {
                    int convertStoneId = Integer.parseInt(command.substring(14, 18));
                    long convertCount = 0L;
                    try {
                        convertCount = Long.parseLong(command.substring(19).trim());
                    }
                    catch (Exception NumberFormatException3) {
                        if (this instanceof L2DawnPriestInstance) {
                            this.showChatWindow(player, 18, "dawn_failed", false);
                            return;
                        }
                        this.showChatWindow(player, 18, "dusk_failed", false);
                        return;
                    }
                    L2ItemInstance convertItem = player.getInventory().getItemByItemId(convertStoneId);
                    if (convertItem != null) {
                        long ancientAdenaReward = 0L;
                        long totalCount = convertItem.getCount();
                        if (convertCount <= totalCount && convertCount > 0L) {
                            switch (convertStoneId) {
                                case 6360: {
                                    ancientAdenaReward = SevenSigns.calcAncientAdenaReward(convertCount, 0L, 0L);
                                    break;
                                }
                                case 6361: {
                                    ancientAdenaReward = SevenSigns.calcAncientAdenaReward(0L, convertCount, 0L);
                                    break;
                                }
                                case 6362: {
                                    ancientAdenaReward = SevenSigns.calcAncientAdenaReward(0L, 0L, convertCount);
                                }
                            }
                            if (!player.destroyItemByItemId("SevenSigns", convertStoneId, convertCount, this, true)) return;
                            player.addAncientAdena("SevenSigns", ancientAdenaReward, this, true);
                            if (this instanceof L2DawnPriestInstance) {
                                this.showChatWindow(player, 18, "dawn", false);
                                return;
                            }
                            this.showChatWindow(player, 18, "dusk", false);
                            return;
                        }
                        if (this instanceof L2DawnPriestInstance) {
                            this.showChatWindow(player, 18, "dawn_low_stones", false);
                            return;
                        }
                        this.showChatWindow(player, 18, "dusk_low_stones", false);
                        return;
                    }
                    if (this instanceof L2DawnPriestInstance) {
                        this.showChatWindow(player, 18, "dawn_no_stones", false);
                        return;
                    }
                    this.showChatWindow(player, 18, "dusk_no_stones", false);
                    return;
                }
                case 19: {
                    int chosenSeal = Integer.parseInt(command.substring(16));
                    String fileSuffix = SevenSigns.getSealName(chosenSeal, true) + "_" + SevenSigns.getCabalShortName(cabal);
                    this.showChatWindow(player, val, fileSuffix, false);
                    return;
                }
                case 20: {
                    TextBuilder contentBuffer = new TextBuilder();
                    if (this instanceof L2DawnPriestInstance) {
                        contentBuffer.append("<html><body>Priest of Dawn:<br><font color=\"LEVEL\">[ Seal Status ]</font><br>");
                    } else {
                        contentBuffer.append("<html><body>Dusk Priestess:<br><font color=\"LEVEL\">[ Status of the Seals ]</font><br>");
                    }
                    for (int i = 1; i < 4; ++i) {
                        int sealOwner = SevenSigns.getInstance().getSealOwner(i);
                        if (sealOwner != 0) {
                            contentBuffer.append('[').append(SevenSigns.getSealNameJA(i, false)).append(": ").append(SevenSigns.getCabalName(sealOwner)).append("]<br>");
                            continue;
                        }
                        contentBuffer.append('[').append(SevenSigns.getSealNameJA(i, false)).append(": Nothingness]<br>");
                    }
                    contentBuffer.append("<a action=\"bypass -h npc_").append(this.getObjectId()).append("_Chat 0\">\u623b\u308b</a></body></html>");
                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                    html.setHtml(contentBuffer.toString());
                    player.sendPacket(html);
                    return;
                }
                default: {
                    this.showChatWindow(player, val, null, false);
                }
            }
            return;
        }
        super.onBypassFeedback(player, command);
    }

    private void showChatWindow(L2PcInstance player, int val, String suffix, boolean isDescription) {
        String filename = "data/html/seven_signs/";
        filename = filename + (isDescription ? "desc_" + val : "signs_" + val);
        filename = filename + (suffix != null ? "_" + suffix + ".htm" : ".htm");
        this.showChatWindow(player, filename);
    }
}

