/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.EnterWorld;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.nio.BufferUnderflowException;
import java.util.logging.Logger;
import org.mmocore.network.ReceivablePacket;

public abstract class L2GameClientPacket
extends ReceivablePacket<L2GameClient> {
    private static final Logger _log = Logger.getLogger(L2GameClientPacket.class.getName());

    protected boolean read() {
        try {
            this.readImpl();
            return true;
        }
        catch (Exception e) {
            _log.severe("Client: " + ((L2GameClient)this.getClient()).toString() + " - Failed reading: " + this.getType() + " - L2J Server Version: " + Config.SERVER_VERSION + " - DP Revision: " + Config.DATAPACK_VERSION);
            e.printStackTrace();
            if (e instanceof BufferUnderflowException) {
                if (GameTimeController.getGameTicks() - ((L2GameClient)this.getClient()).underflowReadStartTick > 600) {
                    ((L2GameClient)this.getClient()).underflowReadStartTick = GameTimeController.getGameTicks();
                    ((L2GameClient)this.getClient()).underflowReadsInMin = 1;
                } else {
                    ((L2GameClient)this.getClient()).underflowReadsInMin = (byte)(((L2GameClient)this.getClient()).underflowReadsInMin + 1);
                    if (((L2GameClient)this.getClient()).underflowReadsInMin > 1) {
                        ((L2GameClient)this.getClient()).closeNow();
                        _log.severe("Client " + ((L2GameClient)this.getClient()).toString() + " - Disconnected: Too many buffer underflow exceptions");
                    }
                }
            }
            return false;
        }
    }

    protected abstract void readImpl();

    public void run() {
        block7: {
            try {
                if (GameTimeController.getGameTicks() - ((L2GameClient)this.getClient()).packetsSentStartTick > 10) {
                    ((L2GameClient)this.getClient()).packetsSentStartTick = GameTimeController.getGameTicks();
                    ((L2GameClient)this.getClient()).packetsSentInSec = 0;
                } else {
                    ((L2GameClient)this.getClient()).packetsSentInSec = (byte)(((L2GameClient)this.getClient()).packetsSentInSec + 1);
                    if (((L2GameClient)this.getClient()).packetsSentInSec > 12) {
                        if (((L2GameClient)this.getClient()).packetsSentInSec < 100) {
                            this.sendPacket(ActionFailed.STATIC_PACKET);
                        }
                        return;
                    }
                }
                this.runImpl();
                if (this.triggersOnActionRequest() && ((L2GameClient)this.getClient()).getActiveChar() != null) {
                    ((L2GameClient)this.getClient()).getActiveChar().onActionRequest();
                }
                this.cleanUp();
            }
            catch (Throwable t) {
                _log.severe("Client: " + ((L2GameClient)this.getClient()).toString() + " - Failed running: " + this.getType() + " - L2J Server Version: " + Config.SERVER_VERSION + " - DP Revision: " + Config.DATAPACK_VERSION);
                t.printStackTrace();
                if (!(this instanceof EnterWorld)) break block7;
                ((L2GameClient)this.getClient()).closeNow();
            }
        }
    }

    protected abstract void runImpl();

    protected final void sendPacket(L2GameServerPacket gsp) {
        ((L2GameClient)this.getClient()).sendPacket(gsp);
    }

    public abstract String getType();

    protected boolean triggersOnActionRequest() {
        return false;
    }

    protected void cleanUp() {
    }
}

