/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.communityserver.writepackets;

import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javolution.util.FastList;
import org.netcon.BaseWritePacket;

public final class WorldInfo
extends BaseWritePacket {
    public static final byte TYPE_INIT_PACKET = 0;
    public static final byte TYPE_UPDATE_PLAYER_DATA = 1;
    public static final byte TYPE_UPDATE_PLAYER_STATUS = 2;
    public static final byte TYPE_UPDATE_CLAN_DATA = 3;
    public static final byte TYPE_SEND_CLAN_NOTICE = 4;
    private static Logger _log = Logger.getLogger(WorldInfo.class.getName());

    public WorldInfo(L2PcInstance player, L2Clan clan, byte type) {
        super.writeC(1);
        switch (type) {
            case 0: {
                super.writeC(0);
            }
            case 1: {
                super.writeC(1);
                super.writeC(0);
                super.writeD(player.getObjectId());
                super.writeS(player.getName());
                super.writeS(player.getAccountName());
                super.writeD(player.getLevel());
                super.writeD(player.getClanId());
                super.writeD(player.getAccessLevel().getLevel());
                super.writeC(player.isOnline());
                List<Integer> list = player.getFriendList();
                super.writeD(list.size());
                for (int j : list) {
                    super.writeD(j);
                }
                break;
            }
            case 2: {
                super.writeC(1);
                super.writeC(1);
                super.writeD(player.getObjectId());
                super.writeC(player.isOnline());
                break;
            }
            case 3: {
                super.writeC(2);
                super.writeD(clan.getClanId());
                super.writeS(clan.getName());
                super.writeD(clan.getLevel());
                super.writeD(clan.getLeader().getObjectId());
                super.writeS(clan.getLeader().getName());
                super.writeD(clan.getMembersCount());
                super.writeC(clan.isNoticeEnabled() ? 1 : 0);
                super.writeS(clan.getAllyName());
                FastList allyClanIdList = FastList.newInstance();
                if (clan.getAllyId() != 0) {
                    for (L2Clan c : ClanTable.getInstance().getClans()) {
                        if (clan.getAllyId() != c.getAllyId() || c == clan) continue;
                        allyClanIdList.add((Object)c.getClanId());
                    }
                }
                super.writeD(allyClanIdList.size());
                Iterator i$ = allyClanIdList.iterator();
                while (i$.hasNext()) {
                    int k = (Integer)i$.next();
                    super.writeD(k);
                }
                FastList.recycle((FastList)allyClanIdList);
                break;
            }
            case 4: {
                super.writeC(3);
                super.writeD(clan.getClanId());
                super.writeS(clan.getNotice());
            }
        }
    }
}

