/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills.effects;

import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.templates.effects.EffectTemplate;
import com.l2jserver.gameserver.templates.skills.L2EffectType;

public class EffectMpConsumePerLevel
extends L2Effect {
    public EffectMpConsumePerLevel(Env env, EffectTemplate template) {
        super(env, template);
    }

    @Override
    public L2EffectType getEffectType() {
        return L2EffectType.MP_CONSUME_PER_LEVEL;
    }

    @Override
    public boolean onActionTime() {
        if (this.getEffected().isDead()) {
            return false;
        }
        double base = this.calc();
        double consume = (double)(this.getEffected().getLevel() - 1) / 7.5 * base * (double)this.getPeriod();
        if (consume > this.getEffected().getCurrentMp()) {
            this.getEffected().sendPacket(new SystemMessage(SystemMessageId.SKILL_REMOVED_DUE_LACK_MP));
            return false;
        }
        this.getEffected().reduceCurrentMp(consume);
        return true;
    }
}

