/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.templates.item;

import com.l2jserver.gameserver.skills.SkillHolder;
import com.l2jserver.gameserver.templates.StatsSet;
import com.l2jserver.gameserver.templates.item.L2EtcItemType;
import com.l2jserver.gameserver.templates.item.L2Item;
import com.l2jserver.util.StringUtil;

public final class L2EtcItem
extends L2Item {
    private final String _handler;
    private SkillHolder[] _skillHolder;
    private int _sharedReuseGroup;

    public L2EtcItem(L2EtcItemType type, StatsSet set) {
        super(type, set);
        String[] skills = set.getString("skill").split(";");
        this._skillHolder = new SkillHolder[skills.length];
        int iterator = 0;
        for (String st : skills) {
            String[] info = st.split("-");
            if (info == null || info.length != 2) continue;
            int id = 0;
            int level = 0;
            try {
                id = Integer.parseInt(info[0]);
                level = Integer.parseInt(info[1]);
            }
            catch (Exception nfe) {
                _log.info(StringUtil.concat("> Couldnt parse ", st, " in etcitem skills!"));
                continue;
            }
            if (id <= 0 || level <= 0) continue;
            this._skillHolder[iterator] = new SkillHolder(id, level);
            iterator = (byte)(iterator + 1);
        }
        this._handler = set.getString("handler").intern();
        this._sharedReuseGroup = set.getInteger("shared_reuse_group", -1);
    }

    @Override
    public L2EtcItemType getItemType() {
        return (L2EtcItemType)this._type;
    }

    @Override
    public final boolean isConsumable() {
        return this.getItemType() == L2EtcItemType.SHOT || this.getItemType() == L2EtcItemType.POTION;
    }

    @Override
    public int getItemMask() {
        return this.getItemType().mask();
    }

    public SkillHolder[] getSkills() {
        return this._skillHolder;
    }

    public String getHandlerName() {
        return this._handler;
    }

    public int getSharedReuseGroup() {
        return this._sharedReuseGroup;
    }
}

