/*
 * Decompiled with CFR 0.152.
 */
package javolution.xml;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javolution.lang.ClassInitializer;
import javolution.lang.Reflection;
import javolution.text.CharArray;
import javolution.text.TextBuilder;
import javolution.text.TextFormat;
import javolution.util.FastMap;
import javolution.xml.QName;
import javolution.xml.XMLBinding;
import javolution.xml.XMLReferenceResolver;
import javolution.xml.sax.Attributes;
import javolution.xml.stream.XMLStreamException;
import javolution.xml.stream.XMLStreamReader;
import javolution.xml.stream.XMLStreamReaderImpl;
import javolution.xml.stream.XMLStreamWriter;
import javolution.xml.stream.XMLStreamWriterImpl;

public abstract class XMLFormat<T> {
    private static final String NULL = "Null";
    private static final FastMap CLASS_TO_FORMAT = new FastMap().shared();
    private final Class<T> _class;
    static final XMLFormat OBJECT_XML = new XMLFormat(Object.class){

        @Override
        public boolean isReferenceable() {
            return false;
        }

        public Object newInstance(Class cls, InputElement xml) throws XMLStreamException {
            TextFormat format = TextFormat.getInstance(cls);
            if (!format.isParsingSupported()) {
                throw new XMLStreamException("No XMLFormat or TextFormat (with parsing supported) for instances of " + cls);
            }
            CharArray value = xml.getAttribute("value");
            if (value == null) {
                throw new XMLStreamException("Missing value attribute (to be able to parse the instance of " + cls + ")");
            }
            return format.parse(value);
        }

        public void read(InputElement xml, Object obj) throws XMLStreamException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(Object obj, OutputElement xml) throws XMLStreamException {
            TextBuilder tmp = TextBuilder.newInstance();
            try {
                TextFormat.getInstance(obj.getClass()).format(obj, tmp);
                xml.setAttribute("value", tmp);
            }
            finally {
                TextBuilder.recycle(tmp);
            }
        }
    };
    static final XMLFormat COLLECTION_XML = new XMLFormat(Collection.class){

        public void read(InputElement xml, Object obj) throws XMLStreamException {
            Collection collection = (Collection)obj;
            while (xml.hasNext()) {
                collection.add(xml.getNext());
            }
        }

        public void write(Object obj, OutputElement xml) throws XMLStreamException {
            Collection collection = (Collection)obj;
            Iterator i = collection.iterator();
            while (i.hasNext()) {
                xml.add(i.next());
            }
        }
    };
    static final XMLFormat MAP_XML = new XMLFormat(Map.class){

        public void read(InputElement xml, Object obj) throws XMLStreamException {
            Map map = (Map)obj;
            while (xml.hasNext()) {
                Object key = xml.get("Key");
                Object value = xml.get("Value");
                map.put(key, value);
            }
        }

        public void write(Object obj, OutputElement xml) throws XMLStreamException {
            Map map = (Map)obj;
            for (Map.Entry entry : map.entrySet()) {
                xml.add(entry.getKey(), "Key");
                xml.add(entry.getValue(), "Value");
            }
        }
    };

    protected XMLFormat(Class<T> cls) {
        this._class = cls;
        if (cls == null) {
            return;
        }
        if (CLASS_TO_FORMAT.containsKey(cls)) {
            throw new IllegalArgumentException("Existing static binding for class " + cls + " can only be overriden through custom XMLBinding" + " (see XMLFormat(Class) documentation)");
        }
        CLASS_TO_FORMAT.put(cls, this);
    }

    public static <T> XMLFormat<T> getInstance(Class<? extends T> forClass) {
        XMLFormat format = (XMLFormat)CLASS_TO_FORMAT.get(forClass);
        if (format != null) {
            return format;
        }
        ClassInitializer.initialize(forClass);
        return XMLFormat.searchDefaultFormat(forClass);
    }

    private static XMLFormat searchDefaultFormat(Class forClass) {
        XMLFormat format = (XMLFormat)CLASS_TO_FORMAT.get(forClass);
        if (format != null) {
            return format;
        }
        Class[] interfaces = Reflection.getInstance().getInterfaces(forClass);
        for (int i = 0; i < interfaces.length; ++i) {
            format = (XMLFormat)CLASS_TO_FORMAT.get(interfaces[i]);
            if (format == null) continue;
            return format;
        }
        Class parentClass = Reflection.getInstance().getSuperclass(forClass);
        return parentClass != null ? XMLFormat.searchDefaultFormat(parentClass) : OBJECT_XML;
    }

    public final Class<T> getBoundClass() {
        return this._class;
    }

    public boolean isReferenceable() {
        return true;
    }

    public T newInstance(Class<T> cls, InputElement xml) throws XMLStreamException {
        try {
            return cls.newInstance();
        }
        catch (InstantiationException e) {
            throw new XMLStreamException(e);
        }
        catch (IllegalAccessException e) {
            throw new XMLStreamException(e);
        }
    }

    public abstract void write(T var1, OutputElement var2) throws XMLStreamException;

    public abstract void read(InputElement var1, T var2) throws XMLStreamException;

    public String toString() {
        Class<T> boundClass = this.getBoundClass();
        return boundClass != null ? "Default XMLFormat for " + boundClass.getName() : "Dynamic XMLtFormat (" + this.hashCode() + ")";
    }

    private static CharSequence toCsq(Object str) {
        return QName.j2meToCharSeq(str);
    }

    public static final class OutputElement {
        final XMLStreamWriterImpl _writer = new XMLStreamWriterImpl();
        private XMLBinding _binding;
        private XMLReferenceResolver _referenceResolver;
        private TextBuilder _tmpTextBuilder = new TextBuilder();

        OutputElement() {
            this.reset();
        }

        public XMLStreamWriter getStreamWriter() {
            return this._writer;
        }

        public void add(Object obj) throws XMLStreamException {
            if (obj == null) {
                this._writer.writeEmptyElement(XMLFormat.toCsq(XMLFormat.NULL));
                return;
            }
            Class<?> cls = obj.getClass();
            this._binding.writeClass(obj.getClass(), this._writer, false);
            XMLFormat xmlFormat = this._binding.getFormat(cls);
            if (xmlFormat.isReferenceable() && this.writeReference(obj)) {
                return;
            }
            xmlFormat.write(obj, this);
            this._writer.writeEndElement();
        }

        public void add(Object obj, String name) throws XMLStreamException {
            if (obj == null) {
                return;
            }
            this._writer.writeStartElement(XMLFormat.toCsq(name));
            Class<?> cls = obj.getClass();
            this._binding.writeClass(cls, this._writer, true);
            XMLFormat xmlFormat = this._binding.getFormat(cls);
            if (xmlFormat.isReferenceable() && this.writeReference(obj)) {
                return;
            }
            xmlFormat.write(obj, this);
            this._writer.writeEndElement();
        }

        public void add(Object obj, String localName, String uri) throws XMLStreamException {
            if (obj == null) {
                return;
            }
            this._writer.writeStartElement(XMLFormat.toCsq(uri), XMLFormat.toCsq(localName));
            Class<?> cls = obj.getClass();
            this._binding.writeClass(cls, this._writer, true);
            XMLFormat xmlFormat = this._binding.getFormat(cls);
            if (xmlFormat.isReferenceable() && this.writeReference(obj)) {
                return;
            }
            xmlFormat.write(obj, this);
            this._writer.writeEndElement();
        }

        public <T> void add(T obj, String name, Class<T> cls) throws XMLStreamException {
            if (obj == null) {
                return;
            }
            this._writer.writeStartElement(XMLFormat.toCsq(name));
            XMLFormat xmlFormat = this._binding.getFormat(cls);
            if (xmlFormat.isReferenceable() && this.writeReference(obj)) {
                return;
            }
            xmlFormat.write(obj, this);
            this._writer.writeEndElement();
        }

        public <T> void add(T obj, String localName, String uri, Class<T> cls) throws XMLStreamException {
            if (obj == null) {
                return;
            }
            this._writer.writeStartElement(XMLFormat.toCsq(uri), XMLFormat.toCsq(localName));
            XMLFormat xmlFormat = this._binding.getFormat(cls);
            if (xmlFormat.isReferenceable() && this.writeReference(obj)) {
                return;
            }
            xmlFormat.write(obj, this);
            this._writer.writeEndElement();
        }

        private boolean writeReference(Object obj) throws XMLStreamException {
            if (this._referenceResolver == null || !this._referenceResolver.writeReference(obj, this)) {
                return false;
            }
            this._writer.writeEndElement();
            return true;
        }

        public void addText(CharSequence text) throws XMLStreamException {
            this._writer.writeCharacters(text);
        }

        public void addText(String text) throws XMLStreamException {
            this._writer.writeCharacters(XMLFormat.toCsq(text));
        }

        public void setAttribute(String name, CharSequence value) throws XMLStreamException {
            if (value == null) {
                return;
            }
            this._writer.writeAttribute(XMLFormat.toCsq(name), value);
        }

        public void setAttribute(String name, String value) throws XMLStreamException {
            if (value == null) {
                return;
            }
            this._writer.writeAttribute(XMLFormat.toCsq(name), XMLFormat.toCsq(value));
        }

        public void setAttribute(String name, boolean value) throws XMLStreamException {
            this.setAttribute(name, this._tmpTextBuilder.clear().append(value));
        }

        public void setAttribute(String name, char value) throws XMLStreamException {
            this.setAttribute(name, this._tmpTextBuilder.clear().append(value));
        }

        public void setAttribute(String name, byte value) throws XMLStreamException {
            this.setAttribute(name, this._tmpTextBuilder.clear().append(value));
        }

        public void setAttribute(String name, short value) throws XMLStreamException {
            this.setAttribute(name, this._tmpTextBuilder.clear().append(value));
        }

        public void setAttribute(String name, int value) throws XMLStreamException {
            this.setAttribute(name, this._tmpTextBuilder.clear().append(value));
        }

        public void setAttribute(String name, long value) throws XMLStreamException {
            this.setAttribute(name, this._tmpTextBuilder.clear().append(value));
        }

        public void setAttribute(String name, float value) throws XMLStreamException {
            this.setAttribute(name, this._tmpTextBuilder.clear().append(value));
        }

        public void setAttribute(String name, double value) throws XMLStreamException {
            this.setAttribute(name, this._tmpTextBuilder.clear().append(value));
        }

        public void setAttribute(String name, Object value) throws XMLStreamException {
            if (value == null) {
                return;
            }
            Class<?> type = value.getClass();
            TextFormat<?> format = TextFormat.getInstance(type);
            this.setAttribute(name, format.format(value, this._tmpTextBuilder.clear()));
        }

        void setBinding(XMLBinding xmlBinding) {
            this._binding = xmlBinding;
        }

        void setReferenceResolver(XMLReferenceResolver xmlReferenceResolver) {
            this._referenceResolver = xmlReferenceResolver;
        }

        void reset() {
            this._binding = XMLBinding.DEFAULT;
            this._writer.reset();
            this._writer.setRepairingNamespaces(true);
            this._writer.setAutomaticEmptyElements(true);
            this._referenceResolver = null;
        }
    }

    public static final class InputElement {
        final XMLStreamReaderImpl _reader = new XMLStreamReaderImpl();
        private XMLBinding _binding;
        private XMLReferenceResolver _referenceResolver;
        private boolean _isReaderAtNext;

        InputElement() {
            this.reset();
        }

        public XMLStreamReader getStreamReader() {
            return this._reader;
        }

        public boolean hasNext() throws XMLStreamException {
            if (!this._isReaderAtNext) {
                this._isReaderAtNext = true;
                this._reader.nextTag();
            }
            return this._reader.getEventType() == 1;
        }

        public <T> T getNext() throws XMLStreamException {
            if (!this.hasNext()) {
                throw new XMLStreamException("No more element to read", this._reader.getLocation());
            }
            if (this._reader.getLocalName().equals(XMLFormat.NULL)) {
                if (this._reader.next() != 2) {
                    throw new XMLStreamException("Non Empty Null Element");
                }
                this._isReaderAtNext = false;
                return null;
            }
            Object ref = this.readReference();
            if (ref != null) {
                return (T)ref;
            }
            Class cls = this._binding.readClass(this._reader, false);
            return (T)this.readInstanceOf(cls);
        }

        public <T> T get(String name) throws XMLStreamException {
            if (!this.hasNext() || !this._reader.getLocalName().equals(name)) {
                return null;
            }
            Object ref = this.readReference();
            if (ref != null) {
                return (T)ref;
            }
            Class cls = this._binding.readClass(this._reader, true);
            return (T)this.readInstanceOf(cls);
        }

        public <T> T get(String localName, String uri) throws XMLStreamException {
            if (uri == null) {
                return this.get(localName);
            }
            if (!(this.hasNext() && this._reader.getLocalName().equals(localName) && this._reader.getNamespaceURI().equals(uri))) {
                return null;
            }
            Object ref = this.readReference();
            if (ref != null) {
                return (T)ref;
            }
            Class cls = this._binding.readClass(this._reader, true);
            return (T)this.readInstanceOf(cls);
        }

        public <T> T get(String name, Class<T> cls) throws XMLStreamException {
            if (!this.hasNext() || !this._reader.getLocalName().equals(name)) {
                return null;
            }
            Object ref = this.readReference();
            if (ref != null) {
                return (T)ref;
            }
            return (T)this.readInstanceOf(cls);
        }

        public <T> T get(String localName, String uri, Class<T> cls) throws XMLStreamException {
            if (uri == null) {
                return this.get(localName, cls);
            }
            if (!(this.hasNext() && this._reader.getLocalName().equals(localName) && this._reader.getNamespaceURI().equals(uri))) {
                return null;
            }
            Object ref = this.readReference();
            if (ref != null) {
                return (T)ref;
            }
            return (T)this.readInstanceOf(cls);
        }

        private Object readReference() throws XMLStreamException {
            if (this._referenceResolver == null) {
                return null;
            }
            Object ref = this._referenceResolver.readReference(this);
            if (ref == null) {
                return null;
            }
            if (this._reader.next() != 2) {
                throw new XMLStreamException("Non Empty Reference Element");
            }
            this._isReaderAtNext = false;
            return ref;
        }

        private Object readInstanceOf(Class cls) throws XMLStreamException {
            XMLFormat xmlFormat = this._binding.getFormat(cls);
            this._isReaderAtNext = false;
            Object obj = xmlFormat.newInstance(cls, this);
            if (this._referenceResolver != null) {
                this._referenceResolver.createReference(obj, this);
            }
            xmlFormat.read(this, obj);
            if (this.hasNext()) {
                throw new XMLStreamException("Incomplete element reading", this._reader.getLocation());
            }
            this._isReaderAtNext = false;
            return obj;
        }

        public CharArray getText() throws XMLStreamException {
            CharArray txt = this._reader.getElementText();
            this._isReaderAtNext = true;
            return txt;
        }

        public Attributes getAttributes() throws XMLStreamException {
            if (this._isReaderAtNext) {
                throw new XMLStreamException("Attributes should be read before content");
            }
            return this._reader.getAttributes();
        }

        public CharArray getAttribute(String name) throws XMLStreamException {
            if (this._isReaderAtNext) {
                throw new XMLStreamException("Attributes should be read before reading content");
            }
            return this._reader.getAttributeValue(null, XMLFormat.toCsq(name));
        }

        public String getAttribute(String name, String defaultValue) throws XMLStreamException {
            CharArray value = this.getAttribute(name);
            return value != null ? value.toString() : defaultValue;
        }

        public boolean getAttribute(String name, boolean defaultValue) throws XMLStreamException {
            CharArray value = this.getAttribute(name);
            return value != null ? value.toBoolean() : defaultValue;
        }

        public char getAttribute(String name, char defaultValue) throws XMLStreamException {
            CharArray value = this.getAttribute(name);
            if (value == null) {
                return defaultValue;
            }
            if (value.length() != 1) {
                throw new XMLStreamException("Single character expected (read '" + value + "')");
            }
            return value.charAt(0);
        }

        public byte getAttribute(String name, byte defaultValue) throws XMLStreamException {
            CharArray value = this.getAttribute(name);
            return value != null ? (byte)value.toInt() : defaultValue;
        }

        public short getAttribute(String name, short defaultValue) throws XMLStreamException {
            CharArray value = this.getAttribute(name);
            return value != null ? (short)value.toInt() : defaultValue;
        }

        public int getAttribute(String name, int defaultValue) throws XMLStreamException {
            CharArray value = this.getAttribute(name);
            return value != null ? value.toInt() : defaultValue;
        }

        public long getAttribute(String name, long defaultValue) throws XMLStreamException {
            CharArray value = this.getAttribute(name);
            return value != null ? value.toLong() : defaultValue;
        }

        public float getAttribute(String name, float defaultValue) throws XMLStreamException {
            CharArray value = this.getAttribute(name);
            return value != null ? value.toFloat() : defaultValue;
        }

        public double getAttribute(String name, double defaultValue) throws XMLStreamException {
            CharArray value = this.getAttribute(name);
            return value != null ? value.toDouble() : defaultValue;
        }

        public <T> T getAttribute(String name, T defaultValue) throws XMLStreamException {
            CharArray value = this.getAttribute(name);
            if (value == null) {
                return defaultValue;
            }
            Class<?> type = defaultValue.getClass();
            TextFormat<?> format = TextFormat.getInstance(type);
            if (!format.isParsingSupported()) {
                throw new XMLStreamException("No TextFormat instance for " + type);
            }
            return (T)format.parse(value);
        }

        void setBinding(XMLBinding xmlBinding) {
            this._binding = xmlBinding;
        }

        void setReferenceResolver(XMLReferenceResolver xmlReferenceResolver) {
            this._referenceResolver = xmlReferenceResolver;
        }

        void reset() {
            this._binding = XMLBinding.DEFAULT;
            this._isReaderAtNext = false;
            this._reader.reset();
            this._referenceResolver = null;
        }
    }
}

