/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.Announcements;
import com.l2jserver.gameserver.GameServer;
import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.LoginServerThread;
import com.l2jserver.gameserver.SevenSigns;
import com.l2jserver.gameserver.SevenSignsFestival;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.TradeController;
import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.instancemanager.CastleManorManager;
import com.l2jserver.gameserver.instancemanager.CursedWeaponsManager;
import com.l2jserver.gameserver.instancemanager.GrandBossManager;
import com.l2jserver.gameserver.instancemanager.ItemsOnGroundManager;
import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.instancemanager.RaidBossSpawnManager;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.olympiad.Olympiad;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.communityserver.CommunityServerThread;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Broadcast;
import java.util.Collection;
import java.util.logging.Logger;

public class Shutdown
extends Thread {
    private static Logger _log = Logger.getLogger(Shutdown.class.getName());
    private static Shutdown _counterInstance = null;
    private int _secondsShut;
    private int _shutdownMode;
    public static final int SIGTERM = 0;
    public static final int GM_SHUTDOWN = 1;
    public static final int GM_RESTART = 2;
    public static final int ABORT = 3;
    private static final String[] MODE_TEXT = new String[]{"SIGTERM", "\u505c\u6b62", "\u518d\u8d77\u52d5", "\u53d6\u308a\u6d88\u3057"};

    private void SendServerQuit(int seconds) {
        SystemMessage sysm = new SystemMessage(SystemMessageId.THE_SERVER_WILL_BE_COMING_DOWN_IN_S1_SECONDS);
        sysm.addNumber(seconds);
        Broadcast.toAllOnlinePlayers(sysm);
    }

    public void startTelnetShutdown(String IP, int seconds, boolean restart) {
        _log.warning("IP: " + IP + " issued shutdown command. " + MODE_TEXT[this._shutdownMode] + " in " + seconds + " seconds!");
        this._shutdownMode = restart ? 2 : 1;
        if (this._shutdownMode > 0) {
            switch (seconds) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 10: 
                case 30: 
                case 60: 
                case 120: 
                case 180: 
                case 240: 
                case 300: 
                case 360: 
                case 420: 
                case 480: 
                case 540: {
                    break;
                }
                default: {
                    this.SendServerQuit(seconds);
                }
            }
        }
        if (_counterInstance != null) {
            _counterInstance._abort();
        }
        _counterInstance = new Shutdown(seconds, restart);
        _counterInstance.start();
    }

    public void telnetAbort(String IP) {
        _log.warning("IP: " + IP + " issued shutdown ABORT. " + MODE_TEXT[this._shutdownMode] + " has been stopped!");
        if (_counterInstance != null) {
            _counterInstance._abort();
            Announcements _an = Announcements.getInstance();
            _an.announceToAll("\u30b5\u30fc\u30d0" + MODE_TEXT[this._shutdownMode] + " \u306f\u53d6\u308a\u6d88\u3055\u308c\u307e\u3057\u305f\u3002\u5e73\u5e38\u3069\u304a\u308a\u7d9a\u884c\u3057\u307e\u3059\u3002");
        }
    }

    private Shutdown() {
        this._secondsShut = -1;
        this._shutdownMode = 0;
    }

    public Shutdown(int seconds, boolean restart) {
        if (seconds < 0) {
            seconds = 0;
        }
        this._secondsShut = seconds;
        this._shutdownMode = restart ? 2 : 1;
    }

    public static Shutdown getInstance() {
        return SingletonHolder._instance;
    }

    @Override
    public void run() {
        if (this == SingletonHolder._instance) {
            try {
                this.disconnectAllCharacters();
                _log.info("All players disconnected.");
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                GameTimeController.getInstance().stopTimer();
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                ThreadPoolManager.getInstance().shutdown();
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                CommunityServerThread.getInstance().interrupt();
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                LoginServerThread.getInstance().interrupt();
            }
            catch (Throwable t) {
                // empty catch block
            }
            this.saveData();
            try {
                GameServer.gameServer.getSelectorThread().shutdown();
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                L2DatabaseFactory.getInstance().shutdown();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (SingletonHolder._instance._shutdownMode == 2) {
                Runtime.getRuntime().halt(2);
            } else {
                Runtime.getRuntime().halt(0);
            }
        } else {
            this.countdown();
            _log.warning("GM shutdown countdown is over. " + MODE_TEXT[this._shutdownMode] + " NOW!");
            switch (this._shutdownMode) {
                case 1: {
                    SingletonHolder._instance.setMode(1);
                    System.exit(0);
                    break;
                }
                case 2: {
                    SingletonHolder._instance.setMode(2);
                    System.exit(2);
                }
            }
        }
    }

    public void startShutdown(L2PcInstance activeChar, int seconds, boolean restart) {
        this._shutdownMode = restart ? 2 : 1;
        if (activeChar != null) {
            _log.warning("GM: " + activeChar.getName() + "(" + activeChar.getObjectId() + ") issued shutdown command. " + MODE_TEXT[this._shutdownMode] + " in " + seconds + " seconds!");
        } else {
            _log.warning("AutoRestartSystem issued shutdown command. " + MODE_TEXT[this._shutdownMode] + " in " + seconds + " seconds!");
        }
        if (this._shutdownMode > 0) {
            switch (seconds) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 10: 
                case 30: 
                case 60: 
                case 120: 
                case 180: 
                case 240: 
                case 300: 
                case 360: 
                case 420: 
                case 480: 
                case 540: {
                    break;
                }
                default: {
                    this.SendServerQuit(seconds);
                }
            }
        }
        if (_counterInstance != null) {
            _counterInstance._abort();
        }
        _counterInstance = new Shutdown(seconds, restart);
        _counterInstance.start();
    }

    public void abort(L2PcInstance activeChar) {
        _log.warning("GM: " + activeChar.getName() + "(" + activeChar.getObjectId() + ") issued shutdown ABORT. " + MODE_TEXT[this._shutdownMode] + " has been stopped!");
        if (_counterInstance != null) {
            _counterInstance._abort();
            Announcements _an = Announcements.getInstance();
            _an.announceToAll("\u30b5\u30fc\u30d0" + MODE_TEXT[this._shutdownMode] + " \u306f\u53d6\u308a\u6d88\u3055\u308c\u307e\u3057\u305f\u3002\u5e73\u5e38\u3069\u304a\u308a\u7d9a\u884c\u3057\u307e\u3059\u3002");
        }
    }

    private void setMode(int mode) {
        this._shutdownMode = mode;
    }

    private void _abort() {
        this._shutdownMode = 3;
    }

    private void countdown() {
        try {
            while (this._secondsShut > 0) {
                switch (this._secondsShut) {
                    case 540: {
                        this.SendServerQuit(540);
                        break;
                    }
                    case 480: {
                        this.SendServerQuit(480);
                        break;
                    }
                    case 420: {
                        this.SendServerQuit(420);
                        break;
                    }
                    case 360: {
                        this.SendServerQuit(360);
                        break;
                    }
                    case 300: {
                        this.SendServerQuit(300);
                        break;
                    }
                    case 240: {
                        this.SendServerQuit(240);
                        break;
                    }
                    case 180: {
                        this.SendServerQuit(180);
                        break;
                    }
                    case 120: {
                        this.SendServerQuit(120);
                        break;
                    }
                    case 60: {
                        LoginServerThread.getInstance().setServerStatus(4);
                        this.SendServerQuit(60);
                        break;
                    }
                    case 30: {
                        this.SendServerQuit(30);
                        break;
                    }
                    case 10: {
                        this.SendServerQuit(10);
                        break;
                    }
                    case 5: {
                        this.SendServerQuit(5);
                        break;
                    }
                    case 4: {
                        this.SendServerQuit(4);
                        break;
                    }
                    case 3: {
                        this.SendServerQuit(3);
                        break;
                    }
                    case 2: {
                        this.SendServerQuit(2);
                        break;
                    }
                    case 1: {
                        this.SendServerQuit(1);
                    }
                }
                --this._secondsShut;
                int delay = 1000;
                Thread.sleep(delay);
                if (this._shutdownMode != 3) continue;
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void saveData() {
        switch (this._shutdownMode) {
            case 0: {
                _log.info("SIGTERM received. Shutting down NOW!");
                break;
            }
            case 1: {
                _log.info("GM shutdown received. Shutting down NOW!");
                break;
            }
            case 2: {
                _log.info("GM restart received. Restarting NOW!");
            }
        }
        if (!SevenSigns.getInstance().isSealValidationPeriod()) {
            SevenSignsFestival.getInstance().saveFestivalData(false);
        }
        SevenSigns.getInstance().saveSevenSignsData();
        SevenSigns.getInstance().saveSevenSignsStatus();
        RaidBossSpawnManager.getInstance().cleanUp();
        _log.info("RaidBossSpawnManager: All raidboss info saved!!");
        GrandBossManager.getInstance().cleanUp();
        _log.info("GrandBossManager: All Grand Boss info saved!!");
        _log.info("TradeController saving data.. This action may take some minutes! Please wait until completed!");
        TradeController.getInstance().dataCountStore();
        _log.info("TradeController: All count Item Saved");
        Olympiad.getInstance().saveOlympiadStatus();
        _log.info("Olympiad System: Data saved!!");
        ClanTable.getInstance().storeClanScore();
        _log.info("Clan System: Data saved!!");
        CursedWeaponsManager.getInstance().saveData();
        CastleManorManager.getInstance().save();
        QuestManager.getInstance().save();
        if (Config.SAVE_DROPPED_ITEM) {
            ItemsOnGroundManager.getInstance().saveInDb();
            ItemsOnGroundManager.getInstance().cleanUp();
            _log.info("ItemsOnGroundManager: All items on ground saved!!");
        }
        try {
            int delay = 5000;
            Thread.sleep(delay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void disconnectAllCharacters() {
        Collection<L2PcInstance> pls = L2World.getInstance().getAllPlayers().values();
        for (L2PcInstance player : pls) {
            try {
                player.logout(false);
            }
            catch (Throwable t) {}
        }
    }

    private static class SingletonHolder {
        protected static final Shutdown _instance = new Shutdown();

        private SingletonHolder() {
        }
    }
}

