/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastMap;

public class CharNameTable {
    private static Logger _log = Logger.getLogger(CharNameTable.class.getName());
    private final Map<Integer, String> _chars = new FastMap();
    private final Map<Integer, Integer> _accessLevels = new FastMap();

    private CharNameTable() {
        if (Config.CACHE_CHAR_NAMES) {
            this.loadAll();
        }
    }

    public static CharNameTable getInstance() {
        return SingletonHolder._instance;
    }

    public final void addName(L2PcInstance player) {
        if (player != null) {
            this.addName(player.getObjectId(), player.getName());
            this._accessLevels.put(player.getObjectId(), player.getAccessLevel().getLevel());
        }
    }

    private final void addName(int objId, String name) {
        if (name != null && !name.equalsIgnoreCase(this._chars.get(objId))) {
            this._chars.put(objId, name);
        }
    }

    public final void removeName(int objId) {
        this._chars.remove(objId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getIdByName(String name) {
        if (name == null || name.isEmpty()) {
            return -1;
        }
        for (Map.Entry<Integer, String> pair : this._chars.entrySet()) {
            if (!pair.getValue().equalsIgnoreCase(name)) continue;
            return pair.getKey();
        }
        if (Config.CACHE_CHAR_NAMES) {
            return -1;
        }
        int id = -1;
        int accessLevel = 0;
        Connection con = null;
        PreparedStatement statement = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            statement = con.prepareStatement("SELECT charId,accesslevel FROM characters WHERE char_name=?");
            statement.setString(1, name);
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                id = rset.getInt(1);
                accessLevel = rset.getInt(2);
            }
            rset.close();
            statement.close();
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "Could not check existing char name: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        if (id > 0) {
            this._chars.put(id, name);
            this._accessLevels.put(id, accessLevel);
            return id;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getNameById(int id) {
        if (id <= 0) {
            return null;
        }
        String name = this._chars.get(id);
        if (name != null) {
            return name;
        }
        if (Config.CACHE_CHAR_NAMES) {
            return null;
        }
        int accessLevel = 0;
        Connection con = null;
        PreparedStatement statement = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            statement = con.prepareStatement("SELECT char_name,accesslevel FROM characters WHERE charId=?");
            statement.setInt(1, id);
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                name = rset.getString(1);
                accessLevel = rset.getInt(2);
            }
            rset.close();
            statement.close();
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "Could not check existing char id: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        if (name != null && !name.isEmpty()) {
            this._chars.put(id, name);
            this._accessLevels.put(id, accessLevel);
            return name;
        }
        return null;
    }

    public final int getAccessLevelById(int objectId) {
        if (this.getNameById(objectId) != null) {
            return this._accessLevels.get(objectId);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean doesCharNameExist(String name) {
        boolean result = true;
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT account_name FROM characters WHERE char_name=?");
            statement.setString(1, name);
            ResultSet rset = statement.executeQuery();
            result = rset.next();
            rset.close();
            statement.close();
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "Could not check existing charname: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int accountCharNumber(String account) {
        Connection con = null;
        int number = 0;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT COUNT(char_name) FROM characters WHERE account_name=?");
            statement.setString(1, account);
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                number = rset.getInt(1);
            }
            rset.close();
            statement.close();
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "Could not check existing char number: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        return number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAll() {
        int id = -1;
        int accessLevel = 0;
        PreparedStatement statement = null;
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            statement = con.prepareStatement("SELECT charId,char_name,accesslevel FROM characters");
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                id = rset.getInt(1);
                String name = rset.getString(2);
                accessLevel = rset.getInt(3);
                this._chars.put(id, name);
                this._accessLevels.put(id, accessLevel);
            }
            rset.close();
            statement.close();
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "Could not load char name: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    private static class SingletonHolder {
        protected static final CharNameTable _instance = new CharNameTable();

        private SingletonHolder() {
        }
    }
}

