/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.model.L2EnchantSkillGroup;
import com.l2jserver.gameserver.model.L2EnchantSkillLearn;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import gnu.trove.TIntObjectHashMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EnchantGroupsTable {
    public static final int NORMAL_ENCHANT_COST_MULTIPLIER = 1;
    public static final int SAFE_ENCHANT_COST_MULTIPLIER = 5;
    public static final int NORMAL_ENCHANT_BOOK = 6622;
    public static final int SAFE_ENCHANT_BOOK = 9627;
    public static final int CHANGE_ENCHANT_BOOK = 9626;
    public static final int UNTRAIN_ENCHANT_BOOK = 9625;
    private static Logger _log = Logger.getLogger(EnchantGroupsTable.class.getName());
    private TIntObjectHashMap<L2EnchantSkillGroup> _enchantSkillGroups;
    private TIntObjectHashMap<L2EnchantSkillLearn> _enchantSkillTrees;

    public static EnchantGroupsTable getInstance() {
        return SingletonHolder._instance;
    }

    private EnchantGroupsTable() {
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        int count = 0;
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            try {
                this._enchantSkillGroups = new TIntObjectHashMap();
                this._enchantSkillTrees = new TIntObjectHashMap();
                PreparedStatement statement = con.prepareStatement("SELECT group_id, level, adena, exp, sp, success_rate76, success_rate77, success_rate78, success_rate79, success_rate80, success_rate81, success_rate82, success_rate83, success_rate84, success_rate85 FROM enchant_skill_groups ORDER BY group_id, level");
                ResultSet enchantGroups = statement.executeQuery();
                int prevGroupId = -1;
                while (enchantGroups.next()) {
                    L2EnchantSkillGroup group;
                    int id = enchantGroups.getInt("group_id");
                    int lvl = enchantGroups.getInt("level");
                    int adena = enchantGroups.getInt("adena");
                    int exp = enchantGroups.getInt("exp");
                    int sp = enchantGroups.getInt("sp");
                    byte rate76 = enchantGroups.getByte("success_rate76");
                    byte rate77 = enchantGroups.getByte("success_rate77");
                    byte rate78 = enchantGroups.getByte("success_rate78");
                    byte rate79 = enchantGroups.getByte("success_rate79");
                    byte rate80 = enchantGroups.getByte("success_rate80");
                    byte rate81 = enchantGroups.getByte("success_rate81");
                    byte rate82 = enchantGroups.getByte("success_rate82");
                    byte rate83 = enchantGroups.getByte("success_rate83");
                    byte rate84 = enchantGroups.getByte("success_rate84");
                    byte rate85 = enchantGroups.getByte("success_rate85");
                    if (prevGroupId != id) {
                        prevGroupId = id;
                    }
                    if ((group = (L2EnchantSkillGroup)this._enchantSkillGroups.get(id)) == null) {
                        group = new L2EnchantSkillGroup(id);
                        this._enchantSkillGroups.put(id, (Object)group);
                        ++count;
                    }
                    L2EnchantSkillGroup.EnchantSkillDetail esd = new L2EnchantSkillGroup.EnchantSkillDetail(lvl, adena, exp, sp, rate76, rate77, rate78, rate79, rate80, rate81, rate82, rate83, rate84, rate85);
                    group.addEnchantDetail(esd);
                }
                enchantGroups.close();
                statement.close();
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Error while loading enchant skill groups ", e);
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error while loading enchant skill groups ", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        _log.info("EnchantGroupsTable: Loaded " + count + " groups.");
    }

    public int addNewRouteForSkill(int skillId, int maxLvL, int route, int group) {
        L2EnchantSkillLearn enchantableSkill = (L2EnchantSkillLearn)this._enchantSkillTrees.get(skillId);
        if (enchantableSkill == null) {
            enchantableSkill = new L2EnchantSkillLearn(skillId, maxLvL);
            this._enchantSkillTrees.put(skillId, (Object)enchantableSkill);
        }
        if (this._enchantSkillGroups.containsKey(group)) {
            enchantableSkill.addNewEnchantRoute(route, group);
            return ((L2EnchantSkillGroup)this._enchantSkillGroups.get(group)).getEnchantGroupDetails().size();
        }
        _log.log(Level.SEVERE, "Error while loading generating enchant skill id: " + skillId + "; route: " + route + "; missing group: " + group);
        return 0;
    }

    public L2EnchantSkillLearn getSkillEnchantmentForSkill(L2Skill skill) {
        L2EnchantSkillLearn esl = this.getSkillEnchantmentBySkillId(skill.getId());
        if (esl != null && skill.getLevel() >= esl.getBaseLevel()) {
            return esl;
        }
        return null;
    }

    public L2EnchantSkillLearn getSkillEnchantmentBySkillId(int skillId) {
        return (L2EnchantSkillLearn)this._enchantSkillTrees.get(skillId);
    }

    public int getEnchantSkillSpCost(L2Skill skill) {
        L2EnchantSkillGroup.EnchantSkillDetail esd;
        L2EnchantSkillLearn enchantSkillLearn = (L2EnchantSkillLearn)this._enchantSkillTrees.get(skill.getId());
        if (enchantSkillLearn != null && (esd = enchantSkillLearn.getEnchantSkillDetail(skill.getLevel())) != null) {
            return esd.getSpCost();
        }
        return Integer.MAX_VALUE;
    }

    public int getEnchantSkillAdenaCost(L2Skill skill) {
        L2EnchantSkillGroup.EnchantSkillDetail esd;
        L2EnchantSkillLearn enchantSkillLearn = (L2EnchantSkillLearn)this._enchantSkillTrees.get(skill.getId());
        if (enchantSkillLearn != null && (esd = enchantSkillLearn.getEnchantSkillDetail(skill.getLevel())) != null) {
            return esd.getAdenaCost();
        }
        return Integer.MAX_VALUE;
    }

    public byte getEnchantSkillRate(L2PcInstance player, L2Skill skill) {
        L2EnchantSkillGroup.EnchantSkillDetail esd;
        L2EnchantSkillLearn enchantSkillLearn = (L2EnchantSkillLearn)this._enchantSkillTrees.get(skill.getId());
        if (enchantSkillLearn != null && (esd = enchantSkillLearn.getEnchantSkillDetail(skill.getLevel())) != null) {
            return esd.getRate(player);
        }
        return 0;
    }

    public L2EnchantSkillGroup getEnchantSkillGroupById(int id) {
        return (L2EnchantSkillGroup)this._enchantSkillGroups.get(id);
    }

    public void reload() {
        this.load();
    }

    private static class SingletonHolder {
        protected static final EnchantGroupsTable _instance = new EnchantGroupsTable();

        private SingletonHolder() {
        }
    }
}

