/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.actor.instance.L2AirShipControllerInstance;
import com.l2jserver.gameserver.model.actor.instance.L2AirShipInstance;
import com.l2jserver.gameserver.templates.StatsSet;
import com.l2jserver.gameserver.templates.chars.L2CharTemplate;
import java.util.ArrayList;
import javolution.util.FastMap;

public class AirShipManager {
    private L2CharTemplate _airShipTemplate = null;
    private FastMap<Integer, L2AirShipInstance> _airShips = new FastMap();
    private ArrayList<L2AirShipControllerInstance> _atcs = new ArrayList(2);

    public static final AirShipManager getInstance() {
        return SingletonHolder._instance;
    }

    private AirShipManager() {
        StatsSet npcDat = new StatsSet();
        npcDat.set("npcId", 9);
        npcDat.set("level", 0);
        npcDat.set("jClass", "boat");
        npcDat.set("baseSTR", 0);
        npcDat.set("baseCON", 0);
        npcDat.set("baseDEX", 0);
        npcDat.set("baseINT", 0);
        npcDat.set("baseWIT", 0);
        npcDat.set("baseMEN", 0);
        npcDat.set("baseShldDef", 0);
        npcDat.set("baseShldRate", 0);
        npcDat.set("baseAccCombat", 38);
        npcDat.set("baseEvasRate", 38);
        npcDat.set("baseCritRate", 38);
        npcDat.set("collision_radius", 0);
        npcDat.set("collision_height", 0);
        npcDat.set("sex", "male");
        npcDat.set("type", "");
        npcDat.set("baseAtkRange", 0);
        npcDat.set("baseMpMax", 0);
        npcDat.set("baseCpMax", 0);
        npcDat.set("rewardExp", 0);
        npcDat.set("rewardSp", 0);
        npcDat.set("basePAtk", 0);
        npcDat.set("baseMAtk", 0);
        npcDat.set("basePAtkSpd", 0);
        npcDat.set("aggroRange", 0);
        npcDat.set("baseMAtkSpd", 0);
        npcDat.set("rhand", 0);
        npcDat.set("lhand", 0);
        npcDat.set("armor", 0);
        npcDat.set("baseWalkSpd", 0);
        npcDat.set("baseRunSpd", 0);
        npcDat.set("name", "AirShip");
        npcDat.set("baseHpMax", 50000);
        npcDat.set("baseHpReg", 0.003f);
        npcDat.set("baseMpReg", 0.003f);
        npcDat.set("basePDef", 100);
        npcDat.set("baseMDef", 100);
        this._airShipTemplate = new L2CharTemplate(npcDat);
    }

    public L2AirShipInstance getAirShip(int objectId) {
        return (L2AirShipInstance)this._airShips.get((Object)objectId);
    }

    public L2AirShipInstance getNewAirShip(int x, int y, int z, int heading) {
        L2AirShipInstance airShip = new L2AirShipInstance(IdFactory.getInstance().getNextId(), this._airShipTemplate);
        this._airShips.put((Object)airShip.getObjectId(), (Object)airShip);
        airShip.setHeading(heading);
        airShip.setXYZInvisible(x, y, z);
        airShip.spawnMe();
        return airShip;
    }

    public void registerATC(L2AirShipControllerInstance atc) {
        this._atcs.add(atc);
    }

    public ArrayList<L2AirShipControllerInstance> getATCs() {
        return this._atcs;
    }

    public L2AirShipControllerInstance getNearestATC(L2AirShipInstance ship, int radius) {
        if (this._atcs == null || this._atcs.isEmpty()) {
            return null;
        }
        for (L2AirShipControllerInstance atc : this._atcs) {
            if (atc == null || !atc.isInsideRadius(ship, radius, true, false)) continue;
            return atc;
        }
        return null;
    }

    private static class SingletonHolder {
        protected static final AirShipManager _instance = new AirShipManager();

        private SingletonHolder() {
        }
    }
}

