/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager.grandbosses;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlEvent;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.datatables.DoorTable;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.instancemanager.grandbosses.BossLair;
import com.l2jserver.gameserver.model.L2CharPosition;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2GrandBossInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.GrandBossState;
import com.l2jserver.gameserver.network.serverpackets.ExShowScreenMessage;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.templates.skills.L2EffectType;
import com.l2jserver.gameserver.util.Broadcast;
import com.l2jserver.util.Rnd;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import javolution.util.FastList;
import javolution.util.FastMap;

public class VanHalterManager
extends BossLair {
    static final int INTERVAL_OF_HALTER_ALIVE = 1200000;
    protected static final int _bossId = 29062;
    protected static final int DUMMY_CAMERA_MARKER = 29059;
    protected Map<Integer, List<L2PcInstance>> _bleedingPlayers = new FastMap();
    protected Map<Integer, L2Spawn> _monsterSpawn = new FastMap();
    protected List<L2Spawn> _royalGuardSpawn = new FastList();
    protected List<L2Spawn> _royalGuardCaptainSpawn = new FastList();
    protected List<L2Spawn> _royalGuardHelperSpawn = new FastList();
    protected List<L2Spawn> _triolRevelationSpawn = new FastList();
    protected List<L2Spawn> _triolRevelationAlive = new FastList();
    protected List<L2Spawn> _guardOfAltarSpawn = new FastList();
    protected Map<Integer, L2Spawn> _cameraMarkerSpawn = new FastMap();
    protected L2Spawn _ritualOfferingSpawn = null;
    protected L2Spawn _ritualSacrificeSpawn = null;
    protected L2Spawn _vanHalterSpawn = null;
    protected List<L2Npc> _monsters = new FastList();
    protected List<L2Npc> _royalGuard = new FastList();
    protected List<L2Npc> _royalGuardCaptain = new FastList();
    protected List<L2Npc> _royalGuardHepler = new FastList();
    protected List<L2Npc> _triolRevelation = new FastList();
    protected List<L2Npc> _guardOfAltar = new FastList();
    protected Map<Integer, L2Npc> _cameraMarker = new FastMap();
    protected List<L2DoorInstance> _doorOfAltar = new FastList();
    protected List<L2DoorInstance> _doorOfSacrifice = new FastList();
    protected L2Npc _ritualOffering = null;
    protected L2Npc _ritualSacrifice = null;
    protected L2GrandBossInstance _vanHalter = null;
    protected ScheduledFuture<?> _movieTask = null;
    protected ScheduledFuture<?> _closeDoorOfAltarTask = null;
    protected ScheduledFuture<?> _openDoorOfAltarTask = null;
    protected ScheduledFuture<?> _lockUpDoorOfAltarTask = null;
    protected ScheduledFuture<?> _callRoyalGuardHelperTask = null;
    protected ScheduledFuture<?> _timeUpTask = null;
    protected ScheduledFuture<?> _intervalTask = null;
    protected ScheduledFuture<?> _halterEscapeTask = null;
    protected ScheduledFuture<?> _setBleedTask = null;
    boolean _isLocked = false;
    boolean _isHalterSpawned = false;
    boolean _isSacrificeSpawned = false;
    boolean _isCaptainSpawned = false;
    boolean _isHelperCalled = false;
    L2Npc _teleportCube0;
    L2Npc _teleportCube1;

    public static VanHalterManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private VanHalterManager() {
        this._state = new GrandBossState(29062);
        if (this.registerZone(-16397, -53308, -10448) == null) {
            _log.warning("VanHalterManager : Failed to load zone 'Altar of Sacrifice'");
        }
    }

    @Override
    public void setUnspawn() {
        this.banishForeigners();
        if (this._isCaptainSpawned) {
            this.enterInterval();
        }
    }

    @Override
    public void init() {
        this._isLocked = false;
        this._isCaptainSpawned = false;
        this._isHelperCalled = false;
        this._isHalterSpawned = false;
        this._doorOfAltar.add(DoorTable.getInstance().getDoor(19160014));
        this._doorOfAltar.add(DoorTable.getInstance().getDoor(19160015));
        this.openDoorOfAltar(true);
        this._doorOfSacrifice.add(DoorTable.getInstance().getDoor(19160016));
        this._doorOfSacrifice.add(DoorTable.getInstance().getDoor(19160017));
        this.closeDoorOfSacrifice();
        this.loadRoyalGuard();
        this.loadTriolRevelation();
        this.loadRoyalGuardCaptain();
        this.loadRoyalGuardHelper();
        this.loadGuardOfAltar();
        this.loadVanHalter();
        this.loadRitualOffering();
        this.loadRitualSacrifice();
        this.spawnRoyalGuard();
        this.spawnTriolRevelation();
        this.spawnVanHalter();
        this.spawnRitualOffering();
        this._cameraMarkerSpawn.clear();
        try {
            L2NpcTemplate template1 = NpcTable.getInstance().getTemplate(29059);
            L2Spawn tempSpawn = new L2Spawn(template1);
            tempSpawn.setLocx(-16397);
            tempSpawn.setLocy(-55200);
            tempSpawn.setLocz(-10449);
            tempSpawn.setHeading(16384);
            tempSpawn.setAmount(1);
            tempSpawn.stopRespawn();
            this._cameraMarkerSpawn.put(1, tempSpawn);
            tempSpawn = new L2Spawn(template1);
            tempSpawn.setLocx(-16397);
            tempSpawn.setLocy(-55200);
            tempSpawn.setLocz(-10051);
            tempSpawn.setHeading(16384);
            tempSpawn.setAmount(1);
            tempSpawn.stopRespawn();
            this._cameraMarkerSpawn.put(2, tempSpawn);
            tempSpawn = new L2Spawn(template1);
            tempSpawn.setLocx(-16397);
            tempSpawn.setLocy(-55200);
            tempSpawn.setLocz(-9741);
            tempSpawn.setHeading(16384);
            tempSpawn.setAmount(1);
            tempSpawn.stopRespawn();
            this._cameraMarkerSpawn.put(3, tempSpawn);
            tempSpawn = new L2Spawn(template1);
            tempSpawn.setLocx(-16397);
            tempSpawn.setLocy(-55200);
            tempSpawn.setLocz(-9394);
            tempSpawn.setHeading(16384);
            tempSpawn.setAmount(1);
            tempSpawn.stopRespawn();
            this._cameraMarkerSpawn.put(4, tempSpawn);
            tempSpawn = new L2Spawn(template1);
            tempSpawn.setLocx(-16397);
            tempSpawn.setLocy(-55197);
            tempSpawn.setLocz(-8739);
            tempSpawn.setHeading(16384);
            tempSpawn.setAmount(1);
            tempSpawn.stopRespawn();
            this._cameraMarkerSpawn.put(5, tempSpawn);
        }
        catch (Exception e) {
            _log.warning("VanHalterManager : " + e.getMessage());
        }
        _log.info("VanHalterManager : State of High Priestess van Halter is " + this._state.getStateName() + ".");
        if (this._state.getState() == 3) {
            this.enterInterval();
        } else {
            this._state.setState(0);
        }
        _log.info("VanHalterManager : init VanHalterManager.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadRoyalGuard() {
        this._royalGuardSpawn.clear();
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT id, count, npc_templateid, locx, locy, locz, heading, respawn_delay FROM vanhalter_spawnlist Where npc_templateid between ? and ? ORDER BY id");
            statement.setInt(1, 22175);
            statement.setInt(2, 22176);
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                L2NpcTemplate template1 = NpcTable.getInstance().getTemplate(rset.getInt("npc_templateid"));
                if (template1 != null) {
                    L2Spawn spawnDat = new L2Spawn(template1);
                    spawnDat.setAmount(rset.getInt("count"));
                    spawnDat.setLocx(rset.getInt("locx"));
                    spawnDat.setLocy(rset.getInt("locy"));
                    spawnDat.setLocz(rset.getInt("locz"));
                    spawnDat.setHeading(rset.getInt("heading"));
                    spawnDat.setRespawnDelay(rset.getInt("respawn_delay"));
                    this._royalGuardSpawn.add(spawnDat);
                    continue;
                }
                _log.warning("VanHalterManager.loadRoyalGuard: Data missing in NPC table for ID: " + rset.getInt("npc_templateid") + ".");
            }
            rset.close();
            statement.close();
            _log.info("VanHalterManager.loadRoyalGuard: Loaded " + this._royalGuardSpawn.size() + " Royal Guard spawn locations.");
        }
        catch (Exception e) {
            _log.warning("VanHalterManager.loadRoyalGuard: Spawn could not be initialized: " + e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    protected void spawnRoyalGuard() {
        if (this._royalGuard.size() != 0) {
            this.deleteRoyalGuard();
        }
        for (L2Spawn rgs : this._royalGuardSpawn) {
            rgs.startRespawn();
            this._royalGuard.add(rgs.doSpawn());
        }
    }

    protected void deleteRoyalGuard() {
        for (L2Npc rg : this._royalGuard) {
            rg.getSpawn().stopRespawn();
            rg.deleteMe();
        }
        this._royalGuard.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadTriolRevelation() {
        this._triolRevelationSpawn.clear();
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT id, count, npc_templateid, locx, locy, locz, heading, respawn_delay FROM vanhalter_spawnlist Where npc_templateid between ? and ? ORDER BY id");
            statement.setInt(1, 32058);
            statement.setInt(2, 32068);
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                L2NpcTemplate template1 = NpcTable.getInstance().getTemplate(rset.getInt("npc_templateid"));
                if (template1 != null) {
                    L2Spawn spawnDat = new L2Spawn(template1);
                    spawnDat.setAmount(rset.getInt("count"));
                    spawnDat.setLocx(rset.getInt("locx"));
                    spawnDat.setLocy(rset.getInt("locy"));
                    spawnDat.setLocz(rset.getInt("locz"));
                    spawnDat.setHeading(rset.getInt("heading"));
                    spawnDat.setRespawnDelay(rset.getInt("respawn_delay"));
                    this._triolRevelationSpawn.add(spawnDat);
                    continue;
                }
                _log.warning("VanHalterManager.loadTriolRevelation: Data missing in NPC table for ID: " + rset.getInt("npc_templateid") + ".");
            }
            rset.close();
            statement.close();
            _log.info("VanHalterManager.loadTriolRevelation: Loaded " + this._triolRevelationSpawn.size() + " Triol's Revelation spawn locations.");
        }
        catch (Exception e) {
            _log.warning("VanHalterManager.loadTriolRevelation: Spawn could not be initialized: " + e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    protected void spawnTriolRevelation() {
        if (this._triolRevelation.size() != 0) {
            this.deleteTriolRevelation();
        }
        for (L2Spawn trs : this._triolRevelationSpawn) {
            trs.startRespawn();
            this._triolRevelation.add(trs.doSpawn());
            if (trs.getNpcid() == 32067 || trs.getNpcid() == 32068) continue;
            this._triolRevelationAlive.add(trs);
        }
    }

    protected void deleteTriolRevelation() {
        for (L2Npc tr : this._triolRevelation) {
            tr.getSpawn().stopRespawn();
            tr.deleteMe();
        }
        this._triolRevelation.clear();
        this._bleedingPlayers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadRoyalGuardCaptain() {
        this._royalGuardCaptainSpawn.clear();
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT id, count, npc_templateid, locx, locy, locz, heading, respawn_delay FROM vanhalter_spawnlist Where npc_templateid = ? ORDER BY id");
            statement.setInt(1, 22188);
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                L2NpcTemplate template1 = NpcTable.getInstance().getTemplate(rset.getInt("npc_templateid"));
                if (template1 != null) {
                    L2Spawn spawnDat = new L2Spawn(template1);
                    spawnDat.setAmount(rset.getInt("count"));
                    spawnDat.setLocx(rset.getInt("locx"));
                    spawnDat.setLocy(rset.getInt("locy"));
                    spawnDat.setLocz(rset.getInt("locz"));
                    spawnDat.setHeading(rset.getInt("heading"));
                    spawnDat.setRespawnDelay(rset.getInt("respawn_delay"));
                    this._royalGuardCaptainSpawn.add(spawnDat);
                    continue;
                }
                _log.warning("VanHalterManager.loadRoyalGuardCaptain: Data missing in NPC table for ID: " + rset.getInt("npc_templateid") + ".");
            }
            rset.close();
            statement.close();
            _log.info("VanHalterManager.loadRoyalGuardCaptain: Loaded " + this._royalGuardCaptainSpawn.size() + " Royal Guard Captain spawn locations.");
        }
        catch (Exception e) {
            _log.warning("VanHalterManager.loadRoyalGuardCaptain: Spawn could not be initialized: " + e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    protected void spawnRoyalGuardCaptain() {
        if (this._royalGuardCaptain.size() != 0) {
            this.deleteRoyalGuardCaptain();
        }
        for (L2Spawn trs : this._royalGuardCaptainSpawn) {
            trs.startRespawn();
            this._royalGuardCaptain.add(trs.doSpawn());
        }
        this._isCaptainSpawned = true;
    }

    protected void deleteRoyalGuardCaptain() {
        for (L2Npc tr : this._royalGuardCaptain) {
            tr.getSpawn().stopRespawn();
            tr.deleteMe();
        }
        this._royalGuardCaptain.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadRoyalGuardHelper() {
        this._royalGuardHelperSpawn.clear();
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT id, count, npc_templateid, locx, locy, locz, heading, respawn_delay FROM vanhalter_spawnlist Where npc_templateid = ? ORDER BY id");
            statement.setInt(1, 22191);
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                L2NpcTemplate template1 = NpcTable.getInstance().getTemplate(rset.getInt("npc_templateid"));
                if (template1 != null) {
                    L2Spawn spawnDat = new L2Spawn(template1);
                    spawnDat.setAmount(rset.getInt("count"));
                    spawnDat.setLocx(rset.getInt("locx"));
                    spawnDat.setLocy(rset.getInt("locy"));
                    spawnDat.setLocz(rset.getInt("locz"));
                    spawnDat.setHeading(rset.getInt("heading"));
                    spawnDat.setRespawnDelay(rset.getInt("respawn_delay"));
                    this._royalGuardHelperSpawn.add(spawnDat);
                    continue;
                }
                _log.warning("VanHalterManager.loadRoyalGuardHelper: Data missing in NPC table for ID: " + rset.getInt("npc_templateid") + ".");
            }
            rset.close();
            statement.close();
            _log.info("VanHalterManager.loadRoyalGuardHelper: Loaded " + this._royalGuardHelperSpawn.size() + " Royal Guard Helper spawn locations.");
        }
        catch (Exception e) {
            _log.warning("VanHalterManager.loadRoyalGuardHelper: Spawn could not be initialized: " + e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    protected void spawnRoyalGuardHepler() {
        for (L2Spawn trs : this._royalGuardHelperSpawn) {
            trs.startRespawn();
            this._royalGuardHepler.add(trs.doSpawn());
        }
    }

    protected void deleteRoyalGuardHepler() {
        for (L2Npc tr : this._royalGuardHepler) {
            tr.getSpawn().stopRespawn();
            tr.deleteMe();
        }
        this._royalGuardHepler.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadGuardOfAltar() {
        this._guardOfAltarSpawn.clear();
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT id, count, npc_templateid, locx, locy, locz, heading, respawn_delay FROM vanhalter_spawnlist Where npc_templateid = ? ORDER BY id");
            statement.setInt(1, 32051);
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                L2NpcTemplate template1 = NpcTable.getInstance().getTemplate(rset.getInt("npc_templateid"));
                if (template1 != null) {
                    L2Spawn spawnDat = new L2Spawn(template1);
                    spawnDat.setAmount(rset.getInt("count"));
                    spawnDat.setLocx(rset.getInt("locx"));
                    spawnDat.setLocy(rset.getInt("locy"));
                    spawnDat.setLocz(rset.getInt("locz"));
                    spawnDat.setHeading(rset.getInt("heading"));
                    spawnDat.setRespawnDelay(rset.getInt("respawn_delay"));
                    this._guardOfAltarSpawn.add(spawnDat);
                    continue;
                }
                _log.warning("VanHalterManager.loadGuardOfAltar: Data missing in NPC table for ID: " + rset.getInt("npc_templateid") + ".");
            }
            rset.close();
            statement.close();
            _log.info("VanHalterManager.loadGuardOfAltar: Loaded " + this._guardOfAltarSpawn.size() + " Guard Of Altar spawn locations.");
        }
        catch (Exception e) {
            _log.warning("VanHalterManager.loadGuardOfAltar: Spawn could not be initialized: " + e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    protected void spawnGuardOfAltar() {
        if (this._guardOfAltar.size() != 0) {
            this.deleteGuardOfAltar();
        }
        for (L2Spawn trs : this._guardOfAltarSpawn) {
            trs.startRespawn();
            this._guardOfAltar.add(trs.doSpawn());
        }
    }

    protected void deleteGuardOfAltar() {
        for (L2Npc tr : this._guardOfAltar) {
            tr.getSpawn().stopRespawn();
            tr.deleteMe();
        }
        this._guardOfAltar.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadVanHalter() {
        this._vanHalterSpawn = null;
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT id, count, npc_templateid, locx, locy, locz, heading, respawn_delay FROM vanhalter_spawnlist Where npc_templateid = ? ORDER BY id");
            statement.setInt(1, 29062);
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                L2NpcTemplate template1 = NpcTable.getInstance().getTemplate(rset.getInt("npc_templateid"));
                if (template1 != null) {
                    L2Spawn spawnDat = new L2Spawn(template1);
                    spawnDat.setAmount(rset.getInt("count"));
                    spawnDat.setLocx(rset.getInt("locx"));
                    spawnDat.setLocy(rset.getInt("locy"));
                    spawnDat.setLocz(rset.getInt("locz"));
                    spawnDat.setHeading(rset.getInt("heading"));
                    spawnDat.setRespawnDelay(rset.getInt("respawn_delay"));
                    this._vanHalterSpawn = spawnDat;
                    continue;
                }
                _log.warning("VanHalterManager.loadVanHalter: Data missing in NPC table for ID: " + rset.getInt("npc_templateid") + ".");
            }
            rset.close();
            statement.close();
            _log.info("VanHalterManager.loadVanHalter: Loaded High Priestess van Halter spawn locations.");
        }
        catch (Exception e) {
            _log.warning("VanHalterManager.loadVanHalter: Spawn could not be initialized: " + e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    protected void spawnVanHalter() {
        this._vanHalter = (L2GrandBossInstance)this._vanHalterSpawn.doSpawn();
        this._vanHalter.setIsImmobilized(true);
        this._vanHalter.setIsInvul(true);
        this._isHalterSpawned = true;
        Broadcast.announceToOnlinePlayers("\u90aa\u6559\u306e\u53f8\u796d\u9577 \u30a2\u30f3\u30c9\u30ec\u30a2\u30b9 \u30f4\u30a1\u30f3 \u30db\u30eb\u30bf\u30fc\u304c\u767b\u5834\u3057\u307e\u3057\u305f\u3002");
    }

    protected void deleteVanHalter() {
        if (this._vanHalter == null) {
            return;
        }
        this._vanHalter.setIsImmobilized(false);
        this._vanHalter.setIsInvul(false);
        this._vanHalter.getSpawn().stopRespawn();
        this._vanHalter.deleteMe();
        this._vanHalter = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadRitualOffering() {
        this._ritualOfferingSpawn = null;
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT id, count, npc_templateid, locx, locy, locz, heading, respawn_delay FROM vanhalter_spawnlist Where npc_templateid = ? ORDER BY id");
            statement.setInt(1, 32038);
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                L2NpcTemplate template1 = NpcTable.getInstance().getTemplate(rset.getInt("npc_templateid"));
                if (template1 != null) {
                    L2Spawn spawnDat = new L2Spawn(template1);
                    spawnDat.setAmount(rset.getInt("count"));
                    spawnDat.setLocx(rset.getInt("locx"));
                    spawnDat.setLocy(rset.getInt("locy"));
                    spawnDat.setLocz(rset.getInt("locz"));
                    spawnDat.setHeading(rset.getInt("heading"));
                    spawnDat.setRespawnDelay(rset.getInt("respawn_delay"));
                    this._ritualOfferingSpawn = spawnDat;
                    continue;
                }
                _log.warning("VanHalterManager.loadRitualOffering: Data missing in NPC table for ID: " + rset.getInt("npc_templateid") + ".");
            }
            rset.close();
            statement.close();
            _log.info("VanHalterManager.loadRitualOffering: Loaded Ritual Offering spawn locations.");
        }
        catch (Exception e) {
            _log.warning("VanHalterManager.loadRitualOffering: Spawn could not be initialized: " + e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    protected void spawnRitualOffering() {
        this._ritualOffering = this._ritualOfferingSpawn.doSpawn();
        this._ritualOffering.setIsImmobilized(true);
        this._ritualOffering.setIsInvul(true);
        this._ritualOffering.startParalyze();
    }

    protected void deleteRitualOffering() {
        if (this._ritualOffering == null) {
            return;
        }
        this._ritualOffering.setIsImmobilized(false);
        this._ritualOffering.setIsInvul(false);
        this._ritualOffering.setIsParalyzed(false);
        this._ritualOffering.getAI().notifyEvent(CtrlEvent.EVT_THINK, null);
        this._ritualOffering.getSpawn().stopRespawn();
        this._ritualOffering.deleteMe();
        this._ritualOffering = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadRitualSacrifice() {
        this._ritualSacrificeSpawn = null;
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT id, count, npc_templateid, locx, locy, locz, heading, respawn_delay FROM vanhalter_spawnlist Where npc_templateid = ? ORDER BY id");
            statement.setInt(1, 22195);
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                L2NpcTemplate template1 = NpcTable.getInstance().getTemplate(rset.getInt("npc_templateid"));
                if (template1 != null) {
                    L2Spawn spawnDat = new L2Spawn(template1);
                    spawnDat.setAmount(rset.getInt("count"));
                    spawnDat.setLocx(rset.getInt("locx"));
                    spawnDat.setLocy(rset.getInt("locy"));
                    spawnDat.setLocz(rset.getInt("locz"));
                    spawnDat.setHeading(rset.getInt("heading"));
                    spawnDat.setRespawnDelay(rset.getInt("respawn_delay"));
                    this._ritualSacrificeSpawn = spawnDat;
                    continue;
                }
                _log.warning("VanHalterManager.loadRitualSacrifice: Data missing in NPC table for ID: " + rset.getInt("npc_templateid") + ".");
            }
            rset.close();
            statement.close();
            _log.info("VanHalterManager.loadRitualSacrifice: Loaded Ritual Sacrifice spawn locations.");
        }
        catch (Exception e) {
            _log.warning("VanHalterManager.loadRitualSacrifice: Spawn could not be initialized: " + e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    protected void spawnRitualSacrifice() {
        this._ritualSacrifice = this._ritualSacrificeSpawn.doSpawn();
        this._ritualSacrifice.setIsImmobilized(true);
        this._ritualSacrifice.setIsInvul(true);
        this._isSacrificeSpawned = true;
    }

    protected void deleteRitualSacrifice() {
        if (!this._isSacrificeSpawned) {
            return;
        }
        if (this._ritualSacrifice == null) {
            return;
        }
        this._ritualSacrifice.getSpawn().stopRespawn();
        this._ritualSacrifice.deleteMe();
        this._isSacrificeSpawned = false;
        this._ritualSacrifice = null;
    }

    protected void spawnCameraMarker() {
        this._cameraMarker.clear();
        for (int i = 1; i <= this._cameraMarkerSpawn.size(); ++i) {
            L2Spawn spawn = this._cameraMarkerSpawn.get(i);
            L2Npc camera = spawn.doSpawn();
            this._cameraMarker.put(i, camera);
            spawn.stopRespawn();
            camera.setIsImmobilized(true);
        }
    }

    protected void deleteCameraMarker() {
        if (this._cameraMarker.isEmpty()) {
            return;
        }
        for (L2Npc camera : this._cameraMarker.values()) {
            camera.deleteMe();
        }
        this._cameraMarker.clear();
    }

    @Override
    public void onEnter(L2PcInstance player) {
        if (this._lockUpDoorOfAltarTask == null && !this._isLocked && this._isCaptainSpawned) {
            this._lockUpDoorOfAltarTask = ThreadPoolManager.getInstance().scheduleGeneral(new LockUpDoorOfAltar(), Config.HPH_TIMEOFLOCKUPDOOROFALTAR);
        }
    }

    protected void openDoorOfAltar(boolean loop) {
        for (L2DoorInstance door : this._doorOfAltar) {
            door.openMe();
        }
        if (loop) {
            this._isLocked = false;
            if (this._closeDoorOfAltarTask != null) {
                this._closeDoorOfAltarTask.cancel(false);
            }
            this._closeDoorOfAltarTask = null;
            this._closeDoorOfAltarTask = ThreadPoolManager.getInstance().scheduleGeneral(new CloseDoorOfAltar(), Config.HPH_INTERVALOFDOOROFALTER);
        } else {
            if (this._closeDoorOfAltarTask != null) {
                this._closeDoorOfAltarTask.cancel(false);
            }
            this._closeDoorOfAltarTask = null;
        }
    }

    protected void closeDoorOfAltar(boolean loop) {
        for (L2DoorInstance door : this._doorOfAltar) {
            door.closeMe();
        }
        if (loop) {
            if (this._openDoorOfAltarTask != null) {
                this._openDoorOfAltarTask.cancel(false);
            }
            this._openDoorOfAltarTask = null;
            this._openDoorOfAltarTask = ThreadPoolManager.getInstance().scheduleGeneral(new OpenDoorOfAltar(), Config.HPH_INTERVALOFDOOROFALTER);
        } else {
            if (this._openDoorOfAltarTask != null) {
                this._openDoorOfAltarTask.cancel(false);
            }
            this._openDoorOfAltarTask = null;
        }
    }

    protected void openDoorOfSacrifice() {
        for (L2DoorInstance door : this._doorOfSacrifice) {
            door.openMe();
        }
    }

    protected void closeDoorOfSacrifice() {
        for (L2DoorInstance door : this._doorOfSacrifice) {
            door.closeMe();
        }
    }

    public void checkTriolRevelationDestroy(L2Npc npc) {
        if (this._isCaptainSpawned) {
            return;
        }
        for (L2Spawn tra : this._triolRevelationAlive) {
            if (tra.getLastSpawn().isDead()) continue;
            return;
        }
        this.spawnRoyalGuardCaptain();
        npc.broadcastPacket(new ExShowScreenMessage("\u89aa\u885b\u968a\u9577\u304c\u51fa\u73fe\u3057\u307e\u3057\u305f", 10000));
    }

    public void checkRoyalGuardCaptainDestroy() {
        if (!this._isHalterSpawned) {
            return;
        }
        this.deleteRoyalGuard();
        this.deleteRoyalGuardCaptain();
        this.spawnGuardOfAltar();
        this.openDoorOfSacrifice();
        this.getZone().broadcastPacket(new ExShowScreenMessage("\u796d\u58c73\u968e\u306e\u6249\u304c\u958b\u304b\u308c\u307e\u3057\u305f", 10000));
        this._vanHalter.setIsImmobilized(true);
        this._vanHalter.setIsInvul(true);
        this.spawnCameraMarker();
        if (this._timeUpTask != null) {
            this._timeUpTask.cancel(false);
        }
        this._timeUpTask = null;
        this._movieTask = ThreadPoolManager.getInstance().scheduleGeneral(new Movie(1), Config.HPH_APPTIMEOFHALTER);
    }

    protected void combatBeginning() {
        if (this._timeUpTask != null) {
            this._timeUpTask.cancel(false);
        }
        this._timeUpTask = ThreadPoolManager.getInstance().scheduleGeneral(new TimeUp(), Config.HPH_FIGHTTIMEOFHALTER);
        FastMap _targets = new FastMap();
        int i = 0;
        for (L2PcInstance pc : this._vanHalter.getKnownList().getKnownPlayers().values()) {
            _targets.put(++i, pc);
        }
        this._vanHalter.reduceCurrentHp(1.0, (L2Character)_targets.get(Rnd.get(1, i)), null);
    }

    public void callRoyalGuardHelper() {
        if (!this._isHelperCalled) {
            this._isHelperCalled = true;
            this._halterEscapeTask = ThreadPoolManager.getInstance().scheduleGeneral(new HalterEscape(), 500L);
            this._callRoyalGuardHelperTask = ThreadPoolManager.getInstance().scheduleGeneral(new CallRoyalGuardHelper(), 1000L);
            this.getZone().broadcastPacket(new ExShowScreenMessage("\u89aa\u885b\u968a\u9577\u304c\u51fa\u73fe\u3057\u307e\u3057\u305f", 10000));
        }
    }

    protected void addBleeding() {
        boolean existPlayers = false;
        L2Skill bleed = SkillTable.getInstance().getInfo(4615, 12);
        for (L2Npc tr : this._triolRevelation) {
            if (tr.isDead() || !tr.isVisible() || tr.getKnownList().getKnownPlayers().size() == 0) continue;
            existPlayers = true;
            List seen = (List)tr.getKnownList().getKnownPlayersInRadius(tr.getAggroRange());
            if (seen.size() == 0) continue;
            for (L2PcInstance pc : seen) {
                if (pc.getFirstEffect(bleed) != null) continue;
                bleed.getEffects(tr, pc);
                tr.broadcastPacket(new MagicSkillUse(tr, pc, bleed.getId(), 12, bleed.getHitTime(), bleed.getReuseDelay()));
            }
            this._bleedingPlayers.put(tr.getNpcId(), seen);
        }
        if (!existPlayers && this._setBleedTask != null) {
            this._setBleedTask.cancel(false);
            this._setBleedTask = null;
        }
    }

    public void removeBleeding(int npcId) {
        List<L2PcInstance> list = this._bleedingPlayers.remove(npcId);
        if (list == null) {
            return;
        }
        for (L2PcInstance pc : list) {
            if (pc.getFirstEffect(L2EffectType.DMG_OVER_TIME) == null) continue;
            pc.stopEffects(L2EffectType.DMG_OVER_TIME);
        }
    }

    public synchronized void enableBleeding() {
        if (this._setBleedTask == null) {
            this._setBleedTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new Bleeding(), 2000L, 2000L);
        }
    }

    public void enterInterval() {
        boolean isHalterAllive;
        if (this._callRoyalGuardHelperTask != null) {
            this._callRoyalGuardHelperTask.cancel(false);
        }
        this._callRoyalGuardHelperTask = null;
        if (this._closeDoorOfAltarTask != null) {
            this._closeDoorOfAltarTask.cancel(false);
        }
        this._closeDoorOfAltarTask = null;
        if (this._halterEscapeTask != null) {
            this._halterEscapeTask.cancel(false);
        }
        this._halterEscapeTask = null;
        if (this._intervalTask != null) {
            this._intervalTask.cancel(false);
        }
        this._intervalTask = null;
        if (this._lockUpDoorOfAltarTask != null) {
            this._lockUpDoorOfAltarTask.cancel(false);
        }
        this._lockUpDoorOfAltarTask = null;
        if (this._movieTask != null) {
            this._movieTask.cancel(false);
        }
        this._movieTask = null;
        if (this._openDoorOfAltarTask != null) {
            this._openDoorOfAltarTask.cancel(false);
        }
        this._openDoorOfAltarTask = null;
        if (this._timeUpTask != null) {
            this._timeUpTask.cancel(false);
        }
        this._timeUpTask = null;
        boolean bl = isHalterAllive = this._vanHalter != null && !this._vanHalter.isDead();
        if (this._vanHalter != null && this._vanHalter.isDead()) {
            this._vanHalter.getSpawn().stopRespawn();
        } else {
            this.deleteVanHalter();
        }
        this.deleteRoyalGuardHepler();
        this.deleteRoyalGuardCaptain();
        this.deleteRoyalGuard();
        this.deleteRitualOffering();
        this.deleteRitualSacrifice();
        this.deleteGuardOfAltar();
        if (this._state.getState() != 3) {
            int interval = isHalterAllive ? Math.min(Config.HPH_FIXINTERVALOFHALTER, 1200000) : Config.HPH_FIXINTERVALOFHALTER + Rnd.get(Config.HPH_RANDOMINTERVALOFHALTER);
            this._state.setRespawnDate(interval);
            this._state.setState(3);
            this._state.update();
        }
        this._intervalTask = ThreadPoolManager.getInstance().scheduleGeneral(new Interval(), this._state.getInterval());
        _log.info("VanHalterManager : Interval START.");
        _log.info("VanHalterManager : Next spawn date of High Priestess van Halter is " + this._state.respawnTimeFormat() + ".");
    }

    public void setupAltar() {
        if (this._callRoyalGuardHelperTask != null) {
            this._callRoyalGuardHelperTask.cancel(false);
        }
        this._callRoyalGuardHelperTask = null;
        if (this._closeDoorOfAltarTask != null) {
            this._closeDoorOfAltarTask.cancel(false);
        }
        this._closeDoorOfAltarTask = null;
        if (this._halterEscapeTask != null) {
            this._halterEscapeTask.cancel(false);
        }
        this._halterEscapeTask = null;
        if (this._intervalTask != null) {
            this._intervalTask.cancel(false);
        }
        this._intervalTask = null;
        if (this._lockUpDoorOfAltarTask != null) {
            this._lockUpDoorOfAltarTask.cancel(false);
        }
        this._lockUpDoorOfAltarTask = null;
        if (this._movieTask != null) {
            this._movieTask.cancel(false);
        }
        this._movieTask = null;
        if (this._openDoorOfAltarTask != null) {
            this._openDoorOfAltarTask.cancel(false);
        }
        this._openDoorOfAltarTask = null;
        if (this._timeUpTask != null) {
            this._timeUpTask.cancel(false);
        }
        this._timeUpTask = null;
        for (L2PcInstance pc : this.getPlayersInside()) {
            pc.teleToLocation(-16397 + Rnd.get(-500, 500), -51050 + Rnd.get(-500, 500), -11017);
        }
        this.deleteVanHalter();
        this.deleteTriolRevelation();
        this.deleteRoyalGuardHepler();
        this.deleteRoyalGuardCaptain();
        this.deleteRoyalGuard();
        this.deleteRitualSacrifice();
        this.deleteRitualOffering();
        this.deleteGuardOfAltar();
        this.deleteCameraMarker();
        this._isLocked = false;
        this._isCaptainSpawned = false;
        this._isHelperCalled = false;
        this._isHalterSpawned = false;
        this.closeDoorOfSacrifice();
        this.openDoorOfAltar(true);
        this.spawnTriolRevelation();
        this.spawnRoyalGuard();
        this.spawnRitualOffering();
        this.spawnVanHalter();
        this._state.setState(0);
        this._state.update();
        this._timeUpTask = ThreadPoolManager.getInstance().scheduleGeneral(new TimeUp(), Config.HPH_ACTIVITYTIMEOFHALTER);
        _log.info("VanHalterManager : Spawn Van Halter.");
    }

    public void onKillVanhalter(L2PcInstance pc) {
        this.enterInterval();
        this._teleportCube0 = this.addSpawn(32467, -16397, -53308, -10448, 16384);
        this._teleportCube1 = this.addSpawn(32467, -16397, -52040, -10607, 16384);
        ThreadPoolManager.getInstance().scheduleGeneral(new Runnable(){

            @Override
            public void run() {
                VanHalterManager.this.banishForeigners();
                VanHalterManager.this._teleportCube0.deleteMe();
                VanHalterManager.this._teleportCube0 = null;
                VanHalterManager.this._teleportCube1.deleteMe();
                VanHalterManager.this._teleportCube1 = null;
            }
        }, 900000L);
        Broadcast.announceToOnlinePlayers("\u90aa\u6559\u306e\u53f8\u796d\u9577 \u30a2\u30f3\u30c9\u30ec\u30a2\u30b9 \u30f4\u30a1\u30f3 \u30db\u30eb\u30bf\u30fc\u304c\u6b7b\u4ea1\u3057\u307e\u3057\u305f\u3002\u6b21\u306e\u5fa9\u6d3b\u306f " + this._state.respawnTimeFormat() + " \u3054\u308d\u3067\u3059\u3002");
    }

    private class Movie
    implements Runnable {
        private final int _distance = 6502500;
        private int _taskId;
        private final List<L2PcInstance> _players = VanHalterManager.this.getPlayersInside();

        public Movie(int taskId) {
            this._taskId = taskId;
        }

        private void next(int taskId, long delay) {
            this._taskId = taskId;
            VanHalterManager.this._movieTask = ThreadPoolManager.getInstance().scheduleGeneral(this, delay);
        }

        @Override
        public void run() {
            VanHalterManager.this._movieTask = null;
            VanHalterManager.this._vanHalter.setHeading(16384);
            VanHalterManager.this._vanHalter.setTarget(VanHalterManager.this._ritualOffering);
            switch (this._taskId) {
                case 1: {
                    VanHalterManager.this._state.setState(1);
                    VanHalterManager.this._state.update();
                    for (L2PcInstance pc : this._players) {
                        if (pc.getPlanDistanceSq(VanHalterManager.this._vanHalter) <= 6502500.0) {
                            pc.enterMovieMode();
                            pc.specialCamera(VanHalterManager.this._vanHalter, 50, 90, 0, 0, 15000);
                            continue;
                        }
                        pc.leaveMovieMode();
                    }
                    this.next(2, 16L);
                    break;
                }
                case 2: {
                    L2Npc cameraMarker = VanHalterManager.this._cameraMarker.get(5);
                    for (L2PcInstance pc : this._players) {
                        if (pc.getPlanDistanceSq(cameraMarker) <= 6502500.0) {
                            pc.enterMovieMode();
                            pc.specialCamera(cameraMarker, 1842, 100, -3, 0, 15000);
                            continue;
                        }
                        pc.leaveMovieMode();
                    }
                    this.next(3, 1L);
                    break;
                }
                case 3: {
                    L2Npc cameraMarker = VanHalterManager.this._cameraMarker.get(5);
                    for (L2PcInstance pc : this._players) {
                        if (pc.getPlanDistanceSq(cameraMarker) <= 6502500.0) {
                            pc.enterMovieMode();
                            pc.specialCamera(cameraMarker, 1861, 97, -10, 1500, 15000);
                            continue;
                        }
                        pc.leaveMovieMode();
                    }
                    this.next(4, 1500L);
                    break;
                }
                case 4: {
                    L2Npc cameraMarker = VanHalterManager.this._cameraMarker.get(4);
                    for (L2PcInstance pc : this._players) {
                        if (pc.getPlanDistanceSq(cameraMarker) <= 6502500.0) {
                            pc.enterMovieMode();
                            pc.specialCamera(cameraMarker, 1876, 97, 12, 0, 15000);
                            continue;
                        }
                        pc.leaveMovieMode();
                    }
                    this.next(5, 1L);
                    break;
                }
                case 5: {
                    L2Npc cameraMarker = VanHalterManager.this._cameraMarker.get(4);
                    for (L2PcInstance pc : this._players) {
                        if (pc.getPlanDistanceSq(cameraMarker) <= 6502500.0) {
                            pc.enterMovieMode();
                            pc.specialCamera(cameraMarker, 1839, 94, 0, 1500, 15000);
                            continue;
                        }
                        pc.leaveMovieMode();
                    }
                    this.next(6, 1500L);
                    break;
                }
                case 6: {
                    L2Npc cameraMarker = VanHalterManager.this._cameraMarker.get(3);
                    for (L2PcInstance pc : this._players) {
                        if (pc.getPlanDistanceSq(cameraMarker) <= 6502500.0) {
                            pc.enterMovieMode();
                            pc.specialCamera(cameraMarker, 1872, 94, 15, 0, 15000);
                            continue;
                        }
                        pc.leaveMovieMode();
                    }
                    this.next(7, 1L);
                    break;
                }
                case 7: {
                    L2Npc cameraMarker = VanHalterManager.this._cameraMarker.get(3);
                    for (L2PcInstance pc : this._players) {
                        if (pc.getPlanDistanceSq(cameraMarker) <= 6502500.0) {
                            pc.enterMovieMode();
                            pc.specialCamera(cameraMarker, 1839, 92, 0, 1500, 15000);
                            continue;
                        }
                        pc.leaveMovieMode();
                    }
                    this.next(8, 1500L);
                    break;
                }
                case 8: {
                    L2Npc cameraMarker = VanHalterManager.this._cameraMarker.get(2);
                    for (L2PcInstance pc : this._players) {
                        if (pc.getPlanDistanceSq(cameraMarker) <= 6502500.0) {
                            pc.enterMovieMode();
                            pc.specialCamera(cameraMarker, 1872, 92, 15, 0, 15000);
                            continue;
                        }
                        pc.leaveMovieMode();
                    }
                    this.next(9, 1L);
                    break;
                }
                case 9: {
                    L2Npc cameraMarker = VanHalterManager.this._cameraMarker.get(2);
                    for (L2PcInstance pc : this._players) {
                        if (pc.getPlanDistanceSq(cameraMarker) <= 6502500.0) {
                            pc.enterMovieMode();
                            pc.specialCamera(cameraMarker, 1839, 90, 5, 1500, 15000);
                            continue;
                        }
                        pc.leaveMovieMode();
                    }
                    this.next(10, 1500L);
                    break;
                }
                case 10: {
                    L2Npc cameraMarker = VanHalterManager.this._cameraMarker.get(1);
                    for (L2PcInstance pc : this._players) {
                        if (pc.getPlanDistanceSq(cameraMarker) <= 6502500.0) {
                            pc.enterMovieMode();
                            pc.specialCamera(cameraMarker, 1872, 90, 5, 0, 15000);
                            continue;
                        }
                        pc.leaveMovieMode();
                    }
                    this.next(11, 1L);
                    break;
                }
                case 11: {
                    L2Npc cameraMarker = VanHalterManager.this._cameraMarker.get(1);
                    for (L2PcInstance pc : this._players) {
                        if (pc.getPlanDistanceSq(cameraMarker) <= 6502500.0) {
                            pc.enterMovieMode();
                            pc.specialCamera(cameraMarker, 2002, 90, 2, 1500, 15000);
                            continue;
                        }
                        pc.leaveMovieMode();
                    }
                    this.next(12, 2000L);
                    break;
                }
                case 12: {
                    for (L2PcInstance pc : this._players) {
                        if (pc.getPlanDistanceSq(VanHalterManager.this._vanHalter) <= 6502500.0) {
                            pc.enterMovieMode();
                            pc.specialCamera(VanHalterManager.this._vanHalter, 50, 90, 10, 0, 15000);
                            continue;
                        }
                        pc.leaveMovieMode();
                    }
                    if (VanHalterManager.this._movieTask != null) {
                        VanHalterManager.this._movieTask.cancel(false);
                    }
                    VanHalterManager.this._movieTask = null;
                    this.next(13, 1000L);
                    break;
                }
                case 13: {
                    L2Skill skill = SkillTable.getInstance().getInfo(1168, 7);
                    VanHalterManager.this._ritualOffering.setIsInvul(false);
                    VanHalterManager.this._vanHalter.setTarget(VanHalterManager.this._ritualOffering);
                    VanHalterManager.this._vanHalter.setIsImmobilized(false);
                    VanHalterManager.this._vanHalter.doCast(skill);
                    VanHalterManager.this._vanHalter.setIsImmobilized(true);
                    this.next(14, 4700L);
                    break;
                }
                case 14: {
                    VanHalterManager.this._ritualOffering.setIsInvul(false);
                    VanHalterManager.this._ritualOffering.reduceCurrentHp(VanHalterManager.this._ritualOffering.getMaxHp() + 1, VanHalterManager.this._vanHalter, null);
                    this.next(15, 4300L);
                    break;
                }
                case 15: {
                    VanHalterManager.this.spawnRitualSacrifice();
                    VanHalterManager.this.deleteRitualOffering();
                    for (L2PcInstance pc : this._players) {
                        if (pc.getPlanDistanceSq(VanHalterManager.this._vanHalter) <= 6502500.0) {
                            pc.enterMovieMode();
                            pc.specialCamera(VanHalterManager.this._vanHalter, 100, 90, 15, 1500, 15000);
                            continue;
                        }
                        pc.leaveMovieMode();
                    }
                    this.next(16, 2000L);
                    break;
                }
                case 16: {
                    for (L2PcInstance pc : this._players) {
                        if (pc.getPlanDistanceSq(VanHalterManager.this._vanHalter) <= 6502500.0) {
                            pc.enterMovieMode();
                            pc.specialCamera(VanHalterManager.this._vanHalter, 5200, 90, -10, 9500, 6000);
                            continue;
                        }
                        pc.leaveMovieMode();
                    }
                    this.next(17, 6000L);
                    break;
                }
                case 17: {
                    for (L2PcInstance pc : this._players) {
                        pc.leaveMovieMode();
                    }
                    VanHalterManager.this.deleteRitualSacrifice();
                    VanHalterManager.this.deleteCameraMarker();
                    VanHalterManager.this._vanHalter.setIsImmobilized(false);
                    VanHalterManager.this._vanHalter.setIsInvul(false);
                    this.next(18, 1000L);
                    break;
                }
                case 18: {
                    VanHalterManager.this.combatBeginning();
                }
            }
        }
    }

    protected class TimeUp
    implements Runnable {
        protected TimeUp() {
        }

        @Override
        public void run() {
            VanHalterManager.this.enterInterval();
        }
    }

    protected class Interval
    implements Runnable {
        protected Interval() {
        }

        @Override
        public void run() {
            VanHalterManager.this.setupAltar();
        }
    }

    private class Bleeding
    implements Runnable {
        private Bleeding() {
        }

        @Override
        public void run() {
            VanHalterManager.this.addBleeding();
        }
    }

    protected class HalterEscape
    implements Runnable {
        protected HalterEscape() {
        }

        @Override
        public void run() {
            if (VanHalterManager.this._royalGuardHepler.size() <= Config.HPH_CALLROYALGUARDHELPERCOUNT && !VanHalterManager.this._vanHalter.isDead()) {
                if (VanHalterManager.this._vanHalter.isAfraid()) {
                    VanHalterManager.this._vanHalter.stopFear(null);
                } else {
                    VanHalterManager.this._vanHalter.startFear();
                    if (VanHalterManager.this._vanHalter.getZ() >= -10476) {
                        L2CharPosition pos = new L2CharPosition(-16397, -53308, -10448, 0);
                        if (VanHalterManager.this._vanHalter.getX() == pos.x && VanHalterManager.this._vanHalter.getY() == pos.y) {
                            VanHalterManager.this._vanHalter.stopFear(null);
                        } else {
                            VanHalterManager.this._vanHalter.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, pos);
                        }
                    } else if (VanHalterManager.this._vanHalter.getX() >= -16397) {
                        L2CharPosition pos = new L2CharPosition(-15548, -54830, -10475, 0);
                        VanHalterManager.this._vanHalter.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, pos);
                    } else {
                        L2CharPosition pos = new L2CharPosition(-17248, -54830, -10475, 0);
                        VanHalterManager.this._vanHalter.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, pos);
                    }
                }
                if (VanHalterManager.this._halterEscapeTask != null) {
                    VanHalterManager.this._halterEscapeTask.cancel(false);
                }
                VanHalterManager.this._halterEscapeTask = ThreadPoolManager.getInstance().scheduleGeneral(new HalterEscape(), 5000L);
            } else {
                VanHalterManager.this._vanHalter.stopFear(null);
                if (VanHalterManager.this._halterEscapeTask != null) {
                    VanHalterManager.this._halterEscapeTask.cancel(false);
                }
                VanHalterManager.this._halterEscapeTask = null;
            }
        }
    }

    protected class CallRoyalGuardHelper
    implements Runnable {
        protected CallRoyalGuardHelper() {
        }

        @Override
        public void run() {
            VanHalterManager.this.spawnRoyalGuardHepler();
            if (VanHalterManager.this._royalGuardHepler.size() <= Config.HPH_CALLROYALGUARDHELPERCOUNT && !VanHalterManager.this._vanHalter.isDead()) {
                if (VanHalterManager.this._callRoyalGuardHelperTask != null) {
                    VanHalterManager.this._callRoyalGuardHelperTask.cancel(false);
                }
                VanHalterManager.this._callRoyalGuardHelperTask = ThreadPoolManager.getInstance().scheduleGeneral(new CallRoyalGuardHelper(), Config.HPH_CALLROYALGUARDHELPERINTERVAL);
            } else {
                if (VanHalterManager.this._callRoyalGuardHelperTask != null) {
                    VanHalterManager.this._callRoyalGuardHelperTask.cancel(false);
                }
                VanHalterManager.this._callRoyalGuardHelperTask = null;
            }
        }
    }

    protected class CloseDoorOfAltar
    implements Runnable {
        protected CloseDoorOfAltar() {
        }

        @Override
        public void run() {
            VanHalterManager.this.closeDoorOfAltar(true);
        }
    }

    protected class OpenDoorOfAltar
    implements Runnable {
        protected OpenDoorOfAltar() {
        }

        @Override
        public void run() {
            VanHalterManager.this.openDoorOfAltar(true);
        }
    }

    protected class LockUpDoorOfAltar
    implements Runnable {
        protected LockUpDoorOfAltar() {
        }

        @Override
        public void run() {
            VanHalterManager.this.closeDoorOfAltar(false);
            VanHalterManager.this._isLocked = true;
            VanHalterManager.this._lockUpDoorOfAltarTask = null;
        }
    }

    private static final class SingletonHolder {
        protected static final VanHalterManager INSTANCE = new VanHalterManager();

        private SingletonHolder() {
        }
    }
}

