/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.olympiad.Olympiad;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.AbnormalStatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.ExOlympiadSpelledInfo;
import com.l2jserver.gameserver.network.serverpackets.PartySpelled;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.skills.L2EffectType;
import com.l2jserver.util.L2FastList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javolution.util.FastList;
import javolution.util.FastMap;

public class CharEffectList {
    private static final L2Effect[] EMPTY_EFFECTS = new L2Effect[0];
    private FastList<L2Effect> _buffs;
    private FastList<L2Effect> _debuffs;
    private Map<String, List<L2Effect>> _stackedEffects;
    private volatile boolean _hasEffectsRemovedOnAnyAction = false;
    private boolean _queuesInitialized = false;
    private LinkedBlockingQueue<L2Effect> _addQueue;
    private LinkedBlockingQueue<L2Effect> _removeQueue;
    private AtomicBoolean queueLock = new AtomicBoolean();
    private boolean _partyOnly = false;
    private L2Character _owner;

    public CharEffectList(L2Character owner) {
        this._owner = owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final L2Effect[] getAllEffects() {
        FastList<L2Effect> fastList;
        if ((this._buffs == null || this._buffs.isEmpty()) && (this._debuffs == null || this._debuffs.isEmpty())) {
            return EMPTY_EFFECTS;
        }
        FastList temp = FastList.newInstance();
        if (this._buffs != null) {
            fastList = this._buffs;
            synchronized (fastList) {
                if (!this._buffs.isEmpty()) {
                    temp.addAll(this._buffs);
                }
            }
        }
        if (this._debuffs != null) {
            fastList = this._debuffs;
            synchronized (fastList) {
                if (!this._debuffs.isEmpty()) {
                    temp.addAll(this._debuffs);
                }
            }
        }
        Object[] tempArray = new L2Effect[temp.size()];
        temp.toArray(tempArray);
        FastList.recycle((FastList)temp);
        return tempArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final L2Effect getFirstEffect(L2EffectType tp) {
        FastList<L2Effect> fastList;
        L2Effect effectNotInUse = null;
        if (this._buffs != null) {
            fastList = this._buffs;
            synchronized (fastList) {
                if (!this._buffs.isEmpty()) {
                    for (L2Effect e : this._buffs) {
                        if (e == null || e.getEffectType() != tp) continue;
                        if (e.getInUse()) {
                            return e;
                        }
                        effectNotInUse = e;
                    }
                }
            }
        }
        if (effectNotInUse == null && this._debuffs != null) {
            fastList = this._debuffs;
            synchronized (fastList) {
                if (!this._debuffs.isEmpty()) {
                    for (L2Effect e : this._debuffs) {
                        if (e == null || e.getEffectType() != tp) continue;
                        if (e.getInUse()) {
                            return e;
                        }
                        effectNotInUse = e;
                    }
                }
            }
        }
        return effectNotInUse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final L2Effect getFirstEffect(L2Skill skill) {
        L2Effect effectNotInUse = null;
        if (skill.isDebuff()) {
            if (this._debuffs == null) {
                return null;
            }
            FastList<L2Effect> fastList = this._debuffs;
            synchronized (fastList) {
                if (this._debuffs.isEmpty()) {
                    return null;
                }
                for (L2Effect e : this._debuffs) {
                    if (e == null || e.getSkill() != skill) continue;
                    if (e.getInUse()) {
                        return e;
                    }
                    effectNotInUse = e;
                }
            }
            return effectNotInUse;
        }
        if (this._buffs == null) {
            return null;
        }
        FastList<L2Effect> fastList = this._buffs;
        synchronized (fastList) {
            if (this._buffs.isEmpty()) {
                return null;
            }
            for (L2Effect e : this._buffs) {
                if (e == null || e.getSkill() != skill) continue;
                if (e.getInUse()) {
                    return e;
                }
                effectNotInUse = e;
            }
        }
        return effectNotInUse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final L2Effect getFirstEffect(int skillId) {
        FastList<L2Effect> fastList;
        L2Effect effectNotInUse = null;
        if (this._buffs != null) {
            fastList = this._buffs;
            synchronized (fastList) {
                if (!this._buffs.isEmpty()) {
                    for (L2Effect e : this._buffs) {
                        if (e == null || e.getSkill().getId() != skillId) continue;
                        if (e.getInUse()) {
                            return e;
                        }
                        effectNotInUse = e;
                    }
                }
            }
        }
        if (effectNotInUse == null && this._debuffs != null) {
            fastList = this._debuffs;
            synchronized (fastList) {
                if (!this._debuffs.isEmpty()) {
                    for (L2Effect e : this._debuffs) {
                        if (e == null || e.getSkill().getId() != skillId) continue;
                        if (e.getInUse()) {
                            return e;
                        }
                        effectNotInUse = e;
                    }
                }
            }
        }
        return effectNotInUse;
    }

    private boolean doesStack(L2Skill checkSkill) {
        if (this._buffs == null || this._buffs.isEmpty() || checkSkill._effectTemplates == null || checkSkill._effectTemplates.length < 1 || checkSkill._effectTemplates[0].stackType == null || "none".equals(checkSkill._effectTemplates[0].stackType)) {
            return false;
        }
        String stackType = checkSkill._effectTemplates[0].stackType;
        for (L2Effect e : this._buffs) {
            if (e.getStackType() == null || !e.getStackType().equals(stackType)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBuffCount() {
        if (this._buffs == null) {
            return 0;
        }
        int buffCount = 0;
        FastList<L2Effect> fastList = this._buffs;
        synchronized (fastList) {
            if (this._buffs.isEmpty()) {
                return 0;
            }
            for (L2Effect e : this._buffs) {
                if (e == null || !e.getShowIcon() || e.getSkill().isDance() || e.getSkill().is7Signs()) continue;
                switch (e.getSkill().getSkillType()) {
                    case BUFF: 
                    case REFLECT: 
                    case HEAL_PERCENT: 
                    case MANAHEAL_PERCENT: {
                        ++buffCount;
                    }
                }
            }
        }
        return buffCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDanceCount() {
        if (this._buffs == null) {
            return 0;
        }
        int danceCount = 0;
        FastList<L2Effect> fastList = this._buffs;
        synchronized (fastList) {
            if (this._buffs.isEmpty()) {
                return 0;
            }
            for (L2Effect e : this._buffs) {
                if (e == null || !e.getSkill().isDance() || !e.getInUse()) continue;
                ++danceCount;
            }
        }
        return danceCount;
    }

    public final void stopAllEffects() {
        L2Effect[] effects;
        for (L2Effect e : effects = this.getAllEffects()) {
            if (e == null) continue;
            e.exit(true);
        }
    }

    public final void stopAllEffectsExceptThoseThatLastThroughDeath() {
        L2Effect[] effects;
        for (L2Effect e : effects = this.getAllEffects()) {
            if (e == null || e.getSkill().isStayAfterDeath()) continue;
            e.exit(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAllToggles() {
        if (this._buffs != null) {
            FastList<L2Effect> fastList = this._buffs;
            synchronized (fastList) {
                if (!this._buffs.isEmpty()) {
                    for (L2Effect e : this._buffs) {
                        if (e == null || !e.getSkill().isToggle()) continue;
                        e.exit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopEffects(L2EffectType type) {
        FastList<L2Effect> fastList;
        FastList temp = FastList.newInstance();
        if (this._buffs != null) {
            fastList = this._buffs;
            synchronized (fastList) {
                if (!this._buffs.isEmpty()) {
                    for (L2Effect e : this._buffs) {
                        if (e == null || e.getEffectType() != type) continue;
                        temp.add((Object)e);
                    }
                }
            }
        }
        if (this._debuffs != null) {
            fastList = this._debuffs;
            synchronized (fastList) {
                if (!this._debuffs.isEmpty()) {
                    for (L2Effect e : this._debuffs) {
                        if (e == null || e.getEffectType() != type) continue;
                        temp.add((Object)e);
                    }
                }
            }
        }
        if (!temp.isEmpty()) {
            for (L2Effect e : temp) {
                if (e == null) continue;
                e.exit();
            }
        }
        FastList.recycle((FastList)temp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopSkillEffects(int skillId) {
        FastList<L2Effect> fastList;
        FastList temp = FastList.newInstance();
        if (this._buffs != null) {
            fastList = this._buffs;
            synchronized (fastList) {
                if (!this._buffs.isEmpty()) {
                    for (L2Effect e : this._buffs) {
                        if (e == null || e.getSkill().getId() != skillId) continue;
                        temp.add((Object)e);
                    }
                }
            }
        }
        if (this._debuffs != null) {
            fastList = this._debuffs;
            synchronized (fastList) {
                if (!this._debuffs.isEmpty()) {
                    for (L2Effect e : this._debuffs) {
                        if (e == null || e.getSkill().getId() != skillId) continue;
                        temp.add((Object)e);
                    }
                }
            }
        }
        if (!temp.isEmpty()) {
            for (L2Effect e : temp) {
                if (e == null) continue;
                e.exit();
            }
        }
        FastList.recycle((FastList)temp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopEffectsOnAction() {
        if (this._hasEffectsRemovedOnAnyAction && this._buffs != null) {
            FastList<L2Effect> fastList = this._buffs;
            synchronized (fastList) {
                if (!this._buffs.isEmpty()) {
                    for (L2Effect e : this._buffs) {
                        if (e == null || !e.getSkill().isRemovedOnAnyActionExceptMove()) continue;
                        e.exit(true);
                    }
                }
            }
        }
    }

    public void updateEffectIcons(boolean partyOnly) {
        if (this._buffs == null && this._debuffs == null) {
            return;
        }
        if (partyOnly) {
            this._partyOnly = true;
        }
        this.queueRunner();
    }

    public void queueEffect(L2Effect effect, boolean remove) {
        if (effect == null) {
            return;
        }
        if (!this._queuesInitialized) {
            this.init();
        }
        if (remove) {
            this._removeQueue.offer(effect);
        } else {
            this._addQueue.offer(effect);
        }
        this.queueRunner();
    }

    private synchronized void init() {
        this._addQueue = new LinkedBlockingQueue();
        this._removeQueue = new LinkedBlockingQueue();
        this._queuesInitialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueRunner() {
        if (!this.queueLock.compareAndSet(false, true)) {
            return;
        }
        try {
            while (true) {
                L2Effect effect;
                if ((effect = this._removeQueue.poll()) != null) {
                    this.removeEffectFromQueue(effect);
                    this._partyOnly = false;
                    continue;
                }
                effect = this._addQueue.poll();
                if (effect != null) {
                    this.addEffectFromQueue(effect);
                    this._partyOnly = false;
                }
                if (this._addQueue.isEmpty() && this._removeQueue.isEmpty()) break;
            }
            this.updateEffectIcons();
        }
        finally {
            this.queueLock.set(false);
        }
    }

    protected void removeEffectFromQueue(L2Effect effect) {
        FastList<L2Effect> effectList;
        if (effect == null) {
            return;
        }
        if (effect.getSkill().isDebuff()) {
            if (this._debuffs == null) {
                return;
            }
            effectList = this._debuffs;
        } else {
            if (this._buffs == null) {
                return;
            }
            effectList = this._buffs;
        }
        if ("none".equals(effect.getStackType())) {
            this._owner.removeStatsOwner(effect);
        } else {
            if (this._stackedEffects == null) {
                return;
            }
            List<L2Effect> stackQueue = this._stackedEffects.get(effect.getStackType());
            if (stackQueue == null || stackQueue.isEmpty()) {
                return;
            }
            int index = stackQueue.indexOf(effect);
            if (index >= 0) {
                stackQueue.remove(effect);
                if (index == 0) {
                    L2Effect newStackedEffect;
                    this._owner.removeStatsOwner(effect);
                    if (!stackQueue.isEmpty() && (newStackedEffect = this.listsContains(stackQueue.get(0))) != null && newStackedEffect.setInUse(true)) {
                        this._owner.addStatFuncs(newStackedEffect.getStatFuncs());
                    }
                }
                if (stackQueue.isEmpty()) {
                    this._stackedEffects.remove(effect.getStackType());
                } else {
                    this._stackedEffects.put(effect.getStackType(), stackQueue);
                }
            }
        }
        if (effectList.remove((Object)effect) && this._owner instanceof L2PcInstance && effect.getShowIcon()) {
            SystemMessage sm = effect.getSkill().isToggle() ? new SystemMessage(SystemMessageId.S1_HAS_BEEN_ABORTED) : new SystemMessage(SystemMessageId.EFFECT_S1_DISAPPEARED);
            sm.addSkillName(effect);
            this._owner.sendPacket(sm);
        }
    }

    protected void addEffectFromQueue(L2Effect newEffect) {
        FastList stackQueue;
        if (newEffect == null) {
            return;
        }
        L2Skill newSkill = newEffect.getSkill();
        if (newSkill.isDebuff()) {
            if (this._debuffs == null) {
                this._debuffs = new FastList();
            }
            for (L2Effect e : this._debuffs) {
                if (e == null || e.getSkill().getId() != newEffect.getSkill().getId() || e.getEffectType() != newEffect.getEffectType() || e.getStackOrder() != newEffect.getStackOrder() || !e.getStackType().equals(newEffect.getStackType())) continue;
                newEffect.stopEffectTask();
                return;
            }
            this._debuffs.addLast((Object)newEffect);
        } else {
            if (this._buffs == null) {
                this._buffs = new FastList();
            }
            for (L2Effect e : this._buffs) {
                if (e == null || e.getSkill().getId() != newEffect.getSkill().getId() || e.getEffectType() != newEffect.getEffectType() || e.getStackOrder() != newEffect.getStackOrder() || !e.getStackType().equals(newEffect.getStackType())) continue;
                e.exit();
            }
            if (newEffect.isHerbEffect() && this.getBuffCount() >= this._owner.getMaxBuffCount()) {
                newEffect.stopEffectTask();
                return;
            }
            if (!this.doesStack(newSkill) && !newSkill.is7Signs()) {
                if (newSkill.isDance()) {
                    int effectsToRemove = this.getDanceCount() - Config.DANCES_MAX_AMOUNT;
                    if (effectsToRemove >= 0) {
                        for (L2Effect e : this._buffs) {
                            if (e == null || !e.getSkill().isDance()) continue;
                            e.exit();
                            if (--effectsToRemove >= 0) continue;
                            break;
                        }
                    }
                } else {
                    int effectsToRemove = this.getBuffCount() - this._owner.getMaxBuffCount();
                    if (effectsToRemove >= 0) {
                        block0 : switch (newSkill.getSkillType()) {
                            case BUFF: 
                            case REFLECT: 
                            case HEAL_PERCENT: 
                            case MANAHEAL_PERCENT: {
                                block9: for (L2Effect e : this._buffs) {
                                    if (e == null || e.getSkill().isDance()) continue;
                                    switch (e.getSkill().getSkillType()) {
                                        case BUFF: 
                                        case REFLECT: 
                                        case HEAL_PERCENT: 
                                        case MANAHEAL_PERCENT: {
                                            e.exit();
                                            break;
                                        }
                                        default: {
                                            continue block9;
                                        }
                                    }
                                    if (--effectsToRemove >= 0) continue;
                                    break block0;
                                }
                                break;
                            }
                        }
                    }
                }
            }
            if (newSkill.isDance()) {
                this._buffs.addLast((Object)newEffect);
            } else {
                int pos = 0;
                if (newSkill.isToggle()) {
                    for (L2Effect e : this._buffs) {
                        if (e == null) continue;
                        if (!e.getSkill().isDance()) {
                            ++pos;
                            continue;
                        }
                        break;
                    }
                } else {
                    for (L2Effect e : this._buffs) {
                        if (e == null) continue;
                        if (!(e.getSkill().isToggle() || e.getSkill().is7Signs() || e.getSkill().isDance())) {
                            ++pos;
                            continue;
                        }
                        break;
                    }
                }
                this._buffs.add(pos, (Object)newEffect);
            }
        }
        if ("none".equals(newEffect.getStackType())) {
            if (newEffect.setInUse(true)) {
                this._owner.addStatFuncs(newEffect.getStatFuncs());
            }
            return;
        }
        L2Effect effectToAdd = null;
        L2Effect effectToRemove = null;
        if (this._stackedEffects == null) {
            this._stackedEffects = new FastMap();
        }
        if ((stackQueue = this._stackedEffects.get(newEffect.getStackType())) != null) {
            int pos = 0;
            if (!stackQueue.isEmpty()) {
                effectToRemove = this.listsContains((L2Effect)stackQueue.get(0));
                Iterator queueIterator = stackQueue.iterator();
                while (queueIterator.hasNext() && newEffect.getStackOrder() < ((L2Effect)queueIterator.next()).getStackOrder()) {
                    ++pos;
                }
                stackQueue.add(pos, newEffect);
                if (Config.EFFECT_CANCELING && !newEffect.isHerbEffect() && stackQueue.size() > 1) {
                    if (newSkill.isDebuff()) {
                        this._debuffs.remove(stackQueue.remove(1));
                    } else {
                        this._buffs.remove(stackQueue.remove(1));
                    }
                }
            } else {
                stackQueue.add(0, newEffect);
            }
        } else {
            stackQueue = new FastList();
            stackQueue.add(0, newEffect);
        }
        this._stackedEffects.put(newEffect.getStackType(), (List<L2Effect>)stackQueue);
        if (!stackQueue.isEmpty()) {
            effectToAdd = this.listsContains((L2Effect)stackQueue.get(0));
        }
        if (effectToRemove != effectToAdd) {
            if (effectToRemove != null) {
                this._owner.removeStatsOwner(effectToRemove);
                effectToRemove.setInUse(false);
            }
            if (effectToAdd != null && effectToAdd.setInUse(true)) {
                this._owner.addStatFuncs(effectToAdd.getStatFuncs());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateEffectIcons() {
        L2FastList<L2PcInstance> specs;
        FastList<L2Effect> fastList;
        if (this._owner == null || !(this._owner instanceof L2Playable)) {
            return;
        }
        AbnormalStatusUpdate mi = null;
        PartySpelled ps = null;
        ExOlympiadSpelledInfo os = null;
        if (this._owner instanceof L2PcInstance) {
            if (this._partyOnly) {
                this._partyOnly = false;
            } else {
                mi = new AbnormalStatusUpdate();
            }
            if (this._owner.isInParty()) {
                ps = new PartySpelled(this._owner);
            }
            if (((L2PcInstance)this._owner).isInOlympiadMode() && ((L2PcInstance)this._owner).isOlympiadStart()) {
                os = new ExOlympiadSpelledInfo((L2PcInstance)this._owner);
            }
        } else if (this._owner instanceof L2Summon) {
            ps = new PartySpelled(this._owner);
        }
        boolean found = false;
        if (this._buffs != null && !this._buffs.isEmpty()) {
            fastList = this._buffs;
            synchronized (fastList) {
                block12: for (L2Effect e : this._buffs) {
                    if (e == null) continue;
                    if (e.getSkill().isRemovedOnAnyActionExceptMove()) {
                        found = true;
                    }
                    if (!e.getShowIcon()) continue;
                    switch (e.getEffectType()) {
                        case CHARGE: 
                        case SIGNET_GROUND: {
                            continue block12;
                        }
                    }
                    if (!e.getInUse()) continue;
                    if (mi != null) {
                        e.addIcon(mi);
                    }
                    if (ps != null) {
                        e.addPartySpelledIcon(ps);
                    }
                    if (os == null) continue;
                    e.addOlympiadSpelledIcon(os);
                }
            }
        }
        if (this._debuffs != null && !this._debuffs.isEmpty()) {
            fastList = this._debuffs;
            synchronized (fastList) {
                block13: for (L2Effect e : this._debuffs) {
                    if (e == null) continue;
                    if (e.getSkill().isRemovedOnAnyActionExceptMove()) {
                        found = true;
                    }
                    if (!e.getShowIcon()) continue;
                    switch (e.getEffectType()) {
                        case SIGNET_GROUND: {
                            continue block13;
                        }
                    }
                    if (!e.getInUse()) continue;
                    if (mi != null) {
                        e.addIcon(mi);
                    }
                    if (ps != null) {
                        e.addPartySpelledIcon(ps);
                    }
                    if (os == null) continue;
                    e.addOlympiadSpelledIcon(os);
                }
            }
        }
        this._hasEffectsRemovedOnAnyAction = found;
        if (mi != null) {
            this._owner.sendPacket(mi);
        }
        if (ps != null) {
            if (this._owner instanceof L2Summon) {
                L2PcInstance summonOwner = ((L2Summon)this._owner).getOwner();
                if (summonOwner != null) {
                    if (summonOwner.isInParty()) {
                        summonOwner.getParty().broadcastToPartyMembers(ps);
                    } else {
                        summonOwner.sendPacket(ps);
                    }
                }
            } else if (this._owner instanceof L2PcInstance && this._owner.isInParty()) {
                this._owner.getParty().broadcastToPartyMembers(ps);
            }
        }
        if (os != null && (specs = Olympiad.getInstance().getSpectators(((L2PcInstance)this._owner).getOlympiadGameId())) != null && !specs.isEmpty()) {
            Iterator i$ = specs.iterator();
            while (i$.hasNext()) {
                L2PcInstance spec = (L2PcInstance)i$.next();
                if (spec == null) continue;
                spec.sendPacket(os);
            }
        }
    }

    private L2Effect listsContains(L2Effect effect) {
        if (this._buffs != null && !this._buffs.isEmpty() && this._buffs.contains((Object)effect)) {
            return effect;
        }
        if (this._debuffs != null && !this._debuffs.isEmpty() && this._debuffs.contains((Object)effect)) {
            return effect;
        }
        return null;
    }

    public void clear() {
        try {
            if (this._addQueue != null) {
                this._addQueue.clear();
                this._addQueue = null;
            }
            if (this._removeQueue != null) {
                this._removeQueue.clear();
                this._removeQueue = null;
            }
            this._queuesInitialized = false;
            if (this._buffs != null) {
                this._buffs.clear();
                this._buffs = null;
            }
            if (this._debuffs != null) {
                this._debuffs.clear();
                this._debuffs = null;
            }
            if (this._stackedEffects != null) {
                this._stackedEffects.clear();
                this._stackedEffects = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

