/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.ai.L2CharacterAI;
import com.l2jserver.gameserver.datatables.MapRegionTable;
import com.l2jserver.gameserver.model.L2CharPosition;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.VehiclePathPoint;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.knownlist.VehicleKnownList;
import com.l2jserver.gameserver.model.actor.stat.VehicleStat;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.DeleteObject;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.chars.L2CharTemplate;
import com.l2jserver.gameserver.templates.item.L2Weapon;
import com.l2jserver.gameserver.util.Util;
import java.util.Collection;
import javolution.util.FastList;

public class L2Vehicle
extends L2Character {
    protected final FastList<L2PcInstance> _passengers = new FastList();
    protected Location _oustLoc = null;
    private Runnable _engine = null;
    protected VehiclePathPoint[] _currentPath = null;
    protected int _runState = 0;

    public L2Vehicle(int objectId, L2CharTemplate template) {
        super(objectId, template);
        this.setIsFlying(true);
    }

    public boolean isBoat() {
        return false;
    }

    public boolean isAirShip() {
        return false;
    }

    public void registerEngine(Runnable r) {
        if (this._engine == null) {
            this._engine = r;
        }
    }

    public void runEngine(int delay) {
        if (this._engine != null) {
            ThreadPoolManager.getInstance().scheduleGeneral(this._engine, delay);
        }
    }

    public void executePath(VehiclePathPoint[] path) {
        this._currentPath = path;
        this._runState = 0;
        if (path != null && path.length > 0) {
            VehiclePathPoint point = this._currentPath[0];
            this.getStat().setMoveSpeed(point.moveSpeed);
            this.getStat().setRotationSpeed(point.rotationSpeed);
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(point.x, point.y, point.z, 0));
            return;
        }
        this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
    }

    @Override
    public boolean moveToNextRoutePoint() {
        this._move = null;
        if (this._currentPath == null) {
            return false;
        }
        ++this._runState;
        if (this._runState < this._currentPath.length) {
            VehiclePathPoint point = this._currentPath[this._runState];
            if (!this.isMovementDisabled()) {
                this.getStat().setMoveSpeed(point.moveSpeed);
                this.getStat().setRotationSpeed(point.rotationSpeed);
                L2Character.MoveData m = new L2Character.MoveData();
                m.disregardingGeodata = false;
                m.onGeodataPathIndex = -1;
                m._xDestination = point.x;
                m._yDestination = point.y;
                m._zDestination = point.z;
                m._heading = 0;
                this.setHeading(Util.calculateHeadingFrom(this.getX(), this.getY(), point.x, point.y));
                m._moveStartTime = GameTimeController.getGameTicks();
                this._move = m;
                GameTimeController.getInstance().registerMovingObject(this);
                return true;
            }
        }
        this.runEngine(10);
        return false;
    }

    @Override
    public void initKnownList() {
        this.setKnownList(new VehicleKnownList(this));
    }

    @Override
    public VehicleStat getStat() {
        return (VehicleStat)super.getStat();
    }

    @Override
    public void initCharStat() {
        this.setStat(new VehicleStat(this));
    }

    public void setOustLoc(Location loc) {
        this._oustLoc = loc;
    }

    public Location getOustLoc() {
        return this._oustLoc != null ? this._oustLoc : MapRegionTable.getInstance().getTeleToLocation(this, MapRegionTable.TeleportWhereType.Town);
    }

    public void oustPlayers() {
        if (!this._passengers.isEmpty()) {
            for (L2PcInstance player : this._passengers) {
                this.oustPlayer(player);
            }
        }
    }

    public void oustPlayer(L2PcInstance player) {
        player.setVehicle(null);
        player.setInVehiclePosition(null);
    }

    public boolean addPassenger(L2PcInstance player) {
        if (player == null || this._passengers.contains((Object)player)) {
            return false;
        }
        this._passengers.add((Object)player);
        return true;
    }

    public void removePassenger(L2PcInstance player) {
        try {
            this._passengers.remove((Object)player);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void payForRide(int itemId, int count, int oustX, int oustY, int oustZ) {
        Collection<L2PcInstance> passengers = this.getKnownList().getKnownPlayersInRadius(1000L);
        if (passengers != null && !passengers.isEmpty()) {
            for (L2PcInstance player : passengers) {
                if (player == null || !player.isInBoat() || player.getBoat() != this) continue;
                if (itemId > 0) {
                    L2ItemInstance ticket = player.getInventory().getItemByItemId(itemId);
                    if (ticket == null || player.getInventory().destroyItem("Boat", ticket, (long)count, player, (L2Object)this) == null) {
                        player.sendPacket(new SystemMessage(SystemMessageId.NOT_CORRECT_BOAT_TICKET));
                        player.teleToLocation(oustX, oustY, oustZ, true);
                        continue;
                    }
                    InventoryUpdate iu = new InventoryUpdate();
                    iu.addModifiedItem(ticket);
                    player.sendPacket(iu);
                }
                this.addPassenger(player);
            }
        }
    }

    @Override
    public boolean updatePosition(int gameTicks) {
        boolean result = super.updatePosition(gameTicks);
        if (!this._passengers.isEmpty()) {
            for (L2PcInstance player : this._passengers) {
                if (player == null || player.getVehicle() != this) continue;
                player.getPosition().setXYZ(this.getX(), this.getY(), this.getZ());
                player.revalidateZone(false);
            }
        }
        return result;
    }

    @Override
    public void teleToLocation(int x, int y, int z, int heading, boolean allowRandomOffset) {
        this.stopMove(null, false);
        this.setIsTeleporting(true);
        this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        for (L2PcInstance player : this._passengers) {
            if (player == null) continue;
            player.teleToLocation(x, y, z);
        }
        this.broadcastPacket(new DeleteObject(this));
        this.decayMe();
        this.setXYZ(x, y, z);
        if (heading != 0) {
            this.getPosition().setHeading(heading);
        }
        this.onTeleported();
        this.revalidateZone(true);
    }

    @Override
    public void stopMove(L2CharPosition pos, boolean updateKnownObjects) {
        this._move = null;
        if (pos != null) {
            this.setXYZ(pos.x, pos.y, pos.z);
            this.setHeading(pos.heading);
            this.revalidateZone(true);
        }
        if (Config.MOVE_BASED_KNOWNLIST && updateKnownObjects) {
            this.getKnownList().findObjects();
        }
    }

    @Override
    public void updateAbnormalEffect() {
    }

    @Override
    public L2ItemInstance getActiveWeaponInstance() {
        return null;
    }

    @Override
    public L2Weapon getActiveWeaponItem() {
        return null;
    }

    @Override
    public L2ItemInstance getSecondaryWeaponInstance() {
        return null;
    }

    @Override
    public L2Weapon getSecondaryWeaponItem() {
        return null;
    }

    @Override
    public int getLevel() {
        return 0;
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return false;
    }

    @Override
    public void setAI(L2CharacterAI newAI) {
        if (this._ai == null) {
            this._ai = newAI;
        }
    }

    public class AIAccessor
    extends L2Character.AIAccessor {
        @Override
        public void detachAI() {
        }
    }
}

