/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone.type;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.network.serverpackets.EtcStatusUpdate;
import com.l2jserver.util.Rnd;
import com.l2jserver.util.StringUtil;
import gnu.trove.TIntIntHashMap;
import java.util.Collection;
import java.util.concurrent.Future;

public class L2PoisonZone
extends L2ZoneType {
    private int _chance = 100;
    private int _initialDelay = 0;
    private int _reuse = 30000;
    private boolean _enabled = true;
    private boolean _bypassConditions = false;
    private String _target = "pc";
    private Future<?> _task;
    private TIntIntHashMap _skills;

    public L2PoisonZone(int id) {
        super(id);
    }

    @Override
    public void setParameter(String name, String value) {
        if (name.equals("chance")) {
            this._chance = Integer.parseInt(value);
        } else if (name.equals("initialDelay")) {
            this._initialDelay = Integer.parseInt(value);
        } else if (name.equals("default_enabled")) {
            this._enabled = Boolean.parseBoolean(value);
        } else if (name.equals("target")) {
            this._target = value;
        } else if (name.equals("reuse")) {
            this._reuse = Integer.parseInt(value);
        } else if (name.equals("bypassSkillConditions")) {
            this._bypassConditions = Boolean.parseBoolean(value);
        } else if (name.equals("skillIdLvl")) {
            String[] propertySplit = value.split(";");
            this._skills = new TIntIntHashMap(propertySplit.length);
            for (String skill : propertySplit) {
                String[] skillSplit = skill.split("-");
                if (skillSplit.length != 2) {
                    _log.warning(StringUtil.concat("[L2PoisonZone]: invalid config property -> skillsIdLvl \"", skill, "\""));
                    continue;
                }
                try {
                    this._skills.put(Integer.parseInt(skillSplit[0]), Integer.parseInt(skillSplit[1]));
                }
                catch (NumberFormatException nfe) {
                    if (skill.isEmpty()) continue;
                    _log.warning(StringUtil.concat("[L2PoisonZone]: invalid config property -> skillsIdLvl \"", skillSplit[0], "\"", skillSplit[1]));
                }
            }
        } else {
            super.setParameter(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onEnter(L2Character character) {
        if ((character instanceof L2Playable && this._target.equalsIgnoreCase("pc") || character instanceof L2PcInstance && this._target.equalsIgnoreCase("pc_only") || character instanceof L2MonsterInstance && this._target.equalsIgnoreCase("npc")) && this._task == null) {
            L2PoisonZone l2PoisonZone = this;
            synchronized (l2PoisonZone) {
                if (this._task == null) {
                    this._task = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new ApplySkill(this), this._initialDelay, this._reuse);
                }
            }
        }
        if (character instanceof L2PcInstance) {
            character.setInsideZone((byte)18, true);
            character.sendPacket(new EtcStatusUpdate((L2PcInstance)character));
        }
    }

    @Override
    protected void onExit(L2Character character) {
        if (this._characterList.isEmpty() && this._task != null) {
            this._task.cancel(true);
            this._task = null;
        }
        if (character instanceof L2PcInstance) {
            character.setInsideZone((byte)18, false);
            if (!character.isInsideZone((byte)18)) {
                character.sendPacket(new EtcStatusUpdate((L2PcInstance)character));
            }
        }
    }

    public L2Skill getSkill(int skillId, int skillLvl) {
        return SkillTable.getInstance().getInfo(skillId, skillLvl);
    }

    public String getTargetType() {
        return this._target;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public int getChance() {
        return this._chance;
    }

    public void setZoneEnabled(boolean val) {
        this._enabled = val;
    }

    protected Collection<L2Character> getCharacterList() {
        return this._characterList.values();
    }

    @Override
    public void onDieInside(L2Character character) {
    }

    @Override
    public void onReviveInside(L2Character character) {
    }

    class ApplySkill
    implements Runnable {
        private final L2PoisonZone _poisonZone;

        ApplySkill(L2PoisonZone zone) {
            this._poisonZone = zone;
            if (L2PoisonZone.this._skills == null) {
                L2PoisonZone.this._skills = new TIntIntHashMap(1);
                L2PoisonZone.this._skills.put(4070, 1);
            }
        }

        @Override
        public void run() {
            if (L2PoisonZone.this.isEnabled()) {
                for (L2Character temp : this._poisonZone.getCharacterList()) {
                    if (temp == null || temp.isDead() || !(temp instanceof L2PcInstance && L2PoisonZone.this.getTargetType().equalsIgnoreCase("pc_only") || temp instanceof L2Playable && L2PoisonZone.this.getTargetType().equalsIgnoreCase("pc")) && (!(temp instanceof L2MonsterInstance) || !temp.hasAI() || temp.getAI().getIntention() == CtrlIntention.AI_INTENTION_IDLE || !L2PoisonZone.this.getTargetType().equalsIgnoreCase("npc")) || Rnd.get(100) >= L2PoisonZone.this.getChance()) continue;
                    for (int skillId : L2PoisonZone.this._skills.keys()) {
                        if (!L2PoisonZone.this._bypassConditions && !L2PoisonZone.this.getSkill(skillId, L2PoisonZone.this._skills.get(skillId)).checkCondition(temp, temp, false) || temp.getFirstEffect(skillId) != null) continue;
                        L2PoisonZone.this.getSkill(skillId, L2PoisonZone.this._skills.get(skillId)).getEffects(temp, temp);
                    }
                }
            }
        }
    }
}

