/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.SkillSpellbookTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.datatables.SkillTreeTable;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2PledgeSkillLearn;
import com.l2jserver.gameserver.model.L2ShortCut;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.L2SkillLearn;
import com.l2jserver.gameserver.model.L2TransformSkillLearn;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2FishermanInstance;
import com.l2jserver.gameserver.model.actor.instance.L2NpcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2TransformManagerInstance;
import com.l2jserver.gameserver.model.actor.instance.L2VillageMasterInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ExStorageMaxCount;
import com.l2jserver.gameserver.network.serverpackets.PledgeSkillList;
import com.l2jserver.gameserver.network.serverpackets.ShortCutRegister;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;
import java.util.logging.Logger;

public class RequestAquireSkill
extends L2GameClientPacket {
    private static final String _C__6C_REQUESTAQUIRESKILL = "[C] 6C RequestAquireSkill";
    private static Logger _log = Logger.getLogger(RequestAquireSkill.class.getName());
    private int _id;
    private int _level;
    private int _skillType;

    @Override
    protected void readImpl() {
        this._id = this.readD();
        this._level = this.readD();
        this._skillType = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        if (this._level < 1 || this._level > 1000 || this._id < 1 || this._id > 32000) {
            _log.warning("Recived Wrong Packet Data in Aquired Skill - id:" + this._id + " level:" + this._level);
            return;
        }
        L2Npc trainer = player.getLastFolkNPC();
        if (!(trainer instanceof L2NpcInstance)) {
            return;
        }
        if (!trainer.canInteract(player) && !player.isGM()) {
            return;
        }
        if (!Config.ALT_GAME_SKILL_LEARN) {
            player.setSkillLearningClassId(player.getClassId());
        }
        if (player.getSkillLevel(this._id) >= this._level) {
            return;
        }
        L2Skill skill = SkillTable.getInstance().getInfo(this._id, this._level);
        int counts = 0;
        int _requiredSp = 10000000;
        switch (this._skillType) {
            case 0: {
                L2SkillLearn[] skills;
                if (trainer instanceof L2TransformManagerInstance) {
                    SystemMessage sm;
                    L2TransformSkillLearn[] skillst;
                    int costid = 0;
                    for (L2TransformSkillLearn s : skillst = SkillTreeTable.getInstance().getAvailableTransformSkills(player)) {
                        L2Skill sk = SkillTable.getInstance().getInfo(s.getId(), s.getLevel());
                        if (sk == null || sk != skill) continue;
                        ++counts;
                        costid = s.getItemId();
                        _requiredSp = s.getSpCost();
                    }
                    if (counts == 0) {
                        player.sendMessage("You are trying to learn skill that u can't..");
                        Util.handleIllegalPlayerAction(player, "Player " + player.getName() + " tried to learn skill that he can't!!!", Config.DEFAULT_PUNISH);
                        return;
                    }
                    if (player.getSp() >= _requiredSp) {
                        if (!player.destroyItemByItemId("Consume", costid, 1L, trainer, false)) {
                            player.sendPacket(new SystemMessage(SystemMessageId.ITEM_MISSING_TO_LEARN_SKILL));
                            return;
                        }
                        sm = new SystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
                        sm.addItemName(costid);
                        sm.addItemNumber(1L);
                        this.sendPacket(sm);
                        sm = null;
                        break;
                    }
                    sm = new SystemMessage(SystemMessageId.NOT_ENOUGH_SP_TO_LEARN_SKILL);
                    player.sendPacket(sm);
                    sm = null;
                    return;
                }
                for (L2SkillLearn s : skills = SkillTreeTable.getInstance().getAvailableSkills(player, player.getSkillLearningClassId())) {
                    L2Skill sk = SkillTable.getInstance().getInfo(s.getId(), s.getLevel());
                    if (sk == null || sk != skill) continue;
                    ++counts;
                    _requiredSp = SkillTreeTable.getInstance().getSkillCost(player, skill);
                }
                if (counts == 0 && !Config.ALT_GAME_SKILL_LEARN) {
                    player.sendMessage("You are trying to learn skill that u can't..");
                    Util.handleIllegalPlayerAction(player, "Player " + player.getName() + " tried to learn skill that he can't!!!", Config.DEFAULT_PUNISH);
                    return;
                }
                if (player.getSp() >= _requiredSp) {
                    int spbId = -1;
                    if (Config.DIVINE_SP_BOOK_NEEDED && skill.getId() == 1405) {
                        spbId = SkillSpellbookTable.getInstance().getBookForSkill(skill, this._level);
                    } else if (Config.SP_BOOK_NEEDED && skill.getLevel() == 1) {
                        spbId = SkillSpellbookTable.getInstance().getBookForSkill(skill);
                    }
                    if (spbId <= -1) break;
                    L2ItemInstance spb = player.getInventory().getItemByItemId(spbId);
                    if (spb == null) {
                        player.sendPacket(new SystemMessage(SystemMessageId.ITEM_MISSING_TO_LEARN_SKILL));
                        return;
                    }
                    player.destroyItem("Consume", spb.getObjectId(), 1L, (L2Object)trainer, true);
                    break;
                }
                SystemMessage sm = new SystemMessage(SystemMessageId.NOT_ENOUGH_SP_TO_LEARN_SKILL);
                player.sendPacket(sm);
                sm = null;
                return;
            }
            case 1: {
                SystemMessage sm;
                L2Skill sk;
                L2SkillLearn[] skillsc;
                int costid = 0;
                int costcount = 0;
                for (L2SkillLearn s : skillsc = SkillTreeTable.getInstance().getAvailableSkills(player)) {
                    sk = SkillTable.getInstance().getInfo(s.getId(), s.getLevel());
                    if (sk == null || sk != skill) continue;
                    ++counts;
                    costid = s.getIdCost();
                    costcount = s.getCostCount();
                    _requiredSp = s.getSpCost();
                }
                if (counts == 0) {
                    player.sendMessage("You are trying to learn skill that u can't..");
                    Util.handleIllegalPlayerAction(player, "Player " + player.getName() + " tried to learn skill that he can't!!!", Config.DEFAULT_PUNISH);
                    return;
                }
                if (player.getSp() >= _requiredSp) {
                    if (!player.destroyItemByItemId("Consume", costid, costcount, trainer, false)) {
                        player.sendPacket(new SystemMessage(SystemMessageId.ITEM_MISSING_TO_LEARN_SKILL));
                        return;
                    }
                    if (costid == 57) {
                        this.sendPacket(new SystemMessage(SystemMessageId.DISAPPEARED_ADENA).addItemNumber(costcount));
                        break;
                    }
                    sm = new SystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
                    sm.addItemName(costid);
                    sm.addItemNumber(costcount);
                    this.sendPacket(sm);
                    sm = null;
                    break;
                }
                sm = new SystemMessage(SystemMessageId.NOT_ENOUGH_SP_TO_LEARN_SKILL);
                player.sendPacket(sm);
                sm = null;
                return;
            }
            case 2: {
                SystemMessage sm;
                L2PledgeSkillLearn[] skills;
                if (!player.isClanLeader()) {
                    player.sendMessage("This feature is available only for the clan leader");
                    return;
                }
                int itemId = 0;
                int itemCount = 0;
                int repCost = 100000000;
                for (L2PledgeSkillLearn s : skills = SkillTreeTable.getInstance().getAvailablePledgeSkills(player)) {
                    L2Skill sk = SkillTable.getInstance().getInfo(s.getId(), s.getLevel());
                    if (sk == null || sk != skill) continue;
                    ++counts;
                    itemId = s.getItemId();
                    itemCount = s.getItemCount();
                    repCost = s.getRepCost();
                }
                if (counts == 0) {
                    player.sendMessage("You are trying to learn skill that u can't..");
                    Util.handleIllegalPlayerAction(player, "Player " + player.getName() + " tried to learn skill that he can't!!!", Config.DEFAULT_PUNISH);
                    return;
                }
                if (player.getClan().getReputationScore() >= repCost) {
                    if (Config.LIFE_CRYSTAL_NEEDED) {
                        if (!player.destroyItemByItemId("Consume", itemId, itemCount, trainer, false)) {
                            player.sendPacket(new SystemMessage(SystemMessageId.ITEM_MISSING_TO_LEARN_SKILL));
                            return;
                        }
                        sm = new SystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
                        sm.addItemName(itemId);
                        sm.addNumber(itemCount);
                        this.sendPacket(sm);
                        sm = null;
                    }
                } else {
                    sm = new SystemMessage(SystemMessageId.ACQUIRE_SKILL_FAILED_BAD_CLAN_REP_SCORE);
                    player.sendPacket(sm);
                    return;
                }
                player.getClan().takeReputationScore(repCost, true);
                player.getClan().addNewSkill(skill);
                if (Config.DEBUG) {
                    _log.fine("Learned pledge skill " + this._id + " for " + _requiredSp + " SP.");
                }
                SystemMessage cr = new SystemMessage(SystemMessageId.S1_DEDUCTED_FROM_CLAN_REP);
                cr.addNumber(repCost);
                player.sendPacket(cr);
                SystemMessage sm2 = new SystemMessage(SystemMessageId.CLAN_SKILL_S1_ADDED);
                sm2.addSkillName(this._id);
                player.sendPacket(sm2);
                sm2 = null;
                player.getClan().broadcastToOnlineMembers(new PledgeSkillList(player.getClan()));
                for (L2PcInstance member : player.getClan().getOnlineMembers(0)) {
                    member.sendSkillList();
                }
                L2VillageMasterInstance.showPledgeSkillList(player);
                return;
            }
            case 4: {
                _requiredSp = 0;
                Quest[] qlst = trainer.getTemplate().getEventQuests(Quest.QuestEventType.ON_SKILL_LEARN);
                if (qlst != null && qlst.length == 1) {
                    if (qlst[0].notifyAcquireSkill(trainer, player, skill)) break;
                    qlst[0].notifyAcquireSkillList(trainer, player);
                    return;
                }
                return;
            }
            case 6: {
                SystemMessage sm;
                L2SkillLearn[] skillsc;
                L2Skill sk;
                int costid = 0;
                int costcount = 0;
                for (L2SkillLearn s : skillsc = SkillTreeTable.getInstance().getAvailableSpecialSkills(player)) {
                    sk = SkillTable.getInstance().getInfo(s.getId(), s.getLevel());
                    if (sk == null || sk != skill) continue;
                    ++counts;
                    costid = s.getIdCost();
                    costcount = s.getCostCount();
                    _requiredSp = s.getSpCost();
                }
                if (counts == 0) {
                    player.sendMessage("You are trying to learn skill that u can't..");
                    Util.handleIllegalPlayerAction(player, "Player " + player.getName() + " tried to learn skill that he can't!!!", Config.DEFAULT_PUNISH);
                    return;
                }
                if (player.getSp() >= _requiredSp) {
                    if (!player.destroyItemByItemId("Consume", costid, costcount, trainer, false)) {
                        player.sendPacket(new SystemMessage(SystemMessageId.ITEM_MISSING_TO_LEARN_SKILL));
                        return;
                    }
                    sm = new SystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
                    sm.addItemName(costid);
                    sm.addItemNumber(costcount);
                    this.sendPacket(sm);
                    sm = null;
                    break;
                }
                sm = new SystemMessage(SystemMessageId.NOT_ENOUGH_SP_TO_LEARN_SKILL);
                player.sendPacket(sm);
                sm = null;
                return;
            }
            default: {
                _log.warning("Recived Wrong Packet Data in Aquired Skill - unk1:" + this._skillType);
                return;
            }
        }
        player.addSkill(skill, true);
        if (Config.DEBUG) {
            _log.fine("Learned skill " + this._id + " for " + _requiredSp + " SP.");
        }
        player.setSp(player.getSp() - _requiredSp);
        StatusUpdate su = new StatusUpdate(player.getObjectId());
        su.addAttribute(13, player.getSp());
        player.sendPacket(su);
        SystemMessage sm = new SystemMessage(SystemMessageId.LEARNED_SKILL_S1);
        sm.addSkillName(this._id);
        player.sendPacket(sm);
        sm = null;
        if (this._level > 1) {
            L2ShortCut[] allShortCuts;
            for (L2ShortCut sc : allShortCuts = player.getAllShortCuts()) {
                if (sc.getId() != this._id || sc.getType() != 2) continue;
                L2ShortCut newsc = new L2ShortCut(sc.getSlot(), sc.getPage(), sc.getType(), sc.getId(), this._level, 1);
                player.sendPacket(new ShortCutRegister(newsc));
                player.registerShortCut(newsc);
            }
        }
        player.sendSkillList();
        if (this._skillType == 4) {
            Quest[] qlst = trainer.getTemplate().getEventQuests(Quest.QuestEventType.ON_SKILL_LEARN);
            qlst[0].notifyAcquireSkillList(trainer, player);
        } else if (trainer instanceof L2FishermanInstance) {
            L2FishermanInstance.showFishSkillList(player);
        } else if (trainer instanceof L2TransformManagerInstance) {
            L2TransformManagerInstance.showTransformSkillList(player);
        } else {
            L2NpcInstance.showSkillList(player, trainer, player.getSkillLearningClassId());
        }
        if (this._id >= 1368 && this._id <= 1372) {
            ExStorageMaxCount esmc = new ExStorageMaxCount(player);
            player.sendPacket(esmc);
        }
    }

    @Override
    public String getType() {
        return _C__6C_REQUESTAQUIRESKILL;
    }
}

