/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.TaskPriority;
import com.l2jserver.gameserver.instancemanager.BoatManager;
import com.l2jserver.gameserver.model.actor.instance.L2BoatInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.MoveToLocationInVehicle;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.item.L2WeaponType;
import com.l2jserver.util.Point3D;

public final class RequestMoveToLocationInVehicle
extends L2GameClientPacket {
    private static final String _C__75_MOVETOLOCATIONINVEHICLE = "[C] 75 RequestMoveToLocationInVehicle";
    private int _boatId;
    private Point3D _pos;
    private Point3D _origin_pos;

    public TaskPriority getPriority() {
        return TaskPriority.PR_HIGH;
    }

    @Override
    protected void readImpl() {
        this._boatId = this.readD();
        int _x = this.readD();
        int _y = this.readD();
        int _z = this.readD();
        this._pos = new Point3D(_x, _y, _z);
        _x = this.readD();
        _y = this.readD();
        _z = this.readD();
        this._origin_pos = new Point3D(_x, _y, _z);
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (activeChar.isAttackingNow() && activeChar.getActiveWeaponItem() != null && activeChar.getActiveWeaponItem().getItemType() == L2WeaponType.BOW) {
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (activeChar.isSitting() || activeChar.isMovementDisabled()) {
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (activeChar.getPet() != null) {
            activeChar.sendPacket(new SystemMessage(SystemMessageId.RELEASE_PET_ON_BOAT));
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (activeChar.isTransformed()) {
            activeChar.sendPacket(new SystemMessage(SystemMessageId.CANT_POLYMORPH_ON_BOAT));
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (activeChar.isInBoat()) {
            L2BoatInstance boat = activeChar.getBoat();
            if (boat.getObjectId() != this._boatId) {
                activeChar.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
        } else {
            L2BoatInstance boat = BoatManager.getInstance().getBoat(this._boatId);
            if (boat == null) {
                activeChar.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
            activeChar.setVehicle(boat);
        }
        activeChar.setInVehiclePosition(this._pos);
        activeChar.broadcastPacket(new MoveToLocationInVehicle(activeChar, this._pos, this._origin_pos));
    }

    @Override
    public String getType() {
        return _C__75_MOVETOLOCATIONINVEHICLE;
    }
}

