/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.pathfinding.cellnodes;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.pathfinding.AbstractNode;
import com.l2jserver.gameserver.pathfinding.AbstractNodeLoc;
import com.l2jserver.gameserver.pathfinding.PathFinding;
import com.l2jserver.gameserver.pathfinding.cellnodes.CellNode;
import com.l2jserver.gameserver.pathfinding.cellnodes.CellNodeBuffer;
import com.l2jserver.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;

public class CellPathFinding
extends PathFinding {
    private static final Logger _log = Logger.getLogger(CellPathFinding.class.getName());
    private BufferInfo[] _allBuffers;
    private int _findSuccess = 0;
    private int _findFails = 0;
    private int _postFilterUses = 0;
    private int _postFilterPlayableUses = 0;
    private int _postFilterPasses = 0;
    private long _postFilterElapsed = 0L;
    private FastList<L2ItemInstance> _debugItems = null;

    public static CellPathFinding getInstance() {
        return SingletonHolder._instance;
    }

    private CellPathFinding() {
        try {
            String[] array = Config.PATHFIND_BUFFERS.split(";");
            this._allBuffers = new BufferInfo[array.length];
            for (int i = 0; i < array.length; ++i) {
                String buf = array[i];
                String[] args = buf.split("x");
                if (args.length != 2) {
                    throw new Exception("Invalid buffer definition: " + buf);
                }
                this._allBuffers[i] = new BufferInfo(Integer.parseInt(args[0]), Integer.parseInt(args[1]));
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "CellPathFinding: Problem during buffer init: " + e.getMessage(), e);
            throw new Error("CellPathFinding: load aborted");
        }
    }

    @Override
    public boolean pathNodesExist(short regionoffset) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AbstractNodeLoc> findPath(int x, int y, int z, int tx, int ty, int tz, int instanceId, boolean playable) {
        AbstractNodeLoc locMiddle;
        ListIterator middlePoint;
        boolean remove;
        List<AbstractNodeLoc> list;
        boolean debug;
        int gx = x - L2World.MAP_MIN_X >> 4;
        int gy = y - L2World.MAP_MIN_Y >> 4;
        if (!GeoData.getInstance().hasGeo(x, y)) {
            return null;
        }
        short gz = GeoData.getInstance().getHeight(x, y, z);
        int gtx = tx - L2World.MAP_MIN_X >> 4;
        int gty = ty - L2World.MAP_MIN_Y >> 4;
        if (!GeoData.getInstance().hasGeo(tx, ty)) {
            return null;
        }
        short gtz = GeoData.getInstance().getHeight(tx, ty, tz);
        CellNodeBuffer buffer = this.alloc(64 + 2 * Math.max(Math.abs(gx - gtx), Math.abs(gy - gty)), playable);
        if (buffer == null) {
            return null;
        }
        boolean bl = debug = playable && Config.DEBUG_PATH;
        if (debug) {
            if (this._debugItems == null) {
                this._debugItems = new FastList();
            } else {
                for (L2ItemInstance item : this._debugItems) {
                    if (item == null) continue;
                    item.decayMe();
                }
                this._debugItems.clear();
            }
        }
        FastList<AbstractNodeLoc> path = null;
        try {
            CellNode result = buffer.findPath(gx, gy, gz, gtx, gty, gtz);
            if (debug) {
                for (CellNode n : buffer.debugPath()) {
                    if (n.getCost() < 0.0f) {
                        this.dropDebugItem(1831, (int)(-n.getCost() * 10.0f), n.getLoc());
                        continue;
                    }
                    this.dropDebugItem(57, (int)(n.getCost() * 10.0f), n.getLoc());
                }
            }
            if (result == null) {
                ++this._findFails;
                list = null;
                return list;
            }
            path = this.constructPath(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            list = null;
            return list;
        }
        finally {
            buffer.free();
        }
        if (path.size() < 3 || Config.MAX_POSTFILTER_PASSES <= 0) {
            ++this._findSuccess;
            return path;
        }
        long timeStamp = System.currentTimeMillis();
        ++this._postFilterUses;
        if (playable) {
            ++this._postFilterPlayableUses;
        }
        int pass = 0;
        do {
            ++pass;
            ++this._postFilterPasses;
            remove = false;
            middlePoint = path.listIterator();
            ListIterator endPoint = path.listIterator(1);
            AbstractNodeLoc locEnd = null;
            int currentX = x;
            int currentY = y;
            int currentZ = z;
            while (endPoint.hasNext()) {
                locEnd = (AbstractNodeLoc)endPoint.next();
                locMiddle = (AbstractNodeLoc)middlePoint.next();
                if (GeoData.getInstance().canMoveFromToTarget(currentX, currentY, currentZ, locEnd.getX(), locEnd.getY(), locEnd.getZ(), instanceId)) {
                    middlePoint.remove();
                    remove = true;
                    if (!debug) continue;
                    this.dropDebugItem(735, 1, locMiddle);
                    continue;
                }
                currentX = locMiddle.getX();
                currentY = locMiddle.getY();
                currentZ = locMiddle.getZ();
            }
        } while (playable && remove && path.size() > 2 && pass < Config.MAX_POSTFILTER_PASSES);
        if (debug) {
            middlePoint = path.listIterator();
            while (middlePoint.hasNext()) {
                locMiddle = (AbstractNodeLoc)middlePoint.next();
                this.dropDebugItem(65, 1, locMiddle);
            }
        }
        ++this._findSuccess;
        this._postFilterElapsed += System.currentTimeMillis() - timeStamp;
        return path;
    }

    private FastList<AbstractNodeLoc> constructPath(AbstractNode node) {
        FastList path = new FastList();
        int previousDirectionX = Integer.MIN_VALUE;
        int previousDirectionY = Integer.MIN_VALUE;
        while (node.getParent() != null) {
            int directionY;
            int directionX;
            if (!Config.ADVANCED_DIAGONAL_STRATEGY && node.getParent().getParent() != null) {
                int tmpX = node.getLoc().getNodeX() - node.getParent().getParent().getLoc().getNodeX();
                int tmpY = node.getLoc().getNodeY() - node.getParent().getParent().getLoc().getNodeY();
                if (Math.abs(tmpX) == Math.abs(tmpY)) {
                    directionX = tmpX;
                    directionY = tmpY;
                } else {
                    directionX = node.getLoc().getNodeX() - node.getParent().getLoc().getNodeX();
                    directionY = node.getLoc().getNodeY() - node.getParent().getLoc().getNodeY();
                }
            } else {
                directionX = node.getLoc().getNodeX() - node.getParent().getLoc().getNodeX();
                directionY = node.getLoc().getNodeY() - node.getParent().getLoc().getNodeY();
            }
            if (directionX != previousDirectionX || directionY != previousDirectionY) {
                previousDirectionX = directionX;
                previousDirectionY = directionY;
                path.addFirst((Object)node.getLoc());
                node.setLoc(null);
            }
            node = node.getParent();
        }
        return path;
    }

    private final CellNodeBuffer alloc(int size, boolean playable) {
        CellNodeBuffer current = null;
        for (BufferInfo i : this._allBuffers) {
            if (i.mapSize < size) continue;
            for (CellNodeBuffer buf : i.bufs) {
                if (!buf.lock()) continue;
                ++i.uses;
                if (playable) {
                    ++i.playableUses;
                }
                i.elapsed += buf.getElapsedTime();
                current = buf;
                break;
            }
            if (current != null) break;
            current = new CellNodeBuffer(i.mapSize);
            current.lock();
            if (i.bufs.size() < i.count) {
                i.bufs.add(current);
                ++i.uses;
                if (!playable) break;
                ++i.playableUses;
                break;
            }
            ++i.overflows;
            if (!playable) continue;
            ++i.playableOverflows;
        }
        return current;
    }

    private final void dropDebugItem(int itemId, int num, AbstractNodeLoc loc) {
        L2ItemInstance item = new L2ItemInstance(IdFactory.getInstance().getNextId(), itemId);
        item.setCount(num);
        item.spawnMe(loc.getX(), loc.getY(), loc.getZ());
        this._debugItems.add((Object)item);
    }

    @Override
    public String[] getStat() {
        String[] result = new String[this._allBuffers.length + 1];
        for (int i = 0; i < this._allBuffers.length; ++i) {
            result[i] = this._allBuffers[i].toString();
        }
        StringBuilder stat = new StringBuilder(100);
        StringUtil.append(stat, "LOS postfilter uses:", String.valueOf(this._postFilterUses), "/", String.valueOf(this._postFilterPlayableUses));
        if (this._postFilterUses > 0) {
            StringUtil.append(stat, " total/avg(ms):", String.valueOf(this._postFilterElapsed), "/", String.format("%1.2f", (double)this._postFilterElapsed / (double)this._postFilterUses), " passes total/avg:", String.valueOf(this._postFilterPasses), "/", String.format("%1.1f", (double)this._postFilterPasses / (double)this._postFilterUses), "\r\n");
        }
        StringUtil.append(stat, "Pathfind success/fail:", String.valueOf(this._findSuccess), "/", String.valueOf(this._findFails));
        result[result.length - 1] = stat.toString();
        return result;
    }

    private static class SingletonHolder {
        protected static final CellPathFinding _instance = new CellPathFinding();

        private SingletonHolder() {
        }
    }

    private static final class BufferInfo {
        final int mapSize;
        final int count;
        ArrayList<CellNodeBuffer> bufs;
        int uses = 0;
        int playableUses = 0;
        int overflows = 0;
        int playableOverflows = 0;
        long elapsed = 0L;

        public BufferInfo(int size, int cnt) {
            this.mapSize = size;
            this.count = cnt;
            this.bufs = new ArrayList(this.count);
        }

        public String toString() {
            StringBuilder stat = new StringBuilder(100);
            StringUtil.append(stat, String.valueOf(this.mapSize), "x", String.valueOf(this.mapSize), " num:", String.valueOf(this.bufs.size()), "/", String.valueOf(this.count), " uses:", String.valueOf(this.uses), "/", String.valueOf(this.playableUses));
            if (this.uses > 0) {
                StringUtil.append(stat, " total/avg(ms):", String.valueOf(this.elapsed), "/", String.format("%1.2f", (double)this.elapsed / (double)this.uses));
            }
            StringUtil.append(stat, " ovf:", String.valueOf(this.overflows), "/", String.valueOf(this.playableOverflows));
            return stat.toString();
        }
    }
}

