/** yeXgz **/
/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package ai.individual;

import com.l2jserver.gameserver.instancemanager.grandbosses.SailrenManager;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.GrandBossState.StateEnum;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.network.serverpackets.NpcSay;
import com.l2jserver.gameserver.util.Broadcast;

/**
 * By L2J_JP SANDMAN
 * JOJO Sync: l2jfree-datapack rev4814, timestamp 2008/11/21 04:53
 *
 * JOJO javaɏ (sailren.py timestamp 2009/12/27 )
 */

// Boss: sailren
public class Sailren extends Quest
{
	private static final String qn = "sailren";

	// NPC
	private static final int STATUE          = 32109;	// V[̐Α/Shilen's Stone Statue
	private static final int VELOCIRAPTOR    = 22218;	// FLvg/Velociraptor
	private static final int PTEROSAUR       = 22199;	// tHNX/Pterosaur
	private static final int TYRANNOSAURUS   = 22217;	// eBmUEX/Tyrannosaurus
	private static final int SAILREN         = 29065;	// TC/Sailren

	// ITEM
	private static final int GAZKH  = 8784;	// JWN/Gazkh

	public Sailren(int id, String name, String descr)
	{
		super(id, name, descr);
	}

	@Override
	public String onTalk(L2Npc npc, L2PcInstance player)
	{
		QuestState st = player.getQuestState(qn);
		if (st == null) return "<html><body>You are either not on a quest that involves this NPC, or you don't meet this NPC's minimum quest requirements.</body></html>";

		if (npc.getNpcId() == STATUE) {
			if (player.isFlying()) {
				return "<html><body>V[̐Α:<br>Co[ɓ撆́Aɓ邱Ƃ͂łȂB</body></html>";
			//	return "<html><body>Shilen's Stone Statue:<br>You may not enter while flying a wyvern</body></html>";
			}
			if (st.getQuestItemsCount(GAZKH) == 0) {
				st.exitQuest(true);
				return "<html><head><body>V[̐Α:<br>TC𕕈󂷂ɂ<font color=LEVEL>JWN</font>KvB</body></html>";
			//	return "<html><head><body>Shilen's Stone Statue:<br><font color=LEVEL>Gazkh</font> is necessary for seal the sailren.</body></html>";
			}
			final int entryStatus = SailrenManager.getInstance().canIntoSailrenLair(player);
			switch (entryStatus) {
			case StateEnum.ALIVE:
			case StateEnum.DEAD:
				st.exitQuest(true);
				return "<html><head><body>V[̐Α:<br>łɑ̎҂TCƓĂBނ̎זĂ͂ȂB</body></html>";
			//	return "<html><head><body>Shilen's Stone Statue:<br>Another adventurers have already fought against the sailren. Do not obstruct them.</body></html>";
			case StateEnum.INTERVAL:
				st.exitQuest(true);
				return "data/html/default/32109-INTERVAL.htm";
			//	return "<html><head><body>V[̐Α:<br>̓TC̗͂ɋɂBɓ邱Ƃ͂łȂB</body></html>";
			// 	return "<html><head><body>Shilen's Stone Statue:<br>The sailren is very powerful now. It is not possible to enter the inside.</body></html>";
			case -4:
				st.exitQuest(true);
				return "<html><head><body>V[̐Α:<br>lŃTC𕕈󂵂悤ǂƍlȂƂBԂAĂȂB</body></html>";
			//	return "<html><head><body>Shilen's Stone Statue:<br>You seal the sailren alone? You should not do so! Bring the companion.</body></html>";
			case StateEnum.NOTSPAWN:
				st.takeItems(GAZKH, 1);
				SailrenManager.getInstance().setSailrenSpawnTask(VELOCIRAPTOR);
				SailrenManager.getInstance().entryToSailrenLair(player);
				return "<html><head><body>V[̐Α:<br>N̗͂ŃTC𕕂ĂقBK^FB</body></html>";
			//	return "<html><head><body>Shilen's Stone Statue:<br>Please seal the sailren by your ability.</body></html>";
			default:
				throw new IllegalArgumentException("canIntoSailrenLair(" + player.getName() + ") is " + entryStatus);
			}
		}
		else
			throw new IllegalArgumentException("npcId is " + npc.getNpcId());
	}

	@Override
	public String onKill(L2Npc npc, L2PcInstance player, boolean isPet)
	{
		if (! SailrenManager.getInstance().getZone().isInsideZone(player)) return null;	//[JOJO]
		QuestState st = player.getQuestState(qn);
		switch (npc.getNpcId()) {
		case VELOCIRAPTOR:
			SailrenManager.getInstance().setSailrenSpawnTask(PTEROSAUR);
			break;
		case PTEROSAUR:
			SailrenManager.getInstance().setSailrenSpawnTask(TYRANNOSAURUS);
			break;
		case TYRANNOSAURUS:
			npc.broadcastPacket(new NpcSay(npc.getObjectId(), 0, npc.getNpcId(), "`Ill炵dԂĂ͂I܂̂ɂȂ邾낤DDD"));
			SailrenManager.getInstance().setSailrenSpawnTask(SAILREN);
			break;
		case SAILREN:
			Broadcast.announceToOnlinePlayers("Â̓̃TCS܂B");	//[JOJO]
			SailrenManager.getInstance().setCubeSpawn();
			if (st != null) st.exitQuest(true);
			break;
		default:
			throw new IllegalArgumentException("npcId is " + npc.getNpcId());
		}
		return null;
	}

	// Quest class and state definition
	public static void main(String[] args)
	{
		final Quest QUEST = new Sailren(-1, qn, "ai");

		// Quest NPC starter initialization
		QUEST.addStartNpc(STATUE);
		QUEST.addTalkId(STATUE);
		QUEST.addKillId(VELOCIRAPTOR);
		QUEST.addKillId(PTEROSAUR);
		QUEST.addKillId(TYRANNOSAURUS);
		QUEST.addKillId(SAILREN);
	}
}
