/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor;

import com.l2jserver.Config;
import com.l2jserver.gameserver.SevenSigns;
import com.l2jserver.gameserver.SevenSignsFestival;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.debug;
import com.l2jserver.gameserver.handler.BypassHandler;
import com.l2jserver.gameserver.handler.IBypassHandler;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.TownManager;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2NpcAIData;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.L2WorldRegion;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.instance.L2ClanHallManagerInstance;
import com.l2jserver.gameserver.model.actor.instance.L2DoormenInstance;
import com.l2jserver.gameserver.model.actor.instance.L2FestivalGuideInstance;
import com.l2jserver.gameserver.model.actor.instance.L2FishermanInstance;
import com.l2jserver.gameserver.model.actor.instance.L2MerchantInstance;
import com.l2jserver.gameserver.model.actor.instance.L2NpcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2TeleporterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2TrainerInstance;
import com.l2jserver.gameserver.model.actor.instance.L2WarehouseInstance;
import com.l2jserver.gameserver.model.actor.knownlist.NpcKnownList;
import com.l2jserver.gameserver.model.actor.stat.NpcStat;
import com.l2jserver.gameserver.model.actor.status.NpcStatus;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.zone.type.L2TownZone;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.AbstractNpcInfo;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.ServerObjectInfo;
import com.l2jserver.gameserver.network.serverpackets.SocialAction;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.skills.Stats;
import com.l2jserver.gameserver.taskmanager.DecayTaskManager;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.templates.item.L2Item;
import com.l2jserver.gameserver.templates.item.L2Weapon;
import com.l2jserver.gameserver.util.Broadcast;
import com.l2jserver.util.Rnd;
import com.l2jserver.util.StringUtil;
import java.util.Collection;
import java.util.logging.Level;
import javolution.util.FastList;

public class L2Npc
extends L2Character {
    public static final int INTERACTION_DISTANCE = 150;
    private L2Spawn _spawn;
    private boolean _isBusy = false;
    private String _busyMessage = "";
    volatile boolean _isDecayed = false;
    private int _castleIndex = -2;
    private int _fortIndex = -2;
    public boolean isEventMob = false;
    private boolean _isInTown = false;
    private boolean _isAutoAttackable = false;
    private long _lastSocialBroadcast = 0L;
    private int _minimalSocialInterval = 6000;
    protected RandomAnimationTask _rAniTask = null;
    private int _currentLHandId;
    private int _currentRHandId;
    private int _currentEnchant;
    private double _currentCollisionHeight;
    private double _currentCollisionRadius;
    public boolean _soulshotcharged = false;
    public boolean _spiritshotcharged = false;
    private int _soulshotamount = 0;
    private int _spiritshotamount = 0;
    public boolean _ssrecharged = true;
    public boolean _spsrecharged = true;
    int _aggroMask = -1;

    public int getSoulShot() {
        L2NpcAIData AI = this.getTemplate().getAIDataStatic();
        return AI.getSoulShot();
    }

    public int getSpiritShot() {
        L2NpcAIData AI = this.getTemplate().getAIDataStatic();
        return AI.getSpiritShot();
    }

    public int getSoulShotChance() {
        L2NpcAIData AI = this.getTemplate().getAIDataStatic();
        return AI.getSoulShotChance();
    }

    public int getSpiritShotChance() {
        L2NpcAIData AI = this.getTemplate().getAIDataStatic();
        return AI.getSpiritShotChance();
    }

    public boolean useSoulShot() {
        if (this._soulshotcharged) {
            return true;
        }
        if (this._ssrecharged) {
            this._soulshotamount = this.getSoulShot();
            this._ssrecharged = false;
        } else if (this._soulshotamount > 0) {
            if (Rnd.get(100) <= this.getSoulShotChance()) {
                --this._soulshotamount;
                Broadcast.toSelfAndKnownPlayersInRadius(this, new MagicSkillUse(this, this, 2154, 1, 0, 0), 360000L);
                this._soulshotcharged = true;
            }
        } else {
            return false;
        }
        return this._soulshotcharged;
    }

    public boolean useSpiritShot() {
        if (this._spiritshotcharged) {
            return true;
        }
        if (this._spsrecharged) {
            this._spiritshotamount = this.getSpiritShot();
            this._spsrecharged = false;
        } else if (this._spiritshotamount > 0) {
            if (Rnd.get(100) <= this.getSpiritShotChance()) {
                --this._spiritshotamount;
                Broadcast.toSelfAndKnownPlayersInRadius(this, new MagicSkillUse(this, this, 2061, 1, 0, 0), 360000L);
                this._spiritshotcharged = true;
            }
        } else {
            return false;
        }
        return this._spiritshotcharged;
    }

    public int getEnemyRange() {
        L2NpcAIData AI = this.getTemplate().getAIDataStatic();
        return AI.getEnemyRange();
    }

    public String getEnemyClan() {
        L2NpcAIData AI = this.getTemplate().getAIDataStatic();
        return AI.getEnemyClan();
    }

    public int getClanRange() {
        L2NpcAIData AI = this.getTemplate().getAIDataStatic();
        return AI.getClanRange();
    }

    public String getClan() {
        L2NpcAIData AI = this.getTemplate().getAIDataStatic();
        return AI.getClan();
    }

    public int getPrimaryAttack() {
        L2NpcAIData AI = this.getTemplate().getAIDataStatic();
        return AI.getPrimaryAttack();
    }

    public int getSkillChance() {
        L2NpcAIData AI = this.getTemplate().getAIDataStatic();
        return AI.getSkillChance();
    }

    public int getCanMove() {
        L2NpcAIData AI = this.getTemplate().getAIDataStatic();
        return AI.getCanMove();
    }

    public int getIsChaos() {
        L2NpcAIData AI = this.getTemplate().getAIDataStatic();
        return AI.getIsChaos();
    }

    public int getCanDodge() {
        L2NpcAIData AI = this.getTemplate().getAIDataStatic();
        return AI.getDodge();
    }

    public int getSSkillChance() {
        L2NpcAIData AI = this.getTemplate().getAIDataStatic();
        return AI.getShortRangeChance();
    }

    public int getLSkillChance() {
        L2NpcAIData AI = this.getTemplate().getAIDataStatic();
        return AI.getLongRangeChance();
    }

    public int getSwitchRangeChance() {
        L2NpcAIData AI = this.getTemplate().getAIDataStatic();
        return AI.getSwitchRangeChance();
    }

    public boolean hasLSkill() {
        L2NpcAIData AI = this.getTemplate().getAIDataStatic();
        return AI.getLongRangeSkill() != 0;
    }

    public boolean hasSSkill() {
        L2NpcAIData AI = this.getTemplate().getAIDataStatic();
        return AI.getShortRangeSkill() != 0;
    }

    public FastList<L2Skill> getLrangeSkill() {
        FastList skilldata = new FastList();
        boolean hasLrange = false;
        L2NpcAIData AI = this.getTemplate().getAIDataStatic();
        if (AI == null || AI.getLongRangeSkill() == 0) {
            return null;
        }
        switch (AI.getLongRangeSkill()) {
            case -1: {
                L2Skill[] skills = null;
                skills = this.getAllSkills();
                if (skills == null) break;
                for (L2Skill sk : skills) {
                    if (sk == null || sk.isPassive() || sk.getTargetType() == L2Skill.SkillTargetType.TARGET_SELF || sk.getCastRange() < 200) continue;
                    skilldata.add((Object)sk);
                    hasLrange = true;
                }
                break;
            }
            case 1: {
                if (this.getTemplate()._universalskills == null) break;
                for (L2Skill sk : this.getTemplate()._universalskills) {
                    if (sk.getCastRange() < 200) continue;
                    skilldata.add((Object)sk);
                    hasLrange = true;
                }
                break;
            }
            default: {
                for (L2Skill sk : this.getAllSkills()) {
                    if (sk.getId() != AI.getLongRangeSkill()) continue;
                    skilldata.add((Object)sk);
                    hasLrange = true;
                }
            }
        }
        return hasLrange ? skilldata : null;
    }

    public FastList<L2Skill> getSrangeSkill() {
        FastList skilldata = new FastList();
        boolean hasSrange = false;
        L2NpcAIData AI = this.getTemplate().getAIDataStatic();
        if (AI == null || AI.getShortRangeSkill() == 0) {
            return null;
        }
        switch (AI.getShortRangeSkill()) {
            case -1: {
                L2Skill[] skills = null;
                skills = this.getAllSkills();
                if (skills == null) break;
                for (L2Skill sk : skills) {
                    if (sk == null || sk.isPassive() || sk.getTargetType() == L2Skill.SkillTargetType.TARGET_SELF || sk.getCastRange() > 200) continue;
                    skilldata.add((Object)sk);
                    hasSrange = true;
                }
                break;
            }
            case 1: {
                if (this.getTemplate()._universalskills == null) break;
                for (L2Skill sk : this.getTemplate()._universalskills) {
                    if (sk.getCastRange() > 200) continue;
                    skilldata.add((Object)sk);
                    hasSrange = true;
                }
                break;
            }
            default: {
                for (L2Skill sk : this.getAllSkills()) {
                    if (sk.getId() != AI.getShortRangeSkill()) continue;
                    skilldata.add((Object)sk);
                    hasSrange = true;
                }
            }
        }
        return hasSrange ? skilldata : null;
    }

    public void onRandomAnimation(int animationId) {
        long now = System.currentTimeMillis();
        if (now - this._lastSocialBroadcast > (long)this._minimalSocialInterval) {
            this._lastSocialBroadcast = now;
            this.broadcastPacket(new SocialAction(this.getObjectId(), animationId));
        }
    }

    public void startRandomAnimationTimer() {
        if (!this.hasRandomAnimation()) {
            return;
        }
        int minWait = this.isMob() ? Config.MIN_MONSTER_ANIMATION : Config.MIN_NPC_ANIMATION;
        int maxWait = this.isMob() ? Config.MAX_MONSTER_ANIMATION : Config.MAX_NPC_ANIMATION;
        int interval = Rnd.get(minWait, maxWait) * 1000;
        this._rAniTask = new RandomAnimationTask();
        ThreadPoolManager.getInstance().scheduleGeneral(this._rAniTask, interval);
    }

    public boolean hasRandomAnimation() {
        return Config.MAX_NPC_ANIMATION > 0 && !this.getAiType().equals((Object)L2NpcTemplate.AIType.CORPSE);
    }

    public L2Npc(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2Npc);
        this.initCharStatusUpdateValues();
        this._currentLHandId = this.getTemplate().lhand;
        this._currentRHandId = this.getTemplate().rhand;
        this._currentEnchant = Config.ENABLE_RANDOM_ENCHANT_EFFECT ? Rnd.get(4, 21) : this.getTemplate().enchantEffect;
        this._currentCollisionHeight = this.getTemplate().fCollisionHeight;
        this._currentCollisionRadius = this.getTemplate().fCollisionRadius;
        if (template == null) {
            _log.severe("No template for Npc. Please check your datapack is setup correctly.");
            return;
        }
        this.setName(template.name);
    }

    @Override
    public NpcKnownList getKnownList() {
        return (NpcKnownList)super.getKnownList();
    }

    @Override
    public void initKnownList() {
        this.setKnownList(new NpcKnownList(this));
    }

    @Override
    public NpcStat getStat() {
        return (NpcStat)super.getStat();
    }

    @Override
    public void initCharStat() {
        this.setStat(new NpcStat(this));
    }

    @Override
    public NpcStatus getStatus() {
        return (NpcStatus)super.getStatus();
    }

    @Override
    public void initCharStatus() {
        this.setStatus(new NpcStatus(this));
    }

    @Override
    public final L2NpcTemplate getTemplate() {
        return (L2NpcTemplate)super.getTemplate();
    }

    public int getNpcId() {
        return this.getTemplate().npcId;
    }

    @Override
    public boolean isAttackable() {
        return Config.ALT_ATTACKABLE_NPCS;
    }

    public final String getFactionId() {
        return this.getClan();
    }

    @Override
    public final int getLevel() {
        return this.getTemplate().level;
    }

    public boolean isAggressive() {
        return false;
    }

    public int getAggroRange() {
        return this.getTemplate().aggroRange & this._aggroMask;
    }

    public void aggroDisable() {
        this._aggroMask = 0;
    }

    public void setAggroEnable() {
        this._aggroMask = -1;
    }

    public void setAggroEnable(long delay) {
        ThreadPoolManager.getInstance().scheduleGeneral(new Runnable(){

            @Override
            public void run() {
                L2Npc.this._aggroMask = -1;
            }
        }, delay);
    }

    public int getFactionRange() {
        return this.getClanRange();
    }

    @Override
    public boolean isUndead() {
        return this.getTemplate().isUndead;
    }

    @Override
    public void updateAbnormalEffect() {
        Collection<L2PcInstance> plrs = this.getKnownList().getKnownPlayers().values();
        for (L2PcInstance player : plrs) {
            if (player == null) continue;
            if (this.getRunSpeed() == 0) {
                player.sendPacket(new ServerObjectInfo(this, player));
                continue;
            }
            player.sendPacket(new AbstractNpcInfo.NpcInfo(this, player));
        }
    }

    public int getDistanceToWatchObject(L2Object object) {
        if (object instanceof L2FestivalGuideInstance) {
            return 10000;
        }
        if (object instanceof L2NpcInstance || !(object instanceof L2Character)) {
            return 0;
        }
        if (object instanceof L2Playable) {
            return 1500;
        }
        return 500;
    }

    public int getDistanceToForgetObject(L2Object object) {
        return 2 * this.getDistanceToWatchObject(object);
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return this._isAutoAttackable;
    }

    public void setAutoAttackable(boolean flag) {
        this._isAutoAttackable = flag;
    }

    public int getLeftHandItem() {
        return this._currentLHandId;
    }

    public int getRightHandItem() {
        return this._currentRHandId;
    }

    public int getEnchantEffect() {
        return this._currentEnchant;
    }

    public final boolean isBusy() {
        return this._isBusy;
    }

    public void setBusy(boolean isBusy) {
        this._isBusy = isBusy;
    }

    public final String getBusyMessage() {
        return this._busyMessage;
    }

    public void setBusyMessage(String message) {
        this._busyMessage = message;
    }

    public boolean isWarehouse() {
        return false;
    }

    public boolean canTarget(L2PcInstance player) {
        if (player.isOutOfControl()) {
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (player.isLockedTarget() && player.getLockedTarget() != this) {
            player.sendPacket(new SystemMessage(SystemMessageId.FAILED_CHANGE_TARGET));
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        return true;
    }

    public boolean canInteract(L2PcInstance player) {
        if (player.isCastingNow() || player.isCastingSimultaneouslyNow()) {
            return false;
        }
        if (player.isDead() || player.isFakeDeath()) {
            return false;
        }
        if (player.isSitting()) {
            return false;
        }
        if (player.getPrivateStoreType() != 0) {
            return false;
        }
        if (!this.isInsideRadius(player, 150, true, false)) {
            return false;
        }
        return player.getInstanceId() == this.getInstanceId() || player.getInstanceId() == -1;
    }

    public final Castle getCastle() {
        if (this._castleIndex < 0) {
            L2TownZone town = TownManager.getTown(this.getX(), this.getY(), this.getZ());
            if (town != null) {
                this._castleIndex = CastleManager.getInstance().getCastleIndex(town.getTaxById());
            }
            if (this._castleIndex < 0) {
                this._castleIndex = CastleManager.getInstance().findNearestCastleIndex(this);
            } else {
                this._isInTown = true;
            }
        }
        if (this._castleIndex < 0) {
            return null;
        }
        return CastleManager.getInstance().getCastles().get(this._castleIndex);
    }

    public final Castle getCastle(long maxDistance) {
        int index = CastleManager.getInstance().findNearestCastleIndex(this, maxDistance);
        if (index < 0) {
            return null;
        }
        return CastleManager.getInstance().getCastles().get(index);
    }

    public final Fort getFort() {
        if (this._fortIndex < 0) {
            Fort fort = FortManager.getInstance().getFort(this.getX(), this.getY(), this.getZ());
            if (fort != null) {
                this._fortIndex = FortManager.getInstance().getFortIndex(fort.getFortId());
            }
            if (this._fortIndex < 0) {
                this._fortIndex = FortManager.getInstance().findNearestFortIndex(this);
            }
        }
        if (this._fortIndex < 0) {
            return null;
        }
        return FortManager.getInstance().getForts().get(this._fortIndex);
    }

    public final Fort getFort(long maxDistance) {
        int index = FortManager.getInstance().findNearestFortIndex(this, maxDistance);
        if (index < 0) {
            return null;
        }
        return FortManager.getInstance().getForts().get(index);
    }

    public final boolean getIsInTown() {
        if (this._castleIndex < 0) {
            this.getCastle();
        }
        return this._isInTown;
    }

    public void onBypassFeedback(L2PcInstance player, String command) {
        if (this.isBusy() && this.getBusyMessage().length() > 0) {
            player.sendPacket(ActionFailed.STATIC_PACKET);
            NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
            html.setFile(player.getHtmlPrefix(), "data/html/npcbusy.htm");
            html.replace((CharSequence)"%busymessage%", this.getBusyMessage());
            html.replace((CharSequence)"%npcname%", this.getName());
            html.replace((CharSequence)"%playername%", player.getName());
            player.sendPacket(html);
        } else {
            IBypassHandler handler = BypassHandler.getInstance().getBypassHandler(command);
            if (handler != null) {
                handler.useBypass(command, player, this);
            } else {
                _log.info(this.getClass().getSimpleName() + ": Unknown NPC bypass: \"" + command + "\" NpcId: " + this.getNpcId());
            }
        }
    }

    @Override
    public L2ItemInstance getActiveWeaponInstance() {
        return null;
    }

    @Override
    public L2Weapon getActiveWeaponItem() {
        int weaponId = this.getTemplate().rhand;
        if (weaponId < 1) {
            return null;
        }
        L2Item item = ItemTable.getInstance().getTemplate(this.getTemplate().rhand);
        if (!(item instanceof L2Weapon)) {
            return null;
        }
        return (L2Weapon)item;
    }

    @Override
    public L2ItemInstance getSecondaryWeaponInstance() {
        return null;
    }

    @Override
    public L2Weapon getSecondaryWeaponItem() {
        int weaponId = this.getTemplate().lhand;
        if (weaponId < 1) {
            return null;
        }
        L2Item item = ItemTable.getInstance().getTemplate(this.getTemplate().lhand);
        if (!(item instanceof L2Weapon)) {
            return null;
        }
        return (L2Weapon)item;
    }

    public void insertObjectIdAndShowChatWindow(L2PcInstance player, String content) {
        content = content.replaceAll("%objectId%", String.valueOf(this.getObjectId()));
        NpcHtmlMessage npcReply = new NpcHtmlMessage(this.getObjectId());
        npcReply.setHtml(content);
        player.sendPacket(npcReply);
    }

    public String getHtmlPath(String prefix, int npcId, int val) {
        StringBuilder pom = new StringBuilder(64).append(prefix);
        if (npcId != 0) {
            pom.append(npcId);
        }
        if (val != 0) {
            pom.append('-').append(val);
        }
        return pom.append(".htm").toString();
    }

    public String getHtmlPath(String prefix, int npcId, int val, String defaultPath) {
        String temp = this.getHtmlPath(prefix, npcId, val);
        if (HtmCache.getInstance().getHtm(null, temp) != null) {
            return temp;
        }
        if (defaultPath != null) {
            return defaultPath;
        }
        return "data/html/npcdefault.htm";
    }

    public String getHtmlPath(int npcId, int val) {
        return this.getHtmlPath("data/html/default/", npcId, val, null);
    }

    @Deprecated
    protected void TRACE(String message) {
        this.TRACE(this.getTitle() == null || this.getTitle().isEmpty() ? this.getName() : this.getTitle() + " " + this.getName(), message);
    }

    @Deprecated
    protected void TRACE(String title, String message) {
        debug.TRACE(title, message);
    }

    public void showChatWindow(L2PcInstance player) {
        this.showChatWindow(player, 0);
    }

    private boolean showPkDenyChatWindow(L2PcInstance player, String type) {
        String html = HtmCache.getInstance().getHtm(player.getHtmlPrefix(), "data/html/" + type + "/" + this.getNpcId() + "-pk.htm");
        if (html != null) {
            NpcHtmlMessage pkDenyMsg = new NpcHtmlMessage(this.getObjectId());
            pkDenyMsg.setHtml(html);
            player.sendPacket(pkDenyMsg);
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return true;
        }
        return false;
    }

    public void showChatWindow(L2PcInstance player, int val) {
        if (!(!player.isCursedWeaponEquipped() || player.getTarget() instanceof L2ClanHallManagerInstance && player.getTarget() instanceof L2DoormenInstance)) {
            player.setTarget(player);
            return;
        }
        if (player.getKarma() > 0 && (!Config.ALT_GAME_KARMA_PLAYER_CAN_SHOP && this instanceof L2MerchantInstance ? this.showPkDenyChatWindow(player, "merchant") : (!Config.ALT_GAME_KARMA_PLAYER_CAN_USE_GK && this instanceof L2TeleporterInstance ? this.showPkDenyChatWindow(player, "teleporter") : (!Config.ALT_GAME_KARMA_PLAYER_CAN_USE_WAREHOUSE && this instanceof L2WarehouseInstance ? this.showPkDenyChatWindow(player, "warehouse") : !Config.ALT_GAME_KARMA_PLAYER_CAN_SHOP && this instanceof L2FishermanInstance && this.showPkDenyChatWindow(player, "fisherman"))))) {
            return;
        }
        if ("L2Auctioneer".equals(this.getTemplate().type) && val == 0) {
            return;
        }
        int npcId = this.getTemplate().npcId;
        String filename = "data/html/seven_signs/";
        int sealAvariceOwner = SevenSigns.getInstance().getSealOwner(1);
        int sealGnosisOwner = SevenSigns.getInstance().getSealOwner(2);
        int playerCabal = SevenSigns.getInstance().getPlayerCabal(player.getObjectId());
        int compWinner = SevenSigns.getInstance().getCabalHighestScore();
        switch (npcId) {
            case 31127: 
            case 31128: 
            case 31129: 
            case 31130: 
            case 31131: {
                filename = filename + "festival/dawn_guide.htm";
                break;
            }
            case 31137: 
            case 31138: 
            case 31139: 
            case 31140: 
            case 31141: {
                filename = filename + "festival/dusk_guide.htm";
                break;
            }
            case 31092: {
                filename = filename + "blkmrkt_1.htm";
                break;
            }
            case 31113: {
                if (Config.ALT_STRICT_SEVENSIGNS) {
                    switch (compWinner) {
                        case 2: {
                            if (playerCabal == compWinner && playerCabal == sealAvariceOwner) break;
                            player.sendPacket(new SystemMessage(SystemMessageId.CAN_BE_USED_BY_DAWN));
                            player.sendPacket(ActionFailed.STATIC_PACKET);
                            return;
                        }
                        case 1: {
                            if (playerCabal == compWinner && playerCabal == sealAvariceOwner) break;
                            player.sendPacket(new SystemMessage(SystemMessageId.CAN_BE_USED_BY_DUSK));
                            player.sendPacket(ActionFailed.STATIC_PACKET);
                            return;
                        }
                        default: {
                            player.sendPacket(new SystemMessage(SystemMessageId.QUEST_EVENT_PERIOD));
                            return;
                        }
                    }
                }
                filename = filename + "mammmerch_1.htm";
                break;
            }
            case 31126: {
                if (Config.ALT_STRICT_SEVENSIGNS) {
                    switch (compWinner) {
                        case 2: {
                            if (playerCabal == compWinner && playerCabal == sealGnosisOwner) break;
                            player.sendPacket(new SystemMessage(SystemMessageId.CAN_BE_USED_BY_DAWN));
                            player.sendPacket(ActionFailed.STATIC_PACKET);
                            return;
                        }
                        case 1: {
                            if (playerCabal == compWinner && playerCabal == sealGnosisOwner) break;
                            player.sendPacket(new SystemMessage(SystemMessageId.CAN_BE_USED_BY_DUSK));
                            player.sendPacket(ActionFailed.STATIC_PACKET);
                            return;
                        }
                        default: {
                            player.sendPacket(new SystemMessage(SystemMessageId.QUEST_EVENT_PERIOD));
                            return;
                        }
                    }
                }
                filename = filename + "mammblack_1.htm";
                break;
            }
            case 31132: 
            case 31133: 
            case 31134: 
            case 31135: 
            case 31136: 
            case 31142: 
            case 31143: 
            case 31144: 
            case 31145: 
            case 31146: {
                filename = filename + "festival/festival_witch.htm";
                break;
            }
            case 31688: {
                if (player.isNoble()) {
                    filename = "data/html/olympiad/noble_main.htm";
                    break;
                }
                filename = this.getHtmlPath(npcId, val);
                break;
            }
            case 31690: 
            case 31769: 
            case 31770: 
            case 31771: 
            case 31772: {
                if (player.isHero() || player.isNoble()) {
                    filename = "data/html/olympiad/hero_main.htm";
                    break;
                }
                filename = this.getHtmlPath(npcId, val);
                break;
            }
            case 36402: {
                if (player.olyBuff > 0) {
                    filename = player.olyBuff == 5 ? "data/html/olympiad/olympiad_buffs.htm" : "data/html/olympiad/olympiad_5buffs.htm";
                    break;
                }
                filename = "data/html/olympiad/olympiad_nobuffs.htm";
                break;
            }
            default: {
                if (npcId >= 31865 && npcId <= 31918) {
                    if (val == 0) {
                        filename = filename + "rift/GuardianOfBorder.htm";
                        break;
                    }
                    filename = filename + "rift/GuardianOfBorder-" + val + ".htm";
                    break;
                }
                if (npcId >= 31093 && npcId <= 31094 || npcId >= 31172 && npcId <= 31201 || npcId >= 31239 && npcId <= 31254) {
                    return;
                }
                filename = this.getHtmlPath(npcId, val);
            }
        }
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        html.setFile(player.getHtmlPrefix(), filename);
        if (Config.ALLOW_RENTPET && this instanceof L2MerchantInstance && Config.LIST_PET_RENT_NPC.contains(npcId)) {
            html.replace((CharSequence)"_Quest", "_RentPet\">\u30da\u30c3\u30c8\u3092\u30ec\u30f3\u30bf\u30eb\u3059\u308b\u3002</a><br><a action=\"bypass -h npc_%objectId%_Quest");
        }
        html.replace((CharSequence)"%objectId%", this.getObjectId());
        html.replace((CharSequence)"%festivalMins%", SevenSignsFestival.getInstance().getTimeToNextFestivalStr());
        player.sendPacket(html);
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    public void showChatWindow(L2PcInstance player, String filename) {
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        html.setFile(player.getHtmlPrefix(), filename);
        html.replace((CharSequence)"%objectId%", this.getObjectId());
        player.sendPacket(html);
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    public int getExpReward() {
        double rateXp = this.getStat().calcStat(Stats.MAX_HP, 1.0, this, null);
        return (int)((double)this.getTemplate().rewardExp * rateXp * (double)Config.RATE_XP);
    }

    public int getSpReward() {
        double rateSp = this.getStat().calcStat(Stats.MAX_HP, 1.0, this, null);
        return (int)((double)this.getTemplate().rewardSp * rateSp * (double)Config.RATE_SP);
    }

    @Override
    public boolean doDie(L2Character killer) {
        if (!super.doDie(killer)) {
            return false;
        }
        this._currentLHandId = this.getTemplate().lhand;
        this._currentRHandId = this.getTemplate().rhand;
        this._currentCollisionHeight = this.getTemplate().fCollisionHeight;
        this._currentCollisionRadius = this.getTemplate().fCollisionRadius;
        DecayTaskManager.getInstance().addDecayTask(this);
        return true;
    }

    public void setSpawn(L2Spawn spawn) {
        this._spawn = spawn;
    }

    @Override
    public void onSpawn() {
        super.onSpawn();
        if (this.getTemplate().getEventQuests(Quest.QuestEventType.ON_SPAWN) != null) {
            for (Quest quest : this.getTemplate().getEventQuests(Quest.QuestEventType.ON_SPAWN)) {
                quest.notifySpawn(this);
            }
        }
    }

    @Override
    public void onDecay() {
        if (this.isDecayed()) {
            return;
        }
        this.setDecayed(true);
        super.onDecay();
        if (this._spawn != null) {
            this._spawn.decreaseCount(this);
        }
    }

    @Override
    public void deleteMe() {
        L2WorldRegion oldRegion = this.getWorldRegion();
        try {
            this.decayMe();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Failed decayMe().", e);
        }
        try {
            if (this._fusionSkill != null) {
                this.abortCast();
            }
            for (L2Character character : this.getKnownList().getKnownCharacters()) {
                if (character.getFusionSkill() == null || character.getFusionSkill().getTarget() != this) continue;
                character.abortCast();
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        if (oldRegion != null) {
            oldRegion.removeFromZones(this);
        }
        try {
            this.getKnownList().removeAllKnownObjects();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Failed removing cleaning knownlist.", e);
        }
        L2World.getInstance().removeObject(this);
        super.deleteMe();
    }

    public L2Spawn getSpawn() {
        return this._spawn;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.getTemplate().name + "(" + this.getNpcId() + ")" + "[" + this.getObjectId() + "]";
    }

    public boolean isDecayed() {
        return this._isDecayed;
    }

    public void setDecayed(boolean decayed) {
        this._isDecayed = decayed;
    }

    public void endDecayTask() {
        if (!this.isDecayed()) {
            DecayTaskManager.getInstance().cancelDecayTask(this);
            this.onDecay();
        }
    }

    public boolean isMob() {
        return false;
    }

    public void setLHandId(int newWeaponId) {
        this._currentLHandId = newWeaponId;
        this.updateAbnormalEffect();
    }

    public void setRHandId(int newWeaponId) {
        this._currentRHandId = newWeaponId;
        this.updateAbnormalEffect();
    }

    public void setLRHandId(int newLWeaponId, int newRWeaponId) {
        this._currentRHandId = newRWeaponId;
        this._currentLHandId = newLWeaponId;
        this.updateAbnormalEffect();
    }

    public void setEnchant(int newEnchantValue) {
        this._currentEnchant = newEnchantValue;
        this.updateAbnormalEffect();
    }

    public void setCollisionHeight(double height) {
        this._currentCollisionHeight = height;
    }

    public void setCollisionRadius(double radius) {
        this._currentCollisionRadius = radius;
    }

    public double getCollisionHeight() {
        return this._currentCollisionHeight;
    }

    public double getCollisionRadius() {
        return this._currentCollisionRadius;
    }

    @Override
    public void sendInfo(L2PcInstance activeChar) {
        if (Config.CHECK_KNOWN && activeChar.isGM()) {
            activeChar.sendMessage("Added NPC: " + this.getName());
        }
        if (this.getRunSpeed() == 0) {
            activeChar.sendPacket(new ServerObjectInfo(this, activeChar));
        } else {
            activeChar.sendPacket(new AbstractNpcInfo.NpcInfo(this, activeChar));
        }
    }

    public void showNoTeachHtml(L2PcInstance player) {
        int npcId = this.getNpcId();
        String html = "";
        if (this instanceof L2WarehouseInstance) {
            html = HtmCache.getInstance().getHtm(player.getHtmlPrefix(), "data/html/warehouse/" + npcId + "-noteach.htm");
        } else if (this instanceof L2TrainerInstance) {
            html = HtmCache.getInstance().getHtm(player.getHtmlPrefix(), "data/html/trainer/" + npcId + "-noteach.htm");
        }
        if (html == null) {
            _log.warning("Npc " + npcId + " missing noTeach html!");
            NpcHtmlMessage msg = new NpcHtmlMessage(this.getObjectId());
            String sb = StringUtil.concat("<html><body>I cannot teach you any skills.<br>You must find your current class teachers.", "</body></html>");
            msg.setHtml(sb);
            player.sendPacket(msg);
            return;
        }
        NpcHtmlMessage noTeachMsg = new NpcHtmlMessage(this.getObjectId());
        noTeachMsg.setHtml(html);
        noTeachMsg.replace((CharSequence)"%objectId%", this.getObjectId());
        player.sendPacket(noTeachMsg);
    }

    public L2Npc scheduleDespawn(long delay) {
        ThreadPoolManager.getInstance().scheduleGeneral(new DespawnTask(this), delay);
        return this;
    }

    @Override
    protected final void notifyQuestEventSkillFinished(L2Skill skill, L2Object target) {
        try {
            if (this.getTemplate().getEventQuests(Quest.QuestEventType.ON_SPELL_FINISHED) != null) {
                L2PcInstance player = target.getActingPlayer();
                for (Quest quest : this.getTemplate().getEventQuests(Quest.QuestEventType.ON_SPELL_FINISHED)) {
                    quest.notifySpellFinished(this, player, skill);
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "", e);
        }
    }

    @Override
    public boolean isMovementDisabled() {
        return super.isMovementDisabled() || this.getCanMove() > 0 || this.getAiType().equals((Object)L2NpcTemplate.AIType.CORPSE);
    }

    public L2NpcTemplate.AIType getAiType() {
        return this.getTemplate().getAIDataStatic().getAiType();
    }

    public class DespawnTask
    implements Runnable {
        L2Npc _npc;

        public DespawnTask(L2Npc npc) {
            this._npc = npc;
        }

        @Override
        public void run() {
            if (this._npc != null) {
                this._npc.deleteMe();
            }
        }
    }

    protected class RandomAnimationTask
    implements Runnable {
        protected RandomAnimationTask() {
        }

        @Override
        public void run() {
            try {
                if (this != L2Npc.this._rAniTask) {
                    return;
                }
                if (L2Npc.this.isMob() ? L2Npc.this.getAI().getIntention() != CtrlIntention.AI_INTENTION_ACTIVE : L2Npc.this.isInActiveRegion() == false) {
                    return;
                }
                if (!(L2Npc.this.isDead() || L2Npc.this.isStunned() || L2Npc.this.isSleeping() || L2Npc.this.isParalyzed())) {
                    L2Npc.this.onRandomAnimation(Rnd.get(2, 3));
                }
                L2Npc.this.startRandomAnimationTimer();
            }
            catch (Exception e) {
                L2Character._log.log(Level.SEVERE, "", e);
            }
        }
    }
}

