/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity;

import com.l2jserver.Config;
import com.l2jserver.gameserver.Announcements;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.DoorTable;
import com.l2jserver.gameserver.datatables.MapRegionTable;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.instancemanager.InstanceManager;
import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.L2WorldRegion;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestTimer;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.CreatureSay;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntProcedure;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javolution.util.FastList;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Instance {
    private static final Logger _log = Logger.getLogger(Instance.class.getName());
    private int _id;
    private String _name;
    private TIntHashSet _players = new TIntHashSet();
    private final EjectPlayerProcedure _ejectProc;
    private FastList<L2Npc> _npcs = new FastList().shared();
    private ArrayList<L2DoorInstance> _doors = null;
    private int[] _spawnLoc = new int[3];
    private boolean _allowSummon = true;
    private long _emptyDestroyTime = -1L;
    private long _lastLeft = -1L;
    private long _instanceEndTime = -1L;
    private boolean _isPvPInstance = false;
    protected ScheduledFuture<?> _CheckTimeUpTask = null;

    public Instance(int id) {
        this._id = id;
        this._ejectProc = new EjectPlayerProcedure();
    }

    public int getId() {
        return this._id;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public boolean isSummonAllowed() {
        return this._allowSummon;
    }

    public void setAllowSummon(boolean b) {
        this._allowSummon = b;
    }

    public boolean isPvPInstance() {
        return this._isPvPInstance;
    }

    public void setPvPInstance(boolean b) {
        this._isPvPInstance = b;
    }

    public void setDuration(int duration) {
        if (this._CheckTimeUpTask != null) {
            this._CheckTimeUpTask.cancel(true);
        }
        this._CheckTimeUpTask = ThreadPoolManager.getInstance().scheduleGeneral(new CheckTimeUp(duration), 500L);
        this._instanceEndTime = System.currentTimeMillis() + (long)duration + 500L;
    }

    public void setEmptyDestroyTime(long time) {
        this._emptyDestroyTime = time;
    }

    public boolean containsPlayer(int objectId) {
        return this._players.contains(objectId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlayer(int objectId) {
        TIntHashSet tIntHashSet = this._players;
        synchronized (tIntHashSet) {
            this._players.add(objectId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlayer(int objectId) {
        TIntHashSet tIntHashSet = this._players;
        synchronized (tIntHashSet) {
            this._players.remove(objectId);
        }
        if (this._players.isEmpty() && this._emptyDestroyTime >= 0L) {
            this._lastLeft = System.currentTimeMillis();
            this.setDuration((int)(this._instanceEndTime - System.currentTimeMillis() - 1000L));
        }
    }

    public void ejectPlayer(int objectId) {
        L2PcInstance player = L2World.getInstance().getPlayer(objectId);
        if (player != null && player.getInstanceId() == this.getId()) {
            player.setInstanceId(0);
            player.sendMessage("\u30a4\u30f3\u30b9\u30bf\u30f3\u30c8 \u30be\u30fc\u30f3\u304b\u3089\u9000\u5834\u3057\u307e\u3057\u305f\u3002");
            if (this.getSpawnLoc()[0] != 0 && this.getSpawnLoc()[1] != 0 && this.getSpawnLoc()[2] != 0) {
                player.teleToLocation(this.getSpawnLoc()[0], this.getSpawnLoc()[1], this.getSpawnLoc()[2]);
            } else {
                player.teleToLocation(MapRegionTable.TeleportWhereType.Town);
            }
        }
    }

    public void addNpc(L2Npc npc) {
        this._npcs.add((Object)npc);
    }

    public void removeNpc(L2Npc npc) {
        if (npc.getSpawn() != null) {
            npc.getSpawn().stopRespawn();
        }
        this._npcs.remove((Object)npc);
    }

    private void addDoor(int doorId, boolean open) {
        if (this._doors == null) {
            this._doors = new ArrayList(2);
        }
        for (L2DoorInstance door : this._doors) {
            if (door.getDoorId() != doorId) continue;
            _log.warning("Door ID " + doorId + " already exists in instance " + this.getId());
            return;
        }
        L2DoorInstance temp = DoorTable.getInstance().getDoor(doorId);
        L2DoorInstance newdoor = new L2DoorInstance(IdFactory.getInstance().getNextId(), temp.getTemplate(), temp.getDoorId(), temp.getName(), temp.isUnlockable());
        newdoor.setInstanceId(this.getId());
        newdoor.setRange(temp.getXMin(), temp.getYMin(), temp.getZMin(), temp.getXMax(), temp.getYMax(), temp.getZMax());
        try {
            newdoor.setMapRegion(MapRegionTable.getInstance().getMapRegion(temp.getX(), temp.getY()));
        }
        catch (Exception e) {
            _log.severe("Error in door data, ID:" + temp.getDoorId());
        }
        newdoor.getStatus().setCurrentHpMp(newdoor.getMaxHp(), newdoor.getMaxMp());
        newdoor.setOpen(open);
        newdoor.getPosition().setXYZInvisible(temp.getX(), temp.getY(), temp.getZ());
        newdoor.spawnMe(newdoor.getX(), newdoor.getY(), newdoor.getZ());
        this._doors.add(newdoor);
    }

    public TIntHashSet getPlayers() {
        return this._players;
    }

    public FastList<L2Npc> getNpcs() {
        return this._npcs;
    }

    public ArrayList<L2DoorInstance> getDoors() {
        return this._doors;
    }

    public L2DoorInstance getDoor(int id) {
        for (L2DoorInstance temp : this.getDoors()) {
            if (temp.getDoorId() != id) continue;
            return temp;
        }
        return null;
    }

    public int[] getSpawnLoc() {
        return this._spawnLoc;
    }

    public void setSpawnLoc(int[] loc) {
        if (loc == null || loc.length < 3) {
            return;
        }
        System.arraycopy(loc, 0, this._spawnLoc, 0, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlayers() {
        this._players.forEach((TIntProcedure)this._ejectProc);
        TIntHashSet tIntHashSet = this._players;
        synchronized (tIntHashSet) {
            this._players.clear();
        }
    }

    public void removeNpcs() {
        for (L2Npc mob : this._npcs) {
            if (mob == null) continue;
            if (mob.getSpawn() != null) {
                mob.getSpawn().stopRespawn();
            }
            mob.deleteMe();
        }
        this._npcs.clear();
    }

    public void removeDoors() {
        if (this._doors == null) {
            return;
        }
        for (L2DoorInstance door : this._doors) {
            if (door == null) continue;
            L2WorldRegion region = door.getWorldRegion();
            door.decayMe();
            if (region != null) {
                region.removeVisibleObject(door);
            }
            door.getKnownList().removeAllKnownObjects();
            L2World.getInstance().removeObject(door);
        }
        this._doors.clear();
        this._doors = null;
    }

    public void cancelQuestTimers() {
        int instanceId = this.getId();
        for (Quest quest : QuestManager.getInstance().getAllManagedScripts()) {
            if (quest == null) continue;
            for (FastList timers : quest.getAllQuestTimers().values()) {
                if (timers == null || timers.isEmpty()) continue;
                for (QuestTimer timer : (QuestTimer[])timers.toArray((Object[])new QuestTimer[timers.size()])) {
                    if (timer == null || timer.getInstanceId() != instanceId) continue;
                    timer.cancel();
                }
            }
        }
    }

    public void loadInstanceTemplate(String filename) throws FileNotFoundException {
        Document doc = null;
        File xml = new File(Config.DATAPACK_ROOT, "data/instances/" + filename);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setIgnoringComments(true);
            doc = factory.newDocumentBuilder().parse(xml);
            for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
                if (!"instance".equalsIgnoreCase(n.getNodeName())) continue;
                this.parseInstance(n);
            }
        }
        catch (IOException e) {
            _log.log(Level.WARNING, "Instance: can not find " + xml.getAbsolutePath() + " ! " + e.getMessage(), e);
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Instance: error while loading " + xml.getAbsolutePath() + " ! " + e.getMessage(), e);
        }
    }

    private void parseInstance(Node n) throws Exception {
        Node first;
        String name = null;
        name = n.getAttributes().getNamedItem("name").getNodeValue();
        this.setName(name);
        for (n = first = n.getFirstChild(); n != null; n = n.getNextSibling()) {
            Node d;
            Node a;
            if ("activityTime".equalsIgnoreCase(n.getNodeName())) {
                a = n.getAttributes().getNamedItem("val");
                if (a == null) continue;
                this._CheckTimeUpTask = ThreadPoolManager.getInstance().scheduleGeneral(new CheckTimeUp(Integer.parseInt(a.getNodeValue()) * 60000), 15000L);
                this._instanceEndTime = System.currentTimeMillis() + Long.parseLong(a.getNodeValue()) * 60000L + 15000L;
                continue;
            }
            if ("allowSummon".equalsIgnoreCase(n.getNodeName())) {
                a = n.getAttributes().getNamedItem("val");
                if (a == null) continue;
                this.setAllowSummon(Boolean.parseBoolean(a.getNodeValue()));
                continue;
            }
            if ("emptyDestroyTime".equalsIgnoreCase(n.getNodeName())) {
                a = n.getAttributes().getNamedItem("val");
                if (a == null) continue;
                this._emptyDestroyTime = Long.parseLong(a.getNodeValue()) * 1000L;
                continue;
            }
            if ("PvPInstance".equalsIgnoreCase(n.getNodeName())) {
                a = n.getAttributes().getNamedItem("val");
                if (a == null) continue;
                this.setPvPInstance(Boolean.parseBoolean(a.getNodeValue()));
                continue;
            }
            if ("doorlist".equalsIgnoreCase(n.getNodeName())) {
                for (d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                    int doorId = 0;
                    boolean doorState = false;
                    if (!"door".equalsIgnoreCase(d.getNodeName())) continue;
                    doorId = Integer.parseInt(d.getAttributes().getNamedItem("doorId").getNodeValue());
                    if (d.getAttributes().getNamedItem("open") != null) {
                        doorState = Boolean.parseBoolean(d.getAttributes().getNamedItem("open").getNodeValue());
                    }
                    this.addDoor(doorId, doorState);
                }
                continue;
            }
            if ("spawnlist".equalsIgnoreCase(n.getNodeName())) {
                for (d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                    L2NpcTemplate npcTemplate;
                    int npcId = 0;
                    int x = 0;
                    int y = 0;
                    int z = 0;
                    int respawn = 0;
                    int heading = 0;
                    int delay = -1;
                    if (!"spawn".equalsIgnoreCase(d.getNodeName())) continue;
                    npcId = Integer.parseInt(d.getAttributes().getNamedItem("npcId").getNodeValue());
                    x = Integer.parseInt(d.getAttributes().getNamedItem("x").getNodeValue());
                    y = Integer.parseInt(d.getAttributes().getNamedItem("y").getNodeValue());
                    z = Integer.parseInt(d.getAttributes().getNamedItem("z").getNodeValue());
                    heading = Integer.parseInt(d.getAttributes().getNamedItem("heading").getNodeValue());
                    respawn = Integer.parseInt(d.getAttributes().getNamedItem("respawn").getNodeValue());
                    if (d.getAttributes().getNamedItem("onKillDelay") != null) {
                        delay = Integer.parseInt(d.getAttributes().getNamedItem("onKillDelay").getNodeValue());
                    }
                    if ((npcTemplate = NpcTable.getInstance().getTemplate(npcId)) != null) {
                        L2Spawn spawnDat = new L2Spawn(npcTemplate);
                        spawnDat.setLocx(x);
                        spawnDat.setLocy(y);
                        spawnDat.setLocz(z);
                        spawnDat.setAmount(1);
                        spawnDat.setHeading(heading);
                        spawnDat.setRespawnDelay(respawn);
                        if (respawn == 0) {
                            spawnDat.stopRespawn();
                        } else {
                            spawnDat.startRespawn();
                        }
                        spawnDat.setInstanceId(this.getId());
                        L2Npc spawned = spawnDat.doSpawn();
                        if (delay < 0 || !(spawned instanceof L2Attackable)) continue;
                        ((L2Attackable)spawned).setOnKillDelay(delay);
                        continue;
                    }
                    _log.warning("Instance: Data missing in NPC table for ID: " + npcId + " in Instance " + this.getId());
                }
                continue;
            }
            if ("spawnpoint".equalsIgnoreCase(n.getNodeName())) {
                try {
                    this._spawnLoc[0] = Integer.parseInt(n.getAttributes().getNamedItem("spawnX").getNodeValue());
                    this._spawnLoc[1] = Integer.parseInt(n.getAttributes().getNamedItem("spawnY").getNodeValue());
                    this._spawnLoc[2] = Integer.parseInt(n.getAttributes().getNamedItem("spawnZ").getNodeValue());
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, "Error parsing instance xml: " + e.getMessage(), e);
                    this._spawnLoc = new int[3];
                }
                continue;
            }
            if (!"returnteleport".equalsIgnoreCase(n.getNodeName())) continue;
            try {
                this._spawnLoc[0] = Integer.parseInt(n.getAttributes().getNamedItem("x").getNodeValue());
                this._spawnLoc[1] = Integer.parseInt(n.getAttributes().getNamedItem("y").getNodeValue());
                this._spawnLoc[2] = Integer.parseInt(n.getAttributes().getNamedItem("z").getNodeValue());
                continue;
            }
            catch (Exception e) {
                _log.warning("Error parsing instance xml: " + e);
                this._spawnLoc = new int[3];
            }
        }
        if (Config.DEBUG) {
            _log.info(name + " Instance Template for Instance " + this.getId() + " loaded");
        }
    }

    protected void doCheckTimeUp(int remaining) {
        int interval;
        CreatureSay cs = null;
        if (this._players.isEmpty() && this._emptyDestroyTime == 0L) {
            remaining = 0;
            interval = 500;
        } else if (this._players.isEmpty() && this._emptyDestroyTime > 0L) {
            Long emptyTimeLeft = this._lastLeft + this._emptyDestroyTime - System.currentTimeMillis();
            if (emptyTimeLeft <= 0L) {
                interval = 0;
                remaining = 0;
            } else if (remaining > 300000 && emptyTimeLeft > 300000L) {
                interval = 300000;
                remaining -= 300000;
            } else if (remaining > 60000 && emptyTimeLeft > 60000L) {
                interval = 60000;
                remaining -= 60000;
            } else if (remaining > 30000 && emptyTimeLeft > 30000L) {
                interval = 30000;
                remaining -= 30000;
            } else {
                interval = 10000;
                remaining -= 10000;
            }
        } else if (remaining > 300000) {
            int timeLeft = remaining / 60000;
            interval = 300000;
            SystemMessage sm = new SystemMessage(SystemMessageId.DUNGEON_EXPIRES_IN_S1_MINUTES);
            sm.addString(Integer.toString(timeLeft));
            Announcements.getInstance().announceToInstance(sm, this.getId());
            remaining -= 300000;
        } else if (remaining > 60000) {
            int timeLeft = remaining / 60000;
            interval = 60000;
            SystemMessage sm = new SystemMessage(SystemMessageId.DUNGEON_EXPIRES_IN_S1_MINUTES);
            sm.addString(Integer.toString(timeLeft));
            Announcements.getInstance().announceToInstance(sm, this.getId());
            remaining -= 60000;
        } else if (remaining > 30000) {
            int timeLeft = remaining / 1000;
            interval = 30000;
            cs = new CreatureSay(0, 9, "\u30c0\u30f3\u30b8\u30e7\u30f3 \u7d42\u4e86", timeLeft + "\u79d2");
            remaining -= 30000;
        } else {
            int timeLeft = remaining / 1000;
            interval = 10000;
            cs = new CreatureSay(0, 9, "\u30c0\u30f3\u30b8\u30e7\u30f3 \u7d42\u4e86", timeLeft + "\u79d2");
            remaining -= 10000;
        }
        if (cs != null) {
            this._players.forEach((TIntProcedure)new SendPacketToPlayerProcedure(cs));
        }
        this.cancelTimer();
        this._CheckTimeUpTask = remaining >= 10000 ? ThreadPoolManager.getInstance().scheduleGeneral(new CheckTimeUp(remaining), interval) : ThreadPoolManager.getInstance().scheduleGeneral(new TimeUp(), interval);
    }

    public void cancelTimer() {
        if (this._CheckTimeUpTask != null) {
            this._CheckTimeUpTask.cancel(true);
        }
    }

    private final class SendPacketToPlayerProcedure
    implements TIntProcedure {
        private final L2GameServerPacket _packet;

        SendPacketToPlayerProcedure(L2GameServerPacket packet) {
            this._packet = packet;
        }

        public final boolean execute(int objId) {
            L2PcInstance player = L2World.getInstance().getPlayer(objId);
            if (player.getInstanceId() == Instance.this.getId()) {
                player.sendPacket(this._packet);
            }
            return true;
        }
    }

    private final class EjectPlayerProcedure
    implements TIntProcedure {
        EjectPlayerProcedure() {
        }

        public final boolean execute(int objId) {
            Instance.this.ejectPlayer(objId);
            return true;
        }
    }

    public class TimeUp
    implements Runnable {
        @Override
        public void run() {
            InstanceManager.getInstance().destroyInstance(Instance.this.getId());
        }
    }

    public class CheckTimeUp
    implements Runnable {
        private int _remaining;

        public CheckTimeUp(int remaining) {
            this._remaining = remaining;
        }

        @Override
        public void run() {
            Instance.this.doCheckTimeUp(this._remaining);
        }
    }
}

